#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 4536
#define LARGE_STATE_COUNT 775
#define SYMBOL_COUNT 670
#define ALIAS_COUNT 0
#define TOKEN_COUNT 386
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 42
#define MAX_ALIAS_SEQUENCE_LENGTH 16
#define PRODUCTION_ID_COUNT 190

enum {
  sym__identifier = 1,
  anon_sym_SEMI = 2,
  sym_keyword_select = 3,
  sym_keyword_delete = 4,
  sym_keyword_insert = 5,
  sym_keyword_replace = 6,
  sym_keyword_update = 7,
  sym_keyword_truncate = 8,
  sym_keyword_merge = 9,
  sym_keyword_into = 10,
  sym_keyword_overwrite = 11,
  sym_keyword_values = 12,
  sym_keyword_value = 13,
  sym_keyword_matched = 14,
  sym_keyword_set = 15,
  sym_keyword_from = 16,
  sym_keyword_left = 17,
  sym_keyword_right = 18,
  sym_keyword_inner = 19,
  sym_keyword_full = 20,
  sym_keyword_outer = 21,
  sym_keyword_cross = 22,
  sym_keyword_join = 23,
  sym_keyword_lateral = 24,
  sym_keyword_natural = 25,
  sym_keyword_on = 26,
  sym_keyword_where = 27,
  sym_keyword_order = 28,
  sym_keyword_group = 29,
  sym_keyword_partition = 30,
  sym_keyword_by = 31,
  sym_keyword_having = 32,
  sym_keyword_desc = 33,
  sym_keyword_asc = 34,
  sym_keyword_limit = 35,
  sym_keyword_offset = 36,
  sym_keyword_primary = 37,
  sym_keyword_create = 38,
  sym_keyword_alter = 39,
  sym_keyword_change = 40,
  sym_keyword_analyze = 41,
  sym_keyword_explain = 42,
  sym_keyword_verbose = 43,
  sym_keyword_modify = 44,
  sym_keyword_drop = 45,
  sym_keyword_add = 46,
  sym_keyword_table = 47,
  sym_keyword_tables = 48,
  sym_keyword_view = 49,
  sym_keyword_column = 50,
  sym_keyword_columns = 51,
  sym_keyword_materialized = 52,
  sym_keyword_tablespace = 53,
  sym_keyword_sequence = 54,
  sym_keyword_increment = 55,
  sym_keyword_minvalue = 56,
  sym_keyword_maxvalue = 57,
  sym_keyword_none = 58,
  sym_keyword_owned = 59,
  sym_keyword_start = 60,
  sym_keyword_restart = 61,
  sym_keyword_key = 62,
  sym_keyword_as = 63,
  sym_keyword_distinct = 64,
  sym_keyword_constraint = 65,
  sym_keyword_filter = 66,
  sym_keyword_cast = 67,
  sym_keyword_separator = 68,
  sym_keyword_max = 69,
  sym_keyword_min = 70,
  sym_keyword_avg = 71,
  sym_keyword_case = 72,
  sym_keyword_when = 73,
  sym_keyword_then = 74,
  sym_keyword_else = 75,
  sym_keyword_end = 76,
  sym_keyword_in = 77,
  sym_keyword_and = 78,
  sym_keyword_or = 79,
  sym_keyword_is = 80,
  sym_keyword_not = 81,
  sym_keyword_force = 82,
  sym_keyword_ignore = 83,
  sym_keyword_using = 84,
  sym_keyword_use = 85,
  sym_keyword_index = 86,
  sym_keyword_for = 87,
  sym_keyword_if = 88,
  sym_keyword_exists = 89,
  sym_keyword_auto_increment = 90,
  sym_keyword_generated = 91,
  sym_keyword_always = 92,
  sym_keyword_collate = 93,
  aux_sym_keyword_character_token1 = 94,
  sym_keyword_engine = 95,
  sym_keyword_default = 96,
  sym_keyword_cascade = 97,
  sym_keyword_restrict = 98,
  aux_sym_keyword_with_token1 = 99,
  sym_keyword_no = 100,
  sym_keyword_data = 101,
  sym_keyword_type = 102,
  sym_keyword_rename = 103,
  sym_keyword_to = 104,
  sym_keyword_database = 105,
  sym_keyword_schema = 106,
  sym_keyword_owner = 107,
  sym_keyword_user = 108,
  sym_keyword_admin = 109,
  sym_keyword_password = 110,
  sym_keyword_encrypted = 111,
  sym_keyword_valid = 112,
  sym_keyword_until = 113,
  sym_keyword_connection = 114,
  sym_keyword_role = 115,
  sym_keyword_reset = 116,
  sym_keyword_temp = 117,
  sym_keyword_temporary = 118,
  sym_keyword_unlogged = 119,
  sym_keyword_logged = 120,
  sym_keyword_cycle = 121,
  sym_keyword_union = 122,
  sym_keyword_all = 123,
  sym_keyword_any = 124,
  sym_keyword_some = 125,
  sym_keyword_except = 126,
  sym_keyword_intersect = 127,
  sym_keyword_returning = 128,
  sym_keyword_begin = 129,
  sym_keyword_commit = 130,
  sym_keyword_rollback = 131,
  sym_keyword_transaction = 132,
  sym_keyword_over = 133,
  sym_keyword_nulls = 134,
  sym_keyword_first = 135,
  sym_keyword_after = 136,
  sym_keyword_before = 137,
  sym_keyword_last = 138,
  sym_keyword_window = 139,
  sym_keyword_range = 140,
  sym_keyword_rows = 141,
  sym_keyword_groups = 142,
  sym_keyword_between = 143,
  sym_keyword_unbounded = 144,
  sym_keyword_preceding = 145,
  sym_keyword_following = 146,
  sym_keyword_exclude = 147,
  sym_keyword_current = 148,
  sym_keyword_row = 149,
  sym_keyword_ties = 150,
  sym_keyword_others = 151,
  sym_keyword_only = 152,
  sym_keyword_unique = 153,
  sym_keyword_foreign = 154,
  sym_keyword_references = 155,
  sym_keyword_concurrently = 156,
  sym_keyword_btree = 157,
  sym_keyword_hash = 158,
  sym_keyword_gist = 159,
  sym_keyword_spgist = 160,
  sym_keyword_gin = 161,
  sym_keyword_brin = 162,
  aux_sym_keyword_like_token1 = 163,
  aux_sym_keyword_like_token2 = 164,
  sym_keyword_similar = 165,
  sym_keyword_preserve = 166,
  sym_keyword_unsigned = 167,
  sym_keyword_zerofill = 168,
  sym_keyword_conflict = 169,
  sym_keyword_do = 170,
  sym_keyword_nothing = 171,
  sym_keyword_high_priority = 172,
  sym_keyword_low_priority = 173,
  sym_keyword_delayed = 174,
  sym_keyword_recursive = 175,
  sym_keyword_cascaded = 176,
  sym_keyword_local = 177,
  sym_keyword_current_timestamp = 178,
  sym_keyword_check = 179,
  sym_keyword_option = 180,
  sym_keyword_vacuum = 181,
  sym_keyword_wait = 182,
  sym_keyword_nowait = 183,
  sym_keyword_attribute = 184,
  sym_keyword_authorization = 185,
  sym_keyword_action = 186,
  sym_keyword_trigger = 187,
  sym_keyword_function = 188,
  sym_keyword_returns = 189,
  sym_keyword_return = 190,
  sym_keyword_setof = 191,
  sym_keyword_atomic = 192,
  sym_keyword_declare = 193,
  sym_keyword_language = 194,
  sym_keyword_sql = 195,
  sym_keyword_plpgsql = 196,
  sym_keyword_immutable = 197,
  sym_keyword_stable = 198,
  sym_keyword_volatile = 199,
  sym_keyword_leakproof = 200,
  sym_keyword_parallel = 201,
  sym_keyword_safe = 202,
  sym_keyword_unsafe = 203,
  sym_keyword_restricted = 204,
  sym_keyword_called = 205,
  sym_keyword_input = 206,
  sym_keyword_strict = 207,
  sym_keyword_cost = 208,
  sym_keyword_support = 209,
  sym_keyword_external = 210,
  sym_keyword_stored = 211,
  sym_keyword_virtual = 212,
  sym_keyword_cached = 213,
  sym_keyword_uncached = 214,
  sym_keyword_replication = 215,
  sym_keyword_tblproperties = 216,
  sym_keyword_options = 217,
  sym_keyword_compute = 218,
  sym_keyword_stats = 219,
  sym_keyword_statistics = 220,
  sym_keyword_optimize = 221,
  sym_keyword_rewrite = 222,
  sym_keyword_bin_pack = 223,
  sym_keyword_incremental = 224,
  sym_keyword_location = 225,
  sym_keyword_partitioned = 226,
  sym_keyword_comment = 227,
  sym_keyword_sort = 228,
  sym_keyword_format = 229,
  sym_keyword_delimited = 230,
  sym_keyword_fields = 231,
  sym_keyword_terminated = 232,
  sym_keyword_escaped = 233,
  sym_keyword_lines = 234,
  sym_keyword_cache = 235,
  sym_keyword_metadata = 236,
  sym_keyword_noscan = 237,
  sym_keyword_parquet = 238,
  sym_keyword_rcfile = 239,
  sym_keyword_csv = 240,
  sym_keyword_textfile = 241,
  sym_keyword_avro = 242,
  sym_keyword_sequencefile = 243,
  sym_keyword_orc = 244,
  sym_keyword_jsonfile = 245,
  sym_keyword_null = 246,
  sym_keyword_true = 247,
  sym_keyword_false = 248,
  sym_keyword_boolean = 249,
  sym_keyword_bit = 250,
  sym_keyword_binary = 251,
  sym_keyword_varbinary = 252,
  sym_keyword_image = 253,
  aux_sym_keyword_smallserial_token1 = 254,
  aux_sym_keyword_smallserial_token2 = 255,
  aux_sym_keyword_serial_token1 = 256,
  aux_sym_keyword_serial_token2 = 257,
  aux_sym_keyword_bigserial_token1 = 258,
  aux_sym_keyword_bigserial_token2 = 259,
  aux_sym_keyword_tinyint_token1 = 260,
  aux_sym_keyword_tinyint_token2 = 261,
  aux_sym_keyword_smallint_token1 = 262,
  aux_sym_keyword_smallint_token2 = 263,
  aux_sym_keyword_mediumint_token1 = 264,
  aux_sym_keyword_mediumint_token2 = 265,
  aux_sym_keyword_int_token1 = 266,
  aux_sym_keyword_int_token2 = 267,
  aux_sym_keyword_int_token3 = 268,
  aux_sym_keyword_bigint_token1 = 269,
  aux_sym_keyword_bigint_token2 = 270,
  sym_keyword_decimal = 271,
  sym_keyword_numeric = 272,
  aux_sym_keyword_real_token1 = 273,
  aux_sym_keyword_real_token2 = 274,
  sym_keyword_float = 275,
  sym_keyword_double = 276,
  sym_keyword_precision = 277,
  sym_keyword_inet = 278,
  sym_keyword_money = 279,
  sym_keyword_smallmoney = 280,
  sym_keyword_varying = 281,
  aux_sym_keyword_char_token1 = 282,
  sym_keyword_nchar = 283,
  aux_sym_keyword_varchar_token1 = 284,
  sym_keyword_nvarchar = 285,
  sym_keyword_text = 286,
  sym_keyword_string = 287,
  sym_keyword_uuid = 288,
  sym_keyword_json = 289,
  sym_keyword_jsonb = 290,
  sym_keyword_xml = 291,
  sym_keyword_bytea = 292,
  sym_keyword_enum = 293,
  sym_keyword_date = 294,
  sym_keyword_datetime = 295,
  sym_keyword_datetime2 = 296,
  sym_keyword_smalldatetime = 297,
  sym_keyword_datetimeoffset = 298,
  aux_sym_keyword_time_token1 = 299,
  aux_sym_keyword_timestamp_token1 = 300,
  aux_sym_keyword_timestamp_token2 = 301,
  aux_sym_keyword_timestamp_token3 = 302,
  aux_sym_keyword_timestamptz_token1 = 303,
  sym_keyword_interval = 304,
  sym_keyword_geometry = 305,
  sym_keyword_geography = 306,
  sym_keyword_box2d = 307,
  sym_keyword_box3d = 308,
  sym_keyword_oid = 309,
  sym_keyword_name = 310,
  sym_keyword_regclass = 311,
  sym_keyword_regnamespace = 312,
  sym_keyword_regproc = 313,
  sym_keyword_regtype = 314,
  sym_keyword_array = 315,
  anon_sym_LBRACK = 316,
  anon_sym_RBRACK = 317,
  anon_sym_LPAREN = 318,
  anon_sym_RPAREN = 319,
  anon_sym_COMMA = 320,
  aux_sym_double_token1 = 321,
  anon_sym_DASH_DASH = 322,
  aux_sym_comment_token1 = 323,
  anon_sym_SLASH_STAR = 324,
  aux_sym_marginalia_token1 = 325,
  anon_sym_SLASH = 326,
  anon_sym_DOLLAR_DOLLAR = 327,
  anon_sym_DOLLARfunction_DOLLAR = 328,
  anon_sym_DOLLARbody_DOLLAR = 329,
  anon_sym_COLON_EQ = 330,
  anon_sym_EQ = 331,
  anon_sym_DOT = 332,
  anon_sym_STAR = 333,
  anon_sym_QMARK = 334,
  anon_sym_DOLLAR = 335,
  aux_sym_parameter_token1 = 336,
  anon_sym_COLON_COLON = 337,
  anon_sym_millennium = 338,
  anon_sym_century = 339,
  anon_sym_decade = 340,
  anon_sym_year = 341,
  anon_sym_month = 342,
  anon_sym_week = 343,
  anon_sym_day = 344,
  anon_sym_hour = 345,
  anon_sym_minute = 346,
  anon_sym_second = 347,
  anon_sym_millisecond = 348,
  anon_sym_microsecond = 349,
  anon_sym_y = 350,
  anon_sym_m = 351,
  anon_sym_d = 352,
  anon_sym_H = 353,
  anon_sym_M = 354,
  anon_sym_S = 355,
  anon_sym_years = 356,
  anon_sym_months = 357,
  anon_sym_weeks = 358,
  anon_sym_days = 359,
  anon_sym_hours = 360,
  anon_sym_minutes = 361,
  anon_sym_seconds = 362,
  anon_sym_ago = 363,
  anon_sym_SQUOTE = 364,
  anon_sym_LT = 365,
  anon_sym_GT = 366,
  anon_sym_LT_EQ = 367,
  anon_sym_GT_EQ = 368,
  anon_sym_PLUS = 369,
  anon_sym_DASH = 370,
  anon_sym_PERCENT = 371,
  anon_sym_CARET = 372,
  anon_sym_PIPE_PIPE = 373,
  anon_sym_BANG_EQ = 374,
  anon_sym_LT_GT = 375,
  anon_sym_DASH_GT = 376,
  anon_sym_DASH_GT_GT = 377,
  anon_sym_POUND_GT = 378,
  anon_sym_POUND_GT_GT = 379,
  anon_sym_DQUOTE = 380,
  aux_sym__double_quote_string_token1 = 381,
  aux_sym__single_quote_string_token1 = 382,
  sym__natural_number = 383,
  sym_bang = 384,
  anon_sym_BQUOTE = 385,
  sym_program = 386,
  sym_keyword_character = 387,
  sym_keyword_with = 388,
  sym_keyword_like = 389,
  sym_is_not = 390,
  sym_not_like = 391,
  sym_similar_to = 392,
  sym_not_similar_to = 393,
  sym_distinct_from = 394,
  sym_not_distinct_from = 395,
  sym__temporary = 396,
  sym__not_null = 397,
  sym__primary_key = 398,
  sym__if_exists = 399,
  sym__if_not_exists = 400,
  sym__or_replace = 401,
  sym__current_row = 402,
  sym__exclude_current_row = 403,
  sym__exclude_group = 404,
  sym__exclude_no_others = 405,
  sym__exclude_ties = 406,
  sym__check_option = 407,
  sym_direction = 408,
  sym_keyword_smallserial = 409,
  sym_keyword_serial = 410,
  sym_keyword_bigserial = 411,
  sym_keyword_tinyint = 412,
  sym_keyword_smallint = 413,
  sym_keyword_mediumint = 414,
  sym_keyword_int = 415,
  sym_keyword_bigint = 416,
  sym_keyword_real = 417,
  sym_keyword_char = 418,
  sym_keyword_varchar = 419,
  sym_keyword_time = 420,
  sym_keyword_timestamp = 421,
  sym_keyword_timestamptz = 422,
  sym__type = 423,
  sym_array_size_definition = 424,
  sym__array_size_definition = 425,
  sym_tinyint = 426,
  sym_smallint = 427,
  sym_mediumint = 428,
  sym_int = 429,
  sym_bigint = 430,
  sym_bit = 431,
  sym_binary = 432,
  sym_varbinary = 433,
  sym_float = 434,
  sym_double = 435,
  sym_decimal = 436,
  sym_numeric = 437,
  sym_char = 438,
  sym_varchar = 439,
  sym_nchar = 440,
  sym_nvarchar = 441,
  sym_datetimeoffset = 442,
  sym_time = 443,
  sym_enum = 444,
  sym_array = 445,
  sym_comment = 446,
  sym_marginalia = 447,
  sym_transaction = 448,
  sym__commit = 449,
  sym__rollback = 450,
  sym_block = 451,
  sym_statement = 452,
  sym__ddl_statement = 453,
  sym__cte = 454,
  sym__dml_write = 455,
  sym__dml_read = 456,
  sym_cte = 457,
  sym_set_operation = 458,
  sym__select_statement = 459,
  sym_comment_statement = 460,
  sym__comment_target = 461,
  sym_select = 462,
  sym_select_expression = 463,
  sym_term = 464,
  sym__truncate_statement = 465,
  sym__delete_statement = 466,
  sym__delete_from = 467,
  sym_delete = 468,
  sym__create_statement = 469,
  sym__table_settings = 470,
  sym_create_table = 471,
  sym_create_query = 472,
  sym_create_view = 473,
  sym_create_materialized_view = 474,
  sym_dollar_quote = 475,
  sym_create_function = 476,
  sym__function_return = 477,
  sym_function_declaration = 478,
  sym__function_body_statement = 479,
  sym_function_body = 480,
  sym_function_language = 481,
  sym_function_volatility = 482,
  sym_function_leakproof = 483,
  sym_function_safety = 484,
  sym_function_strictness = 485,
  sym_function_cost = 486,
  sym_function_rows = 487,
  sym_function_support = 488,
  sym_create_index = 489,
  sym_create_schema = 490,
  sym__with_settings = 491,
  sym_create_database = 492,
  sym_create_role = 493,
  sym__role_options = 494,
  sym__user_access_role_config = 495,
  sym_create_sequence = 496,
  sym_create_type = 497,
  sym_enum_elements = 498,
  sym__alter_statement = 499,
  sym__rename_statement = 500,
  sym__rename_table_names = 501,
  sym_alter_table = 502,
  sym__alter_specifications = 503,
  sym_add_column = 504,
  sym_add_constraint = 505,
  sym_alter_column = 506,
  sym_modify_column = 507,
  sym_change_column = 508,
  sym_column_position = 509,
  sym_drop_column = 510,
  sym_rename_column = 511,
  sym_alter_view = 512,
  sym_alter_schema = 513,
  sym_alter_database = 514,
  sym_alter_role = 515,
  sym_set_configuration = 516,
  sym_alter_index = 517,
  sym_alter_sequence = 518,
  sym_alter_type = 519,
  sym__drop_behavior = 520,
  sym__drop_statement = 521,
  sym_drop_table = 522,
  sym_drop_view = 523,
  sym_drop_schema = 524,
  sym_drop_database = 525,
  sym_drop_role = 526,
  sym_drop_type = 527,
  sym_drop_sequence = 528,
  sym_drop_index = 529,
  sym_rename_object = 530,
  sym_set_schema = 531,
  sym_change_ownership = 532,
  sym_object_reference = 533,
  sym__insert_statement = 534,
  sym_insert = 535,
  sym__insert_values = 536,
  sym__set_values = 537,
  sym__column_list = 538,
  sym__column = 539,
  sym__update_statement = 540,
  sym__merge_statement = 541,
  sym_when_clause = 542,
  sym__optimize_statement = 543,
  sym__compute_stats = 544,
  sym__optimize_table = 545,
  sym__vacuum_table = 546,
  sym__vacuum_option = 547,
  sym__partition_spec = 548,
  sym_update = 549,
  sym__mysql_update_statement = 550,
  sym__postgres_update_statement = 551,
  sym_storage_location = 552,
  sym_row_format = 553,
  sym_table_sort = 554,
  sym_table_partition = 555,
  sym__key_value_pair = 556,
  sym_stored_as = 557,
  sym_assignment = 558,
  sym_table_option = 559,
  sym_column_definitions = 560,
  sym_column_definition = 561,
  sym__column_comment = 562,
  sym__column_constraint = 563,
  sym__default_expression = 564,
  sym__inner_default_expression = 565,
  sym_constraints = 566,
  sym_constraint = 567,
  sym__constraint_literal = 568,
  sym__primary_key_constraint = 569,
  sym__key_constraint = 570,
  sym_ordered_columns = 571,
  sym_ordered_column = 572,
  sym_all_fields = 573,
  sym_parameter = 574,
  sym_case = 575,
  sym_field = 576,
  sym__qualified_field = 577,
  sym_implicit_cast = 578,
  sym_interval_definitions = 579,
  sym__interval_definition = 580,
  sym_interval = 581,
  sym_cast = 582,
  sym_filter_expression = 583,
  sym_invocation = 584,
  sym_exists = 585,
  sym_partition_by = 586,
  sym_frame_definition = 587,
  sym_window_frame = 588,
  sym_window_clause = 589,
  sym_window_specification = 590,
  sym_window_function = 591,
  sym__alias = 592,
  sym_from = 593,
  sym_relation = 594,
  sym_values = 595,
  sym_index_hint = 596,
  sym_join = 597,
  sym_cross_join = 598,
  sym_lateral_join = 599,
  sym_lateral_cross_join = 600,
  sym_where = 601,
  sym_group_by = 602,
  sym__having = 603,
  sym_order_by = 604,
  sym_order_target = 605,
  sym_limit = 606,
  sym_offset = 607,
  sym_returning = 608,
  sym__expression = 609,
  sym_binary_expression = 610,
  sym_unary_expression = 611,
  sym_between_expression = 612,
  sym_not_in = 613,
  sym_subquery = 614,
  sym_list = 615,
  sym_literal = 616,
  sym__double_quote_string = 617,
  sym__single_quote_string = 618,
  sym__literal_string = 619,
  sym__integer = 620,
  sym__decimal_number = 621,
  sym_identifier = 622,
  aux_sym_program_repeat1 = 623,
  aux_sym_array_size_definition_repeat1 = 624,
  aux_sym_enum_repeat1 = 625,
  aux_sym_array_repeat1 = 626,
  aux_sym_transaction_repeat1 = 627,
  aux_sym__cte_repeat1 = 628,
  aux_sym_cte_repeat1 = 629,
  aux_sym_set_operation_repeat1 = 630,
  aux_sym_select_expression_repeat1 = 631,
  aux_sym__truncate_statement_repeat1 = 632,
  aux_sym__create_statement_repeat1 = 633,
  aux_sym__table_settings_repeat1 = 634,
  aux_sym_create_table_repeat1 = 635,
  aux_sym_create_view_repeat1 = 636,
  aux_sym_create_function_repeat1 = 637,
  aux_sym_function_body_repeat1 = 638,
  aux_sym_function_body_repeat2 = 639,
  aux_sym_create_database_repeat1 = 640,
  aux_sym_create_role_repeat1 = 641,
  aux_sym_create_sequence_repeat1 = 642,
  aux_sym_create_type_repeat1 = 643,
  aux_sym_enum_elements_repeat1 = 644,
  aux_sym__rename_statement_repeat1 = 645,
  aux_sym_alter_table_repeat1 = 646,
  aux_sym_alter_role_repeat1 = 647,
  aux_sym_alter_index_repeat1 = 648,
  aux_sym_alter_sequence_repeat1 = 649,
  aux_sym__insert_values_repeat1 = 650,
  aux_sym__set_values_repeat1 = 651,
  aux_sym__column_list_repeat1 = 652,
  aux_sym__merge_statement_repeat1 = 653,
  aux_sym__compute_stats_repeat1 = 654,
  aux_sym__compute_stats_repeat2 = 655,
  aux_sym__vacuum_table_repeat1 = 656,
  aux_sym__mysql_update_statement_repeat1 = 657,
  aux_sym__mysql_update_statement_repeat2 = 658,
  aux_sym_table_partition_repeat1 = 659,
  aux_sym_column_definitions_repeat1 = 660,
  aux_sym_column_definition_repeat1 = 661,
  aux_sym_constraints_repeat1 = 662,
  aux_sym__key_constraint_repeat1 = 663,
  aux_sym_ordered_columns_repeat1 = 664,
  aux_sym_case_repeat1 = 665,
  aux_sym_interval_definitions_repeat1 = 666,
  aux_sym_invocation_repeat1 = 667,
  aux_sym_from_repeat1 = 668,
  aux_sym_order_by_repeat1 = 669,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__identifier] = "_identifier",
  [anon_sym_SEMI] = ";",
  [sym_keyword_select] = "keyword_select",
  [sym_keyword_delete] = "keyword_delete",
  [sym_keyword_insert] = "keyword_insert",
  [sym_keyword_replace] = "keyword_replace",
  [sym_keyword_update] = "keyword_update",
  [sym_keyword_truncate] = "keyword_truncate",
  [sym_keyword_merge] = "keyword_merge",
  [sym_keyword_into] = "keyword_into",
  [sym_keyword_overwrite] = "keyword_overwrite",
  [sym_keyword_values] = "keyword_values",
  [sym_keyword_value] = "keyword_value",
  [sym_keyword_matched] = "keyword_matched",
  [sym_keyword_set] = "keyword_set",
  [sym_keyword_from] = "keyword_from",
  [sym_keyword_left] = "keyword_left",
  [sym_keyword_right] = "keyword_right",
  [sym_keyword_inner] = "keyword_inner",
  [sym_keyword_full] = "keyword_full",
  [sym_keyword_outer] = "keyword_outer",
  [sym_keyword_cross] = "keyword_cross",
  [sym_keyword_join] = "keyword_join",
  [sym_keyword_lateral] = "keyword_lateral",
  [sym_keyword_natural] = "keyword_natural",
  [sym_keyword_on] = "keyword_on",
  [sym_keyword_where] = "keyword_where",
  [sym_keyword_order] = "keyword_order",
  [sym_keyword_group] = "keyword_group",
  [sym_keyword_partition] = "keyword_partition",
  [sym_keyword_by] = "keyword_by",
  [sym_keyword_having] = "keyword_having",
  [sym_keyword_desc] = "keyword_desc",
  [sym_keyword_asc] = "keyword_asc",
  [sym_keyword_limit] = "keyword_limit",
  [sym_keyword_offset] = "keyword_offset",
  [sym_keyword_primary] = "keyword_primary",
  [sym_keyword_create] = "keyword_create",
  [sym_keyword_alter] = "keyword_alter",
  [sym_keyword_change] = "keyword_change",
  [sym_keyword_analyze] = "keyword_analyze",
  [sym_keyword_explain] = "keyword_explain",
  [sym_keyword_verbose] = "keyword_verbose",
  [sym_keyword_modify] = "keyword_modify",
  [sym_keyword_drop] = "keyword_drop",
  [sym_keyword_add] = "keyword_add",
  [sym_keyword_table] = "keyword_table",
  [sym_keyword_tables] = "keyword_tables",
  [sym_keyword_view] = "keyword_view",
  [sym_keyword_column] = "keyword_column",
  [sym_keyword_columns] = "keyword_columns",
  [sym_keyword_materialized] = "keyword_materialized",
  [sym_keyword_tablespace] = "keyword_tablespace",
  [sym_keyword_sequence] = "keyword_sequence",
  [sym_keyword_increment] = "keyword_increment",
  [sym_keyword_minvalue] = "keyword_minvalue",
  [sym_keyword_maxvalue] = "keyword_maxvalue",
  [sym_keyword_none] = "keyword_none",
  [sym_keyword_owned] = "keyword_owned",
  [sym_keyword_start] = "keyword_start",
  [sym_keyword_restart] = "keyword_restart",
  [sym_keyword_key] = "keyword_key",
  [sym_keyword_as] = "keyword_as",
  [sym_keyword_distinct] = "keyword_distinct",
  [sym_keyword_constraint] = "keyword_constraint",
  [sym_keyword_filter] = "keyword_filter",
  [sym_keyword_cast] = "keyword_cast",
  [sym_keyword_separator] = "keyword_separator",
  [sym_keyword_max] = "keyword_max",
  [sym_keyword_min] = "keyword_min",
  [sym_keyword_avg] = "keyword_avg",
  [sym_keyword_case] = "keyword_case",
  [sym_keyword_when] = "keyword_when",
  [sym_keyword_then] = "keyword_then",
  [sym_keyword_else] = "keyword_else",
  [sym_keyword_end] = "keyword_end",
  [sym_keyword_in] = "keyword_in",
  [sym_keyword_and] = "keyword_and",
  [sym_keyword_or] = "keyword_or",
  [sym_keyword_is] = "keyword_is",
  [sym_keyword_not] = "keyword_not",
  [sym_keyword_force] = "keyword_force",
  [sym_keyword_ignore] = "keyword_ignore",
  [sym_keyword_using] = "keyword_using",
  [sym_keyword_use] = "keyword_use",
  [sym_keyword_index] = "keyword_index",
  [sym_keyword_for] = "keyword_for",
  [sym_keyword_if] = "keyword_if",
  [sym_keyword_exists] = "keyword_exists",
  [sym_keyword_auto_increment] = "keyword_auto_increment",
  [sym_keyword_generated] = "keyword_generated",
  [sym_keyword_always] = "keyword_always",
  [sym_keyword_collate] = "keyword_collate",
  [aux_sym_keyword_character_token1] = "keyword_character_token1",
  [sym_keyword_engine] = "keyword_engine",
  [sym_keyword_default] = "keyword_default",
  [sym_keyword_cascade] = "keyword_cascade",
  [sym_keyword_restrict] = "keyword_restrict",
  [aux_sym_keyword_with_token1] = "keyword_with_token1",
  [sym_keyword_no] = "keyword_no",
  [sym_keyword_data] = "keyword_data",
  [sym_keyword_type] = "keyword_type",
  [sym_keyword_rename] = "keyword_rename",
  [sym_keyword_to] = "keyword_to",
  [sym_keyword_database] = "keyword_database",
  [sym_keyword_schema] = "keyword_schema",
  [sym_keyword_owner] = "keyword_owner",
  [sym_keyword_user] = "keyword_user",
  [sym_keyword_admin] = "keyword_admin",
  [sym_keyword_password] = "keyword_password",
  [sym_keyword_encrypted] = "keyword_encrypted",
  [sym_keyword_valid] = "keyword_valid",
  [sym_keyword_until] = "keyword_until",
  [sym_keyword_connection] = "keyword_connection",
  [sym_keyword_role] = "keyword_role",
  [sym_keyword_reset] = "keyword_reset",
  [sym_keyword_temp] = "keyword_temp",
  [sym_keyword_temporary] = "keyword_temporary",
  [sym_keyword_unlogged] = "keyword_unlogged",
  [sym_keyword_logged] = "keyword_logged",
  [sym_keyword_cycle] = "keyword_cycle",
  [sym_keyword_union] = "keyword_union",
  [sym_keyword_all] = "keyword_all",
  [sym_keyword_any] = "keyword_any",
  [sym_keyword_some] = "keyword_some",
  [sym_keyword_except] = "keyword_except",
  [sym_keyword_intersect] = "keyword_intersect",
  [sym_keyword_returning] = "keyword_returning",
  [sym_keyword_begin] = "keyword_begin",
  [sym_keyword_commit] = "keyword_commit",
  [sym_keyword_rollback] = "keyword_rollback",
  [sym_keyword_transaction] = "keyword_transaction",
  [sym_keyword_over] = "keyword_over",
  [sym_keyword_nulls] = "keyword_nulls",
  [sym_keyword_first] = "keyword_first",
  [sym_keyword_after] = "keyword_after",
  [sym_keyword_before] = "keyword_before",
  [sym_keyword_last] = "keyword_last",
  [sym_keyword_window] = "keyword_window",
  [sym_keyword_range] = "keyword_range",
  [sym_keyword_rows] = "keyword_rows",
  [sym_keyword_groups] = "keyword_groups",
  [sym_keyword_between] = "keyword_between",
  [sym_keyword_unbounded] = "keyword_unbounded",
  [sym_keyword_preceding] = "keyword_preceding",
  [sym_keyword_following] = "keyword_following",
  [sym_keyword_exclude] = "keyword_exclude",
  [sym_keyword_current] = "keyword_current",
  [sym_keyword_row] = "keyword_row",
  [sym_keyword_ties] = "keyword_ties",
  [sym_keyword_others] = "keyword_others",
  [sym_keyword_only] = "keyword_only",
  [sym_keyword_unique] = "keyword_unique",
  [sym_keyword_foreign] = "keyword_foreign",
  [sym_keyword_references] = "keyword_references",
  [sym_keyword_concurrently] = "keyword_concurrently",
  [sym_keyword_btree] = "keyword_btree",
  [sym_keyword_hash] = "keyword_hash",
  [sym_keyword_gist] = "keyword_gist",
  [sym_keyword_spgist] = "keyword_spgist",
  [sym_keyword_gin] = "keyword_gin",
  [sym_keyword_brin] = "keyword_brin",
  [aux_sym_keyword_like_token1] = "keyword_like_token1",
  [aux_sym_keyword_like_token2] = "keyword_like_token2",
  [sym_keyword_similar] = "keyword_similar",
  [sym_keyword_preserve] = "keyword_preserve",
  [sym_keyword_unsigned] = "keyword_unsigned",
  [sym_keyword_zerofill] = "keyword_zerofill",
  [sym_keyword_conflict] = "keyword_conflict",
  [sym_keyword_do] = "keyword_do",
  [sym_keyword_nothing] = "keyword_nothing",
  [sym_keyword_high_priority] = "keyword_high_priority",
  [sym_keyword_low_priority] = "keyword_low_priority",
  [sym_keyword_delayed] = "keyword_delayed",
  [sym_keyword_recursive] = "keyword_recursive",
  [sym_keyword_cascaded] = "keyword_cascaded",
  [sym_keyword_local] = "keyword_local",
  [sym_keyword_current_timestamp] = "keyword_current_timestamp",
  [sym_keyword_check] = "keyword_check",
  [sym_keyword_option] = "keyword_option",
  [sym_keyword_vacuum] = "keyword_vacuum",
  [sym_keyword_wait] = "keyword_wait",
  [sym_keyword_nowait] = "keyword_nowait",
  [sym_keyword_attribute] = "keyword_attribute",
  [sym_keyword_authorization] = "keyword_authorization",
  [sym_keyword_action] = "keyword_action",
  [sym_keyword_trigger] = "keyword_trigger",
  [sym_keyword_function] = "keyword_function",
  [sym_keyword_returns] = "keyword_returns",
  [sym_keyword_return] = "keyword_return",
  [sym_keyword_setof] = "keyword_setof",
  [sym_keyword_atomic] = "keyword_atomic",
  [sym_keyword_declare] = "keyword_declare",
  [sym_keyword_language] = "keyword_language",
  [sym_keyword_sql] = "keyword_sql",
  [sym_keyword_plpgsql] = "keyword_plpgsql",
  [sym_keyword_immutable] = "keyword_immutable",
  [sym_keyword_stable] = "keyword_stable",
  [sym_keyword_volatile] = "keyword_volatile",
  [sym_keyword_leakproof] = "keyword_leakproof",
  [sym_keyword_parallel] = "keyword_parallel",
  [sym_keyword_safe] = "keyword_safe",
  [sym_keyword_unsafe] = "keyword_unsafe",
  [sym_keyword_restricted] = "keyword_restricted",
  [sym_keyword_called] = "keyword_called",
  [sym_keyword_input] = "keyword_input",
  [sym_keyword_strict] = "keyword_strict",
  [sym_keyword_cost] = "keyword_cost",
  [sym_keyword_support] = "keyword_support",
  [sym_keyword_external] = "keyword_external",
  [sym_keyword_stored] = "keyword_stored",
  [sym_keyword_virtual] = "keyword_virtual",
  [sym_keyword_cached] = "keyword_cached",
  [sym_keyword_uncached] = "keyword_uncached",
  [sym_keyword_replication] = "keyword_replication",
  [sym_keyword_tblproperties] = "keyword_tblproperties",
  [sym_keyword_options] = "keyword_options",
  [sym_keyword_compute] = "keyword_compute",
  [sym_keyword_stats] = "keyword_stats",
  [sym_keyword_statistics] = "keyword_statistics",
  [sym_keyword_optimize] = "keyword_optimize",
  [sym_keyword_rewrite] = "keyword_rewrite",
  [sym_keyword_bin_pack] = "keyword_bin_pack",
  [sym_keyword_incremental] = "keyword_incremental",
  [sym_keyword_location] = "keyword_location",
  [sym_keyword_partitioned] = "keyword_partitioned",
  [sym_keyword_comment] = "keyword_comment",
  [sym_keyword_sort] = "keyword_sort",
  [sym_keyword_format] = "keyword_format",
  [sym_keyword_delimited] = "keyword_delimited",
  [sym_keyword_fields] = "keyword_fields",
  [sym_keyword_terminated] = "keyword_terminated",
  [sym_keyword_escaped] = "keyword_escaped",
  [sym_keyword_lines] = "keyword_lines",
  [sym_keyword_cache] = "keyword_cache",
  [sym_keyword_metadata] = "keyword_metadata",
  [sym_keyword_noscan] = "keyword_noscan",
  [sym_keyword_parquet] = "keyword_parquet",
  [sym_keyword_rcfile] = "keyword_rcfile",
  [sym_keyword_csv] = "keyword_csv",
  [sym_keyword_textfile] = "keyword_textfile",
  [sym_keyword_avro] = "keyword_avro",
  [sym_keyword_sequencefile] = "keyword_sequencefile",
  [sym_keyword_orc] = "keyword_orc",
  [sym_keyword_jsonfile] = "keyword_jsonfile",
  [sym_keyword_null] = "keyword_null",
  [sym_keyword_true] = "keyword_true",
  [sym_keyword_false] = "keyword_false",
  [sym_keyword_boolean] = "keyword_boolean",
  [sym_keyword_bit] = "keyword_bit",
  [sym_keyword_binary] = "keyword_binary",
  [sym_keyword_varbinary] = "keyword_varbinary",
  [sym_keyword_image] = "keyword_image",
  [aux_sym_keyword_smallserial_token1] = "keyword_smallserial_token1",
  [aux_sym_keyword_smallserial_token2] = "keyword_smallserial_token2",
  [aux_sym_keyword_serial_token1] = "keyword_serial_token1",
  [aux_sym_keyword_serial_token2] = "keyword_serial_token2",
  [aux_sym_keyword_bigserial_token1] = "keyword_bigserial_token1",
  [aux_sym_keyword_bigserial_token2] = "keyword_bigserial_token2",
  [aux_sym_keyword_tinyint_token1] = "keyword_tinyint_token1",
  [aux_sym_keyword_tinyint_token2] = "keyword_tinyint_token2",
  [aux_sym_keyword_smallint_token1] = "keyword_smallint_token1",
  [aux_sym_keyword_smallint_token2] = "keyword_smallint_token2",
  [aux_sym_keyword_mediumint_token1] = "keyword_mediumint_token1",
  [aux_sym_keyword_mediumint_token2] = "keyword_mediumint_token2",
  [aux_sym_keyword_int_token1] = "keyword_int_token1",
  [aux_sym_keyword_int_token2] = "keyword_int_token2",
  [aux_sym_keyword_int_token3] = "keyword_int_token3",
  [aux_sym_keyword_bigint_token1] = "keyword_bigint_token1",
  [aux_sym_keyword_bigint_token2] = "keyword_bigint_token2",
  [sym_keyword_decimal] = "keyword_decimal",
  [sym_keyword_numeric] = "keyword_numeric",
  [aux_sym_keyword_real_token1] = "keyword_real_token1",
  [aux_sym_keyword_real_token2] = "keyword_real_token2",
  [sym_keyword_float] = "keyword_float",
  [sym_keyword_double] = "keyword_double",
  [sym_keyword_precision] = "keyword_precision",
  [sym_keyword_inet] = "keyword_inet",
  [sym_keyword_money] = "keyword_money",
  [sym_keyword_smallmoney] = "keyword_smallmoney",
  [sym_keyword_varying] = "keyword_varying",
  [aux_sym_keyword_char_token1] = "keyword_char_token1",
  [sym_keyword_nchar] = "keyword_nchar",
  [aux_sym_keyword_varchar_token1] = "keyword_varchar_token1",
  [sym_keyword_nvarchar] = "keyword_nvarchar",
  [sym_keyword_text] = "keyword_text",
  [sym_keyword_string] = "keyword_string",
  [sym_keyword_uuid] = "keyword_uuid",
  [sym_keyword_json] = "keyword_json",
  [sym_keyword_jsonb] = "keyword_jsonb",
  [sym_keyword_xml] = "keyword_xml",
  [sym_keyword_bytea] = "keyword_bytea",
  [sym_keyword_enum] = "keyword_enum",
  [sym_keyword_date] = "keyword_date",
  [sym_keyword_datetime] = "keyword_datetime",
  [sym_keyword_datetime2] = "keyword_datetime2",
  [sym_keyword_smalldatetime] = "keyword_smalldatetime",
  [sym_keyword_datetimeoffset] = "keyword_datetimeoffset",
  [aux_sym_keyword_time_token1] = "keyword_time_token1",
  [aux_sym_keyword_timestamp_token1] = "keyword_timestamp_token1",
  [aux_sym_keyword_timestamp_token2] = "keyword_timestamp_token2",
  [aux_sym_keyword_timestamp_token3] = "keyword_timestamp_token3",
  [aux_sym_keyword_timestamptz_token1] = "keyword_timestamptz_token1",
  [sym_keyword_interval] = "keyword_interval",
  [sym_keyword_geometry] = "keyword_geometry",
  [sym_keyword_geography] = "keyword_geography",
  [sym_keyword_box2d] = "keyword_box2d",
  [sym_keyword_box3d] = "keyword_box3d",
  [sym_keyword_oid] = "keyword_oid",
  [sym_keyword_name] = "keyword_name",
  [sym_keyword_regclass] = "keyword_regclass",
  [sym_keyword_regnamespace] = "keyword_regnamespace",
  [sym_keyword_regproc] = "keyword_regproc",
  [sym_keyword_regtype] = "keyword_regtype",
  [sym_keyword_array] = "keyword_array",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [aux_sym_double_token1] = "double_token1",
  [anon_sym_DASH_DASH] = "--",
  [aux_sym_comment_token1] = "comment_token1",
  [anon_sym_SLASH_STAR] = "/*",
  [aux_sym_marginalia_token1] = "marginalia_token1",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOLLAR_DOLLAR] = "$$",
  [anon_sym_DOLLARfunction_DOLLAR] = "$function$",
  [anon_sym_DOLLARbody_DOLLAR] = "$body$",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_EQ] = "=",
  [anon_sym_DOT] = ".",
  [anon_sym_STAR] = "*",
  [anon_sym_QMARK] = "\?",
  [anon_sym_DOLLAR] = "$",
  [aux_sym_parameter_token1] = "parameter_token1",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_millennium] = "millennium",
  [anon_sym_century] = "century",
  [anon_sym_decade] = "decade",
  [anon_sym_year] = "year",
  [anon_sym_month] = "month",
  [anon_sym_week] = "week",
  [anon_sym_day] = "day",
  [anon_sym_hour] = "hour",
  [anon_sym_minute] = "minute",
  [anon_sym_second] = "second",
  [anon_sym_millisecond] = "millisecond",
  [anon_sym_microsecond] = "microsecond",
  [anon_sym_y] = "y",
  [anon_sym_m] = "m",
  [anon_sym_d] = "d",
  [anon_sym_H] = "H",
  [anon_sym_M] = "M",
  [anon_sym_S] = "S",
  [anon_sym_years] = "years",
  [anon_sym_months] = "months",
  [anon_sym_weeks] = "weeks",
  [anon_sym_days] = "days",
  [anon_sym_hours] = "hours",
  [anon_sym_minutes] = "minutes",
  [anon_sym_seconds] = "seconds",
  [anon_sym_ago] = "ago",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_POUND_GT] = "#>",
  [anon_sym_POUND_GT_GT] = "#>>",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__double_quote_string_token1] = "_double_quote_string_token1",
  [aux_sym__single_quote_string_token1] = "_single_quote_string_token1",
  [sym__natural_number] = "_natural_number",
  [sym_bang] = "bang",
  [anon_sym_BQUOTE] = "`",
  [sym_program] = "program",
  [sym_keyword_character] = "keyword_character",
  [sym_keyword_with] = "keyword_with",
  [sym_keyword_like] = "keyword_like",
  [sym_is_not] = "is_not",
  [sym_not_like] = "not_like",
  [sym_similar_to] = "similar_to",
  [sym_not_similar_to] = "not_similar_to",
  [sym_distinct_from] = "distinct_from",
  [sym_not_distinct_from] = "not_distinct_from",
  [sym__temporary] = "_temporary",
  [sym__not_null] = "_not_null",
  [sym__primary_key] = "_primary_key",
  [sym__if_exists] = "_if_exists",
  [sym__if_not_exists] = "_if_not_exists",
  [sym__or_replace] = "_or_replace",
  [sym__current_row] = "_current_row",
  [sym__exclude_current_row] = "_exclude_current_row",
  [sym__exclude_group] = "_exclude_group",
  [sym__exclude_no_others] = "_exclude_no_others",
  [sym__exclude_ties] = "_exclude_ties",
  [sym__check_option] = "_check_option",
  [sym_direction] = "direction",
  [sym_keyword_smallserial] = "keyword_smallserial",
  [sym_keyword_serial] = "keyword_serial",
  [sym_keyword_bigserial] = "keyword_bigserial",
  [sym_keyword_tinyint] = "keyword_tinyint",
  [sym_keyword_smallint] = "keyword_smallint",
  [sym_keyword_mediumint] = "keyword_mediumint",
  [sym_keyword_int] = "keyword_int",
  [sym_keyword_bigint] = "keyword_bigint",
  [sym_keyword_real] = "keyword_real",
  [sym_keyword_char] = "keyword_char",
  [sym_keyword_varchar] = "keyword_varchar",
  [sym_keyword_time] = "keyword_time",
  [sym_keyword_timestamp] = "keyword_timestamp",
  [sym_keyword_timestamptz] = "keyword_timestamptz",
  [sym__type] = "_type",
  [sym_array_size_definition] = "array_size_definition",
  [sym__array_size_definition] = "_array_size_definition",
  [sym_tinyint] = "tinyint",
  [sym_smallint] = "smallint",
  [sym_mediumint] = "mediumint",
  [sym_int] = "int",
  [sym_bigint] = "bigint",
  [sym_bit] = "bit",
  [sym_binary] = "binary",
  [sym_varbinary] = "varbinary",
  [sym_float] = "float",
  [sym_double] = "double",
  [sym_decimal] = "decimal",
  [sym_numeric] = "numeric",
  [sym_char] = "char",
  [sym_varchar] = "varchar",
  [sym_nchar] = "nchar",
  [sym_nvarchar] = "nvarchar",
  [sym_datetimeoffset] = "datetimeoffset",
  [sym_time] = "time",
  [sym_enum] = "enum",
  [sym_array] = "array",
  [sym_comment] = "comment",
  [sym_marginalia] = "marginalia",
  [sym_transaction] = "transaction",
  [sym__commit] = "_commit",
  [sym__rollback] = "_rollback",
  [sym_block] = "block",
  [sym_statement] = "statement",
  [sym__ddl_statement] = "_ddl_statement",
  [sym__cte] = "_cte",
  [sym__dml_write] = "_dml_write",
  [sym__dml_read] = "_dml_read",
  [sym_cte] = "cte",
  [sym_set_operation] = "set_operation",
  [sym__select_statement] = "_select_statement",
  [sym_comment_statement] = "comment_statement",
  [sym__comment_target] = "_comment_target",
  [sym_select] = "select",
  [sym_select_expression] = "select_expression",
  [sym_term] = "term",
  [sym__truncate_statement] = "_truncate_statement",
  [sym__delete_statement] = "_delete_statement",
  [sym__delete_from] = "from",
  [sym_delete] = "delete",
  [sym__create_statement] = "_create_statement",
  [sym__table_settings] = "_table_settings",
  [sym_create_table] = "create_table",
  [sym_create_query] = "create_query",
  [sym_create_view] = "create_view",
  [sym_create_materialized_view] = "create_materialized_view",
  [sym_dollar_quote] = "dollar_quote",
  [sym_create_function] = "create_function",
  [sym__function_return] = "_function_return",
  [sym_function_declaration] = "function_declaration",
  [sym__function_body_statement] = "_function_body_statement",
  [sym_function_body] = "function_body",
  [sym_function_language] = "function_language",
  [sym_function_volatility] = "function_volatility",
  [sym_function_leakproof] = "function_leakproof",
  [sym_function_safety] = "function_safety",
  [sym_function_strictness] = "function_strictness",
  [sym_function_cost] = "function_cost",
  [sym_function_rows] = "function_rows",
  [sym_function_support] = "function_support",
  [sym_create_index] = "create_index",
  [sym_create_schema] = "create_schema",
  [sym__with_settings] = "_with_settings",
  [sym_create_database] = "create_database",
  [sym_create_role] = "create_role",
  [sym__role_options] = "_role_options",
  [sym__user_access_role_config] = "_user_access_role_config",
  [sym_create_sequence] = "create_sequence",
  [sym_create_type] = "create_type",
  [sym_enum_elements] = "enum_elements",
  [sym__alter_statement] = "_alter_statement",
  [sym__rename_statement] = "_rename_statement",
  [sym__rename_table_names] = "_rename_table_names",
  [sym_alter_table] = "alter_table",
  [sym__alter_specifications] = "_alter_specifications",
  [sym_add_column] = "add_column",
  [sym_add_constraint] = "add_constraint",
  [sym_alter_column] = "alter_column",
  [sym_modify_column] = "modify_column",
  [sym_change_column] = "change_column",
  [sym_column_position] = "column_position",
  [sym_drop_column] = "drop_column",
  [sym_rename_column] = "rename_column",
  [sym_alter_view] = "alter_view",
  [sym_alter_schema] = "alter_schema",
  [sym_alter_database] = "alter_database",
  [sym_alter_role] = "alter_role",
  [sym_set_configuration] = "set_configuration",
  [sym_alter_index] = "alter_index",
  [sym_alter_sequence] = "alter_sequence",
  [sym_alter_type] = "alter_type",
  [sym__drop_behavior] = "_drop_behavior",
  [sym__drop_statement] = "_drop_statement",
  [sym_drop_table] = "drop_table",
  [sym_drop_view] = "drop_view",
  [sym_drop_schema] = "drop_schema",
  [sym_drop_database] = "drop_database",
  [sym_drop_role] = "drop_role",
  [sym_drop_type] = "drop_type",
  [sym_drop_sequence] = "drop_sequence",
  [sym_drop_index] = "drop_index",
  [sym_rename_object] = "rename_object",
  [sym_set_schema] = "set_schema",
  [sym_change_ownership] = "change_ownership",
  [sym_object_reference] = "object_reference",
  [sym__insert_statement] = "_insert_statement",
  [sym_insert] = "insert",
  [sym__insert_values] = "_insert_values",
  [sym__set_values] = "_set_values",
  [sym__column_list] = "list",
  [sym__column] = "_column",
  [sym__update_statement] = "_update_statement",
  [sym__merge_statement] = "_merge_statement",
  [sym_when_clause] = "when_clause",
  [sym__optimize_statement] = "_optimize_statement",
  [sym__compute_stats] = "_compute_stats",
  [sym__optimize_table] = "_optimize_table",
  [sym__vacuum_table] = "_vacuum_table",
  [sym__vacuum_option] = "_vacuum_option",
  [sym__partition_spec] = "_partition_spec",
  [sym_update] = "update",
  [sym__mysql_update_statement] = "_mysql_update_statement",
  [sym__postgres_update_statement] = "_postgres_update_statement",
  [sym_storage_location] = "storage_location",
  [sym_row_format] = "row_format",
  [sym_table_sort] = "table_sort",
  [sym_table_partition] = "table_partition",
  [sym__key_value_pair] = "_key_value_pair",
  [sym_stored_as] = "stored_as",
  [sym_assignment] = "assignment",
  [sym_table_option] = "table_option",
  [sym_column_definitions] = "column_definitions",
  [sym_column_definition] = "column_definition",
  [sym__column_comment] = "_column_comment",
  [sym__column_constraint] = "_column_constraint",
  [sym__default_expression] = "_default_expression",
  [sym__inner_default_expression] = "_inner_default_expression",
  [sym_constraints] = "constraints",
  [sym_constraint] = "constraint",
  [sym__constraint_literal] = "_constraint_literal",
  [sym__primary_key_constraint] = "_primary_key_constraint",
  [sym__key_constraint] = "_key_constraint",
  [sym_ordered_columns] = "ordered_columns",
  [sym_ordered_column] = "column",
  [sym_all_fields] = "all_fields",
  [sym_parameter] = "parameter",
  [sym_case] = "case",
  [sym_field] = "field",
  [sym__qualified_field] = "field",
  [sym_implicit_cast] = "cast",
  [sym_interval_definitions] = "interval_definitions",
  [sym__interval_definition] = "_interval_definition",
  [sym_interval] = "interval",
  [sym_cast] = "cast",
  [sym_filter_expression] = "filter_expression",
  [sym_invocation] = "invocation",
  [sym_exists] = "exists",
  [sym_partition_by] = "partition_by",
  [sym_frame_definition] = "frame_definition",
  [sym_window_frame] = "window_frame",
  [sym_window_clause] = "window_clause",
  [sym_window_specification] = "window_specification",
  [sym_window_function] = "window_function",
  [sym__alias] = "_alias",
  [sym_from] = "from",
  [sym_relation] = "relation",
  [sym_values] = "values",
  [sym_index_hint] = "index_hint",
  [sym_join] = "join",
  [sym_cross_join] = "cross_join",
  [sym_lateral_join] = "lateral_join",
  [sym_lateral_cross_join] = "lateral_cross_join",
  [sym_where] = "where",
  [sym_group_by] = "group_by",
  [sym__having] = "_having",
  [sym_order_by] = "order_by",
  [sym_order_target] = "order_target",
  [sym_limit] = "limit",
  [sym_offset] = "offset",
  [sym_returning] = "returning",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_between_expression] = "between_expression",
  [sym_not_in] = "not_in",
  [sym_subquery] = "subquery",
  [sym_list] = "list",
  [sym_literal] = "literal",
  [sym__double_quote_string] = "_double_quote_string",
  [sym__single_quote_string] = "_single_quote_string",
  [sym__literal_string] = "_literal_string",
  [sym__integer] = "_integer",
  [sym__decimal_number] = "_decimal_number",
  [sym_identifier] = "identifier",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_array_size_definition_repeat1] = "array_size_definition_repeat1",
  [aux_sym_enum_repeat1] = "enum_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_transaction_repeat1] = "transaction_repeat1",
  [aux_sym__cte_repeat1] = "_cte_repeat1",
  [aux_sym_cte_repeat1] = "cte_repeat1",
  [aux_sym_set_operation_repeat1] = "set_operation_repeat1",
  [aux_sym_select_expression_repeat1] = "select_expression_repeat1",
  [aux_sym__truncate_statement_repeat1] = "_truncate_statement_repeat1",
  [aux_sym__create_statement_repeat1] = "_create_statement_repeat1",
  [aux_sym__table_settings_repeat1] = "_table_settings_repeat1",
  [aux_sym_create_table_repeat1] = "create_table_repeat1",
  [aux_sym_create_view_repeat1] = "create_view_repeat1",
  [aux_sym_create_function_repeat1] = "create_function_repeat1",
  [aux_sym_function_body_repeat1] = "function_body_repeat1",
  [aux_sym_function_body_repeat2] = "function_body_repeat2",
  [aux_sym_create_database_repeat1] = "create_database_repeat1",
  [aux_sym_create_role_repeat1] = "create_role_repeat1",
  [aux_sym_create_sequence_repeat1] = "create_sequence_repeat1",
  [aux_sym_create_type_repeat1] = "create_type_repeat1",
  [aux_sym_enum_elements_repeat1] = "enum_elements_repeat1",
  [aux_sym__rename_statement_repeat1] = "_rename_statement_repeat1",
  [aux_sym_alter_table_repeat1] = "alter_table_repeat1",
  [aux_sym_alter_role_repeat1] = "alter_role_repeat1",
  [aux_sym_alter_index_repeat1] = "alter_index_repeat1",
  [aux_sym_alter_sequence_repeat1] = "alter_sequence_repeat1",
  [aux_sym__insert_values_repeat1] = "_insert_values_repeat1",
  [aux_sym__set_values_repeat1] = "_set_values_repeat1",
  [aux_sym__column_list_repeat1] = "_column_list_repeat1",
  [aux_sym__merge_statement_repeat1] = "_merge_statement_repeat1",
  [aux_sym__compute_stats_repeat1] = "_compute_stats_repeat1",
  [aux_sym__compute_stats_repeat2] = "_compute_stats_repeat2",
  [aux_sym__vacuum_table_repeat1] = "_vacuum_table_repeat1",
  [aux_sym__mysql_update_statement_repeat1] = "_mysql_update_statement_repeat1",
  [aux_sym__mysql_update_statement_repeat2] = "_mysql_update_statement_repeat2",
  [aux_sym_table_partition_repeat1] = "table_partition_repeat1",
  [aux_sym_column_definitions_repeat1] = "column_definitions_repeat1",
  [aux_sym_column_definition_repeat1] = "column_definition_repeat1",
  [aux_sym_constraints_repeat1] = "constraints_repeat1",
  [aux_sym__key_constraint_repeat1] = "_key_constraint_repeat1",
  [aux_sym_ordered_columns_repeat1] = "ordered_columns_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_interval_definitions_repeat1] = "interval_definitions_repeat1",
  [aux_sym_invocation_repeat1] = "invocation_repeat1",
  [aux_sym_from_repeat1] = "from_repeat1",
  [aux_sym_order_by_repeat1] = "order_by_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__identifier] = sym__identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_keyword_select] = sym_keyword_select,
  [sym_keyword_delete] = sym_keyword_delete,
  [sym_keyword_insert] = sym_keyword_insert,
  [sym_keyword_replace] = sym_keyword_replace,
  [sym_keyword_update] = sym_keyword_update,
  [sym_keyword_truncate] = sym_keyword_truncate,
  [sym_keyword_merge] = sym_keyword_merge,
  [sym_keyword_into] = sym_keyword_into,
  [sym_keyword_overwrite] = sym_keyword_overwrite,
  [sym_keyword_values] = sym_keyword_values,
  [sym_keyword_value] = sym_keyword_value,
  [sym_keyword_matched] = sym_keyword_matched,
  [sym_keyword_set] = sym_keyword_set,
  [sym_keyword_from] = sym_keyword_from,
  [sym_keyword_left] = sym_keyword_left,
  [sym_keyword_right] = sym_keyword_right,
  [sym_keyword_inner] = sym_keyword_inner,
  [sym_keyword_full] = sym_keyword_full,
  [sym_keyword_outer] = sym_keyword_outer,
  [sym_keyword_cross] = sym_keyword_cross,
  [sym_keyword_join] = sym_keyword_join,
  [sym_keyword_lateral] = sym_keyword_lateral,
  [sym_keyword_natural] = sym_keyword_natural,
  [sym_keyword_on] = sym_keyword_on,
  [sym_keyword_where] = sym_keyword_where,
  [sym_keyword_order] = sym_keyword_order,
  [sym_keyword_group] = sym_keyword_group,
  [sym_keyword_partition] = sym_keyword_partition,
  [sym_keyword_by] = sym_keyword_by,
  [sym_keyword_having] = sym_keyword_having,
  [sym_keyword_desc] = sym_keyword_desc,
  [sym_keyword_asc] = sym_keyword_asc,
  [sym_keyword_limit] = sym_keyword_limit,
  [sym_keyword_offset] = sym_keyword_offset,
  [sym_keyword_primary] = sym_keyword_primary,
  [sym_keyword_create] = sym_keyword_create,
  [sym_keyword_alter] = sym_keyword_alter,
  [sym_keyword_change] = sym_keyword_change,
  [sym_keyword_analyze] = sym_keyword_analyze,
  [sym_keyword_explain] = sym_keyword_explain,
  [sym_keyword_verbose] = sym_keyword_verbose,
  [sym_keyword_modify] = sym_keyword_modify,
  [sym_keyword_drop] = sym_keyword_drop,
  [sym_keyword_add] = sym_keyword_add,
  [sym_keyword_table] = sym_keyword_table,
  [sym_keyword_tables] = sym_keyword_tables,
  [sym_keyword_view] = sym_keyword_view,
  [sym_keyword_column] = sym_keyword_column,
  [sym_keyword_columns] = sym_keyword_columns,
  [sym_keyword_materialized] = sym_keyword_materialized,
  [sym_keyword_tablespace] = sym_keyword_tablespace,
  [sym_keyword_sequence] = sym_keyword_sequence,
  [sym_keyword_increment] = sym_keyword_increment,
  [sym_keyword_minvalue] = sym_keyword_minvalue,
  [sym_keyword_maxvalue] = sym_keyword_maxvalue,
  [sym_keyword_none] = sym_keyword_none,
  [sym_keyword_owned] = sym_keyword_owned,
  [sym_keyword_start] = sym_keyword_start,
  [sym_keyword_restart] = sym_keyword_restart,
  [sym_keyword_key] = sym_keyword_key,
  [sym_keyword_as] = sym_keyword_as,
  [sym_keyword_distinct] = sym_keyword_distinct,
  [sym_keyword_constraint] = sym_keyword_constraint,
  [sym_keyword_filter] = sym_keyword_filter,
  [sym_keyword_cast] = sym_keyword_cast,
  [sym_keyword_separator] = sym_keyword_separator,
  [sym_keyword_max] = sym_keyword_max,
  [sym_keyword_min] = sym_keyword_min,
  [sym_keyword_avg] = sym_keyword_avg,
  [sym_keyword_case] = sym_keyword_case,
  [sym_keyword_when] = sym_keyword_when,
  [sym_keyword_then] = sym_keyword_then,
  [sym_keyword_else] = sym_keyword_else,
  [sym_keyword_end] = sym_keyword_end,
  [sym_keyword_in] = sym_keyword_in,
  [sym_keyword_and] = sym_keyword_and,
  [sym_keyword_or] = sym_keyword_or,
  [sym_keyword_is] = sym_keyword_is,
  [sym_keyword_not] = sym_keyword_not,
  [sym_keyword_force] = sym_keyword_force,
  [sym_keyword_ignore] = sym_keyword_ignore,
  [sym_keyword_using] = sym_keyword_using,
  [sym_keyword_use] = sym_keyword_use,
  [sym_keyword_index] = sym_keyword_index,
  [sym_keyword_for] = sym_keyword_for,
  [sym_keyword_if] = sym_keyword_if,
  [sym_keyword_exists] = sym_keyword_exists,
  [sym_keyword_auto_increment] = sym_keyword_auto_increment,
  [sym_keyword_generated] = sym_keyword_generated,
  [sym_keyword_always] = sym_keyword_always,
  [sym_keyword_collate] = sym_keyword_collate,
  [aux_sym_keyword_character_token1] = aux_sym_keyword_character_token1,
  [sym_keyword_engine] = sym_keyword_engine,
  [sym_keyword_default] = sym_keyword_default,
  [sym_keyword_cascade] = sym_keyword_cascade,
  [sym_keyword_restrict] = sym_keyword_restrict,
  [aux_sym_keyword_with_token1] = aux_sym_keyword_with_token1,
  [sym_keyword_no] = sym_keyword_no,
  [sym_keyword_data] = sym_keyword_data,
  [sym_keyword_type] = sym_keyword_type,
  [sym_keyword_rename] = sym_keyword_rename,
  [sym_keyword_to] = sym_keyword_to,
  [sym_keyword_database] = sym_keyword_database,
  [sym_keyword_schema] = sym_keyword_schema,
  [sym_keyword_owner] = sym_keyword_owner,
  [sym_keyword_user] = sym_keyword_user,
  [sym_keyword_admin] = sym_keyword_admin,
  [sym_keyword_password] = sym_keyword_password,
  [sym_keyword_encrypted] = sym_keyword_encrypted,
  [sym_keyword_valid] = sym_keyword_valid,
  [sym_keyword_until] = sym_keyword_until,
  [sym_keyword_connection] = sym_keyword_connection,
  [sym_keyword_role] = sym_keyword_role,
  [sym_keyword_reset] = sym_keyword_reset,
  [sym_keyword_temp] = sym_keyword_temp,
  [sym_keyword_temporary] = sym_keyword_temporary,
  [sym_keyword_unlogged] = sym_keyword_unlogged,
  [sym_keyword_logged] = sym_keyword_logged,
  [sym_keyword_cycle] = sym_keyword_cycle,
  [sym_keyword_union] = sym_keyword_union,
  [sym_keyword_all] = sym_keyword_all,
  [sym_keyword_any] = sym_keyword_any,
  [sym_keyword_some] = sym_keyword_some,
  [sym_keyword_except] = sym_keyword_except,
  [sym_keyword_intersect] = sym_keyword_intersect,
  [sym_keyword_returning] = sym_keyword_returning,
  [sym_keyword_begin] = sym_keyword_begin,
  [sym_keyword_commit] = sym_keyword_commit,
  [sym_keyword_rollback] = sym_keyword_rollback,
  [sym_keyword_transaction] = sym_keyword_transaction,
  [sym_keyword_over] = sym_keyword_over,
  [sym_keyword_nulls] = sym_keyword_nulls,
  [sym_keyword_first] = sym_keyword_first,
  [sym_keyword_after] = sym_keyword_after,
  [sym_keyword_before] = sym_keyword_before,
  [sym_keyword_last] = sym_keyword_last,
  [sym_keyword_window] = sym_keyword_window,
  [sym_keyword_range] = sym_keyword_range,
  [sym_keyword_rows] = sym_keyword_rows,
  [sym_keyword_groups] = sym_keyword_groups,
  [sym_keyword_between] = sym_keyword_between,
  [sym_keyword_unbounded] = sym_keyword_unbounded,
  [sym_keyword_preceding] = sym_keyword_preceding,
  [sym_keyword_following] = sym_keyword_following,
  [sym_keyword_exclude] = sym_keyword_exclude,
  [sym_keyword_current] = sym_keyword_current,
  [sym_keyword_row] = sym_keyword_row,
  [sym_keyword_ties] = sym_keyword_ties,
  [sym_keyword_others] = sym_keyword_others,
  [sym_keyword_only] = sym_keyword_only,
  [sym_keyword_unique] = sym_keyword_unique,
  [sym_keyword_foreign] = sym_keyword_foreign,
  [sym_keyword_references] = sym_keyword_references,
  [sym_keyword_concurrently] = sym_keyword_concurrently,
  [sym_keyword_btree] = sym_keyword_btree,
  [sym_keyword_hash] = sym_keyword_hash,
  [sym_keyword_gist] = sym_keyword_gist,
  [sym_keyword_spgist] = sym_keyword_spgist,
  [sym_keyword_gin] = sym_keyword_gin,
  [sym_keyword_brin] = sym_keyword_brin,
  [aux_sym_keyword_like_token1] = aux_sym_keyword_like_token1,
  [aux_sym_keyword_like_token2] = aux_sym_keyword_like_token2,
  [sym_keyword_similar] = sym_keyword_similar,
  [sym_keyword_preserve] = sym_keyword_preserve,
  [sym_keyword_unsigned] = sym_keyword_unsigned,
  [sym_keyword_zerofill] = sym_keyword_zerofill,
  [sym_keyword_conflict] = sym_keyword_conflict,
  [sym_keyword_do] = sym_keyword_do,
  [sym_keyword_nothing] = sym_keyword_nothing,
  [sym_keyword_high_priority] = sym_keyword_high_priority,
  [sym_keyword_low_priority] = sym_keyword_low_priority,
  [sym_keyword_delayed] = sym_keyword_delayed,
  [sym_keyword_recursive] = sym_keyword_recursive,
  [sym_keyword_cascaded] = sym_keyword_cascaded,
  [sym_keyword_local] = sym_keyword_local,
  [sym_keyword_current_timestamp] = sym_keyword_current_timestamp,
  [sym_keyword_check] = sym_keyword_check,
  [sym_keyword_option] = sym_keyword_option,
  [sym_keyword_vacuum] = sym_keyword_vacuum,
  [sym_keyword_wait] = sym_keyword_wait,
  [sym_keyword_nowait] = sym_keyword_nowait,
  [sym_keyword_attribute] = sym_keyword_attribute,
  [sym_keyword_authorization] = sym_keyword_authorization,
  [sym_keyword_action] = sym_keyword_action,
  [sym_keyword_trigger] = sym_keyword_trigger,
  [sym_keyword_function] = sym_keyword_function,
  [sym_keyword_returns] = sym_keyword_returns,
  [sym_keyword_return] = sym_keyword_return,
  [sym_keyword_setof] = sym_keyword_setof,
  [sym_keyword_atomic] = sym_keyword_atomic,
  [sym_keyword_declare] = sym_keyword_declare,
  [sym_keyword_language] = sym_keyword_language,
  [sym_keyword_sql] = sym_keyword_sql,
  [sym_keyword_plpgsql] = sym_keyword_plpgsql,
  [sym_keyword_immutable] = sym_keyword_immutable,
  [sym_keyword_stable] = sym_keyword_stable,
  [sym_keyword_volatile] = sym_keyword_volatile,
  [sym_keyword_leakproof] = sym_keyword_leakproof,
  [sym_keyword_parallel] = sym_keyword_parallel,
  [sym_keyword_safe] = sym_keyword_safe,
  [sym_keyword_unsafe] = sym_keyword_unsafe,
  [sym_keyword_restricted] = sym_keyword_restricted,
  [sym_keyword_called] = sym_keyword_called,
  [sym_keyword_input] = sym_keyword_input,
  [sym_keyword_strict] = sym_keyword_strict,
  [sym_keyword_cost] = sym_keyword_cost,
  [sym_keyword_support] = sym_keyword_support,
  [sym_keyword_external] = sym_keyword_external,
  [sym_keyword_stored] = sym_keyword_stored,
  [sym_keyword_virtual] = sym_keyword_virtual,
  [sym_keyword_cached] = sym_keyword_cached,
  [sym_keyword_uncached] = sym_keyword_uncached,
  [sym_keyword_replication] = sym_keyword_replication,
  [sym_keyword_tblproperties] = sym_keyword_tblproperties,
  [sym_keyword_options] = sym_keyword_options,
  [sym_keyword_compute] = sym_keyword_compute,
  [sym_keyword_stats] = sym_keyword_stats,
  [sym_keyword_statistics] = sym_keyword_statistics,
  [sym_keyword_optimize] = sym_keyword_optimize,
  [sym_keyword_rewrite] = sym_keyword_rewrite,
  [sym_keyword_bin_pack] = sym_keyword_bin_pack,
  [sym_keyword_incremental] = sym_keyword_incremental,
  [sym_keyword_location] = sym_keyword_location,
  [sym_keyword_partitioned] = sym_keyword_partitioned,
  [sym_keyword_comment] = sym_keyword_comment,
  [sym_keyword_sort] = sym_keyword_sort,
  [sym_keyword_format] = sym_keyword_format,
  [sym_keyword_delimited] = sym_keyword_delimited,
  [sym_keyword_fields] = sym_keyword_fields,
  [sym_keyword_terminated] = sym_keyword_terminated,
  [sym_keyword_escaped] = sym_keyword_escaped,
  [sym_keyword_lines] = sym_keyword_lines,
  [sym_keyword_cache] = sym_keyword_cache,
  [sym_keyword_metadata] = sym_keyword_metadata,
  [sym_keyword_noscan] = sym_keyword_noscan,
  [sym_keyword_parquet] = sym_keyword_parquet,
  [sym_keyword_rcfile] = sym_keyword_rcfile,
  [sym_keyword_csv] = sym_keyword_csv,
  [sym_keyword_textfile] = sym_keyword_textfile,
  [sym_keyword_avro] = sym_keyword_avro,
  [sym_keyword_sequencefile] = sym_keyword_sequencefile,
  [sym_keyword_orc] = sym_keyword_orc,
  [sym_keyword_jsonfile] = sym_keyword_jsonfile,
  [sym_keyword_null] = sym_keyword_null,
  [sym_keyword_true] = sym_keyword_true,
  [sym_keyword_false] = sym_keyword_false,
  [sym_keyword_boolean] = sym_keyword_boolean,
  [sym_keyword_bit] = sym_keyword_bit,
  [sym_keyword_binary] = sym_keyword_binary,
  [sym_keyword_varbinary] = sym_keyword_varbinary,
  [sym_keyword_image] = sym_keyword_image,
  [aux_sym_keyword_smallserial_token1] = aux_sym_keyword_smallserial_token1,
  [aux_sym_keyword_smallserial_token2] = aux_sym_keyword_smallserial_token2,
  [aux_sym_keyword_serial_token1] = aux_sym_keyword_serial_token1,
  [aux_sym_keyword_serial_token2] = aux_sym_keyword_serial_token2,
  [aux_sym_keyword_bigserial_token1] = aux_sym_keyword_bigserial_token1,
  [aux_sym_keyword_bigserial_token2] = aux_sym_keyword_bigserial_token2,
  [aux_sym_keyword_tinyint_token1] = aux_sym_keyword_tinyint_token1,
  [aux_sym_keyword_tinyint_token2] = aux_sym_keyword_tinyint_token2,
  [aux_sym_keyword_smallint_token1] = aux_sym_keyword_smallint_token1,
  [aux_sym_keyword_smallint_token2] = aux_sym_keyword_smallint_token2,
  [aux_sym_keyword_mediumint_token1] = aux_sym_keyword_mediumint_token1,
  [aux_sym_keyword_mediumint_token2] = aux_sym_keyword_mediumint_token2,
  [aux_sym_keyword_int_token1] = aux_sym_keyword_int_token1,
  [aux_sym_keyword_int_token2] = aux_sym_keyword_int_token2,
  [aux_sym_keyword_int_token3] = aux_sym_keyword_int_token3,
  [aux_sym_keyword_bigint_token1] = aux_sym_keyword_bigint_token1,
  [aux_sym_keyword_bigint_token2] = aux_sym_keyword_bigint_token2,
  [sym_keyword_decimal] = sym_keyword_decimal,
  [sym_keyword_numeric] = sym_keyword_numeric,
  [aux_sym_keyword_real_token1] = aux_sym_keyword_real_token1,
  [aux_sym_keyword_real_token2] = aux_sym_keyword_real_token2,
  [sym_keyword_float] = sym_keyword_float,
  [sym_keyword_double] = sym_keyword_double,
  [sym_keyword_precision] = sym_keyword_precision,
  [sym_keyword_inet] = sym_keyword_inet,
  [sym_keyword_money] = sym_keyword_money,
  [sym_keyword_smallmoney] = sym_keyword_smallmoney,
  [sym_keyword_varying] = sym_keyword_varying,
  [aux_sym_keyword_char_token1] = aux_sym_keyword_char_token1,
  [sym_keyword_nchar] = sym_keyword_nchar,
  [aux_sym_keyword_varchar_token1] = aux_sym_keyword_varchar_token1,
  [sym_keyword_nvarchar] = sym_keyword_nvarchar,
  [sym_keyword_text] = sym_keyword_text,
  [sym_keyword_string] = sym_keyword_string,
  [sym_keyword_uuid] = sym_keyword_uuid,
  [sym_keyword_json] = sym_keyword_json,
  [sym_keyword_jsonb] = sym_keyword_jsonb,
  [sym_keyword_xml] = sym_keyword_xml,
  [sym_keyword_bytea] = sym_keyword_bytea,
  [sym_keyword_enum] = sym_keyword_enum,
  [sym_keyword_date] = sym_keyword_date,
  [sym_keyword_datetime] = sym_keyword_datetime,
  [sym_keyword_datetime2] = sym_keyword_datetime2,
  [sym_keyword_smalldatetime] = sym_keyword_smalldatetime,
  [sym_keyword_datetimeoffset] = sym_keyword_datetimeoffset,
  [aux_sym_keyword_time_token1] = aux_sym_keyword_time_token1,
  [aux_sym_keyword_timestamp_token1] = aux_sym_keyword_timestamp_token1,
  [aux_sym_keyword_timestamp_token2] = aux_sym_keyword_timestamp_token2,
  [aux_sym_keyword_timestamp_token3] = aux_sym_keyword_timestamp_token3,
  [aux_sym_keyword_timestamptz_token1] = aux_sym_keyword_timestamptz_token1,
  [sym_keyword_interval] = sym_keyword_interval,
  [sym_keyword_geometry] = sym_keyword_geometry,
  [sym_keyword_geography] = sym_keyword_geography,
  [sym_keyword_box2d] = sym_keyword_box2d,
  [sym_keyword_box3d] = sym_keyword_box3d,
  [sym_keyword_oid] = sym_keyword_oid,
  [sym_keyword_name] = sym_keyword_name,
  [sym_keyword_regclass] = sym_keyword_regclass,
  [sym_keyword_regnamespace] = sym_keyword_regnamespace,
  [sym_keyword_regproc] = sym_keyword_regproc,
  [sym_keyword_regtype] = sym_keyword_regtype,
  [sym_keyword_array] = sym_keyword_array,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [aux_sym_double_token1] = aux_sym_double_token1,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [anon_sym_SLASH_STAR] = anon_sym_SLASH_STAR,
  [aux_sym_marginalia_token1] = aux_sym_marginalia_token1,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOLLAR_DOLLAR] = anon_sym_DOLLAR_DOLLAR,
  [anon_sym_DOLLARfunction_DOLLAR] = anon_sym_DOLLARfunction_DOLLAR,
  [anon_sym_DOLLARbody_DOLLAR] = anon_sym_DOLLARbody_DOLLAR,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_parameter_token1] = aux_sym_parameter_token1,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_millennium] = anon_sym_millennium,
  [anon_sym_century] = anon_sym_century,
  [anon_sym_decade] = anon_sym_decade,
  [anon_sym_year] = anon_sym_year,
  [anon_sym_month] = anon_sym_month,
  [anon_sym_week] = anon_sym_week,
  [anon_sym_day] = anon_sym_day,
  [anon_sym_hour] = anon_sym_hour,
  [anon_sym_minute] = anon_sym_minute,
  [anon_sym_second] = anon_sym_second,
  [anon_sym_millisecond] = anon_sym_millisecond,
  [anon_sym_microsecond] = anon_sym_microsecond,
  [anon_sym_y] = anon_sym_y,
  [anon_sym_m] = anon_sym_m,
  [anon_sym_d] = anon_sym_d,
  [anon_sym_H] = anon_sym_H,
  [anon_sym_M] = anon_sym_M,
  [anon_sym_S] = anon_sym_S,
  [anon_sym_years] = anon_sym_years,
  [anon_sym_months] = anon_sym_months,
  [anon_sym_weeks] = anon_sym_weeks,
  [anon_sym_days] = anon_sym_days,
  [anon_sym_hours] = anon_sym_hours,
  [anon_sym_minutes] = anon_sym_minutes,
  [anon_sym_seconds] = anon_sym_seconds,
  [anon_sym_ago] = anon_sym_ago,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_POUND_GT] = anon_sym_POUND_GT,
  [anon_sym_POUND_GT_GT] = anon_sym_POUND_GT_GT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__double_quote_string_token1] = aux_sym__double_quote_string_token1,
  [aux_sym__single_quote_string_token1] = aux_sym__single_quote_string_token1,
  [sym__natural_number] = sym__natural_number,
  [sym_bang] = sym_bang,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [sym_program] = sym_program,
  [sym_keyword_character] = sym_keyword_character,
  [sym_keyword_with] = sym_keyword_with,
  [sym_keyword_like] = sym_keyword_like,
  [sym_is_not] = sym_is_not,
  [sym_not_like] = sym_not_like,
  [sym_similar_to] = sym_similar_to,
  [sym_not_similar_to] = sym_not_similar_to,
  [sym_distinct_from] = sym_distinct_from,
  [sym_not_distinct_from] = sym_not_distinct_from,
  [sym__temporary] = sym__temporary,
  [sym__not_null] = sym__not_null,
  [sym__primary_key] = sym__primary_key,
  [sym__if_exists] = sym__if_exists,
  [sym__if_not_exists] = sym__if_not_exists,
  [sym__or_replace] = sym__or_replace,
  [sym__current_row] = sym__current_row,
  [sym__exclude_current_row] = sym__exclude_current_row,
  [sym__exclude_group] = sym__exclude_group,
  [sym__exclude_no_others] = sym__exclude_no_others,
  [sym__exclude_ties] = sym__exclude_ties,
  [sym__check_option] = sym__check_option,
  [sym_direction] = sym_direction,
  [sym_keyword_smallserial] = sym_keyword_smallserial,
  [sym_keyword_serial] = sym_keyword_serial,
  [sym_keyword_bigserial] = sym_keyword_bigserial,
  [sym_keyword_tinyint] = sym_keyword_tinyint,
  [sym_keyword_smallint] = sym_keyword_smallint,
  [sym_keyword_mediumint] = sym_keyword_mediumint,
  [sym_keyword_int] = sym_keyword_int,
  [sym_keyword_bigint] = sym_keyword_bigint,
  [sym_keyword_real] = sym_keyword_real,
  [sym_keyword_char] = sym_keyword_char,
  [sym_keyword_varchar] = sym_keyword_varchar,
  [sym_keyword_time] = sym_keyword_time,
  [sym_keyword_timestamp] = sym_keyword_timestamp,
  [sym_keyword_timestamptz] = sym_keyword_timestamptz,
  [sym__type] = sym__type,
  [sym_array_size_definition] = sym_array_size_definition,
  [sym__array_size_definition] = sym__array_size_definition,
  [sym_tinyint] = sym_tinyint,
  [sym_smallint] = sym_smallint,
  [sym_mediumint] = sym_mediumint,
  [sym_int] = sym_int,
  [sym_bigint] = sym_bigint,
  [sym_bit] = sym_bit,
  [sym_binary] = sym_binary,
  [sym_varbinary] = sym_varbinary,
  [sym_float] = sym_float,
  [sym_double] = sym_double,
  [sym_decimal] = sym_decimal,
  [sym_numeric] = sym_numeric,
  [sym_char] = sym_char,
  [sym_varchar] = sym_varchar,
  [sym_nchar] = sym_nchar,
  [sym_nvarchar] = sym_nvarchar,
  [sym_datetimeoffset] = sym_datetimeoffset,
  [sym_time] = sym_time,
  [sym_enum] = sym_enum,
  [sym_array] = sym_array,
  [sym_comment] = sym_comment,
  [sym_marginalia] = sym_marginalia,
  [sym_transaction] = sym_transaction,
  [sym__commit] = sym__commit,
  [sym__rollback] = sym__rollback,
  [sym_block] = sym_block,
  [sym_statement] = sym_statement,
  [sym__ddl_statement] = sym__ddl_statement,
  [sym__cte] = sym__cte,
  [sym__dml_write] = sym__dml_write,
  [sym__dml_read] = sym__dml_read,
  [sym_cte] = sym_cte,
  [sym_set_operation] = sym_set_operation,
  [sym__select_statement] = sym__select_statement,
  [sym_comment_statement] = sym_comment_statement,
  [sym__comment_target] = sym__comment_target,
  [sym_select] = sym_select,
  [sym_select_expression] = sym_select_expression,
  [sym_term] = sym_term,
  [sym__truncate_statement] = sym__truncate_statement,
  [sym__delete_statement] = sym__delete_statement,
  [sym__delete_from] = sym_from,
  [sym_delete] = sym_delete,
  [sym__create_statement] = sym__create_statement,
  [sym__table_settings] = sym__table_settings,
  [sym_create_table] = sym_create_table,
  [sym_create_query] = sym_create_query,
  [sym_create_view] = sym_create_view,
  [sym_create_materialized_view] = sym_create_materialized_view,
  [sym_dollar_quote] = sym_dollar_quote,
  [sym_create_function] = sym_create_function,
  [sym__function_return] = sym__function_return,
  [sym_function_declaration] = sym_function_declaration,
  [sym__function_body_statement] = sym__function_body_statement,
  [sym_function_body] = sym_function_body,
  [sym_function_language] = sym_function_language,
  [sym_function_volatility] = sym_function_volatility,
  [sym_function_leakproof] = sym_function_leakproof,
  [sym_function_safety] = sym_function_safety,
  [sym_function_strictness] = sym_function_strictness,
  [sym_function_cost] = sym_function_cost,
  [sym_function_rows] = sym_function_rows,
  [sym_function_support] = sym_function_support,
  [sym_create_index] = sym_create_index,
  [sym_create_schema] = sym_create_schema,
  [sym__with_settings] = sym__with_settings,
  [sym_create_database] = sym_create_database,
  [sym_create_role] = sym_create_role,
  [sym__role_options] = sym__role_options,
  [sym__user_access_role_config] = sym__user_access_role_config,
  [sym_create_sequence] = sym_create_sequence,
  [sym_create_type] = sym_create_type,
  [sym_enum_elements] = sym_enum_elements,
  [sym__alter_statement] = sym__alter_statement,
  [sym__rename_statement] = sym__rename_statement,
  [sym__rename_table_names] = sym__rename_table_names,
  [sym_alter_table] = sym_alter_table,
  [sym__alter_specifications] = sym__alter_specifications,
  [sym_add_column] = sym_add_column,
  [sym_add_constraint] = sym_add_constraint,
  [sym_alter_column] = sym_alter_column,
  [sym_modify_column] = sym_modify_column,
  [sym_change_column] = sym_change_column,
  [sym_column_position] = sym_column_position,
  [sym_drop_column] = sym_drop_column,
  [sym_rename_column] = sym_rename_column,
  [sym_alter_view] = sym_alter_view,
  [sym_alter_schema] = sym_alter_schema,
  [sym_alter_database] = sym_alter_database,
  [sym_alter_role] = sym_alter_role,
  [sym_set_configuration] = sym_set_configuration,
  [sym_alter_index] = sym_alter_index,
  [sym_alter_sequence] = sym_alter_sequence,
  [sym_alter_type] = sym_alter_type,
  [sym__drop_behavior] = sym__drop_behavior,
  [sym__drop_statement] = sym__drop_statement,
  [sym_drop_table] = sym_drop_table,
  [sym_drop_view] = sym_drop_view,
  [sym_drop_schema] = sym_drop_schema,
  [sym_drop_database] = sym_drop_database,
  [sym_drop_role] = sym_drop_role,
  [sym_drop_type] = sym_drop_type,
  [sym_drop_sequence] = sym_drop_sequence,
  [sym_drop_index] = sym_drop_index,
  [sym_rename_object] = sym_rename_object,
  [sym_set_schema] = sym_set_schema,
  [sym_change_ownership] = sym_change_ownership,
  [sym_object_reference] = sym_object_reference,
  [sym__insert_statement] = sym__insert_statement,
  [sym_insert] = sym_insert,
  [sym__insert_values] = sym__insert_values,
  [sym__set_values] = sym__set_values,
  [sym__column_list] = sym_list,
  [sym__column] = sym__column,
  [sym__update_statement] = sym__update_statement,
  [sym__merge_statement] = sym__merge_statement,
  [sym_when_clause] = sym_when_clause,
  [sym__optimize_statement] = sym__optimize_statement,
  [sym__compute_stats] = sym__compute_stats,
  [sym__optimize_table] = sym__optimize_table,
  [sym__vacuum_table] = sym__vacuum_table,
  [sym__vacuum_option] = sym__vacuum_option,
  [sym__partition_spec] = sym__partition_spec,
  [sym_update] = sym_update,
  [sym__mysql_update_statement] = sym__mysql_update_statement,
  [sym__postgres_update_statement] = sym__postgres_update_statement,
  [sym_storage_location] = sym_storage_location,
  [sym_row_format] = sym_row_format,
  [sym_table_sort] = sym_table_sort,
  [sym_table_partition] = sym_table_partition,
  [sym__key_value_pair] = sym__key_value_pair,
  [sym_stored_as] = sym_stored_as,
  [sym_assignment] = sym_assignment,
  [sym_table_option] = sym_table_option,
  [sym_column_definitions] = sym_column_definitions,
  [sym_column_definition] = sym_column_definition,
  [sym__column_comment] = sym__column_comment,
  [sym__column_constraint] = sym__column_constraint,
  [sym__default_expression] = sym__default_expression,
  [sym__inner_default_expression] = sym__inner_default_expression,
  [sym_constraints] = sym_constraints,
  [sym_constraint] = sym_constraint,
  [sym__constraint_literal] = sym__constraint_literal,
  [sym__primary_key_constraint] = sym__primary_key_constraint,
  [sym__key_constraint] = sym__key_constraint,
  [sym_ordered_columns] = sym_ordered_columns,
  [sym_ordered_column] = sym_ordered_column,
  [sym_all_fields] = sym_all_fields,
  [sym_parameter] = sym_parameter,
  [sym_case] = sym_case,
  [sym_field] = sym_field,
  [sym__qualified_field] = sym_field,
  [sym_implicit_cast] = sym_cast,
  [sym_interval_definitions] = sym_interval_definitions,
  [sym__interval_definition] = sym__interval_definition,
  [sym_interval] = sym_interval,
  [sym_cast] = sym_cast,
  [sym_filter_expression] = sym_filter_expression,
  [sym_invocation] = sym_invocation,
  [sym_exists] = sym_exists,
  [sym_partition_by] = sym_partition_by,
  [sym_frame_definition] = sym_frame_definition,
  [sym_window_frame] = sym_window_frame,
  [sym_window_clause] = sym_window_clause,
  [sym_window_specification] = sym_window_specification,
  [sym_window_function] = sym_window_function,
  [sym__alias] = sym__alias,
  [sym_from] = sym_from,
  [sym_relation] = sym_relation,
  [sym_values] = sym_values,
  [sym_index_hint] = sym_index_hint,
  [sym_join] = sym_join,
  [sym_cross_join] = sym_cross_join,
  [sym_lateral_join] = sym_lateral_join,
  [sym_lateral_cross_join] = sym_lateral_cross_join,
  [sym_where] = sym_where,
  [sym_group_by] = sym_group_by,
  [sym__having] = sym__having,
  [sym_order_by] = sym_order_by,
  [sym_order_target] = sym_order_target,
  [sym_limit] = sym_limit,
  [sym_offset] = sym_offset,
  [sym_returning] = sym_returning,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_between_expression] = sym_between_expression,
  [sym_not_in] = sym_not_in,
  [sym_subquery] = sym_subquery,
  [sym_list] = sym_list,
  [sym_literal] = sym_literal,
  [sym__double_quote_string] = sym__double_quote_string,
  [sym__single_quote_string] = sym__single_quote_string,
  [sym__literal_string] = sym__literal_string,
  [sym__integer] = sym__integer,
  [sym__decimal_number] = sym__decimal_number,
  [sym_identifier] = sym_identifier,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_array_size_definition_repeat1] = aux_sym_array_size_definition_repeat1,
  [aux_sym_enum_repeat1] = aux_sym_enum_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_transaction_repeat1] = aux_sym_transaction_repeat1,
  [aux_sym__cte_repeat1] = aux_sym__cte_repeat1,
  [aux_sym_cte_repeat1] = aux_sym_cte_repeat1,
  [aux_sym_set_operation_repeat1] = aux_sym_set_operation_repeat1,
  [aux_sym_select_expression_repeat1] = aux_sym_select_expression_repeat1,
  [aux_sym__truncate_statement_repeat1] = aux_sym__truncate_statement_repeat1,
  [aux_sym__create_statement_repeat1] = aux_sym__create_statement_repeat1,
  [aux_sym__table_settings_repeat1] = aux_sym__table_settings_repeat1,
  [aux_sym_create_table_repeat1] = aux_sym_create_table_repeat1,
  [aux_sym_create_view_repeat1] = aux_sym_create_view_repeat1,
  [aux_sym_create_function_repeat1] = aux_sym_create_function_repeat1,
  [aux_sym_function_body_repeat1] = aux_sym_function_body_repeat1,
  [aux_sym_function_body_repeat2] = aux_sym_function_body_repeat2,
  [aux_sym_create_database_repeat1] = aux_sym_create_database_repeat1,
  [aux_sym_create_role_repeat1] = aux_sym_create_role_repeat1,
  [aux_sym_create_sequence_repeat1] = aux_sym_create_sequence_repeat1,
  [aux_sym_create_type_repeat1] = aux_sym_create_type_repeat1,
  [aux_sym_enum_elements_repeat1] = aux_sym_enum_elements_repeat1,
  [aux_sym__rename_statement_repeat1] = aux_sym__rename_statement_repeat1,
  [aux_sym_alter_table_repeat1] = aux_sym_alter_table_repeat1,
  [aux_sym_alter_role_repeat1] = aux_sym_alter_role_repeat1,
  [aux_sym_alter_index_repeat1] = aux_sym_alter_index_repeat1,
  [aux_sym_alter_sequence_repeat1] = aux_sym_alter_sequence_repeat1,
  [aux_sym__insert_values_repeat1] = aux_sym__insert_values_repeat1,
  [aux_sym__set_values_repeat1] = aux_sym__set_values_repeat1,
  [aux_sym__column_list_repeat1] = aux_sym__column_list_repeat1,
  [aux_sym__merge_statement_repeat1] = aux_sym__merge_statement_repeat1,
  [aux_sym__compute_stats_repeat1] = aux_sym__compute_stats_repeat1,
  [aux_sym__compute_stats_repeat2] = aux_sym__compute_stats_repeat2,
  [aux_sym__vacuum_table_repeat1] = aux_sym__vacuum_table_repeat1,
  [aux_sym__mysql_update_statement_repeat1] = aux_sym__mysql_update_statement_repeat1,
  [aux_sym__mysql_update_statement_repeat2] = aux_sym__mysql_update_statement_repeat2,
  [aux_sym_table_partition_repeat1] = aux_sym_table_partition_repeat1,
  [aux_sym_column_definitions_repeat1] = aux_sym_column_definitions_repeat1,
  [aux_sym_column_definition_repeat1] = aux_sym_column_definition_repeat1,
  [aux_sym_constraints_repeat1] = aux_sym_constraints_repeat1,
  [aux_sym__key_constraint_repeat1] = aux_sym__key_constraint_repeat1,
  [aux_sym_ordered_columns_repeat1] = aux_sym_ordered_columns_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_interval_definitions_repeat1] = aux_sym_interval_definitions_repeat1,
  [aux_sym_invocation_repeat1] = aux_sym_invocation_repeat1,
  [aux_sym_from_repeat1] = aux_sym_from_repeat1,
  [aux_sym_order_by_repeat1] = aux_sym_order_by_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_keyword_select] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_delete] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_insert] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_update] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_truncate] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_merge] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_into] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_overwrite] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_values] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_value] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_matched] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_set] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_from] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_left] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_right] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_inner] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_full] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_outer] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cross] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_join] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_lateral] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_natural] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_on] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_where] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_order] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_group] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_partition] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_by] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_having] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_desc] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_asc] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_limit] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_offset] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_primary] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_create] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_alter] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_change] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_analyze] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_explain] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_verbose] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_modify] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_drop] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_add] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_table] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_tables] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_view] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_column] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_columns] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_materialized] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_tablespace] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_increment] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_minvalue] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_maxvalue] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_none] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_owned] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_start] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_restart] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_key] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_as] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_distinct] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_max] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_min] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_avg] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_case] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_when] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_then] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_else] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_end] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_in] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_and] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_or] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_is] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_not] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_force] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_ignore] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_using] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_use] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_index] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_for] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_if] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_auto_increment] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_generated] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_always] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_collate] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_character_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_keyword_engine] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_default] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cascade] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_restrict] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_with_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_keyword_no] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_data] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_rename] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_to] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_database] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_schema] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_owner] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_user] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_admin] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_password] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_encrypted] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_valid] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_until] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_connection] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_role] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_reset] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_temp] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_temporary] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_unlogged] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_logged] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cycle] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_union] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_all] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_any] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_some] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_except] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_intersect] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_returning] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_commit] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_rollback] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_transaction] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_over] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_nulls] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_first] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_after] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_before] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_last] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_window] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_range] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_rows] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_groups] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_between] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_unbounded] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_preceding] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_following] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_exclude] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_current] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_row] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_ties] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_others] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_only] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_unique] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_foreign] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_references] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_concurrently] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_btree] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_hash] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_gist] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_spgist] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_gin] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_brin] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_like_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_like_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_keyword_similar] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_preserve] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_unsigned] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_zerofill] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_conflict] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_do] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_nothing] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_high_priority] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_low_priority] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_delayed] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_recursive] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cascaded] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_local] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_current_timestamp] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_check] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_option] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_vacuum] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_wait] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_nowait] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_authorization] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_action] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_trigger] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_function] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_returns] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_return] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_setof] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_atomic] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_declare] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_language] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_sql] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_plpgsql] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_immutable] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_stable] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_volatile] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_leakproof] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_parallel] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_safe] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_unsafe] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_restricted] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_called] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_input] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_strict] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cost] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_support] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_external] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_stored] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_virtual] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cached] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_uncached] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_replication] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_tblproperties] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_options] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_compute] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_stats] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_statistics] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_optimize] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_rewrite] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bin_pack] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_incremental] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_location] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_partitioned] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_sort] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_format] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_delimited] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_fields] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_terminated] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_escaped] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_lines] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_cache] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_metadata] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_noscan] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_parquet] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_rcfile] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_csv] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_textfile] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_avro] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_sequencefile] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_orc] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_jsonfile] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_null] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_true] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_false] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bit] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_varbinary] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_image] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_smallserial_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_smallserial_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_serial_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_serial_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_bigserial_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_bigserial_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_tinyint_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_tinyint_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_smallint_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_smallint_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_mediumint_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_mediumint_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_int_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_int_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_int_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_bigint_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_bigint_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_keyword_decimal] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_numeric] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_real_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_real_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_keyword_float] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_double] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_precision] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_inet] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_money] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_smallmoney] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_varying] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_char_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_keyword_nchar] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_varchar_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_keyword_nvarchar] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_text] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_string] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_uuid] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_json] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_jsonb] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_xml] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bytea] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_date] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_datetime] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_datetime2] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_smalldatetime] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_datetimeoffset] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_keyword_time_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_timestamp_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_timestamp_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_timestamp_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyword_timestamptz_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_keyword_interval] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_geometry] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_geography] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_box2d] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_box3d] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_oid] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_name] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_regclass] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_regnamespace] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_regproc] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_regtype] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_array] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_double_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_marginalia_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARfunction_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARbody_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parameter_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_millennium] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_century] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decade] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_year] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_month] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_week] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_day] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hour] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minute] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_second] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_millisecond] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_microsecond] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_y] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_m] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_H] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_M] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_S] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_years] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_months] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_weeks] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_days] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hours] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minutes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_seconds] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ago] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__double_quote_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__single_quote_string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__natural_number] = {
    .visible = false,
    .named = true,
  },
  [sym_bang] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_character] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_with] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_like] = {
    .visible = true,
    .named = true,
  },
  [sym_is_not] = {
    .visible = true,
    .named = true,
  },
  [sym_not_like] = {
    .visible = true,
    .named = true,
  },
  [sym_similar_to] = {
    .visible = true,
    .named = true,
  },
  [sym_not_similar_to] = {
    .visible = true,
    .named = true,
  },
  [sym_distinct_from] = {
    .visible = true,
    .named = true,
  },
  [sym_not_distinct_from] = {
    .visible = true,
    .named = true,
  },
  [sym__temporary] = {
    .visible = false,
    .named = true,
  },
  [sym__not_null] = {
    .visible = false,
    .named = true,
  },
  [sym__primary_key] = {
    .visible = false,
    .named = true,
  },
  [sym__if_exists] = {
    .visible = false,
    .named = true,
  },
  [sym__if_not_exists] = {
    .visible = false,
    .named = true,
  },
  [sym__or_replace] = {
    .visible = false,
    .named = true,
  },
  [sym__current_row] = {
    .visible = false,
    .named = true,
  },
  [sym__exclude_current_row] = {
    .visible = false,
    .named = true,
  },
  [sym__exclude_group] = {
    .visible = false,
    .named = true,
  },
  [sym__exclude_no_others] = {
    .visible = false,
    .named = true,
  },
  [sym__exclude_ties] = {
    .visible = false,
    .named = true,
  },
  [sym__check_option] = {
    .visible = false,
    .named = true,
  },
  [sym_direction] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_smallserial] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_serial] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bigserial] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_tinyint] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_smallint] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_mediumint] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_int] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_bigint] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_real] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_char] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_varchar] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_time] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_timestamp] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_timestamptz] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_array_size_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__array_size_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_tinyint] = {
    .visible = true,
    .named = true,
  },
  [sym_smallint] = {
    .visible = true,
    .named = true,
  },
  [sym_mediumint] = {
    .visible = true,
    .named = true,
  },
  [sym_int] = {
    .visible = true,
    .named = true,
  },
  [sym_bigint] = {
    .visible = true,
    .named = true,
  },
  [sym_bit] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_varbinary] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_double] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal] = {
    .visible = true,
    .named = true,
  },
  [sym_numeric] = {
    .visible = true,
    .named = true,
  },
  [sym_char] = {
    .visible = true,
    .named = true,
  },
  [sym_varchar] = {
    .visible = true,
    .named = true,
  },
  [sym_nchar] = {
    .visible = true,
    .named = true,
  },
  [sym_nvarchar] = {
    .visible = true,
    .named = true,
  },
  [sym_datetimeoffset] = {
    .visible = true,
    .named = true,
  },
  [sym_time] = {
    .visible = true,
    .named = true,
  },
  [sym_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_marginalia] = {
    .visible = true,
    .named = true,
  },
  [sym_transaction] = {
    .visible = true,
    .named = true,
  },
  [sym__commit] = {
    .visible = false,
    .named = true,
  },
  [sym__rollback] = {
    .visible = false,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__ddl_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__cte] = {
    .visible = false,
    .named = true,
  },
  [sym__dml_write] = {
    .visible = false,
    .named = true,
  },
  [sym__dml_read] = {
    .visible = false,
    .named = true,
  },
  [sym_cte] = {
    .visible = true,
    .named = true,
  },
  [sym_set_operation] = {
    .visible = true,
    .named = true,
  },
  [sym__select_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_comment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_target] = {
    .visible = false,
    .named = true,
  },
  [sym_select] = {
    .visible = true,
    .named = true,
  },
  [sym_select_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym__truncate_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__delete_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__delete_from] = {
    .visible = true,
    .named = true,
  },
  [sym_delete] = {
    .visible = true,
    .named = true,
  },
  [sym__create_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__table_settings] = {
    .visible = false,
    .named = true,
  },
  [sym_create_table] = {
    .visible = true,
    .named = true,
  },
  [sym_create_query] = {
    .visible = true,
    .named = true,
  },
  [sym_create_view] = {
    .visible = true,
    .named = true,
  },
  [sym_create_materialized_view] = {
    .visible = true,
    .named = true,
  },
  [sym_dollar_quote] = {
    .visible = true,
    .named = true,
  },
  [sym_create_function] = {
    .visible = true,
    .named = true,
  },
  [sym__function_return] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__function_body_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function_language] = {
    .visible = true,
    .named = true,
  },
  [sym_function_volatility] = {
    .visible = true,
    .named = true,
  },
  [sym_function_leakproof] = {
    .visible = true,
    .named = true,
  },
  [sym_function_safety] = {
    .visible = true,
    .named = true,
  },
  [sym_function_strictness] = {
    .visible = true,
    .named = true,
  },
  [sym_function_cost] = {
    .visible = true,
    .named = true,
  },
  [sym_function_rows] = {
    .visible = true,
    .named = true,
  },
  [sym_function_support] = {
    .visible = true,
    .named = true,
  },
  [sym_create_index] = {
    .visible = true,
    .named = true,
  },
  [sym_create_schema] = {
    .visible = true,
    .named = true,
  },
  [sym__with_settings] = {
    .visible = false,
    .named = true,
  },
  [sym_create_database] = {
    .visible = true,
    .named = true,
  },
  [sym_create_role] = {
    .visible = true,
    .named = true,
  },
  [sym__role_options] = {
    .visible = false,
    .named = true,
  },
  [sym__user_access_role_config] = {
    .visible = false,
    .named = true,
  },
  [sym_create_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_create_type] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_elements] = {
    .visible = true,
    .named = true,
  },
  [sym__alter_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__rename_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__rename_table_names] = {
    .visible = false,
    .named = true,
  },
  [sym_alter_table] = {
    .visible = true,
    .named = true,
  },
  [sym__alter_specifications] = {
    .visible = false,
    .named = true,
  },
  [sym_add_column] = {
    .visible = true,
    .named = true,
  },
  [sym_add_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_column] = {
    .visible = true,
    .named = true,
  },
  [sym_modify_column] = {
    .visible = true,
    .named = true,
  },
  [sym_change_column] = {
    .visible = true,
    .named = true,
  },
  [sym_column_position] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_column] = {
    .visible = true,
    .named = true,
  },
  [sym_rename_column] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_view] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_schema] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_database] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_role] = {
    .visible = true,
    .named = true,
  },
  [sym_set_configuration] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_index] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_type] = {
    .visible = true,
    .named = true,
  },
  [sym__drop_behavior] = {
    .visible = false,
    .named = true,
  },
  [sym__drop_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_drop_table] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_view] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_schema] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_database] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_role] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_type] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_index] = {
    .visible = true,
    .named = true,
  },
  [sym_rename_object] = {
    .visible = true,
    .named = true,
  },
  [sym_set_schema] = {
    .visible = true,
    .named = true,
  },
  [sym_change_ownership] = {
    .visible = true,
    .named = true,
  },
  [sym_object_reference] = {
    .visible = true,
    .named = true,
  },
  [sym__insert_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_insert] = {
    .visible = true,
    .named = true,
  },
  [sym__insert_values] = {
    .visible = false,
    .named = true,
  },
  [sym__set_values] = {
    .visible = false,
    .named = true,
  },
  [sym__column_list] = {
    .visible = true,
    .named = true,
  },
  [sym__column] = {
    .visible = false,
    .named = true,
  },
  [sym__update_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__merge_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_when_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__optimize_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__compute_stats] = {
    .visible = false,
    .named = true,
  },
  [sym__optimize_table] = {
    .visible = false,
    .named = true,
  },
  [sym__vacuum_table] = {
    .visible = false,
    .named = true,
  },
  [sym__vacuum_option] = {
    .visible = false,
    .named = true,
  },
  [sym__partition_spec] = {
    .visible = false,
    .named = true,
  },
  [sym_update] = {
    .visible = true,
    .named = true,
  },
  [sym__mysql_update_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__postgres_update_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_storage_location] = {
    .visible = true,
    .named = true,
  },
  [sym_row_format] = {
    .visible = true,
    .named = true,
  },
  [sym_table_sort] = {
    .visible = true,
    .named = true,
  },
  [sym_table_partition] = {
    .visible = true,
    .named = true,
  },
  [sym__key_value_pair] = {
    .visible = false,
    .named = true,
  },
  [sym_stored_as] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_table_option] = {
    .visible = true,
    .named = true,
  },
  [sym_column_definitions] = {
    .visible = true,
    .named = true,
  },
  [sym_column_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__column_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__column_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym__default_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__inner_default_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_constraints] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym__constraint_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__primary_key_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym__key_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym_ordered_columns] = {
    .visible = true,
    .named = true,
  },
  [sym_ordered_column] = {
    .visible = true,
    .named = true,
  },
  [sym_all_fields] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__qualified_field] = {
    .visible = true,
    .named = true,
  },
  [sym_implicit_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_interval_definitions] = {
    .visible = true,
    .named = true,
  },
  [sym__interval_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_interval] = {
    .visible = true,
    .named = true,
  },
  [sym_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_filter_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_partition_by] = {
    .visible = true,
    .named = true,
  },
  [sym_frame_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_window_frame] = {
    .visible = true,
    .named = true,
  },
  [sym_window_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_window_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_window_function] = {
    .visible = true,
    .named = true,
  },
  [sym__alias] = {
    .visible = false,
    .named = true,
  },
  [sym_from] = {
    .visible = true,
    .named = true,
  },
  [sym_relation] = {
    .visible = true,
    .named = true,
  },
  [sym_values] = {
    .visible = true,
    .named = true,
  },
  [sym_index_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_join] = {
    .visible = true,
    .named = true,
  },
  [sym_cross_join] = {
    .visible = true,
    .named = true,
  },
  [sym_lateral_join] = {
    .visible = true,
    .named = true,
  },
  [sym_lateral_cross_join] = {
    .visible = true,
    .named = true,
  },
  [sym_where] = {
    .visible = true,
    .named = true,
  },
  [sym_group_by] = {
    .visible = true,
    .named = true,
  },
  [sym__having] = {
    .visible = false,
    .named = true,
  },
  [sym_order_by] = {
    .visible = true,
    .named = true,
  },
  [sym_order_target] = {
    .visible = true,
    .named = true,
  },
  [sym_limit] = {
    .visible = true,
    .named = true,
  },
  [sym_offset] = {
    .visible = true,
    .named = true,
  },
  [sym_returning] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_between_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_not_in] = {
    .visible = true,
    .named = true,
  },
  [sym_subquery] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__double_quote_string] = {
    .visible = false,
    .named = true,
  },
  [sym__single_quote_string] = {
    .visible = false,
    .named = true,
  },
  [sym__literal_string] = {
    .visible = false,
    .named = true,
  },
  [sym__integer] = {
    .visible = false,
    .named = true,
  },
  [sym__decimal_number] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_size_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_transaction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__cte_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cte_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_operation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__truncate_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__create_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__table_settings_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_table_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_view_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_function_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_database_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_role_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__rename_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_alter_table_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_alter_role_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_alter_index_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_alter_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__insert_values_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__set_values_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__column_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__merge_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__compute_stats_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__compute_stats_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__vacuum_table_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__mysql_update_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__mysql_update_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_partition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_column_definitions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_column_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constraints_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__key_constraint_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ordered_columns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interval_definitions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_invocation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_from_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alias = 1,
  field_argument = 2,
  field_cache = 3,
  field_col_name = 4,
  field_column = 5,
  field_configuration_parameter = 6,
  field_connection_limit = 7,
  field_custom_type = 8,
  field_end = 9,
  field_enum_element = 10,
  field_escaped_char = 11,
  field_fields_terminated_char = 12,
  field_high = 13,
  field_increment = 14,
  field_index_name = 15,
  field_key = 16,
  field_left = 17,
  field_low = 18,
  field_name = 19,
  field_new_name = 20,
  field_old_name = 21,
  field_operand = 22,
  field_operation = 23,
  field_operator = 24,
  field_option = 25,
  field_parameter = 26,
  field_password = 27,
  field_path = 28,
  field_pool = 29,
  field_precision = 30,
  field_predicate = 31,
  field_restart = 32,
  field_right = 33,
  field_row_terminated_char = 34,
  field_scale = 35,
  field_schema = 36,
  field_size = 37,
  field_start = 38,
  field_timeout = 39,
  field_type = 40,
  field_valid_until = 41,
  field_value = 42,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_argument] = "argument",
  [field_cache] = "cache",
  [field_col_name] = "col_name",
  [field_column] = "column",
  [field_configuration_parameter] = "configuration_parameter",
  [field_connection_limit] = "connection_limit",
  [field_custom_type] = "custom_type",
  [field_end] = "end",
  [field_enum_element] = "enum_element",
  [field_escaped_char] = "escaped_char",
  [field_fields_terminated_char] = "fields_terminated_char",
  [field_high] = "high",
  [field_increment] = "increment",
  [field_index_name] = "index_name",
  [field_key] = "key",
  [field_left] = "left",
  [field_low] = "low",
  [field_name] = "name",
  [field_new_name] = "new_name",
  [field_old_name] = "old_name",
  [field_operand] = "operand",
  [field_operation] = "operation",
  [field_operator] = "operator",
  [field_option] = "option",
  [field_parameter] = "parameter",
  [field_password] = "password",
  [field_path] = "path",
  [field_pool] = "pool",
  [field_precision] = "precision",
  [field_predicate] = "predicate",
  [field_restart] = "restart",
  [field_right] = "right",
  [field_row_terminated_char] = "row_terminated_char",
  [field_scale] = "scale",
  [field_schema] = "schema",
  [field_size] = "size",
  [field_start] = "start",
  [field_timeout] = "timeout",
  [field_type] = "type",
  [field_valid_until] = "valid_until",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 3},
  [2] = {.index = 3, .length = 1},
  [3] = {.index = 4, .length = 2},
  [4] = {.index = 6, .length = 1},
  [5] = {.index = 7, .length = 1},
  [6] = {.index = 8, .length = 1},
  [7] = {.index = 9, .length = 3},
  [8] = {.index = 12, .length = 1},
  [9] = {.index = 13, .length = 2},
  [10] = {.index = 15, .length = 2},
  [11] = {.index = 17, .length = 1},
  [12] = {.index = 18, .length = 1},
  [14] = {.index = 19, .length = 3},
  [15] = {.index = 22, .length = 1},
  [16] = {.index = 23, .length = 1},
  [17] = {.index = 24, .length = 2},
  [18] = {.index = 26, .length = 1},
  [19] = {.index = 27, .length = 3},
  [20] = {.index = 30, .length = 1},
  [21] = {.index = 31, .length = 2},
  [22] = {.index = 33, .length = 4},
  [23] = {.index = 37, .length = 1},
  [24] = {.index = 38, .length = 4},
  [25] = {.index = 42, .length = 3},
  [26] = {.index = 45, .length = 2},
  [27] = {.index = 47, .length = 2},
  [28] = {.index = 49, .length = 3},
  [29] = {.index = 52, .length = 3},
  [30] = {.index = 55, .length = 1},
  [31] = {.index = 56, .length = 1},
  [32] = {.index = 57, .length = 2},
  [33] = {.index = 59, .length = 1},
  [34] = {.index = 60, .length = 1},
  [35] = {.index = 61, .length = 1},
  [37] = {.index = 62, .length = 1},
  [38] = {.index = 63, .length = 1},
  [39] = {.index = 64, .length = 1},
  [40] = {.index = 65, .length = 4},
  [41] = {.index = 69, .length = 8},
  [42] = {.index = 77, .length = 1},
  [43] = {.index = 78, .length = 3},
  [44] = {.index = 81, .length = 1},
  [45] = {.index = 82, .length = 1},
  [46] = {.index = 83, .length = 1},
  [47] = {.index = 84, .length = 6},
  [48] = {.index = 90, .length = 2},
  [49] = {.index = 92, .length = 2},
  [50] = {.index = 92, .length = 2},
  [51] = {.index = 94, .length = 4},
  [52] = {.index = 98, .length = 1},
  [53] = {.index = 99, .length = 1},
  [54] = {.index = 100, .length = 2},
  [55] = {.index = 102, .length = 3},
  [56] = {.index = 105, .length = 1},
  [57] = {.index = 106, .length = 6},
  [58] = {.index = 112, .length = 1},
  [59] = {.index = 113, .length = 1},
  [61] = {.index = 114, .length = 1},
  [62] = {.index = 115, .length = 1},
  [63] = {.index = 116, .length = 2},
  [64] = {.index = 118, .length = 2},
  [65] = {.index = 120, .length = 4},
  [66] = {.index = 124, .length = 1},
  [67] = {.index = 125, .length = 2},
  [68] = {.index = 127, .length = 1},
  [69] = {.index = 128, .length = 1},
  [70] = {.index = 129, .length = 3},
  [71] = {.index = 132, .length = 2},
  [72] = {.index = 134, .length = 1},
  [73] = {.index = 135, .length = 1},
  [74] = {.index = 136, .length = 1},
  [75] = {.index = 137, .length = 1},
  [76] = {.index = 138, .length = 2},
  [77] = {.index = 140, .length = 1},
  [78] = {.index = 141, .length = 1},
  [79] = {.index = 142, .length = 1},
  [80] = {.index = 138, .length = 2},
  [81] = {.index = 143, .length = 3},
  [82] = {.index = 146, .length = 1},
  [83] = {.index = 147, .length = 1},
  [84] = {.index = 148, .length = 1},
  [85] = {.index = 149, .length = 1},
  [87] = {.index = 150, .length = 1},
  [89] = {.index = 151, .length = 1},
  [90] = {.index = 152, .length = 2},
  [91] = {.index = 154, .length = 2},
  [92] = {.index = 156, .length = 2},
  [93] = {.index = 59, .length = 1},
  [94] = {.index = 158, .length = 2},
  [95] = {.index = 160, .length = 1},
  [96] = {.index = 161, .length = 1},
  [97] = {.index = 160, .length = 1},
  [98] = {.index = 161, .length = 1},
  [99] = {.index = 162, .length = 5},
  [100] = {.index = 167, .length = 1},
  [101] = {.index = 168, .length = 1},
  [102] = {.index = 169, .length = 1},
  [103] = {.index = 170, .length = 1},
  [104] = {.index = 171, .length = 1},
  [105] = {.index = 172, .length = 2},
  [106] = {.index = 174, .length = 4},
  [107] = {.index = 178, .length = 4},
  [108] = {.index = 182, .length = 2},
  [109] = {.index = 184, .length = 2},
  [110] = {.index = 186, .length = 1},
  [111] = {.index = 187, .length = 1},
  [112] = {.index = 188, .length = 2},
  [113] = {.index = 190, .length = 4},
  [114] = {.index = 194, .length = 2},
  [115] = {.index = 196, .length = 2},
  [116] = {.index = 198, .length = 1},
  [117] = {.index = 199, .length = 2},
  [120] = {.index = 201, .length = 1},
  [122] = {.index = 114, .length = 1},
  [123] = {.index = 202, .length = 2},
  [124] = {.index = 59, .length = 1},
  [125] = {.index = 204, .length = 1},
  [126] = {.index = 205, .length = 1},
  [127] = {.index = 206, .length = 1},
  [128] = {.index = 207, .length = 2},
  [129] = {.index = 209, .length = 2},
  [130] = {.index = 211, .length = 1},
  [131] = {.index = 212, .length = 1},
  [132] = {.index = 213, .length = 2},
  [133] = {.index = 215, .length = 4},
  [134] = {.index = 219, .length = 1},
  [135] = {.index = 220, .length = 1},
  [136] = {.index = 221, .length = 2},
  [137] = {.index = 223, .length = 1},
  [138] = {.index = 224, .length = 2},
  [139] = {.index = 226, .length = 1},
  [140] = {.index = 227, .length = 1},
  [141] = {.index = 228, .length = 2},
  [142] = {.index = 230, .length = 1},
  [143] = {.index = 231, .length = 2},
  [146] = {.index = 233, .length = 1},
  [148] = {.index = 114, .length = 1},
  [149] = {.index = 234, .length = 2},
  [150] = {.index = 236, .length = 1},
  [151] = {.index = 237, .length = 4},
  [152] = {.index = 241, .length = 2},
  [153] = {.index = 243, .length = 2},
  [154] = {.index = 245, .length = 4},
  [155] = {.index = 249, .length = 2},
  [156] = {.index = 251, .length = 2},
  [157] = {.index = 253, .length = 1},
  [158] = {.index = 254, .length = 2},
  [160] = {.index = 256, .length = 1},
  [163] = {.index = 257, .length = 1},
  [164] = {.index = 258, .length = 2},
  [165] = {.index = 260, .length = 1},
  [166] = {.index = 261, .length = 3},
  [167] = {.index = 264, .length = 1},
  [168] = {.index = 265, .length = 1},
  [169] = {.index = 266, .length = 2},
  [170] = {.index = 268, .length = 1},
  [172] = {.index = 269, .length = 2},
  [174] = {.index = 257, .length = 1},
  [175] = {.index = 271, .length = 2},
  [176] = {.index = 273, .length = 2},
  [177] = {.index = 275, .length = 1},
  [178] = {.index = 276, .length = 2},
  [179] = {.index = 278, .length = 2},
  [180] = {.index = 280, .length = 2},
  [181] = {.index = 257, .length = 1},
  [182] = {.index = 271, .length = 2},
  [183] = {.index = 282, .length = 3},
  [184] = {.index = 285, .length = 3},
  [185] = {.index = 288, .length = 1},
  [186] = {.index = 271, .length = 2},
  [187] = {.index = 289, .length = 2},
  [188] = {.index = 291, .length = 2},
  [189] = {.index = 293, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_alias, 0, .inherited = true},
    {field_predicate, 0, .inherited = true},
    {field_timeout, 0, .inherited = true},
  [3] =
    {field_timeout, 0, .inherited = true},
  [4] =
    {field_alias, 0, .inherited = true},
    {field_predicate, 0, .inherited = true},
  [6] =
    {field_value, 0},
  [7] =
    {field_name, 0, .inherited = true},
  [8] =
    {field_name, 0},
  [9] =
    {field_alias, 1, .inherited = true},
    {field_predicate, 1, .inherited = true},
    {field_timeout, 1, .inherited = true},
  [12] =
    {field_operation, 1, .inherited = true},
  [13] =
    {field_operand, 1},
    {field_operator, 0},
  [15] =
    {field_alias, 1, .inherited = true},
    {field_value, 0},
  [17] =
    {field_alias, 0},
  [18] =
    {field_alias, 1, .inherited = true},
  [19] =
    {field_alias, 2, .inherited = true},
    {field_predicate, 2, .inherited = true},
    {field_timeout, 2, .inherited = true},
  [22] =
    {field_name, 2},
  [23] =
    {field_operation, 0},
  [24] =
    {field_operation, 0, .inherited = true},
    {field_operation, 1, .inherited = true},
  [26] =
    {field_alias, 1},
  [27] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [30] =
    {field_custom_type, 0},
  [31] =
    {field_name, 2},
    {field_schema, 0},
  [33] =
    {field_connection_limit, 0, .inherited = true},
    {field_option, 0, .inherited = true},
    {field_password, 0, .inherited = true},
    {field_valid_until, 0, .inherited = true},
  [37] =
    {field_option, 0},
  [38] =
    {field_connection_limit, 3, .inherited = true},
    {field_option, 3, .inherited = true},
    {field_password, 3, .inherited = true},
    {field_valid_until, 3, .inherited = true},
  [42] =
    {field_cache, 3, .inherited = true},
    {field_increment, 3, .inherited = true},
    {field_start, 3, .inherited = true},
  [45] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [47] =
    {field_name, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [49] =
    {field_cache, 3, .inherited = true},
    {field_restart, 3, .inherited = true},
    {field_start, 3, .inherited = true},
  [52] =
    {field_alias, 3, .inherited = true},
    {field_predicate, 3, .inherited = true},
    {field_timeout, 3, .inherited = true},
  [55] =
    {field_name, 3},
  [56] =
    {field_name, 1, .inherited = true},
  [57] =
    {field_operation, 0},
    {field_operation, 1},
  [59] =
    {field_parameter, 2},
  [60] =
    {field_size, 0, .inherited = true},
  [61] =
    {field_alias, 3},
  [62] =
    {field_alias, 3, .inherited = true},
  [63] =
    {field_predicate, 1},
  [64] =
    {field_password, 1},
  [65] =
    {field_connection_limit, 4, .inherited = true},
    {field_option, 4, .inherited = true},
    {field_password, 4, .inherited = true},
    {field_valid_until, 4, .inherited = true},
  [69] =
    {field_connection_limit, 0, .inherited = true},
    {field_connection_limit, 1, .inherited = true},
    {field_option, 0, .inherited = true},
    {field_option, 1, .inherited = true},
    {field_password, 0, .inherited = true},
    {field_password, 1, .inherited = true},
    {field_valid_until, 0, .inherited = true},
    {field_valid_until, 1, .inherited = true},
  [77] =
    {field_path, 1},
  [78] =
    {field_cache, 4, .inherited = true},
    {field_increment, 4, .inherited = true},
    {field_start, 4, .inherited = true},
  [81] =
    {field_increment, 1},
  [82] =
    {field_start, 1},
  [83] =
    {field_cache, 1},
  [84] =
    {field_cache, 0, .inherited = true},
    {field_cache, 1, .inherited = true},
    {field_increment, 0, .inherited = true},
    {field_increment, 1, .inherited = true},
    {field_start, 0, .inherited = true},
    {field_start, 1, .inherited = true},
  [90] =
    {field_name, 4, .inherited = true},
    {field_value, 4, .inherited = true},
  [92] =
    {field_name, 0},
    {field_value, 1},
  [94] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [98] =
    {field_option, 4},
  [99] =
    {field_name, 1},
  [100] =
    {field_name, 0},
    {field_type, 1},
  [102] =
    {field_cache, 4, .inherited = true},
    {field_restart, 4, .inherited = true},
    {field_start, 4, .inherited = true},
  [105] =
    {field_restart, 1},
  [106] =
    {field_cache, 0, .inherited = true},
    {field_cache, 1, .inherited = true},
    {field_restart, 0, .inherited = true},
    {field_restart, 1, .inherited = true},
    {field_start, 0, .inherited = true},
    {field_start, 1, .inherited = true},
  [112] =
    {field_configuration_parameter, 4},
  [113] =
    {field_name, 4},
  [114] =
    {field_parameter, 3},
  [115] =
    {field_parameter, 1},
  [116] =
    {field_parameter, 2},
    {field_parameter, 3, .inherited = true},
  [118] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [120] =
    {field_high, 4},
    {field_left, 0},
    {field_low, 2},
    {field_operator, 1},
  [124] =
    {field_size, 1, .inherited = true},
  [125] =
    {field_size, 0, .inherited = true},
    {field_size, 1, .inherited = true},
  [127] =
    {field_index_name, 3},
  [128] =
    {field_alias, 4},
  [129] =
    {field_left, 0},
    {field_name, 0, .inherited = true},
    {field_right, 2},
  [132] =
    {field_key, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [134] =
    {field_predicate, 3},
  [135] =
    {field_password, 2},
  [136] =
    {field_valid_until, 2},
  [137] =
    {field_connection_limit, 2},
  [138] =
    {field_name, 0},
    {field_value, 2},
  [140] =
    {field_increment, 2},
  [141] =
    {field_start, 2},
  [142] =
    {field_column, 2},
  [143] =
    {field_cache, 5, .inherited = true},
    {field_increment, 5, .inherited = true},
    {field_start, 5, .inherited = true},
  [146] =
    {field_schema, 2},
  [147] =
    {field_old_name, 1},
  [148] =
    {field_col_name, 1},
  [149] =
    {field_restart, 2},
  [150] =
    {field_configuration_parameter, 5},
  [151] =
    {field_argument, 1},
  [152] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [154] =
    {field_name, 0},
    {field_parameter, 2},
  [156] =
    {field_parameter, 3},
    {field_parameter, 4, .inherited = true},
  [158] =
    {field_parameter, 2},
    {field_parameter, 4, .inherited = true},
  [160] =
    {field_start, 0},
  [161] =
    {field_end, 0},
  [162] =
    {field_high, 5},
    {field_left, 0},
    {field_low, 3},
    {field_operator, 1},
    {field_operator, 2},
  [167] =
    {field_size, 1},
  [168] =
    {field_precision, 2},
  [169] =
    {field_size, 2},
  [170] =
    {field_value, 2},
  [171] =
    {field_alias, 5},
  [172] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [174] =
    {field_key, 2, .inherited = true},
    {field_key, 3, .inherited = true},
    {field_value, 2, .inherited = true},
    {field_value, 3, .inherited = true},
  [178] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [182] =
    {field_key, 0},
    {field_value, 2},
  [184] =
    {field_key, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [186] =
    {field_predicate, 4},
  [187] =
    {field_column, 3},
  [188] =
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [190] =
    {field_name, 4, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_value, 4, .inherited = true},
    {field_value, 5, .inherited = true},
  [194] =
    {field_option, 0},
    {field_parameter, 2},
  [196] =
    {field_name, 1},
    {field_type, 3},
  [198] =
    {field_old_name, 2},
  [199] =
    {field_new_name, 3},
    {field_old_name, 1},
  [201] =
    {field_timeout, 4},
  [202] =
    {field_parameter, 3},
    {field_parameter, 5, .inherited = true},
  [204] =
    {field_size, 3},
  [205] =
    {field_precision, 3},
  [206] =
    {field_value, 1},
  [207] =
    {field_value, 2},
    {field_value, 3, .inherited = true},
  [209] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [211] =
    {field_index_name, 5},
  [212] =
    {field_alias, 6},
  [213] =
    {field_key, 4, .inherited = true},
    {field_value, 4, .inherited = true},
  [215] =
    {field_key, 3, .inherited = true},
    {field_key, 4, .inherited = true},
    {field_value, 3, .inherited = true},
    {field_value, 4, .inherited = true},
  [219] =
    {field_predicate, 5},
  [220] =
    {field_predicate, 6},
  [221] =
    {field_path, 1},
    {field_pool, 4},
  [223] =
    {field_column, 4},
  [224] =
    {field_name, 6, .inherited = true},
    {field_value, 6, .inherited = true},
  [226] =
    {field_enum_element, 1},
  [227] =
    {field_option, 7},
  [228] =
    {field_name, 2},
    {field_type, 4},
  [230] =
    {field_old_name, 3},
  [231] =
    {field_new_name, 4},
    {field_old_name, 2},
  [233] =
    {field_timeout, 5},
  [234] =
    {field_precision, 2},
    {field_scale, 4},
  [236] =
    {field_alias, 7},
  [237] =
    {field_key, 4, .inherited = true},
    {field_key, 5, .inherited = true},
    {field_value, 4, .inherited = true},
    {field_value, 5, .inherited = true},
  [241] =
    {field_alias, 5, .inherited = true},
    {field_predicate, 7},
  [243] =
    {field_alias, 3, .inherited = true},
    {field_predicate, 7},
  [245] =
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
    {field_value, 6, .inherited = true},
    {field_value, 7, .inherited = true},
  [249] =
    {field_enum_element, 1},
    {field_enum_element, 2, .inherited = true},
  [251] =
    {field_enum_element, 0, .inherited = true},
    {field_enum_element, 1, .inherited = true},
  [253] =
    {field_column, 5},
  [254] =
    {field_name, 1},
    {field_type, 5},
  [256] =
    {field_value, 7},
  [257] =
    {field_argument, 2},
  [258] =
    {field_precision, 3},
    {field_scale, 5},
  [260] =
    {field_predicate, 7},
  [261] =
    {field_alias, 3, .inherited = true},
    {field_alias, 6, .inherited = true},
    {field_predicate, 8},
  [264] =
    {field_fields_terminated_char, 6},
  [265] =
    {field_row_terminated_char, 6},
  [266] =
    {field_name, 2},
    {field_type, 6},
  [268] =
    {field_value, 8},
  [269] =
    {field_value, 7},
    {field_value, 8, .inherited = true},
  [271] =
    {field_argument, 2},
    {field_argument, 3, .inherited = true},
  [273] =
    {field_precision, 4},
    {field_scale, 6},
  [275] =
    {field_predicate, 8},
  [276] =
    {field_alias, 5, .inherited = true},
    {field_predicate, 8},
  [278] =
    {field_alias, 3, .inherited = true},
    {field_predicate, 8},
  [280] =
    {field_value, 8},
    {field_value, 9, .inherited = true},
  [282] =
    {field_alias, 3, .inherited = true},
    {field_alias, 6, .inherited = true},
    {field_predicate, 9},
  [285] =
    {field_path, 1},
    {field_pool, 4},
    {field_value, 8},
  [288] =
    {field_value, 3},
  [289] =
    {field_escaped_char, 9},
    {field_fields_terminated_char, 6},
  [291] =
    {field_fields_terminated_char, 6},
    {field_row_terminated_char, 10},
  [293] =
    {field_escaped_char, 9},
    {field_fields_terminated_char, 6},
    {field_row_terminated_char, 13},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [13] = {
    [0] = sym_literal,
  },
  [31] = {
    [1] = sym_object_reference,
  },
  [36] = {
    [1] = sym_ordered_column,
  },
  [39] = {
    [1] = sym_literal,
  },
  [42] = {
    [1] = sym_literal,
  },
  [44] = {
    [1] = sym_literal,
  },
  [45] = {
    [1] = sym_literal,
  },
  [46] = {
    [1] = sym_literal,
  },
  [49] = {
    [1] = sym_literal,
  },
  [56] = {
    [1] = sym_literal,
  },
  [60] = {
    [4] = sym_literal,
  },
  [73] = {
    [2] = sym_literal,
  },
  [74] = {
    [2] = sym_literal,
  },
  [75] = {
    [2] = sym_literal,
  },
  [77] = {
    [2] = sym_literal,
  },
  [78] = {
    [2] = sym_literal,
  },
  [80] = {
    [2] = sym_literal,
  },
  [85] = {
    [2] = sym_literal,
  },
  [86] = {
    [5] = sym_literal,
  },
  [88] = {
    [3] = sym_statement,
  },
  [93] = {
    [4] = sym_literal,
  },
  [97] = {
    [0] = sym_literal,
  },
  [98] = {
    [0] = sym_literal,
  },
  [100] = {
    [1] = sym_literal,
  },
  [101] = {
    [2] = sym_literal,
  },
  [102] = {
    [2] = sym_literal,
  },
  [103] = {
    [2] = sym_literal,
  },
  [108] = {
    [2] = sym_literal,
  },
  [118] = {
    [1] = sym_literal,
  },
  [119] = {
    [6] = sym_literal,
  },
  [120] = {
    [4] = sym_literal,
  },
  [121] = {
    [4] = sym_statement,
  },
  [122] = {
    [5] = sym_literal,
  },
  [124] = {
    [5] = sym_literal,
  },
  [125] = {
    [3] = sym_literal,
  },
  [126] = {
    [3] = sym_literal,
  },
  [127] = {
    [1] = sym_literal,
  },
  [128] = {
    [2] = sym_literal,
  },
  [136] = {
    [1] = sym_literal,
    [4] = sym_literal,
  },
  [139] = {
    [1] = sym_literal,
  },
  [144] = {
    [4] = sym_literal,
    [7] = sym_literal,
  },
  [145] = {
    [5] = sym_literal,
    [7] = sym_literal,
  },
  [146] = {
    [5] = sym_literal,
  },
  [147] = {
    [5] = sym_statement,
  },
  [148] = {
    [6] = sym_literal,
  },
  [149] = {
    [2] = sym_literal,
    [4] = sym_literal,
  },
  [155] = {
    [1] = sym_literal,
  },
  [159] = {
    [5] = sym_literal,
    [8] = sym_literal,
  },
  [161] = {
    [6] = sym_literal,
    [8] = sym_literal,
  },
  [162] = {
    [6] = sym_statement,
  },
  [163] = {
    [6] = sym_statement,
  },
  [164] = {
    [3] = sym_literal,
    [5] = sym_literal,
  },
  [167] = {
    [6] = sym_literal,
  },
  [168] = {
    [6] = sym_literal,
  },
  [171] = {
    [6] = sym_literal,
    [9] = sym_literal,
  },
  [173] = {
    [7] = sym_statement,
  },
  [174] = {
    [7] = sym_statement,
  },
  [175] = {
    [7] = sym_statement,
  },
  [176] = {
    [4] = sym_literal,
    [6] = sym_literal,
  },
  [181] = {
    [8] = sym_statement,
  },
  [182] = {
    [8] = sym_statement,
  },
  [184] = {
    [1] = sym_literal,
    [4] = sym_literal,
    [8] = sym_literal,
  },
  [186] = {
    [9] = sym_statement,
  },
  [187] = {
    [6] = sym_literal,
    [9] = sym_literal,
  },
  [188] = {
    [6] = sym_literal,
    [10] = sym_literal,
  },
  [189] = {
    [6] = sym_literal,
    [9] = sym_literal,
    [13] = sym_literal,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__dml_write, 2,
    sym__dml_write,
    sym_statement,
  sym__dml_read, 2,
    sym__dml_read,
    sym_statement,
  sym__column, 2,
    sym__column,
    sym_ordered_column,
  sym__qualified_field, 2,
    sym_field,
    sym_object_reference,
  sym__single_quote_string, 2,
    sym__single_quote_string,
    sym_literal,
  sym__literal_string, 2,
    sym__literal_string,
    sym_literal,
  sym__integer, 2,
    sym__integer,
    sym_literal,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 6,
  [9] = 7,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 15,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 18,
  [24] = 18,
  [25] = 15,
  [26] = 26,
  [27] = 18,
  [28] = 18,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 15,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 2,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 4,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 5,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 3,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 3,
  [204] = 37,
  [205] = 52,
  [206] = 38,
  [207] = 47,
  [208] = 48,
  [209] = 209,
  [210] = 54,
  [211] = 49,
  [212] = 46,
  [213] = 43,
  [214] = 41,
  [215] = 40,
  [216] = 216,
  [217] = 39,
  [218] = 42,
  [219] = 51,
  [220] = 53,
  [221] = 45,
  [222] = 50,
  [223] = 60,
  [224] = 59,
  [225] = 61,
  [226] = 66,
  [227] = 65,
  [228] = 62,
  [229] = 63,
  [230] = 230,
  [231] = 56,
  [232] = 232,
  [233] = 233,
  [234] = 58,
  [235] = 57,
  [236] = 64,
  [237] = 91,
  [238] = 97,
  [239] = 107,
  [240] = 67,
  [241] = 77,
  [242] = 80,
  [243] = 92,
  [244] = 106,
  [245] = 95,
  [246] = 76,
  [247] = 68,
  [248] = 69,
  [249] = 79,
  [250] = 102,
  [251] = 94,
  [252] = 103,
  [253] = 83,
  [254] = 98,
  [255] = 104,
  [256] = 109,
  [257] = 93,
  [258] = 89,
  [259] = 88,
  [260] = 100,
  [261] = 84,
  [262] = 73,
  [263] = 108,
  [264] = 96,
  [265] = 85,
  [266] = 86,
  [267] = 87,
  [268] = 105,
  [269] = 75,
  [270] = 74,
  [271] = 90,
  [272] = 78,
  [273] = 81,
  [274] = 82,
  [275] = 70,
  [276] = 71,
  [277] = 72,
  [278] = 99,
  [279] = 126,
  [280] = 146,
  [281] = 147,
  [282] = 170,
  [283] = 169,
  [284] = 166,
  [285] = 164,
  [286] = 286,
  [287] = 287,
  [288] = 158,
  [289] = 151,
  [290] = 152,
  [291] = 150,
  [292] = 144,
  [293] = 143,
  [294] = 142,
  [295] = 140,
  [296] = 139,
  [297] = 134,
  [298] = 133,
  [299] = 130,
  [300] = 127,
  [301] = 141,
  [302] = 112,
  [303] = 113,
  [304] = 114,
  [305] = 149,
  [306] = 125,
  [307] = 154,
  [308] = 131,
  [309] = 111,
  [310] = 115,
  [311] = 116,
  [312] = 145,
  [313] = 110,
  [314] = 159,
  [315] = 148,
  [316] = 171,
  [317] = 317,
  [318] = 155,
  [319] = 135,
  [320] = 156,
  [321] = 162,
  [322] = 153,
  [323] = 168,
  [324] = 138,
  [325] = 167,
  [326] = 132,
  [327] = 129,
  [328] = 328,
  [329] = 117,
  [330] = 165,
  [331] = 128,
  [332] = 157,
  [333] = 161,
  [334] = 124,
  [335] = 123,
  [336] = 122,
  [337] = 121,
  [338] = 120,
  [339] = 119,
  [340] = 118,
  [341] = 137,
  [342] = 163,
  [343] = 317,
  [344] = 160,
  [345] = 136,
  [346] = 173,
  [347] = 172,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 353,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 351,
  [360] = 355,
  [361] = 361,
  [362] = 356,
  [363] = 175,
  [364] = 180,
  [365] = 365,
  [366] = 349,
  [367] = 365,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 350,
  [372] = 357,
  [373] = 358,
  [374] = 368,
  [375] = 184,
  [376] = 369,
  [377] = 348,
  [378] = 352,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 197,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 7,
  [391] = 391,
  [392] = 190,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 191,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 6,
  [404] = 395,
  [405] = 405,
  [406] = 406,
  [407] = 405,
  [408] = 37,
  [409] = 46,
  [410] = 388,
  [411] = 399,
  [412] = 52,
  [413] = 397,
  [414] = 396,
  [415] = 415,
  [416] = 416,
  [417] = 394,
  [418] = 418,
  [419] = 402,
  [420] = 401,
  [421] = 421,
  [422] = 400,
  [423] = 42,
  [424] = 393,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 382,
  [430] = 53,
  [431] = 45,
  [432] = 406,
  [433] = 387,
  [434] = 50,
  [435] = 49,
  [436] = 436,
  [437] = 383,
  [438] = 40,
  [439] = 41,
  [440] = 43,
  [441] = 386,
  [442] = 442,
  [443] = 443,
  [444] = 54,
  [445] = 389,
  [446] = 446,
  [447] = 39,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 391,
  [453] = 381,
  [454] = 48,
  [455] = 380,
  [456] = 51,
  [457] = 384,
  [458] = 38,
  [459] = 459,
  [460] = 47,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 64,
  [465] = 63,
  [466] = 62,
  [467] = 66,
  [468] = 61,
  [469] = 56,
  [470] = 5,
  [471] = 471,
  [472] = 57,
  [473] = 58,
  [474] = 4,
  [475] = 60,
  [476] = 2,
  [477] = 477,
  [478] = 59,
  [479] = 65,
  [480] = 406,
  [481] = 91,
  [482] = 71,
  [483] = 70,
  [484] = 69,
  [485] = 436,
  [486] = 416,
  [487] = 402,
  [488] = 74,
  [489] = 108,
  [490] = 396,
  [491] = 68,
  [492] = 99,
  [493] = 73,
  [494] = 397,
  [495] = 84,
  [496] = 451,
  [497] = 380,
  [498] = 82,
  [499] = 88,
  [500] = 81,
  [501] = 78,
  [502] = 89,
  [503] = 393,
  [504] = 93,
  [505] = 94,
  [506] = 90,
  [507] = 428,
  [508] = 67,
  [509] = 471,
  [510] = 97,
  [511] = 399,
  [512] = 400,
  [513] = 401,
  [514] = 427,
  [515] = 382,
  [516] = 105,
  [517] = 103,
  [518] = 104,
  [519] = 83,
  [520] = 383,
  [521] = 442,
  [522] = 75,
  [523] = 386,
  [524] = 421,
  [525] = 96,
  [526] = 418,
  [527] = 384,
  [528] = 425,
  [529] = 426,
  [530] = 100,
  [531] = 415,
  [532] = 87,
  [533] = 459,
  [534] = 86,
  [535] = 102,
  [536] = 391,
  [537] = 85,
  [538] = 381,
  [539] = 109,
  [540] = 95,
  [541] = 98,
  [542] = 106,
  [543] = 92,
  [544] = 544,
  [545] = 443,
  [546] = 80,
  [547] = 389,
  [548] = 77,
  [549] = 388,
  [550] = 461,
  [551] = 463,
  [552] = 79,
  [553] = 387,
  [554] = 76,
  [555] = 394,
  [556] = 72,
  [557] = 446,
  [558] = 450,
  [559] = 107,
  [560] = 462,
  [561] = 449,
  [562] = 448,
  [563] = 133,
  [564] = 125,
  [565] = 149,
  [566] = 3,
  [567] = 158,
  [568] = 5,
  [569] = 141,
  [570] = 166,
  [571] = 169,
  [572] = 127,
  [573] = 112,
  [574] = 121,
  [575] = 170,
  [576] = 142,
  [577] = 113,
  [578] = 146,
  [579] = 171,
  [580] = 130,
  [581] = 140,
  [582] = 156,
  [583] = 126,
  [584] = 147,
  [585] = 153,
  [586] = 151,
  [587] = 117,
  [588] = 118,
  [589] = 152,
  [590] = 2,
  [591] = 119,
  [592] = 131,
  [593] = 143,
  [594] = 120,
  [595] = 111,
  [596] = 114,
  [597] = 164,
  [598] = 150,
  [599] = 4,
  [600] = 144,
  [601] = 154,
  [602] = 138,
  [603] = 134,
  [604] = 132,
  [605] = 145,
  [606] = 168,
  [607] = 122,
  [608] = 123,
  [609] = 124,
  [610] = 163,
  [611] = 167,
  [612] = 135,
  [613] = 129,
  [614] = 128,
  [615] = 157,
  [616] = 136,
  [617] = 477,
  [618] = 618,
  [619] = 165,
  [620] = 137,
  [621] = 148,
  [622] = 139,
  [623] = 161,
  [624] = 160,
  [625] = 159,
  [626] = 155,
  [627] = 162,
  [628] = 110,
  [629] = 116,
  [630] = 173,
  [631] = 172,
  [632] = 115,
  [633] = 633,
  [634] = 634,
  [635] = 175,
  [636] = 636,
  [637] = 184,
  [638] = 180,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 44,
  [651] = 618,
  [652] = 442,
  [653] = 216,
  [654] = 55,
  [655] = 209,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 416,
  [661] = 471,
  [662] = 418,
  [663] = 421,
  [664] = 664,
  [665] = 665,
  [666] = 446,
  [667] = 448,
  [668] = 449,
  [669] = 426,
  [670] = 425,
  [671] = 450,
  [672] = 672,
  [673] = 415,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 462,
  [681] = 681,
  [682] = 428,
  [683] = 463,
  [684] = 427,
  [685] = 451,
  [686] = 436,
  [687] = 461,
  [688] = 459,
  [689] = 443,
  [690] = 618,
  [691] = 190,
  [692] = 641,
  [693] = 6,
  [694] = 233,
  [695] = 642,
  [696] = 643,
  [697] = 639,
  [698] = 644,
  [699] = 355,
  [700] = 640,
  [701] = 646,
  [702] = 679,
  [703] = 197,
  [704] = 353,
  [705] = 352,
  [706] = 678,
  [707] = 675,
  [708] = 677,
  [709] = 634,
  [710] = 649,
  [711] = 356,
  [712] = 232,
  [713] = 647,
  [714] = 648,
  [715] = 636,
  [716] = 191,
  [717] = 633,
  [718] = 357,
  [719] = 44,
  [720] = 358,
  [721] = 645,
  [722] = 7,
  [723] = 664,
  [724] = 656,
  [725] = 681,
  [726] = 676,
  [727] = 665,
  [728] = 659,
  [729] = 674,
  [730] = 230,
  [731] = 216,
  [732] = 658,
  [733] = 657,
  [734] = 209,
  [735] = 55,
  [736] = 672,
  [737] = 369,
  [738] = 350,
  [739] = 349,
  [740] = 348,
  [741] = 368,
  [742] = 477,
  [743] = 365,
  [744] = 645,
  [745] = 657,
  [746] = 233,
  [747] = 647,
  [748] = 672,
  [749] = 640,
  [750] = 642,
  [751] = 643,
  [752] = 644,
  [753] = 633,
  [754] = 664,
  [755] = 639,
  [756] = 230,
  [757] = 665,
  [758] = 648,
  [759] = 636,
  [760] = 681,
  [761] = 674,
  [762] = 659,
  [763] = 658,
  [764] = 676,
  [765] = 641,
  [766] = 232,
  [767] = 649,
  [768] = 656,
  [769] = 679,
  [770] = 678,
  [771] = 675,
  [772] = 677,
  [773] = 634,
  [774] = 646,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 37,
  [790] = 51,
  [791] = 43,
  [792] = 41,
  [793] = 49,
  [794] = 54,
  [795] = 48,
  [796] = 796,
  [797] = 53,
  [798] = 39,
  [799] = 38,
  [800] = 50,
  [801] = 40,
  [802] = 52,
  [803] = 3,
  [804] = 45,
  [805] = 47,
  [806] = 806,
  [807] = 46,
  [808] = 42,
  [809] = 61,
  [810] = 65,
  [811] = 60,
  [812] = 59,
  [813] = 58,
  [814] = 56,
  [815] = 57,
  [816] = 108,
  [817] = 66,
  [818] = 64,
  [819] = 63,
  [820] = 62,
  [821] = 353,
  [822] = 822,
  [823] = 823,
  [824] = 822,
  [825] = 104,
  [826] = 97,
  [827] = 79,
  [828] = 76,
  [829] = 103,
  [830] = 83,
  [831] = 831,
  [832] = 832,
  [833] = 348,
  [834] = 834,
  [835] = 67,
  [836] = 94,
  [837] = 93,
  [838] = 89,
  [839] = 70,
  [840] = 352,
  [841] = 350,
  [842] = 71,
  [843] = 88,
  [844] = 369,
  [845] = 368,
  [846] = 365,
  [847] = 349,
  [848] = 349,
  [849] = 365,
  [850] = 368,
  [851] = 369,
  [852] = 358,
  [853] = 831,
  [854] = 832,
  [855] = 357,
  [856] = 107,
  [857] = 857,
  [858] = 780,
  [859] = 859,
  [860] = 106,
  [861] = 775,
  [862] = 102,
  [863] = 863,
  [864] = 100,
  [865] = 865,
  [866] = 786,
  [867] = 867,
  [868] = 84,
  [869] = 785,
  [870] = 73,
  [871] = 863,
  [872] = 784,
  [873] = 822,
  [874] = 96,
  [875] = 875,
  [876] = 348,
  [877] = 356,
  [878] = 782,
  [879] = 90,
  [880] = 78,
  [881] = 776,
  [882] = 355,
  [883] = 883,
  [884] = 358,
  [885] = 81,
  [886] = 787,
  [887] = 82,
  [888] = 353,
  [889] = 357,
  [890] = 350,
  [891] = 356,
  [892] = 99,
  [893] = 68,
  [894] = 779,
  [895] = 355,
  [896] = 863,
  [897] = 822,
  [898] = 863,
  [899] = 834,
  [900] = 105,
  [901] = 91,
  [902] = 95,
  [903] = 77,
  [904] = 80,
  [905] = 778,
  [906] = 92,
  [907] = 69,
  [908] = 98,
  [909] = 875,
  [910] = 910,
  [911] = 867,
  [912] = 865,
  [913] = 777,
  [914] = 109,
  [915] = 783,
  [916] = 85,
  [917] = 788,
  [918] = 86,
  [919] = 87,
  [920] = 352,
  [921] = 75,
  [922] = 74,
  [923] = 72,
  [924] = 128,
  [925] = 122,
  [926] = 157,
  [927] = 129,
  [928] = 132,
  [929] = 138,
  [930] = 154,
  [931] = 152,
  [932] = 151,
  [933] = 147,
  [934] = 170,
  [935] = 169,
  [936] = 166,
  [937] = 164,
  [938] = 158,
  [939] = 150,
  [940] = 149,
  [941] = 146,
  [942] = 171,
  [943] = 156,
  [944] = 153,
  [945] = 117,
  [946] = 118,
  [947] = 119,
  [948] = 120,
  [949] = 121,
  [950] = 123,
  [951] = 124,
  [952] = 110,
  [953] = 116,
  [954] = 115,
  [955] = 114,
  [956] = 113,
  [957] = 112,
  [958] = 141,
  [959] = 127,
  [960] = 130,
  [961] = 133,
  [962] = 134,
  [963] = 139,
  [964] = 140,
  [965] = 142,
  [966] = 143,
  [967] = 144,
  [968] = 159,
  [969] = 160,
  [970] = 161,
  [971] = 163,
  [972] = 165,
  [973] = 167,
  [974] = 168,
  [975] = 125,
  [976] = 126,
  [977] = 131,
  [978] = 111,
  [979] = 145,
  [980] = 148,
  [981] = 155,
  [982] = 162,
  [983] = 172,
  [984] = 173,
  [985] = 137,
  [986] = 136,
  [987] = 135,
  [988] = 180,
  [989] = 989,
  [990] = 990,
  [991] = 991,
  [992] = 992,
  [993] = 993,
  [994] = 994,
  [995] = 796,
  [996] = 996,
  [997] = 997,
  [998] = 175,
  [999] = 184,
  [1000] = 191,
  [1001] = 190,
  [1002] = 996,
  [1003] = 197,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1006,
  [1010] = 1007,
  [1011] = 1007,
  [1012] = 1007,
  [1013] = 358,
  [1014] = 350,
  [1015] = 348,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 352,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1004,
  [1024] = 1016,
  [1025] = 1025,
  [1026] = 1017,
  [1027] = 1016,
  [1028] = 1025,
  [1029] = 1029,
  [1030] = 1025,
  [1031] = 365,
  [1032] = 1016,
  [1033] = 1021,
  [1034] = 1020,
  [1035] = 353,
  [1036] = 355,
  [1037] = 1037,
  [1038] = 1021,
  [1039] = 356,
  [1040] = 1021,
  [1041] = 1029,
  [1042] = 357,
  [1043] = 1025,
  [1044] = 369,
  [1045] = 1017,
  [1046] = 1017,
  [1047] = 368,
  [1048] = 349,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1050,
  [1052] = 1050,
  [1053] = 1053,
  [1054] = 2,
  [1055] = 1050,
  [1056] = 1053,
  [1057] = 1057,
  [1058] = 1049,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1061,
  [1064] = 1062,
  [1065] = 1065,
  [1066] = 1061,
  [1067] = 1062,
  [1068] = 1062,
  [1069] = 1065,
  [1070] = 1070,
  [1071] = 1062,
  [1072] = 796,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1061,
  [1076] = 7,
  [1077] = 1062,
  [1078] = 1061,
  [1079] = 641,
  [1080] = 1065,
  [1081] = 1081,
  [1082] = 1062,
  [1083] = 1065,
  [1084] = 6,
  [1085] = 1061,
  [1086] = 1073,
  [1087] = 1061,
  [1088] = 1061,
  [1089] = 1073,
  [1090] = 1090,
  [1091] = 1062,
  [1092] = 1008,
  [1093] = 1073,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1104,
  [1114] = 1112,
  [1115] = 1110,
  [1116] = 1109,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1100,
  [1122] = 1122,
  [1123] = 1097,
  [1124] = 1109,
  [1125] = 1108,
  [1126] = 1107,
  [1127] = 1102,
  [1128] = 1128,
  [1129] = 1105,
  [1130] = 1103,
  [1131] = 1131,
  [1132] = 1101,
  [1133] = 1133,
  [1134] = 1102,
  [1135] = 1135,
  [1136] = 1119,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1122,
  [1142] = 1117,
  [1143] = 1143,
  [1144] = 1120,
  [1145] = 1094,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1118,
  [1150] = 1106,
  [1151] = 1128,
  [1152] = 1095,
  [1153] = 1109,
  [1154] = 1120,
  [1155] = 1102,
  [1156] = 1156,
  [1157] = 1143,
  [1158] = 1096,
  [1159] = 1135,
  [1160] = 1140,
  [1161] = 1143,
  [1162] = 1118,
  [1163] = 1163,
  [1164] = 1095,
  [1165] = 1101,
  [1166] = 1103,
  [1167] = 1105,
  [1168] = 1138,
  [1169] = 1107,
  [1170] = 1100,
  [1171] = 1171,
  [1172] = 1104,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1163,
  [1176] = 1112,
  [1177] = 1110,
  [1178] = 1178,
  [1179] = 1094,
  [1180] = 1137,
  [1181] = 1108,
  [1182] = 1107,
  [1183] = 1105,
  [1184] = 1119,
  [1185] = 1103,
  [1186] = 1106,
  [1187] = 1101,
  [1188] = 1108,
  [1189] = 1110,
  [1190] = 1106,
  [1191] = 1119,
  [1192] = 1112,
  [1193] = 1104,
  [1194] = 1194,
  [1195] = 1106,
  [1196] = 1100,
  [1197] = 1138,
  [1198] = 1138,
  [1199] = 1096,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1202,
  [1204] = 1120,
  [1205] = 1200,
  [1206] = 1206,
  [1207] = 1096,
  [1208] = 1140,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 1106,
  [1212] = 1119,
  [1213] = 1202,
  [1214] = 1139,
  [1215] = 1143,
  [1216] = 1171,
  [1217] = 1200,
  [1218] = 1095,
  [1219] = 1102,
  [1220] = 1140,
  [1221] = 1174,
  [1222] = 1118,
  [1223] = 1223,
  [1224] = 1095,
  [1225] = 1101,
  [1226] = 1106,
  [1227] = 1173,
  [1228] = 1103,
  [1229] = 1095,
  [1230] = 1105,
  [1231] = 1095,
  [1232] = 1147,
  [1233] = 1135,
  [1234] = 1109,
  [1235] = 1137,
  [1236] = 1148,
  [1237] = 1102,
  [1238] = 1238,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1131,
  [1242] = 1107,
  [1243] = 1119,
  [1244] = 1108,
  [1245] = 1209,
  [1246] = 1206,
  [1247] = 1146,
  [1248] = 1098,
  [1249] = 1100,
  [1250] = 1135,
  [1251] = 1104,
  [1252] = 1112,
  [1253] = 1110,
  [1254] = 1110,
  [1255] = 1112,
  [1256] = 1108,
  [1257] = 1104,
  [1258] = 1107,
  [1259] = 1105,
  [1260] = 1100,
  [1261] = 1103,
  [1262] = 1101,
  [1263] = 1096,
  [1264] = 1238,
  [1265] = 1201,
  [1266] = 1101,
  [1267] = 1267,
  [1268] = 1135,
  [1269] = 1102,
  [1270] = 1102,
  [1271] = 1210,
  [1272] = 1103,
  [1273] = 1105,
  [1274] = 1109,
  [1275] = 1107,
  [1276] = 1156,
  [1277] = 1109,
  [1278] = 1278,
  [1279] = 1108,
  [1280] = 1110,
  [1281] = 1112,
  [1282] = 1109,
  [1283] = 1104,
  [1284] = 1201,
  [1285] = 1202,
  [1286] = 1131,
  [1287] = 1200,
  [1288] = 1101,
  [1289] = 1100,
  [1290] = 1278,
  [1291] = 1278,
  [1292] = 1119,
  [1293] = 1103,
  [1294] = 1105,
  [1295] = 1133,
  [1296] = 1107,
  [1297] = 1108,
  [1298] = 1110,
  [1299] = 1239,
  [1300] = 1112,
  [1301] = 1173,
  [1302] = 1106,
  [1303] = 1119,
  [1304] = 1095,
  [1305] = 1194,
  [1306] = 1306,
  [1307] = 1100,
  [1308] = 1104,
  [1309] = 1137,
  [1310] = 1240,
  [1311] = 1156,
  [1312] = 1312,
  [1313] = 784,
  [1314] = 471,
  [1315] = 783,
  [1316] = 1008,
  [1317] = 788,
  [1318] = 777,
  [1319] = 782,
  [1320] = 778,
  [1321] = 357,
  [1322] = 369,
  [1323] = 365,
  [1324] = 352,
  [1325] = 355,
  [1326] = 358,
  [1327] = 348,
  [1328] = 356,
  [1329] = 350,
  [1330] = 368,
  [1331] = 353,
  [1332] = 349,
  [1333] = 1008,
  [1334] = 1178,
  [1335] = 1335,
  [1336] = 356,
  [1337] = 349,
  [1338] = 1004,
  [1339] = 350,
  [1340] = 369,
  [1341] = 352,
  [1342] = 348,
  [1343] = 1343,
  [1344] = 365,
  [1345] = 1345,
  [1346] = 353,
  [1347] = 355,
  [1348] = 368,
  [1349] = 357,
  [1350] = 358,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 1353,
  [1354] = 1008,
  [1355] = 1355,
  [1356] = 1355,
  [1357] = 1357,
  [1358] = 1357,
  [1359] = 1355,
  [1360] = 1355,
  [1361] = 1357,
  [1362] = 1362,
  [1363] = 1357,
  [1364] = 1364,
  [1365] = 1365,
  [1366] = 1366,
  [1367] = 1367,
  [1368] = 1368,
  [1369] = 1369,
  [1370] = 1370,
  [1371] = 1371,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1367,
  [1376] = 1376,
  [1377] = 1374,
  [1378] = 1374,
  [1379] = 1379,
  [1380] = 1380,
  [1381] = 1379,
  [1382] = 1369,
  [1383] = 1364,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1366,
  [1388] = 1388,
  [1389] = 1367,
  [1390] = 1390,
  [1391] = 1390,
  [1392] = 1390,
  [1393] = 1393,
  [1394] = 1368,
  [1395] = 1374,
  [1396] = 1371,
  [1397] = 1380,
  [1398] = 1372,
  [1399] = 1384,
  [1400] = 1386,
  [1401] = 1401,
  [1402] = 1402,
  [1403] = 1402,
  [1404] = 1374,
  [1405] = 1390,
  [1406] = 1401,
  [1407] = 1367,
  [1408] = 1343,
  [1409] = 1004,
  [1410] = 1345,
  [1411] = 1004,
  [1412] = 1412,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 382,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1413,
  [1422] = 1415,
  [1423] = 1415,
  [1424] = 1424,
  [1425] = 1414,
  [1426] = 396,
  [1427] = 1420,
  [1428] = 1413,
  [1429] = 397,
  [1430] = 1416,
  [1431] = 399,
  [1432] = 1432,
  [1433] = 383,
  [1434] = 1432,
  [1435] = 389,
  [1436] = 386,
  [1437] = 388,
  [1438] = 1419,
  [1439] = 1419,
  [1440] = 1440,
  [1441] = 1424,
  [1442] = 1442,
  [1443] = 1442,
  [1444] = 400,
  [1445] = 1424,
  [1446] = 1446,
  [1447] = 1413,
  [1448] = 1448,
  [1449] = 1415,
  [1450] = 401,
  [1451] = 1451,
  [1452] = 1448,
  [1453] = 406,
  [1454] = 1440,
  [1455] = 402,
  [1456] = 1432,
  [1457] = 1440,
  [1458] = 1424,
  [1459] = 387,
  [1460] = 1446,
  [1461] = 1440,
  [1462] = 1419,
  [1463] = 1416,
  [1464] = 1420,
  [1465] = 1432,
  [1466] = 1466,
  [1467] = 394,
  [1468] = 391,
  [1469] = 1420,
  [1470] = 1470,
  [1471] = 1448,
  [1472] = 1446,
  [1473] = 384,
  [1474] = 1416,
  [1475] = 1448,
  [1476] = 1446,
  [1477] = 1417,
  [1478] = 1417,
  [1479] = 381,
  [1480] = 393,
  [1481] = 380,
  [1482] = 1417,
  [1483] = 1483,
  [1484] = 1483,
  [1485] = 1485,
  [1486] = 1483,
  [1487] = 1388,
  [1488] = 1483,
  [1489] = 1485,
  [1490] = 1388,
  [1491] = 4,
  [1492] = 1485,
  [1493] = 1483,
  [1494] = 544,
  [1495] = 1495,
  [1496] = 1495,
  [1497] = 471,
  [1498] = 1483,
  [1499] = 1485,
  [1500] = 1483,
  [1501] = 1370,
  [1502] = 1485,
  [1503] = 1376,
  [1504] = 1370,
  [1505] = 1393,
  [1506] = 1485,
  [1507] = 1393,
  [1508] = 1485,
  [1509] = 1485,
  [1510] = 1376,
  [1511] = 5,
  [1512] = 1483,
  [1513] = 448,
  [1514] = 216,
  [1515] = 416,
  [1516] = 459,
  [1517] = 426,
  [1518] = 463,
  [1519] = 450,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 418,
  [1523] = 55,
  [1524] = 421,
  [1525] = 618,
  [1526] = 436,
  [1527] = 449,
  [1528] = 461,
  [1529] = 442,
  [1530] = 462,
  [1531] = 44,
  [1532] = 428,
  [1533] = 425,
  [1534] = 446,
  [1535] = 1535,
  [1536] = 427,
  [1537] = 209,
  [1538] = 415,
  [1539] = 451,
  [1540] = 1540,
  [1541] = 443,
  [1542] = 232,
  [1543] = 633,
  [1544] = 657,
  [1545] = 647,
  [1546] = 640,
  [1547] = 642,
  [1548] = 645,
  [1549] = 659,
  [1550] = 677,
  [1551] = 230,
  [1552] = 675,
  [1553] = 664,
  [1554] = 641,
  [1555] = 681,
  [1556] = 233,
  [1557] = 1557,
  [1558] = 646,
  [1559] = 639,
  [1560] = 656,
  [1561] = 1561,
  [1562] = 658,
  [1563] = 648,
  [1564] = 634,
  [1565] = 644,
  [1566] = 672,
  [1567] = 643,
  [1568] = 665,
  [1569] = 477,
  [1570] = 679,
  [1571] = 649,
  [1572] = 676,
  [1573] = 678,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 636,
  [1577] = 674,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1592,
  [1598] = 1598,
  [1599] = 1596,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1600,
  [1603] = 1603,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1606,
  [1611] = 1611,
  [1612] = 1605,
  [1613] = 1613,
  [1614] = 1059,
  [1615] = 1609,
  [1616] = 1607,
  [1617] = 1611,
  [1618] = 1603,
  [1619] = 1583,
  [1620] = 1580,
  [1621] = 1584,
  [1622] = 1585,
  [1623] = 1588,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1584,
  [1627] = 1587,
  [1628] = 1090,
  [1629] = 1588,
  [1630] = 1580,
  [1631] = 1581,
  [1632] = 1585,
  [1633] = 1587,
  [1634] = 1581,
  [1635] = 1583,
  [1636] = 1636,
  [1637] = 1637,
  [1638] = 1589,
  [1639] = 1639,
  [1640] = 1590,
  [1641] = 1641,
  [1642] = 1586,
  [1643] = 1578,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1649,
  [1655] = 1582,
  [1656] = 1639,
  [1657] = 1657,
  [1658] = 1579,
  [1659] = 1653,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1677,
  [1679] = 1674,
  [1680] = 1680,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1680,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1648,
  [1704] = 1645,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1709,
  [1710] = 1710,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 1717,
  [1718] = 1718,
  [1719] = 1719,
  [1720] = 1720,
  [1721] = 1721,
  [1722] = 1722,
  [1723] = 1723,
  [1724] = 1724,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 1727,
  [1728] = 1728,
  [1729] = 1729,
  [1730] = 1730,
  [1731] = 1731,
  [1732] = 1732,
  [1733] = 1733,
  [1734] = 1734,
  [1735] = 1735,
  [1736] = 1736,
  [1737] = 1737,
  [1738] = 1738,
  [1739] = 1739,
  [1740] = 1740,
  [1741] = 1741,
  [1742] = 1742,
  [1743] = 1743,
  [1744] = 1744,
  [1745] = 1745,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1754,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1760,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 1768,
  [1769] = 1769,
  [1770] = 1768,
  [1771] = 1768,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1773,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1778,
  [1789] = 1789,
  [1790] = 1768,
  [1791] = 1412,
  [1792] = 1743,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1470,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 1466,
  [1801] = 1801,
  [1802] = 1802,
  [1803] = 1803,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1806,
  [1807] = 1807,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1814,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1817,
  [1818] = 1818,
  [1819] = 1819,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 1823,
  [1824] = 1824,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1817,
  [1832] = 1821,
  [1833] = 1833,
  [1834] = 1816,
  [1835] = 1835,
  [1836] = 1836,
  [1837] = 1837,
  [1838] = 1838,
  [1839] = 1822,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1818,
  [1843] = 1843,
  [1844] = 1844,
  [1845] = 1845,
  [1846] = 1846,
  [1847] = 1847,
  [1848] = 1825,
  [1849] = 1849,
  [1850] = 1826,
  [1851] = 1851,
  [1852] = 1852,
  [1853] = 1853,
  [1854] = 1854,
  [1855] = 1855,
  [1856] = 1856,
  [1857] = 1857,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1860,
  [1861] = 1861,
  [1862] = 1833,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1867,
  [1868] = 1868,
  [1869] = 1869,
  [1870] = 1870,
  [1871] = 1871,
  [1872] = 1871,
  [1873] = 1873,
  [1874] = 1874,
  [1875] = 1875,
  [1876] = 1876,
  [1877] = 1877,
  [1878] = 1878,
  [1879] = 1879,
  [1880] = 1880,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1884,
  [1885] = 1885,
  [1886] = 1886,
  [1887] = 1887,
  [1888] = 1888,
  [1889] = 1889,
  [1890] = 1890,
  [1891] = 1891,
  [1892] = 1892,
  [1893] = 1893,
  [1894] = 1894,
  [1895] = 1895,
  [1896] = 1896,
  [1897] = 1897,
  [1898] = 1898,
  [1899] = 1899,
  [1900] = 1900,
  [1901] = 1901,
  [1902] = 1902,
  [1903] = 1903,
  [1904] = 1855,
  [1905] = 1905,
  [1906] = 1906,
  [1907] = 1907,
  [1908] = 1908,
  [1909] = 1909,
  [1910] = 1910,
  [1911] = 1911,
  [1912] = 1912,
  [1913] = 1913,
  [1914] = 1914,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1917,
  [1918] = 1918,
  [1919] = 1919,
  [1920] = 1920,
  [1921] = 1826,
  [1922] = 1922,
  [1923] = 1849,
  [1924] = 1924,
  [1925] = 1925,
  [1926] = 1926,
  [1927] = 1927,
  [1928] = 1928,
  [1929] = 1929,
  [1930] = 1825,
  [1931] = 1931,
  [1932] = 1932,
  [1933] = 1933,
  [1934] = 1934,
  [1935] = 1935,
  [1936] = 1936,
  [1937] = 1937,
  [1938] = 1938,
  [1939] = 1826,
  [1940] = 1940,
  [1941] = 1941,
  [1942] = 1942,
  [1943] = 1943,
  [1944] = 1944,
  [1945] = 1945,
  [1946] = 1946,
  [1947] = 1825,
  [1948] = 1948,
  [1949] = 1949,
  [1950] = 1950,
  [1951] = 1951,
  [1952] = 1952,
  [1953] = 1953,
  [1954] = 1954,
  [1955] = 1955,
  [1956] = 1956,
  [1957] = 1957,
  [1958] = 1958,
  [1959] = 1956,
  [1960] = 1953,
  [1961] = 1961,
  [1962] = 1954,
  [1963] = 1961,
  [1964] = 1964,
  [1965] = 1956,
  [1966] = 1966,
  [1967] = 1951,
  [1968] = 1950,
  [1969] = 1969,
  [1970] = 1966,
  [1971] = 1954,
  [1972] = 1972,
  [1973] = 1951,
  [1974] = 1974,
  [1975] = 1972,
  [1976] = 1950,
  [1977] = 1964,
  [1978] = 1974,
  [1979] = 1969,
  [1980] = 1900,
  [1981] = 1906,
  [1982] = 1982,
  [1983] = 1983,
  [1984] = 1984,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1987,
  [1988] = 1988,
  [1989] = 1989,
  [1990] = 1876,
  [1991] = 1989,
  [1992] = 1992,
  [1993] = 1984,
  [1994] = 1994,
  [1995] = 1995,
  [1996] = 1996,
  [1997] = 1997,
  [1998] = 1996,
  [1999] = 1999,
  [2000] = 2000,
  [2001] = 2001,
  [2002] = 1995,
  [2003] = 1986,
  [2004] = 2004,
  [2005] = 2005,
  [2006] = 2006,
  [2007] = 1988,
  [2008] = 1734,
  [2009] = 2009,
  [2010] = 2010,
  [2011] = 2011,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 2022,
  [2023] = 2023,
  [2024] = 2024,
  [2025] = 2025,
  [2026] = 2019,
  [2027] = 2027,
  [2028] = 2028,
  [2029] = 2029,
  [2030] = 2030,
  [2031] = 2031,
  [2032] = 2032,
  [2033] = 2033,
  [2034] = 2034,
  [2035] = 2035,
  [2036] = 2016,
  [2037] = 2019,
  [2038] = 2017,
  [2039] = 2039,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 2042,
  [2043] = 2043,
  [2044] = 2034,
  [2045] = 2045,
  [2046] = 2046,
  [2047] = 2047,
  [2048] = 2048,
  [2049] = 2049,
  [2050] = 2048,
  [2051] = 2051,
  [2052] = 2052,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 2055,
  [2056] = 2056,
  [2057] = 2057,
  [2058] = 2058,
  [2059] = 2059,
  [2060] = 2060,
  [2061] = 2061,
  [2062] = 2054,
  [2063] = 2063,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 2066,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 2071,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 2075,
  [2076] = 2076,
  [2077] = 2077,
  [2078] = 2063,
  [2079] = 2079,
  [2080] = 2080,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 2084,
  [2085] = 2085,
  [2086] = 2082,
  [2087] = 2087,
  [2088] = 2088,
  [2089] = 2079,
  [2090] = 2090,
  [2091] = 2084,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 2094,
  [2095] = 2095,
  [2096] = 2096,
  [2097] = 2097,
  [2098] = 2098,
  [2099] = 2099,
  [2100] = 2073,
  [2101] = 2101,
  [2102] = 2102,
  [2103] = 2094,
  [2104] = 2104,
  [2105] = 2064,
  [2106] = 2106,
  [2107] = 2107,
  [2108] = 2108,
  [2109] = 2102,
  [2110] = 2107,
  [2111] = 2085,
  [2112] = 2112,
  [2113] = 2113,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2113,
  [2117] = 2113,
  [2118] = 2118,
  [2119] = 2119,
  [2120] = 2120,
  [2121] = 2119,
  [2122] = 2080,
  [2123] = 2123,
  [2124] = 2095,
  [2125] = 2125,
  [2126] = 2126,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 1952,
  [2130] = 2106,
  [2131] = 2131,
  [2132] = 2132,
  [2133] = 2133,
  [2134] = 2064,
  [2135] = 2135,
  [2136] = 2136,
  [2137] = 2066,
  [2138] = 2094,
  [2139] = 2092,
  [2140] = 2056,
  [2141] = 2069,
  [2142] = 2072,
  [2143] = 1952,
  [2144] = 2144,
  [2145] = 2090,
  [2146] = 2093,
  [2147] = 2147,
  [2148] = 2148,
  [2149] = 2097,
  [2150] = 2150,
  [2151] = 2081,
  [2152] = 2152,
  [2153] = 2088,
  [2154] = 2057,
  [2155] = 2155,
  [2156] = 2125,
  [2157] = 2157,
  [2158] = 2090,
  [2159] = 2159,
  [2160] = 2160,
  [2161] = 2159,
  [2162] = 2162,
  [2163] = 2163,
  [2164] = 2164,
  [2165] = 2165,
  [2166] = 2166,
  [2167] = 2167,
  [2168] = 2168,
  [2169] = 2169,
  [2170] = 2170,
  [2171] = 2171,
  [2172] = 2172,
  [2173] = 2173,
  [2174] = 2174,
  [2175] = 2175,
  [2176] = 2165,
  [2177] = 2177,
  [2178] = 2178,
  [2179] = 2179,
  [2180] = 2180,
  [2181] = 2181,
  [2182] = 2182,
  [2183] = 2167,
  [2184] = 2167,
  [2185] = 2185,
  [2186] = 2186,
  [2187] = 2187,
  [2188] = 2188,
  [2189] = 2189,
  [2190] = 2190,
  [2191] = 2191,
  [2192] = 2192,
  [2193] = 2193,
  [2194] = 2194,
  [2195] = 2195,
  [2196] = 2196,
  [2197] = 2197,
  [2198] = 2198,
  [2199] = 2199,
  [2200] = 2200,
  [2201] = 2201,
  [2202] = 2202,
  [2203] = 2203,
  [2204] = 2204,
  [2205] = 2205,
  [2206] = 2206,
  [2207] = 2207,
  [2208] = 2208,
  [2209] = 2209,
  [2210] = 2210,
  [2211] = 2211,
  [2212] = 2212,
  [2213] = 2213,
  [2214] = 2214,
  [2215] = 2215,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 2218,
  [2219] = 2172,
  [2220] = 2220,
  [2221] = 2221,
  [2222] = 2195,
  [2223] = 2223,
  [2224] = 2224,
  [2225] = 2225,
  [2226] = 2190,
  [2227] = 2227,
  [2228] = 2165,
  [2229] = 2229,
  [2230] = 2209,
  [2231] = 2181,
  [2232] = 2232,
  [2233] = 2233,
  [2234] = 2169,
  [2235] = 2235,
  [2236] = 2185,
  [2237] = 2237,
  [2238] = 2159,
  [2239] = 2239,
  [2240] = 2240,
  [2241] = 2241,
  [2242] = 2242,
  [2243] = 2243,
  [2244] = 2244,
  [2245] = 2245,
  [2246] = 2246,
  [2247] = 2178,
  [2248] = 2248,
  [2249] = 2160,
  [2250] = 2250,
  [2251] = 2233,
  [2252] = 2252,
  [2253] = 2253,
  [2254] = 2254,
  [2255] = 2255,
  [2256] = 2248,
  [2257] = 2257,
  [2258] = 2258,
  [2259] = 2168,
  [2260] = 2165,
  [2261] = 2261,
  [2262] = 2196,
  [2263] = 2263,
  [2264] = 2223,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 2167,
  [2268] = 2268,
  [2269] = 2159,
  [2270] = 2270,
  [2271] = 2271,
  [2272] = 2272,
  [2273] = 2273,
  [2274] = 2274,
  [2275] = 2275,
  [2276] = 2193,
  [2277] = 1608,
  [2278] = 2181,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2265,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2175,
  [2285] = 2285,
  [2286] = 2246,
  [2287] = 2287,
  [2288] = 2288,
  [2289] = 2170,
  [2290] = 2290,
  [2291] = 2212,
  [2292] = 2292,
  [2293] = 2191,
  [2294] = 2294,
  [2295] = 2233,
  [2296] = 2296,
  [2297] = 2191,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2168,
  [2305] = 2186,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2308,
  [2309] = 2309,
  [2310] = 2310,
  [2311] = 2311,
  [2312] = 2312,
  [2313] = 2313,
  [2314] = 2314,
  [2315] = 2315,
  [2316] = 2316,
  [2317] = 2317,
  [2318] = 2318,
  [2319] = 2319,
  [2320] = 2320,
  [2321] = 2321,
  [2322] = 2322,
  [2323] = 2323,
  [2324] = 2324,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 2327,
  [2328] = 2328,
  [2329] = 2307,
  [2330] = 2330,
  [2331] = 2331,
  [2332] = 2332,
  [2333] = 2000,
  [2334] = 2334,
  [2335] = 2335,
  [2336] = 2336,
  [2337] = 2337,
  [2338] = 2319,
  [2339] = 2320,
  [2340] = 2340,
  [2341] = 2341,
  [2342] = 2342,
  [2343] = 2343,
  [2344] = 2344,
  [2345] = 2345,
  [2346] = 2346,
  [2347] = 2347,
  [2348] = 2348,
  [2349] = 2349,
  [2350] = 2350,
  [2351] = 2351,
  [2352] = 2352,
  [2353] = 2353,
  [2354] = 2354,
  [2355] = 2355,
  [2356] = 2356,
  [2357] = 2357,
  [2358] = 2358,
  [2359] = 2359,
  [2360] = 2346,
  [2361] = 2361,
  [2362] = 2362,
  [2363] = 2363,
  [2364] = 2364,
  [2365] = 2365,
  [2366] = 2366,
  [2367] = 2367,
  [2368] = 2368,
  [2369] = 2369,
  [2370] = 2370,
  [2371] = 2371,
  [2372] = 2372,
  [2373] = 2373,
  [2374] = 2374,
  [2375] = 2375,
  [2376] = 2376,
  [2377] = 2377,
  [2378] = 2378,
  [2379] = 2379,
  [2380] = 2343,
  [2381] = 2381,
  [2382] = 2382,
  [2383] = 2383,
  [2384] = 2384,
  [2385] = 2385,
  [2386] = 2386,
  [2387] = 2387,
  [2388] = 2388,
  [2389] = 2389,
  [2390] = 2390,
  [2391] = 2336,
  [2392] = 2316,
  [2393] = 2314,
  [2394] = 2394,
  [2395] = 2395,
  [2396] = 2396,
  [2397] = 2343,
  [2398] = 2398,
  [2399] = 2399,
  [2400] = 2400,
  [2401] = 1987,
  [2402] = 2402,
  [2403] = 2363,
  [2404] = 2404,
  [2405] = 2405,
  [2406] = 2406,
  [2407] = 2349,
  [2408] = 2408,
  [2409] = 2319,
  [2410] = 2410,
  [2411] = 2411,
  [2412] = 2412,
  [2413] = 2413,
  [2414] = 2376,
  [2415] = 2374,
  [2416] = 2416,
  [2417] = 2417,
  [2418] = 2343,
  [2419] = 2419,
  [2420] = 2420,
  [2421] = 2421,
  [2422] = 2422,
  [2423] = 2423,
  [2424] = 2424,
  [2425] = 2417,
  [2426] = 2426,
  [2427] = 2364,
  [2428] = 2428,
  [2429] = 2429,
  [2430] = 2430,
  [2431] = 2352,
  [2432] = 2432,
  [2433] = 2356,
  [2434] = 2434,
  [2435] = 2402,
  [2436] = 2004,
  [2437] = 2398,
  [2438] = 2438,
  [2439] = 2359,
  [2440] = 2440,
  [2441] = 2441,
  [2442] = 2442,
  [2443] = 2443,
  [2444] = 2444,
  [2445] = 2445,
  [2446] = 2446,
  [2447] = 2447,
  [2448] = 2306,
  [2449] = 2449,
  [2450] = 2450,
  [2451] = 2451,
  [2452] = 2452,
  [2453] = 2453,
  [2454] = 2319,
  [2455] = 2408,
  [2456] = 2456,
  [2457] = 2457,
  [2458] = 2458,
  [2459] = 2459,
  [2460] = 2460,
  [2461] = 2461,
  [2462] = 2462,
  [2463] = 2463,
  [2464] = 2464,
  [2465] = 2465,
  [2466] = 2466,
  [2467] = 2467,
  [2468] = 2468,
  [2469] = 2469,
  [2470] = 2470,
  [2471] = 2471,
  [2472] = 2035,
  [2473] = 2473,
  [2474] = 2474,
  [2475] = 2475,
  [2476] = 2032,
  [2477] = 2477,
  [2478] = 2478,
  [2479] = 2479,
  [2480] = 2480,
  [2481] = 2481,
  [2482] = 2482,
  [2483] = 2483,
  [2484] = 2484,
  [2485] = 2485,
  [2486] = 2486,
  [2487] = 2487,
  [2488] = 2488,
  [2489] = 2489,
  [2490] = 2490,
  [2491] = 2491,
  [2492] = 2492,
  [2493] = 2493,
  [2494] = 2494,
  [2495] = 2495,
  [2496] = 2496,
  [2497] = 2497,
  [2498] = 2498,
  [2499] = 2499,
  [2500] = 2500,
  [2501] = 2501,
  [2502] = 2502,
  [2503] = 2503,
  [2504] = 2504,
  [2505] = 2505,
  [2506] = 2506,
  [2507] = 2507,
  [2508] = 2508,
  [2509] = 2509,
  [2510] = 2510,
  [2511] = 2511,
  [2512] = 2512,
  [2513] = 2513,
  [2514] = 2514,
  [2515] = 2515,
  [2516] = 2516,
  [2517] = 2517,
  [2518] = 2518,
  [2519] = 2466,
  [2520] = 2520,
  [2521] = 2521,
  [2522] = 2522,
  [2523] = 2523,
  [2524] = 2524,
  [2525] = 2525,
  [2526] = 2526,
  [2527] = 2527,
  [2528] = 2528,
  [2529] = 2529,
  [2530] = 2530,
  [2531] = 2495,
  [2532] = 2482,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2535,
  [2536] = 2536,
  [2537] = 2537,
  [2538] = 2538,
  [2539] = 2539,
  [2540] = 2024,
  [2541] = 2469,
  [2542] = 2542,
  [2543] = 2543,
  [2544] = 2544,
  [2545] = 2545,
  [2546] = 2546,
  [2547] = 2547,
  [2548] = 2548,
  [2549] = 2549,
  [2550] = 2550,
  [2551] = 2551,
  [2552] = 2552,
  [2553] = 2553,
  [2554] = 2554,
  [2555] = 2555,
  [2556] = 2556,
  [2557] = 2557,
  [2558] = 2558,
  [2559] = 2559,
  [2560] = 2560,
  [2561] = 2561,
  [2562] = 2562,
  [2563] = 2475,
  [2564] = 2564,
  [2565] = 2565,
  [2566] = 2566,
  [2567] = 2567,
  [2568] = 2568,
  [2569] = 2569,
  [2570] = 2570,
  [2571] = 2571,
  [2572] = 2572,
  [2573] = 2573,
  [2574] = 2574,
  [2575] = 2575,
  [2576] = 2576,
  [2577] = 2577,
  [2578] = 2578,
  [2579] = 2579,
  [2580] = 2580,
  [2581] = 2581,
  [2582] = 2582,
  [2583] = 2477,
  [2584] = 2584,
  [2585] = 2585,
  [2586] = 2586,
  [2587] = 2587,
  [2588] = 2023,
  [2589] = 2589,
  [2590] = 2590,
  [2591] = 2591,
  [2592] = 2592,
  [2593] = 2593,
  [2594] = 2594,
  [2595] = 2595,
  [2596] = 2596,
  [2597] = 2597,
  [2598] = 2598,
  [2599] = 2599,
  [2600] = 2600,
  [2601] = 2601,
  [2602] = 2602,
  [2603] = 2582,
  [2604] = 2604,
  [2605] = 2605,
  [2606] = 2606,
  [2607] = 2469,
  [2608] = 1855,
  [2609] = 2609,
  [2610] = 2610,
  [2611] = 2611,
  [2612] = 2535,
  [2613] = 2613,
  [2614] = 2614,
  [2615] = 2497,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2618,
  [2619] = 2619,
  [2620] = 2620,
  [2621] = 2621,
  [2622] = 2622,
  [2623] = 2623,
  [2624] = 2624,
  [2625] = 2625,
  [2626] = 2626,
  [2627] = 2627,
  [2628] = 2628,
  [2629] = 2497,
  [2630] = 2630,
  [2631] = 2631,
  [2632] = 2632,
  [2633] = 2470,
  [2634] = 2634,
  [2635] = 2635,
  [2636] = 2636,
  [2637] = 2637,
  [2638] = 2638,
  [2639] = 2639,
  [2640] = 2640,
  [2641] = 2641,
  [2642] = 2642,
  [2643] = 2643,
  [2644] = 2644,
  [2645] = 2645,
  [2646] = 2646,
  [2647] = 2647,
  [2648] = 2648,
  [2649] = 2465,
  [2650] = 2650,
  [2651] = 2497,
  [2652] = 2652,
  [2653] = 2022,
  [2654] = 2654,
  [2655] = 2655,
  [2656] = 2656,
  [2657] = 2657,
  [2658] = 2658,
  [2659] = 2659,
  [2660] = 2660,
  [2661] = 2661,
  [2662] = 2662,
  [2663] = 2663,
  [2664] = 2664,
  [2665] = 2665,
  [2666] = 2666,
  [2667] = 2667,
  [2668] = 2033,
  [2669] = 2669,
  [2670] = 2670,
  [2671] = 2671,
  [2672] = 2672,
  [2673] = 2469,
  [2674] = 2674,
  [2675] = 2675,
  [2676] = 2676,
  [2677] = 2677,
  [2678] = 2576,
  [2679] = 2679,
  [2680] = 2680,
  [2681] = 2681,
  [2682] = 2579,
  [2683] = 2039,
  [2684] = 2684,
  [2685] = 2685,
  [2686] = 2686,
  [2687] = 2687,
  [2688] = 2688,
  [2689] = 2689,
  [2690] = 2690,
  [2691] = 2691,
  [2692] = 2692,
  [2693] = 2693,
  [2694] = 2501,
  [2695] = 2524,
  [2696] = 2580,
  [2697] = 2697,
  [2698] = 2698,
  [2699] = 2699,
  [2700] = 2700,
  [2701] = 2040,
  [2702] = 2609,
  [2703] = 2703,
  [2704] = 2693,
  [2705] = 2052,
  [2706] = 2706,
  [2707] = 2507,
  [2708] = 2708,
  [2709] = 2709,
  [2710] = 2710,
  [2711] = 2711,
  [2712] = 2712,
  [2713] = 2713,
  [2714] = 2714,
  [2715] = 2715,
  [2716] = 2716,
  [2717] = 2717,
  [2718] = 2718,
  [2719] = 2719,
  [2720] = 2720,
  [2721] = 2721,
  [2722] = 2722,
  [2723] = 2723,
  [2724] = 2724,
  [2725] = 2725,
  [2726] = 2726,
  [2727] = 2727,
  [2728] = 2728,
  [2729] = 2729,
  [2730] = 2730,
  [2731] = 2731,
  [2732] = 2732,
  [2733] = 2733,
  [2734] = 2734,
  [2735] = 2735,
  [2736] = 2736,
  [2737] = 2737,
  [2738] = 2738,
  [2739] = 2739,
  [2740] = 2740,
  [2741] = 2741,
  [2742] = 2742,
  [2743] = 2715,
  [2744] = 2744,
  [2745] = 2745,
  [2746] = 2746,
  [2747] = 2747,
  [2748] = 2748,
  [2749] = 2749,
  [2750] = 2750,
  [2751] = 2751,
  [2752] = 2752,
  [2753] = 2753,
  [2754] = 2754,
  [2755] = 2755,
  [2756] = 2756,
  [2757] = 2757,
  [2758] = 2758,
  [2759] = 2730,
  [2760] = 2760,
  [2761] = 2715,
  [2762] = 2762,
  [2763] = 2763,
  [2764] = 2764,
  [2765] = 2765,
  [2766] = 2766,
  [2767] = 2767,
  [2768] = 2768,
  [2769] = 2769,
  [2770] = 2770,
  [2771] = 2771,
  [2772] = 2772,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2067,
  [2777] = 2777,
  [2778] = 2778,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2782,
  [2783] = 2783,
  [2784] = 2784,
  [2785] = 2785,
  [2786] = 2786,
  [2787] = 2787,
  [2788] = 2788,
  [2789] = 2789,
  [2790] = 2715,
  [2791] = 2791,
  [2792] = 2792,
  [2793] = 2793,
  [2794] = 2794,
  [2795] = 2795,
  [2796] = 2796,
  [2797] = 2797,
  [2798] = 2798,
  [2799] = 2799,
  [2800] = 2800,
  [2801] = 2801,
  [2802] = 2715,
  [2803] = 2803,
  [2804] = 2804,
  [2805] = 2805,
  [2806] = 2806,
  [2807] = 2807,
  [2808] = 2808,
  [2809] = 2809,
  [2810] = 2810,
  [2811] = 2811,
  [2812] = 2812,
  [2813] = 2813,
  [2814] = 2814,
  [2815] = 2815,
  [2816] = 2816,
  [2817] = 2780,
  [2818] = 2818,
  [2819] = 2819,
  [2820] = 2820,
  [2821] = 2821,
  [2822] = 2822,
  [2823] = 2823,
  [2824] = 2824,
  [2825] = 2715,
  [2826] = 2826,
  [2827] = 2827,
  [2828] = 2828,
  [2829] = 2829,
  [2830] = 2830,
  [2831] = 2831,
  [2832] = 2832,
  [2833] = 2833,
  [2834] = 2834,
  [2835] = 2835,
  [2836] = 2836,
  [2837] = 2837,
  [2838] = 2838,
  [2839] = 2839,
  [2840] = 2840,
  [2841] = 2841,
  [2842] = 2842,
  [2843] = 2843,
  [2844] = 2844,
  [2845] = 2845,
  [2846] = 2774,
  [2847] = 2847,
  [2848] = 2771,
  [2849] = 2756,
  [2850] = 2850,
  [2851] = 2851,
  [2852] = 2755,
  [2853] = 2853,
  [2854] = 2789,
  [2855] = 2855,
  [2856] = 2856,
  [2857] = 2857,
  [2858] = 2858,
  [2859] = 2859,
  [2860] = 2860,
  [2861] = 2861,
  [2862] = 2715,
  [2863] = 2863,
  [2864] = 2864,
  [2865] = 2865,
  [2866] = 2866,
  [2867] = 2867,
  [2868] = 2868,
  [2869] = 2754,
  [2870] = 2870,
  [2871] = 2871,
  [2872] = 2872,
  [2873] = 2873,
  [2874] = 2874,
  [2875] = 2875,
  [2876] = 2715,
  [2877] = 2877,
  [2878] = 2878,
  [2879] = 2879,
  [2880] = 2880,
  [2881] = 2726,
  [2882] = 2882,
  [2883] = 2883,
  [2884] = 2884,
  [2885] = 2885,
  [2886] = 2886,
  [2887] = 2887,
  [2888] = 2888,
  [2889] = 2889,
  [2890] = 2890,
  [2891] = 2891,
  [2892] = 2892,
  [2893] = 2893,
  [2894] = 2894,
  [2895] = 2895,
  [2896] = 2896,
  [2897] = 2897,
  [2898] = 2898,
  [2899] = 2899,
  [2900] = 2900,
  [2901] = 2901,
  [2902] = 2902,
  [2903] = 2903,
  [2904] = 2904,
  [2905] = 2905,
  [2906] = 2906,
  [2907] = 2907,
  [2908] = 2768,
  [2909] = 2909,
  [2910] = 2910,
  [2911] = 2911,
  [2912] = 2912,
  [2913] = 2793,
  [2914] = 2914,
  [2915] = 2915,
  [2916] = 2916,
  [2917] = 2710,
  [2918] = 2730,
  [2919] = 2919,
  [2920] = 2784,
  [2921] = 2792,
  [2922] = 2795,
  [2923] = 2923,
  [2924] = 2924,
  [2925] = 2796,
  [2926] = 2926,
  [2927] = 2927,
  [2928] = 2928,
  [2929] = 2730,
  [2930] = 2779,
  [2931] = 2931,
  [2932] = 2927,
  [2933] = 2798,
  [2934] = 2934,
  [2935] = 2935,
  [2936] = 2936,
  [2937] = 2937,
  [2938] = 2938,
  [2939] = 2939,
  [2940] = 2928,
  [2941] = 2938,
  [2942] = 2892,
  [2943] = 2943,
  [2944] = 2944,
  [2945] = 2887,
  [2946] = 2939,
  [2947] = 2947,
  [2948] = 2944,
  [2949] = 2949,
  [2950] = 2950,
  [2951] = 2951,
  [2952] = 2952,
  [2953] = 2953,
  [2954] = 2954,
  [2955] = 2955,
  [2956] = 2956,
  [2957] = 2957,
  [2958] = 2949,
  [2959] = 2959,
  [2960] = 2960,
  [2961] = 2952,
  [2962] = 2962,
  [2963] = 2963,
  [2964] = 2964,
  [2965] = 2914,
  [2966] = 2830,
  [2967] = 2829,
  [2968] = 2953,
  [2969] = 2779,
  [2970] = 2834,
  [2971] = 2827,
  [2972] = 2972,
  [2973] = 2973,
  [2974] = 2838,
  [2975] = 2873,
  [2976] = 2816,
  [2977] = 2977,
  [2978] = 2859,
  [2979] = 2779,
  [2980] = 2980,
  [2981] = 2981,
  [2982] = 2841,
  [2983] = 2797,
  [2984] = 2769,
  [2985] = 2810,
  [2986] = 2812,
  [2987] = 2987,
  [2988] = 2988,
  [2989] = 2989,
  [2990] = 2990,
  [2991] = 2991,
  [2992] = 2992,
  [2993] = 2993,
  [2994] = 2994,
  [2995] = 2995,
  [2996] = 2996,
  [2997] = 2997,
  [2998] = 2998,
  [2999] = 2999,
  [3000] = 2992,
  [3001] = 3001,
  [3002] = 3002,
  [3003] = 3003,
  [3004] = 3004,
  [3005] = 3005,
  [3006] = 2998,
  [3007] = 3007,
  [3008] = 2991,
  [3009] = 3009,
  [3010] = 3010,
  [3011] = 3011,
  [3012] = 3012,
  [3013] = 3013,
  [3014] = 3014,
  [3015] = 3003,
  [3016] = 3016,
  [3017] = 3017,
  [3018] = 3018,
  [3019] = 3019,
  [3020] = 3020,
  [3021] = 2996,
  [3022] = 3022,
  [3023] = 3023,
  [3024] = 3024,
  [3025] = 3025,
  [3026] = 3026,
  [3027] = 3027,
  [3028] = 3028,
  [3029] = 2992,
  [3030] = 3030,
  [3031] = 3031,
  [3032] = 3032,
  [3033] = 3033,
  [3034] = 3034,
  [3035] = 3035,
  [3036] = 3010,
  [3037] = 3037,
  [3038] = 3038,
  [3039] = 3039,
  [3040] = 3040,
  [3041] = 3041,
  [3042] = 3039,
  [3043] = 2995,
  [3044] = 3044,
  [3045] = 3045,
  [3046] = 3046,
  [3047] = 3047,
  [3048] = 3048,
  [3049] = 3049,
  [3050] = 3050,
  [3051] = 3051,
  [3052] = 3052,
  [3053] = 3053,
  [3054] = 3054,
  [3055] = 3055,
  [3056] = 3056,
  [3057] = 3057,
  [3058] = 3058,
  [3059] = 3059,
  [3060] = 2990,
  [3061] = 3061,
  [3062] = 3062,
  [3063] = 3063,
  [3064] = 2998,
  [3065] = 3047,
  [3066] = 3066,
  [3067] = 3051,
  [3068] = 3068,
  [3069] = 3069,
  [3070] = 3070,
  [3071] = 3071,
  [3072] = 3072,
  [3073] = 3073,
  [3074] = 3074,
  [3075] = 3054,
  [3076] = 3039,
  [3077] = 3070,
  [3078] = 3078,
  [3079] = 3079,
  [3080] = 3080,
  [3081] = 3081,
  [3082] = 3082,
  [3083] = 3047,
  [3084] = 3082,
  [3085] = 2999,
  [3086] = 3010,
  [3087] = 3087,
  [3088] = 2995,
  [3089] = 3089,
  [3090] = 3090,
  [3091] = 3035,
  [3092] = 3092,
  [3093] = 3093,
  [3094] = 2991,
  [3095] = 3095,
  [3096] = 3096,
  [3097] = 3097,
  [3098] = 3098,
  [3099] = 3099,
  [3100] = 3009,
  [3101] = 2988,
  [3102] = 3102,
  [3103] = 3103,
  [3104] = 3096,
  [3105] = 3070,
  [3106] = 3001,
  [3107] = 3107,
  [3108] = 3108,
  [3109] = 3039,
  [3110] = 3051,
  [3111] = 3111,
  [3112] = 3112,
  [3113] = 3113,
  [3114] = 3114,
  [3115] = 3113,
  [3116] = 3070,
  [3117] = 3117,
  [3118] = 3051,
  [3119] = 3119,
  [3120] = 3120,
  [3121] = 3121,
  [3122] = 3122,
  [3123] = 3123,
  [3124] = 2992,
  [3125] = 3125,
  [3126] = 3126,
  [3127] = 3127,
  [3128] = 3128,
  [3129] = 3129,
  [3130] = 3032,
  [3131] = 3131,
  [3132] = 3132,
  [3133] = 3035,
  [3134] = 3134,
  [3135] = 3135,
  [3136] = 3136,
  [3137] = 3010,
  [3138] = 3058,
  [3139] = 3139,
  [3140] = 2995,
  [3141] = 3141,
  [3142] = 2996,
  [3143] = 2996,
  [3144] = 2991,
  [3145] = 3145,
  [3146] = 3035,
  [3147] = 3141,
  [3148] = 3148,
  [3149] = 2998,
  [3150] = 3150,
  [3151] = 3151,
  [3152] = 3152,
  [3153] = 3153,
  [3154] = 3154,
  [3155] = 3111,
  [3156] = 3156,
  [3157] = 3157,
  [3158] = 3158,
  [3159] = 3159,
  [3160] = 3160,
  [3161] = 2997,
  [3162] = 2351,
  [3163] = 2324,
  [3164] = 2385,
  [3165] = 3165,
  [3166] = 2323,
  [3167] = 3167,
  [3168] = 2389,
  [3169] = 3169,
  [3170] = 3170,
  [3171] = 2396,
  [3172] = 2390,
  [3173] = 2400,
  [3174] = 2404,
  [3175] = 3175,
  [3176] = 3176,
  [3177] = 3177,
  [3178] = 2344,
  [3179] = 3179,
  [3180] = 2405,
  [3181] = 2342,
  [3182] = 3182,
  [3183] = 3183,
  [3184] = 3184,
  [3185] = 2340,
  [3186] = 2334,
  [3187] = 2357,
  [3188] = 3188,
  [3189] = 3165,
  [3190] = 2406,
  [3191] = 2315,
  [3192] = 3192,
  [3193] = 3169,
  [3194] = 3194,
  [3195] = 3195,
  [3196] = 3196,
  [3197] = 3192,
  [3198] = 3198,
  [3199] = 3199,
  [3200] = 2424,
  [3201] = 3201,
  [3202] = 3202,
  [3203] = 2428,
  [3204] = 2430,
  [3205] = 2432,
  [3206] = 2434,
  [3207] = 2438,
  [3208] = 2347,
  [3209] = 3209,
  [3210] = 3210,
  [3211] = 2384,
  [3212] = 2378,
  [3213] = 2375,
  [3214] = 3192,
  [3215] = 2350,
  [3216] = 2308,
  [3217] = 3217,
  [3218] = 2387,
  [3219] = 2442,
  [3220] = 3202,
  [3221] = 3175,
  [3222] = 3202,
  [3223] = 2443,
  [3224] = 2444,
  [3225] = 3225,
  [3226] = 2318,
  [3227] = 2452,
  [3228] = 3228,
  [3229] = 3229,
  [3230] = 3176,
  [3231] = 3231,
  [3232] = 3169,
  [3233] = 3233,
  [3234] = 3234,
  [3235] = 3235,
  [3236] = 3236,
  [3237] = 3169,
  [3238] = 3238,
  [3239] = 3239,
  [3240] = 3229,
  [3241] = 2413,
  [3242] = 3242,
  [3243] = 3243,
  [3244] = 3244,
  [3245] = 2420,
  [3246] = 2440,
  [3247] = 2421,
  [3248] = 3165,
  [3249] = 3188,
  [3250] = 3250,
  [3251] = 3251,
  [3252] = 2373,
  [3253] = 3170,
  [3254] = 3165,
  [3255] = 2386,
  [3256] = 2388,
  [3257] = 2361,
  [3258] = 3258,
  [3259] = 3202,
  [3260] = 3192,
  [3261] = 2456,
  [3262] = 3262,
  [3263] = 3263,
  [3264] = 2331,
  [3265] = 2366,
  [3266] = 3266,
  [3267] = 2309,
  [3268] = 3250,
  [3269] = 3269,
  [3270] = 3270,
  [3271] = 3271,
  [3272] = 3272,
  [3273] = 3273,
  [3274] = 3274,
  [3275] = 3275,
  [3276] = 3276,
  [3277] = 3277,
  [3278] = 3278,
  [3279] = 2595,
  [3280] = 3280,
  [3281] = 3281,
  [3282] = 3275,
  [3283] = 1855,
  [3284] = 3284,
  [3285] = 3284,
  [3286] = 3286,
  [3287] = 3287,
  [3288] = 3288,
  [3289] = 3289,
  [3290] = 2560,
  [3291] = 3291,
  [3292] = 3292,
  [3293] = 3293,
  [3294] = 3294,
  [3295] = 3295,
  [3296] = 3296,
  [3297] = 3297,
  [3298] = 3280,
  [3299] = 3299,
  [3300] = 3300,
  [3301] = 2697,
  [3302] = 2623,
  [3303] = 2620,
  [3304] = 3304,
  [3305] = 3305,
  [3306] = 3278,
  [3307] = 2490,
  [3308] = 2483,
  [3309] = 3309,
  [3310] = 3310,
  [3311] = 3311,
  [3312] = 3312,
  [3313] = 3313,
  [3314] = 3314,
  [3315] = 3315,
  [3316] = 3316,
  [3317] = 3317,
  [3318] = 3318,
  [3319] = 3319,
  [3320] = 3320,
  [3321] = 3321,
  [3322] = 3322,
  [3323] = 3277,
  [3324] = 3324,
  [3325] = 3325,
  [3326] = 3326,
  [3327] = 3327,
  [3328] = 3328,
  [3329] = 3329,
  [3330] = 3330,
  [3331] = 3331,
  [3332] = 3332,
  [3333] = 3333,
  [3334] = 3334,
  [3335] = 3335,
  [3336] = 3336,
  [3337] = 3337,
  [3338] = 3338,
  [3339] = 3339,
  [3340] = 3340,
  [3341] = 3341,
  [3342] = 2618,
  [3343] = 3343,
  [3344] = 3339,
  [3345] = 3345,
  [3346] = 3346,
  [3347] = 3347,
  [3348] = 3275,
  [3349] = 3349,
  [3350] = 1855,
  [3351] = 3351,
  [3352] = 3352,
  [3353] = 3353,
  [3354] = 3284,
  [3355] = 3338,
  [3356] = 3356,
  [3357] = 3289,
  [3358] = 2661,
  [3359] = 3359,
  [3360] = 3292,
  [3361] = 3361,
  [3362] = 3293,
  [3363] = 3363,
  [3364] = 2516,
  [3365] = 2533,
  [3366] = 3366,
  [3367] = 3367,
  [3368] = 3337,
  [3369] = 2511,
  [3370] = 3370,
  [3371] = 3371,
  [3372] = 3329,
  [3373] = 3294,
  [3374] = 3327,
  [3375] = 3375,
  [3376] = 3332,
  [3377] = 3316,
  [3378] = 3319,
  [3379] = 2650,
  [3380] = 3304,
  [3381] = 3289,
  [3382] = 3292,
  [3383] = 3383,
  [3384] = 3293,
  [3385] = 3326,
  [3386] = 3386,
  [3387] = 3387,
  [3388] = 3388,
  [3389] = 3325,
  [3390] = 3390,
  [3391] = 3391,
  [3392] = 3392,
  [3393] = 3393,
  [3394] = 3394,
  [3395] = 3395,
  [3396] = 3396,
  [3397] = 3397,
  [3398] = 3316,
  [3399] = 3399,
  [3400] = 3400,
  [3401] = 3401,
  [3402] = 3402,
  [3403] = 3316,
  [3404] = 3404,
  [3405] = 3371,
  [3406] = 3370,
  [3407] = 2566,
  [3408] = 3277,
  [3409] = 3409,
  [3410] = 2547,
  [3411] = 3309,
  [3412] = 3299,
  [3413] = 3293,
  [3414] = 3414,
  [3415] = 3292,
  [3416] = 3289,
  [3417] = 3417,
  [3418] = 3418,
  [3419] = 3419,
  [3420] = 3367,
  [3421] = 3291,
  [3422] = 2597,
  [3423] = 3423,
  [3424] = 3424,
  [3425] = 3425,
  [3426] = 3327,
  [3427] = 3427,
  [3428] = 3329,
  [3429] = 3429,
  [3430] = 3341,
  [3431] = 3337,
  [3432] = 3432,
  [3433] = 3433,
  [3434] = 3312,
  [3435] = 3284,
  [3436] = 2594,
  [3437] = 3437,
  [3438] = 3314,
  [3439] = 3439,
  [3440] = 3339,
  [3441] = 3441,
  [3442] = 3442,
  [3443] = 3275,
  [3444] = 3444,
  [3445] = 3445,
  [3446] = 3446,
  [3447] = 3447,
  [3448] = 3277,
  [3449] = 3327,
  [3450] = 3329,
  [3451] = 3451,
  [3452] = 3337,
  [3453] = 3453,
  [3454] = 3454,
  [3455] = 3455,
  [3456] = 3456,
  [3457] = 3457,
  [3458] = 3458,
  [3459] = 3459,
  [3460] = 3338,
  [3461] = 3461,
  [3462] = 3444,
  [3463] = 3339,
  [3464] = 3280,
  [3465] = 3465,
  [3466] = 3466,
  [3467] = 3465,
  [3468] = 3280,
  [3469] = 3469,
  [3470] = 3470,
  [3471] = 3471,
  [3472] = 3472,
  [3473] = 3473,
  [3474] = 3474,
  [3475] = 3475,
  [3476] = 3476,
  [3477] = 3477,
  [3478] = 3330,
  [3479] = 3479,
  [3480] = 3356,
  [3481] = 3333,
  [3482] = 3419,
  [3483] = 3483,
  [3484] = 3484,
  [3485] = 3465,
  [3486] = 2463,
  [3487] = 3487,
  [3488] = 3418,
  [3489] = 2639,
  [3490] = 3490,
  [3491] = 3345,
  [3492] = 3361,
  [3493] = 3493,
  [3494] = 3494,
  [3495] = 3495,
  [3496] = 3496,
  [3497] = 3497,
  [3498] = 3400,
  [3499] = 3351,
  [3500] = 3500,
  [3501] = 3501,
  [3502] = 3502,
  [3503] = 3503,
  [3504] = 3504,
  [3505] = 3402,
  [3506] = 3506,
  [3507] = 3338,
  [3508] = 3508,
  [3509] = 3509,
  [3510] = 3510,
  [3511] = 3511,
  [3512] = 3512,
  [3513] = 3513,
  [3514] = 3465,
  [3515] = 3515,
  [3516] = 3516,
  [3517] = 3517,
  [3518] = 3518,
  [3519] = 3519,
  [3520] = 3520,
  [3521] = 3521,
  [3522] = 3522,
  [3523] = 3523,
  [3524] = 3524,
  [3525] = 3525,
  [3526] = 3526,
  [3527] = 3527,
  [3528] = 3528,
  [3529] = 3529,
  [3530] = 3530,
  [3531] = 3531,
  [3532] = 3532,
  [3533] = 3533,
  [3534] = 3534,
  [3535] = 3535,
  [3536] = 3536,
  [3537] = 3537,
  [3538] = 3538,
  [3539] = 3539,
  [3540] = 3540,
  [3541] = 3541,
  [3542] = 3542,
  [3543] = 3543,
  [3544] = 3544,
  [3545] = 3545,
  [3546] = 3546,
  [3547] = 3547,
  [3548] = 3548,
  [3549] = 3549,
  [3550] = 3550,
  [3551] = 3551,
  [3552] = 3552,
  [3553] = 3539,
  [3554] = 3554,
  [3555] = 3555,
  [3556] = 3556,
  [3557] = 3557,
  [3558] = 3558,
  [3559] = 3559,
  [3560] = 3560,
  [3561] = 3561,
  [3562] = 3562,
  [3563] = 3563,
  [3564] = 3564,
  [3565] = 3565,
  [3566] = 3566,
  [3567] = 3522,
  [3568] = 3568,
  [3569] = 3569,
  [3570] = 3570,
  [3571] = 3571,
  [3572] = 3572,
  [3573] = 3573,
  [3574] = 3574,
  [3575] = 3575,
  [3576] = 3576,
  [3577] = 3531,
  [3578] = 3578,
  [3579] = 3579,
  [3580] = 3580,
  [3581] = 3533,
  [3582] = 3582,
  [3583] = 3572,
  [3584] = 3584,
  [3585] = 3585,
  [3586] = 3586,
  [3587] = 3587,
  [3588] = 3588,
  [3589] = 3589,
  [3590] = 3590,
  [3591] = 3591,
  [3592] = 3527,
  [3593] = 3593,
  [3594] = 3549,
  [3595] = 3595,
  [3596] = 3572,
  [3597] = 3597,
  [3598] = 3598,
  [3599] = 3599,
  [3600] = 3598,
  [3601] = 3601,
  [3602] = 3543,
  [3603] = 3599,
  [3604] = 3589,
  [3605] = 3605,
  [3606] = 3606,
  [3607] = 3587,
  [3608] = 3608,
  [3609] = 3586,
  [3610] = 3610,
  [3611] = 3611,
  [3612] = 3612,
  [3613] = 3548,
  [3614] = 3555,
  [3615] = 3615,
  [3616] = 3616,
  [3617] = 3617,
  [3618] = 3618,
  [3619] = 3619,
  [3620] = 3620,
  [3621] = 3621,
  [3622] = 3622,
  [3623] = 3623,
  [3624] = 3624,
  [3625] = 3546,
  [3626] = 3545,
  [3627] = 3627,
  [3628] = 3628,
  [3629] = 3629,
  [3630] = 3528,
  [3631] = 3631,
  [3632] = 3632,
  [3633] = 3633,
  [3634] = 3582,
  [3635] = 3628,
  [3636] = 3636,
  [3637] = 3580,
  [3638] = 3638,
  [3639] = 3639,
  [3640] = 3579,
  [3641] = 3641,
  [3642] = 3576,
  [3643] = 3533,
  [3644] = 3644,
  [3645] = 3645,
  [3646] = 3646,
  [3647] = 3515,
  [3648] = 3648,
  [3649] = 3649,
  [3650] = 3650,
  [3651] = 3517,
  [3652] = 3652,
  [3653] = 3575,
  [3654] = 3654,
  [3655] = 3655,
  [3656] = 3646,
  [3657] = 3645,
  [3658] = 3644,
  [3659] = 3659,
  [3660] = 3660,
  [3661] = 3621,
  [3662] = 3662,
  [3663] = 3628,
  [3664] = 3664,
  [3665] = 3665,
  [3666] = 3646,
  [3667] = 3542,
  [3668] = 3645,
  [3669] = 3652,
  [3670] = 3670,
  [3671] = 3671,
  [3672] = 3627,
  [3673] = 3564,
  [3674] = 3674,
  [3675] = 3585,
  [3676] = 3515,
  [3677] = 3620,
  [3678] = 3678,
  [3679] = 3519,
  [3680] = 3529,
  [3681] = 3530,
  [3682] = 3555,
  [3683] = 3547,
  [3684] = 3573,
  [3685] = 3685,
  [3686] = 3532,
  [3687] = 3644,
  [3688] = 3688,
  [3689] = 3689,
  [3690] = 3662,
  [3691] = 3691,
  [3692] = 3692,
  [3693] = 3531,
  [3694] = 3612,
  [3695] = 3588,
  [3696] = 3627,
  [3697] = 3646,
  [3698] = 3645,
  [3699] = 3644,
  [3700] = 3549,
  [3701] = 3701,
  [3702] = 3702,
  [3703] = 3703,
  [3704] = 3704,
  [3705] = 3562,
  [3706] = 3649,
  [3707] = 3707,
  [3708] = 3708,
  [3709] = 3709,
  [3710] = 3636,
  [3711] = 3571,
  [3712] = 3638,
  [3713] = 3702,
  [3714] = 3533,
  [3715] = 3715,
  [3716] = 3522,
  [3717] = 3717,
  [3718] = 3670,
  [3719] = 3719,
  [3720] = 3720,
  [3721] = 3721,
  [3722] = 3570,
  [3723] = 3723,
  [3724] = 3724,
  [3725] = 3591,
  [3726] = 3726,
  [3727] = 3715,
  [3728] = 3522,
  [3729] = 3632,
  [3730] = 3730,
  [3731] = 3515,
  [3732] = 3571,
  [3733] = 3572,
  [3734] = 3726,
  [3735] = 3717,
  [3736] = 3685,
  [3737] = 3737,
  [3738] = 3572,
  [3739] = 3739,
  [3740] = 3730,
  [3741] = 3741,
  [3742] = 3548,
  [3743] = 3621,
  [3744] = 3561,
  [3745] = 3569,
  [3746] = 3664,
  [3747] = 3747,
  [3748] = 3748,
  [3749] = 3749,
  [3750] = 3750,
  [3751] = 3751,
  [3752] = 3752,
  [3753] = 3708,
  [3754] = 3571,
  [3755] = 3720,
  [3756] = 3650,
  [3757] = 3757,
  [3758] = 3758,
  [3759] = 3759,
  [3760] = 3760,
  [3761] = 3761,
  [3762] = 3762,
  [3763] = 3763,
  [3764] = 3764,
  [3765] = 3765,
  [3766] = 3766,
  [3767] = 3767,
  [3768] = 3768,
  [3769] = 3769,
  [3770] = 3770,
  [3771] = 3771,
  [3772] = 3772,
  [3773] = 3773,
  [3774] = 3761,
  [3775] = 3775,
  [3776] = 3776,
  [3777] = 3777,
  [3778] = 3778,
  [3779] = 3779,
  [3780] = 3780,
  [3781] = 3781,
  [3782] = 3782,
  [3783] = 3783,
  [3784] = 3784,
  [3785] = 3785,
  [3786] = 3786,
  [3787] = 3787,
  [3788] = 3788,
  [3789] = 3789,
  [3790] = 3790,
  [3791] = 3791,
  [3792] = 3792,
  [3793] = 3793,
  [3794] = 3794,
  [3795] = 3795,
  [3796] = 3796,
  [3797] = 3797,
  [3798] = 3798,
  [3799] = 3799,
  [3800] = 3800,
  [3801] = 3801,
  [3802] = 3802,
  [3803] = 3803,
  [3804] = 3804,
  [3805] = 3805,
  [3806] = 3806,
  [3807] = 3807,
  [3808] = 3808,
  [3809] = 3809,
  [3810] = 3810,
  [3811] = 3811,
  [3812] = 3812,
  [3813] = 3810,
  [3814] = 3812,
  [3815] = 3809,
  [3816] = 3811,
  [3817] = 3803,
  [3818] = 3800,
  [3819] = 3798,
  [3820] = 3797,
  [3821] = 3808,
  [3822] = 3796,
  [3823] = 3784,
  [3824] = 3781,
  [3825] = 3780,
  [3826] = 3807,
  [3827] = 3779,
  [3828] = 3806,
  [3829] = 3805,
  [3830] = 3769,
  [3831] = 3759,
  [3832] = 3760,
  [3833] = 3804,
  [3834] = 3802,
  [3835] = 3801,
  [3836] = 3799,
  [3837] = 3795,
  [3838] = 3794,
  [3839] = 3793,
  [3840] = 3792,
  [3841] = 3791,
  [3842] = 3790,
  [3843] = 3789,
  [3844] = 3788,
  [3845] = 3787,
  [3846] = 3786,
  [3847] = 3785,
  [3848] = 3783,
  [3849] = 3782,
  [3850] = 3850,
  [3851] = 3851,
  [3852] = 3852,
  [3853] = 3778,
  [3854] = 3777,
  [3855] = 3776,
  [3856] = 3775,
  [3857] = 3773,
  [3858] = 3771,
  [3859] = 3768,
  [3860] = 3766,
  [3861] = 3765,
  [3862] = 3764,
  [3863] = 3763,
  [3864] = 3762,
  [3865] = 3812,
  [3866] = 3760,
  [3867] = 3759,
  [3868] = 3758,
  [3869] = 3769,
  [3870] = 3770,
  [3871] = 3772,
  [3872] = 3767,
  [3873] = 3779,
  [3874] = 3780,
  [3875] = 3781,
  [3876] = 3784,
  [3877] = 3796,
  [3878] = 3878,
  [3879] = 3797,
  [3880] = 3798,
  [3881] = 3800,
  [3882] = 3803,
  [3883] = 3811,
  [3884] = 3801,
  [3885] = 3885,
  [3886] = 3810,
  [3887] = 3809,
  [3888] = 3808,
  [3889] = 3807,
  [3890] = 3806,
  [3891] = 3805,
  [3892] = 3892,
  [3893] = 3804,
  [3894] = 3802,
  [3895] = 3764,
  [3896] = 3799,
  [3897] = 3897,
  [3898] = 3898,
  [3899] = 3795,
  [3900] = 3794,
  [3901] = 3793,
  [3902] = 3792,
  [3903] = 3791,
  [3904] = 3790,
  [3905] = 3789,
  [3906] = 3906,
  [3907] = 3907,
  [3908] = 3908,
  [3909] = 3909,
  [3910] = 3910,
  [3911] = 3911,
  [3912] = 3912,
  [3913] = 3913,
  [3914] = 3788,
  [3915] = 3915,
  [3916] = 3916,
  [3917] = 3917,
  [3918] = 3918,
  [3919] = 3919,
  [3920] = 3920,
  [3921] = 3921,
  [3922] = 3922,
  [3923] = 3923,
  [3924] = 3924,
  [3925] = 3925,
  [3926] = 3787,
  [3927] = 3786,
  [3928] = 3785,
  [3929] = 3783,
  [3930] = 3782,
  [3931] = 3778,
  [3932] = 3777,
  [3933] = 3933,
  [3934] = 3934,
  [3935] = 3776,
  [3936] = 3775,
  [3937] = 3773,
  [3938] = 3771,
  [3939] = 3939,
  [3940] = 3768,
  [3941] = 3766,
  [3942] = 3765,
  [3943] = 3767,
  [3944] = 3763,
  [3945] = 3762,
  [3946] = 3761,
  [3947] = 3947,
  [3948] = 3760,
  [3949] = 3759,
  [3950] = 3758,
  [3951] = 3951,
  [3952] = 3952,
  [3953] = 3953,
  [3954] = 3954,
  [3955] = 3955,
  [3956] = 3757,
  [3957] = 3769,
  [3958] = 3770,
  [3959] = 3772,
  [3960] = 3960,
  [3961] = 3961,
  [3962] = 3962,
  [3963] = 3963,
  [3964] = 3964,
  [3965] = 3965,
  [3966] = 3966,
  [3967] = 3967,
  [3968] = 3968,
  [3969] = 3969,
  [3970] = 3970,
  [3971] = 3971,
  [3972] = 3972,
  [3973] = 3973,
  [3974] = 3974,
  [3975] = 3975,
  [3976] = 3976,
  [3977] = 3977,
  [3978] = 3978,
  [3979] = 3979,
  [3980] = 3980,
  [3981] = 3981,
  [3982] = 3982,
  [3983] = 3983,
  [3984] = 3984,
  [3985] = 3985,
  [3986] = 3986,
  [3987] = 3987,
  [3988] = 3988,
  [3989] = 3989,
  [3990] = 3990,
  [3991] = 3991,
  [3992] = 3992,
  [3993] = 3993,
  [3994] = 3994,
  [3995] = 3995,
  [3996] = 3996,
  [3997] = 3997,
  [3998] = 3998,
  [3999] = 3999,
  [4000] = 4000,
  [4001] = 3779,
  [4002] = 4002,
  [4003] = 4003,
  [4004] = 4004,
  [4005] = 4005,
  [4006] = 4006,
  [4007] = 4007,
  [4008] = 4008,
  [4009] = 4009,
  [4010] = 4010,
  [4011] = 4011,
  [4012] = 4012,
  [4013] = 4013,
  [4014] = 4014,
  [4015] = 4015,
  [4016] = 4016,
  [4017] = 4017,
  [4018] = 4018,
  [4019] = 4019,
  [4020] = 4020,
  [4021] = 4021,
  [4022] = 4022,
  [4023] = 4023,
  [4024] = 4024,
  [4025] = 4025,
  [4026] = 4020,
  [4027] = 4007,
  [4028] = 4028,
  [4029] = 3780,
  [4030] = 3781,
  [4031] = 4018,
  [4032] = 3784,
  [4033] = 4033,
  [4034] = 4034,
  [4035] = 3995,
  [4036] = 3796,
  [4037] = 3989,
  [4038] = 4014,
  [4039] = 4039,
  [4040] = 4040,
  [4041] = 4041,
  [4042] = 4042,
  [4043] = 3979,
  [4044] = 4044,
  [4045] = 4045,
  [4046] = 4046,
  [4047] = 4047,
  [4048] = 4048,
  [4049] = 4049,
  [4050] = 4050,
  [4051] = 4051,
  [4052] = 4052,
  [4053] = 4053,
  [4054] = 4054,
  [4055] = 4055,
  [4056] = 4006,
  [4057] = 4057,
  [4058] = 3850,
  [4059] = 3851,
  [4060] = 3852,
  [4061] = 4061,
  [4062] = 4062,
  [4063] = 4063,
  [4064] = 4064,
  [4065] = 4065,
  [4066] = 3797,
  [4067] = 4004,
  [4068] = 3798,
  [4069] = 3800,
  [4070] = 3803,
  [4071] = 4003,
  [4072] = 4072,
  [4073] = 4002,
  [4074] = 4074,
  [4075] = 4075,
  [4076] = 4076,
  [4077] = 4077,
  [4078] = 3906,
  [4079] = 3907,
  [4080] = 3908,
  [4081] = 3909,
  [4082] = 3910,
  [4083] = 3911,
  [4084] = 3912,
  [4085] = 3913,
  [4086] = 4086,
  [4087] = 3915,
  [4088] = 3916,
  [4089] = 3917,
  [4090] = 3918,
  [4091] = 3919,
  [4092] = 3920,
  [4093] = 3921,
  [4094] = 3922,
  [4095] = 3923,
  [4096] = 3924,
  [4097] = 3925,
  [4098] = 3811,
  [4099] = 3812,
  [4100] = 3999,
  [4101] = 4101,
  [4102] = 4102,
  [4103] = 4103,
  [4104] = 4104,
  [4105] = 4105,
  [4106] = 4106,
  [4107] = 3951,
  [4108] = 3952,
  [4109] = 3953,
  [4110] = 3954,
  [4111] = 3955,
  [4112] = 3757,
  [4113] = 3987,
  [4114] = 4114,
  [4115] = 4115,
  [4116] = 4116,
  [4117] = 4117,
  [4118] = 4118,
  [4119] = 4119,
  [4120] = 3981,
  [4121] = 3982,
  [4122] = 3983,
  [4123] = 3984,
  [4124] = 4124,
  [4125] = 4125,
  [4126] = 4126,
  [4127] = 4002,
  [4128] = 4003,
  [4129] = 4004,
  [4130] = 4130,
  [4131] = 4018,
  [4132] = 4132,
  [4133] = 4133,
  [4134] = 3850,
  [4135] = 3851,
  [4136] = 3852,
  [4137] = 4137,
  [4138] = 4138,
  [4139] = 4139,
  [4140] = 4140,
  [4141] = 4141,
  [4142] = 4142,
  [4143] = 4143,
  [4144] = 4144,
  [4145] = 4145,
  [4146] = 4146,
  [4147] = 3906,
  [4148] = 3907,
  [4149] = 3908,
  [4150] = 3909,
  [4151] = 3910,
  [4152] = 3911,
  [4153] = 3912,
  [4154] = 3913,
  [4155] = 3799,
  [4156] = 3915,
  [4157] = 3916,
  [4158] = 3917,
  [4159] = 3918,
  [4160] = 3919,
  [4161] = 3920,
  [4162] = 3921,
  [4163] = 3922,
  [4164] = 3923,
  [4165] = 3924,
  [4166] = 3925,
  [4167] = 4167,
  [4168] = 4168,
  [4169] = 4169,
  [4170] = 4170,
  [4171] = 4171,
  [4172] = 3951,
  [4173] = 3952,
  [4174] = 3953,
  [4175] = 3954,
  [4176] = 3955,
  [4177] = 3757,
  [4178] = 4178,
  [4179] = 3984,
  [4180] = 4180,
  [4181] = 3983,
  [4182] = 3981,
  [4183] = 3982,
  [4184] = 3983,
  [4185] = 3984,
  [4186] = 3982,
  [4187] = 3981,
  [4188] = 4002,
  [4189] = 4003,
  [4190] = 4004,
  [4191] = 3810,
  [4192] = 4018,
  [4193] = 3850,
  [4194] = 3851,
  [4195] = 3852,
  [4196] = 3809,
  [4197] = 3808,
  [4198] = 3807,
  [4199] = 3806,
  [4200] = 3805,
  [4201] = 4201,
  [4202] = 4202,
  [4203] = 4203,
  [4204] = 4204,
  [4205] = 3804,
  [4206] = 4206,
  [4207] = 3802,
  [4208] = 3801,
  [4209] = 4209,
  [4210] = 3898,
  [4211] = 4211,
  [4212] = 4212,
  [4213] = 4213,
  [4214] = 4214,
  [4215] = 4215,
  [4216] = 4216,
  [4217] = 4217,
  [4218] = 4218,
  [4219] = 4219,
  [4220] = 4220,
  [4221] = 4221,
  [4222] = 4222,
  [4223] = 4223,
  [4224] = 4224,
  [4225] = 4225,
  [4226] = 4226,
  [4227] = 4227,
  [4228] = 4228,
  [4229] = 4229,
  [4230] = 3789,
  [4231] = 4231,
  [4232] = 4232,
  [4233] = 3969,
  [4234] = 4234,
  [4235] = 3961,
  [4236] = 4236,
  [4237] = 4237,
  [4238] = 4238,
  [4239] = 4239,
  [4240] = 4240,
  [4241] = 4241,
  [4242] = 4242,
  [4243] = 4243,
  [4244] = 4244,
  [4245] = 4245,
  [4246] = 3795,
  [4247] = 3794,
  [4248] = 3793,
  [4249] = 3792,
  [4250] = 3791,
  [4251] = 3790,
  [4252] = 3771,
  [4253] = 3788,
  [4254] = 3787,
  [4255] = 3786,
  [4256] = 3785,
  [4257] = 4257,
  [4258] = 3783,
  [4259] = 3782,
  [4260] = 4260,
  [4261] = 4260,
  [4262] = 4262,
  [4263] = 3778,
  [4264] = 3777,
  [4265] = 3776,
  [4266] = 3775,
  [4267] = 3955,
  [4268] = 3954,
  [4269] = 3953,
  [4270] = 3952,
  [4271] = 3951,
  [4272] = 4272,
  [4273] = 4273,
  [4274] = 3773,
  [4275] = 4204,
  [4276] = 4201,
  [4277] = 4180,
  [4278] = 4278,
  [4279] = 4279,
  [4280] = 3768,
  [4281] = 3766,
  [4282] = 4282,
  [4283] = 4257,
  [4284] = 4284,
  [4285] = 4285,
  [4286] = 4286,
  [4287] = 4287,
  [4288] = 4288,
  [4289] = 4072,
  [4290] = 3939,
  [4291] = 4291,
  [4292] = 4292,
  [4293] = 4293,
  [4294] = 4294,
  [4295] = 4295,
  [4296] = 4296,
  [4297] = 4297,
  [4298] = 4298,
  [4299] = 4299,
  [4300] = 4300,
  [4301] = 4301,
  [4302] = 4302,
  [4303] = 4303,
  [4304] = 4304,
  [4305] = 4305,
  [4306] = 4306,
  [4307] = 4019,
  [4308] = 4308,
  [4309] = 3906,
  [4310] = 3934,
  [4311] = 3933,
  [4312] = 4312,
  [4313] = 4313,
  [4314] = 4314,
  [4315] = 4315,
  [4316] = 4245,
  [4317] = 4317,
  [4318] = 4318,
  [4319] = 4319,
  [4320] = 4320,
  [4321] = 4321,
  [4322] = 4322,
  [4323] = 3925,
  [4324] = 3924,
  [4325] = 3923,
  [4326] = 3922,
  [4327] = 3921,
  [4328] = 3920,
  [4329] = 3919,
  [4330] = 3918,
  [4331] = 3917,
  [4332] = 3916,
  [4333] = 3915,
  [4334] = 3913,
  [4335] = 3912,
  [4336] = 4336,
  [4337] = 3911,
  [4338] = 3910,
  [4339] = 3909,
  [4340] = 3908,
  [4341] = 4202,
  [4342] = 3907,
  [4343] = 4343,
  [4344] = 4344,
  [4345] = 3765,
  [4346] = 4346,
  [4347] = 3764,
  [4348] = 4243,
  [4349] = 4225,
  [4350] = 4227,
  [4351] = 3897,
  [4352] = 4352,
  [4353] = 4243,
  [4354] = 4354,
  [4355] = 4245,
  [4356] = 4241,
  [4357] = 4357,
  [4358] = 4260,
  [4359] = 4359,
  [4360] = 4204,
  [4361] = 4201,
  [4362] = 4180,
  [4363] = 4072,
  [4364] = 4202,
  [4365] = 4365,
  [4366] = 4366,
  [4367] = 4367,
  [4368] = 4225,
  [4369] = 4369,
  [4370] = 4243,
  [4371] = 4238,
  [4372] = 4372,
  [4373] = 4373,
  [4374] = 4260,
  [4375] = 4375,
  [4376] = 4204,
  [4377] = 4201,
  [4378] = 4180,
  [4379] = 4072,
  [4380] = 4380,
  [4381] = 4381,
  [4382] = 4382,
  [4383] = 4383,
  [4384] = 4384,
  [4385] = 4385,
  [4386] = 4386,
  [4387] = 4387,
  [4388] = 3892,
  [4389] = 4389,
  [4390] = 4390,
  [4391] = 4391,
  [4392] = 4392,
  [4393] = 4393,
  [4394] = 4394,
  [4395] = 4395,
  [4396] = 4396,
  [4397] = 4397,
  [4398] = 4398,
  [4399] = 4399,
  [4400] = 4400,
  [4401] = 4401,
  [4402] = 4402,
  [4403] = 4403,
  [4404] = 4404,
  [4405] = 4405,
  [4406] = 4406,
  [4407] = 4407,
  [4408] = 4408,
  [4409] = 4409,
  [4410] = 4400,
  [4411] = 4411,
  [4412] = 4398,
  [4413] = 4413,
  [4414] = 4336,
  [4415] = 4317,
  [4416] = 4305,
  [4417] = 4417,
  [4418] = 4418,
  [4419] = 4419,
  [4420] = 4273,
  [4421] = 4272,
  [4422] = 4262,
  [4423] = 4244,
  [4424] = 4234,
  [4425] = 4425,
  [4426] = 4426,
  [4427] = 4203,
  [4428] = 4170,
  [4429] = 4142,
  [4430] = 3761,
  [4431] = 4227,
  [4432] = 4432,
  [4433] = 3885,
  [4434] = 4065,
  [4435] = 4063,
  [4436] = 4436,
  [4437] = 4437,
  [4438] = 4028,
  [4439] = 4024,
  [4440] = 4225,
  [4441] = 4000,
  [4442] = 4442,
  [4443] = 4443,
  [4444] = 4444,
  [4445] = 3988,
  [4446] = 3763,
  [4447] = 3762,
  [4448] = 4448,
  [4449] = 4449,
  [4450] = 4450,
  [4451] = 3878,
  [4452] = 4452,
  [4453] = 4453,
  [4454] = 4336,
  [4455] = 4273,
  [4456] = 4272,
  [4457] = 4262,
  [4458] = 4203,
  [4459] = 4459,
  [4460] = 4406,
  [4461] = 4461,
  [4462] = 4336,
  [4463] = 4273,
  [4464] = 4272,
  [4465] = 4262,
  [4466] = 4203,
  [4467] = 4467,
  [4468] = 4468,
  [4469] = 4469,
  [4470] = 4470,
  [4471] = 4471,
  [4472] = 4472,
  [4473] = 4473,
  [4474] = 4474,
  [4475] = 4432,
  [4476] = 4404,
  [4477] = 4403,
  [4478] = 4401,
  [4479] = 4320,
  [4480] = 4480,
  [4481] = 4481,
  [4482] = 4242,
  [4483] = 4239,
  [4484] = 3947,
  [4485] = 4237,
  [4486] = 4486,
  [4487] = 4487,
  [4488] = 4171,
  [4489] = 4169,
  [4490] = 4146,
  [4491] = 4145,
  [4492] = 4064,
  [4493] = 4062,
  [4494] = 3760,
  [4495] = 4025,
  [4496] = 3759,
  [4497] = 3758,
  [4498] = 3769,
  [4499] = 3998,
  [4500] = 3770,
  [4501] = 4501,
  [4502] = 4468,
  [4503] = 4503,
  [4504] = 4471,
  [4505] = 4468,
  [4506] = 4506,
  [4507] = 4507,
  [4508] = 4508,
  [4509] = 4509,
  [4510] = 4510,
  [4511] = 4391,
  [4512] = 4390,
  [4513] = 4470,
  [4514] = 4514,
  [4515] = 4387,
  [4516] = 4516,
  [4517] = 4517,
  [4518] = 3852,
  [4519] = 3851,
  [4520] = 3850,
  [4521] = 3772,
  [4522] = 3767,
  [4523] = 4202,
  [4524] = 4468,
  [4525] = 4525,
  [4526] = 4526,
  [4527] = 4527,
  [4528] = 4528,
  [4529] = 4529,
  [4530] = 4407,
  [4531] = 4531,
  [4532] = 4532,
  [4533] = 4531,
  [4534] = 4534,
  [4535] = 4535,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(33);
      if (lookahead == '!') ADVANCE(98);
      if (lookahead == '"') ADVANCE(85);
      if (lookahead == '#') ADVANCE(15);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '%') ADVANCE(76);
      if (lookahead == '\'') ADVANCE(68);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(38);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == ',') ADVANCE(39);
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(55);
      if (lookahead == ':') ADVANCE(13);
      if (lookahead == ';') ADVANCE(34);
      if (lookahead == '<') ADVANCE(69);
      if (lookahead == '=') ADVANCE(60);
      if (lookahead == '>') ADVANCE(70);
      if (lookahead == '?') ADVANCE(63);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == ']') ADVANCE(36);
      if (lookahead == '^') ADVANCE(77);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == '|') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(97);
      if (lookahead == '"') ADVANCE(85);
      if (lookahead == '$') ADVANCE(64);
      if (lookahead == '\'') ADVANCE(68);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(38);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '-') ADVANCE(74);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '?') ADVANCE(63);
      if (lookahead == ']') ADVANCE(36);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 2:
      if (lookahead == '$') ADVANCE(56);
      if (lookahead == 'b') ADVANCE(21);
      if (lookahead == 'f') ADVANCE(24);
      END_STATE();
    case 3:
      if (lookahead == '$') ADVANCE(58);
      END_STATE();
    case 4:
      if (lookahead == '$') ADVANCE(57);
      END_STATE();
    case 5:
      if (lookahead == '\'') ADVANCE(94);
      END_STATE();
    case 6:
      if (lookahead == '*') ADVANCE(49);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(54);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(29);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(54);
      if (lookahead == '-') ADVANCE(42);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(54);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(51);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 11:
      if (lookahead == '-') ADVANCE(40);
      END_STATE();
    case 12:
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 13:
      if (lookahead == ':') ADVANCE(67);
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 15:
      if (lookahead == '>') ADVANCE(83);
      END_STATE();
    case 16:
      if (lookahead == 'c') ADVANCE(23);
      END_STATE();
    case 17:
      if (lookahead == 'd') ADVANCE(25);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(22);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(16);
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(4);
      END_STATE();
    case 21:
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(20);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(18);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 25:
      if (lookahead == 'y') ADVANCE(3);
      END_STATE();
    case 26:
      if (lookahead == '|') ADVANCE(78);
      END_STATE();
    case 27:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (lookahead == '!') ADVANCE(97);
      if (lookahead == '"') ADVANCE(85);
      if (lookahead == '$') ADVANCE(64);
      if (lookahead == '\'') ADVANCE(68);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(38);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '-') ADVANCE(74);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '?') ADVANCE(63);
      if (lookahead == ']') ADVANCE(36);
      if (lookahead == '`') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 28:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == '/') ADVANCE(6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 29:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(29);
      if (lookahead == '*') ADVANCE(54);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 30:
      if (eof) ADVANCE(33);
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '"') ADVANCE(85);
      if (lookahead == '#') ADVANCE(15);
      if (lookahead == '$') ADVANCE(2);
      if (lookahead == '%') ADVANCE(76);
      if (lookahead == '\'') ADVANCE(68);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(38);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == ',') ADVANCE(39);
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(55);
      if (lookahead == ':') ADVANCE(13);
      if (lookahead == ';') ADVANCE(34);
      if (lookahead == '<') ADVANCE(69);
      if (lookahead == '=') ADVANCE(60);
      if (lookahead == '>') ADVANCE(70);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == ']') ADVANCE(36);
      if (lookahead == '^') ADVANCE(77);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == '|') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 31:
      if (eof) ADVANCE(33);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (lookahead == '!') ADVANCE(98);
      if (lookahead == '"') ADVANCE(85);
      if (lookahead == '#') ADVANCE(15);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '%') ADVANCE(76);
      if (lookahead == '\'') ADVANCE(68);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(38);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == ',') ADVANCE(39);
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(55);
      if (lookahead == ':') ADVANCE(13);
      if (lookahead == ';') ADVANCE(34);
      if (lookahead == '<') ADVANCE(69);
      if (lookahead == '=') ADVANCE(60);
      if (lookahead == '>') ADVANCE(70);
      if (lookahead == '?') ADVANCE(63);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == ']') ADVANCE(36);
      if (lookahead == '^') ADVANCE(77);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == '|') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 32:
      if (eof) ADVANCE(33);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '"') ADVANCE(85);
      if (lookahead == '#') ADVANCE(15);
      if (lookahead == '$') ADVANCE(2);
      if (lookahead == '%') ADVANCE(76);
      if (lookahead == '\'') ADVANCE(68);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(38);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == ',') ADVANCE(39);
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(55);
      if (lookahead == ':') ADVANCE(13);
      if (lookahead == ';') ADVANCE(34);
      if (lookahead == '<') ADVANCE(69);
      if (lookahead == '=') ADVANCE(60);
      if (lookahead == '>') ADVANCE(70);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == ']') ADVANCE(36);
      if (lookahead == '^') ADVANCE(77);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == '|') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '*') ADVANCE(54);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(48);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(90);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '*') ADVANCE(52);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(48);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '-') ADVANCE(47);
      if (lookahead == '/') ADVANCE(45);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(46);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(48);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead == '*') ADVANCE(54);
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(9);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(48);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(90);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_marginalia_token1);
      if (lookahead == '*') ADVANCE(54);
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(9);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(49);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOLLAR);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_DOLLARfunction_DOLLAR);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DOLLARbody_DOLLAR);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(56);
      if (lookahead == 'b') ADVANCE(21);
      if (lookahead == 'f') ADVANCE(24);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym_parameter_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(80);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(72);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(40);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(40);
      if (lookahead == '>') ADVANCE(81);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '>') ADVANCE(82);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_DASH_GT_GT);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_POUND_GT);
      if (lookahead == '>') ADVANCE(84);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_POUND_GT_GT);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym__double_quote_string_token1);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(90);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym__double_quote_string_token1);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(89);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(90);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym__double_quote_string_token1);
      if (lookahead == '-') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(90);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym__double_quote_string_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(89);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(90);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym__double_quote_string_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym__single_quote_string_token1);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead == '*') ADVANCE(50);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym__single_quote_string_token1);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(95);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym__single_quote_string_token1);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead == '-') ADVANCE(41);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym__single_quote_string_token1);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym__single_quote_string_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(95);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym__natural_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_bang);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_bang);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym__identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'C') ADVANCE(2);
      if (lookahead == 'D') ADVANCE(3);
      if (lookahead == 'H') ADVANCE(4);
      if (lookahead == 'M') ADVANCE(5);
      if (lookahead == 'S') ADVANCE(6);
      if (lookahead == 'W') ADVANCE(7);
      if (lookahead == 'a') ADVANCE(8);
      if (lookahead == 'c') ADVANCE(9);
      if (lookahead == 'd') ADVANCE(10);
      if (lookahead == 'h') ADVANCE(11);
      if (lookahead == 'm') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(14);
      if (lookahead == 'y') ADVANCE(15);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(16);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(17);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(18);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(19);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(20);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(21);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(22);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(23);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(24);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(25);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(26);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(27);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(28);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(29);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(30);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(31);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(32);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      END_STATE();
    case 1:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(34);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(35);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(36);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(37);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(38);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(39);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(40);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(41);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(42);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(43);
      END_STATE();
    case 2:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(44);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(45);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(46);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(47);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(48);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(49);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 3:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(51);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(53);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(54);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(55);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym_H);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(56);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 5:
      ACCEPT_TOKEN(anon_sym_M);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(58);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(59);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(60);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 6:
      ACCEPT_TOKEN(anon_sym_S);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(62);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(63);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(64);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(65);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(66);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(67);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(68);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(69);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(70);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(71);
      END_STATE();
    case 7:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(72);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(73);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 8:
      if (lookahead == 'g') ADVANCE(75);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(34);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(35);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(36);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(37);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(38);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(39);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(40);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(41);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(42);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(43);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(76);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(44);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(45);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(46);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(47);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(48);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(49);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(anon_sym_d);
      if (lookahead == 'A') ADVANCE(51);
      if (lookahead == 'E') ADVANCE(52);
      if (lookahead == 'a') ADVANCE(77);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(53);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(54);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(55);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(79);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(56);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_m);
      if (lookahead == 'I') ADVANCE(60);
      if (lookahead == 'O') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(80);
      if (lookahead == 'o') ADVANCE(81);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(58);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 13:
      if (lookahead == 'E') ADVANCE(64);
      if (lookahead == 'e') ADVANCE(82);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(62);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(63);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(65);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(66);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(67);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(68);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(69);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(70);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(71);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(83);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(72);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(73);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_y);
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 16:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(86);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(87);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(88);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(89);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 17:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(91);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(92);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(93);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(94);
      END_STATE();
    case 18:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(95);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(97);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(98);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(99);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(100);
      END_STATE();
    case 19:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(101);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(102);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 20:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(104);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(105);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(106);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(107);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(108);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(109);
      END_STATE();
    case 21:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(110);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(111);
      END_STATE();
    case 22:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(112);
      END_STATE();
    case 23:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(114);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(115);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 24:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(117);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(118);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(119);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(120);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(121);
      END_STATE();
    case 25:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(122);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(123);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(124);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(125);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(126);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(127);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(128);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(129);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(130);
      END_STATE();
    case 26:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(131);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(132);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 27:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(134);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(135);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(136);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(137);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(138);
      END_STATE();
    case 28:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(139);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(140);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(141);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(142);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(144);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(145);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(146);
      END_STATE();
    case 29:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(147);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(148);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(149);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(150);
      END_STATE();
    case 30:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(151);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(152);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(153);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(154);
      END_STATE();
    case 31:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(155);
      END_STATE();
    case 32:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(156);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(157);
      END_STATE();
    case 33:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'C') ADVANCE(2);
      if (lookahead == 'D') ADVANCE(3);
      if (lookahead == 'H') ADVANCE(4);
      if (lookahead == 'M') ADVANCE(5);
      if (lookahead == 'S') ADVANCE(6);
      if (lookahead == 'W') ADVANCE(7);
      if (lookahead == 'a') ADVANCE(8);
      if (lookahead == 'c') ADVANCE(9);
      if (lookahead == 'd') ADVANCE(10);
      if (lookahead == 'h') ADVANCE(11);
      if (lookahead == 'm') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(14);
      if (lookahead == 'y') ADVANCE(15);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(16);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(17);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(18);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(19);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(20);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(21);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(22);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(23);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(24);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(25);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(26);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(27);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(28);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(29);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(30);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(31);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(32);
      END_STATE();
    case 34:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(158);
      END_STATE();
    case 35:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(159);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(160);
      END_STATE();
    case 36:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(161);
      END_STATE();
    case 37:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(162);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(163);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(164);
      END_STATE();
    case 38:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(165);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(166);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(167);
      END_STATE();
    case 39:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(168);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_keyword_as);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(169);
      END_STATE();
    case 41:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(170);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(171);
      END_STATE();
    case 42:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(172);
      END_STATE();
    case 43:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(173);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 44:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(175);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(176);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(177);
      END_STATE();
    case 45:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(178);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 46:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(180);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(181);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(182);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(183);
      END_STATE();
    case 47:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(184);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 48:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(186);
      END_STATE();
    case 49:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(187);
      END_STATE();
    case 50:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(188);
      END_STATE();
    case 51:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(189);
      END_STATE();
    case 52:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(190);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(191);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(192);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(193);
      END_STATE();
    case 53:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(194);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_keyword_do);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(195);
      END_STATE();
    case 55:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(196);
      END_STATE();
    case 56:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(197);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(198);
      END_STATE();
    case 57:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(199);
      END_STATE();
    case 58:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(200);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(201);
      END_STATE();
    case 59:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(202);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(203);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(204);
      END_STATE();
    case 60:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(205);
      END_STATE();
    case 61:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(206);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(207);
      END_STATE();
    case 62:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(208);
      END_STATE();
    case 63:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(209);
      END_STATE();
    case 64:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(210);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(211);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(212);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(213);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(214);
      END_STATE();
    case 65:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(215);
      END_STATE();
    case 66:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(216);
      END_STATE();
    case 67:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(217);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(218);
      END_STATE();
    case 68:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(219);
      END_STATE();
    case 69:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(220);
      END_STATE();
    case 70:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(221);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(222);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(223);
      END_STATE();
    case 71:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(224);
      END_STATE();
    case 72:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 73:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(226);
      END_STATE();
    case 74:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(227);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(228);
      END_STATE();
    case 75:
      if (lookahead == 'o') ADVANCE(229);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 77:
      if (lookahead == 'y') ADVANCE(231);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(189);
      END_STATE();
    case 78:
      if (lookahead == 'C') ADVANCE(190);
      if (lookahead == 'c') ADVANCE(232);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(191);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(192);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(193);
      END_STATE();
    case 79:
      if (lookahead == 'u') ADVANCE(233);
      END_STATE();
    case 80:
      if (lookahead == 'N') ADVANCE(205);
      if (lookahead == 'c') ADVANCE(234);
      if (lookahead == 'l') ADVANCE(235);
      if (lookahead == 'n') ADVANCE(236);
      END_STATE();
    case 81:
      if (lookahead == 'N') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(237);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(206);
      END_STATE();
    case 82:
      if (lookahead == 'c') ADVANCE(238);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(210);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(211);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(212);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(213);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(214);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(239);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(240);
      END_STATE();
    case 85:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(241);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(242);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(243);
      END_STATE();
    case 86:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(244);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(245);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(246);
      END_STATE();
    case 87:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(247);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(248);
      END_STATE();
    case 88:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(249);
      END_STATE();
    case 89:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(250);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_keyword_by);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(251);
      END_STATE();
    case 91:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(252);
      END_STATE();
    case 92:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(253);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(254);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(255);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(256);
      END_STATE();
    case 93:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(257);
      END_STATE();
    case 94:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(258);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(259);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(260);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(261);
      END_STATE();
    case 95:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(262);
      END_STATE();
    case 96:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(263);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(264);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 97:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(266);
      END_STATE();
    case 98:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(267);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(268);
      END_STATE();
    case 99:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(269);
      END_STATE();
    case 100:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(270);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 101:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(272);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(273);
      END_STATE();
    case 102:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(274);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(275);
      END_STATE();
    case 103:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(276);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_keyword_if);
      END_STATE();
    case 105:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(277);
      END_STATE();
    case 106:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(278);
      END_STATE();
    case 107:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(279);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(280);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_keyword_in);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(281);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(282);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(283);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(284);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(285);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(286);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(287);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_keyword_is);
      END_STATE();
    case 110:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(288);
      END_STATE();
    case 111:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(289);
      END_STATE();
    case 112:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(290);
      END_STATE();
    case 113:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(291);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(292);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(293);
      END_STATE();
    case 114:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(294);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(295);
      END_STATE();
    case 115:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(296);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(297);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(298);
      END_STATE();
    case 116:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(299);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(300);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(301);
      END_STATE();
    case 117:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(302);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(303);
      END_STATE();
    case 118:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(304);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_keyword_no);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(305);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(306);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(307);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(308);
      END_STATE();
    case 120:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(309);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(310);
      END_STATE();
    case 121:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(311);
      END_STATE();
    case 122:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(312);
      END_STATE();
    case 123:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(313);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_keyword_on);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(314);
      END_STATE();
    case 125:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(315);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_keyword_or);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(316);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(317);
      END_STATE();
    case 127:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(318);
      END_STATE();
    case 128:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(319);
      END_STATE();
    case 129:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(320);
      END_STATE();
    case 130:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(321);
      END_STATE();
    case 131:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(322);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(323);
      END_STATE();
    case 132:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(324);
      END_STATE();
    case 133:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(325);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(326);
      END_STATE();
    case 134:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(327);
      END_STATE();
    case 135:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(328);
      END_STATE();
    case 136:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(329);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(330);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(331);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(332);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(333);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(334);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(335);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(336);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(337);
      END_STATE();
    case 137:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(338);
      END_STATE();
    case 138:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(339);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(340);
      END_STATE();
    case 139:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(341);
      END_STATE();
    case 140:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(342);
      END_STATE();
    case 141:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(343);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(344);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(345);
      END_STATE();
    case 142:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(346);
      END_STATE();
    case 143:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(347);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(348);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(349);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_keyword_to);
      END_STATE();
    case 145:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(350);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(351);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(352);
      END_STATE();
    case 146:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(353);
      END_STATE();
    case 147:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(354);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(355);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(356);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(357);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(358);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(359);
      END_STATE();
    case 148:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(360);
      END_STATE();
    case 149:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(361);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(362);
      END_STATE();
    case 150:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(363);
      END_STATE();
    case 151:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(364);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(365);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(366);
      END_STATE();
    case 152:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(367);
      END_STATE();
    case 153:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(368);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(369);
      END_STATE();
    case 154:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(370);
      END_STATE();
    case 155:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(371);
      END_STATE();
    case 156:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(372);
      END_STATE();
    case 157:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(373);
      END_STATE();
    case 158:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(374);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_keyword_add);
      END_STATE();
    case 160:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(375);
      END_STATE();
    case 161:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(376);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_keyword_all);
      END_STATE();
    case 163:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(377);
      END_STATE();
    case 164:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(378);
      END_STATE();
    case 165:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(379);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_keyword_and);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_keyword_any);
      END_STATE();
    case 168:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(380);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_keyword_asc);
      END_STATE();
    case 170:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(381);
      END_STATE();
    case 171:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(382);
      END_STATE();
    case 172:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(383);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(384);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_keyword_avg);
      END_STATE();
    case 174:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(385);
      END_STATE();
    case 175:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(386);
      END_STATE();
    case 176:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(387);
      END_STATE();
    case 177:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(388);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(389);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(390);
      END_STATE();
    case 178:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(391);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(392);
      END_STATE();
    case 179:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(393);
      END_STATE();
    case 180:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(394);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(395);
      END_STATE();
    case 181:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(396);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(397);
      END_STATE();
    case 182:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(398);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(399);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(400);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(401);
      END_STATE();
    case 183:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(402);
      END_STATE();
    case 184:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(403);
      END_STATE();
    case 185:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(404);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_keyword_csv);
      END_STATE();
    case 187:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(405);
      END_STATE();
    case 188:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(406);
      END_STATE();
    case 189:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(407);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(408);
      END_STATE();
    case 190:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(409);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(410);
      END_STATE();
    case 191:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(411);
      END_STATE();
    case 192:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(412);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(413);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(414);
      END_STATE();
    case 193:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(415);
      END_STATE();
    case 194:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(416);
      END_STATE();
    case 195:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(417);
      END_STATE();
    case 196:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(418);
      END_STATE();
    case 197:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(419);
      END_STATE();
    case 198:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(420);
      END_STATE();
    case 199:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(421);
      END_STATE();
    case 200:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(422);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(423);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_keyword_max);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(424);
      END_STATE();
    case 202:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(425);
      END_STATE();
    case 203:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(426);
      END_STATE();
    case 204:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(427);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_keyword_min);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(428);
      END_STATE();
    case 206:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(429);
      END_STATE();
    case 207:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(430);
      END_STATE();
    case 208:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(431);
      END_STATE();
    case 209:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(432);
      END_STATE();
    case 210:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(433);
      END_STATE();
    case 211:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(434);
      END_STATE();
    case 212:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(435);
      END_STATE();
    case 213:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(436);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_keyword_set);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(437);
      END_STATE();
    case 215:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(438);
      END_STATE();
    case 216:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(439);
      END_STATE();
    case 217:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(440);
      END_STATE();
    case 218:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(441);
      END_STATE();
    case 219:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(442);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_keyword_sql);
      END_STATE();
    case 221:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(443);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(444);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(445);
      END_STATE();
    case 222:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(446);
      END_STATE();
    case 223:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(447);
      END_STATE();
    case 224:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(448);
      END_STATE();
    case 225:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(449);
      END_STATE();
    case 226:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(450);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(451);
      END_STATE();
    case 227:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(452);
      END_STATE();
    case 228:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(453);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_ago);
      END_STATE();
    case 230:
      if (lookahead == 't') ADVANCE(454);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_day);
      if (lookahead == 's') ADVANCE(455);
      END_STATE();
    case 232:
      if (lookahead == 'a') ADVANCE(456);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(409);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(410);
      END_STATE();
    case 233:
      if (lookahead == 'r') ADVANCE(457);
      END_STATE();
    case 234:
      if (lookahead == 'r') ADVANCE(458);
      END_STATE();
    case 235:
      if (lookahead == 'l') ADVANCE(459);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_keyword_min);
      if (lookahead == 'u') ADVANCE(460);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(428);
      END_STATE();
    case 237:
      if (lookahead == 't') ADVANCE(461);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(430);
      END_STATE();
    case 238:
      if (lookahead == 'o') ADVANCE(462);
      END_STATE();
    case 239:
      if (lookahead == 'k') ADVANCE(463);
      END_STATE();
    case 240:
      if (lookahead == 'r') ADVANCE(464);
      END_STATE();
    case 241:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(465);
      END_STATE();
    case 242:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(466);
      END_STATE();
    case 243:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(467);
      END_STATE();
    case 244:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(468);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(469);
      END_STATE();
    case 245:
      if (lookahead == '_') ADVANCE(470);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(471);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_keyword_bit);
      END_STATE();
    case 247:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(472);
      END_STATE();
    case 248:
      if (lookahead == '2') ADVANCE(473);
      if (lookahead == '3') ADVANCE(474);
      END_STATE();
    case 249:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(475);
      END_STATE();
    case 250:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(476);
      END_STATE();
    case 251:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(477);
      END_STATE();
    case 252:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(478);
      END_STATE();
    case 253:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(479);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_keyword_end);
      END_STATE();
    case 255:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(480);
      END_STATE();
    case 256:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(481);
      END_STATE();
    case 257:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(482);
      END_STATE();
    case 258:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(483);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(484);
      END_STATE();
    case 259:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(485);
      END_STATE();
    case 260:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(486);
      END_STATE();
    case 261:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(487);
      END_STATE();
    case 262:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(488);
      END_STATE();
    case 263:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(489);
      END_STATE();
    case 264:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(490);
      END_STATE();
    case 265:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(491);
      END_STATE();
    case 266:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(492);
      END_STATE();
    case 267:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(493);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_keyword_for);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(494);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(495);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(496);
      END_STATE();
    case 269:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(497);
      END_STATE();
    case 270:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(498);
      END_STATE();
    case 271:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(499);
      END_STATE();
    case 272:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(500);
      END_STATE();
    case 273:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(501);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(502);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_keyword_gin);
      END_STATE();
    case 275:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(503);
      END_STATE();
    case 276:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(504);
      END_STATE();
    case 277:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(505);
      END_STATE();
    case 278:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(506);
      END_STATE();
    case 279:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(507);
      END_STATE();
    case 280:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(508);
      END_STATE();
    case 281:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(509);
      END_STATE();
    case 282:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(510);
      END_STATE();
    case 283:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(511);
      END_STATE();
    case 284:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(512);
      END_STATE();
    case 285:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(513);
      END_STATE();
    case 286:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(514);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(aux_sym_keyword_int_token1);
      if (lookahead == '1') ADVANCE(515);
      if (lookahead == '2') ADVANCE(516);
      if (lookahead == '3') ADVANCE(517);
      if (lookahead == '4') ADVANCE(518);
      if (lookahead == '8') ADVANCE(519);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(520);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(521);
      END_STATE();
    case 288:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(522);
      END_STATE();
    case 289:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(523);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_keyword_key);
      END_STATE();
    case 291:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(524);
      END_STATE();
    case 292:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(525);
      END_STATE();
    case 293:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(526);
      END_STATE();
    case 294:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(527);
      END_STATE();
    case 295:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(528);
      END_STATE();
    case 296:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(529);
      END_STATE();
    case 297:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(530);
      END_STATE();
    case 298:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(531);
      END_STATE();
    case 299:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(532);
      END_STATE();
    case 300:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(533);
      END_STATE();
    case 301:
      if (lookahead == '_') ADVANCE(534);
      END_STATE();
    case 302:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(535);
      END_STATE();
    case 303:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(536);
      END_STATE();
    case 304:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(537);
      END_STATE();
    case 305:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(538);
      END_STATE();
    case 306:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(539);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_keyword_not);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(540);
      END_STATE();
    case 308:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(541);
      END_STATE();
    case 309:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(542);
      END_STATE();
    case 310:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(543);
      END_STATE();
    case 311:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(544);
      END_STATE();
    case 312:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(545);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_keyword_oid);
      END_STATE();
    case 314:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(546);
      END_STATE();
    case 315:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(547);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_keyword_orc);
      END_STATE();
    case 317:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(548);
      END_STATE();
    case 318:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(549);
      END_STATE();
    case 319:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(550);
      END_STATE();
    case 320:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(551);
      END_STATE();
    case 321:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(552);
      END_STATE();
    case 322:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(553);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(554);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(555);
      END_STATE();
    case 323:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(556);
      END_STATE();
    case 324:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(557);
      END_STATE();
    case 325:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(558);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(559);
      END_STATE();
    case 326:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(560);
      END_STATE();
    case 327:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(561);
      END_STATE();
    case 328:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(562);
      END_STATE();
    case 329:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(563);
      END_STATE();
    case 330:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(564);
      END_STATE();
    case 331:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(565);
      END_STATE();
    case 332:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(566);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(567);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(568);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(569);
      END_STATE();
    case 333:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(570);
      END_STATE();
    case 334:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(571);
      END_STATE();
    case 335:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(572);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(573);
      END_STATE();
    case 336:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(574);
      END_STATE();
    case 337:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(575);
      END_STATE();
    case 338:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(576);
      END_STATE();
    case 339:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(577);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(578);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_keyword_row);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(579);
      END_STATE();
    case 341:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(580);
      END_STATE();
    case 342:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(581);
      END_STATE();
    case 343:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(582);
      END_STATE();
    case 344:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(583);
      END_STATE();
    case 345:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(584);
      END_STATE();
    case 346:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(585);
      END_STATE();
    case 347:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(586);
      END_STATE();
    case 348:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(587);
      END_STATE();
    case 349:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(588);
      END_STATE();
    case 350:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(589);
      END_STATE();
    case 351:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(590);
      END_STATE();
    case 352:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(591);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(592);
      END_STATE();
    case 353:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(593);
      END_STATE();
    case 354:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(594);
      END_STATE();
    case 355:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(595);
      END_STATE();
    case 356:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(596);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(597);
      END_STATE();
    case 357:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(598);
      END_STATE();
    case 358:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(599);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(600);
      END_STATE();
    case 359:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(601);
      END_STATE();
    case 360:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(602);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_keyword_use);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(603);
      END_STATE();
    case 362:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(604);
      END_STATE();
    case 363:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(605);
      END_STATE();
    case 364:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(606);
      END_STATE();
    case 365:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(607);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(608);
      END_STATE();
    case 366:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(609);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(610);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(611);
      END_STATE();
    case 367:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(612);
      END_STATE();
    case 368:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(613);
      END_STATE();
    case 369:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(614);
      END_STATE();
    case 370:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(615);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_keyword_xml);
      END_STATE();
    case 372:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(616);
      END_STATE();
    case 373:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(617);
      END_STATE();
    case 374:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(618);
      END_STATE();
    case 375:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(619);
      END_STATE();
    case 376:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(620);
      END_STATE();
    case 377:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(621);
      END_STATE();
    case 378:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(622);
      END_STATE();
    case 379:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(623);
      END_STATE();
    case 380:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(624);
      END_STATE();
    case 381:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(625);
      END_STATE();
    case 382:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(626);
      END_STATE();
    case 383:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(627);
      END_STATE();
    case 384:
      if (lookahead == '_') ADVANCE(628);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_keyword_avro);
      END_STATE();
    case 386:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(629);
      END_STATE();
    case 387:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(630);
      END_STATE();
    case 388:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(631);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_keyword_case);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_keyword_cast);
      END_STATE();
    case 391:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(632);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(aux_sym_keyword_char_token1);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(633);
      END_STATE();
    case 393:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(634);
      END_STATE();
    case 394:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(635);
      END_STATE();
    case 395:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(636);
      END_STATE();
    case 396:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(637);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(638);
      END_STATE();
    case 397:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(639);
      END_STATE();
    case 398:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(640);
      END_STATE();
    case 399:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(641);
      END_STATE();
    case 400:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(642);
      END_STATE();
    case 401:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(643);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_keyword_cost);
      END_STATE();
    case 403:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(644);
      END_STATE();
    case 404:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(645);
      END_STATE();
    case 405:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(646);
      END_STATE();
    case 406:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(647);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_keyword_data);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(648);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_keyword_date);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(649);
      END_STATE();
    case 409:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(650);
      END_STATE();
    case 410:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(651);
      END_STATE();
    case 411:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(652);
      END_STATE();
    case 412:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(653);
      END_STATE();
    case 413:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(654);
      END_STATE();
    case 414:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(655);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_keyword_desc);
      END_STATE();
    case 416:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(656);
      END_STATE();
    case 417:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(657);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_keyword_drop);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_keyword_hash);
      END_STATE();
    case 420:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(658);
      END_STATE();
    case 421:
      if (lookahead == '_') ADVANCE(659);
      END_STATE();
    case 422:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(660);
      END_STATE();
    case 423:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(661);
      END_STATE();
    case 424:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(662);
      END_STATE();
    case 425:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(663);
      END_STATE();
    case 426:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(664);
      END_STATE();
    case 427:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(665);
      END_STATE();
    case 428:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(666);
      END_STATE();
    case 429:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(667);
      END_STATE();
    case 430:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(668);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym_keyword_safe);
      END_STATE();
    case 432:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(669);
      END_STATE();
    case 433:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(670);
      END_STATE();
    case 434:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(671);
      END_STATE();
    case 435:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(672);
      END_STATE();
    case 436:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(673);
      END_STATE();
    case 437:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(674);
      END_STATE();
    case 438:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(675);
      END_STATE();
    case 439:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(676);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_keyword_some);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_keyword_sort);
      END_STATE();
    case 442:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(677);
      END_STATE();
    case 443:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(678);
      END_STATE();
    case 444:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(679);
      END_STATE();
    case 445:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(680);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(681);
      END_STATE();
    case 446:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(682);
      END_STATE();
    case 447:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(683);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(684);
      END_STATE();
    case 448:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(685);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_keyword_wait);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym_keyword_when);
      END_STATE();
    case 451:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(686);
      END_STATE();
    case 452:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(687);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(aux_sym_keyword_with_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(688);
      END_STATE();
    case 454:
      if (lookahead == 'u') ADVANCE(689);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_days);
      END_STATE();
    case 456:
      if (lookahead == 'd') ADVANCE(690);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_hour);
      if (lookahead == 's') ADVANCE(691);
      END_STATE();
    case 458:
      if (lookahead == 'o') ADVANCE(692);
      END_STATE();
    case 459:
      if (lookahead == 'e') ADVANCE(693);
      if (lookahead == 'i') ADVANCE(694);
      END_STATE();
    case 460:
      if (lookahead == 't') ADVANCE(695);
      END_STATE();
    case 461:
      if (lookahead == 'h') ADVANCE(696);
      END_STATE();
    case 462:
      if (lookahead == 'n') ADVANCE(697);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_week);
      if (lookahead == 's') ADVANCE(698);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_year);
      if (lookahead == 's') ADVANCE(699);
      END_STATE();
    case 465:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(700);
      END_STATE();
    case 466:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(701);
      END_STATE();
    case 467:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(702);
      END_STATE();
    case 468:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(703);
      END_STATE();
    case 469:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(704);
      END_STATE();
    case 470:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(705);
      END_STATE();
    case 471:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(706);
      END_STATE();
    case 472:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(707);
      END_STATE();
    case 473:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(708);
      END_STATE();
    case 474:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(709);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(sym_keyword_brin);
      END_STATE();
    case 476:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(710);
      END_STATE();
    case 477:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(711);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_keyword_else);
      END_STATE();
    case 479:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(712);
      END_STATE();
    case 480:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(713);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(sym_keyword_enum);
      END_STATE();
    case 482:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(714);
      END_STATE();
    case 483:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(715);
      END_STATE();
    case 484:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(716);
      END_STATE();
    case 485:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(717);
      END_STATE();
    case 486:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(718);
      END_STATE();
    case 487:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(719);
      END_STATE();
    case 488:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(720);
      END_STATE();
    case 489:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(721);
      END_STATE();
    case 490:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(722);
      END_STATE();
    case 491:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(723);
      END_STATE();
    case 492:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(724);
      END_STATE();
    case 493:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(725);
      END_STATE();
    case 494:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(726);
      END_STATE();
    case 495:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(727);
      END_STATE();
    case 496:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(728);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym_keyword_from);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym_keyword_full);
      END_STATE();
    case 499:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(729);
      END_STATE();
    case 500:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(730);
      END_STATE();
    case 501:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(731);
      END_STATE();
    case 502:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(732);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym_keyword_gist);
      END_STATE();
    case 504:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(733);
      END_STATE();
    case 505:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(734);
      END_STATE();
    case 506:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(735);
      END_STATE();
    case 507:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(736);
      END_STATE();
    case 508:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(737);
      END_STATE();
    case 509:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(738);
      END_STATE();
    case 510:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(739);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_keyword_inet);
      END_STATE();
    case 512:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(740);
      END_STATE();
    case 513:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(741);
      END_STATE();
    case 514:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(742);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(aux_sym_keyword_tinyint_token2);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(aux_sym_keyword_smallint_token2);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(aux_sym_keyword_mediumint_token2);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(aux_sym_keyword_int_token3);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(aux_sym_keyword_bigint_token2);
      END_STATE();
    case 520:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(743);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(744);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym_keyword_into);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_keyword_join);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_keyword_json);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(745);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(746);
      END_STATE();
    case 524:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(747);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym_keyword_last);
      END_STATE();
    case 526:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(748);
      END_STATE();
    case 527:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(749);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym_keyword_left);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(aux_sym_keyword_like_token1);
      END_STATE();
    case 530:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(750);
      END_STATE();
    case 531:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(751);
      END_STATE();
    case 532:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(752);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(753);
      END_STATE();
    case 533:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(754);
      END_STATE();
    case 534:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(755);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym_keyword_name);
      END_STATE();
    case 536:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(756);
      END_STATE();
    case 537:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(757);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_keyword_none);
      END_STATE();
    case 539:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(758);
      END_STATE();
    case 540:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(759);
      END_STATE();
    case 541:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(760);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_keyword_null);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(761);
      END_STATE();
    case 543:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(762);
      END_STATE();
    case 544:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(763);
      END_STATE();
    case 545:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(764);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_keyword_only);
      END_STATE();
    case 547:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(765);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(766);
      END_STATE();
    case 548:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(767);
      END_STATE();
    case 549:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(768);
      END_STATE();
    case 550:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(769);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_keyword_over);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(770);
      END_STATE();
    case 552:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(771);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(772);
      END_STATE();
    case 553:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(773);
      END_STATE();
    case 554:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(774);
      END_STATE();
    case 555:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(775);
      END_STATE();
    case 556:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(776);
      END_STATE();
    case 557:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(777);
      END_STATE();
    case 558:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(778);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(779);
      END_STATE();
    case 559:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(780);
      END_STATE();
    case 560:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(781);
      END_STATE();
    case 561:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(782);
      END_STATE();
    case 562:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(783);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(aux_sym_keyword_real_token1);
      END_STATE();
    case 564:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(784);
      END_STATE();
    case 565:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(785);
      END_STATE();
    case 566:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(786);
      END_STATE();
    case 567:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(787);
      END_STATE();
    case 568:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(788);
      END_STATE();
    case 569:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(789);
      END_STATE();
    case 570:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(790);
      END_STATE();
    case 571:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(791);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(792);
      END_STATE();
    case 572:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(793);
      END_STATE();
    case 573:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(794);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(795);
      END_STATE();
    case 574:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(796);
      END_STATE();
    case 575:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(797);
      END_STATE();
    case 576:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(798);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym_keyword_role);
      END_STATE();
    case 578:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(799);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym_keyword_rows);
      END_STATE();
    case 580:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(800);
      END_STATE();
    case 581:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(801);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym_keyword_temp);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(802);
      END_STATE();
    case 583:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(803);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym_keyword_text);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(804);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym_keyword_then);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym_keyword_ties);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(aux_sym_keyword_time_token1);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(805);
      END_STATE();
    case 588:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(806);
      END_STATE();
    case 589:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(807);
      END_STATE();
    case 590:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(808);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_keyword_true);
      END_STATE();
    case 592:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(809);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_keyword_type);
      END_STATE();
    case 594:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(810);
      END_STATE();
    case 595:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(811);
      END_STATE();
    case 596:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(812);
      END_STATE();
    case 597:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(813);
      END_STATE();
    case 598:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(814);
      END_STATE();
    case 599:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(815);
      END_STATE();
    case 600:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(816);
      END_STATE();
    case 601:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(817);
      END_STATE();
    case 602:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(818);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_keyword_user);
      END_STATE();
    case 604:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(819);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_keyword_uuid);
      END_STATE();
    case 606:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(820);
      END_STATE();
    case 607:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(821);
      END_STATE();
    case 608:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(822);
      END_STATE();
    case 609:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(823);
      END_STATE();
    case 610:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(824);
      END_STATE();
    case 611:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(825);
      END_STATE();
    case 612:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(826);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym_keyword_view);
      END_STATE();
    case 614:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(827);
      END_STATE();
    case 615:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(828);
      END_STATE();
    case 616:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(829);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(aux_sym_keyword_timestamp_token3);
      END_STATE();
    case 618:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(830);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_keyword_admin);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_keyword_after);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_keyword_alter);
      END_STATE();
    case 622:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(831);
      END_STATE();
    case 623:
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(832);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym_keyword_array);
      END_STATE();
    case 625:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(833);
      END_STATE();
    case 626:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(834);
      END_STATE();
    case 627:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(835);
      END_STATE();
    case 628:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(836);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_keyword_cache);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(837);
      END_STATE();
    case 630:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(838);
      END_STATE();
    case 631:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(839);
      END_STATE();
    case 632:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(840);
      END_STATE();
    case 633:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(841);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_keyword_check);
      END_STATE();
    case 635:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(842);
      END_STATE();
    case 636:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(843);
      END_STATE();
    case 637:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(844);
      END_STATE();
    case 638:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(845);
      END_STATE();
    case 639:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(846);
      END_STATE();
    case 640:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(847);
      END_STATE();
    case 641:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(848);
      END_STATE();
    case 642:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(849);
      END_STATE();
    case 643:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(850);
      END_STATE();
    case 644:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(851);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym_keyword_cross);
      END_STATE();
    case 646:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(852);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym_keyword_cycle);
      END_STATE();
    case 648:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(853);
      END_STATE();
    case 649:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(854);
      END_STATE();
    case 650:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(855);
      END_STATE();
    case 651:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(856);
      END_STATE();
    case 652:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(857);
      END_STATE();
    case 653:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(858);
      END_STATE();
    case 654:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(859);
      END_STATE();
    case 655:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(860);
      END_STATE();
    case 656:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(861);
      END_STATE();
    case 657:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(862);
      END_STATE();
    case 658:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(863);
      END_STATE();
    case 659:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(864);
      END_STATE();
    case 660:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(865);
      END_STATE();
    case 661:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(866);
      END_STATE();
    case 662:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(867);
      END_STATE();
    case 663:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(868);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym_keyword_merge);
      END_STATE();
    case 665:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(869);
      END_STATE();
    case 666:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(870);
      END_STATE();
    case 667:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(871);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym_keyword_money);
      END_STATE();
    case 669:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(872);
      END_STATE();
    case 670:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(873);
      END_STATE();
    case 671:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(874);
      END_STATE();
    case 672:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(875);
      END_STATE();
    case 673:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(876);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym_keyword_setof);
      END_STATE();
    case 675:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(877);
      END_STATE();
    case 676:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(878);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(879);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(880);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(881);
      END_STATE();
    case 677:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(882);
      END_STATE();
    case 678:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(883);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym_keyword_start);
      END_STATE();
    case 680:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(884);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym_keyword_stats);
      END_STATE();
    case 682:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(885);
      END_STATE();
    case 683:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(886);
      END_STATE();
    case 684:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(887);
      END_STATE();
    case 685:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(888);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym_keyword_where);
      END_STATE();
    case 687:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(889);
      END_STATE();
    case 688:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(890);
      END_STATE();
    case 689:
      if (lookahead == 'r') ADVANCE(891);
      END_STATE();
    case 690:
      if (lookahead == 'e') ADVANCE(892);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(anon_sym_hours);
      END_STATE();
    case 692:
      if (lookahead == 's') ADVANCE(893);
      END_STATE();
    case 693:
      if (lookahead == 'n') ADVANCE(894);
      END_STATE();
    case 694:
      if (lookahead == 's') ADVANCE(895);
      END_STATE();
    case 695:
      if (lookahead == 'e') ADVANCE(896);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(anon_sym_month);
      if (lookahead == 's') ADVANCE(897);
      END_STATE();
    case 697:
      if (lookahead == 'd') ADVANCE(898);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(anon_sym_weeks);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(anon_sym_years);
      END_STATE();
    case 700:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(899);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym_keyword_begin);
      END_STATE();
    case 702:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(900);
      END_STATE();
    case 703:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(901);
      END_STATE();
    case 704:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(902);
      END_STATE();
    case 705:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(903);
      END_STATE();
    case 706:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(904);
      END_STATE();
    case 707:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(905);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym_keyword_box2d);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym_keyword_box3d);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym_keyword_btree);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym_keyword_bytea);
      END_STATE();
    case 712:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(906);
      END_STATE();
    case 713:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(907);
      END_STATE();
    case 714:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(908);
      END_STATE();
    case 715:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(909);
      END_STATE();
    case 716:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(910);
      END_STATE();
    case 717:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(911);
      END_STATE();
    case 718:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(912);
      END_STATE();
    case 719:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(913);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_keyword_false);
      END_STATE();
    case 721:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(914);
      END_STATE();
    case 722:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(915);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_keyword_first);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_keyword_float);
      if (lookahead == '4') ADVANCE(916);
      if (lookahead == '8') ADVANCE(917);
      END_STATE();
    case 725:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(918);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym_keyword_force);
      END_STATE();
    case 727:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(919);
      END_STATE();
    case 728:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(920);
      END_STATE();
    case 729:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(921);
      END_STATE();
    case 730:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(922);
      END_STATE();
    case 731:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(923);
      END_STATE();
    case 732:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(924);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym_keyword_group);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(925);
      END_STATE();
    case 734:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(926);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(aux_sym_keyword_like_token2);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym_keyword_image);
      END_STATE();
    case 737:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(927);
      END_STATE();
    case 738:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(928);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym_keyword_index);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_keyword_inner);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_keyword_input);
      END_STATE();
    case 742:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(929);
      END_STATE();
    case 743:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(930);
      END_STATE();
    case 744:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(931);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(932);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_keyword_jsonb);
      END_STATE();
    case 746:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(933);
      END_STATE();
    case 747:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(934);
      END_STATE();
    case 748:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(935);
      END_STATE();
    case 749:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(936);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_keyword_limit);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_keyword_lines);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_keyword_local);
      END_STATE();
    case 753:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(937);
      END_STATE();
    case 754:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(938);
      END_STATE();
    case 755:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(939);
      END_STATE();
    case 756:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(940);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym_keyword_nchar);
      END_STATE();
    case 758:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(941);
      END_STATE();
    case 759:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(942);
      END_STATE();
    case 760:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(943);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym_keyword_nulls);
      END_STATE();
    case 762:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(944);
      END_STATE();
    case 763:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(945);
      END_STATE();
    case 764:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(946);
      END_STATE();
    case 765:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(947);
      END_STATE();
    case 766:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(948);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_keyword_order);
      END_STATE();
    case 768:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(949);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym_keyword_outer);
      END_STATE();
    case 770:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(950);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym_keyword_owned);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym_keyword_owner);
      END_STATE();
    case 773:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(951);
      END_STATE();
    case 774:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(952);
      END_STATE();
    case 775:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(953);
      END_STATE();
    case 776:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(954);
      END_STATE();
    case 777:
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(955);
      END_STATE();
    case 778:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(956);
      END_STATE();
    case 779:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(957);
      END_STATE();
    case 780:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(958);
      END_STATE();
    case 781:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(959);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym_keyword_range);
      END_STATE();
    case 783:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(960);
      END_STATE();
    case 784:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(961);
      END_STATE();
    case 785:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(962);
      END_STATE();
    case 786:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(963);
      END_STATE();
    case 787:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(964);
      END_STATE();
    case 788:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(965);
      END_STATE();
    case 789:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(966);
      END_STATE();
    case 790:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(967);
      END_STATE();
    case 791:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(968);
      END_STATE();
    case 792:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(969);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym_keyword_reset);
      END_STATE();
    case 794:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(970);
      END_STATE();
    case 795:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(971);
      END_STATE();
    case 796:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(972);
      END_STATE();
    case 797:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(973);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym_keyword_right);
      END_STATE();
    case 799:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(974);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_keyword_table);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(975);
      END_STATE();
    case 801:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(976);
      END_STATE();
    case 802:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(977);
      END_STATE();
    case 803:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(978);
      END_STATE();
    case 804:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(979);
      END_STATE();
    case 805:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(980);
      END_STATE();
    case 806:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(981);
      END_STATE();
    case 807:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(982);
      END_STATE();
    case 808:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(983);
      END_STATE();
    case 809:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(984);
      END_STATE();
    case 810:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(985);
      END_STATE();
    case 811:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(986);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_keyword_union);
      END_STATE();
    case 813:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(987);
      END_STATE();
    case 814:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(988);
      END_STATE();
    case 815:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(989);
      END_STATE();
    case 816:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(990);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_keyword_until);
      END_STATE();
    case 818:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(991);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_keyword_using);
      END_STATE();
    case 820:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(992);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_keyword_valid);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_keyword_value);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(993);
      END_STATE();
    case 823:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(994);
      END_STATE();
    case 824:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(995);
      END_STATE();
    case 825:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(996);
      END_STATE();
    case 826:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(997);
      END_STATE();
    case 827:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(998);
      END_STATE();
    case 828:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(999);
      END_STATE();
    case 829:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1000);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_keyword_action);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_keyword_always);
      END_STATE();
    case 832:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1001);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_keyword_atomic);
      END_STATE();
    case 834:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1002);
      END_STATE();
    case 835:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1003);
      END_STATE();
    case 836:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1004);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym_keyword_cached);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym_keyword_called);
      END_STATE();
    case 839:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1005);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym_keyword_change);
      END_STATE();
    case 841:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1006);
      END_STATE();
    case 842:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1007);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym_keyword_column);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1008);
      END_STATE();
    case 844:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1009);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym_keyword_commit);
      END_STATE();
    case 846:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1010);
      END_STATE();
    case 847:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1011);
      END_STATE();
    case 848:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1012);
      END_STATE();
    case 849:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1013);
      END_STATE();
    case 850:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1014);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym_keyword_create);
      END_STATE();
    case 852:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1015);
      END_STATE();
    case 853:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1016);
      END_STATE();
    case 854:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1017);
      END_STATE();
    case 855:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1018);
      END_STATE();
    case 856:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1019);
      END_STATE();
    case 857:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1020);
      END_STATE();
    case 858:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1021);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym_keyword_delete);
      END_STATE();
    case 860:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1022);
      END_STATE();
    case 861:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1023);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym_keyword_double);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym_keyword_having);
      END_STATE();
    case 864:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1024);
      END_STATE();
    case 865:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1025);
      END_STATE();
    case 866:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1026);
      END_STATE();
    case 867:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1027);
      END_STATE();
    case 868:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1028);
      END_STATE();
    case 869:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1029);
      END_STATE();
    case 870:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1030);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym_keyword_modify);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym_keyword_schema);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym_keyword_select);
      END_STATE();
    case 874:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1031);
      END_STATE();
    case 875:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1032);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(aux_sym_keyword_serial_token1);
      if (lookahead == '2') ADVANCE(1033);
      if (lookahead == '4') ADVANCE(1034);
      if (lookahead == '8') ADVANCE(1035);
      END_STATE();
    case 877:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1036);
      END_STATE();
    case 878:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1037);
      END_STATE();
    case 879:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1038);
      END_STATE();
    case 880:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1039);
      END_STATE();
    case 881:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1040);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(sym_keyword_spgist);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(sym_keyword_stable);
      END_STATE();
    case 884:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1041);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(sym_keyword_stored);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(sym_keyword_strict);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym_keyword_string);
      END_STATE();
    case 888:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1042);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym_keyword_window);
      END_STATE();
    case 890:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1043);
      END_STATE();
    case 891:
      if (lookahead == 'y') ADVANCE(1044);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(anon_sym_decade);
      END_STATE();
    case 893:
      if (lookahead == 'e') ADVANCE(1045);
      END_STATE();
    case 894:
      if (lookahead == 'n') ADVANCE(1046);
      END_STATE();
    case 895:
      if (lookahead == 'e') ADVANCE(1047);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(anon_sym_minute);
      if (lookahead == 's') ADVANCE(1048);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(anon_sym_months);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(anon_sym_second);
      if (lookahead == 's') ADVANCE(1049);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(sym_keyword_before);
      END_STATE();
    case 900:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1050);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(aux_sym_keyword_bigint_token1);
      END_STATE();
    case 902:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1051);
      END_STATE();
    case 903:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1052);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(sym_keyword_binary);
      END_STATE();
    case 905:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1053);
      END_STATE();
    case 906:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1054);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym_keyword_engine);
      END_STATE();
    case 908:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1055);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(sym_keyword_except);
      END_STATE();
    case 910:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1056);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(sym_keyword_exists);
      END_STATE();
    case 912:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1057);
      END_STATE();
    case 913:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1058);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(sym_keyword_fields);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(sym_keyword_filter);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(aux_sym_keyword_real_token2);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(aux_sym_double_token1);
      END_STATE();
    case 918:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1059);
      END_STATE();
    case 919:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1060);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(sym_keyword_format);
      END_STATE();
    case 921:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1061);
      END_STATE();
    case 922:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1062);
      END_STATE();
    case 923:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1063);
      END_STATE();
    case 924:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1064);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(sym_keyword_groups);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(sym_keyword_ignore);
      END_STATE();
    case 927:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1065);
      END_STATE();
    case 928:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1066);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(sym_keyword_insert);
      END_STATE();
    case 930:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1067);
      END_STATE();
    case 931:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1068);
      END_STATE();
    case 932:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1069);
      END_STATE();
    case 933:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1070);
      END_STATE();
    case 934:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1071);
      END_STATE();
    case 935:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1072);
      END_STATE();
    case 936:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1073);
      END_STATE();
    case 937:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1074);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(sym_keyword_logged);
      END_STATE();
    case 939:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1075);
      END_STATE();
    case 940:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1076);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(sym_keyword_noscan);
      END_STATE();
    case 942:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1077);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(sym_keyword_nowait);
      END_STATE();
    case 944:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1078);
      END_STATE();
    case 945:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1079);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(sym_keyword_offset);
      END_STATE();
    case 947:
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1080);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(sym_keyword_option);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1081);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(sym_keyword_others);
      END_STATE();
    case 950:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1082);
      END_STATE();
    case 951:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1083);
      END_STATE();
    case 952:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1084);
      END_STATE();
    case 953:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1085);
      END_STATE();
    case 954:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1086);
      END_STATE();
    case 955:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1087);
      END_STATE();
    case 956:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1088);
      END_STATE();
    case 957:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1089);
      END_STATE();
    case 958:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1090);
      END_STATE();
    case 959:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1091);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(sym_keyword_rcfile);
      END_STATE();
    case 961:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1092);
      END_STATE();
    case 962:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1093);
      END_STATE();
    case 963:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1094);
      END_STATE();
    case 964:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1095);
      END_STATE();
    case 965:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1096);
      END_STATE();
    case 966:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1097);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(sym_keyword_rename);
      END_STATE();
    case 968:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1098);
      END_STATE();
    case 969:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1099);
      END_STATE();
    case 970:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1100);
      END_STATE();
    case 971:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1101);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(sym_keyword_return);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1102);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1103);
      END_STATE();
    case 973:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1104);
      END_STATE();
    case 974:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1105);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(sym_keyword_tables);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1106);
      END_STATE();
    case 976:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1107);
      END_STATE();
    case 977:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1108);
      END_STATE();
    case 978:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1109);
      END_STATE();
    case 979:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1110);
      END_STATE();
    case 980:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1111);
      END_STATE();
    case 981:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1112);
      END_STATE();
    case 982:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1113);
      END_STATE();
    case 983:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1114);
      END_STATE();
    case 984:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1115);
      END_STATE();
    case 985:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1116);
      END_STATE();
    case 986:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1117);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym_keyword_unique);
      END_STATE();
    case 988:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1118);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(sym_keyword_unsafe);
      END_STATE();
    case 990:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1119);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(sym_keyword_update);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(sym_keyword_vacuum);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(sym_keyword_values);
      END_STATE();
    case 994:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1120);
      END_STATE();
    case 995:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1121);
      END_STATE();
    case 996:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1122);
      END_STATE();
    case 997:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1123);
      END_STATE();
    case 998:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1124);
      END_STATE();
    case 999:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1125);
      END_STATE();
    case 1000:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1126);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(sym_keyword_analyze);
      END_STATE();
    case 1002:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1127);
      END_STATE();
    case 1003:
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1128);
      END_STATE();
    case 1004:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1129);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(sym_keyword_cascade);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1130);
      END_STATE();
    case 1006:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1131);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(sym_keyword_collate);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(sym_keyword_columns);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(sym_keyword_comment);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(sym_keyword_compute);
      END_STATE();
    case 1011:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1132);
      END_STATE();
    case 1012:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1133);
      END_STATE();
    case 1013:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1134);
      END_STATE();
    case 1014:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1135);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(sym_keyword_current);
      if (lookahead == '_') ADVANCE(1136);
      END_STATE();
    case 1016:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1137);
      END_STATE();
    case 1017:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1138);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(sym_keyword_decimal);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(sym_keyword_declare);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(sym_keyword_default);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(sym_keyword_delayed);
      END_STATE();
    case 1022:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1139);
      END_STATE();
    case 1023:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1140);
      END_STATE();
    case 1024:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1141);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(sym_keyword_matched);
      END_STATE();
    case 1026:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1142);
      END_STATE();
    case 1027:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1143);
      END_STATE();
    case 1028:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1144);
      END_STATE();
    case 1029:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1145);
      END_STATE();
    case 1030:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1146);
      END_STATE();
    case 1031:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1147);
      END_STATE();
    case 1032:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1148);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(aux_sym_keyword_smallserial_token2);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(aux_sym_keyword_serial_token2);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(aux_sym_keyword_bigserial_token2);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(sym_keyword_similar);
      END_STATE();
    case 1037:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1149);
      END_STATE();
    case 1038:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1150);
      END_STATE();
    case 1039:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1151);
      END_STATE();
    case 1040:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1152);
      END_STATE();
    case 1041:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1153);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(sym_keyword_support);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(aux_sym_keyword_timestamp_token2);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(anon_sym_century);
      END_STATE();
    case 1045:
      if (lookahead == 'c') ADVANCE(1154);
      END_STATE();
    case 1046:
      if (lookahead == 'i') ADVANCE(1155);
      END_STATE();
    case 1047:
      if (lookahead == 'c') ADVANCE(1156);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(anon_sym_minutes);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(anon_sym_seconds);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(sym_keyword_between);
      END_STATE();
    case 1051:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1157);
      END_STATE();
    case 1052:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1158);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(sym_keyword_boolean);
      END_STATE();
    case 1054:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1159);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(sym_keyword_escaped);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(sym_keyword_exclude);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(sym_keyword_explain);
      END_STATE();
    case 1058:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1160);
      END_STATE();
    case 1059:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1161);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(sym_keyword_foreign);
      END_STATE();
    case 1061:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1162);
      END_STATE();
    case 1062:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1163);
      END_STATE();
    case 1063:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1164);
      END_STATE();
    case 1064:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1165);
      END_STATE();
    case 1065:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1166);
      END_STATE();
    case 1066:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1167);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(aux_sym_keyword_int_token2);
      END_STATE();
    case 1068:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1168);
      END_STATE();
    case 1069:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1169);
      END_STATE();
    case 1070:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1170);
      END_STATE();
    case 1071:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1171);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(sym_keyword_lateral);
      END_STATE();
    case 1073:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1172);
      END_STATE();
    case 1074:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1173);
      END_STATE();
    case 1075:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1174);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(sym_keyword_natural);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(sym_keyword_nothing);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(sym_keyword_numeric);
      END_STATE();
    case 1079:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1175);
      END_STATE();
    case 1080:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1176);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(sym_keyword_options);
      END_STATE();
    case 1082:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1177);
      END_STATE();
    case 1083:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1178);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(sym_keyword_parquet);
      END_STATE();
    case 1085:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1179);
      END_STATE();
    case 1086:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1180);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(sym_keyword_plpgsql);
      END_STATE();
    case 1088:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1181);
      END_STATE();
    case 1089:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1182);
      END_STATE();
    case 1090:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1183);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(sym_keyword_primary);
      END_STATE();
    case 1092:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1184);
      END_STATE();
    case 1093:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1185);
      END_STATE();
    case 1094:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1186);
      END_STATE();
    case 1095:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1187);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(sym_keyword_regproc);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(sym_keyword_regtype);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(sym_keyword_replace);
      END_STATE();
    case 1099:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1188);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(sym_keyword_restart);
      END_STATE();
    case 1101:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1189);
      END_STATE();
    case 1102:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1190);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(sym_keyword_returns);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(sym_keyword_rewrite);
      END_STATE();
    case 1105:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1191);
      END_STATE();
    case 1106:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1192);
      END_STATE();
    case 1107:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1193);
      END_STATE();
    case 1108:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1194);
      END_STATE();
    case 1109:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1195);
      END_STATE();
    case 1110:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1196);
      END_STATE();
    case 1111:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1197);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(aux_sym_keyword_tinyint_token1);
      END_STATE();
    case 1113:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1198);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(sym_keyword_trigger);
      END_STATE();
    case 1115:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1199);
      END_STATE();
    case 1116:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1200);
      END_STATE();
    case 1117:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1201);
      END_STATE();
    case 1118:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1202);
      END_STATE();
    case 1119:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1203);
      END_STATE();
    case 1120:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1204);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(aux_sym_keyword_varchar_token1);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(sym_keyword_varying);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(sym_keyword_verbose);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(sym_keyword_virtual);
      END_STATE();
    case 1125:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1205);
      END_STATE();
    case 1126:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1206);
      END_STATE();
    case 1127:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1207);
      END_STATE();
    case 1128:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1208);
      END_STATE();
    case 1129:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1209);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(sym_keyword_cascaded);
      END_STATE();
    case 1131:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1210);
      END_STATE();
    case 1132:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1211);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(sym_keyword_conflict);
      END_STATE();
    case 1134:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1212);
      END_STATE();
    case 1135:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1213);
      END_STATE();
    case 1136:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1214);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(sym_keyword_database);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(sym_keyword_datetime);
      if (lookahead == '2') ADVANCE(1215);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1216);
      END_STATE();
    case 1139:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1217);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(sym_keyword_distinct);
      END_STATE();
    case 1141:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1218);
      END_STATE();
    case 1142:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1219);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(sym_keyword_maxvalue);
      END_STATE();
    case 1144:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1220);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(sym_keyword_metadata);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(sym_keyword_minvalue);
      END_STATE();
    case 1147:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1221);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(sym_keyword_sequence);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1222);
      END_STATE();
    case 1149:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1223);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(aux_sym_keyword_smallint_token1);
      END_STATE();
    case 1151:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1224);
      END_STATE();
    case 1152:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1225);
      END_STATE();
    case 1153:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1226);
      END_STATE();
    case 1154:
      if (lookahead == 'o') ADVANCE(1227);
      END_STATE();
    case 1155:
      if (lookahead == 'u') ADVANCE(1228);
      END_STATE();
    case 1156:
      if (lookahead == 'o') ADVANCE(1229);
      END_STATE();
    case 1157:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1230);
      END_STATE();
    case 1158:
      ACCEPT_TOKEN(sym_keyword_bin_pack);
      END_STATE();
    case 1159:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1231);
      END_STATE();
    case 1160:
      ACCEPT_TOKEN(sym_keyword_external);
      END_STATE();
    case 1161:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1232);
      END_STATE();
    case 1162:
      ACCEPT_TOKEN(sym_keyword_function);
      END_STATE();
    case 1163:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1233);
      END_STATE();
    case 1164:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1234);
      END_STATE();
    case 1165:
      ACCEPT_TOKEN(sym_keyword_geometry);
      END_STATE();
    case 1166:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1235);
      END_STATE();
    case 1167:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1236);
      END_STATE();
    case 1168:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1237);
      END_STATE();
    case 1169:
      ACCEPT_TOKEN(sym_keyword_interval);
      END_STATE();
    case 1170:
      ACCEPT_TOKEN(sym_keyword_jsonfile);
      END_STATE();
    case 1171:
      ACCEPT_TOKEN(sym_keyword_language);
      END_STATE();
    case 1172:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1238);
      END_STATE();
    case 1173:
      ACCEPT_TOKEN(sym_keyword_location);
      END_STATE();
    case 1174:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1239);
      END_STATE();
    case 1175:
      ACCEPT_TOKEN(sym_keyword_nvarchar);
      END_STATE();
    case 1176:
      ACCEPT_TOKEN(sym_keyword_optimize);
      END_STATE();
    case 1177:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1240);
      END_STATE();
    case 1178:
      ACCEPT_TOKEN(sym_keyword_parallel);
      END_STATE();
    case 1179:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1241);
      END_STATE();
    case 1180:
      ACCEPT_TOKEN(sym_keyword_password);
      END_STATE();
    case 1181:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1242);
      END_STATE();
    case 1182:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1243);
      END_STATE();
    case 1183:
      ACCEPT_TOKEN(sym_keyword_preserve);
      END_STATE();
    case 1184:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1244);
      END_STATE();
    case 1185:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1245);
      END_STATE();
    case 1186:
      ACCEPT_TOKEN(sym_keyword_regclass);
      END_STATE();
    case 1187:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1246);
      END_STATE();
    case 1188:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1247);
      END_STATE();
    case 1189:
      ACCEPT_TOKEN(sym_keyword_restrict);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1248);
      END_STATE();
    case 1190:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1249);
      END_STATE();
    case 1191:
      ACCEPT_TOKEN(sym_keyword_rollback);
      END_STATE();
    case 1192:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1250);
      END_STATE();
    case 1193:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1251);
      END_STATE();
    case 1194:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1252);
      END_STATE();
    case 1195:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1253);
      END_STATE();
    case 1196:
      ACCEPT_TOKEN(sym_keyword_textfile);
      END_STATE();
    case 1197:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1254);
      END_STATE();
    case 1198:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1255);
      END_STATE();
    case 1199:
      ACCEPT_TOKEN(sym_keyword_truncate);
      END_STATE();
    case 1200:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1256);
      END_STATE();
    case 1201:
      ACCEPT_TOKEN(sym_keyword_uncached);
      END_STATE();
    case 1202:
      ACCEPT_TOKEN(sym_keyword_unlogged);
      END_STATE();
    case 1203:
      ACCEPT_TOKEN(sym_keyword_unsigned);
      END_STATE();
    case 1204:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1257);
      END_STATE();
    case 1205:
      ACCEPT_TOKEN(sym_keyword_volatile);
      END_STATE();
    case 1206:
      ACCEPT_TOKEN(sym_keyword_zerofill);
      END_STATE();
    case 1207:
      ACCEPT_TOKEN(sym_keyword_attribute);
      END_STATE();
    case 1208:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1258);
      END_STATE();
    case 1209:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1259);
      END_STATE();
    case 1210:
      ACCEPT_TOKEN(aux_sym_keyword_character_token1);
      END_STATE();
    case 1211:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1260);
      END_STATE();
    case 1212:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1261);
      END_STATE();
    case 1213:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1262);
      END_STATE();
    case 1214:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1263);
      END_STATE();
    case 1215:
      ACCEPT_TOKEN(sym_keyword_datetime2);
      END_STATE();
    case 1216:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1264);
      END_STATE();
    case 1217:
      ACCEPT_TOKEN(sym_keyword_delimited);
      END_STATE();
    case 1218:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1265);
      END_STATE();
    case 1219:
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1266);
      END_STATE();
    case 1220:
      ACCEPT_TOKEN(aux_sym_keyword_mediumint_token1);
      END_STATE();
    case 1221:
      ACCEPT_TOKEN(sym_keyword_separator);
      END_STATE();
    case 1222:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1267);
      END_STATE();
    case 1223:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1268);
      END_STATE();
    case 1224:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1269);
      END_STATE();
    case 1225:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1270);
      END_STATE();
    case 1226:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1271);
      END_STATE();
    case 1227:
      if (lookahead == 'n') ADVANCE(1272);
      END_STATE();
    case 1228:
      if (lookahead == 'm') ADVANCE(1273);
      END_STATE();
    case 1229:
      if (lookahead == 'n') ADVANCE(1274);
      END_STATE();
    case 1230:
      ACCEPT_TOKEN(aux_sym_keyword_bigserial_token1);
      END_STATE();
    case 1231:
      ACCEPT_TOKEN(sym_keyword_encrypted);
      END_STATE();
    case 1232:
      ACCEPT_TOKEN(sym_keyword_following);
      END_STATE();
    case 1233:
      ACCEPT_TOKEN(sym_keyword_generated);
      END_STATE();
    case 1234:
      ACCEPT_TOKEN(sym_keyword_geography);
      END_STATE();
    case 1235:
      ACCEPT_TOKEN(sym_keyword_immutable);
      END_STATE();
    case 1236:
      ACCEPT_TOKEN(sym_keyword_increment);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1275);
      END_STATE();
    case 1237:
      ACCEPT_TOKEN(sym_keyword_intersect);
      END_STATE();
    case 1238:
      ACCEPT_TOKEN(sym_keyword_leakproof);
      END_STATE();
    case 1239:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1276);
      END_STATE();
    case 1240:
      ACCEPT_TOKEN(sym_keyword_overwrite);
      END_STATE();
    case 1241:
      ACCEPT_TOKEN(sym_keyword_partition);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1277);
      END_STATE();
    case 1242:
      ACCEPT_TOKEN(sym_keyword_preceding);
      END_STATE();
    case 1243:
      ACCEPT_TOKEN(sym_keyword_precision);
      END_STATE();
    case 1244:
      ACCEPT_TOKEN(sym_keyword_recursive);
      END_STATE();
    case 1245:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1278);
      END_STATE();
    case 1246:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1279);
      END_STATE();
    case 1247:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1280);
      END_STATE();
    case 1248:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1281);
      END_STATE();
    case 1249:
      ACCEPT_TOKEN(sym_keyword_returning);
      END_STATE();
    case 1250:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1282);
      END_STATE();
    case 1251:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1283);
      END_STATE();
    case 1252:
      ACCEPT_TOKEN(sym_keyword_temporary);
      END_STATE();
    case 1253:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1284);
      END_STATE();
    case 1254:
      ACCEPT_TOKEN(aux_sym_keyword_timestamp_token1);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1285);
      END_STATE();
    case 1255:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1286);
      END_STATE();
    case 1256:
      ACCEPT_TOKEN(sym_keyword_unbounded);
      END_STATE();
    case 1257:
      ACCEPT_TOKEN(sym_keyword_varbinary);
      END_STATE();
    case 1258:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1287);
      END_STATE();
    case 1259:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1288);
      END_STATE();
    case 1260:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1289);
      END_STATE();
    case 1261:
      ACCEPT_TOKEN(sym_keyword_connection);
      END_STATE();
    case 1262:
      ACCEPT_TOKEN(sym_keyword_constraint);
      END_STATE();
    case 1263:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1290);
      END_STATE();
    case 1264:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1291);
      END_STATE();
    case 1265:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1292);
      END_STATE();
    case 1266:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1293);
      END_STATE();
    case 1267:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1294);
      END_STATE();
    case 1268:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1295);
      END_STATE();
    case 1269:
      ACCEPT_TOKEN(sym_keyword_smallmoney);
      END_STATE();
    case 1270:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1296);
      END_STATE();
    case 1271:
      ACCEPT_TOKEN(sym_keyword_statistics);
      END_STATE();
    case 1272:
      if (lookahead == 'd') ADVANCE(1297);
      END_STATE();
    case 1273:
      ACCEPT_TOKEN(anon_sym_millennium);
      END_STATE();
    case 1274:
      if (lookahead == 'd') ADVANCE(1298);
      END_STATE();
    case 1275:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1299);
      END_STATE();
    case 1276:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1300);
      END_STATE();
    case 1277:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1301);
      END_STATE();
    case 1278:
      ACCEPT_TOKEN(sym_keyword_references);
      END_STATE();
    case 1279:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1302);
      END_STATE();
    case 1280:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1303);
      END_STATE();
    case 1281:
      ACCEPT_TOKEN(sym_keyword_restricted);
      END_STATE();
    case 1282:
      ACCEPT_TOKEN(sym_keyword_tablespace);
      END_STATE();
    case 1283:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1304);
      END_STATE();
    case 1284:
      ACCEPT_TOKEN(sym_keyword_terminated);
      END_STATE();
    case 1285:
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1305);
      END_STATE();
    case 1286:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1306);
      END_STATE();
    case 1287:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1307);
      END_STATE();
    case 1288:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1308);
      END_STATE();
    case 1289:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1309);
      END_STATE();
    case 1290:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1310);
      END_STATE();
    case 1291:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1311);
      END_STATE();
    case 1292:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1312);
      END_STATE();
    case 1293:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1313);
      END_STATE();
    case 1294:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1314);
      END_STATE();
    case 1295:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1315);
      END_STATE();
    case 1296:
      ACCEPT_TOKEN(aux_sym_keyword_smallserial_token1);
      END_STATE();
    case 1297:
      ACCEPT_TOKEN(anon_sym_microsecond);
      END_STATE();
    case 1298:
      ACCEPT_TOKEN(anon_sym_millisecond);
      END_STATE();
    case 1299:
      ACCEPT_TOKEN(sym_keyword_incremental);
      END_STATE();
    case 1300:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1316);
      END_STATE();
    case 1301:
      ACCEPT_TOKEN(sym_keyword_partitioned);
      END_STATE();
    case 1302:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1317);
      END_STATE();
    case 1303:
      ACCEPT_TOKEN(sym_keyword_replication);
      END_STATE();
    case 1304:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1318);
      END_STATE();
    case 1305:
      ACCEPT_TOKEN(aux_sym_keyword_timestamptz_token1);
      END_STATE();
    case 1306:
      ACCEPT_TOKEN(sym_keyword_transaction);
      END_STATE();
    case 1307:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1319);
      END_STATE();
    case 1308:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1320);
      END_STATE();
    case 1309:
      ACCEPT_TOKEN(sym_keyword_concurrently);
      END_STATE();
    case 1310:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1321);
      END_STATE();
    case 1311:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1322);
      END_STATE();
    case 1312:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1323);
      END_STATE();
    case 1313:
      ACCEPT_TOKEN(sym_keyword_materialized);
      END_STATE();
    case 1314:
      ACCEPT_TOKEN(sym_keyword_sequencefile);
      END_STATE();
    case 1315:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1324);
      END_STATE();
    case 1316:
      ACCEPT_TOKEN(sym_keyword_low_priority);
      END_STATE();
    case 1317:
      ACCEPT_TOKEN(sym_keyword_regnamespace);
      END_STATE();
    case 1318:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1325);
      END_STATE();
    case 1319:
      ACCEPT_TOKEN(sym_keyword_authorization);
      END_STATE();
    case 1320:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1326);
      END_STATE();
    case 1321:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1327);
      END_STATE();
    case 1322:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1328);
      END_STATE();
    case 1323:
      ACCEPT_TOKEN(sym_keyword_high_priority);
      END_STATE();
    case 1324:
      ACCEPT_TOKEN(sym_keyword_smalldatetime);
      END_STATE();
    case 1325:
      ACCEPT_TOKEN(sym_keyword_tblproperties);
      END_STATE();
    case 1326:
      ACCEPT_TOKEN(sym_keyword_auto_increment);
      END_STATE();
    case 1327:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1329);
      END_STATE();
    case 1328:
      ACCEPT_TOKEN(sym_keyword_datetimeoffset);
      END_STATE();
    case 1329:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1330);
      END_STATE();
    case 1330:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1331);
      END_STATE();
    case 1331:
      ACCEPT_TOKEN(sym_keyword_current_timestamp);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 30},
  [3] = {.lex_state = 30},
  [4] = {.lex_state = 30},
  [5] = {.lex_state = 30},
  [6] = {.lex_state = 30},
  [7] = {.lex_state = 30},
  [8] = {.lex_state = 30},
  [9] = {.lex_state = 30},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 30},
  [37] = {.lex_state = 30},
  [38] = {.lex_state = 30},
  [39] = {.lex_state = 30},
  [40] = {.lex_state = 30},
  [41] = {.lex_state = 30},
  [42] = {.lex_state = 30},
  [43] = {.lex_state = 30},
  [44] = {.lex_state = 30},
  [45] = {.lex_state = 30},
  [46] = {.lex_state = 30},
  [47] = {.lex_state = 30},
  [48] = {.lex_state = 30},
  [49] = {.lex_state = 30},
  [50] = {.lex_state = 30},
  [51] = {.lex_state = 30},
  [52] = {.lex_state = 30},
  [53] = {.lex_state = 30},
  [54] = {.lex_state = 30},
  [55] = {.lex_state = 30},
  [56] = {.lex_state = 30},
  [57] = {.lex_state = 30},
  [58] = {.lex_state = 30},
  [59] = {.lex_state = 30},
  [60] = {.lex_state = 30},
  [61] = {.lex_state = 30},
  [62] = {.lex_state = 30},
  [63] = {.lex_state = 30},
  [64] = {.lex_state = 30},
  [65] = {.lex_state = 30},
  [66] = {.lex_state = 30},
  [67] = {.lex_state = 30},
  [68] = {.lex_state = 30},
  [69] = {.lex_state = 30},
  [70] = {.lex_state = 30},
  [71] = {.lex_state = 30},
  [72] = {.lex_state = 30},
  [73] = {.lex_state = 30},
  [74] = {.lex_state = 30},
  [75] = {.lex_state = 30},
  [76] = {.lex_state = 30},
  [77] = {.lex_state = 30},
  [78] = {.lex_state = 30},
  [79] = {.lex_state = 30},
  [80] = {.lex_state = 30},
  [81] = {.lex_state = 30},
  [82] = {.lex_state = 30},
  [83] = {.lex_state = 30},
  [84] = {.lex_state = 30},
  [85] = {.lex_state = 30},
  [86] = {.lex_state = 30},
  [87] = {.lex_state = 30},
  [88] = {.lex_state = 30},
  [89] = {.lex_state = 30},
  [90] = {.lex_state = 30},
  [91] = {.lex_state = 30},
  [92] = {.lex_state = 30},
  [93] = {.lex_state = 30},
  [94] = {.lex_state = 30},
  [95] = {.lex_state = 30},
  [96] = {.lex_state = 30},
  [97] = {.lex_state = 30},
  [98] = {.lex_state = 30},
  [99] = {.lex_state = 30},
  [100] = {.lex_state = 30},
  [101] = {.lex_state = 0},
  [102] = {.lex_state = 30},
  [103] = {.lex_state = 30},
  [104] = {.lex_state = 30},
  [105] = {.lex_state = 30},
  [106] = {.lex_state = 30},
  [107] = {.lex_state = 30},
  [108] = {.lex_state = 30},
  [109] = {.lex_state = 30},
  [110] = {.lex_state = 30},
  [111] = {.lex_state = 30},
  [112] = {.lex_state = 30},
  [113] = {.lex_state = 30},
  [114] = {.lex_state = 30},
  [115] = {.lex_state = 30},
  [116] = {.lex_state = 30},
  [117] = {.lex_state = 30},
  [118] = {.lex_state = 30},
  [119] = {.lex_state = 30},
  [120] = {.lex_state = 30},
  [121] = {.lex_state = 30},
  [122] = {.lex_state = 30},
  [123] = {.lex_state = 30},
  [124] = {.lex_state = 30},
  [125] = {.lex_state = 30},
  [126] = {.lex_state = 30},
  [127] = {.lex_state = 30},
  [128] = {.lex_state = 30},
  [129] = {.lex_state = 30},
  [130] = {.lex_state = 30},
  [131] = {.lex_state = 30},
  [132] = {.lex_state = 30},
  [133] = {.lex_state = 30},
  [134] = {.lex_state = 30},
  [135] = {.lex_state = 30},
  [136] = {.lex_state = 30},
  [137] = {.lex_state = 30},
  [138] = {.lex_state = 30},
  [139] = {.lex_state = 30},
  [140] = {.lex_state = 30},
  [141] = {.lex_state = 30},
  [142] = {.lex_state = 30},
  [143] = {.lex_state = 30},
  [144] = {.lex_state = 30},
  [145] = {.lex_state = 30},
  [146] = {.lex_state = 30},
  [147] = {.lex_state = 30},
  [148] = {.lex_state = 30},
  [149] = {.lex_state = 30},
  [150] = {.lex_state = 30},
  [151] = {.lex_state = 30},
  [152] = {.lex_state = 30},
  [153] = {.lex_state = 30},
  [154] = {.lex_state = 30},
  [155] = {.lex_state = 30},
  [156] = {.lex_state = 30},
  [157] = {.lex_state = 30},
  [158] = {.lex_state = 30},
  [159] = {.lex_state = 30},
  [160] = {.lex_state = 30},
  [161] = {.lex_state = 30},
  [162] = {.lex_state = 30},
  [163] = {.lex_state = 30},
  [164] = {.lex_state = 30},
  [165] = {.lex_state = 30},
  [166] = {.lex_state = 30},
  [167] = {.lex_state = 30},
  [168] = {.lex_state = 30},
  [169] = {.lex_state = 30},
  [170] = {.lex_state = 30},
  [171] = {.lex_state = 30},
  [172] = {.lex_state = 30},
  [173] = {.lex_state = 30},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 30},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 30},
  [181] = {.lex_state = 0},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 30},
  [184] = {.lex_state = 30},
  [185] = {.lex_state = 30},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 30},
  [191] = {.lex_state = 30},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 0},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 30},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 30},
  [205] = {.lex_state = 30},
  [206] = {.lex_state = 30},
  [207] = {.lex_state = 30},
  [208] = {.lex_state = 30},
  [209] = {.lex_state = 30},
  [210] = {.lex_state = 30},
  [211] = {.lex_state = 30},
  [212] = {.lex_state = 30},
  [213] = {.lex_state = 30},
  [214] = {.lex_state = 30},
  [215] = {.lex_state = 30},
  [216] = {.lex_state = 30},
  [217] = {.lex_state = 30},
  [218] = {.lex_state = 30},
  [219] = {.lex_state = 30},
  [220] = {.lex_state = 30},
  [221] = {.lex_state = 30},
  [222] = {.lex_state = 30},
  [223] = {.lex_state = 30},
  [224] = {.lex_state = 30},
  [225] = {.lex_state = 30},
  [226] = {.lex_state = 30},
  [227] = {.lex_state = 30},
  [228] = {.lex_state = 30},
  [229] = {.lex_state = 30},
  [230] = {.lex_state = 30},
  [231] = {.lex_state = 30},
  [232] = {.lex_state = 30},
  [233] = {.lex_state = 30},
  [234] = {.lex_state = 30},
  [235] = {.lex_state = 30},
  [236] = {.lex_state = 30},
  [237] = {.lex_state = 30},
  [238] = {.lex_state = 30},
  [239] = {.lex_state = 30},
  [240] = {.lex_state = 30},
  [241] = {.lex_state = 30},
  [242] = {.lex_state = 30},
  [243] = {.lex_state = 30},
  [244] = {.lex_state = 30},
  [245] = {.lex_state = 30},
  [246] = {.lex_state = 30},
  [247] = {.lex_state = 30},
  [248] = {.lex_state = 30},
  [249] = {.lex_state = 30},
  [250] = {.lex_state = 30},
  [251] = {.lex_state = 30},
  [252] = {.lex_state = 30},
  [253] = {.lex_state = 30},
  [254] = {.lex_state = 30},
  [255] = {.lex_state = 30},
  [256] = {.lex_state = 30},
  [257] = {.lex_state = 30},
  [258] = {.lex_state = 30},
  [259] = {.lex_state = 30},
  [260] = {.lex_state = 30},
  [261] = {.lex_state = 30},
  [262] = {.lex_state = 30},
  [263] = {.lex_state = 30},
  [264] = {.lex_state = 30},
  [265] = {.lex_state = 30},
  [266] = {.lex_state = 30},
  [267] = {.lex_state = 30},
  [268] = {.lex_state = 30},
  [269] = {.lex_state = 30},
  [270] = {.lex_state = 30},
  [271] = {.lex_state = 30},
  [272] = {.lex_state = 30},
  [273] = {.lex_state = 30},
  [274] = {.lex_state = 30},
  [275] = {.lex_state = 30},
  [276] = {.lex_state = 30},
  [277] = {.lex_state = 30},
  [278] = {.lex_state = 30},
  [279] = {.lex_state = 30},
  [280] = {.lex_state = 30},
  [281] = {.lex_state = 30},
  [282] = {.lex_state = 30},
  [283] = {.lex_state = 30},
  [284] = {.lex_state = 30},
  [285] = {.lex_state = 30},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 30},
  [289] = {.lex_state = 30},
  [290] = {.lex_state = 30},
  [291] = {.lex_state = 30},
  [292] = {.lex_state = 30},
  [293] = {.lex_state = 30},
  [294] = {.lex_state = 30},
  [295] = {.lex_state = 30},
  [296] = {.lex_state = 30},
  [297] = {.lex_state = 30},
  [298] = {.lex_state = 30},
  [299] = {.lex_state = 30},
  [300] = {.lex_state = 30},
  [301] = {.lex_state = 30},
  [302] = {.lex_state = 30},
  [303] = {.lex_state = 30},
  [304] = {.lex_state = 30},
  [305] = {.lex_state = 30},
  [306] = {.lex_state = 30},
  [307] = {.lex_state = 30},
  [308] = {.lex_state = 30},
  [309] = {.lex_state = 30},
  [310] = {.lex_state = 30},
  [311] = {.lex_state = 30},
  [312] = {.lex_state = 30},
  [313] = {.lex_state = 30},
  [314] = {.lex_state = 30},
  [315] = {.lex_state = 30},
  [316] = {.lex_state = 30},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 30},
  [319] = {.lex_state = 30},
  [320] = {.lex_state = 30},
  [321] = {.lex_state = 30},
  [322] = {.lex_state = 30},
  [323] = {.lex_state = 30},
  [324] = {.lex_state = 30},
  [325] = {.lex_state = 30},
  [326] = {.lex_state = 30},
  [327] = {.lex_state = 30},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 30},
  [330] = {.lex_state = 30},
  [331] = {.lex_state = 30},
  [332] = {.lex_state = 30},
  [333] = {.lex_state = 30},
  [334] = {.lex_state = 30},
  [335] = {.lex_state = 30},
  [336] = {.lex_state = 30},
  [337] = {.lex_state = 30},
  [338] = {.lex_state = 30},
  [339] = {.lex_state = 30},
  [340] = {.lex_state = 30},
  [341] = {.lex_state = 30},
  [342] = {.lex_state = 30},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 30},
  [345] = {.lex_state = 30},
  [346] = {.lex_state = 30},
  [347] = {.lex_state = 30},
  [348] = {.lex_state = 30},
  [349] = {.lex_state = 30},
  [350] = {.lex_state = 30},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 30},
  [353] = {.lex_state = 30},
  [354] = {.lex_state = 30},
  [355] = {.lex_state = 30},
  [356] = {.lex_state = 30},
  [357] = {.lex_state = 30},
  [358] = {.lex_state = 30},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 30},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 30},
  [363] = {.lex_state = 30},
  [364] = {.lex_state = 30},
  [365] = {.lex_state = 30},
  [366] = {.lex_state = 30},
  [367] = {.lex_state = 30},
  [368] = {.lex_state = 30},
  [369] = {.lex_state = 30},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 30},
  [372] = {.lex_state = 30},
  [373] = {.lex_state = 30},
  [374] = {.lex_state = 30},
  [375] = {.lex_state = 30},
  [376] = {.lex_state = 30},
  [377] = {.lex_state = 30},
  [378] = {.lex_state = 30},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 30},
  [381] = {.lex_state = 30},
  [382] = {.lex_state = 30},
  [383] = {.lex_state = 30},
  [384] = {.lex_state = 30},
  [385] = {.lex_state = 30},
  [386] = {.lex_state = 30},
  [387] = {.lex_state = 30},
  [388] = {.lex_state = 30},
  [389] = {.lex_state = 30},
  [390] = {.lex_state = 30},
  [391] = {.lex_state = 30},
  [392] = {.lex_state = 30},
  [393] = {.lex_state = 30},
  [394] = {.lex_state = 30},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 30},
  [397] = {.lex_state = 30},
  [398] = {.lex_state = 30},
  [399] = {.lex_state = 30},
  [400] = {.lex_state = 30},
  [401] = {.lex_state = 30},
  [402] = {.lex_state = 30},
  [403] = {.lex_state = 30},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 30},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 30},
  [409] = {.lex_state = 30},
  [410] = {.lex_state = 30},
  [411] = {.lex_state = 30},
  [412] = {.lex_state = 30},
  [413] = {.lex_state = 30},
  [414] = {.lex_state = 30},
  [415] = {.lex_state = 30},
  [416] = {.lex_state = 30},
  [417] = {.lex_state = 30},
  [418] = {.lex_state = 30},
  [419] = {.lex_state = 30},
  [420] = {.lex_state = 30},
  [421] = {.lex_state = 30},
  [422] = {.lex_state = 30},
  [423] = {.lex_state = 30},
  [424] = {.lex_state = 30},
  [425] = {.lex_state = 30},
  [426] = {.lex_state = 30},
  [427] = {.lex_state = 30},
  [428] = {.lex_state = 30},
  [429] = {.lex_state = 30},
  [430] = {.lex_state = 30},
  [431] = {.lex_state = 30},
  [432] = {.lex_state = 30},
  [433] = {.lex_state = 30},
  [434] = {.lex_state = 30},
  [435] = {.lex_state = 30},
  [436] = {.lex_state = 30},
  [437] = {.lex_state = 30},
  [438] = {.lex_state = 30},
  [439] = {.lex_state = 30},
  [440] = {.lex_state = 30},
  [441] = {.lex_state = 30},
  [442] = {.lex_state = 30},
  [443] = {.lex_state = 30},
  [444] = {.lex_state = 30},
  [445] = {.lex_state = 30},
  [446] = {.lex_state = 30},
  [447] = {.lex_state = 30},
  [448] = {.lex_state = 30},
  [449] = {.lex_state = 30},
  [450] = {.lex_state = 30},
  [451] = {.lex_state = 30},
  [452] = {.lex_state = 30},
  [453] = {.lex_state = 30},
  [454] = {.lex_state = 30},
  [455] = {.lex_state = 30},
  [456] = {.lex_state = 30},
  [457] = {.lex_state = 30},
  [458] = {.lex_state = 30},
  [459] = {.lex_state = 30},
  [460] = {.lex_state = 30},
  [461] = {.lex_state = 30},
  [462] = {.lex_state = 30},
  [463] = {.lex_state = 30},
  [464] = {.lex_state = 30},
  [465] = {.lex_state = 30},
  [466] = {.lex_state = 30},
  [467] = {.lex_state = 30},
  [468] = {.lex_state = 30},
  [469] = {.lex_state = 30},
  [470] = {.lex_state = 30},
  [471] = {.lex_state = 30},
  [472] = {.lex_state = 30},
  [473] = {.lex_state = 30},
  [474] = {.lex_state = 30},
  [475] = {.lex_state = 30},
  [476] = {.lex_state = 30},
  [477] = {.lex_state = 30},
  [478] = {.lex_state = 30},
  [479] = {.lex_state = 30},
  [480] = {.lex_state = 30},
  [481] = {.lex_state = 30},
  [482] = {.lex_state = 30},
  [483] = {.lex_state = 30},
  [484] = {.lex_state = 30},
  [485] = {.lex_state = 30},
  [486] = {.lex_state = 30},
  [487] = {.lex_state = 30},
  [488] = {.lex_state = 30},
  [489] = {.lex_state = 30},
  [490] = {.lex_state = 30},
  [491] = {.lex_state = 30},
  [492] = {.lex_state = 30},
  [493] = {.lex_state = 30},
  [494] = {.lex_state = 30},
  [495] = {.lex_state = 30},
  [496] = {.lex_state = 30},
  [497] = {.lex_state = 30},
  [498] = {.lex_state = 30},
  [499] = {.lex_state = 30},
  [500] = {.lex_state = 30},
  [501] = {.lex_state = 30},
  [502] = {.lex_state = 30},
  [503] = {.lex_state = 30},
  [504] = {.lex_state = 30},
  [505] = {.lex_state = 30},
  [506] = {.lex_state = 30},
  [507] = {.lex_state = 30},
  [508] = {.lex_state = 30},
  [509] = {.lex_state = 30},
  [510] = {.lex_state = 30},
  [511] = {.lex_state = 30},
  [512] = {.lex_state = 30},
  [513] = {.lex_state = 30},
  [514] = {.lex_state = 30},
  [515] = {.lex_state = 30},
  [516] = {.lex_state = 30},
  [517] = {.lex_state = 30},
  [518] = {.lex_state = 30},
  [519] = {.lex_state = 30},
  [520] = {.lex_state = 30},
  [521] = {.lex_state = 30},
  [522] = {.lex_state = 30},
  [523] = {.lex_state = 30},
  [524] = {.lex_state = 30},
  [525] = {.lex_state = 30},
  [526] = {.lex_state = 30},
  [527] = {.lex_state = 30},
  [528] = {.lex_state = 30},
  [529] = {.lex_state = 30},
  [530] = {.lex_state = 30},
  [531] = {.lex_state = 30},
  [532] = {.lex_state = 30},
  [533] = {.lex_state = 30},
  [534] = {.lex_state = 30},
  [535] = {.lex_state = 30},
  [536] = {.lex_state = 30},
  [537] = {.lex_state = 30},
  [538] = {.lex_state = 30},
  [539] = {.lex_state = 30},
  [540] = {.lex_state = 30},
  [541] = {.lex_state = 30},
  [542] = {.lex_state = 30},
  [543] = {.lex_state = 30},
  [544] = {.lex_state = 30},
  [545] = {.lex_state = 30},
  [546] = {.lex_state = 30},
  [547] = {.lex_state = 30},
  [548] = {.lex_state = 30},
  [549] = {.lex_state = 30},
  [550] = {.lex_state = 30},
  [551] = {.lex_state = 30},
  [552] = {.lex_state = 30},
  [553] = {.lex_state = 30},
  [554] = {.lex_state = 30},
  [555] = {.lex_state = 30},
  [556] = {.lex_state = 30},
  [557] = {.lex_state = 30},
  [558] = {.lex_state = 30},
  [559] = {.lex_state = 30},
  [560] = {.lex_state = 30},
  [561] = {.lex_state = 30},
  [562] = {.lex_state = 30},
  [563] = {.lex_state = 30},
  [564] = {.lex_state = 30},
  [565] = {.lex_state = 30},
  [566] = {.lex_state = 30},
  [567] = {.lex_state = 30},
  [568] = {.lex_state = 30},
  [569] = {.lex_state = 30},
  [570] = {.lex_state = 30},
  [571] = {.lex_state = 30},
  [572] = {.lex_state = 30},
  [573] = {.lex_state = 30},
  [574] = {.lex_state = 30},
  [575] = {.lex_state = 30},
  [576] = {.lex_state = 30},
  [577] = {.lex_state = 30},
  [578] = {.lex_state = 30},
  [579] = {.lex_state = 30},
  [580] = {.lex_state = 30},
  [581] = {.lex_state = 30},
  [582] = {.lex_state = 30},
  [583] = {.lex_state = 30},
  [584] = {.lex_state = 30},
  [585] = {.lex_state = 30},
  [586] = {.lex_state = 30},
  [587] = {.lex_state = 30},
  [588] = {.lex_state = 30},
  [589] = {.lex_state = 30},
  [590] = {.lex_state = 30},
  [591] = {.lex_state = 30},
  [592] = {.lex_state = 30},
  [593] = {.lex_state = 30},
  [594] = {.lex_state = 30},
  [595] = {.lex_state = 30},
  [596] = {.lex_state = 30},
  [597] = {.lex_state = 30},
  [598] = {.lex_state = 30},
  [599] = {.lex_state = 30},
  [600] = {.lex_state = 30},
  [601] = {.lex_state = 30},
  [602] = {.lex_state = 30},
  [603] = {.lex_state = 30},
  [604] = {.lex_state = 30},
  [605] = {.lex_state = 30},
  [606] = {.lex_state = 30},
  [607] = {.lex_state = 30},
  [608] = {.lex_state = 30},
  [609] = {.lex_state = 30},
  [610] = {.lex_state = 30},
  [611] = {.lex_state = 30},
  [612] = {.lex_state = 30},
  [613] = {.lex_state = 30},
  [614] = {.lex_state = 30},
  [615] = {.lex_state = 30},
  [616] = {.lex_state = 30},
  [617] = {.lex_state = 30},
  [618] = {.lex_state = 30},
  [619] = {.lex_state = 30},
  [620] = {.lex_state = 30},
  [621] = {.lex_state = 30},
  [622] = {.lex_state = 30},
  [623] = {.lex_state = 30},
  [624] = {.lex_state = 30},
  [625] = {.lex_state = 30},
  [626] = {.lex_state = 30},
  [627] = {.lex_state = 30},
  [628] = {.lex_state = 30},
  [629] = {.lex_state = 30},
  [630] = {.lex_state = 30},
  [631] = {.lex_state = 30},
  [632] = {.lex_state = 30},
  [633] = {.lex_state = 30},
  [634] = {.lex_state = 30},
  [635] = {.lex_state = 30},
  [636] = {.lex_state = 30},
  [637] = {.lex_state = 30},
  [638] = {.lex_state = 30},
  [639] = {.lex_state = 30},
  [640] = {.lex_state = 30},
  [641] = {.lex_state = 30},
  [642] = {.lex_state = 30},
  [643] = {.lex_state = 30},
  [644] = {.lex_state = 30},
  [645] = {.lex_state = 30},
  [646] = {.lex_state = 30},
  [647] = {.lex_state = 30},
  [648] = {.lex_state = 30},
  [649] = {.lex_state = 30},
  [650] = {.lex_state = 30},
  [651] = {.lex_state = 30},
  [652] = {.lex_state = 30},
  [653] = {.lex_state = 30},
  [654] = {.lex_state = 30},
  [655] = {.lex_state = 30},
  [656] = {.lex_state = 30},
  [657] = {.lex_state = 30},
  [658] = {.lex_state = 30},
  [659] = {.lex_state = 30},
  [660] = {.lex_state = 30},
  [661] = {.lex_state = 30},
  [662] = {.lex_state = 30},
  [663] = {.lex_state = 30},
  [664] = {.lex_state = 30},
  [665] = {.lex_state = 30},
  [666] = {.lex_state = 30},
  [667] = {.lex_state = 30},
  [668] = {.lex_state = 30},
  [669] = {.lex_state = 30},
  [670] = {.lex_state = 30},
  [671] = {.lex_state = 30},
  [672] = {.lex_state = 30},
  [673] = {.lex_state = 30},
  [674] = {.lex_state = 30},
  [675] = {.lex_state = 30},
  [676] = {.lex_state = 30},
  [677] = {.lex_state = 30},
  [678] = {.lex_state = 30},
  [679] = {.lex_state = 30},
  [680] = {.lex_state = 30},
  [681] = {.lex_state = 30},
  [682] = {.lex_state = 30},
  [683] = {.lex_state = 30},
  [684] = {.lex_state = 30},
  [685] = {.lex_state = 30},
  [686] = {.lex_state = 30},
  [687] = {.lex_state = 30},
  [688] = {.lex_state = 30},
  [689] = {.lex_state = 30},
  [690] = {.lex_state = 30},
  [691] = {.lex_state = 30},
  [692] = {.lex_state = 30},
  [693] = {.lex_state = 30},
  [694] = {.lex_state = 30},
  [695] = {.lex_state = 30},
  [696] = {.lex_state = 30},
  [697] = {.lex_state = 30},
  [698] = {.lex_state = 30},
  [699] = {.lex_state = 30},
  [700] = {.lex_state = 30},
  [701] = {.lex_state = 30},
  [702] = {.lex_state = 30},
  [703] = {.lex_state = 30},
  [704] = {.lex_state = 30},
  [705] = {.lex_state = 30},
  [706] = {.lex_state = 30},
  [707] = {.lex_state = 30},
  [708] = {.lex_state = 30},
  [709] = {.lex_state = 30},
  [710] = {.lex_state = 30},
  [711] = {.lex_state = 30},
  [712] = {.lex_state = 30},
  [713] = {.lex_state = 30},
  [714] = {.lex_state = 30},
  [715] = {.lex_state = 30},
  [716] = {.lex_state = 30},
  [717] = {.lex_state = 30},
  [718] = {.lex_state = 30},
  [719] = {.lex_state = 30},
  [720] = {.lex_state = 30},
  [721] = {.lex_state = 30},
  [722] = {.lex_state = 30},
  [723] = {.lex_state = 30},
  [724] = {.lex_state = 30},
  [725] = {.lex_state = 30},
  [726] = {.lex_state = 30},
  [727] = {.lex_state = 30},
  [728] = {.lex_state = 30},
  [729] = {.lex_state = 30},
  [730] = {.lex_state = 30},
  [731] = {.lex_state = 30},
  [732] = {.lex_state = 30},
  [733] = {.lex_state = 30},
  [734] = {.lex_state = 30},
  [735] = {.lex_state = 30},
  [736] = {.lex_state = 30},
  [737] = {.lex_state = 30},
  [738] = {.lex_state = 30},
  [739] = {.lex_state = 30},
  [740] = {.lex_state = 30},
  [741] = {.lex_state = 30},
  [742] = {.lex_state = 30},
  [743] = {.lex_state = 30},
  [744] = {.lex_state = 30},
  [745] = {.lex_state = 30},
  [746] = {.lex_state = 30},
  [747] = {.lex_state = 30},
  [748] = {.lex_state = 30},
  [749] = {.lex_state = 30},
  [750] = {.lex_state = 30},
  [751] = {.lex_state = 30},
  [752] = {.lex_state = 30},
  [753] = {.lex_state = 30},
  [754] = {.lex_state = 30},
  [755] = {.lex_state = 30},
  [756] = {.lex_state = 30},
  [757] = {.lex_state = 30},
  [758] = {.lex_state = 30},
  [759] = {.lex_state = 30},
  [760] = {.lex_state = 30},
  [761] = {.lex_state = 30},
  [762] = {.lex_state = 30},
  [763] = {.lex_state = 30},
  [764] = {.lex_state = 30},
  [765] = {.lex_state = 30},
  [766] = {.lex_state = 30},
  [767] = {.lex_state = 30},
  [768] = {.lex_state = 30},
  [769] = {.lex_state = 30},
  [770] = {.lex_state = 30},
  [771] = {.lex_state = 30},
  [772] = {.lex_state = 30},
  [773] = {.lex_state = 30},
  [774] = {.lex_state = 30},
  [775] = {.lex_state = 30},
  [776] = {.lex_state = 30},
  [777] = {.lex_state = 30},
  [778] = {.lex_state = 30},
  [779] = {.lex_state = 30},
  [780] = {.lex_state = 30},
  [781] = {.lex_state = 30},
  [782] = {.lex_state = 30},
  [783] = {.lex_state = 30},
  [784] = {.lex_state = 30},
  [785] = {.lex_state = 30},
  [786] = {.lex_state = 30},
  [787] = {.lex_state = 30},
  [788] = {.lex_state = 30},
  [789] = {.lex_state = 30},
  [790] = {.lex_state = 30},
  [791] = {.lex_state = 30},
  [792] = {.lex_state = 30},
  [793] = {.lex_state = 30},
  [794] = {.lex_state = 30},
  [795] = {.lex_state = 30},
  [796] = {.lex_state = 30},
  [797] = {.lex_state = 30},
  [798] = {.lex_state = 30},
  [799] = {.lex_state = 30},
  [800] = {.lex_state = 30},
  [801] = {.lex_state = 30},
  [802] = {.lex_state = 30},
  [803] = {.lex_state = 30},
  [804] = {.lex_state = 30},
  [805] = {.lex_state = 30},
  [806] = {.lex_state = 1},
  [807] = {.lex_state = 30},
  [808] = {.lex_state = 30},
  [809] = {.lex_state = 30},
  [810] = {.lex_state = 30},
  [811] = {.lex_state = 30},
  [812] = {.lex_state = 30},
  [813] = {.lex_state = 30},
  [814] = {.lex_state = 30},
  [815] = {.lex_state = 30},
  [816] = {.lex_state = 30},
  [817] = {.lex_state = 30},
  [818] = {.lex_state = 30},
  [819] = {.lex_state = 30},
  [820] = {.lex_state = 30},
  [821] = {.lex_state = 30},
  [822] = {.lex_state = 1},
  [823] = {.lex_state = 1},
  [824] = {.lex_state = 1},
  [825] = {.lex_state = 30},
  [826] = {.lex_state = 30},
  [827] = {.lex_state = 30},
  [828] = {.lex_state = 30},
  [829] = {.lex_state = 30},
  [830] = {.lex_state = 30},
  [831] = {.lex_state = 1},
  [832] = {.lex_state = 1},
  [833] = {.lex_state = 30},
  [834] = {.lex_state = 1},
  [835] = {.lex_state = 30},
  [836] = {.lex_state = 30},
  [837] = {.lex_state = 30},
  [838] = {.lex_state = 30},
  [839] = {.lex_state = 30},
  [840] = {.lex_state = 30},
  [841] = {.lex_state = 30},
  [842] = {.lex_state = 30},
  [843] = {.lex_state = 30},
  [844] = {.lex_state = 30},
  [845] = {.lex_state = 30},
  [846] = {.lex_state = 30},
  [847] = {.lex_state = 30},
  [848] = {.lex_state = 30},
  [849] = {.lex_state = 30},
  [850] = {.lex_state = 30},
  [851] = {.lex_state = 30},
  [852] = {.lex_state = 30},
  [853] = {.lex_state = 1},
  [854] = {.lex_state = 1},
  [855] = {.lex_state = 30},
  [856] = {.lex_state = 30},
  [857] = {.lex_state = 30},
  [858] = {.lex_state = 30},
  [859] = {.lex_state = 1},
  [860] = {.lex_state = 30},
  [861] = {.lex_state = 30},
  [862] = {.lex_state = 30},
  [863] = {.lex_state = 1},
  [864] = {.lex_state = 30},
  [865] = {.lex_state = 1},
  [866] = {.lex_state = 30},
  [867] = {.lex_state = 1},
  [868] = {.lex_state = 30},
  [869] = {.lex_state = 30},
  [870] = {.lex_state = 30},
  [871] = {.lex_state = 1},
  [872] = {.lex_state = 30},
  [873] = {.lex_state = 1},
  [874] = {.lex_state = 30},
  [875] = {.lex_state = 1},
  [876] = {.lex_state = 30},
  [877] = {.lex_state = 30},
  [878] = {.lex_state = 30},
  [879] = {.lex_state = 30},
  [880] = {.lex_state = 30},
  [881] = {.lex_state = 30},
  [882] = {.lex_state = 30},
  [883] = {.lex_state = 30},
  [884] = {.lex_state = 30},
  [885] = {.lex_state = 30},
  [886] = {.lex_state = 30},
  [887] = {.lex_state = 30},
  [888] = {.lex_state = 30},
  [889] = {.lex_state = 30},
  [890] = {.lex_state = 30},
  [891] = {.lex_state = 30},
  [892] = {.lex_state = 30},
  [893] = {.lex_state = 30},
  [894] = {.lex_state = 30},
  [895] = {.lex_state = 30},
  [896] = {.lex_state = 1},
  [897] = {.lex_state = 1},
  [898] = {.lex_state = 1},
  [899] = {.lex_state = 1},
  [900] = {.lex_state = 30},
  [901] = {.lex_state = 30},
  [902] = {.lex_state = 30},
  [903] = {.lex_state = 30},
  [904] = {.lex_state = 30},
  [905] = {.lex_state = 30},
  [906] = {.lex_state = 30},
  [907] = {.lex_state = 30},
  [908] = {.lex_state = 30},
  [909] = {.lex_state = 1},
  [910] = {.lex_state = 1},
  [911] = {.lex_state = 1},
  [912] = {.lex_state = 1},
  [913] = {.lex_state = 30},
  [914] = {.lex_state = 30},
  [915] = {.lex_state = 30},
  [916] = {.lex_state = 30},
  [917] = {.lex_state = 30},
  [918] = {.lex_state = 30},
  [919] = {.lex_state = 30},
  [920] = {.lex_state = 30},
  [921] = {.lex_state = 30},
  [922] = {.lex_state = 30},
  [923] = {.lex_state = 30},
  [924] = {.lex_state = 30},
  [925] = {.lex_state = 30},
  [926] = {.lex_state = 30},
  [927] = {.lex_state = 30},
  [928] = {.lex_state = 30},
  [929] = {.lex_state = 30},
  [930] = {.lex_state = 30},
  [931] = {.lex_state = 30},
  [932] = {.lex_state = 30},
  [933] = {.lex_state = 30},
  [934] = {.lex_state = 30},
  [935] = {.lex_state = 30},
  [936] = {.lex_state = 30},
  [937] = {.lex_state = 30},
  [938] = {.lex_state = 30},
  [939] = {.lex_state = 30},
  [940] = {.lex_state = 30},
  [941] = {.lex_state = 30},
  [942] = {.lex_state = 30},
  [943] = {.lex_state = 30},
  [944] = {.lex_state = 30},
  [945] = {.lex_state = 30},
  [946] = {.lex_state = 30},
  [947] = {.lex_state = 30},
  [948] = {.lex_state = 30},
  [949] = {.lex_state = 30},
  [950] = {.lex_state = 30},
  [951] = {.lex_state = 30},
  [952] = {.lex_state = 30},
  [953] = {.lex_state = 30},
  [954] = {.lex_state = 30},
  [955] = {.lex_state = 30},
  [956] = {.lex_state = 30},
  [957] = {.lex_state = 30},
  [958] = {.lex_state = 30},
  [959] = {.lex_state = 30},
  [960] = {.lex_state = 30},
  [961] = {.lex_state = 30},
  [962] = {.lex_state = 30},
  [963] = {.lex_state = 30},
  [964] = {.lex_state = 30},
  [965] = {.lex_state = 30},
  [966] = {.lex_state = 30},
  [967] = {.lex_state = 30},
  [968] = {.lex_state = 30},
  [969] = {.lex_state = 30},
  [970] = {.lex_state = 30},
  [971] = {.lex_state = 30},
  [972] = {.lex_state = 30},
  [973] = {.lex_state = 30},
  [974] = {.lex_state = 30},
  [975] = {.lex_state = 30},
  [976] = {.lex_state = 30},
  [977] = {.lex_state = 30},
  [978] = {.lex_state = 30},
  [979] = {.lex_state = 30},
  [980] = {.lex_state = 30},
  [981] = {.lex_state = 30},
  [982] = {.lex_state = 30},
  [983] = {.lex_state = 30},
  [984] = {.lex_state = 30},
  [985] = {.lex_state = 30},
  [986] = {.lex_state = 30},
  [987] = {.lex_state = 30},
  [988] = {.lex_state = 30},
  [989] = {.lex_state = 30},
  [990] = {.lex_state = 30},
  [991] = {.lex_state = 30},
  [992] = {.lex_state = 30},
  [993] = {.lex_state = 30},
  [994] = {.lex_state = 30},
  [995] = {.lex_state = 30},
  [996] = {.lex_state = 30},
  [997] = {.lex_state = 30},
  [998] = {.lex_state = 30},
  [999] = {.lex_state = 30},
  [1000] = {.lex_state = 30},
  [1001] = {.lex_state = 30},
  [1002] = {.lex_state = 30},
  [1003] = {.lex_state = 30},
  [1004] = {.lex_state = 30},
  [1005] = {.lex_state = 1},
  [1006] = {.lex_state = 1},
  [1007] = {.lex_state = 1},
  [1008] = {.lex_state = 30},
  [1009] = {.lex_state = 1},
  [1010] = {.lex_state = 1},
  [1011] = {.lex_state = 1},
  [1012] = {.lex_state = 1},
  [1013] = {.lex_state = 30},
  [1014] = {.lex_state = 30},
  [1015] = {.lex_state = 30},
  [1016] = {.lex_state = 1},
  [1017] = {.lex_state = 1},
  [1018] = {.lex_state = 30},
  [1019] = {.lex_state = 1},
  [1020] = {.lex_state = 1},
  [1021] = {.lex_state = 1},
  [1022] = {.lex_state = 1},
  [1023] = {.lex_state = 30},
  [1024] = {.lex_state = 1},
  [1025] = {.lex_state = 1},
  [1026] = {.lex_state = 1},
  [1027] = {.lex_state = 1},
  [1028] = {.lex_state = 1},
  [1029] = {.lex_state = 1},
  [1030] = {.lex_state = 1},
  [1031] = {.lex_state = 30},
  [1032] = {.lex_state = 1},
  [1033] = {.lex_state = 1},
  [1034] = {.lex_state = 1},
  [1035] = {.lex_state = 30},
  [1036] = {.lex_state = 30},
  [1037] = {.lex_state = 1},
  [1038] = {.lex_state = 1},
  [1039] = {.lex_state = 30},
  [1040] = {.lex_state = 1},
  [1041] = {.lex_state = 1},
  [1042] = {.lex_state = 30},
  [1043] = {.lex_state = 1},
  [1044] = {.lex_state = 30},
  [1045] = {.lex_state = 1},
  [1046] = {.lex_state = 1},
  [1047] = {.lex_state = 30},
  [1048] = {.lex_state = 30},
  [1049] = {.lex_state = 30},
  [1050] = {.lex_state = 1},
  [1051] = {.lex_state = 1},
  [1052] = {.lex_state = 1},
  [1053] = {.lex_state = 1},
  [1054] = {.lex_state = 30},
  [1055] = {.lex_state = 1},
  [1056] = {.lex_state = 1},
  [1057] = {.lex_state = 1},
  [1058] = {.lex_state = 30},
  [1059] = {.lex_state = 30},
  [1060] = {.lex_state = 1},
  [1061] = {.lex_state = 1},
  [1062] = {.lex_state = 1},
  [1063] = {.lex_state = 1},
  [1064] = {.lex_state = 1},
  [1065] = {.lex_state = 1},
  [1066] = {.lex_state = 1},
  [1067] = {.lex_state = 1},
  [1068] = {.lex_state = 1},
  [1069] = {.lex_state = 1},
  [1070] = {.lex_state = 1},
  [1071] = {.lex_state = 1},
  [1072] = {.lex_state = 30},
  [1073] = {.lex_state = 1},
  [1074] = {.lex_state = 1},
  [1075] = {.lex_state = 1},
  [1076] = {.lex_state = 30},
  [1077] = {.lex_state = 1},
  [1078] = {.lex_state = 1},
  [1079] = {.lex_state = 30},
  [1080] = {.lex_state = 1},
  [1081] = {.lex_state = 1},
  [1082] = {.lex_state = 1},
  [1083] = {.lex_state = 1},
  [1084] = {.lex_state = 30},
  [1085] = {.lex_state = 1},
  [1086] = {.lex_state = 1},
  [1087] = {.lex_state = 1},
  [1088] = {.lex_state = 1},
  [1089] = {.lex_state = 1},
  [1090] = {.lex_state = 30},
  [1091] = {.lex_state = 1},
  [1092] = {.lex_state = 30},
  [1093] = {.lex_state = 1},
  [1094] = {.lex_state = 1},
  [1095] = {.lex_state = 1},
  [1096] = {.lex_state = 1},
  [1097] = {.lex_state = 1},
  [1098] = {.lex_state = 1},
  [1099] = {.lex_state = 1},
  [1100] = {.lex_state = 1},
  [1101] = {.lex_state = 1},
  [1102] = {.lex_state = 1},
  [1103] = {.lex_state = 1},
  [1104] = {.lex_state = 1},
  [1105] = {.lex_state = 1},
  [1106] = {.lex_state = 1},
  [1107] = {.lex_state = 1},
  [1108] = {.lex_state = 1},
  [1109] = {.lex_state = 1},
  [1110] = {.lex_state = 1},
  [1111] = {.lex_state = 1},
  [1112] = {.lex_state = 1},
  [1113] = {.lex_state = 1},
  [1114] = {.lex_state = 1},
  [1115] = {.lex_state = 1},
  [1116] = {.lex_state = 1},
  [1117] = {.lex_state = 1},
  [1118] = {.lex_state = 1},
  [1119] = {.lex_state = 1},
  [1120] = {.lex_state = 1},
  [1121] = {.lex_state = 1},
  [1122] = {.lex_state = 1},
  [1123] = {.lex_state = 1},
  [1124] = {.lex_state = 1},
  [1125] = {.lex_state = 1},
  [1126] = {.lex_state = 1},
  [1127] = {.lex_state = 1},
  [1128] = {.lex_state = 1},
  [1129] = {.lex_state = 1},
  [1130] = {.lex_state = 1},
  [1131] = {.lex_state = 1},
  [1132] = {.lex_state = 1},
  [1133] = {.lex_state = 1},
  [1134] = {.lex_state = 1},
  [1135] = {.lex_state = 1},
  [1136] = {.lex_state = 1},
  [1137] = {.lex_state = 1},
  [1138] = {.lex_state = 1},
  [1139] = {.lex_state = 1},
  [1140] = {.lex_state = 1},
  [1141] = {.lex_state = 1},
  [1142] = {.lex_state = 1},
  [1143] = {.lex_state = 1},
  [1144] = {.lex_state = 1},
  [1145] = {.lex_state = 1},
  [1146] = {.lex_state = 1},
  [1147] = {.lex_state = 1},
  [1148] = {.lex_state = 1},
  [1149] = {.lex_state = 1},
  [1150] = {.lex_state = 1},
  [1151] = {.lex_state = 1},
  [1152] = {.lex_state = 1},
  [1153] = {.lex_state = 1},
  [1154] = {.lex_state = 1},
  [1155] = {.lex_state = 1},
  [1156] = {.lex_state = 1},
  [1157] = {.lex_state = 1},
  [1158] = {.lex_state = 1},
  [1159] = {.lex_state = 1},
  [1160] = {.lex_state = 1},
  [1161] = {.lex_state = 1},
  [1162] = {.lex_state = 1},
  [1163] = {.lex_state = 1},
  [1164] = {.lex_state = 1},
  [1165] = {.lex_state = 1},
  [1166] = {.lex_state = 1},
  [1167] = {.lex_state = 1},
  [1168] = {.lex_state = 1},
  [1169] = {.lex_state = 1},
  [1170] = {.lex_state = 1},
  [1171] = {.lex_state = 1},
  [1172] = {.lex_state = 1},
  [1173] = {.lex_state = 1},
  [1174] = {.lex_state = 1},
  [1175] = {.lex_state = 1},
  [1176] = {.lex_state = 1},
  [1177] = {.lex_state = 1},
  [1178] = {.lex_state = 30},
  [1179] = {.lex_state = 1},
  [1180] = {.lex_state = 1},
  [1181] = {.lex_state = 1},
  [1182] = {.lex_state = 1},
  [1183] = {.lex_state = 1},
  [1184] = {.lex_state = 1},
  [1185] = {.lex_state = 1},
  [1186] = {.lex_state = 1},
  [1187] = {.lex_state = 1},
  [1188] = {.lex_state = 1},
  [1189] = {.lex_state = 1},
  [1190] = {.lex_state = 1},
  [1191] = {.lex_state = 1},
  [1192] = {.lex_state = 1},
  [1193] = {.lex_state = 1},
  [1194] = {.lex_state = 1},
  [1195] = {.lex_state = 1},
  [1196] = {.lex_state = 1},
  [1197] = {.lex_state = 1},
  [1198] = {.lex_state = 1},
  [1199] = {.lex_state = 1},
  [1200] = {.lex_state = 1},
  [1201] = {.lex_state = 1},
  [1202] = {.lex_state = 1},
  [1203] = {.lex_state = 1},
  [1204] = {.lex_state = 1},
  [1205] = {.lex_state = 1},
  [1206] = {.lex_state = 1},
  [1207] = {.lex_state = 1},
  [1208] = {.lex_state = 1},
  [1209] = {.lex_state = 1},
  [1210] = {.lex_state = 1},
  [1211] = {.lex_state = 1},
  [1212] = {.lex_state = 1},
  [1213] = {.lex_state = 1},
  [1214] = {.lex_state = 1},
  [1215] = {.lex_state = 1},
  [1216] = {.lex_state = 1},
  [1217] = {.lex_state = 1},
  [1218] = {.lex_state = 1},
  [1219] = {.lex_state = 1},
  [1220] = {.lex_state = 1},
  [1221] = {.lex_state = 1},
  [1222] = {.lex_state = 1},
  [1223] = {.lex_state = 1},
  [1224] = {.lex_state = 1},
  [1225] = {.lex_state = 1},
  [1226] = {.lex_state = 1},
  [1227] = {.lex_state = 1},
  [1228] = {.lex_state = 1},
  [1229] = {.lex_state = 1},
  [1230] = {.lex_state = 1},
  [1231] = {.lex_state = 1},
  [1232] = {.lex_state = 1},
  [1233] = {.lex_state = 1},
  [1234] = {.lex_state = 1},
  [1235] = {.lex_state = 1},
  [1236] = {.lex_state = 1},
  [1237] = {.lex_state = 1},
  [1238] = {.lex_state = 1},
  [1239] = {.lex_state = 1},
  [1240] = {.lex_state = 1},
  [1241] = {.lex_state = 1},
  [1242] = {.lex_state = 1},
  [1243] = {.lex_state = 1},
  [1244] = {.lex_state = 1},
  [1245] = {.lex_state = 1},
  [1246] = {.lex_state = 1},
  [1247] = {.lex_state = 1},
  [1248] = {.lex_state = 1},
  [1249] = {.lex_state = 1},
  [1250] = {.lex_state = 1},
  [1251] = {.lex_state = 1},
  [1252] = {.lex_state = 1},
  [1253] = {.lex_state = 1},
  [1254] = {.lex_state = 1},
  [1255] = {.lex_state = 1},
  [1256] = {.lex_state = 1},
  [1257] = {.lex_state = 1},
  [1258] = {.lex_state = 1},
  [1259] = {.lex_state = 1},
  [1260] = {.lex_state = 1},
  [1261] = {.lex_state = 1},
  [1262] = {.lex_state = 1},
  [1263] = {.lex_state = 1},
  [1264] = {.lex_state = 1},
  [1265] = {.lex_state = 1},
  [1266] = {.lex_state = 1},
  [1267] = {.lex_state = 1},
  [1268] = {.lex_state = 1},
  [1269] = {.lex_state = 1},
  [1270] = {.lex_state = 1},
  [1271] = {.lex_state = 1},
  [1272] = {.lex_state = 1},
  [1273] = {.lex_state = 1},
  [1274] = {.lex_state = 1},
  [1275] = {.lex_state = 1},
  [1276] = {.lex_state = 1},
  [1277] = {.lex_state = 1},
  [1278] = {.lex_state = 1},
  [1279] = {.lex_state = 1},
  [1280] = {.lex_state = 1},
  [1281] = {.lex_state = 1},
  [1282] = {.lex_state = 1},
  [1283] = {.lex_state = 1},
  [1284] = {.lex_state = 1},
  [1285] = {.lex_state = 1},
  [1286] = {.lex_state = 1},
  [1287] = {.lex_state = 1},
  [1288] = {.lex_state = 1},
  [1289] = {.lex_state = 1},
  [1290] = {.lex_state = 1},
  [1291] = {.lex_state = 1},
  [1292] = {.lex_state = 1},
  [1293] = {.lex_state = 1},
  [1294] = {.lex_state = 1},
  [1295] = {.lex_state = 1},
  [1296] = {.lex_state = 1},
  [1297] = {.lex_state = 1},
  [1298] = {.lex_state = 1},
  [1299] = {.lex_state = 1},
  [1300] = {.lex_state = 1},
  [1301] = {.lex_state = 1},
  [1302] = {.lex_state = 1},
  [1303] = {.lex_state = 1},
  [1304] = {.lex_state = 1},
  [1305] = {.lex_state = 1},
  [1306] = {.lex_state = 1},
  [1307] = {.lex_state = 1},
  [1308] = {.lex_state = 1},
  [1309] = {.lex_state = 1},
  [1310] = {.lex_state = 1},
  [1311] = {.lex_state = 1},
  [1312] = {.lex_state = 1},
  [1313] = {.lex_state = 30},
  [1314] = {.lex_state = 30},
  [1315] = {.lex_state = 30},
  [1316] = {.lex_state = 30},
  [1317] = {.lex_state = 30},
  [1318] = {.lex_state = 30},
  [1319] = {.lex_state = 30},
  [1320] = {.lex_state = 30},
  [1321] = {.lex_state = 30},
  [1322] = {.lex_state = 30},
  [1323] = {.lex_state = 30},
  [1324] = {.lex_state = 30},
  [1325] = {.lex_state = 30},
  [1326] = {.lex_state = 30},
  [1327] = {.lex_state = 30},
  [1328] = {.lex_state = 30},
  [1329] = {.lex_state = 30},
  [1330] = {.lex_state = 30},
  [1331] = {.lex_state = 30},
  [1332] = {.lex_state = 30},
  [1333] = {.lex_state = 30},
  [1334] = {.lex_state = 30},
  [1335] = {.lex_state = 30},
  [1336] = {.lex_state = 30},
  [1337] = {.lex_state = 30},
  [1338] = {.lex_state = 30},
  [1339] = {.lex_state = 30},
  [1340] = {.lex_state = 30},
  [1341] = {.lex_state = 30},
  [1342] = {.lex_state = 30},
  [1343] = {.lex_state = 30},
  [1344] = {.lex_state = 30},
  [1345] = {.lex_state = 30},
  [1346] = {.lex_state = 30},
  [1347] = {.lex_state = 30},
  [1348] = {.lex_state = 30},
  [1349] = {.lex_state = 30},
  [1350] = {.lex_state = 30},
  [1351] = {.lex_state = 30},
  [1352] = {.lex_state = 30},
  [1353] = {.lex_state = 30},
  [1354] = {.lex_state = 30},
  [1355] = {.lex_state = 30},
  [1356] = {.lex_state = 30},
  [1357] = {.lex_state = 30},
  [1358] = {.lex_state = 30},
  [1359] = {.lex_state = 30},
  [1360] = {.lex_state = 30},
  [1361] = {.lex_state = 30},
  [1362] = {.lex_state = 30},
  [1363] = {.lex_state = 30},
  [1364] = {.lex_state = 30},
  [1365] = {.lex_state = 30},
  [1366] = {.lex_state = 30},
  [1367] = {.lex_state = 30},
  [1368] = {.lex_state = 30},
  [1369] = {.lex_state = 30},
  [1370] = {.lex_state = 30},
  [1371] = {.lex_state = 30},
  [1372] = {.lex_state = 30},
  [1373] = {.lex_state = 30},
  [1374] = {.lex_state = 30},
  [1375] = {.lex_state = 30},
  [1376] = {.lex_state = 30},
  [1377] = {.lex_state = 30},
  [1378] = {.lex_state = 30},
  [1379] = {.lex_state = 30},
  [1380] = {.lex_state = 30},
  [1381] = {.lex_state = 30},
  [1382] = {.lex_state = 30},
  [1383] = {.lex_state = 30},
  [1384] = {.lex_state = 30},
  [1385] = {.lex_state = 30},
  [1386] = {.lex_state = 30},
  [1387] = {.lex_state = 30},
  [1388] = {.lex_state = 30},
  [1389] = {.lex_state = 30},
  [1390] = {.lex_state = 30},
  [1391] = {.lex_state = 30},
  [1392] = {.lex_state = 30},
  [1393] = {.lex_state = 30},
  [1394] = {.lex_state = 30},
  [1395] = {.lex_state = 30},
  [1396] = {.lex_state = 30},
  [1397] = {.lex_state = 30},
  [1398] = {.lex_state = 30},
  [1399] = {.lex_state = 30},
  [1400] = {.lex_state = 30},
  [1401] = {.lex_state = 30},
  [1402] = {.lex_state = 30},
  [1403] = {.lex_state = 30},
  [1404] = {.lex_state = 30},
  [1405] = {.lex_state = 30},
  [1406] = {.lex_state = 30},
  [1407] = {.lex_state = 30},
  [1408] = {.lex_state = 30},
  [1409] = {.lex_state = 30},
  [1410] = {.lex_state = 30},
  [1411] = {.lex_state = 30},
  [1412] = {.lex_state = 30},
  [1413] = {.lex_state = 30},
  [1414] = {.lex_state = 30},
  [1415] = {.lex_state = 30},
  [1416] = {.lex_state = 30},
  [1417] = {.lex_state = 30},
  [1418] = {.lex_state = 30},
  [1419] = {.lex_state = 30},
  [1420] = {.lex_state = 30},
  [1421] = {.lex_state = 30},
  [1422] = {.lex_state = 30},
  [1423] = {.lex_state = 30},
  [1424] = {.lex_state = 30},
  [1425] = {.lex_state = 30},
  [1426] = {.lex_state = 30},
  [1427] = {.lex_state = 30},
  [1428] = {.lex_state = 30},
  [1429] = {.lex_state = 30},
  [1430] = {.lex_state = 30},
  [1431] = {.lex_state = 30},
  [1432] = {.lex_state = 30},
  [1433] = {.lex_state = 30},
  [1434] = {.lex_state = 30},
  [1435] = {.lex_state = 30},
  [1436] = {.lex_state = 30},
  [1437] = {.lex_state = 30},
  [1438] = {.lex_state = 30},
  [1439] = {.lex_state = 30},
  [1440] = {.lex_state = 30},
  [1441] = {.lex_state = 30},
  [1442] = {.lex_state = 30},
  [1443] = {.lex_state = 30},
  [1444] = {.lex_state = 30},
  [1445] = {.lex_state = 30},
  [1446] = {.lex_state = 30},
  [1447] = {.lex_state = 30},
  [1448] = {.lex_state = 30},
  [1449] = {.lex_state = 30},
  [1450] = {.lex_state = 30},
  [1451] = {.lex_state = 30},
  [1452] = {.lex_state = 30},
  [1453] = {.lex_state = 30},
  [1454] = {.lex_state = 30},
  [1455] = {.lex_state = 30},
  [1456] = {.lex_state = 30},
  [1457] = {.lex_state = 30},
  [1458] = {.lex_state = 30},
  [1459] = {.lex_state = 30},
  [1460] = {.lex_state = 30},
  [1461] = {.lex_state = 30},
  [1462] = {.lex_state = 30},
  [1463] = {.lex_state = 30},
  [1464] = {.lex_state = 30},
  [1465] = {.lex_state = 30},
  [1466] = {.lex_state = 30},
  [1467] = {.lex_state = 30},
  [1468] = {.lex_state = 30},
  [1469] = {.lex_state = 30},
  [1470] = {.lex_state = 30},
  [1471] = {.lex_state = 30},
  [1472] = {.lex_state = 30},
  [1473] = {.lex_state = 30},
  [1474] = {.lex_state = 30},
  [1475] = {.lex_state = 30},
  [1476] = {.lex_state = 30},
  [1477] = {.lex_state = 30},
  [1478] = {.lex_state = 30},
  [1479] = {.lex_state = 30},
  [1480] = {.lex_state = 30},
  [1481] = {.lex_state = 30},
  [1482] = {.lex_state = 30},
  [1483] = {.lex_state = 30},
  [1484] = {.lex_state = 30},
  [1485] = {.lex_state = 30},
  [1486] = {.lex_state = 30},
  [1487] = {.lex_state = 30},
  [1488] = {.lex_state = 30},
  [1489] = {.lex_state = 30},
  [1490] = {.lex_state = 30},
  [1491] = {.lex_state = 30},
  [1492] = {.lex_state = 30},
  [1493] = {.lex_state = 30},
  [1494] = {.lex_state = 30},
  [1495] = {.lex_state = 30},
  [1496] = {.lex_state = 30},
  [1497] = {.lex_state = 30},
  [1498] = {.lex_state = 30},
  [1499] = {.lex_state = 30},
  [1500] = {.lex_state = 30},
  [1501] = {.lex_state = 30},
  [1502] = {.lex_state = 30},
  [1503] = {.lex_state = 30},
  [1504] = {.lex_state = 30},
  [1505] = {.lex_state = 30},
  [1506] = {.lex_state = 30},
  [1507] = {.lex_state = 30},
  [1508] = {.lex_state = 30},
  [1509] = {.lex_state = 30},
  [1510] = {.lex_state = 30},
  [1511] = {.lex_state = 30},
  [1512] = {.lex_state = 30},
  [1513] = {.lex_state = 30},
  [1514] = {.lex_state = 30},
  [1515] = {.lex_state = 30},
  [1516] = {.lex_state = 30},
  [1517] = {.lex_state = 30},
  [1518] = {.lex_state = 30},
  [1519] = {.lex_state = 30},
  [1520] = {.lex_state = 30},
  [1521] = {.lex_state = 30},
  [1522] = {.lex_state = 30},
  [1523] = {.lex_state = 30},
  [1524] = {.lex_state = 30},
  [1525] = {.lex_state = 30},
  [1526] = {.lex_state = 30},
  [1527] = {.lex_state = 30},
  [1528] = {.lex_state = 30},
  [1529] = {.lex_state = 30},
  [1530] = {.lex_state = 30},
  [1531] = {.lex_state = 30},
  [1532] = {.lex_state = 30},
  [1533] = {.lex_state = 30},
  [1534] = {.lex_state = 30},
  [1535] = {.lex_state = 30},
  [1536] = {.lex_state = 30},
  [1537] = {.lex_state = 30},
  [1538] = {.lex_state = 30},
  [1539] = {.lex_state = 30},
  [1540] = {.lex_state = 30},
  [1541] = {.lex_state = 30},
  [1542] = {.lex_state = 30},
  [1543] = {.lex_state = 30},
  [1544] = {.lex_state = 30},
  [1545] = {.lex_state = 30},
  [1546] = {.lex_state = 30},
  [1547] = {.lex_state = 30},
  [1548] = {.lex_state = 30},
  [1549] = {.lex_state = 30},
  [1550] = {.lex_state = 30},
  [1551] = {.lex_state = 30},
  [1552] = {.lex_state = 30},
  [1553] = {.lex_state = 30},
  [1554] = {.lex_state = 30},
  [1555] = {.lex_state = 30},
  [1556] = {.lex_state = 30},
  [1557] = {.lex_state = 30},
  [1558] = {.lex_state = 30},
  [1559] = {.lex_state = 30},
  [1560] = {.lex_state = 30},
  [1561] = {.lex_state = 30},
  [1562] = {.lex_state = 30},
  [1563] = {.lex_state = 30},
  [1564] = {.lex_state = 30},
  [1565] = {.lex_state = 30},
  [1566] = {.lex_state = 30},
  [1567] = {.lex_state = 30},
  [1568] = {.lex_state = 30},
  [1569] = {.lex_state = 30},
  [1570] = {.lex_state = 30},
  [1571] = {.lex_state = 30},
  [1572] = {.lex_state = 30},
  [1573] = {.lex_state = 30},
  [1574] = {.lex_state = 30},
  [1575] = {.lex_state = 30},
  [1576] = {.lex_state = 30},
  [1577] = {.lex_state = 30},
  [1578] = {.lex_state = 30},
  [1579] = {.lex_state = 30},
  [1580] = {.lex_state = 30},
  [1581] = {.lex_state = 30},
  [1582] = {.lex_state = 30},
  [1583] = {.lex_state = 30},
  [1584] = {.lex_state = 30},
  [1585] = {.lex_state = 30},
  [1586] = {.lex_state = 30},
  [1587] = {.lex_state = 30},
  [1588] = {.lex_state = 30},
  [1589] = {.lex_state = 30},
  [1590] = {.lex_state = 30},
  [1591] = {.lex_state = 30},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 30},
  [1594] = {.lex_state = 30},
  [1595] = {.lex_state = 30},
  [1596] = {.lex_state = 0},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 30},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 30},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 30},
  [1604] = {.lex_state = 30},
  [1605] = {.lex_state = 30},
  [1606] = {.lex_state = 30},
  [1607] = {.lex_state = 30},
  [1608] = {.lex_state = 30},
  [1609] = {.lex_state = 30},
  [1610] = {.lex_state = 30},
  [1611] = {.lex_state = 30},
  [1612] = {.lex_state = 30},
  [1613] = {.lex_state = 30},
  [1614] = {.lex_state = 30},
  [1615] = {.lex_state = 30},
  [1616] = {.lex_state = 30},
  [1617] = {.lex_state = 30},
  [1618] = {.lex_state = 30},
  [1619] = {.lex_state = 30},
  [1620] = {.lex_state = 30},
  [1621] = {.lex_state = 30},
  [1622] = {.lex_state = 30},
  [1623] = {.lex_state = 30},
  [1624] = {.lex_state = 30},
  [1625] = {.lex_state = 30},
  [1626] = {.lex_state = 30},
  [1627] = {.lex_state = 30},
  [1628] = {.lex_state = 30},
  [1629] = {.lex_state = 30},
  [1630] = {.lex_state = 30},
  [1631] = {.lex_state = 30},
  [1632] = {.lex_state = 30},
  [1633] = {.lex_state = 30},
  [1634] = {.lex_state = 30},
  [1635] = {.lex_state = 30},
  [1636] = {.lex_state = 30},
  [1637] = {.lex_state = 30},
  [1638] = {.lex_state = 0},
  [1639] = {.lex_state = 0},
  [1640] = {.lex_state = 0},
  [1641] = {.lex_state = 30},
  [1642] = {.lex_state = 0},
  [1643] = {.lex_state = 0},
  [1644] = {.lex_state = 30},
  [1645] = {.lex_state = 30},
  [1646] = {.lex_state = 30},
  [1647] = {.lex_state = 30},
  [1648] = {.lex_state = 30},
  [1649] = {.lex_state = 0},
  [1650] = {.lex_state = 30},
  [1651] = {.lex_state = 30},
  [1652] = {.lex_state = 30},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 0},
  [1655] = {.lex_state = 0},
  [1656] = {.lex_state = 0},
  [1657] = {.lex_state = 30},
  [1658] = {.lex_state = 0},
  [1659] = {.lex_state = 0},
  [1660] = {.lex_state = 30},
  [1661] = {.lex_state = 30},
  [1662] = {.lex_state = 30},
  [1663] = {.lex_state = 30},
  [1664] = {.lex_state = 30},
  [1665] = {.lex_state = 30},
  [1666] = {.lex_state = 30},
  [1667] = {.lex_state = 30},
  [1668] = {.lex_state = 30},
  [1669] = {.lex_state = 30},
  [1670] = {.lex_state = 30},
  [1671] = {.lex_state = 30},
  [1672] = {.lex_state = 30},
  [1673] = {.lex_state = 0},
  [1674] = {.lex_state = 0},
  [1675] = {.lex_state = 0},
  [1676] = {.lex_state = 0},
  [1677] = {.lex_state = 0},
  [1678] = {.lex_state = 0},
  [1679] = {.lex_state = 0},
  [1680] = {.lex_state = 0},
  [1681] = {.lex_state = 0},
  [1682] = {.lex_state = 0},
  [1683] = {.lex_state = 0},
  [1684] = {.lex_state = 0},
  [1685] = {.lex_state = 0},
  [1686] = {.lex_state = 0},
  [1687] = {.lex_state = 30},
  [1688] = {.lex_state = 30},
  [1689] = {.lex_state = 30},
  [1690] = {.lex_state = 30},
  [1691] = {.lex_state = 30},
  [1692] = {.lex_state = 30},
  [1693] = {.lex_state = 30},
  [1694] = {.lex_state = 30},
  [1695] = {.lex_state = 30},
  [1696] = {.lex_state = 30},
  [1697] = {.lex_state = 30},
  [1698] = {.lex_state = 30},
  [1699] = {.lex_state = 30},
  [1700] = {.lex_state = 30},
  [1701] = {.lex_state = 30},
  [1702] = {.lex_state = 30},
  [1703] = {.lex_state = 0},
  [1704] = {.lex_state = 30},
  [1705] = {.lex_state = 30},
  [1706] = {.lex_state = 0},
  [1707] = {.lex_state = 30},
  [1708] = {.lex_state = 30},
  [1709] = {.lex_state = 30},
  [1710] = {.lex_state = 30},
  [1711] = {.lex_state = 30},
  [1712] = {.lex_state = 1},
  [1713] = {.lex_state = 30},
  [1714] = {.lex_state = 30},
  [1715] = {.lex_state = 1},
  [1716] = {.lex_state = 30},
  [1717] = {.lex_state = 30},
  [1718] = {.lex_state = 1},
  [1719] = {.lex_state = 30},
  [1720] = {.lex_state = 30},
  [1721] = {.lex_state = 1},
  [1722] = {.lex_state = 30},
  [1723] = {.lex_state = 30},
  [1724] = {.lex_state = 30},
  [1725] = {.lex_state = 30},
  [1726] = {.lex_state = 1},
  [1727] = {.lex_state = 30},
  [1728] = {.lex_state = 30},
  [1729] = {.lex_state = 30},
  [1730] = {.lex_state = 30},
  [1731] = {.lex_state = 30},
  [1732] = {.lex_state = 30},
  [1733] = {.lex_state = 30},
  [1734] = {.lex_state = 30},
  [1735] = {.lex_state = 30},
  [1736] = {.lex_state = 30},
  [1737] = {.lex_state = 30},
  [1738] = {.lex_state = 30},
  [1739] = {.lex_state = 30},
  [1740] = {.lex_state = 1},
  [1741] = {.lex_state = 30},
  [1742] = {.lex_state = 30},
  [1743] = {.lex_state = 0},
  [1744] = {.lex_state = 30},
  [1745] = {.lex_state = 30},
  [1746] = {.lex_state = 0},
  [1747] = {.lex_state = 0},
  [1748] = {.lex_state = 0},
  [1749] = {.lex_state = 30},
  [1750] = {.lex_state = 30},
  [1751] = {.lex_state = 0},
  [1752] = {.lex_state = 30},
  [1753] = {.lex_state = 0},
  [1754] = {.lex_state = 0},
  [1755] = {.lex_state = 30},
  [1756] = {.lex_state = 0},
  [1757] = {.lex_state = 0},
  [1758] = {.lex_state = 30},
  [1759] = {.lex_state = 30},
  [1760] = {.lex_state = 30},
  [1761] = {.lex_state = 0},
  [1762] = {.lex_state = 30},
  [1763] = {.lex_state = 30},
  [1764] = {.lex_state = 0},
  [1765] = {.lex_state = 0},
  [1766] = {.lex_state = 0},
  [1767] = {.lex_state = 30},
  [1768] = {.lex_state = 0},
  [1769] = {.lex_state = 30},
  [1770] = {.lex_state = 0},
  [1771] = {.lex_state = 0},
  [1772] = {.lex_state = 0},
  [1773] = {.lex_state = 30},
  [1774] = {.lex_state = 30},
  [1775] = {.lex_state = 30},
  [1776] = {.lex_state = 30},
  [1777] = {.lex_state = 30},
  [1778] = {.lex_state = 0},
  [1779] = {.lex_state = 30},
  [1780] = {.lex_state = 30},
  [1781] = {.lex_state = 0},
  [1782] = {.lex_state = 0},
  [1783] = {.lex_state = 30},
  [1784] = {.lex_state = 30},
  [1785] = {.lex_state = 30},
  [1786] = {.lex_state = 30},
  [1787] = {.lex_state = 30},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 30},
  [1790] = {.lex_state = 0},
  [1791] = {.lex_state = 0},
  [1792] = {.lex_state = 30},
  [1793] = {.lex_state = 30},
  [1794] = {.lex_state = 30},
  [1795] = {.lex_state = 30},
  [1796] = {.lex_state = 0},
  [1797] = {.lex_state = 30},
  [1798] = {.lex_state = 30},
  [1799] = {.lex_state = 30},
  [1800] = {.lex_state = 0},
  [1801] = {.lex_state = 30},
  [1802] = {.lex_state = 30},
  [1803] = {.lex_state = 30},
  [1804] = {.lex_state = 30},
  [1805] = {.lex_state = 30},
  [1806] = {.lex_state = 30},
  [1807] = {.lex_state = 30},
  [1808] = {.lex_state = 30},
  [1809] = {.lex_state = 30},
  [1810] = {.lex_state = 30},
  [1811] = {.lex_state = 30},
  [1812] = {.lex_state = 30},
  [1813] = {.lex_state = 30},
  [1814] = {.lex_state = 30},
  [1815] = {.lex_state = 30},
  [1816] = {.lex_state = 30},
  [1817] = {.lex_state = 30},
  [1818] = {.lex_state = 30},
  [1819] = {.lex_state = 30},
  [1820] = {.lex_state = 30},
  [1821] = {.lex_state = 30},
  [1822] = {.lex_state = 30},
  [1823] = {.lex_state = 30},
  [1824] = {.lex_state = 30},
  [1825] = {.lex_state = 30},
  [1826] = {.lex_state = 30},
  [1827] = {.lex_state = 30},
  [1828] = {.lex_state = 30},
  [1829] = {.lex_state = 30},
  [1830] = {.lex_state = 30},
  [1831] = {.lex_state = 30},
  [1832] = {.lex_state = 30},
  [1833] = {.lex_state = 30},
  [1834] = {.lex_state = 30},
  [1835] = {.lex_state = 30},
  [1836] = {.lex_state = 30},
  [1837] = {.lex_state = 30},
  [1838] = {.lex_state = 30},
  [1839] = {.lex_state = 30},
  [1840] = {.lex_state = 30},
  [1841] = {.lex_state = 30},
  [1842] = {.lex_state = 30},
  [1843] = {.lex_state = 30},
  [1844] = {.lex_state = 30},
  [1845] = {.lex_state = 30},
  [1846] = {.lex_state = 30},
  [1847] = {.lex_state = 30},
  [1848] = {.lex_state = 30},
  [1849] = {.lex_state = 30},
  [1850] = {.lex_state = 30},
  [1851] = {.lex_state = 30},
  [1852] = {.lex_state = 30},
  [1853] = {.lex_state = 30},
  [1854] = {.lex_state = 30},
  [1855] = {.lex_state = 30},
  [1856] = {.lex_state = 30},
  [1857] = {.lex_state = 30},
  [1858] = {.lex_state = 30},
  [1859] = {.lex_state = 30},
  [1860] = {.lex_state = 30},
  [1861] = {.lex_state = 30},
  [1862] = {.lex_state = 30},
  [1863] = {.lex_state = 30},
  [1864] = {.lex_state = 30},
  [1865] = {.lex_state = 30},
  [1866] = {.lex_state = 30},
  [1867] = {.lex_state = 30},
  [1868] = {.lex_state = 30},
  [1869] = {.lex_state = 30},
  [1870] = {.lex_state = 30},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 0},
  [1873] = {.lex_state = 30},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 30},
  [1876] = {.lex_state = 30},
  [1877] = {.lex_state = 30},
  [1878] = {.lex_state = 30},
  [1879] = {.lex_state = 30},
  [1880] = {.lex_state = 30},
  [1881] = {.lex_state = 30},
  [1882] = {.lex_state = 30},
  [1883] = {.lex_state = 30},
  [1884] = {.lex_state = 30},
  [1885] = {.lex_state = 30},
  [1886] = {.lex_state = 30},
  [1887] = {.lex_state = 30},
  [1888] = {.lex_state = 30},
  [1889] = {.lex_state = 0},
  [1890] = {.lex_state = 30},
  [1891] = {.lex_state = 30},
  [1892] = {.lex_state = 30},
  [1893] = {.lex_state = 30},
  [1894] = {.lex_state = 30},
  [1895] = {.lex_state = 30},
  [1896] = {.lex_state = 30},
  [1897] = {.lex_state = 30},
  [1898] = {.lex_state = 30},
  [1899] = {.lex_state = 30},
  [1900] = {.lex_state = 30},
  [1901] = {.lex_state = 30},
  [1902] = {.lex_state = 30},
  [1903] = {.lex_state = 30},
  [1904] = {.lex_state = 30},
  [1905] = {.lex_state = 30},
  [1906] = {.lex_state = 30},
  [1907] = {.lex_state = 30},
  [1908] = {.lex_state = 30},
  [1909] = {.lex_state = 0},
  [1910] = {.lex_state = 30},
  [1911] = {.lex_state = 30},
  [1912] = {.lex_state = 30},
  [1913] = {.lex_state = 30},
  [1914] = {.lex_state = 30},
  [1915] = {.lex_state = 30},
  [1916] = {.lex_state = 30},
  [1917] = {.lex_state = 30},
  [1918] = {.lex_state = 30},
  [1919] = {.lex_state = 0},
  [1920] = {.lex_state = 30},
  [1921] = {.lex_state = 0},
  [1922] = {.lex_state = 30},
  [1923] = {.lex_state = 0},
  [1924] = {.lex_state = 30},
  [1925] = {.lex_state = 30},
  [1926] = {.lex_state = 30},
  [1927] = {.lex_state = 30},
  [1928] = {.lex_state = 30},
  [1929] = {.lex_state = 30},
  [1930] = {.lex_state = 0},
  [1931] = {.lex_state = 30},
  [1932] = {.lex_state = 30},
  [1933] = {.lex_state = 30},
  [1934] = {.lex_state = 30},
  [1935] = {.lex_state = 30},
  [1936] = {.lex_state = 30},
  [1937] = {.lex_state = 30},
  [1938] = {.lex_state = 30},
  [1939] = {.lex_state = 0},
  [1940] = {.lex_state = 30},
  [1941] = {.lex_state = 30},
  [1942] = {.lex_state = 30},
  [1943] = {.lex_state = 30},
  [1944] = {.lex_state = 30},
  [1945] = {.lex_state = 30},
  [1946] = {.lex_state = 30},
  [1947] = {.lex_state = 0},
  [1948] = {.lex_state = 30},
  [1949] = {.lex_state = 30},
  [1950] = {.lex_state = 0},
  [1951] = {.lex_state = 0},
  [1952] = {.lex_state = 30},
  [1953] = {.lex_state = 0},
  [1954] = {.lex_state = 0},
  [1955] = {.lex_state = 30},
  [1956] = {.lex_state = 0},
  [1957] = {.lex_state = 30},
  [1958] = {.lex_state = 0},
  [1959] = {.lex_state = 0},
  [1960] = {.lex_state = 0},
  [1961] = {.lex_state = 0},
  [1962] = {.lex_state = 0},
  [1963] = {.lex_state = 0},
  [1964] = {.lex_state = 0},
  [1965] = {.lex_state = 0},
  [1966] = {.lex_state = 0},
  [1967] = {.lex_state = 0},
  [1968] = {.lex_state = 0},
  [1969] = {.lex_state = 0},
  [1970] = {.lex_state = 0},
  [1971] = {.lex_state = 0},
  [1972] = {.lex_state = 0},
  [1973] = {.lex_state = 0},
  [1974] = {.lex_state = 0},
  [1975] = {.lex_state = 0},
  [1976] = {.lex_state = 0},
  [1977] = {.lex_state = 0},
  [1978] = {.lex_state = 0},
  [1979] = {.lex_state = 0},
  [1980] = {.lex_state = 0},
  [1981] = {.lex_state = 0},
  [1982] = {.lex_state = 0},
  [1983] = {.lex_state = 0},
  [1984] = {.lex_state = 0},
  [1985] = {.lex_state = 0},
  [1986] = {.lex_state = 0},
  [1987] = {.lex_state = 30},
  [1988] = {.lex_state = 0},
  [1989] = {.lex_state = 0},
  [1990] = {.lex_state = 0},
  [1991] = {.lex_state = 0},
  [1992] = {.lex_state = 0},
  [1993] = {.lex_state = 0},
  [1994] = {.lex_state = 0},
  [1995] = {.lex_state = 0},
  [1996] = {.lex_state = 0},
  [1997] = {.lex_state = 0},
  [1998] = {.lex_state = 0},
  [1999] = {.lex_state = 0},
  [2000] = {.lex_state = 30},
  [2001] = {.lex_state = 0},
  [2002] = {.lex_state = 0},
  [2003] = {.lex_state = 0},
  [2004] = {.lex_state = 30},
  [2005] = {.lex_state = 0},
  [2006] = {.lex_state = 30},
  [2007] = {.lex_state = 0},
  [2008] = {.lex_state = 0},
  [2009] = {.lex_state = 30},
  [2010] = {.lex_state = 30},
  [2011] = {.lex_state = 30},
  [2012] = {.lex_state = 0},
  [2013] = {.lex_state = 30},
  [2014] = {.lex_state = 30},
  [2015] = {.lex_state = 30},
  [2016] = {.lex_state = 0},
  [2017] = {.lex_state = 0},
  [2018] = {.lex_state = 30},
  [2019] = {.lex_state = 0},
  [2020] = {.lex_state = 30},
  [2021] = {.lex_state = 30},
  [2022] = {.lex_state = 30},
  [2023] = {.lex_state = 30},
  [2024] = {.lex_state = 30},
  [2025] = {.lex_state = 30},
  [2026] = {.lex_state = 0},
  [2027] = {.lex_state = 0},
  [2028] = {.lex_state = 0},
  [2029] = {.lex_state = 0},
  [2030] = {.lex_state = 0},
  [2031] = {.lex_state = 30},
  [2032] = {.lex_state = 30},
  [2033] = {.lex_state = 30},
  [2034] = {.lex_state = 0},
  [2035] = {.lex_state = 30},
  [2036] = {.lex_state = 0},
  [2037] = {.lex_state = 0},
  [2038] = {.lex_state = 0},
  [2039] = {.lex_state = 30},
  [2040] = {.lex_state = 30},
  [2041] = {.lex_state = 30},
  [2042] = {.lex_state = 30},
  [2043] = {.lex_state = 30},
  [2044] = {.lex_state = 0},
  [2045] = {.lex_state = 30},
  [2046] = {.lex_state = 0},
  [2047] = {.lex_state = 30},
  [2048] = {.lex_state = 0},
  [2049] = {.lex_state = 30},
  [2050] = {.lex_state = 0},
  [2051] = {.lex_state = 30},
  [2052] = {.lex_state = 30},
  [2053] = {.lex_state = 30},
  [2054] = {.lex_state = 0},
  [2055] = {.lex_state = 0},
  [2056] = {.lex_state = 0},
  [2057] = {.lex_state = 0},
  [2058] = {.lex_state = 0},
  [2059] = {.lex_state = 30},
  [2060] = {.lex_state = 0},
  [2061] = {.lex_state = 0},
  [2062] = {.lex_state = 0},
  [2063] = {.lex_state = 0},
  [2064] = {.lex_state = 0},
  [2065] = {.lex_state = 0},
  [2066] = {.lex_state = 0},
  [2067] = {.lex_state = 30},
  [2068] = {.lex_state = 30},
  [2069] = {.lex_state = 0},
  [2070] = {.lex_state = 30},
  [2071] = {.lex_state = 30},
  [2072] = {.lex_state = 0},
  [2073] = {.lex_state = 0},
  [2074] = {.lex_state = 30},
  [2075] = {.lex_state = 0},
  [2076] = {.lex_state = 0},
  [2077] = {.lex_state = 0},
  [2078] = {.lex_state = 0},
  [2079] = {.lex_state = 0},
  [2080] = {.lex_state = 0},
  [2081] = {.lex_state = 0},
  [2082] = {.lex_state = 0},
  [2083] = {.lex_state = 0},
  [2084] = {.lex_state = 0},
  [2085] = {.lex_state = 0},
  [2086] = {.lex_state = 0},
  [2087] = {.lex_state = 0},
  [2088] = {.lex_state = 0},
  [2089] = {.lex_state = 0},
  [2090] = {.lex_state = 0},
  [2091] = {.lex_state = 0},
  [2092] = {.lex_state = 0},
  [2093] = {.lex_state = 0},
  [2094] = {.lex_state = 0},
  [2095] = {.lex_state = 0},
  [2096] = {.lex_state = 0},
  [2097] = {.lex_state = 0},
  [2098] = {.lex_state = 30},
  [2099] = {.lex_state = 30},
  [2100] = {.lex_state = 0},
  [2101] = {.lex_state = 30},
  [2102] = {.lex_state = 0},
  [2103] = {.lex_state = 0},
  [2104] = {.lex_state = 30},
  [2105] = {.lex_state = 0},
  [2106] = {.lex_state = 0},
  [2107] = {.lex_state = 0},
  [2108] = {.lex_state = 30},
  [2109] = {.lex_state = 0},
  [2110] = {.lex_state = 0},
  [2111] = {.lex_state = 0},
  [2112] = {.lex_state = 0},
  [2113] = {.lex_state = 0},
  [2114] = {.lex_state = 0},
  [2115] = {.lex_state = 0},
  [2116] = {.lex_state = 0},
  [2117] = {.lex_state = 0},
  [2118] = {.lex_state = 30},
  [2119] = {.lex_state = 0},
  [2120] = {.lex_state = 0},
  [2121] = {.lex_state = 0},
  [2122] = {.lex_state = 0},
  [2123] = {.lex_state = 30},
  [2124] = {.lex_state = 0},
  [2125] = {.lex_state = 0},
  [2126] = {.lex_state = 0},
  [2127] = {.lex_state = 30},
  [2128] = {.lex_state = 30},
  [2129] = {.lex_state = 30},
  [2130] = {.lex_state = 0},
  [2131] = {.lex_state = 30},
  [2132] = {.lex_state = 30},
  [2133] = {.lex_state = 0},
  [2134] = {.lex_state = 0},
  [2135] = {.lex_state = 30},
  [2136] = {.lex_state = 0},
  [2137] = {.lex_state = 0},
  [2138] = {.lex_state = 0},
  [2139] = {.lex_state = 0},
  [2140] = {.lex_state = 0},
  [2141] = {.lex_state = 0},
  [2142] = {.lex_state = 0},
  [2143] = {.lex_state = 30},
  [2144] = {.lex_state = 0},
  [2145] = {.lex_state = 0},
  [2146] = {.lex_state = 0},
  [2147] = {.lex_state = 0},
  [2148] = {.lex_state = 30},
  [2149] = {.lex_state = 0},
  [2150] = {.lex_state = 0},
  [2151] = {.lex_state = 0},
  [2152] = {.lex_state = 0},
  [2153] = {.lex_state = 0},
  [2154] = {.lex_state = 0},
  [2155] = {.lex_state = 30},
  [2156] = {.lex_state = 0},
  [2157] = {.lex_state = 30},
  [2158] = {.lex_state = 0},
  [2159] = {.lex_state = 0},
  [2160] = {.lex_state = 0},
  [2161] = {.lex_state = 0},
  [2162] = {.lex_state = 0},
  [2163] = {.lex_state = 30},
  [2164] = {.lex_state = 30},
  [2165] = {.lex_state = 0},
  [2166] = {.lex_state = 30},
  [2167] = {.lex_state = 0},
  [2168] = {.lex_state = 0},
  [2169] = {.lex_state = 0},
  [2170] = {.lex_state = 0},
  [2171] = {.lex_state = 30},
  [2172] = {.lex_state = 0},
  [2173] = {.lex_state = 30},
  [2174] = {.lex_state = 30},
  [2175] = {.lex_state = 0},
  [2176] = {.lex_state = 0},
  [2177] = {.lex_state = 0},
  [2178] = {.lex_state = 0},
  [2179] = {.lex_state = 30},
  [2180] = {.lex_state = 30},
  [2181] = {.lex_state = 0},
  [2182] = {.lex_state = 30},
  [2183] = {.lex_state = 0},
  [2184] = {.lex_state = 0},
  [2185] = {.lex_state = 0},
  [2186] = {.lex_state = 0},
  [2187] = {.lex_state = 30},
  [2188] = {.lex_state = 30},
  [2189] = {.lex_state = 30},
  [2190] = {.lex_state = 0},
  [2191] = {.lex_state = 0},
  [2192] = {.lex_state = 30},
  [2193] = {.lex_state = 0},
  [2194] = {.lex_state = 30},
  [2195] = {.lex_state = 0},
  [2196] = {.lex_state = 0},
  [2197] = {.lex_state = 30},
  [2198] = {.lex_state = 30},
  [2199] = {.lex_state = 30},
  [2200] = {.lex_state = 30},
  [2201] = {.lex_state = 30},
  [2202] = {.lex_state = 30},
  [2203] = {.lex_state = 30},
  [2204] = {.lex_state = 30},
  [2205] = {.lex_state = 30},
  [2206] = {.lex_state = 0},
  [2207] = {.lex_state = 30},
  [2208] = {.lex_state = 30},
  [2209] = {.lex_state = 0},
  [2210] = {.lex_state = 30},
  [2211] = {.lex_state = 30},
  [2212] = {.lex_state = 0},
  [2213] = {.lex_state = 0},
  [2214] = {.lex_state = 0},
  [2215] = {.lex_state = 0},
  [2216] = {.lex_state = 30},
  [2217] = {.lex_state = 30},
  [2218] = {.lex_state = 30},
  [2219] = {.lex_state = 0},
  [2220] = {.lex_state = 0},
  [2221] = {.lex_state = 0},
  [2222] = {.lex_state = 0},
  [2223] = {.lex_state = 0},
  [2224] = {.lex_state = 30},
  [2225] = {.lex_state = 30},
  [2226] = {.lex_state = 0},
  [2227] = {.lex_state = 30},
  [2228] = {.lex_state = 0},
  [2229] = {.lex_state = 30},
  [2230] = {.lex_state = 0},
  [2231] = {.lex_state = 0},
  [2232] = {.lex_state = 30},
  [2233] = {.lex_state = 0},
  [2234] = {.lex_state = 0},
  [2235] = {.lex_state = 30},
  [2236] = {.lex_state = 0},
  [2237] = {.lex_state = 30},
  [2238] = {.lex_state = 0},
  [2239] = {.lex_state = 30},
  [2240] = {.lex_state = 30},
  [2241] = {.lex_state = 30},
  [2242] = {.lex_state = 30},
  [2243] = {.lex_state = 30},
  [2244] = {.lex_state = 0},
  [2245] = {.lex_state = 30},
  [2246] = {.lex_state = 0},
  [2247] = {.lex_state = 0},
  [2248] = {.lex_state = 0},
  [2249] = {.lex_state = 0},
  [2250] = {.lex_state = 30},
  [2251] = {.lex_state = 0},
  [2252] = {.lex_state = 0},
  [2253] = {.lex_state = 0},
  [2254] = {.lex_state = 0},
  [2255] = {.lex_state = 30},
  [2256] = {.lex_state = 0},
  [2257] = {.lex_state = 30},
  [2258] = {.lex_state = 30},
  [2259] = {.lex_state = 0},
  [2260] = {.lex_state = 0},
  [2261] = {.lex_state = 30},
  [2262] = {.lex_state = 0},
  [2263] = {.lex_state = 30},
  [2264] = {.lex_state = 0},
  [2265] = {.lex_state = 0},
  [2266] = {.lex_state = 0},
  [2267] = {.lex_state = 0},
  [2268] = {.lex_state = 30},
  [2269] = {.lex_state = 0},
  [2270] = {.lex_state = 30},
  [2271] = {.lex_state = 0},
  [2272] = {.lex_state = 0},
  [2273] = {.lex_state = 30},
  [2274] = {.lex_state = 0},
  [2275] = {.lex_state = 30},
  [2276] = {.lex_state = 0},
  [2277] = {.lex_state = 0},
  [2278] = {.lex_state = 0},
  [2279] = {.lex_state = 30},
  [2280] = {.lex_state = 0},
  [2281] = {.lex_state = 0},
  [2282] = {.lex_state = 0},
  [2283] = {.lex_state = 30},
  [2284] = {.lex_state = 0},
  [2285] = {.lex_state = 30},
  [2286] = {.lex_state = 0},
  [2287] = {.lex_state = 30},
  [2288] = {.lex_state = 30},
  [2289] = {.lex_state = 0},
  [2290] = {.lex_state = 30},
  [2291] = {.lex_state = 0},
  [2292] = {.lex_state = 0},
  [2293] = {.lex_state = 0},
  [2294] = {.lex_state = 30},
  [2295] = {.lex_state = 0},
  [2296] = {.lex_state = 30},
  [2297] = {.lex_state = 0},
  [2298] = {.lex_state = 0},
  [2299] = {.lex_state = 0},
  [2300] = {.lex_state = 0},
  [2301] = {.lex_state = 30},
  [2302] = {.lex_state = 30},
  [2303] = {.lex_state = 30},
  [2304] = {.lex_state = 0},
  [2305] = {.lex_state = 0},
  [2306] = {.lex_state = 0},
  [2307] = {.lex_state = 0},
  [2308] = {.lex_state = 30},
  [2309] = {.lex_state = 30},
  [2310] = {.lex_state = 30},
  [2311] = {.lex_state = 30},
  [2312] = {.lex_state = 30},
  [2313] = {.lex_state = 30},
  [2314] = {.lex_state = 0},
  [2315] = {.lex_state = 30},
  [2316] = {.lex_state = 0},
  [2317] = {.lex_state = 0},
  [2318] = {.lex_state = 30},
  [2319] = {.lex_state = 0},
  [2320] = {.lex_state = 0},
  [2321] = {.lex_state = 0},
  [2322] = {.lex_state = 30},
  [2323] = {.lex_state = 30},
  [2324] = {.lex_state = 30},
  [2325] = {.lex_state = 30},
  [2326] = {.lex_state = 30},
  [2327] = {.lex_state = 30},
  [2328] = {.lex_state = 30},
  [2329] = {.lex_state = 0},
  [2330] = {.lex_state = 30},
  [2331] = {.lex_state = 30},
  [2332] = {.lex_state = 30},
  [2333] = {.lex_state = 0},
  [2334] = {.lex_state = 30},
  [2335] = {.lex_state = 30},
  [2336] = {.lex_state = 0},
  [2337] = {.lex_state = 30},
  [2338] = {.lex_state = 0},
  [2339] = {.lex_state = 0},
  [2340] = {.lex_state = 30},
  [2341] = {.lex_state = 0},
  [2342] = {.lex_state = 30},
  [2343] = {.lex_state = 0},
  [2344] = {.lex_state = 30},
  [2345] = {.lex_state = 0},
  [2346] = {.lex_state = 0},
  [2347] = {.lex_state = 30},
  [2348] = {.lex_state = 30},
  [2349] = {.lex_state = 0},
  [2350] = {.lex_state = 30},
  [2351] = {.lex_state = 30},
  [2352] = {.lex_state = 0},
  [2353] = {.lex_state = 0},
  [2354] = {.lex_state = 30},
  [2355] = {.lex_state = 30},
  [2356] = {.lex_state = 0},
  [2357] = {.lex_state = 30},
  [2358] = {.lex_state = 30},
  [2359] = {.lex_state = 0},
  [2360] = {.lex_state = 0},
  [2361] = {.lex_state = 30},
  [2362] = {.lex_state = 30},
  [2363] = {.lex_state = 0},
  [2364] = {.lex_state = 0},
  [2365] = {.lex_state = 30},
  [2366] = {.lex_state = 30},
  [2367] = {.lex_state = 0},
  [2368] = {.lex_state = 0},
  [2369] = {.lex_state = 0},
  [2370] = {.lex_state = 30},
  [2371] = {.lex_state = 30},
  [2372] = {.lex_state = 30},
  [2373] = {.lex_state = 30},
  [2374] = {.lex_state = 0},
  [2375] = {.lex_state = 30},
  [2376] = {.lex_state = 0},
  [2377] = {.lex_state = 30},
  [2378] = {.lex_state = 30},
  [2379] = {.lex_state = 30},
  [2380] = {.lex_state = 0},
  [2381] = {.lex_state = 0},
  [2382] = {.lex_state = 30},
  [2383] = {.lex_state = 0},
  [2384] = {.lex_state = 30},
  [2385] = {.lex_state = 30},
  [2386] = {.lex_state = 30},
  [2387] = {.lex_state = 30},
  [2388] = {.lex_state = 30},
  [2389] = {.lex_state = 30},
  [2390] = {.lex_state = 30},
  [2391] = {.lex_state = 0},
  [2392] = {.lex_state = 0},
  [2393] = {.lex_state = 0},
  [2394] = {.lex_state = 30},
  [2395] = {.lex_state = 30},
  [2396] = {.lex_state = 30},
  [2397] = {.lex_state = 0},
  [2398] = {.lex_state = 0},
  [2399] = {.lex_state = 30},
  [2400] = {.lex_state = 30},
  [2401] = {.lex_state = 0},
  [2402] = {.lex_state = 0},
  [2403] = {.lex_state = 0},
  [2404] = {.lex_state = 30},
  [2405] = {.lex_state = 30},
  [2406] = {.lex_state = 30},
  [2407] = {.lex_state = 0},
  [2408] = {.lex_state = 0},
  [2409] = {.lex_state = 0},
  [2410] = {.lex_state = 30},
  [2411] = {.lex_state = 0},
  [2412] = {.lex_state = 30},
  [2413] = {.lex_state = 30},
  [2414] = {.lex_state = 0},
  [2415] = {.lex_state = 0},
  [2416] = {.lex_state = 0},
  [2417] = {.lex_state = 0},
  [2418] = {.lex_state = 0},
  [2419] = {.lex_state = 0},
  [2420] = {.lex_state = 30},
  [2421] = {.lex_state = 30},
  [2422] = {.lex_state = 0},
  [2423] = {.lex_state = 0},
  [2424] = {.lex_state = 30},
  [2425] = {.lex_state = 0},
  [2426] = {.lex_state = 30},
  [2427] = {.lex_state = 0},
  [2428] = {.lex_state = 30},
  [2429] = {.lex_state = 0},
  [2430] = {.lex_state = 30},
  [2431] = {.lex_state = 0},
  [2432] = {.lex_state = 30},
  [2433] = {.lex_state = 0},
  [2434] = {.lex_state = 30},
  [2435] = {.lex_state = 0},
  [2436] = {.lex_state = 0},
  [2437] = {.lex_state = 0},
  [2438] = {.lex_state = 30},
  [2439] = {.lex_state = 0},
  [2440] = {.lex_state = 30},
  [2441] = {.lex_state = 0},
  [2442] = {.lex_state = 30},
  [2443] = {.lex_state = 30},
  [2444] = {.lex_state = 30},
  [2445] = {.lex_state = 0},
  [2446] = {.lex_state = 0},
  [2447] = {.lex_state = 30},
  [2448] = {.lex_state = 0},
  [2449] = {.lex_state = 0},
  [2450] = {.lex_state = 30},
  [2451] = {.lex_state = 30},
  [2452] = {.lex_state = 30},
  [2453] = {.lex_state = 30},
  [2454] = {.lex_state = 0},
  [2455] = {.lex_state = 0},
  [2456] = {.lex_state = 30},
  [2457] = {.lex_state = 30},
  [2458] = {.lex_state = 0},
  [2459] = {.lex_state = 0},
  [2460] = {.lex_state = 30},
  [2461] = {.lex_state = 30},
  [2462] = {.lex_state = 30},
  [2463] = {.lex_state = 30},
  [2464] = {.lex_state = 0},
  [2465] = {.lex_state = 0},
  [2466] = {.lex_state = 0},
  [2467] = {.lex_state = 30},
  [2468] = {.lex_state = 30},
  [2469] = {.lex_state = 0},
  [2470] = {.lex_state = 0},
  [2471] = {.lex_state = 30},
  [2472] = {.lex_state = 0},
  [2473] = {.lex_state = 30},
  [2474] = {.lex_state = 30},
  [2475] = {.lex_state = 0},
  [2476] = {.lex_state = 0},
  [2477] = {.lex_state = 0},
  [2478] = {.lex_state = 30},
  [2479] = {.lex_state = 30},
  [2480] = {.lex_state = 30},
  [2481] = {.lex_state = 0},
  [2482] = {.lex_state = 0},
  [2483] = {.lex_state = 30},
  [2484] = {.lex_state = 30},
  [2485] = {.lex_state = 30},
  [2486] = {.lex_state = 30},
  [2487] = {.lex_state = 30},
  [2488] = {.lex_state = 0},
  [2489] = {.lex_state = 30},
  [2490] = {.lex_state = 30},
  [2491] = {.lex_state = 30},
  [2492] = {.lex_state = 30},
  [2493] = {.lex_state = 30},
  [2494] = {.lex_state = 30},
  [2495] = {.lex_state = 0},
  [2496] = {.lex_state = 30},
  [2497] = {.lex_state = 0},
  [2498] = {.lex_state = 30},
  [2499] = {.lex_state = 0},
  [2500] = {.lex_state = 0},
  [2501] = {.lex_state = 0},
  [2502] = {.lex_state = 30},
  [2503] = {.lex_state = 0},
  [2504] = {.lex_state = 30},
  [2505] = {.lex_state = 30},
  [2506] = {.lex_state = 0},
  [2507] = {.lex_state = 0},
  [2508] = {.lex_state = 30},
  [2509] = {.lex_state = 30},
  [2510] = {.lex_state = 30},
  [2511] = {.lex_state = 30},
  [2512] = {.lex_state = 30},
  [2513] = {.lex_state = 30},
  [2514] = {.lex_state = 30},
  [2515] = {.lex_state = 30},
  [2516] = {.lex_state = 30},
  [2517] = {.lex_state = 30},
  [2518] = {.lex_state = 30},
  [2519] = {.lex_state = 0},
  [2520] = {.lex_state = 30},
  [2521] = {.lex_state = 30},
  [2522] = {.lex_state = 0},
  [2523] = {.lex_state = 30},
  [2524] = {.lex_state = 0},
  [2525] = {.lex_state = 0},
  [2526] = {.lex_state = 30},
  [2527] = {.lex_state = 30},
  [2528] = {.lex_state = 30},
  [2529] = {.lex_state = 30},
  [2530] = {.lex_state = 0},
  [2531] = {.lex_state = 0},
  [2532] = {.lex_state = 0},
  [2533] = {.lex_state = 30},
  [2534] = {.lex_state = 30},
  [2535] = {.lex_state = 0},
  [2536] = {.lex_state = 30},
  [2537] = {.lex_state = 30},
  [2538] = {.lex_state = 30},
  [2539] = {.lex_state = 30},
  [2540] = {.lex_state = 0},
  [2541] = {.lex_state = 0},
  [2542] = {.lex_state = 30},
  [2543] = {.lex_state = 30},
  [2544] = {.lex_state = 30},
  [2545] = {.lex_state = 30},
  [2546] = {.lex_state = 30},
  [2547] = {.lex_state = 30},
  [2548] = {.lex_state = 0},
  [2549] = {.lex_state = 30},
  [2550] = {.lex_state = 30},
  [2551] = {.lex_state = 0},
  [2552] = {.lex_state = 30},
  [2553] = {.lex_state = 30},
  [2554] = {.lex_state = 30},
  [2555] = {.lex_state = 30},
  [2556] = {.lex_state = 30},
  [2557] = {.lex_state = 30},
  [2558] = {.lex_state = 30},
  [2559] = {.lex_state = 30},
  [2560] = {.lex_state = 30},
  [2561] = {.lex_state = 30},
  [2562] = {.lex_state = 30},
  [2563] = {.lex_state = 0},
  [2564] = {.lex_state = 30},
  [2565] = {.lex_state = 30},
  [2566] = {.lex_state = 30},
  [2567] = {.lex_state = 30},
  [2568] = {.lex_state = 0},
  [2569] = {.lex_state = 30},
  [2570] = {.lex_state = 30},
  [2571] = {.lex_state = 30},
  [2572] = {.lex_state = 30},
  [2573] = {.lex_state = 30},
  [2574] = {.lex_state = 30},
  [2575] = {.lex_state = 30},
  [2576] = {.lex_state = 0},
  [2577] = {.lex_state = 30},
  [2578] = {.lex_state = 30},
  [2579] = {.lex_state = 0},
  [2580] = {.lex_state = 0},
  [2581] = {.lex_state = 30},
  [2582] = {.lex_state = 0},
  [2583] = {.lex_state = 0},
  [2584] = {.lex_state = 30},
  [2585] = {.lex_state = 30},
  [2586] = {.lex_state = 0},
  [2587] = {.lex_state = 30},
  [2588] = {.lex_state = 0},
  [2589] = {.lex_state = 0},
  [2590] = {.lex_state = 30},
  [2591] = {.lex_state = 30},
  [2592] = {.lex_state = 0},
  [2593] = {.lex_state = 0},
  [2594] = {.lex_state = 30},
  [2595] = {.lex_state = 30},
  [2596] = {.lex_state = 30},
  [2597] = {.lex_state = 30},
  [2598] = {.lex_state = 30},
  [2599] = {.lex_state = 30},
  [2600] = {.lex_state = 30},
  [2601] = {.lex_state = 30},
  [2602] = {.lex_state = 0},
  [2603] = {.lex_state = 0},
  [2604] = {.lex_state = 30},
  [2605] = {.lex_state = 30},
  [2606] = {.lex_state = 30},
  [2607] = {.lex_state = 0},
  [2608] = {.lex_state = 0},
  [2609] = {.lex_state = 0},
  [2610] = {.lex_state = 0},
  [2611] = {.lex_state = 30},
  [2612] = {.lex_state = 0},
  [2613] = {.lex_state = 30},
  [2614] = {.lex_state = 30},
  [2615] = {.lex_state = 0},
  [2616] = {.lex_state = 30},
  [2617] = {.lex_state = 0},
  [2618] = {.lex_state = 30},
  [2619] = {.lex_state = 30},
  [2620] = {.lex_state = 30},
  [2621] = {.lex_state = 30},
  [2622] = {.lex_state = 30},
  [2623] = {.lex_state = 30},
  [2624] = {.lex_state = 30},
  [2625] = {.lex_state = 0},
  [2626] = {.lex_state = 30},
  [2627] = {.lex_state = 30},
  [2628] = {.lex_state = 30},
  [2629] = {.lex_state = 0},
  [2630] = {.lex_state = 30},
  [2631] = {.lex_state = 30},
  [2632] = {.lex_state = 30},
  [2633] = {.lex_state = 0},
  [2634] = {.lex_state = 30},
  [2635] = {.lex_state = 30},
  [2636] = {.lex_state = 0},
  [2637] = {.lex_state = 30},
  [2638] = {.lex_state = 30},
  [2639] = {.lex_state = 30},
  [2640] = {.lex_state = 30},
  [2641] = {.lex_state = 30},
  [2642] = {.lex_state = 30},
  [2643] = {.lex_state = 30},
  [2644] = {.lex_state = 30},
  [2645] = {.lex_state = 30},
  [2646] = {.lex_state = 30},
  [2647] = {.lex_state = 30},
  [2648] = {.lex_state = 0},
  [2649] = {.lex_state = 0},
  [2650] = {.lex_state = 30},
  [2651] = {.lex_state = 0},
  [2652] = {.lex_state = 30},
  [2653] = {.lex_state = 0},
  [2654] = {.lex_state = 30},
  [2655] = {.lex_state = 30},
  [2656] = {.lex_state = 30},
  [2657] = {.lex_state = 30},
  [2658] = {.lex_state = 30},
  [2659] = {.lex_state = 0},
  [2660] = {.lex_state = 30},
  [2661] = {.lex_state = 30},
  [2662] = {.lex_state = 30},
  [2663] = {.lex_state = 30},
  [2664] = {.lex_state = 30},
  [2665] = {.lex_state = 30},
  [2666] = {.lex_state = 0},
  [2667] = {.lex_state = 30},
  [2668] = {.lex_state = 0},
  [2669] = {.lex_state = 30},
  [2670] = {.lex_state = 30},
  [2671] = {.lex_state = 30},
  [2672] = {.lex_state = 30},
  [2673] = {.lex_state = 0},
  [2674] = {.lex_state = 30},
  [2675] = {.lex_state = 0},
  [2676] = {.lex_state = 30},
  [2677] = {.lex_state = 30},
  [2678] = {.lex_state = 0},
  [2679] = {.lex_state = 30},
  [2680] = {.lex_state = 30},
  [2681] = {.lex_state = 30},
  [2682] = {.lex_state = 0},
  [2683] = {.lex_state = 0},
  [2684] = {.lex_state = 30},
  [2685] = {.lex_state = 30},
  [2686] = {.lex_state = 30},
  [2687] = {.lex_state = 30},
  [2688] = {.lex_state = 30},
  [2689] = {.lex_state = 0},
  [2690] = {.lex_state = 30},
  [2691] = {.lex_state = 30},
  [2692] = {.lex_state = 30},
  [2693] = {.lex_state = 0},
  [2694] = {.lex_state = 0},
  [2695] = {.lex_state = 0},
  [2696] = {.lex_state = 0},
  [2697] = {.lex_state = 30},
  [2698] = {.lex_state = 30},
  [2699] = {.lex_state = 30},
  [2700] = {.lex_state = 30},
  [2701] = {.lex_state = 0},
  [2702] = {.lex_state = 0},
  [2703] = {.lex_state = 0},
  [2704] = {.lex_state = 0},
  [2705] = {.lex_state = 0},
  [2706] = {.lex_state = 30},
  [2707] = {.lex_state = 0},
  [2708] = {.lex_state = 30},
  [2709] = {.lex_state = 30},
  [2710] = {.lex_state = 0},
  [2711] = {.lex_state = 30},
  [2712] = {.lex_state = 30},
  [2713] = {.lex_state = 30},
  [2714] = {.lex_state = 30},
  [2715] = {.lex_state = 0},
  [2716] = {.lex_state = 30},
  [2717] = {.lex_state = 30},
  [2718] = {.lex_state = 30},
  [2719] = {.lex_state = 30},
  [2720] = {.lex_state = 0},
  [2721] = {.lex_state = 30},
  [2722] = {.lex_state = 30},
  [2723] = {.lex_state = 0},
  [2724] = {.lex_state = 30},
  [2725] = {.lex_state = 30},
  [2726] = {.lex_state = 0},
  [2727] = {.lex_state = 0},
  [2728] = {.lex_state = 30},
  [2729] = {.lex_state = 30},
  [2730] = {.lex_state = 0},
  [2731] = {.lex_state = 30},
  [2732] = {.lex_state = 30},
  [2733] = {.lex_state = 30},
  [2734] = {.lex_state = 0},
  [2735] = {.lex_state = 0},
  [2736] = {.lex_state = 30},
  [2737] = {.lex_state = 30},
  [2738] = {.lex_state = 30},
  [2739] = {.lex_state = 0},
  [2740] = {.lex_state = 30},
  [2741] = {.lex_state = 30},
  [2742] = {.lex_state = 0},
  [2743] = {.lex_state = 0},
  [2744] = {.lex_state = 0},
  [2745] = {.lex_state = 30},
  [2746] = {.lex_state = 30},
  [2747] = {.lex_state = 30},
  [2748] = {.lex_state = 0},
  [2749] = {.lex_state = 0},
  [2750] = {.lex_state = 0},
  [2751] = {.lex_state = 0},
  [2752] = {.lex_state = 0},
  [2753] = {.lex_state = 0},
  [2754] = {.lex_state = 0},
  [2755] = {.lex_state = 0},
  [2756] = {.lex_state = 0},
  [2757] = {.lex_state = 0},
  [2758] = {.lex_state = 30},
  [2759] = {.lex_state = 0},
  [2760] = {.lex_state = 30},
  [2761] = {.lex_state = 0},
  [2762] = {.lex_state = 30},
  [2763] = {.lex_state = 0},
  [2764] = {.lex_state = 0},
  [2765] = {.lex_state = 30},
  [2766] = {.lex_state = 30},
  [2767] = {.lex_state = 30},
  [2768] = {.lex_state = 0},
  [2769] = {.lex_state = 0},
  [2770] = {.lex_state = 30},
  [2771] = {.lex_state = 0},
  [2772] = {.lex_state = 0},
  [2773] = {.lex_state = 0},
  [2774] = {.lex_state = 0},
  [2775] = {.lex_state = 0},
  [2776] = {.lex_state = 0},
  [2777] = {.lex_state = 30},
  [2778] = {.lex_state = 0},
  [2779] = {.lex_state = 0},
  [2780] = {.lex_state = 0},
  [2781] = {.lex_state = 0},
  [2782] = {.lex_state = 30},
  [2783] = {.lex_state = 30},
  [2784] = {.lex_state = 0},
  [2785] = {.lex_state = 30},
  [2786] = {.lex_state = 30},
  [2787] = {.lex_state = 0},
  [2788] = {.lex_state = 30},
  [2789] = {.lex_state = 0},
  [2790] = {.lex_state = 0},
  [2791] = {.lex_state = 30},
  [2792] = {.lex_state = 0},
  [2793] = {.lex_state = 0},
  [2794] = {.lex_state = 0},
  [2795] = {.lex_state = 0},
  [2796] = {.lex_state = 0},
  [2797] = {.lex_state = 0},
  [2798] = {.lex_state = 0},
  [2799] = {.lex_state = 30},
  [2800] = {.lex_state = 30},
  [2801] = {.lex_state = 30},
  [2802] = {.lex_state = 0},
  [2803] = {.lex_state = 30},
  [2804] = {.lex_state = 30},
  [2805] = {.lex_state = 30},
  [2806] = {.lex_state = 30},
  [2807] = {.lex_state = 0},
  [2808] = {.lex_state = 30},
  [2809] = {.lex_state = 0},
  [2810] = {.lex_state = 0},
  [2811] = {.lex_state = 30},
  [2812] = {.lex_state = 0},
  [2813] = {.lex_state = 30},
  [2814] = {.lex_state = 30},
  [2815] = {.lex_state = 30},
  [2816] = {.lex_state = 0},
  [2817] = {.lex_state = 0},
  [2818] = {.lex_state = 30},
  [2819] = {.lex_state = 30},
  [2820] = {.lex_state = 30},
  [2821] = {.lex_state = 30},
  [2822] = {.lex_state = 30},
  [2823] = {.lex_state = 0},
  [2824] = {.lex_state = 0},
  [2825] = {.lex_state = 0},
  [2826] = {.lex_state = 0},
  [2827] = {.lex_state = 0},
  [2828] = {.lex_state = 30},
  [2829] = {.lex_state = 0},
  [2830] = {.lex_state = 0},
  [2831] = {.lex_state = 30},
  [2832] = {.lex_state = 30},
  [2833] = {.lex_state = 0},
  [2834] = {.lex_state = 0},
  [2835] = {.lex_state = 0},
  [2836] = {.lex_state = 30},
  [2837] = {.lex_state = 0},
  [2838] = {.lex_state = 0},
  [2839] = {.lex_state = 30},
  [2840] = {.lex_state = 30},
  [2841] = {.lex_state = 0},
  [2842] = {.lex_state = 0},
  [2843] = {.lex_state = 30},
  [2844] = {.lex_state = 0},
  [2845] = {.lex_state = 30},
  [2846] = {.lex_state = 0},
  [2847] = {.lex_state = 0},
  [2848] = {.lex_state = 0},
  [2849] = {.lex_state = 0},
  [2850] = {.lex_state = 30},
  [2851] = {.lex_state = 0},
  [2852] = {.lex_state = 0},
  [2853] = {.lex_state = 0},
  [2854] = {.lex_state = 0},
  [2855] = {.lex_state = 30},
  [2856] = {.lex_state = 30},
  [2857] = {.lex_state = 0},
  [2858] = {.lex_state = 0},
  [2859] = {.lex_state = 0},
  [2860] = {.lex_state = 30},
  [2861] = {.lex_state = 30},
  [2862] = {.lex_state = 0},
  [2863] = {.lex_state = 0},
  [2864] = {.lex_state = 30},
  [2865] = {.lex_state = 0},
  [2866] = {.lex_state = 30},
  [2867] = {.lex_state = 0},
  [2868] = {.lex_state = 30},
  [2869] = {.lex_state = 0},
  [2870] = {.lex_state = 30},
  [2871] = {.lex_state = 0},
  [2872] = {.lex_state = 30},
  [2873] = {.lex_state = 0},
  [2874] = {.lex_state = 30},
  [2875] = {.lex_state = 30},
  [2876] = {.lex_state = 0},
  [2877] = {.lex_state = 0},
  [2878] = {.lex_state = 30},
  [2879] = {.lex_state = 0},
  [2880] = {.lex_state = 0},
  [2881] = {.lex_state = 0},
  [2882] = {.lex_state = 30},
  [2883] = {.lex_state = 30},
  [2884] = {.lex_state = 30},
  [2885] = {.lex_state = 0},
  [2886] = {.lex_state = 30},
  [2887] = {.lex_state = 0},
  [2888] = {.lex_state = 0},
  [2889] = {.lex_state = 30},
  [2890] = {.lex_state = 30},
  [2891] = {.lex_state = 0},
  [2892] = {.lex_state = 0},
  [2893] = {.lex_state = 30},
  [2894] = {.lex_state = 30},
  [2895] = {.lex_state = 30},
  [2896] = {.lex_state = 0},
  [2897] = {.lex_state = 30},
  [2898] = {.lex_state = 0},
  [2899] = {.lex_state = 30},
  [2900] = {.lex_state = 30},
  [2901] = {.lex_state = 0},
  [2902] = {.lex_state = 30},
  [2903] = {.lex_state = 30},
  [2904] = {.lex_state = 0},
  [2905] = {.lex_state = 30},
  [2906] = {.lex_state = 0},
  [2907] = {.lex_state = 0},
  [2908] = {.lex_state = 0},
  [2909] = {.lex_state = 30},
  [2910] = {.lex_state = 30},
  [2911] = {.lex_state = 30},
  [2912] = {.lex_state = 30},
  [2913] = {.lex_state = 0},
  [2914] = {.lex_state = 0},
  [2915] = {.lex_state = 0},
  [2916] = {.lex_state = 0},
  [2917] = {.lex_state = 0},
  [2918] = {.lex_state = 0},
  [2919] = {.lex_state = 0},
  [2920] = {.lex_state = 0},
  [2921] = {.lex_state = 0},
  [2922] = {.lex_state = 0},
  [2923] = {.lex_state = 0},
  [2924] = {.lex_state = 0},
  [2925] = {.lex_state = 0},
  [2926] = {.lex_state = 0},
  [2927] = {.lex_state = 0},
  [2928] = {.lex_state = 0},
  [2929] = {.lex_state = 0},
  [2930] = {.lex_state = 0},
  [2931] = {.lex_state = 30},
  [2932] = {.lex_state = 0},
  [2933] = {.lex_state = 0},
  [2934] = {.lex_state = 0},
  [2935] = {.lex_state = 0},
  [2936] = {.lex_state = 0},
  [2937] = {.lex_state = 30},
  [2938] = {.lex_state = 0},
  [2939] = {.lex_state = 0},
  [2940] = {.lex_state = 0},
  [2941] = {.lex_state = 0},
  [2942] = {.lex_state = 0},
  [2943] = {.lex_state = 30},
  [2944] = {.lex_state = 0},
  [2945] = {.lex_state = 0},
  [2946] = {.lex_state = 0},
  [2947] = {.lex_state = 30},
  [2948] = {.lex_state = 0},
  [2949] = {.lex_state = 0},
  [2950] = {.lex_state = 30},
  [2951] = {.lex_state = 0},
  [2952] = {.lex_state = 0},
  [2953] = {.lex_state = 0},
  [2954] = {.lex_state = 30},
  [2955] = {.lex_state = 0},
  [2956] = {.lex_state = 30},
  [2957] = {.lex_state = 30},
  [2958] = {.lex_state = 0},
  [2959] = {.lex_state = 30},
  [2960] = {.lex_state = 0},
  [2961] = {.lex_state = 0},
  [2962] = {.lex_state = 30},
  [2963] = {.lex_state = 0},
  [2964] = {.lex_state = 30},
  [2965] = {.lex_state = 0},
  [2966] = {.lex_state = 0},
  [2967] = {.lex_state = 0},
  [2968] = {.lex_state = 0},
  [2969] = {.lex_state = 0},
  [2970] = {.lex_state = 0},
  [2971] = {.lex_state = 0},
  [2972] = {.lex_state = 30},
  [2973] = {.lex_state = 30},
  [2974] = {.lex_state = 0},
  [2975] = {.lex_state = 0},
  [2976] = {.lex_state = 0},
  [2977] = {.lex_state = 0},
  [2978] = {.lex_state = 0},
  [2979] = {.lex_state = 0},
  [2980] = {.lex_state = 0},
  [2981] = {.lex_state = 0},
  [2982] = {.lex_state = 0},
  [2983] = {.lex_state = 0},
  [2984] = {.lex_state = 0},
  [2985] = {.lex_state = 0},
  [2986] = {.lex_state = 0},
  [2987] = {.lex_state = 30},
  [2988] = {.lex_state = 0},
  [2989] = {.lex_state = 0},
  [2990] = {.lex_state = 0},
  [2991] = {.lex_state = 0},
  [2992] = {.lex_state = 0},
  [2993] = {.lex_state = 0},
  [2994] = {.lex_state = 0},
  [2995] = {.lex_state = 0},
  [2996] = {.lex_state = 0},
  [2997] = {.lex_state = 0},
  [2998] = {.lex_state = 0},
  [2999] = {.lex_state = 0},
  [3000] = {.lex_state = 0},
  [3001] = {.lex_state = 0},
  [3002] = {.lex_state = 0},
  [3003] = {.lex_state = 0},
  [3004] = {.lex_state = 0},
  [3005] = {.lex_state = 0},
  [3006] = {.lex_state = 0},
  [3007] = {.lex_state = 0},
  [3008] = {.lex_state = 0},
  [3009] = {.lex_state = 0},
  [3010] = {.lex_state = 0},
  [3011] = {.lex_state = 0},
  [3012] = {.lex_state = 0},
  [3013] = {.lex_state = 0},
  [3014] = {.lex_state = 0},
  [3015] = {.lex_state = 0},
  [3016] = {.lex_state = 0},
  [3017] = {.lex_state = 0},
  [3018] = {.lex_state = 0},
  [3019] = {.lex_state = 0},
  [3020] = {.lex_state = 0},
  [3021] = {.lex_state = 0},
  [3022] = {.lex_state = 0},
  [3023] = {.lex_state = 0},
  [3024] = {.lex_state = 0},
  [3025] = {.lex_state = 0},
  [3026] = {.lex_state = 0},
  [3027] = {.lex_state = 0},
  [3028] = {.lex_state = 0},
  [3029] = {.lex_state = 0},
  [3030] = {.lex_state = 0},
  [3031] = {.lex_state = 0},
  [3032] = {.lex_state = 0},
  [3033] = {.lex_state = 0},
  [3034] = {.lex_state = 0},
  [3035] = {.lex_state = 0},
  [3036] = {.lex_state = 0},
  [3037] = {.lex_state = 0},
  [3038] = {.lex_state = 0},
  [3039] = {.lex_state = 0},
  [3040] = {.lex_state = 0},
  [3041] = {.lex_state = 0},
  [3042] = {.lex_state = 0},
  [3043] = {.lex_state = 0},
  [3044] = {.lex_state = 0},
  [3045] = {.lex_state = 0},
  [3046] = {.lex_state = 0},
  [3047] = {.lex_state = 0},
  [3048] = {.lex_state = 0},
  [3049] = {.lex_state = 0},
  [3050] = {.lex_state = 0},
  [3051] = {.lex_state = 0},
  [3052] = {.lex_state = 0},
  [3053] = {.lex_state = 0},
  [3054] = {.lex_state = 0},
  [3055] = {.lex_state = 0},
  [3056] = {.lex_state = 0},
  [3057] = {.lex_state = 0},
  [3058] = {.lex_state = 0},
  [3059] = {.lex_state = 0},
  [3060] = {.lex_state = 0},
  [3061] = {.lex_state = 0},
  [3062] = {.lex_state = 0},
  [3063] = {.lex_state = 0},
  [3064] = {.lex_state = 0},
  [3065] = {.lex_state = 0},
  [3066] = {.lex_state = 30},
  [3067] = {.lex_state = 0},
  [3068] = {.lex_state = 0},
  [3069] = {.lex_state = 0},
  [3070] = {.lex_state = 0},
  [3071] = {.lex_state = 0},
  [3072] = {.lex_state = 0},
  [3073] = {.lex_state = 30},
  [3074] = {.lex_state = 0},
  [3075] = {.lex_state = 0},
  [3076] = {.lex_state = 0},
  [3077] = {.lex_state = 0},
  [3078] = {.lex_state = 0},
  [3079] = {.lex_state = 0},
  [3080] = {.lex_state = 0},
  [3081] = {.lex_state = 0},
  [3082] = {.lex_state = 0},
  [3083] = {.lex_state = 0},
  [3084] = {.lex_state = 0},
  [3085] = {.lex_state = 0},
  [3086] = {.lex_state = 0},
  [3087] = {.lex_state = 0},
  [3088] = {.lex_state = 0},
  [3089] = {.lex_state = 0},
  [3090] = {.lex_state = 0},
  [3091] = {.lex_state = 0},
  [3092] = {.lex_state = 0},
  [3093] = {.lex_state = 0},
  [3094] = {.lex_state = 0},
  [3095] = {.lex_state = 0},
  [3096] = {.lex_state = 0},
  [3097] = {.lex_state = 30},
  [3098] = {.lex_state = 0},
  [3099] = {.lex_state = 30},
  [3100] = {.lex_state = 0},
  [3101] = {.lex_state = 0},
  [3102] = {.lex_state = 0},
  [3103] = {.lex_state = 0},
  [3104] = {.lex_state = 0},
  [3105] = {.lex_state = 0},
  [3106] = {.lex_state = 0},
  [3107] = {.lex_state = 0},
  [3108] = {.lex_state = 0},
  [3109] = {.lex_state = 0},
  [3110] = {.lex_state = 0},
  [3111] = {.lex_state = 0},
  [3112] = {.lex_state = 0},
  [3113] = {.lex_state = 0},
  [3114] = {.lex_state = 0},
  [3115] = {.lex_state = 0},
  [3116] = {.lex_state = 0},
  [3117] = {.lex_state = 0},
  [3118] = {.lex_state = 0},
  [3119] = {.lex_state = 0},
  [3120] = {.lex_state = 0},
  [3121] = {.lex_state = 0},
  [3122] = {.lex_state = 0},
  [3123] = {.lex_state = 0},
  [3124] = {.lex_state = 0},
  [3125] = {.lex_state = 0},
  [3126] = {.lex_state = 0},
  [3127] = {.lex_state = 0},
  [3128] = {.lex_state = 0},
  [3129] = {.lex_state = 0},
  [3130] = {.lex_state = 0},
  [3131] = {.lex_state = 0},
  [3132] = {.lex_state = 0},
  [3133] = {.lex_state = 0},
  [3134] = {.lex_state = 0},
  [3135] = {.lex_state = 0},
  [3136] = {.lex_state = 0},
  [3137] = {.lex_state = 0},
  [3138] = {.lex_state = 0},
  [3139] = {.lex_state = 0},
  [3140] = {.lex_state = 0},
  [3141] = {.lex_state = 0},
  [3142] = {.lex_state = 0},
  [3143] = {.lex_state = 0},
  [3144] = {.lex_state = 0},
  [3145] = {.lex_state = 0},
  [3146] = {.lex_state = 0},
  [3147] = {.lex_state = 0},
  [3148] = {.lex_state = 0},
  [3149] = {.lex_state = 0},
  [3150] = {.lex_state = 30},
  [3151] = {.lex_state = 0},
  [3152] = {.lex_state = 0},
  [3153] = {.lex_state = 0},
  [3154] = {.lex_state = 0},
  [3155] = {.lex_state = 0},
  [3156] = {.lex_state = 0},
  [3157] = {.lex_state = 0},
  [3158] = {.lex_state = 0},
  [3159] = {.lex_state = 0},
  [3160] = {.lex_state = 0},
  [3161] = {.lex_state = 0},
  [3162] = {.lex_state = 0},
  [3163] = {.lex_state = 0},
  [3164] = {.lex_state = 0},
  [3165] = {.lex_state = 30},
  [3166] = {.lex_state = 0},
  [3167] = {.lex_state = 0},
  [3168] = {.lex_state = 0},
  [3169] = {.lex_state = 0},
  [3170] = {.lex_state = 0},
  [3171] = {.lex_state = 0},
  [3172] = {.lex_state = 0},
  [3173] = {.lex_state = 0},
  [3174] = {.lex_state = 0},
  [3175] = {.lex_state = 0},
  [3176] = {.lex_state = 0},
  [3177] = {.lex_state = 0},
  [3178] = {.lex_state = 0},
  [3179] = {.lex_state = 0},
  [3180] = {.lex_state = 0},
  [3181] = {.lex_state = 0},
  [3182] = {.lex_state = 0},
  [3183] = {.lex_state = 30},
  [3184] = {.lex_state = 0},
  [3185] = {.lex_state = 0},
  [3186] = {.lex_state = 0},
  [3187] = {.lex_state = 0},
  [3188] = {.lex_state = 0},
  [3189] = {.lex_state = 30},
  [3190] = {.lex_state = 0},
  [3191] = {.lex_state = 0},
  [3192] = {.lex_state = 0},
  [3193] = {.lex_state = 0},
  [3194] = {.lex_state = 0},
  [3195] = {.lex_state = 0},
  [3196] = {.lex_state = 0},
  [3197] = {.lex_state = 0},
  [3198] = {.lex_state = 0},
  [3199] = {.lex_state = 0},
  [3200] = {.lex_state = 0},
  [3201] = {.lex_state = 0},
  [3202] = {.lex_state = 30},
  [3203] = {.lex_state = 0},
  [3204] = {.lex_state = 0},
  [3205] = {.lex_state = 0},
  [3206] = {.lex_state = 0},
  [3207] = {.lex_state = 0},
  [3208] = {.lex_state = 0},
  [3209] = {.lex_state = 0},
  [3210] = {.lex_state = 0},
  [3211] = {.lex_state = 0},
  [3212] = {.lex_state = 0},
  [3213] = {.lex_state = 0},
  [3214] = {.lex_state = 0},
  [3215] = {.lex_state = 0},
  [3216] = {.lex_state = 0},
  [3217] = {.lex_state = 0},
  [3218] = {.lex_state = 0},
  [3219] = {.lex_state = 0},
  [3220] = {.lex_state = 30},
  [3221] = {.lex_state = 0},
  [3222] = {.lex_state = 30},
  [3223] = {.lex_state = 0},
  [3224] = {.lex_state = 0},
  [3225] = {.lex_state = 0},
  [3226] = {.lex_state = 0},
  [3227] = {.lex_state = 0},
  [3228] = {.lex_state = 30},
  [3229] = {.lex_state = 0},
  [3230] = {.lex_state = 0},
  [3231] = {.lex_state = 0},
  [3232] = {.lex_state = 0},
  [3233] = {.lex_state = 0},
  [3234] = {.lex_state = 0},
  [3235] = {.lex_state = 30},
  [3236] = {.lex_state = 30},
  [3237] = {.lex_state = 0},
  [3238] = {.lex_state = 0},
  [3239] = {.lex_state = 30},
  [3240] = {.lex_state = 0},
  [3241] = {.lex_state = 0},
  [3242] = {.lex_state = 30},
  [3243] = {.lex_state = 0},
  [3244] = {.lex_state = 0},
  [3245] = {.lex_state = 0},
  [3246] = {.lex_state = 0},
  [3247] = {.lex_state = 0},
  [3248] = {.lex_state = 30},
  [3249] = {.lex_state = 0},
  [3250] = {.lex_state = 0},
  [3251] = {.lex_state = 0},
  [3252] = {.lex_state = 0},
  [3253] = {.lex_state = 0},
  [3254] = {.lex_state = 30},
  [3255] = {.lex_state = 0},
  [3256] = {.lex_state = 0},
  [3257] = {.lex_state = 0},
  [3258] = {.lex_state = 30},
  [3259] = {.lex_state = 30},
  [3260] = {.lex_state = 0},
  [3261] = {.lex_state = 0},
  [3262] = {.lex_state = 0},
  [3263] = {.lex_state = 0},
  [3264] = {.lex_state = 0},
  [3265] = {.lex_state = 0},
  [3266] = {.lex_state = 0},
  [3267] = {.lex_state = 0},
  [3268] = {.lex_state = 0},
  [3269] = {.lex_state = 0},
  [3270] = {.lex_state = 0},
  [3271] = {.lex_state = 0},
  [3272] = {.lex_state = 0},
  [3273] = {.lex_state = 0},
  [3274] = {.lex_state = 0},
  [3275] = {.lex_state = 0},
  [3276] = {.lex_state = 0},
  [3277] = {.lex_state = 0},
  [3278] = {.lex_state = 0},
  [3279] = {.lex_state = 0},
  [3280] = {.lex_state = 0},
  [3281] = {.lex_state = 30},
  [3282] = {.lex_state = 0},
  [3283] = {.lex_state = 0},
  [3284] = {.lex_state = 0},
  [3285] = {.lex_state = 0},
  [3286] = {.lex_state = 0},
  [3287] = {.lex_state = 0},
  [3288] = {.lex_state = 0},
  [3289] = {.lex_state = 0},
  [3290] = {.lex_state = 0},
  [3291] = {.lex_state = 0},
  [3292] = {.lex_state = 0},
  [3293] = {.lex_state = 0},
  [3294] = {.lex_state = 0},
  [3295] = {.lex_state = 0},
  [3296] = {.lex_state = 0},
  [3297] = {.lex_state = 0},
  [3298] = {.lex_state = 0},
  [3299] = {.lex_state = 0},
  [3300] = {.lex_state = 30},
  [3301] = {.lex_state = 0},
  [3302] = {.lex_state = 0},
  [3303] = {.lex_state = 0},
  [3304] = {.lex_state = 0},
  [3305] = {.lex_state = 0},
  [3306] = {.lex_state = 0},
  [3307] = {.lex_state = 0},
  [3308] = {.lex_state = 0},
  [3309] = {.lex_state = 0},
  [3310] = {.lex_state = 0},
  [3311] = {.lex_state = 0},
  [3312] = {.lex_state = 0},
  [3313] = {.lex_state = 0},
  [3314] = {.lex_state = 0},
  [3315] = {.lex_state = 0},
  [3316] = {.lex_state = 0},
  [3317] = {.lex_state = 0},
  [3318] = {.lex_state = 30},
  [3319] = {.lex_state = 0},
  [3320] = {.lex_state = 0},
  [3321] = {.lex_state = 0},
  [3322] = {.lex_state = 30},
  [3323] = {.lex_state = 0},
  [3324] = {.lex_state = 0},
  [3325] = {.lex_state = 0},
  [3326] = {.lex_state = 0},
  [3327] = {.lex_state = 0},
  [3328] = {.lex_state = 0},
  [3329] = {.lex_state = 0},
  [3330] = {.lex_state = 0},
  [3331] = {.lex_state = 0},
  [3332] = {.lex_state = 0},
  [3333] = {.lex_state = 0},
  [3334] = {.lex_state = 30},
  [3335] = {.lex_state = 30},
  [3336] = {.lex_state = 30},
  [3337] = {.lex_state = 0},
  [3338] = {.lex_state = 0},
  [3339] = {.lex_state = 0},
  [3340] = {.lex_state = 0},
  [3341] = {.lex_state = 0},
  [3342] = {.lex_state = 0},
  [3343] = {.lex_state = 30},
  [3344] = {.lex_state = 0},
  [3345] = {.lex_state = 0},
  [3346] = {.lex_state = 0},
  [3347] = {.lex_state = 0},
  [3348] = {.lex_state = 0},
  [3349] = {.lex_state = 0},
  [3350] = {.lex_state = 0},
  [3351] = {.lex_state = 0},
  [3352] = {.lex_state = 0},
  [3353] = {.lex_state = 0},
  [3354] = {.lex_state = 0},
  [3355] = {.lex_state = 0},
  [3356] = {.lex_state = 0},
  [3357] = {.lex_state = 0},
  [3358] = {.lex_state = 0},
  [3359] = {.lex_state = 0},
  [3360] = {.lex_state = 0},
  [3361] = {.lex_state = 0},
  [3362] = {.lex_state = 0},
  [3363] = {.lex_state = 0},
  [3364] = {.lex_state = 0},
  [3365] = {.lex_state = 0},
  [3366] = {.lex_state = 0},
  [3367] = {.lex_state = 0},
  [3368] = {.lex_state = 0},
  [3369] = {.lex_state = 0},
  [3370] = {.lex_state = 0},
  [3371] = {.lex_state = 0},
  [3372] = {.lex_state = 0},
  [3373] = {.lex_state = 0},
  [3374] = {.lex_state = 0},
  [3375] = {.lex_state = 0},
  [3376] = {.lex_state = 0},
  [3377] = {.lex_state = 0},
  [3378] = {.lex_state = 0},
  [3379] = {.lex_state = 0},
  [3380] = {.lex_state = 0},
  [3381] = {.lex_state = 0},
  [3382] = {.lex_state = 0},
  [3383] = {.lex_state = 0},
  [3384] = {.lex_state = 0},
  [3385] = {.lex_state = 0},
  [3386] = {.lex_state = 0},
  [3387] = {.lex_state = 0},
  [3388] = {.lex_state = 0},
  [3389] = {.lex_state = 0},
  [3390] = {.lex_state = 0},
  [3391] = {.lex_state = 0},
  [3392] = {.lex_state = 0},
  [3393] = {.lex_state = 0},
  [3394] = {.lex_state = 0},
  [3395] = {.lex_state = 0},
  [3396] = {.lex_state = 0},
  [3397] = {.lex_state = 0},
  [3398] = {.lex_state = 0},
  [3399] = {.lex_state = 0},
  [3400] = {.lex_state = 0},
  [3401] = {.lex_state = 0},
  [3402] = {.lex_state = 0},
  [3403] = {.lex_state = 0},
  [3404] = {.lex_state = 0},
  [3405] = {.lex_state = 0},
  [3406] = {.lex_state = 0},
  [3407] = {.lex_state = 0},
  [3408] = {.lex_state = 0},
  [3409] = {.lex_state = 0},
  [3410] = {.lex_state = 0},
  [3411] = {.lex_state = 0},
  [3412] = {.lex_state = 0},
  [3413] = {.lex_state = 0},
  [3414] = {.lex_state = 0},
  [3415] = {.lex_state = 0},
  [3416] = {.lex_state = 0},
  [3417] = {.lex_state = 0},
  [3418] = {.lex_state = 0},
  [3419] = {.lex_state = 0},
  [3420] = {.lex_state = 0},
  [3421] = {.lex_state = 0},
  [3422] = {.lex_state = 0},
  [3423] = {.lex_state = 0},
  [3424] = {.lex_state = 0},
  [3425] = {.lex_state = 0},
  [3426] = {.lex_state = 0},
  [3427] = {.lex_state = 0},
  [3428] = {.lex_state = 0},
  [3429] = {.lex_state = 0},
  [3430] = {.lex_state = 0},
  [3431] = {.lex_state = 0},
  [3432] = {.lex_state = 0},
  [3433] = {.lex_state = 0},
  [3434] = {.lex_state = 0},
  [3435] = {.lex_state = 0},
  [3436] = {.lex_state = 0},
  [3437] = {.lex_state = 0},
  [3438] = {.lex_state = 0},
  [3439] = {.lex_state = 0},
  [3440] = {.lex_state = 0},
  [3441] = {.lex_state = 0},
  [3442] = {.lex_state = 0},
  [3443] = {.lex_state = 0},
  [3444] = {.lex_state = 0},
  [3445] = {.lex_state = 0},
  [3446] = {.lex_state = 0},
  [3447] = {.lex_state = 0},
  [3448] = {.lex_state = 0},
  [3449] = {.lex_state = 0},
  [3450] = {.lex_state = 0},
  [3451] = {.lex_state = 0},
  [3452] = {.lex_state = 0},
  [3453] = {.lex_state = 0},
  [3454] = {.lex_state = 0},
  [3455] = {.lex_state = 0},
  [3456] = {.lex_state = 0},
  [3457] = {.lex_state = 0},
  [3458] = {.lex_state = 0},
  [3459] = {.lex_state = 0},
  [3460] = {.lex_state = 0},
  [3461] = {.lex_state = 0},
  [3462] = {.lex_state = 0},
  [3463] = {.lex_state = 0},
  [3464] = {.lex_state = 0},
  [3465] = {.lex_state = 0},
  [3466] = {.lex_state = 0},
  [3467] = {.lex_state = 0},
  [3468] = {.lex_state = 0},
  [3469] = {.lex_state = 0},
  [3470] = {.lex_state = 0},
  [3471] = {.lex_state = 0},
  [3472] = {.lex_state = 0},
  [3473] = {.lex_state = 0},
  [3474] = {.lex_state = 0},
  [3475] = {.lex_state = 0},
  [3476] = {.lex_state = 0},
  [3477] = {.lex_state = 0},
  [3478] = {.lex_state = 0},
  [3479] = {.lex_state = 0},
  [3480] = {.lex_state = 0},
  [3481] = {.lex_state = 0},
  [3482] = {.lex_state = 0},
  [3483] = {.lex_state = 0},
  [3484] = {.lex_state = 0},
  [3485] = {.lex_state = 0},
  [3486] = {.lex_state = 0},
  [3487] = {.lex_state = 0},
  [3488] = {.lex_state = 0},
  [3489] = {.lex_state = 0},
  [3490] = {.lex_state = 0},
  [3491] = {.lex_state = 0},
  [3492] = {.lex_state = 0},
  [3493] = {.lex_state = 0},
  [3494] = {.lex_state = 0},
  [3495] = {.lex_state = 0},
  [3496] = {.lex_state = 0},
  [3497] = {.lex_state = 0},
  [3498] = {.lex_state = 0},
  [3499] = {.lex_state = 0},
  [3500] = {.lex_state = 0},
  [3501] = {.lex_state = 0},
  [3502] = {.lex_state = 0},
  [3503] = {.lex_state = 0},
  [3504] = {.lex_state = 0},
  [3505] = {.lex_state = 0},
  [3506] = {.lex_state = 0},
  [3507] = {.lex_state = 0},
  [3508] = {.lex_state = 0},
  [3509] = {.lex_state = 0},
  [3510] = {.lex_state = 0},
  [3511] = {.lex_state = 0},
  [3512] = {.lex_state = 0},
  [3513] = {.lex_state = 0},
  [3514] = {.lex_state = 0},
  [3515] = {.lex_state = 0},
  [3516] = {.lex_state = 0},
  [3517] = {.lex_state = 0},
  [3518] = {.lex_state = 0},
  [3519] = {.lex_state = 0},
  [3520] = {.lex_state = 0},
  [3521] = {.lex_state = 0},
  [3522] = {.lex_state = 0},
  [3523] = {.lex_state = 0},
  [3524] = {.lex_state = 0},
  [3525] = {.lex_state = 0},
  [3526] = {.lex_state = 0},
  [3527] = {.lex_state = 0},
  [3528] = {.lex_state = 0},
  [3529] = {.lex_state = 0},
  [3530] = {.lex_state = 0},
  [3531] = {.lex_state = 0},
  [3532] = {.lex_state = 0},
  [3533] = {.lex_state = 0},
  [3534] = {.lex_state = 0},
  [3535] = {.lex_state = 0},
  [3536] = {.lex_state = 0},
  [3537] = {.lex_state = 0},
  [3538] = {.lex_state = 0},
  [3539] = {.lex_state = 0},
  [3540] = {.lex_state = 0},
  [3541] = {.lex_state = 0},
  [3542] = {.lex_state = 0},
  [3543] = {.lex_state = 0},
  [3544] = {.lex_state = 0},
  [3545] = {.lex_state = 0},
  [3546] = {.lex_state = 0},
  [3547] = {.lex_state = 0},
  [3548] = {.lex_state = 0},
  [3549] = {.lex_state = 0},
  [3550] = {.lex_state = 0},
  [3551] = {.lex_state = 0},
  [3552] = {.lex_state = 0},
  [3553] = {.lex_state = 0},
  [3554] = {.lex_state = 0},
  [3555] = {.lex_state = 0},
  [3556] = {.lex_state = 0},
  [3557] = {.lex_state = 0},
  [3558] = {.lex_state = 0},
  [3559] = {.lex_state = 0},
  [3560] = {.lex_state = 0},
  [3561] = {.lex_state = 0},
  [3562] = {.lex_state = 0},
  [3563] = {.lex_state = 0},
  [3564] = {.lex_state = 0},
  [3565] = {.lex_state = 0},
  [3566] = {.lex_state = 0},
  [3567] = {.lex_state = 0},
  [3568] = {.lex_state = 0},
  [3569] = {.lex_state = 0},
  [3570] = {.lex_state = 0},
  [3571] = {.lex_state = 30},
  [3572] = {.lex_state = 0},
  [3573] = {.lex_state = 0},
  [3574] = {.lex_state = 0},
  [3575] = {.lex_state = 0},
  [3576] = {.lex_state = 0},
  [3577] = {.lex_state = 0},
  [3578] = {.lex_state = 0},
  [3579] = {.lex_state = 0},
  [3580] = {.lex_state = 0},
  [3581] = {.lex_state = 0},
  [3582] = {.lex_state = 0},
  [3583] = {.lex_state = 0},
  [3584] = {.lex_state = 0},
  [3585] = {.lex_state = 0},
  [3586] = {.lex_state = 0},
  [3587] = {.lex_state = 0},
  [3588] = {.lex_state = 0},
  [3589] = {.lex_state = 0},
  [3590] = {.lex_state = 0},
  [3591] = {.lex_state = 0},
  [3592] = {.lex_state = 0},
  [3593] = {.lex_state = 0},
  [3594] = {.lex_state = 0},
  [3595] = {.lex_state = 0},
  [3596] = {.lex_state = 0},
  [3597] = {.lex_state = 0},
  [3598] = {.lex_state = 0},
  [3599] = {.lex_state = 0},
  [3600] = {.lex_state = 0},
  [3601] = {.lex_state = 0},
  [3602] = {.lex_state = 0},
  [3603] = {.lex_state = 0},
  [3604] = {.lex_state = 0},
  [3605] = {.lex_state = 0},
  [3606] = {.lex_state = 0},
  [3607] = {.lex_state = 0},
  [3608] = {.lex_state = 0},
  [3609] = {.lex_state = 0},
  [3610] = {.lex_state = 0},
  [3611] = {.lex_state = 0},
  [3612] = {.lex_state = 0},
  [3613] = {.lex_state = 0},
  [3614] = {.lex_state = 0},
  [3615] = {.lex_state = 0},
  [3616] = {.lex_state = 0},
  [3617] = {.lex_state = 0},
  [3618] = {.lex_state = 0},
  [3619] = {.lex_state = 0},
  [3620] = {.lex_state = 0},
  [3621] = {.lex_state = 0},
  [3622] = {.lex_state = 0},
  [3623] = {.lex_state = 0},
  [3624] = {.lex_state = 0},
  [3625] = {.lex_state = 0},
  [3626] = {.lex_state = 0},
  [3627] = {.lex_state = 0},
  [3628] = {.lex_state = 0},
  [3629] = {.lex_state = 0},
  [3630] = {.lex_state = 0},
  [3631] = {.lex_state = 0},
  [3632] = {.lex_state = 0},
  [3633] = {.lex_state = 0},
  [3634] = {.lex_state = 0},
  [3635] = {.lex_state = 0},
  [3636] = {.lex_state = 0},
  [3637] = {.lex_state = 0},
  [3638] = {.lex_state = 0},
  [3639] = {.lex_state = 0},
  [3640] = {.lex_state = 0},
  [3641] = {.lex_state = 0},
  [3642] = {.lex_state = 0},
  [3643] = {.lex_state = 0},
  [3644] = {.lex_state = 0},
  [3645] = {.lex_state = 0},
  [3646] = {.lex_state = 0},
  [3647] = {.lex_state = 0},
  [3648] = {.lex_state = 30},
  [3649] = {.lex_state = 0},
  [3650] = {.lex_state = 0},
  [3651] = {.lex_state = 0},
  [3652] = {.lex_state = 0},
  [3653] = {.lex_state = 0},
  [3654] = {.lex_state = 0},
  [3655] = {.lex_state = 0},
  [3656] = {.lex_state = 0},
  [3657] = {.lex_state = 0},
  [3658] = {.lex_state = 0},
  [3659] = {.lex_state = 0},
  [3660] = {.lex_state = 0},
  [3661] = {.lex_state = 0},
  [3662] = {.lex_state = 0},
  [3663] = {.lex_state = 0},
  [3664] = {.lex_state = 0},
  [3665] = {.lex_state = 0},
  [3666] = {.lex_state = 0},
  [3667] = {.lex_state = 0},
  [3668] = {.lex_state = 0},
  [3669] = {.lex_state = 0},
  [3670] = {.lex_state = 0},
  [3671] = {.lex_state = 0},
  [3672] = {.lex_state = 0},
  [3673] = {.lex_state = 0},
  [3674] = {.lex_state = 0},
  [3675] = {.lex_state = 0},
  [3676] = {.lex_state = 0},
  [3677] = {.lex_state = 0},
  [3678] = {.lex_state = 30},
  [3679] = {.lex_state = 0},
  [3680] = {.lex_state = 0},
  [3681] = {.lex_state = 0},
  [3682] = {.lex_state = 0},
  [3683] = {.lex_state = 0},
  [3684] = {.lex_state = 0},
  [3685] = {.lex_state = 0},
  [3686] = {.lex_state = 0},
  [3687] = {.lex_state = 0},
  [3688] = {.lex_state = 30},
  [3689] = {.lex_state = 0},
  [3690] = {.lex_state = 0},
  [3691] = {.lex_state = 0},
  [3692] = {.lex_state = 0},
  [3693] = {.lex_state = 0},
  [3694] = {.lex_state = 0},
  [3695] = {.lex_state = 0},
  [3696] = {.lex_state = 0},
  [3697] = {.lex_state = 0},
  [3698] = {.lex_state = 0},
  [3699] = {.lex_state = 0},
  [3700] = {.lex_state = 0},
  [3701] = {.lex_state = 0},
  [3702] = {.lex_state = 0},
  [3703] = {.lex_state = 0},
  [3704] = {.lex_state = 0},
  [3705] = {.lex_state = 0},
  [3706] = {.lex_state = 0},
  [3707] = {.lex_state = 0},
  [3708] = {.lex_state = 0},
  [3709] = {.lex_state = 0},
  [3710] = {.lex_state = 0},
  [3711] = {.lex_state = 30},
  [3712] = {.lex_state = 0},
  [3713] = {.lex_state = 0},
  [3714] = {.lex_state = 0},
  [3715] = {.lex_state = 0},
  [3716] = {.lex_state = 0},
  [3717] = {.lex_state = 0},
  [3718] = {.lex_state = 0},
  [3719] = {.lex_state = 0},
  [3720] = {.lex_state = 0},
  [3721] = {.lex_state = 0},
  [3722] = {.lex_state = 0},
  [3723] = {.lex_state = 0},
  [3724] = {.lex_state = 30},
  [3725] = {.lex_state = 0},
  [3726] = {.lex_state = 0},
  [3727] = {.lex_state = 0},
  [3728] = {.lex_state = 0},
  [3729] = {.lex_state = 0},
  [3730] = {.lex_state = 0},
  [3731] = {.lex_state = 0},
  [3732] = {.lex_state = 30},
  [3733] = {.lex_state = 0},
  [3734] = {.lex_state = 0},
  [3735] = {.lex_state = 0},
  [3736] = {.lex_state = 0},
  [3737] = {.lex_state = 0},
  [3738] = {.lex_state = 0},
  [3739] = {.lex_state = 0},
  [3740] = {.lex_state = 0},
  [3741] = {.lex_state = 0},
  [3742] = {.lex_state = 0},
  [3743] = {.lex_state = 0},
  [3744] = {.lex_state = 0},
  [3745] = {.lex_state = 0},
  [3746] = {.lex_state = 0},
  [3747] = {.lex_state = 0},
  [3748] = {.lex_state = 0},
  [3749] = {.lex_state = 0},
  [3750] = {.lex_state = 0},
  [3751] = {.lex_state = 0},
  [3752] = {.lex_state = 0},
  [3753] = {.lex_state = 0},
  [3754] = {.lex_state = 30},
  [3755] = {.lex_state = 0},
  [3756] = {.lex_state = 0},
  [3757] = {.lex_state = 30},
  [3758] = {.lex_state = 30},
  [3759] = {.lex_state = 0},
  [3760] = {.lex_state = 0},
  [3761] = {.lex_state = 0},
  [3762] = {.lex_state = 0},
  [3763] = {.lex_state = 0},
  [3764] = {.lex_state = 0},
  [3765] = {.lex_state = 0},
  [3766] = {.lex_state = 0},
  [3767] = {.lex_state = 30},
  [3768] = {.lex_state = 0},
  [3769] = {.lex_state = 0},
  [3770] = {.lex_state = 0},
  [3771] = {.lex_state = 0},
  [3772] = {.lex_state = 12},
  [3773] = {.lex_state = 0},
  [3774] = {.lex_state = 0},
  [3775] = {.lex_state = 0},
  [3776] = {.lex_state = 0},
  [3777] = {.lex_state = 0},
  [3778] = {.lex_state = 0},
  [3779] = {.lex_state = 0},
  [3780] = {.lex_state = 0},
  [3781] = {.lex_state = 0},
  [3782] = {.lex_state = 0},
  [3783] = {.lex_state = 0},
  [3784] = {.lex_state = 0},
  [3785] = {.lex_state = 0},
  [3786] = {.lex_state = 0},
  [3787] = {.lex_state = 0},
  [3788] = {.lex_state = 0},
  [3789] = {.lex_state = 0},
  [3790] = {.lex_state = 0},
  [3791] = {.lex_state = 0},
  [3792] = {.lex_state = 0},
  [3793] = {.lex_state = 0},
  [3794] = {.lex_state = 0},
  [3795] = {.lex_state = 0},
  [3796] = {.lex_state = 0},
  [3797] = {.lex_state = 0},
  [3798] = {.lex_state = 0},
  [3799] = {.lex_state = 0},
  [3800] = {.lex_state = 0},
  [3801] = {.lex_state = 0},
  [3802] = {.lex_state = 0},
  [3803] = {.lex_state = 0},
  [3804] = {.lex_state = 0},
  [3805] = {.lex_state = 0},
  [3806] = {.lex_state = 0},
  [3807] = {.lex_state = 0},
  [3808] = {.lex_state = 0},
  [3809] = {.lex_state = 0},
  [3810] = {.lex_state = 0},
  [3811] = {.lex_state = 0},
  [3812] = {.lex_state = 0},
  [3813] = {.lex_state = 0},
  [3814] = {.lex_state = 0},
  [3815] = {.lex_state = 0},
  [3816] = {.lex_state = 0},
  [3817] = {.lex_state = 0},
  [3818] = {.lex_state = 0},
  [3819] = {.lex_state = 0},
  [3820] = {.lex_state = 0},
  [3821] = {.lex_state = 0},
  [3822] = {.lex_state = 0},
  [3823] = {.lex_state = 0},
  [3824] = {.lex_state = 0},
  [3825] = {.lex_state = 0},
  [3826] = {.lex_state = 0},
  [3827] = {.lex_state = 0},
  [3828] = {.lex_state = 0},
  [3829] = {.lex_state = 0},
  [3830] = {.lex_state = 0},
  [3831] = {.lex_state = 0},
  [3832] = {.lex_state = 0},
  [3833] = {.lex_state = 0},
  [3834] = {.lex_state = 0},
  [3835] = {.lex_state = 0},
  [3836] = {.lex_state = 0},
  [3837] = {.lex_state = 0},
  [3838] = {.lex_state = 0},
  [3839] = {.lex_state = 0},
  [3840] = {.lex_state = 0},
  [3841] = {.lex_state = 0},
  [3842] = {.lex_state = 0},
  [3843] = {.lex_state = 0},
  [3844] = {.lex_state = 0},
  [3845] = {.lex_state = 0},
  [3846] = {.lex_state = 0},
  [3847] = {.lex_state = 0},
  [3848] = {.lex_state = 0},
  [3849] = {.lex_state = 0},
  [3850] = {.lex_state = 92},
  [3851] = {.lex_state = 87},
  [3852] = {.lex_state = 0},
  [3853] = {.lex_state = 0},
  [3854] = {.lex_state = 0},
  [3855] = {.lex_state = 0},
  [3856] = {.lex_state = 0},
  [3857] = {.lex_state = 0},
  [3858] = {.lex_state = 0},
  [3859] = {.lex_state = 0},
  [3860] = {.lex_state = 0},
  [3861] = {.lex_state = 0},
  [3862] = {.lex_state = 0},
  [3863] = {.lex_state = 0},
  [3864] = {.lex_state = 0},
  [3865] = {.lex_state = 0},
  [3866] = {.lex_state = 0},
  [3867] = {.lex_state = 0},
  [3868] = {.lex_state = 30},
  [3869] = {.lex_state = 0},
  [3870] = {.lex_state = 0},
  [3871] = {.lex_state = 12},
  [3872] = {.lex_state = 30},
  [3873] = {.lex_state = 0},
  [3874] = {.lex_state = 0},
  [3875] = {.lex_state = 0},
  [3876] = {.lex_state = 0},
  [3877] = {.lex_state = 0},
  [3878] = {.lex_state = 0},
  [3879] = {.lex_state = 0},
  [3880] = {.lex_state = 0},
  [3881] = {.lex_state = 0},
  [3882] = {.lex_state = 0},
  [3883] = {.lex_state = 0},
  [3884] = {.lex_state = 0},
  [3885] = {.lex_state = 0},
  [3886] = {.lex_state = 0},
  [3887] = {.lex_state = 0},
  [3888] = {.lex_state = 0},
  [3889] = {.lex_state = 0},
  [3890] = {.lex_state = 0},
  [3891] = {.lex_state = 0},
  [3892] = {.lex_state = 0},
  [3893] = {.lex_state = 0},
  [3894] = {.lex_state = 0},
  [3895] = {.lex_state = 0},
  [3896] = {.lex_state = 0},
  [3897] = {.lex_state = 0},
  [3898] = {.lex_state = 0},
  [3899] = {.lex_state = 0},
  [3900] = {.lex_state = 0},
  [3901] = {.lex_state = 0},
  [3902] = {.lex_state = 0},
  [3903] = {.lex_state = 0},
  [3904] = {.lex_state = 0},
  [3905] = {.lex_state = 0},
  [3906] = {.lex_state = 30},
  [3907] = {.lex_state = 30},
  [3908] = {.lex_state = 30},
  [3909] = {.lex_state = 30},
  [3910] = {.lex_state = 30},
  [3911] = {.lex_state = 30},
  [3912] = {.lex_state = 30},
  [3913] = {.lex_state = 30},
  [3914] = {.lex_state = 0},
  [3915] = {.lex_state = 30},
  [3916] = {.lex_state = 0},
  [3917] = {.lex_state = 0},
  [3918] = {.lex_state = 30},
  [3919] = {.lex_state = 30},
  [3920] = {.lex_state = 30},
  [3921] = {.lex_state = 30},
  [3922] = {.lex_state = 30},
  [3923] = {.lex_state = 30},
  [3924] = {.lex_state = 30},
  [3925] = {.lex_state = 30},
  [3926] = {.lex_state = 0},
  [3927] = {.lex_state = 0},
  [3928] = {.lex_state = 0},
  [3929] = {.lex_state = 0},
  [3930] = {.lex_state = 0},
  [3931] = {.lex_state = 0},
  [3932] = {.lex_state = 0},
  [3933] = {.lex_state = 0},
  [3934] = {.lex_state = 0},
  [3935] = {.lex_state = 0},
  [3936] = {.lex_state = 0},
  [3937] = {.lex_state = 0},
  [3938] = {.lex_state = 0},
  [3939] = {.lex_state = 0},
  [3940] = {.lex_state = 0},
  [3941] = {.lex_state = 0},
  [3942] = {.lex_state = 0},
  [3943] = {.lex_state = 30},
  [3944] = {.lex_state = 0},
  [3945] = {.lex_state = 0},
  [3946] = {.lex_state = 0},
  [3947] = {.lex_state = 0},
  [3948] = {.lex_state = 0},
  [3949] = {.lex_state = 0},
  [3950] = {.lex_state = 30},
  [3951] = {.lex_state = 30},
  [3952] = {.lex_state = 30},
  [3953] = {.lex_state = 30},
  [3954] = {.lex_state = 30},
  [3955] = {.lex_state = 30},
  [3956] = {.lex_state = 30},
  [3957] = {.lex_state = 0},
  [3958] = {.lex_state = 0},
  [3959] = {.lex_state = 12},
  [3960] = {.lex_state = 0},
  [3961] = {.lex_state = 0},
  [3962] = {.lex_state = 0},
  [3963] = {.lex_state = 0},
  [3964] = {.lex_state = 0},
  [3965] = {.lex_state = 0},
  [3966] = {.lex_state = 0},
  [3967] = {.lex_state = 0},
  [3968] = {.lex_state = 0},
  [3969] = {.lex_state = 0},
  [3970] = {.lex_state = 0},
  [3971] = {.lex_state = 0},
  [3972] = {.lex_state = 0},
  [3973] = {.lex_state = 0},
  [3974] = {.lex_state = 0},
  [3975] = {.lex_state = 0},
  [3976] = {.lex_state = 0},
  [3977] = {.lex_state = 0},
  [3978] = {.lex_state = 0},
  [3979] = {.lex_state = 0},
  [3980] = {.lex_state = 30},
  [3981] = {.lex_state = 30},
  [3982] = {.lex_state = 30},
  [3983] = {.lex_state = 30},
  [3984] = {.lex_state = 30},
  [3985] = {.lex_state = 0},
  [3986] = {.lex_state = 0},
  [3987] = {.lex_state = 0},
  [3988] = {.lex_state = 0},
  [3989] = {.lex_state = 0},
  [3990] = {.lex_state = 0},
  [3991] = {.lex_state = 0},
  [3992] = {.lex_state = 0},
  [3993] = {.lex_state = 0},
  [3994] = {.lex_state = 0},
  [3995] = {.lex_state = 0},
  [3996] = {.lex_state = 0},
  [3997] = {.lex_state = 0},
  [3998] = {.lex_state = 0},
  [3999] = {.lex_state = 0},
  [4000] = {.lex_state = 0},
  [4001] = {.lex_state = 0},
  [4002] = {.lex_state = 30},
  [4003] = {.lex_state = 30},
  [4004] = {.lex_state = 30},
  [4005] = {.lex_state = 0},
  [4006] = {.lex_state = 0},
  [4007] = {.lex_state = 0},
  [4008] = {.lex_state = 0},
  [4009] = {.lex_state = 0},
  [4010] = {.lex_state = 0},
  [4011] = {.lex_state = 0},
  [4012] = {.lex_state = 0},
  [4013] = {.lex_state = 0},
  [4014] = {.lex_state = 0},
  [4015] = {.lex_state = 30},
  [4016] = {.lex_state = 0},
  [4017] = {.lex_state = 0},
  [4018] = {.lex_state = 30},
  [4019] = {.lex_state = 0},
  [4020] = {.lex_state = 0},
  [4021] = {.lex_state = 0},
  [4022] = {.lex_state = 0},
  [4023] = {.lex_state = 0},
  [4024] = {.lex_state = 0},
  [4025] = {.lex_state = 0},
  [4026] = {.lex_state = 0},
  [4027] = {.lex_state = 0},
  [4028] = {.lex_state = 0},
  [4029] = {.lex_state = 0},
  [4030] = {.lex_state = 0},
  [4031] = {.lex_state = 30},
  [4032] = {.lex_state = 0},
  [4033] = {.lex_state = 0},
  [4034] = {.lex_state = 0},
  [4035] = {.lex_state = 0},
  [4036] = {.lex_state = 0},
  [4037] = {.lex_state = 0},
  [4038] = {.lex_state = 0},
  [4039] = {.lex_state = 0},
  [4040] = {.lex_state = 0},
  [4041] = {.lex_state = 0},
  [4042] = {.lex_state = 0},
  [4043] = {.lex_state = 0},
  [4044] = {.lex_state = 0},
  [4045] = {.lex_state = 0},
  [4046] = {.lex_state = 0},
  [4047] = {.lex_state = 30},
  [4048] = {.lex_state = 0},
  [4049] = {.lex_state = 0},
  [4050] = {.lex_state = 0},
  [4051] = {.lex_state = 0},
  [4052] = {.lex_state = 0},
  [4053] = {.lex_state = 0},
  [4054] = {.lex_state = 0},
  [4055] = {.lex_state = 0},
  [4056] = {.lex_state = 0},
  [4057] = {.lex_state = 0},
  [4058] = {.lex_state = 92},
  [4059] = {.lex_state = 87},
  [4060] = {.lex_state = 0},
  [4061] = {.lex_state = 0},
  [4062] = {.lex_state = 0},
  [4063] = {.lex_state = 0},
  [4064] = {.lex_state = 0},
  [4065] = {.lex_state = 0},
  [4066] = {.lex_state = 0},
  [4067] = {.lex_state = 30},
  [4068] = {.lex_state = 0},
  [4069] = {.lex_state = 0},
  [4070] = {.lex_state = 0},
  [4071] = {.lex_state = 30},
  [4072] = {.lex_state = 0},
  [4073] = {.lex_state = 30},
  [4074] = {.lex_state = 0},
  [4075] = {.lex_state = 0},
  [4076] = {.lex_state = 0},
  [4077] = {.lex_state = 0},
  [4078] = {.lex_state = 30},
  [4079] = {.lex_state = 30},
  [4080] = {.lex_state = 30},
  [4081] = {.lex_state = 30},
  [4082] = {.lex_state = 30},
  [4083] = {.lex_state = 30},
  [4084] = {.lex_state = 30},
  [4085] = {.lex_state = 30},
  [4086] = {.lex_state = 0},
  [4087] = {.lex_state = 30},
  [4088] = {.lex_state = 0},
  [4089] = {.lex_state = 0},
  [4090] = {.lex_state = 30},
  [4091] = {.lex_state = 30},
  [4092] = {.lex_state = 30},
  [4093] = {.lex_state = 30},
  [4094] = {.lex_state = 30},
  [4095] = {.lex_state = 30},
  [4096] = {.lex_state = 30},
  [4097] = {.lex_state = 30},
  [4098] = {.lex_state = 0},
  [4099] = {.lex_state = 0},
  [4100] = {.lex_state = 0},
  [4101] = {.lex_state = 0},
  [4102] = {.lex_state = 0},
  [4103] = {.lex_state = 0},
  [4104] = {.lex_state = 0},
  [4105] = {.lex_state = 0},
  [4106] = {.lex_state = 0},
  [4107] = {.lex_state = 30},
  [4108] = {.lex_state = 30},
  [4109] = {.lex_state = 30},
  [4110] = {.lex_state = 30},
  [4111] = {.lex_state = 30},
  [4112] = {.lex_state = 30},
  [4113] = {.lex_state = 0},
  [4114] = {.lex_state = 0},
  [4115] = {.lex_state = 30},
  [4116] = {.lex_state = 0},
  [4117] = {.lex_state = 0},
  [4118] = {.lex_state = 0},
  [4119] = {.lex_state = 0},
  [4120] = {.lex_state = 30},
  [4121] = {.lex_state = 30},
  [4122] = {.lex_state = 30},
  [4123] = {.lex_state = 30},
  [4124] = {.lex_state = 0},
  [4125] = {.lex_state = 0},
  [4126] = {.lex_state = 0},
  [4127] = {.lex_state = 30},
  [4128] = {.lex_state = 30},
  [4129] = {.lex_state = 30},
  [4130] = {.lex_state = 0},
  [4131] = {.lex_state = 30},
  [4132] = {.lex_state = 30},
  [4133] = {.lex_state = 0},
  [4134] = {.lex_state = 92},
  [4135] = {.lex_state = 87},
  [4136] = {.lex_state = 0},
  [4137] = {.lex_state = 0},
  [4138] = {.lex_state = 30},
  [4139] = {.lex_state = 0},
  [4140] = {.lex_state = 0},
  [4141] = {.lex_state = 0},
  [4142] = {.lex_state = 0},
  [4143] = {.lex_state = 0},
  [4144] = {.lex_state = 0},
  [4145] = {.lex_state = 0},
  [4146] = {.lex_state = 0},
  [4147] = {.lex_state = 30},
  [4148] = {.lex_state = 30},
  [4149] = {.lex_state = 30},
  [4150] = {.lex_state = 30},
  [4151] = {.lex_state = 30},
  [4152] = {.lex_state = 30},
  [4153] = {.lex_state = 30},
  [4154] = {.lex_state = 30},
  [4155] = {.lex_state = 0},
  [4156] = {.lex_state = 30},
  [4157] = {.lex_state = 0},
  [4158] = {.lex_state = 0},
  [4159] = {.lex_state = 30},
  [4160] = {.lex_state = 30},
  [4161] = {.lex_state = 30},
  [4162] = {.lex_state = 30},
  [4163] = {.lex_state = 30},
  [4164] = {.lex_state = 30},
  [4165] = {.lex_state = 30},
  [4166] = {.lex_state = 30},
  [4167] = {.lex_state = 0},
  [4168] = {.lex_state = 0},
  [4169] = {.lex_state = 0},
  [4170] = {.lex_state = 0},
  [4171] = {.lex_state = 0},
  [4172] = {.lex_state = 30},
  [4173] = {.lex_state = 30},
  [4174] = {.lex_state = 30},
  [4175] = {.lex_state = 30},
  [4176] = {.lex_state = 30},
  [4177] = {.lex_state = 30},
  [4178] = {.lex_state = 0},
  [4179] = {.lex_state = 30},
  [4180] = {.lex_state = 0},
  [4181] = {.lex_state = 30},
  [4182] = {.lex_state = 30},
  [4183] = {.lex_state = 30},
  [4184] = {.lex_state = 30},
  [4185] = {.lex_state = 30},
  [4186] = {.lex_state = 30},
  [4187] = {.lex_state = 30},
  [4188] = {.lex_state = 30},
  [4189] = {.lex_state = 30},
  [4190] = {.lex_state = 30},
  [4191] = {.lex_state = 0},
  [4192] = {.lex_state = 30},
  [4193] = {.lex_state = 92},
  [4194] = {.lex_state = 87},
  [4195] = {.lex_state = 0},
  [4196] = {.lex_state = 0},
  [4197] = {.lex_state = 0},
  [4198] = {.lex_state = 0},
  [4199] = {.lex_state = 0},
  [4200] = {.lex_state = 0},
  [4201] = {.lex_state = 0},
  [4202] = {.lex_state = 0},
  [4203] = {.lex_state = 30},
  [4204] = {.lex_state = 0},
  [4205] = {.lex_state = 0},
  [4206] = {.lex_state = 0},
  [4207] = {.lex_state = 0},
  [4208] = {.lex_state = 0},
  [4209] = {.lex_state = 0},
  [4210] = {.lex_state = 0},
  [4211] = {.lex_state = 0},
  [4212] = {.lex_state = 0},
  [4213] = {.lex_state = 0},
  [4214] = {.lex_state = 0},
  [4215] = {.lex_state = 0},
  [4216] = {.lex_state = 0},
  [4217] = {.lex_state = 0},
  [4218] = {.lex_state = 0},
  [4219] = {.lex_state = 0},
  [4220] = {.lex_state = 0},
  [4221] = {.lex_state = 0},
  [4222] = {.lex_state = 0},
  [4223] = {.lex_state = 0},
  [4224] = {.lex_state = 30},
  [4225] = {.lex_state = 0},
  [4226] = {.lex_state = 0},
  [4227] = {.lex_state = 0},
  [4228] = {.lex_state = 0},
  [4229] = {.lex_state = 0},
  [4230] = {.lex_state = 0},
  [4231] = {.lex_state = 0},
  [4232] = {.lex_state = 0},
  [4233] = {.lex_state = 0},
  [4234] = {.lex_state = 0},
  [4235] = {.lex_state = 0},
  [4236] = {.lex_state = 0},
  [4237] = {.lex_state = 0},
  [4238] = {.lex_state = 0},
  [4239] = {.lex_state = 0},
  [4240] = {.lex_state = 0},
  [4241] = {.lex_state = 0},
  [4242] = {.lex_state = 0},
  [4243] = {.lex_state = 0},
  [4244] = {.lex_state = 0},
  [4245] = {.lex_state = 0},
  [4246] = {.lex_state = 0},
  [4247] = {.lex_state = 0},
  [4248] = {.lex_state = 0},
  [4249] = {.lex_state = 0},
  [4250] = {.lex_state = 0},
  [4251] = {.lex_state = 0},
  [4252] = {.lex_state = 0},
  [4253] = {.lex_state = 0},
  [4254] = {.lex_state = 0},
  [4255] = {.lex_state = 0},
  [4256] = {.lex_state = 0},
  [4257] = {.lex_state = 0},
  [4258] = {.lex_state = 0},
  [4259] = {.lex_state = 0},
  [4260] = {.lex_state = 0},
  [4261] = {.lex_state = 0},
  [4262] = {.lex_state = 30},
  [4263] = {.lex_state = 0},
  [4264] = {.lex_state = 0},
  [4265] = {.lex_state = 0},
  [4266] = {.lex_state = 0},
  [4267] = {.lex_state = 30},
  [4268] = {.lex_state = 30},
  [4269] = {.lex_state = 30},
  [4270] = {.lex_state = 30},
  [4271] = {.lex_state = 30},
  [4272] = {.lex_state = 30},
  [4273] = {.lex_state = 30},
  [4274] = {.lex_state = 0},
  [4275] = {.lex_state = 0},
  [4276] = {.lex_state = 0},
  [4277] = {.lex_state = 0},
  [4278] = {.lex_state = 0},
  [4279] = {.lex_state = 30},
  [4280] = {.lex_state = 0},
  [4281] = {.lex_state = 0},
  [4282] = {.lex_state = 0},
  [4283] = {.lex_state = 0},
  [4284] = {.lex_state = 0},
  [4285] = {.lex_state = 0},
  [4286] = {.lex_state = 0},
  [4287] = {.lex_state = 0},
  [4288] = {.lex_state = 0},
  [4289] = {.lex_state = 0},
  [4290] = {.lex_state = 0},
  [4291] = {.lex_state = 0},
  [4292] = {.lex_state = 0},
  [4293] = {.lex_state = 0},
  [4294] = {.lex_state = 30},
  [4295] = {.lex_state = 0},
  [4296] = {.lex_state = 0},
  [4297] = {.lex_state = 0},
  [4298] = {.lex_state = 30},
  [4299] = {.lex_state = 0},
  [4300] = {.lex_state = 0},
  [4301] = {.lex_state = 0},
  [4302] = {.lex_state = 0},
  [4303] = {.lex_state = 0},
  [4304] = {.lex_state = 0},
  [4305] = {.lex_state = 0},
  [4306] = {.lex_state = 0},
  [4307] = {.lex_state = 0},
  [4308] = {.lex_state = 0},
  [4309] = {.lex_state = 30},
  [4310] = {.lex_state = 0},
  [4311] = {.lex_state = 0},
  [4312] = {.lex_state = 0},
  [4313] = {.lex_state = 0},
  [4314] = {.lex_state = 0},
  [4315] = {.lex_state = 0},
  [4316] = {.lex_state = 0},
  [4317] = {.lex_state = 0},
  [4318] = {.lex_state = 0},
  [4319] = {.lex_state = 0},
  [4320] = {.lex_state = 0},
  [4321] = {.lex_state = 0},
  [4322] = {.lex_state = 0},
  [4323] = {.lex_state = 30},
  [4324] = {.lex_state = 30},
  [4325] = {.lex_state = 30},
  [4326] = {.lex_state = 30},
  [4327] = {.lex_state = 30},
  [4328] = {.lex_state = 30},
  [4329] = {.lex_state = 30},
  [4330] = {.lex_state = 30},
  [4331] = {.lex_state = 0},
  [4332] = {.lex_state = 0},
  [4333] = {.lex_state = 30},
  [4334] = {.lex_state = 30},
  [4335] = {.lex_state = 30},
  [4336] = {.lex_state = 30},
  [4337] = {.lex_state = 30},
  [4338] = {.lex_state = 30},
  [4339] = {.lex_state = 30},
  [4340] = {.lex_state = 30},
  [4341] = {.lex_state = 0},
  [4342] = {.lex_state = 30},
  [4343] = {.lex_state = 0},
  [4344] = {.lex_state = 0},
  [4345] = {.lex_state = 0},
  [4346] = {.lex_state = 0},
  [4347] = {.lex_state = 0},
  [4348] = {.lex_state = 0},
  [4349] = {.lex_state = 0},
  [4350] = {.lex_state = 0},
  [4351] = {.lex_state = 0},
  [4352] = {.lex_state = 0},
  [4353] = {.lex_state = 0},
  [4354] = {.lex_state = 0},
  [4355] = {.lex_state = 0},
  [4356] = {.lex_state = 0},
  [4357] = {.lex_state = 0},
  [4358] = {.lex_state = 0},
  [4359] = {.lex_state = 0},
  [4360] = {.lex_state = 0},
  [4361] = {.lex_state = 0},
  [4362] = {.lex_state = 0},
  [4363] = {.lex_state = 0},
  [4364] = {.lex_state = 0},
  [4365] = {.lex_state = 0},
  [4366] = {.lex_state = 0},
  [4367] = {.lex_state = 0},
  [4368] = {.lex_state = 0},
  [4369] = {.lex_state = 0},
  [4370] = {.lex_state = 0},
  [4371] = {.lex_state = 0},
  [4372] = {.lex_state = 0},
  [4373] = {.lex_state = 0},
  [4374] = {.lex_state = 0},
  [4375] = {.lex_state = 0},
  [4376] = {.lex_state = 0},
  [4377] = {.lex_state = 0},
  [4378] = {.lex_state = 0},
  [4379] = {.lex_state = 0},
  [4380] = {.lex_state = 30},
  [4381] = {.lex_state = 0},
  [4382] = {.lex_state = 0},
  [4383] = {.lex_state = 0},
  [4384] = {.lex_state = 0},
  [4385] = {.lex_state = 0},
  [4386] = {.lex_state = 0},
  [4387] = {.lex_state = 0},
  [4388] = {.lex_state = 0},
  [4389] = {.lex_state = 0},
  [4390] = {.lex_state = 0},
  [4391] = {.lex_state = 0},
  [4392] = {.lex_state = 0},
  [4393] = {.lex_state = 0},
  [4394] = {.lex_state = 0},
  [4395] = {.lex_state = 0},
  [4396] = {.lex_state = 0},
  [4397] = {.lex_state = 0},
  [4398] = {.lex_state = 0},
  [4399] = {.lex_state = 0},
  [4400] = {.lex_state = 0},
  [4401] = {.lex_state = 0},
  [4402] = {.lex_state = 0},
  [4403] = {.lex_state = 0},
  [4404] = {.lex_state = 0},
  [4405] = {.lex_state = 0},
  [4406] = {.lex_state = 0},
  [4407] = {.lex_state = 0},
  [4408] = {.lex_state = 0},
  [4409] = {.lex_state = 0},
  [4410] = {.lex_state = 0},
  [4411] = {.lex_state = 0},
  [4412] = {.lex_state = 0},
  [4413] = {.lex_state = 0},
  [4414] = {.lex_state = 30},
  [4415] = {.lex_state = 0},
  [4416] = {.lex_state = 0},
  [4417] = {.lex_state = 0},
  [4418] = {.lex_state = 0},
  [4419] = {.lex_state = 0},
  [4420] = {.lex_state = 30},
  [4421] = {.lex_state = 30},
  [4422] = {.lex_state = 30},
  [4423] = {.lex_state = 0},
  [4424] = {.lex_state = 0},
  [4425] = {.lex_state = 0},
  [4426] = {.lex_state = 0},
  [4427] = {.lex_state = 30},
  [4428] = {.lex_state = 0},
  [4429] = {.lex_state = 0},
  [4430] = {.lex_state = 0},
  [4431] = {.lex_state = 0},
  [4432] = {.lex_state = 0},
  [4433] = {.lex_state = 0},
  [4434] = {.lex_state = 0},
  [4435] = {.lex_state = 0},
  [4436] = {.lex_state = 0},
  [4437] = {.lex_state = 0},
  [4438] = {.lex_state = 0},
  [4439] = {.lex_state = 0},
  [4440] = {.lex_state = 0},
  [4441] = {.lex_state = 0},
  [4442] = {.lex_state = 0},
  [4443] = {.lex_state = 0},
  [4444] = {.lex_state = 0},
  [4445] = {.lex_state = 0},
  [4446] = {.lex_state = 0},
  [4447] = {.lex_state = 0},
  [4448] = {.lex_state = 0},
  [4449] = {.lex_state = 0},
  [4450] = {.lex_state = 0},
  [4451] = {.lex_state = 0},
  [4452] = {.lex_state = 0},
  [4453] = {.lex_state = 0},
  [4454] = {.lex_state = 30},
  [4455] = {.lex_state = 30},
  [4456] = {.lex_state = 30},
  [4457] = {.lex_state = 30},
  [4458] = {.lex_state = 30},
  [4459] = {.lex_state = 0},
  [4460] = {.lex_state = 0},
  [4461] = {.lex_state = 0},
  [4462] = {.lex_state = 30},
  [4463] = {.lex_state = 30},
  [4464] = {.lex_state = 30},
  [4465] = {.lex_state = 30},
  [4466] = {.lex_state = 30},
  [4467] = {.lex_state = 0},
  [4468] = {.lex_state = 0},
  [4469] = {.lex_state = 0},
  [4470] = {.lex_state = 0},
  [4471] = {.lex_state = 0},
  [4472] = {.lex_state = 0},
  [4473] = {.lex_state = 0},
  [4474] = {.lex_state = 0},
  [4475] = {.lex_state = 0},
  [4476] = {.lex_state = 0},
  [4477] = {.lex_state = 0},
  [4478] = {.lex_state = 0},
  [4479] = {.lex_state = 0},
  [4480] = {.lex_state = 0},
  [4481] = {.lex_state = 0},
  [4482] = {.lex_state = 0},
  [4483] = {.lex_state = 0},
  [4484] = {.lex_state = 0},
  [4485] = {.lex_state = 0},
  [4486] = {.lex_state = 0},
  [4487] = {.lex_state = 0},
  [4488] = {.lex_state = 0},
  [4489] = {.lex_state = 0},
  [4490] = {.lex_state = 0},
  [4491] = {.lex_state = 0},
  [4492] = {.lex_state = 0},
  [4493] = {.lex_state = 0},
  [4494] = {.lex_state = 0},
  [4495] = {.lex_state = 0},
  [4496] = {.lex_state = 0},
  [4497] = {.lex_state = 30},
  [4498] = {.lex_state = 0},
  [4499] = {.lex_state = 0},
  [4500] = {.lex_state = 0},
  [4501] = {.lex_state = 0},
  [4502] = {.lex_state = 0},
  [4503] = {.lex_state = 0},
  [4504] = {.lex_state = 0},
  [4505] = {.lex_state = 0},
  [4506] = {.lex_state = 0},
  [4507] = {.lex_state = 0},
  [4508] = {.lex_state = 0},
  [4509] = {.lex_state = 0},
  [4510] = {.lex_state = 46},
  [4511] = {.lex_state = 0},
  [4512] = {.lex_state = 0},
  [4513] = {.lex_state = 0},
  [4514] = {.lex_state = 0},
  [4515] = {.lex_state = 0},
  [4516] = {.lex_state = 0},
  [4517] = {.lex_state = 0},
  [4518] = {.lex_state = 0},
  [4519] = {.lex_state = 87},
  [4520] = {.lex_state = 92},
  [4521] = {.lex_state = 12},
  [4522] = {.lex_state = 30},
  [4523] = {.lex_state = 0},
  [4524] = {.lex_state = 0},
  [4525] = {.lex_state = 0},
  [4526] = {.lex_state = 0},
  [4527] = {.lex_state = 0},
  [4528] = {.lex_state = 0},
  [4529] = {.lex_state = 0},
  [4530] = {.lex_state = 0},
  [4531] = {.lex_state = 0},
  [4532] = {.lex_state = 7},
  [4533] = {.lex_state = 0},
  [4534] = {(TSStateId)(-1)},
  [4535] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [sym_marginalia] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [sym_keyword_select] = ACTIONS(1),
    [sym_keyword_delete] = ACTIONS(1),
    [sym_keyword_insert] = ACTIONS(1),
    [sym_keyword_replace] = ACTIONS(1),
    [sym_keyword_update] = ACTIONS(1),
    [sym_keyword_truncate] = ACTIONS(1),
    [sym_keyword_merge] = ACTIONS(1),
    [sym_keyword_into] = ACTIONS(1),
    [sym_keyword_overwrite] = ACTIONS(1),
    [sym_keyword_values] = ACTIONS(1),
    [sym_keyword_value] = ACTIONS(1),
    [sym_keyword_matched] = ACTIONS(1),
    [sym_keyword_set] = ACTIONS(1),
    [sym_keyword_from] = ACTIONS(1),
    [sym_keyword_left] = ACTIONS(1),
    [sym_keyword_right] = ACTIONS(1),
    [sym_keyword_inner] = ACTIONS(1),
    [sym_keyword_full] = ACTIONS(1),
    [sym_keyword_outer] = ACTIONS(1),
    [sym_keyword_cross] = ACTIONS(1),
    [sym_keyword_join] = ACTIONS(1),
    [sym_keyword_lateral] = ACTIONS(1),
    [sym_keyword_natural] = ACTIONS(1),
    [sym_keyword_on] = ACTIONS(1),
    [sym_keyword_where] = ACTIONS(1),
    [sym_keyword_order] = ACTIONS(1),
    [sym_keyword_group] = ACTIONS(1),
    [sym_keyword_partition] = ACTIONS(1),
    [sym_keyword_by] = ACTIONS(1),
    [sym_keyword_having] = ACTIONS(1),
    [sym_keyword_desc] = ACTIONS(1),
    [sym_keyword_asc] = ACTIONS(1),
    [sym_keyword_limit] = ACTIONS(1),
    [sym_keyword_offset] = ACTIONS(1),
    [sym_keyword_primary] = ACTIONS(1),
    [sym_keyword_create] = ACTIONS(1),
    [sym_keyword_alter] = ACTIONS(1),
    [sym_keyword_change] = ACTIONS(1),
    [sym_keyword_analyze] = ACTIONS(1),
    [sym_keyword_explain] = ACTIONS(1),
    [sym_keyword_verbose] = ACTIONS(1),
    [sym_keyword_modify] = ACTIONS(1),
    [sym_keyword_drop] = ACTIONS(1),
    [sym_keyword_add] = ACTIONS(1),
    [sym_keyword_table] = ACTIONS(1),
    [sym_keyword_tables] = ACTIONS(1),
    [sym_keyword_view] = ACTIONS(1),
    [sym_keyword_column] = ACTIONS(1),
    [sym_keyword_columns] = ACTIONS(1),
    [sym_keyword_materialized] = ACTIONS(1),
    [sym_keyword_tablespace] = ACTIONS(1),
    [sym_keyword_sequence] = ACTIONS(1),
    [sym_keyword_increment] = ACTIONS(1),
    [sym_keyword_minvalue] = ACTIONS(1),
    [sym_keyword_maxvalue] = ACTIONS(1),
    [sym_keyword_none] = ACTIONS(1),
    [sym_keyword_owned] = ACTIONS(1),
    [sym_keyword_start] = ACTIONS(1),
    [sym_keyword_restart] = ACTIONS(1),
    [sym_keyword_key] = ACTIONS(1),
    [sym_keyword_as] = ACTIONS(1),
    [sym_keyword_distinct] = ACTIONS(1),
    [sym_keyword_constraint] = ACTIONS(1),
    [sym_keyword_filter] = ACTIONS(1),
    [sym_keyword_cast] = ACTIONS(1),
    [sym_keyword_separator] = ACTIONS(1),
    [sym_keyword_max] = ACTIONS(1),
    [sym_keyword_min] = ACTIONS(1),
    [sym_keyword_avg] = ACTIONS(1),
    [sym_keyword_case] = ACTIONS(1),
    [sym_keyword_when] = ACTIONS(1),
    [sym_keyword_then] = ACTIONS(1),
    [sym_keyword_else] = ACTIONS(1),
    [sym_keyword_end] = ACTIONS(1),
    [sym_keyword_in] = ACTIONS(1),
    [sym_keyword_and] = ACTIONS(1),
    [sym_keyword_or] = ACTIONS(1),
    [sym_keyword_is] = ACTIONS(1),
    [sym_keyword_not] = ACTIONS(1),
    [sym_keyword_force] = ACTIONS(1),
    [sym_keyword_ignore] = ACTIONS(1),
    [sym_keyword_using] = ACTIONS(1),
    [sym_keyword_use] = ACTIONS(1),
    [sym_keyword_index] = ACTIONS(1),
    [sym_keyword_for] = ACTIONS(1),
    [sym_keyword_if] = ACTIONS(1),
    [sym_keyword_exists] = ACTIONS(1),
    [sym_keyword_auto_increment] = ACTIONS(1),
    [sym_keyword_generated] = ACTIONS(1),
    [sym_keyword_always] = ACTIONS(1),
    [sym_keyword_collate] = ACTIONS(1),
    [aux_sym_keyword_character_token1] = ACTIONS(1),
    [sym_keyword_engine] = ACTIONS(1),
    [sym_keyword_default] = ACTIONS(1),
    [sym_keyword_cascade] = ACTIONS(1),
    [sym_keyword_restrict] = ACTIONS(1),
    [aux_sym_keyword_with_token1] = ACTIONS(1),
    [sym_keyword_no] = ACTIONS(1),
    [sym_keyword_data] = ACTIONS(1),
    [sym_keyword_type] = ACTIONS(1),
    [sym_keyword_rename] = ACTIONS(1),
    [sym_keyword_to] = ACTIONS(1),
    [sym_keyword_database] = ACTIONS(1),
    [sym_keyword_schema] = ACTIONS(1),
    [sym_keyword_owner] = ACTIONS(1),
    [sym_keyword_user] = ACTIONS(1),
    [sym_keyword_admin] = ACTIONS(1),
    [sym_keyword_password] = ACTIONS(1),
    [sym_keyword_encrypted] = ACTIONS(1),
    [sym_keyword_valid] = ACTIONS(1),
    [sym_keyword_until] = ACTIONS(1),
    [sym_keyword_connection] = ACTIONS(1),
    [sym_keyword_role] = ACTIONS(1),
    [sym_keyword_reset] = ACTIONS(1),
    [sym_keyword_temp] = ACTIONS(1),
    [sym_keyword_temporary] = ACTIONS(1),
    [sym_keyword_unlogged] = ACTIONS(1),
    [sym_keyword_logged] = ACTIONS(1),
    [sym_keyword_cycle] = ACTIONS(1),
    [sym_keyword_union] = ACTIONS(1),
    [sym_keyword_all] = ACTIONS(1),
    [sym_keyword_any] = ACTIONS(1),
    [sym_keyword_some] = ACTIONS(1),
    [sym_keyword_except] = ACTIONS(1),
    [sym_keyword_intersect] = ACTIONS(1),
    [sym_keyword_returning] = ACTIONS(1),
    [sym_keyword_begin] = ACTIONS(1),
    [sym_keyword_commit] = ACTIONS(1),
    [sym_keyword_rollback] = ACTIONS(1),
    [sym_keyword_transaction] = ACTIONS(1),
    [sym_keyword_over] = ACTIONS(1),
    [sym_keyword_nulls] = ACTIONS(1),
    [sym_keyword_first] = ACTIONS(1),
    [sym_keyword_after] = ACTIONS(1),
    [sym_keyword_before] = ACTIONS(1),
    [sym_keyword_last] = ACTIONS(1),
    [sym_keyword_window] = ACTIONS(1),
    [sym_keyword_range] = ACTIONS(1),
    [sym_keyword_rows] = ACTIONS(1),
    [sym_keyword_groups] = ACTIONS(1),
    [sym_keyword_between] = ACTIONS(1),
    [sym_keyword_unbounded] = ACTIONS(1),
    [sym_keyword_preceding] = ACTIONS(1),
    [sym_keyword_following] = ACTIONS(1),
    [sym_keyword_exclude] = ACTIONS(1),
    [sym_keyword_current] = ACTIONS(1),
    [sym_keyword_row] = ACTIONS(1),
    [sym_keyword_ties] = ACTIONS(1),
    [sym_keyword_others] = ACTIONS(1),
    [sym_keyword_only] = ACTIONS(1),
    [sym_keyword_unique] = ACTIONS(1),
    [sym_keyword_foreign] = ACTIONS(1),
    [sym_keyword_references] = ACTIONS(1),
    [sym_keyword_concurrently] = ACTIONS(1),
    [sym_keyword_btree] = ACTIONS(1),
    [sym_keyword_hash] = ACTIONS(1),
    [sym_keyword_gist] = ACTIONS(1),
    [sym_keyword_spgist] = ACTIONS(1),
    [sym_keyword_gin] = ACTIONS(1),
    [sym_keyword_brin] = ACTIONS(1),
    [aux_sym_keyword_like_token1] = ACTIONS(1),
    [aux_sym_keyword_like_token2] = ACTIONS(1),
    [sym_keyword_similar] = ACTIONS(1),
    [sym_keyword_preserve] = ACTIONS(1),
    [sym_keyword_unsigned] = ACTIONS(1),
    [sym_keyword_zerofill] = ACTIONS(1),
    [sym_keyword_conflict] = ACTIONS(1),
    [sym_keyword_do] = ACTIONS(1),
    [sym_keyword_nothing] = ACTIONS(1),
    [sym_keyword_high_priority] = ACTIONS(1),
    [sym_keyword_low_priority] = ACTIONS(1),
    [sym_keyword_delayed] = ACTIONS(1),
    [sym_keyword_recursive] = ACTIONS(1),
    [sym_keyword_cascaded] = ACTIONS(1),
    [sym_keyword_local] = ACTIONS(1),
    [sym_keyword_current_timestamp] = ACTIONS(1),
    [sym_keyword_check] = ACTIONS(1),
    [sym_keyword_option] = ACTIONS(1),
    [sym_keyword_vacuum] = ACTIONS(1),
    [sym_keyword_wait] = ACTIONS(1),
    [sym_keyword_nowait] = ACTIONS(1),
    [sym_keyword_attribute] = ACTIONS(1),
    [sym_keyword_authorization] = ACTIONS(1),
    [sym_keyword_action] = ACTIONS(1),
    [sym_keyword_trigger] = ACTIONS(1),
    [sym_keyword_function] = ACTIONS(1),
    [sym_keyword_returns] = ACTIONS(1),
    [sym_keyword_return] = ACTIONS(1),
    [sym_keyword_setof] = ACTIONS(1),
    [sym_keyword_atomic] = ACTIONS(1),
    [sym_keyword_declare] = ACTIONS(1),
    [sym_keyword_language] = ACTIONS(1),
    [sym_keyword_sql] = ACTIONS(1),
    [sym_keyword_plpgsql] = ACTIONS(1),
    [sym_keyword_immutable] = ACTIONS(1),
    [sym_keyword_stable] = ACTIONS(1),
    [sym_keyword_volatile] = ACTIONS(1),
    [sym_keyword_leakproof] = ACTIONS(1),
    [sym_keyword_parallel] = ACTIONS(1),
    [sym_keyword_safe] = ACTIONS(1),
    [sym_keyword_unsafe] = ACTIONS(1),
    [sym_keyword_restricted] = ACTIONS(1),
    [sym_keyword_called] = ACTIONS(1),
    [sym_keyword_input] = ACTIONS(1),
    [sym_keyword_strict] = ACTIONS(1),
    [sym_keyword_cost] = ACTIONS(1),
    [sym_keyword_support] = ACTIONS(1),
    [sym_keyword_external] = ACTIONS(1),
    [sym_keyword_stored] = ACTIONS(1),
    [sym_keyword_virtual] = ACTIONS(1),
    [sym_keyword_cached] = ACTIONS(1),
    [sym_keyword_uncached] = ACTIONS(1),
    [sym_keyword_replication] = ACTIONS(1),
    [sym_keyword_tblproperties] = ACTIONS(1),
    [sym_keyword_options] = ACTIONS(1),
    [sym_keyword_compute] = ACTIONS(1),
    [sym_keyword_stats] = ACTIONS(1),
    [sym_keyword_statistics] = ACTIONS(1),
    [sym_keyword_optimize] = ACTIONS(1),
    [sym_keyword_rewrite] = ACTIONS(1),
    [sym_keyword_bin_pack] = ACTIONS(1),
    [sym_keyword_incremental] = ACTIONS(1),
    [sym_keyword_location] = ACTIONS(1),
    [sym_keyword_partitioned] = ACTIONS(1),
    [sym_keyword_comment] = ACTIONS(1),
    [sym_keyword_sort] = ACTIONS(1),
    [sym_keyword_format] = ACTIONS(1),
    [sym_keyword_delimited] = ACTIONS(1),
    [sym_keyword_fields] = ACTIONS(1),
    [sym_keyword_terminated] = ACTIONS(1),
    [sym_keyword_escaped] = ACTIONS(1),
    [sym_keyword_lines] = ACTIONS(1),
    [sym_keyword_cache] = ACTIONS(1),
    [sym_keyword_metadata] = ACTIONS(1),
    [sym_keyword_noscan] = ACTIONS(1),
    [sym_keyword_parquet] = ACTIONS(1),
    [sym_keyword_rcfile] = ACTIONS(1),
    [sym_keyword_csv] = ACTIONS(1),
    [sym_keyword_textfile] = ACTIONS(1),
    [sym_keyword_avro] = ACTIONS(1),
    [sym_keyword_sequencefile] = ACTIONS(1),
    [sym_keyword_orc] = ACTIONS(1),
    [sym_keyword_jsonfile] = ACTIONS(1),
    [sym_keyword_null] = ACTIONS(1),
    [sym_keyword_true] = ACTIONS(1),
    [sym_keyword_false] = ACTIONS(1),
    [sym_keyword_boolean] = ACTIONS(1),
    [sym_keyword_bit] = ACTIONS(1),
    [sym_keyword_binary] = ACTIONS(1),
    [sym_keyword_varbinary] = ACTIONS(1),
    [sym_keyword_image] = ACTIONS(1),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(1),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(1),
    [aux_sym_keyword_serial_token1] = ACTIONS(1),
    [aux_sym_keyword_serial_token2] = ACTIONS(1),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(1),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(1),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(1),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(1),
    [aux_sym_keyword_smallint_token1] = ACTIONS(1),
    [aux_sym_keyword_smallint_token2] = ACTIONS(1),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(1),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(1),
    [aux_sym_keyword_int_token1] = ACTIONS(1),
    [aux_sym_keyword_int_token2] = ACTIONS(1),
    [aux_sym_keyword_int_token3] = ACTIONS(1),
    [aux_sym_keyword_bigint_token1] = ACTIONS(1),
    [aux_sym_keyword_bigint_token2] = ACTIONS(1),
    [sym_keyword_decimal] = ACTIONS(1),
    [sym_keyword_numeric] = ACTIONS(1),
    [aux_sym_keyword_real_token1] = ACTIONS(1),
    [aux_sym_keyword_real_token2] = ACTIONS(1),
    [sym_keyword_float] = ACTIONS(1),
    [sym_keyword_double] = ACTIONS(1),
    [sym_keyword_precision] = ACTIONS(1),
    [sym_keyword_inet] = ACTIONS(1),
    [sym_keyword_money] = ACTIONS(1),
    [sym_keyword_smallmoney] = ACTIONS(1),
    [sym_keyword_varying] = ACTIONS(1),
    [aux_sym_keyword_char_token1] = ACTIONS(1),
    [sym_keyword_nchar] = ACTIONS(1),
    [aux_sym_keyword_varchar_token1] = ACTIONS(1),
    [sym_keyword_nvarchar] = ACTIONS(1),
    [sym_keyword_text] = ACTIONS(1),
    [sym_keyword_string] = ACTIONS(1),
    [sym_keyword_uuid] = ACTIONS(1),
    [sym_keyword_json] = ACTIONS(1),
    [sym_keyword_jsonb] = ACTIONS(1),
    [sym_keyword_xml] = ACTIONS(1),
    [sym_keyword_bytea] = ACTIONS(1),
    [sym_keyword_enum] = ACTIONS(1),
    [sym_keyword_date] = ACTIONS(1),
    [sym_keyword_datetime] = ACTIONS(1),
    [sym_keyword_datetime2] = ACTIONS(1),
    [sym_keyword_smalldatetime] = ACTIONS(1),
    [sym_keyword_datetimeoffset] = ACTIONS(1),
    [aux_sym_keyword_time_token1] = ACTIONS(1),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(1),
    [aux_sym_keyword_timestamp_token2] = ACTIONS(1),
    [aux_sym_keyword_timestamp_token3] = ACTIONS(1),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(1),
    [sym_keyword_interval] = ACTIONS(1),
    [sym_keyword_geometry] = ACTIONS(1),
    [sym_keyword_geography] = ACTIONS(1),
    [sym_keyword_box2d] = ACTIONS(1),
    [sym_keyword_box3d] = ACTIONS(1),
    [sym_keyword_oid] = ACTIONS(1),
    [sym_keyword_name] = ACTIONS(1),
    [sym_keyword_regclass] = ACTIONS(1),
    [sym_keyword_regnamespace] = ACTIONS(1),
    [sym_keyword_regproc] = ACTIONS(1),
    [sym_keyword_regtype] = ACTIONS(1),
    [sym_keyword_array] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [aux_sym_double_token1] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(1),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(1),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [aux_sym_parameter_token1] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_millennium] = ACTIONS(1),
    [anon_sym_century] = ACTIONS(1),
    [anon_sym_decade] = ACTIONS(1),
    [anon_sym_year] = ACTIONS(1),
    [anon_sym_month] = ACTIONS(1),
    [anon_sym_week] = ACTIONS(1),
    [anon_sym_day] = ACTIONS(1),
    [anon_sym_hour] = ACTIONS(1),
    [anon_sym_minute] = ACTIONS(1),
    [anon_sym_second] = ACTIONS(1),
    [anon_sym_millisecond] = ACTIONS(1),
    [anon_sym_microsecond] = ACTIONS(1),
    [anon_sym_y] = ACTIONS(1),
    [anon_sym_m] = ACTIONS(1),
    [anon_sym_d] = ACTIONS(1),
    [anon_sym_H] = ACTIONS(1),
    [anon_sym_M] = ACTIONS(1),
    [anon_sym_S] = ACTIONS(1),
    [anon_sym_years] = ACTIONS(1),
    [anon_sym_months] = ACTIONS(1),
    [anon_sym_weeks] = ACTIONS(1),
    [anon_sym_days] = ACTIONS(1),
    [anon_sym_hours] = ACTIONS(1),
    [anon_sym_minutes] = ACTIONS(1),
    [anon_sym_seconds] = ACTIONS(1),
    [anon_sym_ago] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_DASH_GT_GT] = ACTIONS(1),
    [anon_sym_POUND_GT] = ACTIONS(1),
    [anon_sym_POUND_GT_GT] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym__natural_number] = ACTIONS(1),
    [sym_bang] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(4527),
    [sym_keyword_with] = STATE(2636),
    [sym_comment] = STATE(1),
    [sym_marginalia] = STATE(1),
    [sym_transaction] = STATE(4526),
    [sym_block] = STATE(4526),
    [sym_statement] = STATE(3741),
    [sym__ddl_statement] = STATE(2777),
    [sym__cte] = STATE(1872),
    [sym__dml_write] = STATE(2782),
    [sym__dml_read] = STATE(2788),
    [sym_set_operation] = STATE(2382),
    [sym__select_statement] = STATE(2032),
    [sym_comment_statement] = STATE(2791),
    [sym_select] = STATE(1952),
    [sym__truncate_statement] = STATE(2811),
    [sym__delete_statement] = STATE(2811),
    [sym_delete] = STATE(3725),
    [sym__create_statement] = STATE(2791),
    [sym_create_table] = STATE(2577),
    [sym_create_view] = STATE(2577),
    [sym_create_materialized_view] = STATE(2577),
    [sym_create_function] = STATE(2577),
    [sym_create_index] = STATE(2577),
    [sym_create_schema] = STATE(1825),
    [sym_create_database] = STATE(2577),
    [sym_create_role] = STATE(2577),
    [sym_create_sequence] = STATE(2577),
    [sym_create_type] = STATE(2577),
    [sym__alter_statement] = STATE(2791),
    [sym__rename_statement] = STATE(2813),
    [sym_alter_table] = STATE(2818),
    [sym_alter_view] = STATE(2818),
    [sym_alter_schema] = STATE(2818),
    [sym_alter_database] = STATE(2818),
    [sym_alter_role] = STATE(2818),
    [sym_alter_index] = STATE(2818),
    [sym_alter_sequence] = STATE(2818),
    [sym_alter_type] = STATE(2818),
    [sym__drop_statement] = STATE(2791),
    [sym_drop_table] = STATE(2819),
    [sym_drop_view] = STATE(2819),
    [sym_drop_schema] = STATE(2819),
    [sym_drop_database] = STATE(2819),
    [sym_drop_role] = STATE(2819),
    [sym_drop_type] = STATE(2819),
    [sym_drop_sequence] = STATE(2819),
    [sym_drop_index] = STATE(2819),
    [sym__insert_statement] = STATE(2811),
    [sym_insert] = STATE(2566),
    [sym__update_statement] = STATE(2811),
    [sym__merge_statement] = STATE(2820),
    [sym__optimize_statement] = STATE(2791),
    [sym__compute_stats] = STATE(2821),
    [sym__optimize_table] = STATE(2821),
    [sym__vacuum_table] = STATE(2821),
    [sym_update] = STATE(2547),
    [aux_sym_program_repeat1] = STATE(187),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_keyword_select] = ACTIONS(9),
    [sym_keyword_delete] = ACTIONS(11),
    [sym_keyword_insert] = ACTIONS(13),
    [sym_keyword_replace] = ACTIONS(13),
    [sym_keyword_update] = ACTIONS(15),
    [sym_keyword_truncate] = ACTIONS(17),
    [sym_keyword_merge] = ACTIONS(19),
    [sym_keyword_create] = ACTIONS(21),
    [sym_keyword_alter] = ACTIONS(23),
    [sym_keyword_analyze] = ACTIONS(25),
    [sym_keyword_explain] = ACTIONS(27),
    [sym_keyword_drop] = ACTIONS(29),
    [aux_sym_keyword_with_token1] = ACTIONS(31),
    [sym_keyword_rename] = ACTIONS(33),
    [sym_keyword_begin] = ACTIONS(35),
    [sym_keyword_vacuum] = ACTIONS(37),
    [sym_keyword_compute] = ACTIONS(39),
    [sym_keyword_optimize] = ACTIONS(41),
    [sym_keyword_comment] = ACTIONS(43),
    [anon_sym_LPAREN] = ACTIONS(45),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [2] = {
    [sym_comment] = STATE(2),
    [sym_marginalia] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(47),
    [sym__identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(47),
    [sym_keyword_select] = ACTIONS(49),
    [sym_keyword_values] = ACTIONS(49),
    [sym_keyword_set] = ACTIONS(49),
    [sym_keyword_from] = ACTIONS(49),
    [sym_keyword_left] = ACTIONS(49),
    [sym_keyword_right] = ACTIONS(49),
    [sym_keyword_inner] = ACTIONS(49),
    [sym_keyword_full] = ACTIONS(49),
    [sym_keyword_join] = ACTIONS(49),
    [sym_keyword_natural] = ACTIONS(49),
    [sym_keyword_on] = ACTIONS(49),
    [sym_keyword_where] = ACTIONS(49),
    [sym_keyword_partition] = ACTIONS(49),
    [sym_keyword_limit] = ACTIONS(49),
    [sym_keyword_offset] = ACTIONS(49),
    [sym_keyword_primary] = ACTIONS(49),
    [sym_keyword_create] = ACTIONS(49),
    [sym_keyword_alter] = ACTIONS(49),
    [sym_keyword_change] = ACTIONS(49),
    [sym_keyword_modify] = ACTIONS(49),
    [sym_keyword_drop] = ACTIONS(49),
    [sym_keyword_add] = ACTIONS(49),
    [sym_keyword_column] = ACTIONS(49),
    [sym_keyword_increment] = ACTIONS(49),
    [sym_keyword_minvalue] = ACTIONS(49),
    [sym_keyword_maxvalue] = ACTIONS(49),
    [sym_keyword_owned] = ACTIONS(49),
    [sym_keyword_start] = ACTIONS(49),
    [sym_keyword_restart] = ACTIONS(49),
    [sym_keyword_as] = ACTIONS(49),
    [sym_keyword_when] = ACTIONS(49),
    [sym_keyword_then] = ACTIONS(49),
    [sym_keyword_else] = ACTIONS(49),
    [sym_keyword_end] = ACTIONS(49),
    [sym_keyword_in] = ACTIONS(49),
    [sym_keyword_and] = ACTIONS(49),
    [sym_keyword_or] = ACTIONS(49),
    [sym_keyword_is] = ACTIONS(49),
    [sym_keyword_not] = ACTIONS(49),
    [sym_keyword_force] = ACTIONS(49),
    [sym_keyword_ignore] = ACTIONS(49),
    [sym_keyword_using] = ACTIONS(49),
    [sym_keyword_use] = ACTIONS(49),
    [sym_keyword_if] = ACTIONS(49),
    [sym_keyword_collate] = ACTIONS(49),
    [sym_keyword_engine] = ACTIONS(49),
    [sym_keyword_default] = ACTIONS(49),
    [sym_keyword_cascade] = ACTIONS(49),
    [sym_keyword_restrict] = ACTIONS(49),
    [aux_sym_keyword_with_token1] = ACTIONS(49),
    [sym_keyword_no] = ACTIONS(49),
    [sym_keyword_type] = ACTIONS(49),
    [sym_keyword_rename] = ACTIONS(49),
    [sym_keyword_to] = ACTIONS(49),
    [sym_keyword_owner] = ACTIONS(49),
    [sym_keyword_user] = ACTIONS(49),
    [sym_keyword_admin] = ACTIONS(49),
    [sym_keyword_password] = ACTIONS(49),
    [sym_keyword_encrypted] = ACTIONS(49),
    [sym_keyword_valid] = ACTIONS(49),
    [sym_keyword_connection] = ACTIONS(49),
    [sym_keyword_role] = ACTIONS(49),
    [sym_keyword_reset] = ACTIONS(49),
    [sym_keyword_cycle] = ACTIONS(49),
    [sym_keyword_union] = ACTIONS(49),
    [sym_keyword_except] = ACTIONS(49),
    [sym_keyword_intersect] = ACTIONS(49),
    [sym_keyword_returning] = ACTIONS(49),
    [sym_keyword_rows] = ACTIONS(49),
    [sym_keyword_between] = ACTIONS(49),
    [sym_keyword_preceding] = ACTIONS(49),
    [sym_keyword_following] = ACTIONS(49),
    [sym_keyword_row] = ACTIONS(49),
    [aux_sym_keyword_like_token1] = ACTIONS(49),
    [aux_sym_keyword_like_token2] = ACTIONS(49),
    [sym_keyword_similar] = ACTIONS(49),
    [sym_keyword_wait] = ACTIONS(49),
    [sym_keyword_nowait] = ACTIONS(49),
    [sym_keyword_authorization] = ACTIONS(49),
    [sym_keyword_returns] = ACTIONS(49),
    [sym_keyword_language] = ACTIONS(49),
    [sym_keyword_immutable] = ACTIONS(49),
    [sym_keyword_stable] = ACTIONS(49),
    [sym_keyword_volatile] = ACTIONS(49),
    [sym_keyword_leakproof] = ACTIONS(49),
    [sym_keyword_parallel] = ACTIONS(49),
    [sym_keyword_called] = ACTIONS(49),
    [sym_keyword_strict] = ACTIONS(49),
    [sym_keyword_cost] = ACTIONS(49),
    [sym_keyword_support] = ACTIONS(49),
    [sym_keyword_stored] = ACTIONS(49),
    [sym_keyword_cached] = ACTIONS(49),
    [sym_keyword_uncached] = ACTIONS(49),
    [sym_keyword_tblproperties] = ACTIONS(49),
    [sym_keyword_compute] = ACTIONS(49),
    [sym_keyword_rewrite] = ACTIONS(49),
    [sym_keyword_location] = ACTIONS(49),
    [sym_keyword_partitioned] = ACTIONS(49),
    [sym_keyword_sort] = ACTIONS(49),
    [sym_keyword_escaped] = ACTIONS(49),
    [sym_keyword_lines] = ACTIONS(49),
    [sym_keyword_cache] = ACTIONS(49),
    [anon_sym_RBRACK] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_RPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(47),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(49),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(47),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(47),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(47),
    [anon_sym_EQ] = ACTIONS(47),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_COLON_COLON] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(49),
    [anon_sym_LT_EQ] = ACTIONS(47),
    [anon_sym_GT_EQ] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_PERCENT] = ACTIONS(47),
    [anon_sym_CARET] = ACTIONS(47),
    [anon_sym_PIPE_PIPE] = ACTIONS(47),
    [anon_sym_BANG_EQ] = ACTIONS(47),
    [anon_sym_LT_GT] = ACTIONS(47),
    [anon_sym_DASH_GT] = ACTIONS(49),
    [anon_sym_DASH_GT_GT] = ACTIONS(47),
    [anon_sym_POUND_GT] = ACTIONS(49),
    [anon_sym_POUND_GT_GT] = ACTIONS(47),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(47),
  },
  [3] = {
    [sym_comment] = STATE(3),
    [sym_marginalia] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(51),
    [sym__identifier] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(51),
    [sym_keyword_on] = ACTIONS(53),
    [sym_keyword_order] = ACTIONS(53),
    [sym_keyword_having] = ACTIONS(53),
    [sym_keyword_limit] = ACTIONS(53),
    [sym_keyword_create] = ACTIONS(53),
    [sym_keyword_as] = ACTIONS(53),
    [sym_keyword_separator] = ACTIONS(53),
    [sym_keyword_when] = ACTIONS(53),
    [sym_keyword_in] = ACTIONS(53),
    [sym_keyword_and] = ACTIONS(53),
    [sym_keyword_or] = ACTIONS(53),
    [sym_keyword_is] = ACTIONS(53),
    [sym_keyword_not] = ACTIONS(53),
    [aux_sym_keyword_character_token1] = ACTIONS(53),
    [sym_keyword_returning] = ACTIONS(53),
    [sym_keyword_window] = ACTIONS(53),
    [sym_keyword_range] = ACTIONS(53),
    [sym_keyword_rows] = ACTIONS(53),
    [sym_keyword_groups] = ACTIONS(53),
    [sym_keyword_between] = ACTIONS(53),
    [aux_sym_keyword_like_token1] = ACTIONS(53),
    [aux_sym_keyword_like_token2] = ACTIONS(53),
    [sym_keyword_similar] = ACTIONS(53),
    [sym_keyword_unsigned] = ACTIONS(53),
    [sym_keyword_boolean] = ACTIONS(53),
    [sym_keyword_bit] = ACTIONS(53),
    [sym_keyword_binary] = ACTIONS(53),
    [sym_keyword_varbinary] = ACTIONS(53),
    [sym_keyword_image] = ACTIONS(53),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(53),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(53),
    [aux_sym_keyword_serial_token1] = ACTIONS(53),
    [aux_sym_keyword_serial_token2] = ACTIONS(53),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(53),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(53),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(53),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(53),
    [aux_sym_keyword_smallint_token1] = ACTIONS(53),
    [aux_sym_keyword_smallint_token2] = ACTIONS(53),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(53),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(53),
    [aux_sym_keyword_int_token1] = ACTIONS(53),
    [aux_sym_keyword_int_token2] = ACTIONS(53),
    [aux_sym_keyword_int_token3] = ACTIONS(53),
    [aux_sym_keyword_bigint_token1] = ACTIONS(53),
    [aux_sym_keyword_bigint_token2] = ACTIONS(53),
    [sym_keyword_decimal] = ACTIONS(53),
    [sym_keyword_numeric] = ACTIONS(53),
    [aux_sym_keyword_real_token1] = ACTIONS(53),
    [aux_sym_keyword_real_token2] = ACTIONS(53),
    [sym_keyword_float] = ACTIONS(53),
    [sym_keyword_double] = ACTIONS(53),
    [sym_keyword_inet] = ACTIONS(53),
    [sym_keyword_money] = ACTIONS(53),
    [sym_keyword_smallmoney] = ACTIONS(53),
    [aux_sym_keyword_char_token1] = ACTIONS(53),
    [sym_keyword_nchar] = ACTIONS(53),
    [aux_sym_keyword_varchar_token1] = ACTIONS(53),
    [sym_keyword_nvarchar] = ACTIONS(53),
    [sym_keyword_text] = ACTIONS(53),
    [sym_keyword_string] = ACTIONS(53),
    [sym_keyword_uuid] = ACTIONS(53),
    [sym_keyword_json] = ACTIONS(53),
    [sym_keyword_jsonb] = ACTIONS(53),
    [sym_keyword_xml] = ACTIONS(53),
    [sym_keyword_bytea] = ACTIONS(53),
    [sym_keyword_enum] = ACTIONS(53),
    [sym_keyword_date] = ACTIONS(53),
    [sym_keyword_datetime] = ACTIONS(53),
    [sym_keyword_datetime2] = ACTIONS(53),
    [sym_keyword_smalldatetime] = ACTIONS(53),
    [sym_keyword_datetimeoffset] = ACTIONS(53),
    [aux_sym_keyword_time_token1] = ACTIONS(53),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(53),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(53),
    [sym_keyword_interval] = ACTIONS(53),
    [sym_keyword_geometry] = ACTIONS(53),
    [sym_keyword_geography] = ACTIONS(53),
    [sym_keyword_box2d] = ACTIONS(53),
    [sym_keyword_box3d] = ACTIONS(53),
    [sym_keyword_oid] = ACTIONS(53),
    [sym_keyword_name] = ACTIONS(53),
    [sym_keyword_regclass] = ACTIONS(53),
    [sym_keyword_regnamespace] = ACTIONS(53),
    [sym_keyword_regproc] = ACTIONS(53),
    [sym_keyword_regtype] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_RPAREN] = ACTIONS(51),
    [anon_sym_COMMA] = ACTIONS(51),
    [aux_sym_double_token1] = ACTIONS(53),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(51),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(51),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_COLON_COLON] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_PERCENT] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_LT_GT] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_POUND_GT] = ACTIONS(53),
    [anon_sym_POUND_GT_GT] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(51),
  },
  [4] = {
    [sym_comment] = STATE(4),
    [sym_marginalia] = STATE(4),
    [ts_builtin_sym_end] = ACTIONS(57),
    [sym__identifier] = ACTIONS(59),
    [anon_sym_SEMI] = ACTIONS(57),
    [sym_keyword_select] = ACTIONS(59),
    [sym_keyword_values] = ACTIONS(59),
    [sym_keyword_set] = ACTIONS(59),
    [sym_keyword_from] = ACTIONS(59),
    [sym_keyword_left] = ACTIONS(59),
    [sym_keyword_right] = ACTIONS(59),
    [sym_keyword_inner] = ACTIONS(59),
    [sym_keyword_full] = ACTIONS(59),
    [sym_keyword_join] = ACTIONS(59),
    [sym_keyword_natural] = ACTIONS(59),
    [sym_keyword_on] = ACTIONS(59),
    [sym_keyword_where] = ACTIONS(59),
    [sym_keyword_partition] = ACTIONS(59),
    [sym_keyword_primary] = ACTIONS(59),
    [sym_keyword_create] = ACTIONS(59),
    [sym_keyword_alter] = ACTIONS(59),
    [sym_keyword_change] = ACTIONS(59),
    [sym_keyword_modify] = ACTIONS(59),
    [sym_keyword_drop] = ACTIONS(59),
    [sym_keyword_add] = ACTIONS(59),
    [sym_keyword_column] = ACTIONS(59),
    [sym_keyword_increment] = ACTIONS(59),
    [sym_keyword_minvalue] = ACTIONS(59),
    [sym_keyword_maxvalue] = ACTIONS(59),
    [sym_keyword_owned] = ACTIONS(59),
    [sym_keyword_start] = ACTIONS(59),
    [sym_keyword_restart] = ACTIONS(59),
    [sym_keyword_as] = ACTIONS(59),
    [sym_keyword_when] = ACTIONS(59),
    [sym_keyword_then] = ACTIONS(59),
    [sym_keyword_else] = ACTIONS(59),
    [sym_keyword_end] = ACTIONS(59),
    [sym_keyword_in] = ACTIONS(59),
    [sym_keyword_and] = ACTIONS(59),
    [sym_keyword_or] = ACTIONS(59),
    [sym_keyword_is] = ACTIONS(59),
    [sym_keyword_not] = ACTIONS(59),
    [sym_keyword_force] = ACTIONS(59),
    [sym_keyword_ignore] = ACTIONS(59),
    [sym_keyword_using] = ACTIONS(59),
    [sym_keyword_use] = ACTIONS(59),
    [sym_keyword_if] = ACTIONS(59),
    [sym_keyword_collate] = ACTIONS(59),
    [sym_keyword_engine] = ACTIONS(59),
    [sym_keyword_default] = ACTIONS(59),
    [sym_keyword_cascade] = ACTIONS(59),
    [sym_keyword_restrict] = ACTIONS(59),
    [aux_sym_keyword_with_token1] = ACTIONS(59),
    [sym_keyword_no] = ACTIONS(59),
    [sym_keyword_type] = ACTIONS(59),
    [sym_keyword_rename] = ACTIONS(59),
    [sym_keyword_to] = ACTIONS(59),
    [sym_keyword_owner] = ACTIONS(59),
    [sym_keyword_user] = ACTIONS(59),
    [sym_keyword_admin] = ACTIONS(59),
    [sym_keyword_password] = ACTIONS(59),
    [sym_keyword_encrypted] = ACTIONS(59),
    [sym_keyword_valid] = ACTIONS(59),
    [sym_keyword_connection] = ACTIONS(59),
    [sym_keyword_role] = ACTIONS(59),
    [sym_keyword_reset] = ACTIONS(59),
    [sym_keyword_cycle] = ACTIONS(59),
    [sym_keyword_union] = ACTIONS(59),
    [sym_keyword_except] = ACTIONS(59),
    [sym_keyword_intersect] = ACTIONS(59),
    [sym_keyword_returning] = ACTIONS(59),
    [sym_keyword_between] = ACTIONS(59),
    [sym_keyword_preceding] = ACTIONS(59),
    [sym_keyword_following] = ACTIONS(59),
    [sym_keyword_row] = ACTIONS(59),
    [aux_sym_keyword_like_token1] = ACTIONS(59),
    [aux_sym_keyword_like_token2] = ACTIONS(59),
    [sym_keyword_similar] = ACTIONS(59),
    [sym_keyword_wait] = ACTIONS(59),
    [sym_keyword_nowait] = ACTIONS(59),
    [sym_keyword_authorization] = ACTIONS(59),
    [sym_keyword_stored] = ACTIONS(59),
    [sym_keyword_tblproperties] = ACTIONS(59),
    [sym_keyword_compute] = ACTIONS(59),
    [sym_keyword_rewrite] = ACTIONS(59),
    [sym_keyword_location] = ACTIONS(59),
    [sym_keyword_partitioned] = ACTIONS(59),
    [sym_keyword_sort] = ACTIONS(59),
    [sym_keyword_cache] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(57),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(57),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(57),
    [anon_sym_EQ] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_PERCENT] = ACTIONS(57),
    [anon_sym_CARET] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_BANG_EQ] = ACTIONS(57),
    [anon_sym_LT_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_DASH_GT_GT] = ACTIONS(57),
    [anon_sym_POUND_GT] = ACTIONS(59),
    [anon_sym_POUND_GT_GT] = ACTIONS(57),
    [anon_sym_DQUOTE] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(57),
  },
  [5] = {
    [sym_comment] = STATE(5),
    [sym_marginalia] = STATE(5),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym__identifier] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(55),
    [sym_keyword_select] = ACTIONS(61),
    [sym_keyword_values] = ACTIONS(61),
    [sym_keyword_set] = ACTIONS(61),
    [sym_keyword_from] = ACTIONS(61),
    [sym_keyword_left] = ACTIONS(61),
    [sym_keyword_right] = ACTIONS(61),
    [sym_keyword_inner] = ACTIONS(61),
    [sym_keyword_full] = ACTIONS(61),
    [sym_keyword_join] = ACTIONS(61),
    [sym_keyword_natural] = ACTIONS(61),
    [sym_keyword_on] = ACTIONS(61),
    [sym_keyword_where] = ACTIONS(61),
    [sym_keyword_partition] = ACTIONS(61),
    [sym_keyword_primary] = ACTIONS(61),
    [sym_keyword_create] = ACTIONS(61),
    [sym_keyword_alter] = ACTIONS(61),
    [sym_keyword_change] = ACTIONS(61),
    [sym_keyword_modify] = ACTIONS(61),
    [sym_keyword_drop] = ACTIONS(61),
    [sym_keyword_add] = ACTIONS(61),
    [sym_keyword_column] = ACTIONS(61),
    [sym_keyword_increment] = ACTIONS(61),
    [sym_keyword_minvalue] = ACTIONS(61),
    [sym_keyword_maxvalue] = ACTIONS(61),
    [sym_keyword_owned] = ACTIONS(61),
    [sym_keyword_start] = ACTIONS(61),
    [sym_keyword_restart] = ACTIONS(61),
    [sym_keyword_as] = ACTIONS(61),
    [sym_keyword_when] = ACTIONS(61),
    [sym_keyword_then] = ACTIONS(61),
    [sym_keyword_else] = ACTIONS(61),
    [sym_keyword_end] = ACTIONS(61),
    [sym_keyword_in] = ACTIONS(61),
    [sym_keyword_and] = ACTIONS(61),
    [sym_keyword_or] = ACTIONS(61),
    [sym_keyword_is] = ACTIONS(61),
    [sym_keyword_not] = ACTIONS(61),
    [sym_keyword_force] = ACTIONS(61),
    [sym_keyword_ignore] = ACTIONS(61),
    [sym_keyword_using] = ACTIONS(61),
    [sym_keyword_use] = ACTIONS(61),
    [sym_keyword_if] = ACTIONS(61),
    [sym_keyword_collate] = ACTIONS(61),
    [sym_keyword_engine] = ACTIONS(61),
    [sym_keyword_default] = ACTIONS(61),
    [sym_keyword_cascade] = ACTIONS(61),
    [sym_keyword_restrict] = ACTIONS(61),
    [aux_sym_keyword_with_token1] = ACTIONS(61),
    [sym_keyword_no] = ACTIONS(61),
    [sym_keyword_type] = ACTIONS(61),
    [sym_keyword_rename] = ACTIONS(61),
    [sym_keyword_to] = ACTIONS(61),
    [sym_keyword_owner] = ACTIONS(61),
    [sym_keyword_user] = ACTIONS(61),
    [sym_keyword_admin] = ACTIONS(61),
    [sym_keyword_password] = ACTIONS(61),
    [sym_keyword_encrypted] = ACTIONS(61),
    [sym_keyword_valid] = ACTIONS(61),
    [sym_keyword_connection] = ACTIONS(61),
    [sym_keyword_role] = ACTIONS(61),
    [sym_keyword_reset] = ACTIONS(61),
    [sym_keyword_cycle] = ACTIONS(61),
    [sym_keyword_union] = ACTIONS(61),
    [sym_keyword_except] = ACTIONS(61),
    [sym_keyword_intersect] = ACTIONS(61),
    [sym_keyword_returning] = ACTIONS(61),
    [sym_keyword_between] = ACTIONS(61),
    [sym_keyword_preceding] = ACTIONS(61),
    [sym_keyword_following] = ACTIONS(61),
    [sym_keyword_row] = ACTIONS(61),
    [aux_sym_keyword_like_token1] = ACTIONS(61),
    [aux_sym_keyword_like_token2] = ACTIONS(61),
    [sym_keyword_similar] = ACTIONS(61),
    [sym_keyword_wait] = ACTIONS(61),
    [sym_keyword_nowait] = ACTIONS(61),
    [sym_keyword_authorization] = ACTIONS(61),
    [sym_keyword_stored] = ACTIONS(61),
    [sym_keyword_tblproperties] = ACTIONS(61),
    [sym_keyword_compute] = ACTIONS(61),
    [sym_keyword_rewrite] = ACTIONS(61),
    [sym_keyword_location] = ACTIONS(61),
    [sym_keyword_partitioned] = ACTIONS(61),
    [sym_keyword_sort] = ACTIONS(61),
    [sym_keyword_cache] = ACTIONS(61),
    [anon_sym_RBRACK] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(61),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(55),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(55),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(55),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_STAR] = ACTIONS(55),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_SQUOTE] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(55),
    [anon_sym_GT_EQ] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(55),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_PERCENT] = ACTIONS(55),
    [anon_sym_CARET] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_BANG_EQ] = ACTIONS(55),
    [anon_sym_LT_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_GT] = ACTIONS(55),
    [anon_sym_POUND_GT] = ACTIONS(61),
    [anon_sym_POUND_GT_GT] = ACTIONS(55),
    [anon_sym_DQUOTE] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
  },
  [6] = {
    [sym_comment] = STATE(6),
    [sym_marginalia] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(63),
    [sym__identifier] = ACTIONS(65),
    [anon_sym_SEMI] = ACTIONS(63),
    [sym_keyword_on] = ACTIONS(65),
    [sym_keyword_order] = ACTIONS(65),
    [sym_keyword_having] = ACTIONS(65),
    [sym_keyword_limit] = ACTIONS(65),
    [sym_keyword_create] = ACTIONS(65),
    [sym_keyword_as] = ACTIONS(65),
    [sym_keyword_separator] = ACTIONS(65),
    [sym_keyword_when] = ACTIONS(65),
    [sym_keyword_in] = ACTIONS(65),
    [sym_keyword_and] = ACTIONS(65),
    [sym_keyword_or] = ACTIONS(65),
    [sym_keyword_is] = ACTIONS(65),
    [sym_keyword_not] = ACTIONS(65),
    [aux_sym_keyword_character_token1] = ACTIONS(65),
    [sym_keyword_returning] = ACTIONS(65),
    [sym_keyword_window] = ACTIONS(65),
    [sym_keyword_range] = ACTIONS(65),
    [sym_keyword_rows] = ACTIONS(65),
    [sym_keyword_groups] = ACTIONS(65),
    [sym_keyword_between] = ACTIONS(65),
    [aux_sym_keyword_like_token1] = ACTIONS(65),
    [aux_sym_keyword_like_token2] = ACTIONS(65),
    [sym_keyword_similar] = ACTIONS(65),
    [sym_keyword_unsigned] = ACTIONS(65),
    [sym_keyword_boolean] = ACTIONS(65),
    [sym_keyword_bit] = ACTIONS(65),
    [sym_keyword_binary] = ACTIONS(65),
    [sym_keyword_varbinary] = ACTIONS(65),
    [sym_keyword_image] = ACTIONS(65),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(65),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(65),
    [aux_sym_keyword_serial_token1] = ACTIONS(65),
    [aux_sym_keyword_serial_token2] = ACTIONS(65),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(65),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(65),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(65),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(65),
    [aux_sym_keyword_smallint_token1] = ACTIONS(65),
    [aux_sym_keyword_smallint_token2] = ACTIONS(65),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(65),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(65),
    [aux_sym_keyword_int_token1] = ACTIONS(65),
    [aux_sym_keyword_int_token2] = ACTIONS(65),
    [aux_sym_keyword_int_token3] = ACTIONS(65),
    [aux_sym_keyword_bigint_token1] = ACTIONS(65),
    [aux_sym_keyword_bigint_token2] = ACTIONS(65),
    [sym_keyword_decimal] = ACTIONS(65),
    [sym_keyword_numeric] = ACTIONS(65),
    [aux_sym_keyword_real_token1] = ACTIONS(65),
    [aux_sym_keyword_real_token2] = ACTIONS(65),
    [sym_keyword_float] = ACTIONS(65),
    [sym_keyword_double] = ACTIONS(65),
    [sym_keyword_inet] = ACTIONS(65),
    [sym_keyword_money] = ACTIONS(65),
    [sym_keyword_smallmoney] = ACTIONS(65),
    [aux_sym_keyword_char_token1] = ACTIONS(65),
    [sym_keyword_nchar] = ACTIONS(65),
    [aux_sym_keyword_varchar_token1] = ACTIONS(65),
    [sym_keyword_nvarchar] = ACTIONS(65),
    [sym_keyword_text] = ACTIONS(65),
    [sym_keyword_string] = ACTIONS(65),
    [sym_keyword_uuid] = ACTIONS(65),
    [sym_keyword_json] = ACTIONS(65),
    [sym_keyword_jsonb] = ACTIONS(65),
    [sym_keyword_xml] = ACTIONS(65),
    [sym_keyword_bytea] = ACTIONS(65),
    [sym_keyword_enum] = ACTIONS(65),
    [sym_keyword_date] = ACTIONS(65),
    [sym_keyword_datetime] = ACTIONS(65),
    [sym_keyword_datetime2] = ACTIONS(65),
    [sym_keyword_smalldatetime] = ACTIONS(65),
    [sym_keyword_datetimeoffset] = ACTIONS(65),
    [aux_sym_keyword_time_token1] = ACTIONS(65),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(65),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(65),
    [sym_keyword_interval] = ACTIONS(65),
    [sym_keyword_geometry] = ACTIONS(65),
    [sym_keyword_geography] = ACTIONS(65),
    [sym_keyword_box2d] = ACTIONS(65),
    [sym_keyword_box3d] = ACTIONS(65),
    [sym_keyword_oid] = ACTIONS(65),
    [sym_keyword_name] = ACTIONS(65),
    [sym_keyword_regclass] = ACTIONS(65),
    [sym_keyword_regnamespace] = ACTIONS(65),
    [sym_keyword_regproc] = ACTIONS(65),
    [sym_keyword_regtype] = ACTIONS(65),
    [anon_sym_RPAREN] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(63),
    [aux_sym_double_token1] = ACTIONS(65),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(63),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(63),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(63),
    [anon_sym_EQ] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_COLON_COLON] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(63),
    [anon_sym_GT_EQ] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(63),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_PIPE_PIPE] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(63),
    [anon_sym_LT_GT] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(63),
    [anon_sym_POUND_GT] = ACTIONS(65),
    [anon_sym_POUND_GT_GT] = ACTIONS(63),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_BQUOTE] = ACTIONS(63),
  },
  [7] = {
    [sym_comment] = STATE(7),
    [sym_marginalia] = STATE(7),
    [ts_builtin_sym_end] = ACTIONS(51),
    [sym__identifier] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(51),
    [sym_keyword_on] = ACTIONS(53),
    [sym_keyword_order] = ACTIONS(53),
    [sym_keyword_having] = ACTIONS(53),
    [sym_keyword_limit] = ACTIONS(53),
    [sym_keyword_create] = ACTIONS(53),
    [sym_keyword_as] = ACTIONS(53),
    [sym_keyword_separator] = ACTIONS(53),
    [sym_keyword_when] = ACTIONS(53),
    [sym_keyword_in] = ACTIONS(53),
    [sym_keyword_and] = ACTIONS(53),
    [sym_keyword_or] = ACTIONS(53),
    [sym_keyword_is] = ACTIONS(53),
    [sym_keyword_not] = ACTIONS(53),
    [aux_sym_keyword_character_token1] = ACTIONS(53),
    [sym_keyword_returning] = ACTIONS(53),
    [sym_keyword_window] = ACTIONS(53),
    [sym_keyword_range] = ACTIONS(53),
    [sym_keyword_rows] = ACTIONS(53),
    [sym_keyword_groups] = ACTIONS(53),
    [sym_keyword_between] = ACTIONS(53),
    [aux_sym_keyword_like_token1] = ACTIONS(53),
    [aux_sym_keyword_like_token2] = ACTIONS(53),
    [sym_keyword_similar] = ACTIONS(53),
    [sym_keyword_unsigned] = ACTIONS(53),
    [sym_keyword_boolean] = ACTIONS(53),
    [sym_keyword_bit] = ACTIONS(53),
    [sym_keyword_binary] = ACTIONS(53),
    [sym_keyword_varbinary] = ACTIONS(53),
    [sym_keyword_image] = ACTIONS(53),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(53),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(53),
    [aux_sym_keyword_serial_token1] = ACTIONS(53),
    [aux_sym_keyword_serial_token2] = ACTIONS(53),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(53),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(53),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(53),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(53),
    [aux_sym_keyword_smallint_token1] = ACTIONS(53),
    [aux_sym_keyword_smallint_token2] = ACTIONS(53),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(53),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(53),
    [aux_sym_keyword_int_token1] = ACTIONS(53),
    [aux_sym_keyword_int_token2] = ACTIONS(53),
    [aux_sym_keyword_int_token3] = ACTIONS(53),
    [aux_sym_keyword_bigint_token1] = ACTIONS(53),
    [aux_sym_keyword_bigint_token2] = ACTIONS(53),
    [sym_keyword_decimal] = ACTIONS(53),
    [sym_keyword_numeric] = ACTIONS(53),
    [aux_sym_keyword_real_token1] = ACTIONS(53),
    [aux_sym_keyword_real_token2] = ACTIONS(53),
    [sym_keyword_float] = ACTIONS(53),
    [sym_keyword_double] = ACTIONS(53),
    [sym_keyword_inet] = ACTIONS(53),
    [sym_keyword_money] = ACTIONS(53),
    [sym_keyword_smallmoney] = ACTIONS(53),
    [aux_sym_keyword_char_token1] = ACTIONS(53),
    [sym_keyword_nchar] = ACTIONS(53),
    [aux_sym_keyword_varchar_token1] = ACTIONS(53),
    [sym_keyword_nvarchar] = ACTIONS(53),
    [sym_keyword_text] = ACTIONS(53),
    [sym_keyword_string] = ACTIONS(53),
    [sym_keyword_uuid] = ACTIONS(53),
    [sym_keyword_json] = ACTIONS(53),
    [sym_keyword_jsonb] = ACTIONS(53),
    [sym_keyword_xml] = ACTIONS(53),
    [sym_keyword_bytea] = ACTIONS(53),
    [sym_keyword_enum] = ACTIONS(53),
    [sym_keyword_date] = ACTIONS(53),
    [sym_keyword_datetime] = ACTIONS(53),
    [sym_keyword_datetime2] = ACTIONS(53),
    [sym_keyword_smalldatetime] = ACTIONS(53),
    [sym_keyword_datetimeoffset] = ACTIONS(53),
    [aux_sym_keyword_time_token1] = ACTIONS(53),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(53),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(53),
    [sym_keyword_interval] = ACTIONS(53),
    [sym_keyword_geometry] = ACTIONS(53),
    [sym_keyword_geography] = ACTIONS(53),
    [sym_keyword_box2d] = ACTIONS(53),
    [sym_keyword_box3d] = ACTIONS(53),
    [sym_keyword_oid] = ACTIONS(53),
    [sym_keyword_name] = ACTIONS(53),
    [sym_keyword_regclass] = ACTIONS(53),
    [sym_keyword_regnamespace] = ACTIONS(53),
    [sym_keyword_regproc] = ACTIONS(53),
    [sym_keyword_regtype] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(51),
    [anon_sym_COMMA] = ACTIONS(51),
    [aux_sym_double_token1] = ACTIONS(53),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(51),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(51),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_COLON_COLON] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_PERCENT] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_LT_GT] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_POUND_GT] = ACTIONS(53),
    [anon_sym_POUND_GT_GT] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(51),
  },
  [8] = {
    [sym_comment] = STATE(8),
    [sym_marginalia] = STATE(8),
    [ts_builtin_sym_end] = ACTIONS(63),
    [sym__identifier] = ACTIONS(65),
    [anon_sym_SEMI] = ACTIONS(63),
    [sym_keyword_set] = ACTIONS(65),
    [sym_keyword_from] = ACTIONS(65),
    [sym_keyword_left] = ACTIONS(65),
    [sym_keyword_right] = ACTIONS(65),
    [sym_keyword_inner] = ACTIONS(65),
    [sym_keyword_full] = ACTIONS(65),
    [sym_keyword_join] = ACTIONS(65),
    [sym_keyword_natural] = ACTIONS(65),
    [sym_keyword_on] = ACTIONS(65),
    [sym_keyword_where] = ACTIONS(65),
    [sym_keyword_partition] = ACTIONS(65),
    [sym_keyword_limit] = ACTIONS(65),
    [sym_keyword_offset] = ACTIONS(65),
    [sym_keyword_create] = ACTIONS(65),
    [sym_keyword_increment] = ACTIONS(65),
    [sym_keyword_minvalue] = ACTIONS(65),
    [sym_keyword_maxvalue] = ACTIONS(65),
    [sym_keyword_owned] = ACTIONS(65),
    [sym_keyword_start] = ACTIONS(65),
    [sym_keyword_restart] = ACTIONS(65),
    [sym_keyword_as] = ACTIONS(65),
    [sym_keyword_when] = ACTIONS(65),
    [sym_keyword_then] = ACTIONS(65),
    [sym_keyword_else] = ACTIONS(65),
    [sym_keyword_end] = ACTIONS(65),
    [sym_keyword_in] = ACTIONS(65),
    [sym_keyword_and] = ACTIONS(65),
    [sym_keyword_or] = ACTIONS(65),
    [sym_keyword_is] = ACTIONS(65),
    [sym_keyword_not] = ACTIONS(65),
    [sym_keyword_using] = ACTIONS(65),
    [sym_keyword_collate] = ACTIONS(65),
    [sym_keyword_engine] = ACTIONS(65),
    [sym_keyword_default] = ACTIONS(65),
    [aux_sym_keyword_with_token1] = ACTIONS(65),
    [sym_keyword_no] = ACTIONS(65),
    [sym_keyword_to] = ACTIONS(65),
    [sym_keyword_user] = ACTIONS(65),
    [sym_keyword_admin] = ACTIONS(65),
    [sym_keyword_password] = ACTIONS(65),
    [sym_keyword_encrypted] = ACTIONS(65),
    [sym_keyword_valid] = ACTIONS(65),
    [sym_keyword_connection] = ACTIONS(65),
    [sym_keyword_role] = ACTIONS(65),
    [sym_keyword_cycle] = ACTIONS(65),
    [sym_keyword_union] = ACTIONS(65),
    [sym_keyword_except] = ACTIONS(65),
    [sym_keyword_intersect] = ACTIONS(65),
    [sym_keyword_returning] = ACTIONS(65),
    [sym_keyword_after] = ACTIONS(65),
    [sym_keyword_before] = ACTIONS(65),
    [sym_keyword_rows] = ACTIONS(65),
    [sym_keyword_between] = ACTIONS(65),
    [sym_keyword_preceding] = ACTIONS(65),
    [sym_keyword_following] = ACTIONS(65),
    [sym_keyword_row] = ACTIONS(65),
    [aux_sym_keyword_like_token1] = ACTIONS(65),
    [aux_sym_keyword_like_token2] = ACTIONS(65),
    [sym_keyword_similar] = ACTIONS(65),
    [sym_keyword_returns] = ACTIONS(65),
    [sym_keyword_language] = ACTIONS(65),
    [sym_keyword_immutable] = ACTIONS(65),
    [sym_keyword_stable] = ACTIONS(65),
    [sym_keyword_volatile] = ACTIONS(65),
    [sym_keyword_leakproof] = ACTIONS(65),
    [sym_keyword_parallel] = ACTIONS(65),
    [sym_keyword_called] = ACTIONS(65),
    [sym_keyword_strict] = ACTIONS(65),
    [sym_keyword_cost] = ACTIONS(65),
    [sym_keyword_support] = ACTIONS(65),
    [sym_keyword_stored] = ACTIONS(65),
    [sym_keyword_cached] = ACTIONS(65),
    [sym_keyword_uncached] = ACTIONS(65),
    [sym_keyword_tblproperties] = ACTIONS(65),
    [sym_keyword_location] = ACTIONS(65),
    [sym_keyword_partitioned] = ACTIONS(65),
    [sym_keyword_sort] = ACTIONS(65),
    [sym_keyword_escaped] = ACTIONS(65),
    [sym_keyword_lines] = ACTIONS(65),
    [sym_keyword_cache] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(63),
    [anon_sym_RPAREN] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(65),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(63),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(63),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(63),
    [anon_sym_EQ] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_COLON_COLON] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(63),
    [anon_sym_GT_EQ] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(63),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_PIPE_PIPE] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(63),
    [anon_sym_LT_GT] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(63),
    [anon_sym_POUND_GT] = ACTIONS(65),
    [anon_sym_POUND_GT_GT] = ACTIONS(63),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_BQUOTE] = ACTIONS(63),
  },
  [9] = {
    [sym_comment] = STATE(9),
    [sym_marginalia] = STATE(9),
    [ts_builtin_sym_end] = ACTIONS(51),
    [sym__identifier] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(51),
    [sym_keyword_set] = ACTIONS(53),
    [sym_keyword_from] = ACTIONS(53),
    [sym_keyword_left] = ACTIONS(53),
    [sym_keyword_right] = ACTIONS(53),
    [sym_keyword_inner] = ACTIONS(53),
    [sym_keyword_full] = ACTIONS(53),
    [sym_keyword_join] = ACTIONS(53),
    [sym_keyword_natural] = ACTIONS(53),
    [sym_keyword_on] = ACTIONS(53),
    [sym_keyword_where] = ACTIONS(53),
    [sym_keyword_partition] = ACTIONS(53),
    [sym_keyword_limit] = ACTIONS(53),
    [sym_keyword_offset] = ACTIONS(53),
    [sym_keyword_create] = ACTIONS(53),
    [sym_keyword_increment] = ACTIONS(53),
    [sym_keyword_minvalue] = ACTIONS(53),
    [sym_keyword_maxvalue] = ACTIONS(53),
    [sym_keyword_owned] = ACTIONS(53),
    [sym_keyword_start] = ACTIONS(53),
    [sym_keyword_restart] = ACTIONS(53),
    [sym_keyword_as] = ACTIONS(53),
    [sym_keyword_when] = ACTIONS(53),
    [sym_keyword_then] = ACTIONS(53),
    [sym_keyword_else] = ACTIONS(53),
    [sym_keyword_end] = ACTIONS(53),
    [sym_keyword_in] = ACTIONS(53),
    [sym_keyword_and] = ACTIONS(53),
    [sym_keyword_or] = ACTIONS(53),
    [sym_keyword_is] = ACTIONS(53),
    [sym_keyword_not] = ACTIONS(53),
    [sym_keyword_using] = ACTIONS(53),
    [sym_keyword_collate] = ACTIONS(53),
    [sym_keyword_engine] = ACTIONS(53),
    [sym_keyword_default] = ACTIONS(53),
    [aux_sym_keyword_with_token1] = ACTIONS(53),
    [sym_keyword_no] = ACTIONS(53),
    [sym_keyword_user] = ACTIONS(53),
    [sym_keyword_admin] = ACTIONS(53),
    [sym_keyword_password] = ACTIONS(53),
    [sym_keyword_encrypted] = ACTIONS(53),
    [sym_keyword_valid] = ACTIONS(53),
    [sym_keyword_connection] = ACTIONS(53),
    [sym_keyword_role] = ACTIONS(53),
    [sym_keyword_cycle] = ACTIONS(53),
    [sym_keyword_union] = ACTIONS(53),
    [sym_keyword_except] = ACTIONS(53),
    [sym_keyword_intersect] = ACTIONS(53),
    [sym_keyword_returning] = ACTIONS(53),
    [sym_keyword_rows] = ACTIONS(53),
    [sym_keyword_between] = ACTIONS(53),
    [sym_keyword_preceding] = ACTIONS(53),
    [sym_keyword_following] = ACTIONS(53),
    [sym_keyword_row] = ACTIONS(53),
    [aux_sym_keyword_like_token1] = ACTIONS(53),
    [aux_sym_keyword_like_token2] = ACTIONS(53),
    [sym_keyword_similar] = ACTIONS(53),
    [sym_keyword_returns] = ACTIONS(53),
    [sym_keyword_language] = ACTIONS(53),
    [sym_keyword_immutable] = ACTIONS(53),
    [sym_keyword_stable] = ACTIONS(53),
    [sym_keyword_volatile] = ACTIONS(53),
    [sym_keyword_leakproof] = ACTIONS(53),
    [sym_keyword_parallel] = ACTIONS(53),
    [sym_keyword_called] = ACTIONS(53),
    [sym_keyword_strict] = ACTIONS(53),
    [sym_keyword_cost] = ACTIONS(53),
    [sym_keyword_support] = ACTIONS(53),
    [sym_keyword_stored] = ACTIONS(53),
    [sym_keyword_cached] = ACTIONS(53),
    [sym_keyword_uncached] = ACTIONS(53),
    [sym_keyword_tblproperties] = ACTIONS(53),
    [sym_keyword_location] = ACTIONS(53),
    [sym_keyword_partitioned] = ACTIONS(53),
    [sym_keyword_sort] = ACTIONS(53),
    [sym_keyword_escaped] = ACTIONS(53),
    [sym_keyword_lines] = ACTIONS(53),
    [sym_keyword_cache] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(51),
    [anon_sym_COMMA] = ACTIONS(51),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(53),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(51),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(51),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_COLON_COLON] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_LT_EQ] = ACTIONS(51),
    [anon_sym_GT_EQ] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_PERCENT] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_BANG_EQ] = ACTIONS(51),
    [anon_sym_LT_GT] = ACTIONS(51),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_GT] = ACTIONS(51),
    [anon_sym_POUND_GT] = ACTIONS(53),
    [anon_sym_POUND_GT_GT] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(51),
  },
  [10] = {
    [sym_keyword_smallserial] = STATE(808),
    [sym_keyword_serial] = STATE(808),
    [sym_keyword_bigserial] = STATE(808),
    [sym_keyword_tinyint] = STATE(795),
    [sym_keyword_smallint] = STATE(805),
    [sym_keyword_mediumint] = STATE(807),
    [sym_keyword_int] = STATE(791),
    [sym_keyword_bigint] = STATE(792),
    [sym_keyword_real] = STATE(801),
    [sym_keyword_char] = STATE(916),
    [sym_keyword_varchar] = STATE(918),
    [sym_keyword_time] = STATE(919),
    [sym_keyword_timestamp] = STATE(808),
    [sym_keyword_timestamptz] = STATE(808),
    [sym__type] = STATE(1683),
    [sym_tinyint] = STATE(808),
    [sym_smallint] = STATE(808),
    [sym_mediumint] = STATE(808),
    [sym_int] = STATE(808),
    [sym_bigint] = STATE(808),
    [sym_bit] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_varbinary] = STATE(808),
    [sym_float] = STATE(808),
    [sym_double] = STATE(808),
    [sym_decimal] = STATE(808),
    [sym_numeric] = STATE(808),
    [sym_char] = STATE(808),
    [sym_varchar] = STATE(808),
    [sym_nchar] = STATE(808),
    [sym_nvarchar] = STATE(808),
    [sym_datetimeoffset] = STATE(808),
    [sym_time] = STATE(808),
    [sym_enum] = STATE(808),
    [sym_comment] = STATE(10),
    [sym_marginalia] = STATE(10),
    [sym__identifier] = ACTIONS(67),
    [sym_keyword_table] = ACTIONS(69),
    [aux_sym_keyword_character_token1] = ACTIONS(71),
    [sym_keyword_unsigned] = ACTIONS(73),
    [sym_keyword_trigger] = ACTIONS(75),
    [sym_keyword_setof] = ACTIONS(77),
    [sym_keyword_boolean] = ACTIONS(79),
    [sym_keyword_bit] = ACTIONS(81),
    [sym_keyword_binary] = ACTIONS(83),
    [sym_keyword_varbinary] = ACTIONS(85),
    [sym_keyword_image] = ACTIONS(79),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(87),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(87),
    [aux_sym_keyword_serial_token1] = ACTIONS(89),
    [aux_sym_keyword_serial_token2] = ACTIONS(89),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(91),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(91),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(93),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(93),
    [aux_sym_keyword_smallint_token1] = ACTIONS(95),
    [aux_sym_keyword_smallint_token2] = ACTIONS(95),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(97),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(97),
    [aux_sym_keyword_int_token1] = ACTIONS(99),
    [aux_sym_keyword_int_token2] = ACTIONS(99),
    [aux_sym_keyword_int_token3] = ACTIONS(99),
    [aux_sym_keyword_bigint_token1] = ACTIONS(101),
    [aux_sym_keyword_bigint_token2] = ACTIONS(101),
    [sym_keyword_decimal] = ACTIONS(103),
    [sym_keyword_numeric] = ACTIONS(105),
    [aux_sym_keyword_real_token1] = ACTIONS(107),
    [aux_sym_keyword_real_token2] = ACTIONS(107),
    [sym_keyword_float] = ACTIONS(109),
    [sym_keyword_double] = ACTIONS(111),
    [sym_keyword_inet] = ACTIONS(79),
    [sym_keyword_money] = ACTIONS(79),
    [sym_keyword_smallmoney] = ACTIONS(79),
    [aux_sym_keyword_char_token1] = ACTIONS(113),
    [sym_keyword_nchar] = ACTIONS(115),
    [aux_sym_keyword_varchar_token1] = ACTIONS(117),
    [sym_keyword_nvarchar] = ACTIONS(119),
    [sym_keyword_text] = ACTIONS(79),
    [sym_keyword_string] = ACTIONS(79),
    [sym_keyword_uuid] = ACTIONS(79),
    [sym_keyword_json] = ACTIONS(79),
    [sym_keyword_jsonb] = ACTIONS(79),
    [sym_keyword_xml] = ACTIONS(79),
    [sym_keyword_bytea] = ACTIONS(79),
    [sym_keyword_enum] = ACTIONS(121),
    [sym_keyword_date] = ACTIONS(79),
    [sym_keyword_datetime] = ACTIONS(79),
    [sym_keyword_datetime2] = ACTIONS(79),
    [sym_keyword_smalldatetime] = ACTIONS(79),
    [sym_keyword_datetimeoffset] = ACTIONS(123),
    [aux_sym_keyword_time_token1] = ACTIONS(125),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(127),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(129),
    [sym_keyword_interval] = ACTIONS(79),
    [sym_keyword_geometry] = ACTIONS(79),
    [sym_keyword_geography] = ACTIONS(79),
    [sym_keyword_box2d] = ACTIONS(79),
    [sym_keyword_box3d] = ACTIONS(79),
    [sym_keyword_oid] = ACTIONS(79),
    [sym_keyword_name] = ACTIONS(79),
    [sym_keyword_regclass] = ACTIONS(79),
    [sym_keyword_regnamespace] = ACTIONS(79),
    [sym_keyword_regproc] = ACTIONS(79),
    [sym_keyword_regtype] = ACTIONS(79),
    [aux_sym_double_token1] = ACTIONS(131),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [11] = {
    [sym_keyword_smallserial] = STATE(808),
    [sym_keyword_serial] = STATE(808),
    [sym_keyword_bigserial] = STATE(808),
    [sym_keyword_tinyint] = STATE(795),
    [sym_keyword_smallint] = STATE(805),
    [sym_keyword_mediumint] = STATE(807),
    [sym_keyword_int] = STATE(791),
    [sym_keyword_bigint] = STATE(792),
    [sym_keyword_real] = STATE(801),
    [sym_keyword_char] = STATE(916),
    [sym_keyword_varchar] = STATE(918),
    [sym_keyword_time] = STATE(919),
    [sym_keyword_timestamp] = STATE(808),
    [sym_keyword_timestamptz] = STATE(808),
    [sym__type] = STATE(1684),
    [sym_tinyint] = STATE(808),
    [sym_smallint] = STATE(808),
    [sym_mediumint] = STATE(808),
    [sym_int] = STATE(808),
    [sym_bigint] = STATE(808),
    [sym_bit] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_varbinary] = STATE(808),
    [sym_float] = STATE(808),
    [sym_double] = STATE(808),
    [sym_decimal] = STATE(808),
    [sym_numeric] = STATE(808),
    [sym_char] = STATE(808),
    [sym_varchar] = STATE(808),
    [sym_nchar] = STATE(808),
    [sym_nvarchar] = STATE(808),
    [sym_datetimeoffset] = STATE(808),
    [sym_time] = STATE(808),
    [sym_enum] = STATE(808),
    [sym_comment] = STATE(11),
    [sym_marginalia] = STATE(11),
    [sym__identifier] = ACTIONS(67),
    [sym_keyword_table] = ACTIONS(133),
    [aux_sym_keyword_character_token1] = ACTIONS(71),
    [sym_keyword_unsigned] = ACTIONS(73),
    [sym_keyword_trigger] = ACTIONS(135),
    [sym_keyword_setof] = ACTIONS(137),
    [sym_keyword_boolean] = ACTIONS(79),
    [sym_keyword_bit] = ACTIONS(81),
    [sym_keyword_binary] = ACTIONS(83),
    [sym_keyword_varbinary] = ACTIONS(85),
    [sym_keyword_image] = ACTIONS(79),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(87),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(87),
    [aux_sym_keyword_serial_token1] = ACTIONS(89),
    [aux_sym_keyword_serial_token2] = ACTIONS(89),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(91),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(91),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(93),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(93),
    [aux_sym_keyword_smallint_token1] = ACTIONS(95),
    [aux_sym_keyword_smallint_token2] = ACTIONS(95),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(97),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(97),
    [aux_sym_keyword_int_token1] = ACTIONS(99),
    [aux_sym_keyword_int_token2] = ACTIONS(99),
    [aux_sym_keyword_int_token3] = ACTIONS(99),
    [aux_sym_keyword_bigint_token1] = ACTIONS(101),
    [aux_sym_keyword_bigint_token2] = ACTIONS(101),
    [sym_keyword_decimal] = ACTIONS(103),
    [sym_keyword_numeric] = ACTIONS(105),
    [aux_sym_keyword_real_token1] = ACTIONS(107),
    [aux_sym_keyword_real_token2] = ACTIONS(107),
    [sym_keyword_float] = ACTIONS(109),
    [sym_keyword_double] = ACTIONS(111),
    [sym_keyword_inet] = ACTIONS(79),
    [sym_keyword_money] = ACTIONS(79),
    [sym_keyword_smallmoney] = ACTIONS(79),
    [aux_sym_keyword_char_token1] = ACTIONS(113),
    [sym_keyword_nchar] = ACTIONS(115),
    [aux_sym_keyword_varchar_token1] = ACTIONS(117),
    [sym_keyword_nvarchar] = ACTIONS(119),
    [sym_keyword_text] = ACTIONS(79),
    [sym_keyword_string] = ACTIONS(79),
    [sym_keyword_uuid] = ACTIONS(79),
    [sym_keyword_json] = ACTIONS(79),
    [sym_keyword_jsonb] = ACTIONS(79),
    [sym_keyword_xml] = ACTIONS(79),
    [sym_keyword_bytea] = ACTIONS(79),
    [sym_keyword_enum] = ACTIONS(121),
    [sym_keyword_date] = ACTIONS(79),
    [sym_keyword_datetime] = ACTIONS(79),
    [sym_keyword_datetime2] = ACTIONS(79),
    [sym_keyword_smalldatetime] = ACTIONS(79),
    [sym_keyword_datetimeoffset] = ACTIONS(123),
    [aux_sym_keyword_time_token1] = ACTIONS(125),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(127),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(129),
    [sym_keyword_interval] = ACTIONS(79),
    [sym_keyword_geometry] = ACTIONS(79),
    [sym_keyword_geography] = ACTIONS(79),
    [sym_keyword_box2d] = ACTIONS(79),
    [sym_keyword_box3d] = ACTIONS(79),
    [sym_keyword_oid] = ACTIONS(79),
    [sym_keyword_name] = ACTIONS(79),
    [sym_keyword_regclass] = ACTIONS(79),
    [sym_keyword_regnamespace] = ACTIONS(79),
    [sym_keyword_regproc] = ACTIONS(79),
    [sym_keyword_regtype] = ACTIONS(79),
    [aux_sym_double_token1] = ACTIONS(131),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [12] = {
    [sym_keyword_smallserial] = STATE(808),
    [sym_keyword_serial] = STATE(808),
    [sym_keyword_bigserial] = STATE(808),
    [sym_keyword_tinyint] = STATE(795),
    [sym_keyword_smallint] = STATE(805),
    [sym_keyword_mediumint] = STATE(807),
    [sym_keyword_int] = STATE(791),
    [sym_keyword_bigint] = STATE(792),
    [sym_keyword_real] = STATE(801),
    [sym_keyword_char] = STATE(916),
    [sym_keyword_varchar] = STATE(918),
    [sym_keyword_time] = STATE(919),
    [sym_keyword_timestamp] = STATE(808),
    [sym_keyword_timestamptz] = STATE(808),
    [sym__type] = STATE(1681),
    [sym_tinyint] = STATE(808),
    [sym_smallint] = STATE(808),
    [sym_mediumint] = STATE(808),
    [sym_int] = STATE(808),
    [sym_bigint] = STATE(808),
    [sym_bit] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_varbinary] = STATE(808),
    [sym_float] = STATE(808),
    [sym_double] = STATE(808),
    [sym_decimal] = STATE(808),
    [sym_numeric] = STATE(808),
    [sym_char] = STATE(808),
    [sym_varchar] = STATE(808),
    [sym_nchar] = STATE(808),
    [sym_nvarchar] = STATE(808),
    [sym_datetimeoffset] = STATE(808),
    [sym_time] = STATE(808),
    [sym_enum] = STATE(808),
    [sym_comment] = STATE(12),
    [sym_marginalia] = STATE(12),
    [sym__identifier] = ACTIONS(67),
    [sym_keyword_table] = ACTIONS(139),
    [aux_sym_keyword_character_token1] = ACTIONS(71),
    [sym_keyword_unsigned] = ACTIONS(73),
    [sym_keyword_trigger] = ACTIONS(141),
    [sym_keyword_setof] = ACTIONS(143),
    [sym_keyword_boolean] = ACTIONS(79),
    [sym_keyword_bit] = ACTIONS(81),
    [sym_keyword_binary] = ACTIONS(83),
    [sym_keyword_varbinary] = ACTIONS(85),
    [sym_keyword_image] = ACTIONS(79),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(87),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(87),
    [aux_sym_keyword_serial_token1] = ACTIONS(89),
    [aux_sym_keyword_serial_token2] = ACTIONS(89),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(91),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(91),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(93),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(93),
    [aux_sym_keyword_smallint_token1] = ACTIONS(95),
    [aux_sym_keyword_smallint_token2] = ACTIONS(95),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(97),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(97),
    [aux_sym_keyword_int_token1] = ACTIONS(99),
    [aux_sym_keyword_int_token2] = ACTIONS(99),
    [aux_sym_keyword_int_token3] = ACTIONS(99),
    [aux_sym_keyword_bigint_token1] = ACTIONS(101),
    [aux_sym_keyword_bigint_token2] = ACTIONS(101),
    [sym_keyword_decimal] = ACTIONS(103),
    [sym_keyword_numeric] = ACTIONS(105),
    [aux_sym_keyword_real_token1] = ACTIONS(107),
    [aux_sym_keyword_real_token2] = ACTIONS(107),
    [sym_keyword_float] = ACTIONS(109),
    [sym_keyword_double] = ACTIONS(111),
    [sym_keyword_inet] = ACTIONS(79),
    [sym_keyword_money] = ACTIONS(79),
    [sym_keyword_smallmoney] = ACTIONS(79),
    [aux_sym_keyword_char_token1] = ACTIONS(113),
    [sym_keyword_nchar] = ACTIONS(115),
    [aux_sym_keyword_varchar_token1] = ACTIONS(117),
    [sym_keyword_nvarchar] = ACTIONS(119),
    [sym_keyword_text] = ACTIONS(79),
    [sym_keyword_string] = ACTIONS(79),
    [sym_keyword_uuid] = ACTIONS(79),
    [sym_keyword_json] = ACTIONS(79),
    [sym_keyword_jsonb] = ACTIONS(79),
    [sym_keyword_xml] = ACTIONS(79),
    [sym_keyword_bytea] = ACTIONS(79),
    [sym_keyword_enum] = ACTIONS(121),
    [sym_keyword_date] = ACTIONS(79),
    [sym_keyword_datetime] = ACTIONS(79),
    [sym_keyword_datetime2] = ACTIONS(79),
    [sym_keyword_smalldatetime] = ACTIONS(79),
    [sym_keyword_datetimeoffset] = ACTIONS(123),
    [aux_sym_keyword_time_token1] = ACTIONS(125),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(127),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(129),
    [sym_keyword_interval] = ACTIONS(79),
    [sym_keyword_geometry] = ACTIONS(79),
    [sym_keyword_geography] = ACTIONS(79),
    [sym_keyword_box2d] = ACTIONS(79),
    [sym_keyword_box3d] = ACTIONS(79),
    [sym_keyword_oid] = ACTIONS(79),
    [sym_keyword_name] = ACTIONS(79),
    [sym_keyword_regclass] = ACTIONS(79),
    [sym_keyword_regnamespace] = ACTIONS(79),
    [sym_keyword_regproc] = ACTIONS(79),
    [sym_keyword_regtype] = ACTIONS(79),
    [aux_sym_double_token1] = ACTIONS(131),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [13] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(2059),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(13),
    [sym_marginalia] = STATE(13),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [14] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(2127),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(14),
    [sym_marginalia] = STATE(14),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [15] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(4281),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(15),
    [sym_marginalia] = STATE(15),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [16] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(1895),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(16),
    [sym_marginalia] = STATE(16),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [17] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(3766),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(17),
    [sym_marginalia] = STATE(17),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [18] = {
    [sym_keyword_smallserial] = STATE(808),
    [sym_keyword_serial] = STATE(808),
    [sym_keyword_bigserial] = STATE(808),
    [sym_keyword_tinyint] = STATE(795),
    [sym_keyword_smallint] = STATE(805),
    [sym_keyword_mediumint] = STATE(807),
    [sym_keyword_int] = STATE(791),
    [sym_keyword_bigint] = STATE(792),
    [sym_keyword_real] = STATE(801),
    [sym_keyword_char] = STATE(916),
    [sym_keyword_varchar] = STATE(918),
    [sym_keyword_time] = STATE(919),
    [sym_keyword_timestamp] = STATE(808),
    [sym_keyword_timestamptz] = STATE(808),
    [sym__type] = STATE(1571),
    [sym_tinyint] = STATE(808),
    [sym_smallint] = STATE(808),
    [sym_mediumint] = STATE(808),
    [sym_int] = STATE(808),
    [sym_bigint] = STATE(808),
    [sym_bit] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_varbinary] = STATE(808),
    [sym_float] = STATE(808),
    [sym_double] = STATE(808),
    [sym_decimal] = STATE(808),
    [sym_numeric] = STATE(808),
    [sym_char] = STATE(808),
    [sym_varchar] = STATE(808),
    [sym_nchar] = STATE(808),
    [sym_nvarchar] = STATE(808),
    [sym_datetimeoffset] = STATE(808),
    [sym_time] = STATE(808),
    [sym_enum] = STATE(808),
    [sym_comment] = STATE(18),
    [sym_marginalia] = STATE(18),
    [sym__identifier] = ACTIONS(67),
    [aux_sym_keyword_character_token1] = ACTIONS(71),
    [sym_keyword_unsigned] = ACTIONS(73),
    [sym_keyword_boolean] = ACTIONS(79),
    [sym_keyword_bit] = ACTIONS(81),
    [sym_keyword_binary] = ACTIONS(83),
    [sym_keyword_varbinary] = ACTIONS(85),
    [sym_keyword_image] = ACTIONS(79),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(87),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(87),
    [aux_sym_keyword_serial_token1] = ACTIONS(89),
    [aux_sym_keyword_serial_token2] = ACTIONS(89),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(91),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(91),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(93),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(93),
    [aux_sym_keyword_smallint_token1] = ACTIONS(95),
    [aux_sym_keyword_smallint_token2] = ACTIONS(95),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(97),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(97),
    [aux_sym_keyword_int_token1] = ACTIONS(99),
    [aux_sym_keyword_int_token2] = ACTIONS(99),
    [aux_sym_keyword_int_token3] = ACTIONS(99),
    [aux_sym_keyword_bigint_token1] = ACTIONS(101),
    [aux_sym_keyword_bigint_token2] = ACTIONS(101),
    [sym_keyword_decimal] = ACTIONS(103),
    [sym_keyword_numeric] = ACTIONS(105),
    [aux_sym_keyword_real_token1] = ACTIONS(107),
    [aux_sym_keyword_real_token2] = ACTIONS(107),
    [sym_keyword_float] = ACTIONS(109),
    [sym_keyword_double] = ACTIONS(111),
    [sym_keyword_inet] = ACTIONS(79),
    [sym_keyword_money] = ACTIONS(79),
    [sym_keyword_smallmoney] = ACTIONS(79),
    [aux_sym_keyword_char_token1] = ACTIONS(113),
    [sym_keyword_nchar] = ACTIONS(115),
    [aux_sym_keyword_varchar_token1] = ACTIONS(117),
    [sym_keyword_nvarchar] = ACTIONS(119),
    [sym_keyword_text] = ACTIONS(79),
    [sym_keyword_string] = ACTIONS(79),
    [sym_keyword_uuid] = ACTIONS(79),
    [sym_keyword_json] = ACTIONS(79),
    [sym_keyword_jsonb] = ACTIONS(79),
    [sym_keyword_xml] = ACTIONS(79),
    [sym_keyword_bytea] = ACTIONS(79),
    [sym_keyword_enum] = ACTIONS(121),
    [sym_keyword_date] = ACTIONS(79),
    [sym_keyword_datetime] = ACTIONS(79),
    [sym_keyword_datetime2] = ACTIONS(79),
    [sym_keyword_smalldatetime] = ACTIONS(79),
    [sym_keyword_datetimeoffset] = ACTIONS(123),
    [aux_sym_keyword_time_token1] = ACTIONS(125),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(127),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(129),
    [sym_keyword_interval] = ACTIONS(79),
    [sym_keyword_geometry] = ACTIONS(79),
    [sym_keyword_geography] = ACTIONS(79),
    [sym_keyword_box2d] = ACTIONS(79),
    [sym_keyword_box3d] = ACTIONS(79),
    [sym_keyword_oid] = ACTIONS(79),
    [sym_keyword_name] = ACTIONS(79),
    [sym_keyword_regclass] = ACTIONS(79),
    [sym_keyword_regnamespace] = ACTIONS(79),
    [sym_keyword_regproc] = ACTIONS(79),
    [sym_keyword_regtype] = ACTIONS(79),
    [aux_sym_double_token1] = ACTIONS(131),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [19] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(2473),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(19),
    [sym_marginalia] = STATE(19),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [20] = {
    [sym_keyword_smallserial] = STATE(808),
    [sym_keyword_serial] = STATE(808),
    [sym_keyword_bigserial] = STATE(808),
    [sym_keyword_tinyint] = STATE(795),
    [sym_keyword_smallint] = STATE(805),
    [sym_keyword_mediumint] = STATE(807),
    [sym_keyword_int] = STATE(791),
    [sym_keyword_bigint] = STATE(792),
    [sym_keyword_real] = STATE(801),
    [sym_keyword_char] = STATE(916),
    [sym_keyword_varchar] = STATE(918),
    [sym_keyword_time] = STATE(919),
    [sym_keyword_timestamp] = STATE(808),
    [sym_keyword_timestamptz] = STATE(808),
    [sym__type] = STATE(1675),
    [sym_tinyint] = STATE(808),
    [sym_smallint] = STATE(808),
    [sym_mediumint] = STATE(808),
    [sym_int] = STATE(808),
    [sym_bigint] = STATE(808),
    [sym_bit] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_varbinary] = STATE(808),
    [sym_float] = STATE(808),
    [sym_double] = STATE(808),
    [sym_decimal] = STATE(808),
    [sym_numeric] = STATE(808),
    [sym_char] = STATE(808),
    [sym_varchar] = STATE(808),
    [sym_nchar] = STATE(808),
    [sym_nvarchar] = STATE(808),
    [sym_datetimeoffset] = STATE(808),
    [sym_time] = STATE(808),
    [sym_enum] = STATE(808),
    [sym_comment] = STATE(20),
    [sym_marginalia] = STATE(20),
    [sym__identifier] = ACTIONS(67),
    [aux_sym_keyword_character_token1] = ACTIONS(71),
    [sym_keyword_unsigned] = ACTIONS(73),
    [sym_keyword_boolean] = ACTIONS(79),
    [sym_keyword_bit] = ACTIONS(81),
    [sym_keyword_binary] = ACTIONS(83),
    [sym_keyword_varbinary] = ACTIONS(85),
    [sym_keyword_image] = ACTIONS(79),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(87),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(87),
    [aux_sym_keyword_serial_token1] = ACTIONS(89),
    [aux_sym_keyword_serial_token2] = ACTIONS(89),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(91),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(91),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(93),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(93),
    [aux_sym_keyword_smallint_token1] = ACTIONS(95),
    [aux_sym_keyword_smallint_token2] = ACTIONS(95),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(97),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(97),
    [aux_sym_keyword_int_token1] = ACTIONS(99),
    [aux_sym_keyword_int_token2] = ACTIONS(99),
    [aux_sym_keyword_int_token3] = ACTIONS(99),
    [aux_sym_keyword_bigint_token1] = ACTIONS(101),
    [aux_sym_keyword_bigint_token2] = ACTIONS(101),
    [sym_keyword_decimal] = ACTIONS(103),
    [sym_keyword_numeric] = ACTIONS(105),
    [aux_sym_keyword_real_token1] = ACTIONS(107),
    [aux_sym_keyword_real_token2] = ACTIONS(107),
    [sym_keyword_float] = ACTIONS(109),
    [sym_keyword_double] = ACTIONS(111),
    [sym_keyword_inet] = ACTIONS(79),
    [sym_keyword_money] = ACTIONS(79),
    [sym_keyword_smallmoney] = ACTIONS(79),
    [aux_sym_keyword_char_token1] = ACTIONS(113),
    [sym_keyword_nchar] = ACTIONS(115),
    [aux_sym_keyword_varchar_token1] = ACTIONS(117),
    [sym_keyword_nvarchar] = ACTIONS(119),
    [sym_keyword_text] = ACTIONS(79),
    [sym_keyword_string] = ACTIONS(79),
    [sym_keyword_uuid] = ACTIONS(79),
    [sym_keyword_json] = ACTIONS(79),
    [sym_keyword_jsonb] = ACTIONS(79),
    [sym_keyword_xml] = ACTIONS(79),
    [sym_keyword_bytea] = ACTIONS(79),
    [sym_keyword_enum] = ACTIONS(121),
    [sym_keyword_date] = ACTIONS(79),
    [sym_keyword_datetime] = ACTIONS(79),
    [sym_keyword_datetime2] = ACTIONS(79),
    [sym_keyword_smalldatetime] = ACTIONS(79),
    [sym_keyword_datetimeoffset] = ACTIONS(123),
    [aux_sym_keyword_time_token1] = ACTIONS(125),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(127),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(129),
    [sym_keyword_interval] = ACTIONS(79),
    [sym_keyword_geometry] = ACTIONS(79),
    [sym_keyword_geography] = ACTIONS(79),
    [sym_keyword_box2d] = ACTIONS(79),
    [sym_keyword_box3d] = ACTIONS(79),
    [sym_keyword_oid] = ACTIONS(79),
    [sym_keyword_name] = ACTIONS(79),
    [sym_keyword_regclass] = ACTIONS(79),
    [sym_keyword_regnamespace] = ACTIONS(79),
    [sym_keyword_regproc] = ACTIONS(79),
    [sym_keyword_regtype] = ACTIONS(79),
    [aux_sym_double_token1] = ACTIONS(131),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [21] = {
    [sym_keyword_smallserial] = STATE(218),
    [sym_keyword_serial] = STATE(218),
    [sym_keyword_bigserial] = STATE(218),
    [sym_keyword_tinyint] = STATE(208),
    [sym_keyword_smallint] = STATE(207),
    [sym_keyword_mediumint] = STATE(212),
    [sym_keyword_int] = STATE(213),
    [sym_keyword_bigint] = STATE(214),
    [sym_keyword_real] = STATE(215),
    [sym_keyword_char] = STATE(265),
    [sym_keyword_varchar] = STATE(266),
    [sym_keyword_time] = STATE(267),
    [sym_keyword_timestamp] = STATE(218),
    [sym_keyword_timestamptz] = STATE(218),
    [sym__type] = STATE(1670),
    [sym_tinyint] = STATE(218),
    [sym_smallint] = STATE(218),
    [sym_mediumint] = STATE(218),
    [sym_int] = STATE(218),
    [sym_bigint] = STATE(218),
    [sym_bit] = STATE(218),
    [sym_binary] = STATE(218),
    [sym_varbinary] = STATE(218),
    [sym_float] = STATE(218),
    [sym_double] = STATE(218),
    [sym_decimal] = STATE(218),
    [sym_numeric] = STATE(218),
    [sym_char] = STATE(218),
    [sym_varchar] = STATE(218),
    [sym_nchar] = STATE(218),
    [sym_nvarchar] = STATE(218),
    [sym_datetimeoffset] = STATE(218),
    [sym_time] = STATE(218),
    [sym_enum] = STATE(218),
    [sym_comment] = STATE(21),
    [sym_marginalia] = STATE(21),
    [sym__identifier] = ACTIONS(205),
    [aux_sym_keyword_character_token1] = ACTIONS(207),
    [sym_keyword_unsigned] = ACTIONS(209),
    [sym_keyword_boolean] = ACTIONS(211),
    [sym_keyword_bit] = ACTIONS(213),
    [sym_keyword_binary] = ACTIONS(215),
    [sym_keyword_varbinary] = ACTIONS(217),
    [sym_keyword_image] = ACTIONS(211),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(219),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(219),
    [aux_sym_keyword_serial_token1] = ACTIONS(221),
    [aux_sym_keyword_serial_token2] = ACTIONS(221),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(223),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(223),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(225),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(225),
    [aux_sym_keyword_smallint_token1] = ACTIONS(227),
    [aux_sym_keyword_smallint_token2] = ACTIONS(227),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(229),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(229),
    [aux_sym_keyword_int_token1] = ACTIONS(231),
    [aux_sym_keyword_int_token2] = ACTIONS(231),
    [aux_sym_keyword_int_token3] = ACTIONS(231),
    [aux_sym_keyword_bigint_token1] = ACTIONS(233),
    [aux_sym_keyword_bigint_token2] = ACTIONS(233),
    [sym_keyword_decimal] = ACTIONS(235),
    [sym_keyword_numeric] = ACTIONS(237),
    [aux_sym_keyword_real_token1] = ACTIONS(239),
    [aux_sym_keyword_real_token2] = ACTIONS(239),
    [sym_keyword_float] = ACTIONS(241),
    [sym_keyword_double] = ACTIONS(243),
    [sym_keyword_inet] = ACTIONS(211),
    [sym_keyword_money] = ACTIONS(211),
    [sym_keyword_smallmoney] = ACTIONS(211),
    [aux_sym_keyword_char_token1] = ACTIONS(245),
    [sym_keyword_nchar] = ACTIONS(247),
    [aux_sym_keyword_varchar_token1] = ACTIONS(249),
    [sym_keyword_nvarchar] = ACTIONS(251),
    [sym_keyword_text] = ACTIONS(211),
    [sym_keyword_string] = ACTIONS(211),
    [sym_keyword_uuid] = ACTIONS(211),
    [sym_keyword_json] = ACTIONS(211),
    [sym_keyword_jsonb] = ACTIONS(211),
    [sym_keyword_xml] = ACTIONS(211),
    [sym_keyword_bytea] = ACTIONS(211),
    [sym_keyword_enum] = ACTIONS(253),
    [sym_keyword_date] = ACTIONS(211),
    [sym_keyword_datetime] = ACTIONS(211),
    [sym_keyword_datetime2] = ACTIONS(211),
    [sym_keyword_smalldatetime] = ACTIONS(211),
    [sym_keyword_datetimeoffset] = ACTIONS(255),
    [aux_sym_keyword_time_token1] = ACTIONS(257),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(259),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(261),
    [sym_keyword_interval] = ACTIONS(211),
    [sym_keyword_geometry] = ACTIONS(211),
    [sym_keyword_geography] = ACTIONS(211),
    [sym_keyword_box2d] = ACTIONS(211),
    [sym_keyword_box3d] = ACTIONS(211),
    [sym_keyword_oid] = ACTIONS(211),
    [sym_keyword_name] = ACTIONS(211),
    [sym_keyword_regclass] = ACTIONS(211),
    [sym_keyword_regnamespace] = ACTIONS(211),
    [sym_keyword_regproc] = ACTIONS(211),
    [sym_keyword_regtype] = ACTIONS(211),
    [aux_sym_double_token1] = ACTIONS(263),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [22] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(2544),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(22),
    [sym_marginalia] = STATE(22),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [23] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(649),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(23),
    [sym_marginalia] = STATE(23),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [24] = {
    [sym_keyword_smallserial] = STATE(423),
    [sym_keyword_serial] = STATE(423),
    [sym_keyword_bigserial] = STATE(423),
    [sym_keyword_tinyint] = STATE(454),
    [sym_keyword_smallint] = STATE(460),
    [sym_keyword_mediumint] = STATE(409),
    [sym_keyword_int] = STATE(440),
    [sym_keyword_bigint] = STATE(439),
    [sym_keyword_real] = STATE(438),
    [sym_keyword_char] = STATE(537),
    [sym_keyword_varchar] = STATE(534),
    [sym_keyword_time] = STATE(532),
    [sym_keyword_timestamp] = STATE(423),
    [sym_keyword_timestamptz] = STATE(423),
    [sym__type] = STATE(710),
    [sym_tinyint] = STATE(423),
    [sym_smallint] = STATE(423),
    [sym_mediumint] = STATE(423),
    [sym_int] = STATE(423),
    [sym_bigint] = STATE(423),
    [sym_bit] = STATE(423),
    [sym_binary] = STATE(423),
    [sym_varbinary] = STATE(423),
    [sym_float] = STATE(423),
    [sym_double] = STATE(423),
    [sym_decimal] = STATE(423),
    [sym_numeric] = STATE(423),
    [sym_char] = STATE(423),
    [sym_varchar] = STATE(423),
    [sym_nchar] = STATE(423),
    [sym_nvarchar] = STATE(423),
    [sym_datetimeoffset] = STATE(423),
    [sym_time] = STATE(423),
    [sym_enum] = STATE(423),
    [sym_comment] = STATE(24),
    [sym_marginalia] = STATE(24),
    [sym__identifier] = ACTIONS(265),
    [aux_sym_keyword_character_token1] = ACTIONS(267),
    [sym_keyword_unsigned] = ACTIONS(269),
    [sym_keyword_boolean] = ACTIONS(271),
    [sym_keyword_bit] = ACTIONS(273),
    [sym_keyword_binary] = ACTIONS(275),
    [sym_keyword_varbinary] = ACTIONS(277),
    [sym_keyword_image] = ACTIONS(271),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(279),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(279),
    [aux_sym_keyword_serial_token1] = ACTIONS(281),
    [aux_sym_keyword_serial_token2] = ACTIONS(281),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(283),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(283),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(285),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(285),
    [aux_sym_keyword_smallint_token1] = ACTIONS(287),
    [aux_sym_keyword_smallint_token2] = ACTIONS(287),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(289),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(289),
    [aux_sym_keyword_int_token1] = ACTIONS(291),
    [aux_sym_keyword_int_token2] = ACTIONS(291),
    [aux_sym_keyword_int_token3] = ACTIONS(291),
    [aux_sym_keyword_bigint_token1] = ACTIONS(293),
    [aux_sym_keyword_bigint_token2] = ACTIONS(293),
    [sym_keyword_decimal] = ACTIONS(295),
    [sym_keyword_numeric] = ACTIONS(297),
    [aux_sym_keyword_real_token1] = ACTIONS(299),
    [aux_sym_keyword_real_token2] = ACTIONS(299),
    [sym_keyword_float] = ACTIONS(301),
    [sym_keyword_double] = ACTIONS(303),
    [sym_keyword_inet] = ACTIONS(271),
    [sym_keyword_money] = ACTIONS(271),
    [sym_keyword_smallmoney] = ACTIONS(271),
    [aux_sym_keyword_char_token1] = ACTIONS(305),
    [sym_keyword_nchar] = ACTIONS(307),
    [aux_sym_keyword_varchar_token1] = ACTIONS(309),
    [sym_keyword_nvarchar] = ACTIONS(311),
    [sym_keyword_text] = ACTIONS(271),
    [sym_keyword_string] = ACTIONS(271),
    [sym_keyword_uuid] = ACTIONS(271),
    [sym_keyword_json] = ACTIONS(271),
    [sym_keyword_jsonb] = ACTIONS(271),
    [sym_keyword_xml] = ACTIONS(271),
    [sym_keyword_bytea] = ACTIONS(271),
    [sym_keyword_enum] = ACTIONS(313),
    [sym_keyword_date] = ACTIONS(271),
    [sym_keyword_datetime] = ACTIONS(271),
    [sym_keyword_datetime2] = ACTIONS(271),
    [sym_keyword_smalldatetime] = ACTIONS(271),
    [sym_keyword_datetimeoffset] = ACTIONS(315),
    [aux_sym_keyword_time_token1] = ACTIONS(317),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(319),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(321),
    [sym_keyword_interval] = ACTIONS(271),
    [sym_keyword_geometry] = ACTIONS(271),
    [sym_keyword_geography] = ACTIONS(271),
    [sym_keyword_box2d] = ACTIONS(271),
    [sym_keyword_box3d] = ACTIONS(271),
    [sym_keyword_oid] = ACTIONS(271),
    [sym_keyword_name] = ACTIONS(271),
    [sym_keyword_regclass] = ACTIONS(271),
    [sym_keyword_regnamespace] = ACTIONS(271),
    [sym_keyword_regproc] = ACTIONS(271),
    [sym_keyword_regtype] = ACTIONS(271),
    [aux_sym_double_token1] = ACTIONS(323),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [25] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(3860),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(25),
    [sym_marginalia] = STATE(25),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [26] = {
    [sym_keyword_smallserial] = STATE(808),
    [sym_keyword_serial] = STATE(808),
    [sym_keyword_bigserial] = STATE(808),
    [sym_keyword_tinyint] = STATE(795),
    [sym_keyword_smallint] = STATE(805),
    [sym_keyword_mediumint] = STATE(807),
    [sym_keyword_int] = STATE(791),
    [sym_keyword_bigint] = STATE(792),
    [sym_keyword_real] = STATE(801),
    [sym_keyword_char] = STATE(916),
    [sym_keyword_varchar] = STATE(918),
    [sym_keyword_time] = STATE(919),
    [sym_keyword_timestamp] = STATE(808),
    [sym_keyword_timestamptz] = STATE(808),
    [sym__type] = STATE(1683),
    [sym_tinyint] = STATE(808),
    [sym_smallint] = STATE(808),
    [sym_mediumint] = STATE(808),
    [sym_int] = STATE(808),
    [sym_bigint] = STATE(808),
    [sym_bit] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_varbinary] = STATE(808),
    [sym_float] = STATE(808),
    [sym_double] = STATE(808),
    [sym_decimal] = STATE(808),
    [sym_numeric] = STATE(808),
    [sym_char] = STATE(808),
    [sym_varchar] = STATE(808),
    [sym_nchar] = STATE(808),
    [sym_nvarchar] = STATE(808),
    [sym_datetimeoffset] = STATE(808),
    [sym_time] = STATE(808),
    [sym_enum] = STATE(808),
    [sym_comment] = STATE(26),
    [sym_marginalia] = STATE(26),
    [sym__identifier] = ACTIONS(67),
    [aux_sym_keyword_character_token1] = ACTIONS(71),
    [sym_keyword_unsigned] = ACTIONS(73),
    [sym_keyword_boolean] = ACTIONS(79),
    [sym_keyword_bit] = ACTIONS(81),
    [sym_keyword_binary] = ACTIONS(83),
    [sym_keyword_varbinary] = ACTIONS(85),
    [sym_keyword_image] = ACTIONS(79),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(87),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(87),
    [aux_sym_keyword_serial_token1] = ACTIONS(89),
    [aux_sym_keyword_serial_token2] = ACTIONS(89),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(91),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(91),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(93),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(93),
    [aux_sym_keyword_smallint_token1] = ACTIONS(95),
    [aux_sym_keyword_smallint_token2] = ACTIONS(95),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(97),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(97),
    [aux_sym_keyword_int_token1] = ACTIONS(99),
    [aux_sym_keyword_int_token2] = ACTIONS(99),
    [aux_sym_keyword_int_token3] = ACTIONS(99),
    [aux_sym_keyword_bigint_token1] = ACTIONS(101),
    [aux_sym_keyword_bigint_token2] = ACTIONS(101),
    [sym_keyword_decimal] = ACTIONS(103),
    [sym_keyword_numeric] = ACTIONS(105),
    [aux_sym_keyword_real_token1] = ACTIONS(107),
    [aux_sym_keyword_real_token2] = ACTIONS(107),
    [sym_keyword_float] = ACTIONS(109),
    [sym_keyword_double] = ACTIONS(111),
    [sym_keyword_inet] = ACTIONS(79),
    [sym_keyword_money] = ACTIONS(79),
    [sym_keyword_smallmoney] = ACTIONS(79),
    [aux_sym_keyword_char_token1] = ACTIONS(113),
    [sym_keyword_nchar] = ACTIONS(115),
    [aux_sym_keyword_varchar_token1] = ACTIONS(117),
    [sym_keyword_nvarchar] = ACTIONS(119),
    [sym_keyword_text] = ACTIONS(79),
    [sym_keyword_string] = ACTIONS(79),
    [sym_keyword_uuid] = ACTIONS(79),
    [sym_keyword_json] = ACTIONS(79),
    [sym_keyword_jsonb] = ACTIONS(79),
    [sym_keyword_xml] = ACTIONS(79),
    [sym_keyword_bytea] = ACTIONS(79),
    [sym_keyword_enum] = ACTIONS(121),
    [sym_keyword_date] = ACTIONS(79),
    [sym_keyword_datetime] = ACTIONS(79),
    [sym_keyword_datetime2] = ACTIONS(79),
    [sym_keyword_smalldatetime] = ACTIONS(79),
    [sym_keyword_datetimeoffset] = ACTIONS(123),
    [aux_sym_keyword_time_token1] = ACTIONS(125),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(127),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(129),
    [sym_keyword_interval] = ACTIONS(79),
    [sym_keyword_geometry] = ACTIONS(79),
    [sym_keyword_geography] = ACTIONS(79),
    [sym_keyword_box2d] = ACTIONS(79),
    [sym_keyword_box3d] = ACTIONS(79),
    [sym_keyword_oid] = ACTIONS(79),
    [sym_keyword_name] = ACTIONS(79),
    [sym_keyword_regclass] = ACTIONS(79),
    [sym_keyword_regnamespace] = ACTIONS(79),
    [sym_keyword_regproc] = ACTIONS(79),
    [sym_keyword_regtype] = ACTIONS(79),
    [aux_sym_double_token1] = ACTIONS(131),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [27] = {
    [sym_keyword_smallserial] = STATE(218),
    [sym_keyword_serial] = STATE(218),
    [sym_keyword_bigserial] = STATE(218),
    [sym_keyword_tinyint] = STATE(208),
    [sym_keyword_smallint] = STATE(207),
    [sym_keyword_mediumint] = STATE(212),
    [sym_keyword_int] = STATE(213),
    [sym_keyword_bigint] = STATE(214),
    [sym_keyword_real] = STATE(215),
    [sym_keyword_char] = STATE(265),
    [sym_keyword_varchar] = STATE(266),
    [sym_keyword_time] = STATE(267),
    [sym_keyword_timestamp] = STATE(218),
    [sym_keyword_timestamptz] = STATE(218),
    [sym__type] = STATE(767),
    [sym_tinyint] = STATE(218),
    [sym_smallint] = STATE(218),
    [sym_mediumint] = STATE(218),
    [sym_int] = STATE(218),
    [sym_bigint] = STATE(218),
    [sym_bit] = STATE(218),
    [sym_binary] = STATE(218),
    [sym_varbinary] = STATE(218),
    [sym_float] = STATE(218),
    [sym_double] = STATE(218),
    [sym_decimal] = STATE(218),
    [sym_numeric] = STATE(218),
    [sym_char] = STATE(218),
    [sym_varchar] = STATE(218),
    [sym_nchar] = STATE(218),
    [sym_nvarchar] = STATE(218),
    [sym_datetimeoffset] = STATE(218),
    [sym_time] = STATE(218),
    [sym_enum] = STATE(218),
    [sym_comment] = STATE(27),
    [sym_marginalia] = STATE(27),
    [sym__identifier] = ACTIONS(205),
    [aux_sym_keyword_character_token1] = ACTIONS(207),
    [sym_keyword_unsigned] = ACTIONS(209),
    [sym_keyword_boolean] = ACTIONS(211),
    [sym_keyword_bit] = ACTIONS(213),
    [sym_keyword_binary] = ACTIONS(215),
    [sym_keyword_varbinary] = ACTIONS(217),
    [sym_keyword_image] = ACTIONS(211),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(219),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(219),
    [aux_sym_keyword_serial_token1] = ACTIONS(221),
    [aux_sym_keyword_serial_token2] = ACTIONS(221),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(223),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(223),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(225),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(225),
    [aux_sym_keyword_smallint_token1] = ACTIONS(227),
    [aux_sym_keyword_smallint_token2] = ACTIONS(227),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(229),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(229),
    [aux_sym_keyword_int_token1] = ACTIONS(231),
    [aux_sym_keyword_int_token2] = ACTIONS(231),
    [aux_sym_keyword_int_token3] = ACTIONS(231),
    [aux_sym_keyword_bigint_token1] = ACTIONS(233),
    [aux_sym_keyword_bigint_token2] = ACTIONS(233),
    [sym_keyword_decimal] = ACTIONS(235),
    [sym_keyword_numeric] = ACTIONS(237),
    [aux_sym_keyword_real_token1] = ACTIONS(239),
    [aux_sym_keyword_real_token2] = ACTIONS(239),
    [sym_keyword_float] = ACTIONS(241),
    [sym_keyword_double] = ACTIONS(243),
    [sym_keyword_inet] = ACTIONS(211),
    [sym_keyword_money] = ACTIONS(211),
    [sym_keyword_smallmoney] = ACTIONS(211),
    [aux_sym_keyword_char_token1] = ACTIONS(245),
    [sym_keyword_nchar] = ACTIONS(247),
    [aux_sym_keyword_varchar_token1] = ACTIONS(249),
    [sym_keyword_nvarchar] = ACTIONS(251),
    [sym_keyword_text] = ACTIONS(211),
    [sym_keyword_string] = ACTIONS(211),
    [sym_keyword_uuid] = ACTIONS(211),
    [sym_keyword_json] = ACTIONS(211),
    [sym_keyword_jsonb] = ACTIONS(211),
    [sym_keyword_xml] = ACTIONS(211),
    [sym_keyword_bytea] = ACTIONS(211),
    [sym_keyword_enum] = ACTIONS(253),
    [sym_keyword_date] = ACTIONS(211),
    [sym_keyword_datetime] = ACTIONS(211),
    [sym_keyword_datetime2] = ACTIONS(211),
    [sym_keyword_smalldatetime] = ACTIONS(211),
    [sym_keyword_datetimeoffset] = ACTIONS(255),
    [aux_sym_keyword_time_token1] = ACTIONS(257),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(259),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(261),
    [sym_keyword_interval] = ACTIONS(211),
    [sym_keyword_geometry] = ACTIONS(211),
    [sym_keyword_geography] = ACTIONS(211),
    [sym_keyword_box2d] = ACTIONS(211),
    [sym_keyword_box3d] = ACTIONS(211),
    [sym_keyword_oid] = ACTIONS(211),
    [sym_keyword_name] = ACTIONS(211),
    [sym_keyword_regclass] = ACTIONS(211),
    [sym_keyword_regnamespace] = ACTIONS(211),
    [sym_keyword_regproc] = ACTIONS(211),
    [sym_keyword_regtype] = ACTIONS(211),
    [aux_sym_double_token1] = ACTIONS(263),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [28] = {
    [sym_keyword_smallserial] = STATE(808),
    [sym_keyword_serial] = STATE(808),
    [sym_keyword_bigserial] = STATE(808),
    [sym_keyword_tinyint] = STATE(795),
    [sym_keyword_smallint] = STATE(805),
    [sym_keyword_mediumint] = STATE(807),
    [sym_keyword_int] = STATE(791),
    [sym_keyword_bigint] = STATE(792),
    [sym_keyword_real] = STATE(801),
    [sym_keyword_char] = STATE(916),
    [sym_keyword_varchar] = STATE(918),
    [sym_keyword_time] = STATE(919),
    [sym_keyword_timestamp] = STATE(808),
    [sym_keyword_timestamptz] = STATE(808),
    [sym__type] = STATE(767),
    [sym_tinyint] = STATE(808),
    [sym_smallint] = STATE(808),
    [sym_mediumint] = STATE(808),
    [sym_int] = STATE(808),
    [sym_bigint] = STATE(808),
    [sym_bit] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_varbinary] = STATE(808),
    [sym_float] = STATE(808),
    [sym_double] = STATE(808),
    [sym_decimal] = STATE(808),
    [sym_numeric] = STATE(808),
    [sym_char] = STATE(808),
    [sym_varchar] = STATE(808),
    [sym_nchar] = STATE(808),
    [sym_nvarchar] = STATE(808),
    [sym_datetimeoffset] = STATE(808),
    [sym_time] = STATE(808),
    [sym_enum] = STATE(808),
    [sym_comment] = STATE(28),
    [sym_marginalia] = STATE(28),
    [sym__identifier] = ACTIONS(67),
    [aux_sym_keyword_character_token1] = ACTIONS(71),
    [sym_keyword_unsigned] = ACTIONS(73),
    [sym_keyword_boolean] = ACTIONS(79),
    [sym_keyword_bit] = ACTIONS(81),
    [sym_keyword_binary] = ACTIONS(83),
    [sym_keyword_varbinary] = ACTIONS(85),
    [sym_keyword_image] = ACTIONS(79),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(87),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(87),
    [aux_sym_keyword_serial_token1] = ACTIONS(89),
    [aux_sym_keyword_serial_token2] = ACTIONS(89),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(91),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(91),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(93),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(93),
    [aux_sym_keyword_smallint_token1] = ACTIONS(95),
    [aux_sym_keyword_smallint_token2] = ACTIONS(95),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(97),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(97),
    [aux_sym_keyword_int_token1] = ACTIONS(99),
    [aux_sym_keyword_int_token2] = ACTIONS(99),
    [aux_sym_keyword_int_token3] = ACTIONS(99),
    [aux_sym_keyword_bigint_token1] = ACTIONS(101),
    [aux_sym_keyword_bigint_token2] = ACTIONS(101),
    [sym_keyword_decimal] = ACTIONS(103),
    [sym_keyword_numeric] = ACTIONS(105),
    [aux_sym_keyword_real_token1] = ACTIONS(107),
    [aux_sym_keyword_real_token2] = ACTIONS(107),
    [sym_keyword_float] = ACTIONS(109),
    [sym_keyword_double] = ACTIONS(111),
    [sym_keyword_inet] = ACTIONS(79),
    [sym_keyword_money] = ACTIONS(79),
    [sym_keyword_smallmoney] = ACTIONS(79),
    [aux_sym_keyword_char_token1] = ACTIONS(113),
    [sym_keyword_nchar] = ACTIONS(115),
    [aux_sym_keyword_varchar_token1] = ACTIONS(117),
    [sym_keyword_nvarchar] = ACTIONS(119),
    [sym_keyword_text] = ACTIONS(79),
    [sym_keyword_string] = ACTIONS(79),
    [sym_keyword_uuid] = ACTIONS(79),
    [sym_keyword_json] = ACTIONS(79),
    [sym_keyword_jsonb] = ACTIONS(79),
    [sym_keyword_xml] = ACTIONS(79),
    [sym_keyword_bytea] = ACTIONS(79),
    [sym_keyword_enum] = ACTIONS(121),
    [sym_keyword_date] = ACTIONS(79),
    [sym_keyword_datetime] = ACTIONS(79),
    [sym_keyword_datetime2] = ACTIONS(79),
    [sym_keyword_smalldatetime] = ACTIONS(79),
    [sym_keyword_datetimeoffset] = ACTIONS(123),
    [aux_sym_keyword_time_token1] = ACTIONS(125),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(127),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(129),
    [sym_keyword_interval] = ACTIONS(79),
    [sym_keyword_geometry] = ACTIONS(79),
    [sym_keyword_geography] = ACTIONS(79),
    [sym_keyword_box2d] = ACTIONS(79),
    [sym_keyword_box3d] = ACTIONS(79),
    [sym_keyword_oid] = ACTIONS(79),
    [sym_keyword_name] = ACTIONS(79),
    [sym_keyword_regclass] = ACTIONS(79),
    [sym_keyword_regnamespace] = ACTIONS(79),
    [sym_keyword_regproc] = ACTIONS(79),
    [sym_keyword_regtype] = ACTIONS(79),
    [aux_sym_double_token1] = ACTIONS(131),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [29] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(1907),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(29),
    [sym_marginalia] = STATE(29),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [30] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(2118),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(30),
    [sym_marginalia] = STATE(30),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [31] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(3751),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(31),
    [sym_marginalia] = STATE(31),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [32] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(3941),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(32),
    [sym_marginalia] = STATE(32),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [33] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(2655),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(33),
    [sym_marginalia] = STATE(33),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [34] = {
    [sym_keyword_smallserial] = STATE(808),
    [sym_keyword_serial] = STATE(808),
    [sym_keyword_bigserial] = STATE(808),
    [sym_keyword_tinyint] = STATE(795),
    [sym_keyword_smallint] = STATE(805),
    [sym_keyword_mediumint] = STATE(807),
    [sym_keyword_int] = STATE(791),
    [sym_keyword_bigint] = STATE(792),
    [sym_keyword_real] = STATE(801),
    [sym_keyword_char] = STATE(916),
    [sym_keyword_varchar] = STATE(918),
    [sym_keyword_time] = STATE(919),
    [sym_keyword_timestamp] = STATE(808),
    [sym_keyword_timestamptz] = STATE(808),
    [sym__type] = STATE(1681),
    [sym_tinyint] = STATE(808),
    [sym_smallint] = STATE(808),
    [sym_mediumint] = STATE(808),
    [sym_int] = STATE(808),
    [sym_bigint] = STATE(808),
    [sym_bit] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_varbinary] = STATE(808),
    [sym_float] = STATE(808),
    [sym_double] = STATE(808),
    [sym_decimal] = STATE(808),
    [sym_numeric] = STATE(808),
    [sym_char] = STATE(808),
    [sym_varchar] = STATE(808),
    [sym_nchar] = STATE(808),
    [sym_nvarchar] = STATE(808),
    [sym_datetimeoffset] = STATE(808),
    [sym_time] = STATE(808),
    [sym_enum] = STATE(808),
    [sym_comment] = STATE(34),
    [sym_marginalia] = STATE(34),
    [sym__identifier] = ACTIONS(67),
    [aux_sym_keyword_character_token1] = ACTIONS(71),
    [sym_keyword_unsigned] = ACTIONS(73),
    [sym_keyword_boolean] = ACTIONS(79),
    [sym_keyword_bit] = ACTIONS(81),
    [sym_keyword_binary] = ACTIONS(83),
    [sym_keyword_varbinary] = ACTIONS(85),
    [sym_keyword_image] = ACTIONS(79),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(87),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(87),
    [aux_sym_keyword_serial_token1] = ACTIONS(89),
    [aux_sym_keyword_serial_token2] = ACTIONS(89),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(91),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(91),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(93),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(93),
    [aux_sym_keyword_smallint_token1] = ACTIONS(95),
    [aux_sym_keyword_smallint_token2] = ACTIONS(95),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(97),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(97),
    [aux_sym_keyword_int_token1] = ACTIONS(99),
    [aux_sym_keyword_int_token2] = ACTIONS(99),
    [aux_sym_keyword_int_token3] = ACTIONS(99),
    [aux_sym_keyword_bigint_token1] = ACTIONS(101),
    [aux_sym_keyword_bigint_token2] = ACTIONS(101),
    [sym_keyword_decimal] = ACTIONS(103),
    [sym_keyword_numeric] = ACTIONS(105),
    [aux_sym_keyword_real_token1] = ACTIONS(107),
    [aux_sym_keyword_real_token2] = ACTIONS(107),
    [sym_keyword_float] = ACTIONS(109),
    [sym_keyword_double] = ACTIONS(111),
    [sym_keyword_inet] = ACTIONS(79),
    [sym_keyword_money] = ACTIONS(79),
    [sym_keyword_smallmoney] = ACTIONS(79),
    [aux_sym_keyword_char_token1] = ACTIONS(113),
    [sym_keyword_nchar] = ACTIONS(115),
    [aux_sym_keyword_varchar_token1] = ACTIONS(117),
    [sym_keyword_nvarchar] = ACTIONS(119),
    [sym_keyword_text] = ACTIONS(79),
    [sym_keyword_string] = ACTIONS(79),
    [sym_keyword_uuid] = ACTIONS(79),
    [sym_keyword_json] = ACTIONS(79),
    [sym_keyword_jsonb] = ACTIONS(79),
    [sym_keyword_xml] = ACTIONS(79),
    [sym_keyword_bytea] = ACTIONS(79),
    [sym_keyword_enum] = ACTIONS(121),
    [sym_keyword_date] = ACTIONS(79),
    [sym_keyword_datetime] = ACTIONS(79),
    [sym_keyword_datetime2] = ACTIONS(79),
    [sym_keyword_smalldatetime] = ACTIONS(79),
    [sym_keyword_datetimeoffset] = ACTIONS(123),
    [aux_sym_keyword_time_token1] = ACTIONS(125),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(127),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(129),
    [sym_keyword_interval] = ACTIONS(79),
    [sym_keyword_geometry] = ACTIONS(79),
    [sym_keyword_geography] = ACTIONS(79),
    [sym_keyword_box2d] = ACTIONS(79),
    [sym_keyword_box3d] = ACTIONS(79),
    [sym_keyword_oid] = ACTIONS(79),
    [sym_keyword_name] = ACTIONS(79),
    [sym_keyword_regclass] = ACTIONS(79),
    [sym_keyword_regnamespace] = ACTIONS(79),
    [sym_keyword_regproc] = ACTIONS(79),
    [sym_keyword_regtype] = ACTIONS(79),
    [aux_sym_double_token1] = ACTIONS(131),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [35] = {
    [sym_keyword_smallserial] = STATE(42),
    [sym_keyword_serial] = STATE(42),
    [sym_keyword_bigserial] = STATE(42),
    [sym_keyword_tinyint] = STATE(48),
    [sym_keyword_smallint] = STATE(47),
    [sym_keyword_mediumint] = STATE(46),
    [sym_keyword_int] = STATE(43),
    [sym_keyword_bigint] = STATE(41),
    [sym_keyword_real] = STATE(40),
    [sym_keyword_char] = STATE(85),
    [sym_keyword_varchar] = STATE(86),
    [sym_keyword_time] = STATE(87),
    [sym_keyword_timestamp] = STATE(42),
    [sym_keyword_timestamptz] = STATE(42),
    [sym__type] = STATE(2644),
    [sym_tinyint] = STATE(42),
    [sym_smallint] = STATE(42),
    [sym_mediumint] = STATE(42),
    [sym_int] = STATE(42),
    [sym_bigint] = STATE(42),
    [sym_bit] = STATE(42),
    [sym_binary] = STATE(42),
    [sym_varbinary] = STATE(42),
    [sym_float] = STATE(42),
    [sym_double] = STATE(42),
    [sym_decimal] = STATE(42),
    [sym_numeric] = STATE(42),
    [sym_char] = STATE(42),
    [sym_varchar] = STATE(42),
    [sym_nchar] = STATE(42),
    [sym_nvarchar] = STATE(42),
    [sym_datetimeoffset] = STATE(42),
    [sym_time] = STATE(42),
    [sym_enum] = STATE(42),
    [sym_comment] = STATE(35),
    [sym_marginalia] = STATE(35),
    [sym__identifier] = ACTIONS(145),
    [aux_sym_keyword_character_token1] = ACTIONS(147),
    [sym_keyword_unsigned] = ACTIONS(149),
    [sym_keyword_boolean] = ACTIONS(151),
    [sym_keyword_bit] = ACTIONS(153),
    [sym_keyword_binary] = ACTIONS(155),
    [sym_keyword_varbinary] = ACTIONS(157),
    [sym_keyword_image] = ACTIONS(151),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(159),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(159),
    [aux_sym_keyword_serial_token1] = ACTIONS(161),
    [aux_sym_keyword_serial_token2] = ACTIONS(161),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(163),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(163),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(165),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(165),
    [aux_sym_keyword_smallint_token1] = ACTIONS(167),
    [aux_sym_keyword_smallint_token2] = ACTIONS(167),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(169),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(169),
    [aux_sym_keyword_int_token1] = ACTIONS(171),
    [aux_sym_keyword_int_token2] = ACTIONS(171),
    [aux_sym_keyword_int_token3] = ACTIONS(171),
    [aux_sym_keyword_bigint_token1] = ACTIONS(173),
    [aux_sym_keyword_bigint_token2] = ACTIONS(173),
    [sym_keyword_decimal] = ACTIONS(175),
    [sym_keyword_numeric] = ACTIONS(177),
    [aux_sym_keyword_real_token1] = ACTIONS(179),
    [aux_sym_keyword_real_token2] = ACTIONS(179),
    [sym_keyword_float] = ACTIONS(181),
    [sym_keyword_double] = ACTIONS(183),
    [sym_keyword_inet] = ACTIONS(151),
    [sym_keyword_money] = ACTIONS(151),
    [sym_keyword_smallmoney] = ACTIONS(151),
    [aux_sym_keyword_char_token1] = ACTIONS(185),
    [sym_keyword_nchar] = ACTIONS(187),
    [aux_sym_keyword_varchar_token1] = ACTIONS(189),
    [sym_keyword_nvarchar] = ACTIONS(191),
    [sym_keyword_text] = ACTIONS(151),
    [sym_keyword_string] = ACTIONS(151),
    [sym_keyword_uuid] = ACTIONS(151),
    [sym_keyword_json] = ACTIONS(151),
    [sym_keyword_jsonb] = ACTIONS(151),
    [sym_keyword_xml] = ACTIONS(151),
    [sym_keyword_bytea] = ACTIONS(151),
    [sym_keyword_enum] = ACTIONS(193),
    [sym_keyword_date] = ACTIONS(151),
    [sym_keyword_datetime] = ACTIONS(151),
    [sym_keyword_datetime2] = ACTIONS(151),
    [sym_keyword_smalldatetime] = ACTIONS(151),
    [sym_keyword_datetimeoffset] = ACTIONS(195),
    [aux_sym_keyword_time_token1] = ACTIONS(197),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(199),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(201),
    [sym_keyword_interval] = ACTIONS(151),
    [sym_keyword_geometry] = ACTIONS(151),
    [sym_keyword_geography] = ACTIONS(151),
    [sym_keyword_box2d] = ACTIONS(151),
    [sym_keyword_box3d] = ACTIONS(151),
    [sym_keyword_oid] = ACTIONS(151),
    [sym_keyword_name] = ACTIONS(151),
    [sym_keyword_regclass] = ACTIONS(151),
    [sym_keyword_regnamespace] = ACTIONS(151),
    [sym_keyword_regproc] = ACTIONS(151),
    [sym_keyword_regtype] = ACTIONS(151),
    [aux_sym_double_token1] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [36] = {
    [sym_comment] = STATE(36),
    [sym_marginalia] = STATE(36),
    [ts_builtin_sym_end] = ACTIONS(47),
    [sym__identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(47),
    [sym_keyword_desc] = ACTIONS(49),
    [sym_keyword_asc] = ACTIONS(49),
    [sym_keyword_primary] = ACTIONS(49),
    [sym_keyword_key] = ACTIONS(49),
    [sym_keyword_as] = ACTIONS(49),
    [sym_keyword_constraint] = ACTIONS(49),
    [sym_keyword_not] = ACTIONS(49),
    [sym_keyword_index] = ACTIONS(49),
    [sym_keyword_auto_increment] = ACTIONS(49),
    [sym_keyword_generated] = ACTIONS(49),
    [aux_sym_keyword_character_token1] = ACTIONS(49),
    [sym_keyword_default] = ACTIONS(49),
    [sym_keyword_first] = ACTIONS(49),
    [sym_keyword_after] = ACTIONS(49),
    [sym_keyword_unique] = ACTIONS(49),
    [sym_keyword_foreign] = ACTIONS(49),
    [sym_keyword_unsigned] = ACTIONS(49),
    [sym_keyword_stored] = ACTIONS(49),
    [sym_keyword_virtual] = ACTIONS(49),
    [sym_keyword_comment] = ACTIONS(49),
    [sym_keyword_null] = ACTIONS(49),
    [sym_keyword_boolean] = ACTIONS(49),
    [sym_keyword_bit] = ACTIONS(49),
    [sym_keyword_binary] = ACTIONS(49),
    [sym_keyword_varbinary] = ACTIONS(49),
    [sym_keyword_image] = ACTIONS(49),
    [aux_sym_keyword_smallserial_token1] = ACTIONS(49),
    [aux_sym_keyword_smallserial_token2] = ACTIONS(49),
    [aux_sym_keyword_serial_token1] = ACTIONS(49),
    [aux_sym_keyword_serial_token2] = ACTIONS(49),
    [aux_sym_keyword_bigserial_token1] = ACTIONS(49),
    [aux_sym_keyword_bigserial_token2] = ACTIONS(49),
    [aux_sym_keyword_tinyint_token1] = ACTIONS(49),
    [aux_sym_keyword_tinyint_token2] = ACTIONS(49),
    [aux_sym_keyword_smallint_token1] = ACTIONS(49),
    [aux_sym_keyword_smallint_token2] = ACTIONS(49),
    [aux_sym_keyword_mediumint_token1] = ACTIONS(49),
    [aux_sym_keyword_mediumint_token2] = ACTIONS(49),
    [aux_sym_keyword_int_token1] = ACTIONS(49),
    [aux_sym_keyword_int_token2] = ACTIONS(49),
    [aux_sym_keyword_int_token3] = ACTIONS(49),
    [aux_sym_keyword_bigint_token1] = ACTIONS(49),
    [aux_sym_keyword_bigint_token2] = ACTIONS(49),
    [sym_keyword_decimal] = ACTIONS(49),
    [sym_keyword_numeric] = ACTIONS(49),
    [aux_sym_keyword_real_token1] = ACTIONS(49),
    [aux_sym_keyword_real_token2] = ACTIONS(49),
    [sym_keyword_float] = ACTIONS(49),
    [sym_keyword_double] = ACTIONS(49),
    [sym_keyword_inet] = ACTIONS(49),
    [sym_keyword_money] = ACTIONS(49),
    [sym_keyword_smallmoney] = ACTIONS(49),
    [aux_sym_keyword_char_token1] = ACTIONS(49),
    [sym_keyword_nchar] = ACTIONS(49),
    [aux_sym_keyword_varchar_token1] = ACTIONS(49),
    [sym_keyword_nvarchar] = ACTIONS(49),
    [sym_keyword_text] = ACTIONS(49),
    [sym_keyword_string] = ACTIONS(49),
    [sym_keyword_uuid] = ACTIONS(49),
    [sym_keyword_json] = ACTIONS(49),
    [sym_keyword_jsonb] = ACTIONS(49),
    [sym_keyword_xml] = ACTIONS(49),
    [sym_keyword_bytea] = ACTIONS(49),
    [sym_keyword_enum] = ACTIONS(49),
    [sym_keyword_date] = ACTIONS(49),
    [sym_keyword_datetime] = ACTIONS(49),
    [sym_keyword_datetime2] = ACTIONS(49),
    [sym_keyword_smalldatetime] = ACTIONS(49),
    [sym_keyword_datetimeoffset] = ACTIONS(49),
    [aux_sym_keyword_time_token1] = ACTIONS(49),
    [aux_sym_keyword_timestamp_token1] = ACTIONS(49),
    [aux_sym_keyword_timestamptz_token1] = ACTIONS(49),
    [sym_keyword_interval] = ACTIONS(49),
    [sym_keyword_geometry] = ACTIONS(49),
    [sym_keyword_geography] = ACTIONS(49),
    [sym_keyword_box2d] = ACTIONS(49),
    [sym_keyword_box3d] = ACTIONS(49),
    [sym_keyword_oid] = ACTIONS(49),
    [sym_keyword_name] = ACTIONS(49),
    [sym_keyword_regclass] = ACTIONS(49),
    [sym_keyword_regnamespace] = ACTIONS(49),
    [sym_keyword_regproc] = ACTIONS(49),
    [sym_keyword_regtype] = ACTIONS(49),
    [anon_sym_RPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(47),
    [aux_sym_double_token1] = ACTIONS(49),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(47),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(47),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(47),
    [anon_sym_EQ] = ACTIONS(47),
  },
  [37] = {
    [sym_comment] = STATE(37),
    [sym_marginalia] = STATE(37),
    [ts_builtin_sym_end] = ACTIONS(325),
    [sym__identifier] = ACTIONS(327),
    [anon_sym_SEMI] = ACTIONS(325),
    [sym_keyword_set] = ACTIONS(327),
    [sym_keyword_from] = ACTIONS(327),
    [sym_keyword_left] = ACTIONS(327),
    [sym_keyword_right] = ACTIONS(327),
    [sym_keyword_inner] = ACTIONS(327),
    [sym_keyword_full] = ACTIONS(327),
    [sym_keyword_join] = ACTIONS(327),
    [sym_keyword_natural] = ACTIONS(327),
    [sym_keyword_on] = ACTIONS(327),
    [sym_keyword_where] = ACTIONS(327),
    [sym_keyword_create] = ACTIONS(327),
    [sym_keyword_increment] = ACTIONS(327),
    [sym_keyword_minvalue] = ACTIONS(327),
    [sym_keyword_maxvalue] = ACTIONS(327),
    [sym_keyword_owned] = ACTIONS(327),
    [sym_keyword_start] = ACTIONS(327),
    [sym_keyword_restart] = ACTIONS(327),
    [sym_keyword_as] = ACTIONS(327),
    [sym_keyword_when] = ACTIONS(327),
    [sym_keyword_then] = ACTIONS(327),
    [sym_keyword_else] = ACTIONS(327),
    [sym_keyword_end] = ACTIONS(327),
    [sym_keyword_in] = ACTIONS(327),
    [sym_keyword_and] = ACTIONS(327),
    [sym_keyword_or] = ACTIONS(327),
    [sym_keyword_is] = ACTIONS(327),
    [sym_keyword_not] = ACTIONS(327),
    [sym_keyword_using] = ACTIONS(327),
    [sym_keyword_collate] = ACTIONS(327),
    [sym_keyword_cascade] = ACTIONS(327),
    [sym_keyword_restrict] = ACTIONS(327),
    [aux_sym_keyword_with_token1] = ACTIONS(327),
    [sym_keyword_no] = ACTIONS(327),
    [sym_keyword_cycle] = ACTIONS(327),
    [sym_keyword_union] = ACTIONS(327),
    [sym_keyword_except] = ACTIONS(327),
    [sym_keyword_intersect] = ACTIONS(327),
    [sym_keyword_returning] = ACTIONS(327),
    [sym_keyword_between] = ACTIONS(327),
    [sym_keyword_preceding] = ACTIONS(327),
    [sym_keyword_following] = ACTIONS(327),
    [aux_sym_keyword_like_token1] = ACTIONS(327),
    [aux_sym_keyword_like_token2] = ACTIONS(327),
    [sym_keyword_similar] = ACTIONS(327),
    [sym_keyword_unsigned] = ACTIONS(329),
    [sym_keyword_zerofill] = ACTIONS(331),
    [sym_keyword_cache] = ACTIONS(327),
    [sym_keyword_precision] = ACTIONS(333),
    [sym_keyword_array] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_RBRACK] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_RPAREN] = ACTIONS(325),
    [anon_sym_COMMA] = ACTIONS(325),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(327),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(325),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(325),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(325),
    [anon_sym_COLON_EQ] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(325),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_COLON_COLON] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(327),
    [anon_sym_GT] = ACTIONS(327),
    [anon_sym_LT_EQ] = ACTIONS(325),
    [anon_sym_GT_EQ] = ACTIONS(325),
    [anon_sym_PLUS] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(327),
    [anon_sym_PERCENT] = ACTIONS(325),
    [anon_sym_CARET] = ACTIONS(325),
    [anon_sym_PIPE_PIPE] = ACTIONS(325),
    [anon_sym_BANG_EQ] = ACTIONS(325),
    [anon_sym_LT_GT] = ACTIONS(325),
    [anon_sym_DASH_GT] = ACTIONS(327),
    [anon_sym_DASH_GT_GT] = ACTIONS(325),
    [anon_sym_POUND_GT] = ACTIONS(327),
    [anon_sym_POUND_GT_GT] = ACTIONS(325),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_BQUOTE] = ACTIONS(325),
  },
  [38] = {
    [sym_comment] = STATE(38),
    [sym_marginalia] = STATE(38),
    [ts_builtin_sym_end] = ACTIONS(337),
    [sym__identifier] = ACTIONS(339),
    [anon_sym_SEMI] = ACTIONS(337),
    [sym_keyword_set] = ACTIONS(339),
    [sym_keyword_from] = ACTIONS(339),
    [sym_keyword_left] = ACTIONS(339),
    [sym_keyword_right] = ACTIONS(339),
    [sym_keyword_inner] = ACTIONS(339),
    [sym_keyword_full] = ACTIONS(339),
    [sym_keyword_join] = ACTIONS(339),
    [sym_keyword_natural] = ACTIONS(339),
    [sym_keyword_on] = ACTIONS(339),
    [sym_keyword_where] = ACTIONS(339),
    [sym_keyword_create] = ACTIONS(339),
    [sym_keyword_increment] = ACTIONS(339),
    [sym_keyword_minvalue] = ACTIONS(339),
    [sym_keyword_maxvalue] = ACTIONS(339),
    [sym_keyword_owned] = ACTIONS(339),
    [sym_keyword_start] = ACTIONS(339),
    [sym_keyword_restart] = ACTIONS(339),
    [sym_keyword_as] = ACTIONS(339),
    [sym_keyword_when] = ACTIONS(339),
    [sym_keyword_then] = ACTIONS(339),
    [sym_keyword_else] = ACTIONS(339),
    [sym_keyword_end] = ACTIONS(339),
    [sym_keyword_in] = ACTIONS(339),
    [sym_keyword_and] = ACTIONS(339),
    [sym_keyword_or] = ACTIONS(339),
    [sym_keyword_is] = ACTIONS(339),
    [sym_keyword_not] = ACTIONS(339),
    [sym_keyword_using] = ACTIONS(339),
    [sym_keyword_collate] = ACTIONS(339),
    [sym_keyword_cascade] = ACTIONS(339),
    [sym_keyword_restrict] = ACTIONS(339),
    [aux_sym_keyword_with_token1] = ACTIONS(339),
    [sym_keyword_no] = ACTIONS(339),
    [sym_keyword_cycle] = ACTIONS(339),
    [sym_keyword_union] = ACTIONS(339),
    [sym_keyword_except] = ACTIONS(339),
    [sym_keyword_intersect] = ACTIONS(339),
    [sym_keyword_returning] = ACTIONS(339),
    [sym_keyword_between] = ACTIONS(339),
    [sym_keyword_preceding] = ACTIONS(339),
    [sym_keyword_following] = ACTIONS(339),
    [aux_sym_keyword_like_token1] = ACTIONS(339),
    [aux_sym_keyword_like_token2] = ACTIONS(339),
    [sym_keyword_similar] = ACTIONS(339),
    [sym_keyword_unsigned] = ACTIONS(339),
    [sym_keyword_zerofill] = ACTIONS(339),
    [sym_keyword_cache] = ACTIONS(339),
    [sym_keyword_array] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(337),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(337),
    [anon_sym_COMMA] = ACTIONS(337),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(339),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(337),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(337),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(337),
    [anon_sym_COLON_EQ] = ACTIONS(337),
    [anon_sym_EQ] = ACTIONS(337),
    [anon_sym_STAR] = ACTIONS(337),
    [anon_sym_COLON_COLON] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_LT_EQ] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(337),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_PERCENT] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(337),
    [anon_sym_PIPE_PIPE] = ACTIONS(337),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_LT_GT] = ACTIONS(337),
    [anon_sym_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_GT] = ACTIONS(337),
    [anon_sym_POUND_GT] = ACTIONS(339),
    [anon_sym_POUND_GT_GT] = ACTIONS(337),
    [anon_sym_DQUOTE] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(337),
  },
  [39] = {
    [sym_comment] = STATE(39),
    [sym_marginalia] = STATE(39),
    [ts_builtin_sym_end] = ACTIONS(341),
    [sym__identifier] = ACTIONS(343),
    [anon_sym_SEMI] = ACTIONS(341),
    [sym_keyword_set] = ACTIONS(343),
    [sym_keyword_from] = ACTIONS(343),
    [sym_keyword_left] = ACTIONS(343),
    [sym_keyword_right] = ACTIONS(343),
    [sym_keyword_inner] = ACTIONS(343),
    [sym_keyword_full] = ACTIONS(343),
    [sym_keyword_join] = ACTIONS(343),
    [sym_keyword_natural] = ACTIONS(343),
    [sym_keyword_on] = ACTIONS(343),
    [sym_keyword_where] = ACTIONS(343),
    [sym_keyword_create] = ACTIONS(343),
    [sym_keyword_increment] = ACTIONS(343),
    [sym_keyword_minvalue] = ACTIONS(343),
    [sym_keyword_maxvalue] = ACTIONS(343),
    [sym_keyword_owned] = ACTIONS(343),
    [sym_keyword_start] = ACTIONS(343),
    [sym_keyword_restart] = ACTIONS(343),
    [sym_keyword_as] = ACTIONS(343),
    [sym_keyword_when] = ACTIONS(343),
    [sym_keyword_then] = ACTIONS(343),
    [sym_keyword_else] = ACTIONS(343),
    [sym_keyword_end] = ACTIONS(343),
    [sym_keyword_in] = ACTIONS(343),
    [sym_keyword_and] = ACTIONS(343),
    [sym_keyword_or] = ACTIONS(343),
    [sym_keyword_is] = ACTIONS(343),
    [sym_keyword_not] = ACTIONS(343),
    [sym_keyword_using] = ACTIONS(343),
    [sym_keyword_collate] = ACTIONS(343),
    [sym_keyword_cascade] = ACTIONS(343),
    [sym_keyword_restrict] = ACTIONS(343),
    [aux_sym_keyword_with_token1] = ACTIONS(343),
    [sym_keyword_no] = ACTIONS(343),
    [sym_keyword_cycle] = ACTIONS(343),
    [sym_keyword_union] = ACTIONS(343),
    [sym_keyword_except] = ACTIONS(343),
    [sym_keyword_intersect] = ACTIONS(343),
    [sym_keyword_returning] = ACTIONS(343),
    [sym_keyword_between] = ACTIONS(343),
    [sym_keyword_preceding] = ACTIONS(343),
    [sym_keyword_following] = ACTIONS(343),
    [aux_sym_keyword_like_token1] = ACTIONS(343),
    [aux_sym_keyword_like_token2] = ACTIONS(343),
    [sym_keyword_similar] = ACTIONS(343),
    [sym_keyword_unsigned] = ACTIONS(345),
    [sym_keyword_zerofill] = ACTIONS(347),
    [sym_keyword_cache] = ACTIONS(343),
    [sym_keyword_array] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_RBRACK] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_RPAREN] = ACTIONS(341),
    [anon_sym_COMMA] = ACTIONS(341),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(341),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(341),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(341),
    [anon_sym_COLON_EQ] = ACTIONS(341),
    [anon_sym_EQ] = ACTIONS(341),
    [anon_sym_STAR] = ACTIONS(341),
    [anon_sym_COLON_COLON] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(343),
    [anon_sym_GT] = ACTIONS(343),
    [anon_sym_LT_EQ] = ACTIONS(341),
    [anon_sym_GT_EQ] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_PERCENT] = ACTIONS(341),
    [anon_sym_CARET] = ACTIONS(341),
    [anon_sym_PIPE_PIPE] = ACTIONS(341),
    [anon_sym_BANG_EQ] = ACTIONS(341),
    [anon_sym_LT_GT] = ACTIONS(341),
    [anon_sym_DASH_GT] = ACTIONS(343),
    [anon_sym_DASH_GT_GT] = ACTIONS(341),
    [anon_sym_POUND_GT] = ACTIONS(343),
    [anon_sym_POUND_GT_GT] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(341),
    [anon_sym_BQUOTE] = ACTIONS(341),
  },
  [40] = {
    [sym_comment] = STATE(40),
    [sym_marginalia] = STATE(40),
    [ts_builtin_sym_end] = ACTIONS(325),
    [sym__identifier] = ACTIONS(327),
    [anon_sym_SEMI] = ACTIONS(325),
    [sym_keyword_set] = ACTIONS(327),
    [sym_keyword_from] = ACTIONS(327),
    [sym_keyword_left] = ACTIONS(327),
    [sym_keyword_right] = ACTIONS(327),
    [sym_keyword_inner] = ACTIONS(327),
    [sym_keyword_full] = ACTIONS(327),
    [sym_keyword_join] = ACTIONS(327),
    [sym_keyword_natural] = ACTIONS(327),
    [sym_keyword_on] = ACTIONS(327),
    [sym_keyword_where] = ACTIONS(327),
    [sym_keyword_create] = ACTIONS(327),
    [sym_keyword_increment] = ACTIONS(327),
    [sym_keyword_minvalue] = ACTIONS(327),
    [sym_keyword_maxvalue] = ACTIONS(327),
    [sym_keyword_owned] = ACTIONS(327),
    [sym_keyword_start] = ACTIONS(327),
    [sym_keyword_restart] = ACTIONS(327),
    [sym_keyword_as] = ACTIONS(327),
    [sym_keyword_when] = ACTIONS(327),
    [sym_keyword_then] = ACTIONS(327),
    [sym_keyword_else] = ACTIONS(327),
    [sym_keyword_end] = ACTIONS(327),
    [sym_keyword_in] = ACTIONS(327),
    [sym_keyword_and] = ACTIONS(327),
    [sym_keyword_or] = ACTIONS(327),
    [sym_keyword_is] = ACTIONS(327),
    [sym_keyword_not] = ACTIONS(327),
    [sym_keyword_using] = ACTIONS(327),
    [sym_keyword_collate] = ACTIONS(327),
    [sym_keyword_cascade] = ACTIONS(327),
    [sym_keyword_restrict] = ACTIONS(327),
    [aux_sym_keyword_with_token1] = ACTIONS(327),
    [sym_keyword_no] = ACTIONS(327),
    [sym_keyword_cycle] = ACTIONS(327),
    [sym_keyword_union] = ACTIONS(327),
    [sym_keyword_except] = ACTIONS(327),
    [sym_keyword_intersect] = ACTIONS(327),
    [sym_keyword_returning] = ACTIONS(327),
    [sym_keyword_between] = ACTIONS(327),
    [sym_keyword_preceding] = ACTIONS(327),
    [sym_keyword_following] = ACTIONS(327),
    [aux_sym_keyword_like_token1] = ACTIONS(327),
    [aux_sym_keyword_like_token2] = ACTIONS(327),
    [sym_keyword_similar] = ACTIONS(327),
    [sym_keyword_unsigned] = ACTIONS(329),
    [sym_keyword_zerofill] = ACTIONS(331),
    [sym_keyword_cache] = ACTIONS(327),
    [sym_keyword_array] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_RBRACK] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_RPAREN] = ACTIONS(325),
    [anon_sym_COMMA] = ACTIONS(325),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(327),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(325),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(325),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(325),
    [anon_sym_COLON_EQ] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(325),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_COLON_COLON] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(327),
    [anon_sym_GT] = ACTIONS(327),
    [anon_sym_LT_EQ] = ACTIONS(325),
    [anon_sym_GT_EQ] = ACTIONS(325),
    [anon_sym_PLUS] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(327),
    [anon_sym_PERCENT] = ACTIONS(325),
    [anon_sym_CARET] = ACTIONS(325),
    [anon_sym_PIPE_PIPE] = ACTIONS(325),
    [anon_sym_BANG_EQ] = ACTIONS(325),
    [anon_sym_LT_GT] = ACTIONS(325),
    [anon_sym_DASH_GT] = ACTIONS(327),
    [anon_sym_DASH_GT_GT] = ACTIONS(325),
    [anon_sym_POUND_GT] = ACTIONS(327),
    [anon_sym_POUND_GT_GT] = ACTIONS(325),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_BQUOTE] = ACTIONS(325),
  },
  [41] = {
    [sym_comment] = STATE(41),
    [sym_marginalia] = STATE(41),
    [ts_builtin_sym_end] = ACTIONS(351),
    [sym__identifier] = ACTIONS(353),
    [anon_sym_SEMI] = ACTIONS(351),
    [sym_keyword_set] = ACTIONS(353),
    [sym_keyword_from] = ACTIONS(353),
    [sym_keyword_left] = ACTIONS(353),
    [sym_keyword_right] = ACTIONS(353),
    [sym_keyword_inner] = ACTIONS(353),
    [sym_keyword_full] = ACTIONS(353),
    [sym_keyword_join] = ACTIONS(353),
    [sym_keyword_natural] = ACTIONS(353),
    [sym_keyword_on] = ACTIONS(353),
    [sym_keyword_where] = ACTIONS(353),
    [sym_keyword_create] = ACTIONS(353),
    [sym_keyword_increment] = ACTIONS(353),
    [sym_keyword_minvalue] = ACTIONS(353),
    [sym_keyword_maxvalue] = ACTIONS(353),
    [sym_keyword_owned] = ACTIONS(353),
    [sym_keyword_start] = ACTIONS(353),
    [sym_keyword_restart] = ACTIONS(353),
    [sym_keyword_as] = ACTIONS(353),
    [sym_keyword_when] = ACTIONS(353),
    [sym_keyword_then] = ACTIONS(353),
    [sym_keyword_else] = ACTIONS(353),
    [sym_keyword_end] = ACTIONS(353),
    [sym_keyword_in] = ACTIONS(353),
    [sym_keyword_and] = ACTIONS(353),
    [sym_keyword_or] = ACTIONS(353),
    [sym_keyword_is] = ACTIONS(353),
    [sym_keyword_not] = ACTIONS(353),
    [sym_keyword_using] = ACTIONS(353),
    [sym_keyword_collate] = ACTIONS(353),
    [sym_keyword_cascade] = ACTIONS(353),
    [sym_keyword_restrict] = ACTIONS(353),
    [aux_sym_keyword_with_token1] = ACTIONS(353),
    [sym_keyword_no] = ACTIONS(353),
    [sym_keyword_cycle] = ACTIONS(353),
    [sym_keyword_union] = ACTIONS(353),
    [sym_keyword_except] = ACTIONS(353),
    [sym_keyword_intersect] = ACTIONS(353),
    [sym_keyword_returning] = ACTIONS(353),
    [sym_keyword_between] = ACTIONS(353),
    [sym_keyword_preceding] = ACTIONS(353),
    [sym_keyword_following] = ACTIONS(353),
    [aux_sym_keyword_like_token1] = ACTIONS(353),
    [aux_sym_keyword_like_token2] = ACTIONS(353),
    [sym_keyword_similar] = ACTIONS(353),
    [sym_keyword_unsigned] = ACTIONS(355),
    [sym_keyword_zerofill] = ACTIONS(357),
    [sym_keyword_cache] = ACTIONS(353),
    [sym_keyword_array] = ACTIONS(353),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_RBRACK] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(351),
    [anon_sym_COMMA] = ACTIONS(351),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(353),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(351),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(351),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(351),
    [anon_sym_COLON_EQ] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(351),
    [anon_sym_STAR] = ACTIONS(351),
    [anon_sym_COLON_COLON] = ACTIONS(351),
    [anon_sym_LT] = ACTIONS(353),
    [anon_sym_GT] = ACTIONS(353),
    [anon_sym_LT_EQ] = ACTIONS(351),
    [anon_sym_GT_EQ] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(351),
    [anon_sym_DASH] = ACTIONS(353),
    [anon_sym_PERCENT] = ACTIONS(351),
    [anon_sym_CARET] = ACTIONS(351),
    [anon_sym_PIPE_PIPE] = ACTIONS(351),
    [anon_sym_BANG_EQ] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(351),
    [anon_sym_DASH_GT] = ACTIONS(353),
    [anon_sym_DASH_GT_GT] = ACTIONS(351),
    [anon_sym_POUND_GT] = ACTIONS(353),
    [anon_sym_POUND_GT_GT] = ACTIONS(351),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [anon_sym_BQUOTE] = ACTIONS(351),
  },
  [42] = {
    [sym_array_size_definition] = STATE(190),
    [sym__array_size_definition] = STATE(184),
    [sym_comment] = STATE(42),
    [sym_marginalia] = STATE(42),
    [aux_sym_array_size_definition_repeat1] = STATE(82),
    [ts_builtin_sym_end] = ACTIONS(361),
    [sym__identifier] = ACTIONS(363),
    [anon_sym_SEMI] = ACTIONS(361),
    [sym_keyword_set] = ACTIONS(363),
    [sym_keyword_from] = ACTIONS(363),
    [sym_keyword_left] = ACTIONS(363),
    [sym_keyword_right] = ACTIONS(363),
    [sym_keyword_inner] = ACTIONS(363),
    [sym_keyword_full] = ACTIONS(363),
    [sym_keyword_join] = ACTIONS(363),
    [sym_keyword_natural] = ACTIONS(363),
    [sym_keyword_on] = ACTIONS(363),
    [sym_keyword_where] = ACTIONS(363),
    [sym_keyword_create] = ACTIONS(363),
    [sym_keyword_increment] = ACTIONS(363),
    [sym_keyword_minvalue] = ACTIONS(363),
    [sym_keyword_maxvalue] = ACTIONS(363),
    [sym_keyword_owned] = ACTIONS(363),
    [sym_keyword_start] = ACTIONS(363),
    [sym_keyword_restart] = ACTIONS(363),
    [sym_keyword_as] = ACTIONS(363),
    [sym_keyword_when] = ACTIONS(363),
    [sym_keyword_then] = ACTIONS(363),
    [sym_keyword_else] = ACTIONS(363),
    [sym_keyword_end] = ACTIONS(363),
    [sym_keyword_in] = ACTIONS(363),
    [sym_keyword_and] = ACTIONS(363),
    [sym_keyword_or] = ACTIONS(363),
    [sym_keyword_is] = ACTIONS(363),
    [sym_keyword_not] = ACTIONS(363),
    [sym_keyword_using] = ACTIONS(363),
    [sym_keyword_collate] = ACTIONS(363),
    [sym_keyword_cascade] = ACTIONS(363),
    [sym_keyword_restrict] = ACTIONS(363),
    [aux_sym_keyword_with_token1] = ACTIONS(363),
    [sym_keyword_no] = ACTIONS(363),
    [sym_keyword_cycle] = ACTIONS(363),
    [sym_keyword_union] = ACTIONS(363),
    [sym_keyword_except] = ACTIONS(363),
    [sym_keyword_intersect] = ACTIONS(363),
    [sym_keyword_returning] = ACTIONS(363),
    [sym_keyword_between] = ACTIONS(363),
    [sym_keyword_preceding] = ACTIONS(363),
    [sym_keyword_following] = ACTIONS(363),
    [aux_sym_keyword_like_token1] = ACTIONS(363),
    [aux_sym_keyword_like_token2] = ACTIONS(363),
    [sym_keyword_similar] = ACTIONS(363),
    [sym_keyword_cache] = ACTIONS(363),
    [sym_keyword_array] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_RBRACK] = ACTIONS(361),
    [anon_sym_RPAREN] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(363),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(361),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(361),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(361),
    [anon_sym_COLON_EQ] = ACTIONS(361),
    [anon_sym_EQ] = ACTIONS(361),
    [anon_sym_STAR] = ACTIONS(361),
    [anon_sym_COLON_COLON] = ACTIONS(361),
    [anon_sym_LT] = ACTIONS(363),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_LT_EQ] = ACTIONS(361),
    [anon_sym_GT_EQ] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(361),
    [anon_sym_DASH] = ACTIONS(363),
    [anon_sym_PERCENT] = ACTIONS(361),
    [anon_sym_CARET] = ACTIONS(361),
    [anon_sym_PIPE_PIPE] = ACTIONS(361),
    [anon_sym_BANG_EQ] = ACTIONS(361),
    [anon_sym_LT_GT] = ACTIONS(361),
    [anon_sym_DASH_GT] = ACTIONS(363),
    [anon_sym_DASH_GT_GT] = ACTIONS(361),
    [anon_sym_POUND_GT] = ACTIONS(363),
    [anon_sym_POUND_GT_GT] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(361),
  },
  [43] = {
    [sym_comment] = STATE(43),
    [sym_marginalia] = STATE(43),
    [ts_builtin_sym_end] = ACTIONS(369),
    [sym__identifier] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(369),
    [sym_keyword_set] = ACTIONS(371),
    [sym_keyword_from] = ACTIONS(371),
    [sym_keyword_left] = ACTIONS(371),
    [sym_keyword_right] = ACTIONS(371),
    [sym_keyword_inner] = ACTIONS(371),
    [sym_keyword_full] = ACTIONS(371),
    [sym_keyword_join] = ACTIONS(371),
    [sym_keyword_natural] = ACTIONS(371),
    [sym_keyword_on] = ACTIONS(371),
    [sym_keyword_where] = ACTIONS(371),
    [sym_keyword_create] = ACTIONS(371),
    [sym_keyword_increment] = ACTIONS(371),
    [sym_keyword_minvalue] = ACTIONS(371),
    [sym_keyword_maxvalue] = ACTIONS(371),
    [sym_keyword_owned] = ACTIONS(371),
    [sym_keyword_start] = ACTIONS(371),
    [sym_keyword_restart] = ACTIONS(371),
    [sym_keyword_as] = ACTIONS(371),
    [sym_keyword_when] = ACTIONS(371),
    [sym_keyword_then] = ACTIONS(371),
    [sym_keyword_else] = ACTIONS(371),
    [sym_keyword_end] = ACTIONS(371),
    [sym_keyword_in] = ACTIONS(371),
    [sym_keyword_and] = ACTIONS(371),
    [sym_keyword_or] = ACTIONS(371),
    [sym_keyword_is] = ACTIONS(371),
    [sym_keyword_not] = ACTIONS(371),
    [sym_keyword_using] = ACTIONS(371),
    [sym_keyword_collate] = ACTIONS(371),
    [sym_keyword_cascade] = ACTIONS(371),
    [sym_keyword_restrict] = ACTIONS(371),
    [aux_sym_keyword_with_token1] = ACTIONS(371),
    [sym_keyword_no] = ACTIONS(371),
    [sym_keyword_cycle] = ACTIONS(371),
    [sym_keyword_union] = ACTIONS(371),
    [sym_keyword_except] = ACTIONS(371),
    [sym_keyword_intersect] = ACTIONS(371),
    [sym_keyword_returning] = ACTIONS(371),
    [sym_keyword_between] = ACTIONS(371),
    [sym_keyword_preceding] = ACTIONS(371),
    [sym_keyword_following] = ACTIONS(371),
    [aux_sym_keyword_like_token1] = ACTIONS(371),
    [aux_sym_keyword_like_token2] = ACTIONS(371),
    [sym_keyword_similar] = ACTIONS(371),
    [sym_keyword_unsigned] = ACTIONS(373),
    [sym_keyword_zerofill] = ACTIONS(375),
    [sym_keyword_cache] = ACTIONS(371),
    [sym_keyword_array] = ACTIONS(371),
    [anon_sym_LBRACK] = ACTIONS(369),
    [anon_sym_RBRACK] = ACTIONS(369),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_RPAREN] = ACTIONS(369),
    [anon_sym_COMMA] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(369),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(369),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(371),
    [anon_sym_PERCENT] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_LT_GT] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_POUND_GT] = ACTIONS(371),
    [anon_sym_POUND_GT_GT] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
  },
  [44] = {
    [sym_comment] = STATE(44),
    [sym_marginalia] = STATE(44),
    [ts_builtin_sym_end] = ACTIONS(379),
    [sym__identifier] = ACTIONS(381),
    [anon_sym_SEMI] = ACTIONS(379),
    [sym_keyword_set] = ACTIONS(381),
    [sym_keyword_from] = ACTIONS(381),
    [sym_keyword_left] = ACTIONS(381),
    [sym_keyword_right] = ACTIONS(381),
    [sym_keyword_inner] = ACTIONS(381),
    [sym_keyword_full] = ACTIONS(381),
    [sym_keyword_join] = ACTIONS(381),
    [sym_keyword_natural] = ACTIONS(381),
    [sym_keyword_on] = ACTIONS(381),
    [sym_keyword_where] = ACTIONS(381),
    [sym_keyword_offset] = ACTIONS(381),
    [sym_keyword_create] = ACTIONS(381),
    [sym_keyword_increment] = ACTIONS(381),
    [sym_keyword_minvalue] = ACTIONS(381),
    [sym_keyword_maxvalue] = ACTIONS(381),
    [sym_keyword_owned] = ACTIONS(381),
    [sym_keyword_start] = ACTIONS(381),
    [sym_keyword_restart] = ACTIONS(381),
    [sym_keyword_as] = ACTIONS(381),
    [sym_keyword_when] = ACTIONS(381),
    [sym_keyword_then] = ACTIONS(381),
    [sym_keyword_else] = ACTIONS(381),
    [sym_keyword_end] = ACTIONS(381),
    [sym_keyword_in] = ACTIONS(381),
    [sym_keyword_and] = ACTIONS(381),
    [sym_keyword_or] = ACTIONS(381),
    [sym_keyword_is] = ACTIONS(381),
    [sym_keyword_not] = ACTIONS(381),
    [sym_keyword_using] = ACTIONS(381),
    [aux_sym_keyword_with_token1] = ACTIONS(381),
    [sym_keyword_no] = ACTIONS(381),
    [sym_keyword_user] = ACTIONS(381),
    [sym_keyword_admin] = ACTIONS(381),
    [sym_keyword_password] = ACTIONS(381),
    [sym_keyword_encrypted] = ACTIONS(381),
    [sym_keyword_valid] = ACTIONS(381),
    [sym_keyword_connection] = ACTIONS(381),
    [sym_keyword_role] = ACTIONS(381),
    [sym_keyword_cycle] = ACTIONS(381),
    [sym_keyword_union] = ACTIONS(381),
    [sym_keyword_except] = ACTIONS(381),
    [sym_keyword_intersect] = ACTIONS(381),
    [sym_keyword_returning] = ACTIONS(381),
    [sym_keyword_between] = ACTIONS(381),
    [sym_keyword_preceding] = ACTIONS(381),
    [sym_keyword_following] = ACTIONS(381),
    [aux_sym_keyword_like_token1] = ACTIONS(381),
    [aux_sym_keyword_like_token2] = ACTIONS(381),
    [sym_keyword_similar] = ACTIONS(381),
    [sym_keyword_cache] = ACTIONS(381),
    [anon_sym_RBRACK] = ACTIONS(379),
    [anon_sym_RPAREN] = ACTIONS(379),
    [anon_sym_COMMA] = ACTIONS(379),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(379),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(379),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(379),
    [anon_sym_DOT] = ACTIONS(379),
    [anon_sym_STAR] = ACTIONS(379),
    [anon_sym_COLON_COLON] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_GT] = ACTIONS(381),
    [anon_sym_LT_EQ] = ACTIONS(379),
    [anon_sym_GT_EQ] = ACTIONS(379),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(381),
    [anon_sym_PERCENT] = ACTIONS(379),
    [anon_sym_CARET] = ACTIONS(379),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_BANG_EQ] = ACTIONS(379),
    [anon_sym_LT_GT] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_POUND_GT] = ACTIONS(381),
    [anon_sym_POUND_GT_GT] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_BQUOTE] = ACTIONS(379),
  },
  [45] = {
    [sym_comment] = STATE(45),
    [sym_marginalia] = STATE(45),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym__identifier] = ACTIONS(385),
    [anon_sym_SEMI] = ACTIONS(383),
    [sym_keyword_set] = ACTIONS(385),
    [sym_keyword_from] = ACTIONS(385),
    [sym_keyword_left] = ACTIONS(385),
    [sym_keyword_right] = ACTIONS(385),
    [sym_keyword_inner] = ACTIONS(385),
    [sym_keyword_full] = ACTIONS(385),
    [sym_keyword_join] = ACTIONS(385),
    [sym_keyword_natural] = ACTIONS(385),
    [sym_keyword_on] = ACTIONS(385),
    [sym_keyword_where] = ACTIONS(385),
    [sym_keyword_create] = ACTIONS(385),
    [sym_keyword_increment] = ACTIONS(385),
    [sym_keyword_minvalue] = ACTIONS(385),
    [sym_keyword_maxvalue] = ACTIONS(385),
    [sym_keyword_owned] = ACTIONS(385),
    [sym_keyword_start] = ACTIONS(385),
    [sym_keyword_restart] = ACTIONS(385),
    [sym_keyword_as] = ACTIONS(385),
    [sym_keyword_when] = ACTIONS(385),
    [sym_keyword_then] = ACTIONS(385),
    [sym_keyword_else] = ACTIONS(385),
    [sym_keyword_end] = ACTIONS(385),
    [sym_keyword_in] = ACTIONS(385),
    [sym_keyword_and] = ACTIONS(385),
    [sym_keyword_or] = ACTIONS(385),
    [sym_keyword_is] = ACTIONS(385),
    [sym_keyword_not] = ACTIONS(385),
    [sym_keyword_using] = ACTIONS(385),
    [sym_keyword_collate] = ACTIONS(385),
    [sym_keyword_cascade] = ACTIONS(385),
    [sym_keyword_restrict] = ACTIONS(385),
    [aux_sym_keyword_with_token1] = ACTIONS(385),
    [sym_keyword_no] = ACTIONS(385),
    [sym_keyword_cycle] = ACTIONS(385),
    [sym_keyword_union] = ACTIONS(385),
    [sym_keyword_except] = ACTIONS(385),
    [sym_keyword_intersect] = ACTIONS(385),
    [sym_keyword_returning] = ACTIONS(385),
    [sym_keyword_between] = ACTIONS(385),
    [sym_keyword_preceding] = ACTIONS(385),
    [sym_keyword_following] = ACTIONS(385),
    [aux_sym_keyword_like_token1] = ACTIONS(385),
    [aux_sym_keyword_like_token2] = ACTIONS(385),
    [sym_keyword_similar] = ACTIONS(385),
    [sym_keyword_unsigned] = ACTIONS(385),
    [sym_keyword_zerofill] = ACTIONS(385),
    [sym_keyword_cache] = ACTIONS(385),
    [sym_keyword_array] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(383),
    [anon_sym_RBRACK] = ACTIONS(383),
    [anon_sym_LPAREN] = ACTIONS(383),
    [anon_sym_RPAREN] = ACTIONS(383),
    [anon_sym_COMMA] = ACTIONS(383),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(383),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(383),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(383),
    [anon_sym_COLON_COLON] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_PERCENT] = ACTIONS(383),
    [anon_sym_CARET] = ACTIONS(383),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_LT_GT] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_POUND_GT] = ACTIONS(385),
    [anon_sym_POUND_GT_GT] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [anon_sym_BQUOTE] = ACTIONS(383),
  },
  [46] = {
    [sym_comment] = STATE(46),
    [sym_marginalia] = STATE(46),
    [ts_builtin_sym_end] = ACTIONS(387),
    [sym__identifier] = ACTIONS(389),
    [anon_sym_SEMI] = ACTIONS(387),
    [sym_keyword_set] = ACTIONS(389),
    [sym_keyword_from] = ACTIONS(389),
    [sym_keyword_left] = ACTIONS(389),
    [sym_keyword_right] = ACTIONS(389),
    [sym_keyword_inner] = ACTIONS(389),
    [sym_keyword_full] = ACTIONS(389),
    [sym_keyword_join] = ACTIONS(389),
    [sym_keyword_natural] = ACTIONS(389),
    [sym_keyword_on] = ACTIONS(389),
    [sym_keyword_where] = ACTIONS(389),
    [sym_keyword_create] = ACTIONS(389),
    [sym_keyword_increment] = ACTIONS(389),
    [sym_keyword_minvalue] = ACTIONS(389),
    [sym_keyword_maxvalue] = ACTIONS(389),
    [sym_keyword_owned] = ACTIONS(389),
    [sym_keyword_start] = ACTIONS(389),
    [sym_keyword_restart] = ACTIONS(389),
    [sym_keyword_as] = ACTIONS(389),
    [sym_keyword_when] = ACTIONS(389),
    [sym_keyword_then] = ACTIONS(389),
    [sym_keyword_else] = ACTIONS(389),
    [sym_keyword_end] = ACTIONS(389),
    [sym_keyword_in] = ACTIONS(389),
    [sym_keyword_and] = ACTIONS(389),
    [sym_keyword_or] = ACTIONS(389),
    [sym_keyword_is] = ACTIONS(389),
    [sym_keyword_not] = ACTIONS(389),
    [sym_keyword_using] = ACTIONS(389),
    [sym_keyword_collate] = ACTIONS(389),
    [sym_keyword_cascade] = ACTIONS(389),
    [sym_keyword_restrict] = ACTIONS(389),
    [aux_sym_keyword_with_token1] = ACTIONS(389),
    [sym_keyword_no] = ACTIONS(389),
    [sym_keyword_cycle] = ACTIONS(389),
    [sym_keyword_union] = ACTIONS(389),
    [sym_keyword_except] = ACTIONS(389),
    [sym_keyword_intersect] = ACTIONS(389),
    [sym_keyword_returning] = ACTIONS(389),
    [sym_keyword_between] = ACTIONS(389),
    [sym_keyword_preceding] = ACTIONS(389),
    [sym_keyword_following] = ACTIONS(389),
    [aux_sym_keyword_like_token1] = ACTIONS(389),
    [aux_sym_keyword_like_token2] = ACTIONS(389),
    [sym_keyword_similar] = ACTIONS(389),
    [sym_keyword_unsigned] = ACTIONS(391),
    [sym_keyword_zerofill] = ACTIONS(393),
    [sym_keyword_cache] = ACTIONS(389),
    [sym_keyword_array] = ACTIONS(389),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_RBRACK] = ACTIONS(387),
    [anon_sym_LPAREN] = ACTIONS(395),
    [anon_sym_RPAREN] = ACTIONS(387),
    [anon_sym_COMMA] = ACTIONS(387),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(387),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(387),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(387),
    [anon_sym_COLON_EQ] = ACTIONS(387),
    [anon_sym_EQ] = ACTIONS(387),
    [anon_sym_STAR] = ACTIONS(387),
    [anon_sym_COLON_COLON] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(389),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_LT_EQ] = ACTIONS(387),
    [anon_sym_GT_EQ] = ACTIONS(387),
    [anon_sym_PLUS] = ACTIONS(387),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_PERCENT] = ACTIONS(387),
    [anon_sym_CARET] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_BANG_EQ] = ACTIONS(387),
    [anon_sym_LT_GT] = ACTIONS(387),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_DASH_GT_GT] = ACTIONS(387),
    [anon_sym_POUND_GT] = ACTIONS(389),
    [anon_sym_POUND_GT_GT] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_BQUOTE] = ACTIONS(387),
  },
  [47] = {
    [sym_comment] = STATE(47),
    [sym_marginalia] = STATE(47),
    [ts_builtin_sym_end] = ACTIONS(397),
    [sym__identifier] = ACTIONS(399),
    [anon_sym_SEMI] = ACTIONS(397),
    [sym_keyword_set] = ACTIONS(399),
    [sym_keyword_from] = ACTIONS(399),
    [sym_keyword_left] = ACTIONS(399),
    [sym_keyword_right] = ACTIONS(399),
    [sym_keyword_inner] = ACTIONS(399),
    [sym_keyword_full] = ACTIONS(399),
    [sym_keyword_join] = ACTIONS(399),
    [sym_keyword_natural] = ACTIONS(399),
    [sym_keyword_on] = ACTIONS(399),
    [sym_keyword_where] = ACTIONS(399),
    [sym_keyword_create] = ACTIONS(399),
    [sym_keyword_increment] = ACTIONS(399),
    [sym_keyword_minvalue] = ACTIONS(399),
    [sym_keyword_maxvalue] = ACTIONS(399),
    [sym_keyword_owned] = ACTIONS(399),
    [sym_keyword_start] = ACTIONS(399),
    [sym_keyword_restart] = ACTIONS(399),
    [sym_keyword_as] = ACTIONS(399),
    [sym_keyword_when] = ACTIONS(399),
    [sym_keyword_then] = ACTIONS(399),
    [sym_keyword_else] = ACTIONS(399),
    [sym_keyword_end] = ACTIONS(399),
    [sym_keyword_in] = ACTIONS(399),
    [sym_keyword_and] = ACTIONS(399),
    [sym_keyword_or] = ACTIONS(399),
    [sym_keyword_is] = ACTIONS(399),
    [sym_keyword_not] = ACTIONS(399),
    [sym_keyword_using] = ACTIONS(399),
    [sym_keyword_collate] = ACTIONS(399),
    [sym_keyword_cascade] = ACTIONS(399),
    [sym_keyword_restrict] = ACTIONS(399),
    [aux_sym_keyword_with_token1] = ACTIONS(399),
    [sym_keyword_no] = ACTIONS(399),
    [sym_keyword_cycle] = ACTIONS(399),
    [sym_keyword_union] = ACTIONS(399),
    [sym_keyword_except] = ACTIONS(399),
    [sym_keyword_intersect] = ACTIONS(399),
    [sym_keyword_returning] = ACTIONS(399),
    [sym_keyword_between] = ACTIONS(399),
    [sym_keyword_preceding] = ACTIONS(399),
    [sym_keyword_following] = ACTIONS(399),
    [aux_sym_keyword_like_token1] = ACTIONS(399),
    [aux_sym_keyword_like_token2] = ACTIONS(399),
    [sym_keyword_similar] = ACTIONS(399),
    [sym_keyword_unsigned] = ACTIONS(401),
    [sym_keyword_zerofill] = ACTIONS(403),
    [sym_keyword_cache] = ACTIONS(399),
    [sym_keyword_array] = ACTIONS(399),
    [anon_sym_LBRACK] = ACTIONS(397),
    [anon_sym_RBRACK] = ACTIONS(397),
    [anon_sym_LPAREN] = ACTIONS(405),
    [anon_sym_RPAREN] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(397),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(399),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(397),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(397),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(397),
    [anon_sym_COLON_EQ] = ACTIONS(397),
    [anon_sym_EQ] = ACTIONS(397),
    [anon_sym_STAR] = ACTIONS(397),
    [anon_sym_COLON_COLON] = ACTIONS(397),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_GT] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(397),
    [anon_sym_GT_EQ] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(397),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_PERCENT] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(397),
    [anon_sym_PIPE_PIPE] = ACTIONS(397),
    [anon_sym_BANG_EQ] = ACTIONS(397),
    [anon_sym_LT_GT] = ACTIONS(397),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_DASH_GT_GT] = ACTIONS(397),
    [anon_sym_POUND_GT] = ACTIONS(399),
    [anon_sym_POUND_GT_GT] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(397),
    [anon_sym_BQUOTE] = ACTIONS(397),
  },
  [48] = {
    [sym_comment] = STATE(48),
    [sym_marginalia] = STATE(48),
    [ts_builtin_sym_end] = ACTIONS(407),
    [sym__identifier] = ACTIONS(409),
    [anon_sym_SEMI] = ACTIONS(407),
    [sym_keyword_set] = ACTIONS(409),
    [sym_keyword_from] = ACTIONS(409),
    [sym_keyword_left] = ACTIONS(409),
    [sym_keyword_right] = ACTIONS(409),
    [sym_keyword_inner] = ACTIONS(409),
    [sym_keyword_full] = ACTIONS(409),
    [sym_keyword_join] = ACTIONS(409),
    [sym_keyword_natural] = ACTIONS(409),
    [sym_keyword_on] = ACTIONS(409),
    [sym_keyword_where] = ACTIONS(409),
    [sym_keyword_create] = ACTIONS(409),
    [sym_keyword_increment] = ACTIONS(409),
    [sym_keyword_minvalue] = ACTIONS(409),
    [sym_keyword_maxvalue] = ACTIONS(409),
    [sym_keyword_owned] = ACTIONS(409),
    [sym_keyword_start] = ACTIONS(409),
    [sym_keyword_restart] = ACTIONS(409),
    [sym_keyword_as] = ACTIONS(409),
    [sym_keyword_when] = ACTIONS(409),
    [sym_keyword_then] = ACTIONS(409),
    [sym_keyword_else] = ACTIONS(409),
    [sym_keyword_end] = ACTIONS(409),
    [sym_keyword_in] = ACTIONS(409),
    [sym_keyword_and] = ACTIONS(409),
    [sym_keyword_or] = ACTIONS(409),
    [sym_keyword_is] = ACTIONS(409),
    [sym_keyword_not] = ACTIONS(409),
    [sym_keyword_using] = ACTIONS(409),
    [sym_keyword_collate] = ACTIONS(409),
    [sym_keyword_cascade] = ACTIONS(409),
    [sym_keyword_restrict] = ACTIONS(409),
    [aux_sym_keyword_with_token1] = ACTIONS(409),
    [sym_keyword_no] = ACTIONS(409),
    [sym_keyword_cycle] = ACTIONS(409),
    [sym_keyword_union] = ACTIONS(409),
    [sym_keyword_except] = ACTIONS(409),
    [sym_keyword_intersect] = ACTIONS(409),
    [sym_keyword_returning] = ACTIONS(409),
    [sym_keyword_between] = ACTIONS(409),
    [sym_keyword_preceding] = ACTIONS(409),
    [sym_keyword_following] = ACTIONS(409),
    [aux_sym_keyword_like_token1] = ACTIONS(409),
    [aux_sym_keyword_like_token2] = ACTIONS(409),
    [sym_keyword_similar] = ACTIONS(409),
    [sym_keyword_unsigned] = ACTIONS(411),
    [sym_keyword_zerofill] = ACTIONS(413),
    [sym_keyword_cache] = ACTIONS(409),
    [sym_keyword_array] = ACTIONS(409),
    [anon_sym_LBRACK] = ACTIONS(407),
    [anon_sym_RBRACK] = ACTIONS(407),
    [anon_sym_LPAREN] = ACTIONS(415),
    [anon_sym_RPAREN] = ACTIONS(407),
    [anon_sym_COMMA] = ACTIONS(407),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(409),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(407),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(407),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(407),
    [anon_sym_COLON_EQ] = ACTIONS(407),
    [anon_sym_EQ] = ACTIONS(407),
    [anon_sym_STAR] = ACTIONS(407),
    [anon_sym_COLON_COLON] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(409),
    [anon_sym_GT] = ACTIONS(409),
    [anon_sym_LT_EQ] = ACTIONS(407),
    [anon_sym_GT_EQ] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(407),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_PERCENT] = ACTIONS(407),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_PIPE_PIPE] = ACTIONS(407),
    [anon_sym_BANG_EQ] = ACTIONS(407),
    [anon_sym_LT_GT] = ACTIONS(407),
    [anon_sym_DASH_GT] = ACTIONS(409),
    [anon_sym_DASH_GT_GT] = ACTIONS(407),
    [anon_sym_POUND_GT] = ACTIONS(409),
    [anon_sym_POUND_GT_GT] = ACTIONS(407),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [anon_sym_BQUOTE] = ACTIONS(407),
  },
  [49] = {
    [sym_array_size_definition] = STATE(197),
    [sym__array_size_definition] = STATE(184),
    [sym_comment] = STATE(49),
    [sym_marginalia] = STATE(49),
    [aux_sym_array_size_definition_repeat1] = STATE(82),
    [ts_builtin_sym_end] = ACTIONS(417),
    [sym__identifier] = ACTIONS(419),
    [anon_sym_SEMI] = ACTIONS(417),
    [sym_keyword_set] = ACTIONS(419),
    [sym_keyword_from] = ACTIONS(419),
    [sym_keyword_left] = ACTIONS(419),
    [sym_keyword_right] = ACTIONS(419),
    [sym_keyword_inner] = ACTIONS(419),
    [sym_keyword_full] = ACTIONS(419),
    [sym_keyword_join] = ACTIONS(419),
    [sym_keyword_natural] = ACTIONS(419),
    [sym_keyword_on] = ACTIONS(419),
    [sym_keyword_where] = ACTIONS(419),
    [sym_keyword_create] = ACTIONS(419),
    [sym_keyword_increment] = ACTIONS(419),
    [sym_keyword_minvalue] = ACTIONS(419),
    [sym_keyword_maxvalue] = ACTIONS(419),
    [sym_keyword_owned] = ACTIONS(419),
    [sym_keyword_start] = ACTIONS(419),
    [sym_keyword_restart] = ACTIONS(419),
    [sym_keyword_as] = ACTIONS(419),
    [sym_keyword_when] = ACTIONS(419),
    [sym_keyword_then] = ACTIONS(419),
    [sym_keyword_else] = ACTIONS(419),
    [sym_keyword_end] = ACTIONS(419),
    [sym_keyword_in] = ACTIONS(419),
    [sym_keyword_and] = ACTIONS(419),
    [sym_keyword_or] = ACTIONS(419),
    [sym_keyword_is] = ACTIONS(419),
    [sym_keyword_not] = ACTIONS(419),
    [sym_keyword_using] = ACTIONS(419),
    [sym_keyword_collate] = ACTIONS(419),
    [sym_keyword_cascade] = ACTIONS(419),
    [sym_keyword_restrict] = ACTIONS(419),
    [aux_sym_keyword_with_token1] = ACTIONS(419),
    [sym_keyword_no] = ACTIONS(419),
    [sym_keyword_cycle] = ACTIONS(419),
    [sym_keyword_union] = ACTIONS(419),
    [sym_keyword_except] = ACTIONS(419),
    [sym_keyword_intersect] = ACTIONS(419),
    [sym_keyword_returning] = ACTIONS(419),
    [sym_keyword_between] = ACTIONS(419),
    [sym_keyword_preceding] = ACTIONS(419),
    [sym_keyword_following] = ACTIONS(419),
    [aux_sym_keyword_like_token1] = ACTIONS(419),
    [aux_sym_keyword_like_token2] = ACTIONS(419),
    [sym_keyword_similar] = ACTIONS(419),
    [sym_keyword_cache] = ACTIONS(419),
    [sym_keyword_array] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_RBRACK] = ACTIONS(417),
    [anon_sym_RPAREN] = ACTIONS(417),
    [anon_sym_COMMA] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(419),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(417),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(417),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(417),
    [anon_sym_COLON_EQ] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(417),
    [anon_sym_STAR] = ACTIONS(417),
    [anon_sym_COLON_COLON] = ACTIONS(417),
    [anon_sym_LT] = ACTIONS(419),
    [anon_sym_GT] = ACTIONS(419),
    [anon_sym_LT_EQ] = ACTIONS(417),
    [anon_sym_GT_EQ] = ACTIONS(417),
    [anon_sym_PLUS] = ACTIONS(417),
    [anon_sym_DASH] = ACTIONS(419),
    [anon_sym_PERCENT] = ACTIONS(417),
    [anon_sym_CARET] = ACTIONS(417),
    [anon_sym_PIPE_PIPE] = ACTIONS(417),
    [anon_sym_BANG_EQ] = ACTIONS(417),
    [anon_sym_LT_GT] = ACTIONS(417),
    [anon_sym_DASH_GT] = ACTIONS(419),
    [anon_sym_DASH_GT_GT] = ACTIONS(417),
    [anon_sym_POUND_GT] = ACTIONS(419),
    [anon_sym_POUND_GT_GT] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(417),
    [anon_sym_BQUOTE] = ACTIONS(417),
  },
  [50] = {
    [sym_comment] = STATE(50),
    [sym_marginalia] = STATE(50),
    [ts_builtin_sym_end] = ACTIONS(421),
    [sym__identifier] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(421),
    [sym_keyword_set] = ACTIONS(423),
    [sym_keyword_from] = ACTIONS(423),
    [sym_keyword_left] = ACTIONS(423),
    [sym_keyword_right] = ACTIONS(423),
    [sym_keyword_inner] = ACTIONS(423),
    [sym_keyword_full] = ACTIONS(423),
    [sym_keyword_join] = ACTIONS(423),
    [sym_keyword_natural] = ACTIONS(423),
    [sym_keyword_on] = ACTIONS(423),
    [sym_keyword_where] = ACTIONS(423),
    [sym_keyword_create] = ACTIONS(423),
    [sym_keyword_increment] = ACTIONS(423),
    [sym_keyword_minvalue] = ACTIONS(423),
    [sym_keyword_maxvalue] = ACTIONS(423),
    [sym_keyword_owned] = ACTIONS(423),
    [sym_keyword_start] = ACTIONS(423),
    [sym_keyword_restart] = ACTIONS(423),
    [sym_keyword_as] = ACTIONS(423),
    [sym_keyword_when] = ACTIONS(423),
    [sym_keyword_then] = ACTIONS(423),
    [sym_keyword_else] = ACTIONS(423),
    [sym_keyword_end] = ACTIONS(423),
    [sym_keyword_in] = ACTIONS(423),
    [sym_keyword_and] = ACTIONS(423),
    [sym_keyword_or] = ACTIONS(423),
    [sym_keyword_is] = ACTIONS(423),
    [sym_keyword_not] = ACTIONS(423),
    [sym_keyword_using] = ACTIONS(423),
    [sym_keyword_collate] = ACTIONS(423),
    [sym_keyword_cascade] = ACTIONS(423),
    [sym_keyword_restrict] = ACTIONS(423),
    [aux_sym_keyword_with_token1] = ACTIONS(423),
    [sym_keyword_no] = ACTIONS(423),
    [sym_keyword_cycle] = ACTIONS(423),
    [sym_keyword_union] = ACTIONS(423),
    [sym_keyword_except] = ACTIONS(423),
    [sym_keyword_intersect] = ACTIONS(423),
    [sym_keyword_returning] = ACTIONS(423),
    [sym_keyword_between] = ACTIONS(423),
    [sym_keyword_preceding] = ACTIONS(423),
    [sym_keyword_following] = ACTIONS(423),
    [aux_sym_keyword_like_token1] = ACTIONS(423),
    [aux_sym_keyword_like_token2] = ACTIONS(423),
    [sym_keyword_similar] = ACTIONS(423),
    [sym_keyword_unsigned] = ACTIONS(423),
    [sym_keyword_zerofill] = ACTIONS(423),
    [sym_keyword_cache] = ACTIONS(423),
    [sym_keyword_array] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(421),
    [anon_sym_RBRACK] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(421),
    [anon_sym_RPAREN] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(421),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(421),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(421),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(421),
    [anon_sym_COLON_EQ] = ACTIONS(421),
    [anon_sym_EQ] = ACTIONS(421),
    [anon_sym_STAR] = ACTIONS(421),
    [anon_sym_COLON_COLON] = ACTIONS(421),
    [anon_sym_LT] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(421),
    [anon_sym_GT_EQ] = ACTIONS(421),
    [anon_sym_PLUS] = ACTIONS(421),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(421),
    [anon_sym_CARET] = ACTIONS(421),
    [anon_sym_PIPE_PIPE] = ACTIONS(421),
    [anon_sym_BANG_EQ] = ACTIONS(421),
    [anon_sym_LT_GT] = ACTIONS(421),
    [anon_sym_DASH_GT] = ACTIONS(423),
    [anon_sym_DASH_GT_GT] = ACTIONS(421),
    [anon_sym_POUND_GT] = ACTIONS(423),
    [anon_sym_POUND_GT_GT] = ACTIONS(421),
    [anon_sym_DQUOTE] = ACTIONS(421),
    [anon_sym_BQUOTE] = ACTIONS(421),
  },
  [51] = {
    [sym_comment] = STATE(51),
    [sym_marginalia] = STATE(51),
    [ts_builtin_sym_end] = ACTIONS(425),
    [sym__identifier] = ACTIONS(427),
    [anon_sym_SEMI] = ACTIONS(425),
    [sym_keyword_set] = ACTIONS(427),
    [sym_keyword_from] = ACTIONS(427),
    [sym_keyword_left] = ACTIONS(427),
    [sym_keyword_right] = ACTIONS(427),
    [sym_keyword_inner] = ACTIONS(427),
    [sym_keyword_full] = ACTIONS(427),
    [sym_keyword_join] = ACTIONS(427),
    [sym_keyword_natural] = ACTIONS(427),
    [sym_keyword_on] = ACTIONS(427),
    [sym_keyword_where] = ACTIONS(427),
    [sym_keyword_create] = ACTIONS(427),
    [sym_keyword_increment] = ACTIONS(427),
    [sym_keyword_minvalue] = ACTIONS(427),
    [sym_keyword_maxvalue] = ACTIONS(427),
    [sym_keyword_owned] = ACTIONS(427),
    [sym_keyword_start] = ACTIONS(427),
    [sym_keyword_restart] = ACTIONS(427),
    [sym_keyword_as] = ACTIONS(427),
    [sym_keyword_when] = ACTIONS(427),
    [sym_keyword_then] = ACTIONS(427),
    [sym_keyword_else] = ACTIONS(427),
    [sym_keyword_end] = ACTIONS(427),
    [sym_keyword_in] = ACTIONS(427),
    [sym_keyword_and] = ACTIONS(427),
    [sym_keyword_or] = ACTIONS(427),
    [sym_keyword_is] = ACTIONS(427),
    [sym_keyword_not] = ACTIONS(427),
    [sym_keyword_using] = ACTIONS(427),
    [sym_keyword_collate] = ACTIONS(427),
    [sym_keyword_cascade] = ACTIONS(427),
    [sym_keyword_restrict] = ACTIONS(427),
    [aux_sym_keyword_with_token1] = ACTIONS(427),
    [sym_keyword_no] = ACTIONS(427),
    [sym_keyword_cycle] = ACTIONS(427),
    [sym_keyword_union] = ACTIONS(427),
    [sym_keyword_except] = ACTIONS(427),
    [sym_keyword_intersect] = ACTIONS(427),
    [sym_keyword_returning] = ACTIONS(427),
    [sym_keyword_between] = ACTIONS(427),
    [sym_keyword_preceding] = ACTIONS(427),
    [sym_keyword_following] = ACTIONS(427),
    [aux_sym_keyword_like_token1] = ACTIONS(427),
    [aux_sym_keyword_like_token2] = ACTIONS(427),
    [sym_keyword_similar] = ACTIONS(427),
    [sym_keyword_unsigned] = ACTIONS(427),
    [sym_keyword_zerofill] = ACTIONS(427),
    [sym_keyword_cache] = ACTIONS(427),
    [sym_keyword_array] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(425),
    [anon_sym_RBRACK] = ACTIONS(425),
    [anon_sym_LPAREN] = ACTIONS(425),
    [anon_sym_RPAREN] = ACTIONS(425),
    [anon_sym_COMMA] = ACTIONS(425),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(427),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(425),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(425),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(425),
    [anon_sym_COLON_EQ] = ACTIONS(425),
    [anon_sym_EQ] = ACTIONS(425),
    [anon_sym_STAR] = ACTIONS(425),
    [anon_sym_COLON_COLON] = ACTIONS(425),
    [anon_sym_LT] = ACTIONS(427),
    [anon_sym_GT] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(425),
    [anon_sym_GT_EQ] = ACTIONS(425),
    [anon_sym_PLUS] = ACTIONS(425),
    [anon_sym_DASH] = ACTIONS(427),
    [anon_sym_PERCENT] = ACTIONS(425),
    [anon_sym_CARET] = ACTIONS(425),
    [anon_sym_PIPE_PIPE] = ACTIONS(425),
    [anon_sym_BANG_EQ] = ACTIONS(425),
    [anon_sym_LT_GT] = ACTIONS(425),
    [anon_sym_DASH_GT] = ACTIONS(427),
    [anon_sym_DASH_GT_GT] = ACTIONS(425),
    [anon_sym_POUND_GT] = ACTIONS(427),
    [anon_sym_POUND_GT_GT] = ACTIONS(425),
    [anon_sym_DQUOTE] = ACTIONS(425),
    [anon_sym_BQUOTE] = ACTIONS(425),
  },
  [52] = {
    [sym_comment] = STATE(52),
    [sym_marginalia] = STATE(52),
    [ts_builtin_sym_end] = ACTIONS(429),
    [sym__identifier] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(429),
    [sym_keyword_set] = ACTIONS(431),
    [sym_keyword_from] = ACTIONS(431),
    [sym_keyword_left] = ACTIONS(431),
    [sym_keyword_right] = ACTIONS(431),
    [sym_keyword_inner] = ACTIONS(431),
    [sym_keyword_full] = ACTIONS(431),
    [sym_keyword_join] = ACTIONS(431),
    [sym_keyword_natural] = ACTIONS(431),
    [sym_keyword_on] = ACTIONS(431),
    [sym_keyword_where] = ACTIONS(431),
    [sym_keyword_create] = ACTIONS(431),
    [sym_keyword_increment] = ACTIONS(431),
    [sym_keyword_minvalue] = ACTIONS(431),
    [sym_keyword_maxvalue] = ACTIONS(431),
    [sym_keyword_owned] = ACTIONS(431),
    [sym_keyword_start] = ACTIONS(431),
    [sym_keyword_restart] = ACTIONS(431),
    [sym_keyword_as] = ACTIONS(431),
    [sym_keyword_when] = ACTIONS(431),
    [sym_keyword_then] = ACTIONS(431),
    [sym_keyword_else] = ACTIONS(431),
    [sym_keyword_end] = ACTIONS(431),
    [sym_keyword_in] = ACTIONS(431),
    [sym_keyword_and] = ACTIONS(431),
    [sym_keyword_or] = ACTIONS(431),
    [sym_keyword_is] = ACTIONS(431),
    [sym_keyword_not] = ACTIONS(431),
    [sym_keyword_using] = ACTIONS(431),
    [sym_keyword_collate] = ACTIONS(431),
    [sym_keyword_cascade] = ACTIONS(431),
    [sym_keyword_restrict] = ACTIONS(431),
    [aux_sym_keyword_with_token1] = ACTIONS(431),
    [sym_keyword_no] = ACTIONS(431),
    [sym_keyword_cycle] = ACTIONS(431),
    [sym_keyword_union] = ACTIONS(431),
    [sym_keyword_except] = ACTIONS(431),
    [sym_keyword_intersect] = ACTIONS(431),
    [sym_keyword_returning] = ACTIONS(431),
    [sym_keyword_between] = ACTIONS(431),
    [sym_keyword_preceding] = ACTIONS(431),
    [sym_keyword_following] = ACTIONS(431),
    [aux_sym_keyword_like_token1] = ACTIONS(431),
    [aux_sym_keyword_like_token2] = ACTIONS(431),
    [sym_keyword_similar] = ACTIONS(431),
    [sym_keyword_unsigned] = ACTIONS(433),
    [sym_keyword_zerofill] = ACTIONS(435),
    [sym_keyword_cache] = ACTIONS(431),
    [sym_keyword_array] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_RBRACK] = ACTIONS(429),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(429),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(431),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(429),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(429),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(429),
    [anon_sym_COLON_EQ] = ACTIONS(429),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_STAR] = ACTIONS(429),
    [anon_sym_COLON_COLON] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(431),
    [anon_sym_GT] = ACTIONS(431),
    [anon_sym_LT_EQ] = ACTIONS(429),
    [anon_sym_GT_EQ] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(429),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(429),
    [anon_sym_PIPE_PIPE] = ACTIONS(429),
    [anon_sym_BANG_EQ] = ACTIONS(429),
    [anon_sym_LT_GT] = ACTIONS(429),
    [anon_sym_DASH_GT] = ACTIONS(431),
    [anon_sym_DASH_GT_GT] = ACTIONS(429),
    [anon_sym_POUND_GT] = ACTIONS(431),
    [anon_sym_POUND_GT_GT] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(429),
    [anon_sym_BQUOTE] = ACTIONS(429),
  },
  [53] = {
    [sym_comment] = STATE(53),
    [sym_marginalia] = STATE(53),
    [ts_builtin_sym_end] = ACTIONS(439),
    [sym__identifier] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(439),
    [sym_keyword_set] = ACTIONS(441),
    [sym_keyword_from] = ACTIONS(441),
    [sym_keyword_left] = ACTIONS(441),
    [sym_keyword_right] = ACTIONS(441),
    [sym_keyword_inner] = ACTIONS(441),
    [sym_keyword_full] = ACTIONS(441),
    [sym_keyword_join] = ACTIONS(441),
    [sym_keyword_natural] = ACTIONS(441),
    [sym_keyword_on] = ACTIONS(441),
    [sym_keyword_where] = ACTIONS(441),
    [sym_keyword_create] = ACTIONS(441),
    [sym_keyword_increment] = ACTIONS(441),
    [sym_keyword_minvalue] = ACTIONS(441),
    [sym_keyword_maxvalue] = ACTIONS(441),
    [sym_keyword_owned] = ACTIONS(441),
    [sym_keyword_start] = ACTIONS(441),
    [sym_keyword_restart] = ACTIONS(441),
    [sym_keyword_as] = ACTIONS(441),
    [sym_keyword_when] = ACTIONS(441),
    [sym_keyword_then] = ACTIONS(441),
    [sym_keyword_else] = ACTIONS(441),
    [sym_keyword_end] = ACTIONS(441),
    [sym_keyword_in] = ACTIONS(441),
    [sym_keyword_and] = ACTIONS(441),
    [sym_keyword_or] = ACTIONS(441),
    [sym_keyword_is] = ACTIONS(441),
    [sym_keyword_not] = ACTIONS(441),
    [sym_keyword_using] = ACTIONS(441),
    [sym_keyword_collate] = ACTIONS(441),
    [sym_keyword_cascade] = ACTIONS(441),
    [sym_keyword_restrict] = ACTIONS(441),
    [aux_sym_keyword_with_token1] = ACTIONS(441),
    [sym_keyword_no] = ACTIONS(441),
    [sym_keyword_cycle] = ACTIONS(441),
    [sym_keyword_union] = ACTIONS(441),
    [sym_keyword_except] = ACTIONS(441),
    [sym_keyword_intersect] = ACTIONS(441),
    [sym_keyword_returning] = ACTIONS(441),
    [sym_keyword_between] = ACTIONS(441),
    [sym_keyword_preceding] = ACTIONS(441),
    [sym_keyword_following] = ACTIONS(441),
    [aux_sym_keyword_like_token1] = ACTIONS(441),
    [aux_sym_keyword_like_token2] = ACTIONS(441),
    [sym_keyword_similar] = ACTIONS(441),
    [sym_keyword_unsigned] = ACTIONS(441),
    [sym_keyword_zerofill] = ACTIONS(441),
    [sym_keyword_cache] = ACTIONS(441),
    [sym_keyword_array] = ACTIONS(441),
    [anon_sym_LBRACK] = ACTIONS(439),
    [anon_sym_RBRACK] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(441),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(439),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(439),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(439),
    [anon_sym_COLON_EQ] = ACTIONS(439),
    [anon_sym_EQ] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(439),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(441),
    [anon_sym_LT_EQ] = ACTIONS(439),
    [anon_sym_GT_EQ] = ACTIONS(439),
    [anon_sym_PLUS] = ACTIONS(439),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_PERCENT] = ACTIONS(439),
    [anon_sym_CARET] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_BANG_EQ] = ACTIONS(439),
    [anon_sym_LT_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(441),
    [anon_sym_DASH_GT_GT] = ACTIONS(439),
    [anon_sym_POUND_GT] = ACTIONS(441),
    [anon_sym_POUND_GT_GT] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(439),
    [anon_sym_BQUOTE] = ACTIONS(439),
  },
  [54] = {
    [sym_comment] = STATE(54),
    [sym_marginalia] = STATE(54),
    [ts_builtin_sym_end] = ACTIONS(443),
    [sym__identifier] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(443),
    [sym_keyword_set] = ACTIONS(445),
    [sym_keyword_from] = ACTIONS(445),
    [sym_keyword_left] = ACTIONS(445),
    [sym_keyword_right] = ACTIONS(445),
    [sym_keyword_inner] = ACTIONS(445),
    [sym_keyword_full] = ACTIONS(445),
    [sym_keyword_join] = ACTIONS(445),
    [sym_keyword_natural] = ACTIONS(445),
    [sym_keyword_on] = ACTIONS(445),
    [sym_keyword_where] = ACTIONS(445),
    [sym_keyword_create] = ACTIONS(445),
    [sym_keyword_increment] = ACTIONS(445),
    [sym_keyword_minvalue] = ACTIONS(445),
    [sym_keyword_maxvalue] = ACTIONS(445),
    [sym_keyword_owned] = ACTIONS(445),
    [sym_keyword_start] = ACTIONS(445),
    [sym_keyword_restart] = ACTIONS(445),
    [sym_keyword_as] = ACTIONS(445),
    [sym_keyword_when] = ACTIONS(445),
    [sym_keyword_then] = ACTIONS(445),
    [sym_keyword_else] = ACTIONS(445),
    [sym_keyword_end] = ACTIONS(445),
    [sym_keyword_in] = ACTIONS(445),
    [sym_keyword_and] = ACTIONS(445),
    [sym_keyword_or] = ACTIONS(445),
    [sym_keyword_is] = ACTIONS(445),
    [sym_keyword_not] = ACTIONS(445),
    [sym_keyword_using] = ACTIONS(445),
    [sym_keyword_collate] = ACTIONS(445),
    [sym_keyword_cascade] = ACTIONS(445),
    [sym_keyword_restrict] = ACTIONS(445),
    [aux_sym_keyword_with_token1] = ACTIONS(445),
    [sym_keyword_no] = ACTIONS(445),
    [sym_keyword_cycle] = ACTIONS(445),
    [sym_keyword_union] = ACTIONS(445),
    [sym_keyword_except] = ACTIONS(445),
    [sym_keyword_intersect] = ACTIONS(445),
    [sym_keyword_returning] = ACTIONS(445),
    [sym_keyword_between] = ACTIONS(445),
    [sym_keyword_preceding] = ACTIONS(445),
    [sym_keyword_following] = ACTIONS(445),
    [aux_sym_keyword_like_token1] = ACTIONS(445),
    [aux_sym_keyword_like_token2] = ACTIONS(445),
    [sym_keyword_similar] = ACTIONS(445),
    [sym_keyword_unsigned] = ACTIONS(445),
    [sym_keyword_zerofill] = ACTIONS(445),
    [sym_keyword_cache] = ACTIONS(445),
    [sym_keyword_array] = ACTIONS(445),
    [anon_sym_LBRACK] = ACTIONS(443),
    [anon_sym_RBRACK] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_RPAREN] = ACTIONS(443),
    [anon_sym_COMMA] = ACTIONS(443),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(445),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(443),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(443),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(443),
    [anon_sym_COLON_EQ] = ACTIONS(443),
    [anon_sym_EQ] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_COLON_COLON] = ACTIONS(443),
    [anon_sym_LT] = ACTIONS(445),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(443),
    [anon_sym_GT_EQ] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(443),
    [anon_sym_DASH] = ACTIONS(445),
    [anon_sym_PERCENT] = ACTIONS(443),
    [anon_sym_CARET] = ACTIONS(443),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_BANG_EQ] = ACTIONS(443),
    [anon_sym_LT_GT] = ACTIONS(443),
    [anon_sym_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_GT] = ACTIONS(443),
    [anon_sym_POUND_GT] = ACTIONS(445),
    [anon_sym_POUND_GT_GT] = ACTIONS(443),
    [anon_sym_DQUOTE] = ACTIONS(443),
    [anon_sym_BQUOTE] = ACTIONS(443),
  },
  [55] = {
    [sym_comment] = STATE(55),
    [sym_marginalia] = STATE(55),
    [ts_builtin_sym_end] = ACTIONS(447),
    [sym__identifier] = ACTIONS(449),
    [anon_sym_SEMI] = ACTIONS(447),
    [sym_keyword_set] = ACTIONS(449),
    [sym_keyword_from] = ACTIONS(449),
    [sym_keyword_left] = ACTIONS(449),
    [sym_keyword_right] = ACTIONS(449),
    [sym_keyword_inner] = ACTIONS(449),
    [sym_keyword_full] = ACTIONS(449),
    [sym_keyword_join] = ACTIONS(449),
    [sym_keyword_natural] = ACTIONS(449),
    [sym_keyword_on] = ACTIONS(449),
    [sym_keyword_where] = ACTIONS(449),
    [sym_keyword_offset] = ACTIONS(449),
    [sym_keyword_create] = ACTIONS(449),
    [sym_keyword_increment] = ACTIONS(449),
    [sym_keyword_minvalue] = ACTIONS(449),
    [sym_keyword_maxvalue] = ACTIONS(449),
    [sym_keyword_owned] = ACTIONS(449),
    [sym_keyword_start] = ACTIONS(449),
    [sym_keyword_restart] = ACTIONS(449),
    [sym_keyword_as] = ACTIONS(449),
    [sym_keyword_when] = ACTIONS(449),
    [sym_keyword_then] = ACTIONS(449),
    [sym_keyword_else] = ACTIONS(449),
    [sym_keyword_end] = ACTIONS(449),
    [sym_keyword_in] = ACTIONS(449),
    [sym_keyword_and] = ACTIONS(449),
    [sym_keyword_or] = ACTIONS(449),
    [sym_keyword_is] = ACTIONS(449),
    [sym_keyword_not] = ACTIONS(449),
    [sym_keyword_using] = ACTIONS(449),
    [aux_sym_keyword_with_token1] = ACTIONS(449),
    [sym_keyword_no] = ACTIONS(449),
    [sym_keyword_user] = ACTIONS(449),
    [sym_keyword_admin] = ACTIONS(449),
    [sym_keyword_password] = ACTIONS(449),
    [sym_keyword_encrypted] = ACTIONS(449),
    [sym_keyword_valid] = ACTIONS(449),
    [sym_keyword_connection] = ACTIONS(449),
    [sym_keyword_role] = ACTIONS(449),
    [sym_keyword_cycle] = ACTIONS(449),
    [sym_keyword_union] = ACTIONS(449),
    [sym_keyword_except] = ACTIONS(449),
    [sym_keyword_intersect] = ACTIONS(449),
    [sym_keyword_returning] = ACTIONS(449),
    [sym_keyword_between] = ACTIONS(449),
    [sym_keyword_preceding] = ACTIONS(449),
    [sym_keyword_following] = ACTIONS(449),
    [aux_sym_keyword_like_token1] = ACTIONS(449),
    [aux_sym_keyword_like_token2] = ACTIONS(449),
    [sym_keyword_similar] = ACTIONS(449),
    [sym_keyword_cache] = ACTIONS(449),
    [anon_sym_RBRACK] = ACTIONS(447),
    [anon_sym_RPAREN] = ACTIONS(447),
    [anon_sym_COMMA] = ACTIONS(447),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(449),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(447),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(447),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(447),
    [anon_sym_EQ] = ACTIONS(447),
    [anon_sym_DOT] = ACTIONS(447),
    [anon_sym_STAR] = ACTIONS(447),
    [anon_sym_COLON_COLON] = ACTIONS(447),
    [anon_sym_LT] = ACTIONS(449),
    [anon_sym_GT] = ACTIONS(449),
    [anon_sym_LT_EQ] = ACTIONS(447),
    [anon_sym_GT_EQ] = ACTIONS(447),
    [anon_sym_PLUS] = ACTIONS(447),
    [anon_sym_DASH] = ACTIONS(449),
    [anon_sym_PERCENT] = ACTIONS(447),
    [anon_sym_CARET] = ACTIONS(447),
    [anon_sym_PIPE_PIPE] = ACTIONS(447),
    [anon_sym_BANG_EQ] = ACTIONS(447),
    [anon_sym_LT_GT] = ACTIONS(447),
    [anon_sym_DASH_GT] = ACTIONS(449),
    [anon_sym_DASH_GT_GT] = ACTIONS(447),
    [anon_sym_POUND_GT] = ACTIONS(449),
    [anon_sym_POUND_GT_GT] = ACTIONS(447),
    [anon_sym_DQUOTE] = ACTIONS(447),
    [anon_sym_BQUOTE] = ACTIONS(447),
  },
  [56] = {
    [sym_comment] = STATE(56),
    [sym_marginalia] = STATE(56),
    [ts_builtin_sym_end] = ACTIONS(451),
    [sym__identifier] = ACTIONS(453),
    [anon_sym_SEMI] = ACTIONS(451),
    [sym_keyword_set] = ACTIONS(453),
    [sym_keyword_from] = ACTIONS(453),
    [sym_keyword_left] = ACTIONS(453),
    [sym_keyword_right] = ACTIONS(453),
    [sym_keyword_inner] = ACTIONS(453),
    [sym_keyword_full] = ACTIONS(453),
    [sym_keyword_join] = ACTIONS(453),
    [sym_keyword_natural] = ACTIONS(453),
    [sym_keyword_on] = ACTIONS(453),
    [sym_keyword_where] = ACTIONS(453),
    [sym_keyword_create] = ACTIONS(453),
    [sym_keyword_increment] = ACTIONS(453),
    [sym_keyword_minvalue] = ACTIONS(453),
    [sym_keyword_maxvalue] = ACTIONS(453),
    [sym_keyword_owned] = ACTIONS(453),
    [sym_keyword_start] = ACTIONS(453),
    [sym_keyword_restart] = ACTIONS(453),
    [sym_keyword_as] = ACTIONS(453),
    [sym_keyword_when] = ACTIONS(453),
    [sym_keyword_then] = ACTIONS(453),
    [sym_keyword_else] = ACTIONS(453),
    [sym_keyword_end] = ACTIONS(453),
    [sym_keyword_in] = ACTIONS(453),
    [sym_keyword_and] = ACTIONS(453),
    [sym_keyword_or] = ACTIONS(453),
    [sym_keyword_is] = ACTIONS(453),
    [sym_keyword_not] = ACTIONS(453),
    [sym_keyword_using] = ACTIONS(453),
    [sym_keyword_collate] = ACTIONS(453),
    [sym_keyword_cascade] = ACTIONS(453),
    [sym_keyword_restrict] = ACTIONS(453),
    [aux_sym_keyword_with_token1] = ACTIONS(453),
    [sym_keyword_no] = ACTIONS(453),
    [sym_keyword_cycle] = ACTIONS(453),
    [sym_keyword_union] = ACTIONS(453),
    [sym_keyword_except] = ACTIONS(453),
    [sym_keyword_intersect] = ACTIONS(453),
    [sym_keyword_returning] = ACTIONS(453),
    [sym_keyword_between] = ACTIONS(453),
    [sym_keyword_preceding] = ACTIONS(453),
    [sym_keyword_following] = ACTIONS(453),
    [aux_sym_keyword_like_token1] = ACTIONS(453),
    [aux_sym_keyword_like_token2] = ACTIONS(453),
    [sym_keyword_similar] = ACTIONS(453),
    [sym_keyword_cache] = ACTIONS(453),
    [sym_keyword_varying] = ACTIONS(455),
    [sym_keyword_array] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(451),
    [anon_sym_RBRACK] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(451),
    [anon_sym_RPAREN] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(451),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(453),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(451),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(451),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(451),
    [anon_sym_COLON_EQ] = ACTIONS(451),
    [anon_sym_EQ] = ACTIONS(451),
    [anon_sym_STAR] = ACTIONS(451),
    [anon_sym_COLON_COLON] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_LT_EQ] = ACTIONS(451),
    [anon_sym_GT_EQ] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(451),
    [anon_sym_DASH] = ACTIONS(453),
    [anon_sym_PERCENT] = ACTIONS(451),
    [anon_sym_CARET] = ACTIONS(451),
    [anon_sym_PIPE_PIPE] = ACTIONS(451),
    [anon_sym_BANG_EQ] = ACTIONS(451),
    [anon_sym_LT_GT] = ACTIONS(451),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_DASH_GT_GT] = ACTIONS(451),
    [anon_sym_POUND_GT] = ACTIONS(453),
    [anon_sym_POUND_GT_GT] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(451),
    [anon_sym_BQUOTE] = ACTIONS(451),
  },
  [57] = {
    [sym_comment] = STATE(57),
    [sym_marginalia] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(457),
    [sym__identifier] = ACTIONS(459),
    [anon_sym_SEMI] = ACTIONS(457),
    [sym_keyword_set] = ACTIONS(459),
    [sym_keyword_from] = ACTIONS(459),
    [sym_keyword_left] = ACTIONS(459),
    [sym_keyword_right] = ACTIONS(459),
    [sym_keyword_inner] = ACTIONS(459),
    [sym_keyword_full] = ACTIONS(459),
    [sym_keyword_join] = ACTIONS(459),
    [sym_keyword_natural] = ACTIONS(459),
    [sym_keyword_on] = ACTIONS(459),
    [sym_keyword_where] = ACTIONS(459),
    [sym_keyword_create] = ACTIONS(459),
    [sym_keyword_increment] = ACTIONS(459),
    [sym_keyword_minvalue] = ACTIONS(459),
    [sym_keyword_maxvalue] = ACTIONS(459),
    [sym_keyword_owned] = ACTIONS(459),
    [sym_keyword_start] = ACTIONS(459),
    [sym_keyword_restart] = ACTIONS(459),
    [sym_keyword_as] = ACTIONS(459),
    [sym_keyword_when] = ACTIONS(459),
    [sym_keyword_then] = ACTIONS(459),
    [sym_keyword_else] = ACTIONS(459),
    [sym_keyword_end] = ACTIONS(459),
    [sym_keyword_in] = ACTIONS(459),
    [sym_keyword_and] = ACTIONS(459),
    [sym_keyword_or] = ACTIONS(459),
    [sym_keyword_is] = ACTIONS(459),
    [sym_keyword_not] = ACTIONS(459),
    [sym_keyword_using] = ACTIONS(459),
    [sym_keyword_collate] = ACTIONS(459),
    [sym_keyword_cascade] = ACTIONS(459),
    [sym_keyword_restrict] = ACTIONS(459),
    [aux_sym_keyword_with_token1] = ACTIONS(459),
    [sym_keyword_no] = ACTIONS(459),
    [sym_keyword_cycle] = ACTIONS(459),
    [sym_keyword_union] = ACTIONS(459),
    [sym_keyword_except] = ACTIONS(459),
    [sym_keyword_intersect] = ACTIONS(459),
    [sym_keyword_returning] = ACTIONS(459),
    [sym_keyword_between] = ACTIONS(459),
    [sym_keyword_preceding] = ACTIONS(459),
    [sym_keyword_following] = ACTIONS(459),
    [aux_sym_keyword_like_token1] = ACTIONS(459),
    [aux_sym_keyword_like_token2] = ACTIONS(459),
    [sym_keyword_similar] = ACTIONS(459),
    [sym_keyword_unsigned] = ACTIONS(461),
    [sym_keyword_zerofill] = ACTIONS(463),
    [sym_keyword_cache] = ACTIONS(459),
    [sym_keyword_array] = ACTIONS(459),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_RBRACK] = ACTIONS(457),
    [anon_sym_RPAREN] = ACTIONS(457),
    [anon_sym_COMMA] = ACTIONS(457),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(459),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(457),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(457),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_EQ] = ACTIONS(457),
    [anon_sym_STAR] = ACTIONS(457),
    [anon_sym_COLON_COLON] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(459),
    [anon_sym_GT] = ACTIONS(459),
    [anon_sym_LT_EQ] = ACTIONS(457),
    [anon_sym_GT_EQ] = ACTIONS(457),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(459),
    [anon_sym_PERCENT] = ACTIONS(457),
    [anon_sym_CARET] = ACTIONS(457),
    [anon_sym_PIPE_PIPE] = ACTIONS(457),
    [anon_sym_BANG_EQ] = ACTIONS(457),
    [anon_sym_LT_GT] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(459),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_POUND_GT] = ACTIONS(459),
    [anon_sym_POUND_GT_GT] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [anon_sym_BQUOTE] = ACTIONS(457),
  },
  [58] = {
    [sym_comment] = STATE(58),
    [sym_marginalia] = STATE(58),
    [ts_builtin_sym_end] = ACTIONS(465),
    [sym__identifier] = ACTIONS(467),
    [anon_sym_SEMI] = ACTIONS(465),
    [sym_keyword_set] = ACTIONS(467),
    [sym_keyword_from] = ACTIONS(467),
    [sym_keyword_left] = ACTIONS(467),
    [sym_keyword_right] = ACTIONS(467),
    [sym_keyword_inner] = ACTIONS(467),
    [sym_keyword_full] = ACTIONS(467),
    [sym_keyword_join] = ACTIONS(467),
    [sym_keyword_natural] = ACTIONS(467),
    [sym_keyword_on] = ACTIONS(467),
    [sym_keyword_where] = ACTIONS(467),
    [sym_keyword_create] = ACTIONS(467),
    [sym_keyword_increment] = ACTIONS(467),
    [sym_keyword_minvalue] = ACTIONS(467),
    [sym_keyword_maxvalue] = ACTIONS(467),
    [sym_keyword_owned] = ACTIONS(467),
    [sym_keyword_start] = ACTIONS(467),
    [sym_keyword_restart] = ACTIONS(467),
    [sym_keyword_as] = ACTIONS(467),
    [sym_keyword_when] = ACTIONS(467),
    [sym_keyword_then] = ACTIONS(467),
    [sym_keyword_else] = ACTIONS(467),
    [sym_keyword_end] = ACTIONS(467),
    [sym_keyword_in] = ACTIONS(467),
    [sym_keyword_and] = ACTIONS(467),
    [sym_keyword_or] = ACTIONS(467),
    [sym_keyword_is] = ACTIONS(467),
    [sym_keyword_not] = ACTIONS(467),
    [sym_keyword_using] = ACTIONS(467),
    [sym_keyword_collate] = ACTIONS(467),
    [sym_keyword_cascade] = ACTIONS(467),
    [sym_keyword_restrict] = ACTIONS(467),
    [aux_sym_keyword_with_token1] = ACTIONS(467),
    [sym_keyword_no] = ACTIONS(467),
    [sym_keyword_cycle] = ACTIONS(467),
    [sym_keyword_union] = ACTIONS(467),
    [sym_keyword_except] = ACTIONS(467),
    [sym_keyword_intersect] = ACTIONS(467),
    [sym_keyword_returning] = ACTIONS(467),
    [sym_keyword_between] = ACTIONS(467),
    [sym_keyword_preceding] = ACTIONS(467),
    [sym_keyword_following] = ACTIONS(467),
    [aux_sym_keyword_like_token1] = ACTIONS(467),
    [aux_sym_keyword_like_token2] = ACTIONS(467),
    [sym_keyword_similar] = ACTIONS(467),
    [sym_keyword_unsigned] = ACTIONS(469),
    [sym_keyword_zerofill] = ACTIONS(471),
    [sym_keyword_cache] = ACTIONS(467),
    [sym_keyword_array] = ACTIONS(467),
    [anon_sym_LBRACK] = ACTIONS(465),
    [anon_sym_RBRACK] = ACTIONS(465),
    [anon_sym_RPAREN] = ACTIONS(465),
    [anon_sym_COMMA] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(467),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(465),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(465),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(465),
    [anon_sym_COLON_EQ] = ACTIONS(465),
    [anon_sym_EQ] = ACTIONS(465),
    [anon_sym_STAR] = ACTIONS(465),
    [anon_sym_COLON_COLON] = ACTIONS(465),
    [anon_sym_LT] = ACTIONS(467),
    [anon_sym_GT] = ACTIONS(467),
    [anon_sym_LT_EQ] = ACTIONS(465),
    [anon_sym_GT_EQ] = ACTIONS(465),
    [anon_sym_PLUS] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_PERCENT] = ACTIONS(465),
    [anon_sym_CARET] = ACTIONS(465),
    [anon_sym_PIPE_PIPE] = ACTIONS(465),
    [anon_sym_BANG_EQ] = ACTIONS(465),
    [anon_sym_LT_GT] = ACTIONS(465),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(465),
    [anon_sym_POUND_GT] = ACTIONS(467),
    [anon_sym_POUND_GT_GT] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [anon_sym_BQUOTE] = ACTIONS(465),
  },
  [59] = {
    [sym_comment] = STATE(59),
    [sym_marginalia] = STATE(59),
    [ts_builtin_sym_end] = ACTIONS(429),
    [sym__identifier] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(429),
    [sym_keyword_set] = ACTIONS(431),
    [sym_keyword_from] = ACTIONS(431),
    [sym_keyword_left] = ACTIONS(431),
    [sym_keyword_right] = ACTIONS(431),
    [sym_keyword_inner] = ACTIONS(431),
    [sym_keyword_full] = ACTIONS(431),
    [sym_keyword_join] = ACTIONS(431),
    [sym_keyword_natural] = ACTIONS(431),
    [sym_keyword_on] = ACTIONS(431),
    [sym_keyword_where] = ACTIONS(431),
    [sym_keyword_create] = ACTIONS(431),
    [sym_keyword_increment] = ACTIONS(431),
    [sym_keyword_minvalue] = ACTIONS(431),
    [sym_keyword_maxvalue] = ACTIONS(431),
    [sym_keyword_owned] = ACTIONS(431),
    [sym_keyword_start] = ACTIONS(431),
    [sym_keyword_restart] = ACTIONS(431),
    [sym_keyword_as] = ACTIONS(431),
    [sym_keyword_when] = ACTIONS(431),
    [sym_keyword_then] = ACTIONS(431),
    [sym_keyword_else] = ACTIONS(431),
    [sym_keyword_end] = ACTIONS(431),
    [sym_keyword_in] = ACTIONS(431),
    [sym_keyword_and] = ACTIONS(431),
    [sym_keyword_or] = ACTIONS(431),
    [sym_keyword_is] = ACTIONS(431),
    [sym_keyword_not] = ACTIONS(431),
    [sym_keyword_using] = ACTIONS(431),
    [sym_keyword_collate] = ACTIONS(431),
    [sym_keyword_cascade] = ACTIONS(431),
    [sym_keyword_restrict] = ACTIONS(431),
    [aux_sym_keyword_with_token1] = ACTIONS(431),
    [sym_keyword_no] = ACTIONS(431),
    [sym_keyword_cycle] = ACTIONS(431),
    [sym_keyword_union] = ACTIONS(431),
    [sym_keyword_except] = ACTIONS(431),
    [sym_keyword_intersect] = ACTIONS(431),
    [sym_keyword_returning] = ACTIONS(431),
    [sym_keyword_between] = ACTIONS(431),
    [sym_keyword_preceding] = ACTIONS(431),
    [sym_keyword_following] = ACTIONS(431),
    [aux_sym_keyword_like_token1] = ACTIONS(431),
    [aux_sym_keyword_like_token2] = ACTIONS(431),
    [sym_keyword_similar] = ACTIONS(431),
    [sym_keyword_cache] = ACTIONS(431),
    [sym_keyword_precision] = ACTIONS(473),
    [sym_keyword_array] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_RBRACK] = ACTIONS(429),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(429),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(431),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(429),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(429),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(429),
    [anon_sym_COLON_EQ] = ACTIONS(429),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_STAR] = ACTIONS(429),
    [anon_sym_COLON_COLON] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(431),
    [anon_sym_GT] = ACTIONS(431),
    [anon_sym_LT_EQ] = ACTIONS(429),
    [anon_sym_GT_EQ] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(429),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(429),
    [anon_sym_PIPE_PIPE] = ACTIONS(429),
    [anon_sym_BANG_EQ] = ACTIONS(429),
    [anon_sym_LT_GT] = ACTIONS(429),
    [anon_sym_DASH_GT] = ACTIONS(431),
    [anon_sym_DASH_GT_GT] = ACTIONS(429),
    [anon_sym_POUND_GT] = ACTIONS(431),
    [anon_sym_POUND_GT_GT] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(429),
    [anon_sym_BQUOTE] = ACTIONS(429),
  },
  [60] = {
    [sym_comment] = STATE(60),
    [sym_marginalia] = STATE(60),
    [ts_builtin_sym_end] = ACTIONS(477),
    [sym__identifier] = ACTIONS(479),
    [anon_sym_SEMI] = ACTIONS(477),
    [sym_keyword_set] = ACTIONS(479),
    [sym_keyword_from] = ACTIONS(479),
    [sym_keyword_left] = ACTIONS(479),
    [sym_keyword_right] = ACTIONS(479),
    [sym_keyword_inner] = ACTIONS(479),
    [sym_keyword_full] = ACTIONS(479),
    [sym_keyword_join] = ACTIONS(479),
    [sym_keyword_natural] = ACTIONS(479),
    [sym_keyword_on] = ACTIONS(479),
    [sym_keyword_where] = ACTIONS(479),
    [sym_keyword_create] = ACTIONS(479),
    [sym_keyword_increment] = ACTIONS(479),
    [sym_keyword_minvalue] = ACTIONS(479),
    [sym_keyword_maxvalue] = ACTIONS(479),
    [sym_keyword_owned] = ACTIONS(479),
    [sym_keyword_start] = ACTIONS(479),
    [sym_keyword_restart] = ACTIONS(479),
    [sym_keyword_as] = ACTIONS(479),
    [sym_keyword_when] = ACTIONS(479),
    [sym_keyword_then] = ACTIONS(479),
    [sym_keyword_else] = ACTIONS(479),
    [sym_keyword_end] = ACTIONS(479),
    [sym_keyword_in] = ACTIONS(479),
    [sym_keyword_and] = ACTIONS(479),
    [sym_keyword_or] = ACTIONS(479),
    [sym_keyword_is] = ACTIONS(479),
    [sym_keyword_not] = ACTIONS(479),
    [sym_keyword_using] = ACTIONS(479),
    [sym_keyword_collate] = ACTIONS(479),
    [sym_keyword_cascade] = ACTIONS(479),
    [sym_keyword_restrict] = ACTIONS(479),
    [aux_sym_keyword_with_token1] = ACTIONS(479),
    [sym_keyword_no] = ACTIONS(479),
    [sym_keyword_cycle] = ACTIONS(479),
    [sym_keyword_union] = ACTIONS(479),
    [sym_keyword_except] = ACTIONS(479),
    [sym_keyword_intersect] = ACTIONS(479),
    [sym_keyword_returning] = ACTIONS(479),
    [sym_keyword_between] = ACTIONS(479),
    [sym_keyword_preceding] = ACTIONS(479),
    [sym_keyword_following] = ACTIONS(479),
    [aux_sym_keyword_like_token1] = ACTIONS(479),
    [aux_sym_keyword_like_token2] = ACTIONS(479),
    [sym_keyword_similar] = ACTIONS(479),
    [sym_keyword_cache] = ACTIONS(479),
    [sym_keyword_varying] = ACTIONS(481),
    [sym_keyword_array] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_RBRACK] = ACTIONS(477),
    [anon_sym_LPAREN] = ACTIONS(483),
    [anon_sym_RPAREN] = ACTIONS(477),
    [anon_sym_COMMA] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(479),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(477),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(477),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(477),
    [anon_sym_COLON_EQ] = ACTIONS(477),
    [anon_sym_EQ] = ACTIONS(477),
    [anon_sym_STAR] = ACTIONS(477),
    [anon_sym_COLON_COLON] = ACTIONS(477),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(477),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_PERCENT] = ACTIONS(477),
    [anon_sym_CARET] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_LT_GT] = ACTIONS(477),
    [anon_sym_DASH_GT] = ACTIONS(479),
    [anon_sym_DASH_GT_GT] = ACTIONS(477),
    [anon_sym_POUND_GT] = ACTIONS(479),
    [anon_sym_POUND_GT_GT] = ACTIONS(477),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [anon_sym_BQUOTE] = ACTIONS(477),
  },
  [61] = {
    [sym_comment] = STATE(61),
    [sym_marginalia] = STATE(61),
    [ts_builtin_sym_end] = ACTIONS(485),
    [sym__identifier] = ACTIONS(487),
    [anon_sym_SEMI] = ACTIONS(485),
    [sym_keyword_set] = ACTIONS(487),
    [sym_keyword_from] = ACTIONS(487),
    [sym_keyword_left] = ACTIONS(487),
    [sym_keyword_right] = ACTIONS(487),
    [sym_keyword_inner] = ACTIONS(487),
    [sym_keyword_full] = ACTIONS(487),
    [sym_keyword_join] = ACTIONS(487),
    [sym_keyword_natural] = ACTIONS(487),
    [sym_keyword_on] = ACTIONS(487),
    [sym_keyword_where] = ACTIONS(487),
    [sym_keyword_create] = ACTIONS(487),
    [sym_keyword_increment] = ACTIONS(487),
    [sym_keyword_minvalue] = ACTIONS(487),
    [sym_keyword_maxvalue] = ACTIONS(487),
    [sym_keyword_owned] = ACTIONS(487),
    [sym_keyword_start] = ACTIONS(487),
    [sym_keyword_restart] = ACTIONS(487),
    [sym_keyword_as] = ACTIONS(487),
    [sym_keyword_when] = ACTIONS(487),
    [sym_keyword_then] = ACTIONS(487),
    [sym_keyword_else] = ACTIONS(487),
    [sym_keyword_end] = ACTIONS(487),
    [sym_keyword_in] = ACTIONS(487),
    [sym_keyword_and] = ACTIONS(487),
    [sym_keyword_or] = ACTIONS(487),
    [sym_keyword_is] = ACTIONS(487),
    [sym_keyword_not] = ACTIONS(487),
    [sym_keyword_using] = ACTIONS(487),
    [sym_keyword_collate] = ACTIONS(487),
    [sym_keyword_cascade] = ACTIONS(487),
    [sym_keyword_restrict] = ACTIONS(487),
    [aux_sym_keyword_with_token1] = ACTIONS(487),
    [sym_keyword_no] = ACTIONS(487),
    [sym_keyword_cycle] = ACTIONS(487),
    [sym_keyword_union] = ACTIONS(487),
    [sym_keyword_except] = ACTIONS(487),
    [sym_keyword_intersect] = ACTIONS(487),
    [sym_keyword_returning] = ACTIONS(487),
    [sym_keyword_between] = ACTIONS(487),
    [sym_keyword_preceding] = ACTIONS(487),
    [sym_keyword_following] = ACTIONS(487),
    [aux_sym_keyword_like_token1] = ACTIONS(487),
    [aux_sym_keyword_like_token2] = ACTIONS(487),
    [sym_keyword_similar] = ACTIONS(487),
    [sym_keyword_unsigned] = ACTIONS(489),
    [sym_keyword_zerofill] = ACTIONS(491),
    [sym_keyword_cache] = ACTIONS(487),
    [sym_keyword_array] = ACTIONS(487),
    [anon_sym_LBRACK] = ACTIONS(485),
    [anon_sym_RBRACK] = ACTIONS(485),
    [anon_sym_RPAREN] = ACTIONS(485),
    [anon_sym_COMMA] = ACTIONS(485),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(485),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(485),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(485),
    [anon_sym_COLON_EQ] = ACTIONS(485),
    [anon_sym_EQ] = ACTIONS(485),
    [anon_sym_STAR] = ACTIONS(485),
    [anon_sym_COLON_COLON] = ACTIONS(485),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_LT_EQ] = ACTIONS(485),
    [anon_sym_GT_EQ] = ACTIONS(485),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_PERCENT] = ACTIONS(485),
    [anon_sym_CARET] = ACTIONS(485),
    [anon_sym_PIPE_PIPE] = ACTIONS(485),
    [anon_sym_BANG_EQ] = ACTIONS(485),
    [anon_sym_LT_GT] = ACTIONS(485),
    [anon_sym_DASH_GT] = ACTIONS(487),
    [anon_sym_DASH_GT_GT] = ACTIONS(485),
    [anon_sym_POUND_GT] = ACTIONS(487),
    [anon_sym_POUND_GT_GT] = ACTIONS(485),
    [anon_sym_DQUOTE] = ACTIONS(485),
    [anon_sym_BQUOTE] = ACTIONS(485),
  },
  [62] = {
    [sym_comment] = STATE(62),
    [sym_marginalia] = STATE(62),
    [ts_builtin_sym_end] = ACTIONS(493),
    [sym__identifier] = ACTIONS(495),
    [anon_sym_SEMI] = ACTIONS(493),
    [sym_keyword_set] = ACTIONS(495),
    [sym_keyword_from] = ACTIONS(495),
    [sym_keyword_left] = ACTIONS(495),
    [sym_keyword_right] = ACTIONS(495),
    [sym_keyword_inner] = ACTIONS(495),
    [sym_keyword_full] = ACTIONS(495),
    [sym_keyword_join] = ACTIONS(495),
    [sym_keyword_natural] = ACTIONS(495),
    [sym_keyword_on] = ACTIONS(495),
    [sym_keyword_where] = ACTIONS(495),
    [sym_keyword_create] = ACTIONS(495),
    [sym_keyword_increment] = ACTIONS(495),
    [sym_keyword_minvalue] = ACTIONS(495),
    [sym_keyword_maxvalue] = ACTIONS(495),
    [sym_keyword_owned] = ACTIONS(495),
    [sym_keyword_start] = ACTIONS(495),
    [sym_keyword_restart] = ACTIONS(495),
    [sym_keyword_as] = ACTIONS(495),
    [sym_keyword_when] = ACTIONS(495),
    [sym_keyword_then] = ACTIONS(495),
    [sym_keyword_else] = ACTIONS(495),
    [sym_keyword_end] = ACTIONS(495),
    [sym_keyword_in] = ACTIONS(495),
    [sym_keyword_and] = ACTIONS(495),
    [sym_keyword_or] = ACTIONS(495),
    [sym_keyword_is] = ACTIONS(495),
    [sym_keyword_not] = ACTIONS(495),
    [sym_keyword_using] = ACTIONS(495),
    [sym_keyword_collate] = ACTIONS(495),
    [sym_keyword_cascade] = ACTIONS(495),
    [sym_keyword_restrict] = ACTIONS(495),
    [aux_sym_keyword_with_token1] = ACTIONS(495),
    [sym_keyword_no] = ACTIONS(495),
    [sym_keyword_cycle] = ACTIONS(495),
    [sym_keyword_union] = ACTIONS(495),
    [sym_keyword_except] = ACTIONS(495),
    [sym_keyword_intersect] = ACTIONS(495),
    [sym_keyword_returning] = ACTIONS(495),
    [sym_keyword_between] = ACTIONS(495),
    [sym_keyword_preceding] = ACTIONS(495),
    [sym_keyword_following] = ACTIONS(495),
    [aux_sym_keyword_like_token1] = ACTIONS(495),
    [aux_sym_keyword_like_token2] = ACTIONS(495),
    [sym_keyword_similar] = ACTIONS(495),
    [sym_keyword_unsigned] = ACTIONS(497),
    [sym_keyword_zerofill] = ACTIONS(499),
    [sym_keyword_cache] = ACTIONS(495),
    [sym_keyword_array] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(493),
    [anon_sym_RBRACK] = ACTIONS(493),
    [anon_sym_RPAREN] = ACTIONS(493),
    [anon_sym_COMMA] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(493),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(493),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(493),
    [anon_sym_COLON_EQ] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_COLON_COLON] = ACTIONS(493),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(493),
    [anon_sym_CARET] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_LT_GT] = ACTIONS(493),
    [anon_sym_DASH_GT] = ACTIONS(495),
    [anon_sym_DASH_GT_GT] = ACTIONS(493),
    [anon_sym_POUND_GT] = ACTIONS(495),
    [anon_sym_POUND_GT_GT] = ACTIONS(493),
    [anon_sym_DQUOTE] = ACTIONS(493),
    [anon_sym_BQUOTE] = ACTIONS(493),
  },
  [63] = {
    [sym_comment] = STATE(63),
    [sym_marginalia] = STATE(63),
    [ts_builtin_sym_end] = ACTIONS(501),
    [sym__identifier] = ACTIONS(503),
    [anon_sym_SEMI] = ACTIONS(501),
    [sym_keyword_set] = ACTIONS(503),
    [sym_keyword_from] = ACTIONS(503),
    [sym_keyword_left] = ACTIONS(503),
    [sym_keyword_right] = ACTIONS(503),
    [sym_keyword_inner] = ACTIONS(503),
    [sym_keyword_full] = ACTIONS(503),
    [sym_keyword_join] = ACTIONS(503),
    [sym_keyword_natural] = ACTIONS(503),
    [sym_keyword_on] = ACTIONS(503),
    [sym_keyword_where] = ACTIONS(503),
    [sym_keyword_create] = ACTIONS(503),
    [sym_keyword_increment] = ACTIONS(503),
    [sym_keyword_minvalue] = ACTIONS(503),
    [sym_keyword_maxvalue] = ACTIONS(503),
    [sym_keyword_owned] = ACTIONS(503),
    [sym_keyword_start] = ACTIONS(503),
    [sym_keyword_restart] = ACTIONS(503),
    [sym_keyword_as] = ACTIONS(503),
    [sym_keyword_when] = ACTIONS(503),
    [sym_keyword_then] = ACTIONS(503),
    [sym_keyword_else] = ACTIONS(503),
    [sym_keyword_end] = ACTIONS(503),
    [sym_keyword_in] = ACTIONS(503),
    [sym_keyword_and] = ACTIONS(503),
    [sym_keyword_or] = ACTIONS(503),
    [sym_keyword_is] = ACTIONS(503),
    [sym_keyword_not] = ACTIONS(503),
    [sym_keyword_using] = ACTIONS(503),
    [sym_keyword_collate] = ACTIONS(503),
    [sym_keyword_cascade] = ACTIONS(503),
    [sym_keyword_restrict] = ACTIONS(503),
    [aux_sym_keyword_with_token1] = ACTIONS(503),
    [sym_keyword_no] = ACTIONS(503),
    [sym_keyword_cycle] = ACTIONS(503),
    [sym_keyword_union] = ACTIONS(503),
    [sym_keyword_except] = ACTIONS(503),
    [sym_keyword_intersect] = ACTIONS(503),
    [sym_keyword_returning] = ACTIONS(503),
    [sym_keyword_between] = ACTIONS(503),
    [sym_keyword_preceding] = ACTIONS(503),
    [sym_keyword_following] = ACTIONS(503),
    [aux_sym_keyword_like_token1] = ACTIONS(503),
    [aux_sym_keyword_like_token2] = ACTIONS(503),
    [sym_keyword_similar] = ACTIONS(503),
    [sym_keyword_unsigned] = ACTIONS(505),
    [sym_keyword_zerofill] = ACTIONS(507),
    [sym_keyword_cache] = ACTIONS(503),
    [sym_keyword_array] = ACTIONS(503),
    [anon_sym_LBRACK] = ACTIONS(501),
    [anon_sym_RBRACK] = ACTIONS(501),
    [anon_sym_RPAREN] = ACTIONS(501),
    [anon_sym_COMMA] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(503),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(501),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(501),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(501),
    [anon_sym_COLON_EQ] = ACTIONS(501),
    [anon_sym_EQ] = ACTIONS(501),
    [anon_sym_STAR] = ACTIONS(501),
    [anon_sym_COLON_COLON] = ACTIONS(501),
    [anon_sym_LT] = ACTIONS(503),
    [anon_sym_GT] = ACTIONS(503),
    [anon_sym_LT_EQ] = ACTIONS(501),
    [anon_sym_GT_EQ] = ACTIONS(501),
    [anon_sym_PLUS] = ACTIONS(501),
    [anon_sym_DASH] = ACTIONS(503),
    [anon_sym_PERCENT] = ACTIONS(501),
    [anon_sym_CARET] = ACTIONS(501),
    [anon_sym_PIPE_PIPE] = ACTIONS(501),
    [anon_sym_BANG_EQ] = ACTIONS(501),
    [anon_sym_LT_GT] = ACTIONS(501),
    [anon_sym_DASH_GT] = ACTIONS(503),
    [anon_sym_DASH_GT_GT] = ACTIONS(501),
    [anon_sym_POUND_GT] = ACTIONS(503),
    [anon_sym_POUND_GT_GT] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(501),
  },
  [64] = {
    [sym_comment] = STATE(64),
    [sym_marginalia] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(509),
    [sym__identifier] = ACTIONS(511),
    [anon_sym_SEMI] = ACTIONS(509),
    [sym_keyword_set] = ACTIONS(511),
    [sym_keyword_from] = ACTIONS(511),
    [sym_keyword_left] = ACTIONS(511),
    [sym_keyword_right] = ACTIONS(511),
    [sym_keyword_inner] = ACTIONS(511),
    [sym_keyword_full] = ACTIONS(511),
    [sym_keyword_join] = ACTIONS(511),
    [sym_keyword_natural] = ACTIONS(511),
    [sym_keyword_on] = ACTIONS(511),
    [sym_keyword_where] = ACTIONS(511),
    [sym_keyword_create] = ACTIONS(511),
    [sym_keyword_increment] = ACTIONS(511),
    [sym_keyword_minvalue] = ACTIONS(511),
    [sym_keyword_maxvalue] = ACTIONS(511),
    [sym_keyword_owned] = ACTIONS(511),
    [sym_keyword_start] = ACTIONS(511),
    [sym_keyword_restart] = ACTIONS(511),
    [sym_keyword_as] = ACTIONS(511),
    [sym_keyword_when] = ACTIONS(511),
    [sym_keyword_then] = ACTIONS(511),
    [sym_keyword_else] = ACTIONS(511),
    [sym_keyword_end] = ACTIONS(511),
    [sym_keyword_in] = ACTIONS(511),
    [sym_keyword_and] = ACTIONS(511),
    [sym_keyword_or] = ACTIONS(511),
    [sym_keyword_is] = ACTIONS(511),
    [sym_keyword_not] = ACTIONS(511),
    [sym_keyword_using] = ACTIONS(511),
    [sym_keyword_collate] = ACTIONS(511),
    [sym_keyword_cascade] = ACTIONS(511),
    [sym_keyword_restrict] = ACTIONS(511),
    [aux_sym_keyword_with_token1] = ACTIONS(511),
    [sym_keyword_no] = ACTIONS(511),
    [sym_keyword_cycle] = ACTIONS(511),
    [sym_keyword_union] = ACTIONS(511),
    [sym_keyword_except] = ACTIONS(511),
    [sym_keyword_intersect] = ACTIONS(511),
    [sym_keyword_returning] = ACTIONS(511),
    [sym_keyword_between] = ACTIONS(511),
    [sym_keyword_preceding] = ACTIONS(511),
    [sym_keyword_following] = ACTIONS(511),
    [aux_sym_keyword_like_token1] = ACTIONS(511),
    [aux_sym_keyword_like_token2] = ACTIONS(511),
    [sym_keyword_similar] = ACTIONS(511),
    [sym_keyword_unsigned] = ACTIONS(513),
    [sym_keyword_zerofill] = ACTIONS(515),
    [sym_keyword_cache] = ACTIONS(511),
    [sym_keyword_array] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_RBRACK] = ACTIONS(509),
    [anon_sym_RPAREN] = ACTIONS(509),
    [anon_sym_COMMA] = ACTIONS(509),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(511),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(509),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(509),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(509),
    [anon_sym_COLON_EQ] = ACTIONS(509),
    [anon_sym_EQ] = ACTIONS(509),
    [anon_sym_STAR] = ACTIONS(509),
    [anon_sym_COLON_COLON] = ACTIONS(509),
    [anon_sym_LT] = ACTIONS(511),
    [anon_sym_GT] = ACTIONS(511),
    [anon_sym_LT_EQ] = ACTIONS(509),
    [anon_sym_GT_EQ] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT] = ACTIONS(509),
    [anon_sym_CARET] = ACTIONS(509),
    [anon_sym_PIPE_PIPE] = ACTIONS(509),
    [anon_sym_BANG_EQ] = ACTIONS(509),
    [anon_sym_LT_GT] = ACTIONS(509),
    [anon_sym_DASH_GT] = ACTIONS(511),
    [anon_sym_DASH_GT_GT] = ACTIONS(509),
    [anon_sym_POUND_GT] = ACTIONS(511),
    [anon_sym_POUND_GT_GT] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_BQUOTE] = ACTIONS(509),
  },
  [65] = {
    [sym_comment] = STATE(65),
    [sym_marginalia] = STATE(65),
    [ts_builtin_sym_end] = ACTIONS(517),
    [sym__identifier] = ACTIONS(519),
    [anon_sym_SEMI] = ACTIONS(517),
    [sym_keyword_set] = ACTIONS(519),
    [sym_keyword_from] = ACTIONS(519),
    [sym_keyword_left] = ACTIONS(519),
    [sym_keyword_right] = ACTIONS(519),
    [sym_keyword_inner] = ACTIONS(519),
    [sym_keyword_full] = ACTIONS(519),
    [sym_keyword_join] = ACTIONS(519),
    [sym_keyword_natural] = ACTIONS(519),
    [sym_keyword_on] = ACTIONS(519),
    [sym_keyword_where] = ACTIONS(519),
    [sym_keyword_create] = ACTIONS(519),
    [sym_keyword_increment] = ACTIONS(519),
    [sym_keyword_minvalue] = ACTIONS(519),
    [sym_keyword_maxvalue] = ACTIONS(519),
    [sym_keyword_owned] = ACTIONS(519),
    [sym_keyword_start] = ACTIONS(519),
    [sym_keyword_restart] = ACTIONS(519),
    [sym_keyword_as] = ACTIONS(519),
    [sym_keyword_when] = ACTIONS(519),
    [sym_keyword_then] = ACTIONS(519),
    [sym_keyword_else] = ACTIONS(519),
    [sym_keyword_end] = ACTIONS(519),
    [sym_keyword_in] = ACTIONS(519),
    [sym_keyword_and] = ACTIONS(519),
    [sym_keyword_or] = ACTIONS(519),
    [sym_keyword_is] = ACTIONS(519),
    [sym_keyword_not] = ACTIONS(519),
    [sym_keyword_using] = ACTIONS(519),
    [sym_keyword_collate] = ACTIONS(519),
    [sym_keyword_cascade] = ACTIONS(519),
    [sym_keyword_restrict] = ACTIONS(519),
    [aux_sym_keyword_with_token1] = ACTIONS(519),
    [sym_keyword_no] = ACTIONS(519),
    [sym_keyword_cycle] = ACTIONS(519),
    [sym_keyword_union] = ACTIONS(519),
    [sym_keyword_except] = ACTIONS(519),
    [sym_keyword_intersect] = ACTIONS(519),
    [sym_keyword_returning] = ACTIONS(519),
    [sym_keyword_between] = ACTIONS(519),
    [sym_keyword_preceding] = ACTIONS(519),
    [sym_keyword_following] = ACTIONS(519),
    [aux_sym_keyword_like_token1] = ACTIONS(519),
    [aux_sym_keyword_like_token2] = ACTIONS(519),
    [sym_keyword_similar] = ACTIONS(519),
    [sym_keyword_unsigned] = ACTIONS(521),
    [sym_keyword_zerofill] = ACTIONS(523),
    [sym_keyword_cache] = ACTIONS(519),
    [sym_keyword_array] = ACTIONS(519),
    [anon_sym_LBRACK] = ACTIONS(517),
    [anon_sym_RBRACK] = ACTIONS(517),
    [anon_sym_RPAREN] = ACTIONS(517),
    [anon_sym_COMMA] = ACTIONS(517),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(519),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(517),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(517),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(517),
    [anon_sym_COLON_EQ] = ACTIONS(517),
    [anon_sym_EQ] = ACTIONS(517),
    [anon_sym_STAR] = ACTIONS(517),
    [anon_sym_COLON_COLON] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(519),
    [anon_sym_GT] = ACTIONS(519),
    [anon_sym_LT_EQ] = ACTIONS(517),
    [anon_sym_GT_EQ] = ACTIONS(517),
    [anon_sym_PLUS] = ACTIONS(517),
    [anon_sym_DASH] = ACTIONS(519),
    [anon_sym_PERCENT] = ACTIONS(517),
    [anon_sym_CARET] = ACTIONS(517),
    [anon_sym_PIPE_PIPE] = ACTIONS(517),
    [anon_sym_BANG_EQ] = ACTIONS(517),
    [anon_sym_LT_GT] = ACTIONS(517),
    [anon_sym_DASH_GT] = ACTIONS(519),
    [anon_sym_DASH_GT_GT] = ACTIONS(517),
    [anon_sym_POUND_GT] = ACTIONS(519),
    [anon_sym_POUND_GT_GT] = ACTIONS(517),
    [anon_sym_DQUOTE] = ACTIONS(517),
    [anon_sym_BQUOTE] = ACTIONS(517),
  },
  [66] = {
    [sym_comment] = STATE(66),
    [sym_marginalia] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(525),
    [sym__identifier] = ACTIONS(527),
    [anon_sym_SEMI] = ACTIONS(525),
    [sym_keyword_set] = ACTIONS(527),
    [sym_keyword_from] = ACTIONS(527),
    [sym_keyword_left] = ACTIONS(527),
    [sym_keyword_right] = ACTIONS(527),
    [sym_keyword_inner] = ACTIONS(527),
    [sym_keyword_full] = ACTIONS(527),
    [sym_keyword_join] = ACTIONS(527),
    [sym_keyword_natural] = ACTIONS(527),
    [sym_keyword_on] = ACTIONS(527),
    [sym_keyword_where] = ACTIONS(527),
    [sym_keyword_create] = ACTIONS(527),
    [sym_keyword_increment] = ACTIONS(527),
    [sym_keyword_minvalue] = ACTIONS(527),
    [sym_keyword_maxvalue] = ACTIONS(527),
    [sym_keyword_owned] = ACTIONS(527),
    [sym_keyword_start] = ACTIONS(527),
    [sym_keyword_restart] = ACTIONS(527),
    [sym_keyword_as] = ACTIONS(527),
    [sym_keyword_when] = ACTIONS(527),
    [sym_keyword_then] = ACTIONS(527),
    [sym_keyword_else] = ACTIONS(527),
    [sym_keyword_end] = ACTIONS(527),
    [sym_keyword_in] = ACTIONS(527),
    [sym_keyword_and] = ACTIONS(527),
    [sym_keyword_or] = ACTIONS(527),
    [sym_keyword_is] = ACTIONS(527),
    [sym_keyword_not] = ACTIONS(527),
    [sym_keyword_using] = ACTIONS(527),
    [sym_keyword_collate] = ACTIONS(527),
    [sym_keyword_cascade] = ACTIONS(527),
    [sym_keyword_restrict] = ACTIONS(527),
    [aux_sym_keyword_with_token1] = ACTIONS(527),
    [sym_keyword_no] = ACTIONS(527),
    [sym_keyword_cycle] = ACTIONS(527),
    [sym_keyword_union] = ACTIONS(527),
    [sym_keyword_except] = ACTIONS(527),
    [sym_keyword_intersect] = ACTIONS(527),
    [sym_keyword_returning] = ACTIONS(527),
    [sym_keyword_between] = ACTIONS(527),
    [sym_keyword_preceding] = ACTIONS(527),
    [sym_keyword_following] = ACTIONS(527),
    [aux_sym_keyword_like_token1] = ACTIONS(527),
    [aux_sym_keyword_like_token2] = ACTIONS(527),
    [sym_keyword_similar] = ACTIONS(527),
    [sym_keyword_unsigned] = ACTIONS(529),
    [sym_keyword_zerofill] = ACTIONS(531),
    [sym_keyword_cache] = ACTIONS(527),
    [sym_keyword_array] = ACTIONS(527),
    [anon_sym_LBRACK] = ACTIONS(525),
    [anon_sym_RBRACK] = ACTIONS(525),
    [anon_sym_RPAREN] = ACTIONS(525),
    [anon_sym_COMMA] = ACTIONS(525),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(527),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(525),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(525),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(525),
    [anon_sym_COLON_EQ] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(525),
    [anon_sym_STAR] = ACTIONS(525),
    [anon_sym_COLON_COLON] = ACTIONS(525),
    [anon_sym_LT] = ACTIONS(527),
    [anon_sym_GT] = ACTIONS(527),
    [anon_sym_LT_EQ] = ACTIONS(525),
    [anon_sym_GT_EQ] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(525),
    [anon_sym_DASH] = ACTIONS(527),
    [anon_sym_PERCENT] = ACTIONS(525),
    [anon_sym_CARET] = ACTIONS(525),
    [anon_sym_PIPE_PIPE] = ACTIONS(525),
    [anon_sym_BANG_EQ] = ACTIONS(525),
    [anon_sym_LT_GT] = ACTIONS(525),
    [anon_sym_DASH_GT] = ACTIONS(527),
    [anon_sym_DASH_GT_GT] = ACTIONS(525),
    [anon_sym_POUND_GT] = ACTIONS(527),
    [anon_sym_POUND_GT_GT] = ACTIONS(525),
    [anon_sym_DQUOTE] = ACTIONS(525),
    [anon_sym_BQUOTE] = ACTIONS(525),
  },
  [67] = {
    [sym_comment] = STATE(67),
    [sym_marginalia] = STATE(67),
    [ts_builtin_sym_end] = ACTIONS(533),
    [sym__identifier] = ACTIONS(535),
    [anon_sym_SEMI] = ACTIONS(533),
    [sym_keyword_set] = ACTIONS(535),
    [sym_keyword_from] = ACTIONS(535),
    [sym_keyword_left] = ACTIONS(535),
    [sym_keyword_right] = ACTIONS(535),
    [sym_keyword_inner] = ACTIONS(535),
    [sym_keyword_full] = ACTIONS(535),
    [sym_keyword_join] = ACTIONS(535),
    [sym_keyword_natural] = ACTIONS(535),
    [sym_keyword_on] = ACTIONS(535),
    [sym_keyword_where] = ACTIONS(535),
    [sym_keyword_create] = ACTIONS(535),
    [sym_keyword_increment] = ACTIONS(535),
    [sym_keyword_minvalue] = ACTIONS(535),
    [sym_keyword_maxvalue] = ACTIONS(535),
    [sym_keyword_owned] = ACTIONS(535),
    [sym_keyword_start] = ACTIONS(535),
    [sym_keyword_restart] = ACTIONS(535),
    [sym_keyword_as] = ACTIONS(535),
    [sym_keyword_when] = ACTIONS(535),
    [sym_keyword_then] = ACTIONS(535),
    [sym_keyword_else] = ACTIONS(535),
    [sym_keyword_end] = ACTIONS(535),
    [sym_keyword_in] = ACTIONS(535),
    [sym_keyword_and] = ACTIONS(535),
    [sym_keyword_or] = ACTIONS(535),
    [sym_keyword_is] = ACTIONS(535),
    [sym_keyword_not] = ACTIONS(535),
    [sym_keyword_using] = ACTIONS(535),
    [sym_keyword_collate] = ACTIONS(535),
    [sym_keyword_cascade] = ACTIONS(535),
    [sym_keyword_restrict] = ACTIONS(535),
    [aux_sym_keyword_with_token1] = ACTIONS(535),
    [sym_keyword_no] = ACTIONS(535),
    [sym_keyword_cycle] = ACTIONS(535),
    [sym_keyword_union] = ACTIONS(535),
    [sym_keyword_except] = ACTIONS(535),
    [sym_keyword_intersect] = ACTIONS(535),
    [sym_keyword_returning] = ACTIONS(535),
    [sym_keyword_between] = ACTIONS(535),
    [sym_keyword_preceding] = ACTIONS(535),
    [sym_keyword_following] = ACTIONS(535),
    [aux_sym_keyword_like_token1] = ACTIONS(535),
    [aux_sym_keyword_like_token2] = ACTIONS(535),
    [sym_keyword_similar] = ACTIONS(535),
    [sym_keyword_cache] = ACTIONS(535),
    [sym_keyword_array] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(533),
    [anon_sym_RBRACK] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(537),
    [anon_sym_RPAREN] = ACTIONS(533),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(535),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(533),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(533),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(533),
    [anon_sym_COLON_EQ] = ACTIONS(533),
    [anon_sym_EQ] = ACTIONS(533),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_COLON_COLON] = ACTIONS(533),
    [anon_sym_LT] = ACTIONS(535),
    [anon_sym_GT] = ACTIONS(535),
    [anon_sym_LT_EQ] = ACTIONS(533),
    [anon_sym_GT_EQ] = ACTIONS(533),
    [anon_sym_PLUS] = ACTIONS(533),
    [anon_sym_DASH] = ACTIONS(535),
    [anon_sym_PERCENT] = ACTIONS(533),
    [anon_sym_CARET] = ACTIONS(533),
    [anon_sym_PIPE_PIPE] = ACTIONS(533),
    [anon_sym_BANG_EQ] = ACTIONS(533),
    [anon_sym_LT_GT] = ACTIONS(533),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_DASH_GT_GT] = ACTIONS(533),
    [anon_sym_POUND_GT] = ACTIONS(535),
    [anon_sym_POUND_GT_GT] = ACTIONS(533),
    [anon_sym_DQUOTE] = ACTIONS(533),
    [anon_sym_BQUOTE] = ACTIONS(533),
  },
  [68] = {
    [sym_comment] = STATE(68),
    [sym_marginalia] = STATE(68),
    [ts_builtin_sym_end] = ACTIONS(539),
    [sym__identifier] = ACTIONS(541),
    [anon_sym_SEMI] = ACTIONS(539),
    [sym_keyword_set] = ACTIONS(541),
    [sym_keyword_from] = ACTIONS(541),
    [sym_keyword_left] = ACTIONS(541),
    [sym_keyword_right] = ACTIONS(541),
    [sym_keyword_inner] = ACTIONS(541),
    [sym_keyword_full] = ACTIONS(541),
    [sym_keyword_join] = ACTIONS(541),
    [sym_keyword_natural] = ACTIONS(541),
    [sym_keyword_on] = ACTIONS(541),
    [sym_keyword_where] = ACTIONS(541),
    [sym_keyword_create] = ACTIONS(541),
    [sym_keyword_increment] = ACTIONS(541),
    [sym_keyword_minvalue] = ACTIONS(541),
    [sym_keyword_maxvalue] = ACTIONS(541),
    [sym_keyword_owned] = ACTIONS(541),
    [sym_keyword_start] = ACTIONS(541),
    [sym_keyword_restart] = ACTIONS(541),
    [sym_keyword_as] = ACTIONS(541),
    [sym_keyword_when] = ACTIONS(541),
    [sym_keyword_then] = ACTIONS(541),
    [sym_keyword_else] = ACTIONS(541),
    [sym_keyword_end] = ACTIONS(541),
    [sym_keyword_in] = ACTIONS(541),
    [sym_keyword_and] = ACTIONS(541),
    [sym_keyword_or] = ACTIONS(541),
    [sym_keyword_is] = ACTIONS(541),
    [sym_keyword_not] = ACTIONS(541),
    [sym_keyword_using] = ACTIONS(541),
    [sym_keyword_collate] = ACTIONS(541),
    [sym_keyword_cascade] = ACTIONS(541),
    [sym_keyword_restrict] = ACTIONS(541),
    [aux_sym_keyword_with_token1] = ACTIONS(541),
    [sym_keyword_no] = ACTIONS(541),
    [sym_keyword_cycle] = ACTIONS(541),
    [sym_keyword_union] = ACTIONS(541),
    [sym_keyword_except] = ACTIONS(541),
    [sym_keyword_intersect] = ACTIONS(541),
    [sym_keyword_returning] = ACTIONS(541),
    [sym_keyword_between] = ACTIONS(541),
    [sym_keyword_preceding] = ACTIONS(541),
    [sym_keyword_following] = ACTIONS(541),
    [aux_sym_keyword_like_token1] = ACTIONS(541),
    [aux_sym_keyword_like_token2] = ACTIONS(541),
    [sym_keyword_similar] = ACTIONS(541),
    [sym_keyword_cache] = ACTIONS(541),
    [sym_keyword_array] = ACTIONS(541),
    [anon_sym_LBRACK] = ACTIONS(539),
    [anon_sym_RBRACK] = ACTIONS(539),
    [anon_sym_LPAREN] = ACTIONS(543),
    [anon_sym_RPAREN] = ACTIONS(539),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(541),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(539),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(539),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(539),
    [anon_sym_COLON_EQ] = ACTIONS(539),
    [anon_sym_EQ] = ACTIONS(539),
    [anon_sym_STAR] = ACTIONS(539),
    [anon_sym_COLON_COLON] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(541),
    [anon_sym_GT] = ACTIONS(541),
    [anon_sym_LT_EQ] = ACTIONS(539),
    [anon_sym_GT_EQ] = ACTIONS(539),
    [anon_sym_PLUS] = ACTIONS(539),
    [anon_sym_DASH] = ACTIONS(541),
    [anon_sym_PERCENT] = ACTIONS(539),
    [anon_sym_CARET] = ACTIONS(539),
    [anon_sym_PIPE_PIPE] = ACTIONS(539),
    [anon_sym_BANG_EQ] = ACTIONS(539),
    [anon_sym_LT_GT] = ACTIONS(539),
    [anon_sym_DASH_GT] = ACTIONS(541),
    [anon_sym_DASH_GT_GT] = ACTIONS(539),
    [anon_sym_POUND_GT] = ACTIONS(541),
    [anon_sym_POUND_GT_GT] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [anon_sym_BQUOTE] = ACTIONS(539),
  },
  [69] = {
    [sym_comment] = STATE(69),
    [sym_marginalia] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(545),
    [sym__identifier] = ACTIONS(547),
    [anon_sym_SEMI] = ACTIONS(545),
    [sym_keyword_set] = ACTIONS(547),
    [sym_keyword_from] = ACTIONS(547),
    [sym_keyword_left] = ACTIONS(547),
    [sym_keyword_right] = ACTIONS(547),
    [sym_keyword_inner] = ACTIONS(547),
    [sym_keyword_full] = ACTIONS(547),
    [sym_keyword_join] = ACTIONS(547),
    [sym_keyword_natural] = ACTIONS(547),
    [sym_keyword_on] = ACTIONS(547),
    [sym_keyword_where] = ACTIONS(547),
    [sym_keyword_create] = ACTIONS(547),
    [sym_keyword_increment] = ACTIONS(547),
    [sym_keyword_minvalue] = ACTIONS(547),
    [sym_keyword_maxvalue] = ACTIONS(547),
    [sym_keyword_owned] = ACTIONS(547),
    [sym_keyword_start] = ACTIONS(547),
    [sym_keyword_restart] = ACTIONS(547),
    [sym_keyword_as] = ACTIONS(547),
    [sym_keyword_when] = ACTIONS(547),
    [sym_keyword_then] = ACTIONS(547),
    [sym_keyword_else] = ACTIONS(547),
    [sym_keyword_end] = ACTIONS(547),
    [sym_keyword_in] = ACTIONS(547),
    [sym_keyword_and] = ACTIONS(547),
    [sym_keyword_or] = ACTIONS(547),
    [sym_keyword_is] = ACTIONS(547),
    [sym_keyword_not] = ACTIONS(547),
    [sym_keyword_using] = ACTIONS(547),
    [sym_keyword_collate] = ACTIONS(547),
    [sym_keyword_cascade] = ACTIONS(547),
    [sym_keyword_restrict] = ACTIONS(547),
    [aux_sym_keyword_with_token1] = ACTIONS(547),
    [sym_keyword_no] = ACTIONS(547),
    [sym_keyword_cycle] = ACTIONS(547),
    [sym_keyword_union] = ACTIONS(547),
    [sym_keyword_except] = ACTIONS(547),
    [sym_keyword_intersect] = ACTIONS(547),
    [sym_keyword_returning] = ACTIONS(547),
    [sym_keyword_between] = ACTIONS(547),
    [sym_keyword_preceding] = ACTIONS(547),
    [sym_keyword_following] = ACTIONS(547),
    [aux_sym_keyword_like_token1] = ACTIONS(547),
    [aux_sym_keyword_like_token2] = ACTIONS(547),
    [sym_keyword_similar] = ACTIONS(547),
    [sym_keyword_cache] = ACTIONS(547),
    [sym_keyword_array] = ACTIONS(547),
    [anon_sym_LBRACK] = ACTIONS(545),
    [anon_sym_RBRACK] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(549),
    [anon_sym_RPAREN] = ACTIONS(545),
    [anon_sym_COMMA] = ACTIONS(545),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(547),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(545),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(545),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(545),
    [anon_sym_COLON_EQ] = ACTIONS(545),
    [anon_sym_EQ] = ACTIONS(545),
    [anon_sym_STAR] = ACTIONS(545),
    [anon_sym_COLON_COLON] = ACTIONS(545),
    [anon_sym_LT] = ACTIONS(547),
    [anon_sym_GT] = ACTIONS(547),
    [anon_sym_LT_EQ] = ACTIONS(545),
    [anon_sym_GT_EQ] = ACTIONS(545),
    [anon_sym_PLUS] = ACTIONS(545),
    [anon_sym_DASH] = ACTIONS(547),
    [anon_sym_PERCENT] = ACTIONS(545),
    [anon_sym_CARET] = ACTIONS(545),
    [anon_sym_PIPE_PIPE] = ACTIONS(545),
    [anon_sym_BANG_EQ] = ACTIONS(545),
    [anon_sym_LT_GT] = ACTIONS(545),
    [anon_sym_DASH_GT] = ACTIONS(547),
    [anon_sym_DASH_GT_GT] = ACTIONS(545),
    [anon_sym_POUND_GT] = ACTIONS(547),
    [anon_sym_POUND_GT_GT] = ACTIONS(545),
    [anon_sym_DQUOTE] = ACTIONS(545),
    [anon_sym_BQUOTE] = ACTIONS(545),
  },
  [70] = {
    [sym_comment] = STATE(70),
    [sym_marginalia] = STATE(70),
    [ts_builtin_sym_end] = ACTIONS(551),
    [sym__identifier] = ACTIONS(553),
    [anon_sym_SEMI] = ACTIONS(551),
    [sym_keyword_set] = ACTIONS(553),
    [sym_keyword_from] = ACTIONS(553),
    [sym_keyword_left] = ACTIONS(553),
    [sym_keyword_right] = ACTIONS(553),
    [sym_keyword_inner] = ACTIONS(553),
    [sym_keyword_full] = ACTIONS(553),
    [sym_keyword_join] = ACTIONS(553),
    [sym_keyword_natural] = ACTIONS(553),
    [sym_keyword_on] = ACTIONS(553),
    [sym_keyword_where] = ACTIONS(553),
    [sym_keyword_create] = ACTIONS(553),
    [sym_keyword_increment] = ACTIONS(553),
    [sym_keyword_minvalue] = ACTIONS(553),
    [sym_keyword_maxvalue] = ACTIONS(553),
    [sym_keyword_owned] = ACTIONS(553),
    [sym_keyword_start] = ACTIONS(553),
    [sym_keyword_restart] = ACTIONS(553),
    [sym_keyword_as] = ACTIONS(553),
    [sym_keyword_when] = ACTIONS(553),
    [sym_keyword_then] = ACTIONS(553),
    [sym_keyword_else] = ACTIONS(553),
    [sym_keyword_end] = ACTIONS(553),
    [sym_keyword_in] = ACTIONS(553),
    [sym_keyword_and] = ACTIONS(553),
    [sym_keyword_or] = ACTIONS(553),
    [sym_keyword_is] = ACTIONS(553),
    [sym_keyword_not] = ACTIONS(553),
    [sym_keyword_using] = ACTIONS(553),
    [sym_keyword_collate] = ACTIONS(553),
    [sym_keyword_cascade] = ACTIONS(553),
    [sym_keyword_restrict] = ACTIONS(553),
    [aux_sym_keyword_with_token1] = ACTIONS(553),
    [sym_keyword_no] = ACTIONS(553),
    [sym_keyword_cycle] = ACTIONS(553),
    [sym_keyword_union] = ACTIONS(553),
    [sym_keyword_except] = ACTIONS(553),
    [sym_keyword_intersect] = ACTIONS(553),
    [sym_keyword_returning] = ACTIONS(553),
    [sym_keyword_between] = ACTIONS(553),
    [sym_keyword_preceding] = ACTIONS(553),
    [sym_keyword_following] = ACTIONS(553),
    [aux_sym_keyword_like_token1] = ACTIONS(553),
    [aux_sym_keyword_like_token2] = ACTIONS(553),
    [sym_keyword_similar] = ACTIONS(553),
    [sym_keyword_cache] = ACTIONS(553),
    [sym_keyword_array] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(551),
    [anon_sym_RBRACK] = ACTIONS(551),
    [anon_sym_LPAREN] = ACTIONS(555),
    [anon_sym_RPAREN] = ACTIONS(551),
    [anon_sym_COMMA] = ACTIONS(551),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(553),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(551),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(551),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(551),
    [anon_sym_COLON_EQ] = ACTIONS(551),
    [anon_sym_EQ] = ACTIONS(551),
    [anon_sym_STAR] = ACTIONS(551),
    [anon_sym_COLON_COLON] = ACTIONS(551),
    [anon_sym_LT] = ACTIONS(553),
    [anon_sym_GT] = ACTIONS(553),
    [anon_sym_LT_EQ] = ACTIONS(551),
    [anon_sym_GT_EQ] = ACTIONS(551),
    [anon_sym_PLUS] = ACTIONS(551),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(551),
    [anon_sym_CARET] = ACTIONS(551),
    [anon_sym_PIPE_PIPE] = ACTIONS(551),
    [anon_sym_BANG_EQ] = ACTIONS(551),
    [anon_sym_LT_GT] = ACTIONS(551),
    [anon_sym_DASH_GT] = ACTIONS(553),
    [anon_sym_DASH_GT_GT] = ACTIONS(551),
    [anon_sym_POUND_GT] = ACTIONS(553),
    [anon_sym_POUND_GT_GT] = ACTIONS(551),
    [anon_sym_DQUOTE] = ACTIONS(551),
    [anon_sym_BQUOTE] = ACTIONS(551),
  },
  [71] = {
    [sym_comment] = STATE(71),
    [sym_marginalia] = STATE(71),
    [ts_builtin_sym_end] = ACTIONS(557),
    [sym__identifier] = ACTIONS(559),
    [anon_sym_SEMI] = ACTIONS(557),
    [sym_keyword_set] = ACTIONS(559),
    [sym_keyword_from] = ACTIONS(559),
    [sym_keyword_left] = ACTIONS(559),
    [sym_keyword_right] = ACTIONS(559),
    [sym_keyword_inner] = ACTIONS(559),
    [sym_keyword_full] = ACTIONS(559),
    [sym_keyword_join] = ACTIONS(559),
    [sym_keyword_natural] = ACTIONS(559),
    [sym_keyword_on] = ACTIONS(559),
    [sym_keyword_where] = ACTIONS(559),
    [sym_keyword_create] = ACTIONS(559),
    [sym_keyword_increment] = ACTIONS(559),
    [sym_keyword_minvalue] = ACTIONS(559),
    [sym_keyword_maxvalue] = ACTIONS(559),
    [sym_keyword_owned] = ACTIONS(559),
    [sym_keyword_start] = ACTIONS(559),
    [sym_keyword_restart] = ACTIONS(559),
    [sym_keyword_as] = ACTIONS(559),
    [sym_keyword_when] = ACTIONS(559),
    [sym_keyword_then] = ACTIONS(559),
    [sym_keyword_else] = ACTIONS(559),
    [sym_keyword_end] = ACTIONS(559),
    [sym_keyword_in] = ACTIONS(559),
    [sym_keyword_and] = ACTIONS(559),
    [sym_keyword_or] = ACTIONS(559),
    [sym_keyword_is] = ACTIONS(559),
    [sym_keyword_not] = ACTIONS(559),
    [sym_keyword_using] = ACTIONS(559),
    [sym_keyword_collate] = ACTIONS(559),
    [sym_keyword_cascade] = ACTIONS(559),
    [sym_keyword_restrict] = ACTIONS(559),
    [aux_sym_keyword_with_token1] = ACTIONS(559),
    [sym_keyword_no] = ACTIONS(559),
    [sym_keyword_cycle] = ACTIONS(559),
    [sym_keyword_union] = ACTIONS(559),
    [sym_keyword_except] = ACTIONS(559),
    [sym_keyword_intersect] = ACTIONS(559),
    [sym_keyword_returning] = ACTIONS(559),
    [sym_keyword_between] = ACTIONS(559),
    [sym_keyword_preceding] = ACTIONS(559),
    [sym_keyword_following] = ACTIONS(559),
    [aux_sym_keyword_like_token1] = ACTIONS(559),
    [aux_sym_keyword_like_token2] = ACTIONS(559),
    [sym_keyword_similar] = ACTIONS(559),
    [sym_keyword_cache] = ACTIONS(559),
    [sym_keyword_array] = ACTIONS(559),
    [anon_sym_LBRACK] = ACTIONS(557),
    [anon_sym_RBRACK] = ACTIONS(557),
    [anon_sym_LPAREN] = ACTIONS(561),
    [anon_sym_RPAREN] = ACTIONS(557),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(559),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(557),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(557),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(557),
    [anon_sym_COLON_EQ] = ACTIONS(557),
    [anon_sym_EQ] = ACTIONS(557),
    [anon_sym_STAR] = ACTIONS(557),
    [anon_sym_COLON_COLON] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(559),
    [anon_sym_GT] = ACTIONS(559),
    [anon_sym_LT_EQ] = ACTIONS(557),
    [anon_sym_GT_EQ] = ACTIONS(557),
    [anon_sym_PLUS] = ACTIONS(557),
    [anon_sym_DASH] = ACTIONS(559),
    [anon_sym_PERCENT] = ACTIONS(557),
    [anon_sym_CARET] = ACTIONS(557),
    [anon_sym_PIPE_PIPE] = ACTIONS(557),
    [anon_sym_BANG_EQ] = ACTIONS(557),
    [anon_sym_LT_GT] = ACTIONS(557),
    [anon_sym_DASH_GT] = ACTIONS(559),
    [anon_sym_DASH_GT_GT] = ACTIONS(557),
    [anon_sym_POUND_GT] = ACTIONS(559),
    [anon_sym_POUND_GT_GT] = ACTIONS(557),
    [anon_sym_DQUOTE] = ACTIONS(557),
    [anon_sym_BQUOTE] = ACTIONS(557),
  },
  [72] = {
    [sym_comment] = STATE(72),
    [sym_marginalia] = STATE(72),
    [ts_builtin_sym_end] = ACTIONS(563),
    [sym__identifier] = ACTIONS(565),
    [anon_sym_SEMI] = ACTIONS(563),
    [sym_keyword_set] = ACTIONS(565),
    [sym_keyword_from] = ACTIONS(565),
    [sym_keyword_left] = ACTIONS(565),
    [sym_keyword_right] = ACTIONS(565),
    [sym_keyword_inner] = ACTIONS(565),
    [sym_keyword_full] = ACTIONS(565),
    [sym_keyword_join] = ACTIONS(565),
    [sym_keyword_natural] = ACTIONS(565),
    [sym_keyword_on] = ACTIONS(565),
    [sym_keyword_where] = ACTIONS(565),
    [sym_keyword_create] = ACTIONS(565),
    [sym_keyword_increment] = ACTIONS(565),
    [sym_keyword_minvalue] = ACTIONS(565),
    [sym_keyword_maxvalue] = ACTIONS(565),
    [sym_keyword_owned] = ACTIONS(565),
    [sym_keyword_start] = ACTIONS(565),
    [sym_keyword_restart] = ACTIONS(565),
    [sym_keyword_as] = ACTIONS(565),
    [sym_keyword_when] = ACTIONS(565),
    [sym_keyword_then] = ACTIONS(565),
    [sym_keyword_else] = ACTIONS(565),
    [sym_keyword_end] = ACTIONS(565),
    [sym_keyword_in] = ACTIONS(565),
    [sym_keyword_and] = ACTIONS(565),
    [sym_keyword_or] = ACTIONS(565),
    [sym_keyword_is] = ACTIONS(565),
    [sym_keyword_not] = ACTIONS(565),
    [sym_keyword_using] = ACTIONS(565),
    [sym_keyword_collate] = ACTIONS(565),
    [sym_keyword_cascade] = ACTIONS(565),
    [sym_keyword_restrict] = ACTIONS(565),
    [aux_sym_keyword_with_token1] = ACTIONS(565),
    [sym_keyword_no] = ACTIONS(565),
    [sym_keyword_cycle] = ACTIONS(565),
    [sym_keyword_union] = ACTIONS(565),
    [sym_keyword_except] = ACTIONS(565),
    [sym_keyword_intersect] = ACTIONS(565),
    [sym_keyword_returning] = ACTIONS(565),
    [sym_keyword_between] = ACTIONS(565),
    [sym_keyword_preceding] = ACTIONS(565),
    [sym_keyword_following] = ACTIONS(565),
    [aux_sym_keyword_like_token1] = ACTIONS(565),
    [aux_sym_keyword_like_token2] = ACTIONS(565),
    [sym_keyword_similar] = ACTIONS(565),
    [sym_keyword_cache] = ACTIONS(565),
    [sym_keyword_array] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(563),
    [anon_sym_RBRACK] = ACTIONS(563),
    [anon_sym_LPAREN] = ACTIONS(567),
    [anon_sym_RPAREN] = ACTIONS(563),
    [anon_sym_COMMA] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(565),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(563),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(563),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(563),
    [anon_sym_COLON_EQ] = ACTIONS(563),
    [anon_sym_EQ] = ACTIONS(563),
    [anon_sym_STAR] = ACTIONS(563),
    [anon_sym_COLON_COLON] = ACTIONS(563),
    [anon_sym_LT] = ACTIONS(565),
    [anon_sym_GT] = ACTIONS(565),
    [anon_sym_LT_EQ] = ACTIONS(563),
    [anon_sym_GT_EQ] = ACTIONS(563),
    [anon_sym_PLUS] = ACTIONS(563),
    [anon_sym_DASH] = ACTIONS(565),
    [anon_sym_PERCENT] = ACTIONS(563),
    [anon_sym_CARET] = ACTIONS(563),
    [anon_sym_PIPE_PIPE] = ACTIONS(563),
    [anon_sym_BANG_EQ] = ACTIONS(563),
    [anon_sym_LT_GT] = ACTIONS(563),
    [anon_sym_DASH_GT] = ACTIONS(565),
    [anon_sym_DASH_GT_GT] = ACTIONS(563),
    [anon_sym_POUND_GT] = ACTIONS(565),
    [anon_sym_POUND_GT_GT] = ACTIONS(563),
    [anon_sym_DQUOTE] = ACTIONS(563),
    [anon_sym_BQUOTE] = ACTIONS(563),
  },
  [73] = {
    [sym_comment] = STATE(73),
    [sym_marginalia] = STATE(73),
    [ts_builtin_sym_end] = ACTIONS(569),
    [sym__identifier] = ACTIONS(571),
    [anon_sym_SEMI] = ACTIONS(569),
    [sym_keyword_set] = ACTIONS(571),
    [sym_keyword_from] = ACTIONS(571),
    [sym_keyword_left] = ACTIONS(571),
    [sym_keyword_right] = ACTIONS(571),
    [sym_keyword_inner] = ACTIONS(571),
    [sym_keyword_full] = ACTIONS(571),
    [sym_keyword_join] = ACTIONS(571),
    [sym_keyword_natural] = ACTIONS(571),
    [sym_keyword_on] = ACTIONS(571),
    [sym_keyword_where] = ACTIONS(571),
    [sym_keyword_create] = ACTIONS(571),
    [sym_keyword_increment] = ACTIONS(571),
    [sym_keyword_minvalue] = ACTIONS(571),
    [sym_keyword_maxvalue] = ACTIONS(571),
    [sym_keyword_owned] = ACTIONS(571),
    [sym_keyword_start] = ACTIONS(571),
    [sym_keyword_restart] = ACTIONS(571),
    [sym_keyword_as] = ACTIONS(571),
    [sym_keyword_when] = ACTIONS(571),
    [sym_keyword_then] = ACTIONS(571),
    [sym_keyword_else] = ACTIONS(571),
    [sym_keyword_end] = ACTIONS(571),
    [sym_keyword_in] = ACTIONS(571),
    [sym_keyword_and] = ACTIONS(571),
    [sym_keyword_or] = ACTIONS(571),
    [sym_keyword_is] = ACTIONS(571),
    [sym_keyword_not] = ACTIONS(571),
    [sym_keyword_using] = ACTIONS(571),
    [sym_keyword_collate] = ACTIONS(571),
    [sym_keyword_cascade] = ACTIONS(571),
    [sym_keyword_restrict] = ACTIONS(571),
    [aux_sym_keyword_with_token1] = ACTIONS(571),
    [sym_keyword_no] = ACTIONS(571),
    [sym_keyword_cycle] = ACTIONS(571),
    [sym_keyword_union] = ACTIONS(571),
    [sym_keyword_except] = ACTIONS(571),
    [sym_keyword_intersect] = ACTIONS(571),
    [sym_keyword_returning] = ACTIONS(571),
    [sym_keyword_between] = ACTIONS(571),
    [sym_keyword_preceding] = ACTIONS(571),
    [sym_keyword_following] = ACTIONS(571),
    [aux_sym_keyword_like_token1] = ACTIONS(571),
    [aux_sym_keyword_like_token2] = ACTIONS(571),
    [sym_keyword_similar] = ACTIONS(571),
    [sym_keyword_cache] = ACTIONS(571),
    [sym_keyword_array] = ACTIONS(571),
    [anon_sym_LBRACK] = ACTIONS(569),
    [anon_sym_RBRACK] = ACTIONS(569),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_RPAREN] = ACTIONS(569),
    [anon_sym_COMMA] = ACTIONS(569),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(571),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(569),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(569),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(569),
    [anon_sym_COLON_EQ] = ACTIONS(569),
    [anon_sym_EQ] = ACTIONS(569),
    [anon_sym_STAR] = ACTIONS(569),
    [anon_sym_COLON_COLON] = ACTIONS(569),
    [anon_sym_LT] = ACTIONS(571),
    [anon_sym_GT] = ACTIONS(571),
    [anon_sym_LT_EQ] = ACTIONS(569),
    [anon_sym_GT_EQ] = ACTIONS(569),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(571),
    [anon_sym_PERCENT] = ACTIONS(569),
    [anon_sym_CARET] = ACTIONS(569),
    [anon_sym_PIPE_PIPE] = ACTIONS(569),
    [anon_sym_BANG_EQ] = ACTIONS(569),
    [anon_sym_LT_GT] = ACTIONS(569),
    [anon_sym_DASH_GT] = ACTIONS(571),
    [anon_sym_DASH_GT_GT] = ACTIONS(569),
    [anon_sym_POUND_GT] = ACTIONS(571),
    [anon_sym_POUND_GT_GT] = ACTIONS(569),
    [anon_sym_DQUOTE] = ACTIONS(569),
    [anon_sym_BQUOTE] = ACTIONS(569),
  },
  [74] = {
    [sym_comment] = STATE(74),
    [sym_marginalia] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(573),
    [sym__identifier] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(573),
    [sym_keyword_set] = ACTIONS(575),
    [sym_keyword_from] = ACTIONS(575),
    [sym_keyword_left] = ACTIONS(575),
    [sym_keyword_right] = ACTIONS(575),
    [sym_keyword_inner] = ACTIONS(575),
    [sym_keyword_full] = ACTIONS(575),
    [sym_keyword_join] = ACTIONS(575),
    [sym_keyword_natural] = ACTIONS(575),
    [sym_keyword_on] = ACTIONS(575),
    [sym_keyword_where] = ACTIONS(575),
    [sym_keyword_create] = ACTIONS(575),
    [sym_keyword_increment] = ACTIONS(575),
    [sym_keyword_minvalue] = ACTIONS(575),
    [sym_keyword_maxvalue] = ACTIONS(575),
    [sym_keyword_owned] = ACTIONS(575),
    [sym_keyword_start] = ACTIONS(575),
    [sym_keyword_restart] = ACTIONS(575),
    [sym_keyword_as] = ACTIONS(575),
    [sym_keyword_when] = ACTIONS(575),
    [sym_keyword_then] = ACTIONS(575),
    [sym_keyword_else] = ACTIONS(575),
    [sym_keyword_end] = ACTIONS(575),
    [sym_keyword_in] = ACTIONS(575),
    [sym_keyword_and] = ACTIONS(575),
    [sym_keyword_or] = ACTIONS(575),
    [sym_keyword_is] = ACTIONS(575),
    [sym_keyword_not] = ACTIONS(575),
    [sym_keyword_using] = ACTIONS(575),
    [sym_keyword_collate] = ACTIONS(575),
    [sym_keyword_cascade] = ACTIONS(575),
    [sym_keyword_restrict] = ACTIONS(575),
    [aux_sym_keyword_with_token1] = ACTIONS(575),
    [sym_keyword_no] = ACTIONS(575),
    [sym_keyword_cycle] = ACTIONS(575),
    [sym_keyword_union] = ACTIONS(575),
    [sym_keyword_except] = ACTIONS(575),
    [sym_keyword_intersect] = ACTIONS(575),
    [sym_keyword_returning] = ACTIONS(575),
    [sym_keyword_between] = ACTIONS(575),
    [sym_keyword_preceding] = ACTIONS(575),
    [sym_keyword_following] = ACTIONS(575),
    [aux_sym_keyword_like_token1] = ACTIONS(575),
    [aux_sym_keyword_like_token2] = ACTIONS(575),
    [sym_keyword_similar] = ACTIONS(575),
    [sym_keyword_cache] = ACTIONS(575),
    [sym_keyword_array] = ACTIONS(575),
    [anon_sym_LBRACK] = ACTIONS(573),
    [anon_sym_RBRACK] = ACTIONS(573),
    [anon_sym_LPAREN] = ACTIONS(577),
    [anon_sym_RPAREN] = ACTIONS(573),
    [anon_sym_COMMA] = ACTIONS(573),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(575),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(573),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(573),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(573),
    [anon_sym_COLON_EQ] = ACTIONS(573),
    [anon_sym_EQ] = ACTIONS(573),
    [anon_sym_STAR] = ACTIONS(573),
    [anon_sym_COLON_COLON] = ACTIONS(573),
    [anon_sym_LT] = ACTIONS(575),
    [anon_sym_GT] = ACTIONS(575),
    [anon_sym_LT_EQ] = ACTIONS(573),
    [anon_sym_GT_EQ] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(573),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(573),
    [anon_sym_CARET] = ACTIONS(573),
    [anon_sym_PIPE_PIPE] = ACTIONS(573),
    [anon_sym_BANG_EQ] = ACTIONS(573),
    [anon_sym_LT_GT] = ACTIONS(573),
    [anon_sym_DASH_GT] = ACTIONS(575),
    [anon_sym_DASH_GT_GT] = ACTIONS(573),
    [anon_sym_POUND_GT] = ACTIONS(575),
    [anon_sym_POUND_GT_GT] = ACTIONS(573),
    [anon_sym_DQUOTE] = ACTIONS(573),
    [anon_sym_BQUOTE] = ACTIONS(573),
  },
  [75] = {
    [sym_comment] = STATE(75),
    [sym_marginalia] = STATE(75),
    [ts_builtin_sym_end] = ACTIONS(579),
    [sym__identifier] = ACTIONS(581),
    [anon_sym_SEMI] = ACTIONS(579),
    [sym_keyword_set] = ACTIONS(581),
    [sym_keyword_from] = ACTIONS(581),
    [sym_keyword_left] = ACTIONS(581),
    [sym_keyword_right] = ACTIONS(581),
    [sym_keyword_inner] = ACTIONS(581),
    [sym_keyword_full] = ACTIONS(581),
    [sym_keyword_join] = ACTIONS(581),
    [sym_keyword_natural] = ACTIONS(581),
    [sym_keyword_on] = ACTIONS(581),
    [sym_keyword_where] = ACTIONS(581),
    [sym_keyword_create] = ACTIONS(581),
    [sym_keyword_increment] = ACTIONS(581),
    [sym_keyword_minvalue] = ACTIONS(581),
    [sym_keyword_maxvalue] = ACTIONS(581),
    [sym_keyword_owned] = ACTIONS(581),
    [sym_keyword_start] = ACTIONS(581),
    [sym_keyword_restart] = ACTIONS(581),
    [sym_keyword_as] = ACTIONS(581),
    [sym_keyword_when] = ACTIONS(581),
    [sym_keyword_then] = ACTIONS(581),
    [sym_keyword_else] = ACTIONS(581),
    [sym_keyword_end] = ACTIONS(581),
    [sym_keyword_in] = ACTIONS(581),
    [sym_keyword_and] = ACTIONS(581),
    [sym_keyword_or] = ACTIONS(581),
    [sym_keyword_is] = ACTIONS(581),
    [sym_keyword_not] = ACTIONS(581),
    [sym_keyword_using] = ACTIONS(581),
    [sym_keyword_collate] = ACTIONS(581),
    [sym_keyword_cascade] = ACTIONS(581),
    [sym_keyword_restrict] = ACTIONS(581),
    [aux_sym_keyword_with_token1] = ACTIONS(581),
    [sym_keyword_no] = ACTIONS(581),
    [sym_keyword_cycle] = ACTIONS(581),
    [sym_keyword_union] = ACTIONS(581),
    [sym_keyword_except] = ACTIONS(581),
    [sym_keyword_intersect] = ACTIONS(581),
    [sym_keyword_returning] = ACTIONS(581),
    [sym_keyword_between] = ACTIONS(581),
    [sym_keyword_preceding] = ACTIONS(581),
    [sym_keyword_following] = ACTIONS(581),
    [aux_sym_keyword_like_token1] = ACTIONS(581),
    [aux_sym_keyword_like_token2] = ACTIONS(581),
    [sym_keyword_similar] = ACTIONS(581),
    [sym_keyword_cache] = ACTIONS(581),
    [sym_keyword_array] = ACTIONS(581),
    [anon_sym_LBRACK] = ACTIONS(579),
    [anon_sym_RBRACK] = ACTIONS(579),
    [anon_sym_LPAREN] = ACTIONS(579),
    [anon_sym_RPAREN] = ACTIONS(579),
    [anon_sym_COMMA] = ACTIONS(579),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(581),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(579),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(579),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(579),
    [anon_sym_COLON_EQ] = ACTIONS(579),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_STAR] = ACTIONS(579),
    [anon_sym_COLON_COLON] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(581),
    [anon_sym_GT] = ACTIONS(581),
    [anon_sym_LT_EQ] = ACTIONS(579),
    [anon_sym_GT_EQ] = ACTIONS(579),
    [anon_sym_PLUS] = ACTIONS(579),
    [anon_sym_DASH] = ACTIONS(581),
    [anon_sym_PERCENT] = ACTIONS(579),
    [anon_sym_CARET] = ACTIONS(579),
    [anon_sym_PIPE_PIPE] = ACTIONS(579),
    [anon_sym_BANG_EQ] = ACTIONS(579),
    [anon_sym_LT_GT] = ACTIONS(579),
    [anon_sym_DASH_GT] = ACTIONS(581),
    [anon_sym_DASH_GT_GT] = ACTIONS(579),
    [anon_sym_POUND_GT] = ACTIONS(581),
    [anon_sym_POUND_GT_GT] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(579),
    [anon_sym_BQUOTE] = ACTIONS(579),
  },
  [76] = {
    [sym_comment] = STATE(76),
    [sym_marginalia] = STATE(76),
    [ts_builtin_sym_end] = ACTIONS(583),
    [sym__identifier] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(583),
    [sym_keyword_set] = ACTIONS(585),
    [sym_keyword_from] = ACTIONS(585),
    [sym_keyword_left] = ACTIONS(585),
    [sym_keyword_right] = ACTIONS(585),
    [sym_keyword_inner] = ACTIONS(585),
    [sym_keyword_full] = ACTIONS(585),
    [sym_keyword_join] = ACTIONS(585),
    [sym_keyword_natural] = ACTIONS(585),
    [sym_keyword_on] = ACTIONS(585),
    [sym_keyword_where] = ACTIONS(585),
    [sym_keyword_create] = ACTIONS(585),
    [sym_keyword_increment] = ACTIONS(585),
    [sym_keyword_minvalue] = ACTIONS(585),
    [sym_keyword_maxvalue] = ACTIONS(585),
    [sym_keyword_owned] = ACTIONS(585),
    [sym_keyword_start] = ACTIONS(585),
    [sym_keyword_restart] = ACTIONS(585),
    [sym_keyword_as] = ACTIONS(585),
    [sym_keyword_when] = ACTIONS(585),
    [sym_keyword_then] = ACTIONS(585),
    [sym_keyword_else] = ACTIONS(585),
    [sym_keyword_end] = ACTIONS(585),
    [sym_keyword_in] = ACTIONS(585),
    [sym_keyword_and] = ACTIONS(585),
    [sym_keyword_or] = ACTIONS(585),
    [sym_keyword_is] = ACTIONS(585),
    [sym_keyword_not] = ACTIONS(585),
    [sym_keyword_using] = ACTIONS(585),
    [sym_keyword_collate] = ACTIONS(585),
    [sym_keyword_cascade] = ACTIONS(585),
    [sym_keyword_restrict] = ACTIONS(585),
    [aux_sym_keyword_with_token1] = ACTIONS(585),
    [sym_keyword_no] = ACTIONS(585),
    [sym_keyword_cycle] = ACTIONS(585),
    [sym_keyword_union] = ACTIONS(585),
    [sym_keyword_except] = ACTIONS(585),
    [sym_keyword_intersect] = ACTIONS(585),
    [sym_keyword_returning] = ACTIONS(585),
    [sym_keyword_between] = ACTIONS(585),
    [sym_keyword_preceding] = ACTIONS(585),
    [sym_keyword_following] = ACTIONS(585),
    [aux_sym_keyword_like_token1] = ACTIONS(585),
    [aux_sym_keyword_like_token2] = ACTIONS(585),
    [sym_keyword_similar] = ACTIONS(585),
    [sym_keyword_cache] = ACTIONS(585),
    [sym_keyword_array] = ACTIONS(585),
    [anon_sym_LBRACK] = ACTIONS(583),
    [anon_sym_RBRACK] = ACTIONS(583),
    [anon_sym_LPAREN] = ACTIONS(587),
    [anon_sym_RPAREN] = ACTIONS(583),
    [anon_sym_COMMA] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(585),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(583),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(583),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(583),
    [anon_sym_COLON_EQ] = ACTIONS(583),
    [anon_sym_EQ] = ACTIONS(583),
    [anon_sym_STAR] = ACTIONS(583),
    [anon_sym_COLON_COLON] = ACTIONS(583),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_GT] = ACTIONS(585),
    [anon_sym_LT_EQ] = ACTIONS(583),
    [anon_sym_GT_EQ] = ACTIONS(583),
    [anon_sym_PLUS] = ACTIONS(583),
    [anon_sym_DASH] = ACTIONS(585),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_PIPE_PIPE] = ACTIONS(583),
    [anon_sym_BANG_EQ] = ACTIONS(583),
    [anon_sym_LT_GT] = ACTIONS(583),
    [anon_sym_DASH_GT] = ACTIONS(585),
    [anon_sym_DASH_GT_GT] = ACTIONS(583),
    [anon_sym_POUND_GT] = ACTIONS(585),
    [anon_sym_POUND_GT_GT] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_BQUOTE] = ACTIONS(583),
  },
  [77] = {
    [sym_comment] = STATE(77),
    [sym_marginalia] = STATE(77),
    [ts_builtin_sym_end] = ACTIONS(589),
    [sym__identifier] = ACTIONS(591),
    [anon_sym_SEMI] = ACTIONS(589),
    [sym_keyword_set] = ACTIONS(591),
    [sym_keyword_from] = ACTIONS(591),
    [sym_keyword_left] = ACTIONS(591),
    [sym_keyword_right] = ACTIONS(591),
    [sym_keyword_inner] = ACTIONS(591),
    [sym_keyword_full] = ACTIONS(591),
    [sym_keyword_join] = ACTIONS(591),
    [sym_keyword_natural] = ACTIONS(591),
    [sym_keyword_on] = ACTIONS(591),
    [sym_keyword_where] = ACTIONS(591),
    [sym_keyword_create] = ACTIONS(591),
    [sym_keyword_increment] = ACTIONS(591),
    [sym_keyword_minvalue] = ACTIONS(591),
    [sym_keyword_maxvalue] = ACTIONS(591),
    [sym_keyword_owned] = ACTIONS(591),
    [sym_keyword_start] = ACTIONS(591),
    [sym_keyword_restart] = ACTIONS(591),
    [sym_keyword_as] = ACTIONS(591),
    [sym_keyword_when] = ACTIONS(591),
    [sym_keyword_then] = ACTIONS(591),
    [sym_keyword_else] = ACTIONS(591),
    [sym_keyword_end] = ACTIONS(591),
    [sym_keyword_in] = ACTIONS(591),
    [sym_keyword_and] = ACTIONS(591),
    [sym_keyword_or] = ACTIONS(591),
    [sym_keyword_is] = ACTIONS(591),
    [sym_keyword_not] = ACTIONS(591),
    [sym_keyword_using] = ACTIONS(591),
    [sym_keyword_collate] = ACTIONS(591),
    [sym_keyword_cascade] = ACTIONS(591),
    [sym_keyword_restrict] = ACTIONS(591),
    [aux_sym_keyword_with_token1] = ACTIONS(591),
    [sym_keyword_no] = ACTIONS(591),
    [sym_keyword_cycle] = ACTIONS(591),
    [sym_keyword_union] = ACTIONS(591),
    [sym_keyword_except] = ACTIONS(591),
    [sym_keyword_intersect] = ACTIONS(591),
    [sym_keyword_returning] = ACTIONS(591),
    [sym_keyword_between] = ACTIONS(591),
    [sym_keyword_preceding] = ACTIONS(591),
    [sym_keyword_following] = ACTIONS(591),
    [aux_sym_keyword_like_token1] = ACTIONS(591),
    [aux_sym_keyword_like_token2] = ACTIONS(591),
    [sym_keyword_similar] = ACTIONS(591),
    [sym_keyword_zerofill] = ACTIONS(593),
    [sym_keyword_cache] = ACTIONS(591),
    [sym_keyword_array] = ACTIONS(591),
    [anon_sym_LBRACK] = ACTIONS(589),
    [anon_sym_RBRACK] = ACTIONS(589),
    [anon_sym_RPAREN] = ACTIONS(589),
    [anon_sym_COMMA] = ACTIONS(589),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(591),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(589),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(589),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(589),
    [anon_sym_COLON_EQ] = ACTIONS(589),
    [anon_sym_EQ] = ACTIONS(589),
    [anon_sym_STAR] = ACTIONS(589),
    [anon_sym_COLON_COLON] = ACTIONS(589),
    [anon_sym_LT] = ACTIONS(591),
    [anon_sym_GT] = ACTIONS(591),
    [anon_sym_LT_EQ] = ACTIONS(589),
    [anon_sym_GT_EQ] = ACTIONS(589),
    [anon_sym_PLUS] = ACTIONS(589),
    [anon_sym_DASH] = ACTIONS(591),
    [anon_sym_PERCENT] = ACTIONS(589),
    [anon_sym_CARET] = ACTIONS(589),
    [anon_sym_PIPE_PIPE] = ACTIONS(589),
    [anon_sym_BANG_EQ] = ACTIONS(589),
    [anon_sym_LT_GT] = ACTIONS(589),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_DASH_GT_GT] = ACTIONS(589),
    [anon_sym_POUND_GT] = ACTIONS(591),
    [anon_sym_POUND_GT_GT] = ACTIONS(589),
    [anon_sym_DQUOTE] = ACTIONS(589),
    [anon_sym_BQUOTE] = ACTIONS(589),
  },
  [78] = {
    [sym_comment] = STATE(78),
    [sym_marginalia] = STATE(78),
    [ts_builtin_sym_end] = ACTIONS(573),
    [sym__identifier] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(573),
    [sym_keyword_set] = ACTIONS(575),
    [sym_keyword_from] = ACTIONS(575),
    [sym_keyword_left] = ACTIONS(575),
    [sym_keyword_right] = ACTIONS(575),
    [sym_keyword_inner] = ACTIONS(575),
    [sym_keyword_full] = ACTIONS(575),
    [sym_keyword_join] = ACTIONS(575),
    [sym_keyword_natural] = ACTIONS(575),
    [sym_keyword_on] = ACTIONS(575),
    [sym_keyword_where] = ACTIONS(575),
    [sym_keyword_create] = ACTIONS(575),
    [sym_keyword_increment] = ACTIONS(575),
    [sym_keyword_minvalue] = ACTIONS(575),
    [sym_keyword_maxvalue] = ACTIONS(575),
    [sym_keyword_owned] = ACTIONS(575),
    [sym_keyword_start] = ACTIONS(575),
    [sym_keyword_restart] = ACTIONS(575),
    [sym_keyword_as] = ACTIONS(575),
    [sym_keyword_when] = ACTIONS(575),
    [sym_keyword_then] = ACTIONS(575),
    [sym_keyword_else] = ACTIONS(575),
    [sym_keyword_end] = ACTIONS(575),
    [sym_keyword_in] = ACTIONS(575),
    [sym_keyword_and] = ACTIONS(575),
    [sym_keyword_or] = ACTIONS(575),
    [sym_keyword_is] = ACTIONS(575),
    [sym_keyword_not] = ACTIONS(575),
    [sym_keyword_using] = ACTIONS(575),
    [sym_keyword_collate] = ACTIONS(575),
    [sym_keyword_cascade] = ACTIONS(575),
    [sym_keyword_restrict] = ACTIONS(575),
    [aux_sym_keyword_with_token1] = ACTIONS(575),
    [sym_keyword_no] = ACTIONS(575),
    [sym_keyword_cycle] = ACTIONS(575),
    [sym_keyword_union] = ACTIONS(575),
    [sym_keyword_except] = ACTIONS(575),
    [sym_keyword_intersect] = ACTIONS(575),
    [sym_keyword_returning] = ACTIONS(575),
    [sym_keyword_between] = ACTIONS(575),
    [sym_keyword_preceding] = ACTIONS(575),
    [sym_keyword_following] = ACTIONS(575),
    [aux_sym_keyword_like_token1] = ACTIONS(575),
    [aux_sym_keyword_like_token2] = ACTIONS(575),
    [sym_keyword_similar] = ACTIONS(575),
    [sym_keyword_zerofill] = ACTIONS(595),
    [sym_keyword_cache] = ACTIONS(575),
    [sym_keyword_array] = ACTIONS(575),
    [anon_sym_LBRACK] = ACTIONS(573),
    [anon_sym_RBRACK] = ACTIONS(573),
    [anon_sym_RPAREN] = ACTIONS(573),
    [anon_sym_COMMA] = ACTIONS(573),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(575),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(573),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(573),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(573),
    [anon_sym_COLON_EQ] = ACTIONS(573),
    [anon_sym_EQ] = ACTIONS(573),
    [anon_sym_STAR] = ACTIONS(573),
    [anon_sym_COLON_COLON] = ACTIONS(573),
    [anon_sym_LT] = ACTIONS(575),
    [anon_sym_GT] = ACTIONS(575),
    [anon_sym_LT_EQ] = ACTIONS(573),
    [anon_sym_GT_EQ] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(573),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(573),
    [anon_sym_CARET] = ACTIONS(573),
    [anon_sym_PIPE_PIPE] = ACTIONS(573),
    [anon_sym_BANG_EQ] = ACTIONS(573),
    [anon_sym_LT_GT] = ACTIONS(573),
    [anon_sym_DASH_GT] = ACTIONS(575),
    [anon_sym_DASH_GT_GT] = ACTIONS(573),
    [anon_sym_POUND_GT] = ACTIONS(575),
    [anon_sym_POUND_GT_GT] = ACTIONS(573),
    [anon_sym_DQUOTE] = ACTIONS(573),
    [anon_sym_BQUOTE] = ACTIONS(573),
  },
  [79] = {
    [sym__array_size_definition] = STATE(184),
    [sym_comment] = STATE(79),
    [sym_marginalia] = STATE(79),
    [aux_sym_array_size_definition_repeat1] = STATE(79),
    [ts_builtin_sym_end] = ACTIONS(597),
    [sym__identifier] = ACTIONS(599),
    [anon_sym_SEMI] = ACTIONS(597),
    [sym_keyword_set] = ACTIONS(599),
    [sym_keyword_from] = ACTIONS(599),
    [sym_keyword_left] = ACTIONS(599),
    [sym_keyword_right] = ACTIONS(599),
    [sym_keyword_inner] = ACTIONS(599),
    [sym_keyword_full] = ACTIONS(599),
    [sym_keyword_join] = ACTIONS(599),
    [sym_keyword_natural] = ACTIONS(599),
    [sym_keyword_on] = ACTIONS(599),
    [sym_keyword_where] = ACTIONS(599),
    [sym_keyword_create] = ACTIONS(599),
    [sym_keyword_increment] = ACTIONS(599),
    [sym_keyword_minvalue] = ACTIONS(599),
    [sym_keyword_maxvalue] = ACTIONS(599),
    [sym_keyword_owned] = ACTIONS(599),
    [sym_keyword_start] = ACTIONS(599),
    [sym_keyword_restart] = ACTIONS(599),
    [sym_keyword_as] = ACTIONS(599),
    [sym_keyword_when] = ACTIONS(599),
    [sym_keyword_then] = ACTIONS(599),
    [sym_keyword_else] = ACTIONS(599),
    [sym_keyword_end] = ACTIONS(599),
    [sym_keyword_in] = ACTIONS(599),
    [sym_keyword_and] = ACTIONS(599),
    [sym_keyword_or] = ACTIONS(599),
    [sym_keyword_is] = ACTIONS(599),
    [sym_keyword_not] = ACTIONS(599),
    [sym_keyword_using] = ACTIONS(599),
    [sym_keyword_collate] = ACTIONS(599),
    [sym_keyword_cascade] = ACTIONS(599),
    [sym_keyword_restrict] = ACTIONS(599),
    [aux_sym_keyword_with_token1] = ACTIONS(599),
    [sym_keyword_no] = ACTIONS(599),
    [sym_keyword_cycle] = ACTIONS(599),
    [sym_keyword_union] = ACTIONS(599),
    [sym_keyword_except] = ACTIONS(599),
    [sym_keyword_intersect] = ACTIONS(599),
    [sym_keyword_returning] = ACTIONS(599),
    [sym_keyword_between] = ACTIONS(599),
    [sym_keyword_preceding] = ACTIONS(599),
    [sym_keyword_following] = ACTIONS(599),
    [aux_sym_keyword_like_token1] = ACTIONS(599),
    [aux_sym_keyword_like_token2] = ACTIONS(599),
    [sym_keyword_similar] = ACTIONS(599),
    [sym_keyword_cache] = ACTIONS(599),
    [anon_sym_LBRACK] = ACTIONS(601),
    [anon_sym_RBRACK] = ACTIONS(597),
    [anon_sym_RPAREN] = ACTIONS(597),
    [anon_sym_COMMA] = ACTIONS(597),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(599),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(597),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(597),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(597),
    [anon_sym_COLON_EQ] = ACTIONS(597),
    [anon_sym_EQ] = ACTIONS(597),
    [anon_sym_STAR] = ACTIONS(597),
    [anon_sym_COLON_COLON] = ACTIONS(597),
    [anon_sym_LT] = ACTIONS(599),
    [anon_sym_GT] = ACTIONS(599),
    [anon_sym_LT_EQ] = ACTIONS(597),
    [anon_sym_GT_EQ] = ACTIONS(597),
    [anon_sym_PLUS] = ACTIONS(597),
    [anon_sym_DASH] = ACTIONS(599),
    [anon_sym_PERCENT] = ACTIONS(597),
    [anon_sym_CARET] = ACTIONS(597),
    [anon_sym_PIPE_PIPE] = ACTIONS(597),
    [anon_sym_BANG_EQ] = ACTIONS(597),
    [anon_sym_LT_GT] = ACTIONS(597),
    [anon_sym_DASH_GT] = ACTIONS(599),
    [anon_sym_DASH_GT_GT] = ACTIONS(597),
    [anon_sym_POUND_GT] = ACTIONS(599),
    [anon_sym_POUND_GT_GT] = ACTIONS(597),
    [anon_sym_DQUOTE] = ACTIONS(597),
    [anon_sym_BQUOTE] = ACTIONS(597),
  },
  [80] = {
    [sym_comment] = STATE(80),
    [sym_marginalia] = STATE(80),
    [ts_builtin_sym_end] = ACTIONS(604),
    [sym__identifier] = ACTIONS(606),
    [anon_sym_SEMI] = ACTIONS(604),
    [sym_keyword_set] = ACTIONS(606),
    [sym_keyword_from] = ACTIONS(606),
    [sym_keyword_left] = ACTIONS(606),
    [sym_keyword_right] = ACTIONS(606),
    [sym_keyword_inner] = ACTIONS(606),
    [sym_keyword_full] = ACTIONS(606),
    [sym_keyword_join] = ACTIONS(606),
    [sym_keyword_natural] = ACTIONS(606),
    [sym_keyword_on] = ACTIONS(606),
    [sym_keyword_where] = ACTIONS(606),
    [sym_keyword_create] = ACTIONS(606),
    [sym_keyword_increment] = ACTIONS(606),
    [sym_keyword_minvalue] = ACTIONS(606),
    [sym_keyword_maxvalue] = ACTIONS(606),
    [sym_keyword_owned] = ACTIONS(606),
    [sym_keyword_start] = ACTIONS(606),
    [sym_keyword_restart] = ACTIONS(606),
    [sym_keyword_as] = ACTIONS(606),
    [sym_keyword_when] = ACTIONS(606),
    [sym_keyword_then] = ACTIONS(606),
    [sym_keyword_else] = ACTIONS(606),
    [sym_keyword_end] = ACTIONS(606),
    [sym_keyword_in] = ACTIONS(606),
    [sym_keyword_and] = ACTIONS(606),
    [sym_keyword_or] = ACTIONS(606),
    [sym_keyword_is] = ACTIONS(606),
    [sym_keyword_not] = ACTIONS(606),
    [sym_keyword_using] = ACTIONS(606),
    [sym_keyword_collate] = ACTIONS(606),
    [sym_keyword_cascade] = ACTIONS(606),
    [sym_keyword_restrict] = ACTIONS(606),
    [aux_sym_keyword_with_token1] = ACTIONS(606),
    [sym_keyword_no] = ACTIONS(606),
    [sym_keyword_cycle] = ACTIONS(606),
    [sym_keyword_union] = ACTIONS(606),
    [sym_keyword_except] = ACTIONS(606),
    [sym_keyword_intersect] = ACTIONS(606),
    [sym_keyword_returning] = ACTIONS(606),
    [sym_keyword_between] = ACTIONS(606),
    [sym_keyword_preceding] = ACTIONS(606),
    [sym_keyword_following] = ACTIONS(606),
    [aux_sym_keyword_like_token1] = ACTIONS(606),
    [aux_sym_keyword_like_token2] = ACTIONS(606),
    [sym_keyword_similar] = ACTIONS(606),
    [sym_keyword_zerofill] = ACTIONS(608),
    [sym_keyword_cache] = ACTIONS(606),
    [sym_keyword_array] = ACTIONS(606),
    [anon_sym_LBRACK] = ACTIONS(604),
    [anon_sym_RBRACK] = ACTIONS(604),
    [anon_sym_RPAREN] = ACTIONS(604),
    [anon_sym_COMMA] = ACTIONS(604),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(606),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(604),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(604),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(604),
    [anon_sym_COLON_EQ] = ACTIONS(604),
    [anon_sym_EQ] = ACTIONS(604),
    [anon_sym_STAR] = ACTIONS(604),
    [anon_sym_COLON_COLON] = ACTIONS(604),
    [anon_sym_LT] = ACTIONS(606),
    [anon_sym_GT] = ACTIONS(606),
    [anon_sym_LT_EQ] = ACTIONS(604),
    [anon_sym_GT_EQ] = ACTIONS(604),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_DASH] = ACTIONS(606),
    [anon_sym_PERCENT] = ACTIONS(604),
    [anon_sym_CARET] = ACTIONS(604),
    [anon_sym_PIPE_PIPE] = ACTIONS(604),
    [anon_sym_BANG_EQ] = ACTIONS(604),
    [anon_sym_LT_GT] = ACTIONS(604),
    [anon_sym_DASH_GT] = ACTIONS(606),
    [anon_sym_DASH_GT_GT] = ACTIONS(604),
    [anon_sym_POUND_GT] = ACTIONS(606),
    [anon_sym_POUND_GT_GT] = ACTIONS(604),
    [anon_sym_DQUOTE] = ACTIONS(604),
    [anon_sym_BQUOTE] = ACTIONS(604),
  },
  [81] = {
    [sym_comment] = STATE(81),
    [sym_marginalia] = STATE(81),
    [ts_builtin_sym_end] = ACTIONS(610),
    [sym__identifier] = ACTIONS(612),
    [anon_sym_SEMI] = ACTIONS(610),
    [sym_keyword_set] = ACTIONS(612),
    [sym_keyword_from] = ACTIONS(612),
    [sym_keyword_left] = ACTIONS(612),
    [sym_keyword_right] = ACTIONS(612),
    [sym_keyword_inner] = ACTIONS(612),
    [sym_keyword_full] = ACTIONS(612),
    [sym_keyword_join] = ACTIONS(612),
    [sym_keyword_natural] = ACTIONS(612),
    [sym_keyword_on] = ACTIONS(612),
    [sym_keyword_where] = ACTIONS(612),
    [sym_keyword_create] = ACTIONS(612),
    [sym_keyword_increment] = ACTIONS(612),
    [sym_keyword_minvalue] = ACTIONS(612),
    [sym_keyword_maxvalue] = ACTIONS(612),
    [sym_keyword_owned] = ACTIONS(612),
    [sym_keyword_start] = ACTIONS(612),
    [sym_keyword_restart] = ACTIONS(612),
    [sym_keyword_as] = ACTIONS(612),
    [sym_keyword_when] = ACTIONS(612),
    [sym_keyword_then] = ACTIONS(612),
    [sym_keyword_else] = ACTIONS(612),
    [sym_keyword_end] = ACTIONS(612),
    [sym_keyword_in] = ACTIONS(612),
    [sym_keyword_and] = ACTIONS(612),
    [sym_keyword_or] = ACTIONS(612),
    [sym_keyword_is] = ACTIONS(612),
    [sym_keyword_not] = ACTIONS(612),
    [sym_keyword_using] = ACTIONS(612),
    [sym_keyword_collate] = ACTIONS(612),
    [sym_keyword_cascade] = ACTIONS(612),
    [sym_keyword_restrict] = ACTIONS(612),
    [aux_sym_keyword_with_token1] = ACTIONS(612),
    [sym_keyword_no] = ACTIONS(612),
    [sym_keyword_cycle] = ACTIONS(612),
    [sym_keyword_union] = ACTIONS(612),
    [sym_keyword_except] = ACTIONS(612),
    [sym_keyword_intersect] = ACTIONS(612),
    [sym_keyword_returning] = ACTIONS(612),
    [sym_keyword_between] = ACTIONS(612),
    [sym_keyword_preceding] = ACTIONS(612),
    [sym_keyword_following] = ACTIONS(612),
    [aux_sym_keyword_like_token1] = ACTIONS(612),
    [aux_sym_keyword_like_token2] = ACTIONS(612),
    [sym_keyword_similar] = ACTIONS(612),
    [sym_keyword_cache] = ACTIONS(612),
    [sym_keyword_array] = ACTIONS(612),
    [anon_sym_LBRACK] = ACTIONS(610),
    [anon_sym_RBRACK] = ACTIONS(610),
    [anon_sym_LPAREN] = ACTIONS(614),
    [anon_sym_RPAREN] = ACTIONS(610),
    [anon_sym_COMMA] = ACTIONS(610),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(612),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(610),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(610),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(610),
    [anon_sym_COLON_EQ] = ACTIONS(610),
    [anon_sym_EQ] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_COLON_COLON] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(610),
    [anon_sym_GT_EQ] = ACTIONS(610),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PERCENT] = ACTIONS(610),
    [anon_sym_CARET] = ACTIONS(610),
    [anon_sym_PIPE_PIPE] = ACTIONS(610),
    [anon_sym_BANG_EQ] = ACTIONS(610),
    [anon_sym_LT_GT] = ACTIONS(610),
    [anon_sym_DASH_GT] = ACTIONS(612),
    [anon_sym_DASH_GT_GT] = ACTIONS(610),
    [anon_sym_POUND_GT] = ACTIONS(612),
    [anon_sym_POUND_GT_GT] = ACTIONS(610),
    [anon_sym_DQUOTE] = ACTIONS(610),
    [anon_sym_BQUOTE] = ACTIONS(610),
  },
  [82] = {
    [sym__array_size_definition] = STATE(184),
    [sym_comment] = STATE(82),
    [sym_marginalia] = STATE(82),
    [aux_sym_array_size_definition_repeat1] = STATE(79),
    [ts_builtin_sym_end] = ACTIONS(616),
    [sym__identifier] = ACTIONS(618),
    [anon_sym_SEMI] = ACTIONS(616),
    [sym_keyword_set] = ACTIONS(618),
    [sym_keyword_from] = ACTIONS(618),
    [sym_keyword_left] = ACTIONS(618),
    [sym_keyword_right] = ACTIONS(618),
    [sym_keyword_inner] = ACTIONS(618),
    [sym_keyword_full] = ACTIONS(618),
    [sym_keyword_join] = ACTIONS(618),
    [sym_keyword_natural] = ACTIONS(618),
    [sym_keyword_on] = ACTIONS(618),
    [sym_keyword_where] = ACTIONS(618),
    [sym_keyword_create] = ACTIONS(618),
    [sym_keyword_increment] = ACTIONS(618),
    [sym_keyword_minvalue] = ACTIONS(618),
    [sym_keyword_maxvalue] = ACTIONS(618),
    [sym_keyword_owned] = ACTIONS(618),
    [sym_keyword_start] = ACTIONS(618),
    [sym_keyword_restart] = ACTIONS(618),
    [sym_keyword_as] = ACTIONS(618),
    [sym_keyword_when] = ACTIONS(618),
    [sym_keyword_then] = ACTIONS(618),
    [sym_keyword_else] = ACTIONS(618),
    [sym_keyword_end] = ACTIONS(618),
    [sym_keyword_in] = ACTIONS(618),
    [sym_keyword_and] = ACTIONS(618),
    [sym_keyword_or] = ACTIONS(618),
    [sym_keyword_is] = ACTIONS(618),
    [sym_keyword_not] = ACTIONS(618),
    [sym_keyword_using] = ACTIONS(618),
    [sym_keyword_collate] = ACTIONS(618),
    [sym_keyword_cascade] = ACTIONS(618),
    [sym_keyword_restrict] = ACTIONS(618),
    [aux_sym_keyword_with_token1] = ACTIONS(618),
    [sym_keyword_no] = ACTIONS(618),
    [sym_keyword_cycle] = ACTIONS(618),
    [sym_keyword_union] = ACTIONS(618),
    [sym_keyword_except] = ACTIONS(618),
    [sym_keyword_intersect] = ACTIONS(618),
    [sym_keyword_returning] = ACTIONS(618),
    [sym_keyword_between] = ACTIONS(618),
    [sym_keyword_preceding] = ACTIONS(618),
    [sym_keyword_following] = ACTIONS(618),
    [aux_sym_keyword_like_token1] = ACTIONS(618),
    [aux_sym_keyword_like_token2] = ACTIONS(618),
    [sym_keyword_similar] = ACTIONS(618),
    [sym_keyword_cache] = ACTIONS(618),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_RBRACK] = ACTIONS(616),
    [anon_sym_RPAREN] = ACTIONS(616),
    [anon_sym_COMMA] = ACTIONS(616),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(618),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(616),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(616),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(616),
    [anon_sym_COLON_EQ] = ACTIONS(616),
    [anon_sym_EQ] = ACTIONS(616),
    [anon_sym_STAR] = ACTIONS(616),
    [anon_sym_COLON_COLON] = ACTIONS(616),
    [anon_sym_LT] = ACTIONS(618),
    [anon_sym_GT] = ACTIONS(618),
    [anon_sym_LT_EQ] = ACTIONS(616),
    [anon_sym_GT_EQ] = ACTIONS(616),
    [anon_sym_PLUS] = ACTIONS(616),
    [anon_sym_DASH] = ACTIONS(618),
    [anon_sym_PERCENT] = ACTIONS(616),
    [anon_sym_CARET] = ACTIONS(616),
    [anon_sym_PIPE_PIPE] = ACTIONS(616),
    [anon_sym_BANG_EQ] = ACTIONS(616),
    [anon_sym_LT_GT] = ACTIONS(616),
    [anon_sym_DASH_GT] = ACTIONS(618),
    [anon_sym_DASH_GT_GT] = ACTIONS(616),
    [anon_sym_POUND_GT] = ACTIONS(618),
    [anon_sym_POUND_GT_GT] = ACTIONS(616),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_BQUOTE] = ACTIONS(616),
  },
  [83] = {
    [sym_comment] = STATE(83),
    [sym_marginalia] = STATE(83),
    [ts_builtin_sym_end] = ACTIONS(583),
    [sym__identifier] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(583),
    [sym_keyword_set] = ACTIONS(585),
    [sym_keyword_from] = ACTIONS(585),
    [sym_keyword_left] = ACTIONS(585),
    [sym_keyword_right] = ACTIONS(585),
    [sym_keyword_inner] = ACTIONS(585),
    [sym_keyword_full] = ACTIONS(585),
    [sym_keyword_join] = ACTIONS(585),
    [sym_keyword_natural] = ACTIONS(585),
    [sym_keyword_on] = ACTIONS(585),
    [sym_keyword_where] = ACTIONS(585),
    [sym_keyword_create] = ACTIONS(585),
    [sym_keyword_increment] = ACTIONS(585),
    [sym_keyword_minvalue] = ACTIONS(585),
    [sym_keyword_maxvalue] = ACTIONS(585),
    [sym_keyword_owned] = ACTIONS(585),
    [sym_keyword_start] = ACTIONS(585),
    [sym_keyword_restart] = ACTIONS(585),
    [sym_keyword_as] = ACTIONS(585),
    [sym_keyword_when] = ACTIONS(585),
    [sym_keyword_then] = ACTIONS(585),
    [sym_keyword_else] = ACTIONS(585),
    [sym_keyword_end] = ACTIONS(585),
    [sym_keyword_in] = ACTIONS(585),
    [sym_keyword_and] = ACTIONS(585),
    [sym_keyword_or] = ACTIONS(585),
    [sym_keyword_is] = ACTIONS(585),
    [sym_keyword_not] = ACTIONS(585),
    [sym_keyword_using] = ACTIONS(585),
    [sym_keyword_collate] = ACTIONS(585),
    [sym_keyword_cascade] = ACTIONS(585),
    [sym_keyword_restrict] = ACTIONS(585),
    [aux_sym_keyword_with_token1] = ACTIONS(585),
    [sym_keyword_no] = ACTIONS(585),
    [sym_keyword_cycle] = ACTIONS(585),
    [sym_keyword_union] = ACTIONS(585),
    [sym_keyword_except] = ACTIONS(585),
    [sym_keyword_intersect] = ACTIONS(585),
    [sym_keyword_returning] = ACTIONS(585),
    [sym_keyword_between] = ACTIONS(585),
    [sym_keyword_preceding] = ACTIONS(585),
    [sym_keyword_following] = ACTIONS(585),
    [aux_sym_keyword_like_token1] = ACTIONS(585),
    [aux_sym_keyword_like_token2] = ACTIONS(585),
    [sym_keyword_similar] = ACTIONS(585),
    [sym_keyword_zerofill] = ACTIONS(620),
    [sym_keyword_cache] = ACTIONS(585),
    [sym_keyword_array] = ACTIONS(585),
    [anon_sym_LBRACK] = ACTIONS(583),
    [anon_sym_RBRACK] = ACTIONS(583),
    [anon_sym_RPAREN] = ACTIONS(583),
    [anon_sym_COMMA] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(585),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(583),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(583),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(583),
    [anon_sym_COLON_EQ] = ACTIONS(583),
    [anon_sym_EQ] = ACTIONS(583),
    [anon_sym_STAR] = ACTIONS(583),
    [anon_sym_COLON_COLON] = ACTIONS(583),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_GT] = ACTIONS(585),
    [anon_sym_LT_EQ] = ACTIONS(583),
    [anon_sym_GT_EQ] = ACTIONS(583),
    [anon_sym_PLUS] = ACTIONS(583),
    [anon_sym_DASH] = ACTIONS(585),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_PIPE_PIPE] = ACTIONS(583),
    [anon_sym_BANG_EQ] = ACTIONS(583),
    [anon_sym_LT_GT] = ACTIONS(583),
    [anon_sym_DASH_GT] = ACTIONS(585),
    [anon_sym_DASH_GT_GT] = ACTIONS(583),
    [anon_sym_POUND_GT] = ACTIONS(585),
    [anon_sym_POUND_GT_GT] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_BQUOTE] = ACTIONS(583),
  },
  [84] = {
    [sym_comment] = STATE(84),
    [sym_marginalia] = STATE(84),
    [ts_builtin_sym_end] = ACTIONS(622),
    [sym__identifier] = ACTIONS(624),
    [anon_sym_SEMI] = ACTIONS(622),
    [sym_keyword_set] = ACTIONS(624),
    [sym_keyword_from] = ACTIONS(624),
    [sym_keyword_left] = ACTIONS(624),
    [sym_keyword_right] = ACTIONS(624),
    [sym_keyword_inner] = ACTIONS(624),
    [sym_keyword_full] = ACTIONS(624),
    [sym_keyword_join] = ACTIONS(624),
    [sym_keyword_natural] = ACTIONS(624),
    [sym_keyword_on] = ACTIONS(624),
    [sym_keyword_where] = ACTIONS(624),
    [sym_keyword_create] = ACTIONS(624),
    [sym_keyword_increment] = ACTIONS(624),
    [sym_keyword_minvalue] = ACTIONS(624),
    [sym_keyword_maxvalue] = ACTIONS(624),
    [sym_keyword_owned] = ACTIONS(624),
    [sym_keyword_start] = ACTIONS(624),
    [sym_keyword_restart] = ACTIONS(624),
    [sym_keyword_as] = ACTIONS(624),
    [sym_keyword_when] = ACTIONS(624),
    [sym_keyword_then] = ACTIONS(624),
    [sym_keyword_else] = ACTIONS(624),
    [sym_keyword_end] = ACTIONS(624),
    [sym_keyword_in] = ACTIONS(624),
    [sym_keyword_and] = ACTIONS(624),
    [sym_keyword_or] = ACTIONS(624),
    [sym_keyword_is] = ACTIONS(624),
    [sym_keyword_not] = ACTIONS(624),
    [sym_keyword_using] = ACTIONS(624),
    [sym_keyword_collate] = ACTIONS(624),
    [sym_keyword_cascade] = ACTIONS(624),
    [sym_keyword_restrict] = ACTIONS(624),
    [aux_sym_keyword_with_token1] = ACTIONS(624),
    [sym_keyword_no] = ACTIONS(624),
    [sym_keyword_cycle] = ACTIONS(624),
    [sym_keyword_union] = ACTIONS(624),
    [sym_keyword_except] = ACTIONS(624),
    [sym_keyword_intersect] = ACTIONS(624),
    [sym_keyword_returning] = ACTIONS(624),
    [sym_keyword_between] = ACTIONS(624),
    [sym_keyword_preceding] = ACTIONS(624),
    [sym_keyword_following] = ACTIONS(624),
    [aux_sym_keyword_like_token1] = ACTIONS(624),
    [aux_sym_keyword_like_token2] = ACTIONS(624),
    [sym_keyword_similar] = ACTIONS(624),
    [sym_keyword_cache] = ACTIONS(624),
    [sym_keyword_array] = ACTIONS(624),
    [anon_sym_LBRACK] = ACTIONS(622),
    [anon_sym_RBRACK] = ACTIONS(622),
    [anon_sym_LPAREN] = ACTIONS(626),
    [anon_sym_RPAREN] = ACTIONS(622),
    [anon_sym_COMMA] = ACTIONS(622),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(624),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(622),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(622),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(622),
    [anon_sym_COLON_EQ] = ACTIONS(622),
    [anon_sym_EQ] = ACTIONS(622),
    [anon_sym_STAR] = ACTIONS(622),
    [anon_sym_COLON_COLON] = ACTIONS(622),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_GT] = ACTIONS(624),
    [anon_sym_LT_EQ] = ACTIONS(622),
    [anon_sym_GT_EQ] = ACTIONS(622),
    [anon_sym_PLUS] = ACTIONS(622),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_PERCENT] = ACTIONS(622),
    [anon_sym_CARET] = ACTIONS(622),
    [anon_sym_PIPE_PIPE] = ACTIONS(622),
    [anon_sym_BANG_EQ] = ACTIONS(622),
    [anon_sym_LT_GT] = ACTIONS(622),
    [anon_sym_DASH_GT] = ACTIONS(624),
    [anon_sym_DASH_GT_GT] = ACTIONS(622),
    [anon_sym_POUND_GT] = ACTIONS(624),
    [anon_sym_POUND_GT_GT] = ACTIONS(622),
    [anon_sym_DQUOTE] = ACTIONS(622),
    [anon_sym_BQUOTE] = ACTIONS(622),
  },
  [85] = {
    [sym_comment] = STATE(85),
    [sym_marginalia] = STATE(85),
    [ts_builtin_sym_end] = ACTIONS(628),
    [sym__identifier] = ACTIONS(630),
    [anon_sym_SEMI] = ACTIONS(628),
    [sym_keyword_set] = ACTIONS(630),
    [sym_keyword_from] = ACTIONS(630),
    [sym_keyword_left] = ACTIONS(630),
    [sym_keyword_right] = ACTIONS(630),
    [sym_keyword_inner] = ACTIONS(630),
    [sym_keyword_full] = ACTIONS(630),
    [sym_keyword_join] = ACTIONS(630),
    [sym_keyword_natural] = ACTIONS(630),
    [sym_keyword_on] = ACTIONS(630),
    [sym_keyword_where] = ACTIONS(630),
    [sym_keyword_create] = ACTIONS(630),
    [sym_keyword_increment] = ACTIONS(630),
    [sym_keyword_minvalue] = ACTIONS(630),
    [sym_keyword_maxvalue] = ACTIONS(630),
    [sym_keyword_owned] = ACTIONS(630),
    [sym_keyword_start] = ACTIONS(630),
    [sym_keyword_restart] = ACTIONS(630),
    [sym_keyword_as] = ACTIONS(630),
    [sym_keyword_when] = ACTIONS(630),
    [sym_keyword_then] = ACTIONS(630),
    [sym_keyword_else] = ACTIONS(630),
    [sym_keyword_end] = ACTIONS(630),
    [sym_keyword_in] = ACTIONS(630),
    [sym_keyword_and] = ACTIONS(630),
    [sym_keyword_or] = ACTIONS(630),
    [sym_keyword_is] = ACTIONS(630),
    [sym_keyword_not] = ACTIONS(630),
    [sym_keyword_using] = ACTIONS(630),
    [sym_keyword_collate] = ACTIONS(630),
    [sym_keyword_cascade] = ACTIONS(630),
    [sym_keyword_restrict] = ACTIONS(630),
    [aux_sym_keyword_with_token1] = ACTIONS(630),
    [sym_keyword_no] = ACTIONS(630),
    [sym_keyword_cycle] = ACTIONS(630),
    [sym_keyword_union] = ACTIONS(630),
    [sym_keyword_except] = ACTIONS(630),
    [sym_keyword_intersect] = ACTIONS(630),
    [sym_keyword_returning] = ACTIONS(630),
    [sym_keyword_between] = ACTIONS(630),
    [sym_keyword_preceding] = ACTIONS(630),
    [sym_keyword_following] = ACTIONS(630),
    [aux_sym_keyword_like_token1] = ACTIONS(630),
    [aux_sym_keyword_like_token2] = ACTIONS(630),
    [sym_keyword_similar] = ACTIONS(630),
    [sym_keyword_cache] = ACTIONS(630),
    [sym_keyword_array] = ACTIONS(630),
    [anon_sym_LBRACK] = ACTIONS(628),
    [anon_sym_RBRACK] = ACTIONS(628),
    [anon_sym_LPAREN] = ACTIONS(632),
    [anon_sym_RPAREN] = ACTIONS(628),
    [anon_sym_COMMA] = ACTIONS(628),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(630),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(628),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(628),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(628),
    [anon_sym_COLON_EQ] = ACTIONS(628),
    [anon_sym_EQ] = ACTIONS(628),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_COLON_COLON] = ACTIONS(628),
    [anon_sym_LT] = ACTIONS(630),
    [anon_sym_GT] = ACTIONS(630),
    [anon_sym_LT_EQ] = ACTIONS(628),
    [anon_sym_GT_EQ] = ACTIONS(628),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_PERCENT] = ACTIONS(628),
    [anon_sym_CARET] = ACTIONS(628),
    [anon_sym_PIPE_PIPE] = ACTIONS(628),
    [anon_sym_BANG_EQ] = ACTIONS(628),
    [anon_sym_LT_GT] = ACTIONS(628),
    [anon_sym_DASH_GT] = ACTIONS(630),
    [anon_sym_DASH_GT_GT] = ACTIONS(628),
    [anon_sym_POUND_GT] = ACTIONS(630),
    [anon_sym_POUND_GT_GT] = ACTIONS(628),
    [anon_sym_DQUOTE] = ACTIONS(628),
    [anon_sym_BQUOTE] = ACTIONS(628),
  },
  [86] = {
    [sym_comment] = STATE(86),
    [sym_marginalia] = STATE(86),
    [ts_builtin_sym_end] = ACTIONS(634),
    [sym__identifier] = ACTIONS(636),
    [anon_sym_SEMI] = ACTIONS(634),
    [sym_keyword_set] = ACTIONS(636),
    [sym_keyword_from] = ACTIONS(636),
    [sym_keyword_left] = ACTIONS(636),
    [sym_keyword_right] = ACTIONS(636),
    [sym_keyword_inner] = ACTIONS(636),
    [sym_keyword_full] = ACTIONS(636),
    [sym_keyword_join] = ACTIONS(636),
    [sym_keyword_natural] = ACTIONS(636),
    [sym_keyword_on] = ACTIONS(636),
    [sym_keyword_where] = ACTIONS(636),
    [sym_keyword_create] = ACTIONS(636),
    [sym_keyword_increment] = ACTIONS(636),
    [sym_keyword_minvalue] = ACTIONS(636),
    [sym_keyword_maxvalue] = ACTIONS(636),
    [sym_keyword_owned] = ACTIONS(636),
    [sym_keyword_start] = ACTIONS(636),
    [sym_keyword_restart] = ACTIONS(636),
    [sym_keyword_as] = ACTIONS(636),
    [sym_keyword_when] = ACTIONS(636),
    [sym_keyword_then] = ACTIONS(636),
    [sym_keyword_else] = ACTIONS(636),
    [sym_keyword_end] = ACTIONS(636),
    [sym_keyword_in] = ACTIONS(636),
    [sym_keyword_and] = ACTIONS(636),
    [sym_keyword_or] = ACTIONS(636),
    [sym_keyword_is] = ACTIONS(636),
    [sym_keyword_not] = ACTIONS(636),
    [sym_keyword_using] = ACTIONS(636),
    [sym_keyword_collate] = ACTIONS(636),
    [sym_keyword_cascade] = ACTIONS(636),
    [sym_keyword_restrict] = ACTIONS(636),
    [aux_sym_keyword_with_token1] = ACTIONS(636),
    [sym_keyword_no] = ACTIONS(636),
    [sym_keyword_cycle] = ACTIONS(636),
    [sym_keyword_union] = ACTIONS(636),
    [sym_keyword_except] = ACTIONS(636),
    [sym_keyword_intersect] = ACTIONS(636),
    [sym_keyword_returning] = ACTIONS(636),
    [sym_keyword_between] = ACTIONS(636),
    [sym_keyword_preceding] = ACTIONS(636),
    [sym_keyword_following] = ACTIONS(636),
    [aux_sym_keyword_like_token1] = ACTIONS(636),
    [aux_sym_keyword_like_token2] = ACTIONS(636),
    [sym_keyword_similar] = ACTIONS(636),
    [sym_keyword_cache] = ACTIONS(636),
    [sym_keyword_array] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(634),
    [anon_sym_RBRACK] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(638),
    [anon_sym_RPAREN] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(636),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(634),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(634),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(634),
    [anon_sym_COLON_EQ] = ACTIONS(634),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_STAR] = ACTIONS(634),
    [anon_sym_COLON_COLON] = ACTIONS(634),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(636),
    [anon_sym_PERCENT] = ACTIONS(634),
    [anon_sym_CARET] = ACTIONS(634),
    [anon_sym_PIPE_PIPE] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(634),
    [anon_sym_LT_GT] = ACTIONS(634),
    [anon_sym_DASH_GT] = ACTIONS(636),
    [anon_sym_DASH_GT_GT] = ACTIONS(634),
    [anon_sym_POUND_GT] = ACTIONS(636),
    [anon_sym_POUND_GT_GT] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(634),
  },
  [87] = {
    [sym_comment] = STATE(87),
    [sym_marginalia] = STATE(87),
    [ts_builtin_sym_end] = ACTIONS(640),
    [sym__identifier] = ACTIONS(642),
    [anon_sym_SEMI] = ACTIONS(640),
    [sym_keyword_set] = ACTIONS(642),
    [sym_keyword_from] = ACTIONS(642),
    [sym_keyword_left] = ACTIONS(642),
    [sym_keyword_right] = ACTIONS(642),
    [sym_keyword_inner] = ACTIONS(642),
    [sym_keyword_full] = ACTIONS(642),
    [sym_keyword_join] = ACTIONS(642),
    [sym_keyword_natural] = ACTIONS(642),
    [sym_keyword_on] = ACTIONS(642),
    [sym_keyword_where] = ACTIONS(642),
    [sym_keyword_create] = ACTIONS(642),
    [sym_keyword_increment] = ACTIONS(642),
    [sym_keyword_minvalue] = ACTIONS(642),
    [sym_keyword_maxvalue] = ACTIONS(642),
    [sym_keyword_owned] = ACTIONS(642),
    [sym_keyword_start] = ACTIONS(642),
    [sym_keyword_restart] = ACTIONS(642),
    [sym_keyword_as] = ACTIONS(642),
    [sym_keyword_when] = ACTIONS(642),
    [sym_keyword_then] = ACTIONS(642),
    [sym_keyword_else] = ACTIONS(642),
    [sym_keyword_end] = ACTIONS(642),
    [sym_keyword_in] = ACTIONS(642),
    [sym_keyword_and] = ACTIONS(642),
    [sym_keyword_or] = ACTIONS(642),
    [sym_keyword_is] = ACTIONS(642),
    [sym_keyword_not] = ACTIONS(642),
    [sym_keyword_using] = ACTIONS(642),
    [sym_keyword_collate] = ACTIONS(642),
    [sym_keyword_cascade] = ACTIONS(642),
    [sym_keyword_restrict] = ACTIONS(642),
    [aux_sym_keyword_with_token1] = ACTIONS(642),
    [sym_keyword_no] = ACTIONS(642),
    [sym_keyword_cycle] = ACTIONS(642),
    [sym_keyword_union] = ACTIONS(642),
    [sym_keyword_except] = ACTIONS(642),
    [sym_keyword_intersect] = ACTIONS(642),
    [sym_keyword_returning] = ACTIONS(642),
    [sym_keyword_between] = ACTIONS(642),
    [sym_keyword_preceding] = ACTIONS(642),
    [sym_keyword_following] = ACTIONS(642),
    [aux_sym_keyword_like_token1] = ACTIONS(642),
    [aux_sym_keyword_like_token2] = ACTIONS(642),
    [sym_keyword_similar] = ACTIONS(642),
    [sym_keyword_cache] = ACTIONS(642),
    [sym_keyword_array] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(640),
    [anon_sym_RBRACK] = ACTIONS(640),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_RPAREN] = ACTIONS(640),
    [anon_sym_COMMA] = ACTIONS(640),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(642),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(640),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(640),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(640),
    [anon_sym_COLON_EQ] = ACTIONS(640),
    [anon_sym_EQ] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(640),
    [anon_sym_COLON_COLON] = ACTIONS(640),
    [anon_sym_LT] = ACTIONS(642),
    [anon_sym_GT] = ACTIONS(642),
    [anon_sym_LT_EQ] = ACTIONS(640),
    [anon_sym_GT_EQ] = ACTIONS(640),
    [anon_sym_PLUS] = ACTIONS(640),
    [anon_sym_DASH] = ACTIONS(642),
    [anon_sym_PERCENT] = ACTIONS(640),
    [anon_sym_CARET] = ACTIONS(640),
    [anon_sym_PIPE_PIPE] = ACTIONS(640),
    [anon_sym_BANG_EQ] = ACTIONS(640),
    [anon_sym_LT_GT] = ACTIONS(640),
    [anon_sym_DASH_GT] = ACTIONS(642),
    [anon_sym_DASH_GT_GT] = ACTIONS(640),
    [anon_sym_POUND_GT] = ACTIONS(642),
    [anon_sym_POUND_GT_GT] = ACTIONS(640),
    [anon_sym_DQUOTE] = ACTIONS(640),
    [anon_sym_BQUOTE] = ACTIONS(640),
  },
  [88] = {
    [sym_comment] = STATE(88),
    [sym_marginalia] = STATE(88),
    [ts_builtin_sym_end] = ACTIONS(646),
    [sym__identifier] = ACTIONS(648),
    [anon_sym_SEMI] = ACTIONS(646),
    [sym_keyword_set] = ACTIONS(648),
    [sym_keyword_from] = ACTIONS(648),
    [sym_keyword_left] = ACTIONS(648),
    [sym_keyword_right] = ACTIONS(648),
    [sym_keyword_inner] = ACTIONS(648),
    [sym_keyword_full] = ACTIONS(648),
    [sym_keyword_join] = ACTIONS(648),
    [sym_keyword_natural] = ACTIONS(648),
    [sym_keyword_on] = ACTIONS(648),
    [sym_keyword_where] = ACTIONS(648),
    [sym_keyword_create] = ACTIONS(648),
    [sym_keyword_increment] = ACTIONS(648),
    [sym_keyword_minvalue] = ACTIONS(648),
    [sym_keyword_maxvalue] = ACTIONS(648),
    [sym_keyword_owned] = ACTIONS(648),
    [sym_keyword_start] = ACTIONS(648),
    [sym_keyword_restart] = ACTIONS(648),
    [sym_keyword_as] = ACTIONS(648),
    [sym_keyword_when] = ACTIONS(648),
    [sym_keyword_then] = ACTIONS(648),
    [sym_keyword_else] = ACTIONS(648),
    [sym_keyword_end] = ACTIONS(648),
    [sym_keyword_in] = ACTIONS(648),
    [sym_keyword_and] = ACTIONS(648),
    [sym_keyword_or] = ACTIONS(648),
    [sym_keyword_is] = ACTIONS(648),
    [sym_keyword_not] = ACTIONS(648),
    [sym_keyword_using] = ACTIONS(648),
    [sym_keyword_collate] = ACTIONS(648),
    [sym_keyword_cascade] = ACTIONS(648),
    [sym_keyword_restrict] = ACTIONS(648),
    [aux_sym_keyword_with_token1] = ACTIONS(648),
    [sym_keyword_no] = ACTIONS(648),
    [sym_keyword_cycle] = ACTIONS(648),
    [sym_keyword_union] = ACTIONS(648),
    [sym_keyword_except] = ACTIONS(648),
    [sym_keyword_intersect] = ACTIONS(648),
    [sym_keyword_returning] = ACTIONS(648),
    [sym_keyword_between] = ACTIONS(648),
    [sym_keyword_preceding] = ACTIONS(648),
    [sym_keyword_following] = ACTIONS(648),
    [aux_sym_keyword_like_token1] = ACTIONS(648),
    [aux_sym_keyword_like_token2] = ACTIONS(648),
    [sym_keyword_similar] = ACTIONS(648),
    [sym_keyword_cache] = ACTIONS(648),
    [sym_keyword_array] = ACTIONS(648),
    [anon_sym_LBRACK] = ACTIONS(646),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(646),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(648),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(646),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(646),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(646),
    [anon_sym_COLON_EQ] = ACTIONS(646),
    [anon_sym_EQ] = ACTIONS(646),
    [anon_sym_STAR] = ACTIONS(646),
    [anon_sym_COLON_COLON] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(648),
    [anon_sym_LT_EQ] = ACTIONS(646),
    [anon_sym_GT_EQ] = ACTIONS(646),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PERCENT] = ACTIONS(646),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_PIPE_PIPE] = ACTIONS(646),
    [anon_sym_BANG_EQ] = ACTIONS(646),
    [anon_sym_LT_GT] = ACTIONS(646),
    [anon_sym_DASH_GT] = ACTIONS(648),
    [anon_sym_DASH_GT_GT] = ACTIONS(646),
    [anon_sym_POUND_GT] = ACTIONS(648),
    [anon_sym_POUND_GT_GT] = ACTIONS(646),
    [anon_sym_DQUOTE] = ACTIONS(646),
    [anon_sym_BQUOTE] = ACTIONS(646),
  },
  [89] = {
    [sym_comment] = STATE(89),
    [sym_marginalia] = STATE(89),
    [ts_builtin_sym_end] = ACTIONS(652),
    [sym__identifier] = ACTIONS(654),
    [anon_sym_SEMI] = ACTIONS(652),
    [sym_keyword_set] = ACTIONS(654),
    [sym_keyword_from] = ACTIONS(654),
    [sym_keyword_left] = ACTIONS(654),
    [sym_keyword_right] = ACTIONS(654),
    [sym_keyword_inner] = ACTIONS(654),
    [sym_keyword_full] = ACTIONS(654),
    [sym_keyword_join] = ACTIONS(654),
    [sym_keyword_natural] = ACTIONS(654),
    [sym_keyword_on] = ACTIONS(654),
    [sym_keyword_where] = ACTIONS(654),
    [sym_keyword_create] = ACTIONS(654),
    [sym_keyword_increment] = ACTIONS(654),
    [sym_keyword_minvalue] = ACTIONS(654),
    [sym_keyword_maxvalue] = ACTIONS(654),
    [sym_keyword_owned] = ACTIONS(654),
    [sym_keyword_start] = ACTIONS(654),
    [sym_keyword_restart] = ACTIONS(654),
    [sym_keyword_as] = ACTIONS(654),
    [sym_keyword_when] = ACTIONS(654),
    [sym_keyword_then] = ACTIONS(654),
    [sym_keyword_else] = ACTIONS(654),
    [sym_keyword_end] = ACTIONS(654),
    [sym_keyword_in] = ACTIONS(654),
    [sym_keyword_and] = ACTIONS(654),
    [sym_keyword_or] = ACTIONS(654),
    [sym_keyword_is] = ACTIONS(654),
    [sym_keyword_not] = ACTIONS(654),
    [sym_keyword_using] = ACTIONS(654),
    [sym_keyword_collate] = ACTIONS(654),
    [sym_keyword_cascade] = ACTIONS(654),
    [sym_keyword_restrict] = ACTIONS(654),
    [aux_sym_keyword_with_token1] = ACTIONS(654),
    [sym_keyword_no] = ACTIONS(654),
    [sym_keyword_cycle] = ACTIONS(654),
    [sym_keyword_union] = ACTIONS(654),
    [sym_keyword_except] = ACTIONS(654),
    [sym_keyword_intersect] = ACTIONS(654),
    [sym_keyword_returning] = ACTIONS(654),
    [sym_keyword_between] = ACTIONS(654),
    [sym_keyword_preceding] = ACTIONS(654),
    [sym_keyword_following] = ACTIONS(654),
    [aux_sym_keyword_like_token1] = ACTIONS(654),
    [aux_sym_keyword_like_token2] = ACTIONS(654),
    [sym_keyword_similar] = ACTIONS(654),
    [sym_keyword_cache] = ACTIONS(654),
    [sym_keyword_array] = ACTIONS(654),
    [anon_sym_LBRACK] = ACTIONS(652),
    [anon_sym_RBRACK] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(652),
    [anon_sym_RPAREN] = ACTIONS(652),
    [anon_sym_COMMA] = ACTIONS(652),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(654),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(652),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(652),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(652),
    [anon_sym_COLON_EQ] = ACTIONS(652),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_COLON_COLON] = ACTIONS(652),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(652),
    [anon_sym_GT_EQ] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(654),
    [anon_sym_PERCENT] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(652),
    [anon_sym_BANG_EQ] = ACTIONS(652),
    [anon_sym_LT_GT] = ACTIONS(652),
    [anon_sym_DASH_GT] = ACTIONS(654),
    [anon_sym_DASH_GT_GT] = ACTIONS(652),
    [anon_sym_POUND_GT] = ACTIONS(654),
    [anon_sym_POUND_GT_GT] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(652),
    [anon_sym_BQUOTE] = ACTIONS(652),
  },
  [90] = {
    [sym_comment] = STATE(90),
    [sym_marginalia] = STATE(90),
    [ts_builtin_sym_end] = ACTIONS(429),
    [sym__identifier] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(429),
    [sym_keyword_set] = ACTIONS(431),
    [sym_keyword_from] = ACTIONS(431),
    [sym_keyword_left] = ACTIONS(431),
    [sym_keyword_right] = ACTIONS(431),
    [sym_keyword_inner] = ACTIONS(431),
    [sym_keyword_full] = ACTIONS(431),
    [sym_keyword_join] = ACTIONS(431),
    [sym_keyword_natural] = ACTIONS(431),
    [sym_keyword_on] = ACTIONS(431),
    [sym_keyword_where] = ACTIONS(431),
    [sym_keyword_create] = ACTIONS(431),
    [sym_keyword_increment] = ACTIONS(431),
    [sym_keyword_minvalue] = ACTIONS(431),
    [sym_keyword_maxvalue] = ACTIONS(431),
    [sym_keyword_owned] = ACTIONS(431),
    [sym_keyword_start] = ACTIONS(431),
    [sym_keyword_restart] = ACTIONS(431),
    [sym_keyword_as] = ACTIONS(431),
    [sym_keyword_when] = ACTIONS(431),
    [sym_keyword_then] = ACTIONS(431),
    [sym_keyword_else] = ACTIONS(431),
    [sym_keyword_end] = ACTIONS(431),
    [sym_keyword_in] = ACTIONS(431),
    [sym_keyword_and] = ACTIONS(431),
    [sym_keyword_or] = ACTIONS(431),
    [sym_keyword_is] = ACTIONS(431),
    [sym_keyword_not] = ACTIONS(431),
    [sym_keyword_using] = ACTIONS(431),
    [sym_keyword_collate] = ACTIONS(431),
    [sym_keyword_cascade] = ACTIONS(431),
    [sym_keyword_restrict] = ACTIONS(431),
    [aux_sym_keyword_with_token1] = ACTIONS(431),
    [sym_keyword_no] = ACTIONS(431),
    [sym_keyword_cycle] = ACTIONS(431),
    [sym_keyword_union] = ACTIONS(431),
    [sym_keyword_except] = ACTIONS(431),
    [sym_keyword_intersect] = ACTIONS(431),
    [sym_keyword_returning] = ACTIONS(431),
    [sym_keyword_between] = ACTIONS(431),
    [sym_keyword_preceding] = ACTIONS(431),
    [sym_keyword_following] = ACTIONS(431),
    [aux_sym_keyword_like_token1] = ACTIONS(431),
    [aux_sym_keyword_like_token2] = ACTIONS(431),
    [sym_keyword_similar] = ACTIONS(431),
    [sym_keyword_zerofill] = ACTIONS(435),
    [sym_keyword_cache] = ACTIONS(431),
    [sym_keyword_array] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_RBRACK] = ACTIONS(429),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(429),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(431),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(429),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(429),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(429),
    [anon_sym_COLON_EQ] = ACTIONS(429),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_STAR] = ACTIONS(429),
    [anon_sym_COLON_COLON] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(431),
    [anon_sym_GT] = ACTIONS(431),
    [anon_sym_LT_EQ] = ACTIONS(429),
    [anon_sym_GT_EQ] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(429),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(429),
    [anon_sym_PIPE_PIPE] = ACTIONS(429),
    [anon_sym_BANG_EQ] = ACTIONS(429),
    [anon_sym_LT_GT] = ACTIONS(429),
    [anon_sym_DASH_GT] = ACTIONS(431),
    [anon_sym_DASH_GT_GT] = ACTIONS(429),
    [anon_sym_POUND_GT] = ACTIONS(431),
    [anon_sym_POUND_GT_GT] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(429),
    [anon_sym_BQUOTE] = ACTIONS(429),
  },
  [91] = {
    [sym_comment] = STATE(91),
    [sym_marginalia] = STATE(91),
    [ts_builtin_sym_end] = ACTIONS(656),
    [sym__identifier] = ACTIONS(658),
    [anon_sym_SEMI] = ACTIONS(656),
    [sym_keyword_set] = ACTIONS(658),
    [sym_keyword_from] = ACTIONS(658),
    [sym_keyword_left] = ACTIONS(658),
    [sym_keyword_right] = ACTIONS(658),
    [sym_keyword_inner] = ACTIONS(658),
    [sym_keyword_full] = ACTIONS(658),
    [sym_keyword_join] = ACTIONS(658),
    [sym_keyword_natural] = ACTIONS(658),
    [sym_keyword_on] = ACTIONS(658),
    [sym_keyword_where] = ACTIONS(658),
    [sym_keyword_create] = ACTIONS(658),
    [sym_keyword_increment] = ACTIONS(658),
    [sym_keyword_minvalue] = ACTIONS(658),
    [sym_keyword_maxvalue] = ACTIONS(658),
    [sym_keyword_owned] = ACTIONS(658),
    [sym_keyword_start] = ACTIONS(658),
    [sym_keyword_restart] = ACTIONS(658),
    [sym_keyword_as] = ACTIONS(658),
    [sym_keyword_when] = ACTIONS(658),
    [sym_keyword_then] = ACTIONS(658),
    [sym_keyword_else] = ACTIONS(658),
    [sym_keyword_end] = ACTIONS(658),
    [sym_keyword_in] = ACTIONS(658),
    [sym_keyword_and] = ACTIONS(658),
    [sym_keyword_or] = ACTIONS(658),
    [sym_keyword_is] = ACTIONS(658),
    [sym_keyword_not] = ACTIONS(658),
    [sym_keyword_using] = ACTIONS(658),
    [sym_keyword_collate] = ACTIONS(658),
    [sym_keyword_cascade] = ACTIONS(658),
    [sym_keyword_restrict] = ACTIONS(658),
    [aux_sym_keyword_with_token1] = ACTIONS(658),
    [sym_keyword_no] = ACTIONS(658),
    [sym_keyword_cycle] = ACTIONS(658),
    [sym_keyword_union] = ACTIONS(658),
    [sym_keyword_except] = ACTIONS(658),
    [sym_keyword_intersect] = ACTIONS(658),
    [sym_keyword_returning] = ACTIONS(658),
    [sym_keyword_between] = ACTIONS(658),
    [sym_keyword_preceding] = ACTIONS(658),
    [sym_keyword_following] = ACTIONS(658),
    [aux_sym_keyword_like_token1] = ACTIONS(658),
    [aux_sym_keyword_like_token2] = ACTIONS(658),
    [sym_keyword_similar] = ACTIONS(658),
    [sym_keyword_zerofill] = ACTIONS(660),
    [sym_keyword_cache] = ACTIONS(658),
    [sym_keyword_array] = ACTIONS(658),
    [anon_sym_LBRACK] = ACTIONS(656),
    [anon_sym_RBRACK] = ACTIONS(656),
    [anon_sym_RPAREN] = ACTIONS(656),
    [anon_sym_COMMA] = ACTIONS(656),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(658),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(656),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(656),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(656),
    [anon_sym_COLON_EQ] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(656),
    [anon_sym_STAR] = ACTIONS(656),
    [anon_sym_COLON_COLON] = ACTIONS(656),
    [anon_sym_LT] = ACTIONS(658),
    [anon_sym_GT] = ACTIONS(658),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(656),
    [anon_sym_DASH] = ACTIONS(658),
    [anon_sym_PERCENT] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_LT_GT] = ACTIONS(656),
    [anon_sym_DASH_GT] = ACTIONS(658),
    [anon_sym_DASH_GT_GT] = ACTIONS(656),
    [anon_sym_POUND_GT] = ACTIONS(658),
    [anon_sym_POUND_GT_GT] = ACTIONS(656),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [anon_sym_BQUOTE] = ACTIONS(656),
  },
  [92] = {
    [sym_comment] = STATE(92),
    [sym_marginalia] = STATE(92),
    [ts_builtin_sym_end] = ACTIONS(662),
    [sym__identifier] = ACTIONS(664),
    [anon_sym_SEMI] = ACTIONS(662),
    [sym_keyword_set] = ACTIONS(664),
    [sym_keyword_from] = ACTIONS(664),
    [sym_keyword_left] = ACTIONS(664),
    [sym_keyword_right] = ACTIONS(664),
    [sym_keyword_inner] = ACTIONS(664),
    [sym_keyword_full] = ACTIONS(664),
    [sym_keyword_join] = ACTIONS(664),
    [sym_keyword_natural] = ACTIONS(664),
    [sym_keyword_on] = ACTIONS(664),
    [sym_keyword_where] = ACTIONS(664),
    [sym_keyword_create] = ACTIONS(664),
    [sym_keyword_increment] = ACTIONS(664),
    [sym_keyword_minvalue] = ACTIONS(664),
    [sym_keyword_maxvalue] = ACTIONS(664),
    [sym_keyword_owned] = ACTIONS(664),
    [sym_keyword_start] = ACTIONS(664),
    [sym_keyword_restart] = ACTIONS(664),
    [sym_keyword_as] = ACTIONS(664),
    [sym_keyword_when] = ACTIONS(664),
    [sym_keyword_then] = ACTIONS(664),
    [sym_keyword_else] = ACTIONS(664),
    [sym_keyword_end] = ACTIONS(664),
    [sym_keyword_in] = ACTIONS(664),
    [sym_keyword_and] = ACTIONS(664),
    [sym_keyword_or] = ACTIONS(664),
    [sym_keyword_is] = ACTIONS(664),
    [sym_keyword_not] = ACTIONS(664),
    [sym_keyword_using] = ACTIONS(664),
    [sym_keyword_collate] = ACTIONS(664),
    [sym_keyword_cascade] = ACTIONS(664),
    [sym_keyword_restrict] = ACTIONS(664),
    [aux_sym_keyword_with_token1] = ACTIONS(664),
    [sym_keyword_no] = ACTIONS(664),
    [sym_keyword_cycle] = ACTIONS(664),
    [sym_keyword_union] = ACTIONS(664),
    [sym_keyword_except] = ACTIONS(664),
    [sym_keyword_intersect] = ACTIONS(664),
    [sym_keyword_returning] = ACTIONS(664),
    [sym_keyword_between] = ACTIONS(664),
    [sym_keyword_preceding] = ACTIONS(664),
    [sym_keyword_following] = ACTIONS(664),
    [aux_sym_keyword_like_token1] = ACTIONS(664),
    [aux_sym_keyword_like_token2] = ACTIONS(664),
    [sym_keyword_similar] = ACTIONS(664),
    [sym_keyword_zerofill] = ACTIONS(666),
    [sym_keyword_cache] = ACTIONS(664),
    [sym_keyword_array] = ACTIONS(664),
    [anon_sym_LBRACK] = ACTIONS(662),
    [anon_sym_RBRACK] = ACTIONS(662),
    [anon_sym_RPAREN] = ACTIONS(662),
    [anon_sym_COMMA] = ACTIONS(662),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(664),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(662),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(662),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(662),
    [anon_sym_COLON_EQ] = ACTIONS(662),
    [anon_sym_EQ] = ACTIONS(662),
    [anon_sym_STAR] = ACTIONS(662),
    [anon_sym_COLON_COLON] = ACTIONS(662),
    [anon_sym_LT] = ACTIONS(664),
    [anon_sym_GT] = ACTIONS(664),
    [anon_sym_LT_EQ] = ACTIONS(662),
    [anon_sym_GT_EQ] = ACTIONS(662),
    [anon_sym_PLUS] = ACTIONS(662),
    [anon_sym_DASH] = ACTIONS(664),
    [anon_sym_PERCENT] = ACTIONS(662),
    [anon_sym_CARET] = ACTIONS(662),
    [anon_sym_PIPE_PIPE] = ACTIONS(662),
    [anon_sym_BANG_EQ] = ACTIONS(662),
    [anon_sym_LT_GT] = ACTIONS(662),
    [anon_sym_DASH_GT] = ACTIONS(664),
    [anon_sym_DASH_GT_GT] = ACTIONS(662),
    [anon_sym_POUND_GT] = ACTIONS(664),
    [anon_sym_POUND_GT_GT] = ACTIONS(662),
    [anon_sym_DQUOTE] = ACTIONS(662),
    [anon_sym_BQUOTE] = ACTIONS(662),
  },
  [93] = {
    [sym_comment] = STATE(93),
    [sym_marginalia] = STATE(93),
    [ts_builtin_sym_end] = ACTIONS(668),
    [sym__identifier] = ACTIONS(670),
    [anon_sym_SEMI] = ACTIONS(668),
    [sym_keyword_set] = ACTIONS(670),
    [sym_keyword_from] = ACTIONS(670),
    [sym_keyword_left] = ACTIONS(670),
    [sym_keyword_right] = ACTIONS(670),
    [sym_keyword_inner] = ACTIONS(670),
    [sym_keyword_full] = ACTIONS(670),
    [sym_keyword_join] = ACTIONS(670),
    [sym_keyword_natural] = ACTIONS(670),
    [sym_keyword_on] = ACTIONS(670),
    [sym_keyword_where] = ACTIONS(670),
    [sym_keyword_create] = ACTIONS(670),
    [sym_keyword_increment] = ACTIONS(670),
    [sym_keyword_minvalue] = ACTIONS(670),
    [sym_keyword_maxvalue] = ACTIONS(670),
    [sym_keyword_owned] = ACTIONS(670),
    [sym_keyword_start] = ACTIONS(670),
    [sym_keyword_restart] = ACTIONS(670),
    [sym_keyword_as] = ACTIONS(670),
    [sym_keyword_when] = ACTIONS(670),
    [sym_keyword_then] = ACTIONS(670),
    [sym_keyword_else] = ACTIONS(670),
    [sym_keyword_end] = ACTIONS(670),
    [sym_keyword_in] = ACTIONS(670),
    [sym_keyword_and] = ACTIONS(670),
    [sym_keyword_or] = ACTIONS(670),
    [sym_keyword_is] = ACTIONS(670),
    [sym_keyword_not] = ACTIONS(670),
    [sym_keyword_using] = ACTIONS(670),
    [sym_keyword_collate] = ACTIONS(670),
    [sym_keyword_cascade] = ACTIONS(670),
    [sym_keyword_restrict] = ACTIONS(670),
    [aux_sym_keyword_with_token1] = ACTIONS(670),
    [sym_keyword_no] = ACTIONS(670),
    [sym_keyword_cycle] = ACTIONS(670),
    [sym_keyword_union] = ACTIONS(670),
    [sym_keyword_except] = ACTIONS(670),
    [sym_keyword_intersect] = ACTIONS(670),
    [sym_keyword_returning] = ACTIONS(670),
    [sym_keyword_between] = ACTIONS(670),
    [sym_keyword_preceding] = ACTIONS(670),
    [sym_keyword_following] = ACTIONS(670),
    [aux_sym_keyword_like_token1] = ACTIONS(670),
    [aux_sym_keyword_like_token2] = ACTIONS(670),
    [sym_keyword_similar] = ACTIONS(670),
    [sym_keyword_cache] = ACTIONS(670),
    [sym_keyword_array] = ACTIONS(670),
    [anon_sym_LBRACK] = ACTIONS(668),
    [anon_sym_RBRACK] = ACTIONS(668),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_RPAREN] = ACTIONS(668),
    [anon_sym_COMMA] = ACTIONS(668),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(670),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(668),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(668),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(668),
    [anon_sym_COLON_EQ] = ACTIONS(668),
    [anon_sym_EQ] = ACTIONS(668),
    [anon_sym_STAR] = ACTIONS(668),
    [anon_sym_COLON_COLON] = ACTIONS(668),
    [anon_sym_LT] = ACTIONS(670),
    [anon_sym_GT] = ACTIONS(670),
    [anon_sym_LT_EQ] = ACTIONS(668),
    [anon_sym_GT_EQ] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(668),
    [anon_sym_DASH] = ACTIONS(670),
    [anon_sym_PERCENT] = ACTIONS(668),
    [anon_sym_CARET] = ACTIONS(668),
    [anon_sym_PIPE_PIPE] = ACTIONS(668),
    [anon_sym_BANG_EQ] = ACTIONS(668),
    [anon_sym_LT_GT] = ACTIONS(668),
    [anon_sym_DASH_GT] = ACTIONS(670),
    [anon_sym_DASH_GT_GT] = ACTIONS(668),
    [anon_sym_POUND_GT] = ACTIONS(670),
    [anon_sym_POUND_GT_GT] = ACTIONS(668),
    [anon_sym_DQUOTE] = ACTIONS(668),
    [anon_sym_BQUOTE] = ACTIONS(668),
  },
  [94] = {
    [sym_comment] = STATE(94),
    [sym_marginalia] = STATE(94),
    [ts_builtin_sym_end] = ACTIONS(451),
    [sym__identifier] = ACTIONS(453),
    [anon_sym_SEMI] = ACTIONS(451),
    [sym_keyword_set] = ACTIONS(453),
    [sym_keyword_from] = ACTIONS(453),
    [sym_keyword_left] = ACTIONS(453),
    [sym_keyword_right] = ACTIONS(453),
    [sym_keyword_inner] = ACTIONS(453),
    [sym_keyword_full] = ACTIONS(453),
    [sym_keyword_join] = ACTIONS(453),
    [sym_keyword_natural] = ACTIONS(453),
    [sym_keyword_on] = ACTIONS(453),
    [sym_keyword_where] = ACTIONS(453),
    [sym_keyword_create] = ACTIONS(453),
    [sym_keyword_increment] = ACTIONS(453),
    [sym_keyword_minvalue] = ACTIONS(453),
    [sym_keyword_maxvalue] = ACTIONS(453),
    [sym_keyword_owned] = ACTIONS(453),
    [sym_keyword_start] = ACTIONS(453),
    [sym_keyword_restart] = ACTIONS(453),
    [sym_keyword_as] = ACTIONS(453),
    [sym_keyword_when] = ACTIONS(453),
    [sym_keyword_then] = ACTIONS(453),
    [sym_keyword_else] = ACTIONS(453),
    [sym_keyword_end] = ACTIONS(453),
    [sym_keyword_in] = ACTIONS(453),
    [sym_keyword_and] = ACTIONS(453),
    [sym_keyword_or] = ACTIONS(453),
    [sym_keyword_is] = ACTIONS(453),
    [sym_keyword_not] = ACTIONS(453),
    [sym_keyword_using] = ACTIONS(453),
    [sym_keyword_collate] = ACTIONS(453),
    [sym_keyword_cascade] = ACTIONS(453),
    [sym_keyword_restrict] = ACTIONS(453),
    [aux_sym_keyword_with_token1] = ACTIONS(453),
    [sym_keyword_no] = ACTIONS(453),
    [sym_keyword_cycle] = ACTIONS(453),
    [sym_keyword_union] = ACTIONS(453),
    [sym_keyword_except] = ACTIONS(453),
    [sym_keyword_intersect] = ACTIONS(453),
    [sym_keyword_returning] = ACTIONS(453),
    [sym_keyword_between] = ACTIONS(453),
    [sym_keyword_preceding] = ACTIONS(453),
    [sym_keyword_following] = ACTIONS(453),
    [aux_sym_keyword_like_token1] = ACTIONS(453),
    [aux_sym_keyword_like_token2] = ACTIONS(453),
    [sym_keyword_similar] = ACTIONS(453),
    [sym_keyword_cache] = ACTIONS(453),
    [sym_keyword_array] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(451),
    [anon_sym_RBRACK] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(451),
    [anon_sym_RPAREN] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(451),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(453),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(451),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(451),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(451),
    [anon_sym_COLON_EQ] = ACTIONS(451),
    [anon_sym_EQ] = ACTIONS(451),
    [anon_sym_STAR] = ACTIONS(451),
    [anon_sym_COLON_COLON] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_LT_EQ] = ACTIONS(451),
    [anon_sym_GT_EQ] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(451),
    [anon_sym_DASH] = ACTIONS(453),
    [anon_sym_PERCENT] = ACTIONS(451),
    [anon_sym_CARET] = ACTIONS(451),
    [anon_sym_PIPE_PIPE] = ACTIONS(451),
    [anon_sym_BANG_EQ] = ACTIONS(451),
    [anon_sym_LT_GT] = ACTIONS(451),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_DASH_GT_GT] = ACTIONS(451),
    [anon_sym_POUND_GT] = ACTIONS(453),
    [anon_sym_POUND_GT_GT] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(451),
    [anon_sym_BQUOTE] = ACTIONS(451),
  },
  [95] = {
    [sym_comment] = STATE(95),
    [sym_marginalia] = STATE(95),
    [ts_builtin_sym_end] = ACTIONS(674),
    [sym__identifier] = ACTIONS(676),
    [anon_sym_SEMI] = ACTIONS(674),
    [sym_keyword_set] = ACTIONS(676),
    [sym_keyword_from] = ACTIONS(676),
    [sym_keyword_left] = ACTIONS(676),
    [sym_keyword_right] = ACTIONS(676),
    [sym_keyword_inner] = ACTIONS(676),
    [sym_keyword_full] = ACTIONS(676),
    [sym_keyword_join] = ACTIONS(676),
    [sym_keyword_natural] = ACTIONS(676),
    [sym_keyword_on] = ACTIONS(676),
    [sym_keyword_where] = ACTIONS(676),
    [sym_keyword_create] = ACTIONS(676),
    [sym_keyword_increment] = ACTIONS(676),
    [sym_keyword_minvalue] = ACTIONS(676),
    [sym_keyword_maxvalue] = ACTIONS(676),
    [sym_keyword_owned] = ACTIONS(676),
    [sym_keyword_start] = ACTIONS(676),
    [sym_keyword_restart] = ACTIONS(676),
    [sym_keyword_as] = ACTIONS(676),
    [sym_keyword_when] = ACTIONS(676),
    [sym_keyword_then] = ACTIONS(676),
    [sym_keyword_else] = ACTIONS(676),
    [sym_keyword_end] = ACTIONS(676),
    [sym_keyword_in] = ACTIONS(676),
    [sym_keyword_and] = ACTIONS(676),
    [sym_keyword_or] = ACTIONS(676),
    [sym_keyword_is] = ACTIONS(676),
    [sym_keyword_not] = ACTIONS(676),
    [sym_keyword_using] = ACTIONS(676),
    [sym_keyword_collate] = ACTIONS(676),
    [sym_keyword_cascade] = ACTIONS(676),
    [sym_keyword_restrict] = ACTIONS(676),
    [aux_sym_keyword_with_token1] = ACTIONS(676),
    [sym_keyword_no] = ACTIONS(676),
    [sym_keyword_cycle] = ACTIONS(676),
    [sym_keyword_union] = ACTIONS(676),
    [sym_keyword_except] = ACTIONS(676),
    [sym_keyword_intersect] = ACTIONS(676),
    [sym_keyword_returning] = ACTIONS(676),
    [sym_keyword_between] = ACTIONS(676),
    [sym_keyword_preceding] = ACTIONS(676),
    [sym_keyword_following] = ACTIONS(676),
    [aux_sym_keyword_like_token1] = ACTIONS(676),
    [aux_sym_keyword_like_token2] = ACTIONS(676),
    [sym_keyword_similar] = ACTIONS(676),
    [sym_keyword_zerofill] = ACTIONS(678),
    [sym_keyword_cache] = ACTIONS(676),
    [sym_keyword_array] = ACTIONS(676),
    [anon_sym_LBRACK] = ACTIONS(674),
    [anon_sym_RBRACK] = ACTIONS(674),
    [anon_sym_RPAREN] = ACTIONS(674),
    [anon_sym_COMMA] = ACTIONS(674),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(676),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(674),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(674),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(674),
    [anon_sym_COLON_EQ] = ACTIONS(674),
    [anon_sym_EQ] = ACTIONS(674),
    [anon_sym_STAR] = ACTIONS(674),
    [anon_sym_COLON_COLON] = ACTIONS(674),
    [anon_sym_LT] = ACTIONS(676),
    [anon_sym_GT] = ACTIONS(676),
    [anon_sym_LT_EQ] = ACTIONS(674),
    [anon_sym_GT_EQ] = ACTIONS(674),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(676),
    [anon_sym_PERCENT] = ACTIONS(674),
    [anon_sym_CARET] = ACTIONS(674),
    [anon_sym_PIPE_PIPE] = ACTIONS(674),
    [anon_sym_BANG_EQ] = ACTIONS(674),
    [anon_sym_LT_GT] = ACTIONS(674),
    [anon_sym_DASH_GT] = ACTIONS(676),
    [anon_sym_DASH_GT_GT] = ACTIONS(674),
    [anon_sym_POUND_GT] = ACTIONS(676),
    [anon_sym_POUND_GT_GT] = ACTIONS(674),
    [anon_sym_DQUOTE] = ACTIONS(674),
    [anon_sym_BQUOTE] = ACTIONS(674),
  },
  [96] = {
    [sym_comment] = STATE(96),
    [sym_marginalia] = STATE(96),
    [ts_builtin_sym_end] = ACTIONS(563),
    [sym__identifier] = ACTIONS(565),
    [anon_sym_SEMI] = ACTIONS(563),
    [sym_keyword_set] = ACTIONS(565),
    [sym_keyword_from] = ACTIONS(565),
    [sym_keyword_left] = ACTIONS(565),
    [sym_keyword_right] = ACTIONS(565),
    [sym_keyword_inner] = ACTIONS(565),
    [sym_keyword_full] = ACTIONS(565),
    [sym_keyword_join] = ACTIONS(565),
    [sym_keyword_natural] = ACTIONS(565),
    [sym_keyword_on] = ACTIONS(565),
    [sym_keyword_where] = ACTIONS(565),
    [sym_keyword_create] = ACTIONS(565),
    [sym_keyword_increment] = ACTIONS(565),
    [sym_keyword_minvalue] = ACTIONS(565),
    [sym_keyword_maxvalue] = ACTIONS(565),
    [sym_keyword_owned] = ACTIONS(565),
    [sym_keyword_start] = ACTIONS(565),
    [sym_keyword_restart] = ACTIONS(565),
    [sym_keyword_as] = ACTIONS(565),
    [sym_keyword_when] = ACTIONS(565),
    [sym_keyword_then] = ACTIONS(565),
    [sym_keyword_else] = ACTIONS(565),
    [sym_keyword_end] = ACTIONS(565),
    [sym_keyword_in] = ACTIONS(565),
    [sym_keyword_and] = ACTIONS(565),
    [sym_keyword_or] = ACTIONS(565),
    [sym_keyword_is] = ACTIONS(565),
    [sym_keyword_not] = ACTIONS(565),
    [sym_keyword_using] = ACTIONS(565),
    [sym_keyword_collate] = ACTIONS(565),
    [sym_keyword_cascade] = ACTIONS(565),
    [sym_keyword_restrict] = ACTIONS(565),
    [aux_sym_keyword_with_token1] = ACTIONS(565),
    [sym_keyword_no] = ACTIONS(565),
    [sym_keyword_cycle] = ACTIONS(565),
    [sym_keyword_union] = ACTIONS(565),
    [sym_keyword_except] = ACTIONS(565),
    [sym_keyword_intersect] = ACTIONS(565),
    [sym_keyword_returning] = ACTIONS(565),
    [sym_keyword_between] = ACTIONS(565),
    [sym_keyword_preceding] = ACTIONS(565),
    [sym_keyword_following] = ACTIONS(565),
    [aux_sym_keyword_like_token1] = ACTIONS(565),
    [aux_sym_keyword_like_token2] = ACTIONS(565),
    [sym_keyword_similar] = ACTIONS(565),
    [sym_keyword_zerofill] = ACTIONS(680),
    [sym_keyword_cache] = ACTIONS(565),
    [sym_keyword_array] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(563),
    [anon_sym_RBRACK] = ACTIONS(563),
    [anon_sym_RPAREN] = ACTIONS(563),
    [anon_sym_COMMA] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(565),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(563),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(563),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(563),
    [anon_sym_COLON_EQ] = ACTIONS(563),
    [anon_sym_EQ] = ACTIONS(563),
    [anon_sym_STAR] = ACTIONS(563),
    [anon_sym_COLON_COLON] = ACTIONS(563),
    [anon_sym_LT] = ACTIONS(565),
    [anon_sym_GT] = ACTIONS(565),
    [anon_sym_LT_EQ] = ACTIONS(563),
    [anon_sym_GT_EQ] = ACTIONS(563),
    [anon_sym_PLUS] = ACTIONS(563),
    [anon_sym_DASH] = ACTIONS(565),
    [anon_sym_PERCENT] = ACTIONS(563),
    [anon_sym_CARET] = ACTIONS(563),
    [anon_sym_PIPE_PIPE] = ACTIONS(563),
    [anon_sym_BANG_EQ] = ACTIONS(563),
    [anon_sym_LT_GT] = ACTIONS(563),
    [anon_sym_DASH_GT] = ACTIONS(565),
    [anon_sym_DASH_GT_GT] = ACTIONS(563),
    [anon_sym_POUND_GT] = ACTIONS(565),
    [anon_sym_POUND_GT_GT] = ACTIONS(563),
    [anon_sym_DQUOTE] = ACTIONS(563),
    [anon_sym_BQUOTE] = ACTIONS(563),
  },
  [97] = {
    [sym_comment] = STATE(97),
    [sym_marginalia] = STATE(97),
    [ts_builtin_sym_end] = ACTIONS(682),
    [sym__identifier] = ACTIONS(684),
    [anon_sym_SEMI] = ACTIONS(682),
    [sym_keyword_set] = ACTIONS(684),
    [sym_keyword_from] = ACTIONS(684),
    [sym_keyword_left] = ACTIONS(684),
    [sym_keyword_right] = ACTIONS(684),
    [sym_keyword_inner] = ACTIONS(684),
    [sym_keyword_full] = ACTIONS(684),
    [sym_keyword_join] = ACTIONS(684),
    [sym_keyword_natural] = ACTIONS(684),
    [sym_keyword_on] = ACTIONS(684),
    [sym_keyword_where] = ACTIONS(684),
    [sym_keyword_create] = ACTIONS(684),
    [sym_keyword_increment] = ACTIONS(684),
    [sym_keyword_minvalue] = ACTIONS(684),
    [sym_keyword_maxvalue] = ACTIONS(684),
    [sym_keyword_owned] = ACTIONS(684),
    [sym_keyword_start] = ACTIONS(684),
    [sym_keyword_restart] = ACTIONS(684),
    [sym_keyword_as] = ACTIONS(684),
    [sym_keyword_when] = ACTIONS(684),
    [sym_keyword_then] = ACTIONS(684),
    [sym_keyword_else] = ACTIONS(684),
    [sym_keyword_end] = ACTIONS(684),
    [sym_keyword_in] = ACTIONS(684),
    [sym_keyword_and] = ACTIONS(684),
    [sym_keyword_or] = ACTIONS(684),
    [sym_keyword_is] = ACTIONS(684),
    [sym_keyword_not] = ACTIONS(684),
    [sym_keyword_using] = ACTIONS(684),
    [sym_keyword_collate] = ACTIONS(684),
    [sym_keyword_cascade] = ACTIONS(684),
    [sym_keyword_restrict] = ACTIONS(684),
    [aux_sym_keyword_with_token1] = ACTIONS(684),
    [sym_keyword_no] = ACTIONS(684),
    [sym_keyword_cycle] = ACTIONS(684),
    [sym_keyword_union] = ACTIONS(684),
    [sym_keyword_except] = ACTIONS(684),
    [sym_keyword_intersect] = ACTIONS(684),
    [sym_keyword_returning] = ACTIONS(684),
    [sym_keyword_between] = ACTIONS(684),
    [sym_keyword_preceding] = ACTIONS(684),
    [sym_keyword_following] = ACTIONS(684),
    [aux_sym_keyword_like_token1] = ACTIONS(684),
    [aux_sym_keyword_like_token2] = ACTIONS(684),
    [sym_keyword_similar] = ACTIONS(684),
    [sym_keyword_cache] = ACTIONS(684),
    [sym_keyword_array] = ACTIONS(684),
    [anon_sym_LBRACK] = ACTIONS(682),
    [anon_sym_RBRACK] = ACTIONS(682),
    [anon_sym_LPAREN] = ACTIONS(686),
    [anon_sym_RPAREN] = ACTIONS(682),
    [anon_sym_COMMA] = ACTIONS(682),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(684),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(682),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(682),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(682),
    [anon_sym_COLON_EQ] = ACTIONS(682),
    [anon_sym_EQ] = ACTIONS(682),
    [anon_sym_STAR] = ACTIONS(682),
    [anon_sym_COLON_COLON] = ACTIONS(682),
    [anon_sym_LT] = ACTIONS(684),
    [anon_sym_GT] = ACTIONS(684),
    [anon_sym_LT_EQ] = ACTIONS(682),
    [anon_sym_GT_EQ] = ACTIONS(682),
    [anon_sym_PLUS] = ACTIONS(682),
    [anon_sym_DASH] = ACTIONS(684),
    [anon_sym_PERCENT] = ACTIONS(682),
    [anon_sym_CARET] = ACTIONS(682),
    [anon_sym_PIPE_PIPE] = ACTIONS(682),
    [anon_sym_BANG_EQ] = ACTIONS(682),
    [anon_sym_LT_GT] = ACTIONS(682),
    [anon_sym_DASH_GT] = ACTIONS(684),
    [anon_sym_DASH_GT_GT] = ACTIONS(682),
    [anon_sym_POUND_GT] = ACTIONS(684),
    [anon_sym_POUND_GT_GT] = ACTIONS(682),
    [anon_sym_DQUOTE] = ACTIONS(682),
    [anon_sym_BQUOTE] = ACTIONS(682),
  },
  [98] = {
    [sym_comment] = STATE(98),
    [sym_marginalia] = STATE(98),
    [ts_builtin_sym_end] = ACTIONS(688),
    [sym__identifier] = ACTIONS(690),
    [anon_sym_SEMI] = ACTIONS(688),
    [sym_keyword_set] = ACTIONS(690),
    [sym_keyword_from] = ACTIONS(690),
    [sym_keyword_left] = ACTIONS(690),
    [sym_keyword_right] = ACTIONS(690),
    [sym_keyword_inner] = ACTIONS(690),
    [sym_keyword_full] = ACTIONS(690),
    [sym_keyword_join] = ACTIONS(690),
    [sym_keyword_natural] = ACTIONS(690),
    [sym_keyword_on] = ACTIONS(690),
    [sym_keyword_where] = ACTIONS(690),
    [sym_keyword_create] = ACTIONS(690),
    [sym_keyword_increment] = ACTIONS(690),
    [sym_keyword_minvalue] = ACTIONS(690),
    [sym_keyword_maxvalue] = ACTIONS(690),
    [sym_keyword_owned] = ACTIONS(690),
    [sym_keyword_start] = ACTIONS(690),
    [sym_keyword_restart] = ACTIONS(690),
    [sym_keyword_as] = ACTIONS(690),
    [sym_keyword_when] = ACTIONS(690),
    [sym_keyword_then] = ACTIONS(690),
    [sym_keyword_else] = ACTIONS(690),
    [sym_keyword_end] = ACTIONS(690),
    [sym_keyword_in] = ACTIONS(690),
    [sym_keyword_and] = ACTIONS(690),
    [sym_keyword_or] = ACTIONS(690),
    [sym_keyword_is] = ACTIONS(690),
    [sym_keyword_not] = ACTIONS(690),
    [sym_keyword_using] = ACTIONS(690),
    [sym_keyword_collate] = ACTIONS(690),
    [sym_keyword_cascade] = ACTIONS(690),
    [sym_keyword_restrict] = ACTIONS(690),
    [aux_sym_keyword_with_token1] = ACTIONS(690),
    [sym_keyword_no] = ACTIONS(690),
    [sym_keyword_cycle] = ACTIONS(690),
    [sym_keyword_union] = ACTIONS(690),
    [sym_keyword_except] = ACTIONS(690),
    [sym_keyword_intersect] = ACTIONS(690),
    [sym_keyword_returning] = ACTIONS(690),
    [sym_keyword_between] = ACTIONS(690),
    [sym_keyword_preceding] = ACTIONS(690),
    [sym_keyword_following] = ACTIONS(690),
    [aux_sym_keyword_like_token1] = ACTIONS(690),
    [aux_sym_keyword_like_token2] = ACTIONS(690),
    [sym_keyword_similar] = ACTIONS(690),
    [sym_keyword_zerofill] = ACTIONS(692),
    [sym_keyword_cache] = ACTIONS(690),
    [sym_keyword_array] = ACTIONS(690),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(688),
    [anon_sym_RPAREN] = ACTIONS(688),
    [anon_sym_COMMA] = ACTIONS(688),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(690),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(688),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(688),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(688),
    [anon_sym_EQ] = ACTIONS(688),
    [anon_sym_STAR] = ACTIONS(688),
    [anon_sym_COLON_COLON] = ACTIONS(688),
    [anon_sym_LT] = ACTIONS(690),
    [anon_sym_GT] = ACTIONS(690),
    [anon_sym_LT_EQ] = ACTIONS(688),
    [anon_sym_GT_EQ] = ACTIONS(688),
    [anon_sym_PLUS] = ACTIONS(688),
    [anon_sym_DASH] = ACTIONS(690),
    [anon_sym_PERCENT] = ACTIONS(688),
    [anon_sym_CARET] = ACTIONS(688),
    [anon_sym_PIPE_PIPE] = ACTIONS(688),
    [anon_sym_BANG_EQ] = ACTIONS(688),
    [anon_sym_LT_GT] = ACTIONS(688),
    [anon_sym_DASH_GT] = ACTIONS(690),
    [anon_sym_DASH_GT_GT] = ACTIONS(688),
    [anon_sym_POUND_GT] = ACTIONS(690),
    [anon_sym_POUND_GT_GT] = ACTIONS(688),
    [anon_sym_DQUOTE] = ACTIONS(688),
    [anon_sym_BQUOTE] = ACTIONS(688),
  },
  [99] = {
    [sym_comment] = STATE(99),
    [sym_marginalia] = STATE(99),
    [ts_builtin_sym_end] = ACTIONS(429),
    [sym__identifier] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(429),
    [sym_keyword_set] = ACTIONS(431),
    [sym_keyword_from] = ACTIONS(431),
    [sym_keyword_left] = ACTIONS(431),
    [sym_keyword_right] = ACTIONS(431),
    [sym_keyword_inner] = ACTIONS(431),
    [sym_keyword_full] = ACTIONS(431),
    [sym_keyword_join] = ACTIONS(431),
    [sym_keyword_natural] = ACTIONS(431),
    [sym_keyword_on] = ACTIONS(431),
    [sym_keyword_where] = ACTIONS(431),
    [sym_keyword_create] = ACTIONS(431),
    [sym_keyword_increment] = ACTIONS(431),
    [sym_keyword_minvalue] = ACTIONS(431),
    [sym_keyword_maxvalue] = ACTIONS(431),
    [sym_keyword_owned] = ACTIONS(431),
    [sym_keyword_start] = ACTIONS(431),
    [sym_keyword_restart] = ACTIONS(431),
    [sym_keyword_as] = ACTIONS(431),
    [sym_keyword_when] = ACTIONS(431),
    [sym_keyword_then] = ACTIONS(431),
    [sym_keyword_else] = ACTIONS(431),
    [sym_keyword_end] = ACTIONS(431),
    [sym_keyword_in] = ACTIONS(431),
    [sym_keyword_and] = ACTIONS(431),
    [sym_keyword_or] = ACTIONS(431),
    [sym_keyword_is] = ACTIONS(431),
    [sym_keyword_not] = ACTIONS(431),
    [sym_keyword_using] = ACTIONS(431),
    [sym_keyword_collate] = ACTIONS(431),
    [sym_keyword_cascade] = ACTIONS(431),
    [sym_keyword_restrict] = ACTIONS(431),
    [aux_sym_keyword_with_token1] = ACTIONS(431),
    [sym_keyword_no] = ACTIONS(431),
    [sym_keyword_cycle] = ACTIONS(431),
    [sym_keyword_union] = ACTIONS(431),
    [sym_keyword_except] = ACTIONS(431),
    [sym_keyword_intersect] = ACTIONS(431),
    [sym_keyword_returning] = ACTIONS(431),
    [sym_keyword_between] = ACTIONS(431),
    [sym_keyword_preceding] = ACTIONS(431),
    [sym_keyword_following] = ACTIONS(431),
    [aux_sym_keyword_like_token1] = ACTIONS(431),
    [aux_sym_keyword_like_token2] = ACTIONS(431),
    [sym_keyword_similar] = ACTIONS(431),
    [sym_keyword_cache] = ACTIONS(431),
    [sym_keyword_array] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_RBRACK] = ACTIONS(429),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(429),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(431),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(429),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(429),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(429),
    [anon_sym_COLON_EQ] = ACTIONS(429),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_STAR] = ACTIONS(429),
    [anon_sym_COLON_COLON] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(431),
    [anon_sym_GT] = ACTIONS(431),
    [anon_sym_LT_EQ] = ACTIONS(429),
    [anon_sym_GT_EQ] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(429),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(429),
    [anon_sym_PIPE_PIPE] = ACTIONS(429),
    [anon_sym_BANG_EQ] = ACTIONS(429),
    [anon_sym_LT_GT] = ACTIONS(429),
    [anon_sym_DASH_GT] = ACTIONS(431),
    [anon_sym_DASH_GT_GT] = ACTIONS(429),
    [anon_sym_POUND_GT] = ACTIONS(431),
    [anon_sym_POUND_GT_GT] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(429),
    [anon_sym_BQUOTE] = ACTIONS(429),
  },
  [100] = {
    [sym_comment] = STATE(100),
    [sym_marginalia] = STATE(100),
    [ts_builtin_sym_end] = ACTIONS(557),
    [sym__identifier] = ACTIONS(559),
    [anon_sym_SEMI] = ACTIONS(557),
    [sym_keyword_set] = ACTIONS(559),
    [sym_keyword_from] = ACTIONS(559),
    [sym_keyword_left] = ACTIONS(559),
    [sym_keyword_right] = ACTIONS(559),
    [sym_keyword_inner] = ACTIONS(559),
    [sym_keyword_full] = ACTIONS(559),
    [sym_keyword_join] = ACTIONS(559),
    [sym_keyword_natural] = ACTIONS(559),
    [sym_keyword_on] = ACTIONS(559),
    [sym_keyword_where] = ACTIONS(559),
    [sym_keyword_create] = ACTIONS(559),
    [sym_keyword_increment] = ACTIONS(559),
    [sym_keyword_minvalue] = ACTIONS(559),
    [sym_keyword_maxvalue] = ACTIONS(559),
    [sym_keyword_owned] = ACTIONS(559),
    [sym_keyword_start] = ACTIONS(559),
    [sym_keyword_restart] = ACTIONS(559),
    [sym_keyword_as] = ACTIONS(559),
    [sym_keyword_when] = ACTIONS(559),
    [sym_keyword_then] = ACTIONS(559),
    [sym_keyword_else] = ACTIONS(559),
    [sym_keyword_end] = ACTIONS(559),
    [sym_keyword_in] = ACTIONS(559),
    [sym_keyword_and] = ACTIONS(559),
    [sym_keyword_or] = ACTIONS(559),
    [sym_keyword_is] = ACTIONS(559),
    [sym_keyword_not] = ACTIONS(559),
    [sym_keyword_using] = ACTIONS(559),
    [sym_keyword_collate] = ACTIONS(559),
    [sym_keyword_cascade] = ACTIONS(559),
    [sym_keyword_restrict] = ACTIONS(559),
    [aux_sym_keyword_with_token1] = ACTIONS(559),
    [sym_keyword_no] = ACTIONS(559),
    [sym_keyword_cycle] = ACTIONS(559),
    [sym_keyword_union] = ACTIONS(559),
    [sym_keyword_except] = ACTIONS(559),
    [sym_keyword_intersect] = ACTIONS(559),
    [sym_keyword_returning] = ACTIONS(559),
    [sym_keyword_between] = ACTIONS(559),
    [sym_keyword_preceding] = ACTIONS(559),
    [sym_keyword_following] = ACTIONS(559),
    [aux_sym_keyword_like_token1] = ACTIONS(559),
    [aux_sym_keyword_like_token2] = ACTIONS(559),
    [sym_keyword_similar] = ACTIONS(559),
    [sym_keyword_zerofill] = ACTIONS(694),
    [sym_keyword_cache] = ACTIONS(559),
    [sym_keyword_array] = ACTIONS(559),
    [anon_sym_LBRACK] = ACTIONS(557),
    [anon_sym_RBRACK] = ACTIONS(557),
    [anon_sym_RPAREN] = ACTIONS(557),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(559),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(557),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(557),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(557),
    [anon_sym_COLON_EQ] = ACTIONS(557),
    [anon_sym_EQ] = ACTIONS(557),
    [anon_sym_STAR] = ACTIONS(557),
    [anon_sym_COLON_COLON] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(559),
    [anon_sym_GT] = ACTIONS(559),
    [anon_sym_LT_EQ] = ACTIONS(557),
    [anon_sym_GT_EQ] = ACTIONS(557),
    [anon_sym_PLUS] = ACTIONS(557),
    [anon_sym_DASH] = ACTIONS(559),
    [anon_sym_PERCENT] = ACTIONS(557),
    [anon_sym_CARET] = ACTIONS(557),
    [anon_sym_PIPE_PIPE] = ACTIONS(557),
    [anon_sym_BANG_EQ] = ACTIONS(557),
    [anon_sym_LT_GT] = ACTIONS(557),
    [anon_sym_DASH_GT] = ACTIONS(559),
    [anon_sym_DASH_GT_GT] = ACTIONS(557),
    [anon_sym_POUND_GT] = ACTIONS(559),
    [anon_sym_POUND_GT_GT] = ACTIONS(557),
    [anon_sym_DQUOTE] = ACTIONS(557),
    [anon_sym_BQUOTE] = ACTIONS(557),
  },
  [101] = {
    [sym_keyword_with] = STATE(2636),
    [sym_comment] = STATE(101),
    [sym_marginalia] = STATE(101),
    [sym__commit] = STATE(4509),
    [sym__rollback] = STATE(4509),
    [sym_statement] = STATE(4508),
    [sym__ddl_statement] = STATE(2777),
    [sym__cte] = STATE(1872),
    [sym__dml_write] = STATE(2782),
    [sym__dml_read] = STATE(2788),
    [sym_set_operation] = STATE(2382),
    [sym__select_statement] = STATE(2032),
    [sym_comment_statement] = STATE(2791),
    [sym_select] = STATE(1952),
    [sym__truncate_statement] = STATE(2811),
    [sym__delete_statement] = STATE(2811),
    [sym_delete] = STATE(3725),
    [sym__create_statement] = STATE(2791),
    [sym_create_table] = STATE(2577),
    [sym_create_view] = STATE(2577),
    [sym_create_materialized_view] = STATE(2577),
    [sym_create_function] = STATE(2577),
    [sym_create_index] = STATE(2577),
    [sym_create_schema] = STATE(1825),
    [sym_create_database] = STATE(2577),
    [sym_create_role] = STATE(2577),
    [sym_create_sequence] = STATE(2577),
    [sym_create_type] = STATE(2577),
    [sym__alter_statement] = STATE(2791),
    [sym__rename_statement] = STATE(2813),
    [sym_alter_table] = STATE(2818),
    [sym_alter_view] = STATE(2818),
    [sym_alter_schema] = STATE(2818),
    [sym_alter_database] = STATE(2818),
    [sym_alter_role] = STATE(2818),
    [sym_alter_index] = STATE(2818),
    [sym_alter_sequence] = STATE(2818),
    [sym_alter_type] = STATE(2818),
    [sym__drop_statement] = STATE(2791),
    [sym_drop_table] = STATE(2819),
    [sym_drop_view] = STATE(2819),
    [sym_drop_schema] = STATE(2819),
    [sym_drop_database] = STATE(2819),
    [sym_drop_role] = STATE(2819),
    [sym_drop_type] = STATE(2819),
    [sym_drop_sequence] = STATE(2819),
    [sym_drop_index] = STATE(2819),
    [sym__insert_statement] = STATE(2811),
    [sym_insert] = STATE(2566),
    [sym__update_statement] = STATE(2811),
    [sym__merge_statement] = STATE(2820),
    [sym__optimize_statement] = STATE(2791),
    [sym__compute_stats] = STATE(2821),
    [sym__optimize_table] = STATE(2821),
    [sym__vacuum_table] = STATE(2821),
    [sym_update] = STATE(2547),
    [aux_sym_transaction_repeat1] = STATE(181),
    [anon_sym_SEMI] = ACTIONS(696),
    [sym_keyword_select] = ACTIONS(9),
    [sym_keyword_delete] = ACTIONS(11),
    [sym_keyword_insert] = ACTIONS(13),
    [sym_keyword_replace] = ACTIONS(13),
    [sym_keyword_update] = ACTIONS(15),
    [sym_keyword_truncate] = ACTIONS(17),
    [sym_keyword_merge] = ACTIONS(19),
    [sym_keyword_create] = ACTIONS(21),
    [sym_keyword_alter] = ACTIONS(23),
    [sym_keyword_analyze] = ACTIONS(25),
    [sym_keyword_explain] = ACTIONS(27),
    [sym_keyword_drop] = ACTIONS(29),
    [sym_keyword_end] = ACTIONS(698),
    [aux_sym_keyword_with_token1] = ACTIONS(31),
    [sym_keyword_rename] = ACTIONS(33),
    [sym_keyword_commit] = ACTIONS(700),
    [sym_keyword_rollback] = ACTIONS(702),
    [sym_keyword_transaction] = ACTIONS(704),
    [sym_keyword_vacuum] = ACTIONS(37),
    [sym_keyword_compute] = ACTIONS(39),
    [sym_keyword_optimize] = ACTIONS(41),
    [sym_keyword_comment] = ACTIONS(43),
    [anon_sym_LPAREN] = ACTIONS(45),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [102] = {
    [sym_comment] = STATE(102),
    [sym_marginalia] = STATE(102),
    [ts_builtin_sym_end] = ACTIONS(551),
    [sym__identifier] = ACTIONS(553),
    [anon_sym_SEMI] = ACTIONS(551),
    [sym_keyword_set] = ACTIONS(553),
    [sym_keyword_from] = ACTIONS(553),
    [sym_keyword_left] = ACTIONS(553),
    [sym_keyword_right] = ACTIONS(553),
    [sym_keyword_inner] = ACTIONS(553),
    [sym_keyword_full] = ACTIONS(553),
    [sym_keyword_join] = ACTIONS(553),
    [sym_keyword_natural] = ACTIONS(553),
    [sym_keyword_on] = ACTIONS(553),
    [sym_keyword_where] = ACTIONS(553),
    [sym_keyword_create] = ACTIONS(553),
    [sym_keyword_increment] = ACTIONS(553),
    [sym_keyword_minvalue] = ACTIONS(553),
    [sym_keyword_maxvalue] = ACTIONS(553),
    [sym_keyword_owned] = ACTIONS(553),
    [sym_keyword_start] = ACTIONS(553),
    [sym_keyword_restart] = ACTIONS(553),
    [sym_keyword_as] = ACTIONS(553),
    [sym_keyword_when] = ACTIONS(553),
    [sym_keyword_then] = ACTIONS(553),
    [sym_keyword_else] = ACTIONS(553),
    [sym_keyword_end] = ACTIONS(553),
    [sym_keyword_in] = ACTIONS(553),
    [sym_keyword_and] = ACTIONS(553),
    [sym_keyword_or] = ACTIONS(553),
    [sym_keyword_is] = ACTIONS(553),
    [sym_keyword_not] = ACTIONS(553),
    [sym_keyword_using] = ACTIONS(553),
    [sym_keyword_collate] = ACTIONS(553),
    [sym_keyword_cascade] = ACTIONS(553),
    [sym_keyword_restrict] = ACTIONS(553),
    [aux_sym_keyword_with_token1] = ACTIONS(553),
    [sym_keyword_no] = ACTIONS(553),
    [sym_keyword_cycle] = ACTIONS(553),
    [sym_keyword_union] = ACTIONS(553),
    [sym_keyword_except] = ACTIONS(553),
    [sym_keyword_intersect] = ACTIONS(553),
    [sym_keyword_returning] = ACTIONS(553),
    [sym_keyword_between] = ACTIONS(553),
    [sym_keyword_preceding] = ACTIONS(553),
    [sym_keyword_following] = ACTIONS(553),
    [aux_sym_keyword_like_token1] = ACTIONS(553),
    [aux_sym_keyword_like_token2] = ACTIONS(553),
    [sym_keyword_similar] = ACTIONS(553),
    [sym_keyword_zerofill] = ACTIONS(706),
    [sym_keyword_cache] = ACTIONS(553),
    [sym_keyword_array] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(551),
    [anon_sym_RBRACK] = ACTIONS(551),
    [anon_sym_RPAREN] = ACTIONS(551),
    [anon_sym_COMMA] = ACTIONS(551),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(553),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(551),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(551),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(551),
    [anon_sym_COLON_EQ] = ACTIONS(551),
    [anon_sym_EQ] = ACTIONS(551),
    [anon_sym_STAR] = ACTIONS(551),
    [anon_sym_COLON_COLON] = ACTIONS(551),
    [anon_sym_LT] = ACTIONS(553),
    [anon_sym_GT] = ACTIONS(553),
    [anon_sym_LT_EQ] = ACTIONS(551),
    [anon_sym_GT_EQ] = ACTIONS(551),
    [anon_sym_PLUS] = ACTIONS(551),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(551),
    [anon_sym_CARET] = ACTIONS(551),
    [anon_sym_PIPE_PIPE] = ACTIONS(551),
    [anon_sym_BANG_EQ] = ACTIONS(551),
    [anon_sym_LT_GT] = ACTIONS(551),
    [anon_sym_DASH_GT] = ACTIONS(553),
    [anon_sym_DASH_GT_GT] = ACTIONS(551),
    [anon_sym_POUND_GT] = ACTIONS(553),
    [anon_sym_POUND_GT_GT] = ACTIONS(551),
    [anon_sym_DQUOTE] = ACTIONS(551),
    [anon_sym_BQUOTE] = ACTIONS(551),
  },
  [103] = {
    [sym_comment] = STATE(103),
    [sym_marginalia] = STATE(103),
    [ts_builtin_sym_end] = ACTIONS(708),
    [sym__identifier] = ACTIONS(710),
    [anon_sym_SEMI] = ACTIONS(708),
    [sym_keyword_set] = ACTIONS(710),
    [sym_keyword_from] = ACTIONS(710),
    [sym_keyword_left] = ACTIONS(710),
    [sym_keyword_right] = ACTIONS(710),
    [sym_keyword_inner] = ACTIONS(710),
    [sym_keyword_full] = ACTIONS(710),
    [sym_keyword_join] = ACTIONS(710),
    [sym_keyword_natural] = ACTIONS(710),
    [sym_keyword_on] = ACTIONS(710),
    [sym_keyword_where] = ACTIONS(710),
    [sym_keyword_create] = ACTIONS(710),
    [sym_keyword_increment] = ACTIONS(710),
    [sym_keyword_minvalue] = ACTIONS(710),
    [sym_keyword_maxvalue] = ACTIONS(710),
    [sym_keyword_owned] = ACTIONS(710),
    [sym_keyword_start] = ACTIONS(710),
    [sym_keyword_restart] = ACTIONS(710),
    [sym_keyword_as] = ACTIONS(710),
    [sym_keyword_when] = ACTIONS(710),
    [sym_keyword_then] = ACTIONS(710),
    [sym_keyword_else] = ACTIONS(710),
    [sym_keyword_end] = ACTIONS(710),
    [sym_keyword_in] = ACTIONS(710),
    [sym_keyword_and] = ACTIONS(710),
    [sym_keyword_or] = ACTIONS(710),
    [sym_keyword_is] = ACTIONS(710),
    [sym_keyword_not] = ACTIONS(710),
    [sym_keyword_using] = ACTIONS(710),
    [sym_keyword_collate] = ACTIONS(710),
    [sym_keyword_cascade] = ACTIONS(710),
    [sym_keyword_restrict] = ACTIONS(710),
    [aux_sym_keyword_with_token1] = ACTIONS(710),
    [sym_keyword_no] = ACTIONS(710),
    [sym_keyword_cycle] = ACTIONS(710),
    [sym_keyword_union] = ACTIONS(710),
    [sym_keyword_except] = ACTIONS(710),
    [sym_keyword_intersect] = ACTIONS(710),
    [sym_keyword_returning] = ACTIONS(710),
    [sym_keyword_between] = ACTIONS(710),
    [sym_keyword_preceding] = ACTIONS(710),
    [sym_keyword_following] = ACTIONS(710),
    [aux_sym_keyword_like_token1] = ACTIONS(710),
    [aux_sym_keyword_like_token2] = ACTIONS(710),
    [sym_keyword_similar] = ACTIONS(710),
    [sym_keyword_cache] = ACTIONS(710),
    [sym_keyword_array] = ACTIONS(710),
    [anon_sym_LBRACK] = ACTIONS(708),
    [anon_sym_RBRACK] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(712),
    [anon_sym_RPAREN] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(708),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(710),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(708),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(708),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(708),
    [anon_sym_COLON_EQ] = ACTIONS(708),
    [anon_sym_EQ] = ACTIONS(708),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COLON_COLON] = ACTIONS(708),
    [anon_sym_LT] = ACTIONS(710),
    [anon_sym_GT] = ACTIONS(710),
    [anon_sym_LT_EQ] = ACTIONS(708),
    [anon_sym_GT_EQ] = ACTIONS(708),
    [anon_sym_PLUS] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(710),
    [anon_sym_PERCENT] = ACTIONS(708),
    [anon_sym_CARET] = ACTIONS(708),
    [anon_sym_PIPE_PIPE] = ACTIONS(708),
    [anon_sym_BANG_EQ] = ACTIONS(708),
    [anon_sym_LT_GT] = ACTIONS(708),
    [anon_sym_DASH_GT] = ACTIONS(710),
    [anon_sym_DASH_GT_GT] = ACTIONS(708),
    [anon_sym_POUND_GT] = ACTIONS(710),
    [anon_sym_POUND_GT_GT] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(708),
    [anon_sym_BQUOTE] = ACTIONS(708),
  },
  [104] = {
    [sym_comment] = STATE(104),
    [sym_marginalia] = STATE(104),
    [ts_builtin_sym_end] = ACTIONS(714),
    [sym__identifier] = ACTIONS(716),
    [anon_sym_SEMI] = ACTIONS(714),
    [sym_keyword_set] = ACTIONS(716),
    [sym_keyword_from] = ACTIONS(716),
    [sym_keyword_left] = ACTIONS(716),
    [sym_keyword_right] = ACTIONS(716),
    [sym_keyword_inner] = ACTIONS(716),
    [sym_keyword_full] = ACTIONS(716),
    [sym_keyword_join] = ACTIONS(716),
    [sym_keyword_natural] = ACTIONS(716),
    [sym_keyword_on] = ACTIONS(716),
    [sym_keyword_where] = ACTIONS(716),
    [sym_keyword_create] = ACTIONS(716),
    [sym_keyword_increment] = ACTIONS(716),
    [sym_keyword_minvalue] = ACTIONS(716),
    [sym_keyword_maxvalue] = ACTIONS(716),
    [sym_keyword_owned] = ACTIONS(716),
    [sym_keyword_start] = ACTIONS(716),
    [sym_keyword_restart] = ACTIONS(716),
    [sym_keyword_as] = ACTIONS(716),
    [sym_keyword_when] = ACTIONS(716),
    [sym_keyword_then] = ACTIONS(716),
    [sym_keyword_else] = ACTIONS(716),
    [sym_keyword_end] = ACTIONS(716),
    [sym_keyword_in] = ACTIONS(716),
    [sym_keyword_and] = ACTIONS(716),
    [sym_keyword_or] = ACTIONS(716),
    [sym_keyword_is] = ACTIONS(716),
    [sym_keyword_not] = ACTIONS(716),
    [sym_keyword_using] = ACTIONS(716),
    [sym_keyword_collate] = ACTIONS(716),
    [sym_keyword_cascade] = ACTIONS(716),
    [sym_keyword_restrict] = ACTIONS(716),
    [aux_sym_keyword_with_token1] = ACTIONS(716),
    [sym_keyword_no] = ACTIONS(716),
    [sym_keyword_cycle] = ACTIONS(716),
    [sym_keyword_union] = ACTIONS(716),
    [sym_keyword_except] = ACTIONS(716),
    [sym_keyword_intersect] = ACTIONS(716),
    [sym_keyword_returning] = ACTIONS(716),
    [sym_keyword_between] = ACTIONS(716),
    [sym_keyword_preceding] = ACTIONS(716),
    [sym_keyword_following] = ACTIONS(716),
    [aux_sym_keyword_like_token1] = ACTIONS(716),
    [aux_sym_keyword_like_token2] = ACTIONS(716),
    [sym_keyword_similar] = ACTIONS(716),
    [sym_keyword_cache] = ACTIONS(716),
    [sym_keyword_array] = ACTIONS(716),
    [anon_sym_LBRACK] = ACTIONS(714),
    [anon_sym_RBRACK] = ACTIONS(714),
    [anon_sym_LPAREN] = ACTIONS(718),
    [anon_sym_RPAREN] = ACTIONS(714),
    [anon_sym_COMMA] = ACTIONS(714),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(716),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(714),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(714),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(714),
    [anon_sym_COLON_EQ] = ACTIONS(714),
    [anon_sym_EQ] = ACTIONS(714),
    [anon_sym_STAR] = ACTIONS(714),
    [anon_sym_COLON_COLON] = ACTIONS(714),
    [anon_sym_LT] = ACTIONS(716),
    [anon_sym_GT] = ACTIONS(716),
    [anon_sym_LT_EQ] = ACTIONS(714),
    [anon_sym_GT_EQ] = ACTIONS(714),
    [anon_sym_PLUS] = ACTIONS(714),
    [anon_sym_DASH] = ACTIONS(716),
    [anon_sym_PERCENT] = ACTIONS(714),
    [anon_sym_CARET] = ACTIONS(714),
    [anon_sym_PIPE_PIPE] = ACTIONS(714),
    [anon_sym_BANG_EQ] = ACTIONS(714),
    [anon_sym_LT_GT] = ACTIONS(714),
    [anon_sym_DASH_GT] = ACTIONS(716),
    [anon_sym_DASH_GT_GT] = ACTIONS(714),
    [anon_sym_POUND_GT] = ACTIONS(716),
    [anon_sym_POUND_GT_GT] = ACTIONS(714),
    [anon_sym_DQUOTE] = ACTIONS(714),
    [anon_sym_BQUOTE] = ACTIONS(714),
  },
  [105] = {
    [sym_comment] = STATE(105),
    [sym_marginalia] = STATE(105),
    [ts_builtin_sym_end] = ACTIONS(720),
    [sym__identifier] = ACTIONS(722),
    [anon_sym_SEMI] = ACTIONS(720),
    [sym_keyword_set] = ACTIONS(722),
    [sym_keyword_from] = ACTIONS(722),
    [sym_keyword_left] = ACTIONS(722),
    [sym_keyword_right] = ACTIONS(722),
    [sym_keyword_inner] = ACTIONS(722),
    [sym_keyword_full] = ACTIONS(722),
    [sym_keyword_join] = ACTIONS(722),
    [sym_keyword_natural] = ACTIONS(722),
    [sym_keyword_on] = ACTIONS(722),
    [sym_keyword_where] = ACTIONS(722),
    [sym_keyword_create] = ACTIONS(722),
    [sym_keyword_increment] = ACTIONS(722),
    [sym_keyword_minvalue] = ACTIONS(722),
    [sym_keyword_maxvalue] = ACTIONS(722),
    [sym_keyword_owned] = ACTIONS(722),
    [sym_keyword_start] = ACTIONS(722),
    [sym_keyword_restart] = ACTIONS(722),
    [sym_keyword_as] = ACTIONS(722),
    [sym_keyword_when] = ACTIONS(722),
    [sym_keyword_then] = ACTIONS(722),
    [sym_keyword_else] = ACTIONS(722),
    [sym_keyword_end] = ACTIONS(722),
    [sym_keyword_in] = ACTIONS(722),
    [sym_keyword_and] = ACTIONS(722),
    [sym_keyword_or] = ACTIONS(722),
    [sym_keyword_is] = ACTIONS(722),
    [sym_keyword_not] = ACTIONS(722),
    [sym_keyword_using] = ACTIONS(722),
    [sym_keyword_collate] = ACTIONS(722),
    [sym_keyword_cascade] = ACTIONS(722),
    [sym_keyword_restrict] = ACTIONS(722),
    [aux_sym_keyword_with_token1] = ACTIONS(722),
    [sym_keyword_no] = ACTIONS(722),
    [sym_keyword_cycle] = ACTIONS(722),
    [sym_keyword_union] = ACTIONS(722),
    [sym_keyword_except] = ACTIONS(722),
    [sym_keyword_intersect] = ACTIONS(722),
    [sym_keyword_returning] = ACTIONS(722),
    [sym_keyword_between] = ACTIONS(722),
    [sym_keyword_preceding] = ACTIONS(722),
    [sym_keyword_following] = ACTIONS(722),
    [aux_sym_keyword_like_token1] = ACTIONS(722),
    [aux_sym_keyword_like_token2] = ACTIONS(722),
    [sym_keyword_similar] = ACTIONS(722),
    [sym_keyword_zerofill] = ACTIONS(724),
    [sym_keyword_cache] = ACTIONS(722),
    [sym_keyword_array] = ACTIONS(722),
    [anon_sym_LBRACK] = ACTIONS(720),
    [anon_sym_RBRACK] = ACTIONS(720),
    [anon_sym_RPAREN] = ACTIONS(720),
    [anon_sym_COMMA] = ACTIONS(720),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(722),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(720),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(720),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(720),
    [anon_sym_COLON_EQ] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(720),
    [anon_sym_STAR] = ACTIONS(720),
    [anon_sym_COLON_COLON] = ACTIONS(720),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(722),
    [anon_sym_LT_EQ] = ACTIONS(720),
    [anon_sym_GT_EQ] = ACTIONS(720),
    [anon_sym_PLUS] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(722),
    [anon_sym_PERCENT] = ACTIONS(720),
    [anon_sym_CARET] = ACTIONS(720),
    [anon_sym_PIPE_PIPE] = ACTIONS(720),
    [anon_sym_BANG_EQ] = ACTIONS(720),
    [anon_sym_LT_GT] = ACTIONS(720),
    [anon_sym_DASH_GT] = ACTIONS(722),
    [anon_sym_DASH_GT_GT] = ACTIONS(720),
    [anon_sym_POUND_GT] = ACTIONS(722),
    [anon_sym_POUND_GT_GT] = ACTIONS(720),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_BQUOTE] = ACTIONS(720),
  },
  [106] = {
    [sym_comment] = STATE(106),
    [sym_marginalia] = STATE(106),
    [ts_builtin_sym_end] = ACTIONS(545),
    [sym__identifier] = ACTIONS(547),
    [anon_sym_SEMI] = ACTIONS(545),
    [sym_keyword_set] = ACTIONS(547),
    [sym_keyword_from] = ACTIONS(547),
    [sym_keyword_left] = ACTIONS(547),
    [sym_keyword_right] = ACTIONS(547),
    [sym_keyword_inner] = ACTIONS(547),
    [sym_keyword_full] = ACTIONS(547),
    [sym_keyword_join] = ACTIONS(547),
    [sym_keyword_natural] = ACTIONS(547),
    [sym_keyword_on] = ACTIONS(547),
    [sym_keyword_where] = ACTIONS(547),
    [sym_keyword_create] = ACTIONS(547),
    [sym_keyword_increment] = ACTIONS(547),
    [sym_keyword_minvalue] = ACTIONS(547),
    [sym_keyword_maxvalue] = ACTIONS(547),
    [sym_keyword_owned] = ACTIONS(547),
    [sym_keyword_start] = ACTIONS(547),
    [sym_keyword_restart] = ACTIONS(547),
    [sym_keyword_as] = ACTIONS(547),
    [sym_keyword_when] = ACTIONS(547),
    [sym_keyword_then] = ACTIONS(547),
    [sym_keyword_else] = ACTIONS(547),
    [sym_keyword_end] = ACTIONS(547),
    [sym_keyword_in] = ACTIONS(547),
    [sym_keyword_and] = ACTIONS(547),
    [sym_keyword_or] = ACTIONS(547),
    [sym_keyword_is] = ACTIONS(547),
    [sym_keyword_not] = ACTIONS(547),
    [sym_keyword_using] = ACTIONS(547),
    [sym_keyword_collate] = ACTIONS(547),
    [sym_keyword_cascade] = ACTIONS(547),
    [sym_keyword_restrict] = ACTIONS(547),
    [aux_sym_keyword_with_token1] = ACTIONS(547),
    [sym_keyword_no] = ACTIONS(547),
    [sym_keyword_cycle] = ACTIONS(547),
    [sym_keyword_union] = ACTIONS(547),
    [sym_keyword_except] = ACTIONS(547),
    [sym_keyword_intersect] = ACTIONS(547),
    [sym_keyword_returning] = ACTIONS(547),
    [sym_keyword_between] = ACTIONS(547),
    [sym_keyword_preceding] = ACTIONS(547),
    [sym_keyword_following] = ACTIONS(547),
    [aux_sym_keyword_like_token1] = ACTIONS(547),
    [aux_sym_keyword_like_token2] = ACTIONS(547),
    [sym_keyword_similar] = ACTIONS(547),
    [sym_keyword_zerofill] = ACTIONS(726),
    [sym_keyword_cache] = ACTIONS(547),
    [sym_keyword_array] = ACTIONS(547),
    [anon_sym_LBRACK] = ACTIONS(545),
    [anon_sym_RBRACK] = ACTIONS(545),
    [anon_sym_RPAREN] = ACTIONS(545),
    [anon_sym_COMMA] = ACTIONS(545),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(547),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(545),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(545),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(545),
    [anon_sym_COLON_EQ] = ACTIONS(545),
    [anon_sym_EQ] = ACTIONS(545),
    [anon_sym_STAR] = ACTIONS(545),
    [anon_sym_COLON_COLON] = ACTIONS(545),
    [anon_sym_LT] = ACTIONS(547),
    [anon_sym_GT] = ACTIONS(547),
    [anon_sym_LT_EQ] = ACTIONS(545),
    [anon_sym_GT_EQ] = ACTIONS(545),
    [anon_sym_PLUS] = ACTIONS(545),
    [anon_sym_DASH] = ACTIONS(547),
    [anon_sym_PERCENT] = ACTIONS(545),
    [anon_sym_CARET] = ACTIONS(545),
    [anon_sym_PIPE_PIPE] = ACTIONS(545),
    [anon_sym_BANG_EQ] = ACTIONS(545),
    [anon_sym_LT_GT] = ACTIONS(545),
    [anon_sym_DASH_GT] = ACTIONS(547),
    [anon_sym_DASH_GT_GT] = ACTIONS(545),
    [anon_sym_POUND_GT] = ACTIONS(547),
    [anon_sym_POUND_GT_GT] = ACTIONS(545),
    [anon_sym_DQUOTE] = ACTIONS(545),
    [anon_sym_BQUOTE] = ACTIONS(545),
  },
  [107] = {
    [sym_comment] = STATE(107),
    [sym_marginalia] = STATE(107),
    [ts_builtin_sym_end] = ACTIONS(539),
    [sym__identifier] = ACTIONS(541),
    [anon_sym_SEMI] = ACTIONS(539),
    [sym_keyword_set] = ACTIONS(541),
    [sym_keyword_from] = ACTIONS(541),
    [sym_keyword_left] = ACTIONS(541),
    [sym_keyword_right] = ACTIONS(541),
    [sym_keyword_inner] = ACTIONS(541),
    [sym_keyword_full] = ACTIONS(541),
    [sym_keyword_join] = ACTIONS(541),
    [sym_keyword_natural] = ACTIONS(541),
    [sym_keyword_on] = ACTIONS(541),
    [sym_keyword_where] = ACTIONS(541),
    [sym_keyword_create] = ACTIONS(541),
    [sym_keyword_increment] = ACTIONS(541),
    [sym_keyword_minvalue] = ACTIONS(541),
    [sym_keyword_maxvalue] = ACTIONS(541),
    [sym_keyword_owned] = ACTIONS(541),
    [sym_keyword_start] = ACTIONS(541),
    [sym_keyword_restart] = ACTIONS(541),
    [sym_keyword_as] = ACTIONS(541),
    [sym_keyword_when] = ACTIONS(541),
    [sym_keyword_then] = ACTIONS(541),
    [sym_keyword_else] = ACTIONS(541),
    [sym_keyword_end] = ACTIONS(541),
    [sym_keyword_in] = ACTIONS(541),
    [sym_keyword_and] = ACTIONS(541),
    [sym_keyword_or] = ACTIONS(541),
    [sym_keyword_is] = ACTIONS(541),
    [sym_keyword_not] = ACTIONS(541),
    [sym_keyword_using] = ACTIONS(541),
    [sym_keyword_collate] = ACTIONS(541),
    [sym_keyword_cascade] = ACTIONS(541),
    [sym_keyword_restrict] = ACTIONS(541),
    [aux_sym_keyword_with_token1] = ACTIONS(541),
    [sym_keyword_no] = ACTIONS(541),
    [sym_keyword_cycle] = ACTIONS(541),
    [sym_keyword_union] = ACTIONS(541),
    [sym_keyword_except] = ACTIONS(541),
    [sym_keyword_intersect] = ACTIONS(541),
    [sym_keyword_returning] = ACTIONS(541),
    [sym_keyword_between] = ACTIONS(541),
    [sym_keyword_preceding] = ACTIONS(541),
    [sym_keyword_following] = ACTIONS(541),
    [aux_sym_keyword_like_token1] = ACTIONS(541),
    [aux_sym_keyword_like_token2] = ACTIONS(541),
    [sym_keyword_similar] = ACTIONS(541),
    [sym_keyword_zerofill] = ACTIONS(728),
    [sym_keyword_cache] = ACTIONS(541),
    [sym_keyword_array] = ACTIONS(541),
    [anon_sym_LBRACK] = ACTIONS(539),
    [anon_sym_RBRACK] = ACTIONS(539),
    [anon_sym_RPAREN] = ACTIONS(539),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(541),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(539),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(539),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(539),
    [anon_sym_COLON_EQ] = ACTIONS(539),
    [anon_sym_EQ] = ACTIONS(539),
    [anon_sym_STAR] = ACTIONS(539),
    [anon_sym_COLON_COLON] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(541),
    [anon_sym_GT] = ACTIONS(541),
    [anon_sym_LT_EQ] = ACTIONS(539),
    [anon_sym_GT_EQ] = ACTIONS(539),
    [anon_sym_PLUS] = ACTIONS(539),
    [anon_sym_DASH] = ACTIONS(541),
    [anon_sym_PERCENT] = ACTIONS(539),
    [anon_sym_CARET] = ACTIONS(539),
    [anon_sym_PIPE_PIPE] = ACTIONS(539),
    [anon_sym_BANG_EQ] = ACTIONS(539),
    [anon_sym_LT_GT] = ACTIONS(539),
    [anon_sym_DASH_GT] = ACTIONS(541),
    [anon_sym_DASH_GT_GT] = ACTIONS(539),
    [anon_sym_POUND_GT] = ACTIONS(541),
    [anon_sym_POUND_GT_GT] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [anon_sym_BQUOTE] = ACTIONS(539),
  },
  [108] = {
    [sym_comment] = STATE(108),
    [sym_marginalia] = STATE(108),
    [ts_builtin_sym_end] = ACTIONS(730),
    [sym__identifier] = ACTIONS(732),
    [anon_sym_SEMI] = ACTIONS(730),
    [sym_keyword_set] = ACTIONS(732),
    [sym_keyword_from] = ACTIONS(732),
    [sym_keyword_left] = ACTIONS(732),
    [sym_keyword_right] = ACTIONS(732),
    [sym_keyword_inner] = ACTIONS(732),
    [sym_keyword_full] = ACTIONS(732),
    [sym_keyword_join] = ACTIONS(732),
    [sym_keyword_natural] = ACTIONS(732),
    [sym_keyword_on] = ACTIONS(732),
    [sym_keyword_where] = ACTIONS(732),
    [sym_keyword_create] = ACTIONS(732),
    [sym_keyword_increment] = ACTIONS(732),
    [sym_keyword_minvalue] = ACTIONS(732),
    [sym_keyword_maxvalue] = ACTIONS(732),
    [sym_keyword_owned] = ACTIONS(732),
    [sym_keyword_start] = ACTIONS(732),
    [sym_keyword_restart] = ACTIONS(732),
    [sym_keyword_as] = ACTIONS(732),
    [sym_keyword_when] = ACTIONS(732),
    [sym_keyword_then] = ACTIONS(732),
    [sym_keyword_else] = ACTIONS(732),
    [sym_keyword_end] = ACTIONS(732),
    [sym_keyword_in] = ACTIONS(732),
    [sym_keyword_and] = ACTIONS(732),
    [sym_keyword_or] = ACTIONS(732),
    [sym_keyword_is] = ACTIONS(732),
    [sym_keyword_not] = ACTIONS(732),
    [sym_keyword_using] = ACTIONS(732),
    [sym_keyword_collate] = ACTIONS(732),
    [sym_keyword_cascade] = ACTIONS(732),
    [sym_keyword_restrict] = ACTIONS(732),
    [aux_sym_keyword_with_token1] = ACTIONS(734),
    [sym_keyword_no] = ACTIONS(732),
    [sym_keyword_cycle] = ACTIONS(732),
    [sym_keyword_union] = ACTIONS(732),
    [sym_keyword_except] = ACTIONS(732),
    [sym_keyword_intersect] = ACTIONS(732),
    [sym_keyword_returning] = ACTIONS(732),
    [sym_keyword_between] = ACTIONS(732),
    [sym_keyword_preceding] = ACTIONS(732),
    [sym_keyword_following] = ACTIONS(732),
    [aux_sym_keyword_like_token1] = ACTIONS(732),
    [aux_sym_keyword_like_token2] = ACTIONS(732),
    [sym_keyword_similar] = ACTIONS(732),
    [sym_keyword_cache] = ACTIONS(732),
    [aux_sym_keyword_timestamp_token2] = ACTIONS(736),
    [sym_keyword_array] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(730),
    [anon_sym_RBRACK] = ACTIONS(730),
    [anon_sym_RPAREN] = ACTIONS(730),
    [anon_sym_COMMA] = ACTIONS(730),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(732),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(730),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(730),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(730),
    [anon_sym_COLON_EQ] = ACTIONS(730),
    [anon_sym_EQ] = ACTIONS(730),
    [anon_sym_STAR] = ACTIONS(730),
    [anon_sym_COLON_COLON] = ACTIONS(730),
    [anon_sym_LT] = ACTIONS(732),
    [anon_sym_GT] = ACTIONS(732),
    [anon_sym_LT_EQ] = ACTIONS(730),
    [anon_sym_GT_EQ] = ACTIONS(730),
    [anon_sym_PLUS] = ACTIONS(730),
    [anon_sym_DASH] = ACTIONS(732),
    [anon_sym_PERCENT] = ACTIONS(730),
    [anon_sym_CARET] = ACTIONS(730),
    [anon_sym_PIPE_PIPE] = ACTIONS(730),
    [anon_sym_BANG_EQ] = ACTIONS(730),
    [anon_sym_LT_GT] = ACTIONS(730),
    [anon_sym_DASH_GT] = ACTIONS(732),
    [anon_sym_DASH_GT_GT] = ACTIONS(730),
    [anon_sym_POUND_GT] = ACTIONS(732),
    [anon_sym_POUND_GT_GT] = ACTIONS(730),
    [anon_sym_DQUOTE] = ACTIONS(730),
    [anon_sym_BQUOTE] = ACTIONS(730),
  },
  [109] = {
    [sym_comment] = STATE(109),
    [sym_marginalia] = STATE(109),
    [ts_builtin_sym_end] = ACTIONS(738),
    [sym__identifier] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(738),
    [sym_keyword_set] = ACTIONS(740),
    [sym_keyword_from] = ACTIONS(740),
    [sym_keyword_left] = ACTIONS(740),
    [sym_keyword_right] = ACTIONS(740),
    [sym_keyword_inner] = ACTIONS(740),
    [sym_keyword_full] = ACTIONS(740),
    [sym_keyword_join] = ACTIONS(740),
    [sym_keyword_natural] = ACTIONS(740),
    [sym_keyword_on] = ACTIONS(740),
    [sym_keyword_where] = ACTIONS(740),
    [sym_keyword_create] = ACTIONS(740),
    [sym_keyword_increment] = ACTIONS(740),
    [sym_keyword_minvalue] = ACTIONS(740),
    [sym_keyword_maxvalue] = ACTIONS(740),
    [sym_keyword_owned] = ACTIONS(740),
    [sym_keyword_start] = ACTIONS(740),
    [sym_keyword_restart] = ACTIONS(740),
    [sym_keyword_as] = ACTIONS(740),
    [sym_keyword_when] = ACTIONS(740),
    [sym_keyword_then] = ACTIONS(740),
    [sym_keyword_else] = ACTIONS(740),
    [sym_keyword_end] = ACTIONS(740),
    [sym_keyword_in] = ACTIONS(740),
    [sym_keyword_and] = ACTIONS(740),
    [sym_keyword_or] = ACTIONS(740),
    [sym_keyword_is] = ACTIONS(740),
    [sym_keyword_not] = ACTIONS(740),
    [sym_keyword_using] = ACTIONS(740),
    [sym_keyword_collate] = ACTIONS(740),
    [sym_keyword_cascade] = ACTIONS(740),
    [sym_keyword_restrict] = ACTIONS(740),
    [aux_sym_keyword_with_token1] = ACTIONS(740),
    [sym_keyword_no] = ACTIONS(740),
    [sym_keyword_cycle] = ACTIONS(740),
    [sym_keyword_union] = ACTIONS(740),
    [sym_keyword_except] = ACTIONS(740),
    [sym_keyword_intersect] = ACTIONS(740),
    [sym_keyword_returning] = ACTIONS(740),
    [sym_keyword_between] = ACTIONS(740),
    [sym_keyword_preceding] = ACTIONS(740),
    [sym_keyword_following] = ACTIONS(740),
    [aux_sym_keyword_like_token1] = ACTIONS(740),
    [aux_sym_keyword_like_token2] = ACTIONS(740),
    [sym_keyword_similar] = ACTIONS(740),
    [sym_keyword_zerofill] = ACTIONS(742),
    [sym_keyword_cache] = ACTIONS(740),
    [sym_keyword_array] = ACTIONS(740),
    [anon_sym_LBRACK] = ACTIONS(738),
    [anon_sym_RBRACK] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(738),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(738),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(738),
    [anon_sym_COLON_EQ] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_COLON_COLON] = ACTIONS(738),
    [anon_sym_LT] = ACTIONS(740),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_LT_EQ] = ACTIONS(738),
    [anon_sym_GT_EQ] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym_PIPE_PIPE] = ACTIONS(738),
    [anon_sym_BANG_EQ] = ACTIONS(738),
    [anon_sym_LT_GT] = ACTIONS(738),
    [anon_sym_DASH_GT] = ACTIONS(740),
    [anon_sym_DASH_GT_GT] = ACTIONS(738),
    [anon_sym_POUND_GT] = ACTIONS(740),
    [anon_sym_POUND_GT_GT] = ACTIONS(738),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
  },
  [110] = {
    [sym_comment] = STATE(110),
    [sym_marginalia] = STATE(110),
    [ts_builtin_sym_end] = ACTIONS(744),
    [sym__identifier] = ACTIONS(746),
    [anon_sym_SEMI] = ACTIONS(744),
    [sym_keyword_set] = ACTIONS(746),
    [sym_keyword_from] = ACTIONS(746),
    [sym_keyword_left] = ACTIONS(746),
    [sym_keyword_right] = ACTIONS(746),
    [sym_keyword_inner] = ACTIONS(746),
    [sym_keyword_full] = ACTIONS(746),
    [sym_keyword_join] = ACTIONS(746),
    [sym_keyword_natural] = ACTIONS(746),
    [sym_keyword_on] = ACTIONS(746),
    [sym_keyword_where] = ACTIONS(746),
    [sym_keyword_create] = ACTIONS(746),
    [sym_keyword_increment] = ACTIONS(746),
    [sym_keyword_minvalue] = ACTIONS(746),
    [sym_keyword_maxvalue] = ACTIONS(746),
    [sym_keyword_owned] = ACTIONS(746),
    [sym_keyword_start] = ACTIONS(746),
    [sym_keyword_restart] = ACTIONS(746),
    [sym_keyword_as] = ACTIONS(746),
    [sym_keyword_when] = ACTIONS(746),
    [sym_keyword_then] = ACTIONS(746),
    [sym_keyword_else] = ACTIONS(746),
    [sym_keyword_end] = ACTIONS(746),
    [sym_keyword_in] = ACTIONS(746),
    [sym_keyword_and] = ACTIONS(746),
    [sym_keyword_or] = ACTIONS(746),
    [sym_keyword_is] = ACTIONS(746),
    [sym_keyword_not] = ACTIONS(746),
    [sym_keyword_using] = ACTIONS(746),
    [sym_keyword_collate] = ACTIONS(746),
    [sym_keyword_cascade] = ACTIONS(746),
    [sym_keyword_restrict] = ACTIONS(746),
    [aux_sym_keyword_with_token1] = ACTIONS(746),
    [sym_keyword_no] = ACTIONS(746),
    [sym_keyword_cycle] = ACTIONS(746),
    [sym_keyword_union] = ACTIONS(746),
    [sym_keyword_except] = ACTIONS(746),
    [sym_keyword_intersect] = ACTIONS(746),
    [sym_keyword_returning] = ACTIONS(746),
    [sym_keyword_between] = ACTIONS(746),
    [sym_keyword_preceding] = ACTIONS(746),
    [sym_keyword_following] = ACTIONS(746),
    [aux_sym_keyword_like_token1] = ACTIONS(746),
    [aux_sym_keyword_like_token2] = ACTIONS(746),
    [sym_keyword_similar] = ACTIONS(746),
    [sym_keyword_cache] = ACTIONS(746),
    [sym_keyword_array] = ACTIONS(746),
    [anon_sym_LBRACK] = ACTIONS(744),
    [anon_sym_RBRACK] = ACTIONS(744),
    [anon_sym_RPAREN] = ACTIONS(744),
    [anon_sym_COMMA] = ACTIONS(744),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(746),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(744),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(744),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(744),
    [anon_sym_COLON_EQ] = ACTIONS(744),
    [anon_sym_EQ] = ACTIONS(744),
    [anon_sym_STAR] = ACTIONS(744),
    [anon_sym_COLON_COLON] = ACTIONS(744),
    [anon_sym_LT] = ACTIONS(746),
    [anon_sym_GT] = ACTIONS(746),
    [anon_sym_LT_EQ] = ACTIONS(744),
    [anon_sym_GT_EQ] = ACTIONS(744),
    [anon_sym_PLUS] = ACTIONS(744),
    [anon_sym_DASH] = ACTIONS(746),
    [anon_sym_PERCENT] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(744),
    [anon_sym_PIPE_PIPE] = ACTIONS(744),
    [anon_sym_BANG_EQ] = ACTIONS(744),
    [anon_sym_LT_GT] = ACTIONS(744),
    [anon_sym_DASH_GT] = ACTIONS(746),
    [anon_sym_DASH_GT_GT] = ACTIONS(744),
    [anon_sym_POUND_GT] = ACTIONS(746),
    [anon_sym_POUND_GT_GT] = ACTIONS(744),
    [anon_sym_DQUOTE] = ACTIONS(744),
    [anon_sym_BQUOTE] = ACTIONS(744),
  },
  [111] = {
    [sym_comment] = STATE(111),
    [sym_marginalia] = STATE(111),
    [ts_builtin_sym_end] = ACTIONS(557),
    [sym__identifier] = ACTIONS(559),
    [anon_sym_SEMI] = ACTIONS(557),
    [sym_keyword_set] = ACTIONS(559),
    [sym_keyword_from] = ACTIONS(559),
    [sym_keyword_left] = ACTIONS(559),
    [sym_keyword_right] = ACTIONS(559),
    [sym_keyword_inner] = ACTIONS(559),
    [sym_keyword_full] = ACTIONS(559),
    [sym_keyword_join] = ACTIONS(559),
    [sym_keyword_natural] = ACTIONS(559),
    [sym_keyword_on] = ACTIONS(559),
    [sym_keyword_where] = ACTIONS(559),
    [sym_keyword_create] = ACTIONS(559),
    [sym_keyword_increment] = ACTIONS(559),
    [sym_keyword_minvalue] = ACTIONS(559),
    [sym_keyword_maxvalue] = ACTIONS(559),
    [sym_keyword_owned] = ACTIONS(559),
    [sym_keyword_start] = ACTIONS(559),
    [sym_keyword_restart] = ACTIONS(559),
    [sym_keyword_as] = ACTIONS(559),
    [sym_keyword_when] = ACTIONS(559),
    [sym_keyword_then] = ACTIONS(559),
    [sym_keyword_else] = ACTIONS(559),
    [sym_keyword_end] = ACTIONS(559),
    [sym_keyword_in] = ACTIONS(559),
    [sym_keyword_and] = ACTIONS(559),
    [sym_keyword_or] = ACTIONS(559),
    [sym_keyword_is] = ACTIONS(559),
    [sym_keyword_not] = ACTIONS(559),
    [sym_keyword_using] = ACTIONS(559),
    [sym_keyword_collate] = ACTIONS(559),
    [sym_keyword_cascade] = ACTIONS(559),
    [sym_keyword_restrict] = ACTIONS(559),
    [aux_sym_keyword_with_token1] = ACTIONS(559),
    [sym_keyword_no] = ACTIONS(559),
    [sym_keyword_cycle] = ACTIONS(559),
    [sym_keyword_union] = ACTIONS(559),
    [sym_keyword_except] = ACTIONS(559),
    [sym_keyword_intersect] = ACTIONS(559),
    [sym_keyword_returning] = ACTIONS(559),
    [sym_keyword_between] = ACTIONS(559),
    [sym_keyword_preceding] = ACTIONS(559),
    [sym_keyword_following] = ACTIONS(559),
    [aux_sym_keyword_like_token1] = ACTIONS(559),
    [aux_sym_keyword_like_token2] = ACTIONS(559),
    [sym_keyword_similar] = ACTIONS(559),
    [sym_keyword_cache] = ACTIONS(559),
    [sym_keyword_array] = ACTIONS(559),
    [anon_sym_LBRACK] = ACTIONS(557),
    [anon_sym_RBRACK] = ACTIONS(557),
    [anon_sym_RPAREN] = ACTIONS(557),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(559),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(557),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(557),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(557),
    [anon_sym_COLON_EQ] = ACTIONS(557),
    [anon_sym_EQ] = ACTIONS(557),
    [anon_sym_STAR] = ACTIONS(557),
    [anon_sym_COLON_COLON] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(559),
    [anon_sym_GT] = ACTIONS(559),
    [anon_sym_LT_EQ] = ACTIONS(557),
    [anon_sym_GT_EQ] = ACTIONS(557),
    [anon_sym_PLUS] = ACTIONS(557),
    [anon_sym_DASH] = ACTIONS(559),
    [anon_sym_PERCENT] = ACTIONS(557),
    [anon_sym_CARET] = ACTIONS(557),
    [anon_sym_PIPE_PIPE] = ACTIONS(557),
    [anon_sym_BANG_EQ] = ACTIONS(557),
    [anon_sym_LT_GT] = ACTIONS(557),
    [anon_sym_DASH_GT] = ACTIONS(559),
    [anon_sym_DASH_GT_GT] = ACTIONS(557),
    [anon_sym_POUND_GT] = ACTIONS(559),
    [anon_sym_POUND_GT_GT] = ACTIONS(557),
    [anon_sym_DQUOTE] = ACTIONS(557),
    [anon_sym_BQUOTE] = ACTIONS(557),
  },
  [112] = {
    [sym_comment] = STATE(112),
    [sym_marginalia] = STATE(112),
    [ts_builtin_sym_end] = ACTIONS(748),
    [sym__identifier] = ACTIONS(750),
    [anon_sym_SEMI] = ACTIONS(748),
    [sym_keyword_set] = ACTIONS(750),
    [sym_keyword_from] = ACTIONS(750),
    [sym_keyword_left] = ACTIONS(750),
    [sym_keyword_right] = ACTIONS(750),
    [sym_keyword_inner] = ACTIONS(750),
    [sym_keyword_full] = ACTIONS(750),
    [sym_keyword_join] = ACTIONS(750),
    [sym_keyword_natural] = ACTIONS(750),
    [sym_keyword_on] = ACTIONS(750),
    [sym_keyword_where] = ACTIONS(750),
    [sym_keyword_create] = ACTIONS(750),
    [sym_keyword_increment] = ACTIONS(750),
    [sym_keyword_minvalue] = ACTIONS(750),
    [sym_keyword_maxvalue] = ACTIONS(750),
    [sym_keyword_owned] = ACTIONS(750),
    [sym_keyword_start] = ACTIONS(750),
    [sym_keyword_restart] = ACTIONS(750),
    [sym_keyword_as] = ACTIONS(750),
    [sym_keyword_when] = ACTIONS(750),
    [sym_keyword_then] = ACTIONS(750),
    [sym_keyword_else] = ACTIONS(750),
    [sym_keyword_end] = ACTIONS(750),
    [sym_keyword_in] = ACTIONS(750),
    [sym_keyword_and] = ACTIONS(750),
    [sym_keyword_or] = ACTIONS(750),
    [sym_keyword_is] = ACTIONS(750),
    [sym_keyword_not] = ACTIONS(750),
    [sym_keyword_using] = ACTIONS(750),
    [sym_keyword_collate] = ACTIONS(750),
    [sym_keyword_cascade] = ACTIONS(750),
    [sym_keyword_restrict] = ACTIONS(750),
    [aux_sym_keyword_with_token1] = ACTIONS(750),
    [sym_keyword_no] = ACTIONS(750),
    [sym_keyword_cycle] = ACTIONS(750),
    [sym_keyword_union] = ACTIONS(750),
    [sym_keyword_except] = ACTIONS(750),
    [sym_keyword_intersect] = ACTIONS(750),
    [sym_keyword_returning] = ACTIONS(750),
    [sym_keyword_between] = ACTIONS(750),
    [sym_keyword_preceding] = ACTIONS(750),
    [sym_keyword_following] = ACTIONS(750),
    [aux_sym_keyword_like_token1] = ACTIONS(750),
    [aux_sym_keyword_like_token2] = ACTIONS(750),
    [sym_keyword_similar] = ACTIONS(750),
    [sym_keyword_cache] = ACTIONS(750),
    [sym_keyword_array] = ACTIONS(750),
    [anon_sym_LBRACK] = ACTIONS(748),
    [anon_sym_RBRACK] = ACTIONS(748),
    [anon_sym_RPAREN] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(748),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(750),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(748),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(748),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(748),
    [anon_sym_COLON_EQ] = ACTIONS(748),
    [anon_sym_EQ] = ACTIONS(748),
    [anon_sym_STAR] = ACTIONS(748),
    [anon_sym_COLON_COLON] = ACTIONS(748),
    [anon_sym_LT] = ACTIONS(750),
    [anon_sym_GT] = ACTIONS(750),
    [anon_sym_LT_EQ] = ACTIONS(748),
    [anon_sym_GT_EQ] = ACTIONS(748),
    [anon_sym_PLUS] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(750),
    [anon_sym_PERCENT] = ACTIONS(748),
    [anon_sym_CARET] = ACTIONS(748),
    [anon_sym_PIPE_PIPE] = ACTIONS(748),
    [anon_sym_BANG_EQ] = ACTIONS(748),
    [anon_sym_LT_GT] = ACTIONS(748),
    [anon_sym_DASH_GT] = ACTIONS(750),
    [anon_sym_DASH_GT_GT] = ACTIONS(748),
    [anon_sym_POUND_GT] = ACTIONS(750),
    [anon_sym_POUND_GT_GT] = ACTIONS(748),
    [anon_sym_DQUOTE] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(748),
  },
  [113] = {
    [sym_comment] = STATE(113),
    [sym_marginalia] = STATE(113),
    [ts_builtin_sym_end] = ACTIONS(752),
    [sym__identifier] = ACTIONS(754),
    [anon_sym_SEMI] = ACTIONS(752),
    [sym_keyword_set] = ACTIONS(754),
    [sym_keyword_from] = ACTIONS(754),
    [sym_keyword_left] = ACTIONS(754),
    [sym_keyword_right] = ACTIONS(754),
    [sym_keyword_inner] = ACTIONS(754),
    [sym_keyword_full] = ACTIONS(754),
    [sym_keyword_join] = ACTIONS(754),
    [sym_keyword_natural] = ACTIONS(754),
    [sym_keyword_on] = ACTIONS(754),
    [sym_keyword_where] = ACTIONS(754),
    [sym_keyword_create] = ACTIONS(754),
    [sym_keyword_increment] = ACTIONS(754),
    [sym_keyword_minvalue] = ACTIONS(754),
    [sym_keyword_maxvalue] = ACTIONS(754),
    [sym_keyword_owned] = ACTIONS(754),
    [sym_keyword_start] = ACTIONS(754),
    [sym_keyword_restart] = ACTIONS(754),
    [sym_keyword_as] = ACTIONS(754),
    [sym_keyword_when] = ACTIONS(754),
    [sym_keyword_then] = ACTIONS(754),
    [sym_keyword_else] = ACTIONS(754),
    [sym_keyword_end] = ACTIONS(754),
    [sym_keyword_in] = ACTIONS(754),
    [sym_keyword_and] = ACTIONS(754),
    [sym_keyword_or] = ACTIONS(754),
    [sym_keyword_is] = ACTIONS(754),
    [sym_keyword_not] = ACTIONS(754),
    [sym_keyword_using] = ACTIONS(754),
    [sym_keyword_collate] = ACTIONS(754),
    [sym_keyword_cascade] = ACTIONS(754),
    [sym_keyword_restrict] = ACTIONS(754),
    [aux_sym_keyword_with_token1] = ACTIONS(754),
    [sym_keyword_no] = ACTIONS(754),
    [sym_keyword_cycle] = ACTIONS(754),
    [sym_keyword_union] = ACTIONS(754),
    [sym_keyword_except] = ACTIONS(754),
    [sym_keyword_intersect] = ACTIONS(754),
    [sym_keyword_returning] = ACTIONS(754),
    [sym_keyword_between] = ACTIONS(754),
    [sym_keyword_preceding] = ACTIONS(754),
    [sym_keyword_following] = ACTIONS(754),
    [aux_sym_keyword_like_token1] = ACTIONS(754),
    [aux_sym_keyword_like_token2] = ACTIONS(754),
    [sym_keyword_similar] = ACTIONS(754),
    [sym_keyword_cache] = ACTIONS(754),
    [sym_keyword_array] = ACTIONS(754),
    [anon_sym_LBRACK] = ACTIONS(752),
    [anon_sym_RBRACK] = ACTIONS(752),
    [anon_sym_RPAREN] = ACTIONS(752),
    [anon_sym_COMMA] = ACTIONS(752),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(754),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(752),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(752),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(752),
    [anon_sym_COLON_EQ] = ACTIONS(752),
    [anon_sym_EQ] = ACTIONS(752),
    [anon_sym_STAR] = ACTIONS(752),
    [anon_sym_COLON_COLON] = ACTIONS(752),
    [anon_sym_LT] = ACTIONS(754),
    [anon_sym_GT] = ACTIONS(754),
    [anon_sym_LT_EQ] = ACTIONS(752),
    [anon_sym_GT_EQ] = ACTIONS(752),
    [anon_sym_PLUS] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(754),
    [anon_sym_PERCENT] = ACTIONS(752),
    [anon_sym_CARET] = ACTIONS(752),
    [anon_sym_PIPE_PIPE] = ACTIONS(752),
    [anon_sym_BANG_EQ] = ACTIONS(752),
    [anon_sym_LT_GT] = ACTIONS(752),
    [anon_sym_DASH_GT] = ACTIONS(754),
    [anon_sym_DASH_GT_GT] = ACTIONS(752),
    [anon_sym_POUND_GT] = ACTIONS(754),
    [anon_sym_POUND_GT_GT] = ACTIONS(752),
    [anon_sym_DQUOTE] = ACTIONS(752),
    [anon_sym_BQUOTE] = ACTIONS(752),
  },
  [114] = {
    [sym_comment] = STATE(114),
    [sym_marginalia] = STATE(114),
    [ts_builtin_sym_end] = ACTIONS(756),
    [sym__identifier] = ACTIONS(758),
    [anon_sym_SEMI] = ACTIONS(756),
    [sym_keyword_set] = ACTIONS(758),
    [sym_keyword_from] = ACTIONS(758),
    [sym_keyword_left] = ACTIONS(758),
    [sym_keyword_right] = ACTIONS(758),
    [sym_keyword_inner] = ACTIONS(758),
    [sym_keyword_full] = ACTIONS(758),
    [sym_keyword_join] = ACTIONS(758),
    [sym_keyword_natural] = ACTIONS(758),
    [sym_keyword_on] = ACTIONS(758),
    [sym_keyword_where] = ACTIONS(758),
    [sym_keyword_create] = ACTIONS(758),
    [sym_keyword_increment] = ACTIONS(758),
    [sym_keyword_minvalue] = ACTIONS(758),
    [sym_keyword_maxvalue] = ACTIONS(758),
    [sym_keyword_owned] = ACTIONS(758),
    [sym_keyword_start] = ACTIONS(758),
    [sym_keyword_restart] = ACTIONS(758),
    [sym_keyword_as] = ACTIONS(758),
    [sym_keyword_when] = ACTIONS(758),
    [sym_keyword_then] = ACTIONS(758),
    [sym_keyword_else] = ACTIONS(758),
    [sym_keyword_end] = ACTIONS(758),
    [sym_keyword_in] = ACTIONS(758),
    [sym_keyword_and] = ACTIONS(758),
    [sym_keyword_or] = ACTIONS(758),
    [sym_keyword_is] = ACTIONS(758),
    [sym_keyword_not] = ACTIONS(758),
    [sym_keyword_using] = ACTIONS(758),
    [sym_keyword_collate] = ACTIONS(758),
    [sym_keyword_cascade] = ACTIONS(758),
    [sym_keyword_restrict] = ACTIONS(758),
    [aux_sym_keyword_with_token1] = ACTIONS(758),
    [sym_keyword_no] = ACTIONS(758),
    [sym_keyword_cycle] = ACTIONS(758),
    [sym_keyword_union] = ACTIONS(758),
    [sym_keyword_except] = ACTIONS(758),
    [sym_keyword_intersect] = ACTIONS(758),
    [sym_keyword_returning] = ACTIONS(758),
    [sym_keyword_between] = ACTIONS(758),
    [sym_keyword_preceding] = ACTIONS(758),
    [sym_keyword_following] = ACTIONS(758),
    [aux_sym_keyword_like_token1] = ACTIONS(758),
    [aux_sym_keyword_like_token2] = ACTIONS(758),
    [sym_keyword_similar] = ACTIONS(758),
    [sym_keyword_cache] = ACTIONS(758),
    [sym_keyword_array] = ACTIONS(758),
    [anon_sym_LBRACK] = ACTIONS(756),
    [anon_sym_RBRACK] = ACTIONS(756),
    [anon_sym_RPAREN] = ACTIONS(756),
    [anon_sym_COMMA] = ACTIONS(756),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(758),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(756),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(756),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(756),
    [anon_sym_COLON_EQ] = ACTIONS(756),
    [anon_sym_EQ] = ACTIONS(756),
    [anon_sym_STAR] = ACTIONS(756),
    [anon_sym_COLON_COLON] = ACTIONS(756),
    [anon_sym_LT] = ACTIONS(758),
    [anon_sym_GT] = ACTIONS(758),
    [anon_sym_LT_EQ] = ACTIONS(756),
    [anon_sym_GT_EQ] = ACTIONS(756),
    [anon_sym_PLUS] = ACTIONS(756),
    [anon_sym_DASH] = ACTIONS(758),
    [anon_sym_PERCENT] = ACTIONS(756),
    [anon_sym_CARET] = ACTIONS(756),
    [anon_sym_PIPE_PIPE] = ACTIONS(756),
    [anon_sym_BANG_EQ] = ACTIONS(756),
    [anon_sym_LT_GT] = ACTIONS(756),
    [anon_sym_DASH_GT] = ACTIONS(758),
    [anon_sym_DASH_GT_GT] = ACTIONS(756),
    [anon_sym_POUND_GT] = ACTIONS(758),
    [anon_sym_POUND_GT_GT] = ACTIONS(756),
    [anon_sym_DQUOTE] = ACTIONS(756),
    [anon_sym_BQUOTE] = ACTIONS(756),
  },
  [115] = {
    [sym_comment] = STATE(115),
    [sym_marginalia] = STATE(115),
    [ts_builtin_sym_end] = ACTIONS(760),
    [sym__identifier] = ACTIONS(762),
    [anon_sym_SEMI] = ACTIONS(760),
    [sym_keyword_set] = ACTIONS(762),
    [sym_keyword_from] = ACTIONS(762),
    [sym_keyword_left] = ACTIONS(762),
    [sym_keyword_right] = ACTIONS(762),
    [sym_keyword_inner] = ACTIONS(762),
    [sym_keyword_full] = ACTIONS(762),
    [sym_keyword_join] = ACTIONS(762),
    [sym_keyword_natural] = ACTIONS(762),
    [sym_keyword_on] = ACTIONS(762),
    [sym_keyword_where] = ACTIONS(762),
    [sym_keyword_create] = ACTIONS(762),
    [sym_keyword_increment] = ACTIONS(762),
    [sym_keyword_minvalue] = ACTIONS(762),
    [sym_keyword_maxvalue] = ACTIONS(762),
    [sym_keyword_owned] = ACTIONS(762),
    [sym_keyword_start] = ACTIONS(762),
    [sym_keyword_restart] = ACTIONS(762),
    [sym_keyword_as] = ACTIONS(762),
    [sym_keyword_when] = ACTIONS(762),
    [sym_keyword_then] = ACTIONS(762),
    [sym_keyword_else] = ACTIONS(762),
    [sym_keyword_end] = ACTIONS(762),
    [sym_keyword_in] = ACTIONS(762),
    [sym_keyword_and] = ACTIONS(762),
    [sym_keyword_or] = ACTIONS(762),
    [sym_keyword_is] = ACTIONS(762),
    [sym_keyword_not] = ACTIONS(762),
    [sym_keyword_using] = ACTIONS(762),
    [sym_keyword_collate] = ACTIONS(762),
    [sym_keyword_cascade] = ACTIONS(762),
    [sym_keyword_restrict] = ACTIONS(762),
    [aux_sym_keyword_with_token1] = ACTIONS(762),
    [sym_keyword_no] = ACTIONS(762),
    [sym_keyword_cycle] = ACTIONS(762),
    [sym_keyword_union] = ACTIONS(762),
    [sym_keyword_except] = ACTIONS(762),
    [sym_keyword_intersect] = ACTIONS(762),
    [sym_keyword_returning] = ACTIONS(762),
    [sym_keyword_between] = ACTIONS(762),
    [sym_keyword_preceding] = ACTIONS(762),
    [sym_keyword_following] = ACTIONS(762),
    [aux_sym_keyword_like_token1] = ACTIONS(762),
    [aux_sym_keyword_like_token2] = ACTIONS(762),
    [sym_keyword_similar] = ACTIONS(762),
    [sym_keyword_cache] = ACTIONS(762),
    [sym_keyword_array] = ACTIONS(762),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_RBRACK] = ACTIONS(760),
    [anon_sym_RPAREN] = ACTIONS(760),
    [anon_sym_COMMA] = ACTIONS(760),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(762),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(760),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(760),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(760),
    [anon_sym_COLON_EQ] = ACTIONS(760),
    [anon_sym_EQ] = ACTIONS(760),
    [anon_sym_STAR] = ACTIONS(760),
    [anon_sym_COLON_COLON] = ACTIONS(760),
    [anon_sym_LT] = ACTIONS(762),
    [anon_sym_GT] = ACTIONS(762),
    [anon_sym_LT_EQ] = ACTIONS(760),
    [anon_sym_GT_EQ] = ACTIONS(760),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(762),
    [anon_sym_PERCENT] = ACTIONS(760),
    [anon_sym_CARET] = ACTIONS(760),
    [anon_sym_PIPE_PIPE] = ACTIONS(760),
    [anon_sym_BANG_EQ] = ACTIONS(760),
    [anon_sym_LT_GT] = ACTIONS(760),
    [anon_sym_DASH_GT] = ACTIONS(762),
    [anon_sym_DASH_GT_GT] = ACTIONS(760),
    [anon_sym_POUND_GT] = ACTIONS(762),
    [anon_sym_POUND_GT_GT] = ACTIONS(760),
    [anon_sym_DQUOTE] = ACTIONS(760),
    [anon_sym_BQUOTE] = ACTIONS(760),
  },
  [116] = {
    [sym_comment] = STATE(116),
    [sym_marginalia] = STATE(116),
    [ts_builtin_sym_end] = ACTIONS(764),
    [sym__identifier] = ACTIONS(766),
    [anon_sym_SEMI] = ACTIONS(764),
    [sym_keyword_set] = ACTIONS(766),
    [sym_keyword_from] = ACTIONS(766),
    [sym_keyword_left] = ACTIONS(766),
    [sym_keyword_right] = ACTIONS(766),
    [sym_keyword_inner] = ACTIONS(766),
    [sym_keyword_full] = ACTIONS(766),
    [sym_keyword_join] = ACTIONS(766),
    [sym_keyword_natural] = ACTIONS(766),
    [sym_keyword_on] = ACTIONS(766),
    [sym_keyword_where] = ACTIONS(766),
    [sym_keyword_create] = ACTIONS(766),
    [sym_keyword_increment] = ACTIONS(766),
    [sym_keyword_minvalue] = ACTIONS(766),
    [sym_keyword_maxvalue] = ACTIONS(766),
    [sym_keyword_owned] = ACTIONS(766),
    [sym_keyword_start] = ACTIONS(766),
    [sym_keyword_restart] = ACTIONS(766),
    [sym_keyword_as] = ACTIONS(766),
    [sym_keyword_when] = ACTIONS(766),
    [sym_keyword_then] = ACTIONS(766),
    [sym_keyword_else] = ACTIONS(766),
    [sym_keyword_end] = ACTIONS(766),
    [sym_keyword_in] = ACTIONS(766),
    [sym_keyword_and] = ACTIONS(766),
    [sym_keyword_or] = ACTIONS(766),
    [sym_keyword_is] = ACTIONS(766),
    [sym_keyword_not] = ACTIONS(766),
    [sym_keyword_using] = ACTIONS(766),
    [sym_keyword_collate] = ACTIONS(766),
    [sym_keyword_cascade] = ACTIONS(766),
    [sym_keyword_restrict] = ACTIONS(766),
    [aux_sym_keyword_with_token1] = ACTIONS(766),
    [sym_keyword_no] = ACTIONS(766),
    [sym_keyword_cycle] = ACTIONS(766),
    [sym_keyword_union] = ACTIONS(766),
    [sym_keyword_except] = ACTIONS(766),
    [sym_keyword_intersect] = ACTIONS(766),
    [sym_keyword_returning] = ACTIONS(766),
    [sym_keyword_between] = ACTIONS(766),
    [sym_keyword_preceding] = ACTIONS(766),
    [sym_keyword_following] = ACTIONS(766),
    [aux_sym_keyword_like_token1] = ACTIONS(766),
    [aux_sym_keyword_like_token2] = ACTIONS(766),
    [sym_keyword_similar] = ACTIONS(766),
    [sym_keyword_cache] = ACTIONS(766),
    [sym_keyword_array] = ACTIONS(766),
    [anon_sym_LBRACK] = ACTIONS(764),
    [anon_sym_RBRACK] = ACTIONS(764),
    [anon_sym_RPAREN] = ACTIONS(764),
    [anon_sym_COMMA] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(766),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(764),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(764),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(764),
    [anon_sym_COLON_EQ] = ACTIONS(764),
    [anon_sym_EQ] = ACTIONS(764),
    [anon_sym_STAR] = ACTIONS(764),
    [anon_sym_COLON_COLON] = ACTIONS(764),
    [anon_sym_LT] = ACTIONS(766),
    [anon_sym_GT] = ACTIONS(766),
    [anon_sym_LT_EQ] = ACTIONS(764),
    [anon_sym_GT_EQ] = ACTIONS(764),
    [anon_sym_PLUS] = ACTIONS(764),
    [anon_sym_DASH] = ACTIONS(766),
    [anon_sym_PERCENT] = ACTIONS(764),
    [anon_sym_CARET] = ACTIONS(764),
    [anon_sym_PIPE_PIPE] = ACTIONS(764),
    [anon_sym_BANG_EQ] = ACTIONS(764),
    [anon_sym_LT_GT] = ACTIONS(764),
    [anon_sym_DASH_GT] = ACTIONS(766),
    [anon_sym_DASH_GT_GT] = ACTIONS(764),
    [anon_sym_POUND_GT] = ACTIONS(766),
    [anon_sym_POUND_GT_GT] = ACTIONS(764),
    [anon_sym_DQUOTE] = ACTIONS(764),
    [anon_sym_BQUOTE] = ACTIONS(764),
  },
  [117] = {
    [sym_comment] = STATE(117),
    [sym_marginalia] = STATE(117),
    [ts_builtin_sym_end] = ACTIONS(738),
    [sym__identifier] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(738),
    [sym_keyword_set] = ACTIONS(740),
    [sym_keyword_from] = ACTIONS(740),
    [sym_keyword_left] = ACTIONS(740),
    [sym_keyword_right] = ACTIONS(740),
    [sym_keyword_inner] = ACTIONS(740),
    [sym_keyword_full] = ACTIONS(740),
    [sym_keyword_join] = ACTIONS(740),
    [sym_keyword_natural] = ACTIONS(740),
    [sym_keyword_on] = ACTIONS(740),
    [sym_keyword_where] = ACTIONS(740),
    [sym_keyword_create] = ACTIONS(740),
    [sym_keyword_increment] = ACTIONS(740),
    [sym_keyword_minvalue] = ACTIONS(740),
    [sym_keyword_maxvalue] = ACTIONS(740),
    [sym_keyword_owned] = ACTIONS(740),
    [sym_keyword_start] = ACTIONS(740),
    [sym_keyword_restart] = ACTIONS(740),
    [sym_keyword_as] = ACTIONS(740),
    [sym_keyword_when] = ACTIONS(740),
    [sym_keyword_then] = ACTIONS(740),
    [sym_keyword_else] = ACTIONS(740),
    [sym_keyword_end] = ACTIONS(740),
    [sym_keyword_in] = ACTIONS(740),
    [sym_keyword_and] = ACTIONS(740),
    [sym_keyword_or] = ACTIONS(740),
    [sym_keyword_is] = ACTIONS(740),
    [sym_keyword_not] = ACTIONS(740),
    [sym_keyword_using] = ACTIONS(740),
    [sym_keyword_collate] = ACTIONS(740),
    [sym_keyword_cascade] = ACTIONS(740),
    [sym_keyword_restrict] = ACTIONS(740),
    [aux_sym_keyword_with_token1] = ACTIONS(740),
    [sym_keyword_no] = ACTIONS(740),
    [sym_keyword_cycle] = ACTIONS(740),
    [sym_keyword_union] = ACTIONS(740),
    [sym_keyword_except] = ACTIONS(740),
    [sym_keyword_intersect] = ACTIONS(740),
    [sym_keyword_returning] = ACTIONS(740),
    [sym_keyword_between] = ACTIONS(740),
    [sym_keyword_preceding] = ACTIONS(740),
    [sym_keyword_following] = ACTIONS(740),
    [aux_sym_keyword_like_token1] = ACTIONS(740),
    [aux_sym_keyword_like_token2] = ACTIONS(740),
    [sym_keyword_similar] = ACTIONS(740),
    [sym_keyword_cache] = ACTIONS(740),
    [sym_keyword_array] = ACTIONS(740),
    [anon_sym_LBRACK] = ACTIONS(738),
    [anon_sym_RBRACK] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(738),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(738),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(738),
    [anon_sym_COLON_EQ] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_COLON_COLON] = ACTIONS(738),
    [anon_sym_LT] = ACTIONS(740),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_LT_EQ] = ACTIONS(738),
    [anon_sym_GT_EQ] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym_PIPE_PIPE] = ACTIONS(738),
    [anon_sym_BANG_EQ] = ACTIONS(738),
    [anon_sym_LT_GT] = ACTIONS(738),
    [anon_sym_DASH_GT] = ACTIONS(740),
    [anon_sym_DASH_GT_GT] = ACTIONS(738),
    [anon_sym_POUND_GT] = ACTIONS(740),
    [anon_sym_POUND_GT_GT] = ACTIONS(738),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
  },
  [118] = {
    [sym_comment] = STATE(118),
    [sym_marginalia] = STATE(118),
    [ts_builtin_sym_end] = ACTIONS(768),
    [sym__identifier] = ACTIONS(770),
    [anon_sym_SEMI] = ACTIONS(768),
    [sym_keyword_set] = ACTIONS(770),
    [sym_keyword_from] = ACTIONS(770),
    [sym_keyword_left] = ACTIONS(770),
    [sym_keyword_right] = ACTIONS(770),
    [sym_keyword_inner] = ACTIONS(770),
    [sym_keyword_full] = ACTIONS(770),
    [sym_keyword_join] = ACTIONS(770),
    [sym_keyword_natural] = ACTIONS(770),
    [sym_keyword_on] = ACTIONS(770),
    [sym_keyword_where] = ACTIONS(770),
    [sym_keyword_create] = ACTIONS(770),
    [sym_keyword_increment] = ACTIONS(770),
    [sym_keyword_minvalue] = ACTIONS(770),
    [sym_keyword_maxvalue] = ACTIONS(770),
    [sym_keyword_owned] = ACTIONS(770),
    [sym_keyword_start] = ACTIONS(770),
    [sym_keyword_restart] = ACTIONS(770),
    [sym_keyword_as] = ACTIONS(770),
    [sym_keyword_when] = ACTIONS(770),
    [sym_keyword_then] = ACTIONS(770),
    [sym_keyword_else] = ACTIONS(770),
    [sym_keyword_end] = ACTIONS(770),
    [sym_keyword_in] = ACTIONS(770),
    [sym_keyword_and] = ACTIONS(770),
    [sym_keyword_or] = ACTIONS(770),
    [sym_keyword_is] = ACTIONS(770),
    [sym_keyword_not] = ACTIONS(770),
    [sym_keyword_using] = ACTIONS(770),
    [sym_keyword_collate] = ACTIONS(770),
    [sym_keyword_cascade] = ACTIONS(770),
    [sym_keyword_restrict] = ACTIONS(770),
    [aux_sym_keyword_with_token1] = ACTIONS(770),
    [sym_keyword_no] = ACTIONS(770),
    [sym_keyword_cycle] = ACTIONS(770),
    [sym_keyword_union] = ACTIONS(770),
    [sym_keyword_except] = ACTIONS(770),
    [sym_keyword_intersect] = ACTIONS(770),
    [sym_keyword_returning] = ACTIONS(770),
    [sym_keyword_between] = ACTIONS(770),
    [sym_keyword_preceding] = ACTIONS(770),
    [sym_keyword_following] = ACTIONS(770),
    [aux_sym_keyword_like_token1] = ACTIONS(770),
    [aux_sym_keyword_like_token2] = ACTIONS(770),
    [sym_keyword_similar] = ACTIONS(770),
    [sym_keyword_cache] = ACTIONS(770),
    [sym_keyword_array] = ACTIONS(770),
    [anon_sym_LBRACK] = ACTIONS(768),
    [anon_sym_RBRACK] = ACTIONS(768),
    [anon_sym_RPAREN] = ACTIONS(768),
    [anon_sym_COMMA] = ACTIONS(768),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(770),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(768),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(768),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(768),
    [anon_sym_COLON_EQ] = ACTIONS(768),
    [anon_sym_EQ] = ACTIONS(768),
    [anon_sym_STAR] = ACTIONS(768),
    [anon_sym_COLON_COLON] = ACTIONS(768),
    [anon_sym_LT] = ACTIONS(770),
    [anon_sym_GT] = ACTIONS(770),
    [anon_sym_LT_EQ] = ACTIONS(768),
    [anon_sym_GT_EQ] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_DASH] = ACTIONS(770),
    [anon_sym_PERCENT] = ACTIONS(768),
    [anon_sym_CARET] = ACTIONS(768),
    [anon_sym_PIPE_PIPE] = ACTIONS(768),
    [anon_sym_BANG_EQ] = ACTIONS(768),
    [anon_sym_LT_GT] = ACTIONS(768),
    [anon_sym_DASH_GT] = ACTIONS(770),
    [anon_sym_DASH_GT_GT] = ACTIONS(768),
    [anon_sym_POUND_GT] = ACTIONS(770),
    [anon_sym_POUND_GT_GT] = ACTIONS(768),
    [anon_sym_DQUOTE] = ACTIONS(768),
    [anon_sym_BQUOTE] = ACTIONS(768),
  },
  [119] = {
    [sym_comment] = STATE(119),
    [sym_marginalia] = STATE(119),
    [ts_builtin_sym_end] = ACTIONS(772),
    [sym__identifier] = ACTIONS(774),
    [anon_sym_SEMI] = ACTIONS(772),
    [sym_keyword_set] = ACTIONS(774),
    [sym_keyword_from] = ACTIONS(774),
    [sym_keyword_left] = ACTIONS(774),
    [sym_keyword_right] = ACTIONS(774),
    [sym_keyword_inner] = ACTIONS(774),
    [sym_keyword_full] = ACTIONS(774),
    [sym_keyword_join] = ACTIONS(774),
    [sym_keyword_natural] = ACTIONS(774),
    [sym_keyword_on] = ACTIONS(774),
    [sym_keyword_where] = ACTIONS(774),
    [sym_keyword_create] = ACTIONS(774),
    [sym_keyword_increment] = ACTIONS(774),
    [sym_keyword_minvalue] = ACTIONS(774),
    [sym_keyword_maxvalue] = ACTIONS(774),
    [sym_keyword_owned] = ACTIONS(774),
    [sym_keyword_start] = ACTIONS(774),
    [sym_keyword_restart] = ACTIONS(774),
    [sym_keyword_as] = ACTIONS(774),
    [sym_keyword_when] = ACTIONS(774),
    [sym_keyword_then] = ACTIONS(774),
    [sym_keyword_else] = ACTIONS(774),
    [sym_keyword_end] = ACTIONS(774),
    [sym_keyword_in] = ACTIONS(774),
    [sym_keyword_and] = ACTIONS(774),
    [sym_keyword_or] = ACTIONS(774),
    [sym_keyword_is] = ACTIONS(774),
    [sym_keyword_not] = ACTIONS(774),
    [sym_keyword_using] = ACTIONS(774),
    [sym_keyword_collate] = ACTIONS(774),
    [sym_keyword_cascade] = ACTIONS(774),
    [sym_keyword_restrict] = ACTIONS(774),
    [aux_sym_keyword_with_token1] = ACTIONS(774),
    [sym_keyword_no] = ACTIONS(774),
    [sym_keyword_cycle] = ACTIONS(774),
    [sym_keyword_union] = ACTIONS(774),
    [sym_keyword_except] = ACTIONS(774),
    [sym_keyword_intersect] = ACTIONS(774),
    [sym_keyword_returning] = ACTIONS(774),
    [sym_keyword_between] = ACTIONS(774),
    [sym_keyword_preceding] = ACTIONS(774),
    [sym_keyword_following] = ACTIONS(774),
    [aux_sym_keyword_like_token1] = ACTIONS(774),
    [aux_sym_keyword_like_token2] = ACTIONS(774),
    [sym_keyword_similar] = ACTIONS(774),
    [sym_keyword_cache] = ACTIONS(774),
    [sym_keyword_array] = ACTIONS(774),
    [anon_sym_LBRACK] = ACTIONS(772),
    [anon_sym_RBRACK] = ACTIONS(772),
    [anon_sym_RPAREN] = ACTIONS(772),
    [anon_sym_COMMA] = ACTIONS(772),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(774),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(772),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(772),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(772),
    [anon_sym_COLON_EQ] = ACTIONS(772),
    [anon_sym_EQ] = ACTIONS(772),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_COLON_COLON] = ACTIONS(772),
    [anon_sym_LT] = ACTIONS(774),
    [anon_sym_GT] = ACTIONS(774),
    [anon_sym_LT_EQ] = ACTIONS(772),
    [anon_sym_GT_EQ] = ACTIONS(772),
    [anon_sym_PLUS] = ACTIONS(772),
    [anon_sym_DASH] = ACTIONS(774),
    [anon_sym_PERCENT] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(772),
    [anon_sym_PIPE_PIPE] = ACTIONS(772),
    [anon_sym_BANG_EQ] = ACTIONS(772),
    [anon_sym_LT_GT] = ACTIONS(772),
    [anon_sym_DASH_GT] = ACTIONS(774),
    [anon_sym_DASH_GT_GT] = ACTIONS(772),
    [anon_sym_POUND_GT] = ACTIONS(774),
    [anon_sym_POUND_GT_GT] = ACTIONS(772),
    [anon_sym_DQUOTE] = ACTIONS(772),
    [anon_sym_BQUOTE] = ACTIONS(772),
  },
  [120] = {
    [sym_comment] = STATE(120),
    [sym_marginalia] = STATE(120),
    [ts_builtin_sym_end] = ACTIONS(776),
    [sym__identifier] = ACTIONS(778),
    [anon_sym_SEMI] = ACTIONS(776),
    [sym_keyword_set] = ACTIONS(778),
    [sym_keyword_from] = ACTIONS(778),
    [sym_keyword_left] = ACTIONS(778),
    [sym_keyword_right] = ACTIONS(778),
    [sym_keyword_inner] = ACTIONS(778),
    [sym_keyword_full] = ACTIONS(778),
    [sym_keyword_join] = ACTIONS(778),
    [sym_keyword_natural] = ACTIONS(778),
    [sym_keyword_on] = ACTIONS(778),
    [sym_keyword_where] = ACTIONS(778),
    [sym_keyword_create] = ACTIONS(778),
    [sym_keyword_increment] = ACTIONS(778),
    [sym_keyword_minvalue] = ACTIONS(778),
    [sym_keyword_maxvalue] = ACTIONS(778),
    [sym_keyword_owned] = ACTIONS(778),
    [sym_keyword_start] = ACTIONS(778),
    [sym_keyword_restart] = ACTIONS(778),
    [sym_keyword_as] = ACTIONS(778),
    [sym_keyword_when] = ACTIONS(778),
    [sym_keyword_then] = ACTIONS(778),
    [sym_keyword_else] = ACTIONS(778),
    [sym_keyword_end] = ACTIONS(778),
    [sym_keyword_in] = ACTIONS(778),
    [sym_keyword_and] = ACTIONS(778),
    [sym_keyword_or] = ACTIONS(778),
    [sym_keyword_is] = ACTIONS(778),
    [sym_keyword_not] = ACTIONS(778),
    [sym_keyword_using] = ACTIONS(778),
    [sym_keyword_collate] = ACTIONS(778),
    [sym_keyword_cascade] = ACTIONS(778),
    [sym_keyword_restrict] = ACTIONS(778),
    [aux_sym_keyword_with_token1] = ACTIONS(778),
    [sym_keyword_no] = ACTIONS(778),
    [sym_keyword_cycle] = ACTIONS(778),
    [sym_keyword_union] = ACTIONS(778),
    [sym_keyword_except] = ACTIONS(778),
    [sym_keyword_intersect] = ACTIONS(778),
    [sym_keyword_returning] = ACTIONS(778),
    [sym_keyword_between] = ACTIONS(778),
    [sym_keyword_preceding] = ACTIONS(778),
    [sym_keyword_following] = ACTIONS(778),
    [aux_sym_keyword_like_token1] = ACTIONS(778),
    [aux_sym_keyword_like_token2] = ACTIONS(778),
    [sym_keyword_similar] = ACTIONS(778),
    [sym_keyword_cache] = ACTIONS(778),
    [sym_keyword_array] = ACTIONS(778),
    [anon_sym_LBRACK] = ACTIONS(776),
    [anon_sym_RBRACK] = ACTIONS(776),
    [anon_sym_RPAREN] = ACTIONS(776),
    [anon_sym_COMMA] = ACTIONS(776),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(778),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(776),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(776),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(776),
    [anon_sym_COLON_EQ] = ACTIONS(776),
    [anon_sym_EQ] = ACTIONS(776),
    [anon_sym_STAR] = ACTIONS(776),
    [anon_sym_COLON_COLON] = ACTIONS(776),
    [anon_sym_LT] = ACTIONS(778),
    [anon_sym_GT] = ACTIONS(778),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_DASH] = ACTIONS(778),
    [anon_sym_PERCENT] = ACTIONS(776),
    [anon_sym_CARET] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_LT_GT] = ACTIONS(776),
    [anon_sym_DASH_GT] = ACTIONS(778),
    [anon_sym_DASH_GT_GT] = ACTIONS(776),
    [anon_sym_POUND_GT] = ACTIONS(778),
    [anon_sym_POUND_GT_GT] = ACTIONS(776),
    [anon_sym_DQUOTE] = ACTIONS(776),
    [anon_sym_BQUOTE] = ACTIONS(776),
  },
  [121] = {
    [sym_comment] = STATE(121),
    [sym_marginalia] = STATE(121),
    [ts_builtin_sym_end] = ACTIONS(780),
    [sym__identifier] = ACTIONS(782),
    [anon_sym_SEMI] = ACTIONS(780),
    [sym_keyword_set] = ACTIONS(782),
    [sym_keyword_from] = ACTIONS(782),
    [sym_keyword_left] = ACTIONS(782),
    [sym_keyword_right] = ACTIONS(782),
    [sym_keyword_inner] = ACTIONS(782),
    [sym_keyword_full] = ACTIONS(782),
    [sym_keyword_join] = ACTIONS(782),
    [sym_keyword_natural] = ACTIONS(782),
    [sym_keyword_on] = ACTIONS(782),
    [sym_keyword_where] = ACTIONS(782),
    [sym_keyword_create] = ACTIONS(782),
    [sym_keyword_increment] = ACTIONS(782),
    [sym_keyword_minvalue] = ACTIONS(782),
    [sym_keyword_maxvalue] = ACTIONS(782),
    [sym_keyword_owned] = ACTIONS(782),
    [sym_keyword_start] = ACTIONS(782),
    [sym_keyword_restart] = ACTIONS(782),
    [sym_keyword_as] = ACTIONS(782),
    [sym_keyword_when] = ACTIONS(782),
    [sym_keyword_then] = ACTIONS(782),
    [sym_keyword_else] = ACTIONS(782),
    [sym_keyword_end] = ACTIONS(782),
    [sym_keyword_in] = ACTIONS(782),
    [sym_keyword_and] = ACTIONS(782),
    [sym_keyword_or] = ACTIONS(782),
    [sym_keyword_is] = ACTIONS(782),
    [sym_keyword_not] = ACTIONS(782),
    [sym_keyword_using] = ACTIONS(782),
    [sym_keyword_collate] = ACTIONS(782),
    [sym_keyword_cascade] = ACTIONS(782),
    [sym_keyword_restrict] = ACTIONS(782),
    [aux_sym_keyword_with_token1] = ACTIONS(782),
    [sym_keyword_no] = ACTIONS(782),
    [sym_keyword_cycle] = ACTIONS(782),
    [sym_keyword_union] = ACTIONS(782),
    [sym_keyword_except] = ACTIONS(782),
    [sym_keyword_intersect] = ACTIONS(782),
    [sym_keyword_returning] = ACTIONS(782),
    [sym_keyword_between] = ACTIONS(782),
    [sym_keyword_preceding] = ACTIONS(782),
    [sym_keyword_following] = ACTIONS(782),
    [aux_sym_keyword_like_token1] = ACTIONS(782),
    [aux_sym_keyword_like_token2] = ACTIONS(782),
    [sym_keyword_similar] = ACTIONS(782),
    [sym_keyword_cache] = ACTIONS(782),
    [sym_keyword_array] = ACTIONS(782),
    [anon_sym_LBRACK] = ACTIONS(780),
    [anon_sym_RBRACK] = ACTIONS(780),
    [anon_sym_RPAREN] = ACTIONS(780),
    [anon_sym_COMMA] = ACTIONS(780),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(782),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(780),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(780),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(780),
    [anon_sym_COLON_EQ] = ACTIONS(780),
    [anon_sym_EQ] = ACTIONS(780),
    [anon_sym_STAR] = ACTIONS(780),
    [anon_sym_COLON_COLON] = ACTIONS(780),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_GT] = ACTIONS(782),
    [anon_sym_LT_EQ] = ACTIONS(780),
    [anon_sym_GT_EQ] = ACTIONS(780),
    [anon_sym_PLUS] = ACTIONS(780),
    [anon_sym_DASH] = ACTIONS(782),
    [anon_sym_PERCENT] = ACTIONS(780),
    [anon_sym_CARET] = ACTIONS(780),
    [anon_sym_PIPE_PIPE] = ACTIONS(780),
    [anon_sym_BANG_EQ] = ACTIONS(780),
    [anon_sym_LT_GT] = ACTIONS(780),
    [anon_sym_DASH_GT] = ACTIONS(782),
    [anon_sym_DASH_GT_GT] = ACTIONS(780),
    [anon_sym_POUND_GT] = ACTIONS(782),
    [anon_sym_POUND_GT_GT] = ACTIONS(780),
    [anon_sym_DQUOTE] = ACTIONS(780),
    [anon_sym_BQUOTE] = ACTIONS(780),
  },
  [122] = {
    [sym_comment] = STATE(122),
    [sym_marginalia] = STATE(122),
    [ts_builtin_sym_end] = ACTIONS(784),
    [sym__identifier] = ACTIONS(786),
    [anon_sym_SEMI] = ACTIONS(784),
    [sym_keyword_set] = ACTIONS(786),
    [sym_keyword_from] = ACTIONS(786),
    [sym_keyword_left] = ACTIONS(786),
    [sym_keyword_right] = ACTIONS(786),
    [sym_keyword_inner] = ACTIONS(786),
    [sym_keyword_full] = ACTIONS(786),
    [sym_keyword_join] = ACTIONS(786),
    [sym_keyword_natural] = ACTIONS(786),
    [sym_keyword_on] = ACTIONS(786),
    [sym_keyword_where] = ACTIONS(786),
    [sym_keyword_create] = ACTIONS(786),
    [sym_keyword_increment] = ACTIONS(786),
    [sym_keyword_minvalue] = ACTIONS(786),
    [sym_keyword_maxvalue] = ACTIONS(786),
    [sym_keyword_owned] = ACTIONS(786),
    [sym_keyword_start] = ACTIONS(786),
    [sym_keyword_restart] = ACTIONS(786),
    [sym_keyword_as] = ACTIONS(786),
    [sym_keyword_when] = ACTIONS(786),
    [sym_keyword_then] = ACTIONS(786),
    [sym_keyword_else] = ACTIONS(786),
    [sym_keyword_end] = ACTIONS(786),
    [sym_keyword_in] = ACTIONS(786),
    [sym_keyword_and] = ACTIONS(786),
    [sym_keyword_or] = ACTIONS(786),
    [sym_keyword_is] = ACTIONS(786),
    [sym_keyword_not] = ACTIONS(786),
    [sym_keyword_using] = ACTIONS(786),
    [sym_keyword_collate] = ACTIONS(786),
    [sym_keyword_cascade] = ACTIONS(786),
    [sym_keyword_restrict] = ACTIONS(786),
    [aux_sym_keyword_with_token1] = ACTIONS(786),
    [sym_keyword_no] = ACTIONS(786),
    [sym_keyword_cycle] = ACTIONS(786),
    [sym_keyword_union] = ACTIONS(786),
    [sym_keyword_except] = ACTIONS(786),
    [sym_keyword_intersect] = ACTIONS(786),
    [sym_keyword_returning] = ACTIONS(786),
    [sym_keyword_between] = ACTIONS(786),
    [sym_keyword_preceding] = ACTIONS(786),
    [sym_keyword_following] = ACTIONS(786),
    [aux_sym_keyword_like_token1] = ACTIONS(786),
    [aux_sym_keyword_like_token2] = ACTIONS(786),
    [sym_keyword_similar] = ACTIONS(786),
    [sym_keyword_cache] = ACTIONS(786),
    [sym_keyword_array] = ACTIONS(786),
    [anon_sym_LBRACK] = ACTIONS(784),
    [anon_sym_RBRACK] = ACTIONS(784),
    [anon_sym_RPAREN] = ACTIONS(784),
    [anon_sym_COMMA] = ACTIONS(784),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(786),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(784),
    [anon_sym_DOLLARfunction_DOLLAR] = ACTIONS(784),
    [anon_sym_DOLLARbody_DOLLAR] = ACTIONS(784),
    [anon_sym_COLON_EQ] = ACTIONS(784),
    [anon_sym_EQ] = ACTIONS(784),
    [anon_sym_STAR] = ACTIONS(784),
    [anon_sym_COLON_COLON] = ACTIONS(784),
    [anon_sym_LT] = ACTIONS(786),
    [anon_sym_GT] = ACTIONS(786),
    [anon_sym_LT_EQ] = ACTIONS(784),
    [anon_sym_GT_EQ] = ACTIONS(784),
    [anon_sym_PLUS] = ACTIONS(784),
    [anon_sym_DASH] = ACTIONS(786),
    [anon_sym_PERCENT] = ACTIONS(784),
    [anon_sym_CARET] = ACTIONS(784),
    [anon_sym_PIPE_PIPE] = ACTIONS(784),
    [anon_sym_BANG_EQ] = ACTIONS(784),
    [anon_sym_LT_GT] = ACTIONS(784),
    [anon_sym_DASH_GT] = ACTIONS(786),
    [anon_sym_DASH_GT_GT] = ACTIONS(784),
    [anon_sym_POUND_GT] = ACTIONS(786),
    [anon_sym_POUND_GT_GT] = ACTIONS(784),
    [anon_sym_DQUOTE] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(784),
  },
  [123] = {
    [sym_comment] = STATE(123),
    [sym_marginalia] = STATE(123),
    [ts_builtin_sym_end] = ACTIONS(788),
    [sym__identifier] = ACTIONS(790),
    [anon_sym_SEMI] = ACTIONS(788),
    [sym_keyword_set] = ACTIONS(790),
    [sym_keyword_from] = ACTIONS(790),
    [sym_keyword_left] = ACTIONS(790),
    [sym_keyword_right] = ACTIONS(790),
    [sym_keyword_inner] = ACTIONS(790),
    [sym_keyword_full] = ACTIONS(790),
    [sym_keyword_join] = ACTIONS(790),
    [sym_keyword_nat