#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1160
#define LARGE_STATE_COUNT 166
#define SYMBOL_COUNT 148
#define ALIAS_COUNT 4
#define TOKEN_COUNT 67
#define EXTERNAL_TOKEN_COUNT 15
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 6

enum {
  sym__backslash_escape = 1,
  sym_entity_reference = 2,
  sym_numeric_character_reference = 3,
  anon_sym_LBRACK = 4,
  anon_sym_RBRACK = 5,
  anon_sym_LT = 6,
  anon_sym_GT = 7,
  anon_sym_BANG = 8,
  anon_sym_DQUOTE = 9,
  anon_sym_POUND = 10,
  anon_sym_DOLLAR = 11,
  anon_sym_PERCENT = 12,
  anon_sym_AMP = 13,
  anon_sym_SQUOTE = 14,
  anon_sym_STAR = 15,
  anon_sym_PLUS = 16,
  anon_sym_COMMA = 17,
  anon_sym_DASH = 18,
  anon_sym_DOT = 19,
  anon_sym_SLASH = 20,
  anon_sym_COLON = 21,
  anon_sym_SEMI = 22,
  anon_sym_EQ = 23,
  anon_sym_QMARK = 24,
  anon_sym_AT = 25,
  anon_sym_BSLASH = 26,
  anon_sym_CARET = 27,
  anon_sym__ = 28,
  anon_sym_BQUOTE = 29,
  anon_sym_LBRACE = 30,
  anon_sym_PIPE = 31,
  anon_sym_RBRACE = 32,
  anon_sym_TILDE = 33,
  anon_sym_LPAREN = 34,
  anon_sym_RPAREN = 35,
  sym__newline_token = 36,
  sym_uri_autolink = 37,
  sym_email_autolink = 38,
  sym__attribute_name = 39,
  aux_sym__attribute_value_token1 = 40,
  anon_sym_LT_BANG_DASH_DASH = 41,
  anon_sym_DASH_DASH_GT = 42,
  anon_sym_LT_QMARK = 43,
  anon_sym_QMARK_GT = 44,
  aux_sym__declaration_token1 = 45,
  anon_sym_LT_BANG_LBRACKCDATA_LBRACK = 46,
  anon_sym_RBRACK_RBRACK_GT = 47,
  sym__whitespace_ge_2 = 48,
  aux_sym__whitespace_token1 = 49,
  sym__word_no_digit = 50,
  sym__digits = 51,
  sym__error = 52,
  sym__trigger_error = 53,
  sym__code_span_start = 54,
  sym__code_span_close = 55,
  sym__emphasis_open_star = 56,
  sym__emphasis_open_underscore = 57,
  sym__emphasis_close_star = 58,
  sym__emphasis_close_underscore = 59,
  sym__last_token_whitespace = 60,
  sym__last_token_punctuation = 61,
  sym__strikethrough_open = 62,
  sym__strikethrough_close = 63,
  sym__latex_span_start = 64,
  sym__latex_span_close = 65,
  sym__unclosed_span = 66,
  sym_inline = 67,
  sym_backslash_escape = 68,
  sym_link_label = 69,
  sym_link_destination = 70,
  sym__link_destination_parenthesis = 71,
  sym__text_no_angle = 72,
  sym_link_title = 73,
  sym_code_span = 74,
  sym_latex_block = 75,
  sym__link_text = 76,
  sym__link_text_non_empty = 77,
  sym_shortcut_link = 78,
  sym_full_reference_link = 79,
  sym_collapsed_reference_link = 80,
  sym_inline_link = 81,
  sym_image = 82,
  sym__image_inline_link = 83,
  sym__image_shortcut_link = 84,
  sym__image_full_reference_link = 85,
  sym__image_collapsed_reference_link = 86,
  sym__image_description = 87,
  sym__image_description_non_empty = 88,
  sym__html_tag = 89,
  sym__open_tag = 90,
  sym__closing_tag = 91,
  sym__tag_name = 92,
  sym__attribute = 93,
  sym__attribute_value = 94,
  sym__html_comment = 95,
  sym__processing_instruction = 96,
  sym__declaration = 97,
  sym__cdata_section = 98,
  sym_hard_line_break = 99,
  sym__whitespace = 100,
  sym__word = 101,
  sym__soft_line_break = 102,
  sym__inline_base = 103,
  sym__text_base = 104,
  sym__text_inline_no_link = 105,
  sym__inline_element = 106,
  aux_sym__inline = 107,
  sym__inline_element_no_star = 108,
  aux_sym__inline_no_star = 109,
  sym__inline_element_no_underscore = 110,
  aux_sym__inline_no_underscore = 111,
  sym__inline_element_no_tilde = 112,
  aux_sym__inline_no_tilde = 113,
  sym__strikethrough = 114,
  sym__emphasis_star = 115,
  sym__strong_emphasis_star = 116,
  sym__emphasis_underscore = 117,
  sym__strong_emphasis_underscore = 118,
  sym__inline_element_no_link = 119,
  aux_sym__inline_no_link = 120,
  sym__inline_element_no_star_no_link = 121,
  aux_sym__inline_no_star_no_link = 122,
  sym__inline_element_no_underscore_no_link = 123,
  aux_sym__inline_no_underscore_no_link = 124,
  sym__inline_element_no_tilde_no_link = 125,
  aux_sym__inline_no_tilde_no_link = 126,
  sym__strikethrough_no_link = 127,
  sym__emphasis_star_no_link = 128,
  sym__strong_emphasis_star_no_link = 129,
  sym__emphasis_underscore_no_link = 130,
  sym__strong_emphasis_underscore_no_link = 131,
  aux_sym_link_label_repeat1 = 132,
  aux_sym_link_destination_repeat1 = 133,
  aux_sym_link_destination_repeat2 = 134,
  aux_sym_link_title_repeat1 = 135,
  aux_sym_link_title_repeat2 = 136,
  aux_sym_link_title_repeat3 = 137,
  aux_sym_code_span_repeat1 = 138,
  aux_sym_inline_link_repeat1 = 139,
  aux_sym__open_tag_repeat1 = 140,
  aux_sym__tag_name_repeat1 = 141,
  aux_sym__attribute_value_repeat1 = 142,
  aux_sym__attribute_value_repeat2 = 143,
  aux_sym__html_comment_repeat1 = 144,
  aux_sym__processing_instruction_repeat1 = 145,
  aux_sym__declaration_repeat1 = 146,
  aux_sym__inline_base_repeat1 = 147,
  alias_sym_emphasis = 148,
  alias_sym_html_tag = 149,
  alias_sym_image_description = 150,
  alias_sym_link_text = 151,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__backslash_escape] = "_backslash_escape",
  [sym_entity_reference] = "entity_reference",
  [sym_numeric_character_reference] = "numeric_character_reference",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_BANG] = "!",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_PERCENT] = "%",
  [anon_sym_AMP] = "&",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_STAR] = "*",
  [anon_sym_PLUS] = "+",
  [anon_sym_COMMA] = ",",
  [anon_sym_DASH] = "-",
  [anon_sym_DOT] = ".",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AT] = "@",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_CARET] = "^",
  [anon_sym__] = "_",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LBRACE] = "{",
  [anon_sym_PIPE] = "|",
  [anon_sym_RBRACE] = "}",
  [anon_sym_TILDE] = "~",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym__newline_token] = "_newline_token",
  [sym_uri_autolink] = "uri_autolink",
  [sym_email_autolink] = "email_autolink",
  [sym__attribute_name] = "_attribute_name",
  [aux_sym__attribute_value_token1] = "_attribute_value_token1",
  [anon_sym_LT_BANG_DASH_DASH] = "<!--",
  [anon_sym_DASH_DASH_GT] = "-->",
  [anon_sym_LT_QMARK] = "<\?",
  [anon_sym_QMARK_GT] = "\?>",
  [aux_sym__declaration_token1] = "_declaration_token1",
  [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = "<![CDATA[",
  [anon_sym_RBRACK_RBRACK_GT] = "]]>",
  [sym__whitespace_ge_2] = "_whitespace_ge_2",
  [aux_sym__whitespace_token1] = "_whitespace_token1",
  [sym__word_no_digit] = "_word_no_digit",
  [sym__digits] = "_digits",
  [sym__error] = "_error",
  [sym__trigger_error] = "_trigger_error",
  [sym__code_span_start] = "code_span_delimiter",
  [sym__code_span_close] = "code_span_delimiter",
  [sym__emphasis_open_star] = "_emphasis_open_star",
  [sym__emphasis_open_underscore] = "_emphasis_open_underscore",
  [sym__emphasis_close_star] = "emphasis_delimiter",
  [sym__emphasis_close_underscore] = "emphasis_delimiter",
  [sym__last_token_whitespace] = "_last_token_whitespace",
  [sym__last_token_punctuation] = "_last_token_punctuation",
  [sym__strikethrough_open] = "_strikethrough_open",
  [sym__strikethrough_close] = "emphasis_delimiter",
  [sym__latex_span_start] = "latex_span_delimiter",
  [sym__latex_span_close] = "latex_span_delimiter",
  [sym__unclosed_span] = "_unclosed_span",
  [sym_inline] = "inline",
  [sym_backslash_escape] = "backslash_escape",
  [sym_link_label] = "link_label",
  [sym_link_destination] = "link_destination",
  [sym__link_destination_parenthesis] = "_link_destination_parenthesis",
  [sym__text_no_angle] = "_text_no_angle",
  [sym_link_title] = "link_title",
  [sym_code_span] = "code_span",
  [sym_latex_block] = "latex_block",
  [sym__link_text] = "_link_text",
  [sym__link_text_non_empty] = "_link_text_non_empty",
  [sym_shortcut_link] = "shortcut_link",
  [sym_full_reference_link] = "full_reference_link",
  [sym_collapsed_reference_link] = "collapsed_reference_link",
  [sym_inline_link] = "inline_link",
  [sym_image] = "image",
  [sym__image_inline_link] = "_image_inline_link",
  [sym__image_shortcut_link] = "_image_shortcut_link",
  [sym__image_full_reference_link] = "_image_full_reference_link",
  [sym__image_collapsed_reference_link] = "_image_collapsed_reference_link",
  [sym__image_description] = "_image_description",
  [sym__image_description_non_empty] = "_image_description_non_empty",
  [sym__html_tag] = "_html_tag",
  [sym__open_tag] = "_open_tag",
  [sym__closing_tag] = "_closing_tag",
  [sym__tag_name] = "_tag_name",
  [sym__attribute] = "_attribute",
  [sym__attribute_value] = "_attribute_value",
  [sym__html_comment] = "_html_comment",
  [sym__processing_instruction] = "_processing_instruction",
  [sym__declaration] = "_declaration",
  [sym__cdata_section] = "_cdata_section",
  [sym_hard_line_break] = "hard_line_break",
  [sym__whitespace] = "_whitespace",
  [sym__word] = "_word",
  [sym__soft_line_break] = "_soft_line_break",
  [sym__inline_base] = "_inline_base",
  [sym__text_base] = "_text_base",
  [sym__text_inline_no_link] = "_text_inline_no_link",
  [sym__inline_element] = "_inline_element",
  [aux_sym__inline] = "_inline",
  [sym__inline_element_no_star] = "_inline_element_no_star",
  [aux_sym__inline_no_star] = "_inline_no_star",
  [sym__inline_element_no_underscore] = "_inline_element_no_underscore",
  [aux_sym__inline_no_underscore] = "_inline_no_underscore",
  [sym__inline_element_no_tilde] = "_inline_element_no_tilde",
  [aux_sym__inline_no_tilde] = "_inline_no_tilde",
  [sym__strikethrough] = "strikethrough",
  [sym__emphasis_star] = "_emphasis_star",
  [sym__strong_emphasis_star] = "strong_emphasis",
  [sym__emphasis_underscore] = "_emphasis_underscore",
  [sym__strong_emphasis_underscore] = "strong_emphasis",
  [sym__inline_element_no_link] = "_inline_element_no_link",
  [aux_sym__inline_no_link] = "_inline_no_link",
  [sym__inline_element_no_star_no_link] = "_inline_element_no_star_no_link",
  [aux_sym__inline_no_star_no_link] = "_inline_no_star_no_link",
  [sym__inline_element_no_underscore_no_link] = "_inline_element_no_underscore_no_link",
  [aux_sym__inline_no_underscore_no_link] = "_inline_no_underscore_no_link",
  [sym__inline_element_no_tilde_no_link] = "_inline_element_no_tilde_no_link",
  [aux_sym__inline_no_tilde_no_link] = "_inline_no_tilde_no_link",
  [sym__strikethrough_no_link] = "strikethrough",
  [sym__emphasis_star_no_link] = "_emphasis_star_no_link",
  [sym__strong_emphasis_star_no_link] = "strong_emphasis",
  [sym__emphasis_underscore_no_link] = "_emphasis_underscore_no_link",
  [sym__strong_emphasis_underscore_no_link] = "strong_emphasis",
  [aux_sym_link_label_repeat1] = "link_label_repeat1",
  [aux_sym_link_destination_repeat1] = "link_destination_repeat1",
  [aux_sym_link_destination_repeat2] = "link_destination_repeat2",
  [aux_sym_link_title_repeat1] = "link_title_repeat1",
  [aux_sym_link_title_repeat2] = "link_title_repeat2",
  [aux_sym_link_title_repeat3] = "link_title_repeat3",
  [aux_sym_code_span_repeat1] = "code_span_repeat1",
  [aux_sym_inline_link_repeat1] = "inline_link_repeat1",
  [aux_sym__open_tag_repeat1] = "_open_tag_repeat1",
  [aux_sym__tag_name_repeat1] = "_tag_name_repeat1",
  [aux_sym__attribute_value_repeat1] = "_attribute_value_repeat1",
  [aux_sym__attribute_value_repeat2] = "_attribute_value_repeat2",
  [aux_sym__html_comment_repeat1] = "_html_comment_repeat1",
  [aux_sym__processing_instruction_repeat1] = "_processing_instruction_repeat1",
  [aux_sym__declaration_repeat1] = "_declaration_repeat1",
  [aux_sym__inline_base_repeat1] = "_inline_base_repeat1",
  [alias_sym_emphasis] = "emphasis",
  [alias_sym_html_tag] = "html_tag",
  [alias_sym_image_description] = "image_description",
  [alias_sym_link_text] = "link_text",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__backslash_escape] = sym__backslash_escape,
  [sym_entity_reference] = sym_entity_reference,
  [sym_numeric_character_reference] = sym_numeric_character_reference,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym__] = anon_sym__,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym__newline_token] = sym__newline_token,
  [sym_uri_autolink] = sym_uri_autolink,
  [sym_email_autolink] = sym_email_autolink,
  [sym__attribute_name] = sym__attribute_name,
  [aux_sym__attribute_value_token1] = aux_sym__attribute_value_token1,
  [anon_sym_LT_BANG_DASH_DASH] = anon_sym_LT_BANG_DASH_DASH,
  [anon_sym_DASH_DASH_GT] = anon_sym_DASH_DASH_GT,
  [anon_sym_LT_QMARK] = anon_sym_LT_QMARK,
  [anon_sym_QMARK_GT] = anon_sym_QMARK_GT,
  [aux_sym__declaration_token1] = aux_sym__declaration_token1,
  [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
  [anon_sym_RBRACK_RBRACK_GT] = anon_sym_RBRACK_RBRACK_GT,
  [sym__whitespace_ge_2] = sym__whitespace_ge_2,
  [aux_sym__whitespace_token1] = aux_sym__whitespace_token1,
  [sym__word_no_digit] = sym__word_no_digit,
  [sym__digits] = sym__digits,
  [sym__error] = sym__error,
  [sym__trigger_error] = sym__trigger_error,
  [sym__code_span_start] = sym__code_span_start,
  [sym__code_span_close] = sym__code_span_start,
  [sym__emphasis_open_star] = sym__emphasis_open_star,
  [sym__emphasis_open_underscore] = sym__emphasis_open_underscore,
  [sym__emphasis_close_star] = sym__emphasis_close_star,
  [sym__emphasis_close_underscore] = sym__emphasis_close_star,
  [sym__last_token_whitespace] = sym__last_token_whitespace,
  [sym__last_token_punctuation] = sym__last_token_punctuation,
  [sym__strikethrough_open] = sym__strikethrough_open,
  [sym__strikethrough_close] = sym__emphasis_close_star,
  [sym__latex_span_start] = sym__latex_span_start,
  [sym__latex_span_close] = sym__latex_span_start,
  [sym__unclosed_span] = sym__unclosed_span,
  [sym_inline] = sym_inline,
  [sym_backslash_escape] = sym_backslash_escape,
  [sym_link_label] = sym_link_label,
  [sym_link_destination] = sym_link_destination,
  [sym__link_destination_parenthesis] = sym__link_destination_parenthesis,
  [sym__text_no_angle] = sym__text_no_angle,
  [sym_link_title] = sym_link_title,
  [sym_code_span] = sym_code_span,
  [sym_latex_block] = sym_latex_block,
  [sym__link_text] = sym__link_text,
  [sym__link_text_non_empty] = sym__link_text_non_empty,
  [sym_shortcut_link] = sym_shortcut_link,
  [sym_full_reference_link] = sym_full_reference_link,
  [sym_collapsed_reference_link] = sym_collapsed_reference_link,
  [sym_inline_link] = sym_inline_link,
  [sym_image] = sym_image,
  [sym__image_inline_link] = sym__image_inline_link,
  [sym__image_shortcut_link] = sym__image_shortcut_link,
  [sym__image_full_reference_link] = sym__image_full_reference_link,
  [sym__image_collapsed_reference_link] = sym__image_collapsed_reference_link,
  [sym__image_description] = sym__image_description,
  [sym__image_description_non_empty] = sym__image_description_non_empty,
  [sym__html_tag] = sym__html_tag,
  [sym__open_tag] = sym__open_tag,
  [sym__closing_tag] = sym__closing_tag,
  [sym__tag_name] = sym__tag_name,
  [sym__attribute] = sym__attribute,
  [sym__attribute_value] = sym__attribute_value,
  [sym__html_comment] = sym__html_comment,
  [sym__processing_instruction] = sym__processing_instruction,
  [sym__declaration] = sym__declaration,
  [sym__cdata_section] = sym__cdata_section,
  [sym_hard_line_break] = sym_hard_line_break,
  [sym__whitespace] = sym__whitespace,
  [sym__word] = sym__word,
  [sym__soft_line_break] = sym__soft_line_break,
  [sym__inline_base] = sym__inline_base,
  [sym__text_base] = sym__text_base,
  [sym__text_inline_no_link] = sym__text_inline_no_link,
  [sym__inline_element] = sym__inline_element,
  [aux_sym__inline] = aux_sym__inline,
  [sym__inline_element_no_star] = sym__inline_element_no_star,
  [aux_sym__inline_no_star] = aux_sym__inline_no_star,
  [sym__inline_element_no_underscore] = sym__inline_element_no_underscore,
  [aux_sym__inline_no_underscore] = aux_sym__inline_no_underscore,
  [sym__inline_element_no_tilde] = sym__inline_element_no_tilde,
  [aux_sym__inline_no_tilde] = aux_sym__inline_no_tilde,
  [sym__strikethrough] = sym__strikethrough,
  [sym__emphasis_star] = sym__emphasis_star,
  [sym__strong_emphasis_star] = sym__strong_emphasis_star,
  [sym__emphasis_underscore] = sym__emphasis_underscore,
  [sym__strong_emphasis_underscore] = sym__strong_emphasis_star,
  [sym__inline_element_no_link] = sym__inline_element_no_link,
  [aux_sym__inline_no_link] = aux_sym__inline_no_link,
  [sym__inline_element_no_star_no_link] = sym__inline_element_no_star_no_link,
  [aux_sym__inline_no_star_no_link] = aux_sym__inline_no_star_no_link,
  [sym__inline_element_no_underscore_no_link] = sym__inline_element_no_underscore_no_link,
  [aux_sym__inline_no_underscore_no_link] = aux_sym__inline_no_underscore_no_link,
  [sym__inline_element_no_tilde_no_link] = sym__inline_element_no_tilde_no_link,
  [aux_sym__inline_no_tilde_no_link] = aux_sym__inline_no_tilde_no_link,
  [sym__strikethrough_no_link] = sym__strikethrough,
  [sym__emphasis_star_no_link] = sym__emphasis_star_no_link,
  [sym__strong_emphasis_star_no_link] = sym__strong_emphasis_star,
  [sym__emphasis_underscore_no_link] = sym__emphasis_underscore_no_link,
  [sym__strong_emphasis_underscore_no_link] = sym__strong_emphasis_star,
  [aux_sym_link_label_repeat1] = aux_sym_link_label_repeat1,
  [aux_sym_link_destination_repeat1] = aux_sym_link_destination_repeat1,
  [aux_sym_link_destination_repeat2] = aux_sym_link_destination_repeat2,
  [aux_sym_link_title_repeat1] = aux_sym_link_title_repeat1,
  [aux_sym_link_title_repeat2] = aux_sym_link_title_repeat2,
  [aux_sym_link_title_repeat3] = aux_sym_link_title_repeat3,
  [aux_sym_code_span_repeat1] = aux_sym_code_span_repeat1,
  [aux_sym_inline_link_repeat1] = aux_sym_inline_link_repeat1,
  [aux_sym__open_tag_repeat1] = aux_sym__open_tag_repeat1,
  [aux_sym__tag_name_repeat1] = aux_sym__tag_name_repeat1,
  [aux_sym__attribute_value_repeat1] = aux_sym__attribute_value_repeat1,
  [aux_sym__attribute_value_repeat2] = aux_sym__attribute_value_repeat2,
  [aux_sym__html_comment_repeat1] = aux_sym__html_comment_repeat1,
  [aux_sym__processing_instruction_repeat1] = aux_sym__processing_instruction_repeat1,
  [aux_sym__declaration_repeat1] = aux_sym__declaration_repeat1,
  [aux_sym__inline_base_repeat1] = aux_sym__inline_base_repeat1,
  [alias_sym_emphasis] = alias_sym_emphasis,
  [alias_sym_html_tag] = alias_sym_html_tag,
  [alias_sym_image_description] = alias_sym_image_description,
  [alias_sym_link_text] = alias_sym_link_text,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__backslash_escape] = {
    .visible = false,
    .named = true,
  },
  [sym_entity_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_numeric_character_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym__newline_token] = {
    .visible = false,
    .named = true,
  },
  [sym_uri_autolink] = {
    .visible = true,
    .named = true,
  },
  [sym_email_autolink] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_name] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__attribute_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT_BANG_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__declaration_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__whitespace_ge_2] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__whitespace_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__word_no_digit] = {
    .visible = false,
    .named = true,
  },
  [sym__digits] = {
    .visible = false,
    .named = true,
  },
  [sym__error] = {
    .visible = false,
    .named = true,
  },
  [sym__trigger_error] = {
    .visible = false,
    .named = true,
  },
  [sym__code_span_start] = {
    .visible = true,
    .named = true,
  },
  [sym__code_span_close] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_open_star] = {
    .visible = false,
    .named = true,
  },
  [sym__emphasis_open_underscore] = {
    .visible = false,
    .named = true,
  },
  [sym__emphasis_close_star] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_close_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym__last_token_whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__last_token_punctuation] = {
    .visible = false,
    .named = true,
  },
  [sym__strikethrough_open] = {
    .visible = false,
    .named = true,
  },
  [sym__strikethrough_close] = {
    .visible = true,
    .named = true,
  },
  [sym__latex_span_start] = {
    .visible = true,
    .named = true,
  },
  [sym__latex_span_close] = {
    .visible = true,
    .named = true,
  },
  [sym__unclosed_span] = {
    .visible = false,
    .named = true,
  },
  [sym_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_backslash_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_link_label] = {
    .visible = true,
    .named = true,
  },
  [sym_link_destination] = {
    .visible = true,
    .named = true,
  },
  [sym__link_destination_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__text_no_angle] = {
    .visible = false,
    .named = true,
  },
  [sym_link_title] = {
    .visible = true,
    .named = true,
  },
  [sym_code_span] = {
    .visible = true,
    .named = true,
  },
  [sym_latex_block] = {
    .visible = true,
    .named = true,
  },
  [sym__link_text] = {
    .visible = false,
    .named = true,
  },
  [sym__link_text_non_empty] = {
    .visible = false,
    .named = true,
  },
  [sym_shortcut_link] = {
    .visible = true,
    .named = true,
  },
  [sym_full_reference_link] = {
    .visible = true,
    .named = true,
  },
  [sym_collapsed_reference_link] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_link] = {
    .visible = true,
    .named = true,
  },
  [sym_image] = {
    .visible = true,
    .named = true,
  },
  [sym__image_inline_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_shortcut_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_full_reference_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_collapsed_reference_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_description] = {
    .visible = false,
    .named = true,
  },
  [sym__image_description_non_empty] = {
    .visible = false,
    .named = true,
  },
  [sym__html_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__open_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__closing_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__tag_name] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym__html_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__processing_instruction] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__cdata_section] = {
    .visible = false,
    .named = true,
  },
  [sym_hard_line_break] = {
    .visible = true,
    .named = true,
  },
  [sym__whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__word] = {
    .visible = false,
    .named = true,
  },
  [sym__soft_line_break] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_base] = {
    .visible = false,
    .named = true,
  },
  [sym__text_base] = {
    .visible = false,
    .named = true,
  },
  [sym__text_inline_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_element] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_star] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_star] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_underscore] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_underscore] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_tilde] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_tilde] = {
    .visible = false,
    .named = false,
  },
  [sym__strikethrough] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_star] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_star] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_underscore] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym__inline_element_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_star_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_star_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_underscore_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_underscore_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_tilde_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_tilde_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__strikethrough_no_link] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_star_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_star_no_link] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_underscore_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_underscore_no_link] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_link_label_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_destination_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_destination_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_code_span_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inline_link_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__open_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__tag_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_value_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__html_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__processing_instruction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__inline_base_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_emphasis] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_html_tag] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_image_description] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_link_text] = {
    .visible = true,
    .named = true,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_html_tag,
  },
  [2] = {
    [0] = alias_sym_emphasis,
  },
  [3] = {
    [0] = sym__emphasis_close_star,
  },
  [4] = {
    [1] = alias_sym_link_text,
  },
  [5] = {
    [2] = alias_sym_image_description,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__html_tag, 2,
    sym__html_tag,
    alias_sym_html_tag,
  aux_sym__inline, 2,
    aux_sym__inline,
    alias_sym_image_description,
  sym__emphasis_star, 2,
    sym__emphasis_star,
    alias_sym_emphasis,
  sym__emphasis_underscore, 2,
    sym__emphasis_underscore,
    alias_sym_emphasis,
  aux_sym__inline_no_link, 2,
    aux_sym__inline_no_link,
    alias_sym_link_text,
  sym__emphasis_star_no_link, 2,
    sym__emphasis_star_no_link,
    alias_sym_emphasis,
  sym__emphasis_underscore_no_link, 2,
    sym__emphasis_underscore_no_link,
    alias_sym_emphasis,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(2178);
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2195);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2201);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2186);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2208);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2211);
      if (lookahead == ']') ADVANCE(2184);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 1:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2195);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2187);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '\\') ADVANCE(2211);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0 &&
          lookahead != '[') ADVANCE(2240);
      END_STATE();
    case 2:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2195);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2185);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2211);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 3:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2194);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2201);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2187);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2210);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 4:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2194);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2201);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2185);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2210);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 5:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2194);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2187);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2208);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2210);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 6:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2194);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2187);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2210);
      if (lookahead == ']') ADVANCE(2184);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 7:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2194);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2187);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2210);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 8:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2194);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2185);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2208);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2210);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 9:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2194);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2185);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2210);
      if (lookahead == ']') ADVANCE(2184);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 10:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2194);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2185);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2210);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 11:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead != 0 &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '`') ADVANCE(2226);
      END_STATE();
    case 12:
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == ':' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2225);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == '@') ADVANCE(2172);
      if (lookahead == '[') ADVANCE(424);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2233);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('.' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(383);
      END_STATE();
    case 14:
      if (lookahead == '-') ADVANCE(2228);
      if (lookahead == '@') ADVANCE(2172);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('.' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(383);
      END_STATE();
    case 15:
      if (lookahead == '-') ADVANCE(137);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(136);
      END_STATE();
    case 16:
      if (lookahead == '-') ADVANCE(17);
      if (lookahead == '[') ADVANCE(424);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2234);
      END_STATE();
    case 17:
      if (lookahead == '-') ADVANCE(2227);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(2173);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(139);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(2173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(139);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(22);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(22);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(18);
      END_STATE();
    case 23:
      if (lookahead == '-') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(18);
      END_STATE();
    case 24:
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(26);
      END_STATE();
    case 25:
      if (lookahead == '-') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(26);
      END_STATE();
    case 26:
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(20);
      END_STATE();
    case 27:
      if (lookahead == '-') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(20);
      END_STATE();
    case 28:
      if (lookahead == '-') ADVANCE(31);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(30);
      END_STATE();
    case 29:
      if (lookahead == '-') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(30);
      END_STATE();
    case 30:
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 32:
      if (lookahead == '-') ADVANCE(35);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(34);
      END_STATE();
    case 33:
      if (lookahead == '-') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(34);
      END_STATE();
    case 34:
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 35:
      if (lookahead == '-') ADVANCE(29);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 36:
      if (lookahead == '-') ADVANCE(39);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 37:
      if (lookahead == '-') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 38:
      if (lookahead == '-') ADVANCE(33);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 39:
      if (lookahead == '-') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 40:
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(42);
      END_STATE();
    case 41:
      if (lookahead == '-') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(36);
      END_STATE();
    case 43:
      if (lookahead == '-') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(36);
      END_STATE();
    case 44:
      if (lookahead == '-') ADVANCE(47);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 45:
      if (lookahead == '-') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 46:
      if (lookahead == '-') ADVANCE(41);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(40);
      END_STATE();
    case 47:
      if (lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(40);
      END_STATE();
    case 48:
      if (lookahead == '-') ADVANCE(51);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 49:
      if (lookahead == '-') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 50:
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(44);
      END_STATE();
    case 51:
      if (lookahead == '-') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(44);
      END_STATE();
    case 52:
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 53:
      if (lookahead == '-') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 54:
      if (lookahead == '-') ADVANCE(49);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 55:
      if (lookahead == '-') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 56:
      if (lookahead == '-') ADVANCE(59);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 57:
      if (lookahead == '-') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 58:
      if (lookahead == '-') ADVANCE(53);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 59:
      if (lookahead == '-') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 60:
      if (lookahead == '-') ADVANCE(63);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 61:
      if (lookahead == '-') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 63:
      if (lookahead == '-') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 64:
      if (lookahead == '-') ADVANCE(67);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 65:
      if (lookahead == '-') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 66:
      if (lookahead == '-') ADVANCE(61);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 67:
      if (lookahead == '-') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 68:
      if (lookahead == '-') ADVANCE(71);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 69:
      if (lookahead == '-') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 70:
      if (lookahead == '-') ADVANCE(65);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 71:
      if (lookahead == '-') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 72:
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 73:
      if (lookahead == '-') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 74:
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 75:
      if (lookahead == '-') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 76:
      if (lookahead == '-') ADVANCE(79);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 77:
      if (lookahead == '-') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 78:
      if (lookahead == '-') ADVANCE(73);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 79:
      if (lookahead == '-') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 80:
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 81:
      if (lookahead == '-') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 82:
      if (lookahead == '-') ADVANCE(77);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 83:
      if (lookahead == '-') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 84:
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 85:
      if (lookahead == '-') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 86:
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(80);
      END_STATE();
    case 87:
      if (lookahead == '-') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(80);
      END_STATE();
    case 88:
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 89:
      if (lookahead == '-') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 90:
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 91:
      if (lookahead == '-') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 92:
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 93:
      if (lookahead == '-') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 94:
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 95:
      if (lookahead == '-') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 96:
      if (lookahead == '-') ADVANCE(99);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(98);
      END_STATE();
    case 97:
      if (lookahead == '-') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(98);
      END_STATE();
    case 98:
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 99:
      if (lookahead == '-') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 100:
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(102);
      END_STATE();
    case 101:
      if (lookahead == '-') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(102);
      END_STATE();
    case 102:
      if (lookahead == '-') ADVANCE(97);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 103:
      if (lookahead == '-') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 104:
      if (lookahead == '-') ADVANCE(107);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(106);
      END_STATE();
    case 105:
      if (lookahead == '-') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(106);
      END_STATE();
    case 106:
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 107:
      if (lookahead == '-') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 108:
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 109:
      if (lookahead == '-') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 110:
      if (lookahead == '-') ADVANCE(105);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(104);
      END_STATE();
    case 111:
      if (lookahead == '-') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(104);
      END_STATE();
    case 112:
      if (lookahead == '-') ADVANCE(115);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 113:
      if (lookahead == '-') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 114:
      if (lookahead == '-') ADVANCE(109);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 115:
      if (lookahead == '-') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 116:
      if (lookahead == '-') ADVANCE(119);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(118);
      END_STATE();
    case 117:
      if (lookahead == '-') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(118);
      END_STATE();
    case 118:
      if (lookahead == '-') ADVANCE(113);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(112);
      END_STATE();
    case 119:
      if (lookahead == '-') ADVANCE(113);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(112);
      END_STATE();
    case 120:
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 121:
      if (lookahead == '-') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 122:
      if (lookahead == '-') ADVANCE(117);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 123:
      if (lookahead == '-') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 124:
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 125:
      if (lookahead == '-') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 126:
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(120);
      END_STATE();
    case 127:
      if (lookahead == '-') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(120);
      END_STATE();
    case 128:
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 129:
      if (lookahead == '-') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 130:
      if (lookahead == '-') ADVANCE(125);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 131:
      if (lookahead == '-') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 132:
      if (lookahead == '-') ADVANCE(135);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(134);
      END_STATE();
    case 133:
      if (lookahead == '-') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(134);
      END_STATE();
    case 134:
      if (lookahead == '-') ADVANCE(129);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(128);
      END_STATE();
    case 135:
      if (lookahead == '-') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(128);
      END_STATE();
    case 136:
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(132);
      END_STATE();
    case 137:
      if (lookahead == '-') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(132);
      END_STATE();
    case 138:
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      END_STATE();
    case 139:
      if (lookahead == '.') ADVANCE(2172);
      if (lookahead == '>') ADVANCE(2224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 140:
      if (lookahead == '1') ADVANCE(2147);
      if (lookahead == '3') ADVANCE(143);
      END_STATE();
    case 141:
      if (lookahead == '1') ADVANCE(2162);
      if (lookahead == ';') ADVANCE(2180);
      END_STATE();
    case 142:
      if (lookahead == '1') ADVANCE(2169);
      if (lookahead == '2') ADVANCE(2148);
      if (lookahead == '3') ADVANCE(2165);
      if (lookahead == '4') ADVANCE(145);
      if (lookahead == '5') ADVANCE(2149);
      if (lookahead == '7') ADVANCE(146);
      END_STATE();
    case 143:
      if (lookahead == '4') ADVANCE(148);
      END_STATE();
    case 144:
      if (lookahead == '4') ADVANCE(148);
      if (lookahead == 'f') ADVANCE(1659);
      END_STATE();
    case 145:
      if (lookahead == '5') ADVANCE(148);
      END_STATE();
    case 146:
      if (lookahead == '8') ADVANCE(148);
      END_STATE();
    case 147:
      if (lookahead == ':') ADVANCE(381);
      if (lookahead == '@') ADVANCE(2172);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '/' ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(383);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(147);
      END_STATE();
    case 148:
      if (lookahead == ';') ADVANCE(2180);
      END_STATE();
    case 149:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'A') ADVANCE(585);
      if (lookahead == 'B') ADVANCE(575);
      if (lookahead == 'E') ADVANCE(271);
      if (lookahead == 'H') ADVANCE(538);
      if (lookahead == 'a') ADVANCE(810);
      if (lookahead == 'b') ADVANCE(576);
      if (lookahead == 'c') ADVANCE(602);
      if (lookahead == 'd') ADVANCE(794);
      if (lookahead == 'e') ADVANCE(268);
      if (lookahead == 'f') ADVANCE(1252);
      if (lookahead == 'g') ADVANCE(163);
      if (lookahead == 'h') ADVANCE(620);
      if (lookahead == 'j') ADVANCE(745);
      if (lookahead == 'l') ADVANCE(197);
      if (lookahead == 'm') ADVANCE(1235);
      if (lookahead == 'n') ADVANCE(457);
      if (lookahead == 'o') ADVANCE(546);
      if (lookahead == 'p') ADVANCE(624);
      if (lookahead == 'r') ADVANCE(579);
      if (lookahead == 's') ADVANCE(526);
      if (lookahead == 't') ADVANCE(223);
      if (lookahead == 'u') ADVANCE(1769);
      if (lookahead == 'v') ADVANCE(1062);
      END_STATE();
    case 150:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'a') ADVANCE(1753);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'q') ADVANCE(2070);
      if (lookahead == 's') ADVANCE(967);
      if (lookahead == 'x') ADVANCE(1294);
      END_STATE();
    case 151:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'A') ADVANCE(1872);
      END_STATE();
    case 152:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'A') ADVANCE(1872);
      if (lookahead == 'V') ADVANCE(1063);
      END_STATE();
    case 153:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'B') ADVANCE(538);
      END_STATE();
    case 154:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'B') ADVANCE(538);
      if (lookahead == 'D') ADVANCE(1643);
      END_STATE();
    case 155:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'B') ADVANCE(538);
      if (lookahead == 'E') ADVANCE(1731);
      END_STATE();
    case 156:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'B') ADVANCE(538);
      if (lookahead == 'L') ADVANCE(1065);
      END_STATE();
    case 157:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'B') ADVANCE(538);
      if (lookahead == 'R') ADVANCE(1316);
      END_STATE();
    case 158:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'B') ADVANCE(538);
      if (lookahead == 'U') ADVANCE(1687);
      END_STATE();
    case 159:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'C') ADVANCE(1654);
      if (lookahead == 'D') ADVANCE(1628);
      if (lookahead == 'E') ADVANCE(1363);
      if (lookahead == 'G') ADVANCE(1888);
      if (lookahead == 'H') ADVANCE(2081);
      if (lookahead == 'L') ADVANCE(1037);
      if (lookahead == 'N') ADVANCE(1004);
      if (lookahead == 'P') ADVANCE(1849);
      if (lookahead == 'R') ADVANCE(1038);
      if (lookahead == 'S') ADVANCE(1732);
      if (lookahead == 'T') ADVANCE(1241);
      if (lookahead == 'V') ADVANCE(1077);
      END_STATE();
    case 160:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'C') ADVANCE(564);
      END_STATE();
    case 161:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'D') ADVANCE(1589);
      if (lookahead == 'E') ADVANCE(1731);
      END_STATE();
    case 162:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'D') ADVANCE(438);
      END_STATE();
    case 163:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(148);
      END_STATE();
    case 164:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1668);
      if (lookahead == 'c') ADVANCE(2059);
      if (lookahead == 'e') ADVANCE(222);
      if (lookahead == 'i') ADVANCE(1490);
      if (lookahead == 'n') ADVANCE(456);
      if (lookahead == 'o') ADVANCE(873);
      if (lookahead == 's') ADVANCE(1246);
      if (lookahead == 'u') ADVANCE(1800);
      END_STATE();
    case 165:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(233);
      if (lookahead == 'm') ADVANCE(2066);
      if (lookahead == 'n') ADVANCE(2150);
      if (lookahead == 'p') ADVANCE(1439);
      if (lookahead == 'r') ADVANCE(575);
      if (lookahead == 's') ADVANCE(1017);
      END_STATE();
    case 166:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'v') ADVANCE(2166);
      END_STATE();
    case 167:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 168:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'o') ADVANCE(1894);
      if (lookahead == 'p') ADVANCE(1820);
      END_STATE();
    case 169:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(287);
      if (lookahead == 'a') ADVANCE(812);
      if (lookahead == 'b') ADVANCE(1740);
      if (lookahead == 'c') ADVANCE(1282);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(288);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(271);
      if (lookahead == 'i') ADVANCE(1475);
      if (lookahead == 'j') ADVANCE(745);
      if (lookahead == 'l') ADVANCE(363);
      if (lookahead == 'n') ADVANCE(457);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'r') ADVANCE(529);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(224);
      if (lookahead == 'v') ADVANCE(1062);
      END_STATE();
    case 170:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(1731);
      END_STATE();
    case 171:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(1731);
      if (lookahead == 'F') ADVANCE(2088);
      if (lookahead == 'G') ADVANCE(1881);
      if (lookahead == 'L') ADVANCE(963);
      if (lookahead == 'S') ADVANCE(1449);
      if (lookahead == 'T') ADVANCE(1309);
      END_STATE();
    case 172:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(1731);
      if (lookahead == 'F') ADVANCE(2088);
      if (lookahead == 'T') ADVANCE(1309);
      END_STATE();
    case 173:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(1731);
      if (lookahead == 'G') ADVANCE(1881);
      if (lookahead == 'L') ADVANCE(963);
      if (lookahead == 'S') ADVANCE(1449);
      if (lookahead == 'T') ADVANCE(1309);
      END_STATE();
    case 174:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(1731);
      if (lookahead == 'S') ADVANCE(1449);
      END_STATE();
    case 175:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E') ADVANCE(1731);
      if (lookahead == 'S') ADVANCE(1449);
      if (lookahead == 'T') ADVANCE(1309);
      END_STATE();
    case 176:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'G') ADVANCE(148);
      END_STATE();
    case 177:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'H') ADVANCE(148);
      END_STATE();
    case 178:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'I') ADVANCE(1571);
      if (lookahead == 'S') ADVANCE(2052);
      if (lookahead == 'U') ADVANCE(1552);
      END_STATE();
    case 179:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'J') ADVANCE(745);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(811);
      if (lookahead == 'c') ADVANCE(604);
      if (lookahead == 'e') ADVANCE(1094);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'l') ADVANCE(248);
      if (lookahead == 'm') ADVANCE(1234);
      if (lookahead == 'o') ADVANCE(1519);
      if (lookahead == 's') ADVANCE(777);
      END_STATE();
    case 180:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'J') ADVANCE(745);
      if (lookahead == 'T' ||
          lookahead == 'g' ||
          lookahead == 't') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1491);
      if (lookahead == 'b') ADVANCE(1740);
      if (lookahead == 'c') ADVANCE(971);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'r') ADVANCE(989);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 181:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'L') ADVANCE(963);
      END_STATE();
    case 182:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'N') ADVANCE(148);
      END_STATE();
    case 183:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'P') ADVANCE(148);
      END_STATE();
    case 184:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'P') ADVANCE(1439);
      END_STATE();
    case 185:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'T') ADVANCE(148);
      END_STATE();
    case 186:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'T') ADVANCE(1309);
      END_STATE();
    case 187:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'Y') ADVANCE(148);
      END_STATE();
    case 188:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(775);
      if (lookahead == 'p') ADVANCE(1405);
      END_STATE();
    case 189:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1126);
      if (lookahead == 'o') ADVANCE(2004);
      END_STATE();
    case 190:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(2170);
      END_STATE();
    case 191:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(769);
      if (lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 192:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1741);
      END_STATE();
    case 193:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(783);
      if (lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 194:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(293);
      if (lookahead == 's') ADVANCE(1247);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 195:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1668);
      if (lookahead == 'b') ADVANCE(267);
      if (lookahead == 'c' ||
          lookahead == 'w') ADVANCE(148);
      if (lookahead == 'f') ADVANCE(1894);
      if (lookahead == 'h') ADVANCE(1330);
      if (lookahead == 'l') ADVANCE(1668);
      if (lookahead == 'p') ADVANCE(1349);
      if (lookahead == 's') ADVANCE(1246);
      if (lookahead == 't') ADVANCE(1349);
      END_STATE();
    case 196:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(841);
      if (lookahead == 'b' ||
          lookahead == 'e') ADVANCE(148);
      if (lookahead == 'c') ADVANCE(1224);
      if (lookahead == 'd') ADVANCE(2160);
      if (lookahead == 'm') ADVANCE(297);
      if (lookahead == 's') ADVANCE(1246);
      if (lookahead == 't') ADVANCE(2112);
      END_STATE();
    case 197:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'c') ADVANCE(1640);
      if (lookahead == 'h') ADVANCE(639);
      if (lookahead == 't') ADVANCE(1776);
      END_STATE();
    case 198:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'd') ADVANCE(263);
      if (lookahead == 'i') ADVANCE(1128);
      if (lookahead == 'o') ADVANCE(1741);
      if (lookahead == 's') ADVANCE(1404);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 199:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1894);
      END_STATE();
    case 200:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1905);
      if (lookahead == 'c') ADVANCE(1224);
      if (lookahead == 'd') ADVANCE(1596);
      END_STATE();
    case 201:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1349);
      END_STATE();
    case 202:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1794);
      if (lookahead == 'e') ADVANCE(912);
      if (lookahead == 'i') ADVANCE(1808);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 203:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1354);
      if (lookahead == 'c') ADVANCE(1949);
      if (lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 204:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1494);
      if (lookahead == 'b') ADVANCE(1863);
      if (lookahead == 'c') ADVANCE(568);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 205:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1494);
      if (lookahead == 'd' ||
          lookahead == 'v') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1404);
      END_STATE();
    case 206:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(834);
      END_STATE();
    case 207:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1789);
      if (lookahead == 'c') ADVANCE(1181);
      if (lookahead == 'o') ADVANCE(1828);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 208:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1373);
      END_STATE();
    case 209:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1757);
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 210:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1703);
      if (lookahead == 'c') ADVANCE(2079);
      if (lookahead == 'e') ADVANCE(1723);
      if (lookahead == 'n') ADVANCE(661);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 211:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1254);
      if (lookahead == 'e') ADVANCE(322);
      END_STATE();
    case 212:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(1349);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 213:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'b') ADVANCE(1589);
      if (lookahead == 'c') ADVANCE(1224);
      if (lookahead == 'f') ADVANCE(306);
      END_STATE();
    case 214:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'b') ADVANCE(148);
      if (lookahead == 'd') ADVANCE(343);
      END_STATE();
    case 215:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'b') ADVANCE(148);
      if (lookahead == 'h') ADVANCE(1941);
      END_STATE();
    case 216:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'b') ADVANCE(192);
      END_STATE();
    case 217:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'd') ADVANCE(148);
      END_STATE();
    case 218:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'b') ADVANCE(267);
      if (lookahead == 'f') ADVANCE(1894);
      if (lookahead == 'h') ADVANCE(1330);
      if (lookahead == 'l') ADVANCE(1668);
      if (lookahead == 'p') ADVANCE(1349);
      if (lookahead == 's') ADVANCE(1246);
      if (lookahead == 't') ADVANCE(1349);
      END_STATE();
    case 219:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'b') ADVANCE(538);
      if (lookahead == 'e') ADVANCE(1723);
      END_STATE();
    case 220:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'b') ADVANCE(1816);
      if (lookahead == 'c') ADVANCE(568);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'o') ADVANCE(1741);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 221:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(148);
      END_STATE();
    case 222:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(210);
      END_STATE();
    case 223:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(754);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'h') ADVANCE(1790);
      if (lookahead == 'i') ADVANCE(1488);
      if (lookahead == 'l') ADVANCE(575);
      if (lookahead == 'q') ADVANCE(2071);
      if (lookahead == 'r') ADVANCE(498);
      END_STATE();
    case 224:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(754);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'l') ADVANCE(497);
      if (lookahead == 'q') ADVANCE(2071);
      if (lookahead == 'r') ADVANCE(563);
      END_STATE();
    case 225:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(250);
      END_STATE();
    case 226:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(753);
      if (lookahead == 'd') ADVANCE(1633);
      if (lookahead == 'l') ADVANCE(258);
      END_STATE();
    case 227:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(753);
      if (lookahead == 'd') ADVANCE(1634);
      if (lookahead == 'g') ADVANCE(258);
      if (lookahead == 's') ADVANCE(660);
      END_STATE();
    case 228:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(591);
      if (lookahead == 'e') ADVANCE(1159);
      if (lookahead == 'l') ADVANCE(646);
      if (lookahead == 'p') ADVANCE(1801);
      END_STATE();
    case 229:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(1224);
      if (lookahead == 'w') ADVANCE(148);
      END_STATE();
    case 230:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(2059);
      if (lookahead == 'e') ADVANCE(225);
      END_STATE();
    case 231:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(2059);
      if (lookahead == 'e' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 232:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c') ADVANCE(681);
      if (lookahead == 'f') ADVANCE(1269);
      if (lookahead == 'o') ADVANCE(867);
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 233:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd') ADVANCE(1589);
      END_STATE();
    case 234:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(313);
      if (lookahead == 'g') ADVANCE(163);
      if (lookahead == 'l') ADVANCE(163);
      if (lookahead == 'n') ADVANCE(917);
      if (lookahead == 'p') ADVANCE(1439);
      if (lookahead == 'r') ADVANCE(575);
      END_STATE();
    case 235:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd') ADVANCE(148);
      END_STATE();
    case 236:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(917);
      END_STATE();
    case 237:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd') ADVANCE(1582);
      if (lookahead == 'l') ADVANCE(977);
      if (lookahead == 'r') ADVANCE(1277);
      END_STATE();
    case 238:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd') ADVANCE(1582);
      if (lookahead == 'l') ADVANCE(977);
      if (lookahead == 'u') ADVANCE(1668);
      END_STATE();
    case 239:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd') ADVANCE(1582);
      if (lookahead == 'l') ADVANCE(1070);
      if (lookahead == 'q') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1320);
      END_STATE();
    case 240:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd') ADVANCE(1254);
      END_STATE();
    case 241:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 242:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(917);
      if (lookahead == 'm') ADVANCE(1924);
      if (lookahead == 'r') ADVANCE(1978);
      if (lookahead == 's') ADVANCE(1691);
      if (lookahead == 'z') ADVANCE(575);
      END_STATE();
    case 243:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1005);
      END_STATE();
    case 244:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1741);
      END_STATE();
    case 245:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1724);
      if (lookahead == 'm') ADVANCE(1306);
      if (lookahead == 'p') ADVANCE(1439);
      if (lookahead == 's') ADVANCE(1738);
      END_STATE();
    case 246:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1949);
      END_STATE();
    case 247:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1152);
      END_STATE();
    case 248:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1097);
      END_STATE();
    case 249:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 250:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1723);
      END_STATE();
    case 251:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1723);
      if (lookahead == 'l') ADVANCE(937);
      END_STATE();
    case 252:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(322);
      END_STATE();
    case 253:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(843);
      if (lookahead == 'i') ADVANCE(1478);
      if (lookahead == 'o') ADVANCE(896);
      END_STATE();
    case 254:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(309);
      END_STATE();
    case 255:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1728);
      END_STATE();
    case 256:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1728);
      if (lookahead == 'n') ADVANCE(982);
      END_STATE();
    case 257:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(590);
      END_STATE();
    case 258:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1894);
      END_STATE();
    case 259:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1925);
      END_STATE();
    case 260:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1549);
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 261:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1826);
      if (lookahead == 's') ADVANCE(952);
      END_STATE();
    case 262:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1782);
      if (lookahead == 's') ADVANCE(1668);
      END_STATE();
    case 263:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1792);
      if (lookahead == 'f' ||
          lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 264:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e') ADVANCE(1781);
      END_STATE();
    case 265:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 266:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1578);
      if (lookahead == 'y') ADVANCE(323);
      END_STATE();
    case 267:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'f') ADVANCE(1894);
      END_STATE();
    case 268:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'f') ADVANCE(1954);
      if (lookahead == 'g') ADVANCE(148);
      if (lookahead == 'q') ADVANCE(314);
      if (lookahead == 's') ADVANCE(227);
      END_STATE();
    case 269:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'f') ADVANCE(1495);
      if (lookahead == 'l') ADVANCE(938);
      END_STATE();
    case 270:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'f') ADVANCE(1979);
      if (lookahead == 'q') ADVANCE(314);
      if (lookahead == 's') ADVANCE(322);
      END_STATE();
    case 271:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 272:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'g') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(1970);
      if (lookahead == 'm') ADVANCE(1702);
      END_STATE();
    case 273:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'g') ADVANCE(1949);
      END_STATE();
    case 274:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'g') ADVANCE(917);
      END_STATE();
    case 275:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 276:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'h') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(1620);
      END_STATE();
    case 277:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'h') ADVANCE(1579);
      END_STATE();
    case 278:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'i') ADVANCE(1227);
      if (lookahead == 'n') ADVANCE(1109);
      if (lookahead == 'o') ADVANCE(1970);
      END_STATE();
    case 279:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'i') ADVANCE(891);
      if (lookahead == 'o') ADVANCE(1511);
      END_STATE();
    case 280:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'i') ADVANCE(1771);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 281:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'i') ADVANCE(1529);
      if (lookahead == 'p') ADVANCE(643);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 282:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'i') ADVANCE(2008);
      END_STATE();
    case 283:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'i') ADVANCE(856);
      END_STATE();
    case 284:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'i') ADVANCE(1503);
      if (lookahead == 'n') ADVANCE(1237);
      END_STATE();
    case 285:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'i') ADVANCE(1431);
      END_STATE();
    case 286:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'i') ADVANCE(1568);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == 's') ADVANCE(233);
      END_STATE();
    case 287:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 288:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == 'q') ADVANCE(314);
      if (lookahead == 's') ADVANCE(226);
      END_STATE();
    case 289:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'l') ADVANCE(1949);
      END_STATE();
    case 290:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'l') ADVANCE(1620);
      END_STATE();
    case 291:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'l') ADVANCE(1620);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 292:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'l') ADVANCE(2011);
      if (lookahead == 'm') ADVANCE(564);
      END_STATE();
    case 293:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'l') ADVANCE(1390);
      END_STATE();
    case 294:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 295:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'm') ADVANCE(262);
      END_STATE();
    case 296:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'm') ADVANCE(597);
      END_STATE();
    case 297:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 298:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'n') ADVANCE(616);
      END_STATE();
    case 299:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(148);
      END_STATE();
    case 300:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(318);
      END_STATE();
    case 301:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(287);
      END_STATE();
    case 302:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(1087);
      END_STATE();
    case 303:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(2117);
      END_STATE();
    case 304:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(2107);
      END_STATE();
    case 305:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(841);
      END_STATE();
    case 306:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(1795);
      END_STATE();
    case 307:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(2024);
      END_STATE();
    case 308:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(1534);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 309:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'o') ADVANCE(1559);
      END_STATE();
    case 310:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 311:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 't') ADVANCE(284);
      END_STATE();
    case 312:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'p') ADVANCE(1820);
      END_STATE();
    case 313:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'q') ADVANCE(148);
      END_STATE();
    case 314:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'q') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1434);
      END_STATE();
    case 315:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'q') ADVANCE(314);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 316:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'q') ADVANCE(313);
      END_STATE();
    case 317:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'q') ADVANCE(2070);
      END_STATE();
    case 318:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 319:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'r') ADVANCE(556);
      if (lookahead == 's') ADVANCE(233);
      END_STATE();
    case 320:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'r') ADVANCE(1262);
      END_STATE();
    case 321:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'r') ADVANCE(1240);
      END_STATE();
    case 322:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 323:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(1741);
      END_STATE();
    case 324:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(235);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 325:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(217);
      END_STATE();
    case 326:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(2139);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 327:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(1454);
      END_STATE();
    case 328:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(1349);
      END_STATE();
    case 329:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(2012);
      END_STATE();
    case 330:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(952);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 331:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(1007);
      END_STATE();
    case 332:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 's') ADVANCE(2074);
      END_STATE();
    case 333:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 334:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(524);
      END_STATE();
    case 335:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(1579);
      END_STATE();
    case 336:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 337:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(725);
      END_STATE();
    case 338:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(1349);
      END_STATE();
    case 339:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(823);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 340:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(670);
      END_STATE();
    case 341:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(1603);
      END_STATE();
    case 342:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 't') ADVANCE(1262);
      END_STATE();
    case 343:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 344:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'u') ADVANCE(1232);
      END_STATE();
    case 345:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 346:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'v') ADVANCE(2166);
      END_STATE();
    case 347:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'v') ADVANCE(714);
      END_STATE();
    case 348:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'v') ADVANCE(1019);
      END_STATE();
    case 349:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(841);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == 'o') ADVANCE(1894);
      if (lookahead == 'p') ADVANCE(1814);
      END_STATE();
    case 350:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(148);
      if (lookahead == 'c') ADVANCE(251);
      if (lookahead == 'f') ADVANCE(1557);
      if (lookahead == 'm') ADVANCE(1213);
      if (lookahead == 's') ADVANCE(841);
      END_STATE();
    case 351:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1020);
      END_STATE();
    case 352:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E' ||
          lookahead == 'v') ADVANCE(148);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 's') ADVANCE(345);
      END_STATE();
    case 353:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E' ||
          lookahead == 'y') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1669);
      if (lookahead == 'c') ADVANCE(2059);
      if (lookahead == 'e') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(1808);
      if (lookahead == 'n') ADVANCE(456);
      if (lookahead == 'p') ADVANCE(1664);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 354:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'a' ||
          lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 355:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'b' ||
          lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 356:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'c' ||
          lookahead == 'w') ADVANCE(148);
      END_STATE();
    case 357:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e' ||
          lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 358:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e' ||
          lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 359:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'f' ||
          lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 360:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd' ||
          lookahead == 'e') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(917);
      END_STATE();
    case 361:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 362:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(2007);
      END_STATE();
    case 363:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E' ||
          lookahead == 'a' ||
          lookahead == 'j') ADVANCE(148);
      END_STATE();
    case 364:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'E' ||
          lookahead == 'd' ||
          lookahead == 'y') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(1771);
      if (lookahead == 'u') ADVANCE(1985);
      END_STATE();
    case 365:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'D' ||
          lookahead == 'U' ||
          lookahead == 'd' ||
          lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 366:
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'H' ||
          lookahead == 'L' ||
          lookahead == 'R' ||
          lookahead == 'h' ||
          lookahead == 'l' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 367:
      if (lookahead == ';') ADVANCE(2181);
      END_STATE();
    case 368:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(369);
      END_STATE();
    case 369:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(367);
      END_STATE();
    case 370:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(368);
      END_STATE();
    case 371:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(370);
      END_STATE();
    case 372:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(371);
      END_STATE();
    case 373:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 374:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(367);
      END_STATE();
    case 375:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(374);
      END_STATE();
    case 376:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(375);
      END_STATE();
    case 377:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(376);
      END_STATE();
    case 378:
      if (lookahead == ';') ADVANCE(2181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(377);
      END_STATE();
    case 379:
      if (lookahead == '>') ADVANCE(2229);
      END_STATE();
    case 380:
      if (lookahead == '>') ADVANCE(2236);
      END_STATE();
    case 381:
      if (lookahead == '>') ADVANCE(2223);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '<') ADVANCE(381);
      END_STATE();
    case 382:
      if (lookahead == '@') ADVANCE(2172);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '/' ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(383);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(147);
      END_STATE();
    case 383:
      if (lookahead == '@') ADVANCE(2172);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(383);
      END_STATE();
    case 384:
      if (lookahead == 'A') ADVANCE(502);
      if (lookahead == 'a') ADVANCE(816);
      if (lookahead == 'c') ADVANCE(1280);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(1368);
      if (lookahead == 'o') ADVANCE(1674);
      if (lookahead == 's') ADVANCE(790);
      if (lookahead == 'u') ADVANCE(1467);
      END_STATE();
    case 385:
      if (lookahead == 'A') ADVANCE(585);
      if (lookahead == 'B') ADVANCE(575);
      if (lookahead == 'H') ADVANCE(538);
      if (lookahead == 'a') ADVANCE(763);
      if (lookahead == 'b') ADVANCE(576);
      if (lookahead == 'c') ADVANCE(602);
      if (lookahead == 'd') ADVANCE(793);
      if (lookahead == 'e') ADVANCE(203);
      if (lookahead == 'f') ADVANCE(1252);
      if (lookahead == 'h') ADVANCE(621);
      if (lookahead == 'i') ADVANCE(1142);
      if (lookahead == 'l') ADVANCE(581);
      if (lookahead == 'm') ADVANCE(1652);
      if (lookahead == 'n') ADVANCE(1468);
      if (lookahead == 'o') ADVANCE(547);
      if (lookahead == 'p') ADVANCE(628);
      if (lookahead == 'r') ADVANCE(575);
      if (lookahead == 's') ADVANCE(527);
      if (lookahead == 't') ADVANCE(1208);
      if (lookahead == 'u') ADVANCE(1394);
      if (lookahead == 'x') ADVANCE(148);
      END_STATE();
    case 386:
      if (lookahead == 'A') ADVANCE(520);
      END_STATE();
    case 387:
      if (lookahead == 'A') ADVANCE(745);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'U') ADVANCE(745);
      if (lookahead == 'a') ADVANCE(803);
      if (lookahead == 'c') ADVANCE(1282);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 'u') ADVANCE(1476);
      END_STATE();
    case 388:
      if (lookahead == 'A') ADVANCE(441);
      END_STATE();
    case 389:
      if (lookahead == 'A') ADVANCE(1566);
      if (lookahead == 'C') ADVANCE(1079);
      if (lookahead == 'D') ADVANCE(1584);
      if (lookahead == 'F') ADVANCE(1393);
      if (lookahead == 'R') ADVANCE(1315);
      if (lookahead == 'T') ADVANCE(1024);
      if (lookahead == 'U') ADVANCE(1682);
      if (lookahead == 'V') ADVANCE(1058);
      if (lookahead == 'a') ADVANCE(1872);
      if (lookahead == 'r') ADVANCE(1308);
      END_STATE();
    case 390:
      if (lookahead == 'A') ADVANCE(511);
      END_STATE();
    case 391:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'B') ADVANCE(631);
      if (lookahead == 'D') ADVANCE(571);
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'd') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(930);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'l') ADVANCE(2007);
      if (lookahead == 'n') ADVANCE(1923);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'p') ADVANCE(1810);
      if (lookahead == 'r') ADVANCE(2007);
      if (lookahead == 's') ADVANCE(792);
      if (lookahead == 'z') ADVANCE(1255);
      END_STATE();
    case 392:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'd') ADVANCE(1741);
      if (lookahead == 'e') ADVANCE(270);
      if (lookahead == 's') ADVANCE(1246);
      if (lookahead == 't') ADVANCE(321);
      END_STATE();
    case 393:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'H') ADVANCE(538);
      if (lookahead == 'a') ADVANCE(1125);
      if (lookahead == 'b') ADVANCE(1346);
      if (lookahead == 'c') ADVANCE(607);
      if (lookahead == 'd') ADVANCE(189);
      if (lookahead == 'e') ADVANCE(272);
      if (lookahead == 'f') ADVANCE(1253);
      if (lookahead == 'h') ADVANCE(614);
      if (lookahead == 'i') ADVANCE(586);
      if (lookahead == 'j') ADVANCE(745);
      if (lookahead == 'l') ADVANCE(759);
      if (lookahead == 'o') ADVANCE(1397);
      if (lookahead == 'r') ADVANCE(721);
      if (lookahead == 's') ADVANCE(761);
      if (lookahead == 't') ADVANCE(871);
      if (lookahead == 'u') ADVANCE(580);
      if (lookahead == 'w') ADVANCE(589);
      if (lookahead == 'z') ADVANCE(750);
      END_STATE();
    case 394:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'H') ADVANCE(538);
      if (lookahead == 'a') ADVANCE(804);
      if (lookahead == 'b') ADVANCE(1763);
      if (lookahead == 'c') ADVANCE(1261);
      if (lookahead == 'd') ADVANCE(577);
      if (lookahead == 'f') ADVANCE(1253);
      if (lookahead == 'g') ADVANCE(1802);
      if (lookahead == 'h') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(852);
      if (lookahead == 'm') ADVANCE(191);
      if (lookahead == 'o') ADVANCE(1129);
      if (lookahead == 'p') ADVANCE(686);
      if (lookahead == 'r') ADVANCE(851);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 't') ADVANCE(868);
      if (lookahead == 'u') ADVANCE(582);
      if (lookahead == 'w') ADVANCE(589);
      END_STATE();
    case 395:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'a') ADVANCE(1268);
      if (lookahead == 'b') ADVANCE(538);
      if (lookahead == 'c') ADVANCE(1280);
      if (lookahead == 'e') ADVANCE(668);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'k') ADVANCE(1895);
      if (lookahead == 'o') ADVANCE(583);
      if (lookahead == 's') ADVANCE(782);
      if (lookahead == 'y') ADVANCE(723);
      END_STATE();
    case 396:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'a') ADVANCE(1760);
      END_STATE();
    case 397:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'p') ADVANCE(538);
      END_STATE();
    case 398:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'a') ADVANCE(1753);
      if (lookahead == 'c') ADVANCE(333);
      if (lookahead == 'm') ADVANCE(1214);
      if (lookahead == 's') ADVANCE(2113);
      if (lookahead == 't') ADVANCE(1462);
      if (lookahead == 'x') ADVANCE(1949);
      END_STATE();
    case 399:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'a') ADVANCE(1753);
      if (lookahead == 'n') ADVANCE(2113);
      END_STATE();
    case 400:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'a') ADVANCE(1753);
      if (lookahead == 'n') ADVANCE(966);
      END_STATE();
    case 401:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'a') ADVANCE(1852);
      if (lookahead == 'i') ADVANCE(1145);
      if (lookahead == 't') ADVANCE(1835);
      END_STATE();
    case 402:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 403:
      if (lookahead == 'A') ADVANCE(1760);
      if (lookahead == 't') ADVANCE(1830);
      END_STATE();
    case 404:
      if (lookahead == 'A') ADVANCE(1875);
      if (lookahead == 'D') ADVANCE(1643);
      if (lookahead == 'E') ADVANCE(1734);
      if (lookahead == 'T') ADVANCE(1009);
      if (lookahead == 'a') ADVANCE(1872);
      if (lookahead == 'd') ADVANCE(1650);
      if (lookahead == 'p') ADVANCE(1018);
      if (lookahead == 's') ADVANCE(1231);
      END_STATE();
    case 405:
      if (lookahead == 'A') ADVANCE(809);
      END_STATE();
    case 406:
      if (lookahead == 'A') ADVANCE(809);
      if (lookahead == 'D') ADVANCE(1587);
      if (lookahead == 'G') ADVANCE(1793);
      if (lookahead == 'T') ADVANCE(1309);
      END_STATE();
    case 407:
      if (lookahead == 'A') ADVANCE(1391);
      END_STATE();
    case 408:
      if (lookahead == 'A') ADVANCE(1567);
      if (lookahead == 'C') ADVANCE(1079);
      if (lookahead == 'D') ADVANCE(1584);
      if (lookahead == 'F') ADVANCE(1393);
      if (lookahead == 'T') ADVANCE(1024);
      if (lookahead == 'U') ADVANCE(1682);
      if (lookahead == 'V') ADVANCE(1058);
      if (lookahead == 'a') ADVANCE(1872);
      END_STATE();
    case 409:
      if (lookahead == 'A') ADVANCE(1872);
      END_STATE();
    case 410:
      if (lookahead == 'A') ADVANCE(1872);
      if (lookahead == 'D') ADVANCE(1643);
      END_STATE();
    case 411:
      if (lookahead == 'A') ADVANCE(1872);
      if (lookahead == 'R') ADVANCE(1316);
      END_STATE();
    case 412:
      if (lookahead == 'A') ADVANCE(1872);
      if (lookahead == 'R') ADVANCE(1316);
      if (lookahead == 'T') ADVANCE(994);
      END_STATE();
    case 413:
      if (lookahead == 'A') ADVANCE(1872);
      if (lookahead == 'T') ADVANCE(994);
      END_STATE();
    case 414:
      if (lookahead == 'A') ADVANCE(1872);
      if (lookahead == 'V') ADVANCE(1063);
      END_STATE();
    case 415:
      if (lookahead == 'A') ADVANCE(1876);
      if (lookahead == 'B') ADVANCE(1740);
      if (lookahead == 'L') ADVANCE(1056);
      if (lookahead == 'R') ADVANCE(1314);
      if (lookahead == 'T') ADVANCE(1009);
      if (lookahead == 'a') ADVANCE(1872);
      END_STATE();
    case 416:
      if (lookahead == 'B') ADVANCE(541);
      if (lookahead == 'P') ADVANCE(689);
      END_STATE();
    case 417:
      if (lookahead == 'B') ADVANCE(575);
      if (lookahead == 'E') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(813);
      if (lookahead == 'c') ADVANCE(604);
      if (lookahead == 'e') ADVANCE(348);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(1579);
      if (lookahead == 'i') ADVANCE(1123);
      if (lookahead == 'o') ADVANCE(1677);
      if (lookahead == 'r') ADVANCE(1308);
      if (lookahead == 's') ADVANCE(776);
      if (lookahead == 'u') ADVANCE(1384);
      END_STATE();
    case 418:
      if (lookahead == 'B') ADVANCE(538);
      END_STATE();
    case 419:
      if (lookahead == 'B') ADVANCE(538);
      if (lookahead == 'L') ADVANCE(1263);
      if (lookahead == 'S') ADVANCE(1051);
      if (lookahead == 'T') ADVANCE(1309);
      END_STATE();
    case 420:
      if (lookahead == 'B') ADVANCE(1873);
      END_STATE();
    case 421:
      if (lookahead == 'B') ADVANCE(1865);
      if (lookahead == 'n') ADVANCE(422);
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 422:
      if (lookahead == 'B') ADVANCE(1870);
      END_STATE();
    case 423:
      if (lookahead == 'C') ADVANCE(475);
      if (lookahead == 'c') ADVANCE(2129);
      END_STATE();
    case 424:
      if (lookahead == 'C') ADVANCE(444);
      END_STATE();
    case 425:
      if (lookahead == 'C') ADVANCE(564);
      END_STATE();
    case 426:
      if (lookahead == 'C') ADVANCE(1644);
      if (lookahead == 'T') ADVANCE(1295);
      END_STATE();
    case 427:
      if (lookahead == 'C') ADVANCE(1321);
      END_STATE();
    case 428:
      if (lookahead == 'C') ADVANCE(1416);
      END_STATE();
    case 429:
      if (lookahead == 'C') ADVANCE(2078);
      END_STATE();
    case 430:
      if (lookahead == 'C') ADVANCE(1660);
      END_STATE();
    case 431:
      if (lookahead == 'C') ADVANCE(1660);
      if (lookahead == 'D') ADVANCE(1586);
      if (lookahead == 'L') ADVANCE(1068);
      if (lookahead == 'R') ADVANCE(1318);
      if (lookahead == 'U') ADVANCE(1683);
      if (lookahead == 'V') ADVANCE(1077);
      END_STATE();
    case 432:
      if (lookahead == 'D') ADVANCE(1589);
      END_STATE();
    case 433:
      if (lookahead == 'D') ADVANCE(1589);
      if (lookahead == 'M') ADVANCE(1306);
      if (lookahead == 'P') ADVANCE(1439);
      if (lookahead == 'T') ADVANCE(1295);
      END_STATE();
    case 434:
      if (lookahead == 'D') ADVANCE(1589);
      if (lookahead == 'a') ADVANCE(1760);
      END_STATE();
    case 435:
      if (lookahead == 'D') ADVANCE(1589);
      if (lookahead == 'o') ADVANCE(1949);
      END_STATE();
    case 436:
      if (lookahead == 'D') ADVANCE(1589);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 437:
      if (lookahead == 'D') ADVANCE(307);
      if (lookahead == 'J') ADVANCE(745);
      if (lookahead == 'S') ADVANCE(745);
      if (lookahead == 'Z') ADVANCE(745);
      if (lookahead == 'a') ADVANCE(1127);
      if (lookahead == 'c') ADVANCE(607);
      if (lookahead == 'e') ADVANCE(1350);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(550);
      if (lookahead == 'o') ADVANCE(1675);
      if (lookahead == 's') ADVANCE(790);
      END_STATE();
    case 438:
      if (lookahead == 'D') ADVANCE(148);
      END_STATE();
    case 439:
      if (lookahead == 'D') ADVANCE(435);
      if (lookahead == 'a') ADVANCE(807);
      if (lookahead == 'c') ADVANCE(605);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'f') ADVANCE(436);
      if (lookahead == 'g') ADVANCE(319);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'm') ADVANCE(537);
      if (lookahead == 'n') ADVANCE(1112);
      if (lookahead == 'o') ADVANCE(1129);
      if (lookahead == 'p') ADVANCE(618);
      if (lookahead == 'q') ADVANCE(800);
      if (lookahead == 'r') ADVANCE(434);
      if (lookahead == 's') ADVANCE(770);
      if (lookahead == 't') ADVANCE(354);
      if (lookahead == 'u') ADVANCE(1456);
      if (lookahead == 'x') ADVANCE(828);
      END_STATE();
    case 440:
      if (lookahead == 'D') ADVANCE(432);
      if (lookahead == 'a') ADVANCE(755);
      if (lookahead == 'c') ADVANCE(1645);
      if (lookahead == 'd') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(653);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(1579);
      if (lookahead == 'i') ADVANCE(844);
      if (lookahead == 'l') ADVANCE(808);
      if (lookahead == 'n') ADVANCE(1699);
      if (lookahead == 'o') ADVANCE(908);
      if (lookahead == 'p') ADVANCE(148);
      if (lookahead == 's') ADVANCE(789);
      if (lookahead == 'u') ADVANCE(292);
      END_STATE();
    case 441:
      if (lookahead == 'D') ADVANCE(455);
      END_STATE();
    case 442:
      if (lookahead == 'D') ADVANCE(2167);
      if (lookahead == 'H') ADVANCE(365);
      if (lookahead == 'U') ADVANCE(2167);
      if (lookahead == 'V') ADVANCE(366);
      if (lookahead == 'b') ADVANCE(1594);
      if (lookahead == 'd') ADVANCE(2167);
      if (lookahead == 'h') ADVANCE(365);
      if (lookahead == 'm') ADVANCE(1306);
      if (lookahead == 'p') ADVANCE(1439);
      if (lookahead == 't') ADVANCE(1295);
      if (lookahead == 'u') ADVANCE(2167);
      if (lookahead == 'v') ADVANCE(366);
      END_STATE();
    case 443:
      if (lookahead == 'D') ADVANCE(745);
      END_STATE();
    case 444:
      if (lookahead == 'D') ADVANCE(390);
      END_STATE();
    case 445:
      if (lookahead == 'D') ADVANCE(571);
      if (lookahead == 'H') ADVANCE(575);
      if (lookahead == 'a') ADVANCE(1668);
      if (lookahead == 'd') ADVANCE(571);
      if (lookahead == 'g') ADVANCE(2157);
      if (lookahead == 'i') ADVANCE(1513);
      if (lookahead == 'l') ADVANCE(402);
      if (lookahead == 'r') ADVANCE(403);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 446:
      if (lookahead == 'D') ADVANCE(571);
      if (lookahead == 'b') ADVANCE(538);
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'd') ADVANCE(574);
      if (lookahead == 'e') ADVANCE(920);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 'v') ADVANCE(888);
      END_STATE();
    case 447:
      if (lookahead == 'D') ADVANCE(571);
      if (lookahead == 'd') ADVANCE(571);
      END_STATE();
    case 448:
      if (lookahead == 'D') ADVANCE(1643);
      if (lookahead == 'L') ADVANCE(1065);
      if (lookahead == 'R') ADVANCE(1316);
      if (lookahead == 'U') ADVANCE(1687);
      END_STATE();
    case 449:
      if (lookahead == 'D') ADVANCE(1245);
      END_STATE();
    case 450:
      if (lookahead == 'D') ADVANCE(1011);
      END_STATE();
    case 451:
      if (lookahead == 'D') ADVANCE(1651);
      if (lookahead == 'E') ADVANCE(1731);
      END_STATE();
    case 452:
      if (lookahead == 'D') ADVANCE(1655);
      if (lookahead == 'T') ADVANCE(1030);
      if (lookahead == 'V') ADVANCE(1058);
      END_STATE();
    case 453:
      if (lookahead == 'D') ADVANCE(1665);
      if (lookahead == 'Q') ADVANCE(2089);
      END_STATE();
    case 454:
      if (lookahead == 'E') ADVANCE(1389);
      if (lookahead == 'M') ADVANCE(183);
      if (lookahead == 'a') ADVANCE(803);
      if (lookahead == 'b') ADVANCE(1740);
      if (lookahead == 'c') ADVANCE(1261);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(1802);
      if (lookahead == 'l') ADVANCE(1670);
      if (lookahead == 'm') ADVANCE(533);
      if (lookahead == 'n') ADVANCE(872);
      if (lookahead == 'o') ADVANCE(1129);
      if (lookahead == 'p') ADVANCE(1695);
      if (lookahead == 'r') ADVANCE(1236);
      if (lookahead == 's') ADVANCE(787);
      if (lookahead == 't') ADVANCE(1283);
      if (lookahead == 'u') ADVANCE(1455);
      END_STATE();
    case 455:
      if (lookahead == 'E') ADVANCE(148);
      END_STATE();
    case 456:
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1668);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 457:
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1686);
      if (lookahead == 'e') ADVANCE(316);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 458:
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'e') ADVANCE(315);
      if (lookahead == 's') ADVANCE(1246);
      if (lookahead == 't') ADVANCE(318);
      END_STATE();
    case 459:
      if (lookahead == 'E') ADVANCE(1362);
      if (lookahead == 'U') ADVANCE(1718);
      END_STATE();
    case 460:
      if (lookahead == 'E') ADVANCE(745);
      if (lookahead == 'J') ADVANCE(1395);
      if (lookahead == 'O') ADVANCE(745);
      if (lookahead == 'a') ADVANCE(803);
      if (lookahead == 'c') ADVANCE(1261);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(1802);
      if (lookahead == 'm') ADVANCE(188);
      if (lookahead == 'n') ADVANCE(1977);
      if (lookahead == 'o') ADVANCE(1130);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 't') ADVANCE(1309);
      if (lookahead == 'u') ADVANCE(1338);
      END_STATE();
    case 461:
      if (lookahead == 'E') ADVANCE(1361);
      END_STATE();
    case 462:
      if (lookahead == 'E') ADVANCE(1395);
      if (lookahead == 'a') ADVANCE(803);
      if (lookahead == 'c') ADVANCE(1261);
      if (lookahead == 'd') ADVANCE(743);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(1802);
      if (lookahead == 'm') ADVANCE(535);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'p') ADVANCE(981);
      if (lookahead == 'r') ADVANCE(148);
      if (lookahead == 's') ADVANCE(784);
      if (lookahead == 't') ADVANCE(1230);
      if (lookahead == 'u') ADVANCE(1455);
      if (lookahead == 'v') ADVANCE(996);
      END_STATE();
    case 463:
      if (lookahead == 'E') ADVANCE(1734);
      END_STATE();
    case 464:
      if (lookahead == 'E') ADVANCE(1731);
      END_STATE();
    case 465:
      if (lookahead == 'E') ADVANCE(1736);
      if (lookahead == 'F') ADVANCE(2088);
      if (lookahead == 'G') ADVANCE(1881);
      if (lookahead == 'L') ADVANCE(963);
      if (lookahead == 'S') ADVANCE(1449);
      if (lookahead == 'T') ADVANCE(1309);
      END_STATE();
    case 466:
      if (lookahead == 'E') ADVANCE(1737);
      if (lookahead == 'F') ADVANCE(2088);
      if (lookahead == 'G') ADVANCE(1881);
      if (lookahead == 'L') ADVANCE(963);
      if (lookahead == 'S') ADVANCE(1449);
      if (lookahead == 'T') ADVANCE(1309);
      END_STATE();
    case 467:
      if (lookahead == 'F') ADVANCE(510);
      END_STATE();
    case 468:
      if (lookahead == 'F') ADVANCE(2082);
      END_STATE();
    case 469:
      if (lookahead == 'G') ADVANCE(148);
      END_STATE();
    case 470:
      if (lookahead == 'G') ADVANCE(1113);
      if (lookahead == 'L') ADVANCE(1044);
      if (lookahead == 'R') ADVANCE(1308);
      if (lookahead == 'V') ADVANCE(447);
      if (lookahead == 'a') ADVANCE(727);
      if (lookahead == 'b') ADVANCE(1896);
      if (lookahead == 'c') ADVANCE(558);
      if (lookahead == 'd') ADVANCE(571);
      if (lookahead == 'e') ADVANCE(150);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(458);
      if (lookahead == 'h') ADVANCE(397);
      if (lookahead == 'i') ADVANCE(324);
      if (lookahead == 'j') ADVANCE(745);
      if (lookahead == 'l') ADVANCE(392);
      if (lookahead == 'm') ADVANCE(1213);
      if (lookahead == 'o') ADVANCE(311);
      if (lookahead == 'p') ADVANCE(626);
      if (lookahead == 'r') ADVANCE(401);
      if (lookahead == 's') ADVANCE(762);
      if (lookahead == 't') ADVANCE(1133);
      if (lookahead == 'u') ADVANCE(295);
      if (lookahead == 'v') ADVANCE(445);
      if (lookahead == 'w') ADVANCE(400);
      END_STATE();
    case 471:
      if (lookahead == 'G') ADVANCE(1881);
      END_STATE();
    case 472:
      if (lookahead == 'G') ADVANCE(1890);
      if (lookahead == 'L') ADVANCE(1046);
      END_STATE();
    case 473:
      if (lookahead == 'H') ADVANCE(423);
      if (lookahead == 'O') ADVANCE(467);
      if (lookahead == 'a') ADVANCE(809);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(1646);
      if (lookahead == 'i') ADVANCE(1131);
      if (lookahead == 'm') ADVANCE(651);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'q') ADVANCE(1767);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 't') ADVANCE(538);
      if (lookahead == 'u') ADVANCE(711);
      END_STATE();
    case 474:
      if (lookahead == 'H') ADVANCE(495);
      if (lookahead == 'R') ADVANCE(388);
      if (lookahead == 'S') ADVANCE(479);
      if (lookahead == 'a') ADVANCE(2154);
      if (lookahead == 'c') ADVANCE(604);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(951);
      if (lookahead == 'i') ADVANCE(1377);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'r') ADVANCE(1288);
      if (lookahead == 's') ADVANCE(790);
      END_STATE();
    case 475:
      if (lookahead == 'H') ADVANCE(745);
      END_STATE();
    case 476:
      if (lookahead == 'H') ADVANCE(745);
      if (lookahead == 'J') ADVANCE(745);
      if (lookahead == 'a') ADVANCE(1692);
      if (lookahead == 'c') ADVANCE(972);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 477:
      if (lookahead == 'H') ADVANCE(745);
      if (lookahead == 'O') ADVANCE(496);
      if (lookahead == 'a') ADVANCE(815);
      if (lookahead == 'c') ADVANCE(603);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(905);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(1214);
      if (lookahead == 'i') ADVANCE(1788);
      if (lookahead == 'l') ADVANCE(1593);
      if (lookahead == 'o') ADVANCE(1433);
      if (lookahead == 'r') ADVANCE(1595);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 'u') ADVANCE(1678);
      END_STATE();
    case 478:
      if (lookahead == 'H') ADVANCE(745);
      if (lookahead == 'a') ADVANCE(809);
      if (lookahead == 'c') ADVANCE(607);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(1798);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 479:
      if (lookahead == 'H') ADVANCE(745);
      if (lookahead == 'c') ADVANCE(2129);
      END_STATE();
    case 480:
      if (lookahead == 'H') ADVANCE(2090);
      END_STATE();
    case 481:
      if (lookahead == 'I') ADVANCE(148);
      END_STATE();
    case 482:
      if (lookahead == 'I') ADVANCE(1489);
      END_STATE();
    case 483:
      if (lookahead == 'I') ADVANCE(1556);
      END_STATE();
    case 484:
      if (lookahead == 'J') ADVANCE(745);
      if (lookahead == 'a') ADVANCE(809);
      if (lookahead == 'c') ADVANCE(604);
      if (lookahead == 'e') ADVANCE(1134);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(421);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 't') ADVANCE(1283);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 485:
      if (lookahead == 'L') ADVANCE(963);
      END_STATE();
    case 486:
      if (lookahead == 'L') ADVANCE(1263);
      END_STATE();
    case 487:
      if (lookahead == 'L') ADVANCE(1061);
      if (lookahead == 'R') ADVANCE(1316);
      END_STATE();
    case 488:
      if (lookahead == 'L') ADVANCE(1061);
      if (lookahead == 'R') ADVANCE(1316);
      if (lookahead == 'l') ADVANCE(1043);
      if (lookahead == 'r') ADVANCE(1308);
      END_STATE();
    case 489:
      if (lookahead == 'L') ADVANCE(1065);
      if (lookahead == 'R') ADVANCE(1316);
      END_STATE();
    case 490:
      if (lookahead == 'M') ADVANCE(1047);
      if (lookahead == 'T') ADVANCE(1196);
      if (lookahead == 'V') ADVANCE(1035);
      END_STATE();
    case 491:
      if (lookahead == 'M') ADVANCE(1306);
      END_STATE();
    case 492:
      if (lookahead == 'N') ADVANCE(1589);
      if (lookahead == 'a') ADVANCE(799);
      if (lookahead == 'b') ADVANCE(1784);
      if (lookahead == 'c') ADVANCE(1610);
      if (lookahead == 'd') ADVANCE(1730);
      if (lookahead == 'e') ADVANCE(864);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(1114);
      if (lookahead == 'k') ADVANCE(669);
      if (lookahead == 'l') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(929);
      if (lookahead == 'o') ADVANCE(1676);
      if (lookahead == 'p') ADVANCE(1811);
      if (lookahead == 'r') ADVANCE(927);
      if (lookahead == 's') ADVANCE(771);
      if (lookahead == 'u') ADVANCE(1396);
      END_STATE();
    case 493:
      if (lookahead == 'N') ADVANCE(469);
      if (lookahead == 'T') ADVANCE(177);
      if (lookahead == 'a') ADVANCE(803);
      if (lookahead == 'c') ADVANCE(606);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(1802);
      if (lookahead == 'l') ADVANCE(1048);
      if (lookahead == 'm') ADVANCE(536);
      if (lookahead == 'o') ADVANCE(1129);
      if (lookahead == 'p') ADVANCE(1945);
      if (lookahead == 'q') ADVANCE(2042);
      if (lookahead == 's') ADVANCE(779);
      if (lookahead == 't') ADVANCE(524);
      if (lookahead == 'u') ADVANCE(1455);
      if (lookahead == 'x') ADVANCE(1239);
      END_STATE();
    case 494:
      if (lookahead == 'O') ADVANCE(185);
      END_STATE();
    case 495:
      if (lookahead == 'O') ADVANCE(501);
      END_STATE();
    case 496:
      if (lookahead == 'P') ADVANCE(187);
      END_STATE();
    case 497:
      if (lookahead == 'P') ADVANCE(538);
      END_STATE();
    case 498:
      if (lookahead == 'P') ADVANCE(538);
      if (lookahead == 'i') ADVANCE(361);
      END_STATE();
    case 499:
      if (lookahead == 'P') ADVANCE(1439);
      END_STATE();
    case 500:
      if (lookahead == 'Q') ADVANCE(2089);
      END_STATE();
    case 501:
      if (lookahead == 'R') ADVANCE(182);
      END_STATE();
    case 502:
      if (lookahead == 'R') ADVANCE(443);
      END_STATE();
    case 503:
      if (lookahead == 'R') ADVANCE(1319);
      if (lookahead == 'T') ADVANCE(1030);
      if (lookahead == 'V') ADVANCE(1058);
      END_STATE();
    case 504:
      if (lookahead == 'S') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(806);
      if (lookahead == 'c') ADVANCE(1261);
      if (lookahead == 'd') ADVANCE(572);
      if (lookahead == 'e') ADVANCE(1395);
      if (lookahead == 'f') ADVANCE(842);
      if (lookahead == 'g') ADVANCE(1621);
      if (lookahead == 'h') ADVANCE(718);
      if (lookahead == 'i') ADVANCE(1507);
      if (lookahead == 'l') ADVANCE(578);
      if (lookahead == 'm') ADVANCE(534);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'p') ADVANCE(539);
      if (lookahead == 'r') ADVANCE(198);
      if (lookahead == 's') ADVANCE(785);
      if (lookahead == 't') ADVANCE(1278);
      if (lookahead == 'u') ADVANCE(1455);
      if (lookahead == 'v') ADVANCE(716);
      END_STATE();
    case 505:
      if (lookahead == 'S') ADVANCE(1493);
      END_STATE();
    case 506:
      if (lookahead == 'S') ADVANCE(1493);
      if (lookahead == 'V') ADVANCE(1033);
      END_STATE();
    case 507:
      if (lookahead == 'S') ADVANCE(1711);
      END_STATE();
    case 508:
      if (lookahead == 'S') ADVANCE(2052);
      END_STATE();
    case 509:
      if (lookahead == 'S') ADVANCE(1738);
      END_STATE();
    case 510:
      if (lookahead == 'T') ADVANCE(745);
      END_STATE();
    case 511:
      if (lookahead == 'T') ADVANCE(386);
      END_STATE();
    case 512:
      if (lookahead == 'T') ADVANCE(1210);
      END_STATE();
    case 513:
      if (lookahead == 'T') ADVANCE(1191);
      END_STATE();
    case 514:
      if (lookahead == 'T') ADVANCE(1030);
      if (lookahead == 'V') ADVANCE(1058);
      END_STATE();
    case 515:
      if (lookahead == 'T') ADVANCE(1892);
      END_STATE();
    case 516:
      if (lookahead == 'U') ADVANCE(494);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 517:
      if (lookahead == 'V') ADVANCE(1077);
      END_STATE();
    case 518:
      if (lookahead == 'V') ADVANCE(1063);
      END_STATE();
    case 519:
      if (lookahead == 'W') ADVANCE(1265);
      END_STATE();
    case 520:
      if (lookahead == '[') ADVANCE(2235);
      END_STATE();
    case 521:
      if (lookahead == 'a') ADVANCE(803);
      if (lookahead == 'b') ADVANCE(1740);
      if (lookahead == 'c') ADVANCE(364);
      if (lookahead == 'e') ADVANCE(1389);
      if (lookahead == 'f') ADVANCE(318);
      if (lookahead == 'g') ADVANCE(1802);
      if (lookahead == 'l') ADVANCE(928);
      if (lookahead == 'm') ADVANCE(193);
      if (lookahead == 'n') ADVANCE(876);
      if (lookahead == 'o') ADVANCE(1129);
      if (lookahead == 'p') ADVANCE(349);
      if (lookahead == 'r') ADVANCE(1236);
      if (lookahead == 's') ADVANCE(788);
      if (lookahead == 't') ADVANCE(1283);
      if (lookahead == 'u') ADVANCE(1455);
      if (lookahead == 'w') ADVANCE(824);
      END_STATE();
    case 522:
      if (lookahead == 'a') ADVANCE(803);
      if (lookahead == 'c') ADVANCE(280);
      if (lookahead == 'e') ADVANCE(752);
      if (lookahead == 'f') ADVANCE(2158);
      if (lookahead == 'g') ADVANCE(1802);
      if (lookahead == 'i') ADVANCE(278);
      if (lookahead == 'j') ADVANCE(1395);
      if (lookahead == 'm') ADVANCE(530);
      if (lookahead == 'n') ADVANCE(232);
      if (lookahead == 'o') ADVANCE(749);
      if (lookahead == 'p') ADVANCE(1801);
      if (lookahead == 'q') ADVANCE(2057);
      if (lookahead == 's') ADVANCE(781);
      if (lookahead == 't') ADVANCE(285);
      if (lookahead == 'u') ADVANCE(1338);
      END_STATE();
    case 523:
      if (lookahead == 'a') ADVANCE(795);
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'e') ADVANCE(830);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'r') ADVANCE(926);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 'u') ADVANCE(1466);
      END_STATE();
    case 524:
      if (lookahead == 'a') ADVANCE(148);
      END_STATE();
    case 525:
      if (lookahead == 'a') ADVANCE(318);
      END_STATE();
    case 526:
      if (lookahead == 'a') ADVANCE(1730);
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(1460);
      if (lookahead == 'q') ADVANCE(710);
      if (lookahead == 't') ADVANCE(1812);
      END_STATE();
    case 527:
      if (lookahead == 'a') ADVANCE(1730);
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(148);
      if (lookahead == 'q') ADVANCE(710);
      END_STATE();
    case 528:
      if (lookahead == 'a') ADVANCE(814);
      if (lookahead == 'c') ADVANCE(553);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(898);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(747);
      if (lookahead == 'i') ADVANCE(1745);
      if (lookahead == 'l') ADVANCE(2047);
      if (lookahead == 'o') ADVANCE(1443);
      if (lookahead == 'r') ADVANCE(584);
      if (lookahead == 's') ADVANCE(791);
      if (lookahead == 't') ADVANCE(867);
      if (lookahead == 'u') ADVANCE(915);
      if (lookahead == 'w') ADVANCE(824);
      if (lookahead == 'y') ADVANCE(1386);
      END_STATE();
    case 529:
      if (lookahead == 'a') ADVANCE(2104);
      END_STATE();
    case 530:
      if (lookahead == 'a') ADVANCE(774);
      if (lookahead == 'o') ADVANCE(1087);
      if (lookahead == 'p') ADVANCE(916);
      END_STATE();
    case 531:
      if (lookahead == 'a') ADVANCE(1403);
      if (lookahead == 'e') ADVANCE(1716);
      if (lookahead == 'i') ADVANCE(874);
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 532:
      if (lookahead == 'a') ADVANCE(359);
      END_STATE();
    case 533:
      if (lookahead == 'a') ADVANCE(769);
      END_STATE();
    case 534:
      if (lookahead == 'a') ADVANCE(769);
      if (lookahead == 'e') ADVANCE(1122);
      if (lookahead == 'i') ADVANCE(836);
      END_STATE();
    case 535:
      if (lookahead == 'a') ADVANCE(769);
      if (lookahead == 'e') ADVANCE(1122);
      if (lookahead == 'i') ADVANCE(835);
      END_STATE();
    case 536:
      if (lookahead == 'a') ADVANCE(769);
      if (lookahead == 'p') ADVANCE(1976);
      END_STATE();
    case 537:
      if (lookahead == 'a') ADVANCE(769);
      if (lookahead == 'p') ADVANCE(1984);
      if (lookahead == 's') ADVANCE(1681);
      END_STATE();
    case 538:
      if (lookahead == 'a') ADVANCE(1741);
      END_STATE();
    case 539:
      if (lookahead == 'a') ADVANCE(1741);
      if (lookahead == 'e') ADVANCE(1789);
      if (lookahead == 'l') ADVANCE(2056);
      END_STATE();
    case 540:
      if (lookahead == 'a') ADVANCE(1741);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(2056);
      END_STATE();
    case 541:
      if (lookahead == 'a') ADVANCE(1741);
      if (lookahead == 'r') ADVANCE(619);
      END_STATE();
    case 542:
      if (lookahead == 'a') ADVANCE(805);
      if (lookahead == 'b') ADVANCE(1763);
      if (lookahead == 'c') ADVANCE(1261);
      if (lookahead == 'd') ADVANCE(743);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(1802);
      if (lookahead == 'm') ADVANCE(533);
      if (lookahead == 'n') ADVANCE(886);
      if (lookahead == 'o') ADVANCE(1129);
      if (lookahead == 'p') ADVANCE(404);
      if (lookahead == 'r') ADVANCE(1251);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 't') ADVANCE(1309);
      if (lookahead == 'u') ADVANCE(1455);
      END_STATE();
    case 543:
      if (lookahead == 'a') ADVANCE(1507);
      END_STATE();
    case 544:
      if (lookahead == 'a') ADVANCE(345);
      END_STATE();
    case 545:
      if (lookahead == 'a') ADVANCE(1866);
      if (lookahead == 'b') ADVANCE(1795);
      if (lookahead == 'c') ADVANCE(604);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(1444);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(958);
      if (lookahead == 'i') ADVANCE(1432);
      if (lookahead == 'o') ADVANCE(949);
      if (lookahead == 'p') ADVANCE(1811);
      if (lookahead == 'r') ADVANCE(656);
      if (lookahead == 's') ADVANCE(760);
      if (lookahead == 'w') ADVANCE(1218);
      END_STATE();
    case 546:
      if (lookahead == 'a') ADVANCE(1517);
      if (lookahead == 'b') ADVANCE(1795);
      if (lookahead == 'n') ADVANCE(1120);
      if (lookahead == 'o') ADVANCE(1717);
      if (lookahead == 'p') ADVANCE(540);
      if (lookahead == 't') ADVANCE(1295);
      if (lookahead == 'w') ADVANCE(588);
      if (lookahead == 'z') ADVANCE(260);
      END_STATE();
    case 547:
      if (lookahead == 'a') ADVANCE(1517);
      if (lookahead == 'b') ADVANCE(1795);
      if (lookahead == 'p') ADVANCE(540);
      if (lookahead == 't') ADVANCE(1295);
      END_STATE();
    case 548:
      if (lookahead == 'a') ADVANCE(1949);
      END_STATE();
    case 549:
      if (lookahead == 'a') ADVANCE(1949);
      if (lookahead == 'l') ADVANCE(1243);
      if (lookahead == 't') ADVANCE(1523);
      END_STATE();
    case 550:
      if (lookahead == 'a') ADVANCE(858);
      if (lookahead == 'f') ADVANCE(1098);
      END_STATE();
    case 551:
      if (lookahead == 'a') ADVANCE(825);
      if (lookahead == 'k') ADVANCE(140);
      if (lookahead == 'o') ADVANCE(818);
      END_STATE();
    case 552:
      if (lookahead == 'a') ADVANCE(235);
      END_STATE();
    case 553:
      if (lookahead == 'a') ADVANCE(1693);
      if (lookahead == 'e') ADVANCE(897);
      if (lookahead == 'i') ADVANCE(1808);
      if (lookahead == 'u') ADVANCE(1701);
      END_STATE();
    case 554:
      if (lookahead == 'a') ADVANCE(909);
      END_STATE();
    case 555:
      if (lookahead == 'a') ADVANCE(326);
      END_STATE();
    case 556:
      if (lookahead == 'a') ADVANCE(2102);
      END_STATE();
    case 557:
      if (lookahead == 'a') ADVANCE(765);
      if (lookahead == 'o') ADVANCE(2117);
      END_STATE();
    case 558:
      if (lookahead == 'a') ADVANCE(1669);
      if (lookahead == 'e') ADVANCE(912);
      if (lookahead == 'o') ADVANCE(1530);
      if (lookahead == 'u') ADVANCE(1668);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 559:
      if (lookahead == 'a') ADVANCE(333);
      END_STATE();
    case 560:
      if (lookahead == 'a') ADVANCE(764);
      if (lookahead == 'c') ADVANCE(1282);
      if (lookahead == 'e') ADVANCE(297);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(745);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 'u') ADVANCE(751);
      END_STATE();
    case 561:
      if (lookahead == 'a') ADVANCE(1791);
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(1214);
      if (lookahead == 'i') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(2051);
      if (lookahead == 'o') ADVANCE(1279);
      if (lookahead == 'r') ADVANCE(253);
      if (lookahead == 's') ADVANCE(778);
      END_STATE();
    case 562:
      if (lookahead == 'a') ADVANCE(1692);
      END_STATE();
    case 563:
      if (lookahead == 'a') ADVANCE(1704);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(1725);
      if (lookahead == 'l') ADVANCE(963);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 564:
      if (lookahead == 'a') ADVANCE(1668);
      END_STATE();
    case 565:
      if (lookahead == 'a') ADVANCE(1668);
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'e') ADVANCE(893);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(1547);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 566:
      if (lookahead == 'a') ADVANCE(1668);
      if (lookahead == 'i') ADVANCE(1808);
      if (lookahead == 'u') ADVANCE(1668);
      END_STATE();
    case 567:
      if (lookahead == 'a') ADVANCE(1668);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 568:
      if (lookahead == 'a') ADVANCE(1668);
      if (lookahead == 'u') ADVANCE(1668);
      END_STATE();
    case 569:
      if (lookahead == 'a') ADVANCE(1111);
      END_STATE();
    case 570:
      if (lookahead == 'a') ADVANCE(1451);
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'e') ADVANCE(1481);
      if (lookahead == 'f') ADVANCE(1276);
      if (lookahead == 'i') ADVANCE(1395);
      if (lookahead == 'j') ADVANCE(1395);
      if (lookahead == 'l') ADVANCE(549);
      if (lookahead == 'n') ADVANCE(1581);
      if (lookahead == 'o') ADVANCE(1672);
      if (lookahead == 'p') ADVANCE(659);
      if (lookahead == 'r') ADVANCE(557);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 571:
      if (lookahead == 'a') ADVANCE(1915);
      END_STATE();
    case 572:
      if (lookahead == 'a') ADVANCE(1915);
      if (lookahead == 'b') ADVANCE(1429);
      if (lookahead == 'i') ADVANCE(2099);
      if (lookahead == 'o') ADVANCE(1949);
      if (lookahead == 's') ADVANCE(1631);
      END_STATE();
    case 573:
      if (lookahead == 'a') ADVANCE(1330);
      END_STATE();
    case 574:
      if (lookahead == 'a') ADVANCE(1918);
      END_STATE();
    case 575:
      if (lookahead == 'a') ADVANCE(1760);
      END_STATE();
    case 576:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'b') ADVANCE(1795);
      if (lookahead == 'r') ADVANCE(609);
      END_STATE();
    case 577:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'b') ADVANCE(1429);
      if (lookahead == 'h') ADVANCE(538);
      END_STATE();
    case 578:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'c') ADVANCE(1225);
      if (lookahead == 'i') ADVANCE(1529);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 579:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'c') ADVANCE(1640);
      if (lookahead == 'h') ADVANCE(640);
      if (lookahead == 'm') ADVANCE(148);
      if (lookahead == 't') ADVANCE(1776);
      END_STATE();
    case 580:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'h') ADVANCE(538);
      END_STATE();
    case 581:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'h') ADVANCE(538);
      if (lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 582:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'm') ADVANCE(287);
      END_STATE();
    case 583:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'm') ADVANCE(1991);
      if (lookahead == 'o') ADVANCE(1333);
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 'r') ADVANCE(716);
      END_STATE();
    case 584:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'o') ADVANCE(1920);
      END_STATE();
    case 585:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'r') ADVANCE(1741);
      if (lookahead == 't') ADVANCE(670);
      END_STATE();
    case 586:
      if (lookahead == 'a') ADVANCE(1458);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'g') ADVANCE(652);
      if (lookahead == 's') ADVANCE(1258);
      if (lookahead == 'v') ADVANCE(279);
      END_STATE();
    case 587:
      if (lookahead == 'a') ADVANCE(2140);
      END_STATE();
    case 588:
      if (lookahead == 'a') ADVANCE(1905);
      if (lookahead == 'b') ADVANCE(538);
      END_STATE();
    case 589:
      if (lookahead == 'a') ADVANCE(1528);
      END_STATE();
    case 590:
      if (lookahead == 'a') ADVANCE(1988);
      END_STATE();
    case 591:
      if (lookahead == 'a') ADVANCE(1349);
      END_STATE();
    case 592:
      if (lookahead == 'a') ADVANCE(1747);
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'e') ADVANCE(1748);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(1228);
      if (lookahead == 'i') ADVANCE(339);
      if (lookahead == 'l') ADVANCE(608);
      if (lookahead == 'm') ADVANCE(148);
      if (lookahead == 'o') ADVANCE(1289);
      if (lookahead == 'r') ADVANCE(164);
      if (lookahead == 's') ADVANCE(778);
      if (lookahead == 'u') ADVANCE(1527);
      END_STATE();
    case 593:
      if (lookahead == 'a') ADVANCE(1982);
      if (lookahead == 'e') ADVANCE(1929);
      if (lookahead == 'o') ADVANCE(333);
      END_STATE();
    case 594:
      if (lookahead == 'a') ADVANCE(1173);
      END_STATE();
    case 595:
      if (lookahead == 'a') ADVANCE(1347);
      END_STATE();
    case 596:
      if (lookahead == 'a') ADVANCE(1372);
      if (lookahead == 'l') ADVANCE(1263);
      if (lookahead == 's') ADVANCE(2076);
      END_STATE();
    case 597:
      if (lookahead == 'a') ADVANCE(1795);
      END_STATE();
    case 598:
      if (lookahead == 'a') ADVANCE(1908);
      END_STATE();
    case 599:
      if (lookahead == 'a') ADVANCE(1495);
      END_STATE();
    case 600:
      if (lookahead == 'a') ADVANCE(753);
      END_STATE();
    case 601:
      if (lookahead == 'a') ADVANCE(1529);
      END_STATE();
    case 602:
      if (lookahead == 'a') ADVANCE(1794);
      if (lookahead == 'e') ADVANCE(913);
      if (lookahead == 'u') ADVANCE(709);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 603:
      if (lookahead == 'a') ADVANCE(1794);
      if (lookahead == 'e') ADVANCE(897);
      if (lookahead == 'i') ADVANCE(1808);
      if (lookahead == 'o') ADVANCE(1557);
      END_STATE();
    case 604:
      if (lookahead == 'a') ADVANCE(1794);
      if (lookahead == 'e') ADVANCE(912);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 605:
      if (lookahead == 'a') ADVANCE(1794);
      if (lookahead == 'i') ADVANCE(1771);
      if (lookahead == 'o') ADVANCE(1379);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 606:
      if (lookahead == 'a') ADVANCE(1794);
      if (lookahead == 'i') ADVANCE(1771);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 607:
      if (lookahead == 'a') ADVANCE(1794);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 608:
      if (lookahead == 'a') ADVANCE(1501);
      if (lookahead == 'u') ADVANCE(1899);
      END_STATE();
    case 609:
      if (lookahead == 'a') ADVANCE(767);
      if (lookahead == 'k') ADVANCE(921);
      END_STATE();
    case 610:
      if (lookahead == 'a') ADVANCE(1690);
      if (lookahead == 'u') ADVANCE(1690);
      END_STATE();
    case 611:
      if (lookahead == 'a') ADVANCE(878);
      END_STATE();
    case 612:
      if (lookahead == 'a') ADVANCE(1366);
      END_STATE();
    case 613:
      if (lookahead == 'a') ADVANCE(1366);
      if (lookahead == 'i') ADVANCE(1411);
      END_STATE();
    case 614:
      if (lookahead == 'a') ADVANCE(1750);
      END_STATE();
    case 615:
      if (lookahead == 'a') ADVANCE(1750);
      if (lookahead == 'b') ADVANCE(1380);
      END_STATE();
    case 616:
      if (lookahead == 'a') ADVANCE(1385);
      END_STATE();
    case 617:
      if (lookahead == 'a') ADVANCE(1385);
      if (lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'i') ADVANCE(2101);
      END_STATE();
    case 618:
      if (lookahead == 'a') ADVANCE(1785);
      if (lookahead == 'l') ADVANCE(2056);
      if (lookahead == 's') ADVANCE(1221);
      END_STATE();
    case 619:
      if (lookahead == 'a') ADVANCE(768);
      END_STATE();
    case 620:
      if (lookahead == 'a') ADVANCE(1780);
      if (lookahead == 'b') ADVANCE(1380);
      END_STATE();
    case 621:
      if (lookahead == 'a') ADVANCE(1780);
      if (lookahead == 'o') ADVANCE(345);
      END_STATE();
    case 622:
      if (lookahead == 'a') ADVANCE(1712);
      END_STATE();
    case 623:
      if (lookahead == 'a') ADVANCE(853);
      END_STATE();
    case 624:
      if (lookahead == 'a') ADVANCE(1778);
      END_STATE();
    case 625:
      if (lookahead == 'a') ADVANCE(1378);
      END_STATE();
    case 626:
      if (lookahead == 'a') ADVANCE(1770);
      if (lookahead == 'o') ADVANCE(1445);
      if (lookahead == 'r') ADVANCE(230);
      END_STATE();
    case 627:
      if (lookahead == 'a') ADVANCE(1376);
      END_STATE();
    case 628:
      if (lookahead == 'a') ADVANCE(1765);
      if (lookahead == 'p') ADVANCE(1664);
      END_STATE();
    case 629:
      if (lookahead == 'a') ADVANCE(1751);
      if (lookahead == 'r') ADVANCE(700);
      END_STATE();
    case 630:
      if (lookahead == 'a') ADVANCE(1356);
      END_STATE();
    case 631:
      if (lookahead == 'a') ADVANCE(1764);
      END_STATE();
    case 632:
      if (lookahead == 'a') ADVANCE(1364);
      END_STATE();
    case 633:
      if (lookahead == 'a') ADVANCE(1351);
      END_STATE();
    case 634:
      if (lookahead == 'a') ADVANCE(1357);
      END_STATE();
    case 635:
      if (lookahead == 'a') ADVANCE(1352);
      END_STATE();
    case 636:
      if (lookahead == 'a') ADVANCE(1818);
      END_STATE();
    case 637:
      if (lookahead == 'a') ADVANCE(1370);
      END_STATE();
    case 638:
      if (lookahead == 'a') ADVANCE(1358);
      END_STATE();
    case 639:
      if (lookahead == 'a') ADVANCE(1739);
      END_STATE();
    case 640:
      if (lookahead == 'a') ADVANCE(1768);
      END_STATE();
    case 641:
      if (lookahead == 'a') ADVANCE(1744);
      END_STATE();
    case 642:
      if (lookahead == 'a') ADVANCE(1822);
      END_STATE();
    case 643:
      if (lookahead == 'a') ADVANCE(1766);
      END_STATE();
    case 644:
      if (lookahead == 'a') ADVANCE(2006);
      END_STATE();
    case 645:
      if (lookahead == 'a') ADVANCE(1833);
      END_STATE();
    case 646:
      if (lookahead == 'a') ADVANCE(1806);
      END_STATE();
    case 647:
      if (lookahead == 'a') ADVANCE(1797);
      END_STATE();
    case 648:
      if (lookahead == 'a') ADVANCE(1803);
      END_STATE();
    case 649:
      if (lookahead == 'a') ADVANCE(809);
      if (lookahead == 'b') ADVANCE(1730);
      if (lookahead == 'c') ADVANCE(353);
      if (lookahead == 'd') ADVANCE(1618);
      if (lookahead == 'e') ADVANCE(398);
      if (lookahead == 'f') ADVANCE(1761);
      if (lookahead == 'h') ADVANCE(207);
      if (lookahead == 'i') ADVANCE(1150);
      if (lookahead == 'l') ADVANCE(575);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'o') ADVANCE(1095);
      if (lookahead == 'p') ADVANCE(554);
      if (lookahead == 'q') ADVANCE(797);
      if (lookahead == 'r') ADVANCE(575);
      if (lookahead == 's') ADVANCE(772);
      if (lookahead == 't') ADVANCE(629);
      if (lookahead == 'u') ADVANCE(712);
      if (lookahead == 'w') ADVANCE(399);
      if (lookahead == 'z') ADVANCE(1389);
      END_STATE();
    case 650:
      if (lookahead == 'a') ADVANCE(809);
      if (lookahead == 'c') ADVANCE(607);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(1054);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(745);
      if (lookahead == 'i') ADVANCE(1144);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 'w') ADVANCE(1329);
      END_STATE();
    case 651:
      if (lookahead == 'a') ADVANCE(1401);
      END_STATE();
    case 652:
      if (lookahead == 'a') ADVANCE(1470);
      END_STATE();
    case 653:
      if (lookahead == 'a') ADVANCE(1927);
      END_STATE();
    case 654:
      if (lookahead == 'a') ADVANCE(1696);
      if (lookahead == 'c') ADVANCE(972);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(1805);
      if (lookahead == 'h') ADVANCE(745);
      if (lookahead == 'j') ADVANCE(745);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 655:
      if (lookahead == 'a') ADVANCE(847);
      END_STATE();
    case 656:
      if (lookahead == 'a') ADVANCE(894);
      if (lookahead == 'i') ADVANCE(701);
      if (lookahead == 'p') ADVANCE(956);
      END_STATE();
    case 657:
      if (lookahead == 'a') ADVANCE(1854);
      END_STATE();
    case 658:
      if (lookahead == 'a') ADVANCE(2003);
      END_STATE();
    case 659:
      if (lookahead == 'a') ADVANCE(1821);
      END_STATE();
    case 660:
      if (lookahead == 'a') ADVANCE(1703);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(1726);
      if (lookahead == 'g') ADVANCE(1969);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 661:
      if (lookahead == 'a') ADVANCE(1703);
      if (lookahead == 'e') ADVANCE(1729);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 662:
      if (lookahead == 'a') ADVANCE(1703);
      if (lookahead == 's') ADVANCE(1246);
      END_STATE();
    case 663:
      if (lookahead == 'a') ADVANCE(833);
      END_STATE();
    case 664:
      if (lookahead == 'a') ADVANCE(1855);
      if (lookahead == 'l') ADVANCE(2131);
      if (lookahead == 'r') ADVANCE(925);
      if (lookahead == 'v') ADVANCE(1074);
      END_STATE();
    case 665:
      if (lookahead == 'a') ADVANCE(1540);
      END_STATE();
    case 666:
      if (lookahead == 'a') ADVANCE(1391);
      if (lookahead == 'k') ADVANCE(345);
      END_STATE();
    case 667:
      if (lookahead == 'a') ADVANCE(2013);
      END_STATE();
    case 668:
      if (lookahead == 'a') ADVANCE(1867);
      if (lookahead == 'l') ADVANCE(1406);
      if (lookahead == 'r') ADVANCE(817);
      END_STATE();
    case 669:
      if (lookahead == 'a') ADVANCE(1817);
      END_STATE();
    case 670:
      if (lookahead == 'a') ADVANCE(1254);
      END_STATE();
    case 671:
      if (lookahead == 'a') ADVANCE(1254);
      if (lookahead == 'i') ADVANCE(1591);
      END_STATE();
    case 672:
      if (lookahead == 'a') ADVANCE(2067);
      END_STATE();
    case 673:
      if (lookahead == 'a') ADVANCE(1413);
      END_STATE();
    case 674:
      if (lookahead == 'a') ADVANCE(1858);
      END_STATE();
    case 675:
      if (lookahead == 'a') ADVANCE(2069);
      END_STATE();
    case 676:
      if (lookahead == 'a') ADVANCE(2021);
      END_STATE();
    case 677:
      if (lookahead == 'a') ADVANCE(1541);
      END_STATE();
    case 678:
      if (lookahead == 'a') ADVANCE(1860);
      END_STATE();
    case 679:
      if (lookahead == 'a') ADVANCE(1398);
      END_STATE();
    case 680:
      if (lookahead == 'a') ADVANCE(1850);
      END_STATE();
    case 681:
      if (lookahead == 'a') ADVANCE(1809);
      END_STATE();
    case 682:
      if (lookahead == 'a') ADVANCE(1856);
      END_STATE();
    case 683:
      if (lookahead == 'a') ADVANCE(1857);
      END_STATE();
    case 684:
      if (lookahead == 'a') ADVANCE(1448);
      END_STATE();
    case 685:
      if (lookahead == 'a') ADVANCE(1872);
      END_STATE();
    case 686:
      if (lookahead == 'a') ADVANCE(1872);
      if (lookahead == 'd') ADVANCE(1650);
      if (lookahead == 'h') ADVANCE(642);
      if (lookahead == 'l') ADVANCE(2056);
      if (lookahead == 's') ADVANCE(1223);
      if (lookahead == 'u') ADVANCE(1722);
      END_STATE();
    case 687:
      if (lookahead == 'a') ADVANCE(1872);
      if (lookahead == 'd') ADVANCE(1666);
      if (lookahead == 'h') ADVANCE(642);
      END_STATE();
    case 688:
      if (lookahead == 'a') ADVANCE(1872);
      if (lookahead == 'r') ADVANCE(1308);
      END_STATE();
    case 689:
      if (lookahead == 'a') ADVANCE(1883);
      END_STATE();
    case 690:
      if (lookahead == 'a') ADVANCE(2029);
      END_STATE();
    case 691:
      if (lookahead == 'a') ADVANCE(1877);
      if (lookahead == 'h') ADVANCE(702);
      if (lookahead == 'l') ADVANCE(1066);
      if (lookahead == 'r') ADVANCE(1323);
      if (lookahead == 's') ADVANCE(1733);
      if (lookahead == 't') ADVANCE(1211);
      END_STATE();
    case 692:
      if (lookahead == 'a') ADVANCE(1877);
      if (lookahead == 'h') ADVANCE(702);
      if (lookahead == 'l') ADVANCE(1086);
      if (lookahead == 'r') ADVANCE(1317);
      if (lookahead == 't') ADVANCE(1211);
      END_STATE();
    case 693:
      if (lookahead == 'a') ADVANCE(2031);
      END_STATE();
    case 694:
      if (lookahead == 'a') ADVANCE(1878);
      END_STATE();
    case 695:
      if (lookahead == 'a') ADVANCE(1878);
      if (lookahead == 'd') ADVANCE(2163);
      END_STATE();
    case 696:
      if (lookahead == 'a') ADVANCE(1879);
      END_STATE();
    case 697:
      if (lookahead == 'a') ADVANCE(1879);
      if (lookahead == 'h') ADVANCE(704);
      END_STATE();
    case 698:
      if (lookahead == 'a') ADVANCE(2033);
      END_STATE();
    case 699:
      if (lookahead == 'a') ADVANCE(1880);
      if (lookahead == 'h') ADVANCE(704);
      if (lookahead == 's') ADVANCE(1733);
      END_STATE();
    case 700:
      if (lookahead == 'a') ADVANCE(1313);
      if (lookahead == 'n') ADVANCE(1894);
      END_STATE();
    case 701:
      if (lookahead == 'a') ADVANCE(1562);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'm') ADVANCE(1306);
      if (lookahead == 'p') ADVANCE(1439);
      if (lookahead == 's') ADVANCE(709);
      if (lookahead == 't') ADVANCE(1291);
      END_STATE();
    case 702:
      if (lookahead == 'a') ADVANCE(1885);
      END_STATE();
    case 703:
      if (lookahead == 'a') ADVANCE(1569);
      END_STATE();
    case 704:
      if (lookahead == 'a') ADVANCE(1887);
      END_STATE();
    case 705:
      if (lookahead == 'a') ADVANCE(1570);
      END_STATE();
    case 706:
      if (lookahead == 'a') ADVANCE(1572);
      END_STATE();
    case 707:
      if (lookahead == 'a') ADVANCE(1573);
      END_STATE();
    case 708:
      if (lookahead == 'a') ADVANCE(1574);
      END_STATE();
    case 709:
      if (lookahead == 'b') ADVANCE(148);
      END_STATE();
    case 710:
      if (lookahead == 'b') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(1580);
      END_STATE();
    case 711:
      if (lookahead == 'b') ADVANCE(331);
      if (lookahead == 'c') ADVANCE(855);
      if (lookahead == 'm') ADVANCE(148);
      if (lookahead == 'p') ADVANCE(261);
      END_STATE();
    case 712:
      if (lookahead == 'b') ADVANCE(165);
      if (lookahead == 'c') ADVANCE(766);
      if (lookahead == 'm') ADVANCE(148);
      if (lookahead == 'n') ADVANCE(1111);
      if (lookahead == 'p') ADVANCE(2168);
      END_STATE();
    case 713:
      if (lookahead == 'b') ADVANCE(351);
      if (lookahead == 'c') ADVANCE(822);
      if (lookahead == 'p') ADVANCE(351);
      END_STATE();
    case 714:
      if (lookahead == 'b') ADVANCE(235);
      END_STATE();
    case 715:
      if (lookahead == 'b') ADVANCE(243);
      if (lookahead == 'p') ADVANCE(243);
      END_STATE();
    case 716:
      if (lookahead == 'b') ADVANCE(538);
      END_STATE();
    case 717:
      if (lookahead == 'b') ADVANCE(538);
      if (lookahead == 'g') ADVANCE(960);
      END_STATE();
    case 718:
      if (lookahead == 'b') ADVANCE(538);
      if (lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 719:
      if (lookahead == 'b') ADVANCE(538);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 720:
      if (lookahead == 'b') ADVANCE(538);
      if (lookahead == 't') ADVANCE(283);
      if (lookahead == 'y') ADVANCE(512);
      END_STATE();
    case 721:
      if (lookahead == 'b') ADVANCE(1345);
      if (lookahead == 'c') ADVANCE(1639);
      END_STATE();
    case 722:
      if (lookahead == 'b') ADVANCE(241);
      if (lookahead == 'p') ADVANCE(241);
      END_STATE();
    case 723:
      if (lookahead == 'b') ADVANCE(2085);
      if (lookahead == 'p') ADVANCE(1206);
      END_STATE();
    case 724:
      if (lookahead == 'b') ADVANCE(882);
      END_STATE();
    case 725:
      if (lookahead == 'b') ADVANCE(1795);
      END_STATE();
    case 726:
      if (lookahead == 'b') ADVANCE(917);
      if (lookahead == 'p') ADVANCE(917);
      END_STATE();
    case 727:
      if (lookahead == 'b') ADVANCE(1359);
      if (lookahead == 'c') ADVANCE(2086);
      if (lookahead == 'n') ADVANCE(1111);
      if (lookahead == 'p') ADVANCE(168);
      if (lookahead == 't') ADVANCE(2075);
      END_STATE();
    case 728:
      if (lookahead == 'b') ADVANCE(1900);
      END_STATE();
    case 729:
      if (lookahead == 'b') ADVANCE(525);
      END_STATE();
    case 730:
      if (lookahead == 'b') ADVANCE(1069);
      END_STATE();
    case 731:
      if (lookahead == 'b') ADVANCE(1502);
      if (lookahead == 'p') ADVANCE(1502);
      END_STATE();
    case 732:
      if (lookahead == 'b') ADVANCE(1944);
      if (lookahead == 'c') ADVANCE(854);
      if (lookahead == 'p') ADVANCE(1021);
      END_STATE();
    case 733:
      if (lookahead == 'b') ADVANCE(1944);
      if (lookahead == 'p') ADVANCE(1021);
      END_STATE();
    case 734:
      if (lookahead == 'b') ADVANCE(1415);
      END_STATE();
    case 735:
      if (lookahead == 'b') ADVANCE(1418);
      END_STATE();
    case 736:
      if (lookahead == 'b') ADVANCE(1861);
      END_STATE();
    case 737:
      if (lookahead == 'b') ADVANCE(1421);
      END_STATE();
    case 738:
      if (lookahead == 'b') ADVANCE(1422);
      END_STATE();
    case 739:
      if (lookahead == 'b') ADVANCE(1436);
      END_STATE();
    case 740:
      if (lookahead == 'b') ADVANCE(648);
      END_STATE();
    case 741:
      if (lookahead == 'b') ADVANCE(1427);
      END_STATE();
    case 742:
      if (lookahead == 'b') ADVANCE(1428);
      END_STATE();
    case 743:
      if (lookahead == 'b') ADVANCE(1429);
      END_STATE();
    case 744:
      if (lookahead == 'b') ADVANCE(1947);
      if (lookahead == 'p') ADVANCE(1947);
      END_STATE();
    case 745:
      if (lookahead == 'c') ADVANCE(2129);
      END_STATE();
    case 746:
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'e') ADVANCE(2104);
      END_STATE();
    case 747:
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'e') ADVANCE(827);
      if (lookahead == 'i') ADVANCE(148);
      END_STATE();
    case 748:
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(1440);
      if (lookahead == 'o') ADVANCE(1673);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 749:
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'g') ADVANCE(1620);
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 't') ADVANCE(524);
      END_STATE();
    case 750:
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'i') ADVANCE(1144);
      END_STATE();
    case 751:
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'm') ADVANCE(287);
      END_STATE();
    case 752:
      if (lookahead == 'c') ADVANCE(2129);
      if (lookahead == 'x') ADVANCE(756);
      END_STATE();
    case 753:
      if (lookahead == 'c') ADVANCE(148);
      END_STATE();
    case 754:
      if (lookahead == 'c') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(1741);
      END_STATE();
    case 755:
      if (lookahead == 'c') ADVANCE(318);
      if (lookahead == 'l') ADVANCE(922);
      if (lookahead == 'p') ADVANCE(329);
      if (lookahead == 'r') ADVANCE(1342);
      END_STATE();
    case 756:
      if (lookahead == 'c') ADVANCE(287);
      END_STATE();
    case 757:
      if (lookahead == 'c') ADVANCE(566);
      if (lookahead == 'd') ADVANCE(2007);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(396);
      if (lookahead == 'i') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(396);
      if (lookahead == 'm') ADVANCE(564);
      if (lookahead == 'n') ADVANCE(1250);
      if (lookahead == 'o') ADVANCE(869);
      if (lookahead == 'r') ADVANCE(396);
      if (lookahead == 's') ADVANCE(786);
      if (lookahead == 'u') ADVANCE(1700);
      if (lookahead == 'v') ADVANCE(994);
      if (lookahead == 'w') ADVANCE(957);
      END_STATE();
    case 758:
      if (lookahead == 'c') ADVANCE(566);
      if (lookahead == 'o') ADVANCE(870);
      if (lookahead == 's') ADVANCE(1735);
      if (lookahead == 't') ADVANCE(1891);
      if (lookahead == 'u') ADVANCE(1699);
      if (lookahead == 'v') ADVANCE(994);
      if (lookahead == 'w') ADVANCE(957);
      END_STATE();
    case 759:
      if (lookahead == 'c') ADVANCE(1639);
      END_STATE();
    case 760:
      if (lookahead == 'c') ADVANCE(2161);
      if (lookahead == 'h') ADVANCE(745);
      if (lookahead == 't') ADVANCE(1812);
      END_STATE();
    case 761:
      if (lookahead == 'c') ADVANCE(2161);
      if (lookahead == 'o') ADVANCE(1349);
      if (lookahead == 't') ADVANCE(1812);
      END_STATE();
    case 762:
      if (lookahead == 'c') ADVANCE(231);
      if (lookahead == 'h') ADVANCE(1657);
      if (lookahead == 'i') ADVANCE(1471);
      if (lookahead == 'm') ADVANCE(1213);
      if (lookahead == 'p') ADVANCE(538);
      if (lookahead == 'q') ADVANCE(1928);
      if (lookahead == 'u') ADVANCE(713);
      END_STATE();
    case 763:
      if (lookahead == 'c') ADVANCE(923);
      if (lookahead == 'd') ADVANCE(1260);
      if (lookahead == 'e') ADVANCE(1472);
      if (lookahead == 'n') ADVANCE(1121);
      if (lookahead == 'q') ADVANCE(2045);
      if (lookahead == 'r') ADVANCE(1754);
      if (lookahead == 't') ADVANCE(671);
      END_STATE();
    case 764:
      if (lookahead == 'c') ADVANCE(2054);
      END_STATE();
    case 765:
      if (lookahead == 'c') ADVANCE(142);
      if (lookahead == 's') ADVANCE(1349);
      END_STATE();
    case 766:
      if (lookahead == 'c') ADVANCE(210);
      END_STATE();
    case 767:
      if (lookahead == 'c') ADVANCE(2156);
      END_STATE();
    case 768:
      if (lookahead == 'c') ADVANCE(918);
      END_STATE();
    case 769:
      if (lookahead == 'c') ADVANCE(1741);
      END_STATE();
    case 770:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'i') ADVANCE(1454);
      END_STATE();
    case 771:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'e') ADVANCE(1463);
      if (lookahead == 'i') ADVANCE(1464);
      if (lookahead == 'o') ADVANCE(1353);
      END_STATE();
    case 772:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'e') ADVANCE(1997);
      if (lookahead == 'm') ADVANCE(1303);
      if (lookahead == 't') ADVANCE(641);
      END_STATE();
    case 773:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'e') ADVANCE(1774);
      END_STATE();
    case 774:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(919);
      if (lookahead == 't') ADVANCE(1174);
      END_STATE();
    case 775:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'g') ADVANCE(1273);
      END_STATE();
    case 776:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 777:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'h') ADVANCE(148);
      if (lookahead == 't') ADVANCE(1812);
      END_STATE();
    case 778:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(148);
      END_STATE();
    case 779:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(1454);
      END_STATE();
    case 780:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(1459);
      END_STATE();
    case 781:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(1500);
      END_STATE();
    case 782:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'l') ADVANCE(571);
      if (lookahead == 't') ADVANCE(1812);
      END_STATE();
    case 783:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'l') ADVANCE(1111);
      END_STATE();
    case 784:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'l') ADVANCE(598);
      END_STATE();
    case 785:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'l') ADVANCE(598);
      if (lookahead == 'o') ADVANCE(1349);
      END_STATE();
    case 786:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'q') ADVANCE(838);
      END_STATE();
    case 787:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 's') ADVANCE(1256);
      END_STATE();
    case 788:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 't') ADVANCE(148);
      if (lookahead == 'y') ADVANCE(1479);
      END_STATE();
    case 789:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 't') ADVANCE(1709);
      END_STATE();
    case 790:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 't') ADVANCE(1812);
      END_STATE();
    case 791:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'u') ADVANCE(722);
      END_STATE();
    case 792:
      if (lookahead == 'c') ADVANCE(1741);
      if (lookahead == 'u') ADVANCE(731);
      END_STATE();
    case 793:
      if (lookahead == 'c') ADVANCE(524);
      if (lookahead == 'l') ADVANCE(903);
      if (lookahead == 'q') ADVANCE(2065);
      if (lookahead == 's') ADVANCE(1174);
      END_STATE();
    case 794:
      if (lookahead == 'c') ADVANCE(524);
      if (lookahead == 'q') ADVANCE(2065);
      if (lookahead == 'r') ADVANCE(904);
      if (lookahead == 's') ADVANCE(1174);
      END_STATE();
    case 795:
      if (lookahead == 'c') ADVANCE(1341);
      if (lookahead == 'r') ADVANCE(2100);
      END_STATE();
    case 796:
      if (lookahead == 'c') ADVANCE(1507);
      if (lookahead == 'i') ADVANCE(1578);
      if (lookahead == 'm') ADVANCE(1254);
      if (lookahead == 'p') ADVANCE(148);
      if (lookahead == 't') ADVANCE(1010);
      END_STATE();
    case 797:
      if (lookahead == 'c') ADVANCE(610);
      if (lookahead == 's') ADVANCE(2046);
      if (lookahead == 'u') ADVANCE(209);
      END_STATE();
    case 798:
      if (lookahead == 'c') ADVANCE(1949);
      END_STATE();
    case 799:
      if (lookahead == 'c') ADVANCE(1332);
      if (lookahead == 'r') ADVANCE(2103);
      END_STATE();
    case 800:
      if (lookahead == 'c') ADVANCE(1281);
      if (lookahead == 's') ADVANCE(1248);
      if (lookahead == 'u') ADVANCE(617);
      if (lookahead == 'v') ADVANCE(1716);
      END_STATE();
    case 801:
      if (lookahead == 'c') ADVANCE(1280);
      if (lookahead == 'e') ADVANCE(877);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'p') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(257);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 802:
      if (lookahead == 'c') ADVANCE(1280);
      if (lookahead == 'e') ADVANCE(906);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 803:
      if (lookahead == 'c') ADVANCE(2053);
      END_STATE();
    case 804:
      if (lookahead == 'c') ADVANCE(2053);
      if (lookahead == 'r') ADVANCE(1741);
      END_STATE();
    case 805:
      if (lookahead == 'c') ADVANCE(2053);
      if (lookahead == 'r') ADVANCE(1777);
      END_STATE();
    case 806:
      if (lookahead == 'c') ADVANCE(2053);
      if (lookahead == 's') ADVANCE(1949);
      END_STATE();
    case 807:
      if (lookahead == 'c') ADVANCE(2053);
      if (lookahead == 's') ADVANCE(2003);
      END_STATE();
    case 808:
      if (lookahead == 'c') ADVANCE(1668);
      if (lookahead == 'd') ADVANCE(1741);
      END_STATE();
    case 809:
      if (lookahead == 'c') ADVANCE(2086);
      END_STATE();
    case 810:
      if (lookahead == 'c') ADVANCE(2086);
      if (lookahead == 'e') ADVANCE(1472);
      if (lookahead == 'g') ADVANCE(1859);
      if (lookahead == 'm') ADVANCE(724);
      if (lookahead == 'n') ADVANCE(1119);
      if (lookahead == 'p') ADVANCE(148);
      if (lookahead == 'q') ADVANCE(2045);
      if (lookahead == 'r') ADVANCE(1752);
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 811:
      if (lookahead == 'c') ADVANCE(2086);
      if (lookahead == 'm') ADVANCE(724);
      if (lookahead == 'n') ADVANCE(1111);
      if (lookahead == 'p') ADVANCE(1438);
      if (lookahead == 'r') ADVANCE(1741);
      END_STATE();
    case 812:
      if (lookahead == 'c') ADVANCE(2086);
      if (lookahead == 'm') ADVANCE(1482);
      if (lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 813:
      if (lookahead == 'c') ADVANCE(2086);
      if (lookahead == 'n') ADVANCE(1111);
      if (lookahead == 'r') ADVANCE(1787);
      END_STATE();
    case 814:
      if (lookahead == 'c') ADVANCE(2086);
      if (lookahead == 'p') ADVANCE(204);
      if (lookahead == 'r') ADVANCE(953);
      END_STATE();
    case 815:
      if (lookahead == 'c') ADVANCE(2086);
      if (lookahead == 'p') ADVANCE(282);
      if (lookahead == 'y') ADVANCE(1399);
      END_STATE();
    case 816:
      if (lookahead == 'c') ADVANCE(980);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 817:
      if (lookahead == 'c') ADVANCE(1620);
      END_STATE();
    case 818:
      if (lookahead == 'c') ADVANCE(1330);
      END_STATE();
    case 819:
      if (lookahead == 'c') ADVANCE(1339);
      END_STATE();
    case 820:
      if (lookahead == 'c') ADVANCE(1339);
      if (lookahead == 's') ADVANCE(954);
      END_STATE();
    case 821:
      if (lookahead == 'c') ADVANCE(1331);
      if (lookahead == 'n') ADVANCE(507);
      END_STATE();
    case 822:
      if (lookahead == 'c') ADVANCE(250);
      END_STATE();
    case 823:
      if (lookahead == 'c') ADVANCE(1207);
      END_STATE();
    case 824:
      if (lookahead == 'c') ADVANCE(1600);
      if (lookahead == 'i') ADVANCE(1507);
      END_STATE();
    case 825:
      if (lookahead == 'c') ADVANCE(1334);
      if (lookahead == 'n') ADVANCE(1330);
      END_STATE();
    case 826:
      if (lookahead == 'c') ADVANCE(564);
      END_STATE();
    case 827:
      if (lookahead == 'c') ADVANCE(1335);
      END_STATE();
    case 828:
      if (lookahead == 'c') ADVANCE(1349);
      if (lookahead == 'i') ADVANCE(1905);
      if (lookahead == 'p') ADVANCE(1049);
      END_STATE();
    case 829:
      if (lookahead == 'c') ADVANCE(1344);
      if (lookahead == 'n') ADVANCE(1914);
      END_STATE();
    case 830:
      if (lookahead == 'c') ADVANCE(672);
      if (lookahead == 'r') ADVANCE(1532);
      if (lookahead == 't') ADVANCE(524);
      END_STATE();
    case 831:
      if (lookahead == 'c') ADVANCE(1336);
      if (lookahead == 'k') ADVANCE(2099);
      END_STATE();
    case 832:
      if (lookahead == 'c') ADVANCE(753);
      END_STATE();
    case 833:
      if (lookahead == 'c') ADVANCE(917);
      END_STATE();
    case 834:
      if (lookahead == 'c') ADVANCE(1188);
      END_STATE();
    case 835:
      if (lookahead == 'c') ADVANCE(1794);
      END_STATE();
    case 836:
      if (lookahead == 'c') ADVANCE(1794);
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'n') ADVANCE(2056);
      END_STATE();
    case 837:
      if (lookahead == 'c') ADVANCE(1914);
      END_STATE();
    case 838:
      if (lookahead == 'c') ADVANCE(2049);
      END_STATE();
    case 839:
      if (lookahead == 'c') ADVANCE(1948);
      END_STATE();
    case 840:
      if (lookahead == 'c') ADVANCE(591);
      END_STATE();
    case 841:
      if (lookahead == 'c') ADVANCE(1224);
      END_STATE();
    case 842:
      if (lookahead == 'c') ADVANCE(1224);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 843:
      if (lookahead == 'c') ADVANCE(1057);
      END_STATE();
    case 844:
      if (lookahead == 'c') ADVANCE(1783);
      if (lookahead == 'd') ADVANCE(200);
      if (lookahead == 'n') ADVANCE(2064);
      END_STATE();
    case 845:
      if (lookahead == 'c') ADVANCE(2035);
      END_STATE();
    case 846:
      if (lookahead == 'c') ADVANCE(2022);
      END_STATE();
    case 847:
      if (lookahead == 'c') ADVANCE(1053);
      END_STATE();
    case 848:
      if (lookahead == 'c') ADVANCE(2006);
      END_STATE();
    case 849:
      if (lookahead == 'c') ADVANCE(1282);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'm') ADVANCE(590);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(773);
      if (lookahead == 'u') ADVANCE(1337);
      END_STATE();
    case 850:
      if (lookahead == 'c') ADVANCE(1282);
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(773);
      if (lookahead == 'u') ADVANCE(1337);
      END_STATE();
    case 851:
      if (lookahead == 'c') ADVANCE(1641);
      if (lookahead == 'i') ADVANCE(1516);
      if (lookahead == 't') ADVANCE(1776);
      END_STATE();
    case 852:
      if (lookahead == 'c') ADVANCE(1641);
      if (lookahead == 't') ADVANCE(1776);
      END_STATE();
    case 853:
      if (lookahead == 'c') ADVANCE(1343);
      END_STATE();
    case 854:
      if (lookahead == 'c') ADVANCE(1023);
      END_STATE();
    case 855:
      if (lookahead == 'c') ADVANCE(1023);
      if (lookahead == 'h') ADVANCE(513);
      END_STATE();
    case 856:
      if (lookahead == 'c') ADVANCE(630);
      END_STATE();
    case 857:
      if (lookahead == 'c') ADVANCE(1414);
      END_STATE();
    case 858:
      if (lookahead == 'c') ADVANCE(1838);
      if (lookahead == 'm') ADVANCE(1626);
      END_STATE();
    case 859:
      if (lookahead == 'c') ADVANCE(634);
      END_STATE();
    case 860:
      if (lookahead == 'c') ADVANCE(2021);
      END_STATE();
    case 861:
      if (lookahead == 'c') ADVANCE(1609);
      if (lookahead == 'e') ADVANCE(1667);
      if (lookahead == 'p') ADVANCE(1811);
      if (lookahead == 's') ADVANCE(1266);
      END_STATE();
    case 862:
      if (lookahead == 'c') ADVANCE(1398);
      END_STATE();
    case 863:
      if (lookahead == 'c') ADVANCE(637);
      END_STATE();
    case 864:
      if (lookahead == 'c') ADVANCE(675);
      if (lookahead == 'm') ADVANCE(1702);
      if (lookahead == 'p') ADVANCE(1909);
      if (lookahead == 'r') ADVANCE(1555);
      if (lookahead == 't') ADVANCE(2152);
      END_STATE();
    case 865:
      if (lookahead == 'c') ADVANCE(682);
      END_STATE();
    case 866:
      if (lookahead == 'c') ADVANCE(1081);
      END_STATE();
    case 867:
      if (lookahead == 'd') ADVANCE(1589);
      END_STATE();
    case 868:
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'i') ADVANCE(1431);
      if (lookahead == 'r') ADVANCE(1220);
      END_STATE();
    case 869:
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'p') ADVANCE(1088);
      if (lookahead == 't') ADVANCE(1291);
      END_STATE();
    case 870:
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'p') ADVANCE(1439);
      if (lookahead == 't') ADVANCE(1295);
      END_STATE();
    case 871:
      if (lookahead == 'd') ADVANCE(1589);
      if (lookahead == 'r') ADVANCE(1220);
      END_STATE();
    case 872:
      if (lookahead == 'd') ADVANCE(148);
      END_STATE();
    case 873:
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'f') ADVANCE(596);
      if (lookahead == 'p') ADVANCE(335);
      END_STATE();
    case 874:
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(917);
      END_STATE();
    case 875:
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(287);
      END_STATE();
    case 876:
      if (lookahead == 'd') ADVANCE(205);
      if (lookahead == 'g') ADVANCE(242);
      END_STATE();
    case 877:
      if (lookahead == 'd') ADVANCE(717);
      if (lookahead == 'i') ADVANCE(1012);
      END_STATE();
    case 878:
      if (lookahead == 'd') ADVANCE(1435);
      END_STATE();
    case 879:
      if (lookahead == 'd') ADVANCE(506);
      END_STATE();
    case 880:
      if (lookahead == 'd') ADVANCE(482);
      END_STATE();
    case 881:
      if (lookahead == 'd') ADVANCE(472);
      END_STATE();
    case 882:
      if (lookahead == 'd') ADVANCE(524);
      END_STATE();
    case 883:
      if (lookahead == 'd') ADVANCE(745);
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 884:
      if (lookahead == 'd') ADVANCE(274);
      END_STATE();
    case 885:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 886:
      if (lookahead == 'd') ADVANCE(996);
      if (lookahead == 'i') ADVANCE(1624);
      END_STATE();
    case 887:
      if (lookahead == 'd') ADVANCE(241);
      END_STATE();
    case 888:
      if (lookahead == 'd') ADVANCE(571);
      END_STATE();
    case 889:
      if (lookahead == 'd') ADVANCE(589);
      END_STATE();
    case 890:
      if (lookahead == 'd') ADVANCE(332);
      END_STATE();
    case 891:
      if (lookahead == 'd') ADVANCE(254);
      END_STATE();
    case 892:
      if (lookahead == 'd') ADVANCE(1257);
      END_STATE();
    case 893:
      if (lookahead == 'd') ADVANCE(1257);
      if (lookahead == 'l') ADVANCE(1447);
      END_STATE();
    case 894:
      if (lookahead == 'd') ADVANCE(917);
      END_STATE();
    case 895:
      if (lookahead == 'd') ADVANCE(2061);
      END_STATE();
    case 896:
      if (lookahead == 'd') ADVANCE(2061);
      if (lookahead == 'p') ADVANCE(1663);
      END_STATE();
    case 897:
      if (lookahead == 'd') ADVANCE(1215);
      END_STATE();
    case 898:
      if (lookahead == 'd') ADVANCE(1215);
      if (lookahead == 'm') ADVANCE(1702);
      if (lookahead == 'n') ADVANCE(336);
      END_STATE();
    case 899:
      if (lookahead == 'd') ADVANCE(1940);
      if (lookahead == 'u') ADVANCE(1184);
      END_STATE();
    case 900:
      if (lookahead == 'd') ADVANCE(931);
      END_STATE();
    case 901:
      if (lookahead == 'd') ADVANCE(1903);
      END_STATE();
    case 902:
      if (lookahead == 'd') ADVANCE(1996);
      END_STATE();
    case 903:
      if (lookahead == 'd') ADVANCE(1184);
      END_STATE();
    case 904:
      if (lookahead == 'd') ADVANCE(1184);
      if (lookahead == 'u') ADVANCE(1940);
      END_STATE();
    case 905:
      if (lookahead == 'd') ADVANCE(1290);
      if (lookahead == 'n') ADVANCE(2025);
      END_STATE();
    case 906:
      if (lookahead == 'd') ADVANCE(1136);
      END_STATE();
    case 907:
      if (lookahead == 'd') ADVANCE(1582);
      if (lookahead == 'u') ADVANCE(1668);
      END_STATE();
    case 908:
      if (lookahead == 'd') ADVANCE(1001);
      if (lookahead == 'p') ADVANCE(1087);
      END_STATE();
    case 909:
      if (lookahead == 'd') ADVANCE(997);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 910:
      if (lookahead == 'd') ADVANCE(1014);
      END_STATE();
    case 911:
      if (lookahead == 'd') ADVANCE(1605);
      END_STATE();
    case 912:
      if (lookahead == 'd') ADVANCE(1254);
      END_STATE();
    case 913:
      if (lookahead == 'd') ADVANCE(1254);
      if (lookahead == 'i') ADVANCE(1349);
      END_STATE();
    case 914:
      if (lookahead == 'd') ADVANCE(1016);
      END_STATE();
    case 915:
      if (lookahead == 'd') ADVANCE(636);
      if (lookahead == 'e') ADVANCE(1684);
      if (lookahead == 'l') ADVANCE(657);
      if (lookahead == 'p') ADVANCE(220);
      if (lookahead == 'r') ADVANCE(664);
      if (lookahead == 'v') ADVANCE(994);
      if (lookahead == 'w') ADVANCE(916);
      END_STATE();
    case 916:
      if (lookahead == 'e') ADVANCE(872);
      END_STATE();
    case 917:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 918:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'k') ADVANCE(952);
      END_STATE();
    case 919:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(1263);
      if (lookahead == 'p') ADVANCE(643);
      END_STATE();
    case 920:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(720);
      END_STATE();
    case 921:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1355);
      END_STATE();
    case 922:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 923:
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(1998);
      END_STATE();
    case 924:
      if (lookahead == 'e') ADVANCE(432);
      END_STATE();
    case 925:
      if (lookahead == 'e') ADVANCE(297);
      END_STATE();
    case 926:
      if (lookahead == 'e') ADVANCE(2104);
      END_STATE();
    case 927:
      if (lookahead == 'e') ADVANCE(2104);
      if (lookahead == 'v') ADVANCE(729);
      END_STATE();
    case 928:
      if (lookahead == 'e') ADVANCE(1096);
      if (lookahead == 'p') ADVANCE(1177);
      END_STATE();
    case 929:
      if (lookahead == 'e') ADVANCE(317);
      if (lookahead == 'o') ADVANCE(1949);
      END_STATE();
    case 930:
      if (lookahead == 'e') ADVANCE(219);
      if (lookahead == 'l') ADVANCE(1406);
      if (lookahead == 'r') ADVANCE(719);
      END_STATE();
    case 931:
      if (lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 932:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 933:
      if (lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 934:
      if (lookahead == 'e') ADVANCE(433);
      END_STATE();
    case 935:
      if (lookahead == 'e') ADVANCE(431);
      END_STATE();
    case 936:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 937:
      if (lookahead == 'e') ADVANCE(695);
      END_STATE();
    case 938:
      if (lookahead == 'e') ADVANCE(1485);
      END_STATE();
    case 939:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 940:
      if (lookahead == 'e') ADVANCE(459);
      END_STATE();
    case 941:
      if (lookahead == 'e') ADVANCE(490);
      END_STATE();
    case 942:
      if (lookahead == 'e') ADVANCE(239);
      END_STATE();
    case 943:
      if (lookahead == 'e') ADVANCE(426);
      END_STATE();
    case 944:
      if (lookahead == 'e') ADVANCE(518);
      END_STATE();
    case 945:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 946:
      if (lookahead == 'e') ADVANCE(237);
      END_STATE();
    case 947:
      if (lookahead == 'e') ADVANCE(500);
      END_STATE();
    case 948:
      if (lookahead == 'e') ADVANCE(1741);
      END_STATE();
    case 949:
      if (lookahead == 'e') ADVANCE(524);
      if (lookahead == 'p') ADVANCE(213);
      if (lookahead == 's') ADVANCE(524);
      END_STATE();
    case 950:
      if (lookahead == 'e') ADVANCE(1507);
      END_STATE();
    case 951:
      if (lookahead == 'e') ADVANCE(1827);
      if (lookahead == 'i') ADVANCE(821);
      END_STATE();
    case 952:
      if (lookahead == 'e') ADVANCE(1949);
      END_STATE();
    case 953:
      if (lookahead == 'e') ADVANCE(1949);
      if (lookahead == 'o') ADVANCE(1495);
      END_STATE();
    case 954:
      if (lookahead == 'e') ADVANCE(429);
      END_STATE();
    case 955:
      if (lookahead == 'e') ADVANCE(420);
      END_STATE();
    case 956:
      if (lookahead == 'e') ADVANCE(2145);
      END_STATE();
    case 957:
      if (lookahead == 'e') ADVANCE(906);
      END_STATE();
    case 958:
      if (lookahead == 'e') ADVANCE(1843);
      if (lookahead == 'i') ADVANCE(829);
      if (lookahead == 'k') ADVANCE(567);
      if (lookahead == 'o') ADVANCE(1743);
      END_STATE();
    case 959:
      if (lookahead == 'e') ADVANCE(1097);
      END_STATE();
    case 960:
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 961:
      if (lookahead == 'e') ADVANCE(461);
      END_STATE();
    case 962:
      if (lookahead == 'e') ADVANCE(508);
      END_STATE();
    case 963:
      if (lookahead == 'e') ADVANCE(1920);
      END_STATE();
    case 964:
      if (lookahead == 'e') ADVANCE(1723);
      END_STATE();
    case 965:
      if (lookahead == 'e') ADVANCE(907);
      END_STATE();
    case 966:
      if (lookahead == 'e') ADVANCE(538);
      END_STATE();
    case 967:
      if (lookahead == 'e') ADVANCE(538);
      if (lookahead == 'i') ADVANCE(1454);
      END_STATE();
    case 968:
      if (lookahead == 'e') ADVANCE(450);
      END_STATE();
    case 969:
      if (lookahead == 'e') ADVANCE(1101);
      END_STATE();
    case 970:
      if (lookahead == 'e') ADVANCE(322);
      END_STATE();
    case 971:
      if (lookahead == 'e') ADVANCE(912);
      if (lookahead == 'i') ADVANCE(1808);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 972:
      if (lookahead == 'e') ADVANCE(912);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 973:
      if (lookahead == 'e') ADVANCE(2141);
      END_STATE();
    case 974:
      if (lookahead == 'e') ADVANCE(405);
      END_STATE();
    case 975:
      if (lookahead == 'e') ADVANCE(1727);
      if (lookahead == 'v') ADVANCE(994);
      if (lookahead == 'w') ADVANCE(957);
      END_STATE();
    case 976:
      if (lookahead == 'e') ADVANCE(430);
      END_STATE();
    case 977:
      if (lookahead == 'e') ADVANCE(1092);
      END_STATE();
    case 978:
      if (lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 979:
      if (lookahead == 'e') ADVANCE(1729);
      END_STATE();
    case 980:
      if (lookahead == 'e') ADVANCE(1330);
      END_STATE();
    case 981:
      if (lookahead == 'e') ADVANCE(1508);
      END_STATE();
    case 982:
      if (lookahead == 'e') ADVANCE(1728);
      END_STATE();
    case 983:
      if (lookahead == 'e') ADVANCE(1970);
      END_STATE();
    case 984:
      if (lookahead == 'e') ADVANCE(1894);
      END_STATE();
    case 985:
      if (lookahead == 'e') ADVANCE(1905);
      END_STATE();
    case 986:
      if (lookahead == 'e') ADVANCE(1988);
      END_STATE();
    case 987:
      if (lookahead == 'e') ADVANCE(1349);
      END_STATE();
    case 988:
      if (lookahead == 'e') ADVANCE(879);
      END_STATE();
    case 989:
      if (lookahead == 'e') ADVANCE(690);
      END_STATE();
    case 990:
      if (lookahead == 'e') ADVANCE(881);
      END_STATE();
    case 991:
      if (lookahead == 'e') ADVANCE(1495);
      END_STATE();
    case 992:
      if (lookahead == 'e') ADVANCE(753);
      END_STATE();
    case 993:
      if (lookahead == 'e') ADVANCE(884);
      END_STATE();
    case 994:
      if (lookahead == 'e') ADVANCE(917);
      END_STATE();
    case 995:
      if (lookahead == 'e') ADVANCE(901);
      END_STATE();
    case 996:
      if (lookahead == 'e') ADVANCE(1749);
      END_STATE();
    case 997:
      if (lookahead == 'e') ADVANCE(1900);
      END_STATE();
    case 998:
      if (lookahead == 'e') ADVANCE(1667);
      if (lookahead == 'k') ADVANCE(562);
      if (lookahead == 'n') ADVANCE(1635);
      if (lookahead == 'p') ADVANCE(1183);
      if (lookahead == 'r') ADVANCE(277);
      if (lookahead == 's') ADVANCE(1229);
      if (lookahead == 't') ADVANCE(1200);
      END_STATE();
    case 999:
      if (lookahead == 'e') ADVANCE(1667);
      if (lookahead == 'p') ADVANCE(1182);
      END_STATE();
    case 1000:
      if (lookahead == 'e') ADVANCE(1911);
      END_STATE();
    case 1001:
      if (lookahead == 'e') ADVANCE(1385);
      END_STATE();
    case 1002:
      if (lookahead == 'e') ADVANCE(860);
      END_STATE();
    case 1003:
      if (lookahead == 'e') ADVANCE(1549);
      END_STATE();
    case 1004:
      if (lookahead == 'e') ADVANCE(1942);
      END_STATE();
    case 1005:
      if (lookahead == 'e') ADVANCE(1994);
      END_STATE();
    case 1006:
      if (lookahead == 'e') ADVANCE(1913);
      END_STATE();
    case 1007:
      if (lookahead == 'e') ADVANCE(1972);
      END_STATE();
    case 1008:
      if (lookahead == 'e') ADVANCE(573);
      END_STATE();
    case 1009:
      if (lookahead == 'e') ADVANCE(932);
      END_STATE();
    case 1010:
      if (lookahead == 'e') ADVANCE(1521);
      END_STATE();
    case 1011:
      if (lookahead == 'e') ADVANCE(1412);
      END_STATE();
    case 1012:
      if (lookahead == 'e') ADVANCE(1789);
      END_STATE();
    case 1013:
      if (lookahead == 'e') ADVANCE(611);
      END_STATE();
    case 1014:
      if (lookahead == 'e') ADVANCE(1903);
      END_STATE();
    case 1015:
      if (lookahead == 'e') ADVANCE(595);
      END_STATE();
    case 1016:
      if (lookahead == 'e') ADVANCE(1904);
      END_STATE();
    case 1017:
      if (lookahead == 'e') ADVANCE(1959);
      if (lookahead == 'i') ADVANCE(1454);
      if (lookahead == 'u') ADVANCE(2153);
      END_STATE();
    case 1018:
      if (lookahead == 'e') ADVANCE(1755);
      END_STATE();
    case 1019:
      if (lookahead == 'e') ADVANCE(1862);
      END_STATE();
    case 1020:
      if (lookahead == 'e') ADVANCE(1995);
      END_STATE();
    case 1021:
      if (lookahead == 'e') ADVANCE(1826);
      END_STATE();
    case 1022:
      if (lookahead == 'e') ADVANCE(2002);
      END_STATE();
    case 1023:
      if (lookahead == 'e') ADVANCE(995);
      END_STATE();
    case 1024:
      if (lookahead == 'e') ADVANCE(939);
      if (lookahead == 'r') ADVANCE(1326);
      END_STATE();
    case 1025:
      if (lookahead == 'e') ADVANCE(1742);
      END_STATE();
    case 1026:
      if (lookahead == 'e') ADVANCE(1836);
      if (lookahead == 'i') ADVANCE(1507);
      END_STATE();
    case 1027:
      if (lookahead == 'e') ADVANCE(1786);
      END_STATE();
    case 1028:
      if (lookahead == 'e') ADVANCE(1864);
      END_STATE();
    case 1029:
      if (lookahead == 'e') ADVANCE(1884);
      END_STATE();
    case 1030:
      if (lookahead == 'e') ADVANCE(944);
      END_STATE();
    case 1031:
      if (lookahead == 'e') ADVANCE(1799);
      END_STATE();
    case 1032:
      if (lookahead == 'e') ADVANCE(1071);
      END_STATE();
    case 1033:
      if (lookahead == 'e') ADVANCE(1796);
      END_STATE();
    case 1034:
      if (lookahead == 'e') ADVANCE(1759);
      END_STATE();
    case 1035:
      if (lookahead == 'e') ADVANCE(1804);
      END_STATE();
    case 1036:
      if (lookahead == 'e') ADVANCE(1762);
      END_STATE();
    case 1037:
      if (lookahead == 'e') ADVANCE(1102);
      END_STATE();
    case 1038:
      if (lookahead == 'e') ADVANCE(2106);
      if (lookahead == 'i') ADVANCE(1149);
      END_STATE();
    case 1039:
      if (lookahead == 'e') ADVANCE(1419);
      END_STATE();
    case 1040:
      if (lookahead == 'e') ADVANCE(517);
      END_STATE();
    case 1041:
      if (lookahead == 'e') ADVANCE(889);
      END_STATE();
    case 1042:
      if (lookahead == 'e') ADVANCE(669);
      if (lookahead == 'w') ADVANCE(669);
      END_STATE();
    case 1043:
      if (lookahead == 'e') ADVANCE(1099);
      END_STATE();
    case 1044:
      if (lookahead == 'e') ADVANCE(1099);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == 't') ADVANCE(345);
      END_STATE();
    case 1045:
      if (lookahead == 'e') ADVANCE(991);
      END_STATE();
    case 1046:
      if (lookahead == 'e') ADVANCE(1931);
      END_STATE();
    case 1047:
      if (lookahead == 'e') ADVANCE(892);
      END_STATE();
    case 1048:
      if (lookahead == 'e') ADVANCE(1484);
      END_STATE();
    case 1049:
      if (lookahead == 'e') ADVANCE(845);
      if (lookahead == 'o') ADVANCE(1565);
      END_STATE();
    case 1050:
      if (lookahead == 'e') ADVANCE(658);
      END_STATE();
    case 1051:
      if (lookahead == 'e') ADVANCE(1720);
      END_STATE();
    case 1052:
      if (lookahead == 'e') ADVANCE(1824);
      END_STATE();
    case 1053:
      if (lookahead == 'e') ADVANCE(2017);
      END_STATE();
    case 1054:
      if (lookahead == 'e') ADVANCE(2017);
      if (lookahead == 't') ADVANCE(524);
      END_STATE();
    case 1055:
      if (lookahead == 'e') ADVANCE(740);
      END_STATE();
    case 1056:
      if (lookahead == 'e') ADVANCE(1103);
      END_STATE();
    case 1057:
      if (lookahead == 'e') ADVANCE(910);
      END_STATE();
    case 1058:
      if (lookahead == 'e') ADVANCE(846);
      END_STATE();
    case 1059:
      if (lookahead == 'e') ADVANCE(1921);
      END_STATE();
    case 1060:
      if (lookahead == 'e') ADVANCE(1707);
      END_STATE();
    case 1061:
      if (lookahead == 'e') ADVANCE(1104);
      END_STATE();
    case 1062:
      if (lookahead == 'e') ADVANCE(1823);
      if (lookahead == 'n') ADVANCE(455);
      END_STATE();
    case 1063:
      if (lookahead == 'e') ADVANCE(848);
      END_STATE();
    case 1064:
      if (lookahead == 'e') ADVANCE(1575);
      END_STATE();
    case 1065:
      if (lookahead == 'e') ADVANCE(1105);
      END_STATE();
    case 1066:
      if (lookahead == 'e') ADVANCE(1106);
      END_STATE();
    case 1067:
      if (lookahead == 'e') ADVANCE(1558);
      END_STATE();
    case 1068:
      if (lookahead == 'e') ADVANCE(1107);
      if (lookahead == 'o') ADVANCE(1535);
      END_STATE();
    case 1069:
      if (lookahead == 'e') ADVANCE(1842);
      END_STATE();
    case 1070:
      if (lookahead == 'e') ADVANCE(1100);
      END_STATE();
    case 1071:
      if (lookahead == 'e') ADVANCE(2036);
      END_STATE();
    case 1072:
      if (lookahead == 'e') ADVANCE(1889);
      END_STATE();
    case 1073:
      if (lookahead == 'e') ADVANCE(1543);
      END_STATE();
    case 1074:
      if (lookahead == 'e') ADVANCE(694);
      END_STATE();
    case 1075:
      if (lookahead == 'e') ADVANCE(1453);
      END_STATE();
    case 1076:
      if (lookahead == 'e') ADVANCE(1151);
      END_STATE();
    case 1077:
      if (lookahead == 'e') ADVANCE(1886);
      END_STATE();
    case 1078:
      if (lookahead == 'e') ADVANCE(2023);
      END_STATE();
    case 1079:
      if (lookahead == 'e') ADVANCE(1302);
      END_STATE();
    case 1080:
      if (lookahead == 'e') ADVANCE(1869);
      END_STATE();
    case 1081:
      if (lookahead == 'e') ADVANCE(914);
      END_STATE();
    case 1082:
      if (lookahead == 'e') ADVANCE(693);
      END_STATE();
    case 1083:
      if (lookahead == 'e') ADVANCE(1518);
      END_STATE();
    case 1084:
      if (lookahead == 'e') ADVANCE(698);
      END_STATE();
    case 1085:
      if (lookahead == 'e') ADVANCE(866);
      END_STATE();
    case 1086:
      if (lookahead == 'e') ADVANCE(1110);
      END_STATE();
    case 1087:
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 1088:
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(2056);
      END_STATE();
    case 1089:
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1615);
      END_STATE();
    case 1090:
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(148);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 's') ADVANCE(769);
      END_STATE();
    case 1091:
      if (lookahead == 'f') ADVANCE(1741);
      if (lookahead == 'i') ADVANCE(1507);
      if (lookahead == 'o') ADVANCE(1671);
      if (lookahead == 'p') ADVANCE(1811);
      if (lookahead == 's') ADVANCE(769);
      if (lookahead == 'u') ADVANCE(593);
      END_STATE();
    case 1092:
      if (lookahead == 'f') ADVANCE(1949);
      END_STATE();
    case 1093:
      if (lookahead == 'f') ADVANCE(1098);
      END_STATE();
    case 1094:
      if (lookahead == 'f') ADVANCE(1952);
      if (lookahead == 's') ADVANCE(1897);
      END_STATE();
    case 1095:
      if (lookahead == 'f') ADVANCE(1975);
      if (lookahead == 'l') ADVANCE(216);
      if (lookahead == 'p') ADVANCE(1087);
      END_STATE();
    case 1096:
      if (lookahead == 'f') ADVANCE(1916);
      if (lookahead == 'p') ADVANCE(1174);
      END_STATE();
    case 1097:
      if (lookahead == 'f') ADVANCE(2040);
      END_STATE();
    case 1098:
      if (lookahead == 'f') ADVANCE(1072);
      END_STATE();
    case 1099:
      if (lookahead == 'f') ADVANCE(1979);
      END_STATE();
    case 1100:
      if (lookahead == 'f') ADVANCE(1994);
      END_STATE();
    case 1101:
      if (lookahead == 'f') ADVANCE(1659);
      END_STATE();
    case 1102:
      if (lookahead == 'f') ADVANCE(1986);
      if (lookahead == 's') ADVANCE(1902);
      END_STATE();
    case 1103:
      if (lookahead == 'f') ADVANCE(1961);
      END_STATE();
    case 1104:
      if (lookahead == 'f') ADVANCE(1963);
      END_STATE();
    case 1105:
      if (lookahead == 'f') ADVANCE(1981);
      END_STATE();
    case 1106:
      if (lookahead == 'f') ADVANCE(2019);
      END_STATE();
    case 1107:
      if (lookahead == 'f') ADVANCE(1967);
      END_STATE();
    case 1108:
      if (lookahead == 'f') ADVANCE(1619);
      END_STATE();
    case 1109:
      if (lookahead == 'f') ADVANCE(1258);
      END_STATE();
    case 1110:
      if (lookahead == 'f') ADVANCE(2039);
      END_STATE();
    case 1111:
      if (lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 1112:
      if (lookahead == 'g') ADVANCE(148);
      if (lookahead == 's') ADVANCE(1668);
      END_STATE();
    case 1113:
      if (lookahead == 'g') ADVANCE(148);
      if (lookahead == 't') ADVANCE(345);
      END_STATE();
    case 1114:
      if (lookahead == 'g') ADVANCE(758);
      END_STATE();
    case 1115:
      if (lookahead == 'g') ADVANCE(233);
      END_STATE();
    case 1116:
      if (lookahead == 'g') ADVANCE(233);
      if (lookahead == 'i') ADVANCE(1507);
      END_STATE();
    case 1117:
      if (lookahead == 'g') ADVANCE(488);
      END_STATE();
    case 1118:
      if (lookahead == 'g') ADVANCE(507);
      END_STATE();
    case 1119:
      if (lookahead == 'g') ADVANCE(236);
      END_STATE();
    case 1120:
      if (lookahead == 'g') ADVANCE(1452);
      END_STATE();
    case 1121:
      if (lookahead == 'g') ADVANCE(360);
      END_STATE();
    case 1122:
      if (lookahead == 'g') ADVANCE(524);
      END_STATE();
    case 1123:
      if (lookahead == 'g') ADVANCE(1190);
      END_STATE();
    case 1124:
      if (lookahead == 'g') ADVANCE(2144);
      END_STATE();
    case 1125:
      if (lookahead == 'g') ADVANCE(1137);
      if (lookahead == 'l') ADVANCE(986);
      if (lookahead == 'r') ADVANCE(1741);
      if (lookahead == 's') ADVANCE(1178);
      END_STATE();
    case 1126:
      if (lookahead == 'g') ADVANCE(1137);
      if (lookahead == 'r') ADVANCE(1741);
      END_STATE();
    case 1127:
      if (lookahead == 'g') ADVANCE(1137);
      if (lookahead == 'r') ADVANCE(1741);
      if (lookahead == 's') ADVANCE(1180);
      END_STATE();
    case 1128:
      if (lookahead == 'g') ADVANCE(1581);
      END_STATE();
    case 1129:
      if (lookahead == 'g') ADVANCE(1620);
      if (lookahead == 'p') ADVANCE(1087);
      END_STATE();
    case 1130:
      if (lookahead == 'g') ADVANCE(1620);
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 't') ADVANCE(524);
      END_STATE();
    case 1131:
      if (lookahead == 'g') ADVANCE(1461);
      END_STATE();
    case 1132:
      if (lookahead == 'g') ADVANCE(1179);
      END_STATE();
    case 1133:
      if (lookahead == 'g') ADVANCE(1349);
      if (lookahead == 'i') ADVANCE(1381);
      if (lookahead == 'l') ADVANCE(1111);
      if (lookahead == 'r') ADVANCE(1322);
      END_STATE();
    case 1134:
      if (lookahead == 'g') ADVANCE(667);
      if (lookahead == 's') ADVANCE(2005);
      if (lookahead == 'w') ADVANCE(486);
      END_STATE();
    case 1135:
      if (lookahead == 'g') ADVANCE(1495);
      END_STATE();
    case 1136:
      if (lookahead == 'g') ADVANCE(917);
      END_STATE();
    case 1137:
      if (lookahead == 'g') ADVANCE(948);
      END_STATE();
    case 1138:
      if (lookahead == 'g') ADVANCE(952);
      END_STATE();
    case 1139:
      if (lookahead == 'g') ADVANCE(1868);
      END_STATE();
    case 1140:
      if (lookahead == 'g') ADVANCE(1868);
      if (lookahead == 'i') ADVANCE(1507);
      if (lookahead == 't') ADVANCE(1649);
      END_STATE();
    case 1141:
      if (lookahead == 'g') ADVANCE(1766);
      END_STATE();
    case 1142:
      if (lookahead == 'g') ADVANCE(1193);
      if (lookahead == 'n') ADVANCE(1111);
      if (lookahead == 's') ADVANCE(1292);
      END_STATE();
    case 1143:
      if (lookahead == 'g') ADVANCE(911);
      END_STATE();
    case 1144:
      if (lookahead == 'g') ADVANCE(1775);
      END_STATE();
    case 1145:
      if (lookahead == 'g') ADVANCE(1189);
      END_STATE();
    case 1146:
      if (lookahead == 'g') ADVANCE(1969);
      END_STATE();
    case 1147:
      if (lookahead == 'g') ADVANCE(1969);
      if (lookahead == 'l') ADVANCE(963);
      END_STATE();
    case 1148:
      if (lookahead == 'g') ADVANCE(1969);
      if (lookahead == 'q') ADVANCE(1146);
      END_STATE();
    case 1149:
      if (lookahead == 'g') ADVANCE(1194);
      END_STATE();
    case 1150:
      if (lookahead == 'g') ADVANCE(1487);
      if (lookahead == 'm') ADVANCE(234);
      END_STATE();
    case 1151:
      if (lookahead == 'g') ADVANCE(1819);
      END_STATE();
    case 1152:
      if (lookahead == 'g') ADVANCE(1819);
      if (lookahead == 'r') ADVANCE(1936);
      END_STATE();
    case 1153:
      if (lookahead == 'g') ADVANCE(1195);
      END_STATE();
    case 1154:
      if (lookahead == 'g') ADVANCE(1197);
      END_STATE();
    case 1155:
      if (lookahead == 'g') ADVANCE(1198);
      END_STATE();
    case 1156:
      if (lookahead == 'g') ADVANCE(1199);
      END_STATE();
    case 1157:
      if (lookahead == 'g') ADVANCE(1398);
      END_STATE();
    case 1158:
      if (lookahead == 'g') ADVANCE(1201);
      END_STATE();
    case 1159:
      if (lookahead == 'g') ADVANCE(1031);
      if (lookahead == 'r') ADVANCE(840);
      END_STATE();
    case 1160:
      if (lookahead == 'g') ADVANCE(1202);
      END_STATE();
    case 1161:
      if (lookahead == 'g') ADVANCE(1203);
      END_STATE();
    case 1162:
      if (lookahead == 'g') ADVANCE(1420);
      END_STATE();
    case 1163:
      if (lookahead == 'g') ADVANCE(1192);
      END_STATE();
    case 1164:
      if (lookahead == 'g') ADVANCE(1422);
      END_STATE();
    case 1165:
      if (lookahead == 'g') ADVANCE(1423);
      END_STATE();
    case 1166:
      if (lookahead == 'g') ADVANCE(1424);
      END_STATE();
    case 1167:
      if (lookahead == 'g') ADVANCE(1437);
      END_STATE();
    case 1168:
      if (lookahead == 'g') ADVANCE(1425);
      END_STATE();
    case 1169:
      if (lookahead == 'g') ADVANCE(1426);
      END_STATE();
    case 1170:
      if (lookahead == 'g') ADVANCE(487);
      END_STATE();
    case 1171:
      if (lookahead == 'g') ADVANCE(685);
      END_STATE();
    case 1172:
      if (lookahead == 'g') ADVANCE(1212);
      END_STATE();
    case 1173:
      if (lookahead == 'h') ADVANCE(872);
      END_STATE();
    case 1174:
      if (lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 1175:
      if (lookahead == 'h') ADVANCE(287);
      END_STATE();
    case 1176:
      if (lookahead == 'h') ADVANCE(507);
      END_STATE();
    case 1177:
      if (lookahead == 'h') ADVANCE(524);
      END_STATE();
    case 1178:
      if (lookahead == 'h') ADVANCE(345);
      END_STATE();
    case 1179:
      if (lookahead == 'h') ADVANCE(1949);
      END_STATE();
    case 1180:
      if (lookahead == 'h') ADVANCE(2099);
      END_STATE();
    case 1181:
      if (lookahead == 'h') ADVANCE(745);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1182:
      if (lookahead == 'h') ADVANCE(1214);
      END_STATE();
    case 1183:
      if (lookahead == 'h') ADVANCE(1214);
      if (lookahead == 'i') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1648);
      END_STATE();
    case 1184:
      if (lookahead == 'h') ADVANCE(538);
      END_STATE();
    case 1185:
      if (lookahead == 'h') ADVANCE(1668);
      END_STATE();
    case 1186:
      if (lookahead == 'h') ADVANCE(1330);
      END_STATE();
    case 1187:
      if (lookahead == 'h') ADVANCE(1330);
      if (lookahead == 'r') ADVANCE(304);
      END_STATE();
    case 1188:
      if (lookahead == 'h') ADVANCE(917);
      END_STATE();
    case 1189:
      if (lookahead == 'h') ADVANCE(2040);
      END_STATE();
    case 1190:
      if (lookahead == 'h') ADVANCE(1956);
      END_STATE();
    case 1191:
      if (lookahead == 'h') ADVANCE(548);
      END_STATE();
    case 1192:
      if (lookahead == 'h') ADVANCE(1994);
      END_STATE();
    case 1193:
      if (lookahead == 'h') ADVANCE(1958);
      END_STATE();
    case 1194:
      if (lookahead == 'h') ADVANCE(1986);
      END_STATE();
    case 1195:
      if (lookahead == 'h') ADVANCE(1971);
      END_STATE();
    case 1196:
      if (lookahead == 'h') ADVANCE(1217);
      END_STATE();
    case 1197:
      if (lookahead == 'h') ADVANCE(1962);
      END_STATE();
    case 1198:
      if (lookahead == 'h') ADVANCE(1964);
      END_STATE();
    case 1199:
      if (lookahead == 'h') ADVANCE(1981);
      END_STATE();
    case 1200:
      if (lookahead == 'h') ADVANCE(983);
      if (lookahead == 'r') ADVANCE(1325);
      END_STATE();
    case 1201:
      if (lookahead == 'h') ADVANCE(1966);
      END_STATE();
    case 1202:
      if (lookahead == 'h') ADVANCE(1968);
      END_STATE();
    case 1203:
      if (lookahead == 'h') ADVANCE(1965);
      END_STATE();
    case 1204:
      if (lookahead == 'h') ADVANCE(1059);
      END_STATE();
    case 1205:
      if (lookahead == 'h') ADVANCE(1251);
      END_STATE();
    case 1206:
      if (lookahead == 'h') ADVANCE(991);
      END_STATE();
    case 1207:
      if (lookahead == 'h') ADVANCE(1108);
      END_STATE();
    case 1208:
      if (lookahead == 'h') ADVANCE(1790);
      if (lookahead == 'i') ADVANCE(1488);
      if (lookahead == 'r') ADVANCE(1222);
      END_STATE();
    case 1209:
      if (lookahead == 'h') ADVANCE(1013);
      END_STATE();
    case 1210:
      if (lookahead == 'h') ADVANCE(1275);
      END_STATE();
    case 1211:
      if (lookahead == 'h') ADVANCE(1871);
      END_STATE();
    case 1212:
      if (lookahead == 'h') ADVANCE(2039);
      END_STATE();
    case 1213:
      if (lookahead == 'i') ADVANCE(872);
      END_STATE();
    case 1214:
      if (lookahead == 'i') ADVANCE(148);
      END_STATE();
    case 1215:
      if (lookahead == 'i') ADVANCE(287);
      END_STATE();
    case 1216:
      if (lookahead == 'i') ADVANCE(271);
      END_STATE();
    case 1217:
      if (lookahead == 'i') ADVANCE(821);
      END_STATE();
    case 1218:
      if (lookahead == 'i') ADVANCE(2127);
      if (lookahead == 'o') ADVANCE(1209);
      END_STATE();
    case 1219:
      if (lookahead == 'i') ADVANCE(2143);
      END_STATE();
    case 1220:
      if (lookahead == 'i') ADVANCE(265);
      END_STATE();
    case 1221:
      if (lookahead == 'i') ADVANCE(291);
      END_STATE();
    case 1222:
      if (lookahead == 'i') ADVANCE(362);
      END_STATE();
    case 1223:
      if (lookahead == 'i') ADVANCE(276);
      END_STATE();
    case 1224:
      if (lookahead == 'i') ADVANCE(1741);
      END_STATE();
    case 1225:
      if (lookahead == 'i') ADVANCE(1741);
      if (lookahead == 'r') ADVANCE(1595);
      END_STATE();
    case 1226:
      if (lookahead == 'i') ADVANCE(1507);
      END_STATE();
    case 1227:
      if (lookahead == 'i') ADVANCE(1507);
      if (lookahead == 'n') ADVANCE(1949);
      END_STATE();
    case 1228:
      if (lookahead == 'i') ADVANCE(345);
      if (lookahead == 'm') ADVANCE(1486);
      if (lookahead == 'o') ADVANCE(1529);
      END_STATE();
    case 1229:
      if (lookahead == 'i') ADVANCE(1131);
      if (lookahead == 'u') ADVANCE(744);
      END_STATE();
    case 1230:
      if (lookahead == 'i') ADVANCE(1382);
      END_STATE();
    case 1231:
      if (lookahead == 'i') ADVANCE(290);
      END_STATE();
    case 1232:
      if (lookahead == 'i') ADVANCE(1949);
      END_STATE();
    case 1233:
      if (lookahead == 'i') ADVANCE(2099);
      END_STATE();
    case 1234:
      if (lookahead == 'i') ADVANCE(867);
      END_STATE();
    case 1235:
      if (lookahead == 'i') ADVANCE(867);
      if (lookahead == 'o') ADVANCE(2083);
      END_STATE();
    case 1236:
      if (lookahead == 'i') ADVANCE(1496);
      END_STATE();
    case 1237:
      if (lookahead == 'i') ADVANCE(346);
      END_STATE();
    case 1238:
      if (lookahead == 'i') ADVANCE(1943);
      END_STATE();
    case 1239:
      if (lookahead == 'i') ADVANCE(1943);
      if (lookahead == 'p') ADVANCE(1623);
      END_STATE();
    case 1240:
      if (lookahead == 'i') ADVANCE(241);
      END_STATE();
    case 1241:
      if (lookahead == 'i') ADVANCE(1377);
      END_STATE();
    case 1242:
      if (lookahead == 'i') ADVANCE(1668);
      END_STATE();
    case 1243:
      if (lookahead == 'i') ADVANCE(1111);
      END_STATE();
    case 1244:
      if (lookahead == 'i') ADVANCE(1111);
      if (lookahead == 'l') ADVANCE(1243);
      END_STATE();
    case 1245:
      if (lookahead == 'i') ADVANCE(1093);
      END_STATE();
    case 1246:
      if (lookahead == 'i') ADVANCE(1454);
      END_STATE();
    case 1247:
      if (lookahead == 'i') ADVANCE(1454);
      if (lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 1248:
      if (lookahead == 'i') ADVANCE(1454);
      if (lookahead == 'l') ADVANCE(665);
      END_STATE();
    case 1249:
      if (lookahead == 'i') ADVANCE(1620);
      END_STATE();
    case 1250:
      if (lookahead == 'i') ADVANCE(1894);
      END_STATE();
    case 1251:
      if (lookahead == 'i') ADVANCE(1516);
      END_STATE();
    case 1252:
      if (lookahead == 'i') ADVANCE(1919);
      if (lookahead == 'l') ADVANCE(1629);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 1253:
      if (lookahead == 'i') ADVANCE(1919);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 1254:
      if (lookahead == 'i') ADVANCE(1349);
      END_STATE();
    case 1255:
      if (lookahead == 'i') ADVANCE(1124);
      END_STATE();
    case 1256:
      if (lookahead == 'i') ADVANCE(1135);
      END_STATE();
    case 1257:
      if (lookahead == 'i') ADVANCE(2060);
      END_STATE();
    case 1258:
      if (lookahead == 'i') ADVANCE(1495);
      END_STATE();
    case 1259:
      if (lookahead == 'i') ADVANCE(1379);
      END_STATE();
    case 1260:
      if (lookahead == 'i') ADVANCE(753);
      END_STATE();
    case 1261:
      if (lookahead == 'i') ADVANCE(1771);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1262:
      if (lookahead == 'i') ADVANCE(917);
      END_STATE();
    case 1263:
      if (lookahead == 'i') ADVANCE(1529);
      END_STATE();
    case 1264:
      if (lookahead == 'i') ADVANCE(679);
      END_STATE();
    case 1265:
      if (lookahead == 'i') ADVANCE(902);
      END_STATE();
    case 1266:
      if (lookahead == 'i') ADVANCE(1473);
      END_STATE();
    case 1267:
      if (lookahead == 'i') ADVANCE(1171);
      END_STATE();
    case 1268:
      if (lookahead == 'i') ADVANCE(1815);
      if (lookahead == 'l') ADVANCE(1087);
      if (lookahead == 'm') ADVANCE(1270);
      if (lookahead == 'r') ADVANCE(883);
      END_STATE();
    case 1269:
      if (lookahead == 'i') ADVANCE(1520);
      END_STATE();
    case 1270:
      if (lookahead == 'i') ADVANCE(1365);
      END_STATE();
    case 1271:
      if (lookahead == 'i') ADVANCE(984);
      END_STATE();
    case 1272:
      if (lookahead == 'i') ADVANCE(2055);
      END_STATE();
    case 1273:
      if (lookahead == 'i') ADVANCE(1560);
      END_STATE();
    case 1274:
      if (lookahead == 'i') ADVANCE(1553);
      END_STATE();
    case 1275:
      if (lookahead == 'i') ADVANCE(1498);
      END_STATE();
    case 1276:
      if (lookahead == 'i') ADVANCE(1395);
      if (lookahead == 'l') ADVANCE(1244);
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 1277:
      if (lookahead == 'i') ADVANCE(1132);
      END_STATE();
    case 1278:
      if (lookahead == 'i') ADVANCE(1383);
      END_STATE();
    case 1279:
      if (lookahead == 'i') ADVANCE(1531);
      if (lookahead == 'p') ADVANCE(1087);
      END_STATE();
    case 1280:
      if (lookahead == 'i') ADVANCE(1808);
      END_STATE();
    case 1281:
      if (lookahead == 'i') ADVANCE(1808);
      if (lookahead == 'o') ADVANCE(1379);
      END_STATE();
    case 1282:
      if (lookahead == 'i') ADVANCE(1808);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1283:
      if (lookahead == 'i') ADVANCE(1381);
      END_STATE();
    case 1284:
      if (lookahead == 'i') ADVANCE(736);
      END_STATE();
    case 1285:
      if (lookahead == 'i') ADVANCE(627);
      END_STATE();
    case 1286:
      if (lookahead == 'i') ADVANCE(1934);
      END_STATE();
    case 1287:
      if (lookahead == 'i') ADVANCE(2105);
      END_STATE();
    case 1288:
      if (lookahead == 'i') ADVANCE(1714);
      END_STATE();
    case 1289:
      if (lookahead == 'i') ADVANCE(1539);
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 'u') ADVANCE(1510);
      END_STATE();
    case 1290:
      if (lookahead == 'i') ADVANCE(1400);
      END_STATE();
    case 1291:
      if (lookahead == 'i') ADVANCE(1478);
      END_STATE();
    case 1292:
      if (lookahead == 'i') ADVANCE(1533);
      END_STATE();
    case 1293:
      if (lookahead == 'i') ADVANCE(1938);
      END_STATE();
    case 1294:
      if (lookahead == 'i') ADVANCE(1933);
      END_STATE();
    case 1295:
      if (lookahead == 'i') ADVANCE(1488);
      END_STATE();
    case 1296:
      if (lookahead == 'i') ADVANCE(1474);
      END_STATE();
    case 1297:
      if (lookahead == 'i') ADVANCE(2014);
      END_STATE();
    case 1298:
      if (lookahead == 'i') ADVANCE(1411);
      END_STATE();
    case 1299:
      if (lookahead == 'i') ADVANCE(1537);
      END_STATE();
    case 1300:
      if (lookahead == 'i') ADVANCE(1028);
      END_STATE();
    case 1301:
      if (lookahead == 'i') ADVANCE(635);
      END_STATE();
    case 1302:
      if (lookahead == 'i') ADVANCE(1430);
      END_STATE();
    case 1303:
      if (lookahead == 'i') ADVANCE(1398);
      END_STATE();
    case 1304:
      if (lookahead == 'i') ADVANCE(1637);
      END_STATE();
    case 1305:
      if (lookahead == 'i') ADVANCE(1616);
      END_STATE();
    case 1306:
      if (lookahead == 'i') ADVANCE(1554);
      END_STATE();
    case 1307:
      if (lookahead == 'i') ADVANCE(1554);
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 1308:
      if (lookahead == 'i') ADVANCE(1145);
      END_STATE();
    case 1309:
      if (lookahead == 'i') ADVANCE(1431);
      END_STATE();
    case 1310:
      if (lookahead == 'i') ADVANCE(859);
      END_STATE();
    case 1311:
      if (lookahead == 'i') ADVANCE(863);
      END_STATE();
    case 1312:
      if (lookahead == 'i') ADVANCE(737);
      END_STATE();
    case 1313:
      if (lookahead == 'i') ADVANCE(1153);
      END_STATE();
    case 1314:
      if (lookahead == 'i') ADVANCE(1154);
      END_STATE();
    case 1315:
      if (lookahead == 'i') ADVANCE(1155);
      END_STATE();
    case 1316:
      if (lookahead == 'i') ADVANCE(1156);
      END_STATE();
    case 1317:
      if (lookahead == 'i') ADVANCE(1158);
      END_STATE();
    case 1318:
      if (lookahead == 'i') ADVANCE(1160);
      END_STATE();
    case 1319:
      if (lookahead == 'i') ADVANCE(1161);
      END_STATE();
    case 1320:
      if (lookahead == 'i') ADVANCE(1163);
      END_STATE();
    case 1321:
      if (lookahead == 'i') ADVANCE(1882);
      END_STATE();
    case 1322:
      if (lookahead == 'i') ADVANCE(703);
      END_STATE();
    case 1323:
      if (lookahead == 'i') ADVANCE(1172);
      END_STATE();
    case 1324:
      if (lookahead == 'i') ADVANCE(705);
      END_STATE();
    case 1325:
      if (lookahead == 'i') ADVANCE(706);
      END_STATE();
    case 1326:
      if (lookahead == 'i') ADVANCE(707);
      END_STATE();
    case 1327:
      if (lookahead == 'i') ADVANCE(708);
      END_STATE();
    case 1328:
      if (lookahead == 'j') ADVANCE(148);
      END_STATE();
    case 1329:
      if (lookahead == 'j') ADVANCE(148);
      if (lookahead == 'n') ADVANCE(1328);
      END_STATE();
    case 1330:
      if (lookahead == 'k') ADVANCE(148);
      END_STATE();
    case 1331:
      if (lookahead == 'k') ADVANCE(507);
      END_STATE();
    case 1332:
      if (lookahead == 'k') ADVANCE(861);
      END_STATE();
    case 1333:
      if (lookahead == 'k') ADVANCE(1435);
      END_STATE();
    case 1334:
      if (lookahead == 'k') ADVANCE(1408);
      END_STATE();
    case 1335:
      if (lookahead == 'k') ADVANCE(296);
      END_STATE();
    case 1336:
      if (lookahead == 'k') ADVANCE(275);
      END_STATE();
    case 1337:
      if (lookahead == 'k') ADVANCE(745);
      END_STATE();
    case 1338:
      if (lookahead == 'k') ADVANCE(745);
      if (lookahead == 'm') ADVANCE(287);
      END_STATE();
    case 1339:
      if (lookahead == 'k') ADVANCE(2121);
      END_STATE();
    case 1340:
      if (lookahead == 'k') ADVANCE(337);
      END_STATE();
    case 1341:
      if (lookahead == 'k') ADVANCE(1930);
      END_STATE();
    case 1342:
      if (lookahead == 'k') ADVANCE(948);
      END_STATE();
    case 1343:
      if (lookahead == 'k') ADVANCE(952);
      END_STATE();
    case 1344:
      if (lookahead == 'k') ADVANCE(662);
      END_STATE();
    case 1345:
      if (lookahead == 'k') ADVANCE(669);
      END_STATE();
    case 1346:
      if (lookahead == 'k') ADVANCE(669);
      if (lookahead == 'l') ADVANCE(600);
      END_STATE();
    case 1347:
      if (lookahead == 'k') ADVANCE(1299);
      END_STATE();
    case 1348:
      if (lookahead == 'l') ADVANCE(872);
      END_STATE();
    case 1349:
      if (lookahead == 'l') ADVANCE(148);
      END_STATE();
    case 1350:
      if (lookahead == 'l') ADVANCE(334);
      END_STATE();
    case 1351:
      if (lookahead == 'l') ADVANCE(486);
      END_STATE();
    case 1352:
      if (lookahead == 'l') ADVANCE(455);
      END_STATE();
    case 1353:
      if (lookahead == 'l') ADVANCE(215);
      END_STATE();
    case 1354:
      if (lookahead == 'l') ADVANCE(281);
      END_STATE();
    case 1355:
      if (lookahead == 'l') ADVANCE(2155);
      END_STATE();
    case 1356:
      if (lookahead == 'l') ADVANCE(419);
      END_STATE();
    case 1357:
      if (lookahead == 'l') ADVANCE(406);
      END_STATE();
    case 1358:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 1359:
      if (lookahead == 'l') ADVANCE(524);
      END_STATE();
    case 1360:
      if (lookahead == 'l') ADVANCE(2133);
      END_STATE();
    case 1361:
      if (lookahead == 'l') ADVANCE(1048);
      END_STATE();
    case 1362:
      if (lookahead == 'l') ADVANCE(1048);
      if (lookahead == 'q') ADVANCE(2073);
      END_STATE();
    case 1363:
      if (lookahead == 'l') ADVANCE(1048);
      if (lookahead == 'q') ADVANCE(2072);
      if (lookahead == 'x') ADVANCE(1238);
      END_STATE();
    case 1364:
      if (lookahead == 'l') ADVANCE(471);
      END_STATE();
    case 1365:
      if (lookahead == 'l') ADVANCE(1949);
      END_STATE();
    case 1366:
      if (lookahead == 'l') ADVANCE(186);
      END_STATE();
    case 1367:
      if (lookahead == 'l') ADVANCE(464);
      END_STATE();
    case 1368:
      if (lookahead == 'l') ADVANCE(730);
      END_STATE();
    case 1369:
      if (lookahead == 'l') ADVANCE(427);
      END_STATE();
    case 1370:
      if (lookahead == 'l') ADVANCE(418);
      END_STATE();
    case 1371:
      if (lookahead == 'l') ADVANCE(509);
      END_STATE();
    case 1372:
      if (lookahead == 'l') ADVANCE(538);
      END_STATE();
    case 1373:
      if (lookahead == 'l') ADVANCE(322);
      END_STATE();
    case 1374:
      if (lookahead == 'l') ADVANCE(571);
      END_STATE();
    case 1375:
      if (lookahead == 'l') ADVANCE(246);
      END_STATE();
    case 1376:
      if (lookahead == 'l') ADVANCE(438);
      END_STATE();
    case 1377:
      if (lookahead == 'l') ADVANCE(900);
      END_STATE();
    case 1378:
      if (lookahead == 'l') ADVANCE(449);
      END_STATE();
    case 1379:
      if (lookahead == 'l') ADVANCE(1620);
      END_STATE();
    case 1380:
      if (lookahead == 'l') ADVANCE(1330);
      END_STATE();
    case 1381:
      if (lookahead == 'l') ADVANCE(887);
      END_STATE();
    case 1382:
      if (lookahead == 'l') ADVANCE(887);
      if (lookahead == 'm') ADVANCE(984);
      END_STATE();
    case 1383:
      if (lookahead == 'l') ADVANCE(887);
      if (lookahead == 'm') ADVANCE(1006);
      END_STATE();
    case 1384:
      if (lookahead == 'l') ADVANCE(968);
      END_STATE();
    case 1385:
      if (lookahead == 'l') ADVANCE(1894);
      END_STATE();
    case 1386:
      if (lookahead == 'l') ADVANCE(839);
      END_STATE();
    case 1387:
      if (lookahead == 'l') ADVANCE(1250);
      END_STATE();
    case 1388:
      if (lookahead == 'l') ADVANCE(2132);
      END_STATE();
    case 1389:
      if (lookahead == 'l') ADVANCE(1216);
      END_STATE();
    case 1390:
      if (lookahead == 'l') ADVANCE(987);
      END_STATE();
    case 1391:
      if (lookahead == 'l') ADVANCE(1349);
      END_STATE();
    case 1392:
      if (lookahead == 'l') ADVANCE(2142);
      END_STATE();
    case 1393:
      if (lookahead == 'l') ADVANCE(1629);
      END_STATE();
    case 1394:
      if (lookahead == 'l') ADVANCE(2080);
      END_STATE();
    case 1395:
      if (lookahead == 'l') ADVANCE(1243);
      END_STATE();
    case 1396:
      if (lookahead == 'l') ADVANCE(1375);
      if (lookahead == 'm') ADVANCE(1680);
      END_STATE();
    case 1397:
      if (lookahead == 'l') ADVANCE(1372);
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'u') ADVANCE(735);
      if (lookahead == 'w') ADVANCE(1499);
      END_STATE();
    case 1398:
      if (lookahead == 'l') ADVANCE(917);
      END_STATE();
    case 1399:
      if (lookahead == 'l') ADVANCE(973);
      END_STATE();
    case 1400:
      if (lookahead == 'l') ADVANCE(1359);
      END_STATE();
    case 1401:
      if (lookahead == 'l') ADVANCE(1369);
      END_STATE();
    case 1402:
      if (lookahead == 'l') ADVANCE(988);
      END_STATE();
    case 1403:
      if (lookahead == 'l') ADVANCE(1450);
      if (lookahead == 's') ADVANCE(1185);
      END_STATE();
    case 1404:
      if (lookahead == 'l') ADVANCE(1647);
      END_STATE();
    case 1405:
      if (lookahead == 'l') ADVANCE(1271);
      END_STATE();
    case 1406:
      if (lookahead == 'l') ADVANCE(1242);
      END_STATE();
    case 1407:
      if (lookahead == 'l') ADVANCE(1367);
      END_STATE();
    case 1408:
      if (lookahead == 'l') ADVANCE(1598);
      if (lookahead == 's') ADVANCE(1738);
      if (lookahead == 't') ADVANCE(1893);
      END_STATE();
    case 1409:
      if (lookahead == 'l') ADVANCE(963);
      END_STATE();
    case 1410:
      if (lookahead == 'l') ADVANCE(963);
      if (lookahead == 'q') ADVANCE(1409);
      END_STATE();
    case 1411:
      if (lookahead == 'l') ADVANCE(1284);
      END_STATE();
    case 1412:
      if (lookahead == 'l') ADVANCE(587);
      END_STATE();
    case 1413:
      if (lookahead == 'l') ADVANCE(1371);
      END_STATE();
    case 1414:
      if (lookahead == 'l') ADVANCE(934);
      END_STATE();
    case 1415:
      if (lookahead == 'l') ADVANCE(935);
      END_STATE();
    case 1416:
      if (lookahead == 'l') ADVANCE(1632);
      END_STATE();
    case 1417:
      if (lookahead == 'l') ADVANCE(924);
      END_STATE();
    case 1418:
      if (lookahead == 'l') ADVANCE(1055);
      END_STATE();
    case 1419:
      if (lookahead == 'l') ADVANCE(977);
      if (lookahead == 'r') ADVANCE(1277);
      END_STATE();
    case 1420:
      if (lookahead == 'l') ADVANCE(942);
      END_STATE();
    case 1421:
      if (lookahead == 'l') ADVANCE(943);
      END_STATE();
    case 1422:
      if (lookahead == 'l') ADVANCE(955);
      END_STATE();
    case 1423:
      if (lookahead == 'l') ADVANCE(1075);
      END_STATE();
    case 1424:
      if (lookahead == 'l') ADVANCE(965);
      END_STATE();
    case 1425:
      if (lookahead == 'l') ADVANCE(945);
      END_STATE();
    case 1426:
      if (lookahead == 'l') ADVANCE(946);
      END_STATE();
    case 1427:
      if (lookahead == 'l') ADVANCE(947);
      END_STATE();
    case 1428:
      if (lookahead == 'l') ADVANCE(974);
      END_STATE();
    case 1429:
      if (lookahead == 'l') ADVANCE(600);
      END_STATE();
    case 1430:
      if (lookahead == 'l') ADVANCE(1251);
      END_STATE();
    case 1431:
      if (lookahead == 'l') ADVANCE(894);
      END_STATE();
    case 1432:
      if (lookahead == 'l') ADVANCE(894);
      if (lookahead == 'm') ADVANCE(978);
      if (lookahead == 'n') ADVANCE(1949);
      END_STATE();
    case 1433:
      if (lookahead == 'l') ADVANCE(1622);
      if (lookahead == 'n') ADVANCE(1140);
      if (lookahead == 'p') ADVANCE(1089);
      if (lookahead == 'u') ADVANCE(1561);
      END_STATE();
    case 1434:
      if (lookahead == 'l') ADVANCE(543);
      END_STATE();
    case 1435:
      if (lookahead == 'l') ADVANCE(959);
      if (lookahead == 'r') ADVANCE(1308);
      END_STATE();
    case 1436:
      if (lookahead == 'l') ADVANCE(1040);
      END_STATE();
    case 1437:
      if (lookahead == 'l') ADVANCE(1039);
      END_STATE();
    case 1438:
      if (lookahead == 'l') ADVANCE(655);
      END_STATE();
    case 1439:
      if (lookahead == 'l') ADVANCE(2056);
      END_STATE();
    case 1440:
      if (lookahead == 'l') ADVANCE(1402);
      END_STATE();
    case 1441:
      if (lookahead == 'l') ADVANCE(601);
      END_STATE();
    case 1442:
      if (lookahead == 'l') ADVANCE(1292);
      END_STATE();
    case 1443:
      if (lookahead == 'l') ADVANCE(1627);
      if (lookahead == 'm') ADVANCE(1483);
      if (lookahead == 'n') ADVANCE(1116);
      if (lookahead == 'p') ADVANCE(266);
      END_STATE();
    case 1444:
      if (lookahead == 'l') ADVANCE(1840);
      END_STATE();
    case 1445:
      if (lookahead == 'l') ADVANCE(1226);
      END_STATE();
    case 1446:
      if (lookahead == 'l') ADVANCE(1387);
      END_STATE();
    case 1447:
      if (lookahead == 'l') ADVANCE(1274);
      END_STATE();
    case 1448:
      if (lookahead == 'l') ADVANCE(1390);
      END_STATE();
    case 1449:
      if (lookahead == 'l') ADVANCE(677);
      END_STATE();
    case 1450:
      if (lookahead == 'l') ADVANCE(1946);
      END_STATE();
    case 1451:
      if (lookahead == 'l') ADVANCE(1442);
      END_STATE();
    case 1452:
      if (lookahead == 'l') ADVANCE(1043);
      if (lookahead == 'm') ADVANCE(622);
      if (lookahead == 'r') ADVANCE(1308);
      END_STATE();
    case 1453:
      if (lookahead == 'l') ADVANCE(1070);
      if (lookahead == 'r') ADVANCE(1320);
      END_STATE();
    case 1454:
      if (lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 1455:
      if (lookahead == 'm') ADVANCE(287);
      END_STATE();
    case 1456:
      if (lookahead == 'm') ADVANCE(287);
      if (lookahead == 'r') ADVANCE(1579);
      END_STATE();
    case 1457:
      if (lookahead == 'm') ADVANCE(507);
      END_STATE();
    case 1458:
      if (lookahead == 'm') ADVANCE(308);
      END_STATE();
    case 1459:
      if (lookahead == 'm') ADVANCE(358);
      END_STATE();
    case 1460:
      if (lookahead == 'm') ADVANCE(357);
      END_STATE();
    case 1461:
      if (lookahead == 'm') ADVANCE(524);
      END_STATE();
    case 1462:
      if (lookahead == 'm') ADVANCE(1307);
      END_STATE();
    case 1463:
      if (lookahead == 'm') ADVANCE(1214);
      END_STATE();
    case 1464:
      if (lookahead == 'm') ADVANCE(241);
      END_STATE();
    case 1465:
      if (lookahead == 'm') ADVANCE(1668);
      END_STATE();
    case 1466:
      if (lookahead == 'm') ADVANCE(1698);
      END_STATE();
    case 1467:
      if (lookahead == 'm') ADVANCE(1679);
      END_STATE();
    case 1468:
      if (lookahead == 'm') ADVANCE(1213);
      END_STATE();
    case 1469:
      if (lookahead == 'm') ADVANCE(1213);
      if (lookahead == 'p') ADVANCE(674);
      END_STATE();
    case 1470:
      if (lookahead == 'm') ADVANCE(1461);
      END_STATE();
    case 1471:
      if (lookahead == 'm') ADVANCE(249);
      END_STATE();
    case 1472:
      if (lookahead == 'm') ADVANCE(1702);
      END_STATE();
    case 1473:
      if (lookahead == 'm') ADVANCE(250);
      END_STATE();
    case 1474:
      if (lookahead == 'm') ADVANCE(564);
      END_STATE();
    case 1475:
      if (lookahead == 'm') ADVANCE(987);
      END_STATE();
    case 1476:
      if (lookahead == 'm') ADVANCE(1349);
      END_STATE();
    case 1477:
      if (lookahead == 'm') ADVANCE(1495);
      END_STATE();
    case 1478:
      if (lookahead == 'm') ADVANCE(917);
      END_STATE();
    case 1479:
      if (lookahead == 'm') ADVANCE(1694);
      END_STATE();
    case 1480:
      if (lookahead == 'm') ADVANCE(1689);
      END_STATE();
    case 1481:
      if (lookahead == 'm') ADVANCE(679);
      END_STATE();
    case 1482:
      if (lookahead == 'm') ADVANCE(552);
      END_STATE();
    case 1483:
      if (lookahead == 'm') ADVANCE(559);
      if (lookahead == 'p') ADVANCE(269);
      END_STATE();
    case 1484:
      if (lookahead == 'm') ADVANCE(950);
      END_STATE();
    case 1485:
      if (lookahead == 'm') ADVANCE(950);
      if (lookahead == 'x') ADVANCE(984);
      END_STATE();
    case 1486:
      if (lookahead == 'm') ADVANCE(548);
      END_STATE();
    case 1487:
      if (lookahead == 'm') ADVANCE(532);
      END_STATE();
    case 1488:
      if (lookahead == 'm') ADVANCE(984);
      END_STATE();
    case 1489:
      if (lookahead == 'm') ADVANCE(1710);
      END_STATE();
    case 1490:
      if (lookahead == 'm') ADVANCE(970);
      END_STATE();
    case 1491:
      if (lookahead == 'm') ADVANCE(1482);
      END_STATE();
    case 1492:
      if (lookahead == 'm') ADVANCE(1306);
      END_STATE();
    case 1493:
      if (lookahead == 'm') ADVANCE(673);
      END_STATE();
    case 1494:
      if (lookahead == 'n') ADVANCE(872);
      END_STATE();
    case 1495:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 1496:
      if (lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 1497:
      if (lookahead == 'n') ADVANCE(415);
      END_STATE();
    case 1498:
      if (lookahead == 'n') ADVANCE(507);
      END_STATE();
    case 1499:
      if (lookahead == 'n') ADVANCE(687);
      END_STATE();
    case 1500:
      if (lookahead == 'n') ADVANCE(352);
      END_STATE();
    case 1501:
      if (lookahead == 'n') ADVANCE(831);
      END_STATE();
    case 1502:
      if (lookahead == 'n') ADVANCE(2150);
      END_STATE();
    case 1503:
      if (lookahead == 'n') ADVANCE(166);
      END_STATE();
    case 1504:
      if (lookahead == 'n') ADVANCE(514);
      END_STATE();
    case 1505:
      if (lookahead == 'n') ADVANCE(518);
      END_STATE();
    case 1506:
      if (lookahead == 'n') ADVANCE(184);
      END_STATE();
    case 1507:
      if (lookahead == 'n') ADVANCE(1949);
      END_STATE();
    case 1508:
      if (lookahead == 'n') ADVANCE(429);
      END_STATE();
    case 1509:
      if (lookahead == 'n') ADVANCE(480);
      END_STATE();
    case 1510:
      if (lookahead == 'n') ADVANCE(235);
      END_STATE();
    case 1511:
      if (lookahead == 'n') ADVANCE(2126);
      END_STATE();
    case 1512:
      if (lookahead == 'n') ADVANCE(409);
      END_STATE();
    case 1513:
      if (lookahead == 'n') ADVANCE(1109);
      END_STATE();
    case 1514:
      if (lookahead == 'n') ADVANCE(907);
      END_STATE();
    case 1515:
      if (lookahead == 'n') ADVANCE(241);
      END_STATE();
    case 1516:
      if (lookahead == 'n') ADVANCE(1111);
      END_STATE();
    case 1517:
      if (lookahead == 'n') ADVANCE(1111);
      if (lookahead == 'r') ADVANCE(1741);
      END_STATE();
    case 1518:
      if (lookahead == 'n') ADVANCE(2009);
      END_STATE();
    case 1519:
      if (lookahead == 'n') ADVANCE(1117);
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 'w') ADVANCE(1018);
      END_STATE();
    case 1520:
      if (lookahead == 'n') ADVANCE(342);
      END_STATE();
    case 1521:
      if (lookahead == 'n') ADVANCE(1330);
      END_STATE();
    case 1522:
      if (lookahead == 'n') ADVANCE(249);
      END_STATE();
    case 1523:
      if (lookahead == 'n') ADVANCE(1894);
      END_STATE();
    case 1524:
      if (lookahead == 'n') ADVANCE(880);
      END_STATE();
    case 1525:
      if (lookahead == 'n') ADVANCE(244);
      END_STATE();
    case 1526:
      if (lookahead == 'n') ADVANCE(1141);
      if (lookahead == 'r') ADVANCE(998);
      END_STATE();
    case 1527:
      if (lookahead == 'n') ADVANCE(837);
      END_STATE();
    case 1528:
      if (lookahead == 'n') ADVANCE(1157);
      END_STATE();
    case 1529:
      if (lookahead == 'n') ADVANCE(917);
      END_STATE();
    case 1530:
      if (lookahead == 'n') ADVANCE(1115);
      END_STATE();
    case 1531:
      if (lookahead == 'n') ADVANCE(865);
      END_STATE();
    case 1532:
      if (lookahead == 'n') ADVANCE(1625);
      END_STATE();
    case 1533:
      if (lookahead == 'n') ADVANCE(1143);
      END_STATE();
    case 1534:
      if (lookahead == 'n') ADVANCE(890);
      END_STATE();
    case 1535:
      if (lookahead == 'n') ADVANCE(1170);
      END_STATE();
    case 1536:
      if (lookahead == 'n') ADVANCE(948);
      END_STATE();
    case 1537:
      if (lookahead == 'n') ADVANCE(1118);
      END_STATE();
    case 1538:
      if (lookahead == 'n') ADVANCE(860);
      END_STATE();
    case 1539:
      if (lookahead == 'n') ADVANCE(2027);
      END_STATE();
    case 1540:
      if (lookahead == 'n') ADVANCE(1960);
      END_STATE();
    case 1541:
      if (lookahead == 'n') ADVANCE(1974);
      END_STATE();
    case 1542:
      if (lookahead == 'n') ADVANCE(1999);
      END_STATE();
    case 1543:
      if (lookahead == 'n') ADVANCE(2001);
      END_STATE();
    case 1544:
      if (lookahead == 'n') ADVANCE(979);
      END_STATE();
    case 1545:
      if (lookahead == 'n') ADVANCE(982);
      END_STATE();
    case 1546:
      if (lookahead == 'n') ADVANCE(1419);
      END_STATE();
    case 1547:
      if (lookahead == 'n') ADVANCE(2058);
      END_STATE();
    case 1548:
      if (lookahead == 'n') ADVANCE(201);
      END_STATE();
    case 1549:
      if (lookahead == 'n') ADVANCE(1136);
      END_STATE();
    case 1550:
      if (lookahead == 'n') ADVANCE(1139);
      END_STATE();
    case 1551:
      if (lookahead == 'n') ADVANCE(1064);
      END_STATE();
    case 1552:
      if (lookahead == 'n') ADVANCE(1249);
      END_STATE();
    case 1553:
      if (lookahead == 'n') ADVANCE(2017);
      END_STATE();
    case 1554:
      if (lookahead == 'n') ADVANCE(2056);
      END_STATE();
    case 1555:
      if (lookahead == 'n') ADVANCE(1630);
      END_STATE();
    case 1556:
      if (lookahead == 'n') ADVANCE(2018);
      END_STATE();
    case 1557:
      if (lookahead == 'n') ADVANCE(1226);
      END_STATE();
    case 1558:
      if (lookahead == 'n') ADVANCE(2016);
      END_STATE();
    case 1559:
      if (lookahead == 'n') ADVANCE(2036);
      END_STATE();
    case 1560:
      if (lookahead == 'n') ADVANCE(647);
      END_STATE();
    case 1561:
      if (lookahead == 'n') ADVANCE(2028);
      END_STATE();
    case 1562:
      if (lookahead == 'n') ADVANCE(1162);
      END_STATE();
    case 1563:
      if (lookahead == 'n') ADVANCE(2026);
      END_STATE();
    case 1564:
      if (lookahead == 'n') ADVANCE(1305);
      END_STATE();
    case 1565:
      if (lookahead == 'n') ADVANCE(1067);
      END_STATE();
    case 1566:
      if (lookahead == 'n') ADVANCE(1164);
      if (lookahead == 'r') ADVANCE(1844);
      END_STATE();
    case 1567:
      if (lookahead == 'n') ADVANCE(1164);
      if (lookahead == 'r') ADVANCE(1848);
      END_STATE();
    case 1568:
      if (lookahead == 'n') ADVANCE(2030);
      END_STATE();
    case 1569:
      if (lookahead == 'n') ADVANCE(1165);
      END_STATE();
    case 1570:
      if (lookahead == 'n') ADVANCE(1166);
      END_STATE();
    case 1571:
      if (lookahead == 'n') ADVANCE(2032);
      END_STATE();
    case 1572:
      if (lookahead == 'n') ADVANCE(1167);
      END_STATE();
    case 1573:
      if (lookahead == 'n') ADVANCE(1168);
      END_STATE();
    case 1574:
      if (lookahead == 'n') ADVANCE(1169);
      END_STATE();
    case 1575:
      if (lookahead == 'n') ADVANCE(2037);
      END_STATE();
    case 1576:
      if (lookahead == 'n') ADVANCE(696);
      END_STATE();
    case 1577:
      if (lookahead == 'n') ADVANCE(685);
      END_STATE();
    case 1578:
      if (lookahead == 'o') ADVANCE(872);
      END_STATE();
    case 1579:
      if (lookahead == 'o') ADVANCE(148);
      END_STATE();
    case 1580:
      if (lookahead == 'o') ADVANCE(318);
      END_STATE();
    case 1581:
      if (lookahead == 'o') ADVANCE(1087);
      END_STATE();
    case 1582:
      if (lookahead == 'o') ADVANCE(2117);
      END_STATE();
    case 1583:
      if (lookahead == 'o') ADVANCE(519);
      END_STATE();
    case 1584:
      if (lookahead == 'o') ADVANCE(2097);
      END_STATE();
    case 1585:
      if (lookahead == 'o') ADVANCE(238);
      END_STATE();
    case 1586:
      if (lookahead == 'o') ADVANCE(1951);
      END_STATE();
    case 1587:
      if (lookahead == 'o') ADVANCE(1950);
      END_STATE();
    case 1588:
      if (lookahead == 'o') ADVANCE(1741);
      END_STATE();
    case 1589:
      if (lookahead == 'o') ADVANCE(1949);
      END_STATE();
    case 1590:
      if (lookahead == 'o') ADVANCE(1949);
      if (lookahead == 's') ADVANCE(2050);
      END_STATE();
    case 1591:
      if (lookahead == 'o') ADVANCE(298);
      END_STATE();
    case 1592:
      if (lookahead == 'o') ADVANCE(2128);
      END_STATE();
    case 1593:
      if (lookahead == 'o') ADVANCE(820);
      END_STATE();
    case 1594:
      if (lookahead == 'o') ADVANCE(2126);
      END_STATE();
    case 1595:
      if (lookahead == 'o') ADVANCE(1920);
      END_STATE();
    case 1596:
      if (lookahead == 'o') ADVANCE(333);
      END_STATE();
    case 1597:
      if (lookahead == 'o') ADVANCE(2107);
      END_STATE();
    case 1598:
      if (lookahead == 'o') ADVANCE(2146);
      END_STATE();
    case 1599:
      if (lookahead == 'o') ADVANCE(1668);
      END_STATE();
    case 1600:
      if (lookahead == 'o') ADVANCE(1557);
      END_STATE();
    case 1601:
      if (lookahead == 'o') ADVANCE(2108);
      END_STATE();
    case 1602:
      if (lookahead == 'o') ADVANCE(2109);
      END_STATE();
    case 1603:
      if (lookahead == 'o') ADVANCE(1454);
      END_STATE();
    case 1604:
      if (lookahead == 'o') ADVANCE(1330);
      END_STATE();
    case 1605:
      if (lookahead == 'o') ADVANCE(2004);
      END_STATE();
    case 1606:
      if (lookahead == 'o') ADVANCE(2110);
      END_STATE();
    case 1607:
      if (lookahead == 'o') ADVANCE(2122);
      END_STATE();
    case 1608:
      if (lookahead == 'o') ADVANCE(1894);
      END_STATE();
    case 1609:
      if (lookahead == 'o') ADVANCE(1516);
      END_STATE();
    case 1610:
      if (lookahead == 'o') ADVANCE(1516);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1611:
      if (lookahead == 'o') ADVANCE(2123);
      END_STATE();
    case 1612:
      if (lookahead == 'o') ADVANCE(2116);
      END_STATE();
    case 1613:
      if (lookahead == 'o') ADVANCE(2111);
      END_STATE();
    case 1614:
      if (lookahead == 'o') ADVANCE(1349);
      if (lookahead == 'u') ADVANCE(709);
      END_STATE();
    case 1615:
      if (lookahead == 'o') ADVANCE(895);
      END_STATE();
    case 1616:
      if (lookahead == 'o') ADVANCE(1523);
      END_STATE();
    case 1617:
      if (lookahead == 'o') ADVANCE(2114);
      END_STATE();
    case 1618:
      if (lookahead == 'o') ADVANCE(1955);
      END_STATE();
    case 1619:
      if (lookahead == 'o') ADVANCE(1795);
      END_STATE();
    case 1620:
      if (lookahead == 'o') ADVANCE(1495);
      END_STATE();
    case 1621:
      if (lookahead == 'o') ADVANCE(1495);
      if (lookahead == 'r') ADVANCE(556);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 1622:
      if (lookahead == 'o') ADVANCE(1515);
      END_STATE();
    case 1623:
      if (lookahead == 'o') ADVANCE(1551);
      END_STATE();
    case 1624:
      if (lookahead == 'o') ADVANCE(1506);
      END_STATE();
    case 1625:
      if (lookahead == 'o') ADVANCE(2093);
      END_STATE();
    case 1626:
      if (lookahead == 'o') ADVANCE(1494);
      END_STATE();
    case 1627:
      if (lookahead == 'o') ADVANCE(1522);
      END_STATE();
    case 1628:
      if (lookahead == 'o') ADVANCE(2095);
      END_STATE();
    case 1629:
      if (lookahead == 'o') ADVANCE(1588);
      END_STATE();
    case 1630:
      if (lookahead == 'o') ADVANCE(2041);
      END_STATE();
    case 1631:
      if (lookahead == 'o') ADVANCE(1348);
      END_STATE();
    case 1632:
      if (lookahead == 'o') ADVANCE(819);
      END_STATE();
    case 1633:
      if (lookahead == 'o') ADVANCE(1990);
      END_STATE();
    case 1634:
      if (lookahead == 'o') ADVANCE(1992);
      END_STATE();
    case 1635:
      if (lookahead == 'o') ADVANCE(2034);
      END_STATE();
    case 1636:
      if (lookahead == 'o') ADVANCE(1546);
      END_STATE();
    case 1637:
      if (lookahead == 'o') ADVANCE(1548);
      END_STATE();
    case 1638:
      if (lookahead == 'o') ADVANCE(1514);
      END_STATE();
    case 1639:
      if (lookahead == 'o') ADVANCE(1807);
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 1640:
      if (lookahead == 'o') ADVANCE(1832);
      END_STATE();
    case 1641:
      if (lookahead == 'o') ADVANCE(1834);
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 1642:
      if (lookahead == 'o') ADVANCE(1758);
      END_STATE();
    case 1643:
      if (lookahead == 'o') ADVANCE(2118);
      END_STATE();
    case 1644:
      if (lookahead == 'o') ADVANCE(1470);
      END_STATE();
    case 1645:
      if (lookahead == 'o') ADVANCE(1470);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 1646:
      if (lookahead == 'o') ADVANCE(1813);
      END_STATE();
    case 1647:
      if (lookahead == 'o') ADVANCE(1697);
      END_STATE();
    case 1648:
      if (lookahead == 'o') ADVANCE(1708);
      END_STATE();
    case 1649:
      if (lookahead == 'o') ADVANCE(2077);
      END_STATE();
    case 1650:
      if (lookahead == 'o') ADVANCE(2124);
      END_STATE();
    case 1651:
      if (lookahead == 'o') ADVANCE(2119);
      END_STATE();
    case 1652:
      if (lookahead == 'o') ADVANCE(2083);
      END_STATE();
    case 1653:
      if (lookahead == 'o') ADVANCE(1998);
      END_STATE();
    case 1654:
      if (lookahead == 'o') ADVANCE(1550);
      if (lookahead == 'u') ADVANCE(1688);
      END_STATE();
    case 1655:
      if (lookahead == 'o') ADVANCE(2120);
      END_STATE();
    case 1656:
      if (lookahead == 'o') ADVANCE(1563);
      END_STATE();
    case 1657:
      if (lookahead == 'o') ADVANCE(1828);
      END_STATE();
    case 1658:
      if (lookahead == 'o') ADVANCE(1636);
      END_STATE();
    case 1659:
      if (lookahead == 'o') ADVANCE(1809);
      END_STATE();
    case 1660:
      if (lookahead == 'o') ADVANCE(1542);
      END_STATE();
    case 1661:
      if (lookahead == 'o') ADVANCE(1616);
      END_STATE();
    case 1662:
      if (lookahead == 'o') ADVANCE(1638);
      END_STATE();
    case 1663:
      if (lookahead == 'o') ADVANCE(1874);
      END_STATE();
    case 1664:
      if (lookahead == 'o') ADVANCE(1445);
      END_STATE();
    case 1665:
      if (lookahead == 'o') ADVANCE(2098);
      END_STATE();
    case 1666:
      if (lookahead == 'o') ADVANCE(2125);
      END_STATE();
    case 1667:
      if (lookahead == 'p') ADVANCE(1945);
      END_STATE();
    case 1668:
      if (lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 1669:
      if (lookahead == 'p') ADVANCE(148);
      if (lookahead == 'r') ADVANCE(1620);
      END_STATE();
    case 1670:
      if (lookahead == 'p') ADVANCE(1177);
      END_STATE();
    case 1671:
      if (lookahead == 'p') ADVANCE(1087);
      END_STATE();
    case 1672:
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 'r') ADVANCE(666);
      END_STATE();
    case 1673:
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 'r') ADVANCE(407);
      if (lookahead == 'u') ADVANCE(1825);
      END_STATE();
    case 1674:
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 'r') ADVANCE(1219);
      END_STATE();
    case 1675:
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 't') ADVANCE(161);
      if (lookahead == 'u') ADVANCE(734);
      if (lookahead == 'w') ADVANCE(1497);
      END_STATE();
    case 1676:
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 't') ADVANCE(341);
      if (lookahead == 'w') ADVANCE(2010);
      if (lookahead == 'x') ADVANCE(442);
      END_STATE();
    case 1677:
      if (lookahead == 'p') ADVANCE(1087);
      if (lookahead == 'u') ADVANCE(1524);
      END_STATE();
    case 1678:
      if (lookahead == 'p') ADVANCE(160);
      END_STATE();
    case 1679:
      if (lookahead == 'p') ADVANCE(451);
      END_STATE();
    case 1680:
      if (lookahead == 'p') ADVANCE(167);
      END_STATE();
    case 1681:
      if (lookahead == 'p') ADVANCE(141);
      END_STATE();
    case 1682:
      if (lookahead == 'p') ADVANCE(452);
      END_STATE();
    case 1683:
      if (lookahead == 'p') ADVANCE(410);
      END_STATE();
    case 1684:
      if (lookahead == 'p') ADVANCE(1741);
      if (lookahead == 's') ADVANCE(753);
      END_STATE();
    case 1685:
      if (lookahead == 'p') ADVANCE(524);
      END_STATE();
    case 1686:
      if (lookahead == 'p') ADVANCE(312);
      END_STATE();
    case 1687:
      if (lookahead == 'p') ADVANCE(409);
      END_STATE();
    case 1688:
      if (lookahead == 'p') ADVANCE(425);
      END_STATE();
    case 1689:
      if (lookahead == 'p') ADVANCE(241);
      END_STATE();
    case 1690:
      if (lookahead == 'p') ADVANCE(322);
      END_STATE();
    case 1691:
      if (lookahead == 'p') ADVANCE(1174);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 1692:
      if (lookahead == 'p') ADVANCE(1685);
      END_STATE();
    case 1693:
      if (lookahead == 'p') ADVANCE(1894);
      if (lookahead == 'r') ADVANCE(1620);
      END_STATE();
    case 1694:
      if (lookahead == 'p') ADVANCE(250);
      END_STATE();
    case 1695:
      if (lookahead == 'p') ADVANCE(1360);
      END_STATE();
    case 1696:
      if (lookahead == 'p') ADVANCE(1705);
      END_STATE();
    case 1697:
      if (lookahead == 'p') ADVANCE(917);
      END_STATE();
    case 1698:
      if (lookahead == 'p') ADVANCE(964);
      END_STATE();
    case 1699:
      if (lookahead == 'p') ADVANCE(1439);
      END_STATE();
    case 1700:
      if (lookahead == 'p') ADVANCE(1439);
      if (lookahead == 't') ADVANCE(1776);
      END_STATE();
    case 1701:
      if (lookahead == 'p') ADVANCE(1917);
      END_STATE();
    case 1702:
      if (lookahead == 'p') ADVANCE(1989);
      END_STATE();
    case 1703:
      if (lookahead == 'p') ADVANCE(1715);
      END_STATE();
    case 1704:
      if (lookahead == 'p') ADVANCE(1715);
      if (lookahead == 'r') ADVANCE(1741);
      END_STATE();
    case 1705:
      if (lookahead == 'p') ADVANCE(544);
      END_STATE();
    case 1706:
      if (lookahead == 'p') ADVANCE(1658);
      END_STATE();
    case 1707:
      if (lookahead == 'p') ADVANCE(1441);
      END_STATE();
    case 1708:
      if (lookahead == 'p') ADVANCE(1980);
      END_STATE();
    case 1709:
      if (lookahead == 'p') ADVANCE(1608);
      END_STATE();
    case 1710:
      if (lookahead == 'p') ADVANCE(1405);
      END_STATE();
    case 1711:
      if (lookahead == 'p') ADVANCE(663);
      END_STATE();
    case 1712:
      if (lookahead == 'p') ADVANCE(1935);
      END_STATE();
    case 1713:
      if (lookahead == 'p') ADVANCE(1840);
      if (lookahead == 's') ADVANCE(2068);
      END_STATE();
    case 1714:
      if (lookahead == 'p') ADVANCE(1417);
      END_STATE();
    case 1715:
      if (lookahead == 'p') ADVANCE(1820);
      END_STATE();
    case 1716:
      if (lookahead == 'p') ADVANCE(645);
      END_STATE();
    case 1717:
      if (lookahead == 'p') ADVANCE(694);
      END_STATE();
    case 1718:
      if (lookahead == 'p') ADVANCE(463);
      END_STATE();
    case 1719:
      if (lookahead == 'p') ADVANCE(1662);
      END_STATE();
    case 1720:
      if (lookahead == 'p') ADVANCE(678);
      END_STATE();
    case 1721:
      if (lookahead == 'p') ADVANCE(1661);
      END_STATE();
    case 1722:
      if (lookahead == 'p') ADVANCE(696);
      END_STATE();
    case 1723:
      if (lookahead == 'q') ADVANCE(148);
      END_STATE();
    case 1724:
      if (lookahead == 'q') ADVANCE(233);
      END_STATE();
    case 1725:
      if (lookahead == 'q') ADVANCE(1410);
      END_STATE();
    case 1726:
      if (lookahead == 'q') ADVANCE(1148);
      END_STATE();
    case 1727:
      if (lookahead == 'q') ADVANCE(1713);
      END_STATE();
    case 1728:
      if (lookahead == 'q') ADVANCE(313);
      END_STATE();
    case 1729:
      if (lookahead == 'q') ADVANCE(1723);
      END_STATE();
    case 1730:
      if (lookahead == 'q') ADVANCE(2044);
      END_STATE();
    case 1731:
      if (lookahead == 'q') ADVANCE(2063);
      END_STATE();
    case 1732:
      if (lookahead == 'q') ADVANCE(2096);
      if (lookahead == 'u') ADVANCE(732);
      END_STATE();
    case 1733:
      if (lookahead == 'q') ADVANCE(2084);
      END_STATE();
    case 1734:
      if (lookahead == 'q') ADVANCE(2073);
      END_STATE();
    case 1735:
      if (lookahead == 'q') ADVANCE(838);
      if (lookahead == 't') ADVANCE(538);
      END_STATE();
    case 1736:
      if (lookahead == 'q') ADVANCE(2087);
      END_STATE();
    case 1737:
      if (lookahead == 'q') ADVANCE(2091);
      END_STATE();
    case 1738:
      if (lookahead == 'q') ADVANCE(2094);
      END_STATE();
    case 1739:
      if (lookahead == 'r') ADVANCE(872);
      END_STATE();
    case 1740:
      if (lookahead == 'r') ADVANCE(926);
      END_STATE();
    case 1741:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 1742:
      if (lookahead == 'r') ADVANCE(432);
      END_STATE();
    case 1743:
      if (lookahead == 'r') ADVANCE(297);
      END_STATE();
    case 1744:
      if (lookahead == 'r') ADVANCE(1087);
      END_STATE();
    case 1745:
      if (lookahead == 'r') ADVANCE(350);
      END_STATE();
    case 1746:
      if (lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 1747:
      if (lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 1748:
      if (lookahead == 'r') ADVANCE(796);
      END_STATE();
    case 1749:
      if (lookahead == 'r') ADVANCE(416);
      END_STATE();
    case 1750:
      if (lookahead == 'r') ADVANCE(2159);
      END_STATE();
    case 1751:
      if (lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 1752:
      if (lookahead == 'r') ADVANCE(218);
      END_STATE();
    case 1753:
      if (lookahead == 'r') ADVANCE(1187);
      END_STATE();
    case 1754:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 1755:
      if (lookahead == 'r') ADVANCE(489);
      END_STATE();
    case 1756:
      if (lookahead == 'r') ADVANCE(356);
      END_STATE();
    case 1757:
      if (lookahead == 'r') ADVANCE(2164);
      END_STATE();
    case 1758:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 1759:
      if (lookahead == 'r') ADVANCE(171);
      END_STATE();
    case 1760:
      if (lookahead == 'r') ADVANCE(1741);
      END_STATE();
    case 1761:
      if (lookahead == 'r') ADVANCE(303);
      END_STATE();
    case 1762:
      if (lookahead == 'r') ADVANCE(471);
      END_STATE();
    case 1763:
      if (lookahead == 'r') ADVANCE(746);
      END_STATE();
    case 1764:
      if (lookahead == 'r') ADVANCE(345);
      END_STATE();
    case 1765:
      if (lookahead == 'r') ADVANCE(273);
      END_STATE();
    case 1766:
      if (lookahead == 'r') ADVANCE(1949);
      END_STATE();
    case 1767:
      if (lookahead == 'r') ADVANCE(1949);
      if (lookahead == 'u') ADVANCE(680);
      END_STATE();
    case 1768:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 1769:
      if (lookahead == 'r') ADVANCE(899);
      END_STATE();
    case 1770:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 1771:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 1772:
      if (lookahead == 'r') ADVANCE(208);
      END_STATE();
    case 1773:
      if (lookahead == 'r') ADVANCE(483);
      END_STATE();
    case 1774:
      if (lookahead == 'r') ADVANCE(745);
      END_STATE();
    case 1775:
      if (lookahead == 'r') ADVANCE(575);
      END_STATE();
    case 1776:
      if (lookahead == 'r') ADVANCE(1214);
      END_STATE();
    case 1777:
      if (lookahead == 'r') ADVANCE(305);
      END_STATE();
    case 1778:
      if (lookahead == 'r') ADVANCE(289);
      END_STATE();
    case 1779:
      if (lookahead == 'r') ADVANCE(294);
      END_STATE();
    case 1780:
      if (lookahead == 'r') ADVANCE(875);
      END_STATE();
    case 1781:
      if (lookahead == 'r') ADVANCE(867);
      END_STATE();
    case 1782:
      if (lookahead == 'r') ADVANCE(1579);
      END_STATE();
    case 1783:
      if (lookahead == 'r') ADVANCE(299);
      END_STATE();
    case 1784:
      if (lookahead == 'r') ADVANCE(1340);
      END_STATE();
    case 1785:
      if (lookahead == 'r') ADVANCE(328);
      END_STATE();
    case 1786:
      if (lookahead == 'r') ADVANCE(428);
      END_STATE();
    case 1787:
      if (lookahead == 'r') ADVANCE(338);
      END_STATE();
    case 1788:
      if (lookahead == 'r') ADVANCE(857);
      END_STATE();
    case 1789:
      if (lookahead == 'r') ADVANCE(1668);
      END_STATE();
    case 1790:
      if (lookahead == 'r') ADVANCE(994);
      END_STATE();
    case 1791:
      if (lookahead == 'r') ADVANCE(2009);
      END_STATE();
    case 1792:
      if (lookahead == 'r') ADVANCE(302);
      END_STATE();
    case 1793:
      if (lookahead == 'r') ADVANCE(529);
      END_STATE();
    case 1794:
      if (lookahead == 'r') ADVANCE(1620);
      END_STATE();
    case 1795:
      if (lookahead == 'r') ADVANCE(1330);
      END_STATE();
    case 1796:
      if (lookahead == 'r') ADVANCE(2136);
      END_STATE();
    case 1797:
      if (lookahead == 'r') ADVANCE(2138);
      END_STATE();
    case 1798:
      if (lookahead == 'r') ADVANCE(1583);
      if (lookahead == 't') ADVANCE(524);
      END_STATE();
    case 1799:
      if (lookahead == 'r') ADVANCE(1894);
      END_STATE();
    case 1800:
      if (lookahead == 'r') ADVANCE(987);
      END_STATE();
    case 1801:
      if (lookahead == 'r') ADVANCE(1578);
      END_STATE();
    case 1802:
      if (lookahead == 'r') ADVANCE(556);
      END_STATE();
    case 1803:
      if (lookahead == 'r') ADVANCE(2115);
      END_STATE();
    case 1804:
      if (lookahead == 'r') ADVANCE(2137);
      END_STATE();
    case 1805:
      if (lookahead == 'r') ADVANCE(1045);
      END_STATE();
    case 1806:
      if (lookahead == 'r') ADVANCE(1186);
      END_STATE();
    case 1807:
      if (lookahead == 'r') ADVANCE(1495);
      END_STATE();
    case 1808:
      if (lookahead == 'r') ADVANCE(753);
      END_STATE();
    case 1809:
      if (lookahead == 'r') ADVANCE(917);
      END_STATE();
    case 1810:
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 1811:
      if (lookahead == 'r') ADVANCE(1291);
      END_STATE();
    case 1812:
      if (lookahead == 'r') ADVANCE(1604);
      END_STATE();
    case 1813:
      if (lookahead == 'r') ADVANCE(1957);
      END_STATE();
    case 1814:
      if (lookahead == 'r') ADVANCE(1592);
      END_STATE();
    case 1815:
      if (lookahead == 'r') ADVANCE(1914);
      END_STATE();
    case 1816:
      if (lookahead == 'r') ADVANCE(826);
      END_STATE();
    case 1817:
      if (lookahead == 'r') ADVANCE(1597);
      END_STATE();
    case 1818:
      if (lookahead == 'r') ADVANCE(1750);
      END_STATE();
    case 1819:
      if (lookahead == 'r') ADVANCE(591);
      END_STATE();
    case 1820:
      if (lookahead == 'r') ADVANCE(1594);
      END_STATE();
    case 1821:
      if (lookahead == 'r') ADVANCE(2027);
      END_STATE();
    case 1822:
      if (lookahead == 'r') ADVANCE(1706);
      END_STATE();
    case 1823:
      if (lookahead == 'r') ADVANCE(2020);
      END_STATE();
    case 1824:
      if (lookahead == 'r') ADVANCE(1936);
      END_STATE();
    case 1825:
      if (lookahead == 'r') ADVANCE(1300);
      END_STATE();
    case 1826:
      if (lookahead == 'r') ADVANCE(1944);
      END_STATE();
    case 1827:
      if (lookahead == 'r') ADVANCE(969);
      if (lookahead == 't') ADVANCE(524);
      END_STATE();
    case 1828:
      if (lookahead == 'r') ADVANCE(1973);
      END_STATE();
    case 1829:
      if (lookahead == 'r') ADVANCE(594);
      END_STATE();
    case 1830:
      if (lookahead == 'r') ADVANCE(1262);
      END_STATE();
    case 1831:
      if (lookahead == 'r') ADVANCE(1601);
      END_STATE();
    case 1832:
      if (lookahead == 'r') ADVANCE(1536);
      END_STATE();
    case 1833:
      if (lookahead == 'r') ADVANCE(1922);
      END_STATE();
    case 1834:
      if (lookahead == 'r') ADVANCE(1525);
      END_STATE();
    case 1835:
      if (lookahead == 'r') ADVANCE(1240);
      END_STATE();
    case 1836:
      if (lookahead == 'r') ADVANCE(1564);
      END_STATE();
    case 1837:
      if (lookahead == 'r') ADVANCE(1388);
      END_STATE();
    case 1838:
      if (lookahead == 'r') ADVANCE(1297);
      END_STATE();
    case 1839:
      if (lookahead == 'r') ADVANCE(1392);
      END_STATE();
    case 1840:
      if (lookahead == 'r') ADVANCE(992);
      END_STATE();
    case 1841:
      if (lookahead == 'r') ADVANCE(1602);
      END_STATE();
    case 1842:
      if (lookahead == 'r') ADVANCE(1953);
      END_STATE();
    case 1843:
      if (lookahead == 'r') ADVANCE(933);
      if (lookahead == 't') ADVANCE(555);
      END_STATE();
    case 1844:
      if (lookahead == 'r') ADVANCE(1606);
      END_STATE();
    case 1845:
      if (lookahead == 'r') ADVANCE(1607);
      END_STATE();
    case 1846:
      if (lookahead == 'r') ADVANCE(1611);
      END_STATE();
    case 1847:
      if (lookahead == 'r') ADVANCE(1612);
      END_STATE();
    case 1848:
      if (lookahead == 'r') ADVANCE(1613);
      END_STATE();
    case 1849:
      if (lookahead == 'r') ADVANCE(1085);
      END_STATE();
    case 1850:
      if (lookahead == 'r') ADVANCE(936);
      END_STATE();
    case 1851:
      if (lookahead == 'r') ADVANCE(1617);
      END_STATE();
    case 1852:
      if (lookahead == 'r') ADVANCE(1756);
      END_STATE();
    case 1853:
      if (lookahead == 'r') ADVANCE(1041);
      END_STATE();
    case 1854:
      if (lookahead == 'r') ADVANCE(1746);
      END_STATE();
    case 1855:
      if (lookahead == 'r') ADVANCE(1779);
      END_STATE();
    case 1856:
      if (lookahead == 'r') ADVANCE(1060);
      END_STATE();
    case 1857:
      if (lookahead == 'r') ADVANCE(962);
      END_STATE();
    case 1858:
      if (lookahead == 'r') ADVANCE(684);
      END_STATE();
    case 1859:
      if (lookahead == 'r') ADVANCE(599);
      END_STATE();
    case 1860:
      if (lookahead == 'r') ADVANCE(644);
      END_STATE();
    case 1861:
      if (lookahead == 'r') ADVANCE(1272);
      END_STATE();
    case 1862:
      if (lookahead == 'r') ADVANCE(1937);
      END_STATE();
    case 1863:
      if (lookahead == 'r') ADVANCE(838);
      END_STATE();
    case 1864:
      if (lookahead == 'r') ADVANCE(2017);
      END_STATE();
    case 1865:
      if (lookahead == 'r') ADVANCE(1008);
      END_STATE();
    case 1866:
      if (lookahead == 'r') ADVANCE(1138);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 1867:
      if (lookahead == 'r') ADVANCE(2000);
      END_STATE();
    case 1868:
      if (lookahead == 'r') ADVANCE(2062);
      END_STATE();
    case 1869:
      if (lookahead == 'r') ADVANCE(1939);
      END_STATE();
    case 1870:
      if (lookahead == 'r') ADVANCE(1015);
      END_STATE();
    case 1871:
      if (lookahead == 'r') ADVANCE(1032);
      END_STATE();
    case 1872:
      if (lookahead == 'r') ADVANCE(1817);
      END_STATE();
    case 1873:
      if (lookahead == 'r') ADVANCE(623);
      END_STATE();
    case 1874:
      if (lookahead == 'r') ADVANCE(2015);
      END_STATE();
    case 1875:
      if (lookahead == 'r') ADVANCE(1831);
      END_STATE();
    case 1876:
      if (lookahead == 'r') ADVANCE(1841);
      END_STATE();
    case 1877:
      if (lookahead == 'r') ADVANCE(1845);
      END_STATE();
    case 1878:
      if (lookahead == 'r') ADVANCE(1846);
      END_STATE();
    case 1879:
      if (lookahead == 'r') ADVANCE(1847);
      END_STATE();
    case 1880:
      if (lookahead == 'r') ADVANCE(1851);
      END_STATE();
    case 1881:
      if (lookahead == 'r') ADVANCE(1050);
      END_STATE();
    case 1882:
      if (lookahead == 'r') ADVANCE(862);
      END_STATE();
    case 1883:
      if (lookahead == 'r') ADVANCE(1073);
      END_STATE();
    case 1884:
      if (lookahead == 'r') ADVANCE(466);
      END_STATE();
    case 1885:
      if (lookahead == 'r') ADVANCE(1719);
      END_STATE();
    case 1886:
      if (lookahead == 'r') ADVANCE(2038);
      END_STATE();
    case 1887:
      if (lookahead == 'r') ADVANCE(1721);
      END_STATE();
    case 1888:
      if (lookahead == 'r') ADVANCE(1082);
      END_STATE();
    case 1889:
      if (lookahead == 'r') ADVANCE(1083);
      END_STATE();
    case 1890:
      if (lookahead == 'r') ADVANCE(1084);
      END_STATE();
    case 1891:
      if (lookahead == 'r') ADVANCE(1324);
      END_STATE();
    case 1892:
      if (lookahead == 'r') ADVANCE(1326);
      END_STATE();
    case 1893:
      if (lookahead == 'r') ADVANCE(1327);
      END_STATE();
    case 1894:
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 1895:
      if (lookahead == 's') ADVANCE(1042);
      END_STATE();
    case 1896:
      if (lookahead == 's') ADVANCE(310);
      if (lookahead == 'u') ADVANCE(1480);
      END_STATE();
    case 1897:
      if (lookahead == 's') ADVANCE(465);
      END_STATE();
    case 1898:
      if (lookahead == 's') ADVANCE(491);
      END_STATE();
    case 1899:
      if (lookahead == 's') ADVANCE(196);
      END_STATE();
    case 1900:
      if (lookahead == 's') ADVANCE(344);
      END_STATE();
    case 1901:
      if (lookahead == 's') ADVANCE(214);
      END_STATE();
    case 1902:
      if (lookahead == 's') ADVANCE(173);
      END_STATE();
    case 1903:
      if (lookahead == 's') ADVANCE(175);
      END_STATE();
    case 1904:
      if (lookahead == 's') ADVANCE(174);
      END_STATE();
    case 1905:
      if (lookahead == 's') ADVANCE(1949);
      END_STATE();
    case 1906:
      if (lookahead == 's') ADVANCE(485);
      END_STATE();
    case 1907:
      if (lookahead == 's') ADVANCE(1614);
      END_STATE();
    case 1908:
      if (lookahead == 's') ADVANCE(275);
      END_STATE();
    case 1909:
      if (lookahead == 's') ADVANCE(1214);
      END_STATE();
    case 1910:
      if (lookahead == 's') ADVANCE(499);
      END_STATE();
    case 1911:
      if (lookahead == 's') ADVANCE(333);
      END_STATE();
    case 1912:
      if (lookahead == 's') ADVANCE(241);
      END_STATE();
    case 1913:
      if (lookahead == 's') ADVANCE(199);
      END_STATE();
    case 1914:
      if (lookahead == 's') ADVANCE(1668);
      END_STATE();
    case 1915:
      if (lookahead == 's') ADVANCE(1174);
      END_STATE();
    case 1916:
      if (lookahead == 's') ADVANCE(2139);
      END_STATE();
    case 1917:
      if (lookahead == 's') ADVANCE(327);
      END_STATE();
    case 1918:
      if (lookahead == 's') ADVANCE(1175);
      END_STATE();
    case 1919:
      if (lookahead == 's') ADVANCE(1179);
      END_STATE();
    case 1920:
      if (lookahead == 's') ADVANCE(1894);
      END_STATE();
    case 1921:
      if (lookahead == 's') ADVANCE(1250);
      END_STATE();
    case 1922:
      if (lookahead == 's') ADVANCE(1349);
      END_STATE();
    case 1923:
      if (lookahead == 's') ADVANCE(2043);
      END_STATE();
    case 1924:
      if (lookahead == 's') ADVANCE(885);
      END_STATE();
    case 1925:
      if (lookahead == 's') ADVANCE(917);
      END_STATE();
    case 1926:
      if (lookahead == 's') ADVANCE(964);
      END_STATE();
    case 1927:
      if (lookahead == 's') ADVANCE(2092);
      END_STATE();
    case 1928:
      if (lookahead == 's') ADVANCE(2048);
      END_STATE();
    case 1929:
      if (lookahead == 's') ADVANCE(1994);
      END_STATE();
    case 1930:
      if (lookahead == 's') ADVANCE(1374);
      END_STATE();
    case 1931:
      if (lookahead == 's') ADVANCE(1906);
      END_STATE();
    case 1932:
      if (lookahead == 's') ADVANCE(1983);
      END_STATE();
    case 1933:
      if (lookahead == 's') ADVANCE(1987);
      END_STATE();
    case 1934:
      if (lookahead == 's') ADVANCE(1312);
      END_STATE();
    case 1935:
      if (lookahead == 's') ADVANCE(1980);
      END_STATE();
    case 1936:
      if (lookahead == 's') ADVANCE(1002);
      END_STATE();
    case 1937:
      if (lookahead == 's') ADVANCE(940);
      END_STATE();
    case 1938:
      if (lookahead == 's') ADVANCE(976);
      END_STATE();
    case 1939:
      if (lookahead == 's') ADVANCE(961);
      END_STATE();
    case 1940:
      if (lookahead == 's') ADVANCE(1184);
      END_STATE();
    case 1941:
      if (lookahead == 's') ADVANCE(2050);
      END_STATE();
    case 1942:
      if (lookahead == 's') ADVANCE(2005);
      END_STATE();
    case 1943:
      if (lookahead == 's') ADVANCE(1993);
      END_STATE();
    case 1944:
      if (lookahead == 's') ADVANCE(1007);
      END_STATE();
    case 1945:
      if (lookahead == 's') ADVANCE(1259);
      END_STATE();
    case 1946:
      if (lookahead == 's') ADVANCE(1022);
      END_STATE();
    case 1947:
      if (lookahead == 's') ADVANCE(1078);
      END_STATE();
    case 1948:
      if (lookahead == 't') ADVANCE(2129);
      END_STATE();
    case 1949:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 1950:
      if (lookahead == 't') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(742);
      END_STATE();
    case 1951:
      if (lookahead == 't') ADVANCE(148);
      if (lookahead == 'w') ADVANCE(1512);
      END_STATE();
    case 1952:
      if (lookahead == 't') ADVANCE(389);
      END_STATE();
    case 1953:
      if (lookahead == 't') ADVANCE(507);
      END_STATE();
    case 1954:
      if (lookahead == 't') ADVANCE(692);
      END_STATE();
    case 1955:
      if (lookahead == 't') ADVANCE(355);
      END_STATE();
    case 1956:
      if (lookahead == 't') ADVANCE(408);
      END_STATE();
    case 1957:
      if (lookahead == 't') ADVANCE(448);
      END_STATE();
    case 1958:
      if (lookahead == 't') ADVANCE(691);
      END_STATE();
    case 1959:
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 1960:
      if (lookahead == 't') ADVANCE(1147);
      END_STATE();
    case 1961:
      if (lookahead == 't') ADVANCE(503);
      END_STATE();
    case 1962:
      if (lookahead == 't') ADVANCE(514);
      END_STATE();
    case 1963:
      if (lookahead == 't') ADVANCE(411);
      END_STATE();
    case 1964:
      if (lookahead == 't') ADVANCE(414);
      END_STATE();
    case 1965:
      if (lookahead == 't') ADVANCE(518);
      END_STATE();
    case 1966:
      if (lookahead == 't') ADVANCE(699);
      END_STATE();
    case 1967:
      if (lookahead == 't') ADVANCE(412);
      END_STATE();
    case 1968:
      if (lookahead == 't') ADVANCE(413);
      END_STATE();
    case 1969:
      if (lookahead == 't') ADVANCE(1741);
      END_STATE();
    case 1970:
      if (lookahead == 't') ADVANCE(524);
      END_STATE();
    case 1971:
      if (lookahead == 't') ADVANCE(999);
      END_STATE();
    case 1972:
      if (lookahead == 't') ADVANCE(170);
      END_STATE();
    case 1973:
      if (lookahead == 't') ADVANCE(1469);
      END_STATE();
    case 1974:
      if (lookahead == 't') ADVANCE(464);
      END_STATE();
    case 1975:
      if (lookahead == 't') ADVANCE(745);
      END_STATE();
    case 1976:
      if (lookahead == 't') ADVANCE(2130);
      END_STATE();
    case 1977:
      if (lookahead == 't') ADVANCE(247);
      if (lookahead == 'v') ADVANCE(1286);
      END_STATE();
    case 1978:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 1979:
      if (lookahead == 't') ADVANCE(688);
      END_STATE();
    case 1980:
      if (lookahead == 't') ADVANCE(1579);
      END_STATE();
    case 1981:
      if (lookahead == 't') ADVANCE(409);
      END_STATE();
    case 1982:
      if (lookahead == 't') ADVANCE(1026);
      END_STATE();
    case 1983:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 1984:
      if (lookahead == 't') ADVANCE(2134);
      END_STATE();
    case 1985:
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 1986:
      if (lookahead == 't') ADVANCE(515);
      END_STATE();
    case 1987:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 1988:
      if (lookahead == 't') ADVANCE(1174);
      END_STATE();
    case 1989:
      if (lookahead == 't') ADVANCE(2135);
      END_STATE();
    case 1990:
      if (lookahead == 't') ADVANCE(301);
      END_STATE();
    case 1991:
      if (lookahead == 't') ADVANCE(1179);
      END_STATE();
    case 1992:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 1993:
      if (lookahead == 't') ADVANCE(1894);
      END_STATE();
    case 1994:
      if (lookahead == 't') ADVANCE(250);
      END_STATE();
    case 1995:
      if (lookahead == 't') ADVANCE(255);
      END_STATE();
    case 1996:
      if (lookahead == 't') ADVANCE(1176);
      END_STATE();
    case 1997:
      if (lookahead == 't') ADVANCE(1477);
      END_STATE();
    case 1998:
      if (lookahead == 't') ADVANCE(917);
      END_STATE();
    case 1999:
      if (lookahead == 't') ADVANCE(1649);
      END_STATE();
    case 2000:
      if (lookahead == 't') ADVANCE(1900);
      END_STATE();
    case 2001:
      if (lookahead == 't') ADVANCE(1204);
      END_STATE();
    case 2002:
      if (lookahead == 't') ADVANCE(1492);
      END_STATE();
    case 2003:
      if (lookahead == 't') ADVANCE(948);
      END_STATE();
    case 2004:
      if (lookahead == 't') ADVANCE(1926);
      END_STATE();
    case 2005:
      if (lookahead == 't') ADVANCE(990);
      END_STATE();
    case 2006:
      if (lookahead == 't') ADVANCE(1588);
      END_STATE();
    case 2007:
      if (lookahead == 't') ADVANCE(1776);
      END_STATE();
    case 2008:
      if (lookahead == 't') ADVANCE(625);
      END_STATE();
    case 2009:
      if (lookahead == 't') ADVANCE(1285);
      END_STATE();
    case 2010:
      if (lookahead == 't') ADVANCE(1262);
      END_STATE();
    case 2011:
      if (lookahead == 't') ADVANCE(1296);
      END_STATE();
    case 2012:
      if (lookahead == 't') ADVANCE(1585);
      END_STATE();
    case 2013:
      if (lookahead == 't') ADVANCE(1287);
      END_STATE();
    case 2014:
      if (lookahead == 't') ADVANCE(1310);
      END_STATE();
    case 2015:
      if (lookahead == 't') ADVANCE(1304);
      END_STATE();
    case 2016:
      if (lookahead == 't') ADVANCE(1264);
      END_STATE();
    case 2017:
      if (lookahead == 't') ADVANCE(1744);
      END_STATE();
    case 2018:
      if (lookahead == 't') ADVANCE(1076);
      END_STATE();
    case 2019:
      if (lookahead == 't') ADVANCE(697);
      END_STATE();
    case 2020:
      if (lookahead == 't') ADVANCE(1544);
      END_STATE();
    case 2021:
      if (lookahead == 't') ADVANCE(1249);
      END_STATE();
    case 2022:
      if (lookahead == 't') ADVANCE(1642);
      END_STATE();
    case 2023:
      if (lookahead == 't') ADVANCE(1545);
      END_STATE();
    case 2024:
      if (lookahead == 't') ADVANCE(1829);
      END_STATE();
    case 2025:
      if (lookahead == 't') ADVANCE(1025);
      END_STATE();
    case 2026:
      if (lookahead == 't') ADVANCE(633);
      END_STATE();
    case 2027:
      if (lookahead == 't') ADVANCE(1226);
      END_STATE();
    case 2028:
      if (lookahead == 't') ADVANCE(1027);
      END_STATE();
    case 2029:
      if (lookahead == 't') ADVANCE(1029);
      END_STATE();
    case 2030:
      if (lookahead == 't') ADVANCE(1031);
      END_STATE();
    case 2031:
      if (lookahead == 't') ADVANCE(1034);
      END_STATE();
    case 2032:
      if (lookahead == 't') ADVANCE(1052);
      END_STATE();
    case 2033:
      if (lookahead == 't') ADVANCE(1036);
      END_STATE();
    case 2034:
      if (lookahead == 't') ADVANCE(1205);
      END_STATE();
    case 2035:
      if (lookahead == 't') ADVANCE(676);
      END_STATE();
    case 2036:
      if (lookahead == 't') ADVANCE(1295);
      END_STATE();
    case 2037:
      if (lookahead == 't') ADVANCE(1301);
      END_STATE();
    case 2038:
      if (lookahead == 't') ADVANCE(1311);
      END_STATE();
    case 2039:
      if (lookahead == 't') ADVANCE(696);
      END_STATE();
    case 2040:
      if (lookahead == 't') ADVANCE(685);
      END_STATE();
    case 2041:
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 2042:
      if (lookahead == 'u') ADVANCE(613);
      END_STATE();
    case 2043:
      if (lookahead == 'u') ADVANCE(2153);
      END_STATE();
    case 2044:
      if (lookahead == 'u') ADVANCE(1579);
      END_STATE();
    case 2045:
      if (lookahead == 'u') ADVANCE(299);
      END_STATE();
    case 2046:
      if (lookahead == 'u') ADVANCE(715);
      END_STATE();
    case 2047:
      if (lookahead == 'u') ADVANCE(728);
      END_STATE();
    case 2048:
      if (lookahead == 'u') ADVANCE(726);
      END_STATE();
    case 2049:
      if (lookahead == 'u') ADVANCE(1668);
      END_STATE();
    case 2050:
      if (lookahead == 'u') ADVANCE(709);
      END_STATE();
    case 2051:
      if (lookahead == 'u') ADVANCE(1898);
      END_STATE();
    case 2052:
      if (lookahead == 'u') ADVANCE(733);
      END_STATE();
    case 2053:
      if (lookahead == 'u') ADVANCE(1985);
      END_STATE();
    case 2054:
      if (lookahead == 'u') ADVANCE(1985);
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 2055:
      if (lookahead == 'u') ADVANCE(1454);
      END_STATE();
    case 2056:
      if (lookahead == 'u') ADVANCE(1894);
      END_STATE();
    case 2057:
      if (lookahead == 'u') ADVANCE(1000);
      END_STATE();
    case 2058:
      if (lookahead == 'u') ADVANCE(1910);
      END_STATE();
    case 2059:
      if (lookahead == 'u') ADVANCE(917);
      END_STATE();
    case 2060:
      if (lookahead == 'u') ADVANCE(1457);
      END_STATE();
    case 2061:
      if (lookahead == 'u') ADVANCE(798);
      END_STATE();
    case 2062:
      if (lookahead == 'u') ADVANCE(950);
      END_STATE();
    case 2063:
      if (lookahead == 'u') ADVANCE(591);
      END_STATE();
    case 2064:
      if (lookahead == 'u') ADVANCE(1901);
      END_STATE();
    case 2065:
      if (lookahead == 'u') ADVANCE(1580);
      END_STATE();
    case 2066:
      if (lookahead == 'u') ADVANCE(1365);
      END_STATE();
    case 2067:
      if (lookahead == 'u') ADVANCE(1925);
      END_STATE();
    case 2068:
      if (lookahead == 'u') ADVANCE(832);
      END_STATE();
    case 2069:
      if (lookahead == 'u') ADVANCE(1912);
      END_STATE();
    case 2070:
      if (lookahead == 'u') ADVANCE(1233);
      END_STATE();
    case 2071:
      if (lookahead == 'u') ADVANCE(985);
      END_STATE();
    case 2072:
      if (lookahead == 'u') ADVANCE(612);
      END_STATE();
    case 2073:
      if (lookahead == 'u') ADVANCE(1298);
      END_STATE();
    case 2074:
      if (lookahead == 'u') ADVANCE(1232);
      END_STATE();
    case 2075:
      if (lookahead == 'u') ADVANCE(1772);
      END_STATE();
    case 2076:
      if (lookahead == 'u') ADVANCE(1744);
      END_STATE();
    case 2077:
      if (lookahead == 'u') ADVANCE(1773);
      END_STATE();
    case 2078:
      if (lookahead == 'u') ADVANCE(1837);
      END_STATE();
    case 2079:
      if (lookahead == 'u') ADVANCE(1839);
      END_STATE();
    case 2080:
      if (lookahead == 'u') ADVANCE(1184);
      END_STATE();
    case 2081:
      if (lookahead == 'u') ADVANCE(1467);
      END_STATE();
    case 2082:
      if (lookahead == 'u') ADVANCE(1538);
      END_STATE();
    case 2083:
      if (lookahead == 'u') ADVANCE(1932);
      END_STATE();
    case 2084:
      if (lookahead == 'u') ADVANCE(1267);
      END_STATE();
    case 2085:
      if (lookahead == 'u') ADVANCE(1391);
      END_STATE();
    case 2086:
      if (lookahead == 'u') ADVANCE(1998);
      END_STATE();
    case 2087:
      if (lookahead == 'u') ADVANCE(632);
      END_STATE();
    case 2088:
      if (lookahead == 'u') ADVANCE(1407);
      END_STATE();
    case 2089:
      if (lookahead == 'u') ADVANCE(1653);
      END_STATE();
    case 2090:
      if (lookahead == 'u') ADVANCE(1465);
      END_STATE();
    case 2091:
      if (lookahead == 'u') ADVANCE(638);
      END_STATE();
    case 2092:
      if (lookahead == 'u') ADVANCE(1853);
      END_STATE();
    case 2093:
      if (lookahead == 'u') ADVANCE(1446);
      END_STATE();
    case 2094:
      if (lookahead == 'u') ADVANCE(681);
      END_STATE();
    case 2095:
      if (lookahead == 'u') ADVANCE(739);
      END_STATE();
    case 2096:
      if (lookahead == 'u') ADVANCE(683);
      END_STATE();
    case 2097:
      if (lookahead == 'u') ADVANCE(738);
      if (lookahead == 'w') ADVANCE(1504);
      END_STATE();
    case 2098:
      if (lookahead == 'u') ADVANCE(741);
      END_STATE();
    case 2099:
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 2100:
      if (lookahead == 'v') ADVANCE(148);
      if (lookahead == 'w') ADVANCE(916);
      END_STATE();
    case 2101:
      if (lookahead == 'v') ADVANCE(162);
      END_STATE();
    case 2102:
      if (lookahead == 'v') ADVANCE(241);
      END_STATE();
    case 2103:
      if (lookahead == 'v') ADVANCE(994);
      if (lookahead == 'w') ADVANCE(993);
      END_STATE();
    case 2104:
      if (lookahead == 'v') ADVANCE(917);
      END_STATE();
    case 2105:
      if (lookahead == 'v') ADVANCE(941);
      END_STATE();
    case 2106:
      if (lookahead == 'v') ADVANCE(1080);
      END_STATE();
    case 2107:
      if (lookahead == 'w') ADVANCE(148);
      END_STATE();
    case 2108:
      if (lookahead == 'w') ADVANCE(154);
      END_STATE();
    case 2109:
      if (lookahead == 'w') ADVANCE(158);
      END_STATE();
    case 2110:
      if (lookahead == 'w') ADVANCE(157);
      END_STATE();
    case 2111:
      if (lookahead == 'w') ADVANCE(156);
      END_STATE();
    case 2112:
      if (lookahead == 'w') ADVANCE(1579);
      END_STATE();
    case 2113:
      if (lookahead == 'w') ADVANCE(538);
      END_STATE();
    case 2114:
      if (lookahead == 'w') ADVANCE(322);
      END_STATE();
    case 2115:
      if (lookahead == 'w') ADVANCE(957);
      END_STATE();
    case 2116:
      if (lookahead == 'w') ADVANCE(1894);
      END_STATE();
    case 2117:
      if (lookahead == 'w') ADVANCE(1495);
      END_STATE();
    case 2118:
      if (lookahead == 'w') ADVANCE(1512);
      END_STATE();
    case 2119:
      if (lookahead == 'w') ADVANCE(1509);
      END_STATE();
    case 2120:
      if (lookahead == 'w') ADVANCE(1505);
      END_STATE();
    case 2121:
      if (lookahead == 'w') ADVANCE(1293);
      END_STATE();
    case 2122:
      if (lookahead == 'w') ADVANCE(340);
      END_STATE();
    case 2123:
      if (lookahead == 'w') ADVANCE(1419);
      END_STATE();
    case 2124:
      if (lookahead == 'w') ADVANCE(1577);
      END_STATE();
    case 2125:
      if (lookahead == 'w') ADVANCE(1576);
      END_STATE();
    case 2126:
      if (lookahead == 'x') ADVANCE(148);
      END_STATE();
    case 2127:
      if (lookahead == 'x') ADVANCE(1949);
      END_STATE();
    case 2128:
      if (lookahead == 'x') ADVANCE(250);
      END_STATE();
    case 2129:
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 2130:
      if (lookahead == 'y') ADVANCE(506);
      END_STATE();
    case 2131:
      if (lookahead == 'y') ADVANCE(975);
      END_STATE();
    case 2132:
      if (lookahead == 'y') ADVANCE(453);
      END_STATE();
    case 2133:
      if (lookahead == 'y') ADVANCE(468);
      END_STATE();
    case 2134:
      if (lookahead == 'y') ADVANCE(330);
      END_STATE();
    case 2135:
      if (lookahead == 'y') ADVANCE(2099);
      END_STATE();
    case 2136:
      if (lookahead == 'y') ADVANCE(505);
      END_STATE();
    case 2137:
      if (lookahead == 'y') ADVANCE(512);
      END_STATE();
    case 2138:
      if (lookahead == 'y') ADVANCE(481);
      END_STATE();
    case 2139:
      if (lookahead == 'y') ADVANCE(1454);
      END_STATE();
    case 2140:
      if (lookahead == 'y') ADVANCE(916);
      END_STATE();
    case 2141:
      if (lookahead == 'y') ADVANCE(1894);
      END_STATE();
    case 2142:
      if (lookahead == 'y') ADVANCE(964);
      END_STATE();
    case 2143:
      if (lookahead == 'z') ADVANCE(1656);
      END_STATE();
    case 2144:
      if (lookahead == 'z') ADVANCE(569);
      END_STATE();
    case 2145:
      if (lookahead == 'z') ADVANCE(1272);
      END_STATE();
    case 2146:
      if (lookahead == 'z') ADVANCE(1003);
      END_STATE();
    case 2147:
      if (lookahead == '2' ||
          lookahead == '4') ADVANCE(148);
      END_STATE();
    case 2148:
      if (lookahead == '3' ||
          lookahead == '5') ADVANCE(148);
      END_STATE();
    case 2149:
      if (lookahead == '6' ||
          lookahead == '8') ADVANCE(148);
      END_STATE();
    case 2150:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 2151:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(2171);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 2152:
      if (lookahead == 'a' ||
          lookahead == 'h') ADVANCE(148);
      if (lookahead == 'w') ADVANCE(1045);
      END_STATE();
    case 2153:
      if (lookahead == 'b' ||
          lookahead == 'p') ADVANCE(148);
      END_STATE();
    case 2154:
      if (lookahead == 'b' ||
          lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 2155:
      if (lookahead == 'd' ||
          lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 2156:
      if (lookahead == 'e' ||
          lookahead == 'k') ADVANCE(148);
      END_STATE();
    case 2157:
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(148);
      END_STATE();
    case 2158:
      if (lookahead == 'f' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 2159:
      if (lookahead == 'l' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 2160:
      if (lookahead == 'o' ||
          lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 2161:
      if (lookahead == 'r' ||
          lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 2162:
      if (lookahead == '3' ||
          lookahead == '4') ADVANCE(148);
      END_STATE();
    case 2163:
      if (lookahead == 'R' ||
          lookahead == 'S') ADVANCE(148);
      if (lookahead == 'a') ADVANCE(1905);
      if (lookahead == 'c') ADVANCE(1280);
      if (lookahead == 'd') ADVANCE(571);
      END_STATE();
    case 2164:
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 2165:
      if (lookahead == '4' ||
          lookahead == '5' ||
          lookahead == '8') ADVANCE(148);
      if (lookahead == ';') ADVANCE(2180);
      END_STATE();
    case 2166:
      if (('a' <= lookahead && lookahead <= 'c')) ADVANCE(148);
      END_STATE();
    case 2167:
      if (lookahead == 'L' ||
          lookahead == 'R' ||
          lookahead == 'l' ||
          lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 2168:
      if (('1' <= lookahead && lookahead <= '3') ||
          lookahead == 'E') ADVANCE(148);
      if (lookahead == ';') ADVANCE(2180);
      if (lookahead == 'd') ADVANCE(1590);
      if (lookahead == 'e') ADVANCE(233);
      if (lookahead == 'h') ADVANCE(1907);
      if (lookahead == 'l') ADVANCE(575);
      if (lookahead == 'm') ADVANCE(2066);
      if (lookahead == 'n') ADVANCE(2150);
      if (lookahead == 'p') ADVANCE(1439);
      if (lookahead == 's') ADVANCE(1017);
      END_STATE();
    case 2169:
      if (('2' <= lookahead && lookahead <= '6') ||
          lookahead == '8') ADVANCE(148);
      if (lookahead == ';') ADVANCE(2180);
      END_STATE();
    case 2170:
      if (('a' <= lookahead && lookahead <= 'h')) ADVANCE(148);
      END_STATE();
    case 2171:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(378);
      END_STATE();
    case 2172:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(15);
      END_STATE();
    case 2173:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 2174:
      if (eof) ADVANCE(2178);
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2195);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2201);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2186);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2211);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 2175:
      if (eof) ADVANCE(2178);
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2195);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2186);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2208);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2211);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 2176:
      if (eof) ADVANCE(2178);
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2195);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2186);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2211);
      if (lookahead == ']') ADVANCE(2184);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 2177:
      if (eof) ADVANCE(2178);
      if (lookahead == '\t') ADVANCE(2237);
      if (lookahead == '\n') ADVANCE(2221);
      if (lookahead == '\r') ADVANCE(2222);
      if (lookahead == ' ') ADVANCE(2239);
      if (lookahead == '!') ADVANCE(2189);
      if (lookahead == '"') ADVANCE(2190);
      if (lookahead == '#') ADVANCE(2191);
      if (lookahead == '$') ADVANCE(2192);
      if (lookahead == '%') ADVANCE(2193);
      if (lookahead == '&') ADVANCE(2195);
      if (lookahead == '\'') ADVANCE(2196);
      if (lookahead == '(') ADVANCE(2219);
      if (lookahead == ')') ADVANCE(2220);
      if (lookahead == '*') ADVANCE(2197);
      if (lookahead == '+') ADVANCE(2198);
      if (lookahead == ',') ADVANCE(2199);
      if (lookahead == '-') ADVANCE(2200);
      if (lookahead == '.') ADVANCE(2202);
      if (lookahead == '/') ADVANCE(2203);
      if (lookahead == ':') ADVANCE(2204);
      if (lookahead == ';') ADVANCE(2205);
      if (lookahead == '<') ADVANCE(2186);
      if (lookahead == '=') ADVANCE(2206);
      if (lookahead == '>') ADVANCE(2188);
      if (lookahead == '?') ADVANCE(2207);
      if (lookahead == '@') ADVANCE(2209);
      if (lookahead == '[') ADVANCE(2182);
      if (lookahead == '\\') ADVANCE(2211);
      if (lookahead == ']') ADVANCE(2183);
      if (lookahead == '^') ADVANCE(2212);
      if (lookahead == '_') ADVANCE(2213);
      if (lookahead == '`') ADVANCE(2214);
      if (lookahead == '{') ADVANCE(2215);
      if (lookahead == '|') ADVANCE(2216);
      if (lookahead == '}') ADVANCE(2217);
      if (lookahead == '~') ADVANCE(2218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      if (lookahead != 0) ADVANCE(2240);
      END_STATE();
    case 2178:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 2179:
      ACCEPT_TOKEN(sym__backslash_escape);
      END_STATE();
    case 2180:
      ACCEPT_TOKEN(sym_entity_reference);
      END_STATE();
    case 2181:
      ACCEPT_TOKEN(sym_numeric_character_reference);
      END_STATE();
    case 2182:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 2183:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 2184:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead == ']') ADVANCE(380);
      END_STATE();
    case 2185:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 2186:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '?') ADVANCE(2231);
      if (('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('^' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(383);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(382);
      END_STATE();
    case 2187:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '?') ADVANCE(2230);
      END_STATE();
    case 2188:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 2189:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 2190:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 2191:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 2192:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 2193:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 2194:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 2195:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '#') ADVANCE(2151);
      if (lookahead == 'A') ADVANCE(454);
      if (lookahead == 'B') ADVANCE(523);
      if (lookahead == 'C') ADVANCE(477);
      if (lookahead == 'D') ADVANCE(437);
      if (lookahead == 'E') ADVANCE(493);
      if (lookahead == 'F') ADVANCE(748);
      if (lookahead == 'G') ADVANCE(180);
      if (lookahead == 'H') ADVANCE(384);
      if (lookahead == 'I') ADVANCE(460);
      if (lookahead == 'J') ADVANCE(850);
      if (lookahead == 'K') ADVANCE(476);
      if (lookahead == 'L') ADVANCE(179);
      if (lookahead == 'M') ADVANCE(565);
      if (lookahead == 'N') ADVANCE(484);
      if (lookahead == 'O') ADVANCE(462);
      if (lookahead == 'P') ADVANCE(561);
      if (lookahead == 'Q') ADVANCE(516);
      if (lookahead == 'R') ADVANCE(417);
      if (lookahead == 'S') ADVANCE(473);
      if (lookahead == 'T') ADVANCE(474);
      if (lookahead == 'U') ADVANCE(542);
      if (lookahead == 'V') ADVANCE(446);
      if (lookahead == 'W') ADVANCE(802);
      if (lookahead == 'X') ADVANCE(1090);
      if (lookahead == 'Y') ADVANCE(387);
      if (lookahead == 'Z') ADVANCE(478);
      if (lookahead == 'a') ADVANCE(521);
      if (lookahead == 'b') ADVANCE(492);
      if (lookahead == 'c') ADVANCE(528);
      if (lookahead == 'd') ADVANCE(393);
      if (lookahead == 'e') ADVANCE(439);
      if (lookahead == 'f') ADVANCE(570);
      if (lookahead == 'g') ADVANCE(169);
      if (lookahead == 'h') ADVANCE(395);
      if (lookahead == 'i') ADVANCE(522);
      if (lookahead == 'j') ADVANCE(849);
      if (lookahead == 'k') ADVANCE(654);
      if (lookahead == 'l') ADVANCE(149);
      if (lookahead == 'm') ADVANCE(440);
      if (lookahead == 'n') ADVANCE(470);
      if (lookahead == 'o') ADVANCE(504);
      if (lookahead == 'p') ADVANCE(592);
      if (lookahead == 'q') ADVANCE(1091);
      if (lookahead == 'r') ADVANCE(385);
      if (lookahead == 's') ADVANCE(649);
      if (lookahead == 't') ADVANCE(545);
      if (lookahead == 'u') ADVANCE(394);
      if (lookahead == 'v') ADVANCE(391);
      if (lookahead == 'w') ADVANCE(801);
      if (lookahead == 'x') ADVANCE(757);
      if (lookahead == 'y') ADVANCE(560);
      if (lookahead == 'z') ADVANCE(650);
      END_STATE();
    case 2196:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 2197:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 2198:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 2199:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 2200:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 2201:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(379);
      END_STATE();
    case 2202:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 2203:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 2204:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 2205:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 2206:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 2207:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 2208:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '>') ADVANCE(2232);
      END_STATE();
    case 2209:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 2210:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 2211:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (('!' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          ('[' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(2179);
      END_STATE();
    case 2212:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 2213:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 2214:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 2215:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 2216:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 2217:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 2218:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 2219:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 2220:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 2221:
      ACCEPT_TOKEN(sym__newline_token);
      END_STATE();
    case 2222:
      ACCEPT_TOKEN(sym__newline_token);
      if (lookahead == '\n') ADVANCE(2221);
      END_STATE();
    case 2223:
      ACCEPT_TOKEN(sym_uri_autolink);
      END_STATE();
    case 2224:
      ACCEPT_TOKEN(sym_email_autolink);
      END_STATE();
    case 2225:
      ACCEPT_TOKEN(sym__attribute_name);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2225);
      END_STATE();
    case 2226:
      ACCEPT_TOKEN(aux_sym__attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '`') ADVANCE(2226);
      END_STATE();
    case 2227:
      ACCEPT_TOKEN(anon_sym_LT_BANG_DASH_DASH);
      END_STATE();
    case 2228:
      ACCEPT_TOKEN(anon_sym_LT_BANG_DASH_DASH);
      if (lookahead == '@') ADVANCE(2172);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(383);
      END_STATE();
    case 2229:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_GT);
      END_STATE();
    case 2230:
      ACCEPT_TOKEN(anon_sym_LT_QMARK);
      END_STATE();
    case 2231:
      ACCEPT_TOKEN(anon_sym_LT_QMARK);
      if (lookahead == '@') ADVANCE(2172);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(383);
      END_STATE();
    case 2232:
      ACCEPT_TOKEN(anon_sym_QMARK_GT);
      END_STATE();
    case 2233:
      ACCEPT_TOKEN(aux_sym__declaration_token1);
      if (lookahead == '@') ADVANCE(2172);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2233);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(383);
      END_STATE();
    case 2234:
      ACCEPT_TOKEN(aux_sym__declaration_token1);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2234);
      END_STATE();
    case 2235:
      ACCEPT_TOKEN(anon_sym_LT_BANG_LBRACKCDATA_LBRACK);
      END_STATE();
    case 2236:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK_GT);
      END_STATE();
    case 2237:
      ACCEPT_TOKEN(sym__whitespace_ge_2);
      END_STATE();
    case 2238:
      ACCEPT_TOKEN(sym__whitespace_ge_2);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2238);
      END_STATE();
    case 2239:
      ACCEPT_TOKEN(aux_sym__whitespace_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2238);
      END_STATE();
    case 2240:
      ACCEPT_TOKEN(sym__word_no_digit);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(2240);
      END_STATE();
    case 2241:
      ACCEPT_TOKEN(sym__digits);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2241);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 2177, .external_lex_state = 2},
  [2] = {.lex_state = 2177, .external_lex_state = 3},
  [3] = {.lex_state = 2177, .external_lex_state = 4},
  [4] = {.lex_state = 2177, .external_lex_state = 4},
  [5] = {.lex_state = 2177, .external_lex_state = 5},
  [6] = {.lex_state = 2177, .external_lex_state = 4},
  [7] = {.lex_state = 2177, .external_lex_state = 3},
  [8] = {.lex_state = 2177, .external_lex_state = 6},
  [9] = {.lex_state = 2177, .external_lex_state = 6},
  [10] = {.lex_state = 2177, .external_lex_state = 5},
  [11] = {.lex_state = 2177, .external_lex_state = 7},
  [12] = {.lex_state = 2177, .external_lex_state = 8},
  [13] = {.lex_state = 2177, .external_lex_state = 9},
  [14] = {.lex_state = 2177, .external_lex_state = 9},
  [15] = {.lex_state = 2177, .external_lex_state = 7},
  [16] = {.lex_state = 2177, .external_lex_state = 9},
  [17] = {.lex_state = 2177, .external_lex_state = 8},
  [18] = {.lex_state = 2177, .external_lex_state = 7},
  [19] = {.lex_state = 2177, .external_lex_state = 9},
  [20] = {.lex_state = 2177, .external_lex_state = 8},
  [21] = {.lex_state = 2177, .external_lex_state = 7},
  [22] = {.lex_state = 2177, .external_lex_state = 8},
  [23] = {.lex_state = 2177, .external_lex_state = 8},
  [24] = {.lex_state = 2177, .external_lex_state = 7},
  [25] = {.lex_state = 2177, .external_lex_state = 8},
  [26] = {.lex_state = 2177, .external_lex_state = 9},
  [27] = {.lex_state = 2177, .external_lex_state = 9},
  [28] = {.lex_state = 2177, .external_lex_state = 4},
  [29] = {.lex_state = 2177, .external_lex_state = 4},
  [30] = {.lex_state = 2177, .external_lex_state = 4},
  [31] = {.lex_state = 2177, .external_lex_state = 10},
  [32] = {.lex_state = 2177, .external_lex_state = 8},
  [33] = {.lex_state = 2177, .external_lex_state = 7},
  [34] = {.lex_state = 2177, .external_lex_state = 8},
  [35] = {.lex_state = 2177, .external_lex_state = 9},
  [36] = {.lex_state = 2177, .external_lex_state = 4},
  [37] = {.lex_state = 2177, .external_lex_state = 7},
  [38] = {.lex_state = 2177, .external_lex_state = 9},
  [39] = {.lex_state = 2177, .external_lex_state = 9},
  [40] = {.lex_state = 2177, .external_lex_state = 7},
  [41] = {.lex_state = 2177, .external_lex_state = 9},
  [42] = {.lex_state = 2177, .external_lex_state = 7},
  [43] = {.lex_state = 2177, .external_lex_state = 7},
  [44] = {.lex_state = 2177, .external_lex_state = 4},
  [45] = {.lex_state = 2177, .external_lex_state = 7},
  [46] = {.lex_state = 2177, .external_lex_state = 4},
  [47] = {.lex_state = 2177, .external_lex_state = 8},
  [48] = {.lex_state = 2177, .external_lex_state = 10},
  [49] = {.lex_state = 2177, .external_lex_state = 8},
  [50] = {.lex_state = 2177, .external_lex_state = 9},
  [51] = {.lex_state = 2177, .external_lex_state = 8},
  [52] = {.lex_state = 2177, .external_lex_state = 10},
  [53] = {.lex_state = 2177, .external_lex_state = 10},
  [54] = {.lex_state = 2177, .external_lex_state = 10},
  [55] = {.lex_state = 2177, .external_lex_state = 10},
  [56] = {.lex_state = 2177, .external_lex_state = 10},
  [57] = {.lex_state = 2177, .external_lex_state = 10},
  [58] = {.lex_state = 2177, .external_lex_state = 10},
  [59] = {.lex_state = 2177, .external_lex_state = 10},
  [60] = {.lex_state = 2177, .external_lex_state = 10},
  [61] = {.lex_state = 2177, .external_lex_state = 10},
  [62] = {.lex_state = 2177, .external_lex_state = 10},
  [63] = {.lex_state = 2177, .external_lex_state = 10},
  [64] = {.lex_state = 2177, .external_lex_state = 10},
  [65] = {.lex_state = 2177, .external_lex_state = 10},
  [66] = {.lex_state = 2177, .external_lex_state = 10},
  [67] = {.lex_state = 2177, .external_lex_state = 10},
  [68] = {.lex_state = 2177, .external_lex_state = 10},
  [69] = {.lex_state = 2177, .external_lex_state = 10},
  [70] = {.lex_state = 2177, .external_lex_state = 10},
  [71] = {.lex_state = 2177, .external_lex_state = 10},
  [72] = {.lex_state = 2177, .external_lex_state = 10},
  [73] = {.lex_state = 2177, .external_lex_state = 10},
  [74] = {.lex_state = 2177, .external_lex_state = 10},
  [75] = {.lex_state = 2177, .external_lex_state = 10},
  [76] = {.lex_state = 2177, .external_lex_state = 10},
  [77] = {.lex_state = 2177, .external_lex_state = 10},
  [78] = {.lex_state = 2177, .external_lex_state = 10},
  [79] = {.lex_state = 2177, .external_lex_state = 10},
  [80] = {.lex_state = 2177, .external_lex_state = 10},
  [81] = {.lex_state = 2177, .external_lex_state = 10},
  [82] = {.lex_state = 2177, .external_lex_state = 10},
  [83] = {.lex_state = 2177, .external_lex_state = 10},
  [84] = {.lex_state = 2177, .external_lex_state = 10},
  [85] = {.lex_state = 2177, .external_lex_state = 10},
  [86] = {.lex_state = 2177, .external_lex_state = 6},
  [87] = {.lex_state = 2177, .external_lex_state = 5},
  [88] = {.lex_state = 2177, .external_lex_state = 3},
  [89] = {.lex_state = 2177, .external_lex_state = 4},
  [90] = {.lex_state = 2177, .external_lex_state = 4},
  [91] = {.lex_state = 2177, .external_lex_state = 5},
  [92] = {.lex_state = 2177, .external_lex_state = 3},
  [93] = {.lex_state = 2177, .external_lex_state = 4},
  [94] = {.lex_state = 2177, .external_lex_state = 4},
  [95] = {.lex_state = 2177, .external_lex_state = 4},
  [96] = {.lex_state = 2177, .external_lex_state = 3},
  [97] = {.lex_state = 2177, .external_lex_state = 6},
  [98] = {.lex_state = 2177, .external_lex_state = 5},
  [99] = {.lex_state = 2177, .external_lex_state = 6},
  [100] = {.lex_state = 2177, .external_lex_state = 10},
  [101] = {.lex_state = 2177, .external_lex_state = 9},
  [102] = {.lex_state = 2177, .external_lex_state = 7},
  [103] = {.lex_state = 2177, .external_lex_state = 7},
  [104] = {.lex_state = 2177, .external_lex_state = 8},
  [105] = {.lex_state = 2177, .external_lex_state = 9},
  [106] = {.lex_state = 2177, .external_lex_state = 10},
  [107] = {.lex_state = 2177, .external_lex_state = 7},
  [108] = {.lex_state = 2177, .external_lex_state = 9},
  [109] = {.lex_state = 2177, .external_lex_state = 9},
  [110] = {.lex_state = 2177, .external_lex_state = 8},
  [111] = {.lex_state = 2177, .external_lex_state = 8},
  [112] = {.lex_state = 2177, .external_lex_state = 7},
  [113] = {.lex_state = 2177, .external_lex_state = 9},
  [114] = {.lex_state = 2177, .external_lex_state = 10},
  [115] = {.lex_state = 2177, .external_lex_state = 9},
  [116] = {.lex_state = 2177, .external_lex_state = 8},
  [117] = {.lex_state = 2177, .external_lex_state = 8},
  [118] = {.lex_state = 2177, .external_lex_state = 9},
  [119] = {.lex_state = 2177, .external_lex_state = 7},
  [120] = {.lex_state = 2177, .external_lex_state = 9},
  [121] = {.lex_state = 2177, .external_lex_state = 4},
  [122] = {.lex_state = 2177, .external_lex_state = 8},
  [123] = {.lex_state = 2177, .external_lex_state = 7},
  [124] = {.lex_state = 2177, .external_lex_state = 9},
  [125] = {.lex_state = 2177, .external_lex_state = 7},
  [126] = {.lex_state = 2177, .external_lex_state = 4},
  [127] = {.lex_state = 2177, .external_lex_state = 7},
  [128] = {.lex_state = 2177, .external_lex_state = 8},
  [129] = {.lex_state = 2177, .external_lex_state = 8},
  [130] = {.lex_state = 2177, .external_lex_state = 8},
  [131] = {.lex_state = 2177, .external_lex_state = 10},
  [132] = {.lex_state = 2177, .external_lex_state = 10},
  [133] = {.lex_state = 2177, .external_lex_state = 4},
  [134] = {.lex_state = 2177, .external_lex_state = 10},
  [135] = {.lex_state = 2177, .external_lex_state = 7},
  [136] = {.lex_state = 2177, .external_lex_state = 10},
  [137] = {.lex_state = 2177, .external_lex_state = 10},
  [138] = {.lex_state = 2177, .external_lex_state = 10},
  [139] = {.lex_state = 2177, .external_lex_state = 10},
  [140] = {.lex_state = 2177, .external_lex_state = 10},
  [141] = {.lex_state = 2177, .external_lex_state = 10},
  [142] = {.lex_state = 2177, .external_lex_state = 10},
  [143] = {.lex_state = 2177, .external_lex_state = 10},
  [144] = {.lex_state = 2177, .external_lex_state = 10},
  [145] = {.lex_state = 2177, .external_lex_state = 10},
  [146] = {.lex_state = 2177, .external_lex_state = 10},
  [147] = {.lex_state = 2177, .external_lex_state = 10},
  [148] = {.lex_state = 2177, .external_lex_state = 10},
  [149] = {.lex_state = 2177, .external_lex_state = 7},
  [150] = {.lex_state = 2177, .external_lex_state = 9},
  [151] = {.lex_state = 2177, .external_lex_state = 7},
  [152] = {.lex_state = 2177, .external_lex_state = 8},
  [153] = {.lex_state = 2177, .external_lex_state = 8},
  [154] = {.lex_state = 2177, .external_lex_state = 9},
  [155] = {.lex_state = 2177, .external_lex_state = 10},
  [156] = {.lex_state = 2177, .external_lex_state = 10},
  [157] = {.lex_state = 2177, .external_lex_state = 10},
  [158] = {.lex_state = 2177, .external_lex_state = 9},
  [159] = {.lex_state = 2177, .external_lex_state = 8},
  [160] = {.lex_state = 2177, .external_lex_state = 10},
  [161] = {.lex_state = 2177, .external_lex_state = 9},
  [162] = {.lex_state = 2177, .external_lex_state = 10},
  [163] = {.lex_state = 2177, .external_lex_state = 7},
  [164] = {.lex_state = 2177, .external_lex_state = 8},
  [165] = {.lex_state = 2177, .external_lex_state = 7},
  [166] = {.lex_state = 2176, .external_lex_state = 8},
  [167] = {.lex_state = 2175, .external_lex_state = 8},
  [168] = {.lex_state = 2175, .external_lex_state = 8},
  [169] = {.lex_state = 2175, .external_lex_state = 9},
  [170] = {.lex_state = 2175, .external_lex_state = 7},
  [171] = {.lex_state = 2176, .external_lex_state = 9},
  [172] = {.lex_state = 2176, .external_lex_state = 7},
  [173] = {.lex_state = 2175, .external_lex_state = 9},
  [174] = {.lex_state = 2176, .external_lex_state = 7},
  [175] = {.lex_state = 2175, .external_lex_state = 10},
  [176] = {.lex_state = 2176, .external_lex_state = 8},
  [177] = {.lex_state = 2176, .external_lex_state = 9},
  [178] = {.lex_state = 2176, .external_lex_state = 10},
  [179] = {.lex_state = 2175, .external_lex_state = 7},
  [180] = {.lex_state = 2174, .external_lex_state = 8},
  [181] = {.lex_state = 2174, .external_lex_state = 7},
  [182] = {.lex_state = 2174, .external_lex_state = 8},
  [183] = {.lex_state = 2174, .external_lex_state = 10},
  [184] = {.lex_state = 2175, .external_lex_state = 10},
  [185] = {.lex_state = 2174, .external_lex_state = 9},
  [186] = {.lex_state = 2175, .external_lex_state = 10},
  [187] = {.lex_state = 2174, .external_lex_state = 7},
  [188] = {.lex_state = 2176, .external_lex_state = 10},
  [189] = {.lex_state = 2174, .external_lex_state = 9},
  [190] = {.lex_state = 2176, .external_lex_state = 10},
  [191] = {.lex_state = 2174, .external_lex_state = 10},
  [192] = {.lex_state = 2174, .external_lex_state = 10},
  [193] = {.lex_state = 2177, .external_lex_state = 11},
  [194] = {.lex_state = 2177, .external_lex_state = 3},
  [195] = {.lex_state = 2177, .external_lex_state = 6},
  [196] = {.lex_state = 2177, .external_lex_state = 12},
  [197] = {.lex_state = 2177, .external_lex_state = 6},
  [198] = {.lex_state = 2177, .external_lex_state = 7},
  [199] = {.lex_state = 2177, .external_lex_state = 4},
  [200] = {.lex_state = 2177, .external_lex_state = 9},
  [201] = {.lex_state = 2177, .external_lex_state = 4},
  [202] = {.lex_state = 2177, .external_lex_state = 5},
  [203] = {.lex_state = 2177, .external_lex_state = 13},
  [204] = {.lex_state = 2177, .external_lex_state = 8},
  [205] = {.lex_state = 2177, .external_lex_state = 10},
  [206] = {.lex_state = 2177, .external_lex_state = 5},
  [207] = {.lex_state = 2177, .external_lex_state = 2},
  [208] = {.lex_state = 2177, .external_lex_state = 3},
  [209] = {.lex_state = 7, .external_lex_state = 14},
  [210] = {.lex_state = 2177, .external_lex_state = 5},
  [211] = {.lex_state = 2177, .external_lex_state = 6},
  [212] = {.lex_state = 2177, .external_lex_state = 6},
  [213] = {.lex_state = 2177, .external_lex_state = 3},
  [214] = {.lex_state = 2177, .external_lex_state = 10},
  [215] = {.lex_state = 7, .external_lex_state = 15},
  [216] = {.lex_state = 2177, .external_lex_state = 12},
  [217] = {.lex_state = 2177, .external_lex_state = 12},
  [218] = {.lex_state = 7, .external_lex_state = 15},
  [219] = {.lex_state = 2177, .external_lex_state = 3},
  [220] = {.lex_state = 7, .external_lex_state = 15},
  [221] = {.lex_state = 7, .external_lex_state = 14},
  [222] = {.lex_state = 7, .external_lex_state = 15},
  [223] = {.lex_state = 2177, .external_lex_state = 3},
  [224] = {.lex_state = 7, .external_lex_state = 14},
  [225] = {.lex_state = 2177, .external_lex_state = 3},
  [226] = {.lex_state = 2177, .external_lex_state = 6},
  [227] = {.lex_state = 2177, .external_lex_state = 2},
  [228] = {.lex_state = 7, .external_lex_state = 15},
  [229] = {.lex_state = 7, .external_lex_state = 15},
  [230] = {.lex_state = 2177, .external_lex_state = 6},
  [231] = {.lex_state = 7, .external_lex_state = 14},
  [232] = {.lex_state = 2177, .external_lex_state = 5},
  [233] = {.lex_state = 7, .external_lex_state = 14},
  [234] = {.lex_state = 2177, .external_lex_state = 11},
  [235] = {.lex_state = 7, .external_lex_state = 15},
  [236] = {.lex_state = 7, .external_lex_state = 14},
  [237] = {.lex_state = 7, .external_lex_state = 14},
  [238] = {.lex_state = 2177, .external_lex_state = 4},
  [239] = {.lex_state = 7, .external_lex_state = 14},
  [240] = {.lex_state = 2177, .external_lex_state = 6},
  [241] = {.lex_state = 2177, .external_lex_state = 2},
  [242] = {.lex_state = 2177, .external_lex_state = 11},
  [243] = {.lex_state = 2177, .external_lex_state = 5},
  [244] = {.lex_state = 2177, .external_lex_state = 4},
  [245] = {.lex_state = 2177, .external_lex_state = 5},
  [246] = {.lex_state = 2177, .external_lex_state = 4},
  [247] = {.lex_state = 2177, .external_lex_state = 5},
  [248] = {.lex_state = 2177, .external_lex_state = 13},
  [249] = {.lex_state = 2177, .external_lex_state = 3},
  [250] = {.lex_state = 7, .external_lex_state = 14},
  [251] = {.lex_state = 7, .external_lex_state = 14},
  [252] = {.lex_state = 2177, .external_lex_state = 2},
  [253] = {.lex_state = 2177, .external_lex_state = 4},
  [254] = {.lex_state = 2177, .external_lex_state = 4},
  [255] = {.lex_state = 7, .external_lex_state = 15},
  [256] = {.lex_state = 7, .external_lex_state = 15},
  [257] = {.lex_state = 7, .external_lex_state = 14},
  [258] = {.lex_state = 2177, .external_lex_state = 4},
  [259] = {.lex_state = 2177, .external_lex_state = 13},
  [260] = {.lex_state = 7, .external_lex_state = 15},
  [261] = {.lex_state = 7, .external_lex_state = 15},
  [262] = {.lex_state = 2177, .external_lex_state = 8},
  [263] = {.lex_state = 2177, .external_lex_state = 9},
  [264] = {.lex_state = 2177, .external_lex_state = 10},
  [265] = {.lex_state = 2177, .external_lex_state = 10},
  [266] = {.lex_state = 2177, .external_lex_state = 10},
  [267] = {.lex_state = 2177, .external_lex_state = 10},
  [268] = {.lex_state = 2177, .external_lex_state = 8},
  [269] = {.lex_state = 1, .external_lex_state = 16},
  [270] = {.lex_state = 2177, .external_lex_state = 5},
  [271] = {.lex_state = 2177, .external_lex_state = 7},
  [272] = {.lex_state = 2177, .external_lex_state = 10},
  [273] = {.lex_state = 1, .external_lex_state = 16},
  [274] = {.lex_state = 2177, .external_lex_state = 10},
  [275] = {.lex_state = 2177, .external_lex_state = 10},
  [276] = {.lex_state = 2177, .external_lex_state = 10},
  [277] = {.lex_state = 2177, .external_lex_state = 10},
  [278] = {.lex_state = 2177, .external_lex_state = 10},
  [279] = {.lex_state = 2177, .external_lex_state = 2},
  [280] = {.lex_state = 2177, .external_lex_state = 10},
  [281] = {.lex_state = 2177, .external_lex_state = 10},
  [282] = {.lex_state = 2177, .external_lex_state = 7},
  [283] = {.lex_state = 2177, .external_lex_state = 10},
  [284] = {.lex_state = 2177, .external_lex_state = 7},
  [285] = {.lex_state = 2177, .external_lex_state = 2},
  [286] = {.lex_state = 2177, .external_lex_state = 3},
  [287] = {.lex_state = 2177, .external_lex_state = 10},
  [288] = {.lex_state = 1, .external_lex_state = 16},
  [289] = {.lex_state = 2177, .external_lex_state = 4},
  [290] = {.lex_state = 2177, .external_lex_state = 8},
  [291] = {.lex_state = 2177, .external_lex_state = 8},
  [292] = {.lex_state = 2177, .external_lex_state = 9},
  [293] = {.lex_state = 2177, .external_lex_state = 10},
  [294] = {.lex_state = 2177, .external_lex_state = 10},
  [295] = {.lex_state = 2177, .external_lex_state = 10},
  [296] = {.lex_state = 2177, .external_lex_state = 10},
  [297] = {.lex_state = 2177, .external_lex_state = 10},
  [298] = {.lex_state = 2177, .external_lex_state = 10},
  [299] = {.lex_state = 2177, .external_lex_state = 10},
  [300] = {.lex_state = 1, .external_lex_state = 16},
  [301] = {.lex_state = 2177, .external_lex_state = 10},
  [302] = {.lex_state = 1, .external_lex_state = 16},
  [303] = {.lex_state = 2177, .external_lex_state = 10},
  [304] = {.lex_state = 2177, .external_lex_state = 4},
  [305] = {.lex_state = 1, .external_lex_state = 16},
  [306] = {.lex_state = 2177, .external_lex_state = 10},
  [307] = {.lex_state = 2177, .external_lex_state = 10},
  [308] = {.lex_state = 2177, .external_lex_state = 10},
  [309] = {.lex_state = 2177, .external_lex_state = 10},
  [310] = {.lex_state = 2177, .external_lex_state = 10},
  [311] = {.lex_state = 2177, .external_lex_state = 10},
  [312] = {.lex_state = 2177, .external_lex_state = 8},
  [313] = {.lex_state = 1, .external_lex_state = 16},
  [314] = {.lex_state = 2177, .external_lex_state = 7},
  [315] = {.lex_state = 2177, .external_lex_state = 10},
  [316] = {.lex_state = 2177, .external_lex_state = 10},
  [317] = {.lex_state = 2177, .external_lex_state = 7},
  [318] = {.lex_state = 2177, .external_lex_state = 10},
  [319] = {.lex_state = 2177, .external_lex_state = 6},
  [320] = {.lex_state = 2177, .external_lex_state = 8},
  [321] = {.lex_state = 2177, .external_lex_state = 9},
  [322] = {.lex_state = 2177, .external_lex_state = 9},
  [323] = {.lex_state = 2177, .external_lex_state = 9},
  [324] = {.lex_state = 2177, .external_lex_state = 9},
  [325] = {.lex_state = 2177, .external_lex_state = 9},
  [326] = {.lex_state = 2177, .external_lex_state = 10},
  [327] = {.lex_state = 2177, .external_lex_state = 10},
  [328] = {.lex_state = 1, .external_lex_state = 16},
  [329] = {.lex_state = 2177, .external_lex_state = 9},
  [330] = {.lex_state = 2177, .external_lex_state = 9},
  [331] = {.lex_state = 2177, .external_lex_state = 7},
  [332] = {.lex_state = 2177, .external_lex_state = 4},
  [333] = {.lex_state = 2177, .external_lex_state = 4},
  [334] = {.lex_state = 2177, .external_lex_state = 9},
  [335] = {.lex_state = 2177, .external_lex_state = 9},
  [336] = {.lex_state = 1, .external_lex_state = 16},
  [337] = {.lex_state = 1, .external_lex_state = 16},
  [338] = {.lex_state = 2177, .external_lex_state = 9},
  [339] = {.lex_state = 2177, .external_lex_state = 9},
  [340] = {.lex_state = 2177, .external_lex_state = 9},
  [341] = {.lex_state = 2177, .external_lex_state = 9},
  [342] = {.lex_state = 2177, .external_lex_state = 9},
  [343] = {.lex_state = 2177, .external_lex_state = 10},
  [344] = {.lex_state = 2177, .external_lex_state = 9},
  [345] = {.lex_state = 2177, .external_lex_state = 7},
  [346] = {.lex_state = 2177, .external_lex_state = 7},
  [347] = {.lex_state = 2177, .external_lex_state = 7},
  [348] = {.lex_state = 2177, .external_lex_state = 7},
  [349] = {.lex_state = 1, .external_lex_state = 16},
  [350] = {.lex_state = 2177, .external_lex_state = 9},
  [351] = {.lex_state = 2177, .external_lex_state = 9},
  [352] = {.lex_state = 2177, .external_lex_state = 9},
  [353] = {.lex_state = 2177, .external_lex_state = 7},
  [354] = {.lex_state = 2177, .external_lex_state = 7},
  [355] = {.lex_state = 2177, .external_lex_state = 9},
  [356] = {.lex_state = 2177, .external_lex_state = 9},
  [357] = {.lex_state = 2177, .external_lex_state = 7},
  [358] = {.lex_state = 2177, .external_lex_state = 10},
  [359] = {.lex_state = 2177, .external_lex_state = 9},
  [360] = {.lex_state = 2177, .external_lex_state = 10},
  [361] = {.lex_state = 1, .external_lex_state = 16},
  [362] = {.lex_state = 2177, .external_lex_state = 10},
  [363] = {.lex_state = 2177, .external_lex_state = 10},
  [364] = {.lex_state = 2177, .external_lex_state = 7},
  [365] = {.lex_state = 2177, .external_lex_state = 7},
  [366] = {.lex_state = 2177, .external_lex_state = 7},
  [367] = {.lex_state = 2177, .external_lex_state = 10},
  [368] = {.lex_state = 2177, .external_lex_state = 7},
  [369] = {.lex_state = 2177, .external_lex_state = 10},
  [370] = {.lex_state = 2177, .external_lex_state = 7},
  [371] = {.lex_state = 2177, .external_lex_state = 7},
  [372] = {.lex_state = 2177, .external_lex_state = 7},
  [373] = {.lex_state = 2177, .external_lex_state = 7},
  [374] = {.lex_state = 2177, .external_lex_state = 7},
  [375] = {.lex_state = 2177, .external_lex_state = 7},
  [376] = {.lex_state = 2177, .external_lex_state = 7},
  [377] = {.lex_state = 2177, .external_lex_state = 8},
  [378] = {.lex_state = 2177, .external_lex_state = 10},
  [379] = {.lex_state = 2177, .external_lex_state = 10},
  [380] = {.lex_state = 2177, .external_lex_state = 10},
  [381] = {.lex_state = 1, .external_lex_state = 16},
  [382] = {.lex_state = 2177, .external_lex_state = 4},
  [383] = {.lex_state = 1, .external_lex_state = 16},
  [384] = {.lex_state = 2177, .external_lex_state = 7},
  [385] = {.lex_state = 2177, .external_lex_state = 7},
  [386] = {.lex_state = 2177, .external_lex_state = 7},
  [387] = {.lex_state = 2177, .external_lex_state = 7},
  [388] = {.lex_state = 2177, .external_lex_state = 7},
  [389] = {.lex_state = 2177, .external_lex_state = 7},
  [390] = {.lex_state = 2177, .external_lex_state = 7},
  [391] = {.lex_state = 2177, .external_lex_state = 9},
  [392] = {.lex_state = 2177, .external_lex_state = 10},
  [393] = {.lex_state = 2177, .external_lex_state = 9},
  [394] = {.lex_state = 2177, .external_lex_state = 9},
  [395] = {.lex_state = 2177, .external_lex_state = 9},
  [396] = {.lex_state = 2177, .external_lex_state = 9},
  [397] = {.lex_state = 2177, .external_lex_state = 10},
  [398] = {.lex_state = 2177, .external_lex_state = 9},
  [399] = {.lex_state = 2177, .external_lex_state = 9},
  [400] = {.lex_state = 2177, .external_lex_state = 8},
  [401] = {.lex_state = 2177, .external_lex_state = 8},
  [402] = {.lex_state = 2177, .external_lex_state = 7},
  [403] = {.lex_state = 2177, .external_lex_state = 7},
  [404] = {.lex_state = 2177, .external_lex_state = 7},
  [405] = {.lex_state = 2177, .external_lex_state = 9},
  [406] = {.lex_state = 2177, .external_lex_state = 9},
  [407] = {.lex_state = 2177, .external_lex_state = 8},
  [408] = {.lex_state = 2177, .external_lex_state = 8},
  [409] = {.lex_state = 2177, .external_lex_state = 8},
  [410] = {.lex_state = 2177, .external_lex_state = 7},
  [411] = {.lex_state = 2177, .external_lex_state = 7},
  [412] = {.lex_state = 2177, .external_lex_state = 7},
  [413] = {.lex_state = 2177, .external_lex_state = 8},
  [414] = {.lex_state = 2177, .external_lex_state = 10},
  [415] = {.lex_state = 2177, .external_lex_state = 7},
  [416] = {.lex_state = 2177, .external_lex_state = 7},
  [417] = {.lex_state = 2177, .external_lex_state = 7},
  [418] = {.lex_state = 2177, .external_lex_state = 7},
  [419] = {.lex_state = 2177, .external_lex_state = 7},
  [420] = {.lex_state = 2177, .external_lex_state = 7},
  [421] = {.lex_state = 2177, .external_lex_state = 8},
  [422] = {.lex_state = 2177, .external_lex_state = 10},
  [423] = {.lex_state = 2177, .external_lex_state = 10},
  [424] = {.lex_state = 2177, .external_lex_state = 9},
  [425] = {.lex_state = 2177, .external_lex_state = 9},
  [426] = {.lex_state = 2177, .external_lex_state = 10},
  [427] = {.lex_state = 2177, .external_lex_state = 10},
  [428] = {.lex_state = 2177, .external_lex_state = 9},
  [429] = {.lex_state = 2177, .external_lex_state = 10},
  [430] = {.lex_state = 2177, .external_lex_state = 8},
  [431] = {.lex_state = 2177, .external_lex_state = 8},
  [432] = {.lex_state = 2177, .external_lex_state = 10},
  [433] = {.lex_state = 2177, .external_lex_state = 8},
  [434] = {.lex_state = 2177, .external_lex_state = 8},
  [435] = {.lex_state = 2177, .external_lex_state = 8},
  [436] = {.lex_state = 2177, .external_lex_state = 8},
  [437] = {.lex_state = 2177, .external_lex_state = 7},
  [438] = {.lex_state = 2177, .external_lex_state = 8},
  [439] = {.lex_state = 2177, .external_lex_state = 8},
  [440] = {.lex_state = 2177, .external_lex_state = 8},
  [441] = {.lex_state = 2177, .external_lex_state = 7},
  [442] = {.lex_state = 2177, .external_lex_state = 8},
  [443] = {.lex_state = 2177, .external_lex_state = 7},
  [444] = {.lex_state = 2177, .external_lex_state = 7},
  [445] = {.lex_state = 2177, .external_lex_state = 7},
  [446] = {.lex_state = 2177, .external_lex_state = 7},
  [447] = {.lex_state = 2177, .external_lex_state = 7},
  [448] = {.lex_state = 2177, .external_lex_state = 8},
  [449] = {.lex_state = 2177, .external_lex_state = 8},
  [450] = {.lex_state = 2177, .external_lex_state = 8},
  [451] = {.lex_state = 2177, .external_lex_state = 8},
  [452] = {.lex_state = 2177, .external_lex_state = 8},
  [453] = {.lex_state = 2177, .external_lex_state = 8},
  [454] = {.lex_state = 2177, .external_lex_state = 8},
  [455] = {.lex_state = 2177, .external_lex_state = 8},
  [456] = {.lex_state = 2177, .external_lex_state = 8},
  [457] = {.lex_state = 2177, .external_lex_state = 8},
  [458] = {.lex_state = 2177, .external_lex_state = 8},
  [459] = {.lex_state = 2177, .external_lex_state = 7},
  [460] = {.lex_state = 2177, .external_lex_state = 7},
  [461] = {.lex_state = 2177, .external_lex_state = 7},
  [462] = {.lex_state = 2177, .external_lex_state = 7},
  [463] = {.lex_state = 2177, .external_lex_state = 7},
  [464] = {.lex_state = 2177, .external_lex_state = 8},
  [465] = {.lex_state = 2177, .external_lex_state = 8},
  [466] = {.lex_state = 2177, .external_lex_state = 8},
  [467] = {.lex_state = 2177, .external_lex_state = 8},
  [468] = {.lex_state = 2177, .external_lex_state = 8},
  [469] = {.lex_state = 2177, .external_lex_state = 8},
  [470] = {.lex_state = 2177, .external_lex_state = 8},
  [471] = {.lex_state = 2177, .external_lex_state = 7},
  [472] = {.lex_state = 2177, .external_lex_state = 7},
  [473] = {.lex_state = 2177, .external_lex_state = 10},
  [474] = {.lex_state = 1, .external_lex_state = 16},
  [475] = {.lex_state = 2177, .external_lex_state = 7},
  [476] = {.lex_state = 2177, .external_lex_state = 7},
  [477] = {.lex_state = 2177, .external_lex_state = 8},
  [478] = {.lex_state = 2177, .external_lex_state = 8},
  [479] = {.lex_state = 2177, .external_lex_state = 8},
  [480] = {.lex_state = 2177, .external_lex_state = 7},
  [481] = {.lex_state = 2177, .external_lex_state = 7},
  [482] = {.lex_state = 2177, .external_lex_state = 7},
  [483] = {.lex_state = 2177, .external_lex_state = 8},
  [484] = {.lex_state = 2177, .external_lex_state = 8},
  [485] = {.lex_state = 2177, .external_lex_state = 7},
  [486] = {.lex_state = 2177, .external_lex_state = 7},
  [487] = {.lex_state = 2177, .external_lex_state = 8},
  [488] = {.lex_state = 2177, .external_lex_state = 8},
  [489] = {.lex_state = 2177, .external_lex_state = 8},
  [490] = {.lex_state = 2177, .external_lex_state = 8},
  [491] = {.lex_state = 2177, .external_lex_state = 8},
  [492] = {.lex_state = 2177, .external_lex_state = 8},
  [493] = {.lex_state = 2177, .external_lex_state = 9},
  [494] = {.lex_state = 2177, .external_lex_state = 10},
  [495] = {.lex_state = 2177, .external_lex_state = 10},
  [496] = {.lex_state = 2177, .external_lex_state = 10},
  [497] = {.lex_state = 2177, .external_lex_state = 10},
  [498] = {.lex_state = 2177, .external_lex_state = 10},
  [499] = {.lex_state = 2177, .external_lex_state = 4},
  [500] = {.lex_state = 2177, .external_lex_state = 10},
  [501] = {.lex_state = 1, .external_lex_state = 16},
  [502] = {.lex_state = 2177, .external_lex_state = 9},
  [503] = {.lex_state = 2177, .external_lex_state = 9},
  [504] = {.lex_state = 2177, .external_lex_state = 9},
  [505] = {.lex_state = 2177, .external_lex_state = 9},
  [506] = {.lex_state = 2177, .external_lex_state = 8},
  [507] = {.lex_state = 2177, .external_lex_state = 9},
  [508] = {.lex_state = 2177, .external_lex_state = 9},
  [509] = {.lex_state = 2177, .external_lex_state = 8},
  [510] = {.lex_state = 2177, .external_lex_state = 9},
  [511] = {.lex_state = 2177, .external_lex_state = 8},
  [512] = {.lex_state = 2177, .external_lex_state = 8},
  [513] = {.lex_state = 2177, .external_lex_state = 8},
  [514] = {.lex_state = 2177, .external_lex_state = 8},
  [515] = {.lex_state = 2177, .external_lex_state = 8},
  [516] = {.lex_state = 2177, .external_lex_state = 9},
  [517] = {.lex_state = 2177, .external_lex_state = 9},
  [518] = {.lex_state = 2177, .external_lex_state = 9},
  [519] = {.lex_state = 2177, .external_lex_state = 9},
  [520] = {.lex_state = 2177, .external_lex_state = 9},
  [521] = {.lex_state = 2177, .external_lex_state = 9},
  [522] = {.lex_state = 2177, .external_lex_state = 9},
  [523] = {.lex_state = 2177, .external_lex_state = 9},
  [524] = {.lex_state = 2177, .external_lex_state = 9},
  [525] = {.lex_state = 2177, .external_lex_state = 9},
  [526] = {.lex_state = 2177, .external_lex_state = 8},
  [527] = {.lex_state = 2177, .external_lex_state = 8},
  [528] = {.lex_state = 2177, .external_lex_state = 8},
  [529] = {.lex_state = 2177, .external_lex_state = 8},
  [530] = {.lex_state = 2177, .external_lex_state = 9},
  [531] = {.lex_state = 2177, .external_lex_state = 9},
  [532] = {.lex_state = 2177, .external_lex_state = 9},
  [533] = {.lex_state = 2177, .external_lex_state = 9},
  [534] = {.lex_state = 2177, .external_lex_state = 9},
  [535] = {.lex_state = 2177, .external_lex_state = 9},
  [536] = {.lex_state = 2177, .external_lex_state = 10},
  [537] = {.lex_state = 2177, .external_lex_state = 10},
  [538] = {.lex_state = 2177, .external_lex_state = 8},
  [539] = {.lex_state = 2177, .external_lex_state = 10},
  [540] = {.lex_state = 2177, .external_lex_state = 9},
  [541] = {.lex_state = 2177, .external_lex_state = 7},
  [542] = {.lex_state = 2177, .external_lex_state = 10},
  [543] = {.lex_state = 2177, .external_lex_state = 10},
  [544] = {.lex_state = 2177, .external_lex_state = 10},
  [545] = {.lex_state = 2177, .external_lex_state = 10},
  [546] = {.lex_state = 2177, .external_lex_state = 10},
  [547] = {.lex_state = 2177, .external_lex_state = 10},
  [548] = {.lex_state = 2177, .external_lex_state = 10},
  [549] = {.lex_state = 2177, .external_lex_state = 10},
  [550] = {.lex_state = 2177, .external_lex_state = 10},
  [551] = {.lex_state = 2177, .external_lex_state = 10},
  [552] = {.lex_state = 2177, .external_lex_state = 10},
  [553] = {.lex_state = 2177, .external_lex_state = 10},
  [554] = {.lex_state = 2177, .external_lex_state = 10},
  [555] = {.lex_state = 2177, .external_lex_state = 10},
  [556] = {.lex_state = 2177, .external_lex_state = 10},
  [557] = {.lex_state = 2177, .external_lex_state = 10},
  [558] = {.lex_state = 2177, .external_lex_state = 10},
  [559] = {.lex_state = 2177, .external_lex_state = 10},
  [560] = {.lex_state = 2177, .external_lex_state = 10},
  [561] = {.lex_state = 2177, .external_lex_state = 10},
  [562] = {.lex_state = 2177, .external_lex_state = 10},
  [563] = {.lex_state = 2177, .external_lex_state = 10},
  [564] = {.lex_state = 2177, .external_lex_state = 10},
  [565] = {.lex_state = 2177, .external_lex_state = 10},
  [566] = {.lex_state = 2177, .external_lex_state = 10},
  [567] = {.lex_state = 2177, .external_lex_state = 10},
  [568] = {.lex_state = 2177, .external_lex_state = 10},
  [569] = {.lex_state = 2177, .external_lex_state = 10},
  [570] = {.lex_state = 2177, .external_lex_state = 10},
  [571] = {.lex_state = 2177, .external_lex_state = 10},
  [572] = {.lex_state = 2177, .external_lex_state = 10},
  [573] = {.lex_state = 2177, .external_lex_state = 10},
  [574] = {.lex_state = 2177, .external_lex_state = 10},
  [575] = {.lex_state = 2177, .external_lex_state = 10},
  [576] = {.lex_state = 2177, .external_lex_state = 10},
  [577] = {.lex_state = 2177, .external_lex_state = 10},
  [578] = {.lex_state = 2177, .external_lex_state = 10},
  [579] = {.lex_state = 2177, .external_lex_state = 10},
  [580] = {.lex_state = 2177, .external_lex_state = 10},
  [581] = {.lex_state = 2177, .external_lex_state = 10},
  [582] = {.lex_state = 2177, .external_lex_state = 10},
  [583] = {.lex_state = 2177, .external_lex_state = 10},
  [584] = {.lex_state = 2177, .external_lex_state = 10},
  [585] = {.lex_state = 2177, .external_lex_state = 10},
  [586] = {.lex_state = 2177, .external_lex_state = 10},
  [587] = {.lex_state = 2177, .external_lex_state = 10},
  [588] = {.lex_state = 2177, .external_lex_state = 10},
  [589] = {.lex_state = 2177, .external_lex_state = 10},
  [590] = {.lex_state = 2177, .external_lex_state = 10},
  [591] = {.lex_state = 2177, .external_lex_state = 10},
  [592] = {.lex_state = 2177, .external_lex_state = 10},
  [593] = {.lex_state = 2177, .external_lex_state = 10},
  [594] = {.lex_state = 2177, .external_lex_state = 10},
  [595] = {.lex_state = 2177, .external_lex_state = 10},
  [596] = {.lex_state = 2177, .external_lex_state = 10},
  [597] = {.lex_state = 2177, .external_lex_state = 10},
  [598] = {.lex_state = 2177, .external_lex_state = 10},
  [599] = {.lex_state = 2177, .external_lex_state = 10},
  [600] = {.lex_state = 2177, .external_lex_state = 9},
  [601] = {.lex_state = 2177, .external_lex_state = 10},
  [602] = {.lex_state = 2177, .external_lex_state = 7},
  [603] = {.lex_state = 2177, .external_lex_state = 8},
  [604] = {.lex_state = 2177, .external_lex_state = 10},
  [605] = {.lex_state = 2177, .external_lex_state = 10},
  [606] = {.lex_state = 2177, .external_lex_state = 10},
  [607] = {.lex_state = 2177, .external_lex_state = 8},
  [608] = {.lex_state = 2177, .external_lex_state = 7},
  [609] = {.lex_state = 2177, .external_lex_state = 7},
  [610] = {.lex_state = 2177, .external_lex_state = 7},
  [611] = {.lex_state = 2177, .external_lex_state = 7},
  [612] = {.lex_state = 2177, .external_lex_state = 10},
  [613] = {.lex_state = 2177, .external_lex_state = 7},
  [614] = {.lex_state = 2177, .external_lex_state = 7},
  [615] = {.lex_state = 2177, .external_lex_state = 7},
  [616] = {.lex_state = 2177, .external_lex_state = 7},
  [617] = {.lex_state = 2177, .external_lex_state = 7},
  [618] = {.lex_state = 2177, .external_lex_state = 8},
  [619] = {.lex_state = 2177, .external_lex_state = 10},
  [620] = {.lex_state = 2177, .external_lex_state = 10},
  [621] = {.lex_state = 2177, .external_lex_state = 10},
  [622] = {.lex_state = 2177, .external_lex_state = 9},
  [623] = {.lex_state = 2177, .external_lex_state = 9},
  [624] = {.lex_state = 2177, .external_lex_state = 9},
  [625] = {.lex_state = 2177, .external_lex_state = 10},
  [626] = {.lex_state = 2177, .external_lex_state = 8},
  [627] = {.lex_state = 2177, .external_lex_state = 8},
  [628] = {.lex_state = 2177, .external_lex_state = 7},
  [629] = {.lex_state = 2177, .external_lex_state = 9},
  [630] = {.lex_state = 2177, .external_lex_state = 9},
  [631] = {.lex_state = 2177, .external_lex_state = 9},
  [632] = {.lex_state = 2177, .external_lex_state = 10},
  [633] = {.lex_state = 2177, .external_lex_state = 8},
  [634] = {.lex_state = 2177, .external_lex_state = 8},
  [635] = {.lex_state = 2177, .external_lex_state = 9},
  [636] = {.lex_state = 2177, .external_lex_state = 8},
  [637] = {.lex_state = 2177, .external_lex_state = 8},
  [638] = {.lex_state = 2177, .external_lex_state = 9},
  [639] = {.lex_state = 2177, .external_lex_state = 8},
  [640] = {.lex_state = 2177, .external_lex_state = 8},
  [641] = {.lex_state = 2177, .external_lex_state = 8},
  [642] = {.lex_state = 2177, .external_lex_state = 8},
  [643] = {.lex_state = 2177, .external_lex_state = 7},
  [644] = {.lex_state = 2177, .external_lex_state = 7},
  [645] = {.lex_state = 2},
  [646] = {.lex_state = 2},
  [647] = {.lex_state = 2},
  [648] = {.lex_state = 2},
  [649] = {.lex_state = 2},
  [650] = {.lex_state = 2},
  [651] = {.lex_state = 2},
  [652] = {.lex_state = 2},
  [653] = {.lex_state = 2, .external_lex_state = 17},
  [654] = {.lex_state = 2},
  [655] = {.lex_state = 2},
  [656] = {.lex_state = 2},
  [657] = {.lex_state = 2},
  [658] = {.lex_state = 2},
  [659] = {.lex_state = 2},
  [660] = {.lex_state = 2},
  [661] = {.lex_state = 2},
  [662] = {.lex_state = 2},
  [663] = {.lex_state = 2},
  [664] = {.lex_state = 2},
  [665] = {.lex_state = 2},
  [666] = {.lex_state = 2, .external_lex_state = 17},
  [667] = {.lex_state = 1, .external_lex_state = 18},
  [668] = {.lex_state = 6, .external_lex_state = 15},
  [669] = {.lex_state = 1, .external_lex_state = 19},
  [670] = {.lex_state = 2},
  [671] = {.lex_state = 6, .external_lex_state = 14},
  [672] = {.lex_state = 5, .external_lex_state = 14},
  [673] = {.lex_state = 5, .external_lex_state = 15},
  [674] = {.lex_state = 1, .external_lex_state = 18},
  [675] = {.lex_state = 1, .external_lex_state = 16},
  [676] = {.lex_state = 1, .external_lex_state = 16},
  [677] = {.lex_state = 3, .external_lex_state = 14},
  [678] = {.lex_state = 1, .external_lex_state = 16},
  [679] = {.lex_state = 1, .external_lex_state = 16},
  [680] = {.lex_state = 3, .external_lex_state = 15},
  [681] = {.lex_state = 2},
  [682] = {.lex_state = 2, .external_lex_state = 17},
  [683] = {.lex_state = 2},
  [684] = {.lex_state = 2},
  [685] = {.lex_state = 2, .external_lex_state = 17},
  [686] = {.lex_state = 2, .external_lex_state = 17},
  [687] = {.lex_state = 2},
  [688] = {.lex_state = 2},
  [689] = {.lex_state = 2},
  [690] = {.lex_state = 7, .external_lex_state = 20},
  [691] = {.lex_state = 2},
  [692] = {.lex_state = 2},
  [693] = {.lex_state = 7, .external_lex_state = 15},
  [694] = {.lex_state = 2},
  [695] = {.lex_state = 2},
  [696] = {.lex_state = 2},
  [697] = {.lex_state = 2},
  [698] = {.lex_state = 2},
  [699] = {.lex_state = 2},
  [700] = {.lex_state = 7, .external_lex_state = 21},
  [701] = {.lex_state = 7, .external_lex_state = 14},
  [702] = {.lex_state = 4, .external_lex_state = 17},
  [703] = {.lex_state = 4, .external_lex_state = 17},
  [704] = {.lex_state = 7, .external_lex_state = 20},
  [705] = {.lex_state = 7, .external_lex_state = 22},
  [706] = {.lex_state = 7, .external_lex_state = 21},
  [707] = {.lex_state = 7, .external_lex_state = 22},
  [708] = {.lex_state = 4, .external_lex_state = 17},
  [709] = {.lex_state = 4, .external_lex_state = 17},
  [710] = {.lex_state = 2177},
  [711] = {.lex_state = 4, .external_lex_state = 17},
  [712] = {.lex_state = 4, .external_lex_state = 17},
  [713] = {.lex_state = 4, .external_lex_state = 17},
  [714] = {.lex_state = 4, .external_lex_state = 17},
  [715] = {.lex_state = 4, .external_lex_state = 17},
  [716] = {.lex_state = 4, .external_lex_state = 17},
  [717] = {.lex_state = 2},
  [718] = {.lex_state = 4, .external_lex_state = 17},
  [719] = {.lex_state = 4, .external_lex_state = 17},
  [720] = {.lex_state = 2177},
  [721] = {.lex_state = 2177},
  [722] = {.lex_state = 4, .external_lex_state = 17},
  [723] = {.lex_state = 4, .external_lex_state = 17},
  [724] = {.lex_state = 7, .external_lex_state = 23},
  [725] = {.lex_state = 7, .external_lex_state = 23},
  [726] = {.lex_state = 8},
  [727] = {.lex_state = 4},
  [728] = {.lex_state = 7, .external_lex_state = 15},
  [729] = {.lex_state = 7, .external_lex_state = 15},
  [730] = {.lex_state = 7, .external_lex_state = 15},
  [731] = {.lex_state = 7, .external_lex_state = 15},
  [732] = {.lex_state = 7, .external_lex_state = 15},
  [733] = {.lex_state = 7, .external_lex_state = 15},
  [734] = {.lex_state = 7, .external_lex_state = 15},
  [735] = {.lex_state = 7, .external_lex_state = 15},
  [736] = {.lex_state = 7, .external_lex_state = 15},
  [737] = {.lex_state = 7, .external_lex_state = 15},
  [738] = {.lex_state = 7, .external_lex_state = 15},
  [739] = {.lex_state = 7, .external_lex_state = 15},
  [740] = {.lex_state = 7, .external_lex_state = 15},
  [741] = {.lex_state = 7, .external_lex_state = 15},
  [742] = {.lex_state = 7, .external_lex_state = 15},
  [743] = {.lex_state = 7, .external_lex_state = 15},
  [744] = {.lex_state = 7, .external_lex_state = 15},
  [745] = {.lex_state = 7, .external_lex_state = 15},
  [746] = {.lex_state = 7, .external_lex_state = 15},
  [747] = {.lex_state = 4},
  [748] = {.lex_state = 4},
  [749] = {.lex_state = 4},
  [750] = {.lex_state = 4},
  [751] = {.lex_state = 4},
  [752] = {.lex_state = 4},
  [753] = {.lex_state = 9},
  [754] = {.lex_state = 8},
  [755] = {.lex_state = 4},
  [756] = {.lex_state = 7, .external_lex_state = 15},
  [757] = {.lex_state = 4},
  [758] = {.lex_state = 4},
  [759] = {.lex_state = 4},
  [760] = {.lex_state = 4},
  [761] = {.lex_state = 4},
  [762] = {.lex_state = 4},
  [763] = {.lex_state = 4},
  [764] = {.lex_state = 8},
  [765] = {.lex_state = 9},
  [766] = {.lex_state = 4},
  [767] = {.lex_state = 9},
  [768] = {.lex_state = 4},
  [769] = {.lex_state = 4},
  [770] = {.lex_state = 4},
  [771] = {.lex_state = 4},
  [772] = {.lex_state = 4},
  [773] = {.lex_state = 4},
  [774] = {.lex_state = 8},
  [775] = {.lex_state = 4},
  [776] = {.lex_state = 4},
  [777] = {.lex_state = 9},
  [778] = {.lex_state = 7, .external_lex_state = 15},
  [779] = {.lex_state = 7, .external_lex_state = 14},
  [780] = {.lex_state = 4},
  [781] = {.lex_state = 4},
  [782] = {.lex_state = 4},
  [783] = {.lex_state = 7, .external_lex_state = 14},
  [784] = {.lex_state = 7, .external_lex_state = 14},
  [785] = {.lex_state = 7, .external_lex_state = 14},
  [786] = {.lex_state = 7, .external_lex_state = 14},
  [787] = {.lex_state = 8},
  [788] = {.lex_state = 7, .external_lex_state = 14},
  [789] = {.lex_state = 7, .external_lex_state = 14},
  [790] = {.lex_state = 9},
  [791] = {.lex_state = 7, .external_lex_state = 14},
  [792] = {.lex_state = 4},
  [793] = {.lex_state = 8},
  [794] = {.lex_state = 4},
  [795] = {.lex_state = 9},
  [796] = {.lex_state = 7, .external_lex_state = 14},
  [797] = {.lex_state = 7, .external_lex_state = 14},
  [798] = {.lex_state = 7, .external_lex_state = 14},
  [799] = {.lex_state = 9},
  [800] = {.lex_state = 7, .external_lex_state = 14},
  [801] = {.lex_state = 4},
  [802] = {.lex_state = 7, .external_lex_state = 14},
  [803] = {.lex_state = 7, .external_lex_state = 14},
  [804] = {.lex_state = 7, .external_lex_state = 14},
  [805] = {.lex_state = 7, .external_lex_state = 14},
  [806] = {.lex_state = 7, .external_lex_state = 14},
  [807] = {.lex_state = 4},
  [808] = {.lex_state = 4},
  [809] = {.lex_state = 8},
  [810] = {.lex_state = 9},
  [811] = {.lex_state = 4},
  [812] = {.lex_state = 7, .external_lex_state = 14},
  [813] = {.lex_state = 4},
  [814] = {.lex_state = 4},
  [815] = {.lex_state = 7, .external_lex_state = 14},
  [816] = {.lex_state = 4},
  [817] = {.lex_state = 7, .external_lex_state = 14},
  [818] = {.lex_state = 4},
  [819] = {.lex_state = 4},
  [820] = {.lex_state = 7, .external_lex_state = 14},
  [821] = {.lex_state = 4},
  [822] = {.lex_state = 4},
  [823] = {.lex_state = 4},
  [824] = {.lex_state = 8},
  [825] = {.lex_state = 4},
  [826] = {.lex_state = 4},
  [827] = {.lex_state = 10},
  [828] = {.lex_state = 10},
  [829] = {.lex_state = 2, .external_lex_state = 17},
  [830] = {.lex_state = 2},
  [831] = {.lex_state = 10},
  [832] = {.lex_state = 10},
  [833] = {.lex_state = 10},
  [834] = {.lex_state = 10},
  [835] = {.lex_state = 10},
  [836] = {.lex_state = 10},
  [837] = {.lex_state = 10},
  [838] = {.lex_state = 2},
  [839] = {.lex_state = 2, .external_lex_state = 17},
  [840] = {.lex_state = 10},
  [841] = {.lex_state = 2, .external_lex_state = 17},
  [842] = {.lex_state = 10},
  [843] = {.lex_state = 2},
  [844] = {.lex_state = 2, .external_lex_state = 17},
  [845] = {.lex_state = 2, .external_lex_state = 17},
  [846] = {.lex_state = 10},
  [847] = {.lex_state = 10},
  [848] = {.lex_state = 10},
  [849] = {.lex_state = 2, .external_lex_state = 17},
  [850] = {.lex_state = 2, .external_lex_state = 24},
  [851] = {.lex_state = 10},
  [852] = {.lex_state = 2},
  [853] = {.lex_state = 10},
  [854] = {.lex_state = 10},
  [855] = {.lex_state = 10},
  [856] = {.lex_state = 2, .external_lex_state = 17},
  [857] = {.lex_state = 10},
  [858] = {.lex_state = 10},
  [859] = {.lex_state = 2, .external_lex_state = 24},
  [860] = {.lex_state = 10},
  [861] = {.lex_state = 2},
  [862] = {.lex_state = 2},
  [863] = {.lex_state = 2},
  [864] = {.lex_state = 2},
  [865] = {.lex_state = 2},
  [866] = {.lex_state = 2},
  [867] = {.lex_state = 2},
  [868] = {.lex_state = 2},
  [869] = {.lex_state = 2},
  [870] = {.lex_state = 2},
  [871] = {.lex_state = 2},
  [872] = {.lex_state = 2},
  [873] = {.lex_state = 2, .external_lex_state = 17},
  [874] = {.lex_state = 2},
  [875] = {.lex_state = 2},
  [876] = {.lex_state = 2},
  [877] = {.lex_state = 2},
  [878] = {.lex_state = 2},
  [879] = {.lex_state = 2},
  [880] = {.lex_state = 2},
  [881] = {.lex_state = 2},
  [882] = {.lex_state = 8, .external_lex_state = 17},
  [883] = {.lex_state = 4, .external_lex_state = 17},
  [884] = {.lex_state = 2177, .external_lex_state = 17},
  [885] = {.lex_state = 9, .external_lex_state = 17},
  [886] = {.lex_state = 8, .external_lex_state = 24},
  [887] = {.lex_state = 9, .external_lex_state = 24},
  [888] = {.lex_state = 8, .external_lex_state = 24},
  [889] = {.lex_state = 4, .external_lex_state = 17},
  [890] = {.lex_state = 9, .external_lex_state = 24},
  [891] = {.lex_state = 4, .external_lex_state = 24},
  [892] = {.lex_state = 4, .external_lex_state = 24},
  [893] = {.lex_state = 4},
  [894] = {.lex_state = 8},
  [895] = {.lex_state = 8},
  [896] = {.lex_state = 10, .external_lex_state = 17},
  [897] = {.lex_state = 4},
  [898] = {.lex_state = 9},
  [899] = {.lex_state = 2177},
  [900] = {.lex_state = 4},
  [901] = {.lex_state = 10, .external_lex_state = 17},
  [902] = {.lex_state = 9},
  [903] = {.lex_state = 9},
  [904] = {.lex_state = 4},
  [905] = {.lex_state = 8},
  [906] = {.lex_state = 10, .external_lex_state = 17},
  [907] = {.lex_state = 4},
  [908] = {.lex_state = 10, .external_lex_state = 24},
  [909] = {.lex_state = 10, .external_lex_state = 24},
  [910] = {.lex_state = 10},
  [911] = {.lex_state = 10},
  [912] = {.lex_state = 10},
  [913] = {.lex_state = 10},
  [914] = {.lex_state = 10},
  [915] = {.lex_state = 10},
  [916] = {.lex_state = 10},
  [917] = {.lex_state = 10},
  [918] = {.lex_state = 10},
  [919] = {.lex_state = 10},
  [920] = {.lex_state = 10},
  [921] = {.lex_state = 10},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 11},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 11},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 11},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 11},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 12},
  [963] = {.lex_state = 12},
  [964] = {.lex_state = 2177},
  [965] = {.lex_state = 12},
  [966] = {.lex_state = 12},
  [967] = {.lex_state = 12},
  [968] = {.lex_state = 12},
  [969] = {.lex_state = 12},
  [970] = {.lex_state = 12},
  [971] = {.lex_state = 2177},
  [972] = {.lex_state = 12},
  [973] = {.lex_state = 12},
  [974] = {.lex_state = 12},
  [975] = {.lex_state = 11},
  [976] = {.lex_state = 12},
  [977] = {.lex_state = 12},
  [978] = {.lex_state = 12},
  [979] = {.lex_state = 2177},
  [980] = {.lex_state = 12},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 12, .external_lex_state = 24},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 11, .external_lex_state = 24},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 11, .external_lex_state = 24},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 12},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 12, .external_lex_state = 24},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 12},
  [1103] = {.lex_state = 11},
  [1104] = {.lex_state = 12},
  [1105] = {.lex_state = 11},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0, .external_lex_state = 25},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0, .external_lex_state = 26},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0, .external_lex_state = 26},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0, .external_lex_state = 26},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0, .external_lex_state = 26},
  [1159] = {.lex_state = 0},
};

enum {
  ts_external_token__error = 0,
  ts_external_token__trigger_error = 1,
  ts_external_token__code_span_start = 2,
  ts_external_token__code_span_close = 3,
  ts_external_token__emphasis_open_star = 4,
  ts_external_token__emphasis_open_underscore = 5,
  ts_external_token__emphasis_close_star = 6,
  ts_external_token__emphasis_close_underscore = 7,
  ts_external_token__last_token_whitespace = 8,
  ts_external_token__last_token_punctuation = 9,
  ts_external_token__strikethrough_open = 10,
  ts_external_token__strikethrough_close = 11,
  ts_external_token__latex_span_start = 12,
  ts_external_token__latex_span_close = 13,
  ts_external_token__unclosed_span = 14,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__error] = sym__error,
  [ts_external_token__trigger_error] = sym__trigger_error,
  [ts_external_token__code_span_start] = sym__code_span_start,
  [ts_external_token__code_span_close] = sym__code_span_close,
  [ts_external_token__emphasis_open_star] = sym__emphasis_open_star,
  [ts_external_token__emphasis_open_underscore] = sym__emphasis_open_underscore,
  [ts_external_token__emphasis_close_star] = sym__emphasis_close_star,
  [ts_external_token__emphasis_close_underscore] = sym__emphasis_close_underscore,
  [ts_external_token__last_token_whitespace] = sym__last_token_whitespace,
  [ts_external_token__last_token_punctuation] = sym__last_token_punctuation,
  [ts_external_token__strikethrough_open] = sym__strikethrough_open,
  [ts_external_token__strikethrough_close] = sym__strikethrough_close,
  [ts_external_token__latex_span_start] = sym__latex_span_start,
  [ts_external_token__latex_span_close] = sym__latex_span_close,
  [ts_external_token__unclosed_span] = sym__unclosed_span,
};

static const bool ts_external_scanner_states[27][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__error] = true,
    [ts_external_token__trigger_error] = true,
    [ts_external_token__code_span_start] = true,
    [ts_external_token__code_span_close] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__emphasis_close_star] = true,
    [ts_external_token__emphasis_close_underscore] = true,
    [ts_external_token__last_token_whitespace] = true,
    [ts_external_token__last_token_punctuation] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__strikethrough_close] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__latex_span_close] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [2] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__last_token_whitespace] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [3] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__emphasis_close_underscore] = true,
    [ts_external_token__last_token_punctuation] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [4] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__last_token_punctuation] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [5] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__last_token_punctuation] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__strikethrough_close] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [6] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__emphasis_close_star] = true,
    [ts_external_token__last_token_punctuation] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [7] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__emphasis_close_star] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [8] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__emphasis_close_underscore] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [9] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__strikethrough_close] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [10] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [11] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__emphasis_close_underscore] = true,
    [ts_external_token__last_token_whitespace] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [12] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__emphasis_close_star] = true,
    [ts_external_token__last_token_whitespace] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [13] = {
    [ts_external_token__code_span_start] = true,
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__last_token_whitespace] = true,
    [ts_external_token__strikethrough_open] = true,
    [ts_external_token__strikethrough_close] = true,
    [ts_external_token__latex_span_start] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [14] = {
    [ts_external_token__code_span_close] = true,
  },
  [15] = {
    [ts_external_token__latex_span_close] = true,
  },
  [16] = {
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [17] = {
    [ts_external_token__last_token_punctuation] = true,
  },
  [18] = {
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__last_token_whitespace] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [19] = {
    [ts_external_token__emphasis_open_star] = true,
    [ts_external_token__emphasis_open_underscore] = true,
    [ts_external_token__last_token_punctuation] = true,
    [ts_external_token__unclosed_span] = true,
  },
  [20] = {
    [ts_external_token__last_token_punctuation] = true,
    [ts_external_token__latex_span_close] = true,
  },
  [21] = {
    [ts_external_token__code_span_close] = true,
    [ts_external_token__last_token_punctuation] = true,
  },
  [22] = {
    [ts_external_token__code_span_close] = true,
    [ts_external_token__last_token_whitespace] = true,
  },
  [23] = {
    [ts_external_token__last_token_whitespace] = true,
    [ts_external_token__latex_span_close] = true,
  },
  [24] = {
    [ts_external_token__last_token_whitespace] = true,
  },
  [25] = {
    [ts_external_token__trigger_error] = true,
    [ts_external_token__last_token_whitespace] = true,
  },
  [26] = {
    [ts_external_token__trigger_error] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__backslash_escape] = ACTIONS(1),
    [sym_entity_reference] = ACTIONS(1),
    [sym_numeric_character_reference] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym__newline_token] = ACTIONS(1),
    [sym_uri_autolink] = ACTIONS(1),
    [sym_email_autolink] = ACTIONS(1),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1),
    [anon_sym_DASH_DASH_GT] = ACTIONS(1),
    [anon_sym_LT_QMARK] = ACTIONS(1),
    [anon_sym_QMARK_GT] = ACTIONS(1),
    [aux_sym__declaration_token1] = ACTIONS(1),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK_RBRACK_GT] = ACTIONS(1),
    [sym__whitespace_ge_2] = ACTIONS(1),
    [aux_sym__whitespace_token1] = ACTIONS(1),
    [sym__word_no_digit] = ACTIONS(1),
    [sym__digits] = ACTIONS(1),
    [sym__error] = ACTIONS(1),
    [sym__trigger_error] = ACTIONS(1),
    [sym__code_span_start] = ACTIONS(1),
    [sym__code_span_close] = ACTIONS(1),
    [sym__emphasis_open_star] = ACTIONS(1),
    [sym__emphasis_open_underscore] = ACTIONS(1),
    [sym__emphasis_close_star] = ACTIONS(1),
    [sym__emphasis_close_underscore] = ACTIONS(1),
    [sym__last_token_whitespace] = ACTIONS(1),
    [sym__last_token_punctuation] = ACTIONS(1),
    [sym__strikethrough_open] = ACTIONS(1),
    [sym__strikethrough_close] = ACTIONS(1),
    [sym__latex_span_start] = ACTIONS(1),
    [sym__latex_span_close] = ACTIONS(1),
    [sym__unclosed_span] = ACTIONS(1),
  },
  [1] = {
    [sym_inline] = STATE(1140),
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(31),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__last_token_whitespace] = ACTIONS(41),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [2] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(19),
    [aux_sym__inline_no_tilde] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(47),
    [sym_entity_reference] = ACTIONS(50),
    [sym_numeric_character_reference] = ACTIONS(50),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(56),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(62),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(62),
    [anon_sym_POUND] = ACTIONS(62),
    [anon_sym_DOLLAR] = ACTIONS(62),
    [anon_sym_PERCENT] = ACTIONS(62),
    [anon_sym_AMP] = ACTIONS(68),
    [anon_sym_SQUOTE] = ACTIONS(62),
    [anon_sym_STAR] = ACTIONS(62),
    [anon_sym_PLUS] = ACTIONS(62),
    [anon_sym_COMMA] = ACTIONS(62),
    [anon_sym_DASH] = ACTIONS(62),
    [anon_sym_DOT] = ACTIONS(62),
    [anon_sym_SLASH] = ACTIONS(62),
    [anon_sym_COLON] = ACTIONS(62),
    [anon_sym_SEMI] = ACTIONS(62),
    [anon_sym_EQ] = ACTIONS(62),
    [anon_sym_QMARK] = ACTIONS(62),
    [anon_sym_AT] = ACTIONS(62),
    [anon_sym_BSLASH] = ACTIONS(71),
    [anon_sym_CARET] = ACTIONS(62),
    [anon_sym__] = ACTIONS(62),
    [anon_sym_BQUOTE] = ACTIONS(62),
    [anon_sym_LBRACE] = ACTIONS(62),
    [anon_sym_PIPE] = ACTIONS(62),
    [anon_sym_RBRACE] = ACTIONS(62),
    [anon_sym_TILDE] = ACTIONS(62),
    [anon_sym_LPAREN] = ACTIONS(62),
    [anon_sym_RPAREN] = ACTIONS(62),
    [sym__newline_token] = ACTIONS(74),
    [sym_uri_autolink] = ACTIONS(50),
    [sym_email_autolink] = ACTIONS(50),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(77),
    [anon_sym_LT_QMARK] = ACTIONS(80),
    [aux_sym__declaration_token1] = ACTIONS(83),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(86),
    [sym__whitespace_ge_2] = ACTIONS(89),
    [aux_sym__whitespace_token1] = ACTIONS(92),
    [sym__word_no_digit] = ACTIONS(50),
    [sym__digits] = ACTIONS(50),
    [sym__code_span_start] = ACTIONS(95),
    [sym__emphasis_open_star] = ACTIONS(98),
    [sym__emphasis_open_underscore] = ACTIONS(101),
    [sym__emphasis_close_underscore] = ACTIONS(104),
    [sym__last_token_punctuation] = ACTIONS(106),
    [sym__strikethrough_open] = ACTIONS(108),
    [sym__latex_span_start] = ACTIONS(111),
    [sym__unclosed_span] = ACTIONS(50),
  },
  [3] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(42),
    [sym_full_reference_link] = STATE(42),
    [sym_collapsed_reference_link] = STATE(42),
    [sym_inline_link] = STATE(42),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(42),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(42),
    [aux_sym__inline_no_star] = STATE(42),
    [sym__strikethrough] = STATE(42),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(42),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(42),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(116),
    [sym_entity_reference] = ACTIONS(119),
    [sym_numeric_character_reference] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(122),
    [anon_sym_RBRACK] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(128),
    [anon_sym_GT] = ACTIONS(131),
    [anon_sym_BANG] = ACTIONS(134),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(131),
    [anon_sym_DOLLAR] = ACTIONS(131),
    [anon_sym_PERCENT] = ACTIONS(131),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(131),
    [anon_sym_COMMA] = ACTIONS(131),
    [anon_sym_DASH] = ACTIONS(131),
    [anon_sym_DOT] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(131),
    [anon_sym_COLON] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(131),
    [anon_sym_EQ] = ACTIONS(131),
    [anon_sym_QMARK] = ACTIONS(131),
    [anon_sym_AT] = ACTIONS(131),
    [anon_sym_BSLASH] = ACTIONS(140),
    [anon_sym_CARET] = ACTIONS(131),
    [anon_sym__] = ACTIONS(131),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_PIPE] = ACTIONS(131),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_TILDE] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(131),
    [sym__newline_token] = ACTIONS(143),
    [sym_uri_autolink] = ACTIONS(119),
    [sym_email_autolink] = ACTIONS(119),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(146),
    [anon_sym_LT_QMARK] = ACTIONS(149),
    [aux_sym__declaration_token1] = ACTIONS(152),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(155),
    [sym__whitespace_ge_2] = ACTIONS(158),
    [aux_sym__whitespace_token1] = ACTIONS(161),
    [sym__word_no_digit] = ACTIONS(119),
    [sym__digits] = ACTIONS(119),
    [sym__code_span_start] = ACTIONS(164),
    [sym__emphasis_open_star] = ACTIONS(167),
    [sym__emphasis_open_underscore] = ACTIONS(170),
    [sym__last_token_punctuation] = ACTIONS(173),
    [sym__strikethrough_open] = ACTIONS(175),
    [sym__latex_span_start] = ACTIONS(178),
    [sym__unclosed_span] = ACTIONS(119),
  },
  [4] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(49),
    [sym_full_reference_link] = STATE(49),
    [sym_collapsed_reference_link] = STATE(49),
    [sym_inline_link] = STATE(49),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(49),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(49),
    [aux_sym__inline_no_underscore] = STATE(49),
    [sym__strikethrough] = STATE(49),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(49),
    [sym__emphasis_underscore] = STATE(291),
    [sym__strong_emphasis_underscore] = STATE(49),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(181),
    [sym_entity_reference] = ACTIONS(184),
    [sym_numeric_character_reference] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(190),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(196),
    [anon_sym_BANG] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(196),
    [anon_sym_POUND] = ACTIONS(196),
    [anon_sym_DOLLAR] = ACTIONS(196),
    [anon_sym_PERCENT] = ACTIONS(196),
    [anon_sym_AMP] = ACTIONS(202),
    [anon_sym_SQUOTE] = ACTIONS(196),
    [anon_sym_STAR] = ACTIONS(196),
    [anon_sym_PLUS] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(196),
    [anon_sym_DASH] = ACTIONS(196),
    [anon_sym_DOT] = ACTIONS(196),
    [anon_sym_SLASH] = ACTIONS(196),
    [anon_sym_COLON] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(196),
    [anon_sym_EQ] = ACTIONS(196),
    [anon_sym_QMARK] = ACTIONS(196),
    [anon_sym_AT] = ACTIONS(196),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_CARET] = ACTIONS(196),
    [anon_sym__] = ACTIONS(196),
    [anon_sym_BQUOTE] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(196),
    [anon_sym_PIPE] = ACTIONS(196),
    [anon_sym_RBRACE] = ACTIONS(196),
    [anon_sym_TILDE] = ACTIONS(196),
    [anon_sym_LPAREN] = ACTIONS(196),
    [anon_sym_RPAREN] = ACTIONS(196),
    [sym__newline_token] = ACTIONS(208),
    [sym_uri_autolink] = ACTIONS(184),
    [sym_email_autolink] = ACTIONS(184),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(211),
    [anon_sym_LT_QMARK] = ACTIONS(214),
    [aux_sym__declaration_token1] = ACTIONS(217),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(220),
    [sym__whitespace_ge_2] = ACTIONS(223),
    [aux_sym__whitespace_token1] = ACTIONS(226),
    [sym__word_no_digit] = ACTIONS(184),
    [sym__digits] = ACTIONS(184),
    [sym__code_span_start] = ACTIONS(229),
    [sym__emphasis_open_star] = ACTIONS(232),
    [sym__emphasis_open_underscore] = ACTIONS(235),
    [sym__last_token_punctuation] = ACTIONS(238),
    [sym__strikethrough_open] = ACTIONS(240),
    [sym__latex_span_start] = ACTIONS(243),
    [sym__unclosed_span] = ACTIONS(184),
  },
  [5] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(47),
    [sym_full_reference_link] = STATE(47),
    [sym_collapsed_reference_link] = STATE(47),
    [sym_inline_link] = STATE(47),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(47),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(47),
    [aux_sym__inline_no_underscore] = STATE(47),
    [sym__strikethrough] = STATE(47),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(47),
    [sym__emphasis_underscore] = STATE(268),
    [sym__strong_emphasis_underscore] = STATE(47),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(246),
    [sym_entity_reference] = ACTIONS(249),
    [sym_numeric_character_reference] = ACTIONS(249),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_RBRACK] = ACTIONS(255),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(261),
    [anon_sym_POUND] = ACTIONS(261),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_PERCENT] = ACTIONS(261),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_SQUOTE] = ACTIONS(261),
    [anon_sym_STAR] = ACTIONS(261),
    [anon_sym_PLUS] = ACTIONS(261),
    [anon_sym_COMMA] = ACTIONS(261),
    [anon_sym_DASH] = ACTIONS(261),
    [anon_sym_DOT] = ACTIONS(261),
    [anon_sym_SLASH] = ACTIONS(261),
    [anon_sym_COLON] = ACTIONS(261),
    [anon_sym_SEMI] = ACTIONS(261),
    [anon_sym_EQ] = ACTIONS(261),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [anon_sym_BSLASH] = ACTIONS(270),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym__] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_PIPE] = ACTIONS(261),
    [anon_sym_RBRACE] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_RPAREN] = ACTIONS(261),
    [sym__newline_token] = ACTIONS(273),
    [sym_uri_autolink] = ACTIONS(249),
    [sym_email_autolink] = ACTIONS(249),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(276),
    [anon_sym_LT_QMARK] = ACTIONS(279),
    [aux_sym__declaration_token1] = ACTIONS(282),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(285),
    [sym__whitespace_ge_2] = ACTIONS(288),
    [aux_sym__whitespace_token1] = ACTIONS(291),
    [sym__word_no_digit] = ACTIONS(249),
    [sym__digits] = ACTIONS(249),
    [sym__code_span_start] = ACTIONS(294),
    [sym__emphasis_open_star] = ACTIONS(297),
    [sym__emphasis_open_underscore] = ACTIONS(300),
    [sym__last_token_punctuation] = ACTIONS(303),
    [sym__strikethrough_open] = ACTIONS(305),
    [sym__strikethrough_close] = ACTIONS(308),
    [sym__latex_span_start] = ACTIONS(310),
    [sym__unclosed_span] = ACTIONS(249),
  },
  [6] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(41),
    [sym_full_reference_link] = STATE(41),
    [sym_collapsed_reference_link] = STATE(41),
    [sym_inline_link] = STATE(41),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(41),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(41),
    [aux_sym__inline_no_tilde] = STATE(41),
    [sym__strikethrough] = STATE(41),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(41),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(41),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(313),
    [sym_entity_reference] = ACTIONS(316),
    [sym_numeric_character_reference] = ACTIONS(316),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_RBRACK] = ACTIONS(322),
    [anon_sym_LT] = ACTIONS(325),
    [anon_sym_GT] = ACTIONS(328),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_DQUOTE] = ACTIONS(328),
    [anon_sym_POUND] = ACTIONS(328),
    [anon_sym_DOLLAR] = ACTIONS(328),
    [anon_sym_PERCENT] = ACTIONS(328),
    [anon_sym_AMP] = ACTIONS(334),
    [anon_sym_SQUOTE] = ACTIONS(328),
    [anon_sym_STAR] = ACTIONS(328),
    [anon_sym_PLUS] = ACTIONS(328),
    [anon_sym_COMMA] = ACTIONS(328),
    [anon_sym_DASH] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(328),
    [anon_sym_SLASH] = ACTIONS(328),
    [anon_sym_COLON] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_EQ] = ACTIONS(328),
    [anon_sym_QMARK] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(328),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(328),
    [anon_sym__] = ACTIONS(328),
    [anon_sym_BQUOTE] = ACTIONS(328),
    [anon_sym_LBRACE] = ACTIONS(328),
    [anon_sym_PIPE] = ACTIONS(328),
    [anon_sym_RBRACE] = ACTIONS(328),
    [anon_sym_TILDE] = ACTIONS(328),
    [anon_sym_LPAREN] = ACTIONS(328),
    [anon_sym_RPAREN] = ACTIONS(328),
    [sym__newline_token] = ACTIONS(340),
    [sym_uri_autolink] = ACTIONS(316),
    [sym_email_autolink] = ACTIONS(316),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(343),
    [anon_sym_LT_QMARK] = ACTIONS(346),
    [aux_sym__declaration_token1] = ACTIONS(349),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(352),
    [sym__whitespace_ge_2] = ACTIONS(355),
    [aux_sym__whitespace_token1] = ACTIONS(358),
    [sym__word_no_digit] = ACTIONS(316),
    [sym__digits] = ACTIONS(316),
    [sym__code_span_start] = ACTIONS(361),
    [sym__emphasis_open_star] = ACTIONS(364),
    [sym__emphasis_open_underscore] = ACTIONS(367),
    [sym__last_token_punctuation] = ACTIONS(370),
    [sym__strikethrough_open] = ACTIONS(372),
    [sym__latex_span_start] = ACTIONS(375),
    [sym__unclosed_span] = ACTIONS(316),
  },
  [7] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(24),
    [sym_full_reference_link] = STATE(24),
    [sym_collapsed_reference_link] = STATE(24),
    [sym_inline_link] = STATE(24),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(24),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(24),
    [aux_sym__inline_no_star] = STATE(24),
    [sym__strikethrough] = STATE(24),
    [sym__emphasis_star] = STATE(314),
    [sym__strong_emphasis_star] = STATE(24),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(24),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(378),
    [sym_entity_reference] = ACTIONS(381),
    [sym_numeric_character_reference] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(384),
    [anon_sym_RBRACK] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(390),
    [anon_sym_GT] = ACTIONS(393),
    [anon_sym_BANG] = ACTIONS(396),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_POUND] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(393),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(393),
    [anon_sym_PLUS] = ACTIONS(393),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_DASH] = ACTIONS(393),
    [anon_sym_DOT] = ACTIONS(393),
    [anon_sym_SLASH] = ACTIONS(393),
    [anon_sym_COLON] = ACTIONS(393),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(393),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_AT] = ACTIONS(393),
    [anon_sym_BSLASH] = ACTIONS(402),
    [anon_sym_CARET] = ACTIONS(393),
    [anon_sym__] = ACTIONS(393),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(393),
    [anon_sym_RBRACE] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_RPAREN] = ACTIONS(393),
    [sym__newline_token] = ACTIONS(405),
    [sym_uri_autolink] = ACTIONS(381),
    [sym_email_autolink] = ACTIONS(381),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(408),
    [anon_sym_LT_QMARK] = ACTIONS(411),
    [aux_sym__declaration_token1] = ACTIONS(414),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(417),
    [sym__whitespace_ge_2] = ACTIONS(420),
    [aux_sym__whitespace_token1] = ACTIONS(423),
    [sym__word_no_digit] = ACTIONS(381),
    [sym__digits] = ACTIONS(381),
    [sym__code_span_start] = ACTIONS(426),
    [sym__emphasis_open_star] = ACTIONS(429),
    [sym__emphasis_open_underscore] = ACTIONS(432),
    [sym__emphasis_close_underscore] = ACTIONS(104),
    [sym__last_token_punctuation] = ACTIONS(435),
    [sym__strikethrough_open] = ACTIONS(437),
    [sym__latex_span_start] = ACTIONS(440),
    [sym__unclosed_span] = ACTIONS(381),
  },
  [8] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(38),
    [sym_full_reference_link] = STATE(38),
    [sym_collapsed_reference_link] = STATE(38),
    [sym_inline_link] = STATE(38),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(38),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(38),
    [aux_sym__inline_no_tilde] = STATE(38),
    [sym__strikethrough] = STATE(38),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(38),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(38),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(443),
    [sym_entity_reference] = ACTIONS(446),
    [sym_numeric_character_reference] = ACTIONS(446),
    [anon_sym_LBRACK] = ACTIONS(449),
    [anon_sym_RBRACK] = ACTIONS(452),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_GT] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(458),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_DOLLAR] = ACTIONS(458),
    [anon_sym_PERCENT] = ACTIONS(458),
    [anon_sym_AMP] = ACTIONS(464),
    [anon_sym_SQUOTE] = ACTIONS(458),
    [anon_sym_STAR] = ACTIONS(458),
    [anon_sym_PLUS] = ACTIONS(458),
    [anon_sym_COMMA] = ACTIONS(458),
    [anon_sym_DASH] = ACTIONS(458),
    [anon_sym_DOT] = ACTIONS(458),
    [anon_sym_SLASH] = ACTIONS(458),
    [anon_sym_COLON] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(458),
    [anon_sym_EQ] = ACTIONS(458),
    [anon_sym_QMARK] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(458),
    [anon_sym_BSLASH] = ACTIONS(467),
    [anon_sym_CARET] = ACTIONS(458),
    [anon_sym__] = ACTIONS(458),
    [anon_sym_BQUOTE] = ACTIONS(458),
    [anon_sym_LBRACE] = ACTIONS(458),
    [anon_sym_PIPE] = ACTIONS(458),
    [anon_sym_RBRACE] = ACTIONS(458),
    [anon_sym_TILDE] = ACTIONS(458),
    [anon_sym_LPAREN] = ACTIONS(458),
    [anon_sym_RPAREN] = ACTIONS(458),
    [sym__newline_token] = ACTIONS(470),
    [sym_uri_autolink] = ACTIONS(446),
    [sym_email_autolink] = ACTIONS(446),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(473),
    [anon_sym_LT_QMARK] = ACTIONS(476),
    [aux_sym__declaration_token1] = ACTIONS(479),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(482),
    [sym__whitespace_ge_2] = ACTIONS(485),
    [aux_sym__whitespace_token1] = ACTIONS(488),
    [sym__word_no_digit] = ACTIONS(446),
    [sym__digits] = ACTIONS(446),
    [sym__code_span_start] = ACTIONS(491),
    [sym__emphasis_open_star] = ACTIONS(494),
    [sym__emphasis_open_underscore] = ACTIONS(497),
    [sym__emphasis_close_star] = ACTIONS(500),
    [sym__last_token_punctuation] = ACTIONS(502),
    [sym__strikethrough_open] = ACTIONS(504),
    [sym__latex_span_start] = ACTIONS(507),
    [sym__unclosed_span] = ACTIONS(446),
  },
  [9] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(12),
    [sym_full_reference_link] = STATE(12),
    [sym_collapsed_reference_link] = STATE(12),
    [sym_inline_link] = STATE(12),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(12),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(12),
    [aux_sym__inline_no_underscore] = STATE(12),
    [sym__strikethrough] = STATE(12),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(12),
    [sym__emphasis_underscore] = STATE(408),
    [sym__strong_emphasis_underscore] = STATE(12),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(510),
    [sym_entity_reference] = ACTIONS(513),
    [sym_numeric_character_reference] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(516),
    [anon_sym_RBRACK] = ACTIONS(519),
    [anon_sym_LT] = ACTIONS(522),
    [anon_sym_GT] = ACTIONS(525),
    [anon_sym_BANG] = ACTIONS(528),
    [anon_sym_DQUOTE] = ACTIONS(525),
    [anon_sym_POUND] = ACTIONS(525),
    [anon_sym_DOLLAR] = ACTIONS(525),
    [anon_sym_PERCENT] = ACTIONS(525),
    [anon_sym_AMP] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [anon_sym_STAR] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(525),
    [anon_sym_COMMA] = ACTIONS(525),
    [anon_sym_DASH] = ACTIONS(525),
    [anon_sym_DOT] = ACTIONS(525),
    [anon_sym_SLASH] = ACTIONS(525),
    [anon_sym_COLON] = ACTIONS(525),
    [anon_sym_SEMI] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(525),
    [anon_sym_AT] = ACTIONS(525),
    [anon_sym_BSLASH] = ACTIONS(534),
    [anon_sym_CARET] = ACTIONS(525),
    [anon_sym__] = ACTIONS(525),
    [anon_sym_BQUOTE] = ACTIONS(525),
    [anon_sym_LBRACE] = ACTIONS(525),
    [anon_sym_PIPE] = ACTIONS(525),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_TILDE] = ACTIONS(525),
    [anon_sym_LPAREN] = ACTIONS(525),
    [anon_sym_RPAREN] = ACTIONS(525),
    [sym__newline_token] = ACTIONS(537),
    [sym_uri_autolink] = ACTIONS(513),
    [sym_email_autolink] = ACTIONS(513),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(540),
    [anon_sym_LT_QMARK] = ACTIONS(543),
    [aux_sym__declaration_token1] = ACTIONS(546),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(549),
    [sym__whitespace_ge_2] = ACTIONS(552),
    [aux_sym__whitespace_token1] = ACTIONS(555),
    [sym__word_no_digit] = ACTIONS(513),
    [sym__digits] = ACTIONS(513),
    [sym__code_span_start] = ACTIONS(558),
    [sym__emphasis_open_star] = ACTIONS(561),
    [sym__emphasis_open_underscore] = ACTIONS(564),
    [sym__emphasis_close_star] = ACTIONS(500),
    [sym__last_token_punctuation] = ACTIONS(567),
    [sym__strikethrough_open] = ACTIONS(569),
    [sym__latex_span_start] = ACTIONS(572),
    [sym__unclosed_span] = ACTIONS(513),
  },
  [10] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(45),
    [sym_full_reference_link] = STATE(45),
    [sym_collapsed_reference_link] = STATE(45),
    [sym_inline_link] = STATE(45),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(45),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(45),
    [aux_sym__inline_no_star] = STATE(45),
    [sym__strikethrough] = STATE(45),
    [sym__emphasis_star] = STATE(271),
    [sym__strong_emphasis_star] = STATE(45),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(45),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(575),
    [sym_entity_reference] = ACTIONS(578),
    [sym_numeric_character_reference] = ACTIONS(578),
    [anon_sym_LBRACK] = ACTIONS(581),
    [anon_sym_RBRACK] = ACTIONS(584),
    [anon_sym_LT] = ACTIONS(587),
    [anon_sym_GT] = ACTIONS(590),
    [anon_sym_BANG] = ACTIONS(593),
    [anon_sym_DQUOTE] = ACTIONS(590),
    [anon_sym_POUND] = ACTIONS(590),
    [anon_sym_DOLLAR] = ACTIONS(590),
    [anon_sym_PERCENT] = ACTIONS(590),
    [anon_sym_AMP] = ACTIONS(596),
    [anon_sym_SQUOTE] = ACTIONS(590),
    [anon_sym_STAR] = ACTIONS(590),
    [anon_sym_PLUS] = ACTIONS(590),
    [anon_sym_COMMA] = ACTIONS(590),
    [anon_sym_DASH] = ACTIONS(590),
    [anon_sym_DOT] = ACTIONS(590),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_COLON] = ACTIONS(590),
    [anon_sym_SEMI] = ACTIONS(590),
    [anon_sym_EQ] = ACTIONS(590),
    [anon_sym_QMARK] = ACTIONS(590),
    [anon_sym_AT] = ACTIONS(590),
    [anon_sym_BSLASH] = ACTIONS(599),
    [anon_sym_CARET] = ACTIONS(590),
    [anon_sym__] = ACTIONS(590),
    [anon_sym_BQUOTE] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(590),
    [anon_sym_PIPE] = ACTIONS(590),
    [anon_sym_RBRACE] = ACTIONS(590),
    [anon_sym_TILDE] = ACTIONS(590),
    [anon_sym_LPAREN] = ACTIONS(590),
    [anon_sym_RPAREN] = ACTIONS(590),
    [sym__newline_token] = ACTIONS(602),
    [sym_uri_autolink] = ACTIONS(578),
    [sym_email_autolink] = ACTIONS(578),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(605),
    [anon_sym_LT_QMARK] = ACTIONS(608),
    [aux_sym__declaration_token1] = ACTIONS(611),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(614),
    [sym__whitespace_ge_2] = ACTIONS(617),
    [aux_sym__whitespace_token1] = ACTIONS(620),
    [sym__word_no_digit] = ACTIONS(578),
    [sym__digits] = ACTIONS(578),
    [sym__code_span_start] = ACTIONS(623),
    [sym__emphasis_open_star] = ACTIONS(626),
    [sym__emphasis_open_underscore] = ACTIONS(629),
    [sym__last_token_punctuation] = ACTIONS(632),
    [sym__strikethrough_open] = ACTIONS(634),
    [sym__strikethrough_close] = ACTIONS(308),
    [sym__latex_span_start] = ACTIONS(637),
    [sym__unclosed_span] = ACTIONS(578),
  },
  [11] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(678),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [12] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(722),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [13] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(768),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [14] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(772),
    [sym_entity_reference] = ACTIONS(775),
    [sym_numeric_character_reference] = ACTIONS(775),
    [anon_sym_LBRACK] = ACTIONS(778),
    [anon_sym_RBRACK] = ACTIONS(781),
    [anon_sym_LT] = ACTIONS(784),
    [anon_sym_GT] = ACTIONS(787),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_POUND] = ACTIONS(787),
    [anon_sym_DOLLAR] = ACTIONS(787),
    [anon_sym_PERCENT] = ACTIONS(787),
    [anon_sym_AMP] = ACTIONS(793),
    [anon_sym_SQUOTE] = ACTIONS(787),
    [anon_sym_STAR] = ACTIONS(787),
    [anon_sym_PLUS] = ACTIONS(787),
    [anon_sym_COMMA] = ACTIONS(787),
    [anon_sym_DASH] = ACTIONS(787),
    [anon_sym_DOT] = ACTIONS(787),
    [anon_sym_SLASH] = ACTIONS(787),
    [anon_sym_COLON] = ACTIONS(787),
    [anon_sym_SEMI] = ACTIONS(787),
    [anon_sym_EQ] = ACTIONS(787),
    [anon_sym_QMARK] = ACTIONS(787),
    [anon_sym_AT] = ACTIONS(787),
    [anon_sym_BSLASH] = ACTIONS(796),
    [anon_sym_CARET] = ACTIONS(787),
    [anon_sym__] = ACTIONS(787),
    [anon_sym_BQUOTE] = ACTIONS(787),
    [anon_sym_LBRACE] = ACTIONS(787),
    [anon_sym_PIPE] = ACTIONS(787),
    [anon_sym_RBRACE] = ACTIONS(787),
    [anon_sym_TILDE] = ACTIONS(787),
    [anon_sym_LPAREN] = ACTIONS(787),
    [anon_sym_RPAREN] = ACTIONS(787),
    [sym__newline_token] = ACTIONS(799),
    [sym_uri_autolink] = ACTIONS(775),
    [sym_email_autolink] = ACTIONS(775),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(802),
    [anon_sym_LT_QMARK] = ACTIONS(805),
    [aux_sym__declaration_token1] = ACTIONS(808),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(811),
    [sym__whitespace_ge_2] = ACTIONS(814),
    [aux_sym__whitespace_token1] = ACTIONS(817),
    [sym__word_no_digit] = ACTIONS(775),
    [sym__digits] = ACTIONS(775),
    [sym__code_span_start] = ACTIONS(820),
    [sym__emphasis_open_star] = ACTIONS(823),
    [sym__emphasis_open_underscore] = ACTIONS(826),
    [sym__strikethrough_open] = ACTIONS(829),
    [sym__strikethrough_close] = ACTIONS(832),
    [sym__latex_span_start] = ACTIONS(834),
    [sym__unclosed_span] = ACTIONS(775),
  },
  [15] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(837),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [16] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(839),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [17] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(841),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [18] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(843),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [19] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(845),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [20] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(847),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [21] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(849),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [22] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(851),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [23] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(853),
    [sym_entity_reference] = ACTIONS(856),
    [sym_numeric_character_reference] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(859),
    [anon_sym_RBRACK] = ACTIONS(862),
    [anon_sym_LT] = ACTIONS(865),
    [anon_sym_GT] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(871),
    [anon_sym_DQUOTE] = ACTIONS(868),
    [anon_sym_POUND] = ACTIONS(868),
    [anon_sym_DOLLAR] = ACTIONS(868),
    [anon_sym_PERCENT] = ACTIONS(868),
    [anon_sym_AMP] = ACTIONS(874),
    [anon_sym_SQUOTE] = ACTIONS(868),
    [anon_sym_STAR] = ACTIONS(868),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_COMMA] = ACTIONS(868),
    [anon_sym_DASH] = ACTIONS(868),
    [anon_sym_DOT] = ACTIONS(868),
    [anon_sym_SLASH] = ACTIONS(868),
    [anon_sym_COLON] = ACTIONS(868),
    [anon_sym_SEMI] = ACTIONS(868),
    [anon_sym_EQ] = ACTIONS(868),
    [anon_sym_QMARK] = ACTIONS(868),
    [anon_sym_AT] = ACTIONS(868),
    [anon_sym_BSLASH] = ACTIONS(877),
    [anon_sym_CARET] = ACTIONS(868),
    [anon_sym__] = ACTIONS(868),
    [anon_sym_BQUOTE] = ACTIONS(868),
    [anon_sym_LBRACE] = ACTIONS(868),
    [anon_sym_PIPE] = ACTIONS(868),
    [anon_sym_RBRACE] = ACTIONS(868),
    [anon_sym_TILDE] = ACTIONS(868),
    [anon_sym_LPAREN] = ACTIONS(868),
    [anon_sym_RPAREN] = ACTIONS(868),
    [sym__newline_token] = ACTIONS(880),
    [sym_uri_autolink] = ACTIONS(856),
    [sym_email_autolink] = ACTIONS(856),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(883),
    [anon_sym_LT_QMARK] = ACTIONS(886),
    [aux_sym__declaration_token1] = ACTIONS(889),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(892),
    [sym__whitespace_ge_2] = ACTIONS(895),
    [aux_sym__whitespace_token1] = ACTIONS(898),
    [sym__word_no_digit] = ACTIONS(856),
    [sym__digits] = ACTIONS(856),
    [sym__code_span_start] = ACTIONS(901),
    [sym__emphasis_open_star] = ACTIONS(904),
    [sym__emphasis_open_underscore] = ACTIONS(907),
    [sym__emphasis_close_underscore] = ACTIONS(910),
    [sym__strikethrough_open] = ACTIONS(912),
    [sym__latex_span_start] = ACTIONS(915),
    [sym__unclosed_span] = ACTIONS(856),
  },
  [24] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(918),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [25] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(920),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [26] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(922),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [27] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(924),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [28] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(317),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(116),
    [sym_entity_reference] = ACTIONS(119),
    [sym_numeric_character_reference] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(122),
    [anon_sym_RBRACK] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(128),
    [anon_sym_GT] = ACTIONS(131),
    [anon_sym_BANG] = ACTIONS(134),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(131),
    [anon_sym_DOLLAR] = ACTIONS(131),
    [anon_sym_PERCENT] = ACTIONS(131),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(131),
    [anon_sym_COMMA] = ACTIONS(131),
    [anon_sym_DASH] = ACTIONS(131),
    [anon_sym_DOT] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(131),
    [anon_sym_COLON] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(131),
    [anon_sym_EQ] = ACTIONS(131),
    [anon_sym_QMARK] = ACTIONS(131),
    [anon_sym_AT] = ACTIONS(131),
    [anon_sym_BSLASH] = ACTIONS(140),
    [anon_sym_CARET] = ACTIONS(131),
    [anon_sym__] = ACTIONS(131),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_PIPE] = ACTIONS(131),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_TILDE] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(131),
    [sym__newline_token] = ACTIONS(143),
    [sym_uri_autolink] = ACTIONS(119),
    [sym_email_autolink] = ACTIONS(119),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(146),
    [anon_sym_LT_QMARK] = ACTIONS(149),
    [aux_sym__declaration_token1] = ACTIONS(152),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(155),
    [sym__whitespace_ge_2] = ACTIONS(158),
    [aux_sym__whitespace_token1] = ACTIONS(161),
    [sym__word_no_digit] = ACTIONS(119),
    [sym__digits] = ACTIONS(119),
    [sym__code_span_start] = ACTIONS(164),
    [sym__emphasis_open_star] = ACTIONS(167),
    [sym__emphasis_open_underscore] = ACTIONS(170),
    [sym__last_token_punctuation] = ACTIONS(926),
    [sym__strikethrough_open] = ACTIONS(175),
    [sym__latex_span_start] = ACTIONS(178),
    [sym__unclosed_span] = ACTIONS(119),
  },
  [29] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(25),
    [sym_full_reference_link] = STATE(25),
    [sym_collapsed_reference_link] = STATE(25),
    [sym_inline_link] = STATE(25),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(25),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(25),
    [aux_sym__inline_no_underscore] = STATE(25),
    [sym__strikethrough] = STATE(25),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(25),
    [sym__emphasis_underscore] = STATE(320),
    [sym__strong_emphasis_underscore] = STATE(25),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(181),
    [sym_entity_reference] = ACTIONS(184),
    [sym_numeric_character_reference] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(190),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(196),
    [anon_sym_BANG] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(196),
    [anon_sym_POUND] = ACTIONS(196),
    [anon_sym_DOLLAR] = ACTIONS(196),
    [anon_sym_PERCENT] = ACTIONS(196),
    [anon_sym_AMP] = ACTIONS(202),
    [anon_sym_SQUOTE] = ACTIONS(196),
    [anon_sym_STAR] = ACTIONS(196),
    [anon_sym_PLUS] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(196),
    [anon_sym_DASH] = ACTIONS(196),
    [anon_sym_DOT] = ACTIONS(196),
    [anon_sym_SLASH] = ACTIONS(196),
    [anon_sym_COLON] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(196),
    [anon_sym_EQ] = ACTIONS(196),
    [anon_sym_QMARK] = ACTIONS(196),
    [anon_sym_AT] = ACTIONS(196),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_CARET] = ACTIONS(196),
    [anon_sym__] = ACTIONS(196),
    [anon_sym_BQUOTE] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(196),
    [anon_sym_PIPE] = ACTIONS(196),
    [anon_sym_RBRACE] = ACTIONS(196),
    [anon_sym_TILDE] = ACTIONS(196),
    [anon_sym_LPAREN] = ACTIONS(196),
    [anon_sym_RPAREN] = ACTIONS(196),
    [sym__newline_token] = ACTIONS(208),
    [sym_uri_autolink] = ACTIONS(184),
    [sym_email_autolink] = ACTIONS(184),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(211),
    [anon_sym_LT_QMARK] = ACTIONS(214),
    [aux_sym__declaration_token1] = ACTIONS(217),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(220),
    [sym__whitespace_ge_2] = ACTIONS(223),
    [aux_sym__whitespace_token1] = ACTIONS(226),
    [sym__word_no_digit] = ACTIONS(184),
    [sym__digits] = ACTIONS(184),
    [sym__code_span_start] = ACTIONS(229),
    [sym__emphasis_open_star] = ACTIONS(232),
    [sym__emphasis_open_underscore] = ACTIONS(235),
    [sym__last_token_punctuation] = ACTIONS(928),
    [sym__strikethrough_open] = ACTIONS(240),
    [sym__latex_span_start] = ACTIONS(243),
    [sym__unclosed_span] = ACTIONS(184),
  },
  [30] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(27),
    [sym_full_reference_link] = STATE(27),
    [sym_collapsed_reference_link] = STATE(27),
    [sym_inline_link] = STATE(27),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(27),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(27),
    [aux_sym__inline_no_tilde] = STATE(27),
    [sym__strikethrough] = STATE(27),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(27),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(27),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(313),
    [sym_entity_reference] = ACTIONS(316),
    [sym_numeric_character_reference] = ACTIONS(316),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_RBRACK] = ACTIONS(322),
    [anon_sym_LT] = ACTIONS(325),
    [anon_sym_GT] = ACTIONS(328),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_DQUOTE] = ACTIONS(328),
    [anon_sym_POUND] = ACTIONS(328),
    [anon_sym_DOLLAR] = ACTIONS(328),
    [anon_sym_PERCENT] = ACTIONS(328),
    [anon_sym_AMP] = ACTIONS(334),
    [anon_sym_SQUOTE] = ACTIONS(328),
    [anon_sym_STAR] = ACTIONS(328),
    [anon_sym_PLUS] = ACTIONS(328),
    [anon_sym_COMMA] = ACTIONS(328),
    [anon_sym_DASH] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(328),
    [anon_sym_SLASH] = ACTIONS(328),
    [anon_sym_COLON] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_EQ] = ACTIONS(328),
    [anon_sym_QMARK] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(328),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(328),
    [anon_sym__] = ACTIONS(328),
    [anon_sym_BQUOTE] = ACTIONS(328),
    [anon_sym_LBRACE] = ACTIONS(328),
    [anon_sym_PIPE] = ACTIONS(328),
    [anon_sym_RBRACE] = ACTIONS(328),
    [anon_sym_TILDE] = ACTIONS(328),
    [anon_sym_LPAREN] = ACTIONS(328),
    [anon_sym_RPAREN] = ACTIONS(328),
    [sym__newline_token] = ACTIONS(340),
    [sym_uri_autolink] = ACTIONS(316),
    [sym_email_autolink] = ACTIONS(316),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(343),
    [anon_sym_LT_QMARK] = ACTIONS(346),
    [aux_sym__declaration_token1] = ACTIONS(349),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(352),
    [sym__whitespace_ge_2] = ACTIONS(355),
    [aux_sym__whitespace_token1] = ACTIONS(358),
    [sym__word_no_digit] = ACTIONS(316),
    [sym__digits] = ACTIONS(316),
    [sym__code_span_start] = ACTIONS(361),
    [sym__emphasis_open_star] = ACTIONS(364),
    [sym__emphasis_open_underscore] = ACTIONS(367),
    [sym__last_token_punctuation] = ACTIONS(930),
    [sym__strikethrough_open] = ACTIONS(372),
    [sym__latex_span_start] = ACTIONS(375),
    [sym__unclosed_span] = ACTIONS(316),
  },
  [31] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(48),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [ts_builtin_sym_end] = ACTIONS(932),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [32] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(934),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [33] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(936),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [34] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(938),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [35] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(940),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [36] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(11),
    [sym_full_reference_link] = STATE(11),
    [sym_collapsed_reference_link] = STATE(11),
    [sym_inline_link] = STATE(11),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(11),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(11),
    [aux_sym__inline_no_star] = STATE(11),
    [sym__strikethrough] = STATE(11),
    [sym__emphasis_star] = STATE(410),
    [sym__strong_emphasis_star] = STATE(11),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(11),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__last_token_punctuation] = ACTIONS(942),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [37] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(944),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [38] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(946),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [39] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(948),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [40] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(950),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [41] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(952),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [42] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(954),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [43] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(956),
    [sym_entity_reference] = ACTIONS(959),
    [sym_numeric_character_reference] = ACTIONS(959),
    [anon_sym_LBRACK] = ACTIONS(962),
    [anon_sym_RBRACK] = ACTIONS(965),
    [anon_sym_LT] = ACTIONS(968),
    [anon_sym_GT] = ACTIONS(971),
    [anon_sym_BANG] = ACTIONS(974),
    [anon_sym_DQUOTE] = ACTIONS(971),
    [anon_sym_POUND] = ACTIONS(971),
    [anon_sym_DOLLAR] = ACTIONS(971),
    [anon_sym_PERCENT] = ACTIONS(971),
    [anon_sym_AMP] = ACTIONS(977),
    [anon_sym_SQUOTE] = ACTIONS(971),
    [anon_sym_STAR] = ACTIONS(971),
    [anon_sym_PLUS] = ACTIONS(971),
    [anon_sym_COMMA] = ACTIONS(971),
    [anon_sym_DASH] = ACTIONS(971),
    [anon_sym_DOT] = ACTIONS(971),
    [anon_sym_SLASH] = ACTIONS(971),
    [anon_sym_COLON] = ACTIONS(971),
    [anon_sym_SEMI] = ACTIONS(971),
    [anon_sym_EQ] = ACTIONS(971),
    [anon_sym_QMARK] = ACTIONS(971),
    [anon_sym_AT] = ACTIONS(971),
    [anon_sym_BSLASH] = ACTIONS(980),
    [anon_sym_CARET] = ACTIONS(971),
    [anon_sym__] = ACTIONS(971),
    [anon_sym_BQUOTE] = ACTIONS(971),
    [anon_sym_LBRACE] = ACTIONS(971),
    [anon_sym_PIPE] = ACTIONS(971),
    [anon_sym_RBRACE] = ACTIONS(971),
    [anon_sym_TILDE] = ACTIONS(971),
    [anon_sym_LPAREN] = ACTIONS(971),
    [anon_sym_RPAREN] = ACTIONS(971),
    [sym__newline_token] = ACTIONS(983),
    [sym_uri_autolink] = ACTIONS(959),
    [sym_email_autolink] = ACTIONS(959),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(986),
    [anon_sym_LT_QMARK] = ACTIONS(989),
    [aux_sym__declaration_token1] = ACTIONS(992),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(995),
    [sym__whitespace_ge_2] = ACTIONS(998),
    [aux_sym__whitespace_token1] = ACTIONS(1001),
    [sym__word_no_digit] = ACTIONS(959),
    [sym__digits] = ACTIONS(959),
    [sym__code_span_start] = ACTIONS(1004),
    [sym__emphasis_open_star] = ACTIONS(1007),
    [sym__emphasis_open_underscore] = ACTIONS(1010),
    [sym__emphasis_close_star] = ACTIONS(1013),
    [sym__strikethrough_open] = ACTIONS(1015),
    [sym__latex_span_start] = ACTIONS(1018),
    [sym__unclosed_span] = ACTIONS(959),
  },
  [44] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(26),
    [sym_full_reference_link] = STATE(26),
    [sym_collapsed_reference_link] = STATE(26),
    [sym_inline_link] = STATE(26),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(26),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(26),
    [aux_sym__inline_no_tilde] = STATE(26),
    [sym__strikethrough] = STATE(26),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(26),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(26),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__last_token_punctuation] = ACTIONS(1021),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [45] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__emphasis_close_star] = ACTIONS(1023),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [46] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(20),
    [sym_full_reference_link] = STATE(20),
    [sym_collapsed_reference_link] = STATE(20),
    [sym_inline_link] = STATE(20),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(20),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(20),
    [aux_sym__inline_no_underscore] = STATE(20),
    [sym__strikethrough] = STATE(20),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(20),
    [sym__emphasis_underscore] = STATE(312),
    [sym__strong_emphasis_underscore] = STATE(20),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__last_token_punctuation] = ACTIONS(1025),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [47] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(1027),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [48] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(48),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [ts_builtin_sym_end] = ACTIONS(1029),
    [sym__backslash_escape] = ACTIONS(1031),
    [sym_entity_reference] = ACTIONS(1034),
    [sym_numeric_character_reference] = ACTIONS(1034),
    [anon_sym_LBRACK] = ACTIONS(1037),
    [anon_sym_RBRACK] = ACTIONS(1040),
    [anon_sym_LT] = ACTIONS(1043),
    [anon_sym_GT] = ACTIONS(1046),
    [anon_sym_BANG] = ACTIONS(1049),
    [anon_sym_DQUOTE] = ACTIONS(1046),
    [anon_sym_POUND] = ACTIONS(1046),
    [anon_sym_DOLLAR] = ACTIONS(1046),
    [anon_sym_PERCENT] = ACTIONS(1046),
    [anon_sym_AMP] = ACTIONS(1052),
    [anon_sym_SQUOTE] = ACTIONS(1046),
    [anon_sym_STAR] = ACTIONS(1046),
    [anon_sym_PLUS] = ACTIONS(1046),
    [anon_sym_COMMA] = ACTIONS(1046),
    [anon_sym_DASH] = ACTIONS(1046),
    [anon_sym_DOT] = ACTIONS(1046),
    [anon_sym_SLASH] = ACTIONS(1046),
    [anon_sym_COLON] = ACTIONS(1046),
    [anon_sym_SEMI] = ACTIONS(1046),
    [anon_sym_EQ] = ACTIONS(1046),
    [anon_sym_QMARK] = ACTIONS(1046),
    [anon_sym_AT] = ACTIONS(1046),
    [anon_sym_BSLASH] = ACTIONS(1055),
    [anon_sym_CARET] = ACTIONS(1046),
    [anon_sym__] = ACTIONS(1046),
    [anon_sym_BQUOTE] = ACTIONS(1046),
    [anon_sym_LBRACE] = ACTIONS(1046),
    [anon_sym_PIPE] = ACTIONS(1046),
    [anon_sym_RBRACE] = ACTIONS(1046),
    [anon_sym_TILDE] = ACTIONS(1046),
    [anon_sym_LPAREN] = ACTIONS(1046),
    [anon_sym_RPAREN] = ACTIONS(1046),
    [sym__newline_token] = ACTIONS(1058),
    [sym_uri_autolink] = ACTIONS(1034),
    [sym_email_autolink] = ACTIONS(1034),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1061),
    [anon_sym_LT_QMARK] = ACTIONS(1064),
    [aux_sym__declaration_token1] = ACTIONS(1067),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1070),
    [sym__whitespace_ge_2] = ACTIONS(1073),
    [aux_sym__whitespace_token1] = ACTIONS(1076),
    [sym__word_no_digit] = ACTIONS(1034),
    [sym__digits] = ACTIONS(1034),
    [sym__code_span_start] = ACTIONS(1079),
    [sym__emphasis_open_star] = ACTIONS(1082),
    [sym__emphasis_open_underscore] = ACTIONS(1085),
    [sym__strikethrough_open] = ACTIONS(1088),
    [sym__latex_span_start] = ACTIONS(1091),
    [sym__unclosed_span] = ACTIONS(1034),
  },
  [49] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(1094),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [50] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(14),
    [aux_sym__inline_no_tilde] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__strikethrough_close] = ACTIONS(1096),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [51] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(23),
    [aux_sym__inline_no_underscore] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__emphasis_close_underscore] = ACTIONS(1098),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [52] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(48),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [ts_builtin_sym_end] = ACTIONS(1100),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [53] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [54] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(37),
    [sym_full_reference_link] = STATE(37),
    [sym_collapsed_reference_link] = STATE(37),
    [sym_inline_link] = STATE(37),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(37),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(37),
    [aux_sym__inline_no_star] = STATE(37),
    [sym__strikethrough] = STATE(37),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(37),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(37),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [55] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(32),
    [sym_full_reference_link] = STATE(32),
    [sym_collapsed_reference_link] = STATE(32),
    [sym_inline_link] = STATE(32),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(32),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(32),
    [aux_sym__inline_no_underscore] = STATE(32),
    [sym__strikethrough] = STATE(32),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(32),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(32),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [56] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(265),
    [sym_shortcut_link] = STATE(275),
    [sym_full_reference_link] = STATE(275),
    [sym_collapsed_reference_link] = STATE(275),
    [sym_inline_link] = STATE(275),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__inline_base] = STATE(275),
    [sym__text_base] = STATE(155),
    [sym__inline_element] = STATE(275),
    [aux_sym__inline] = STATE(52),
    [sym__strikethrough] = STATE(275),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(275),
    [sym__emphasis_underscore] = STATE(280),
    [sym__strong_emphasis_underscore] = STATE(275),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [57] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(39),
    [sym_full_reference_link] = STATE(39),
    [sym_collapsed_reference_link] = STATE(39),
    [sym_inline_link] = STATE(39),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(39),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(39),
    [aux_sym__inline_no_tilde] = STATE(39),
    [sym__strikethrough] = STATE(39),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(39),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(39),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [58] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(22),
    [sym_full_reference_link] = STATE(22),
    [sym_collapsed_reference_link] = STATE(22),
    [sym_inline_link] = STATE(22),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(22),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(22),
    [aux_sym__inline_no_underscore] = STATE(22),
    [sym__strikethrough] = STATE(22),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(22),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(22),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [59] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1144),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [60] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1146),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [61] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1148),
    [sym_entity_reference] = ACTIONS(1151),
    [sym_numeric_character_reference] = ACTIONS(1151),
    [anon_sym_LBRACK] = ACTIONS(1154),
    [anon_sym_RBRACK] = ACTIONS(1157),
    [anon_sym_LT] = ACTIONS(1160),
    [anon_sym_GT] = ACTIONS(1163),
    [anon_sym_BANG] = ACTIONS(1166),
    [anon_sym_DQUOTE] = ACTIONS(1163),
    [anon_sym_POUND] = ACTIONS(1163),
    [anon_sym_DOLLAR] = ACTIONS(1163),
    [anon_sym_PERCENT] = ACTIONS(1163),
    [anon_sym_AMP] = ACTIONS(1169),
    [anon_sym_SQUOTE] = ACTIONS(1163),
    [anon_sym_STAR] = ACTIONS(1163),
    [anon_sym_PLUS] = ACTIONS(1163),
    [anon_sym_COMMA] = ACTIONS(1163),
    [anon_sym_DASH] = ACTIONS(1163),
    [anon_sym_DOT] = ACTIONS(1163),
    [anon_sym_SLASH] = ACTIONS(1163),
    [anon_sym_COLON] = ACTIONS(1163),
    [anon_sym_SEMI] = ACTIONS(1163),
    [anon_sym_EQ] = ACTIONS(1163),
    [anon_sym_QMARK] = ACTIONS(1163),
    [anon_sym_AT] = ACTIONS(1163),
    [anon_sym_BSLASH] = ACTIONS(1172),
    [anon_sym_CARET] = ACTIONS(1163),
    [anon_sym__] = ACTIONS(1163),
    [anon_sym_BQUOTE] = ACTIONS(1163),
    [anon_sym_LBRACE] = ACTIONS(1163),
    [anon_sym_PIPE] = ACTIONS(1163),
    [anon_sym_RBRACE] = ACTIONS(1163),
    [anon_sym_TILDE] = ACTIONS(1163),
    [anon_sym_LPAREN] = ACTIONS(1163),
    [anon_sym_RPAREN] = ACTIONS(1163),
    [sym__newline_token] = ACTIONS(1175),
    [sym_uri_autolink] = ACTIONS(1151),
    [sym_email_autolink] = ACTIONS(1151),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1178),
    [anon_sym_LT_QMARK] = ACTIONS(1181),
    [aux_sym__declaration_token1] = ACTIONS(1184),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1187),
    [sym__whitespace_ge_2] = ACTIONS(1190),
    [aux_sym__whitespace_token1] = ACTIONS(1193),
    [sym__word_no_digit] = ACTIONS(1151),
    [sym__digits] = ACTIONS(1151),
    [sym__code_span_start] = ACTIONS(1196),
    [sym__emphasis_open_star] = ACTIONS(1199),
    [sym__emphasis_open_underscore] = ACTIONS(1202),
    [sym__strikethrough_open] = ACTIONS(1205),
    [sym__latex_span_start] = ACTIONS(1208),
    [sym__unclosed_span] = ACTIONS(1151),
  },
  [62] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1211),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [63] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(13),
    [sym_full_reference_link] = STATE(13),
    [sym_collapsed_reference_link] = STATE(13),
    [sym_inline_link] = STATE(13),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(13),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(13),
    [aux_sym__inline_no_tilde] = STATE(13),
    [sym__strikethrough] = STATE(13),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(13),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(13),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [64] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(15),
    [aux_sym__inline_no_star] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [65] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(85),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [66] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1215),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [67] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(40),
    [sym_full_reference_link] = STATE(40),
    [sym_collapsed_reference_link] = STATE(40),
    [sym_inline_link] = STATE(40),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(40),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(40),
    [aux_sym__inline_no_star] = STATE(40),
    [sym__strikethrough] = STATE(40),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(40),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(40),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [68] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(51),
    [sym_full_reference_link] = STATE(51),
    [sym_collapsed_reference_link] = STATE(51),
    [sym_inline_link] = STATE(51),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(51),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(51),
    [aux_sym__inline_no_underscore] = STATE(51),
    [sym__strikethrough] = STATE(51),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(51),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(51),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [69] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(62),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [70] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(50),
    [sym_full_reference_link] = STATE(50),
    [sym_collapsed_reference_link] = STATE(50),
    [sym_inline_link] = STATE(50),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(50),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(50),
    [aux_sym__inline_no_tilde] = STATE(50),
    [sym__strikethrough] = STATE(50),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(50),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(50),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [71] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(53),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [72] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(18),
    [sym_full_reference_link] = STATE(18),
    [sym_collapsed_reference_link] = STATE(18),
    [sym_inline_link] = STATE(18),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(18),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(18),
    [aux_sym__inline_no_star] = STATE(18),
    [sym__strikethrough] = STATE(18),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(18),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(18),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [73] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(17),
    [sym_full_reference_link] = STATE(17),
    [sym_collapsed_reference_link] = STATE(17),
    [sym_inline_link] = STATE(17),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(17),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(17),
    [aux_sym__inline_no_underscore] = STATE(17),
    [sym__strikethrough] = STATE(17),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(17),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(17),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [74] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(35),
    [sym_full_reference_link] = STATE(35),
    [sym_collapsed_reference_link] = STATE(35),
    [sym_inline_link] = STATE(35),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(35),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(35),
    [aux_sym__inline_no_tilde] = STATE(35),
    [sym__strikethrough] = STATE(35),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(35),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(35),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [75] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1115),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(34),
    [sym_full_reference_link] = STATE(34),
    [sym_collapsed_reference_link] = STATE(34),
    [sym_inline_link] = STATE(34),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(34),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(34),
    [aux_sym__inline_no_underscore] = STATE(34),
    [sym__strikethrough] = STATE(34),
    [sym__emphasis_star] = STATE(290),
    [sym__strong_emphasis_star] = STATE(34),
    [sym__emphasis_underscore] = STATE(290),
    [sym__strong_emphasis_underscore] = STATE(34),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(686),
    [sym_numeric_character_reference] = ACTIONS(686),
    [anon_sym_LBRACK] = ACTIONS(688),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(686),
    [sym_email_autolink] = ACTIONS(686),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(686),
    [sym__digits] = ACTIONS(686),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(718),
    [sym__emphasis_open_underscore] = ACTIONS(720),
    [sym__strikethrough_open] = ACTIONS(724),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(686),
  },
  [76] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(345),
    [sym_shortcut_link] = STATE(33),
    [sym_full_reference_link] = STATE(33),
    [sym_collapsed_reference_link] = STATE(33),
    [sym_inline_link] = STATE(33),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(33),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(33),
    [aux_sym__inline_no_star] = STATE(33),
    [sym__strikethrough] = STATE(33),
    [sym__emphasis_star] = STATE(284),
    [sym__strong_emphasis_star] = STATE(33),
    [sym__emphasis_underscore] = STATE(284),
    [sym__strong_emphasis_underscore] = STATE(33),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [77] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [78] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(502),
    [sym_shortcut_link] = STATE(16),
    [sym_full_reference_link] = STATE(16),
    [sym_collapsed_reference_link] = STATE(16),
    [sym_inline_link] = STATE(16),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(16),
    [sym__text_base] = STATE(154),
    [sym__inline_element_no_tilde] = STATE(16),
    [aux_sym__inline_no_tilde] = STATE(16),
    [sym__strikethrough] = STATE(16),
    [sym__emphasis_star] = STATE(292),
    [sym__strong_emphasis_star] = STATE(16),
    [sym__emphasis_underscore] = STATE(292),
    [sym__strong_emphasis_underscore] = STATE(16),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(730),
    [sym_numeric_character_reference] = ACTIONS(730),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(730),
    [sym_email_autolink] = ACTIONS(730),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(730),
    [sym__digits] = ACTIONS(730),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(762),
    [sym__emphasis_open_underscore] = ACTIONS(764),
    [sym__strikethrough_open] = ACTIONS(766),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(730),
  },
  [79] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1217),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [80] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(59),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [81] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1219),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [82] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(81),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [83] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(60),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [84] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(66),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1213),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [85] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym__link_text] = STATE(1122),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(585),
    [sym_full_reference_link] = STATE(585),
    [sym_collapsed_reference_link] = STATE(585),
    [sym_inline_link] = STATE(585),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__inline_base] = STATE(585),
    [sym__text_base] = STATE(157),
    [sym__inline_element] = STATE(585),
    [aux_sym__inline] = STATE(61),
    [sym__strikethrough] = STATE(585),
    [sym__emphasis_star] = STATE(589),
    [sym__strong_emphasis_star] = STATE(585),
    [sym__emphasis_underscore] = STATE(589),
    [sym__strong_emphasis_underscore] = STATE(585),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1221),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [86] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(114),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1223),
    [sym_entity_reference] = ACTIONS(1226),
    [sym_numeric_character_reference] = ACTIONS(1226),
    [anon_sym_LBRACK] = ACTIONS(500),
    [anon_sym_RBRACK] = ACTIONS(1229),
    [anon_sym_LT] = ACTIONS(1232),
    [anon_sym_GT] = ACTIONS(1235),
    [anon_sym_BANG] = ACTIONS(1238),
    [anon_sym_DQUOTE] = ACTIONS(1235),
    [anon_sym_POUND] = ACTIONS(1235),
    [anon_sym_DOLLAR] = ACTIONS(1235),
    [anon_sym_PERCENT] = ACTIONS(1235),
    [anon_sym_AMP] = ACTIONS(1241),
    [anon_sym_SQUOTE] = ACTIONS(1235),
    [anon_sym_STAR] = ACTIONS(1235),
    [anon_sym_PLUS] = ACTIONS(1235),
    [anon_sym_COMMA] = ACTIONS(1235),
    [anon_sym_DASH] = ACTIONS(1235),
    [anon_sym_DOT] = ACTIONS(1235),
    [anon_sym_SLASH] = ACTIONS(1235),
    [anon_sym_COLON] = ACTIONS(1235),
    [anon_sym_SEMI] = ACTIONS(1235),
    [anon_sym_EQ] = ACTIONS(1235),
    [anon_sym_QMARK] = ACTIONS(1235),
    [anon_sym_AT] = ACTIONS(1235),
    [anon_sym_BSLASH] = ACTIONS(1244),
    [anon_sym_CARET] = ACTIONS(1235),
    [anon_sym__] = ACTIONS(1235),
    [anon_sym_BQUOTE] = ACTIONS(1235),
    [anon_sym_LBRACE] = ACTIONS(1235),
    [anon_sym_PIPE] = ACTIONS(1235),
    [anon_sym_RBRACE] = ACTIONS(1235),
    [anon_sym_TILDE] = ACTIONS(1235),
    [anon_sym_LPAREN] = ACTIONS(1235),
    [anon_sym_RPAREN] = ACTIONS(1235),
    [sym__newline_token] = ACTIONS(1247),
    [sym_uri_autolink] = ACTIONS(1226),
    [sym_email_autolink] = ACTIONS(1226),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1250),
    [anon_sym_LT_QMARK] = ACTIONS(1253),
    [aux_sym__declaration_token1] = ACTIONS(1256),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1259),
    [sym__whitespace_ge_2] = ACTIONS(1262),
    [aux_sym__whitespace_token1] = ACTIONS(1265),
    [sym__word_no_digit] = ACTIONS(1226),
    [sym__digits] = ACTIONS(1226),
    [sym__code_span_start] = ACTIONS(1268),
    [sym__emphasis_open_star] = ACTIONS(1271),
    [sym__emphasis_open_underscore] = ACTIONS(1274),
    [sym__emphasis_close_star] = ACTIONS(500),
    [sym__last_token_punctuation] = ACTIONS(1277),
    [sym__strikethrough_open] = ACTIONS(1279),
    [sym__latex_span_start] = ACTIONS(1282),
    [sym__unclosed_span] = ACTIONS(1226),
  },
  [87] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(131),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1285),
    [sym_entity_reference] = ACTIONS(1288),
    [sym_numeric_character_reference] = ACTIONS(1288),
    [anon_sym_LBRACK] = ACTIONS(308),
    [anon_sym_RBRACK] = ACTIONS(1291),
    [anon_sym_LT] = ACTIONS(1294),
    [anon_sym_GT] = ACTIONS(1297),
    [anon_sym_BANG] = ACTIONS(1300),
    [anon_sym_DQUOTE] = ACTIONS(1297),
    [anon_sym_POUND] = ACTIONS(1297),
    [anon_sym_DOLLAR] = ACTIONS(1297),
    [anon_sym_PERCENT] = ACTIONS(1297),
    [anon_sym_AMP] = ACTIONS(1303),
    [anon_sym_SQUOTE] = ACTIONS(1297),
    [anon_sym_STAR] = ACTIONS(1297),
    [anon_sym_PLUS] = ACTIONS(1297),
    [anon_sym_COMMA] = ACTIONS(1297),
    [anon_sym_DASH] = ACTIONS(1297),
    [anon_sym_DOT] = ACTIONS(1297),
    [anon_sym_SLASH] = ACTIONS(1297),
    [anon_sym_COLON] = ACTIONS(1297),
    [anon_sym_SEMI] = ACTIONS(1297),
    [anon_sym_EQ] = ACTIONS(1297),
    [anon_sym_QMARK] = ACTIONS(1297),
    [anon_sym_AT] = ACTIONS(1297),
    [anon_sym_BSLASH] = ACTIONS(1306),
    [anon_sym_CARET] = ACTIONS(1297),
    [anon_sym__] = ACTIONS(1297),
    [anon_sym_BQUOTE] = ACTIONS(1297),
    [anon_sym_LBRACE] = ACTIONS(1297),
    [anon_sym_PIPE] = ACTIONS(1297),
    [anon_sym_RBRACE] = ACTIONS(1297),
    [anon_sym_TILDE] = ACTIONS(1297),
    [anon_sym_LPAREN] = ACTIONS(1297),
    [anon_sym_RPAREN] = ACTIONS(1297),
    [sym__newline_token] = ACTIONS(1309),
    [sym_uri_autolink] = ACTIONS(1288),
    [sym_email_autolink] = ACTIONS(1288),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1312),
    [anon_sym_LT_QMARK] = ACTIONS(1315),
    [aux_sym__declaration_token1] = ACTIONS(1318),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1321),
    [sym__whitespace_ge_2] = ACTIONS(1324),
    [aux_sym__whitespace_token1] = ACTIONS(1327),
    [sym__word_no_digit] = ACTIONS(1288),
    [sym__digits] = ACTIONS(1288),
    [sym__code_span_start] = ACTIONS(1330),
    [sym__emphasis_open_star] = ACTIONS(1333),
    [sym__emphasis_open_underscore] = ACTIONS(1336),
    [sym__last_token_punctuation] = ACTIONS(1339),
    [sym__strikethrough_open] = ACTIONS(1341),
    [sym__strikethrough_close] = ACTIONS(308),
    [sym__latex_span_start] = ACTIONS(1344),
    [sym__unclosed_span] = ACTIONS(1288),
  },
  [88] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(132),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1347),
    [sym_entity_reference] = ACTIONS(1350),
    [sym_numeric_character_reference] = ACTIONS(1350),
    [anon_sym_LBRACK] = ACTIONS(104),
    [anon_sym_RBRACK] = ACTIONS(1353),
    [anon_sym_LT] = ACTIONS(1356),
    [anon_sym_GT] = ACTIONS(1359),
    [anon_sym_BANG] = ACTIONS(1362),
    [anon_sym_DQUOTE] = ACTIONS(1359),
    [anon_sym_POUND] = ACTIONS(1359),
    [anon_sym_DOLLAR] = ACTIONS(1359),
    [anon_sym_PERCENT] = ACTIONS(1359),
    [anon_sym_AMP] = ACTIONS(1365),
    [anon_sym_SQUOTE] = ACTIONS(1359),
    [anon_sym_STAR] = ACTIONS(1359),
    [anon_sym_PLUS] = ACTIONS(1359),
    [anon_sym_COMMA] = ACTIONS(1359),
    [anon_sym_DASH] = ACTIONS(1359),
    [anon_sym_DOT] = ACTIONS(1359),
    [anon_sym_SLASH] = ACTIONS(1359),
    [anon_sym_COLON] = ACTIONS(1359),
    [anon_sym_SEMI] = ACTIONS(1359),
    [anon_sym_EQ] = ACTIONS(1359),
    [anon_sym_QMARK] = ACTIONS(1359),
    [anon_sym_AT] = ACTIONS(1359),
    [anon_sym_BSLASH] = ACTIONS(1368),
    [anon_sym_CARET] = ACTIONS(1359),
    [anon_sym__] = ACTIONS(1359),
    [anon_sym_BQUOTE] = ACTIONS(1359),
    [anon_sym_LBRACE] = ACTIONS(1359),
    [anon_sym_PIPE] = ACTIONS(1359),
    [anon_sym_RBRACE] = ACTIONS(1359),
    [anon_sym_TILDE] = ACTIONS(1359),
    [anon_sym_LPAREN] = ACTIONS(1359),
    [anon_sym_RPAREN] = ACTIONS(1359),
    [sym__newline_token] = ACTIONS(1371),
    [sym_uri_autolink] = ACTIONS(1350),
    [sym_email_autolink] = ACTIONS(1350),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1374),
    [anon_sym_LT_QMARK] = ACTIONS(1377),
    [aux_sym__declaration_token1] = ACTIONS(1380),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1383),
    [sym__whitespace_ge_2] = ACTIONS(1386),
    [aux_sym__whitespace_token1] = ACTIONS(1389),
    [sym__word_no_digit] = ACTIONS(1350),
    [sym__digits] = ACTIONS(1350),
    [sym__code_span_start] = ACTIONS(1392),
    [sym__emphasis_open_star] = ACTIONS(1395),
    [sym__emphasis_open_underscore] = ACTIONS(1398),
    [sym__emphasis_close_underscore] = ACTIONS(104),
    [sym__last_token_punctuation] = ACTIONS(1401),
    [sym__strikethrough_open] = ACTIONS(1403),
    [sym__latex_span_start] = ACTIONS(1406),
    [sym__unclosed_span] = ACTIONS(1350),
  },
  [89] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(1409),
    [sym_entity_reference] = ACTIONS(1412),
    [sym_numeric_character_reference] = ACTIONS(1412),
    [anon_sym_LBRACK] = ACTIONS(114),
    [anon_sym_RBRACK] = ACTIONS(1415),
    [anon_sym_LT] = ACTIONS(1418),
    [anon_sym_GT] = ACTIONS(1421),
    [anon_sym_BANG] = ACTIONS(1424),
    [anon_sym_DQUOTE] = ACTIONS(1421),
    [anon_sym_POUND] = ACTIONS(1421),
    [anon_sym_DOLLAR] = ACTIONS(1421),
    [anon_sym_PERCENT] = ACTIONS(1421),
    [anon_sym_AMP] = ACTIONS(1427),
    [anon_sym_SQUOTE] = ACTIONS(1421),
    [anon_sym_STAR] = ACTIONS(1421),
    [anon_sym_PLUS] = ACTIONS(1421),
    [anon_sym_COMMA] = ACTIONS(1421),
    [anon_sym_DASH] = ACTIONS(1421),
    [anon_sym_DOT] = ACTIONS(1421),
    [anon_sym_SLASH] = ACTIONS(1421),
    [anon_sym_COLON] = ACTIONS(1421),
    [anon_sym_SEMI] = ACTIONS(1421),
    [anon_sym_EQ] = ACTIONS(1421),
    [anon_sym_QMARK] = ACTIONS(1421),
    [anon_sym_AT] = ACTIONS(1421),
    [anon_sym_BSLASH] = ACTIONS(1430),
    [anon_sym_CARET] = ACTIONS(1421),
    [anon_sym__] = ACTIONS(1421),
    [anon_sym_BQUOTE] = ACTIONS(1421),
    [anon_sym_LBRACE] = ACTIONS(1421),
    [anon_sym_PIPE] = ACTIONS(1421),
    [anon_sym_RBRACE] = ACTIONS(1421),
    [anon_sym_TILDE] = ACTIONS(1421),
    [anon_sym_LPAREN] = ACTIONS(1421),
    [anon_sym_RPAREN] = ACTIONS(1421),
    [sym__newline_token] = ACTIONS(1433),
    [sym_uri_autolink] = ACTIONS(1412),
    [sym_email_autolink] = ACTIONS(1412),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1436),
    [anon_sym_LT_QMARK] = ACTIONS(1439),
    [aux_sym__declaration_token1] = ACTIONS(1442),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1445),
    [sym__whitespace_ge_2] = ACTIONS(1448),
    [aux_sym__whitespace_token1] = ACTIONS(1451),
    [sym__word_no_digit] = ACTIONS(1412),
    [sym__digits] = ACTIONS(1412),
    [sym__code_span_start] = ACTIONS(1454),
    [sym__emphasis_open_star] = ACTIONS(1457),
    [sym__emphasis_open_underscore] = ACTIONS(1460),
    [sym__last_token_punctuation] = ACTIONS(1463),
    [sym__strikethrough_open] = ACTIONS(1465),
    [sym__latex_span_start] = ACTIONS(1468),
    [sym__unclosed_span] = ACTIONS(1412),
  },
  [90] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(100),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1409),
    [sym_entity_reference] = ACTIONS(1412),
    [sym_numeric_character_reference] = ACTIONS(1412),
    [anon_sym_LBRACK] = ACTIONS(114),
    [anon_sym_RBRACK] = ACTIONS(1415),
    [anon_sym_LT] = ACTIONS(1418),
    [anon_sym_GT] = ACTIONS(1421),
    [anon_sym_BANG] = ACTIONS(1424),
    [anon_sym_DQUOTE] = ACTIONS(1421),
    [anon_sym_POUND] = ACTIONS(1421),
    [anon_sym_DOLLAR] = ACTIONS(1421),
    [anon_sym_PERCENT] = ACTIONS(1421),
    [anon_sym_AMP] = ACTIONS(1427),
    [anon_sym_SQUOTE] = ACTIONS(1421),
    [anon_sym_STAR] = ACTIONS(1421),
    [anon_sym_PLUS] = ACTIONS(1421),
    [anon_sym_COMMA] = ACTIONS(1421),
    [anon_sym_DASH] = ACTIONS(1421),
    [anon_sym_DOT] = ACTIONS(1421),
    [anon_sym_SLASH] = ACTIONS(1421),
    [anon_sym_COLON] = ACTIONS(1421),
    [anon_sym_SEMI] = ACTIONS(1421),
    [anon_sym_EQ] = ACTIONS(1421),
    [anon_sym_QMARK] = ACTIONS(1421),
    [anon_sym_AT] = ACTIONS(1421),
    [anon_sym_BSLASH] = ACTIONS(1430),
    [anon_sym_CARET] = ACTIONS(1421),
    [anon_sym__] = ACTIONS(1421),
    [anon_sym_BQUOTE] = ACTIONS(1421),
    [anon_sym_LBRACE] = ACTIONS(1421),
    [anon_sym_PIPE] = ACTIONS(1421),
    [anon_sym_RBRACE] = ACTIONS(1421),
    [anon_sym_TILDE] = ACTIONS(1421),
    [anon_sym_LPAREN] = ACTIONS(1421),
    [anon_sym_RPAREN] = ACTIONS(1421),
    [sym__newline_token] = ACTIONS(1433),
    [sym_uri_autolink] = ACTIONS(1412),
    [sym_email_autolink] = ACTIONS(1412),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1436),
    [anon_sym_LT_QMARK] = ACTIONS(1439),
    [aux_sym__declaration_token1] = ACTIONS(1442),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1445),
    [sym__whitespace_ge_2] = ACTIONS(1448),
    [aux_sym__whitespace_token1] = ACTIONS(1451),
    [sym__word_no_digit] = ACTIONS(1412),
    [sym__digits] = ACTIONS(1412),
    [sym__code_span_start] = ACTIONS(1454),
    [sym__emphasis_open_star] = ACTIONS(1457),
    [sym__emphasis_open_underscore] = ACTIONS(1460),
    [sym__last_token_punctuation] = ACTIONS(1471),
    [sym__strikethrough_open] = ACTIONS(1465),
    [sym__latex_span_start] = ACTIONS(1468),
    [sym__unclosed_span] = ACTIONS(1412),
  },
  [91] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(116),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(116),
    [aux_sym__inline_no_underscore_no_link] = STATE(116),
    [sym__strikethrough_no_link] = STATE(116),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(116),
    [sym__emphasis_underscore_no_link] = STATE(618),
    [sym__strong_emphasis_underscore_no_link] = STATE(116),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(1473),
    [sym_entity_reference] = ACTIONS(1476),
    [sym_numeric_character_reference] = ACTIONS(1476),
    [anon_sym_LT] = ACTIONS(1479),
    [anon_sym_GT] = ACTIONS(1482),
    [anon_sym_BANG] = ACTIONS(1485),
    [anon_sym_DQUOTE] = ACTIONS(1482),
    [anon_sym_POUND] = ACTIONS(1482),
    [anon_sym_DOLLAR] = ACTIONS(1482),
    [anon_sym_PERCENT] = ACTIONS(1482),
    [anon_sym_AMP] = ACTIONS(1488),
    [anon_sym_SQUOTE] = ACTIONS(1482),
    [anon_sym_STAR] = ACTIONS(1482),
    [anon_sym_PLUS] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1482),
    [anon_sym_DASH] = ACTIONS(1482),
    [anon_sym_DOT] = ACTIONS(1482),
    [anon_sym_SLASH] = ACTIONS(1482),
    [anon_sym_COLON] = ACTIONS(1482),
    [anon_sym_SEMI] = ACTIONS(1482),
    [anon_sym_EQ] = ACTIONS(1482),
    [anon_sym_QMARK] = ACTIONS(1482),
    [anon_sym_AT] = ACTIONS(1482),
    [anon_sym_BSLASH] = ACTIONS(1491),
    [anon_sym_CARET] = ACTIONS(1482),
    [anon_sym__] = ACTIONS(1482),
    [anon_sym_BQUOTE] = ACTIONS(1482),
    [anon_sym_LBRACE] = ACTIONS(1482),
    [anon_sym_PIPE] = ACTIONS(1482),
    [anon_sym_RBRACE] = ACTIONS(1482),
    [anon_sym_TILDE] = ACTIONS(1482),
    [anon_sym_LPAREN] = ACTIONS(1482),
    [anon_sym_RPAREN] = ACTIONS(1482),
    [sym__newline_token] = ACTIONS(1494),
    [sym_uri_autolink] = ACTIONS(1476),
    [sym_email_autolink] = ACTIONS(1476),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1497),
    [anon_sym_LT_QMARK] = ACTIONS(1500),
    [aux_sym__declaration_token1] = ACTIONS(1503),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1506),
    [sym__whitespace_ge_2] = ACTIONS(1509),
    [aux_sym__whitespace_token1] = ACTIONS(1512),
    [sym__word_no_digit] = ACTIONS(1476),
    [sym__digits] = ACTIONS(1476),
    [sym__code_span_start] = ACTIONS(1515),
    [sym__emphasis_open_star] = ACTIONS(1518),
    [sym__emphasis_open_underscore] = ACTIONS(1521),
    [sym__last_token_punctuation] = ACTIONS(1524),
    [sym__strikethrough_open] = ACTIONS(1526),
    [sym__strikethrough_close] = ACTIONS(1529),
    [sym__latex_span_start] = ACTIONS(1531),
    [sym__unclosed_span] = ACTIONS(1476),
  },
  [92] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(119),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(119),
    [aux_sym__inline_no_star_no_link] = STATE(119),
    [sym__strikethrough_no_link] = STATE(119),
    [sym__emphasis_star_no_link] = STATE(614),
    [sym__strong_emphasis_star_no_link] = STATE(119),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(119),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1534),
    [sym_entity_reference] = ACTIONS(1537),
    [sym_numeric_character_reference] = ACTIONS(1537),
    [anon_sym_LT] = ACTIONS(1540),
    [anon_sym_GT] = ACTIONS(1543),
    [anon_sym_BANG] = ACTIONS(1546),
    [anon_sym_DQUOTE] = ACTIONS(1543),
    [anon_sym_POUND] = ACTIONS(1543),
    [anon_sym_DOLLAR] = ACTIONS(1543),
    [anon_sym_PERCENT] = ACTIONS(1543),
    [anon_sym_AMP] = ACTIONS(1549),
    [anon_sym_SQUOTE] = ACTIONS(1543),
    [anon_sym_STAR] = ACTIONS(1543),
    [anon_sym_PLUS] = ACTIONS(1543),
    [anon_sym_COMMA] = ACTIONS(1543),
    [anon_sym_DASH] = ACTIONS(1543),
    [anon_sym_DOT] = ACTIONS(1543),
    [anon_sym_SLASH] = ACTIONS(1543),
    [anon_sym_COLON] = ACTIONS(1543),
    [anon_sym_SEMI] = ACTIONS(1543),
    [anon_sym_EQ] = ACTIONS(1543),
    [anon_sym_QMARK] = ACTIONS(1543),
    [anon_sym_AT] = ACTIONS(1543),
    [anon_sym_BSLASH] = ACTIONS(1552),
    [anon_sym_CARET] = ACTIONS(1543),
    [anon_sym__] = ACTIONS(1543),
    [anon_sym_BQUOTE] = ACTIONS(1543),
    [anon_sym_LBRACE] = ACTIONS(1543),
    [anon_sym_PIPE] = ACTIONS(1543),
    [anon_sym_RBRACE] = ACTIONS(1543),
    [anon_sym_TILDE] = ACTIONS(1543),
    [anon_sym_LPAREN] = ACTIONS(1543),
    [anon_sym_RPAREN] = ACTIONS(1543),
    [sym__newline_token] = ACTIONS(1555),
    [sym_uri_autolink] = ACTIONS(1537),
    [sym_email_autolink] = ACTIONS(1537),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1558),
    [anon_sym_LT_QMARK] = ACTIONS(1561),
    [aux_sym__declaration_token1] = ACTIONS(1564),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1567),
    [sym__whitespace_ge_2] = ACTIONS(1570),
    [aux_sym__whitespace_token1] = ACTIONS(1573),
    [sym__word_no_digit] = ACTIONS(1537),
    [sym__digits] = ACTIONS(1537),
    [sym__code_span_start] = ACTIONS(1576),
    [sym__emphasis_open_star] = ACTIONS(1579),
    [sym__emphasis_open_underscore] = ACTIONS(1582),
    [sym__emphasis_close_underscore] = ACTIONS(1585),
    [sym__last_token_punctuation] = ACTIONS(1587),
    [sym__strikethrough_open] = ACTIONS(1589),
    [sym__latex_span_start] = ACTIONS(1592),
    [sym__unclosed_span] = ACTIONS(1537),
  },
  [93] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(123),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(123),
    [aux_sym__inline_no_star_no_link] = STATE(123),
    [sym__strikethrough_no_link] = STATE(123),
    [sym__emphasis_star_no_link] = STATE(644),
    [sym__strong_emphasis_star_no_link] = STATE(123),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(123),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1595),
    [sym_entity_reference] = ACTIONS(1598),
    [sym_numeric_character_reference] = ACTIONS(1598),
    [anon_sym_RBRACK] = ACTIONS(1601),
    [anon_sym_LT] = ACTIONS(1603),
    [anon_sym_GT] = ACTIONS(1606),
    [anon_sym_BANG] = ACTIONS(1609),
    [anon_sym_DQUOTE] = ACTIONS(1606),
    [anon_sym_POUND] = ACTIONS(1606),
    [anon_sym_DOLLAR] = ACTIONS(1606),
    [anon_sym_PERCENT] = ACTIONS(1606),
    [anon_sym_AMP] = ACTIONS(1612),
    [anon_sym_SQUOTE] = ACTIONS(1606),
    [anon_sym_STAR] = ACTIONS(1606),
    [anon_sym_PLUS] = ACTIONS(1606),
    [anon_sym_COMMA] = ACTIONS(1606),
    [anon_sym_DASH] = ACTIONS(1606),
    [anon_sym_DOT] = ACTIONS(1606),
    [anon_sym_SLASH] = ACTIONS(1606),
    [anon_sym_COLON] = ACTIONS(1606),
    [anon_sym_SEMI] = ACTIONS(1606),
    [anon_sym_EQ] = ACTIONS(1606),
    [anon_sym_QMARK] = ACTIONS(1606),
    [anon_sym_AT] = ACTIONS(1606),
    [anon_sym_BSLASH] = ACTIONS(1615),
    [anon_sym_CARET] = ACTIONS(1606),
    [anon_sym__] = ACTIONS(1606),
    [anon_sym_BQUOTE] = ACTIONS(1606),
    [anon_sym_LBRACE] = ACTIONS(1606),
    [anon_sym_PIPE] = ACTIONS(1606),
    [anon_sym_RBRACE] = ACTIONS(1606),
    [anon_sym_TILDE] = ACTIONS(1606),
    [anon_sym_LPAREN] = ACTIONS(1606),
    [anon_sym_RPAREN] = ACTIONS(1606),
    [sym__newline_token] = ACTIONS(1618),
    [sym_uri_autolink] = ACTIONS(1598),
    [sym_email_autolink] = ACTIONS(1598),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1621),
    [anon_sym_LT_QMARK] = ACTIONS(1624),
    [aux_sym__declaration_token1] = ACTIONS(1627),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1630),
    [sym__whitespace_ge_2] = ACTIONS(1633),
    [aux_sym__whitespace_token1] = ACTIONS(1636),
    [sym__word_no_digit] = ACTIONS(1598),
    [sym__digits] = ACTIONS(1598),
    [sym__code_span_start] = ACTIONS(1639),
    [sym__emphasis_open_star] = ACTIONS(1642),
    [sym__emphasis_open_underscore] = ACTIONS(1645),
    [sym__last_token_punctuation] = ACTIONS(1648),
    [sym__strikethrough_open] = ACTIONS(1650),
    [sym__latex_span_start] = ACTIONS(1653),
    [sym__unclosed_span] = ACTIONS(1598),
  },
  [94] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(128),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(128),
    [aux_sym__inline_no_underscore_no_link] = STATE(128),
    [sym__strikethrough_no_link] = STATE(128),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(128),
    [sym__emphasis_underscore_no_link] = STATE(627),
    [sym__strong_emphasis_underscore_no_link] = STATE(128),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(1656),
    [sym_entity_reference] = ACTIONS(1659),
    [sym_numeric_character_reference] = ACTIONS(1659),
    [anon_sym_RBRACK] = ACTIONS(1601),
    [anon_sym_LT] = ACTIONS(1662),
    [anon_sym_GT] = ACTIONS(1665),
    [anon_sym_BANG] = ACTIONS(1668),
    [anon_sym_DQUOTE] = ACTIONS(1665),
    [anon_sym_POUND] = ACTIONS(1665),
    [anon_sym_DOLLAR] = ACTIONS(1665),
    [anon_sym_PERCENT] = ACTIONS(1665),
    [anon_sym_AMP] = ACTIONS(1671),
    [anon_sym_SQUOTE] = ACTIONS(1665),
    [anon_sym_STAR] = ACTIONS(1665),
    [anon_sym_PLUS] = ACTIONS(1665),
    [anon_sym_COMMA] = ACTIONS(1665),
    [anon_sym_DASH] = ACTIONS(1665),
    [anon_sym_DOT] = ACTIONS(1665),
    [anon_sym_SLASH] = ACTIONS(1665),
    [anon_sym_COLON] = ACTIONS(1665),
    [anon_sym_SEMI] = ACTIONS(1665),
    [anon_sym_EQ] = ACTIONS(1665),
    [anon_sym_QMARK] = ACTIONS(1665),
    [anon_sym_AT] = ACTIONS(1665),
    [anon_sym_BSLASH] = ACTIONS(1674),
    [anon_sym_CARET] = ACTIONS(1665),
    [anon_sym__] = ACTIONS(1665),
    [anon_sym_BQUOTE] = ACTIONS(1665),
    [anon_sym_LBRACE] = ACTIONS(1665),
    [anon_sym_PIPE] = ACTIONS(1665),
    [anon_sym_RBRACE] = ACTIONS(1665),
    [anon_sym_TILDE] = ACTIONS(1665),
    [anon_sym_LPAREN] = ACTIONS(1665),
    [anon_sym_RPAREN] = ACTIONS(1665),
    [sym__newline_token] = ACTIONS(1677),
    [sym_uri_autolink] = ACTIONS(1659),
    [sym_email_autolink] = ACTIONS(1659),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1680),
    [anon_sym_LT_QMARK] = ACTIONS(1683),
    [aux_sym__declaration_token1] = ACTIONS(1686),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1689),
    [sym__whitespace_ge_2] = ACTIONS(1692),
    [aux_sym__whitespace_token1] = ACTIONS(1695),
    [sym__word_no_digit] = ACTIONS(1659),
    [sym__digits] = ACTIONS(1659),
    [sym__code_span_start] = ACTIONS(1698),
    [sym__emphasis_open_star] = ACTIONS(1701),
    [sym__emphasis_open_underscore] = ACTIONS(1704),
    [sym__last_token_punctuation] = ACTIONS(1707),
    [sym__strikethrough_open] = ACTIONS(1709),
    [sym__latex_span_start] = ACTIONS(1712),
    [sym__unclosed_span] = ACTIONS(1659),
  },
  [95] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(101),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(101),
    [aux_sym__inline_no_tilde_no_link] = STATE(101),
    [sym__strikethrough_no_link] = STATE(101),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(101),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(101),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(1715),
    [sym_entity_reference] = ACTIONS(1718),
    [sym_numeric_character_reference] = ACTIONS(1718),
    [anon_sym_RBRACK] = ACTIONS(1601),
    [anon_sym_LT] = ACTIONS(1721),
    [anon_sym_GT] = ACTIONS(1724),
    [anon_sym_BANG] = ACTIONS(1727),
    [anon_sym_DQUOTE] = ACTIONS(1724),
    [anon_sym_POUND] = ACTIONS(1724),
    [anon_sym_DOLLAR] = ACTIONS(1724),
    [anon_sym_PERCENT] = ACTIONS(1724),
    [anon_sym_AMP] = ACTIONS(1730),
    [anon_sym_SQUOTE] = ACTIONS(1724),
    [anon_sym_STAR] = ACTIONS(1724),
    [anon_sym_PLUS] = ACTIONS(1724),
    [anon_sym_COMMA] = ACTIONS(1724),
    [anon_sym_DASH] = ACTIONS(1724),
    [anon_sym_DOT] = ACTIONS(1724),
    [anon_sym_SLASH] = ACTIONS(1724),
    [anon_sym_COLON] = ACTIONS(1724),
    [anon_sym_SEMI] = ACTIONS(1724),
    [anon_sym_EQ] = ACTIONS(1724),
    [anon_sym_QMARK] = ACTIONS(1724),
    [anon_sym_AT] = ACTIONS(1724),
    [anon_sym_BSLASH] = ACTIONS(1733),
    [anon_sym_CARET] = ACTIONS(1724),
    [anon_sym__] = ACTIONS(1724),
    [anon_sym_BQUOTE] = ACTIONS(1724),
    [anon_sym_LBRACE] = ACTIONS(1724),
    [anon_sym_PIPE] = ACTIONS(1724),
    [anon_sym_RBRACE] = ACTIONS(1724),
    [anon_sym_TILDE] = ACTIONS(1724),
    [anon_sym_LPAREN] = ACTIONS(1724),
    [anon_sym_RPAREN] = ACTIONS(1724),
    [sym__newline_token] = ACTIONS(1736),
    [sym_uri_autolink] = ACTIONS(1718),
    [sym_email_autolink] = ACTIONS(1718),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1739),
    [anon_sym_LT_QMARK] = ACTIONS(1742),
    [aux_sym__declaration_token1] = ACTIONS(1745),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1748),
    [sym__whitespace_ge_2] = ACTIONS(1751),
    [aux_sym__whitespace_token1] = ACTIONS(1754),
    [sym__word_no_digit] = ACTIONS(1718),
    [sym__digits] = ACTIONS(1718),
    [sym__code_span_start] = ACTIONS(1757),
    [sym__emphasis_open_star] = ACTIONS(1760),
    [sym__emphasis_open_underscore] = ACTIONS(1763),
    [sym__last_token_punctuation] = ACTIONS(1766),
    [sym__strikethrough_open] = ACTIONS(1768),
    [sym__latex_span_start] = ACTIONS(1771),
    [sym__unclosed_span] = ACTIONS(1718),
  },
  [96] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(115),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(115),
    [aux_sym__inline_no_tilde_no_link] = STATE(115),
    [sym__strikethrough_no_link] = STATE(115),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(115),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(115),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(1774),
    [sym_entity_reference] = ACTIONS(1777),
    [sym_numeric_character_reference] = ACTIONS(1777),
    [anon_sym_LT] = ACTIONS(1780),
    [anon_sym_GT] = ACTIONS(1783),
    [anon_sym_BANG] = ACTIONS(1786),
    [anon_sym_DQUOTE] = ACTIONS(1783),
    [anon_sym_POUND] = ACTIONS(1783),
    [anon_sym_DOLLAR] = ACTIONS(1783),
    [anon_sym_PERCENT] = ACTIONS(1783),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_SQUOTE] = ACTIONS(1783),
    [anon_sym_STAR] = ACTIONS(1783),
    [anon_sym_PLUS] = ACTIONS(1783),
    [anon_sym_COMMA] = ACTIONS(1783),
    [anon_sym_DASH] = ACTIONS(1783),
    [anon_sym_DOT] = ACTIONS(1783),
    [anon_sym_SLASH] = ACTIONS(1783),
    [anon_sym_COLON] = ACTIONS(1783),
    [anon_sym_SEMI] = ACTIONS(1783),
    [anon_sym_EQ] = ACTIONS(1783),
    [anon_sym_QMARK] = ACTIONS(1783),
    [anon_sym_AT] = ACTIONS(1783),
    [anon_sym_BSLASH] = ACTIONS(1792),
    [anon_sym_CARET] = ACTIONS(1783),
    [anon_sym__] = ACTIONS(1783),
    [anon_sym_BQUOTE] = ACTIONS(1783),
    [anon_sym_LBRACE] = ACTIONS(1783),
    [anon_sym_PIPE] = ACTIONS(1783),
    [anon_sym_RBRACE] = ACTIONS(1783),
    [anon_sym_TILDE] = ACTIONS(1783),
    [anon_sym_LPAREN] = ACTIONS(1783),
    [anon_sym_RPAREN] = ACTIONS(1783),
    [sym__newline_token] = ACTIONS(1795),
    [sym_uri_autolink] = ACTIONS(1777),
    [sym_email_autolink] = ACTIONS(1777),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1798),
    [anon_sym_LT_QMARK] = ACTIONS(1801),
    [aux_sym__declaration_token1] = ACTIONS(1804),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1807),
    [sym__whitespace_ge_2] = ACTIONS(1810),
    [aux_sym__whitespace_token1] = ACTIONS(1813),
    [sym__word_no_digit] = ACTIONS(1777),
    [sym__digits] = ACTIONS(1777),
    [sym__code_span_start] = ACTIONS(1816),
    [sym__emphasis_open_star] = ACTIONS(1819),
    [sym__emphasis_open_underscore] = ACTIONS(1822),
    [sym__emphasis_close_underscore] = ACTIONS(1585),
    [sym__last_token_punctuation] = ACTIONS(1825),
    [sym__strikethrough_open] = ACTIONS(1827),
    [sym__latex_span_start] = ACTIONS(1830),
    [sym__unclosed_span] = ACTIONS(1777),
  },
  [97] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(122),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(122),
    [aux_sym__inline_no_underscore_no_link] = STATE(122),
    [sym__strikethrough_no_link] = STATE(122),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(122),
    [sym__emphasis_underscore_no_link] = STATE(633),
    [sym__strong_emphasis_underscore_no_link] = STATE(122),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(1833),
    [sym_entity_reference] = ACTIONS(1836),
    [sym_numeric_character_reference] = ACTIONS(1836),
    [anon_sym_LT] = ACTIONS(1839),
    [anon_sym_GT] = ACTIONS(1842),
    [anon_sym_BANG] = ACTIONS(1845),
    [anon_sym_DQUOTE] = ACTIONS(1842),
    [anon_sym_POUND] = ACTIONS(1842),
    [anon_sym_DOLLAR] = ACTIONS(1842),
    [anon_sym_PERCENT] = ACTIONS(1842),
    [anon_sym_AMP] = ACTIONS(1848),
    [anon_sym_SQUOTE] = ACTIONS(1842),
    [anon_sym_STAR] = ACTIONS(1842),
    [anon_sym_PLUS] = ACTIONS(1842),
    [anon_sym_COMMA] = ACTIONS(1842),
    [anon_sym_DASH] = ACTIONS(1842),
    [anon_sym_DOT] = ACTIONS(1842),
    [anon_sym_SLASH] = ACTIONS(1842),
    [anon_sym_COLON] = ACTIONS(1842),
    [anon_sym_SEMI] = ACTIONS(1842),
    [anon_sym_EQ] = ACTIONS(1842),
    [anon_sym_QMARK] = ACTIONS(1842),
    [anon_sym_AT] = ACTIONS(1842),
    [anon_sym_BSLASH] = ACTIONS(1851),
    [anon_sym_CARET] = ACTIONS(1842),
    [anon_sym__] = ACTIONS(1842),
    [anon_sym_BQUOTE] = ACTIONS(1842),
    [anon_sym_LBRACE] = ACTIONS(1842),
    [anon_sym_PIPE] = ACTIONS(1842),
    [anon_sym_RBRACE] = ACTIONS(1842),
    [anon_sym_TILDE] = ACTIONS(1842),
    [anon_sym_LPAREN] = ACTIONS(1842),
    [anon_sym_RPAREN] = ACTIONS(1842),
    [sym__newline_token] = ACTIONS(1854),
    [sym_uri_autolink] = ACTIONS(1836),
    [sym_email_autolink] = ACTIONS(1836),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1857),
    [anon_sym_LT_QMARK] = ACTIONS(1860),
    [aux_sym__declaration_token1] = ACTIONS(1863),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1866),
    [sym__whitespace_ge_2] = ACTIONS(1869),
    [aux_sym__whitespace_token1] = ACTIONS(1872),
    [sym__word_no_digit] = ACTIONS(1836),
    [sym__digits] = ACTIONS(1836),
    [sym__code_span_start] = ACTIONS(1875),
    [sym__emphasis_open_star] = ACTIONS(1878),
    [sym__emphasis_open_underscore] = ACTIONS(1881),
    [sym__emphasis_close_star] = ACTIONS(1884),
    [sym__last_token_punctuation] = ACTIONS(1886),
    [sym__strikethrough_open] = ACTIONS(1888),
    [sym__latex_span_start] = ACTIONS(1891),
    [sym__unclosed_span] = ACTIONS(1836),
  },
  [98] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(107),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(107),
    [aux_sym__inline_no_star_no_link] = STATE(107),
    [sym__strikethrough_no_link] = STATE(107),
    [sym__emphasis_star_no_link] = STATE(613),
    [sym__strong_emphasis_star_no_link] = STATE(107),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(107),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1894),
    [sym_entity_reference] = ACTIONS(1897),
    [sym_numeric_character_reference] = ACTIONS(1897),
    [anon_sym_LT] = ACTIONS(1900),
    [anon_sym_GT] = ACTIONS(1903),
    [anon_sym_BANG] = ACTIONS(1906),
    [anon_sym_DQUOTE] = ACTIONS(1903),
    [anon_sym_POUND] = ACTIONS(1903),
    [anon_sym_DOLLAR] = ACTIONS(1903),
    [anon_sym_PERCENT] = ACTIONS(1903),
    [anon_sym_AMP] = ACTIONS(1909),
    [anon_sym_SQUOTE] = ACTIONS(1903),
    [anon_sym_STAR] = ACTIONS(1903),
    [anon_sym_PLUS] = ACTIONS(1903),
    [anon_sym_COMMA] = ACTIONS(1903),
    [anon_sym_DASH] = ACTIONS(1903),
    [anon_sym_DOT] = ACTIONS(1903),
    [anon_sym_SLASH] = ACTIONS(1903),
    [anon_sym_COLON] = ACTIONS(1903),
    [anon_sym_SEMI] = ACTIONS(1903),
    [anon_sym_EQ] = ACTIONS(1903),
    [anon_sym_QMARK] = ACTIONS(1903),
    [anon_sym_AT] = ACTIONS(1903),
    [anon_sym_BSLASH] = ACTIONS(1912),
    [anon_sym_CARET] = ACTIONS(1903),
    [anon_sym__] = ACTIONS(1903),
    [anon_sym_BQUOTE] = ACTIONS(1903),
    [anon_sym_LBRACE] = ACTIONS(1903),
    [anon_sym_PIPE] = ACTIONS(1903),
    [anon_sym_RBRACE] = ACTIONS(1903),
    [anon_sym_TILDE] = ACTIONS(1903),
    [anon_sym_LPAREN] = ACTIONS(1903),
    [anon_sym_RPAREN] = ACTIONS(1903),
    [sym__newline_token] = ACTIONS(1915),
    [sym_uri_autolink] = ACTIONS(1897),
    [sym_email_autolink] = ACTIONS(1897),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1918),
    [anon_sym_LT_QMARK] = ACTIONS(1921),
    [aux_sym__declaration_token1] = ACTIONS(1924),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1927),
    [sym__whitespace_ge_2] = ACTIONS(1930),
    [aux_sym__whitespace_token1] = ACTIONS(1933),
    [sym__word_no_digit] = ACTIONS(1897),
    [sym__digits] = ACTIONS(1897),
    [sym__code_span_start] = ACTIONS(1936),
    [sym__emphasis_open_star] = ACTIONS(1939),
    [sym__emphasis_open_underscore] = ACTIONS(1942),
    [sym__last_token_punctuation] = ACTIONS(1945),
    [sym__strikethrough_open] = ACTIONS(1947),
    [sym__strikethrough_close] = ACTIONS(1529),
    [sym__latex_span_start] = ACTIONS(1950),
    [sym__unclosed_span] = ACTIONS(1897),
  },
  [99] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(124),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(124),
    [aux_sym__inline_no_tilde_no_link] = STATE(124),
    [sym__strikethrough_no_link] = STATE(124),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(124),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(124),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(1953),
    [sym_entity_reference] = ACTIONS(1956),
    [sym_numeric_character_reference] = ACTIONS(1956),
    [anon_sym_LT] = ACTIONS(1959),
    [anon_sym_GT] = ACTIONS(1962),
    [anon_sym_BANG] = ACTIONS(1965),
    [anon_sym_DQUOTE] = ACTIONS(1962),
    [anon_sym_POUND] = ACTIONS(1962),
    [anon_sym_DOLLAR] = ACTIONS(1962),
    [anon_sym_PERCENT] = ACTIONS(1962),
    [anon_sym_AMP] = ACTIONS(1968),
    [anon_sym_SQUOTE] = ACTIONS(1962),
    [anon_sym_STAR] = ACTIONS(1962),
    [anon_sym_PLUS] = ACTIONS(1962),
    [anon_sym_COMMA] = ACTIONS(1962),
    [anon_sym_DASH] = ACTIONS(1962),
    [anon_sym_DOT] = ACTIONS(1962),
    [anon_sym_SLASH] = ACTIONS(1962),
    [anon_sym_COLON] = ACTIONS(1962),
    [anon_sym_SEMI] = ACTIONS(1962),
    [anon_sym_EQ] = ACTIONS(1962),
    [anon_sym_QMARK] = ACTIONS(1962),
    [anon_sym_AT] = ACTIONS(1962),
    [anon_sym_BSLASH] = ACTIONS(1971),
    [anon_sym_CARET] = ACTIONS(1962),
    [anon_sym__] = ACTIONS(1962),
    [anon_sym_BQUOTE] = ACTIONS(1962),
    [anon_sym_LBRACE] = ACTIONS(1962),
    [anon_sym_PIPE] = ACTIONS(1962),
    [anon_sym_RBRACE] = ACTIONS(1962),
    [anon_sym_TILDE] = ACTIONS(1962),
    [anon_sym_LPAREN] = ACTIONS(1962),
    [anon_sym_RPAREN] = ACTIONS(1962),
    [sym__newline_token] = ACTIONS(1974),
    [sym_uri_autolink] = ACTIONS(1956),
    [sym_email_autolink] = ACTIONS(1956),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1977),
    [anon_sym_LT_QMARK] = ACTIONS(1980),
    [aux_sym__declaration_token1] = ACTIONS(1983),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1986),
    [sym__whitespace_ge_2] = ACTIONS(1989),
    [aux_sym__whitespace_token1] = ACTIONS(1992),
    [sym__word_no_digit] = ACTIONS(1956),
    [sym__digits] = ACTIONS(1956),
    [sym__code_span_start] = ACTIONS(1995),
    [sym__emphasis_open_star] = ACTIONS(1998),
    [sym__emphasis_open_underscore] = ACTIONS(2001),
    [sym__emphasis_close_star] = ACTIONS(1884),
    [sym__last_token_punctuation] = ACTIONS(2004),
    [sym__strikethrough_open] = ACTIONS(2006),
    [sym__latex_span_start] = ACTIONS(2009),
    [sym__unclosed_span] = ACTIONS(1956),
  },
  [100] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2014),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [101] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2046),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [102] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(2048),
    [sym_entity_reference] = ACTIONS(2051),
    [sym_numeric_character_reference] = ACTIONS(2051),
    [anon_sym_LT] = ACTIONS(2054),
    [anon_sym_GT] = ACTIONS(2057),
    [anon_sym_BANG] = ACTIONS(2060),
    [anon_sym_DQUOTE] = ACTIONS(2057),
    [anon_sym_POUND] = ACTIONS(2057),
    [anon_sym_DOLLAR] = ACTIONS(2057),
    [anon_sym_PERCENT] = ACTIONS(2057),
    [anon_sym_AMP] = ACTIONS(2063),
    [anon_sym_SQUOTE] = ACTIONS(2057),
    [anon_sym_STAR] = ACTIONS(2057),
    [anon_sym_PLUS] = ACTIONS(2057),
    [anon_sym_COMMA] = ACTIONS(2057),
    [anon_sym_DASH] = ACTIONS(2057),
    [anon_sym_DOT] = ACTIONS(2057),
    [anon_sym_SLASH] = ACTIONS(2057),
    [anon_sym_COLON] = ACTIONS(2057),
    [anon_sym_SEMI] = ACTIONS(2057),
    [anon_sym_EQ] = ACTIONS(2057),
    [anon_sym_QMARK] = ACTIONS(2057),
    [anon_sym_AT] = ACTIONS(2057),
    [anon_sym_BSLASH] = ACTIONS(2066),
    [anon_sym_CARET] = ACTIONS(2057),
    [anon_sym__] = ACTIONS(2057),
    [anon_sym_BQUOTE] = ACTIONS(2057),
    [anon_sym_LBRACE] = ACTIONS(2057),
    [anon_sym_PIPE] = ACTIONS(2057),
    [anon_sym_RBRACE] = ACTIONS(2057),
    [anon_sym_TILDE] = ACTIONS(2057),
    [anon_sym_LPAREN] = ACTIONS(2057),
    [anon_sym_RPAREN] = ACTIONS(2057),
    [sym__newline_token] = ACTIONS(2069),
    [sym_uri_autolink] = ACTIONS(2051),
    [sym_email_autolink] = ACTIONS(2051),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2072),
    [anon_sym_LT_QMARK] = ACTIONS(2075),
    [aux_sym__declaration_token1] = ACTIONS(2078),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2081),
    [sym__whitespace_ge_2] = ACTIONS(2084),
    [aux_sym__whitespace_token1] = ACTIONS(2087),
    [sym__word_no_digit] = ACTIONS(2051),
    [sym__digits] = ACTIONS(2051),
    [sym__code_span_start] = ACTIONS(2090),
    [sym__emphasis_open_star] = ACTIONS(2093),
    [sym__emphasis_open_underscore] = ACTIONS(2096),
    [sym__emphasis_close_star] = ACTIONS(2099),
    [sym__strikethrough_open] = ACTIONS(2101),
    [sym__latex_span_start] = ACTIONS(2104),
    [sym__unclosed_span] = ACTIONS(2051),
  },
  [103] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__emphasis_close_star] = ACTIONS(2121),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [104] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__emphasis_close_underscore] = ACTIONS(2139),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [105] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2143),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [106] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2145),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [107] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__emphasis_close_star] = ACTIONS(2147),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [108] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2149),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [109] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2151),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [110] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__emphasis_close_underscore] = ACTIONS(2153),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [111] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__emphasis_close_underscore] = ACTIONS(2155),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [112] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__emphasis_close_star] = ACTIONS(2157),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [113] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(2159),
    [sym_entity_reference] = ACTIONS(2162),
    [sym_numeric_character_reference] = ACTIONS(2162),
    [anon_sym_LT] = ACTIONS(2165),
    [anon_sym_GT] = ACTIONS(2168),
    [anon_sym_BANG] = ACTIONS(2171),
    [anon_sym_DQUOTE] = ACTIONS(2168),
    [anon_sym_POUND] = ACTIONS(2168),
    [anon_sym_DOLLAR] = ACTIONS(2168),
    [anon_sym_PERCENT] = ACTIONS(2168),
    [anon_sym_AMP] = ACTIONS(2174),
    [anon_sym_SQUOTE] = ACTIONS(2168),
    [anon_sym_STAR] = ACTIONS(2168),
    [anon_sym_PLUS] = ACTIONS(2168),
    [anon_sym_COMMA] = ACTIONS(2168),
    [anon_sym_DASH] = ACTIONS(2168),
    [anon_sym_DOT] = ACTIONS(2168),
    [anon_sym_SLASH] = ACTIONS(2168),
    [anon_sym_COLON] = ACTIONS(2168),
    [anon_sym_SEMI] = ACTIONS(2168),
    [anon_sym_EQ] = ACTIONS(2168),
    [anon_sym_QMARK] = ACTIONS(2168),
    [anon_sym_AT] = ACTIONS(2168),
    [anon_sym_BSLASH] = ACTIONS(2177),
    [anon_sym_CARET] = ACTIONS(2168),
    [anon_sym__] = ACTIONS(2168),
    [anon_sym_BQUOTE] = ACTIONS(2168),
    [anon_sym_LBRACE] = ACTIONS(2168),
    [anon_sym_PIPE] = ACTIONS(2168),
    [anon_sym_RBRACE] = ACTIONS(2168),
    [anon_sym_TILDE] = ACTIONS(2168),
    [anon_sym_LPAREN] = ACTIONS(2168),
    [anon_sym_RPAREN] = ACTIONS(2168),
    [sym__newline_token] = ACTIONS(2180),
    [sym_uri_autolink] = ACTIONS(2162),
    [sym_email_autolink] = ACTIONS(2162),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2183),
    [anon_sym_LT_QMARK] = ACTIONS(2186),
    [aux_sym__declaration_token1] = ACTIONS(2189),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2192),
    [sym__whitespace_ge_2] = ACTIONS(2195),
    [aux_sym__whitespace_token1] = ACTIONS(2198),
    [sym__word_no_digit] = ACTIONS(2162),
    [sym__digits] = ACTIONS(2162),
    [sym__code_span_start] = ACTIONS(2201),
    [sym__emphasis_open_star] = ACTIONS(2204),
    [sym__emphasis_open_underscore] = ACTIONS(2207),
    [sym__strikethrough_open] = ACTIONS(2210),
    [sym__strikethrough_close] = ACTIONS(2213),
    [sym__latex_span_start] = ACTIONS(2215),
    [sym__unclosed_span] = ACTIONS(2162),
  },
  [114] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2218),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [115] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2220),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [116] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__emphasis_close_underscore] = ACTIONS(2222),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [117] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__emphasis_close_underscore] = ACTIONS(2224),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [118] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2226),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [119] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__emphasis_close_star] = ACTIONS(2228),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [120] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2230),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [121] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(135),
    [aux_sym__inline_no_star_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(602),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__last_token_punctuation] = ACTIONS(2232),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [122] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__emphasis_close_underscore] = ACTIONS(2234),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [123] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__emphasis_close_star] = ACTIONS(2236),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [124] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(113),
    [aux_sym__inline_no_tilde_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__strikethrough_close] = ACTIONS(2238),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [125] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__emphasis_close_star] = ACTIONS(2240),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [126] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(117),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(117),
    [aux_sym__inline_no_underscore_no_link] = STATE(117),
    [sym__strikethrough_no_link] = STATE(117),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(117),
    [sym__emphasis_underscore_no_link] = STATE(607),
    [sym__strong_emphasis_underscore_no_link] = STATE(117),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__last_token_punctuation] = ACTIONS(2242),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [127] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__emphasis_close_star] = ACTIONS(2244),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [128] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__emphasis_close_underscore] = ACTIONS(2246),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [129] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(2248),
    [sym_entity_reference] = ACTIONS(2251),
    [sym_numeric_character_reference] = ACTIONS(2251),
    [anon_sym_LT] = ACTIONS(2254),
    [anon_sym_GT] = ACTIONS(2257),
    [anon_sym_BANG] = ACTIONS(2260),
    [anon_sym_DQUOTE] = ACTIONS(2257),
    [anon_sym_POUND] = ACTIONS(2257),
    [anon_sym_DOLLAR] = ACTIONS(2257),
    [anon_sym_PERCENT] = ACTIONS(2257),
    [anon_sym_AMP] = ACTIONS(2263),
    [anon_sym_SQUOTE] = ACTIONS(2257),
    [anon_sym_STAR] = ACTIONS(2257),
    [anon_sym_PLUS] = ACTIONS(2257),
    [anon_sym_COMMA] = ACTIONS(2257),
    [anon_sym_DASH] = ACTIONS(2257),
    [anon_sym_DOT] = ACTIONS(2257),
    [anon_sym_SLASH] = ACTIONS(2257),
    [anon_sym_COLON] = ACTIONS(2257),
    [anon_sym_SEMI] = ACTIONS(2257),
    [anon_sym_EQ] = ACTIONS(2257),
    [anon_sym_QMARK] = ACTIONS(2257),
    [anon_sym_AT] = ACTIONS(2257),
    [anon_sym_BSLASH] = ACTIONS(2266),
    [anon_sym_CARET] = ACTIONS(2257),
    [anon_sym__] = ACTIONS(2257),
    [anon_sym_BQUOTE] = ACTIONS(2257),
    [anon_sym_LBRACE] = ACTIONS(2257),
    [anon_sym_PIPE] = ACTIONS(2257),
    [anon_sym_RBRACE] = ACTIONS(2257),
    [anon_sym_TILDE] = ACTIONS(2257),
    [anon_sym_LPAREN] = ACTIONS(2257),
    [anon_sym_RPAREN] = ACTIONS(2257),
    [sym__newline_token] = ACTIONS(2269),
    [sym_uri_autolink] = ACTIONS(2251),
    [sym_email_autolink] = ACTIONS(2251),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2272),
    [anon_sym_LT_QMARK] = ACTIONS(2275),
    [aux_sym__declaration_token1] = ACTIONS(2278),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2281),
    [sym__whitespace_ge_2] = ACTIONS(2284),
    [aux_sym__whitespace_token1] = ACTIONS(2287),
    [sym__word_no_digit] = ACTIONS(2251),
    [sym__digits] = ACTIONS(2251),
    [sym__code_span_start] = ACTIONS(2290),
    [sym__emphasis_open_star] = ACTIONS(2293),
    [sym__emphasis_open_underscore] = ACTIONS(2296),
    [sym__emphasis_close_underscore] = ACTIONS(2299),
    [sym__strikethrough_open] = ACTIONS(2301),
    [sym__latex_span_start] = ACTIONS(2304),
    [sym__unclosed_span] = ACTIONS(2251),
  },
  [130] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(129),
    [aux_sym__inline_no_underscore_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__emphasis_close_underscore] = ACTIONS(2307),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [131] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2309),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [132] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_RBRACK] = ACTIONS(2311),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2024),
    [sym__emphasis_open_underscore] = ACTIONS(2026),
    [sym__strikethrough_open] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [133] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(118),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(118),
    [aux_sym__inline_no_tilde_no_link] = STATE(118),
    [sym__strikethrough_no_link] = STATE(118),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(118),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(118),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__last_token_punctuation] = ACTIONS(2313),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [134] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__inline_base] = STATE(621),
    [sym__text_base] = STATE(160),
    [sym__inline_element_no_link] = STATE(621),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(621),
    [sym__emphasis_star_no_link] = STATE(625),
    [sym__strong_emphasis_star_no_link] = STATE(621),
    [sym__emphasis_underscore_no_link] = STATE(625),
    [sym__strong_emphasis_underscore_no_link] = STATE(621),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(2315),
    [sym_entity_reference] = ACTIONS(2318),
    [sym_numeric_character_reference] = ACTIONS(2318),
    [anon_sym_RBRACK] = ACTIONS(2321),
    [anon_sym_LT] = ACTIONS(2323),
    [anon_sym_GT] = ACTIONS(2326),
    [anon_sym_BANG] = ACTIONS(2329),
    [anon_sym_DQUOTE] = ACTIONS(2326),
    [anon_sym_POUND] = ACTIONS(2326),
    [anon_sym_DOLLAR] = ACTIONS(2326),
    [anon_sym_PERCENT] = ACTIONS(2326),
    [anon_sym_AMP] = ACTIONS(2332),
    [anon_sym_SQUOTE] = ACTIONS(2326),
    [anon_sym_STAR] = ACTIONS(2326),
    [anon_sym_PLUS] = ACTIONS(2326),
    [anon_sym_COMMA] = ACTIONS(2326),
    [anon_sym_DASH] = ACTIONS(2326),
    [anon_sym_DOT] = ACTIONS(2326),
    [anon_sym_SLASH] = ACTIONS(2326),
    [anon_sym_COLON] = ACTIONS(2326),
    [anon_sym_SEMI] = ACTIONS(2326),
    [anon_sym_EQ] = ACTIONS(2326),
    [anon_sym_QMARK] = ACTIONS(2326),
    [anon_sym_AT] = ACTIONS(2326),
    [anon_sym_BSLASH] = ACTIONS(2335),
    [anon_sym_CARET] = ACTIONS(2326),
    [anon_sym__] = ACTIONS(2326),
    [anon_sym_BQUOTE] = ACTIONS(2326),
    [anon_sym_LBRACE] = ACTIONS(2326),
    [anon_sym_PIPE] = ACTIONS(2326),
    [anon_sym_RBRACE] = ACTIONS(2326),
    [anon_sym_TILDE] = ACTIONS(2326),
    [anon_sym_LPAREN] = ACTIONS(2326),
    [anon_sym_RPAREN] = ACTIONS(2326),
    [sym__newline_token] = ACTIONS(2338),
    [sym_uri_autolink] = ACTIONS(2318),
    [sym_email_autolink] = ACTIONS(2318),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2341),
    [anon_sym_LT_QMARK] = ACTIONS(2344),
    [aux_sym__declaration_token1] = ACTIONS(2347),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2350),
    [sym__whitespace_ge_2] = ACTIONS(2353),
    [aux_sym__whitespace_token1] = ACTIONS(2356),
    [sym__word_no_digit] = ACTIONS(2318),
    [sym__digits] = ACTIONS(2318),
    [sym__code_span_start] = ACTIONS(2359),
    [sym__emphasis_open_star] = ACTIONS(2362),
    [sym__emphasis_open_underscore] = ACTIONS(2365),
    [sym__strikethrough_open] = ACTIONS(2368),
    [sym__latex_span_start] = ACTIONS(2371),
    [sym__unclosed_span] = ACTIONS(2318),
  },
  [135] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(102),
    [aux_sym__inline_no_star_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__emphasis_close_star] = ACTIONS(2374),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [136] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(105),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(105),
    [aux_sym__inline_no_tilde_no_link] = STATE(105),
    [sym__strikethrough_no_link] = STATE(105),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(105),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(105),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [137] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(110),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(110),
    [aux_sym__inline_no_underscore_no_link] = STATE(110),
    [sym__strikethrough_no_link] = STATE(110),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(110),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(110),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [138] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [139] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(108),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(108),
    [aux_sym__inline_no_tilde_no_link] = STATE(108),
    [sym__strikethrough_no_link] = STATE(108),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(108),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(108),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [140] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(130),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(130),
    [aux_sym__inline_no_underscore_no_link] = STATE(130),
    [sym__strikethrough_no_link] = STATE(130),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(130),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(130),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [141] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(111),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(111),
    [aux_sym__inline_no_underscore_no_link] = STATE(111),
    [sym__strikethrough_no_link] = STATE(111),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(111),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(111),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [142] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(112),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(112),
    [aux_sym__inline_no_star_no_link] = STATE(112),
    [sym__strikethrough_no_link] = STATE(112),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(112),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(112),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [143] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(109),
    [aux_sym__inline_no_tilde_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(635),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2030),
    [sym_numeric_character_reference] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2030),
    [sym_email_autolink] = ACTIONS(2030),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2030),
    [sym__digits] = ACTIONS(2030),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2040),
    [sym__emphasis_open_underscore] = ACTIONS(2042),
    [sym__strikethrough_open] = ACTIONS(2044),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2030),
  },
  [144] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(125),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(125),
    [aux_sym__inline_no_star_no_link] = STATE(125),
    [sym__strikethrough_no_link] = STATE(125),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(125),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(125),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [145] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(103),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(103),
    [aux_sym__inline_no_star_no_link] = STATE(103),
    [sym__strikethrough_no_link] = STATE(103),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(103),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(103),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [146] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__inline_base] = STATE(104),
    [sym__text_base] = STATE(164),
    [sym__inline_element_no_underscore_no_link] = STATE(104),
    [aux_sym__inline_no_underscore_no_link] = STATE(104),
    [sym__strikethrough_no_link] = STATE(104),
    [sym__emphasis_star_no_link] = STATE(642),
    [sym__strong_emphasis_star_no_link] = STATE(104),
    [sym__emphasis_underscore_no_link] = STATE(642),
    [sym__strong_emphasis_underscore_no_link] = STATE(104),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2125),
    [sym_numeric_character_reference] = ACTIONS(2125),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2125),
    [sym_email_autolink] = ACTIONS(2125),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2125),
    [sym__digits] = ACTIONS(2125),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2135),
    [sym__emphasis_open_underscore] = ACTIONS(2137),
    [sym__strikethrough_open] = ACTIONS(2141),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2125),
  },
  [147] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(127),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_star_no_link] = STATE(127),
    [aux_sym__inline_no_star_no_link] = STATE(127),
    [sym__strikethrough_no_link] = STATE(127),
    [sym__emphasis_star_no_link] = STATE(643),
    [sym__strong_emphasis_star_no_link] = STATE(127),
    [sym__emphasis_underscore_no_link] = STATE(643),
    [sym__strong_emphasis_underscore_no_link] = STATE(127),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2107),
    [sym_numeric_character_reference] = ACTIONS(2107),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2107),
    [sym_email_autolink] = ACTIONS(2107),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2107),
    [sym__digits] = ACTIONS(2107),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2119),
    [sym__strikethrough_open] = ACTIONS(2123),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2107),
  },
  [148] = {
    [sym_backslash_escape] = STATE(148),
    [sym_code_span] = STATE(148),
    [sym_latex_block] = STATE(148),
    [sym_image] = STATE(148),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(148),
    [sym__whitespace] = STATE(148),
    [sym__word] = STATE(148),
    [sym__soft_line_break] = STATE(148),
    [sym__text_base] = STATE(148),
    [aux_sym__inline_base_repeat1] = STATE(148),
    [ts_builtin_sym_end] = ACTIONS(2376),
    [sym__backslash_escape] = ACTIONS(2378),
    [sym_entity_reference] = ACTIONS(2381),
    [sym_numeric_character_reference] = ACTIONS(2381),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2384),
    [anon_sym_GT] = ACTIONS(2387),
    [anon_sym_BANG] = ACTIONS(2390),
    [anon_sym_DQUOTE] = ACTIONS(2387),
    [anon_sym_POUND] = ACTIONS(2387),
    [anon_sym_DOLLAR] = ACTIONS(2387),
    [anon_sym_PERCENT] = ACTIONS(2387),
    [anon_sym_AMP] = ACTIONS(2393),
    [anon_sym_SQUOTE] = ACTIONS(2387),
    [anon_sym_STAR] = ACTIONS(2387),
    [anon_sym_PLUS] = ACTIONS(2387),
    [anon_sym_COMMA] = ACTIONS(2387),
    [anon_sym_DASH] = ACTIONS(2387),
    [anon_sym_DOT] = ACTIONS(2387),
    [anon_sym_SLASH] = ACTIONS(2387),
    [anon_sym_COLON] = ACTIONS(2387),
    [anon_sym_SEMI] = ACTIONS(2387),
    [anon_sym_EQ] = ACTIONS(2387),
    [anon_sym_QMARK] = ACTIONS(2387),
    [anon_sym_AT] = ACTIONS(2387),
    [anon_sym_BSLASH] = ACTIONS(2396),
    [anon_sym_CARET] = ACTIONS(2387),
    [anon_sym__] = ACTIONS(2387),
    [anon_sym_BQUOTE] = ACTIONS(2387),
    [anon_sym_LBRACE] = ACTIONS(2387),
    [anon_sym_PIPE] = ACTIONS(2387),
    [anon_sym_RBRACE] = ACTIONS(2387),
    [anon_sym_TILDE] = ACTIONS(2387),
    [anon_sym_LPAREN] = ACTIONS(2387),
    [anon_sym_RPAREN] = ACTIONS(2387),
    [sym__newline_token] = ACTIONS(2399),
    [sym_uri_autolink] = ACTIONS(2381),
    [sym_email_autolink] = ACTIONS(2381),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2402),
    [anon_sym_LT_QMARK] = ACTIONS(2405),
    [aux_sym__declaration_token1] = ACTIONS(2408),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2411),
    [sym__whitespace_ge_2] = ACTIONS(2414),
    [aux_sym__whitespace_token1] = ACTIONS(2417),
    [sym__word_no_digit] = ACTIONS(2381),
    [sym__digits] = ACTIONS(2381),
    [sym__code_span_start] = ACTIONS(2420),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2423),
    [sym__unclosed_span] = ACTIONS(2381),
  },
  [149] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__text_base] = STATE(151),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2426),
    [sym_numeric_character_reference] = ACTIONS(2426),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2426),
    [sym_email_autolink] = ACTIONS(2426),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2426),
    [sym__digits] = ACTIONS(2426),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_star] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2426),
  },
  [150] = {
    [sym_backslash_escape] = STATE(150),
    [sym_code_span] = STATE(150),
    [sym_latex_block] = STATE(150),
    [sym_image] = STATE(150),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(150),
    [sym__whitespace] = STATE(150),
    [sym__word] = STATE(150),
    [sym__soft_line_break] = STATE(150),
    [sym__text_base] = STATE(150),
    [aux_sym__inline_base_repeat1] = STATE(150),
    [sym__backslash_escape] = ACTIONS(2430),
    [sym_entity_reference] = ACTIONS(2433),
    [sym_numeric_character_reference] = ACTIONS(2433),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2436),
    [anon_sym_GT] = ACTIONS(2439),
    [anon_sym_BANG] = ACTIONS(2442),
    [anon_sym_DQUOTE] = ACTIONS(2439),
    [anon_sym_POUND] = ACTIONS(2439),
    [anon_sym_DOLLAR] = ACTIONS(2439),
    [anon_sym_PERCENT] = ACTIONS(2439),
    [anon_sym_AMP] = ACTIONS(2445),
    [anon_sym_SQUOTE] = ACTIONS(2439),
    [anon_sym_STAR] = ACTIONS(2439),
    [anon_sym_PLUS] = ACTIONS(2439),
    [anon_sym_COMMA] = ACTIONS(2439),
    [anon_sym_DASH] = ACTIONS(2439),
    [anon_sym_DOT] = ACTIONS(2439),
    [anon_sym_SLASH] = ACTIONS(2439),
    [anon_sym_COLON] = ACTIONS(2439),
    [anon_sym_SEMI] = ACTIONS(2439),
    [anon_sym_EQ] = ACTIONS(2439),
    [anon_sym_QMARK] = ACTIONS(2439),
    [anon_sym_AT] = ACTIONS(2439),
    [anon_sym_BSLASH] = ACTIONS(2448),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym__] = ACTIONS(2439),
    [anon_sym_BQUOTE] = ACTIONS(2439),
    [anon_sym_LBRACE] = ACTIONS(2439),
    [anon_sym_PIPE] = ACTIONS(2439),
    [anon_sym_RBRACE] = ACTIONS(2439),
    [anon_sym_TILDE] = ACTIONS(2439),
    [anon_sym_LPAREN] = ACTIONS(2439),
    [anon_sym_RPAREN] = ACTIONS(2439),
    [sym__newline_token] = ACTIONS(2451),
    [sym_uri_autolink] = ACTIONS(2433),
    [sym_email_autolink] = ACTIONS(2433),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2454),
    [anon_sym_LT_QMARK] = ACTIONS(2457),
    [aux_sym__declaration_token1] = ACTIONS(2460),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2463),
    [sym__whitespace_ge_2] = ACTIONS(2466),
    [aux_sym__whitespace_token1] = ACTIONS(2469),
    [sym__word_no_digit] = ACTIONS(2433),
    [sym__digits] = ACTIONS(2433),
    [sym__code_span_start] = ACTIONS(2472),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__strikethrough_close] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2475),
    [sym__unclosed_span] = ACTIONS(2433),
  },
  [151] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(347),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__text_base] = STATE(151),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(2478),
    [sym_entity_reference] = ACTIONS(2481),
    [sym_numeric_character_reference] = ACTIONS(2481),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2484),
    [anon_sym_GT] = ACTIONS(2487),
    [anon_sym_BANG] = ACTIONS(2490),
    [anon_sym_DQUOTE] = ACTIONS(2487),
    [anon_sym_POUND] = ACTIONS(2487),
    [anon_sym_DOLLAR] = ACTIONS(2487),
    [anon_sym_PERCENT] = ACTIONS(2487),
    [anon_sym_AMP] = ACTIONS(2493),
    [anon_sym_SQUOTE] = ACTIONS(2487),
    [anon_sym_STAR] = ACTIONS(2487),
    [anon_sym_PLUS] = ACTIONS(2487),
    [anon_sym_COMMA] = ACTIONS(2487),
    [anon_sym_DASH] = ACTIONS(2487),
    [anon_sym_DOT] = ACTIONS(2487),
    [anon_sym_SLASH] = ACTIONS(2487),
    [anon_sym_COLON] = ACTIONS(2487),
    [anon_sym_SEMI] = ACTIONS(2487),
    [anon_sym_EQ] = ACTIONS(2487),
    [anon_sym_QMARK] = ACTIONS(2487),
    [anon_sym_AT] = ACTIONS(2487),
    [anon_sym_BSLASH] = ACTIONS(2496),
    [anon_sym_CARET] = ACTIONS(2487),
    [anon_sym__] = ACTIONS(2487),
    [anon_sym_BQUOTE] = ACTIONS(2487),
    [anon_sym_LBRACE] = ACTIONS(2487),
    [anon_sym_PIPE] = ACTIONS(2487),
    [anon_sym_RBRACE] = ACTIONS(2487),
    [anon_sym_TILDE] = ACTIONS(2487),
    [anon_sym_LPAREN] = ACTIONS(2487),
    [anon_sym_RPAREN] = ACTIONS(2487),
    [sym__newline_token] = ACTIONS(2499),
    [sym_uri_autolink] = ACTIONS(2481),
    [sym_email_autolink] = ACTIONS(2481),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2502),
    [anon_sym_LT_QMARK] = ACTIONS(2505),
    [aux_sym__declaration_token1] = ACTIONS(2508),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2511),
    [sym__whitespace_ge_2] = ACTIONS(2514),
    [aux_sym__whitespace_token1] = ACTIONS(2517),
    [sym__word_no_digit] = ACTIONS(2481),
    [sym__digits] = ACTIONS(2481),
    [sym__code_span_start] = ACTIONS(2520),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__emphasis_close_star] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2523),
    [sym__unclosed_span] = ACTIONS(2481),
  },
  [152] = {
    [sym_backslash_escape] = STATE(152),
    [sym_code_span] = STATE(152),
    [sym_latex_block] = STATE(152),
    [sym_image] = STATE(152),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(152),
    [sym__whitespace] = STATE(152),
    [sym__word] = STATE(152),
    [sym__soft_line_break] = STATE(152),
    [sym__text_base] = STATE(152),
    [aux_sym__inline_base_repeat1] = STATE(152),
    [sym__backslash_escape] = ACTIONS(2526),
    [sym_entity_reference] = ACTIONS(2529),
    [sym_numeric_character_reference] = ACTIONS(2529),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2532),
    [anon_sym_GT] = ACTIONS(2535),
    [anon_sym_BANG] = ACTIONS(2538),
    [anon_sym_DQUOTE] = ACTIONS(2535),
    [anon_sym_POUND] = ACTIONS(2535),
    [anon_sym_DOLLAR] = ACTIONS(2535),
    [anon_sym_PERCENT] = ACTIONS(2535),
    [anon_sym_AMP] = ACTIONS(2541),
    [anon_sym_SQUOTE] = ACTIONS(2535),
    [anon_sym_STAR] = ACTIONS(2535),
    [anon_sym_PLUS] = ACTIONS(2535),
    [anon_sym_COMMA] = ACTIONS(2535),
    [anon_sym_DASH] = ACTIONS(2535),
    [anon_sym_DOT] = ACTIONS(2535),
    [anon_sym_SLASH] = ACTIONS(2535),
    [anon_sym_COLON] = ACTIONS(2535),
    [anon_sym_SEMI] = ACTIONS(2535),
    [anon_sym_EQ] = ACTIONS(2535),
    [anon_sym_QMARK] = ACTIONS(2535),
    [anon_sym_AT] = ACTIONS(2535),
    [anon_sym_BSLASH] = ACTIONS(2544),
    [anon_sym_CARET] = ACTIONS(2535),
    [anon_sym__] = ACTIONS(2535),
    [anon_sym_BQUOTE] = ACTIONS(2535),
    [anon_sym_LBRACE] = ACTIONS(2535),
    [anon_sym_PIPE] = ACTIONS(2535),
    [anon_sym_RBRACE] = ACTIONS(2535),
    [anon_sym_TILDE] = ACTIONS(2535),
    [anon_sym_LPAREN] = ACTIONS(2535),
    [anon_sym_RPAREN] = ACTIONS(2535),
    [sym__newline_token] = ACTIONS(2547),
    [sym_uri_autolink] = ACTIONS(2529),
    [sym_email_autolink] = ACTIONS(2529),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2550),
    [anon_sym_LT_QMARK] = ACTIONS(2553),
    [aux_sym__declaration_token1] = ACTIONS(2556),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2559),
    [sym__whitespace_ge_2] = ACTIONS(2562),
    [aux_sym__whitespace_token1] = ACTIONS(2565),
    [sym__word_no_digit] = ACTIONS(2529),
    [sym__digits] = ACTIONS(2529),
    [sym__code_span_start] = ACTIONS(2568),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__emphasis_close_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2571),
    [sym__unclosed_span] = ACTIONS(2529),
  },
  [153] = {
    [sym_backslash_escape] = STATE(152),
    [sym_code_span] = STATE(152),
    [sym_latex_block] = STATE(152),
    [sym_image] = STATE(152),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(152),
    [sym__whitespace] = STATE(152),
    [sym__word] = STATE(152),
    [sym__soft_line_break] = STATE(152),
    [sym__text_base] = STATE(152),
    [aux_sym__inline_base_repeat1] = STATE(152),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2574),
    [sym_numeric_character_reference] = ACTIONS(2574),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2574),
    [sym_email_autolink] = ACTIONS(2574),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(704),
    [anon_sym_LT_QMARK] = ACTIONS(706),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(710),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2574),
    [sym__digits] = ACTIONS(2574),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2574),
  },
  [154] = {
    [sym_backslash_escape] = STATE(150),
    [sym_code_span] = STATE(150),
    [sym_latex_block] = STATE(150),
    [sym_image] = STATE(150),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(504),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(150),
    [sym__whitespace] = STATE(150),
    [sym__word] = STATE(150),
    [sym__soft_line_break] = STATE(150),
    [sym__text_base] = STATE(150),
    [aux_sym__inline_base_repeat1] = STATE(150),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2576),
    [sym_numeric_character_reference] = ACTIONS(2576),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2576),
    [sym_email_autolink] = ACTIONS(2576),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(748),
    [anon_sym_LT_QMARK] = ACTIONS(750),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(754),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2576),
    [sym__digits] = ACTIONS(2576),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__strikethrough_close] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2576),
  },
  [155] = {
    [sym_backslash_escape] = STATE(148),
    [sym_code_span] = STATE(148),
    [sym_latex_block] = STATE(148),
    [sym_image] = STATE(148),
    [sym__image_inline_link] = STATE(266),
    [sym__image_shortcut_link] = STATE(266),
    [sym__image_full_reference_link] = STATE(266),
    [sym__image_collapsed_reference_link] = STATE(266),
    [sym__image_description] = STATE(1124),
    [sym__image_description_non_empty] = STATE(267),
    [sym__html_tag] = STATE(272),
    [sym__open_tag] = STATE(274),
    [sym__closing_tag] = STATE(274),
    [sym__html_comment] = STATE(274),
    [sym__processing_instruction] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym__cdata_section] = STATE(274),
    [sym_hard_line_break] = STATE(148),
    [sym__whitespace] = STATE(148),
    [sym__word] = STATE(148),
    [sym__soft_line_break] = STATE(148),
    [sym__text_base] = STATE(148),
    [aux_sym__inline_base_repeat1] = STATE(148),
    [ts_builtin_sym_end] = ACTIONS(2428),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(2578),
    [sym_numeric_character_reference] = ACTIONS(2578),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(2578),
    [sym_email_autolink] = ACTIONS(2578),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(2578),
    [sym__digits] = ACTIONS(2578),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(2578),
  },
  [156] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__text_base] = STATE(156),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(2580),
    [sym_entity_reference] = ACTIONS(2583),
    [sym_numeric_character_reference] = ACTIONS(2583),
    [anon_sym_LBRACK] = ACTIONS(2376),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2586),
    [anon_sym_GT] = ACTIONS(2589),
    [anon_sym_BANG] = ACTIONS(2592),
    [anon_sym_DQUOTE] = ACTIONS(2589),
    [anon_sym_POUND] = ACTIONS(2589),
    [anon_sym_DOLLAR] = ACTIONS(2589),
    [anon_sym_PERCENT] = ACTIONS(2589),
    [anon_sym_AMP] = ACTIONS(2595),
    [anon_sym_SQUOTE] = ACTIONS(2589),
    [anon_sym_STAR] = ACTIONS(2589),
    [anon_sym_PLUS] = ACTIONS(2589),
    [anon_sym_COMMA] = ACTIONS(2589),
    [anon_sym_DASH] = ACTIONS(2589),
    [anon_sym_DOT] = ACTIONS(2589),
    [anon_sym_SLASH] = ACTIONS(2589),
    [anon_sym_COLON] = ACTIONS(2589),
    [anon_sym_SEMI] = ACTIONS(2589),
    [anon_sym_EQ] = ACTIONS(2589),
    [anon_sym_QMARK] = ACTIONS(2589),
    [anon_sym_AT] = ACTIONS(2589),
    [anon_sym_BSLASH] = ACTIONS(2598),
    [anon_sym_CARET] = ACTIONS(2589),
    [anon_sym__] = ACTIONS(2589),
    [anon_sym_BQUOTE] = ACTIONS(2589),
    [anon_sym_LBRACE] = ACTIONS(2589),
    [anon_sym_PIPE] = ACTIONS(2589),
    [anon_sym_RBRACE] = ACTIONS(2589),
    [anon_sym_TILDE] = ACTIONS(2589),
    [anon_sym_LPAREN] = ACTIONS(2589),
    [anon_sym_RPAREN] = ACTIONS(2589),
    [sym__newline_token] = ACTIONS(2601),
    [sym_uri_autolink] = ACTIONS(2583),
    [sym_email_autolink] = ACTIONS(2583),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2604),
    [anon_sym_LT_QMARK] = ACTIONS(2607),
    [aux_sym__declaration_token1] = ACTIONS(2610),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2613),
    [sym__whitespace_ge_2] = ACTIONS(2616),
    [aux_sym__whitespace_token1] = ACTIONS(2619),
    [sym__word_no_digit] = ACTIONS(2583),
    [sym__digits] = ACTIONS(2583),
    [sym__code_span_start] = ACTIONS(2622),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2625),
    [sym__unclosed_span] = ACTIONS(2583),
  },
  [157] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(539),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__text_base] = STATE(156),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2628),
    [sym_numeric_character_reference] = ACTIONS(2628),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2628),
    [sym_email_autolink] = ACTIONS(2628),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2628),
    [sym__digits] = ACTIONS(2628),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2628),
  },
  [158] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__text_base] = STATE(161),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(728),
    [sym_entity_reference] = ACTIONS(2630),
    [sym_numeric_character_reference] = ACTIONS(2630),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(2032),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(738),
    [anon_sym_DOLLAR] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_COLON] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(738),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_BSLASH] = ACTIONS(744),
    [anon_sym_CARET] = ACTIONS(738),
    [anon_sym__] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(738),
    [sym__newline_token] = ACTIONS(746),
    [sym_uri_autolink] = ACTIONS(2630),
    [sym_email_autolink] = ACTIONS(2630),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2034),
    [anon_sym_LT_QMARK] = ACTIONS(2036),
    [aux_sym__declaration_token1] = ACTIONS(752),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2038),
    [sym__whitespace_ge_2] = ACTIONS(756),
    [aux_sym__whitespace_token1] = ACTIONS(758),
    [sym__word_no_digit] = ACTIONS(2630),
    [sym__digits] = ACTIONS(2630),
    [sym__code_span_start] = ACTIONS(760),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__strikethrough_close] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(770),
    [sym__unclosed_span] = ACTIONS(2630),
  },
  [159] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__text_base] = STATE(159),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(2526),
    [sym_entity_reference] = ACTIONS(2632),
    [sym_numeric_character_reference] = ACTIONS(2632),
    [anon_sym_LT] = ACTIONS(2532),
    [anon_sym_GT] = ACTIONS(2535),
    [anon_sym_BANG] = ACTIONS(2635),
    [anon_sym_DQUOTE] = ACTIONS(2535),
    [anon_sym_POUND] = ACTIONS(2535),
    [anon_sym_DOLLAR] = ACTIONS(2535),
    [anon_sym_PERCENT] = ACTIONS(2535),
    [anon_sym_AMP] = ACTIONS(2541),
    [anon_sym_SQUOTE] = ACTIONS(2535),
    [anon_sym_STAR] = ACTIONS(2535),
    [anon_sym_PLUS] = ACTIONS(2535),
    [anon_sym_COMMA] = ACTIONS(2535),
    [anon_sym_DASH] = ACTIONS(2535),
    [anon_sym_DOT] = ACTIONS(2535),
    [anon_sym_SLASH] = ACTIONS(2535),
    [anon_sym_COLON] = ACTIONS(2535),
    [anon_sym_SEMI] = ACTIONS(2535),
    [anon_sym_EQ] = ACTIONS(2535),
    [anon_sym_QMARK] = ACTIONS(2535),
    [anon_sym_AT] = ACTIONS(2535),
    [anon_sym_BSLASH] = ACTIONS(2544),
    [anon_sym_CARET] = ACTIONS(2535),
    [anon_sym__] = ACTIONS(2535),
    [anon_sym_BQUOTE] = ACTIONS(2535),
    [anon_sym_LBRACE] = ACTIONS(2535),
    [anon_sym_PIPE] = ACTIONS(2535),
    [anon_sym_RBRACE] = ACTIONS(2535),
    [anon_sym_TILDE] = ACTIONS(2535),
    [anon_sym_LPAREN] = ACTIONS(2535),
    [anon_sym_RPAREN] = ACTIONS(2535),
    [sym__newline_token] = ACTIONS(2547),
    [sym_uri_autolink] = ACTIONS(2632),
    [sym_email_autolink] = ACTIONS(2632),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2638),
    [anon_sym_LT_QMARK] = ACTIONS(2641),
    [aux_sym__declaration_token1] = ACTIONS(2556),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2644),
    [sym__whitespace_ge_2] = ACTIONS(2562),
    [aux_sym__whitespace_token1] = ACTIONS(2565),
    [sym__word_no_digit] = ACTIONS(2632),
    [sym__digits] = ACTIONS(2632),
    [sym__code_span_start] = ACTIONS(2568),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__emphasis_close_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2571),
    [sym__unclosed_span] = ACTIONS(2632),
  },
  [160] = {
    [sym_backslash_escape] = STATE(162),
    [sym_code_span] = STATE(162),
    [sym_latex_block] = STATE(162),
    [sym_image] = STATE(162),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(162),
    [sym__whitespace] = STATE(162),
    [sym__word] = STATE(162),
    [sym__soft_line_break] = STATE(162),
    [sym__text_base] = STATE(162),
    [aux_sym__inline_base_repeat1] = STATE(162),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2647),
    [sym_numeric_character_reference] = ACTIONS(2647),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2016),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2647),
    [sym_email_autolink] = ACTIONS(2647),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2018),
    [anon_sym_LT_QMARK] = ACTIONS(2020),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2022),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2647),
    [sym__digits] = ACTIONS(2647),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2647),
  },
  [161] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(503),
    [sym__image_shortcut_link] = STATE(503),
    [sym__image_full_reference_link] = STATE(503),
    [sym__image_collapsed_reference_link] = STATE(503),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(540),
    [sym__html_tag] = STATE(505),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__text_base] = STATE(161),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(2430),
    [sym_entity_reference] = ACTIONS(2649),
    [sym_numeric_character_reference] = ACTIONS(2649),
    [anon_sym_LT] = ACTIONS(2436),
    [anon_sym_GT] = ACTIONS(2439),
    [anon_sym_BANG] = ACTIONS(2652),
    [anon_sym_DQUOTE] = ACTIONS(2439),
    [anon_sym_POUND] = ACTIONS(2439),
    [anon_sym_DOLLAR] = ACTIONS(2439),
    [anon_sym_PERCENT] = ACTIONS(2439),
    [anon_sym_AMP] = ACTIONS(2445),
    [anon_sym_SQUOTE] = ACTIONS(2439),
    [anon_sym_STAR] = ACTIONS(2439),
    [anon_sym_PLUS] = ACTIONS(2439),
    [anon_sym_COMMA] = ACTIONS(2439),
    [anon_sym_DASH] = ACTIONS(2439),
    [anon_sym_DOT] = ACTIONS(2439),
    [anon_sym_SLASH] = ACTIONS(2439),
    [anon_sym_COLON] = ACTIONS(2439),
    [anon_sym_SEMI] = ACTIONS(2439),
    [anon_sym_EQ] = ACTIONS(2439),
    [anon_sym_QMARK] = ACTIONS(2439),
    [anon_sym_AT] = ACTIONS(2439),
    [anon_sym_BSLASH] = ACTIONS(2448),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym__] = ACTIONS(2439),
    [anon_sym_BQUOTE] = ACTIONS(2439),
    [anon_sym_LBRACE] = ACTIONS(2439),
    [anon_sym_PIPE] = ACTIONS(2439),
    [anon_sym_RBRACE] = ACTIONS(2439),
    [anon_sym_TILDE] = ACTIONS(2439),
    [anon_sym_LPAREN] = ACTIONS(2439),
    [anon_sym_RPAREN] = ACTIONS(2439),
    [sym__newline_token] = ACTIONS(2451),
    [sym_uri_autolink] = ACTIONS(2649),
    [sym_email_autolink] = ACTIONS(2649),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2655),
    [anon_sym_LT_QMARK] = ACTIONS(2658),
    [aux_sym__declaration_token1] = ACTIONS(2460),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2661),
    [sym__whitespace_ge_2] = ACTIONS(2466),
    [aux_sym__whitespace_token1] = ACTIONS(2469),
    [sym__word_no_digit] = ACTIONS(2649),
    [sym__digits] = ACTIONS(2649),
    [sym__code_span_start] = ACTIONS(2472),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__strikethrough_close] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2475),
    [sym__unclosed_span] = ACTIONS(2649),
  },
  [162] = {
    [sym_backslash_escape] = STATE(162),
    [sym_code_span] = STATE(162),
    [sym_latex_block] = STATE(162),
    [sym_image] = STATE(162),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(551),
    [sym__closing_tag] = STATE(551),
    [sym__html_comment] = STATE(551),
    [sym__processing_instruction] = STATE(551),
    [sym__declaration] = STATE(551),
    [sym__cdata_section] = STATE(551),
    [sym_hard_line_break] = STATE(162),
    [sym__whitespace] = STATE(162),
    [sym__word] = STATE(162),
    [sym__soft_line_break] = STATE(162),
    [sym__text_base] = STATE(162),
    [aux_sym__inline_base_repeat1] = STATE(162),
    [sym__backslash_escape] = ACTIONS(2580),
    [sym_entity_reference] = ACTIONS(2664),
    [sym_numeric_character_reference] = ACTIONS(2664),
    [anon_sym_RBRACK] = ACTIONS(2376),
    [anon_sym_LT] = ACTIONS(2586),
    [anon_sym_GT] = ACTIONS(2589),
    [anon_sym_BANG] = ACTIONS(2667),
    [anon_sym_DQUOTE] = ACTIONS(2589),
    [anon_sym_POUND] = ACTIONS(2589),
    [anon_sym_DOLLAR] = ACTIONS(2589),
    [anon_sym_PERCENT] = ACTIONS(2589),
    [anon_sym_AMP] = ACTIONS(2595),
    [anon_sym_SQUOTE] = ACTIONS(2589),
    [anon_sym_STAR] = ACTIONS(2589),
    [anon_sym_PLUS] = ACTIONS(2589),
    [anon_sym_COMMA] = ACTIONS(2589),
    [anon_sym_DASH] = ACTIONS(2589),
    [anon_sym_DOT] = ACTIONS(2589),
    [anon_sym_SLASH] = ACTIONS(2589),
    [anon_sym_COLON] = ACTIONS(2589),
    [anon_sym_SEMI] = ACTIONS(2589),
    [anon_sym_EQ] = ACTIONS(2589),
    [anon_sym_QMARK] = ACTIONS(2589),
    [anon_sym_AT] = ACTIONS(2589),
    [anon_sym_BSLASH] = ACTIONS(2598),
    [anon_sym_CARET] = ACTIONS(2589),
    [anon_sym__] = ACTIONS(2589),
    [anon_sym_BQUOTE] = ACTIONS(2589),
    [anon_sym_LBRACE] = ACTIONS(2589),
    [anon_sym_PIPE] = ACTIONS(2589),
    [anon_sym_RBRACE] = ACTIONS(2589),
    [anon_sym_TILDE] = ACTIONS(2589),
    [anon_sym_LPAREN] = ACTIONS(2589),
    [anon_sym_RPAREN] = ACTIONS(2589),
    [sym__newline_token] = ACTIONS(2601),
    [sym_uri_autolink] = ACTIONS(2664),
    [sym_email_autolink] = ACTIONS(2664),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2670),
    [anon_sym_LT_QMARK] = ACTIONS(2673),
    [aux_sym__declaration_token1] = ACTIONS(2610),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2676),
    [sym__whitespace_ge_2] = ACTIONS(2616),
    [aux_sym__whitespace_token1] = ACTIONS(2619),
    [sym__word_no_digit] = ACTIONS(2664),
    [sym__digits] = ACTIONS(2664),
    [sym__code_span_start] = ACTIONS(2622),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2625),
    [sym__unclosed_span] = ACTIONS(2664),
  },
  [163] = {
    [sym_backslash_escape] = STATE(165),
    [sym_code_span] = STATE(165),
    [sym_latex_block] = STATE(165),
    [sym_image] = STATE(165),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(165),
    [sym__whitespace] = STATE(165),
    [sym__word] = STATE(165),
    [sym__soft_line_break] = STATE(165),
    [sym__text_base] = STATE(165),
    [aux_sym__inline_base_repeat1] = STATE(165),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2679),
    [sym_numeric_character_reference] = ACTIONS(2679),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2109),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2679),
    [sym_email_autolink] = ACTIONS(2679),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2111),
    [anon_sym_LT_QMARK] = ACTIONS(2113),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2115),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2679),
    [sym__digits] = ACTIONS(2679),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_star] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2679),
  },
  [164] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(506),
    [sym__closing_tag] = STATE(506),
    [sym__html_comment] = STATE(506),
    [sym__processing_instruction] = STATE(506),
    [sym__declaration] = STATE(506),
    [sym__cdata_section] = STATE(506),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__text_base] = STATE(159),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(684),
    [sym_entity_reference] = ACTIONS(2681),
    [sym_numeric_character_reference] = ACTIONS(2681),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(694),
    [anon_sym_DOLLAR] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_AMP] = ACTIONS(698),
    [anon_sym_SQUOTE] = ACTIONS(694),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_COLON] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_BSLASH] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(694),
    [anon_sym__] = ACTIONS(694),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_RPAREN] = ACTIONS(694),
    [sym__newline_token] = ACTIONS(702),
    [sym_uri_autolink] = ACTIONS(2681),
    [sym_email_autolink] = ACTIONS(2681),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2129),
    [anon_sym_LT_QMARK] = ACTIONS(2131),
    [aux_sym__declaration_token1] = ACTIONS(708),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2133),
    [sym__whitespace_ge_2] = ACTIONS(712),
    [aux_sym__whitespace_token1] = ACTIONS(714),
    [sym__word_no_digit] = ACTIONS(2681),
    [sym__digits] = ACTIONS(2681),
    [sym__code_span_start] = ACTIONS(716),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(726),
    [sym__unclosed_span] = ACTIONS(2681),
  },
  [165] = {
    [sym_backslash_escape] = STATE(165),
    [sym_code_span] = STATE(165),
    [sym_latex_block] = STATE(165),
    [sym_image] = STATE(165),
    [sym__image_inline_link] = STATE(346),
    [sym__image_shortcut_link] = STATE(346),
    [sym__image_full_reference_link] = STATE(346),
    [sym__image_collapsed_reference_link] = STATE(346),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(541),
    [sym__html_tag] = STATE(348),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(165),
    [sym__whitespace] = STATE(165),
    [sym__word] = STATE(165),
    [sym__soft_line_break] = STATE(165),
    [sym__text_base] = STATE(165),
    [aux_sym__inline_base_repeat1] = STATE(165),
    [sym__backslash_escape] = ACTIONS(2478),
    [sym_entity_reference] = ACTIONS(2683),
    [sym_numeric_character_reference] = ACTIONS(2683),
    [anon_sym_LT] = ACTIONS(2484),
    [anon_sym_GT] = ACTIONS(2487),
    [anon_sym_BANG] = ACTIONS(2686),
    [anon_sym_DQUOTE] = ACTIONS(2487),
    [anon_sym_POUND] = ACTIONS(2487),
    [anon_sym_DOLLAR] = ACTIONS(2487),
    [anon_sym_PERCENT] = ACTIONS(2487),
    [anon_sym_AMP] = ACTIONS(2493),
    [anon_sym_SQUOTE] = ACTIONS(2487),
    [anon_sym_STAR] = ACTIONS(2487),
    [anon_sym_PLUS] = ACTIONS(2487),
    [anon_sym_COMMA] = ACTIONS(2487),
    [anon_sym_DASH] = ACTIONS(2487),
    [anon_sym_DOT] = ACTIONS(2487),
    [anon_sym_SLASH] = ACTIONS(2487),
    [anon_sym_COLON] = ACTIONS(2487),
    [anon_sym_SEMI] = ACTIONS(2487),
    [anon_sym_EQ] = ACTIONS(2487),
    [anon_sym_QMARK] = ACTIONS(2487),
    [anon_sym_AT] = ACTIONS(2487),
    [anon_sym_BSLASH] = ACTIONS(2496),
    [anon_sym_CARET] = ACTIONS(2487),
    [anon_sym__] = ACTIONS(2487),
    [anon_sym_BQUOTE] = ACTIONS(2487),
    [anon_sym_LBRACE] = ACTIONS(2487),
    [anon_sym_PIPE] = ACTIONS(2487),
    [anon_sym_RBRACE] = ACTIONS(2487),
    [anon_sym_TILDE] = ACTIONS(2487),
    [anon_sym_LPAREN] = ACTIONS(2487),
    [anon_sym_RPAREN] = ACTIONS(2487),
    [sym__newline_token] = ACTIONS(2499),
    [sym_uri_autolink] = ACTIONS(2683),
    [sym_email_autolink] = ACTIONS(2683),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2689),
    [anon_sym_LT_QMARK] = ACTIONS(2692),
    [aux_sym__declaration_token1] = ACTIONS(2508),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2695),
    [sym__whitespace_ge_2] = ACTIONS(2514),
    [aux_sym__whitespace_token1] = ACTIONS(2517),
    [sym__word_no_digit] = ACTIONS(2683),
    [sym__digits] = ACTIONS(2683),
    [sym__code_span_start] = ACTIONS(2520),
    [sym__emphasis_open_star] = ACTIONS(2376),
    [sym__emphasis_open_underscore] = ACTIONS(2376),
    [sym__emphasis_close_star] = ACTIONS(2376),
    [sym__strikethrough_open] = ACTIONS(2376),
    [sym__latex_span_start] = ACTIONS(2523),
    [sym__unclosed_span] = ACTIONS(2683),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 12,
    ACTIONS(2700), 1,
      anon_sym_LBRACK,
    ACTIONS(2702), 1,
      anon_sym_RBRACK,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2715), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2723), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2704), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    STATE(753), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 27,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [83] = 10,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2735), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2743), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(754), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [162] = 11,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2735), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2743), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2746), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(754), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 26,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [243] = 11,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2748), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2746), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2750), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(764), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 26,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [324] = 11,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2753), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2746), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2755), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(726), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 26,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [405] = 10,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2758), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2760), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2704), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(765), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [484] = 10,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2763), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2765), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2704), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(767), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [563] = 10,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2748), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2750), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(764), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2726), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [642] = 12,
    ACTIONS(2700), 1,
      anon_sym_LBRACK,
    ACTIONS(2702), 1,
      anon_sym_RBRACK,
    ACTIONS(2710), 1,
      sym__newline_token,
    ACTIONS(2717), 1,
      sym__whitespace_ge_2,
    ACTIONS(2720), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2763), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2765), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2704), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    STATE(767), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2707), 27,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [725] = 10,
    ACTIONS(2732), 1,
      sym__newline_token,
    ACTIONS(2737), 1,
      sym__whitespace_ge_2,
    ACTIONS(2740), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2768), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2770), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2713), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2729), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(774), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      ts_builtin