/*	$Id: extern.h,v 1.16 2015/02/25 14:49:14 kristaps Exp $ */
/*
 * Copyright (c) 2015 Kristaps Dzonsons <kristaps@bsd.lv>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef EXTERN_H
#define EXTERN_H

/*
 * This defines each one of the Texinfo commands that we understand.
 * Obviously this only refers to native commands; overriden names are a
 * different story.
 */
enum	texicmd {
	TEXICMD_A4PAPER,
	TEXICMD_AA,
	TEXICMD_AASMALL,
	TEXICMD_ACRONYM,
	TEXICMD_ACUTE,
	TEXICMD_AE,
	TEXICMD_AESMALL,
	TEXICMD_ANCHOR,
	TEXICMD_APPENDIX,
	TEXICMD_APPENDIXSEC,
	TEXICMD_APPENDIXSUBSEC,
	TEXICMD_APPENDIXSUBSUBSEC,
	TEXICMD_ASIS,
	TEXICMD_ASTERISK,
	TEXICMD_AT,
	TEXICMD_AUTHOR,
	TEXICMD_B,
	TEXICMD_BANG,
	TEXICMD_BULLET,
	TEXICMD_BYE,
	TEXICMD_CARTOUCHE,
	TEXICMD_CEDILLA,
	TEXICMD_CENTER,
	TEXICMD_CHAPTER,
	TEXICMD_CINDEX,
	TEXICMD_CIRCUMFLEX,
	TEXICMD_CITE,
	TEXICMD_CLEAR,
	TEXICMD_CODE,
	TEXICMD_COLON,
	TEXICMD_COLUMNFRACTIONS,
	TEXICMD_COMMA,
	TEXICMD_COMMAND,
	TEXICMD_COMMENT,
	TEXICMD_COMMENT_LONG,
	TEXICMD_CONTENTS,
	TEXICMD_COPYING,
	TEXICMD_COPYRIGHT,
	TEXICMD_DEFCODEINDEX,
	TEXICMD_DEFFN,
	TEXICMD_DEFFNX,
	TEXICMD_DEFINDEX,
	TEXICMD_DEFMAC,
	TEXICMD_DEFMACX,
	TEXICMD_DEFTP,
	TEXICMD_DEFTPX,
	TEXICMD_DEFTYPEFN,
	TEXICMD_DEFTYPEFNX,
	TEXICMD_DEFTYPEFUN,
	TEXICMD_DEFTYPEFUNX,
	TEXICMD_DEFTYPEMETHOD,
	TEXICMD_DEFTYPEMETHODX,
	TEXICMD_DEFTYPEVAR,
	TEXICMD_DEFTYPEVARX,
	TEXICMD_DEFTYPEVR,
	TEXICMD_DEFTYPEVRX,
	TEXICMD_DEFUN,
	TEXICMD_DEFUNX,
	TEXICMD_DEFVAR,
	TEXICMD_DEFVARX,
	TEXICMD_DEFVR,
	TEXICMD_DEFVRX,
	TEXICMD_DETAILMENU,
	TEXICMD_DFN,
	TEXICMD_DH,
	TEXICMD_DHSMALL,
	TEXICMD_DIRCATEGORY,
	TEXICMD_DIRENTRY,
	TEXICMD_DISPLAY,
	TEXICMD_DMN,
	TEXICMD_DOCUMENTDESCRPITION,
	TEXICMD_DOCUMENTENCODING,
	TEXICMD_DOCUMENTLANGUAGE,
	TEXICMD_DOTACCENT,
	TEXICMD_DOTLESS,
	TEXICMD_DOTS,
	TEXICMD_EMAIL,
	TEXICMD_EMPH,
	TEXICMD_END,
	TEXICMD_ENDDOTS,
	TEXICMD_ENUMERATE,
	TEXICMD_ENV,
	TEXICMD_EQUIV,
	TEXICMD_ERROR,
	TEXICMD_EURO,
	TEXICMD_EXAMPLE,
	TEXICMD_EXCLAMDOWN,
	TEXICMD_EXDENT,
	TEXICMD_EXPANSION,
	TEXICMD_FILE,
	TEXICMD_FINALOUT,
	TEXICMD_FINDEX,
	TEXICMD_FLUSHLEFT,
	TEXICMD_FLUSHRIGHT,
	TEXICMD_FIRSTPARAGRAPHINDENT,
	TEXICMD_FOOTNOTE,
	TEXICMD_FOOTNOTESTYLE,
	TEXICMD_FTABLE,
	TEXICMD_FORMAT,
	TEXICMD_GEQ,
	TEXICMD_GRAVE,
	TEXICMD_GROUP,
	TEXICMD_GUILLEMETLEFT,
	TEXICMD_GUILLEMETRIGHT,
	TEXICMD_GUILLEMOTLEFT,
	TEXICMD_GUILLEMOTRIGHT,
	TEXICMD_GUILSINGLLEFT,
	TEXICMD_GUILSINGLRIGHT,
	TEXICMD_H,
	TEXICMD_HEADING,
	TEXICMD_HEADINGS,
	TEXICMD_HEADITEM,
	TEXICMD_HTML,
	TEXICMD_HYPHEN,
	TEXICMD_I,
	TEXICMD_IFCLEAR,
	TEXICMD_IFDOCBOOK,
	TEXICMD_IFHTML,
	TEXICMD_IFINFO,
	TEXICMD_IFNOTDOCBOOK,
	TEXICMD_IFNOTHTML,
	TEXICMD_IFNOTINFO,
	TEXICMD_IFNOTPLAINTEXT,
	TEXICMD_IFNOTTEX,
	TEXICMD_IFNOTXML,
	TEXICMD_IFPLAINTEXT,
	TEXICMD_IFTEX,
	TEXICMD_IFSET,
	TEXICMD_IFXML,
	TEXICMD_IGNORE,
	TEXICMD_IMAGE,
	TEXICMD_INCLUDE,
	TEXICMD_INDENTBLOCK,
	TEXICMD_INDICATEURL,
	TEXICMD_INFOREF,
	TEXICMD_INSERTCOPYING,
	TEXICMD_ITEM,
	TEXICMD_ITEMIZE,
	TEXICMD_ITEMX,
	TEXICMD_KBD,
	TEXICMD_KEY,
	TEXICMD_KINDEX,
	TEXICMD_L,
	TEXICMD_LATEX,
	TEXICMD_LEQ,
	TEXICMD_LOWERSECTIONS,
	TEXICMD_LSMALL,
	TEXICMD_MACRO,
	TEXICMD_MACRON,
	TEXICMD_MATH,
	TEXICMD_MENU,
	TEXICMD_MINUS,
	TEXICMD_MULTITABLE,
	TEXICMD_NEED,
	TEXICMD_NEWLINE,
	TEXICMD_NODE,
	TEXICMD_NOINDENT,
	TEXICMD_O,
	TEXICMD_OE,
	TEXICMD_OESMALL,
	TEXICMD_OGONEK,
	TEXICMD_OPTION,
	TEXICMD_ORDF,
	TEXICMD_ORDM,
	TEXICMD_OSMALL,
	TEXICMD_PAGE,
	TEXICMD_PARINDENT,
	TEXICMD_PERIOD,
	TEXICMD_PINDEX,
	TEXICMD_POUNDS,
	TEXICMD_PRINTINDEX,
	TEXICMD_PXREF,
	TEXICMD_QUESTIONDOWN,
	TEXICMD_QUESTIONMARK,
	TEXICMD_QUOTATION,
	TEXICMD_QUOTEDBLBASE,
	TEXICMD_QUOTEDBLLEFT,
	TEXICMD_QUOTEDBLRIGHT,
	TEXICMD_QUOTESINGLBASE,
	TEXICMD_QUOTELEFT,
	TEXICMD_QUOTERIGHT,
	TEXICMD_R,
	TEXICMD_RAISESECTIONS,
	TEXICMD_REF,
	TEXICMD_REFILL,
	TEXICMD_REGISTEREDSYMBOL,
	TEXICMD_RESULT,
	TEXICMD_RINGACCENT,
	TEXICMD_SAMP,
	TEXICMD_SANSSERIF,
	TEXICMD_SC,
	TEXICMD_SECTION,
	TEXICMD_SET,
	TEXICMD_SETCHAPNEWPAGE,
	TEXICMD_SETCONTENTSAFTER,
	TEXICMD_SETFILENAME,
	TEXICMD_SETTITLE,
	TEXICMD_SHORTCONTENTS,
	TEXICMD_SLANTED,
	TEXICMD_SLASH,
	TEXICMD_SP,
	TEXICMD_SPACE,
	TEXICMD_SMALLBOOK,
	TEXICMD_SMALLDISPLAY,
	TEXICMD_SMALLEXAMPLE,
	TEXICMD_SMALLFORMAT,
	TEXICMD_SMALLINDENTBLOCK,
	TEXICMD_SQUIGGLE_LEFT,
	TEXICMD_SQUIGGLE_RIGHT,
	TEXICMD_SS,
	TEXICMD_STRONG,
	TEXICMD_SUBHEADING,
	TEXICMD_SUBSECTION,
	TEXICMD_SUBSUBHEADING,
	TEXICMD_SUBSUBSECTION,
	TEXICMD_SUBTITLE,
	TEXICMD_SUMMARYCONTENTS,
	TEXICMD_SYNINDEX,
	TEXICMD_SYNCODEINDEX,
	TEXICMD_T,
	TEXICMD_TAB,
	TEXICMD_TABSYM,
	TEXICMD_TABLE,
	TEXICMD_TEX,
	TEXICMD_TEXSYM,
	TEXICMD_TEXTDEGREE,
	TEXICMD_TH,
	TEXICMD_THSMALL,
	TEXICMD_TIE,
	TEXICMD_TIEACCENT,
	TEXICMD_TILDE,
	TEXICMD_TINDEX,
	TEXICMD_TITLE,
	TEXICMD_TITLEFONT,
	TEXICMD_TITLEPAGE,
	TEXICMD_TOP,
	TEXICMD_U,
	TEXICMD_UBARACCENT,
	TEXICMD_UDOTACCENT,
	TEXICMD_UMLAUT,
	TEXICMD_UNNUMBERED,
	TEXICMD_UNNUMBEREDSEC,
	TEXICMD_UNNUMBEREDSUBSEC,
	TEXICMD_UNNUMBEREDSUBSUBSEC,
	TEXICMD_UREF,
	TEXICMD_URL,
	TEXICMD_USER_INDEX,
	TEXICMD_V,
	TEXICMD_VALUE,
	TEXICMD_VAR,
	TEXICMD_VERB,
	TEXICMD_VERBATIM,
	TEXICMD_VERBATIMINCLUDE,
	TEXICMD_VINDEX,
	TEXICMD_VSKIP,
	TEXICMD_VTABLE,
	TEXICMD_W,
	TEXICMD_XREF,
	TEXICMD__MAX
};

enum	texisrc {
	TEXISRC_FILE,
	TEXISRC_STDIN
};

/*
 * The file currently being parsed.
 * This keeps track of our location within that file.
 */
struct	texifile {
	enum texisrc	 type; /* type of file */
	const char	*name; /* name of the file */
	size_t	  	 line; /* current line (from zero) */
	size_t	  	 col; /* current column in line (from zero) */
	char		*map; /* allocated file buffer */
	size_t		 mapsz; /* size of map */
	size_t		 mapmaxsz; /* full size of map */
	size_t		 insplice; /* how many bytes left in splice */
};

struct	texi;

/*
 * Callback for functions implementing texi commands.
 */
typedef	void (*texicmdfp)(struct texi *, enum texicmd, size_t *);

/*
 * Describes Texinfo commands, whether native or overriden.
 */
struct	texitok {
	texicmdfp	 fp; /* callback (or NULL if none) */
	const char	*tok; /* name of the token */
	size_t		 len; /* strlen(tok) */
};

/*
 * These values instruct us on whether a list (or table) of some type is
 * currently being parsed.
 */
enum	texilist {
	TEXILIST_NONE = 0,
	TEXILIST_ITEM,
	TEXILIST_NOITEM,
	TEXILIST_TABLE
};

/*
 * Hold values assigned with @set and retrieved with @value.
 * These values can contain arbitrary Texinfo.
 */
struct	texivalue {
	char		*key; /* the nil-terminated value name */
	char		*value; /* the nil-terminated value */
};

/*
 * Macros are (possibly-recursive) Texinfo sequences created with @macro
 * and filled in by arguments when invoked.
 */
struct	teximacro {
	char		 *key; /* nil-terminated macro name */
	char		 *value; /* nil-terminated value */
	char		**args; /* array of argument names (or NULL) */
	size_t		  argsz; /* array size */
};

/*
 * The main parse structure.
 * This keeps any necessary information handy.
 */
struct	texi {
	struct texifile   files[64]; /* stack of open files */
	size_t		  filepos; /* number of open files */
	const char	 *valstack[64]; /* stack of opened values */
	size_t		  valstackpos; /* position in valstack */
	size_t		  outcol; /* column in output line */
	char		**dirs; /* texi directories */
	size_t		  dirsz; /* number of texi directories */
	char		 *title; /* title of document */
	char		 *subtitle; /* subtitle of document */
	int		  secoffs; /* see sectioner() */
	char		**indexs; /* @defindex indices */
	size_t		  indexsz; /* entries in indexs */
	struct texivalue *vals; /* @value entries */
	size_t		  valsz; /* entries in vals */
	struct teximacro *macros; /* @macro entries */
	size_t		  macrosz; /* entries in macros */
	/*
	 * The following control what we output to the screen.
	 * The complexity is required to accomodate for mdoc(7).
	 */
	enum texilist	  list; /* current list (set recursively) */
	int		  outmacro; /* if >0, output is in line macro */
	int		  seenws; /* ws has been seen (and ignored) */
	int		  seenvs; /* newline has been Pp'd */
	int		  ign; /* if >0, don't print anything */
	int		  literal; /* if >0, literal context */
};

#define	BUF(_p) ((_p)->files[(_p)->filepos - 1].map)
#define	BUFSZ(_p) ((_p)->files[(_p)->filepos - 1].mapsz)

#define	isws(_x) \
	(' ' == (_x) || '\t' == (_x))
#define	ismspace(_x) \
	(isws((_x)) || '\n' == (_x))

__BEGIN_DECLS

void	advance(struct texi *, size_t *);
size_t	advanceeoln(struct texi *, size_t *, int);
void	advanceto(struct texi *, size_t *, size_t);

char  **argparse(struct texi *, size_t *, size_t *, size_t);

int	parsearg(struct texi *, size_t *, size_t);
void	parsebracket(struct texi *, size_t *);
void	parsestdin(struct texi *);
void	parsefile(struct texi *, const char *, int);
int	parselinearg(struct texi *, size_t *);
void	parseeoln(struct texi *, size_t *);
void	parseto(struct texi *, size_t *, const char *);

void	texiabort(struct texi *, const char *)
		__attribute__((noreturn));
enum texicmd
	texicmd(struct texi *, size_t, 
		size_t *, struct teximacro **);
void	texierr(struct texi *, const char *, ...)
		__attribute__((format(printf, 2, 3)))
		__attribute__((noreturn));
void	texiexit(struct texi *p);
void	texifilepop(struct texi *);
void	teximacro(struct texi *, const char *);
void	teximacroclose(struct texi *);
void	teximacroopen(struct texi *, const char *);
void 	texipunctuate(struct texi *, size_t *);
void	texiputbuf(struct texi *p, size_t, size_t);
void	texiputchar(struct texi *p, char);
void	texiputchars(struct texi *, const char *);
void	texivspace(struct texi *);
void	texiwarn(const struct texi *, const char *, ...)
		__attribute__((format(printf, 2, 3)));
void	texisplice(struct texi *, const char *, size_t, size_t *);

void	valueadd(struct texi *, char *, char *);
const char *
	valueblookup(struct texi *, size_t *);
void	valuelclear(struct texi *, size_t *);
const char *
	valuellookup(struct texi *, size_t *);

extern	const struct texitok *const texitoks;

__END_DECLS

#endif
