# Contributing to Terraform - AWS Provider

**First:** if you're unsure or afraid of _anything_, ask for help! You can
submit a work in progress (WIP) pull request, or file an issue with the parts
you know. We'll do our best to guide you in the right direction, and let you
know if there are guidelines we will need to follow. We want people to be able
to participate without fear of doing the wrong thing.

Below are our expectations for contributors. Following these guidelines gives us
the best opportunity to work with you, by making sure we have the things we need
in order to make it happen. Doing your best to follow it will speed up our
ability to merge PRs and respond to issues.

- [Development Environment Setup](DEVELOPMENT.md)
- [Issue Reporting and Lifecycle](contributing/issue-reporting-and-lifecycle.md)
- [Pull Request Submission and Lifecycle](contributing/pullrequest-submission-and-lifecycle.md)
- [Contribution Types and Checklists](contributing/contribution-checklists.md)

This documentation also contains reference material specific to certain functionality:

- [Provider Design](contributing/provider-design.md)
- [Running and Writing Acceptance Tests](contributing/running-and-writing-acceptance-tests.md)
- [Data Handling and Conversion](contributing/data-handling-and-conversion.md)
- [Error Handling](contributing/error-handling.md)
