/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.BasicAWSCredentials;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.profile.ProfileCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.client.builder.AwsClientBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.regions.Regions;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.streaming.connectors.kinesis.config.AWSConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.util.BeanDeserializerModifierForIgnorables;

@Internal
public class AWSUtil {
    private static final String USER_AGENT_FORMAT = "Apache Flink %s (%s) Kinesis Connector";
    public static final String AWS_CLIENT_CONFIG_PREFIX = "aws.clientconfig.";

    public static AmazonKinesis createKinesisClient(Properties configProps) {
        return AWSUtil.createKinesisClient(configProps, new ClientConfigurationFactory().getConfig());
    }

    public static AmazonKinesis createKinesisClient(Properties configProps, ClientConfiguration awsClientConfig) {
        awsClientConfig.setUserAgentPrefix(String.format(USER_AGENT_FORMAT, EnvironmentInformation.getVersion(), EnvironmentInformation.getRevisionInformation().commitId));
        AmazonKinesisClientBuilder builder = (AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials(AWSUtil.getCredentialsProvider(configProps))).withClientConfiguration(awsClientConfig);
        if (configProps.containsKey("aws.endpoint")) {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(configProps.getProperty("aws.endpoint"), null));
        } else {
            builder.withRegion(Regions.fromName(configProps.getProperty("aws.region")));
        }
        return (AmazonKinesis)builder.build();
    }

    public static AWSCredentialsProvider getCredentialsProvider(Properties configProps) {
        return AWSUtil.getCredentialsProvider(configProps, "aws.credentials.provider");
    }

    private static AWSCredentialsProvider getCredentialsProvider(final Properties configProps, final String configPrefix) {
        AWSConfigConstants.CredentialProvider credentialProviderType = !configProps.containsKey(configPrefix) ? (configProps.containsKey(AWSConfigConstants.accessKeyId(configPrefix)) && configProps.containsKey(AWSConfigConstants.secretKey(configPrefix)) ? AWSConfigConstants.CredentialProvider.BASIC : AWSConfigConstants.CredentialProvider.AUTO) : AWSConfigConstants.CredentialProvider.valueOf(configProps.getProperty(configPrefix));
        switch (credentialProviderType) {
            case ENV_VAR: {
                return new EnvironmentVariableCredentialsProvider();
            }
            case SYS_PROP: {
                return new SystemPropertiesCredentialsProvider();
            }
            case PROFILE: {
                String profileName = configProps.getProperty(AWSConfigConstants.profileName(configPrefix), null);
                String profileConfigPath = configProps.getProperty(AWSConfigConstants.profilePath(configPrefix), null);
                return profileConfigPath == null ? new ProfileCredentialsProvider(profileName) : new ProfileCredentialsProvider(profileConfigPath, profileName);
            }
            case BASIC: {
                return new AWSCredentialsProvider(){

                    @Override
                    public AWSCredentials getCredentials() {
                        return new BasicAWSCredentials(configProps.getProperty(AWSConfigConstants.accessKeyId(configPrefix)), configProps.getProperty(AWSConfigConstants.secretKey(configPrefix)));
                    }

                    @Override
                    public void refresh() {
                    }
                };
            }
            case ASSUME_ROLE: {
                AWSSecurityTokenService baseCredentials = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(AWSUtil.getCredentialsProvider(configProps, AWSConfigConstants.roleCredentialsProvider(configPrefix)))).withRegion(configProps.getProperty("aws.region"))).build();
                return new STSAssumeRoleSessionCredentialsProvider.Builder(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix)), configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix))).withExternalId(configProps.getProperty(AWSConfigConstants.externalId(configPrefix))).withStsClient(baseCredentials).build();
            }
        }
        return new DefaultAWSCredentialsProviderChain();
    }

    public static boolean isValidRegion(String region) {
        try {
            Regions.fromName(region.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static void setAwsClientConfigProperties(ClientConfiguration config, Properties configProps) {
        HashMap<String, Object> awsConfigProperties = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : configProps.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(AWS_CLIENT_CONFIG_PREFIX)) continue;
            awsConfigProperties.put(key.substring(AWS_CLIENT_CONFIG_PREFIX.length()), entry.getValue());
        }
        String[] ignorableProperties = new String[]{"secureRandom"};
        BeanDeserializerModifierForIgnorables modifier = new BeanDeserializerModifierForIgnorables(ClientConfiguration.class, ignorableProperties);
        DeserializerFactory factory = BeanDeserializerFactory.instance.withDeserializerModifier(modifier);
        ObjectMapper mapper = new ObjectMapper(null, null, new DefaultDeserializationContext.Impl(factory));
        JsonNode propTree = mapper.convertValue(awsConfigProperties, JsonNode.class);
        try {
            mapper.readerForUpdating(config).readValue(propTree);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

