/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.model;

import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamShardHandle {
    private final String streamName;
    private final Shard shard;
    private final int cachedHash;

    public StreamShardHandle(String streamName, Shard shard) {
        this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
        this.shard = (Shard)Preconditions.checkNotNull((Object)shard);
        int hash = 17;
        hash = 37 * hash + streamName.hashCode();
        this.cachedHash = hash = 37 * hash + shard.getShardId().hashCode();
    }

    public String getStreamName() {
        return this.streamName;
    }

    public boolean isClosed() {
        return this.shard.getSequenceNumberRange().getEndingSequenceNumber() != null;
    }

    public Shard getShard() {
        return this.shard;
    }

    public String toString() {
        return "StreamShardHandle{streamName='" + this.streamName + "', shard='" + this.shard.toString() + "'}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StreamShardHandle)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        StreamShardHandle other = (StreamShardHandle)obj;
        return this.streamName.equals(other.getStreamName()) && this.shard.equals(other.getShard());
    }

    public int hashCode() {
        return this.cachedHash;
    }

    public static int compareShardIds(String firstShardId, String secondShardId) {
        return firstShardId.compareTo(secondShardId);
    }
}

