/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.config;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.connectors.kinesis.config.AWSConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.model.SentinelSequenceNumber;

@PublicEvolving
public class ConsumerConfigConstants
extends AWSConfigConstants {
    public static final String STREAM_INITIAL_POSITION = "flink.stream.initpos";
    public static final String STREAM_INITIAL_TIMESTAMP = "flink.stream.initpos.timestamp";
    public static final String STREAM_TIMESTAMP_DATE_FORMAT = "flink.stream.initpos.timestamp.format";
    public static final String STREAM_DESCRIBE_BACKOFF_BASE = "flink.stream.describe.backoff.base";
    public static final String STREAM_DESCRIBE_BACKOFF_MAX = "flink.stream.describe.backoff.max";
    public static final String STREAM_DESCRIBE_BACKOFF_EXPONENTIAL_CONSTANT = "flink.stream.describe.backoff.expconst";
    public static final String LIST_SHARDS_RETRIES = "flink.list.shards.maxretries";
    public static final String LIST_SHARDS_BACKOFF_BASE = "flink.list.shards.backoff.base";
    public static final String LIST_SHARDS_BACKOFF_MAX = "flink.list.shards.backoff.max";
    public static final String LIST_SHARDS_BACKOFF_EXPONENTIAL_CONSTANT = "flink.list.shards.backoff.expconst";
    public static final String SHARD_GETRECORDS_MAX = "flink.shard.getrecords.maxrecordcount";
    public static final String SHARD_GETRECORDS_RETRIES = "flink.shard.getrecords.maxretries";
    public static final String SHARD_GETRECORDS_BACKOFF_BASE = "flink.shard.getrecords.backoff.base";
    public static final String SHARD_GETRECORDS_BACKOFF_MAX = "flink.shard.getrecords.backoff.max";
    public static final String SHARD_GETRECORDS_BACKOFF_EXPONENTIAL_CONSTANT = "flink.shard.getrecords.backoff.expconst";
    public static final String SHARD_GETRECORDS_INTERVAL_MILLIS = "flink.shard.getrecords.intervalmillis";
    public static final String SHARD_GETITERATOR_RETRIES = "flink.shard.getiterator.maxretries";
    public static final String SHARD_GETITERATOR_BACKOFF_BASE = "flink.shard.getiterator.backoff.base";
    public static final String SHARD_GETITERATOR_BACKOFF_MAX = "flink.shard.getiterator.backoff.max";
    public static final String SHARD_GETITERATOR_BACKOFF_EXPONENTIAL_CONSTANT = "flink.shard.getiterator.backoff.expconst";
    public static final String SHARD_DISCOVERY_INTERVAL_MILLIS = "flink.shard.discovery.intervalmillis";
    public static final String SHARD_USE_ADAPTIVE_READS = "flink.shard.adaptivereads";
    public static final String SHARD_IDLE_INTERVAL_MILLIS = "flink.shard.idle.interval";
    public static final String WATERMARK_SYNC_MILLIS = "flink.watermark.sync.interval";
    public static final String WATERMARK_LOOKAHEAD_MILLIS = "flink.watermark.lookahead.millis";
    public static final String WATERMARK_SYNC_QUEUE_CAPACITY = "flink.watermark.sync.queue.capacity";
    public static final String DEFAULT_STREAM_INITIAL_POSITION = InitialPosition.LATEST.toString();
    public static final String DEFAULT_STREAM_TIMESTAMP_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final long DEFAULT_STREAM_DESCRIBE_BACKOFF_BASE = 1000L;
    public static final long DEFAULT_STREAM_DESCRIBE_BACKOFF_MAX = 5000L;
    public static final double DEFAULT_STREAM_DESCRIBE_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final long DEFAULT_LIST_SHARDS_BACKOFF_BASE = 1000L;
    public static final long DEFAULT_LIST_SHARDS_BACKOFF_MAX = 5000L;
    public static final double DEFAULT_LIST_SHARDS_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final int DEFAULT_LIST_SHARDS_RETRIES = 10;
    public static final int DEFAULT_SHARD_GETRECORDS_MAX = 10000;
    public static final int DEFAULT_SHARD_GETRECORDS_RETRIES = 3;
    public static final long DEFAULT_SHARD_GETRECORDS_BACKOFF_BASE = 300L;
    public static final long DEFAULT_SHARD_GETRECORDS_BACKOFF_MAX = 1000L;
    public static final double DEFAULT_SHARD_GETRECORDS_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final long DEFAULT_SHARD_GETRECORDS_INTERVAL_MILLIS = 200L;
    public static final int DEFAULT_SHARD_GETITERATOR_RETRIES = 3;
    public static final long DEFAULT_SHARD_GETITERATOR_BACKOFF_BASE = 300L;
    public static final long DEFAULT_SHARD_GETITERATOR_BACKOFF_MAX = 1000L;
    public static final double DEFAULT_SHARD_GETITERATOR_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final long DEFAULT_SHARD_DISCOVERY_INTERVAL_MILLIS = 10000L;
    public static final boolean DEFAULT_SHARD_USE_ADAPTIVE_READS = false;
    public static final long DEFAULT_SHARD_IDLE_INTERVAL_MILLIS = -1L;
    public static final long DEFAULT_WATERMARK_SYNC_MILLIS = 30000L;
    public static final long MAX_SHARD_GETRECORDS_INTERVAL_MILLIS = 300000L;

    public static enum InitialPosition {
        TRIM_HORIZON(SentinelSequenceNumber.SENTINEL_EARLIEST_SEQUENCE_NUM),
        LATEST(SentinelSequenceNumber.SENTINEL_LATEST_SEQUENCE_NUM),
        AT_TIMESTAMP(SentinelSequenceNumber.SENTINEL_AT_TIMESTAMP_SEQUENCE_NUM);

        private SentinelSequenceNumber sentinelSequenceNumber;

        private InitialPosition(SentinelSequenceNumber sentinelSequenceNumber) {
            this.sentinelSequenceNumber = sentinelSequenceNumber;
        }

        public SentinelSequenceNumber toSentinelSequenceNumber() {
            return this.sentinelSequenceNumber;
        }
    }
}

