/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.util;

import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.AbortedException;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonClientException;

public enum Throwables {


    public static Throwable getRootCause(Throwable orig) {
        if (orig == null) {
            return orig;
        }
        Throwable t = orig;
        for (int i2 = 0; i2 < 1000; ++i2) {
            Throwable cause = t.getCause();
            if (cause == null) {
                return t;
            }
            t = cause;
        }
        LogFactory.getLog(Throwables.class).debug("Possible circular reference detected on " + orig.getClass() + ": [" + orig + "]");
        return orig;
    }

    public static RuntimeException failure(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        return t instanceof InterruptedException ? new AbortedException(t) : new AmazonClientException(t);
    }

    public static RuntimeException failure(Throwable t, String errmsg) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        return t instanceof InterruptedException ? new AbortedException(errmsg, t) : new AmazonClientException(errmsg, t);
    }
}

