/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.auth;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.RegionAwareSigner;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.Signer;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.auth.SignerProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.auth.SignerProviderContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.ServiceUtils;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.AwsHostNameUtils;

public class S3SignerProvider
extends SignerProvider {
    private static Log log = LogFactory.getLog(S3SignerProvider.class);
    private final AmazonWebServiceClient awsClient;
    private Signer signer;

    public S3SignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.signer = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext signerProviderContext) {
        URI uri = signerProviderContext.getUri();
        if (uri == null || ServiceUtils.isS3AccelerateEndpoint(uri.getHost()) || this.isSignerRegionOverrideSet()) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(AwsHostNameUtils.parseRegionName(uri.getHost(), "s3"));
            }
            catch (RuntimeException e) {
                log.warn("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region", e);
            }
        }
        return this.signer;
    }

    private boolean isSignerRegionOverrideSet() {
        return this.awsClient != null && this.awsClient.getSignerRegionOverride() != null;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }
}

