/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.multilang;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.multilang.MultiLangRecordProcessor;

public class MultiLangRecordProcessorFactory
implements IRecordProcessorFactory {
    private static final Log LOG = LogFactory.getLog(MultiLangRecordProcessorFactory.class);
    private static final String COMMAND_DELIMETER_REGEX = " +";
    private final String command;
    private final String[] commandArray;
    private final ObjectMapper objectMapper;
    private final ExecutorService executorService;
    private final KinesisClientLibConfiguration configuration;

    public MultiLangRecordProcessorFactory(String command, ExecutorService executorService, KinesisClientLibConfiguration configuration) {
        this(command, executorService, new ObjectMapper(), configuration);
    }

    public MultiLangRecordProcessorFactory(String command, ExecutorService executorService, ObjectMapper objectMapper, KinesisClientLibConfiguration configuration) {
        this.command = command;
        this.commandArray = command.split(COMMAND_DELIMETER_REGEX);
        this.executorService = executorService;
        this.objectMapper = objectMapper;
        this.configuration = configuration;
    }

    @Override
    public IRecordProcessor createProcessor() {
        LOG.debug(String.format("Creating new record processor for client executable: %s", this.command));
        return new MultiLangRecordProcessor(new ProcessBuilder(this.commandArray), this.executorService, this.objectMapper, this.configuration);
    }

    String[] getCommandArray() {
        return this.commandArray;
    }
}

