/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StandardUnit;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.AccumulateByNameMetricsScope;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;

public class FilteringMetricsScope
extends AccumulateByNameMetricsScope {
    private final MetricsLevel metricsLevel;
    private final Set<String> metricsEnabledDimensions;
    private final boolean metricsEnabledDimensionsAll;

    public FilteringMetricsScope() {
        this(MetricsLevel.DETAILED, ImmutableSet.of("ALL"));
    }

    public FilteringMetricsScope(MetricsLevel metricsLevel, Set<String> metricsEnabledDimensions) {
        this.metricsLevel = metricsLevel;
        this.metricsEnabledDimensions = metricsEnabledDimensions;
        this.metricsEnabledDimensionsAll = metricsEnabledDimensions != null && metricsEnabledDimensions.contains("ALL");
    }

    @Override
    public void addData(String name, double value, StandardUnit unit) {
        this.addData(name, value, unit, MetricsLevel.DETAILED);
    }

    @Override
    public void addData(String name, double value, StandardUnit unit, MetricsLevel level) {
        if (level.getValue() < this.metricsLevel.getValue()) {
            return;
        }
        super.addData(name, value, unit);
    }

    @Override
    public void addDimension(String name, String value) {
        if (!(this.metricsEnabledDimensionsAll || this.metricsEnabledDimensions != null && this.metricsEnabledDimensions.contains(name))) {
            return;
        }
        super.addDimension(name, value);
    }
}

