/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.ICWMetricsPublisher;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.MetricAccumulatingQueue;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.MetricDatumWithKey;

public class CWPublisherRunnable<KeyType>
implements Runnable {
    private static final Log LOG = LogFactory.getLog(CWPublisherRunnable.class);
    private final ICWMetricsPublisher<KeyType> metricsPublisher;
    private final MetricAccumulatingQueue<KeyType> queue;
    private final long bufferTimeMillis;
    private int flushSize;
    private boolean shuttingDown = false;
    private boolean shutdown = false;
    private long lastFlushTime = Long.MAX_VALUE;
    private int maxJitter;
    private Random rand = new Random();
    private int nextJitterValueToUse = 0;

    public CWPublisherRunnable(ICWMetricsPublisher<KeyType> metricsPublisher, long bufferTimeMillis, int maxQueueSize, int batchSize) {
        this(metricsPublisher, bufferTimeMillis, maxQueueSize, batchSize, 0);
    }

    public CWPublisherRunnable(ICWMetricsPublisher<KeyType> metricsPublisher, long bufferTimeMillis, int maxQueueSize, int batchSize, int maxJitter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Constructing CWPublisherRunnable with maxBufferTimeMillis %d maxQueueSize %d batchSize %d maxJitter %d", bufferTimeMillis, maxQueueSize, batchSize, maxJitter));
        }
        this.metricsPublisher = metricsPublisher;
        this.bufferTimeMillis = bufferTimeMillis;
        this.queue = new MetricAccumulatingQueue(maxQueueSize);
        this.flushSize = batchSize;
        this.maxJitter = maxJitter;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                this.runOnce();
            }
            catch (Throwable t) {
                LOG.error("Encountered throwable in CWPublisherRunable", t);
            }
        }
        LOG.info("CWPublication thread finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnce() {
        List<MetricDatumWithKey<KeyType>> dataToPublish = null;
        MetricAccumulatingQueue<KeyType> metricAccumulatingQueue = this.queue;
        synchronized (metricAccumulatingQueue) {
            long timeSinceFlush = Math.max(0L, this.getTime() - this.lastFlushTime);
            if (timeSinceFlush >= this.bufferTimeMillis || this.queue.size() >= this.flushSize || this.shuttingDown) {
                dataToPublish = this.queue.drain(this.flushSize);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Drained %d datums from queue", dataToPublish.size()));
                }
                if (this.shuttingDown) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Shutting down with %d datums left on the queue", this.queue.size()));
                    }
                    this.shutdown = this.queue.isEmpty();
                }
            } else {
                long waitTime = this.bufferTimeMillis - timeSinceFlush;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Waiting up to %dms for %d more datums to appear.", waitTime, this.flushSize - this.queue.size()));
                }
                try {
                    this.queue.wait(waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (dataToPublish != null) {
            try {
                this.metricsPublisher.publishMetrics(dataToPublish);
            }
            catch (Throwable t) {
                LOG.error("Caught exception thrown by metrics Publisher in CWPublisherRunnable", t);
            }
            this.lastFlushTime = this.getTime() + (long)this.nextJitterValueToUse;
            if (this.maxJitter != 0) {
                this.nextJitterValueToUse = this.maxJitter - this.rand.nextInt(2 * this.maxJitter);
            }
        }
    }

    protected long getTime() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LOG.info("Shutting down CWPublication thread.");
        MetricAccumulatingQueue<KeyType> metricAccumulatingQueue = this.queue;
        synchronized (metricAccumulatingQueue) {
            this.shuttingDown = true;
            this.queue.notify();
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Collection<MetricDatumWithKey<KeyType>> data) {
        MetricAccumulatingQueue<KeyType> metricAccumulatingQueue = this.queue;
        synchronized (metricAccumulatingQueue) {
            if (this.shuttingDown) {
                LOG.warn(String.format("Dropping metrics %s because CWPublisherRunnable is shutting down.", data));
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Enqueueing %d datums for publication", data.size()));
            }
            for (MetricDatumWithKey<KeyType> datumWithKey : data) {
                if (this.queue.offer(datumWithKey.key, datumWithKey.datum)) continue;
                LOG.warn("Metrics queue full - dropping metric " + datumWithKey.datum);
            }
            if (this.lastFlushTime == Long.MAX_VALUE) {
                this.lastFlushTime = this.getTime();
            }
            this.queue.notify();
        }
    }
}

