/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLeaseSerializer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.LeaseManager;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.interfaces.IKinesisClientLeaseManager;

public class KinesisClientLeaseManager
extends LeaseManager<KinesisClientLease>
implements IKinesisClientLeaseManager {
    private static final Log LOG = LogFactory.getLog(KinesisClientLeaseManager.class);

    public KinesisClientLeaseManager(String table, AmazonDynamoDB dynamoDBClient) {
        this(table, dynamoDBClient, false);
    }

    public KinesisClientLeaseManager(String table, AmazonDynamoDB dynamoDBClient, boolean consistentReads) {
        super(table, dynamoDBClient, new KinesisClientLeaseSerializer(), consistentReads);
    }

    @Override
    public boolean takeLease(KinesisClientLease lease, String newOwner) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        String oldOwner = lease.getLeaseOwner();
        boolean result = super.takeLease(lease, newOwner);
        if (oldOwner != null && !oldOwner.equals(newOwner)) {
            lease.setOwnerSwitchesSinceCheckpoint(lease.getOwnerSwitchesSinceCheckpoint() + 1L);
        }
        return result;
    }

    @Override
    public ExtendedSequenceNumber getCheckpoint(String shardId) throws ProvisionedThroughputException, InvalidStateException, DependencyException {
        ExtendedSequenceNumber checkpoint = null;
        KinesisClientLease lease = (KinesisClientLease)this.getLease(shardId);
        if (lease != null) {
            checkpoint = lease.getCheckpoint();
        }
        return checkpoint;
    }
}

