/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.waiters.DescribeTableFunction;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.waiters.TableExists;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.waiters.TableNotExists;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.PollingStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.Waiter;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.WaiterBuilder;

public class AmazonDynamoDBWaiters {
    private final AmazonDynamoDB client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonDynamoDBWaiters(AmazonDynamoDB client) {
        this.client = client;
    }

    public Waiter<DescribeTableRequest> tableExists() {
        return new WaiterBuilder<DescribeTableRequest, DescribeTableResult>().withSdkFunction(new DescribeTableFunction(this.client)).withAcceptors(new TableExists.IsACTIVEMatcher(), new TableExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTableRequest> tableNotExists() {
        return new WaiterBuilder<DescribeTableRequest, DescribeTableResult>().withSdkFunction(new DescribeTableFunction(this.client)).withAcceptors(new TableNotExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

