/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Record;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamRecord;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamViewType;

public class RecordObjectMapper
extends ObjectMapper {
    public static final String L = "L";
    public static final String M = "M";
    public static final String BS = "BS";
    public static final String NS = "NS";
    public static final String SS = "SS";
    public static final String BOOL = "BOOL";
    public static final String NULL = "NULL";
    public static final String B = "B";
    public static final String N = "N";
    public static final String S = "S";
    public static final String OLD_IMAGE = "OldImage";
    public static final String NEW_IMAGE = "NewImage";
    public static final String STREAM_VIEW_TYPE = "StreamViewType";
    public static final String OPERATION_TYPE = "OperationType";
    public static final String SEQUENCE_NUMBER = "SequenceNumber";
    public static final String SIZE_BYTES = "SizeBytes";
    public static final String KEYS = "Keys";
    public static final String AWS_REGION = "awsRegion";
    public static final String DYNAMODB = "dynamodb";
    public static final String EVENT_ID = "eventID";
    public static final String EVENT_NAME = "eventName";
    public static final String EVENT_SOURCE = "eventSource";
    public static final String EVENT_VERSION = "eventVersion";
    public static final String APPROXIMATE_CREATION_DATE_TIME = "ApproximateCreationDateTime";
    private static final String MODULE = "custom";

    public RecordObjectMapper() {
        SimpleModule module = new SimpleModule(MODULE, Version.unknownVersion());
        module.addSerializer(ByteBuffer.class, new ByteBufferSerializer());
        module.addDeserializer(ByteBuffer.class, new ByteBufferDeserializer());
        module.addSerializer(Date.class, DateSerializer.instance);
        module.addDeserializer(Date.class, new DateDeserializers.DateDeserializer());
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.addMixIn(AttributeValue.class, AttributeValueMixIn.class);
        this.addMixIn(Record.class, RecordMixIn.class);
        this.addMixIn(StreamRecord.class, StreamRecordMixIn.class);
    }

    private static abstract class AttributeValueMixIn {
        private AttributeValueMixIn() {
        }

        @JsonProperty(value="S")
        public abstract String getS();

        @JsonProperty(value="S")
        public abstract void setS(String var1);

        @JsonProperty(value="N")
        public abstract String getN();

        @JsonProperty(value="N")
        public abstract void setN(String var1);

        @JsonProperty(value="B")
        public abstract ByteBuffer getB();

        @JsonProperty(value="B")
        public abstract void setB(ByteBuffer var1);

        @JsonProperty(value="NULL")
        public abstract Boolean isNULL();

        @JsonProperty(value="NULL")
        public abstract void setNULL(Boolean var1);

        @JsonProperty(value="BOOL")
        public abstract Boolean getBOOL();

        @JsonProperty(value="BOOL")
        public abstract void setBOOL(Boolean var1);

        @JsonProperty(value="SS")
        public abstract List<String> getSS();

        @JsonProperty(value="SS")
        public abstract void setSS(List<String> var1);

        @JsonProperty(value="NS")
        public abstract List<String> getNS();

        @JsonProperty(value="NS")
        public abstract void setNS(List<String> var1);

        @JsonProperty(value="BS")
        public abstract List<String> getBS();

        @JsonProperty(value="BS")
        public abstract void setBS(List<String> var1);

        @JsonProperty(value="M")
        public abstract Map<String, AttributeValue> getM();

        @JsonProperty(value="M")
        public abstract void setM(Map<String, AttributeValue> var1);

        @JsonProperty(value="L")
        public abstract List<AttributeValue> getL();

        @JsonProperty(value="L")
        public abstract void setL(List<AttributeValue> var1);
    }

    private static abstract class StreamRecordMixIn {
        private StreamRecordMixIn() {
        }

        @JsonProperty(value="SizeBytes")
        public abstract Long getSizeBytes();

        @JsonProperty(value="SizeBytes")
        public abstract void setSizeBytes(Long var1);

        @JsonProperty(value="SequenceNumber")
        public abstract String getSequenceNumber();

        @JsonProperty(value="SequenceNumber")
        public abstract void setSequenceNumber(String var1);

        @JsonProperty(value="StreamViewType")
        public abstract StreamViewType getStreamViewTypeEnum();

        @JsonProperty(value="StreamViewType")
        public abstract void setStreamViewType(StreamViewType var1);

        @JsonProperty(value="Keys")
        public abstract Map<String, AttributeValue> getKeys();

        @JsonProperty(value="Keys")
        public abstract void setKeys(Map<String, AttributeValue> var1);

        @JsonProperty(value="NewImage")
        public abstract Map<String, AttributeValue> getNewImage();

        @JsonProperty(value="NewImage")
        public abstract void setNewImage(Map<String, AttributeValue> var1);

        @JsonProperty(value="OldImage")
        public abstract Map<String, AttributeValue> getOldImage();

        @JsonProperty(value="OldImage")
        public abstract void setOldImage(Map<String, AttributeValue> var1);

        @JsonProperty(value="ApproximateCreationDateTime")
        public abstract Date getApproximateCreationDateTime();

        @JsonProperty(value="ApproximateCreationDateTime")
        public abstract void setApproximateCreationDateTime(Date var1);
    }

    private static abstract class RecordMixIn {
        private RecordMixIn() {
        }

        @JsonProperty(value="awsRegion")
        public abstract String getAwsRegion();

        @JsonProperty(value="awsRegion")
        public abstract void setAwsRegion(String var1);

        @JsonProperty(value="dynamodb")
        public abstract StreamRecord getDynamodb();

        @JsonProperty(value="dynamodb")
        public abstract void setDynamodb(StreamRecord var1);

        @JsonProperty(value="eventID")
        public abstract String getEventID();

        @JsonProperty(value="eventID")
        public abstract void setEventID(String var1);

        @JsonProperty(value="eventName")
        public abstract String getEventName();

        @JsonProperty(value="eventName")
        public abstract void setEventName(String var1);

        @JsonProperty(value="eventSource")
        public abstract String getEventSource();

        @JsonProperty(value="eventSource")
        public abstract void setEventSource(String var1);

        @JsonProperty(value="eventVersion")
        public abstract String getEventVersion();

        @JsonProperty(value="eventVersion")
        public abstract void setEventVersion(String var1);
    }

    private static class ByteBufferDeserializer
    extends JsonDeserializer<ByteBuffer> {
        private ByteBufferDeserializer() {
        }

        @Override
        public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ByteBuffer.wrap(jp.getBinaryValue());
        }
    }

    private static class ByteBufferSerializer
    extends JsonSerializer<ByteBuffer> {
        private ByteBufferSerializer() {
        }

        @Override
        public void serialize(ByteBuffer value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeBinary(value.array());
        }
    }
}

