/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamSpecification;

public class CreateTableRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<AttributeDefinition> attributeDefinitions;
    private String tableName;
    private List<KeySchemaElement> keySchema;
    private List<LocalSecondaryIndex> localSecondaryIndexes;
    private List<GlobalSecondaryIndex> globalSecondaryIndexes;
    private ProvisionedThroughput provisionedThroughput;
    private StreamSpecification streamSpecification;

    public CreateTableRequest() {
    }

    public CreateTableRequest(String tableName, List<KeySchemaElement> keySchema) {
        this.setTableName(tableName);
        this.setKeySchema(keySchema);
    }

    public CreateTableRequest(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) {
        this.setAttributeDefinitions(attributeDefinitions);
        this.setTableName(tableName);
        this.setKeySchema(keySchema);
        this.setProvisionedThroughput(provisionedThroughput);
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null) {
            this.attributeDefinitions = null;
            return;
        }
        this.attributeDefinitions = new ArrayList<AttributeDefinition>(attributeDefinitions);
    }

    public CreateTableRequest withAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
        if (this.attributeDefinitions == null) {
            this.setAttributeDefinitions(new ArrayList<AttributeDefinition>(attributeDefinitions.length));
        }
        for (AttributeDefinition ele : attributeDefinitions) {
            this.attributeDefinitions.add(ele);
        }
        return this;
    }

    public CreateTableRequest withAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        this.setAttributeDefinitions(attributeDefinitions);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public CreateTableRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        this.keySchema = new ArrayList<KeySchemaElement>(keySchema);
    }

    public CreateTableRequest withKeySchema(KeySchemaElement ... keySchema) {
        if (this.keySchema == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement ele : keySchema) {
            this.keySchema.add(ele);
        }
        return this;
    }

    public CreateTableRequest withKeySchema(Collection<KeySchemaElement> keySchema) {
        this.setKeySchema(keySchema);
        return this;
    }

    public List<LocalSecondaryIndex> getLocalSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public void setLocalSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
        if (localSecondaryIndexes == null) {
            this.localSecondaryIndexes = null;
            return;
        }
        this.localSecondaryIndexes = new ArrayList<LocalSecondaryIndex>(localSecondaryIndexes);
    }

    public CreateTableRequest withLocalSecondaryIndexes(LocalSecondaryIndex ... localSecondaryIndexes) {
        if (this.localSecondaryIndexes == null) {
            this.setLocalSecondaryIndexes(new ArrayList<LocalSecondaryIndex>(localSecondaryIndexes.length));
        }
        for (LocalSecondaryIndex ele : localSecondaryIndexes) {
            this.localSecondaryIndexes.add(ele);
        }
        return this;
    }

    public CreateTableRequest withLocalSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
        this.setLocalSecondaryIndexes(localSecondaryIndexes);
        return this;
    }

    public List<GlobalSecondaryIndex> getGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
        if (globalSecondaryIndexes == null) {
            this.globalSecondaryIndexes = null;
            return;
        }
        this.globalSecondaryIndexes = new ArrayList<GlobalSecondaryIndex>(globalSecondaryIndexes);
    }

    public CreateTableRequest withGlobalSecondaryIndexes(GlobalSecondaryIndex ... globalSecondaryIndexes) {
        if (this.globalSecondaryIndexes == null) {
            this.setGlobalSecondaryIndexes(new ArrayList<GlobalSecondaryIndex>(globalSecondaryIndexes.length));
        }
        for (GlobalSecondaryIndex ele : globalSecondaryIndexes) {
            this.globalSecondaryIndexes.add(ele);
        }
        return this;
    }

    public CreateTableRequest withGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
        this.setGlobalSecondaryIndexes(globalSecondaryIndexes);
        return this;
    }

    public void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public CreateTableRequest withProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.setProvisionedThroughput(provisionedThroughput);
        return this;
    }

    public void setStreamSpecification(StreamSpecification streamSpecification) {
        this.streamSpecification = streamSpecification;
    }

    public StreamSpecification getStreamSpecification() {
        return this.streamSpecification;
    }

    public CreateTableRequest withStreamSpecification(StreamSpecification streamSpecification) {
        this.setStreamSpecification(streamSpecification);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(this.getAttributeDefinitions()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: ").append(this.getKeySchema()).append(",");
        }
        if (this.getLocalSecondaryIndexes() != null) {
            sb.append("LocalSecondaryIndexes: ").append(this.getLocalSecondaryIndexes()).append(",");
        }
        if (this.getGlobalSecondaryIndexes() != null) {
            sb.append("GlobalSecondaryIndexes: ").append(this.getGlobalSecondaryIndexes()).append(",");
        }
        if (this.getProvisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.getProvisionedThroughput()).append(",");
        }
        if (this.getStreamSpecification() != null) {
            sb.append("StreamSpecification: ").append(this.getStreamSpecification());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest)obj;
        if (other.getAttributeDefinitions() == null ^ this.getAttributeDefinitions() == null) {
            return false;
        }
        if (other.getAttributeDefinitions() != null && !other.getAttributeDefinitions().equals(this.getAttributeDefinitions())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !other.getKeySchema().equals(this.getKeySchema())) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() == null ^ this.getLocalSecondaryIndexes() == null) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() != null && !other.getLocalSecondaryIndexes().equals(this.getLocalSecondaryIndexes())) {
            return false;
        }
        if (other.getGlobalSecondaryIndexes() == null ^ this.getGlobalSecondaryIndexes() == null) {
            return false;
        }
        if (other.getGlobalSecondaryIndexes() != null && !other.getGlobalSecondaryIndexes().equals(this.getGlobalSecondaryIndexes())) {
            return false;
        }
        if (other.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (other.getProvisionedThroughput() != null && !other.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (other.getStreamSpecification() == null ^ this.getStreamSpecification() == null) {
            return false;
        }
        return other.getStreamSpecification() == null || other.getStreamSpecification().equals(this.getStreamSpecification());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeDefinitions() == null ? 0 : this.getAttributeDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : this.getKeySchema().hashCode());
        hashCode = 31 * hashCode + (this.getLocalSecondaryIndexes() == null ? 0 : this.getLocalSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalSecondaryIndexes() == null ? 0 : this.getGlobalSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.getStreamSpecification() == null ? 0 : this.getStreamSpecification().hashCode());
        return hashCode;
    }

    @Override
    public CreateTableRequest clone() {
        return (CreateTableRequest)super.clone();
    }
}

