/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.http.apache.request.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.ProxyAuthenticationMethod;
import org.apache.flink.kinesis.shaded.com.amazonaws.Request;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.RepeatableInputStreamRequestEntity;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.apache.request.impl.HttpGetWithBody;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.apache.utils.ApacheUtils;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.request.HttpRequestFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.settings.HttpClientSettings;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.FakeIOException;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.SdkHttpUtils;
import org.apache.flink.kinesis.shaded.org.apache.http.HttpEntity;
import org.apache.flink.kinesis.shaded.org.apache.http.client.config.RequestConfig;
import org.apache.flink.kinesis.shaded.org.apache.http.client.methods.HttpDelete;
import org.apache.flink.kinesis.shaded.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.flink.kinesis.shaded.org.apache.http.client.methods.HttpHead;
import org.apache.flink.kinesis.shaded.org.apache.http.client.methods.HttpOptions;
import org.apache.flink.kinesis.shaded.org.apache.http.client.methods.HttpPatch;
import org.apache.flink.kinesis.shaded.org.apache.http.client.methods.HttpPost;
import org.apache.flink.kinesis.shaded.org.apache.http.client.methods.HttpPut;
import org.apache.flink.kinesis.shaded.org.apache.http.client.methods.HttpRequestBase;

public class ApacheHttpRequestFactory
implements HttpRequestFactory<HttpRequestBase> {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final List<String> ignoreHeaders = Arrays.asList("Content-Length", "Host");

    @Override
    public HttpRequestBase create(Request<?> request, HttpClientSettings settings) throws FakeIOException {
        boolean putParamsInUri;
        URI endpoint = request.getEndpoint();
        String uri = SdkHttpUtils.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = SdkHttpUtils.encodeParameters(request);
        boolean requestHasNoPayload = request.getContent() != null;
        boolean requestIsPost = request.getHttpMethod() == HttpMethodName.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (encodedParams != null && putParamsInUri) {
            uri = uri + "?" + encodedParams;
        }
        HttpRequestBase base = this.createApacheRequest(request, uri, encodedParams);
        this.addHeadersToRequest(base, request);
        this.addRequestConfig(base, request, settings);
        return base;
    }

    private void addRequestConfig(HttpRequestBase base, Request<?> request, HttpClientSettings settings) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(settings.getConnectionPoolRequestTimeout()).setConnectTimeout(settings.getConnectionTimeout()).setSocketTimeout(settings.getSocketTimeout()).setLocalAddress(settings.getLocalAddress());
        if (HttpMethodName.PUT == request.getHttpMethod() && settings.isUseExpectContinue()) {
            requestConfigBuilder.setExpectContinueEnabled(true);
        }
        this.addProxyConfig(requestConfigBuilder, settings);
        base.setConfig(requestConfigBuilder.build());
    }

    private HttpRequestBase createApacheRequest(Request<?> request, String uri, String encodedParams) throws FakeIOException {
        switch (request.getHttpMethod()) {
            case HEAD: {
                return new HttpHead(uri);
            }
            case GET: {
                return this.wrapEntity(request, new HttpGetWithBody(uri), encodedParams);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case PATCH: {
                return this.wrapEntity(request, new HttpPatch(uri), encodedParams);
            }
            case POST: {
                return this.wrapEntity(request, new HttpPost(uri), encodedParams);
            }
            case PUT: {
                return this.wrapEntity(request, new HttpPut(uri), encodedParams);
            }
        }
        throw new SdkClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
    }

    private HttpRequestBase wrapEntity(Request<?> request, HttpEntityEnclosingRequestBase entityEnclosingRequest, String encodedParams) throws FakeIOException {
        if (HttpMethodName.POST == request.getHttpMethod()) {
            if (request.getContent() == null && encodedParams != null) {
                entityEnclosingRequest.setEntity(ApacheUtils.newStringEntity(encodedParams));
            } else {
                entityEnclosingRequest.setEntity(new RepeatableInputStreamRequestEntity(request));
            }
        } else if (request.getContent() != null) {
            HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
            if (request.getHeaders().get("Content-Length") == null) {
                entity = ApacheUtils.newBufferedHttpEntity(entity);
            }
            entityEnclosingRequest.setEntity(entity);
        }
        return entityEnclosingRequest;
    }

    private void addHeadersToRequest(HttpRequestBase httpRequest, Request<?> request) {
        httpRequest.addHeader("Host", this.getHostHeaderValue(request.getEndpoint()));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (ignoreHeaders.contains(entry.getKey())) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
        }
    }

    private String getHostHeaderValue(URI endpoint) {
        return SdkHttpUtils.isUsingNonDefaultPort(endpoint) ? endpoint.getHost() + ":" + endpoint.getPort() : endpoint.getHost();
    }

    private void addProxyConfig(RequestConfig.Builder requestConfigBuilder, HttpClientSettings settings) {
        if (settings.isProxyEnabled() && settings.isAuthenticatedProxy() && settings.getProxyAuthenticationMethods() != null) {
            ArrayList<String> apacheAuthenticationSchemes = new ArrayList<String>();
            for (ProxyAuthenticationMethod authenticationMethod : settings.getProxyAuthenticationMethods()) {
                apacheAuthenticationSchemes.add(this.toApacheAuthenticationScheme(authenticationMethod));
            }
            requestConfigBuilder.setProxyPreferredAuthSchemes(apacheAuthenticationSchemes);
        }
    }

    private String toApacheAuthenticationScheme(ProxyAuthenticationMethod authenticationMethod) {
        if (authenticationMethod == null) {
            throw new IllegalStateException("The configured proxy authentication methods must not be null.");
        }
        switch (authenticationMethod) {
            case NTLM: {
                return "NTLM";
            }
            case BASIC: {
                return "Basic";
            }
            case DIGEST: {
                return "Digest";
            }
            case SPNEGO: {
                return "Negotiate";
            }
            case KERBEROS: {
                return "Kerberos";
            }
        }
        throw new IllegalStateException("Unknown authentication scheme: " + (Object)((Object)authenticationMethod));
    }
}

