/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics;

import com.amazonaws.services.kinesisanalytics.runtime.KinesisAnalyticsRuntime;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.kinesis.FlinkKinesisConsumer;
import org.apache.flink.streaming.connectors.kinesis.FlinkKinesisProducer;

public class BasicStreamingJob {
    private static final String region = "us-east-1";
    private static final String inputStreamName = "BlakeKDATestInputStream";
    private static final String outputStreamName = "BlakeKDATestOutputStream";

    private static DataStream<String> createSourceFromStaticConfig(StreamExecutionEnvironment env) {
        Properties inputProperties = new Properties();
        inputProperties.setProperty("aws.region", region);
        inputProperties.setProperty("flink.stream.initpos", "LATEST");
        return env.addSource(new FlinkKinesisConsumer(inputStreamName, new SimpleStringSchema(), inputProperties));
    }

    private static DataStream<String> createSourceFromApplicationProperties(StreamExecutionEnvironment env) throws IOException {
        Map<String, Properties> applicationProperties = KinesisAnalyticsRuntime.getApplicationProperties();
        return env.addSource(new FlinkKinesisConsumer(inputStreamName, new SimpleStringSchema(), applicationProperties.get("ConsumerConfigProperties")));
    }

    private static FlinkKinesisProducer<String> createSinkFromStaticConfig() {
        Properties outputProperties = new Properties();
        outputProperties.setProperty("aws.region", region);
        outputProperties.setProperty("AggregationEnabled", "false");
        FlinkKinesisProducer<String> sink = new FlinkKinesisProducer<String>((SerializationSchema<String>)new SimpleStringSchema(), outputProperties);
        sink.setDefaultStream(outputStreamName);
        sink.setDefaultPartition("0");
        return sink;
    }

    private static FlinkKinesisProducer<String> createSinkFromApplicationProperties() throws IOException {
        Map<String, Properties> applicationProperties = KinesisAnalyticsRuntime.getApplicationProperties();
        FlinkKinesisProducer<String> sink = new FlinkKinesisProducer<String>((SerializationSchema<String>)new SimpleStringSchema(), applicationProperties.get("ProducerConfigProperties"));
        sink.setDefaultStream(outputStreamName);
        sink.setDefaultPartition("0");
        return sink;
    }

    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStream<String> input = BasicStreamingJob.createSourceFromStaticConfig(env);
        input.addSink(BasicStreamingJob.createSinkFromStaticConfig());
        env.execute("Flink Streaming Java API Skeleton");
    }
}

