/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.Tag;
import com.amazonaws.services.identitymanagement.model.TagUserRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TagUserRequestMarshaller
implements Marshaller<Request<TagUserRequest>, TagUserRequest> {
    @Override
    public Request<TagUserRequest> marshall(TagUserRequest tagUserRequest) {
        if (tagUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TagUserRequest> request = new DefaultRequest<TagUserRequest>(tagUserRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "TagUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagUserRequest.getUserName() != null) {
            request.addParameter("UserName", StringUtils.fromString(tagUserRequest.getUserName()));
        }
        if (!tagUserRequest.getTags().isEmpty() || !((SdkInternalList)tagUserRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)tagUserRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

