/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.Policy;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListPoliciesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Policy> policies;
    private Boolean isTruncated;
    private String marker;

    public List<Policy> getPolicies() {
        if (this.policies == null) {
            this.policies = new SdkInternalList();
        }
        return this.policies;
    }

    public void setPolicies(Collection<Policy> policies) {
        if (policies == null) {
            this.policies = null;
            return;
        }
        this.policies = new SdkInternalList<Policy>(policies);
    }

    public ListPoliciesResult withPolicies(Policy ... policies) {
        if (this.policies == null) {
            this.setPolicies(new SdkInternalList<Policy>(policies.length));
        }
        for (Policy ele : policies) {
            this.policies.add(ele);
        }
        return this;
    }

    public ListPoliciesResult withPolicies(Collection<Policy> policies) {
        this.setPolicies(policies);
        return this;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public ListPoliciesResult withIsTruncated(Boolean isTruncated) {
        this.setIsTruncated(isTruncated);
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListPoliciesResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicies() != null) {
            sb.append("Policies: ").append(this.getPolicies()).append(",");
        }
        if (this.getIsTruncated() != null) {
            sb.append("IsTruncated: ").append(this.getIsTruncated()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesResult)) {
            return false;
        }
        ListPoliciesResult other = (ListPoliciesResult)obj;
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        if (other.getPolicies() != null && !other.getPolicies().equals(this.getPolicies())) {
            return false;
        }
        if (other.getIsTruncated() == null ^ this.getIsTruncated() == null) {
            return false;
        }
        if (other.getIsTruncated() != null && !other.getIsTruncated().equals(this.getIsTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getIsTruncated() == null ? 0 : this.getIsTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListPoliciesResult clone() {
        try {
            return (ListPoliciesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

