// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// see the license for the specific language governing permissions and
// limitations under the license.

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: internal/quickstore_microservice/proto/quickstore.proto

package mako_internal_quickstore_microservice

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	quickstore_go_proto "github.com/google/mako/proto/quickstore/quickstore_go_proto"
	mako_go_proto "github.com/google/mako/spec/proto/mako_go_proto"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type StoreInput struct {
	QuickstoreInput      *quickstore_go_proto.QuickstoreInput `protobuf:"bytes,1,opt,name=quickstore_input,json=quickstoreInput" json:"quickstore_input,omitempty"`
	SamplePoints         []*mako_go_proto.SamplePoint         `protobuf:"bytes,2,rep,name=sample_points,json=samplePoints" json:"sample_points,omitempty"`
	SampleErrors         []*mako_go_proto.SampleError         `protobuf:"bytes,3,rep,name=sample_errors,json=sampleErrors" json:"sample_errors,omitempty"`
	RunAggregates        []*mako_go_proto.KeyedValue          `protobuf:"bytes,4,rep,name=run_aggregates,json=runAggregates" json:"run_aggregates,omitempty"`
	AggregateValueKeys   []string                             `protobuf:"bytes,5,rep,name=aggregate_value_keys,json=aggregateValueKeys" json:"aggregate_value_keys,omitempty"`
	AggregateValueTypes  []string                             `protobuf:"bytes,6,rep,name=aggregate_value_types,json=aggregateValueTypes" json:"aggregate_value_types,omitempty"`
	AggregateValueValues []float64                            `protobuf:"fixed64,7,rep,name=aggregate_value_values,json=aggregateValueValues" json:"aggregate_value_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *StoreInput) Reset()         { *m = StoreInput{} }
func (m *StoreInput) String() string { return proto.CompactTextString(m) }
func (*StoreInput) ProtoMessage()    {}
func (*StoreInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_80613028ee3e5eb0, []int{0}
}

func (m *StoreInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StoreInput.Unmarshal(m, b)
}
func (m *StoreInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StoreInput.Marshal(b, m, deterministic)
}
func (m *StoreInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreInput.Merge(m, src)
}
func (m *StoreInput) XXX_Size() int {
	return xxx_messageInfo_StoreInput.Size(m)
}
func (m *StoreInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreInput.DiscardUnknown(m)
}

var xxx_messageInfo_StoreInput proto.InternalMessageInfo

func (m *StoreInput) GetQuickstoreInput() *quickstore_go_proto.QuickstoreInput {
	if m != nil {
		return m.QuickstoreInput
	}
	return nil
}

func (m *StoreInput) GetSamplePoints() []*mako_go_proto.SamplePoint {
	if m != nil {
		return m.SamplePoints
	}
	return nil
}

func (m *StoreInput) GetSampleErrors() []*mako_go_proto.SampleError {
	if m != nil {
		return m.SampleErrors
	}
	return nil
}

func (m *StoreInput) GetRunAggregates() []*mako_go_proto.KeyedValue {
	if m != nil {
		return m.RunAggregates
	}
	return nil
}

func (m *StoreInput) GetAggregateValueKeys() []string {
	if m != nil {
		return m.AggregateValueKeys
	}
	return nil
}

func (m *StoreInput) GetAggregateValueTypes() []string {
	if m != nil {
		return m.AggregateValueTypes
	}
	return nil
}

func (m *StoreInput) GetAggregateValueValues() []float64 {
	if m != nil {
		return m.AggregateValueValues
	}
	return nil
}

type StoreOutput struct {
	QuickstoreOutput     *quickstore_go_proto.QuickstoreOutput `protobuf:"bytes,1,opt,name=quickstore_output,json=quickstoreOutput" json:"quickstore_output,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *StoreOutput) Reset()         { *m = StoreOutput{} }
func (m *StoreOutput) String() string { return proto.CompactTextString(m) }
func (*StoreOutput) ProtoMessage()    {}
func (*StoreOutput) Descriptor() ([]byte, []int) {
	return fileDescriptor_80613028ee3e5eb0, []int{1}
}

func (m *StoreOutput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StoreOutput.Unmarshal(m, b)
}
func (m *StoreOutput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StoreOutput.Marshal(b, m, deterministic)
}
func (m *StoreOutput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreOutput.Merge(m, src)
}
func (m *StoreOutput) XXX_Size() int {
	return xxx_messageInfo_StoreOutput.Size(m)
}
func (m *StoreOutput) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreOutput.DiscardUnknown(m)
}

var xxx_messageInfo_StoreOutput proto.InternalMessageInfo

func (m *StoreOutput) GetQuickstoreOutput() *quickstore_go_proto.QuickstoreOutput {
	if m != nil {
		return m.QuickstoreOutput
	}
	return nil
}

type ShutdownInput struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShutdownInput) Reset()         { *m = ShutdownInput{} }
func (m *ShutdownInput) String() string { return proto.CompactTextString(m) }
func (*ShutdownInput) ProtoMessage()    {}
func (*ShutdownInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_80613028ee3e5eb0, []int{2}
}

func (m *ShutdownInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShutdownInput.Unmarshal(m, b)
}
func (m *ShutdownInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShutdownInput.Marshal(b, m, deterministic)
}
func (m *ShutdownInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShutdownInput.Merge(m, src)
}
func (m *ShutdownInput) XXX_Size() int {
	return xxx_messageInfo_ShutdownInput.Size(m)
}
func (m *ShutdownInput) XXX_DiscardUnknown() {
	xxx_messageInfo_ShutdownInput.DiscardUnknown(m)
}

var xxx_messageInfo_ShutdownInput proto.InternalMessageInfo

type ShutdownOutput struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShutdownOutput) Reset()         { *m = ShutdownOutput{} }
func (m *ShutdownOutput) String() string { return proto.CompactTextString(m) }
func (*ShutdownOutput) ProtoMessage()    {}
func (*ShutdownOutput) Descriptor() ([]byte, []int) {
	return fileDescriptor_80613028ee3e5eb0, []int{3}
}

func (m *ShutdownOutput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShutdownOutput.Unmarshal(m, b)
}
func (m *ShutdownOutput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShutdownOutput.Marshal(b, m, deterministic)
}
func (m *ShutdownOutput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShutdownOutput.Merge(m, src)
}
func (m *ShutdownOutput) XXX_Size() int {
	return xxx_messageInfo_ShutdownOutput.Size(m)
}
func (m *ShutdownOutput) XXX_DiscardUnknown() {
	xxx_messageInfo_ShutdownOutput.DiscardUnknown(m)
}

var xxx_messageInfo_ShutdownOutput proto.InternalMessageInfo

func init() {
	proto.RegisterType((*StoreInput)(nil), "mako.internal.quickstore_microservice.StoreInput")
	proto.RegisterType((*StoreOutput)(nil), "mako.internal.quickstore_microservice.StoreOutput")
	proto.RegisterType((*ShutdownInput)(nil), "mako.internal.quickstore_microservice.ShutdownInput")
	proto.RegisterType((*ShutdownOutput)(nil), "mako.internal.quickstore_microservice.ShutdownOutput")
}

func init() {
	proto.RegisterFile("internal/quickstore_microservice/proto/quickstore.proto", fileDescriptor_80613028ee3e5eb0)
}

var fileDescriptor_80613028ee3e5eb0 = []byte{
	// 408 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x92, 0xcd, 0x8e, 0xda, 0x30,
	0x14, 0x85, 0x1b, 0x52, 0x5a, 0xf5, 0x52, 0xfe, 0x5c, 0xa8, 0xa2, 0xac, 0x42, 0xa4, 0x4a, 0x59,
	0x85, 0x36, 0xa2, 0x65, 0xdd, 0x45, 0x17, 0x15, 0xea, 0x5f, 0xa8, 0xba, 0xab, 0xa2, 0x28, 0x58,
	0x4c, 0x04, 0xc4, 0xc1, 0x76, 0x18, 0xe5, 0x01, 0x66, 0x1e, 0x63, 0x9e, 0x75, 0x94, 0x1b, 0x12,
	0x0c, 0x68, 0x46, 0xb0, 0xb1, 0xec, 0x7b, 0xee, 0x77, 0x7c, 0x93, 0x63, 0x98, 0xc6, 0x89, 0xa4,
	0x3c, 0x09, 0xd7, 0xe3, 0x6d, 0x16, 0x47, 0x2b, 0x21, 0x19, 0xa7, 0xc1, 0x26, 0x8e, 0x38, 0x13,
	0x94, 0xef, 0xe2, 0x88, 0x8e, 0x53, 0xce, 0x24, 0x53, 0x54, 0x17, 0x0b, 0xe4, 0xc3, 0x26, 0x5c,
	0x31, 0xb7, 0xa2, 0xdd, 0x27, 0x68, 0x73, 0x74, 0x8a, 0x9f, 0x39, 0x99, 0x43, 0x91, 0xd2, 0x68,
	0x7f, 0x0d, 0x9a, 0xe2, 0xd6, 0x7e, 0xd0, 0x01, 0xe6, 0x45, 0xdb, 0xf7, 0x24, 0xcd, 0x24, 0x99,
	0x41, 0x4f, 0xb9, 0x23, 0x2e, 0x6a, 0x86, 0x66, 0x69, 0x4e, 0xcb, 0xb3, 0x5c, 0xa4, 0x14, 0xdf,
	0x3f, 0xf5, 0x16, 0x59, 0xbf, 0xbb, 0x3d, 0x2e, 0x90, 0x2f, 0xd0, 0x16, 0xe1, 0x26, 0x5d, 0xd3,
	0x20, 0x65, 0x71, 0x22, 0x85, 0xd1, 0xb0, 0x74, 0xa7, 0xe5, 0xf5, 0x4b, 0xa7, 0x39, 0x4a, 0xbf,
	0x0b, 0xc5, 0x7f, 0x2b, 0x0e, 0x07, 0xa1, 0x70, 0x94, 0x73, 0xc6, 0x85, 0xa1, 0x9f, 0x73, 0xdf,
	0x0a, 0xa5, 0xe2, 0xf0, 0x20, 0xc8, 0x14, 0x3a, 0x3c, 0x4b, 0x82, 0x70, 0xb9, 0xe4, 0x74, 0x19,
	0x4a, 0x2a, 0x8c, 0x97, 0x08, 0xf6, 0x4a, 0x70, 0x46, 0x73, 0xba, 0xf8, 0x17, 0xae, 0x33, 0xea,
	0xb7, 0x79, 0x96, 0x7c, 0xad, 0xdb, 0xc8, 0x47, 0x18, 0xd4, 0x50, 0xb0, 0x2b, 0x3a, 0x82, 0x15,
	0xcd, 0x85, 0xd1, 0xb4, 0x74, 0xe7, 0x8d, 0x4f, 0x6a, 0x0d, 0xe1, 0x19, 0xcd, 0x05, 0xf1, 0x60,
	0x78, 0x4a, 0xc8, 0x3c, 0xa5, 0xc2, 0x78, 0x85, 0xc8, 0xbb, 0x63, 0xe4, 0x6f, 0x21, 0x91, 0x09,
	0xbc, 0x3f, 0x65, 0x70, 0x15, 0xc6, 0x6b, 0x4b, 0x77, 0x34, 0x7f, 0x70, 0x0c, 0xe1, 0x22, 0xec,
	0xff, 0xd0, 0xc2, 0x7c, 0x7e, 0x65, 0xb2, 0xf8, 0xa7, 0x3f, 0xa1, 0xaf, 0x04, 0xc4, 0xb0, 0xb8,
	0x4f, 0x68, 0xf4, 0x4c, 0x42, 0x25, 0xed, 0x2b, 0xe1, 0x96, 0x15, 0xbb, 0x0b, 0xed, 0xf9, 0x4d,
	0x26, 0x17, 0xec, 0x36, 0xc1, 0xd0, 0xec, 0x1e, 0x74, 0xaa, 0x42, 0xd9, 0xe2, 0xdd, 0x37, 0x00,
	0x0e, 0x4e, 0x24, 0x85, 0x26, 0x0e, 0x44, 0x3e, 0xb9, 0x17, 0x3d, 0x4e, 0xf7, 0xf0, 0xbc, 0x4c,
	0xef, 0x1a, 0x64, 0x3f, 0xe1, 0x0b, 0x72, 0xa7, 0xc1, 0xa0, 0x9a, 0xe9, 0x87, 0xd2, 0x46, 0x26,
	0x97, 0xda, 0xa9, 0x5f, 0x68, 0x7e, 0xbe, 0x92, 0xaa, 0xe6, 0x78, 0x0c, 0x00, 0x00, 0xff, 0xff,
	0xe2, 0xb4, 0xaf, 0x68, 0xc6, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// QuickstoreClient is the client API for Quickstore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type QuickstoreClient interface {
	Store(ctx context.Context, in *StoreInput, opts ...grpc.CallOption) (*StoreOutput, error)
	ShutdownMicroservice(ctx context.Context, in *ShutdownInput, opts ...grpc.CallOption) (*ShutdownOutput, error)
}

type quickstoreClient struct {
	cc *grpc.ClientConn
}

func NewQuickstoreClient(cc *grpc.ClientConn) QuickstoreClient {
	return &quickstoreClient{cc}
}

func (c *quickstoreClient) Store(ctx context.Context, in *StoreInput, opts ...grpc.CallOption) (*StoreOutput, error) {
	out := new(StoreOutput)
	err := c.cc.Invoke(ctx, "/mako.internal.quickstore_microservice.Quickstore/Store", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *quickstoreClient) ShutdownMicroservice(ctx context.Context, in *ShutdownInput, opts ...grpc.CallOption) (*ShutdownOutput, error) {
	out := new(ShutdownOutput)
	err := c.cc.Invoke(ctx, "/mako.internal.quickstore_microservice.Quickstore/ShutdownMicroservice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// QuickstoreServer is the server API for Quickstore service.
type QuickstoreServer interface {
	Store(context.Context, *StoreInput) (*StoreOutput, error)
	ShutdownMicroservice(context.Context, *ShutdownInput) (*ShutdownOutput, error)
}

func RegisterQuickstoreServer(s *grpc.Server, srv QuickstoreServer) {
	s.RegisterService(&_Quickstore_serviceDesc, srv)
}

func _Quickstore_Store_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoreInput)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuickstoreServer).Store(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/mako.internal.quickstore_microservice.Quickstore/Store",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuickstoreServer).Store(ctx, req.(*StoreInput))
	}
	return interceptor(ctx, in, info, handler)
}

func _Quickstore_ShutdownMicroservice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShutdownInput)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuickstoreServer).ShutdownMicroservice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/mako.internal.quickstore_microservice.Quickstore/ShutdownMicroservice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuickstoreServer).ShutdownMicroservice(ctx, req.(*ShutdownInput))
	}
	return interceptor(ctx, in, info, handler)
}

var _Quickstore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "mako.internal.quickstore_microservice.Quickstore",
	HandlerType: (*QuickstoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Store",
			Handler:    _Quickstore_Store_Handler,
		},
		{
			MethodName: "ShutdownMicroservice",
			Handler:    _Quickstore_ShutdownMicroservice_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "internal/quickstore_microservice/proto/quickstore.proto",
}
