---
layout: home
hero:
  name: Task
  text: The Modern Task Runner
  tagline:
    A fast, cross-platform build tool inspired by Make, designed for modern
    workflows.
  image:
    src: /img/logo.png
    alt: Task logo
  actions:
    - theme: brand
      text: Install
      link: /docs/installation
    - theme: alt
      text: Get Started
      link: /docs/getting-started
    - theme: alt
      text: Guide
      link: /docs/guide

features:
  - title: 30-Second Setup
    details:
      Single binary download, zero dependencies. Works with Homebrew, Snapcraft,
      Scoop and more.
    icon: 🚀

  - title: Truly cross-platform
    icon: 🖥️
    details:
      Run the same Taskfile on Linux, macOS and Windows. No extra setup. Task
      handles platform quirks so you don’t have to.

  - title: Smart Caching
    icon: 🎯
    details:
      Skip unnecessary rebuilds by tracking file changes (timestamp or
      content-based).

  - title: Ideal for code generation & scaffolding
    icon: ⚡
    details:
      Use Task to wire up codegen tools, formatters, linters, or anything
      repetitive. Chain commands, set dependencies, and keep your workflow
      clean.
---
