template = """
; This script is used by Inno Setup to create a Windows Installer.
; see http://www.jrsoftware.org/isinfo.php to download Inno Setup

[Setup]
AppName=StegaVorto
AppVerName=StegaVorto %s
VersionInfoVersion=%s.0
AppPublisher=James Paige
AppPublisherURL=http://james.hamsterrepublic.com/?p=130
AppSupportURL=http://james.hamsterrepublic.com/?p=130
AppUpdatesURL=http://james.hamsterrepublic.com/?p=130
AppReadmeFile={app}\README.txt
DefaultDirName={pf}\StegaVorto
DefaultGroupName=StegaVorto
DisableProgramGroupPage=yes
AllowNoIcons=yes
AllowUNCPath=yes
LicenseFile=LICENSE.txt
InfoAfterFile=README.txt
OutputBaseFilename=stegavorto
Compression=bzip
SolidCompression=yes
ChangesAssociations=yes
UninstallDisplayIcon={app}\stegavorto.exe

[Languages]
Name: "eng"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"

[Files]
Source: "dist\stegavorto.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "dist\MSVCR71.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "dist\w9xpopen.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "dist\library.zip"; DestDir: "{app}"; Flags: ignoreversion
Source: "dist\data\*"; DestDir: "{app}\data\"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "README.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "LICENSE.txt"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\StegaVorto"; Filename: "{app}\stegavorto.exe"; WorkingDir: "{app}"; Flags: closeonexit
Name: "{userdesktop}\StegaVorto"; Filename: "{app}\stegavorto.exe"; WorkingDir: "{app}"; Flags: closeonexit; Tasks: desktopicon
Name: "{group}\Website (Help, Updates, Source Code)"; Filename: "http://james.hamsterrepublic.com/?p=130";

[Registry]

[Run]
"""

from datetime import date
ver = date.strftime(date.today(), "%Y.%m.%d")
f = open("win-installer.iss", "w")
f.write(template % (ver, ver))
f.close()
