# Template Functions

## Reading Function Signatures

The function signatures below borrow from TypeScript to describe the arguments a function accepts and the value it returns:

```typescript
f(arg1: boolean, arg2: string[], arg3?: string): bytes
```

The function `f` accepts two required positional arguments (`arg1` and `arg2`) and one optional keyword argument (`arg3`), and returns a `bytes`.

### Types

`value` is the top-level type. It represents any [template value](../user_guide/templates/values.md).

The following types are scalar (i.e. not collections):

- `boolean`
- `float`
- `integer`
- `string`
- `bytes`

Array types accept an array of a single type: `string[]` accepts `["a", "b", "c"]` but not `["a", 1, false]`.

Type unions allow values that match _any_ of the members: `"a" | "b"` accepts the string `"a"` or the string `"b"`.

Some functions define custom types such as `JsonPath`, which are generally a narrowing of the `string` type. These will be described on a case-by-case basis in the function descriptions.

### Arguments

Arguments with a `?` are optional keyword arguments. Those without `?` are required positional arguments. See [Arguments](../user_guide/templates/functions.md#arguments) for more.

<!-- Function docs are autogenerated. See crates/core/src/render/functions.rs -->

{{#template_functions}}
