/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <atcommand.h>
#include <helper.h>

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <errno.h>

static int at_sie_blacklisted (char* model) {
  if (strcmp(model,"SF65") == 0) return 1;
  return 0;
}

int at_sie_supported () {
  char* vendor = at_get_vendor();
  char* model = at_get_model();
  int retval = 1;

  if (at_sie_blacklisted(model) || strcasecmp(vendor,"SIEMENS"))
    retval = 0;
  
  mem_realloc(vendor,0);
  mem_realloc(model,0);
  return retval;
}

char* at_sie_pref_op_read (unsigned int index1,
			   unsigned int index2)
{
  char* parmlist;
  
  if (!at_sie_supported()) return NULL;

  parmlist = mem_alloc(numlen(index1)+1+numlen(index2)+1,1);
  if (index2 > index1)
    sprintf(parmlist,"%d,%d",index1,index2);
  else
    sprintf(parmlist,"%d",index1);
  at_command_send(AT_SIE_PREF_OP_READ,parmlist);
  mem_realloc(parmlist,0);
  return AT_SIE_PREF_OP_READ;
}

char* at_sie_password (const char* lock,
		      const char* oldpin,
		      const char* newpin)
{
  char* parmlist;

  if (!at_sie_supported())
    return at_gen_password(lock,oldpin,newpin);

  if (str_len(lock) == 0 ||
      (oldpin == NULL && newpin == NULL))
    return NULL;
  parmlist = mem_alloc(1+strlen(lock)+3+str_len(oldpin)+3
		       +str_len(newpin)+1,1);
  if (oldpin == NULL) {
    //there is no pin set, yet
    sprintf(parmlist,"\"%s\",,\"%s\"",lock,newpin);
  } else {
    if (newpin == NULL) {
      //delete the pin
      sprintf(parmlist,"\"%s\",\"%s\"",lock,oldpin);
    } else {
      sprintf(parmlist,"\"%s\",\"%s\",\"%s\"",lock,oldpin,newpin);
    }
  }
  at_command_send(AT_SIE_PASSWORD,parmlist);
  mem_realloc(parmlist,0);
  return AT_SIE_PASSWORD;
}

char* at_sie_lock (const char* lock, int mode,
		   const char* password, uint8_t class)
{
  char* parmlist;

  if (str_len(lock) == 0) return NULL;

  if (!at_sie_supported())
    return at_gen_lock(lock,mode,password,class);

  parmlist = mem_alloc(1+strlen(lock)+1
		       +1+numlen(mode)
		       +2+str_len(password)+1
		       +1+numlen(class)+1,1);
  if (class > 0)
    if (str_len(password))
      sprintf(parmlist,"\"%s\",%d,\"%s\",%d",lock,mode,password,class);
    else
      sprintf(parmlist,"\"%s\",%d,,%d",lock,mode,class);
  else
    if (str_len(password))
      sprintf(parmlist,"\"%s\",%d,\"%s\"",lock,mode,password);
    else
      sprintf(parmlist,"\"%s\",%d",lock,mode);
  at_command_send(AT_SIE_LOCK,parmlist);
  mem_realloc(parmlist,0);
  return AT_SIE_LOCK;
}

char* at_sie_binary_write (const char* ftype,
			   unsigned int slot,
			   int part, int total)
{
  char* parmlist;

  if (str_len(ftype) == 0) return NULL;
  if (!at_sie_supported()) return NULL;

  parmlist = mem_alloc(1+strlen(ftype)+2+numlen(slot)
		       +1+numlen(part)+1+numlen(total)
		       +1,
		       1);
  if (part < 0 || total < 0) {
    sprintf(parmlist,"\"%s\",%d",ftype,slot);
  } else if (part == 0 || total == 0) {
    sprintf(parmlist,"\"%s\",%d,%d",ftype,slot,part);
  } else {
    sprintf(parmlist,"\"%s\",%d,%d,%d",ftype,slot,part,total);
  }
  at_command_send(AT_SIE_BIN_WRITE,parmlist);
  mem_realloc(parmlist,0);
  return AT_SIE_BIN_WRITE;
}

char* at_sie_binary_read (const char* ftype, unsigned int slot) {
  char* parmlist;

  if (str_len(ftype) == 0) return NULL;
  if (!at_sie_supported()) return NULL;

  parmlist = mem_alloc(1+strlen(ftype)+2+numlen(slot)+1, 1);
  sprintf(parmlist,"\"%s\",%d",ftype,slot);
  at_command_send(AT_SIE_BIN_READ,parmlist);
  mem_realloc(parmlist,0);
  return AT_SIE_BIN_READ;
}

char* at_sie_phonebook_vcf_read (unsigned int slot, int type) {
  char* parmlist;
  
  if (!at_sie_supported()) return NULL;

  if (type > 3 || type < 0) {
    type = -1;
    parmlist = mem_alloc(numlen(slot)+1,1);
    sprintf(parmlist,"%d",slot);
  } else {
    parmlist = mem_alloc(numlen(slot)+1+numlen(type)+1,1);
    sprintf(parmlist,"%d,%d",slot,type);
  }
  at_command_send(AT_SIE_PB_VCF_READ,parmlist);
  mem_realloc(parmlist,0);
  return AT_SIE_PB_VCF_READ;
}

char* at_sie_phonebook_read_sorted (unsigned int slot_low,
				   unsigned int slot_high)
{
  char* parmlist;

  if (!at_sie_supported()) return NULL;

  parmlist = mem_alloc(numlen(slot_low)+1
		       +numlen(slot_high)+1, 1);
  sprintf(parmlist,"%d,%d",slot_low,slot_high);
  at_command_send(AT_SIE_PB_READ_SORTED,parmlist);
  mem_realloc(parmlist,0);  
  return AT_SIE_PB_READ_SORTED;
}

char* at_sie_phonebook_select (const char* mem) {
  char* parmlist;

  if (mem == NULL) return NULL;

  if (!at_sie_supported())
    return at_gen_phonebook_select(mem);

  parmlist = mem_alloc(1+strlen(mem)+2, 1);
  sprintf(parmlist,"\"%s\"",mem);
  at_command_send(AT_SIE_PB_SELECT,parmlist);
  mem_realloc(parmlist,0);  
  return AT_SIE_PB_SELECT;
}

char* at_sie_sms_slot_read (unsigned int slot) {
  char* parmlist;

  if (!at_sie_supported()) return NULL;

  parmlist = mem_alloc(numlen(slot)+1,1);
  sprintf(parmlist,"%d",slot);
  at_command_send(AT_SIE_SMS_SLOT_READ,parmlist);
  mem_realloc(parmlist,0);  
  return AT_SIE_SMS_SLOT_READ;
}

char* at_sie_sms_list_read (unsigned int list_id) {
  char* parmlist;

  if (!at_sie_supported()) return NULL;

  parmlist = mem_alloc(numlen(list_id)+1,1);
  sprintf(parmlist,"%d",list_id);
  at_command_send(AT_SIE_SMS_LIST_READ,parmlist);
  mem_realloc(parmlist,0);  
  return AT_SIE_SMS_LIST_READ;
}
