<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw webhosting`
Web Hosting API.
  
- [Control Panels](#control-panels)
  - [List all control panels type](#list-all-control-panels-type)
- [Hosting management commands](#hosting-management-commands)
  - [Order a Web Hosting plan](#order-a-web-hosting-plan)
  - [Delete a Web Hosting plan](#delete-a-web-hosting-plan)
  - [Get a Web Hosting plan](#get-a-web-hosting-plan)
  - [Get DNS records](#get-dns-records)
  - [List all Web Hosting plans](#list-all-web-hosting-plans)
  - [Restore a Web Hosting plan](#restore-a-web-hosting-plan)
  - [Update a Web Hosting plan](#update-a-web-hosting-plan)
- [Offer management commands](#offer-management-commands)
  - [List all offers](#list-all-offers)

  
## Control Panels

Control panels represent the kind of administration panel to manage your Web Hosting plan, cPanel or plesk.


### List all control panels type

List the control panels type: cpanel or plesk.

**Usage:**

```
scw webhosting control-panel list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `all` | Region to target. If none is passed will use default region from the config |



## Hosting management commands

With a Scaleway Web Hosting plan, you can manage your domain, configure your web hosting services, manage your emails and more. Create, list, update and delete your Web Hosting plans with these calls.


### Order a Web Hosting plan

Order a Web Hosting plan, specifying the offer type required via the `offer_id` parameter.

**Usage:**

```
scw webhosting hosting create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| offer-id |  | ID of the selected offer for the Web Hosting plan |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| email |  | Contact email for the Web Hosting client |
| tags.{index} |  | List of tags for the Web Hosting plan |
| domain |  | Domain name to link to the Web Hosting plan. You must already own this domain name, and have completed the DNS validation process beforehand |
| option-ids.{index} |  | IDs of any selected additional options for the Web Hosting plan |
| language | One of: `unknown_language_code`, `en_US`, `fr_FR`, `de_DE` | Default language for the control panel interface |
| domain-configuration.update-nameservers |  |  |
| domain-configuration.update-web-record |  |  |
| domain-configuration.update-mail-record |  |  |
| domain-configuration.update-all-records |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Delete a Web Hosting plan

Delete a Web Hosting plan, specified by its `hosting_id`. Note that deletion is not immediate: it will take place at the end of the calendar month, after which time your Web Hosting plan and all its data (files and emails) will be irreversibly lost.

**Usage:**

```
scw webhosting hosting delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | Hosting ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Delete a Hosting with the given ID
```
scw webhosting hosting delete hosting-id=a3244331-5d32-4e36-9bf9-b60233e201c7
```




### Get a Web Hosting plan

Get the details of one of your existing Web Hosting plans, specified by its `hosting_id`.

**Usage:**

```
scw webhosting hosting get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | Hosting ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Get a Hosting with the given ID
```
scw webhosting hosting get hosting-id=a3244331-5d32-4e36-9bf9-b60233e201c7
```




### Get DNS records

Get the set of DNS records of a specified domain associated with a Web Hosting plan.

**Usage:**

```
scw webhosting hosting get-dns-records [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain | Required | Domain associated with the DNS records |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Get DNS records associated to the given domain
```
scw webhosting hosting get-dns-records domain=foo.com
```




### List all Web Hosting plans

List all of your existing Web Hosting plans. Various filters are available to limit the results, including filtering by domain, status, tag and Project ID.

**Usage:**

```
scw webhosting hosting list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order for Web Hosting plans in the response |
| tags.{index} |  | Tags to filter for, only Web Hosting plans with matching tags will be returned |
| statuses.{index} | One of: `unknown_status`, `delivering`, `ready`, `deleting`, `error`, `locked`, `migrating` | Statuses to filter for, only Web Hosting plans with matching statuses will be returned |
| domain |  | Domain to filter for, only Web Hosting plans associated with this domain will be returned |
| project-id |  | Project ID to filter for, only Web Hosting plans from this Project will be returned |
| control-panels.{index} |  | Name of the control panel to filter for, only Web Hosting plans from this control panel will be returned |
| organization-id |  | Organization ID to filter for, only Web Hosting plans from this Organization will be returned |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `all` | Region to target. If none is passed will use default region from the config |


**Examples:**


List all hostings of a given project ID
```
scw webhosting hosting list project-id=a3244331-5d32-4e36-9bf9-b60233e201c7 organization-id=a3244331-5d32-4e36-9bf9-b60233e201c7
```




### Restore a Web Hosting plan

When you [delete a Web Hosting plan](#path-hostings-delete-a-hosting), definitive deletion does not take place until the end of the calendar month. In the time between initiating the deletion, and definitive deletion at the end of the month, you can choose to **restore** the Web Hosting plan, using this endpoint and specifying its `hosting_id`.

**Usage:**

```
scw webhosting hosting restore [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | Hosting ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Restore a Hosting with the given ID
```
scw webhosting hosting restore hosting-id=a3244331-5d32-4e36-9bf9-b60233e201c7
```




### Update a Web Hosting plan

Update the details of one of your existing Web Hosting plans, specified by its `hosting_id`. You can update parameters including the contact email address, tags, options and offer.

**Usage:**

```
scw webhosting hosting update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | Hosting ID |
| email |  | New contact email for the Web Hosting plan |
| tags.{index} |  | New tags for the Web Hosting plan |
| option-ids.{index} |  | IDs of the new options for the Web Hosting plan |
| offer-id |  | ID of the new offer for the Web Hosting plan |
| protected |  | Whether the hosting is protected or not |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Update the contact email of a given hosting
```
scw webhosting hosting update hosting-id=11111111-1111-1111-1111-111111111111 email=foobar@example.com
```

Overwrite tags of a given hosting
```
scw webhosting hosting update hosting-id=11111111-1111-1111-1111-111111111111 tags.0=foo tags.1=bar
```

Overwrite options of a given hosting
```
scw webhosting hosting update hosting-id=11111111-1111-1111-1111-111111111111 option-ids.0=22222222-2222-2222-2222-222222222222 option-ids.1=33333333-3333-3333-3333-333333333333
```




## Offer management commands

Web Hosting offers represent the different types of Web Hosting plan available to order at Scaleway.


### List all offers

List the different Web Hosting offers, and their options, available to order from Scaleway.

**Usage:**

```
scw webhosting offer list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `price_asc` | Sort order of offers in the response |
| without-options |  | Defines whether the response should consist of offers only, without options |
| only-options |  | Defines whether the response should consist of options only, without offers |
| hosting-id |  | ID of a Web Hosting plan, to check compatibility with returned offers (in case of wanting to update the plan) |
| control-panels.{index} |  | Name of the control panel to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


List all offers available for purchase
```
scw webhosting offer list hosting-id=a3244331-5d32-4e36-9bf9-b60233e201c7
```

List only offers, no options
```
scw webhosting offer list without-options=true
```

List only options
```
scw webhosting offer list only-options=true
```




