# MD046 - Use Consistent Code Block Style

Aliases: `code-block-style`

## What this rule does

Ensures all code blocks in your document use the same style - either fenced (with backticks) or indented (with spaces).

## Why this matters

- **Readability**: Mixing styles makes documents harder to scan and understand
- **Maintainability**: Consistent style makes code blocks easier to edit
- **Tool compatibility**: Some tools work better with one style over another
- **Professional appearance**: Consistency shows attention to detail

## Examples

### ✅ Correct (Fenced style)

````markdown
Here's how to use our API:

```javascript
const api = require('our-api');
api.connect();
```

And here's the response format:

```json
{
  "status": "success",
  "data": {}
}
```
````

### ❌ Incorrect (Mixed styles)

<!-- rumdl-disable MD031 MD040 -->

````markdown
Here's how to use our API:

```javascript
const api = require('our-api');
api.connect();
```

And here's the response format:

    {
      "status": "success",
      "data": {}
    }
````

<!-- rumdl-enable MD031 MD040 -->

### 🔧 Fixed

````markdown
Here's how to use our API:

```javascript
const api = require('our-api');
api.connect();
```

And here's the response format:

```json
{
  "status": "success",
  "data": {}
}
```
````

## Configuration

```toml
[MD046]
style = "consistent"  # Options: "consistent", "fenced", "indented"
```

### Style options

| Value        | Description                                       |
| ------------ | ------------------------------------------------- |
| `consistent` | All code blocks must use the same style (default) |

| `fenced` | All code blocks must use fenced style (``` or ~~~) |
| `indented` | All code blocks must use indented style (4 spaces) |

## Automatic fixes

When enabled, this rule will:

- Convert all code blocks to match your configured style
- Preserve code content and language identifiers
- Maintain proper spacing around blocks

## Style comparison

**Fenced code blocks** (recommended):

- Support syntax highlighting with language identifiers
- Easier to copy and paste
- More visible boundaries

**Indented code blocks**:

- Traditional Markdown style
- No language identifier support
- Must indent each line with 4 spaces or 1 tab

## Special cases

- Empty code blocks are ignored
- HTML `<pre>` and `<code>` tags are not affected
- When using "consistent", the most prevalent style is used (in case of a tie, fenced style is preferred as it's more widely supported)
- Per CommonMark, fenced code block openers (`` ``` `` or `~~~`) can only have 0-3 spaces of indentation. With 4+ spaces, the fence markers become literal content in an indented code block

## Learn more

- [CommonMark fenced code blocks](https://spec.commonmark.org/0.31.2/#fenced-code-blocks)
- [CommonMark indented code blocks](https://spec.commonmark.org/0.31.2/#indented-code-blocks)
- [GitHub Flavored Markdown](https://github.github.com/gfm/#code-blocks)

## Related rules

- [MD031](md031.md) - Add blank lines around code blocks
- [MD040](md040.md) - Specify languages for code blocks
- [MD048](md048.md) - Use consistent fence markers (backticks vs tildes)
