# MD068 - Empty footnote definitions

Aliases: `empty-footnote-definition`

## What this rule does

Checks that footnote definitions have content and are not empty.

## Why this matters

- **Prevents mistakes**: Empty footnotes are almost always unintentional
- **Avoids confusion**: Readers clicking a footnote expect to find information
- **Catches incomplete work**: Flags placeholder footnotes that need content

## Examples

### Correct

```markdown
Text with a footnote[^1] reference.

[^1]: This footnote has content.
```

### Correct - multi-line footnote

```markdown
Text with a footnote[^1] reference.

[^1]:
    Content on the next line is valid.
    Additional paragraphs work too.
```

### Incorrect

```markdown
Text with a footnote[^1] reference.

[^1]:
```

**Warning**: `Footnote definition [^1] is empty`

### Incorrect - whitespace only

```markdown
Text with a footnote[^1] reference.

[^1]:
```

**Warning**: `Footnote definition [^1] is empty`

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule cannot automatically fix issues because it cannot determine what content should be added to empty footnotes.

## Related rules

- [MD066 - Footnote validation](md066.md)
- [MD067 - Footnote definition order](md067.md)
