# MD059 - Link Text Should Be Descriptive

Aliases: `descriptive-link-text`

## What this rule does

Ensures that markdown links use meaningful, descriptive text rather than generic phrases like "click here," "here," "link," or "more."

## Why this matters

- **Accessibility**: Screen readers often present links without surrounding context, making generic text problematic for users relying on assistive technologies
- **User experience**: Descriptive link text helps readers understand where links lead before clicking
- **SEO benefits**: Search engines use link text to understand page relationships and relevance
- **Professional quality**: Generic link text appears unprofessional and can diminish document credibility

## Examples

### ✅ Correct

```markdown
[API documentation](docs.md)

[Installation guide](install.md)

[Read the complete tutorial](tutorial.md)

Check out our [feature roadmap](roadmap.md) for upcoming releases.
```

### ❌ Incorrect

```markdown
[click here](docs.md)

[here](install.md)

[link](tutorial.md)

For upcoming releases, click [more](roadmap.md).
```

## Configuration

```toml
[MD059]
prohibited-texts = ["click here", "here", "link", "more"]
```

### Options

- **`prohibited-texts`**: List of prohibited link text phrases (case-insensitive)
  - Default: `["click here", "here", "link", "more"]`
  - Phrases are matched exactly after trimming whitespace
  - Matching is case-insensitive
  - Only exact matches trigger warnings (substrings within larger text are allowed)

### Customizing for non-English content

For documentation in other languages, customize the prohibited texts:

```toml
[MD059]
prohibited-texts = ["hier klicken", "hier", "link", "mehr"]  # German

[MD059]
prohibited-texts = ["cliquez ici", "ici", "lien", "plus"]     # French

[MD059]
prohibited-texts = ["haz clic aquí", "aquí", "enlace", "más"]  # Spanish
```

## Automatic fixes

This rule is **not auto-fixable** because choosing descriptive link text requires human judgment and understanding of the link's context and destination. You must manually replace generic link text
with meaningful descriptions.

## Special cases

- **Empty link text**: Links with empty text are skipped (handled by MD042)
- **Substring matching**: "click here for more info" does NOT match "click here" because it's not an exact match after trimming
- **Reference-style links**: Both inline and reference-style links are checked
- **Whitespace handling**: Leading and trailing whitespace is trimmed before checking
- **Case insensitivity**: "CLICK HERE", "Click Here", and "click here" all match the default prohibited text

## Examples of edge cases

```markdown
<!-- Allowed: prohibited text as substring of larger phrase -->
[click here for more information](url)
[see here for details](url)
[hyperlink documentation](url)

<!-- Still triggers warning: case variations are still detected -->
[CLICK HERE](url)           <!-- ❌ Still triggers warning -->
[Click Here](url)           <!-- ❌ Still triggers warning -->
[   click here   ](url)     <!-- ❌ Whitespace trimmed, still matches -->

<!-- Not checked by MD059: handled by MD042 -->
[](url)                     <!-- Empty text not checked by MD059 -->
[   ](url)                  <!-- Whitespace-only not checked by MD059 -->
```

## Best practices

When replacing generic link text:

1. **Describe the destination**: "API documentation" instead of "click here"
2. **Provide context**: "installation guide" instead of "here"
3. **Be specific**: "user authentication tutorial" instead of "tutorial"
4. **Keep it concise**: Balance description with brevity
5. **Avoid redundancy**: Don't use "link to" since the syntax already indicates it's a link

## Learn more

- [WebAIM: Links and Hypertext](https://webaim.org/techniques/hypertext/)
- [W3C: Providing link text that describes the purpose of a link](https://www.w3.org/WAI/WCAG21/Techniques/general/G53)
- [markdownlint MD059](https://github.com/DavidAnson/markdownlint/blob/main/doc/md059.md)
