# MD025 - Keep your document organized with one main title

Aliases: `single-title`, `single-h1`

## What this rule does

Ensures your document has only one main title (heading level 1), maintaining a clear document hierarchy.

## Why this matters

- **Clear hierarchy**: One main title makes the document structure obvious to readers
- **Better navigation**: Tools and readers can easily identify the document's primary topic
- **SEO benefits**: Search engines expect one main title per page
- **Accessibility**: Screen readers rely on proper heading hierarchy for navigation

## Examples

### ✅ Correct

```markdown
# Document Title

## Section 1

Content here.

## Section 2

More content here.
```

### ❌ Incorrect

```markdown
# First Title

Content here.

# Second Title

More content here.
```

### 🔧 Fixed

```markdown
# Document Title

## First Section

Content here.

## Second Section

More content here.
```

## Configuration

```toml
[MD025]
level = 1                        # The heading level that should be unique (default: 1)
front-matter-title = "title"     # Regex pattern to match title in YAML front matter (default: "title")
allow-document-sections = false  # Allow multiple H1s separated by --- thematic breaks (default: false)
allow-with-separators = false    # Allow multiple H1s as document section titles (default: false)
```

### Front Matter Integration

The `front-matter-title` option allows this rule to treat YAML front matter titles as H1 headings. This is useful for static site generators like Jekyll, Hugo, and Docusaurus that extract titles from
front matter.

**How it works:**

- When a document has YAML front matter with a `title` field, it counts as an H1
- Subsequent H1 headings in the document body will trigger a violation
- You can customize the field name by changing the regex pattern

**Example with front matter:**

```markdown
---
title: My Blog Post
date: 2024-01-15
---

Content starts here without an H1 heading.

## First Section

This is valid because the front matter title counts as the H1.
```

**Configuration examples:**

```toml
# Match standard 'title:' field (default)
[MD025]
front-matter-title = "title"

# Match either 'title:' or 'heading:' fields
[MD025]
front-matter-title = "^\\s*(title|heading)\\s*[:=]"

# Disable front matter checking (treat front matter and body separately)
[MD025]
front-matter-title = ""
```

## Automatic fixes

This rule will:

- Convert extra main titles to the next heading level (H1 → H2)
- Preserve the document's first main title
- Maintain the relative hierarchy of subsequent headings

## Learn more

- [CommonMark Spec: ATX headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [CommonMark Spec: Setext headings](https://spec.commonmark.org/0.31.2/#setext-headings)

## Related rules

- [MD001 - Keep heading levels organized](md001.md)
- [MD003 - Use consistent heading styles](md003.md)
- [MD024 - Avoid duplicate heading text](md024.md)
- [MD041 - Start files with a heading](md041.md)
