require "eet"
require "test/unit"
require "common"

class ArraySubTestData
	def initialize(v)
		@value = v
	end

	protected
	def to_eet_name
		"ArraySubTest"
	end

	def to_eet_properties
		{"value" => [@value, :sub]}
	end
end

class MyArray < Array
	protected
	def to_eet_properties
		{"entries" => [self]}
	end
end

class Entry
	def initialize(v)
		@value = v
	end
end

class ArraySubTest < Test::Unit::TestCase
	def test_arraysub
		a = MyArray.new
		["foo", "bar", "baz"].each { |s| a << Entry.new(s) }

		data = ArraySubTestData.new(a).to_eet

		assert_not_nil(data)

		stream = nil

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(data)
		end

		assert_equal(1, stream.length)
		assert_equal("ArraySubTest", stream.first.tag)

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(stream.first.data)
		end

		assert_equal(1, stream.length)
		assert_equal("value", stream.first.tag)

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(stream.first.data)
		end

		assert_equal(1, stream.length)
		assert_equal("MyArray", stream.first.tag)

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(stream.first.data)
		end

		assert_equal(3, stream.length)

		["foo", "bar", "baz"].each_with_index do |s, i|
			stream2 = nil
			stream3 = nil

			assert_equal("entries", stream[i].tag)

			assert_nothing_raised do
				stream2 = Eet::Stream.deserialize(stream[i].data)
			end

			assert_equal(1, stream2.length)
			assert_equal("Entry", stream2.first.tag)

			assert_nothing_raised do
				stream3 = Eet::Stream.deserialize(stream2.first.data)
			end

			assert_equal(1, stream3.length)
			assert_equal("value", stream3.first.tag)
			assert_equal(s + "\0", stream3.first.data)
		end
	end
end
