/*--------------------------------------------------------
    setup.h - Constants.

--------------------------------------------------------*/


/*--------------------------------------------------------

REALNETWORKS LICENSE AGREEMENT AND WARRANTY 
             DISCLAIMER

_____________________________________________

Free Real-Time Streaming Protocol (RTSP) Firewall 
             Proxy License

IMPORTANT -- READ CAREFULLY: This RealNetworks 
License Agreement ("License Agreement") is a legal 
agreement between you (either an individual or an 
entity) and RealNetworks, Inc.  and its suppliers and 
licensors collectively ("RN") for the software product 
listed above, which includes computer software and 
associated media and printed material, whether provided 
in a physical form or received on-line form ("Software").  
By clicking on the "Accept" button or opening the 
package, you are consenting to be bound by this Agreement.  
If you do not agree to all of the terms of this agreement, 
click the "Do Not Accept" button and, if you received the 
Software by package, return the product to the place of 
purchase.

__________________________________________________________

1. GRANT OF LICENSE.

Subject to the provisions contained in this License Agreement, 
RN hereby grants you a non-exclusive, non-transferable, 
perpetual, worldwide license to use, modify or redistribute the 
Software subject to the following terms and conditions:

(a) The copyright notice (" 1998 RealNetworks, 
Inc.") and this copy of  this License Agreement shall 
appear on all copies and/or any derivative versions 
of the Software you create or distribute.

(b)	You acknowledge and agree that RN is and shall be 
the exclusive owner of all right, title and interest, 
including copyright, in the Software.

All rights not expressly granted to you are reserved to RN.

2.  SOFTWARE MAINTENANCE AND UPGRADES. 

RN is not obligated to provide maintenance or updates to you 
for the Software. However, any maintenance or updates 
provided by RN shall be covered by this Agreement.

3.  DISCLAIMER OF WARRANTY.

The Software is deemed accepted by you.  Because RN is 
providing you the Software for free, the Software is provided 
to you AS IS, WITHOUT WARRANTY OF ANY KIND. TO 
THE MAXIMUM EXTENT PERMITTED BY 
APPLICABLE LAW, REALNETWORKS FURTHER 
DISCLAIMS ALL
WARRANTIES, INCLUDING WITHOUT LIMITATION 
ANY IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE, AND NONINFRINGEMENT. THE ENTIRE 
RISK ARISING OUT OF THE USE OR PERFORMANCE 
OF THE SOFTWARE REMAINS WITH YOU. TO THE 
MAXIMUM EXTENT PERMITTED BY APPLICABLE 
LAW, IN NO
EVENT SHALL REALNETWORKS OR ITS SUPPLIERS 
BE LIABLE FOR ANY CONSEQUENTIAL, INCIDENTAL, 
DIRECT, INDIRECT, SPECIAL, PUNITIVE, OR OTHER 
DAMAGES WHATSOEVER (INCLUDING, WITHOUT 
LIMITATION, DAMAGES FOR LOSS OF BUSINESS 
PROFITS, BUSINESS INTERRUPTION, LOSS OF 
BUSINESS INFORMATION, OR OTHER PECUNIARY 
LOSS) ARISING OUT OF THIS AGREEMENT OR THE 
USE OF OR INABILITY TO USE THE SOFTWARE, EVEN 
IF REALNETWORKS HAS BEEN ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGES. BECAUSE SOME 
STATES/JURISDICTIONS DO NOT ALLOW THE 
EXCLUSION OR LIMITATION OF LIABILITY FOR 
CONSEQUENTIAL OR INCIDENTAL DAMAGES, THE 
ABOVE LIMITATION MAY NOT APPLY TO YOU.

4. INDEMNIFICATION. 

You hereby agree to defend, indemnify, and hold RN, its 
directors, officers, employees and agents, harmless from any 
and all claims, damages, and expenses (including attorneys 
fees and costs) of any nature arising out of the use, 
modification, or redistribution the Software or any derivative 
versions thereof.

5. U.S. GOVERNMENT RESTRICTED RIGHTS AND 
EXPORT RESTRICTIONS. 

The Software is provided with RESTRICTED RIGHTS. Use, 
duplication, or disclosure by the Government is subject to 
restrictions as set forth in subparagraph (a) through (d) of the 
of the Commercial Computer Software-Restricted Rights at 
FAR 52.227-19, as applicable, or subparagraph (c)(1)(ii) of 
The Rights in Technical Data and Computer Software clause 
of DFARS 252.227-7013, and in similar clauses in the NASA 
FAR supplement, as applicable.  Manufacturer is 
RealNetworks, Inc., 1111 Third Avenue, Suite 500, Seattle, 
Washington 98101.  You acknowledge that none of the 
Software or underlying information or technology may be 
downloaded or otherwise exported or re-exported (i) into (or 
to a national or resident of) Cuba, Iraq, Libya, Yugoslavia, 
North Korea, Iran, Syria, Sudan or Angola or any other 
country to which the U.S. has embargoed goods; or (ii) to 
anyone on the U.S. Treasury Department's list of Specially 
Designated Nationals or the U.S. Commerce Department's 
Table of Denial Orders.  By using the Software, you are 
agreeing to the foregoing and you are representing and 
warranting that you are not located in, under the control of, or 
a national or resident or resident of any such country or on any 
such list.

6. GOVERNING LAW; ATTORNEYS FEES. 

This agreement shall be governed by the laws of the State of 
Washington and you further consent to jurisdiction by the state 
and federal courts sitting in the State of Washington. If either 
RN or you employs
attorneys to enforce any rights arising out of or relating to this 
Agreement, the prevailing party shall be entitled to recover 
reasonable attorneys' fees.

8.  ENTIRE AGREEMENT. 

This agreement constitutes the complete and exclusive 
agreement between RN and you with respect to the subject 
matter hereof, and supersedes all prior oral or written 
understandings, communications or agreements not 
specifically incorporated herein.  This agreement may not be 
modified except in a writing duly signed by an authorized 
representative of RN and you.    

Copyright  1997-1998 RealNetworks, Inc. and or its 
suppliers.  1111 Third Avenue, Suite 2900, Seattle, 
Washington 98101 U.S.A.  All rights are reserved.



RTSP Proxy License Agreement 8-98

--------------------------------------------------------*/



#ifndef __setup_h__
#define __setup_h__


/*----------------------------------------------------------------------*/
/* CONFIGURATION ITEMS                                                  */
/*----------------------------------------------------------------------*/

/* The default port rtspd listens to for RTSP Control connections       */
/* (which may be overridden by the -p command-line switch).             */
/*If a port lower than 1024   is used, the proxy can only bind to the   */
/* port when started by the "root" user.  In which case, the -u switch  */
/* should probably be used, as in "-u nobody".                          */
/* used in:  main.c */
#ifndef SERV_TCP_PORT
#define SERV_TCP_PORT 554
#endif /* SERV_TCP_PORT */

/* The default port ON THE REMOTE SERVER for the TCP Control connection.   */
/* If the client requests a URL without specifying a port number, this     */
/* is the port on the server the proxy will connect to.  The default, 554, */
/* is a standard port and probably shouldn't be changed.                   */
/* used in: rtsp.c */
#ifndef DEFAULT_SERVER_PORT
#define DEFAULT_SERVER_PORT 554
#endif /* DEFAULT_SERVER_PORT */

/* The name of this package (used below only) */
#ifndef PROXY_NAME
#define PROXY_NAME "RTSP Proxy Reference Implementation"
#endif /* PROXY_NAME */

/* The version of this package (used below only) */
#ifndef PROXY_VERSION
#define PROXY_VERSION "1.0.0.0"
#endif /* PROXY_VERSION */

/* The copyright notice for this package (used below only) */
#ifndef PROXY_COPYRIGHT
#define PROXY_COPYRIGHT "(c) 1997-1998 RealNetworks, Inc.\nAll Rights Reserved"
#endif /* PROXY_COPYRIGHT */

/* The full version string, displayed with -v and -h and logged via syslog */
/* used in:  main.c */
#ifndef VERSION_MESSAGE
#define VERSION_MESSAGE   PROXY_NAME " Version " PROXY_VERSION "\n" PROXY_COPYRIGHT
#endif /* VERSION_MESSAGE */

/* Maximum number of times to try to allocate ports for RTP/AVP/UDP.     */
/* (Needed to eliminate the remote chance of looping when allocating     */
/* port numbers 2N and 2N+1.)                                            */
/* used in: rtsp.c */
#ifndef RTP_PORT_RETRY_MAX
#define RTP_PORT_RETRY_MAX 10
#endif /* RTP_PORT_RETRY_MAX */


/* The default user to setuid to when running as root. */
#ifndef DEFAULT_SETUID_USER
#define DEFAULT_SETUID_USER "nobody"
#endif /* DEFAULT_SETUID_USER */

/* The syslog(3) facility to be used.  You may prefer one of LOG_LOCAL0-7 */
/* or something else.                                                     */
/* used in:  util.c */
#ifndef SYSLOG_FACILITY
#define SYSLOG_FACILITY LOG_DAEMON
#endif /* SYSLOG_FACILITY */

/* The syslog(3) identifier to be used. */
/* used in:  util.c */
#ifndef SYSLOG_IDENT
#define SYSLOG_IDENT "rtspd"
#endif /* SYSLOG_IDENT */

/* If you define this, most debug output will be logged via syslog(3) */
/* in addition to being displayed on stderr.  Be aware that logging   */
/* for TCP-only connections can generate a large amount of output.    */
/* #ifndef DEBUG_TO_SYSLOG */
/* #define DEBUG_TO_SYSLOG */
/* #endif                  */

#ifdef DEBUG
#define LOG_EACH_UDP_PACKET  /* print a message each time a UDP packet arrives*/
#define LOG_RTSP_TRAFFIC     /* print all RTSP Control messages to stderr */
#endif /* DEBUG */

#define LOG_URLS_PLAYED      /* log each URL played to syslog */


/* needed on Solaris 2.5 */
#ifdef USE__SNPRINTF
#define snprintf __snprintf
#define vsnprintf __vsnprintf
int __snprintf ( char *str, size_t n, const char *format, ... );
int __vsnprintf ( char *str, size_t n, const char *format, va_list ap );
#endif /* USE__SNPRINTF */


/* use rand() or random() */
#ifdef USE_RAND
#define RANDOM rand
#define SRANDOM srand
#else
#define RANDOM random
#define SRANDOM srandom
#endif /* USE_RAND */

/* used as third paramater to getpeername() and getsockname().
   Might be int or size_t.
*/
#ifndef ADDRESS_LENGTH
#define ADDRESS_LENGTH int
#endif /* ADDRESS_LENGTH */


#ifdef NEED_EXTRA_PROTOTYPES
void bcopy(), bzero(), endhostent(), srandom(), openlog(), syslog(),
     closelog(), ioctl();
int select(), recvfrom(), sendto(), socket(), connect(), setsockopt(),
    getpeername(), bind(), getsockname(), chroot(), getopt(), listen(),
    accept(), gethostname(), setpgrp();
char *index();
long int random();
#ifndef NEED_SNPRINTF
int snprintf();
#endif /* NEED_SNPRINTF */
#ifndef NEED_VSNPRINTF
int vsnprintf();
#endif /* NEED_VSNPRINTF */
#endif /* NEED_EXTRA_PROTOTYPES */



/*----------------------------------------------------------------------*/
/* BUFFER-SIZE RELATED LIMITS                                           */
/*----------------------------------------------------------------------*/

/* Maximum size of UDP and TCP buffers. */
/* used in:  child-main.c and rtsp.c */
#ifndef MAX_TCP_BUFF
#define MAX_TCP_BUFF 16385
#endif /* MAX_TCP_BUFF */
#define MAX_UDP_BUFF MAX_TCP_BUFF

/* Maximum hostname+domainname length for the host we forward to with -f */
/* and hosts in SETUP messages.                                          */
/* used in: rtsp.c, child-main.c and main.c */
#ifndef HOSTNAME_MAX
#define HOSTNAME_MAX 1024
#endif /* HOSTNAME_MAX */

/* Largest message we can log via log_message(). */
/* used in: util.c */
#ifndef LOG_MESSAGE_MAX
#define LOG_MESSAGE_MAX 4096
#endif /* LOG_MESSAGE_MAX */

/* Maximum length of a filesystem pathname. */
/* used in: main.c */
#ifndef PATH_MAX
#define PATH_MAX 256
#endif /* PATH_MAX */

/* Used in remapping CSeq values (default should be plenty) */
/* used in: rtsp.c */
#ifndef MAX_CSEQ_STR_LEN
#define MAX_CSEQ_STR_LEN 256
#endif /* MAX_CSEQ_STR_LEN */

#endif /* __setup_h__ */
