/* tests/mocks.h -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#pragma once

#include <sys/types.h>
#include <sys/socket.h>

#define make_mock(name, retval, ...)         \
  retval (*mock_##name) (__VA_ARGS__);       \
  retval (*real_##name) (__VA_ARGS__);       \
  retval name (__VA_ARGS__)

#define mock(name, func) mock_##name = func
#define restore(name) mock_##name = real_##name

#define STUB(name, ...)                         \
  if (!real_##name)                             \
    real_##name = dlsym (RTLD_NEXT, #name);     \
  if (!mock_##name)                             \
    mock_##name = real_##name;                  \
                                                \
  return mock_##name (__VA_ARGS__)

make_mock (socket, int, int domain, int type, int protocol)
{
  STUB (socket, domain, type, protocol);
}

make_mock (send, ssize_t, int sockfd, const void *buf, size_t len,
           int flags)
{
  STUB (send, sockfd, buf, len, flags);
}

make_mock (sendto, ssize_t, int sockfd, const void *buf, size_t len,
           int flags, const struct sockaddr *dest_addr,
           socklen_t addrlen)
{
  STUB (sendto, sockfd, buf, len, flags, dest_addr, addrlen);
}

make_mock (recv, ssize_t, int sockfd, void *buf, size_t len, int flags)
{
  STUB (recv, sockfd, buf, len, flags);
}

int mock_enosys_int_always_fail ();
ssize_t mock_enosys_ssize_t_always_fail ();
