/* riemann/client/udp.c -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>

#include "riemann/client/udp.h"
#include "riemann/client/socket.h"
#include "riemann/_private.h"

void
_riemann_client_connect_setup_udp (riemann_client_t *client)
{
  _riemann_client_connect_setup_socket (client);

  client->type = RIEMANN_CLIENT_UDP;
  client->send = _riemann_client_send_message_udp;
  client->recv = _riemann_client_recv_message_udp;
}

struct _riemann_buff_w_hdr
{
  uint32_t header;
  uint8_t data[0];
};

int
_riemann_client_send_message_udp (riemann_client_t *client,
                                  riemann_message_t *message)
{
  struct _riemann_buff_w_hdr *buffer;
  size_t len;
  ssize_t sent;
  riemann_client_connection_socket_t *conn =
    (riemann_client_connection_socket_t *) client->connection;

  buffer = (struct _riemann_buff_w_hdr *)
    riemann_message_to_buffer (message, &len);
  if (!buffer)
    return -errno;

  sent = sendto (conn->sock, buffer->data, len - sizeof (buffer->header), 0,
                 conn->srv_addr->ai_addr, conn->srv_addr->ai_addrlen);
  if (sent == -1 || (size_t)sent != len - sizeof (buffer->header))
    {
      int e = errno;

      free (buffer);
      return -e;
    }
  free (buffer);
  return 0;
}

riemann_message_t *
_riemann_client_recv_message_udp (riemann_client_t __attribute__((unused)) *client)
{
  errno = ENOTSUP;
  return NULL;
}
