/* riemann/client/tls.h -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#pragma once

#include <riemann/client.h>
#include <riemann/message.h>
#include <netdb.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
  char *cafn;
  char *certfn;
  char *keyfn;
  unsigned int handshake_timeout;
  char *priorities;
} riemann_client_tls_options_t;

int _riemann_client_connect_setup_tls (riemann_client_t *client,
                                       va_list aq);
int _riemann_client_connect_tls (riemann_client_t *client,
                                 const char *hostname,
                                 int port);
int _riemann_client_disconnect_tls (riemann_client_t *client);
int _riemann_client_send_message_tls (riemann_client_t *client,
                                      riemann_message_t *message);
riemann_message_t *_riemann_client_recv_message_tls (riemann_client_t *client);

#ifdef __cplusplus
} /* extern "C" */
#endif
