/* riemann/client/tls.c -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#include <stdlib.h>

#include "riemann/_private.h"
#include "riemann/platform.h"

#include "riemann/client/tls.h"

#if WITH_TLS
static void
_riemann_client_tls_options_free (riemann_client_tls_options_t *tls_options)
{
  if (tls_options->cafn)
    free (tls_options->cafn);
  if (tls_options->certfn)
    free (tls_options->certfn);
  if (tls_options->keyfn)
    free (tls_options->keyfn);
  if (tls_options->priorities)
    free (tls_options->priorities);
}
#endif

#if WITH_TLS_GNUTLS

#include "riemann/client/tls-gnutls.c"

#elif WITH_TLS_WOLFSSL

#include "riemann/client/tls-wolfssl.c"

#elif WITH_TLS_OPENSSL

#include "riemann/client/tls-openssl.c"

#else /* !WITH_TLS_GNUTLS && !WITH_TLS_WOLFSSL && !WITH_TLS_OPENSSL */

int
_riemann_client_connect_setup_tls (riemann_client_t __attribute__((unused)) *client,
                                   va_list __attribute__((unused)) aq)
{
  return -ENOTSUP;
}

riemann_client_tls_library_t
riemann_client_get_tls_library (void)
{
  return RIEMANN_CLIENT_TLS_LIBRARY_NONE;
}

#endif
