/* riemann/client/socket.h -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#pragma once

#include <riemann/riemann-client.h>

typedef struct
{
  int sock;
  struct addrinfo *srv_addr;
} riemann_client_connection_socket_t;

void _riemann_client_connect_setup_socket (riemann_client_t *client);
int _riemann_client_connect_socket (riemann_client_t *client,
                                    const char *hostname,
                                    int port);
int _riemann_client_disconnect_socket (riemann_client_t *client);
int _riemann_client_get_fd_socket (riemann_client_t *client);
int _riemann_client_set_timeout_socket (riemann_client_t *client,
                                        struct timeval *timeout);
