/* riemann/_private.h -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#pragma once

#include <riemann/riemann-client.h>

#include "riemann/platform.h"

int _riemann_client_compare_versions (int cur_major, int cur_minor, int cur_patch,
                                      int chk_major, int chk_minor, int chk_patch);

typedef int (*riemann_client_send_message_t) (riemann_client_t *client,
                                              riemann_message_t *message);
typedef riemann_message_t *(*riemann_client_recv_message_t) (riemann_client_t *client);
typedef int (*riemann_client_connect_t) (riemann_client_t *client,
                                         const char *hostname,
                                         int port);
typedef int (*riemann_client_disconnect_t) (riemann_client_t *client);
typedef int (*riemann_client_get_fd_t) (riemann_client_t *client);
typedef int (*riemann_client_set_timeout_t) (riemann_client_t *client,
                                             struct timeval *timeout);

struct _riemann_client_t
{
  riemann_client_type_t type;

  riemann_client_connect_t connect;
  riemann_client_get_fd_t get_fd;
  riemann_client_set_timeout_t set_timeout;
  riemann_client_send_message_t send;
  riemann_client_recv_message_t recv;
  riemann_client_disconnect_t disconnect;

  void *connection;
};

void _riemann_set_string (char **str, char *value);
