/* riemann/_private.h -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#include "_private.h"

#include <stdlib.h>
#include <string.h>

int
_riemann_client_compare_versions (int cur_major, int cur_minor, int cur_patch,
                                  int chk_major, int chk_minor, int chk_patch)
{
  if (chk_major >= 0)
    {
      if (cur_major < chk_major)
        return -1;
      if (cur_major > chk_major)
        return 1;
    }

  if (chk_minor >= 0)
    {
      if (cur_minor < chk_minor)
        return -1;
      if (cur_minor > chk_minor)
        return 1;
    }

  if (chk_patch >= 0)
    {
      if (cur_patch < chk_patch)
        return -1;
      if (cur_patch > chk_patch)
        return 1;
    }

  return 0;
}

void
_riemann_set_string (char **str, char *value)
{
  if (*str)
    free (*str);
  if (value)
    *str = strdup (value);
  else
    *str = NULL;
}
