Frequently Asked Questions
==========================

Why does the SONAME have the TLS library name in it?
----------------------------------------------------

Anything compiled against one variant of the library would still link and run
against another variant. Why do we have the TLS library in the SONAME then, if
the variants are so interchangeable?

The reason is simple: when something is compiled against a particular variant of
the library, it can rightfully expect that it will be linked against the same
variant too. If an application is compiled against a TLS-enabled
riemann-c-client, it should not suddenly find itself linked against a variant
that does not have TLS enabled.

Likewise, if it is compiled against a particular variant, it should always be
linked against that particular variant too, because there may be subtle
differences between the backing libraries, in behavior, options supported, and
so on.

In short, we have the TLS library in the SONAME because that makes linking
reliable, and reproducible.
