// Copyright 2009 the Sputnik authors.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
info: Check x >> y operator in distinct points
es5id: 11.7.2_A4_T1
description: ShiftExpression = -2^n, n = 0...15
---*/

//CHECK

if (-1 >> 0 !== -1) { 
  $ERROR('#1: -1 >> 0 === -1. Actual: ' + (-1 >> 0)); 
} 


if (-2 >> 0 !== -2) { 
  $ERROR('#2: -2 >> 0 === -2. Actual: ' + (-2 >> 0)); 
} 


if (-4 >> 0 !== -4) { 
  $ERROR('#3: -4 >> 0 === -4. Actual: ' + (-4 >> 0)); 
} 


if (-8 >> 0 !== -8) { 
  $ERROR('#4: -8 >> 0 === -8. Actual: ' + (-8 >> 0)); 
} 


if (-16 >> 0 !== -16) { 
  $ERROR('#5: -16 >> 0 === -16. Actual: ' + (-16 >> 0)); 
} 


if (-32 >> 0 !== -32) { 
  $ERROR('#6: -32 >> 0 === -32. Actual: ' + (-32 >> 0)); 
} 


if (-64 >> 0 !== -64) { 
  $ERROR('#7: -64 >> 0 === -64. Actual: ' + (-64 >> 0)); 
} 


if (-128 >> 0 !== -128) { 
  $ERROR('#8: -128 >> 0 === -128. Actual: ' + (-128 >> 0)); 
} 


if (-256 >> 0 !== -256) { 
  $ERROR('#9: -256 >> 0 === -256. Actual: ' + (-256 >> 0)); 
} 


if (-512 >> 0 !== -512) { 
  $ERROR('#10: -512 >> 0 === -512. Actual: ' + (-512 >> 0)); 
} 


if (-1024 >> 0 !== -1024) { 
  $ERROR('#11: -1024 >> 0 === -1024. Actual: ' + (-1024 >> 0)); 
} 


if (-2048 >> 0 !== -2048) { 
  $ERROR('#12: -2048 >> 0 === -2048. Actual: ' + (-2048 >> 0)); 
} 


if (-4096 >> 0 !== -4096) { 
  $ERROR('#13: -4096 >> 0 === -4096. Actual: ' + (-4096 >> 0)); 
} 


if (-8192 >> 0 !== -8192) { 
  $ERROR('#14: -8192 >> 0 === -8192. Actual: ' + (-8192 >> 0)); 
} 


if (-16384 >> 0 !== -16384) { 
  $ERROR('#15: -16384 >> 0 === -16384. Actual: ' + (-16384 >> 0)); 
} 


if (-32768 >> 0 !== -32768) { 
  $ERROR('#16: -32768 >> 0 === -32768. Actual: ' + (-32768 >> 0)); 
} 


if (-65536 >> 0 !== -65536) { 
  $ERROR('#17: -65536 >> 0 === -65536. Actual: ' + (-65536 >> 0)); 
} 


if (-131072 >> 0 !== -131072) { 
  $ERROR('#18: -131072 >> 0 === -131072. Actual: ' + (-131072 >> 0)); 
} 


if (-262144 >> 0 !== -262144) { 
  $ERROR('#19: -262144 >> 0 === -262144. Actual: ' + (-262144 >> 0)); 
} 


if (-524288 >> 0 !== -524288) { 
  $ERROR('#20: -524288 >> 0 === -524288. Actual: ' + (-524288 >> 0)); 
} 


if (-1048576 >> 0 !== -1048576) { 
  $ERROR('#21: -1048576 >> 0 === -1048576. Actual: ' + (-1048576 >> 0)); 
} 


if (-2097152 >> 0 !== -2097152) { 
  $ERROR('#22: -2097152 >> 0 === -2097152. Actual: ' + (-2097152 >> 0)); 
} 


if (-4194304 >> 0 !== -4194304) { 
  $ERROR('#23: -4194304 >> 0 === -4194304. Actual: ' + (-4194304 >> 0)); 
} 


if (-8388608 >> 0 !== -8388608) { 
  $ERROR('#24: -8388608 >> 0 === -8388608. Actual: ' + (-8388608 >> 0)); 
} 


if (-16777216 >> 0 !== -16777216) { 
  $ERROR('#25: -16777216 >> 0 === -16777216. Actual: ' + (-16777216 >> 0)); 
} 


if (-33554432 >> 0 !== -33554432) { 
  $ERROR('#26: -33554432 >> 0 === -33554432. Actual: ' + (-33554432 >> 0)); 
} 


if (-67108864 >> 0 !== -67108864) { 
  $ERROR('#27: -67108864 >> 0 === -67108864. Actual: ' + (-67108864 >> 0)); 
} 


if (-134217728 >> 0 !== -134217728) { 
  $ERROR('#28: -134217728 >> 0 === -134217728. Actual: ' + (-134217728 >> 0)); 
} 


if (-268435456 >> 0 !== -268435456) { 
  $ERROR('#29: -268435456 >> 0 === -268435456. Actual: ' + (-268435456 >> 0)); 
} 


if (-536870912 >> 0 !== -536870912) { 
  $ERROR('#30: -536870912 >> 0 === -536870912. Actual: ' + (-536870912 >> 0)); 
} 


if (-1073741824 >> 0 !== -1073741824) { 
  $ERROR('#31: -1073741824 >> 0 === -1073741824. Actual: ' + (-1073741824 >> 0)); 
} 


if (-2147483648 >> 0 !== -2147483648) { 
  $ERROR('#32: -2147483648 >> 0 === -2147483648. Actual: ' + (-2147483648 >> 0)); 
} 


if (-1 >> 1 !== -1) { 
  $ERROR('#33: -1 >> 1 === -1. Actual: ' + (-1 >> 1)); 
} 


if (-2 >> 1 !== -1) { 
  $ERROR('#34: -2 >> 1 === -1. Actual: ' + (-2 >> 1)); 
} 


if (-4 >> 1 !== -2) { 
  $ERROR('#35: -4 >> 1 === -2. Actual: ' + (-4 >> 1)); 
} 


if (-8 >> 1 !== -4) { 
  $ERROR('#36: -8 >> 1 === -4. Actual: ' + (-8 >> 1)); 
} 


if (-16 >> 1 !== -8) { 
  $ERROR('#37: -16 >> 1 === -8. Actual: ' + (-16 >> 1)); 
} 


if (-32 >> 1 !== -16) { 
  $ERROR('#38: -32 >> 1 === -16. Actual: ' + (-32 >> 1)); 
} 


if (-64 >> 1 !== -32) { 
  $ERROR('#39: -64 >> 1 === -32. Actual: ' + (-64 >> 1)); 
} 


if (-128 >> 1 !== -64) { 
  $ERROR('#40: -128 >> 1 === -64. Actual: ' + (-128 >> 1)); 
} 


if (-256 >> 1 !== -128) { 
  $ERROR('#41: -256 >> 1 === -128. Actual: ' + (-256 >> 1)); 
} 


if (-512 >> 1 !== -256) { 
  $ERROR('#42: -512 >> 1 === -256. Actual: ' + (-512 >> 1)); 
} 


if (-1024 >> 1 !== -512) { 
  $ERROR('#43: -1024 >> 1 === -512. Actual: ' + (-1024 >> 1)); 
} 


if (-2048 >> 1 !== -1024) { 
  $ERROR('#44: -2048 >> 1 === -1024. Actual: ' + (-2048 >> 1)); 
} 


if (-4096 >> 1 !== -2048) { 
  $ERROR('#45: -4096 >> 1 === -2048. Actual: ' + (-4096 >> 1)); 
} 


if (-8192 >> 1 !== -4096) { 
  $ERROR('#46: -8192 >> 1 === -4096. Actual: ' + (-8192 >> 1)); 
} 


if (-16384 >> 1 !== -8192) { 
  $ERROR('#47: -16384 >> 1 === -8192. Actual: ' + (-16384 >> 1)); 
} 


if (-32768 >> 1 !== -16384) { 
  $ERROR('#48: -32768 >> 1 === -16384. Actual: ' + (-32768 >> 1)); 
} 


if (-65536 >> 1 !== -32768) { 
  $ERROR('#49: -65536 >> 1 === -32768. Actual: ' + (-65536 >> 1)); 
} 


if (-131072 >> 1 !== -65536) { 
  $ERROR('#50: -131072 >> 1 === -65536. Actual: ' + (-131072 >> 1)); 
} 


if (-262144 >> 1 !== -131072) { 
  $ERROR('#51: -262144 >> 1 === -131072. Actual: ' + (-262144 >> 1)); 
} 


if (-524288 >> 1 !== -262144) { 
  $ERROR('#52: -524288 >> 1 === -262144. Actual: ' + (-524288 >> 1)); 
} 


if (-1048576 >> 1 !== -524288) { 
  $ERROR('#53: -1048576 >> 1 === -524288. Actual: ' + (-1048576 >> 1)); 
} 


if (-2097152 >> 1 !== -1048576) { 
  $ERROR('#54: -2097152 >> 1 === -1048576. Actual: ' + (-2097152 >> 1)); 
} 


if (-4194304 >> 1 !== -2097152) { 
  $ERROR('#55: -4194304 >> 1 === -2097152. Actual: ' + (-4194304 >> 1)); 
} 


if (-8388608 >> 1 !== -4194304) { 
  $ERROR('#56: -8388608 >> 1 === -4194304. Actual: ' + (-8388608 >> 1)); 
} 


if (-16777216 >> 1 !== -8388608) { 
  $ERROR('#57: -16777216 >> 1 === -8388608. Actual: ' + (-16777216 >> 1)); 
} 


if (-33554432 >> 1 !== -16777216) { 
  $ERROR('#58: -33554432 >> 1 === -16777216. Actual: ' + (-33554432 >> 1)); 
} 


if (-67108864 >> 1 !== -33554432) { 
  $ERROR('#59: -67108864 >> 1 === -33554432. Actual: ' + (-67108864 >> 1)); 
} 


if (-134217728 >> 1 !== -67108864) { 
  $ERROR('#60: -134217728 >> 1 === -67108864. Actual: ' + (-134217728 >> 1)); 
} 


if (-268435456 >> 1 !== -134217728) { 
  $ERROR('#61: -268435456 >> 1 === -134217728. Actual: ' + (-268435456 >> 1)); 
} 


if (-536870912 >> 1 !== -268435456) { 
  $ERROR('#62: -536870912 >> 1 === -268435456. Actual: ' + (-536870912 >> 1)); 
} 


if (-1073741824 >> 1 !== -536870912) { 
  $ERROR('#63: -1073741824 >> 1 === -536870912. Actual: ' + (-1073741824 >> 1)); 
} 


if (-2147483648 >> 1 !== -1073741824) { 
  $ERROR('#64: -2147483648 >> 1 === -1073741824. Actual: ' + (-2147483648 >> 1)); 
} 


if (-1 >> 2 !== -1) { 
  $ERROR('#65: -1 >> 2 === -1. Actual: ' + (-1 >> 2)); 
} 


if (-2 >> 2 !== -1) { 
  $ERROR('#66: -2 >> 2 === -1. Actual: ' + (-2 >> 2)); 
} 


if (-4 >> 2 !== -1) { 
  $ERROR('#67: -4 >> 2 === -1. Actual: ' + (-4 >> 2)); 
} 


if (-8 >> 2 !== -2) { 
  $ERROR('#68: -8 >> 2 === -2. Actual: ' + (-8 >> 2)); 
} 


if (-16 >> 2 !== -4) { 
  $ERROR('#69: -16 >> 2 === -4. Actual: ' + (-16 >> 2)); 
} 


if (-32 >> 2 !== -8) { 
  $ERROR('#70: -32 >> 2 === -8. Actual: ' + (-32 >> 2)); 
} 


if (-64 >> 2 !== -16) { 
  $ERROR('#71: -64 >> 2 === -16. Actual: ' + (-64 >> 2)); 
} 


if (-128 >> 2 !== -32) { 
  $ERROR('#72: -128 >> 2 === -32. Actual: ' + (-128 >> 2)); 
} 


if (-256 >> 2 !== -64) { 
  $ERROR('#73: -256 >> 2 === -64. Actual: ' + (-256 >> 2)); 
} 


if (-512 >> 2 !== -128) { 
  $ERROR('#74: -512 >> 2 === -128. Actual: ' + (-512 >> 2)); 
} 


if (-1024 >> 2 !== -256) { 
  $ERROR('#75: -1024 >> 2 === -256. Actual: ' + (-1024 >> 2)); 
} 


if (-2048 >> 2 !== -512) { 
  $ERROR('#76: -2048 >> 2 === -512. Actual: ' + (-2048 >> 2)); 
} 


if (-4096 >> 2 !== -1024) { 
  $ERROR('#77: -4096 >> 2 === -1024. Actual: ' + (-4096 >> 2)); 
} 


if (-8192 >> 2 !== -2048) { 
  $ERROR('#78: -8192 >> 2 === -2048. Actual: ' + (-8192 >> 2)); 
} 


if (-16384 >> 2 !== -4096) { 
  $ERROR('#79: -16384 >> 2 === -4096. Actual: ' + (-16384 >> 2)); 
} 


if (-32768 >> 2 !== -8192) { 
  $ERROR('#80: -32768 >> 2 === -8192. Actual: ' + (-32768 >> 2)); 
} 


if (-65536 >> 2 !== -16384) { 
  $ERROR('#81: -65536 >> 2 === -16384. Actual: ' + (-65536 >> 2)); 
} 


if (-131072 >> 2 !== -32768) { 
  $ERROR('#82: -131072 >> 2 === -32768. Actual: ' + (-131072 >> 2)); 
} 


if (-262144 >> 2 !== -65536) { 
  $ERROR('#83: -262144 >> 2 === -65536. Actual: ' + (-262144 >> 2)); 
} 


if (-524288 >> 2 !== -131072) { 
  $ERROR('#84: -524288 >> 2 === -131072. Actual: ' + (-524288 >> 2)); 
} 


if (-1048576 >> 2 !== -262144) { 
  $ERROR('#85: -1048576 >> 2 === -262144. Actual: ' + (-1048576 >> 2)); 
} 


if (-2097152 >> 2 !== -524288) { 
  $ERROR('#86: -2097152 >> 2 === -524288. Actual: ' + (-2097152 >> 2)); 
} 


if (-4194304 >> 2 !== -1048576) { 
  $ERROR('#87: -4194304 >> 2 === -1048576. Actual: ' + (-4194304 >> 2)); 
} 


if (-8388608 >> 2 !== -2097152) { 
  $ERROR('#88: -8388608 >> 2 === -2097152. Actual: ' + (-8388608 >> 2)); 
} 


if (-16777216 >> 2 !== -4194304) { 
  $ERROR('#89: -16777216 >> 2 === -4194304. Actual: ' + (-16777216 >> 2)); 
} 


if (-33554432 >> 2 !== -8388608) { 
  $ERROR('#90: -33554432 >> 2 === -8388608. Actual: ' + (-33554432 >> 2)); 
} 


if (-67108864 >> 2 !== -16777216) { 
  $ERROR('#91: -67108864 >> 2 === -16777216. Actual: ' + (-67108864 >> 2)); 
} 


if (-134217728 >> 2 !== -33554432) { 
  $ERROR('#92: -134217728 >> 2 === -33554432. Actual: ' + (-134217728 >> 2)); 
} 


if (-268435456 >> 2 !== -67108864) { 
  $ERROR('#93: -268435456 >> 2 === -67108864. Actual: ' + (-268435456 >> 2)); 
} 


if (-536870912 >> 2 !== -134217728) { 
  $ERROR('#94: -536870912 >> 2 === -134217728. Actual: ' + (-536870912 >> 2)); 
} 


if (-1073741824 >> 2 !== -268435456) { 
  $ERROR('#95: -1073741824 >> 2 === -268435456. Actual: ' + (-1073741824 >> 2)); 
} 


if (-2147483648 >> 2 !== -536870912) { 
  $ERROR('#96: -2147483648 >> 2 === -536870912. Actual: ' + (-2147483648 >> 2)); 
} 


if (-1 >> 3 !== -1) { 
  $ERROR('#97: -1 >> 3 === -1. Actual: ' + (-1 >> 3)); 
} 


if (-2 >> 3 !== -1) { 
  $ERROR('#98: -2 >> 3 === -1. Actual: ' + (-2 >> 3)); 
} 


if (-4 >> 3 !== -1) { 
  $ERROR('#99: -4 >> 3 === -1. Actual: ' + (-4 >> 3)); 
} 


if (-8 >> 3 !== -1) { 
  $ERROR('#100: -8 >> 3 === -1. Actual: ' + (-8 >> 3)); 
} 


if (-16 >> 3 !== -2) { 
  $ERROR('#101: -16 >> 3 === -2. Actual: ' + (-16 >> 3)); 
} 


if (-32 >> 3 !== -4) { 
  $ERROR('#102: -32 >> 3 === -4. Actual: ' + (-32 >> 3)); 
} 


if (-64 >> 3 !== -8) { 
  $ERROR('#103: -64 >> 3 === -8. Actual: ' + (-64 >> 3)); 
} 


if (-128 >> 3 !== -16) { 
  $ERROR('#104: -128 >> 3 === -16. Actual: ' + (-128 >> 3)); 
} 


if (-256 >> 3 !== -32) { 
  $ERROR('#105: -256 >> 3 === -32. Actual: ' + (-256 >> 3)); 
} 


if (-512 >> 3 !== -64) { 
  $ERROR('#106: -512 >> 3 === -64. Actual: ' + (-512 >> 3)); 
} 


if (-1024 >> 3 !== -128) { 
  $ERROR('#107: -1024 >> 3 === -128. Actual: ' + (-1024 >> 3)); 
} 


if (-2048 >> 3 !== -256) { 
  $ERROR('#108: -2048 >> 3 === -256. Actual: ' + (-2048 >> 3)); 
} 


if (-4096 >> 3 !== -512) { 
  $ERROR('#109: -4096 >> 3 === -512. Actual: ' + (-4096 >> 3)); 
} 


if (-8192 >> 3 !== -1024) { 
  $ERROR('#110: -8192 >> 3 === -1024. Actual: ' + (-8192 >> 3)); 
} 


if (-16384 >> 3 !== -2048) { 
  $ERROR('#111: -16384 >> 3 === -2048. Actual: ' + (-16384 >> 3)); 
} 


if (-32768 >> 3 !== -4096) { 
  $ERROR('#112: -32768 >> 3 === -4096. Actual: ' + (-32768 >> 3)); 
} 


if (-65536 >> 3 !== -8192) { 
  $ERROR('#113: -65536 >> 3 === -8192. Actual: ' + (-65536 >> 3)); 
} 


if (-131072 >> 3 !== -16384) { 
  $ERROR('#114: -131072 >> 3 === -16384. Actual: ' + (-131072 >> 3)); 
} 


if (-262144 >> 3 !== -32768) { 
  $ERROR('#115: -262144 >> 3 === -32768. Actual: ' + (-262144 >> 3)); 
} 


if (-524288 >> 3 !== -65536) { 
  $ERROR('#116: -524288 >> 3 === -65536. Actual: ' + (-524288 >> 3)); 
} 


if (-1048576 >> 3 !== -131072) { 
  $ERROR('#117: -1048576 >> 3 === -131072. Actual: ' + (-1048576 >> 3)); 
} 


if (-2097152 >> 3 !== -262144) { 
  $ERROR('#118: -2097152 >> 3 === -262144. Actual: ' + (-2097152 >> 3)); 
} 


if (-4194304 >> 3 !== -524288) { 
  $ERROR('#119: -4194304 >> 3 === -524288. Actual: ' + (-4194304 >> 3)); 
} 


if (-8388608 >> 3 !== -1048576) { 
  $ERROR('#120: -8388608 >> 3 === -1048576. Actual: ' + (-8388608 >> 3)); 
} 


if (-16777216 >> 3 !== -2097152) { 
  $ERROR('#121: -16777216 >> 3 === -2097152. Actual: ' + (-16777216 >> 3)); 
} 


if (-33554432 >> 3 !== -4194304) { 
  $ERROR('#122: -33554432 >> 3 === -4194304. Actual: ' + (-33554432 >> 3)); 
} 


if (-67108864 >> 3 !== -8388608) { 
  $ERROR('#123: -67108864 >> 3 === -8388608. Actual: ' + (-67108864 >> 3)); 
} 


if (-134217728 >> 3 !== -16777216) { 
  $ERROR('#124: -134217728 >> 3 === -16777216. Actual: ' + (-134217728 >> 3)); 
} 


if (-268435456 >> 3 !== -33554432) { 
  $ERROR('#125: -268435456 >> 3 === -33554432. Actual: ' + (-268435456 >> 3)); 
} 


if (-536870912 >> 3 !== -67108864) { 
  $ERROR('#126: -536870912 >> 3 === -67108864. Actual: ' + (-536870912 >> 3)); 
} 


if (-1073741824 >> 3 !== -134217728) { 
  $ERROR('#127: -1073741824 >> 3 === -134217728. Actual: ' + (-1073741824 >> 3)); 
} 


if (-2147483648 >> 3 !== -268435456) { 
  $ERROR('#128: -2147483648 >> 3 === -268435456. Actual: ' + (-2147483648 >> 3)); 
} 


if (-1 >> 4 !== -1) { 
  $ERROR('#129: -1 >> 4 === -1. Actual: ' + (-1 >> 4)); 
} 


if (-2 >> 4 !== -1) { 
  $ERROR('#130: -2 >> 4 === -1. Actual: ' + (-2 >> 4)); 
} 


if (-4 >> 4 !== -1) { 
  $ERROR('#131: -4 >> 4 === -1. Actual: ' + (-4 >> 4)); 
} 


if (-8 >> 4 !== -1) { 
  $ERROR('#132: -8 >> 4 === -1. Actual: ' + (-8 >> 4)); 
} 


if (-16 >> 4 !== -1) { 
  $ERROR('#133: -16 >> 4 === -1. Actual: ' + (-16 >> 4)); 
} 


if (-32 >> 4 !== -2) { 
  $ERROR('#134: -32 >> 4 === -2. Actual: ' + (-32 >> 4)); 
} 


if (-64 >> 4 !== -4) { 
  $ERROR('#135: -64 >> 4 === -4. Actual: ' + (-64 >> 4)); 
} 


if (-128 >> 4 !== -8) { 
  $ERROR('#136: -128 >> 4 === -8. Actual: ' + (-128 >> 4)); 
} 


if (-256 >> 4 !== -16) { 
  $ERROR('#137: -256 >> 4 === -16. Actual: ' + (-256 >> 4)); 
} 


if (-512 >> 4 !== -32) { 
  $ERROR('#138: -512 >> 4 === -32. Actual: ' + (-512 >> 4)); 
} 


if (-1024 >> 4 !== -64) { 
  $ERROR('#139: -1024 >> 4 === -64. Actual: ' + (-1024 >> 4)); 
} 


if (-2048 >> 4 !== -128) { 
  $ERROR('#140: -2048 >> 4 === -128. Actual: ' + (-2048 >> 4)); 
} 


if (-4096 >> 4 !== -256) { 
  $ERROR('#141: -4096 >> 4 === -256. Actual: ' + (-4096 >> 4)); 
} 


if (-8192 >> 4 !== -512) { 
  $ERROR('#142: -8192 >> 4 === -512. Actual: ' + (-8192 >> 4)); 
} 


if (-16384 >> 4 !== -1024) { 
  $ERROR('#143: -16384 >> 4 === -1024. Actual: ' + (-16384 >> 4)); 
} 


if (-32768 >> 4 !== -2048) { 
  $ERROR('#144: -32768 >> 4 === -2048. Actual: ' + (-32768 >> 4)); 
} 


if (-65536 >> 4 !== -4096) { 
  $ERROR('#145: -65536 >> 4 === -4096. Actual: ' + (-65536 >> 4)); 
} 


if (-131072 >> 4 !== -8192) { 
  $ERROR('#146: -131072 >> 4 === -8192. Actual: ' + (-131072 >> 4)); 
} 


if (-262144 >> 4 !== -16384) { 
  $ERROR('#147: -262144 >> 4 === -16384. Actual: ' + (-262144 >> 4)); 
} 


if (-524288 >> 4 !== -32768) { 
  $ERROR('#148: -524288 >> 4 === -32768. Actual: ' + (-524288 >> 4)); 
} 


if (-1048576 >> 4 !== -65536) { 
  $ERROR('#149: -1048576 >> 4 === -65536. Actual: ' + (-1048576 >> 4)); 
} 


if (-2097152 >> 4 !== -131072) { 
  $ERROR('#150: -2097152 >> 4 === -131072. Actual: ' + (-2097152 >> 4)); 
} 


if (-4194304 >> 4 !== -262144) { 
  $ERROR('#151: -4194304 >> 4 === -262144. Actual: ' + (-4194304 >> 4)); 
} 


if (-8388608 >> 4 !== -524288) { 
  $ERROR('#152: -8388608 >> 4 === -524288. Actual: ' + (-8388608 >> 4)); 
} 


if (-16777216 >> 4 !== -1048576) { 
  $ERROR('#153: -16777216 >> 4 === -1048576. Actual: ' + (-16777216 >> 4)); 
} 


if (-33554432 >> 4 !== -2097152) { 
  $ERROR('#154: -33554432 >> 4 === -2097152. Actual: ' + (-33554432 >> 4)); 
} 


if (-67108864 >> 4 !== -4194304) { 
  $ERROR('#155: -67108864 >> 4 === -4194304. Actual: ' + (-67108864 >> 4)); 
} 


if (-134217728 >> 4 !== -8388608) { 
  $ERROR('#156: -134217728 >> 4 === -8388608. Actual: ' + (-134217728 >> 4)); 
} 


if (-268435456 >> 4 !== -16777216) { 
  $ERROR('#157: -268435456 >> 4 === -16777216. Actual: ' + (-268435456 >> 4)); 
} 


if (-536870912 >> 4 !== -33554432) { 
  $ERROR('#158: -536870912 >> 4 === -33554432. Actual: ' + (-536870912 >> 4)); 
} 


if (-1073741824 >> 4 !== -67108864) { 
  $ERROR('#159: -1073741824 >> 4 === -67108864. Actual: ' + (-1073741824 >> 4)); 
} 


if (-2147483648 >> 4 !== -134217728) { 
  $ERROR('#160: -2147483648 >> 4 === -134217728. Actual: ' + (-2147483648 >> 4)); 
} 


if (-1 >> 5 !== -1) { 
  $ERROR('#161: -1 >> 5 === -1. Actual: ' + (-1 >> 5)); 
} 


if (-2 >> 5 !== -1) { 
  $ERROR('#162: -2 >> 5 === -1. Actual: ' + (-2 >> 5)); 
} 


if (-4 >> 5 !== -1) { 
  $ERROR('#163: -4 >> 5 === -1. Actual: ' + (-4 >> 5)); 
} 


if (-8 >> 5 !== -1) { 
  $ERROR('#164: -8 >> 5 === -1. Actual: ' + (-8 >> 5)); 
} 


if (-16 >> 5 !== -1) { 
  $ERROR('#165: -16 >> 5 === -1. Actual: ' + (-16 >> 5)); 
} 


if (-32 >> 5 !== -1) { 
  $ERROR('#166: -32 >> 5 === -1. Actual: ' + (-32 >> 5)); 
} 


if (-64 >> 5 !== -2) { 
  $ERROR('#167: -64 >> 5 === -2. Actual: ' + (-64 >> 5)); 
} 


if (-128 >> 5 !== -4) { 
  $ERROR('#168: -128 >> 5 === -4. Actual: ' + (-128 >> 5)); 
} 


if (-256 >> 5 !== -8) { 
  $ERROR('#169: -256 >> 5 === -8. Actual: ' + (-256 >> 5)); 
} 


if (-512 >> 5 !== -16) { 
  $ERROR('#170: -512 >> 5 === -16. Actual: ' + (-512 >> 5)); 
} 


if (-1024 >> 5 !== -32) { 
  $ERROR('#171: -1024 >> 5 === -32. Actual: ' + (-1024 >> 5)); 
} 


if (-2048 >> 5 !== -64) { 
  $ERROR('#172: -2048 >> 5 === -64. Actual: ' + (-2048 >> 5)); 
} 


if (-4096 >> 5 !== -128) { 
  $ERROR('#173: -4096 >> 5 === -128. Actual: ' + (-4096 >> 5)); 
} 


if (-8192 >> 5 !== -256) { 
  $ERROR('#174: -8192 >> 5 === -256. Actual: ' + (-8192 >> 5)); 
} 


if (-16384 >> 5 !== -512) { 
  $ERROR('#175: -16384 >> 5 === -512. Actual: ' + (-16384 >> 5)); 
} 


if (-32768 >> 5 !== -1024) { 
  $ERROR('#176: -32768 >> 5 === -1024. Actual: ' + (-32768 >> 5)); 
} 


if (-65536 >> 5 !== -2048) { 
  $ERROR('#177: -65536 >> 5 === -2048. Actual: ' + (-65536 >> 5)); 
} 


if (-131072 >> 5 !== -4096) { 
  $ERROR('#178: -131072 >> 5 === -4096. Actual: ' + (-131072 >> 5)); 
} 


if (-262144 >> 5 !== -8192) { 
  $ERROR('#179: -262144 >> 5 === -8192. Actual: ' + (-262144 >> 5)); 
} 


if (-524288 >> 5 !== -16384) { 
  $ERROR('#180: -524288 >> 5 === -16384. Actual: ' + (-524288 >> 5)); 
} 


if (-1048576 >> 5 !== -32768) { 
  $ERROR('#181: -1048576 >> 5 === -32768. Actual: ' + (-1048576 >> 5)); 
} 


if (-2097152 >> 5 !== -65536) { 
  $ERROR('#182: -2097152 >> 5 === -65536. Actual: ' + (-2097152 >> 5)); 
} 


if (-4194304 >> 5 !== -131072) { 
  $ERROR('#183: -4194304 >> 5 === -131072. Actual: ' + (-4194304 >> 5)); 
} 


if (-8388608 >> 5 !== -262144) { 
  $ERROR('#184: -8388608 >> 5 === -262144. Actual: ' + (-8388608 >> 5)); 
} 


if (-16777216 >> 5 !== -524288) { 
  $ERROR('#185: -16777216 >> 5 === -524288. Actual: ' + (-16777216 >> 5)); 
} 


if (-33554432 >> 5 !== -1048576) { 
  $ERROR('#186: -33554432 >> 5 === -1048576. Actual: ' + (-33554432 >> 5)); 
} 


if (-67108864 >> 5 !== -2097152) { 
  $ERROR('#187: -67108864 >> 5 === -2097152. Actual: ' + (-67108864 >> 5)); 
} 


if (-134217728 >> 5 !== -4194304) { 
  $ERROR('#188: -134217728 >> 5 === -4194304. Actual: ' + (-134217728 >> 5)); 
} 


if (-268435456 >> 5 !== -8388608) { 
  $ERROR('#189: -268435456 >> 5 === -8388608. Actual: ' + (-268435456 >> 5)); 
} 


if (-536870912 >> 5 !== -16777216) { 
  $ERROR('#190: -536870912 >> 5 === -16777216. Actual: ' + (-536870912 >> 5)); 
} 


if (-1073741824 >> 5 !== -33554432) { 
  $ERROR('#191: -1073741824 >> 5 === -33554432. Actual: ' + (-1073741824 >> 5)); 
} 


if (-2147483648 >> 5 !== -67108864) { 
  $ERROR('#192: -2147483648 >> 5 === -67108864. Actual: ' + (-2147483648 >> 5)); 
} 


if (-1 >> 6 !== -1) { 
  $ERROR('#193: -1 >> 6 === -1. Actual: ' + (-1 >> 6)); 
} 


if (-2 >> 6 !== -1) { 
  $ERROR('#194: -2 >> 6 === -1. Actual: ' + (-2 >> 6)); 
} 


if (-4 >> 6 !== -1) { 
  $ERROR('#195: -4 >> 6 === -1. Actual: ' + (-4 >> 6)); 
} 


if (-8 >> 6 !== -1) { 
  $ERROR('#196: -8 >> 6 === -1. Actual: ' + (-8 >> 6)); 
} 


if (-16 >> 6 !== -1) { 
  $ERROR('#197: -16 >> 6 === -1. Actual: ' + (-16 >> 6)); 
} 


if (-32 >> 6 !== -1) { 
  $ERROR('#198: -32 >> 6 === -1. Actual: ' + (-32 >> 6)); 
} 


if (-64 >> 6 !== -1) { 
  $ERROR('#199: -64 >> 6 === -1. Actual: ' + (-64 >> 6)); 
} 


if (-128 >> 6 !== -2) { 
  $ERROR('#200: -128 >> 6 === -2. Actual: ' + (-128 >> 6)); 
} 


if (-256 >> 6 !== -4) { 
  $ERROR('#201: -256 >> 6 === -4. Actual: ' + (-256 >> 6)); 
} 


if (-512 >> 6 !== -8) { 
  $ERROR('#202: -512 >> 6 === -8. Actual: ' + (-512 >> 6)); 
} 


if (-1024 >> 6 !== -16) { 
  $ERROR('#203: -1024 >> 6 === -16. Actual: ' + (-1024 >> 6)); 
} 


if (-2048 >> 6 !== -32) { 
  $ERROR('#204: -2048 >> 6 === -32. Actual: ' + (-2048 >> 6)); 
} 


if (-4096 >> 6 !== -64) { 
  $ERROR('#205: -4096 >> 6 === -64. Actual: ' + (-4096 >> 6)); 
} 


if (-8192 >> 6 !== -128) { 
  $ERROR('#206: -8192 >> 6 === -128. Actual: ' + (-8192 >> 6)); 
} 


if (-16384 >> 6 !== -256) { 
  $ERROR('#207: -16384 >> 6 === -256. Actual: ' + (-16384 >> 6)); 
} 


if (-32768 >> 6 !== -512) { 
  $ERROR('#208: -32768 >> 6 === -512. Actual: ' + (-32768 >> 6)); 
} 


if (-65536 >> 6 !== -1024) { 
  $ERROR('#209: -65536 >> 6 === -1024. Actual: ' + (-65536 >> 6)); 
} 


if (-131072 >> 6 !== -2048) { 
  $ERROR('#210: -131072 >> 6 === -2048. Actual: ' + (-131072 >> 6)); 
} 


if (-262144 >> 6 !== -4096) { 
  $ERROR('#211: -262144 >> 6 === -4096. Actual: ' + (-262144 >> 6)); 
} 


if (-524288 >> 6 !== -8192) { 
  $ERROR('#212: -524288 >> 6 === -8192. Actual: ' + (-524288 >> 6)); 
} 


if (-1048576 >> 6 !== -16384) { 
  $ERROR('#213: -1048576 >> 6 === -16384. Actual: ' + (-1048576 >> 6)); 
} 


if (-2097152 >> 6 !== -32768) { 
  $ERROR('#214: -2097152 >> 6 === -32768. Actual: ' + (-2097152 >> 6)); 
} 


if (-4194304 >> 6 !== -65536) { 
  $ERROR('#215: -4194304 >> 6 === -65536. Actual: ' + (-4194304 >> 6)); 
} 


if (-8388608 >> 6 !== -131072) { 
  $ERROR('#216: -8388608 >> 6 === -131072. Actual: ' + (-8388608 >> 6)); 
} 


if (-16777216 >> 6 !== -262144) { 
  $ERROR('#217: -16777216 >> 6 === -262144. Actual: ' + (-16777216 >> 6)); 
} 


if (-33554432 >> 6 !== -524288) { 
  $ERROR('#218: -33554432 >> 6 === -524288. Actual: ' + (-33554432 >> 6)); 
} 


if (-67108864 >> 6 !== -1048576) { 
  $ERROR('#219: -67108864 >> 6 === -1048576. Actual: ' + (-67108864 >> 6)); 
} 


if (-134217728 >> 6 !== -2097152) { 
  $ERROR('#220: -134217728 >> 6 === -2097152. Actual: ' + (-134217728 >> 6)); 
} 


if (-268435456 >> 6 !== -4194304) { 
  $ERROR('#221: -268435456 >> 6 === -4194304. Actual: ' + (-268435456 >> 6)); 
} 


if (-536870912 >> 6 !== -8388608) { 
  $ERROR('#222: -536870912 >> 6 === -8388608. Actual: ' + (-536870912 >> 6)); 
} 


if (-1073741824 >> 6 !== -16777216) { 
  $ERROR('#223: -1073741824 >> 6 === -16777216. Actual: ' + (-1073741824 >> 6)); 
} 


if (-2147483648 >> 6 !== -33554432) { 
  $ERROR('#224: -2147483648 >> 6 === -33554432. Actual: ' + (-2147483648 >> 6)); 
} 


if (-1 >> 7 !== -1) { 
  $ERROR('#225: -1 >> 7 === -1. Actual: ' + (-1 >> 7)); 
} 


if (-2 >> 7 !== -1) { 
  $ERROR('#226: -2 >> 7 === -1. Actual: ' + (-2 >> 7)); 
} 


if (-4 >> 7 !== -1) { 
  $ERROR('#227: -4 >> 7 === -1. Actual: ' + (-4 >> 7)); 
} 


if (-8 >> 7 !== -1) { 
  $ERROR('#228: -8 >> 7 === -1. Actual: ' + (-8 >> 7)); 
} 


if (-16 >> 7 !== -1) { 
  $ERROR('#229: -16 >> 7 === -1. Actual: ' + (-16 >> 7)); 
} 


if (-32 >> 7 !== -1) { 
  $ERROR('#230: -32 >> 7 === -1. Actual: ' + (-32 >> 7)); 
} 


if (-64 >> 7 !== -1) { 
  $ERROR('#231: -64 >> 7 === -1. Actual: ' + (-64 >> 7)); 
} 


if (-128 >> 7 !== -1) { 
  $ERROR('#232: -128 >> 7 === -1. Actual: ' + (-128 >> 7)); 
} 


if (-256 >> 7 !== -2) { 
  $ERROR('#233: -256 >> 7 === -2. Actual: ' + (-256 >> 7)); 
} 


if (-512 >> 7 !== -4) { 
  $ERROR('#234: -512 >> 7 === -4. Actual: ' + (-512 >> 7)); 
} 


if (-1024 >> 7 !== -8) { 
  $ERROR('#235: -1024 >> 7 === -8. Actual: ' + (-1024 >> 7)); 
} 


if (-2048 >> 7 !== -16) { 
  $ERROR('#236: -2048 >> 7 === -16. Actual: ' + (-2048 >> 7)); 
} 


if (-4096 >> 7 !== -32) { 
  $ERROR('#237: -4096 >> 7 === -32. Actual: ' + (-4096 >> 7)); 
} 


if (-8192 >> 7 !== -64) { 
  $ERROR('#238: -8192 >> 7 === -64. Actual: ' + (-8192 >> 7)); 
} 


if (-16384 >> 7 !== -128) { 
  $ERROR('#239: -16384 >> 7 === -128. Actual: ' + (-16384 >> 7)); 
} 


if (-32768 >> 7 !== -256) { 
  $ERROR('#240: -32768 >> 7 === -256. Actual: ' + (-32768 >> 7)); 
} 


if (-65536 >> 7 !== -512) { 
  $ERROR('#241: -65536 >> 7 === -512. Actual: ' + (-65536 >> 7)); 
} 


if (-131072 >> 7 !== -1024) { 
  $ERROR('#242: -131072 >> 7 === -1024. Actual: ' + (-131072 >> 7)); 
} 


if (-262144 >> 7 !== -2048) { 
  $ERROR('#243: -262144 >> 7 === -2048. Actual: ' + (-262144 >> 7)); 
} 


if (-524288 >> 7 !== -4096) { 
  $ERROR('#244: -524288 >> 7 === -4096. Actual: ' + (-524288 >> 7)); 
} 


if (-1048576 >> 7 !== -8192) { 
  $ERROR('#245: -1048576 >> 7 === -8192. Actual: ' + (-1048576 >> 7)); 
} 


if (-2097152 >> 7 !== -16384) { 
  $ERROR('#246: -2097152 >> 7 === -16384. Actual: ' + (-2097152 >> 7)); 
} 


if (-4194304 >> 7 !== -32768) { 
  $ERROR('#247: -4194304 >> 7 === -32768. Actual: ' + (-4194304 >> 7)); 
} 


if (-8388608 >> 7 !== -65536) { 
  $ERROR('#248: -8388608 >> 7 === -65536. Actual: ' + (-8388608 >> 7)); 
} 


if (-16777216 >> 7 !== -131072) { 
  $ERROR('#249: -16777216 >> 7 === -131072. Actual: ' + (-16777216 >> 7)); 
} 


if (-33554432 >> 7 !== -262144) { 
  $ERROR('#250: -33554432 >> 7 === -262144. Actual: ' + (-33554432 >> 7)); 
} 


if (-67108864 >> 7 !== -524288) { 
  $ERROR('#251: -67108864 >> 7 === -524288. Actual: ' + (-67108864 >> 7)); 
} 


if (-134217728 >> 7 !== -1048576) { 
  $ERROR('#252: -134217728 >> 7 === -1048576. Actual: ' + (-134217728 >> 7)); 
} 


if (-268435456 >> 7 !== -2097152) { 
  $ERROR('#253: -268435456 >> 7 === -2097152. Actual: ' + (-268435456 >> 7)); 
} 


if (-536870912 >> 7 !== -4194304) { 
  $ERROR('#254: -536870912 >> 7 === -4194304. Actual: ' + (-536870912 >> 7)); 
} 


if (-1073741824 >> 7 !== -8388608) { 
  $ERROR('#255: -1073741824 >> 7 === -8388608. Actual: ' + (-1073741824 >> 7)); 
} 


if (-2147483648 >> 7 !== -16777216) { 
  $ERROR('#256: -2147483648 >> 7 === -16777216. Actual: ' + (-2147483648 >> 7)); 
} 


if (-1 >> 8 !== -1) { 
  $ERROR('#257: -1 >> 8 === -1. Actual: ' + (-1 >> 8)); 
} 


if (-2 >> 8 !== -1) { 
  $ERROR('#258: -2 >> 8 === -1. Actual: ' + (-2 >> 8)); 
} 


if (-4 >> 8 !== -1) { 
  $ERROR('#259: -4 >> 8 === -1. Actual: ' + (-4 >> 8)); 
} 


if (-8 >> 8 !== -1) { 
  $ERROR('#260: -8 >> 8 === -1. Actual: ' + (-8 >> 8)); 
} 


if (-16 >> 8 !== -1) { 
  $ERROR('#261: -16 >> 8 === -1. Actual: ' + (-16 >> 8)); 
} 


if (-32 >> 8 !== -1) { 
  $ERROR('#262: -32 >> 8 === -1. Actual: ' + (-32 >> 8)); 
} 


if (-64 >> 8 !== -1) { 
  $ERROR('#263: -64 >> 8 === -1. Actual: ' + (-64 >> 8)); 
} 


if (-128 >> 8 !== -1) { 
  $ERROR('#264: -128 >> 8 === -1. Actual: ' + (-128 >> 8)); 
} 


if (-256 >> 8 !== -1) { 
  $ERROR('#265: -256 >> 8 === -1. Actual: ' + (-256 >> 8)); 
} 


if (-512 >> 8 !== -2) { 
  $ERROR('#266: -512 >> 8 === -2. Actual: ' + (-512 >> 8)); 
} 


if (-1024 >> 8 !== -4) { 
  $ERROR('#267: -1024 >> 8 === -4. Actual: ' + (-1024 >> 8)); 
} 


if (-2048 >> 8 !== -8) { 
  $ERROR('#268: -2048 >> 8 === -8. Actual: ' + (-2048 >> 8)); 
} 


if (-4096 >> 8 !== -16) { 
  $ERROR('#269: -4096 >> 8 === -16. Actual: ' + (-4096 >> 8)); 
} 


if (-8192 >> 8 !== -32) { 
  $ERROR('#270: -8192 >> 8 === -32. Actual: ' + (-8192 >> 8)); 
} 


if (-16384 >> 8 !== -64) { 
  $ERROR('#271: -16384 >> 8 === -64. Actual: ' + (-16384 >> 8)); 
} 


if (-32768 >> 8 !== -128) { 
  $ERROR('#272: -32768 >> 8 === -128. Actual: ' + (-32768 >> 8)); 
} 


if (-65536 >> 8 !== -256) { 
  $ERROR('#273: -65536 >> 8 === -256. Actual: ' + (-65536 >> 8)); 
} 


if (-131072 >> 8 !== -512) { 
  $ERROR('#274: -131072 >> 8 === -512. Actual: ' + (-131072 >> 8)); 
} 


if (-262144 >> 8 !== -1024) { 
  $ERROR('#275: -262144 >> 8 === -1024. Actual: ' + (-262144 >> 8)); 
} 


if (-524288 >> 8 !== -2048) { 
  $ERROR('#276: -524288 >> 8 === -2048. Actual: ' + (-524288 >> 8)); 
} 


if (-1048576 >> 8 !== -4096) { 
  $ERROR('#277: -1048576 >> 8 === -4096. Actual: ' + (-1048576 >> 8)); 
} 


if (-2097152 >> 8 !== -8192) { 
  $ERROR('#278: -2097152 >> 8 === -8192. Actual: ' + (-2097152 >> 8)); 
} 


if (-4194304 >> 8 !== -16384) { 
  $ERROR('#279: -4194304 >> 8 === -16384. Actual: ' + (-4194304 >> 8)); 
} 


if (-8388608 >> 8 !== -32768) { 
  $ERROR('#280: -8388608 >> 8 === -32768. Actual: ' + (-8388608 >> 8)); 
} 


if (-16777216 >> 8 !== -65536) { 
  $ERROR('#281: -16777216 >> 8 === -65536. Actual: ' + (-16777216 >> 8)); 
} 


if (-33554432 >> 8 !== -131072) { 
  $ERROR('#282: -33554432 >> 8 === -131072. Actual: ' + (-33554432 >> 8)); 
} 


if (-67108864 >> 8 !== -262144) { 
  $ERROR('#283: -67108864 >> 8 === -262144. Actual: ' + (-67108864 >> 8)); 
} 


if (-134217728 >> 8 !== -524288) { 
  $ERROR('#284: -134217728 >> 8 === -524288. Actual: ' + (-134217728 >> 8)); 
} 


if (-268435456 >> 8 !== -1048576) { 
  $ERROR('#285: -268435456 >> 8 === -1048576. Actual: ' + (-268435456 >> 8)); 
} 


if (-536870912 >> 8 !== -2097152) { 
  $ERROR('#286: -536870912 >> 8 === -2097152. Actual: ' + (-536870912 >> 8)); 
} 


if (-1073741824 >> 8 !== -4194304) { 
  $ERROR('#287: -1073741824 >> 8 === -4194304. Actual: ' + (-1073741824 >> 8)); 
} 


if (-2147483648 >> 8 !== -8388608) { 
  $ERROR('#288: -2147483648 >> 8 === -8388608. Actual: ' + (-2147483648 >> 8)); 
} 


if (-1 >> 9 !== -1) { 
  $ERROR('#289: -1 >> 9 === -1. Actual: ' + (-1 >> 9)); 
} 


if (-2 >> 9 !== -1) { 
  $ERROR('#290: -2 >> 9 === -1. Actual: ' + (-2 >> 9)); 
} 


if (-4 >> 9 !== -1) { 
  $ERROR('#291: -4 >> 9 === -1. Actual: ' + (-4 >> 9)); 
} 


if (-8 >> 9 !== -1) { 
  $ERROR('#292: -8 >> 9 === -1. Actual: ' + (-8 >> 9)); 
} 


if (-16 >> 9 !== -1) { 
  $ERROR('#293: -16 >> 9 === -1. Actual: ' + (-16 >> 9)); 
} 


if (-32 >> 9 !== -1) { 
  $ERROR('#294: -32 >> 9 === -1. Actual: ' + (-32 >> 9)); 
} 


if (-64 >> 9 !== -1) { 
  $ERROR('#295: -64 >> 9 === -1. Actual: ' + (-64 >> 9)); 
} 


if (-128 >> 9 !== -1) { 
  $ERROR('#296: -128 >> 9 === -1. Actual: ' + (-128 >> 9)); 
} 


if (-256 >> 9 !== -1) { 
  $ERROR('#297: -256 >> 9 === -1. Actual: ' + (-256 >> 9)); 
} 


if (-512 >> 9 !== -1) { 
  $ERROR('#298: -512 >> 9 === -1. Actual: ' + (-512 >> 9)); 
} 


if (-1024 >> 9 !== -2) { 
  $ERROR('#299: -1024 >> 9 === -2. Actual: ' + (-1024 >> 9)); 
} 


if (-2048 >> 9 !== -4) { 
  $ERROR('#300: -2048 >> 9 === -4. Actual: ' + (-2048 >> 9)); 
} 


if (-4096 >> 9 !== -8) { 
  $ERROR('#301: -4096 >> 9 === -8. Actual: ' + (-4096 >> 9)); 
} 


if (-8192 >> 9 !== -16) { 
  $ERROR('#302: -8192 >> 9 === -16. Actual: ' + (-8192 >> 9)); 
} 


if (-16384 >> 9 !== -32) { 
  $ERROR('#303: -16384 >> 9 === -32. Actual: ' + (-16384 >> 9)); 
} 


if (-32768 >> 9 !== -64) { 
  $ERROR('#304: -32768 >> 9 === -64. Actual: ' + (-32768 >> 9)); 
} 


if (-65536 >> 9 !== -128) { 
  $ERROR('#305: -65536 >> 9 === -128. Actual: ' + (-65536 >> 9)); 
} 


if (-131072 >> 9 !== -256) { 
  $ERROR('#306: -131072 >> 9 === -256. Actual: ' + (-131072 >> 9)); 
} 


if (-262144 >> 9 !== -512) { 
  $ERROR('#307: -262144 >> 9 === -512. Actual: ' + (-262144 >> 9)); 
} 


if (-524288 >> 9 !== -1024) { 
  $ERROR('#308: -524288 >> 9 === -1024. Actual: ' + (-524288 >> 9)); 
} 


if (-1048576 >> 9 !== -2048) { 
  $ERROR('#309: -1048576 >> 9 === -2048. Actual: ' + (-1048576 >> 9)); 
} 


if (-2097152 >> 9 !== -4096) { 
  $ERROR('#310: -2097152 >> 9 === -4096. Actual: ' + (-2097152 >> 9)); 
} 


if (-4194304 >> 9 !== -8192) { 
  $ERROR('#311: -4194304 >> 9 === -8192. Actual: ' + (-4194304 >> 9)); 
} 


if (-8388608 >> 9 !== -16384) { 
  $ERROR('#312: -8388608 >> 9 === -16384. Actual: ' + (-8388608 >> 9)); 
} 


if (-16777216 >> 9 !== -32768) { 
  $ERROR('#313: -16777216 >> 9 === -32768. Actual: ' + (-16777216 >> 9)); 
} 


if (-33554432 >> 9 !== -65536) { 
  $ERROR('#314: -33554432 >> 9 === -65536. Actual: ' + (-33554432 >> 9)); 
} 


if (-67108864 >> 9 !== -131072) { 
  $ERROR('#315: -67108864 >> 9 === -131072. Actual: ' + (-67108864 >> 9)); 
} 


if (-134217728 >> 9 !== -262144) { 
  $ERROR('#316: -134217728 >> 9 === -262144. Actual: ' + (-134217728 >> 9)); 
} 


if (-268435456 >> 9 !== -524288) { 
  $ERROR('#317: -268435456 >> 9 === -524288. Actual: ' + (-268435456 >> 9)); 
} 


if (-536870912 >> 9 !== -1048576) { 
  $ERROR('#318: -536870912 >> 9 === -1048576. Actual: ' + (-536870912 >> 9)); 
} 


if (-1073741824 >> 9 !== -2097152) { 
  $ERROR('#319: -1073741824 >> 9 === -2097152. Actual: ' + (-1073741824 >> 9)); 
} 


if (-2147483648 >> 9 !== -4194304) { 
  $ERROR('#320: -2147483648 >> 9 === -4194304. Actual: ' + (-2147483648 >> 9)); 
} 


if (-1 >> 10 !== -1) { 
  $ERROR('#321: -1 >> 10 === -1. Actual: ' + (-1 >> 10)); 
} 


if (-2 >> 10 !== -1) { 
  $ERROR('#322: -2 >> 10 === -1. Actual: ' + (-2 >> 10)); 
} 


if (-4 >> 10 !== -1) { 
  $ERROR('#323: -4 >> 10 === -1. Actual: ' + (-4 >> 10)); 
} 


if (-8 >> 10 !== -1) { 
  $ERROR('#324: -8 >> 10 === -1. Actual: ' + (-8 >> 10)); 
} 


if (-16 >> 10 !== -1) { 
  $ERROR('#325: -16 >> 10 === -1. Actual: ' + (-16 >> 10)); 
} 


if (-32 >> 10 !== -1) { 
  $ERROR('#326: -32 >> 10 === -1. Actual: ' + (-32 >> 10)); 
} 


if (-64 >> 10 !== -1) { 
  $ERROR('#327: -64 >> 10 === -1. Actual: ' + (-64 >> 10)); 
} 


if (-128 >> 10 !== -1) { 
  $ERROR('#328: -128 >> 10 === -1. Actual: ' + (-128 >> 10)); 
} 


if (-256 >> 10 !== -1) { 
  $ERROR('#329: -256 >> 10 === -1. Actual: ' + (-256 >> 10)); 
} 


if (-512 >> 10 !== -1) { 
  $ERROR('#330: -512 >> 10 === -1. Actual: ' + (-512 >> 10)); 
} 


if (-1024 >> 10 !== -1) { 
  $ERROR('#331: -1024 >> 10 === -1. Actual: ' + (-1024 >> 10)); 
} 


if (-2048 >> 10 !== -2) { 
  $ERROR('#332: -2048 >> 10 === -2. Actual: ' + (-2048 >> 10)); 
} 


if (-4096 >> 10 !== -4) { 
  $ERROR('#333: -4096 >> 10 === -4. Actual: ' + (-4096 >> 10)); 
} 


if (-8192 >> 10 !== -8) { 
  $ERROR('#334: -8192 >> 10 === -8. Actual: ' + (-8192 >> 10)); 
} 


if (-16384 >> 10 !== -16) { 
  $ERROR('#335: -16384 >> 10 === -16. Actual: ' + (-16384 >> 10)); 
} 


if (-32768 >> 10 !== -32) { 
  $ERROR('#336: -32768 >> 10 === -32. Actual: ' + (-32768 >> 10)); 
} 


if (-65536 >> 10 !== -64) { 
  $ERROR('#337: -65536 >> 10 === -64. Actual: ' + (-65536 >> 10)); 
} 


if (-131072 >> 10 !== -128) { 
  $ERROR('#338: -131072 >> 10 === -128. Actual: ' + (-131072 >> 10)); 
} 


if (-262144 >> 10 !== -256) { 
  $ERROR('#339: -262144 >> 10 === -256. Actual: ' + (-262144 >> 10)); 
} 


if (-524288 >> 10 !== -512) { 
  $ERROR('#340: -524288 >> 10 === -512. Actual: ' + (-524288 >> 10)); 
} 


if (-1048576 >> 10 !== -1024) { 
  $ERROR('#341: -1048576 >> 10 === -1024. Actual: ' + (-1048576 >> 10)); 
} 


if (-2097152 >> 10 !== -2048) { 
  $ERROR('#342: -2097152 >> 10 === -2048. Actual: ' + (-2097152 >> 10)); 
} 


if (-4194304 >> 10 !== -4096) { 
  $ERROR('#343: -4194304 >> 10 === -4096. Actual: ' + (-4194304 >> 10)); 
} 


if (-8388608 >> 10 !== -8192) { 
  $ERROR('#344: -8388608 >> 10 === -8192. Actual: ' + (-8388608 >> 10)); 
} 


if (-16777216 >> 10 !== -16384) { 
  $ERROR('#345: -16777216 >> 10 === -16384. Actual: ' + (-16777216 >> 10)); 
} 


if (-33554432 >> 10 !== -32768) { 
  $ERROR('#346: -33554432 >> 10 === -32768. Actual: ' + (-33554432 >> 10)); 
} 


if (-67108864 >> 10 !== -65536) { 
  $ERROR('#347: -67108864 >> 10 === -65536. Actual: ' + (-67108864 >> 10)); 
} 


if (-134217728 >> 10 !== -131072) { 
  $ERROR('#348: -134217728 >> 10 === -131072. Actual: ' + (-134217728 >> 10)); 
} 


if (-268435456 >> 10 !== -262144) { 
  $ERROR('#349: -268435456 >> 10 === -262144. Actual: ' + (-268435456 >> 10)); 
} 


if (-536870912 >> 10 !== -524288) { 
  $ERROR('#350: -536870912 >> 10 === -524288. Actual: ' + (-536870912 >> 10)); 
} 


if (-1073741824 >> 10 !== -1048576) { 
  $ERROR('#351: -1073741824 >> 10 === -1048576. Actual: ' + (-1073741824 >> 10)); 
} 


if (-2147483648 >> 10 !== -2097152) { 
  $ERROR('#352: -2147483648 >> 10 === -2097152. Actual: ' + (-2147483648 >> 10)); 
} 


if (-1 >> 11 !== -1) { 
  $ERROR('#353: -1 >> 11 === -1. Actual: ' + (-1 >> 11)); 
} 


if (-2 >> 11 !== -1) { 
  $ERROR('#354: -2 >> 11 === -1. Actual: ' + (-2 >> 11)); 
} 


if (-4 >> 11 !== -1) { 
  $ERROR('#355: -4 >> 11 === -1. Actual: ' + (-4 >> 11)); 
} 


if (-8 >> 11 !== -1) { 
  $ERROR('#356: -8 >> 11 === -1. Actual: ' + (-8 >> 11)); 
} 


if (-16 >> 11 !== -1) { 
  $ERROR('#357: -16 >> 11 === -1. Actual: ' + (-16 >> 11)); 
} 


if (-32 >> 11 !== -1) { 
  $ERROR('#358: -32 >> 11 === -1. Actual: ' + (-32 >> 11)); 
} 


if (-64 >> 11 !== -1) { 
  $ERROR('#359: -64 >> 11 === -1. Actual: ' + (-64 >> 11)); 
} 


if (-128 >> 11 !== -1) { 
  $ERROR('#360: -128 >> 11 === -1. Actual: ' + (-128 >> 11)); 
} 


if (-256 >> 11 !== -1) { 
  $ERROR('#361: -256 >> 11 === -1. Actual: ' + (-256 >> 11)); 
} 


if (-512 >> 11 !== -1) { 
  $ERROR('#362: -512 >> 11 === -1. Actual: ' + (-512 >> 11)); 
} 


if (-1024 >> 11 !== -1) { 
  $ERROR('#363: -1024 >> 11 === -1. Actual: ' + (-1024 >> 11)); 
} 


if (-2048 >> 11 !== -1) { 
  $ERROR('#364: -2048 >> 11 === -1. Actual: ' + (-2048 >> 11)); 
} 


if (-4096 >> 11 !== -2) { 
  $ERROR('#365: -4096 >> 11 === -2. Actual: ' + (-4096 >> 11)); 
} 


if (-8192 >> 11 !== -4) { 
  $ERROR('#366: -8192 >> 11 === -4. Actual: ' + (-8192 >> 11)); 
} 


if (-16384 >> 11 !== -8) { 
  $ERROR('#367: -16384 >> 11 === -8. Actual: ' + (-16384 >> 11)); 
} 


if (-32768 >> 11 !== -16) { 
  $ERROR('#368: -32768 >> 11 === -16. Actual: ' + (-32768 >> 11)); 
} 


if (-65536 >> 11 !== -32) { 
  $ERROR('#369: -65536 >> 11 === -32. Actual: ' + (-65536 >> 11)); 
} 


if (-131072 >> 11 !== -64) { 
  $ERROR('#370: -131072 >> 11 === -64. Actual: ' + (-131072 >> 11)); 
} 


if (-262144 >> 11 !== -128) { 
  $ERROR('#371: -262144 >> 11 === -128. Actual: ' + (-262144 >> 11)); 
} 


if (-524288 >> 11 !== -256) { 
  $ERROR('#372: -524288 >> 11 === -256. Actual: ' + (-524288 >> 11)); 
} 


if (-1048576 >> 11 !== -512) { 
  $ERROR('#373: -1048576 >> 11 === -512. Actual: ' + (-1048576 >> 11)); 
} 


if (-2097152 >> 11 !== -1024) { 
  $ERROR('#374: -2097152 >> 11 === -1024. Actual: ' + (-2097152 >> 11)); 
} 


if (-4194304 >> 11 !== -2048) { 
  $ERROR('#375: -4194304 >> 11 === -2048. Actual: ' + (-4194304 >> 11)); 
} 


if (-8388608 >> 11 !== -4096) { 
  $ERROR('#376: -8388608 >> 11 === -4096. Actual: ' + (-8388608 >> 11)); 
} 


if (-16777216 >> 11 !== -8192) { 
  $ERROR('#377: -16777216 >> 11 === -8192. Actual: ' + (-16777216 >> 11)); 
} 


if (-33554432 >> 11 !== -16384) { 
  $ERROR('#378: -33554432 >> 11 === -16384. Actual: ' + (-33554432 >> 11)); 
} 


if (-67108864 >> 11 !== -32768) { 
  $ERROR('#379: -67108864 >> 11 === -32768. Actual: ' + (-67108864 >> 11)); 
} 


if (-134217728 >> 11 !== -65536) { 
  $ERROR('#380: -134217728 >> 11 === -65536. Actual: ' + (-134217728 >> 11)); 
} 


if (-268435456 >> 11 !== -131072) { 
  $ERROR('#381: -268435456 >> 11 === -131072. Actual: ' + (-268435456 >> 11)); 
} 


if (-536870912 >> 11 !== -262144) { 
  $ERROR('#382: -536870912 >> 11 === -262144. Actual: ' + (-536870912 >> 11)); 
} 


if (-1073741824 >> 11 !== -524288) { 
  $ERROR('#383: -1073741824 >> 11 === -524288. Actual: ' + (-1073741824 >> 11)); 
} 


if (-2147483648 >> 11 !== -1048576) { 
  $ERROR('#384: -2147483648 >> 11 === -1048576. Actual: ' + (-2147483648 >> 11)); 
} 


if (-1 >> 12 !== -1) { 
  $ERROR('#385: -1 >> 12 === -1. Actual: ' + (-1 >> 12)); 
} 


if (-2 >> 12 !== -1) { 
  $ERROR('#386: -2 >> 12 === -1. Actual: ' + (-2 >> 12)); 
} 


if (-4 >> 12 !== -1) { 
  $ERROR('#387: -4 >> 12 === -1. Actual: ' + (-4 >> 12)); 
} 


if (-8 >> 12 !== -1) { 
  $ERROR('#388: -8 >> 12 === -1. Actual: ' + (-8 >> 12)); 
} 


if (-16 >> 12 !== -1) { 
  $ERROR('#389: -16 >> 12 === -1. Actual: ' + (-16 >> 12)); 
} 


if (-32 >> 12 !== -1) { 
  $ERROR('#390: -32 >> 12 === -1. Actual: ' + (-32 >> 12)); 
} 


if (-64 >> 12 !== -1) { 
  $ERROR('#391: -64 >> 12 === -1. Actual: ' + (-64 >> 12)); 
} 


if (-128 >> 12 !== -1) { 
  $ERROR('#392: -128 >> 12 === -1. Actual: ' + (-128 >> 12)); 
} 


if (-256 >> 12 !== -1) { 
  $ERROR('#393: -256 >> 12 === -1. Actual: ' + (-256 >> 12)); 
} 


if (-512 >> 12 !== -1) { 
  $ERROR('#394: -512 >> 12 === -1. Actual: ' + (-512 >> 12)); 
} 


if (-1024 >> 12 !== -1) { 
  $ERROR('#395: -1024 >> 12 === -1. Actual: ' + (-1024 >> 12)); 
} 


if (-2048 >> 12 !== -1) { 
  $ERROR('#396: -2048 >> 12 === -1. Actual: ' + (-2048 >> 12)); 
} 


if (-4096 >> 12 !== -1) { 
  $ERROR('#397: -4096 >> 12 === -1. Actual: ' + (-4096 >> 12)); 
} 


if (-8192 >> 12 !== -2) { 
  $ERROR('#398: -8192 >> 12 === -2. Actual: ' + (-8192 >> 12)); 
} 


if (-16384 >> 12 !== -4) { 
  $ERROR('#399: -16384 >> 12 === -4. Actual: ' + (-16384 >> 12)); 
} 


if (-32768 >> 12 !== -8) { 
  $ERROR('#400: -32768 >> 12 === -8. Actual: ' + (-32768 >> 12)); 
} 


if (-65536 >> 12 !== -16) { 
  $ERROR('#401: -65536 >> 12 === -16. Actual: ' + (-65536 >> 12)); 
} 


if (-131072 >> 12 !== -32) { 
  $ERROR('#402: -131072 >> 12 === -32. Actual: ' + (-131072 >> 12)); 
} 


if (-262144 >> 12 !== -64) { 
  $ERROR('#403: -262144 >> 12 === -64. Actual: ' + (-262144 >> 12)); 
} 


if (-524288 >> 12 !== -128) { 
  $ERROR('#404: -524288 >> 12 === -128. Actual: ' + (-524288 >> 12)); 
} 


if (-1048576 >> 12 !== -256) { 
  $ERROR('#405: -1048576 >> 12 === -256. Actual: ' + (-1048576 >> 12)); 
} 


if (-2097152 >> 12 !== -512) { 
  $ERROR('#406: -2097152 >> 12 === -512. Actual: ' + (-2097152 >> 12)); 
} 


if (-4194304 >> 12 !== -1024) { 
  $ERROR('#407: -4194304 >> 12 === -1024. Actual: ' + (-4194304 >> 12)); 
} 


if (-8388608 >> 12 !== -2048) { 
  $ERROR('#408: -8388608 >> 12 === -2048. Actual: ' + (-8388608 >> 12)); 
} 


if (-16777216 >> 12 !== -4096) { 
  $ERROR('#409: -16777216 >> 12 === -4096. Actual: ' + (-16777216 >> 12)); 
} 


if (-33554432 >> 12 !== -8192) { 
  $ERROR('#410: -33554432 >> 12 === -8192. Actual: ' + (-33554432 >> 12)); 
} 


if (-67108864 >> 12 !== -16384) { 
  $ERROR('#411: -67108864 >> 12 === -16384. Actual: ' + (-67108864 >> 12)); 
} 


if (-134217728 >> 12 !== -32768) { 
  $ERROR('#412: -134217728 >> 12 === -32768. Actual: ' + (-134217728 >> 12)); 
} 


if (-268435456 >> 12 !== -65536) { 
  $ERROR('#413: -268435456 >> 12 === -65536. Actual: ' + (-268435456 >> 12)); 
} 


if (-536870912 >> 12 !== -131072) { 
  $ERROR('#414: -536870912 >> 12 === -131072. Actual: ' + (-536870912 >> 12)); 
} 


if (-1073741824 >> 12 !== -262144) { 
  $ERROR('#415: -1073741824 >> 12 === -262144. Actual: ' + (-1073741824 >> 12)); 
} 


if (-2147483648 >> 12 !== -524288) { 
  $ERROR('#416: -2147483648 >> 12 === -524288. Actual: ' + (-2147483648 >> 12)); 
} 


if (-1 >> 13 !== -1) { 
  $ERROR('#417: -1 >> 13 === -1. Actual: ' + (-1 >> 13)); 
} 


if (-2 >> 13 !== -1) { 
  $ERROR('#418: -2 >> 13 === -1. Actual: ' + (-2 >> 13)); 
} 


if (-4 >> 13 !== -1) { 
  $ERROR('#419: -4 >> 13 === -1. Actual: ' + (-4 >> 13)); 
} 


if (-8 >> 13 !== -1) { 
  $ERROR('#420: -8 >> 13 === -1. Actual: ' + (-8 >> 13)); 
} 


if (-16 >> 13 !== -1) { 
  $ERROR('#421: -16 >> 13 === -1. Actual: ' + (-16 >> 13)); 
} 


if (-32 >> 13 !== -1) { 
  $ERROR('#422: -32 >> 13 === -1. Actual: ' + (-32 >> 13)); 
} 


if (-64 >> 13 !== -1) { 
  $ERROR('#423: -64 >> 13 === -1. Actual: ' + (-64 >> 13)); 
} 


if (-128 >> 13 !== -1) { 
  $ERROR('#424: -128 >> 13 === -1. Actual: ' + (-128 >> 13)); 
} 


if (-256 >> 13 !== -1) { 
  $ERROR('#425: -256 >> 13 === -1. Actual: ' + (-256 >> 13)); 
} 


if (-512 >> 13 !== -1) { 
  $ERROR('#426: -512 >> 13 === -1. Actual: ' + (-512 >> 13)); 
} 


if (-1024 >> 13 !== -1) { 
  $ERROR('#427: -1024 >> 13 === -1. Actual: ' + (-1024 >> 13)); 
} 


if (-2048 >> 13 !== -1) { 
  $ERROR('#428: -2048 >> 13 === -1. Actual: ' + (-2048 >> 13)); 
} 


if (-4096 >> 13 !== -1) { 
  $ERROR('#429: -4096 >> 13 === -1. Actual: ' + (-4096 >> 13)); 
} 


if (-8192 >> 13 !== -1) { 
  $ERROR('#430: -8192 >> 13 === -1. Actual: ' + (-8192 >> 13)); 
} 


if (-16384 >> 13 !== -2) { 
  $ERROR('#431: -16384 >> 13 === -2. Actual: ' + (-16384 >> 13)); 
} 


if (-32768 >> 13 !== -4) { 
  $ERROR('#432: -32768 >> 13 === -4. Actual: ' + (-32768 >> 13)); 
} 


if (-65536 >> 13 !== -8) { 
  $ERROR('#433: -65536 >> 13 === -8. Actual: ' + (-65536 >> 13)); 
} 


if (-131072 >> 13 !== -16) { 
  $ERROR('#434: -131072 >> 13 === -16. Actual: ' + (-131072 >> 13)); 
} 


if (-262144 >> 13 !== -32) { 
  $ERROR('#435: -262144 >> 13 === -32. Actual: ' + (-262144 >> 13)); 
} 


if (-524288 >> 13 !== -64) { 
  $ERROR('#436: -524288 >> 13 === -64. Actual: ' + (-524288 >> 13)); 
} 


if (-1048576 >> 13 !== -128) { 
  $ERROR('#437: -1048576 >> 13 === -128. Actual: ' + (-1048576 >> 13)); 
} 


if (-2097152 >> 13 !== -256) { 
  $ERROR('#438: -2097152 >> 13 === -256. Actual: ' + (-2097152 >> 13)); 
} 


if (-4194304 >> 13 !== -512) { 
  $ERROR('#439: -4194304 >> 13 === -512. Actual: ' + (-4194304 >> 13)); 
} 


if (-8388608 >> 13 !== -1024) { 
  $ERROR('#440: -8388608 >> 13 === -1024. Actual: ' + (-8388608 >> 13)); 
} 


if (-16777216 >> 13 !== -2048) { 
  $ERROR('#441: -16777216 >> 13 === -2048. Actual: ' + (-16777216 >> 13)); 
} 


if (-33554432 >> 13 !== -4096) { 
  $ERROR('#442: -33554432 >> 13 === -4096. Actual: ' + (-33554432 >> 13)); 
} 


if (-67108864 >> 13 !== -8192) { 
  $ERROR('#443: -67108864 >> 13 === -8192. Actual: ' + (-67108864 >> 13)); 
} 


if (-134217728 >> 13 !== -16384) { 
  $ERROR('#444: -134217728 >> 13 === -16384. Actual: ' + (-134217728 >> 13)); 
} 


if (-268435456 >> 13 !== -32768) { 
  $ERROR('#445: -268435456 >> 13 === -32768. Actual: ' + (-268435456 >> 13)); 
} 


if (-536870912 >> 13 !== -65536) { 
  $ERROR('#446: -536870912 >> 13 === -65536. Actual: ' + (-536870912 >> 13)); 
} 


if (-1073741824 >> 13 !== -131072) { 
  $ERROR('#447: -1073741824 >> 13 === -131072. Actual: ' + (-1073741824 >> 13)); 
} 


if (-2147483648 >> 13 !== -262144) { 
  $ERROR('#448: -2147483648 >> 13 === -262144. Actual: ' + (-2147483648 >> 13)); 
} 


if (-1 >> 14 !== -1) { 
  $ERROR('#449: -1 >> 14 === -1. Actual: ' + (-1 >> 14)); 
} 


if (-2 >> 14 !== -1) { 
  $ERROR('#450: -2 >> 14 === -1. Actual: ' + (-2 >> 14)); 
} 


if (-4 >> 14 !== -1) { 
  $ERROR('#451: -4 >> 14 === -1. Actual: ' + (-4 >> 14)); 
} 


if (-8 >> 14 !== -1) { 
  $ERROR('#452: -8 >> 14 === -1. Actual: ' + (-8 >> 14)); 
} 


if (-16 >> 14 !== -1) { 
  $ERROR('#453: -16 >> 14 === -1. Actual: ' + (-16 >> 14)); 
} 


if (-32 >> 14 !== -1) { 
  $ERROR('#454: -32 >> 14 === -1. Actual: ' + (-32 >> 14)); 
} 


if (-64 >> 14 !== -1) { 
  $ERROR('#455: -64 >> 14 === -1. Actual: ' + (-64 >> 14)); 
} 


if (-128 >> 14 !== -1) { 
  $ERROR('#456: -128 >> 14 === -1. Actual: ' + (-128 >> 14)); 
} 


if (-256 >> 14 !== -1) { 
  $ERROR('#457: -256 >> 14 === -1. Actual: ' + (-256 >> 14)); 
} 


if (-512 >> 14 !== -1) { 
  $ERROR('#458: -512 >> 14 === -1. Actual: ' + (-512 >> 14)); 
} 


if (-1024 >> 14 !== -1) { 
  $ERROR('#459: -1024 >> 14 === -1. Actual: ' + (-1024 >> 14)); 
} 


if (-2048 >> 14 !== -1) { 
  $ERROR('#460: -2048 >> 14 === -1. Actual: ' + (-2048 >> 14)); 
} 


if (-4096 >> 14 !== -1) { 
  $ERROR('#461: -4096 >> 14 === -1. Actual: ' + (-4096 >> 14)); 
} 


if (-8192 >> 14 !== -1) { 
  $ERROR('#462: -8192 >> 14 === -1. Actual: ' + (-8192 >> 14)); 
} 


if (-16384 >> 14 !== -1) { 
  $ERROR('#463: -16384 >> 14 === -1. Actual: ' + (-16384 >> 14)); 
} 


if (-32768 >> 14 !== -2) { 
  $ERROR('#464: -32768 >> 14 === -2. Actual: ' + (-32768 >> 14)); 
} 


if (-65536 >> 14 !== -4) { 
  $ERROR('#465: -65536 >> 14 === -4. Actual: ' + (-65536 >> 14)); 
} 


if (-131072 >> 14 !== -8) { 
  $ERROR('#466: -131072 >> 14 === -8. Actual: ' + (-131072 >> 14)); 
} 


if (-262144 >> 14 !== -16) { 
  $ERROR('#467: -262144 >> 14 === -16. Actual: ' + (-262144 >> 14)); 
} 


if (-524288 >> 14 !== -32) { 
  $ERROR('#468: -524288 >> 14 === -32. Actual: ' + (-524288 >> 14)); 
} 


if (-1048576 >> 14 !== -64) { 
  $ERROR('#469: -1048576 >> 14 === -64. Actual: ' + (-1048576 >> 14)); 
} 


if (-2097152 >> 14 !== -128) { 
  $ERROR('#470: -2097152 >> 14 === -128. Actual: ' + (-2097152 >> 14)); 
} 


if (-4194304 >> 14 !== -256) { 
  $ERROR('#471: -4194304 >> 14 === -256. Actual: ' + (-4194304 >> 14)); 
} 


if (-8388608 >> 14 !== -512) { 
  $ERROR('#472: -8388608 >> 14 === -512. Actual: ' + (-8388608 >> 14)); 
} 


if (-16777216 >> 14 !== -1024) { 
  $ERROR('#473: -16777216 >> 14 === -1024. Actual: ' + (-16777216 >> 14)); 
} 


if (-33554432 >> 14 !== -2048) { 
  $ERROR('#474: -33554432 >> 14 === -2048. Actual: ' + (-33554432 >> 14)); 
} 


if (-67108864 >> 14 !== -4096) { 
  $ERROR('#475: -67108864 >> 14 === -4096. Actual: ' + (-67108864 >> 14)); 
} 


if (-134217728 >> 14 !== -8192) { 
  $ERROR('#476: -134217728 >> 14 === -8192. Actual: ' + (-134217728 >> 14)); 
} 


if (-268435456 >> 14 !== -16384) { 
  $ERROR('#477: -268435456 >> 14 === -16384. Actual: ' + (-268435456 >> 14)); 
} 


if (-536870912 >> 14 !== -32768) { 
  $ERROR('#478: -536870912 >> 14 === -32768. Actual: ' + (-536870912 >> 14)); 
} 


if (-1073741824 >> 14 !== -65536) { 
  $ERROR('#479: -1073741824 >> 14 === -65536. Actual: ' + (-1073741824 >> 14)); 
} 


if (-2147483648 >> 14 !== -131072) { 
  $ERROR('#480: -2147483648 >> 14 === -131072. Actual: ' + (-2147483648 >> 14)); 
} 


if (-1 >> 15 !== -1) { 
  $ERROR('#481: -1 >> 15 === -1. Actual: ' + (-1 >> 15)); 
} 


if (-2 >> 15 !== -1) { 
  $ERROR('#482: -2 >> 15 === -1. Actual: ' + (-2 >> 15)); 
} 


if (-4 >> 15 !== -1) { 
  $ERROR('#483: -4 >> 15 === -1. Actual: ' + (-4 >> 15)); 
} 


if (-8 >> 15 !== -1) { 
  $ERROR('#484: -8 >> 15 === -1. Actual: ' + (-8 >> 15)); 
} 


if (-16 >> 15 !== -1) { 
  $ERROR('#485: -16 >> 15 === -1. Actual: ' + (-16 >> 15)); 
} 


if (-32 >> 15 !== -1) { 
  $ERROR('#486: -32 >> 15 === -1. Actual: ' + (-32 >> 15)); 
} 


if (-64 >> 15 !== -1) { 
  $ERROR('#487: -64 >> 15 === -1. Actual: ' + (-64 >> 15)); 
} 


if (-128 >> 15 !== -1) { 
  $ERROR('#488: -128 >> 15 === -1. Actual: ' + (-128 >> 15)); 
} 


if (-256 >> 15 !== -1) { 
  $ERROR('#489: -256 >> 15 === -1. Actual: ' + (-256 >> 15)); 
} 


if (-512 >> 15 !== -1) { 
  $ERROR('#490: -512 >> 15 === -1. Actual: ' + (-512 >> 15)); 
} 


if (-1024 >> 15 !== -1) { 
  $ERROR('#491: -1024 >> 15 === -1. Actual: ' + (-1024 >> 15)); 
} 


if (-2048 >> 15 !== -1) { 
  $ERROR('#492: -2048 >> 15 === -1. Actual: ' + (-2048 >> 15)); 
} 


if (-4096 >> 15 !== -1) { 
  $ERROR('#493: -4096 >> 15 === -1. Actual: ' + (-4096 >> 15)); 
} 


if (-8192 >> 15 !== -1) { 
  $ERROR('#494: -8192 >> 15 === -1. Actual: ' + (-8192 >> 15)); 
} 


if (-16384 >> 15 !== -1) { 
  $ERROR('#495: -16384 >> 15 === -1. Actual: ' + (-16384 >> 15)); 
} 


if (-32768 >> 15 !== -1) { 
  $ERROR('#496: -32768 >> 15 === -1. Actual: ' + (-32768 >> 15)); 
} 


if (-65536 >> 15 !== -2) { 
  $ERROR('#497: -65536 >> 15 === -2. Actual: ' + (-65536 >> 15)); 
} 


if (-131072 >> 15 !== -4) { 
  $ERROR('#498: -131072 >> 15 === -4. Actual: ' + (-131072 >> 15)); 
} 


if (-262144 >> 15 !== -8) { 
  $ERROR('#499: -262144 >> 15 === -8. Actual: ' + (-262144 >> 15)); 
} 


if (-524288 >> 15 !== -16) { 
  $ERROR('#500: -524288 >> 15 === -16. Actual: ' + (-524288 >> 15)); 
} 


if (-1048576 >> 15 !== -32) { 
  $ERROR('#501: -1048576 >> 15 === -32. Actual: ' + (-1048576 >> 15)); 
} 


if (-2097152 >> 15 !== -64) { 
  $ERROR('#502: -2097152 >> 15 === -64. Actual: ' + (-2097152 >> 15)); 
} 


if (-4194304 >> 15 !== -128) { 
  $ERROR('#503: -4194304 >> 15 === -128. Actual: ' + (-4194304 >> 15)); 
} 


if (-8388608 >> 15 !== -256) { 
  $ERROR('#504: -8388608 >> 15 === -256. Actual: ' + (-8388608 >> 15)); 
} 


if (-16777216 >> 15 !== -512) { 
  $ERROR('#505: -16777216 >> 15 === -512. Actual: ' + (-16777216 >> 15)); 
} 


if (-33554432 >> 15 !== -1024) { 
  $ERROR('#506: -33554432 >> 15 === -1024. Actual: ' + (-33554432 >> 15)); 
} 


if (-67108864 >> 15 !== -2048) { 
  $ERROR('#507: -67108864 >> 15 === -2048. Actual: ' + (-67108864 >> 15)); 
} 


if (-134217728 >> 15 !== -4096) { 
  $ERROR('#508: -134217728 >> 15 === -4096. Actual: ' + (-134217728 >> 15)); 
} 


if (-268435456 >> 15 !== -8192) { 
  $ERROR('#509: -268435456 >> 15 === -8192. Actual: ' + (-268435456 >> 15)); 
} 


if (-536870912 >> 15 !== -16384) { 
  $ERROR('#510: -536870912 >> 15 === -16384. Actual: ' + (-536870912 >> 15)); 
} 


if (-1073741824 >> 15 !== -32768) { 
  $ERROR('#511: -1073741824 >> 15 === -32768. Actual: ' + (-1073741824 >> 15)); 
} 


if (-2147483648 >> 15 !== -65536) { 
  $ERROR('#512: -2147483648 >> 15 === -65536. Actual: ' + (-2147483648 >> 15)); 
}
