# CMake module to search for the libyaml library
# (library for parsing YAML files)
#
# If it's found it sets LIBYAML_FOUND to TRUE
# and following variables are set:
#    LIBYAML_INCLUDE_DIR
#    LIBYAML_LIBRARY

FIND_LIBRARY(LIBYAML_LIBRARY
  NAMES libyaml yaml
  PATHS
    ${LIBYAML_LIBRARIES}
)

FIND_PATH(LIBYAML_INCLUDE_DIR
  NAMES yaml.h
  PATHS
#   ${libyaml_FRAMEWORK_INCLUDES}
    ${LIBYAML_INCLUDE_DIRS}
    ${LIBYAML_INCLUDE_DIR}
)

MARK_AS_ADVANCED(
  LIBYAML_LIBRARY
  LIBYAML_INCLUDE_DIR
)
SET(LIBYAML_INCLUDE_DIRS "${LIBYAML_INCLUDE_DIR}")
SET(LIBYAML_LIBRARIES "${LIBYAML_LIBRARY}")

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LibYAML DEFAULT_MSG LIBYAML_LIBRARIES LIBYAML_INCLUDE_DIRS)

