%{
#include <malloc.h>
#include <iostream>
#include <stdlib.h>
#include "ordinal.h"
#include <list>
using namespace ord;
#include "intfc.h"
#define main doNotWantMain
int yylex();
int yyerror(char * );
#define YYDEBUG 1

%}
%union {
    int Int ;
    bool boolean ;
    const string * name ;
    const ord::Ordinal * ordinal ;
    const ParseContainer * container ;
    list<const Ordinal *> * ordinalList ;
    list<const string *> * stringList ;
    list<const ParseContainer *> *containerList ;
}


%token <Int>  NUMBER PLUS MINUS ASTERISK NEWLINE 
%token <Int> EXP LPAREN RPAREN ASSIGN COMMA ITER_BEGIN LBRACKET RBRACKET
%token <Int> LESS GTR LEQ GEQ EQUAL DOT BAD OMEGA_BEGIN LSQBRACKET RSQBRACKET
%token <name> NAME STRING 
%type <name> left_assign name name_nl name_number
%type <container> factor expr term base function member_function paren iter
%type <container> brparams admis admis_begin
%type <containerList> parameters opt_parameters expr_list 
%type <stringList> nameSet
%type <Int> cmpoper 
%type <boolean> comparison


%%
line:expr NEWLINE                    { pS->expr($1);  YYACCEPT;  }
    | name_nl                        { pS->expr(pS->evaluate($1));  YYACCEPT;  }
    | left_assign expr_list NEWLINE { pS->assign($1,$2);  YYACCEPT;  }
    | comparison NEWLINE            { YYACCEPT;  }                  
    | NEWLINE                       { YYACCEPT;  }
    ;
expr_list : expr                    {$$=pS->makeContainList($1);}
    | expr_list COMMA expr            {$$=pS->appendContainList($1,$3);}
    ;

left_assign : NAME ASSIGN           {$$ = $1;}
    ;
comparison : expr cmpoper expr      {$$ = pS->compare($1,$2,$3);}
    ;
cmpoper : LESS                  {$$ = LESS;}
    | GTR                       {$$ = GTR;}
    | LEQ                       {$$ = LEQ;}
    | GEQ                       {$$ = GEQ;}
    | EQUAL                     {$$ = EQUAL;}
    ;
expr : expr PLUS term            {$$=pS->operation($1,'+',$3);}      
    | expr MINUS term            {$$=pS->operation($1,'-',$3);}      
    | term                      {$$=$1;}
    ;
term : term ASTERISK factor      {$$=pS->operation($1,'*',$3);}
    | factor                    {$$=$1;}
    ;
factor : base EXP factor         {$$=pS->operation($1,'^',$3);}
    | base                      {$$=$1;}
    ;

base : paren                     {$$=$1;}
      | NUMBER                  {$$=pS->number($1);}
      | function                {$$=$1;}
      | member_function         {$$=$1;}
      | iter                    {$$=$1;}
      | admis                   {$$=$1;}
      | name                    {$$=pS->evaluate($1);}
       ;

paren : LPAREN expr RPAREN       {$$=$2;}
    ;

iter : ITER_BEGIN expr RBRACKET parameters {$$=pS->iterOrd($2,$4);}
iter : ITER_BEGIN expr RBRACKET  {$$=pS->iterOrd($2,NULL);}

admis : ITER_BEGIN expr COMMA expr RBRACKET parameters brparams
        {$$=pS->admisOrd(NULL, $2,$4,$6,$7);}

admis : ITER_BEGIN expr COMMA expr RBRACKET brparams
        {$$=pS->admisOrd(NULL, $2,$4,NULL,$6);}
     ;
admis : admis_begin expr RBRACKET parameters brparams
        {$$=pS->admisOrd($1,$2,new ParseContainer(&(Ordinal::zero)),$4,$5);}
admis : admis_begin expr COMMA expr RBRACKET parameters brparams
        {$$=pS->admisOrd($1,$2,$4,$6,$7);}

admis : admis_begin expr COMMA expr RBRACKET brparams
        {$$=pS->admisOrd($1,$2,$4,NULL,$6);}

admis : admis_begin expr RBRACKET brparams
        {$$=pS->admisOrd($1,$2,new ParseContainer(&(Ordinal::zero)),NULL,$4);}
     ;

admis_begin : OMEGA_BEGIN   {$$=NULL;}
    
    | LSQBRACKET  LSQBRACKET expr RSQBRACKET RSQBRACKET OMEGA_BEGIN {$$=$3;}

brparams : LSQBRACKET expr RSQBRACKET  {$$=$2;}
    |                           {$$=NULL;}
    ;

function: name parameters   {$$=pS->evaluateFunction($1,$2);}
    ;

member_function : name DOT name opt_parameters
            {$$=pS->memberFunction(pS->evaluate($1),$3,$4);}
    |   paren DOT name opt_parameters    {$$=pS->memberFunction($1,$3,$4);}
    |   function DOT name opt_parameters   {$$=pS->memberFunction($1,$3,$4);}
    |   iter DOT name opt_parameters   {$$=pS->memberFunction($1,$3,$4);}
    |   admis DOT name opt_parameters   {$$=pS->memberFunction($1,$3,$4);}
    |   member_function DOT name opt_parameters
            {$$=pS->memberFunction($1,$3,$4);}

    ;
opt_parameters : parameters     {$$=$1;}
    |                           {$$=NULL;}
    ;
parameters : LPAREN expr_list RPAREN {$$=$2;}
    |  LPAREN  RPAREN                       {$$=NULL;}
      ;
name_nl : NAME NEWLINE       {if (pS->checkCmd($1)) YYACCEPT; else $$=$1;}
    | nameSet NEWLINE       {const string * s=pS->checkCommand($1); if (s) $$=s; else YYACCEPT;}
        ;
name : NAME             {$$=$1;}
nameSet : NAME name_number                 {$$ = pS->makeStrList($1,$2); } 
       | nameSet name_number           {$$=pS->appendStrList($1,$2);}
       | nameSet STRING          {$$=pS->appendQuoteList($1,$2);}
       | NAME STRING          {$$ = pS->makeQuoteList($1,$2); } 
       ;

name_number : NAME             {$$=$1;} 
        | NUMBER                {$$ = intToString($1);}
        ;

%%



#include <stdio.h>
int yyerror(char *s)        
{
    printf("%s\n",s);
    return(0);
}


int main(void)
{
    yyparse();
    exit(0);
}

