
//
#include <map>
#include <assert.h>

#include <stdio.h>

extern "C" char * readline(const char *);

#include <readline/history.h>
#include <fstream>
#include <list>
#include <stack>
#include <iomanip>
#include "ordinal.h"
#include "teeStream.h"

using namespace ord;
using namespace std;

#include "intfc.h"
extern const char * version ;

extern int yyparse();
extern int yyerror(char *);
extern char * myReadline(const char * prompt);

static stack<ParseSemantics::FileState*> streamStack ;

const char * ParseSemantics::ordCalc = "ordCalc> " ;

const string * ParseSemantics::fileToRead = NULL ;

 const char ** ParseSemantics::exampleInput = NULL ;


bool inContinue ;


void ParseSemantics::readFromFile(const string * fileName)
{
    fileToRead = fileName ;
}


ParseSemantics::FileState::FileState(string nm, ifstream * str):
line(0),name(nm),stream(str)
{}

ParseSemantics::FileState::~FileState()
{
    delete stream ;
    stream = NULL ;
}

void ParseSemantics::readFromFile()
{
    assert(fileToRead);
    ifstream * streamToRead = new ifstream(fileToRead->c_str());
    if (!streamToRead->good()) {
        *out << "ERROR: Cannot read file '" << *fileToRead << "'.\n" ;
        delete streamToRead ;
        streamToRead = NULL ;
        fileToRead = NULL ;
        return ;
    }
    currentFile = new FileState(*fileToRead,streamToRead);
    fileToRead = NULL ;
    streamStack.push(currentFile);
}

void ParseSemantics::popFile()
{
    assert(streamStack.size()>0);
    FileState * toDelete = streamStack.top();
    streamStack.pop();
    delete toDelete ;
    toDelete = NULL ;
    currentFile = NULL ;
    if (streamStack.size()) currentFile = streamStack.top();
 
}

void ParseSemantics::exampleParse()
{
    assert(exampleInput);
    assert(*exampleInput);
    while(true) {
        *out << ordCalc << *exampleInput << "\n" ;
        yyparse();
        exampleInput++ ;
        if (!*exampleInput) {
            exampleInput = NULL ;
            break ;
        }
    }
}

void ParseSemantics::readline(char * buf, int& char_read, int max_size)
{
    if (exampleInput) {
        int length = strlen(*exampleInput);
        assert((length + 2) < max_size);
        strcpy(buf,*exampleInput);
        char_read = length + 1 ;
        buf[length]='\n' ;
        buf[length+1] = 0 ;
        return ;
    }
    if (fileToRead) readFromFile();
    char * lbuf = NULL;
    bool readStream = false ;
    ifstream * inputStream = NULL ;
    if (currentFile) inputStream = currentFile->stream ;
    bool loop = true ;
    if (inputStream) while (loop) {
        loop = false ;
        if (inputStream->eof()) popFile();
        inputStream = NULL ;
        if (currentFile) inputStream = currentFile->stream ;
        if (inputStream) {
            static const int bufSize = 8192;
            static char buf[bufSize];
            if (inputStream->good()) {
                currentFile->line++ ;
                inputStream->getline(lbuf=buf,bufSize);
                if (!buf[0] && inputStream->eof()) {
                    loop = true ;
                    continue ;
                }
                *out << currentFile->name << ":" << currentFile->line << "::" ;
                *out << buf << "\n" ;
                promptCheck();
                readStream = true ;
            }
        }
    }
    if (!readStream) {
        static bool welcomeOut = false ;
        if (!currentFile && !fileToRead) initFile = false ;
        if (!welcomeOut && !initFile) {
            *out << "\nWelcome to the ordinal calculator, " << version << ".\n" ;
            *out << "Copyright (C) 2009 Mountain Math Software\n" ;
            *out << "All rights reserved,\n" ;
            *out << "GPL version 2 licensed software.\n";
            *out << "www.mtnmath.com\n\n" ;
            *out << "Type \"help ENTER\" to learn about the calculator.\n" ;
            out->flush();
            welcomeOut = true ;
        }
        if (inContinue) lbuf = ::readline("");
        else lbuf = ::readline(ordCalc);
        if (lbuf == NULL) {
            *out << "\n";
            exit(0);
        }

        setPromptLine(0);
        
        add_history(lbuf);
    }
    if (logFileStream) *logFileStream << ordCalc << lbuf << "\n" ;
    int length = strlen(lbuf);
    if (length +2 >=max_size) {
        *out << "ERROR: Line must be less than " << max_size-2 << " characters.\n" ;
        char_read = 0 ;
    } else {
        strcpy(buf,lbuf);
        char_read = length + 1 ;
        buf[length]='\n' ;
        buf[length+1] = 0 ;
    }
    if (!readStream) delete lbuf ;


}



bool ParseSemantics::initFile = false ;

void ParseSemantics::parseInput(const char * file)
{
    if (file) {
        initFile = true ;
        string * sfile = new string(file) ;
        pS->readFromFile(sfile);
    } 
    using_history();
    while(true) {
       yy_flush_bison_buffer();
       yyparse();
    }


}



void ParseSemantics::log(enum ParseSemantics::logOption opt, 
    const string * name)
{
    
    teestream * tee = NULL ;
    static const string * fileName = NULL  ;
    switch(opt) {
case createLog:
            assert(name);
            if (fileName) {
                *out << "ERROR: log file '" << *fileName <<
                    "' is already active.\n" ;
                
                return ;
            }
            out->flush();
            break;
case flushLog:
            out->flush();
            return ;
case stopLog:
case exitClean:
            break ;
default:
        assert(0);
    }


    out->flush();
    if (tee) {delete tee;tee=NULL;}
    if (logFileStream) {delete logFileStream;logFileStream=NULL;}
    if (fileName) {delete fileName; fileName = NULL;}

    if (opt == stopLog) { out = &cout ; return ; }

    if (opt == createLog) {
        fileName = new string(*name) ;
        logFileStream = new ofstream (fileName->c_str());

        logFileStream->setf(ios::unitbuf); 

        if (!logFileStream->good()) {
            *out << "ERROR: cannot write to log file '" << fileName
                << "'. Logging abored.\n" ;
            log(stopLog,NULL);
        } else {
            tee = new teestream(std::cout,*logFileStream);
            out = tee ;
            defaultLogFile = *name ;
        }
    } else assert(!name);
}

