#include <stdlib.h>
#include <iostream>
#include <gmpxx.h>

using namespace std ;
namespace ord {

    
	typedef  mpz_class Int ;

	class OrdinalImpl ;
	struct NormalFormTerm ;
	class OrdSubs ;

	class Ordinal {
		friend class NormalFormTerm ;
		friend class CantorNormalElement ;
		friend class OrdinalImpl ;
		void commonInit();
protected:
		const OrdinalImpl& ord ;
		

public:

		virtual const OrdinalImpl& getIndexCK() const ;
		
		Ordinal(unsigned long n);
		Ordinal(Int n);
		Ordinal(const Ordinal& op) ;
		Ordinal(const char * name,const NormalFormTerm&  trms);
		Ordinal(const OrdinalImpl& impl);
		
		const OrdinalImpl& getImpl() const ;
		bool hasFiniteTerm() const ;
		bool isLimit() const ;
		bool isSuccessor() const {return hasFiniteTerm();}
		bool isOmegaSuccessor() const ;
		
		const OrdinalImpl& limitType() const ;
		const OrdinalImpl& maxLimitType() const ;
		const OrdinalImpl& maxLimitType(const Ordinal& context) const ;
		int psuedoCodeLevel() const ; 


		virtual ~Ordinal();

		int compare(const Ordinal& o) const;

		const Ordinal& limit(const Ordinal * const * const ords)
            const ;
		const Ordinal& limit(const Int n, const Ordinal& ord) const ;
		const Ordinal& limitElement(Int n) const ;
		const Ordinal& limitOrd(const Ordinal & arg) const ;
	
        bool isOmega() const ;
		

		static void multCheck(const Ordinal& a, const Ordinal& b,
			const Ordinal& c, const Ordinal &d) ;

		static void multCheck(const Ordinal& a, const Ordinal& b,
			const Ordinal& c) ;
		static void powerCheck(const Ordinal& a, const Ordinal& b,
			const Ordinal& c) ;

        string normalFormOpt(bool texFlag) const;
		void listEltsCore(int length = 10, bool texFlag= false,
            bool doDescendTest = false, int line = 0, int start = 0) const ;
		void listElts(int length = 10, bool doDescendTest = false,
			int line = 0) const ;
		void listEltsTex(int length = 10,
            bool doDescendTest = false, int line = 0) const ;
		void listiElts(int length = 10, bool doDescendTest = false,
			int line = 0) const ;
		void listiEltsTex(int length = 10,
            bool doDescendTest = false, int line = 0) const ;
		void listOrdElts(const Ordinal * const
			ords[], bool doDescendTest = false) const ;
		const Ordinal * descendFull(int index, int limit = 100, int sel= -1)
            const ;
		const Ordinal * descend(int index, int limit = 100) const ;
		void limitOrdTest(const Ordinal * const ords[], int desLim=5) const ;
		void limitElementTest(int limit=3, int desLim=5) const ;

		static void cmpCheck(const Ordinal& a, const Ordinal& b);


		const string& assignedName() const ;
		const string normalForm() const ;
		
		const string texNormalForm() const ;
        const string psiNormalForm() const ;
		const Ordinal& plus_1() const ;
		const Ordinal& limPlus_1() const ;

		bool isZero() const ;
		bool isOne() const ;

        const Ordinal& limitMaxEmbed(const OrdinalImpl & lim) const ;
        virtual const Ordinal& getMaxEmbedIndex() const ;


		ostream& out(const string cmt = "") const ;
	


		bool operator< (const Ordinal &a) const {return compare(a) < 0;}
		bool operator> (const Ordinal &a) const {return compare(a) > 0;}
		bool operator== (const Ordinal &a) const {return compare(a) == 0;}
		bool operator!= (const Ordinal &a) const {return compare(a) != 0;}
		bool operator<= (const Ordinal &a) const {return compare(a) <= 0;}
		bool operator>= (const Ordinal &a) const {return compare(a) >= 0;}

		bool isFinite() const ;

		const Ordinal operator+(const Ordinal&op) const ;
		const Ordinal operator*(const Ordinal&op) const ;
		const Ordinal operator^(const Ordinal&op) const ;

		void describe(ostream&out) const ;
		void describel(ostream&out) const ;
		void descr(const char * comment=0) const ;

		static const char * sect;
		static const char * subSect;

		struct TexTableParameters {
			const Ordinal  * ord ;
			ostream & outStream ;
			const Int * indicies ;
			TexTableParameters(ostream & out):outStream(out){}
		};

		struct OrdTexTableParameters {
			const Ordinal  * ord ;
			ostream & outStream ;
			const Ordinal * const * indicies ;
			OrdTexTableParameters(ostream & out):outStream(out){}
		};


		static void texTableLimitElt(const TexTableParameters& params)  ;
		static void limitElementTable(const Ordinal * ords,
			const Int * indicies, string ordinalClass) ;
		static void limitTypeTable(const Ordinal * const * ords,
			string ordinalClass, int part = 0, const char * size = NULL) ;
		static void limitElementTable(const Ordinal * const * ords,
			const Int * indicies, string ordinalClass, int part = 0,
			const char * size = NULL) ;
		static void texTableLimitOrd(const OrdTexTableParameters& params)  ;
		static void limitOrdTable(const Ordinal * const * ords,
			const Ordinal * const * indicies, string ordinalClass) ;

		static void multiplyTableLine(const Ordinal& a, const Ordinal& b,
			ostream & out);
		static void powerTableLine(const Ordinal& a, const Ordinal& b,
			ostream & out);
		
		enum ExampType {multType=0, powerType=1} ;

		static void arithExamp(const Ordinal *const* a,
			const char * cls, ExampType type);
		

		static void texDocument() ;



		static const Ordinal zero ;
		static const Ordinal one ;
		static const Ordinal two ;
		static const Ordinal three ;
		static const Ordinal four ;
		static const Ordinal five ;
		static const Ordinal six ;
		static const Ordinal omega ;
        static const class Embeddings& noEmbeddings ;

	};

	static const Ordinal& zero = Ordinal::zero ;
	static const Ordinal& one = Ordinal::one ;
	static const Ordinal& omega = Ordinal::omega ;
    extern const Ordinal& omega1CK ;

	extern const Ordinal& eps0 ;
	extern const Ordinal& gamma0 ;

    const Ordinal& expFunctional(const Ordinal&exponent, Int factor=1);

	const Ordinal& psi(const Ordinal& a, const Ordinal &b) ;

	const Ordinal& finiteFunctionalTest(const Ordinal* const * const params,
		bool& fixedPointCreate);
	const Ordinal& finiteFunctional(const Ordinal* const * const params);
	const Ordinal& finiteFunctional(const Ordinal& ord1, const Ordinal&ord2,
			const Ordinal& ord3);
	const Ordinal& finiteFunctional(const Ordinal& ord1, const Ordinal&ord2,
			const Ordinal& ord3, const Ordinal&ord4);
	const Ordinal& finiteFunctional(const Ordinal& ord1, const Ordinal&ord2,
			const Ordinal& ord3, const Ordinal&ord4, const Ordinal&ord5);

	const Ordinal& iterativeFunctional(const Ordinal& iter,
		const Ordinal* const * params= NULL);
	const Ordinal& iterativeFunctional(const Ordinal& iter,
		const Ordinal& ord1);
	const Ordinal& iterativeFunctional(const Ordinal& iter,
		const Ordinal& ord1, const Ordinal&ord2);
	const Ordinal& iterativeFunctional(const Ordinal& iter,
		const Ordinal& ord1, const Ordinal&ord2,
			const Ordinal& ord3);
	const Ordinal& iterativeFunctional(const Ordinal& iter,
		const Ordinal& ord1, const Ordinal&ord2,
			const Ordinal& ord3, const Ordinal&ord4);

	const Ordinal& interpolateFunctional(const Ordinal& levCK,
		const Ordinal & interp, const Ordinal& iter,
		const Ordinal* const * params= NULL);

    

    const Ordinal& admisLevelFunctional(const Ordinal& levCK,
		const Ordinal& iter, const Ordinal* const * params=NULL,
		const Ordinal& drillDown=Ordinal::zero,
        const Ordinal& embOrd=Ordinal::zero);
    const Ordinal& admisLevelFunctional(const Ordinal& levCK,
		const Ordinal& iter, const Ordinal* const * params,
		const Ordinal& drillDown, const class Embeddings& embed);

	const Ordinal* const * const createParameters(
			const Ordinal * ord1,
			const Ordinal * ord2=0, const Ordinal * ord3=0,
			const Ordinal * ord4=0, const Ordinal * ord5=0,
			const Ordinal * ord6=0, const Ordinal * ord7=0,
			const Ordinal * ord8=0, const Ordinal * ord9=0)  ;


	const Ordinal* const * const replace1Parameter(
		const Ordinal* const * const base,
		int ix1, const Ordinal& ord1);

	const Ordinal* const * const replace2Parameters(
		const Ordinal* const * const base,
		int ix1, const Ordinal& ord1, int ix2, const Ordinal& ord2);


	const Ordinal ** createParamArray(Int n, int& nint);



	extern ostream& outStream() ;
	extern ostream& outDbgStream() ;
    extern bool runChecks ;
    extern bool interactiveMode ;
}





