#include <assert.h>
#include <iostream>
#include <iostream>
#include <sstream>
#include <string>
#include <list>


#include "ordDebug.h"
#include "gmpxx.h"

using namespace std ;



namespace ord {




	typedef  mpz_class Int ;

	class OrdinalImpl ;
	class Ordinal ;
	class InterpNormalElement ;
    class Embeddings ;


	class OrdSubs {
		struct OrdSub {
			
			
			const InterpNormalElement& ordElt ;
			OrdSub * next ;
			OrdSub * stack ;
			OrdSub * fullStackNext ;
			OrdSub(const InterpNormalElement& e):
				ordElt(e),next(NULL),stack(NULL),
				fullStackNext(NULL){}
			void push(OrdSub * sub);
			OrdSub * pop();
		} * ordSubs ;
		OrdSub * fullStack ; 
public:
		OrdSubs():ordSubs(NULL),fullStack(NULL){}

		void add(const InterpNormalElement& e);
		bool remove(const InterpNormalElement& e);
		const InterpNormalElement * getOrdSub(const OrdinalImpl& ix) const ;
		const OrdinalImpl * check(const OrdinalImpl& limTp,
			const OrdinalImpl &ord) const;
		const OrdinalImpl * check(const OrdinalImpl& limTp,
			const Int &n) const;

	};

   



	struct NormalFormTerm ;
	class CantorNormalElement {
		friend class NormalFormTerm ;
		friend class OrdinalImpl;
        friend class AdmisNormalElement;
protected:
		const class Parameters {
public:
			int codeLevel ;
			const OrdinalImpl * exponent ;
public:
			
			virtual ~Parameters(){}
		} * parameters ;

		unsigned int refCount ;
public:
		static const int cantorCodeLevel =  1 ;
		const int codeLevel ;
		const Int factor ;
		const OrdinalImpl& exponent ;
		virtual const OrdinalImpl & getMaxParameter() const 
			{return exponent;}

        virtual const Ordinal& getMaxEmbedIndex() const  ;
        virtual const CantorNormalElement& limitMaxEmbed(
            const OrdinalImpl&lim) const ;
        
        virtual const OrdinalImpl& getCompareIndexCK(bool ign) const ;
		static const OrdinalImpl & createOrdinal(const string& name,
			const NormalFormTerm& t)  ;
        
            
		enum LimitTypeInfo {
            unknownLimit,
            zeroLimit,
            finiteLimit,        
            drillDownLimit,     
            drillDownSucc, 
            paramLimit,         
            paramNxtLimit,      
			paramSucc,          
            iterLimit,          
            iterNxtLimit,       
            iterSucc,           
            indexCKlimit,       
            indexCKsuccParam,   
            indexCKsuccIter,    
            indexCKsucc,        
            indexCKlimitParam,  
            indexCKlimitIter,   
        } theLimitTypeInfo ;
        static string limInfoName(LimitTypeInfo inf) ;
protected:
		const OrdinalImpl * theLimitType ;
		const OrdinalImpl * theMaxLimitType ;
        const OrdinalImpl * theEmbedLimitType ;
        const OrdinalImpl * theMaxEmbedLimitType ;

		static  int count ;
		const int id ;
		const OrdinalImpl* termValue ;
		void dereference() const {((CantorNormalElement *)this)->refCount-- ;
			if (!refCount) if (id > 1) delete this ;
		}
		void commonInit() ;
		static const CantorNormalElement & createCantorNormalElement(
			const OrdinalImpl& ord, Int fac=1) {
				return * new CantorNormalElement(ord,fac);}

		
		CantorNormalElement(int n, const OrdinalImpl& one);

		CantorNormalElement(const Parameters * params, Int fac=1);
		CantorNormalElement(const OrdinalImpl& expon,
			Int f =1);

		CantorNormalElement(const OrdinalImpl& expon,
			Int f , int codeLev );
		CantorNormalElement(const CantorNormalElement&elt);
		
		virtual ~CantorNormalElement();

		virtual const CantorNormalElement& getCopy(const Int fac=1) const;

		static const NormalFormTerm * getOrdinalTerm(const OrdinalImpl& ord);
		static const OrdinalImpl& createOrdinal(
			const CantorNormalElement &elt ) {return elt.termToOrdinal();}
		static const CantorNormalElement& createTerm(const OrdinalImpl& ord,
			Int f =1) {return * new CantorNormalElement(ord,f);}
		static const OrdinalImpl& createOrdinal(const OrdinalImpl& ord);
		const OrdinalImpl& addFactorPart(const OrdinalImpl& r) const ;
		
		

		virtual const OrdinalImpl& limitElement(Int n) const ;
        virtual const OrdinalImpl& getDDindexVal() const ;

		const OrdinalImpl * limitOrdCom(const OrdinalImpl & ord) const ;
		virtual const OrdinalImpl& limitOrd(const OrdinalImpl & ord) const ;
		void outOperands(char  oper, const CantorNormalElement& b) const ;
		static const OrdinalImpl& getImpl(const Ordinal& ord) ;
		virtual const CantorNormalElement & addFactors(
			const CantorNormalElement& toAdd) const ;
public:
		virtual bool isOne() const ;
		ostream & out(const string cmt = "") const ;

		virtual const OrdinalImpl& maxLimitType() const ;
        virtual const OrdinalImpl& maxLimitType(const Ordinal& context) const ;
		virtual const OrdinalImpl& limitType() const;
		LimitTypeInfo getLimitInfo() const ;

        

         const OrdinalImpl& limitInfo( LimitTypeInfo& typeInfo) const  ;



		static const OrdinalImpl& nullLimitType ;
		static const OrdinalImpl& integerLimitType ;
		static const OrdinalImpl& recOrdLimitType ;
		virtual const OrdinalImpl& getIndexCK() const {return zero;}
		const OrdinalImpl& getOrdinalCopy(const Int fac=1) const;
		static const OrdinalImpl& createExpOrdinal(const OrdinalImpl& ord,
			Int factor = 1);
		static void outOperands(char  oper, const CantorNormalElement& a,
				const CantorNormalElement& b) ;
		const OrdinalImpl& termToOrdinal() const ;
		static const OrdinalImpl& createOrdinal(Int n) ;
		static const OrdinalImpl& fixedPointCheck(const OrdinalImpl& exp,
			const Int& fact=1);
		
		
		
		
		static const OrdinalImpl& zero ;
		static const OrdinalImpl& one ;
		static const OrdinalImpl& two ;
		static const OrdinalImpl& three ;
		static const OrdinalImpl& four ;
		static const OrdinalImpl& five ;
		static const OrdinalImpl& six ;
		static const OrdinalImpl& omega ;
		virtual void normalFormName(string& base) const ;

        virtual void psiNormalForm(string& str) const ;
		virtual void texNormalForm(string& str) const ;
		string& psiNormalForm() const
			{string &s = * new string ; psiNormalForm(s);return s;}
		string& texNormalForm() const
			{string &s = * new string ; texNormalForm(s);return s;}

		string& normalForm() const {
			string& temp = *new string ; normalFormName(temp); return temp;}

		virtual int compare(const Embeddings& context,
            const Embeddings& paramContext,
            const CantorNormalElement& trm,
			bool ignoreFactor = false) const ;
        int parameterCompare(const Embeddings& context,
            const Embeddings& paramContext,
            const CantorNormalElement &trm) const ;


        int compare(const OrdinalImpl& ord) const ;

        int compare(const Embeddings& embedIx,
            const Embeddings& termEmbedIx,
            const OrdinalImpl& ord) const ;

		virtual int compare(const CantorNormalElement& trm,
			bool ignoreFactor = false) const ;
        bool isOmega() const ;
		bool isFinite() const ;
		bool isIntOrCantorLevel() const {return codeLevel <= cantorCodeLevel;}
		virtual const CantorNormalElement& multiply(
			const CantorNormalElement& op) const;
		virtual const CantorNormalElement& multiply(const Int& fac) const ;
		virtual const CantorNormalElement& multiplyBy(
			const CantorNormalElement& op) const {return op.multiply(*this);}
		void reference() const {((CantorNormalElement *)this)->refCount++ ;}
		const Int& getFactor() const {return factor;}
		void deleteIfNotReferenced() const {
			if (refCount < 1) delete this;
		}

		void describe(ostream&out) const;
		void describel(ostream&out) const {describe(out); out << "\n" ;}

		int psuedoCodeLevel() const { if (factor > 1) return cantorCodeLevel;
			return codeLevel;}

		virtual const OrdinalImpl& toPower(const CantorNormalElement& elt)
			const;
		virtual const OrdinalImpl& powerOf(const CantorNormalElement& elt)
			const {assert(0);}
		
		bool expTerm() const ;
	};


	struct NormalFormTerm {
		const CantorNormalElement&  term ;
		const NormalFormTerm * next  ;
		
		NormalFormTerm(CantorNormalElement& trm);
		~NormalFormTerm();
		void append(const NormalFormTerm& trm) const 
			{if (next == NULL) {
				((NormalFormTerm *)this)->next = &trm;
			}
			else next->append(trm) ; }

		static void concatenate(const NormalFormTerm *& concatTo,
			const NormalFormTerm& concatFrom) ;

		void append(const CantorNormalElement& trm) const
			{append(*new NormalFormTerm(trm));}
		virtual void normalFormName(string& base) const ;
		int compare(const Embeddings& context,
            const Embeddings& paramContext, const NormalFormTerm& trm,
            bool ignoreFactor = false) const ;
		int compare(const NormalFormTerm& trm, bool ignoreFactor = false)
            const ;
		int compare(const OrdinalImpl& ord) const ;
		int compare(const Ordinal& ord) const ;
		NormalFormTerm(const CantorNormalElement& elt):
			term(elt),next(NULL){term.reference();}
			
		static NormalFormTerm * create(const OrdinalImpl& exponent,
			Int factor=1);

 
		
		bool isFinite() const {return term.isFinite();}
		
		void add(const NormalFormTerm*& sum) const ;
		void add(const NormalFormTerm*& sum,
			const NormalFormTerm&  toAdd) const  ;
		void multiply(const NormalFormTerm*& prod, const NormalFormTerm&  op,
			const NormalFormTerm * finiteProdTerm) const ;
		void multiply(const NormalFormTerm& prod, const Int& finiteFac) const ;
		
		void prodInfiniteTerms(const OrdinalImpl*& ord) const ;

		void getInfiniteTerms(NormalFormTerm& trm) const 
		{
			if (isFinite()) return ;
			trm.append(term);
			if (next) next->getInfiniteTerms(trm);

		}
		const NormalFormTerm& getInfiniteTerms() const 
		{
			NormalFormTerm * trm = new NormalFormTerm(term);
			if (next) next->getInfiniteTerms(*trm);
			return *trm;
		}

		void addInfiniteTerms(const NormalFormTerm* toAdd) const {
			if (!toAdd) return ;
			if (isFinite()) return ;
			append(toAdd->term);
			addInfiniteTerms(toAdd->next);
		}
		
		const OrdinalImpl * takePowerOf(const CantorNormalElement & trm) const ;

		int count() const {
			if (next == NULL) return 1; return 1 + next->count();}
		const NormalFormTerm& getTail() const {if (next == NULL) return *this;
			return next->getTail();}

		const OrdinalImpl& subract(const Int& offset,
			NormalFormTerm * resultTerms = NULL) const ;

		const Int& getFiniteTerm() const ;
		bool hasFiniteTerm() const ;
        bool isSuccessor() const {return hasFiniteTerm() ;}
		const Int& getFiniteFac() const ;


		const OrdinalImpl& limitElement(Int n,const NormalFormTerm *t=0) const;
		void describe(ostream&out) const ;

		void describel(ostream&out) const {describe(out); out << "\n" ;}
		void doCountTerms(Int& count) const {
			count += term.factor; if (next) next->doCountTerms(count);}

		Int countTerms() const {Int temp; doCountTerms(temp); return temp;}

		const NormalFormTerm * listCopySubtractOmega() const ;
		const NormalFormTerm * listCopyOff(Int& offset) const ;
		const NormalFormTerm * listCopy() const ;
		const NormalFormTerm * makeInfiniteCopy() const {
			if (isFinite()) return NULL ;
			 NormalFormTerm * ret = new NormalFormTerm(term);
			if (next) ret->next = next->makeInfiniteCopy() ;
			return ret ;
		}
		void normalForm(string & s) const ;

		void psiNormalForm(string& str) const ;
		void texNormalForm(string& str) const ;
		string texNormalForm() const {string s; texNormalForm(s);return s;}

		string normalForm() const ;
		
		const NormalFormTerm * replaceLast(const CantorNormalElement& e) const ;
	};


	class DebugControl ;

	class OrdinalImpl  {
		friend class CantorNormalElement ;
		friend class AdmisNormalElement ;
		friend class IterFuncNormalElement ;

		friend class NormalFormTerm ;
		friend class Ordinal ;

        friend const Ordinal& ord::admisLevelFunctional(const Ordinal& levCK,
		    const Ordinal& iter, const Ordinal* const * params,
		    const Ordinal* drillDown);

		static int idCount ;
		bool inDeleteList ;
		const int id ;
		const OrdinalImpl * theLimitType ;
		const OrdinalImpl * theMaxLimitType ;
        const OrdinalImpl * theEmbedLimitType ;
        const OrdinalImpl * theMaxEmbedLimitType ;
public:
		static DebugControl& debugControl ;
protected:
		unsigned refCount ;
		const NormalFormTerm* terms ; 
		string assignedNameString ;
		string normalFormString ;
public:
		virtual void normalFormName(string& base) const {base += normalForm();}
		virtual int psuedoCodeLevel() const ;

        virtual const Ordinal& getMaxEmbedIndex() const  ;
        const Ordinal& limitMaxEmbed(const OrdinalImpl & lim) const ;

        const OrdinalImpl& getCompareIndexCK(bool ign) const ;
        const OrdinalImpl& removeDelta(const Ordinal& bound) const ;
		const bool hasFiniteTerm ;
		bool isLimit() const {return !isZero() && !hasFiniteTerm;}
		bool isSuccessor() const {return hasFiniteTerm;}
        bool isOmegaSuccessor() const ;
        bool isOmega() const ;
		bool singleTerm() const {if (terms) if (terms->next == NULL)
			if (terms->term.factor == 1) return true; return false;}
	
		const Int termCount ;

        
        const class AdmisLevOrdinal* getAdmissibleBase() const ;
        int getFTcodeLevel() const ;
        const OrdinalImpl& getDDindexVal() const ;


		static const OrdinalImpl& zero ;
		static const OrdinalImpl& one ;
		static const OrdinalImpl& two;
		static const OrdinalImpl& three ;
		static const OrdinalImpl& four ;
		static const OrdinalImpl& five ;
		static const OrdinalImpl& six ;
		static const OrdinalImpl& omega ;
		static const Int zeroInt ;
		const Int getFiniteTerm() const {if (!terms) return 0;
			return terms->getFiniteTerm();}

        string normalFormOpt(bool texFlag) const;
		void texNormalForm(string& str) const ;
		void psiNormalForm(string& str) const ;
        string & psiNormalForm() const 
            {string& s = *new string; psiNormalForm(s);return s;}
            
		string& texNormalForm() const
            {string& s = *new string; texNormalForm(s);return s;}
		const CantorNormalElement * lastTerm ;
		bool oneTerm() const
			{if (terms) if (!terms->next) return true; return false;}

		const OrdinalImpl& plus_1() const 
			{return addLoc(one);}
		const OrdinalImpl& limPlus_1() const
			
			{if (psuedoCodeLevel() > CantorNormalElement::cantorCodeLevel)
				return addLoc(one); return *this; }

protected:
		
		
		
		void normalFormName() const ;

		static list<OrdinalImpl *> urefImp ;
		bool noRef() const {urefImp.push_front((OrdinalImpl *)this);
			return true;}
		
		void commonInit(const char * from);
		bool clearInDeleteList() const
			{if (!inDeleteList) describel(outStream());
			assert(inDeleteList) ;
			((OrdinalImpl *)this)-> inDeleteList = false ;
			return inDeleteList ; }

        int getHighestCodeLevel() const ;

        const Ordinal * maxEmbedIndex ;
	

		OrdinalImpl(const OrdinalImpl& copyFrom, Int off=0);

		OrdinalImpl(const CantorNormalElement& elt):lastTerm(0),
			assignedNameString(elt.normalForm()),id(idCount++),
			terms(new const NormalFormTerm(elt)),maxEmbedIndex(NULL),
			termCount(terms?terms->countTerms():0),
			hasFiniteTerm(terms->hasFiniteTerm()){commonInit("elt");}

		OrdinalImpl(const string& name,const NormalFormTerm&  trms):
			lastTerm(0),
			assignedNameString(name),id(idCount++),
			terms(&trms),refCount(0),maxEmbedIndex(NULL),
			termCount(terms?terms->countTerms():0),
			hasFiniteTerm(trms.hasFiniteTerm()) {commonInit("string");}

		OrdinalImpl(const char * name,const NormalFormTerm&  trms):
			lastTerm(0),maxEmbedIndex(NULL),
			assignedNameString(name),id(idCount++),
			terms(&trms),refCount(0),
			termCount(terms?terms->countTerms():0),
			hasFiniteTerm(trms.hasFiniteTerm()) {commonInit("char");}

		OrdinalImpl(unsigned long n) ;

		OrdinalImpl(Int n) ;

		OrdinalImpl(int n1, int n2) ; 

        OrdinalImpl(const NormalFormTerm * trms, const string& name);

		virtual ~OrdinalImpl();

        void termsCopy(NormalFormTerm *& terms, Int lastFactor) const ;

		const OrdinalImpl& makeInfiniteTermCopy() const {
			assert(terms);
			return * new OrdinalImpl(assignedNameString,
				*(terms->makeInfiniteCopy()));
		}

		string exprName(const OrdinalImpl& a, const char * oper,
			 const OrdinalImpl&b) const ;


		void outOperands(char  oper, const OrdinalImpl& b) const;

		const OrdinalImpl& finitePowerLoc(unsigned long) const ;
		const OrdinalImpl& finitePowerLoc(const Int& n) const ;

public:
		const CantorNormalElement * getLastTerm() const ;
		const OrdinalImpl& getMaxParameter() const	;

		const OrdinalImpl& maxLimitType() const	;
        virtual const OrdinalImpl& maxLimitType(const Ordinal& context) const ;
		const OrdinalImpl& limitType() const ;
        CantorNormalElement::LimitTypeInfo getLimitInfo() const ;
		
		const OrdinalImpl& maxEmbedLimitType(const OrdinalImpl& embedIX) const;
		const OrdinalImpl& embedLimitType(const OrdinalImpl& embedIX) const ;
		
		
		static void outOperands(char  oper, const OrdinalImpl& a,
			const OrdinalImpl& b) ;
		const OrdinalImpl& subtract(const Int& offset) const ;
		const OrdinalImpl& subtractOmega() const ;
		const OrdinalImpl& addLoc(const OrdinalImpl&op) const ;
		const OrdinalImpl& addLoc(const int n) const ;
		const OrdinalImpl& multLoc(const OrdinalImpl&op) const ;
		const OrdinalImpl& powerLoc(const OrdinalImpl&op) const ;


		ostream & out(const string cmt="") const ;


		const OrdinalImpl& addLoc(const Ordinal&op) const ;

		void reference() const {((OrdinalImpl *)this)->refCount++;}
		void dereference() const ;
		const OrdinalImpl& getInfiniteTerms() const ;
		const OrdinalImpl& limit(const Ordinal * const * const ords) const;
		const OrdinalImpl& limit(const Int n, const Ordinal& ord) const ;
		const OrdinalImpl& limitElement(Int n) const ;
		const OrdinalImpl& limitOrd(const OrdinalImpl & ord) const ;


		const string& assignedName() const {return assignedNameString;}
		const string& normalForm() const {
			if (normalFormString.empty()) normalFormName();
			return normalFormString;}
		int compare(const Embeddings& context, const Embeddings& paramContext,
            const OrdinalImpl& ord) const ;
		int compare(const OrdinalImpl& ord) const ;
		int compare(const Ordinal& ord) const ;

        static const OrdinalImpl& expFunctional(
            const OrdinalImpl &exponent, Int factor=1)  ;

		const NormalFormTerm * getTerms() const {return terms;}
		const CantorNormalElement* getFirstTerm() const {
			if (terms) return &(terms->term);
			return NULL ;
		}
		const OrdinalImpl& getIndexCK() const {
			if (!terms) return zero ;
			return terms->term.getIndexCK();
		}
		const CantorNormalElement* getSecondTerm() const {
			if (terms) if (terms->next) return &(terms->next->term);
			return NULL ;
		}

        const bool multipleTerms() const {return getSecondTerm() != NULL;}
			
		bool isFinite() const {if (!terms) return true ;
			return terms->isFinite();}
		bool isZero() const {return terms == NULL;}
		bool isOne() const {if (terms) return terms->term.isOne();
			else return false; }
		Int getInt() const ; 
		int get_int() const ; 
		static void deleteUnref();
		int refCnt() const {return refCount;}


		void describe(ostream&out) const
			{ out << assignedNameString << " : " << normalForm();}
		void describel(ostream&out) const {describe(out); out << "\n" ;}
		void descr(const char * comment=0) const ;
        virtual const OrdinalImpl& indexCKlimitType() const ;


		static Int intExp(const Int& a , const Int& b);
		static unsigned long int ulongFromInt(const Int& in);
		static string itoa(Int num);

	};


 class Embeddings {
    public:
        const Ordinal& embedIndex ;
        const Ordinal& embedIndexMo ;
        const enum Type {none,paramRestrict} type ;
        Embeddings(const Ordinal& ddIx,Type typ);
                bool isParamRestrict() const ;
                    static const Embeddings embedNone ;
        string normalForm() const ;
    };

}

#include "ordinal.h"

