;  ord.nsi from ord (ordinal calculator) 
;  Copyright (C) 2009, Mountain Math Software, www.mtnmath.com.
;  All rights reserved. Email: ord@mtnmath.com
;  
;  This file is part of ord (ordinal calculator).
;  Permission is hereby granted to use and distribute this software
;  under the terms of The GNU General Public License version 2.
;  You should have received a copy of the GNU General
;  Public License along with this program. See file COPYING.
;  You may also obtain the GNU General Public License by writing the
;  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
;  USA.
;  
;  Send feedback and bug reports to ord@mtnmath.com.
;  
;ord.nsi
;
; ord install script
;
;--------------------------------
;Include Modern UI

  !include "MUI.nsh"

;--------------------------------
;General

Name "MMS ord"
;Icon ordimgl.ico
;UninstallIcon ordimgl.ico

; The file to write
OutFile "ordInstall.exe"


;--------------------------------
;Variables

  Var MUI_TEMP
  Var STARTMENU_FOLDER

;--------------------------------
;Interface Settings
;	!define MUI_WELCOMEFINISHPAGE_BITMAP "ordinstalll.bmp"
	!define MUI_ABORTWARNING

	

;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "mmsgpll.txt"
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY

  ;Start Menu Folder Page Configuration
  !define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKCU" ;;;HKLM 
  !define MUI_STARTMENUPAGE_REGISTRY_KEY "Software\MMS ord" 
  !define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"
  
  !insertmacro MUI_PAGE_STARTMENU Application $STARTMENU_FOLDER

  
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Version Information

  VIProductVersion "0.2.0.0"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "ProductName" "ord (ordinal calculator)"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "Comments" "Does ordinal arithmetic on the Veblen function and more"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "CompanyName" "Mountain Math Software"
  ;;VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalTrademarks" "Test Application is a trademark of Fake company"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalCopyright" " Mountain Math Software"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "FileDescription" "ord installer"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "FileVersion" "0.1.0.0"


;--------------------------------


; The default installation directory
InstallDir "$PROGRAMFILES\Mountain Math Software\ord"

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Mountain Math Software\MMS ord" "Install_Dir"

;LicenseText "GNU GENERAL PUBLIC LICENSE"
;LicenseData "gpl.txt"

;--------------------------------

; Pages

;Page license
;Page components
;Page directory
;Page instfiles

;UninstPage uninstConfirm
;UninstPage instfiles

;--------------------------------

; The stuff to install
Section "ord (required)"

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File "ord.exe"
  File "cygwin1.dll"
  File "cyggmp-3.dll"
  File "cyggmpxx-4.dll"
  File "cygncurses-9.dll"
  File "cygreadline7.dll"
  File "cyggcc_s-1.dll"
  File "cygstdc++-6.dll"
  File "ordinal.pdf"
  File "ordCalc.pdf"

  
  ; Write the installation path into the registry
  WriteRegStr HKLM "Software\MMS ord" "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MMS ord" "DisplayName" "Mountain Math Software ord"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MMS ord" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MMS ord" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MMS ord" "NoRepair" 1
  WriteUninstaller "uninstall.exe"

  
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
    
    ;Create shortcuts
    CreateDirectory "$SMPROGRAMS\$STARTMENU_FOLDER"
 	CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\ord.lnk" "$INSTDIR\ord.exe" "" "$INSTDIR\ordimgl.ico" 0
	CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\manual.lnk" "$INSTDIR\ordCalc.pdf" "" "$INSTDIR\ordCalc.pdf" 0
	CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\documentation.lnk" "$INSTDIR\ordinal.pdf" "" "$INSTDIR\ordinal.pdf" 0
    CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\uninstall.lnk" "$INSTDIR\Uninstall.exe"
  
  !insertmacro MUI_STARTMENU_WRITE_END

  
SectionEnd

; Optional section (can be disabled by the user)
;Section "Start Menu Shortcuts"
;
;  CreateDirectory "$SMPROGRAMS\mdb"
;  CreateShortCut "$SMPROGRAMS\mdb\mdb.lnk" "$INSTDIR\mdb.exe" "" "$INSTDIR\mdbimgl.ico" 0
;  CreateShortCut "$SMPROGRAMS\mdb\manual.lnk" "$INSTDIR\mdb_doc.chm" "" "$INSTDIR\mdb_doc.chm" 0
;  CreateShortCut "$SMPROGRAMS\mdb\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
;  
;SectionEnd

Section "Desktop Menu Shortcuts"
	CreateShortCut "$DESKTOP\ord.lnk" "$INSTDIR\ord.exe" "" "$INSTDIR\ordimgl.ico" 0
	
SectionEnd
;--------------------------------

; Uninstaller

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MMS ord"
  DeleteRegKey HKLM "SOFTWARE\MMS ord"

  ; Remove files and uninstaller
  Delete $INSTDIR\ord.exe
  Delete $INSTDIR\cygwin1.dll
  Delete $INSTDIR\cyggmp-3.dll
  Delete $INSTDIR\cyggmpxx-4.dll
  Delete $INSTDIR\cygncurses-9.dll
  Delete $INSTDIR\cygreadline7.dll
  Delete $INSTDIR\cyggcc_s-1.dll
  Delete $INSTDIR\cygstdc++-6.dll
  Delete $INSTDIR\ordinal.pdf
  Delete $INSTDIR\ordCalc.pdf
  Delete $INSTDIR\uninstall.exe
  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\ord\*.*"
  Delete "$DESKTOP\ord.lnk"

  ; Remove directories used
;  RMDir "$SMPROGRAMS\ord"
  RMDir "$INSTDIR"
  RmDir "$PROGRAMFILES\Mountain Math Software"

  !insertmacro MUI_STARTMENU_GETFOLDER Application $MUI_TEMP
    
  Delete "$SMPROGRAMS\$MUI_TEMP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$MUI_TEMP\ord.lnk"
  Delete "$SMPROGRAMS\$MUI_TEMP\manual.lnk"
  Delete "$SMPROGRAMS\$MUI_TEMP\documentation.lnk"
  
  ;Delete empty start menu parent diretories
  StrCpy $MUI_TEMP "$SMPROGRAMS\$MUI_TEMP"
 
  startMenuDeleteLoop:
	ClearErrors
    RMDir $MUI_TEMP
    GetFullPathName $MUI_TEMP "$MUI_TEMP\.."
    
    IfErrors startMenuDeleteLoopDone
  
    StrCmp $MUI_TEMP $SMPROGRAMS startMenuDeleteLoopDone startMenuDeleteLoop
  startMenuDeleteLoopDone:

  ;;!define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKLM" 
  ;;!define MUI_STARTMENUPAGE_REGISTRY_KEY "Software\MMS ord" 
  ;;!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"
  ;;DeleteRegKey /ifempty HKCU "Software\Modern UI Test"
  DeleteRegKey /ifempty HKCU "Software\MMS ord" ;;HKLM


SectionEnd
