#include <fstream>
#include <algorithm>
#include "ordTop.h"
#include "validate.h"
extern const char * version ;

using namespace std;
using namespace ord ;


extern void parseInput(const char * name = NULL);
extern void writeTeXdoc(const char *fileName, const char *sec );



void writeTeXdoc(const char *fileName)
{
    writeTeXdoc(fileName,"section");
}




#define LISTELTS(ord,doTest) Validate::listElts(ord,doTest,__LINE__)
#define DLISTELTS(ord,doTest) listElts(ord,doTest,__LINE__)


void newL(int i, ostream&str)
{

	if (!((i+1)%5)) str << "\n\t" ;
}

void texOut()
{
	ofstream texStream("ordExamp.tex") ;
	texStream << "\\begin{math}\n";
	for (int i = 0 ; i < 10 ; i++) {
		if (i) texStream << ", " ;
		texStream << (omega^i).texNormalForm() ;
		newL(i,texStream);
	}
	texStream << "\\\\[.2in]\n" ;
	for (int i = 0 ; i < 10 ; i++) {
		if (i) texStream << ", " ;
		texStream << ((omega^i)*(i+1)).texNormalForm() ;
		newL(i,texStream);
	}
	texStream << "\\\\[.2in]\n" ;
	const OrdinalImpl * ord = &(omega.getImpl());
	for (int i = 0 ; i < 10 ; i++) {
		if (i) texStream << ", " ;
		
		ord = &((omega^*ord)).getImpl();
		texStream << ord->texNormalForm() ;
		newL(i,texStream);
	}
	texStream << "\\\\[.2in]\n" ;

	
	
	


	texStream << "\\end{math}\n";
}

void help();
void helpTex();
void helpVersion();

void texDoc()
{
	texOut();
	Ordinal::texDocument();
	FiniteFuncOrdinal::texDocument();
	IterFuncOrdinal::texDocument();
	AdmisLevOrdinal::texDocument();
    writeTeXdoc("cmdman.tex");
    writeTeXdoc("cmdchapt.tex","subsection");
    helpTex();


}


typedef void Action() ;

struct Option {
	const char * name;
	Action * act ;
    int paramCount ;
	const char * desc ;
    bool validate ;
};


static const char * parameter = NULL ;
void interactive()
{
    interactiveMode=true ;
    parseInput(parameter);
}

void writeTeXinteractiveManual()
{
    if (!parameter) {
        cerr << "ERROR: command line option 'cmdDoc' requires a file name.\n" ;
        exit(1);
    }

    writeTeXdoc(parameter);
    exit(0);
}





static Option opts[] = {	
                            {"cmd",interactive,1,
                               "Read specified command file and enter command line mode",false},
                            {"version",helpVersion,0,"Print program version",false},
							{"help", help,0, "Describe command line options",false},
                            {"cmdDoc", writeTeXinteractiveManual,1,
                             "Write manual for command line mode in TeX format",false},

							{"tex",texDoc,0, "Output TeX documentation files",false},

							{"psi",Validate::psiTest,0,"Do tests of Veblen hierarchy",true},
							
							{"base",Validate::baseTest,0,
                                "Do tests of base class Ordinal",true},
							{"try",Validate::tryExamp,0,
								"Do tests of class FiniteFuncOrdinal" ,true},
							{"iter",Validate::iterTest,0,
								"Do tests of class IterFuncOrdinal",true},
							{"admis",Validate::admisTest,0,
								"Do tests of class AdmisLevOrdinal",true},
							{"admis2",Validate::admisTest2,0,
								"Do additional tests of class AdmisLevOrdinal",true},
							{"play",Validate::playTest,0,
								"Do integrating tests",true},
							{"descend",Validate::descendTest,0,
								"Test descending trees",true},
                            {"collapse",Validate::collapseTest,0,
                                "Ordinal collapsing tests",true},
                            {"nested",Validate::nestedCollapseTest,0,
                                "Ordinal nested collapsing tests",true},
                            {"nested2",Validate::nestedCollapseTest2,0,
                                "Ordinal nested collapsing tests 2",true},
                            {"nested3",Validate::nestedCollapseTest3,0,
                                "Ordinal nested collapsing tests 3",true},
                            {"exitCode",Validate::exitCodeTest,0,
                                "LimitElement exit code base test",true},
                            {"exitCode2",Validate::exitCodeTest2,0,
                             "LimitElement exit code base test 2",true},
                            {"limitEltExitCode",Validate::limitEltExitCodeTest,
                                0,"Admissible level LimitElement exit code test 0",true},
                            {"limitEltExitCode1",Validate::limitEltExitCodeTest1,
                                0,"Admissible level limitElement exit code test 1",true},
                            {"limitEltExitCode2",Validate::limitEltExitCodeTest2,
                                0,"Admissible level limitElement exit code test 2",true},
                            {"limitEltExitCode3",Validate::limitEltExitCodeTest3,
                                0,"Admissible level limitElement exit code test 3",true},
                            {"limitOrdExitCode",Validate::limitOrdExitCodeTest,
                                0,"Admissible level limitOrd exit code test",true},
                            {"limitOrdExitCode1",Validate::limitOrdExitCodeTest1,
                                0,"Admissible level limitOrd exit code test",true},
                            {"limitOrdExitCode2",Validate::limitOrdExitCodeTest2,
                                0,"Admissible level limitOrd exit code test",true},
                            {"limitOrdExitCode3",Validate::limitOrdExitCodeTest3,
                                0,"Admissible level limitOrd exit code test",true},
                            {"transition",Validate::transitionTest,
                                0,"Admissible level transition test",true},
                            {"cmpExitCode",Validate::cmpExitCodeTest,0,
                                "Admissible level compare exit code test",true},
                            {"drillDownExitCode",Validate::drillDownExitCodeTest,0,
                                "Admissible level compare exit code test",true},
                            {"embedExitCode",Validate::embedExitCodeTest,0,
                                "Admissible level compare exit code test",true},
                            {"fixedPoint",Validate::fixedPointTest,0,
                                "test fixed point detection",true},

                            
							{"helpTex", helpTex,0, "TeX document command line options",false},
							{0}};

void helpVersion()
{
    cout << "This is " << version << ".\n" ;
}

void help()
{
	cout << "Command line options are:\n\n" ;
	for (const Option * opt = opts ; opt->name ; opt++) 
		if (opt->desc) cout << opt->name << " --- " << opt->desc << ".\n" ;

}



void helpTex()
{
    ofstream outStream("ordCalcCmdLine.tex");
	outStream << "\\subsection{Command line options}\n" <<
    "\\index{command line options}\n\n" <<
    "The standard name for the ordinal calculator is {\\tt ord}.\n" <<
    "Typing {\\tt ord} (or {\\tt ./ord}) ENTER will start {\\tt ord} in\n" <<
    "command line mode on most Unix or Linux based systems.\n" <<
    "The other command line options are mostly for validating\n" <<
    "or documenting {\\tt ord}. They are:\\\\\n\n\\addvspace{.05in}\n" ;
	for (const Option * opt = opts ; opt->name ; opt++) 
		if (opt->desc) outStream << "`{\\tt " <<
            opt->name << "}' --- " << opt->desc << ".\\\\\n" ;
    outStream << "\n" ;

}


main(int argc, char  ** argv)
{
    

    Validate::simpRand();
    bool flagInteractive = true ; ;
    parameter = NULL ;
	for (int i =1; i < argc; i++)  {
        flagInteractive = false ;
		bool ok = false ;
        for ( Option * op = opts; op->name; op++) {
			if (!strcmp(op->name,argv[i])) {
                int paramCount = op->paramCount;
                assert((paramCount > -1) && (paramCount <2)) ;
                if (paramCount) if (argv[i+1]) {parameter = argv[++i];}
                if (op->validate) Validate::validationTest = true ;
				op->act();
                parameter = NULL ;
				ok = true ;
				break ;
			}
			
		}
		if (!ok) {
			cerr << "Invalid command line option \"" << argv[i] << 
				"\" for \"" << argv[0] << "\"!\n" ;
			exit(1);
		}
	}
    if (flagInteractive) interactive();
}





