#include <fstream>
#include "admisOrd.h"

using namespace ord ;
using namespace std ;

FiniteFuncNormalElement::FiniteFuncParameters::FiniteFuncParameters(
	const Ordinal * const * const params, const Embeddings& embed,int level):
        parameters(params),embeddings(embed)
{
	
	bool dbg = false ;
	if (dbg) outStream() <<
	"FiniteFuncNormalElement::FiniteFuncParameters::FiniteFuncParameters\n" ;

	size = 0 ;
	assert(!parameters || parameters[0]);
	if (parameters) {
        maxEmbedIndex = &(params[0]->getMaxEmbedIndex());
		maxParameter = params[0];
		while (params[++size]) {
            if (*maxParameter < *(params[size])) maxParameter = params[size] ;
            const Ordinal& ord = params[size]->getMaxEmbedIndex() ;
            if (maxEmbedIndex->getImpl().compare(embeddings,embeddings,
                ord.getImpl())<0)
                maxEmbedIndex =  &ord ;
        }
		assert(size > 0);
		if (dbg) for (int i = 0 ; i < size ; i++) outStream() << 
			i << " : " << parameters[i]->normalForm() << " prm\n" ;
	
		exponent= &(parameters[size-1]->getImpl()) ;
		if (level > -1) codeLevel = level ;
		else codeLevel = (size > 1) ? finiteFuncCodeLevel: cantorCodeLevel ;
	} else {
        maxEmbedIndex = &Ordinal::zero ;
		maxParameter = &Ordinal::zero ;
		exponent = &OrdinalImpl::zero ;
		assert(level > -1);
		codeLevel = level ;
	}
	
}


FiniteFuncNormalElement::FiniteFuncNormalElement(
	const Ordinal* const * const params, Int fac):
	CantorNormalElement(new FiniteFuncParameters(params),fac),
	funcParameters(params),
	size(((const FiniteFuncParameters *) parameters)->size),
    maxParameter(((const FiniteFuncParameters *)
	    parameters)->maxParameter->getImpl()),
    maxEmbedIndex(*((const FiniteFuncParameters *)
	    parameters)->maxEmbedIndex)
{
	commonInit();
	
	bool dbg = false ;
	if (dbg) outStream() << normalForm() << ".maxParameter = " <<
		maxParameter.normalForm() << "\n" ;
}

FiniteFuncNormalElement::FiniteFuncNormalElement(
	const FiniteFuncParameters* prma, Int fac):
		CantorNormalElement(prma,fac),
		funcParameters(prma->parameters),
		size(((const FiniteFuncParameters *) prma)->size),
		maxParameter(prma->maxParameter->getImpl()),
        maxEmbedIndex(*((const FiniteFuncParameters *)
	        parameters)->maxEmbedIndex)
{
	
	commonInit();
	bool dbg = false ;
	if (dbg) outStream() << normalForm() << ".maxParameter = " <<
		maxParameter.normalForm() << "\n" ;


}


void FiniteFuncNormalElement::commonInit()
{

	if (codeLevel > finiteFuncCodeLevel) return ;
	assert(size > 1) ;
	assert(!funcParameters[0]->isZero());
}

const Ordinal * const * FiniteFuncNormalElement::getLimitMaxEmbedParamAry(
    const OrdinalImpl& lim) const
{
    if (!size) return NULL ;
    if (getMaxEmbedIndex().compare(lim)<0) return funcParameters ;
    const Ordinal * * newParams = new const Ordinal*[size+1] ;
    newParams[size] = NULL ;
    for (int i = 0 ; i < size ;i++)
        newParams[i]=&(funcParameters[i]->limitMaxEmbed(lim));
    return newParams ;

}

const CantorNormalElement& FiniteFuncNormalElement::limitMaxEmbed(
            const OrdinalImpl&lim) const
{
    if (getMaxEmbedIndex().compare(lim)<0) return *this ;
    const Ordinal *const * newParams = getLimitMaxEmbedParamAry(lim);
    return * new FiniteFuncNormalElement(newParams,factor);

}


const CantorNormalElement& FiniteFuncNormalElement::multiply(
	const CantorNormalElement& op) const 
{
	if (codeLevel < finiteFuncCodeLevel) return
		CantorNormalElement::multiply(op);
	return doMultiply(*this,op);
}


const CantorNormalElement& FiniteFuncNormalElement::multiplyBy(
	const CantorNormalElement& op) const 
{
	return doMultiply(op,*this);
}

const CantorNormalElement& FiniteFuncNormalElement::doMultiply(
			const CantorNormalElement& op1, const CantorNormalElement& op2)
{
	
	

	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::mult,0) ;
	if (dbg) {
		outStream() << "In FinitFuncNormalElement::doMultiply\n" ;
		outOperands('*',op1, op2);
	}

	bool op1ff = op1.codeLevel >= finiteFuncCodeLevel;
	bool op2ff = op2.codeLevel >= finiteFuncCodeLevel;
	assert(op1ff || op2ff);

	if (op2.isFinite()) {
		const FiniteFuncNormalElement& vop1 =
			(const FiniteFuncNormalElement&) op1 ;
		return vop1.getCopy(vop1.factor*op2.factor);
	}
	const OrdinalImpl * s1 = 0 ;
	const OrdinalImpl * s2 = 0 ;
	if (op1ff) {
		s1 = &(op1.getOrdinalCopy(1)) ;
		
	} else s1 = &(op1.exponent);
	if (op2ff) {
		s2 = &(op2.getOrdinalCopy(1)) ;
		
	} else s2 = &(op2.exponent);
	const OrdinalImpl& newExp = s1->addLoc(*s2);
	if (newExp.oneTerm()) {
		const CantorNormalElement* elt = newExp.getFirstTerm();
		if ((elt->codeLevel >= finiteFuncCodeLevel) && (elt->factor == 1))
			return * elt ;
	}
	return createCantorNormalElement(newExp,op2.factor);

}

const CantorNormalElement& FiniteFuncNormalElement::getCopy(const Int fac)
	const
{
	
	if (codeLevel == cantorCodeLevel)
		return CantorNormalElement::getCopy(fac);
	
	assert(codeLevel == finiteFuncCodeLevel);
	if (fac == 1) {
		
		const Ordinal& ord = finiteFunctional(funcParameters);
		const CantorNormalElement * ret = ord.getImpl().getFirstTerm();
		assert(ret) ;
		return *ret ;
	}
	return *new FiniteFuncNormalElement(funcParameters,fac);

}


const OrdinalImpl & FiniteFuncNormalElement::createVirtualOrdImpl(
	const Ordinal * const * const params) const 
{
	return finiteFunctional(params).getImpl();
}


const Ordinal & FiniteFuncNormalElement::createVirtualOrd(
			const Ordinal * const * const params) const 
{
	return finiteFunctional(params);
}



const OrdinalImpl& FiniteFuncNormalElement::replace1( int index,
	const Ordinal& nval) const 
{
	bool dbg = false ;
	if (dbg) outStream()<<"rp1, ix = " <<index<<", nv = "
		<< nval.normalForm()<<"\n";
	assert((index < size) && (index >= 0)) ;
	int newSize = size  ;
	int ix = 0 ;
	if (index == 0 && nval.isZero()) {
		newSize -- ;
		for (ix =1;(ix<size) && funcParameters[ix]->isZero();
			ix++,newSize--);
	}
	if (!newSize) return createVirtualOrdImpl(NULL);
	
	const Ordinal** newParameters = new
		const Ordinal * [newSize+1] ;
	for (int i = 0 ; i < newSize ; i++) {
		int origIx = i + ix ;
		assert((origIx >= 0) && (origIx < size));
		if (origIx == index) newParameters[i] = &nval ;
		else newParameters[i] = funcParameters[origIx] ;
	}
	newParameters[newSize] = 0 ;
	if (dbg) for (int i = 0 ; i < newSize ; i++)
		outStream() << "np[" << i << "] = " <<
		newParameters[i]->normalForm() << "\n" ;
	
	
	return createVirtualOrdImpl(newParameters);
	

}


const OrdinalImpl& FiniteFuncNormalElement::replace3( int index1,
	const Ordinal& nval1, int index2, const Ordinal& nval2,
	int index3, const Ordinal &nval3) const 
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
	if (dbg) out("replacing from");
	if (dbg) outStream() << "rp3(" << index1 << ", " << nval1.normalForm()
		<< ", " << index2 << ", " << nval2.normalForm() 
		<< ", " << index3 << ", " << nval3.normalForm() << ")\n" ;
	assert(index2 > index1) ;
	assert(index3 > index2);
	assert((index1 < size) && (index2 < size) && (index3 < size));
	assert((index1 >= 0) && (index2 >= 0) && (index3>=0));
	int newSize = size  ;
	int ix = 0 ;
	if (index1 == 0 && nval1.isZero()) {
		newSize -- ;
		ix = 1 ;
		while (ix<size) {
			if (ix == index2) {
				if (!nval2.isZero()) break ;
			} else if (ix == index3) {
				if (!nval2.isZero()) break ;
			} else if (!funcParameters[ix]->isZero()) break ;
			ix++; newSize--;
		}
	}
	if (dbg) outStream() << "newSize =  " << newSize << "\n" ;
	
	assert(newSize);
	const Ordinal** newParameters = new const Ordinal * [newSize+1] ;
	for (int i = 0 ; i < newSize ; i++) {
		int origIx = i + ix ;
		if (origIx == index1) newParameters[i] = &nval1 ;
		else if (origIx == index2) newParameters[i] = &nval2 ;
		else if (origIx == index3) newParameters[i] = &nval3 ;
		else newParameters[i] = funcParameters[origIx] ;
	}
	newParameters[newSize] = 0 ;
	if (dbg) for (int i = 0 ; i < newSize ; i++)
		outStream() << "np2[" << i << "] = " <<
		newParameters[i]->normalForm() << "\n" ;
	
	
	const OrdinalImpl& ret =  createVirtualOrdImpl(newParameters);
	if (dbg) ret.out("replace3 returning");
	return ret ;
}


const OrdinalImpl& FiniteFuncNormalElement::replace2( int index1,
	const Ordinal& nval1, int index2, const Ordinal& nval2) const 
{
	const bool dbg = false ;
	if (dbg) outStream() << "rp2(" << index1 << ", " << nval1.normalForm()
		<< ", " << index2 << ", " << nval2.normalForm() << ")\n" ;
	assert(index2 > index1) ;
	assert((index1 < size) && (index2 < size));
	assert((index1 >= 0) && (index2 >= 0));
	int newSize = size  ;
	int ix = 0 ;
	if (index1 == 0 && nval1.isZero()) {
		newSize -- ;
		ix = 1 ;
		while (ix<size) {
			if (ix == index2) {
				if (!nval2.isZero()) break ;
			} else if (!funcParameters[ix]->isZero()) break ;
			ix++; newSize--;
		}
	}
	if (dbg) outStream() << "newSize =  " << newSize << "\n" ;
	if (!newSize) return createVirtualOrdImpl(NULL);
	
	const Ordinal** newParameters = new
		const Ordinal * [newSize+1] ;
	for (int i = 0 ; i < newSize ; i++) {
		int origIx = i + ix ;
		if (origIx == index1) newParameters[i] = &nval1 ;
		else if (origIx == index2) newParameters[i] = &nval2 ;
		else newParameters[i] = funcParameters[origIx] ;
	}
	newParameters[newSize] = 0 ;
	if (dbg) for (int i = 0 ; i < newSize ; i++)
		outStream() << "np2[" << i << "] = " <<
		newParameters[i]->normalForm() << "\n" ;
	
	
	
	return createVirtualOrdImpl(newParameters);
	

}

int FiniteFuncNormalElement::leastNzIndex() const
{
	if (!size || !funcParameters) return
		FiniteFuncOrdinal::maxIndexPosUndefined ;
	int i = size -1 ;
	while(i > -1) if (!funcParameters[i]->isZero()) break ;
	else i--;
	if (i < 0) return FiniteFuncOrdinal::maxIndexPosUndefined ;
	return i ;
}

const OrdinalImpl* FiniteFuncNormalElement::limitOrdCom(const OrdinalImpl & ord)
	const 
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
	

	if (dbg) outStream() << "FiniteFunc entering for " <<
		normalForm() << ".limitOrd(" << ord.normalForm() << ")\n" ;

	
	
	int subIndex = leastNzIndex() ;
	if (subIndex < 0) return NULL ;
	assert((subIndex < size) );
	const OrdinalImpl& subOrd = (funcParameters[subIndex])->getImpl() ;
	if (subOrd.isOne()) {
		int nxtLeastIndex = subIndex - 1 ;
		for (; nxtLeastIndex >= 0 ; nxtLeastIndex--)
			if (!funcParameters[nxtLeastIndex]->isZero()) break ;
		if(nxtLeastIndex >=0) {
			const Ordinal& nxtLeastOrd = *funcParameters[nxtLeastIndex] ;
			assert(nxtLeastOrd.limitType().compare(ord.maxLimitType())>0);
			const Ordinal& clearOne = *new Ordinal(replace1(subIndex,
					Ordinal::zero).limPlus_1());
			dbg = true ;
			if (dbg) clearOne.out("clearOne");
			return &(replace2(nxtLeastIndex,* new Ordinal(ord),nxtLeastIndex+1,
				clearOne));
		}
	}
	assert(subOrd.limitType().compare(ord.maxLimitType())>0);
	return &(replace1(subIndex,* new Ordinal(subOrd.limitOrd(ord))));

}

const OrdinalImpl& FiniteFuncNormalElement::limitOrd(const OrdinalImpl & ord)
const
{
	const OrdinalImpl * comRet = limitOrdCom(ord);
	assert(comRet);
	return *comRet ;
}


static const OrdinalImpl& returning1(bool dbg, const char *id,
	const OrdinalImpl& r,
	const Int& n, const FiniteFuncNormalElement& elt)
{
	const OrdinalImpl * ret = &r ;
	
	if (!dbg) {
		
		return *ret ;
	}
	outDbgStream() << "FiniteFunc -le limit returning at " << id << ", val = "
		<< ret->normalForm() << ", " << n << " limit of " << elt.normalForm()
			<< "\n" ;
	return *ret;
}


#define RETURN1(id,x) return returning1(dbg, id, addFactorPart(x), n, *this)
#define RETURN1X(id,x) return returning1(dbg, id, x, n, *this)



const OrdinalImpl& FiniteFuncNormalElement::limitElement(Int n) const 
{
	assert(n>0);
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
	
	if (dbg) outStream() << "Entering FiniteFunc:: " <<
		normalForm() << ".limitElement(" << n << ") ff\n" ;
	bool inputCheck = true ;
	if (inputCheck) {
		assert(size>1);
		replace1(size-1,*(funcParameters[size-1])) ;
	}

	if (codeLevel == cantorCodeLevel) 
		RETURN1("AA", CantorNormalElement::limitElement(n));
	assert(codeLevel >= finiteFuncCodeLevel);
	return limitElementCom(n);
}

const OrdinalImpl& FiniteFuncNormalElement::limitElementCom(Int n)const
{
	assert(n>0);
	assert(size > 1) ;
	assert(funcParameters[0]);
	
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
	

	int leastNz = size-1  ;
	while ((leastNz >= 0) &&
		funcParameters[leastNz]->isZero()) leastNz--;
	assert(leastNz >= 0);

	
	const Ordinal& leastNzOrd = *(funcParameters[leastNz]) ;

	if (dbg) outStream() << "leastNz = " << leastNz << ", leastNzOrd = " <<
			leastNzOrd.normalForm() <<  "\n" ;
	if (leastNzOrd.isLimit())  {
		const Ordinal & rep = * new Ordinal(
			leastNzOrd.limitElement(n).limPlus_1());
		RETURN1("A",replace1(leastNz,rep));
	}
	assert(leastNzOrd.hasFiniteTerm()) ;
	const Ordinal & leastNzOrdMo =
		* new Ordinal(leastNzOrd.getImpl().subtract(1));
	
	if (leastNz < (size -1)) {
		const OrdinalImpl * base = &(replace2(leastNz,leastNzOrdMo,
			leastNz+1,Ordinal::one));
		if (dbg) base->out("base");
		assert((leastNz+1) < size);
		for (int i = 1 ; i < n ;i++) base = &(replace2(leastNz,leastNzOrdMo,
			leastNz+1, *new Ordinal(base->limPlus_1())));
		RETURN1("B",*base);
	}
	int nxtLeastNz = leastNz -1 ;
	while ((nxtLeastNz >= 0) &&
		funcParameters[nxtLeastNz]->isZero()) nxtLeastNz-- ;

	
	const OrdinalImpl * base = &(replace1(leastNz,leastNzOrdMo).limPlus_1());

	const Ordinal& nxtLeastNzOrd = *(funcParameters[nxtLeastNz]) ;
	if (nxtLeastNzOrd.isLimit()) {
		const Ordinal & rep = * new Ordinal(nxtLeastNzOrd.
			limitElement(n).limPlus_1()) ;
		base = &(replace2(
			nxtLeastNz,rep, nxtLeastNz+1, *new Ordinal(*base)
		));
		RETURN1("C",*base);
	}
	const Ordinal & nxtLeastNzOrdMo =
			* new Ordinal(nxtLeastNzOrd.getImpl().subtract(1));

	
	for (int i = 1 ; i < n ;i++) {
		base = &(replace2(nxtLeastNz,nxtLeastNzOrdMo,
			nxtLeastNz+1,* new Ordinal(base->limPlus_1())));
	}
	RETURN1("D",*base);
}


const CantorNormalElement & FiniteFuncNormalElement::addFactors(
	const CantorNormalElement& toAdd) const 
{
	assert(toAdd.codeLevel <= finiteFuncCodeLevel);
	if (codeLevel == cantorCodeLevel) return
		CantorNormalElement::addFactors(toAdd);
	return * new FiniteFuncNormalElement(funcParameters,factor+toAdd.factor);

}



void FiniteFuncNormalElement::normalFormName(string& base) const 
{
	if (codeLevel == cantorCodeLevel) return
		CantorNormalElement::normalFormName(base);
	bool useFactor = factor > 1 ;
	if (useFactor) base += "(" ;
	base += FiniteFuncOrdinalImpl::makeName(funcParameters);
	if (useFactor) {
		base += "*" ;
		base += OrdinalImpl::itoa(factor) ;
		base += ")" ;
	}


}

const char * FiniteFuncNormalElement::notBasicString =
    "$not $\\Psi$ displayable$" ;

string FiniteFuncNormalElement::notBasic()
{
    
    return notBasicString ;
}

bool FiniteFuncNormalElement::isNotBasic(string& str)
{
    return str == notBasicString ;
}


void FiniteFuncNormalElement::psiNormalForm(string& str) const
{
	bool useFactor = factor > 1 ;
	if (useFactor) str += "(" ;
    if (size == 2) {
        const Ordinal& p0 = *(funcParameters[0]) ;
        const Ordinal& p1 = *(funcParameters[1]) ;
        if ((p1.compare(psi(p0+one,zero)) >=0)|| (p0.compare(gamma0)>=0)) {
            str = notBasic();
            return ;
        } else if (p0.isFinite()) {
            str += "\\Psi( ";
            if (p0.isOne()) str += p1.psiNormalForm() ;
            else {
                const OrdinalImpl &exp = p0.getImpl().subtract(1);
                str += "\\Omega";
                if (!exp.isOne()) {
                    str += "^{" ;
                    str += exp.psiNormalForm();
                    str += "}" ;
                }
                str += " " ;
                if (!p1.isZero()) if (p1.isFinite()) str += 
                   one.addLoc(p1).psiNormalForm() ;
                else {
                    str += "(" ;
                    str += p1.psiNormalForm() ;
                    str += ")" ;
                }
            }
            str += " )" ;
        } else {
            if (p0.compare(finiteFunctional(one,zero,zero)<0)
                && (p1.compare(psi(p0+Ordinal::one,zero))<0)) {
                str+= "\\Psi( \\Omega^{" ;
                str += p0.psiNormalForm();
                str += "}";
                if (!p1.isZero()) if (p1.isFinite()) str += 
                   one.addLoc(p1).psiNormalForm() ;
                else {
                    str += "(" ;
                    str += p1.psiNormalForm() ;
                    str += ")" ;
                }
                str += ")" ;
            } else {
                str = notBasic();
                return ;
            }
        }
    } else { 
        
        const Ordinal ** params = new const Ordinal * [size+2] ;
        params[size+1]=NULL ;
        params[0]=&Ordinal::one;
        for (int i =1; i < size+1; i++) params[i] = &Ordinal::zero;
        if (createVirtualOrdImpl(params).compare(*(funcParameters[0]))>0) {
            params[size] = NULL ;
            bool badFlag = false ;
            for (int i = 0 ; i < size -1 ;i++) {
                if (!funcParameters[i+1]->isFinite()) {
                    
                    params[i]=funcParameters[i] ;
                    if (finiteFunctional(params).compare(*(funcParameters[i+1]))
                        <=0) {
                          badFlag = true ;
                          break ;
                    }

                }
                params[i]=funcParameters[i] ;
            }
            if (badFlag) {
                str = notBasic();
                return ;
            } else {
                bool paramsZero = true ;
                for (int i = 1 ; i < size ; i++)
                    if (!funcParameters[i]->isZero()) {
                    paramsZero = false ;
                    break ;
                }
                str+= "\\Psi( \\Omega^{" ;
                if (!paramsZero) str += "(" ;
                for (int i = 0 ; i < size-1; i++) { 
                    const Ordinal &f = *(funcParameters[i]) ;
                    int exp = size - i - 2  ;
                    bool fz = f.isZero() ;
                    if ((i>0) &&  !fz) str += " + " ;
                    if (!fz) {
                        if (exp > 0) str += "\\Omega" ;
                        if (exp > 1) {
                            str += "^" ;
                            str += OrdinalImpl::itoa(exp) ;
                        }
                        str+= " " ;
                        
                        if (!f.isOne() || (exp == 0)) str += f.psiNormalForm();

                    }
                }
                if (!paramsZero) str += ")" ;
                str += "}" ;
                const Ordinal &pe = *(funcParameters[size-1]) ;
                if (!pe.isZero()) if (pe.isFinite()) str +=
                    (pe + Ordinal::one).psiNormalForm() ;
                else str += pe.psiNormalForm() ;
                str += ")" ;

            }
            delete params ;
            params = NULL ;
                
        }
    }
	if (useFactor) {
		str += " " ;
		str += OrdinalImpl::itoa(factor) ;
		str += ")" ;
	}
    return ;
}

void FiniteFuncNormalElement::texNormalForm(string& str) const 
{
	if (codeLevel == cantorCodeLevel) {
		CantorNormalElement::texNormalForm(str);
		return ;
	}
	bool useFactor = factor > 1 ;
	if (useFactor) str += "(" ;
	str += FiniteFuncOrdinalImpl::makeTexName(funcParameters);
	if (useFactor) {
		str += " " ;
		str += OrdinalImpl::itoa(factor) ;
		str += ")" ;
	}

}

static int returning3(bool dbg, const char * id, int v,
	const FiniteFuncNormalElement &th, const OrdinalImpl& ord)
{
	if (!dbg) return v ;
	outDbgStream() << "FiniteFuncn -b compareOrd at " << id << ", returning "
        << v << ", cmp(" << th.normalForm() << "::\n" << ord.normalForm()
        << ")\n";
	return v ;
}

#define RETURN3(id,x) return returning3(dbg,id,x,*this,ord)




static int returning(bool dbg, const char *id, int r, 
	const FiniteFuncNormalElement& op1, const CantorNormalElement &op2,
	bool ignoreFactor) 

{
	if (!dbg) return r ;
	outDbgStream() << "FiniteFunc elt compare returning at " << id <<
        ", val = "  << r <<
		", cmp(" << op1.normalForm() << " ::\n" << op2.normalForm() <<
		"), ignf = " << ignoreFactor <<  "\n" ;
	return r;
}

#define RETURN2(id,x) return returning(dbg, id, x, *this, trm,  ignoreFactor)

int FiniteFuncNormalElement::compareFiniteParams(const Embeddings& context,
            const Embeddings& paramContext,
            const FiniteFuncNormalElement& trm) const
{
	int ignoreFactor = -1 ; 
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
	
	if (dbg) outStream() << "compareFiniteParams{\n" ;
	int sizeDiff = size - trm.size ;
	if (sizeDiff) RETURN2("C+",sizeDiff);
	const Ordinal* const * const trmParameters = trm.funcParameters ;
	for (int i = 0 ; i < size ; i++) {
		if (dbg) outStream() << funcParameters[i]->normalForm() << " : " <<
			trmParameters[i]->normalForm() << ", i = " << i << " fcp:trmP\n" ;
		int diff = funcParameters[i]->getImpl().compare(context,paramContext,
            trmParameters[i]->getImpl());
		if (diff) RETURN2("C",diff);

	}
	RETURN2("DP",0);

}

int FiniteFuncNormalElement::compare(const CantorNormalElement& trm,
	bool ignoreFactor) const
{
    return (compare(Embeddings::embedNone,Embeddings::embedNone, trm,
        ignoreFactor));
}

int FiniteFuncNormalElement::compare(const Embeddings& context,
    const Embeddings& paramContext, const CantorNormalElement& trm,
	bool ignoreFactor) const 
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
	
	if (dbg) {
		outDbgStream() << "FiniteFunc{ elt compare(" <<  normalForm() << ", " 
			<< trm.normalForm() << ")\n" ;
	}
    assert(codeLevel == finiteFuncCodeLevel);
	if (codeLevel < finiteFuncCodeLevel)
		RETURN2("A",CantorNormalElement::compare(context,paramContext,
            trm, ignoreFactor));
	if (trm.codeLevel > finiteFuncCodeLevel) RETURN2("A1", -trm.compare(
        paramContext, context, *this));

	assert(trm.codeLevel <= finiteFuncCodeLevel) ;

	if (trm.codeLevel < finiteFuncCodeLevel) {
		assert(trm.codeLevel == cantorCodeLevel);
		const CantorNormalElement *expFirstTerm = trm.exponent.getFirstTerm();
		if (!expFirstTerm) RETURN2("A1A",1);
		int diff = compare(context,paramContext,*expFirstTerm,true) ;
		if (diff) RETURN2("A2", diff) ;
		if (dbg) outStream() << expFirstTerm->normalForm() << ", trm.exp = "
			<< trm.exponent.normalForm() << "\n" ;
        
		RETURN2("A3", -1) ;

	}
	assert(trm.codeLevel == finiteFuncCodeLevel);
    int diff = parameterCompare(context,paramContext,trm);
    if (diff) RETURN2("A5",diff);
	const FiniteFuncNormalElement& ftrm = (const FiniteFuncNormalElement&) trm;
    
    
	
	
	diff = compareFiniteParams(context,paramContext,ftrm);
	if (diff) RETURN2("R",diff);
	int factDiff = 0 ;
	if (!ignoreFactor) factDiff = cmp(factor,ftrm.factor) ;
	RETURN2("S", factDiff) ;

}

const OrdinalImpl& FiniteFuncNormalElement::doToPower(
			const CantorNormalElement& base, const CantorNormalElement&  expon)
{
	
	
	static const char * where = "FiniteFuncNormalElement::doToPower" ;
	bool baseFiniteFunc = base.codeLevel >= finiteFuncCodeLevel ;
	bool exponFiniteFunc = expon.codeLevel >= finiteFuncCodeLevel ;
	assert(baseFiniteFunc || exponFiniteFunc) ;


	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::expon) ;
	if (dbg) outDbgStream() << where << ", base = " <<
		base.normalForm() << ", expon = " << expon.normalForm() << "\n" ;
	
	if (!expon.expTerm() && (expon.factor == 1) && (base.compare(expon) < 0)) {
		if (dbg) outStream() <<  where << " returning at A " <<
			expon.termToOrdinal().normalForm() << "\n" ;
		return expon.termToOrdinal();
	}
	
	const OrdinalImpl * p1 = 0 ;
	const OrdinalImpl * p2 = 0 ;
	if (baseFiniteFunc) {
		p1 = &(base.getOrdinalCopy(1));
		
	} else p1 = &(base.exponent);
	p2 = &(expon.termToOrdinal()) ;
	const OrdinalImpl& newExp = p1->multLoc(*p2);
	if (newExp.oneTerm()) {
		const CantorNormalElement* elt = newExp.getFirstTerm();
		if ((elt->codeLevel >= finiteFuncCodeLevel) && (elt->factor == 1)) {
			if (dbg) outStream() << where << " returning at B " <<
				elt->termToOrdinal().normalForm() << "\n" ;
			return elt->termToOrdinal() ;
		}
	}
	if (dbg) outStream() << where << " returning at C " <<
		createCantorNormalElement(newExp).termToOrdinal().normalForm() << "\n" ;
	return createCantorNormalElement(newExp).termToOrdinal();

}



const OrdinalImpl& FiniteFuncNormalElement::toPower(
	const CantorNormalElement& elt) const
{
	if ((codeLevel < finiteFuncCodeLevel) && 
		(elt.codeLevel < finiteFuncCodeLevel))
	return CantorNormalElement::toPower(elt);
	return doToPower(*this,elt);

}


const OrdinalImpl& FiniteFuncNormalElement::powerOf(
	const CantorNormalElement& elt) const 
{
	if ((codeLevel < finiteFuncCodeLevel) && 
		(elt.codeLevel < finiteFuncCodeLevel))
		return CantorNormalElement::powerOf(elt);
	return doToPower(elt,*this);

}


const OrdinalImpl& FiniteFuncNormalElement::limitInfo(
	CantorNormalElement::LimitTypeInfo& typeInfo) const 
{
	assert(!theLimitType) ;
	assert(size > 0) ;
	typeInfo = unknownLimit;
	const OrdinalImpl * type = NULL ;
	if (size==1) {
		type = &(CantorNormalElement::limitInfo(typeInfo));
		assert(typeInfo != unknownLimit);
	} else {
		typeInfo = paramSucc ;
		type = & integerLimitType ;
		bool leastOneFlag = false ;	
		for (int i = size -1 ; i > -1 ; i--) {
			if (funcParameters[i]->isZero()) continue ;
			if (funcParameters[i]->isOne()) {
				if (!leastOneFlag) {
					leastOneFlag = true ;
					continue ;
				}
			}
			const OrdinalImpl& cur = funcParameters[i]->limitType() ;
			if (type->compare(cur)<0) {
				type =  &cur ;
			}
			if (funcParameters[i]->isLimit()) typeInfo =  paramLimit ;
			break ;
		}
	}
	assert (type);
	assert(typeInfo != unknownLimit);
	FiniteFuncNormalElement * setThis = (FiniteFuncNormalElement *)this ;
	setThis->theLimitType = type ;
	setThis->theLimitTypeInfo = typeInfo ;
	return *theLimitType ;

}

const OrdinalImpl& FiniteFuncNormalElement::maxLimitType() const
{
    return maxLimitType(Ordinal::zero);

}

const OrdinalImpl& FiniteFuncNormalElement::maxLimitType(const Ordinal&embIx)
    const
{

	if (embIx.isZero()) if (theMaxLimitType) return *theMaxLimitType ;
	const OrdinalImpl * ret = & integerLimitType ;
	const OrdinalImpl& maxParamMaxLimit = maxParameter.maxLimitType(embIx);
	if (ret->compare(maxParamMaxLimit)< 0) ret = &maxParamMaxLimit;

    if (embIx.isZero()) {
	    ((FiniteFuncNormalElement *)this)->theMaxLimitType = ret;
	    return *theMaxLimitType ;
    }
    ret = &(AdmisNormalElement::boundedLimitType( embIx,*ret));

    return *ret ;
}


const OrdinalImpl& FiniteFuncNormalElement::limitType() const
{
	if (theLimitType) return *theLimitType ;
	LimitTypeInfo typeInfo;
	return limitInfo(typeInfo) ;
}


const NormalFormTerm&  FiniteFuncOrdinalImpl::createTerms(
	const Ordinal* const * const params)
{
	int size = 0 ;
	for (size=0 ;params[size] ; size++) ;
	assert(size) ;
	if (size == 1) return *NormalFormTerm::create(params[0]->getImpl());
	const FiniteFuncNormalElement& elt = *new FiniteFuncNormalElement( params);
	return * new NormalFormTerm(elt) ;
}



string  FiniteFuncOrdinalImpl::makeName(const Ordinal* const * const params)  
{
	int count = 0 ;
	for (;params[count];count++) ;
	assert(count > 0);
	string base ;
	if (count < 4) {
		const OrdinalImpl& a = (count < 3) ? zero :
			(params[count-3])->getImpl();

		const OrdinalImpl& alpha = (count < 2) ? zero :
			(params[count-2])->getImpl();
		const OrdinalImpl& beta = (params[count-1])->getImpl();
        
		
		if ((alpha.compare(OrdinalImpl::one)==0) && a.isZero()) {
			base = "epsilon( " ;
			
			base += beta.normalForm();
			base += ")" ;
			return base ;
		}
		
		if (beta.isZero() && alpha.isZero()) {
		
			base = "gamma( " ;
		    
            if (a.isFinite()) base += a.subtract(1).normalForm();
            else base += a.normalForm();
			base += " )" ;
			return base ;

		}
		
	}
	base = "psi( " ;
	for (int i = 0 ; i < count; i++) {
		if (i) base += ", " ;
		base += params[i]->normalForm() ;
	}
	base += " )" ;
	return base ;

}

string  FiniteFuncOrdinalImpl::makeTexName(const Ordinal* const * const params)
{
	int count = 0 ;
	for (;params[count];count++) ;
	assert(count > 0);
	string base ;
	if (count < 4) {
		const OrdinalImpl& a = (count < 3) ? zero :
			(params[count-3])->getImpl();

		const OrdinalImpl& alpha = (count < 2) ? zero :
			(params[count-2])->getImpl();
		const OrdinalImpl& beta = (params[count-1])->getImpl();
		if ((alpha.compare(OrdinalImpl::one)==0) && a.isZero()) {
			base = "\\varepsilon_{" ;
			base += beta.texNormalForm();
			base += "}" ;
			return base ;
		}
		if (beta.isZero() && (a.compare(OrdinalImpl::one)==0)) {
		
		
			base = "\\Gamma_{" ;
		    base += alpha.texNormalForm();
            
			
			base += "}" ;
			return base ;

		}
		
		
	}
	base = "\\varphi( " ;
	for (int i = 0 ; i < count; i++) {
		if (i) base += ", " ;
		base += params[i]->texNormalForm() ;
	}
	base += ")" ;
	return base ;

}

static void outTabVebFunc()
{
	ofstream out("tabvecFunc.tex");
	out << "\\begin{table}\\centering\n";
	out << "\\begin{tabular}{|l|c|}\\hline\n" ;
	out << "{\\bf \\Cpp{} code }&{\\bf Ordinal}\\\\\\hline\n" ;
	const Ordinal * const  params[] = {&Ordinal::one,&Ordinal::zero,0};
	const FiniteFuncOrdinal eps0(params);
	out << "{\\tt const Ordinal * const  params[] =}& \\\\\n" ;
	out << "{\\tt \\{\\&Ordinal::one,\\&Ordinal::zero,0\\}; } & \\\\ \n" ;
	out << "{\\tt const FiniteFuncOrdinal eps0(params);}&$" <<
		eps0.texNormalForm() << "$\\\\ \\hline \n" ;
	
	const Ordinal & eps0_alt = psi(1,0);
	out << "{\\tt Ordinal eps0\\_alt = psi(1,0);} & $" <<
		eps0_alt.texNormalForm() << "$\\\\ \\hline \n" ;
	const FiniteFuncOrdinal eps0_alt2(1,0);
	out << "{\\tt const FiniteFuncOrdinal eps0\\_alt2(1,0);} & $" <<
		eps0_alt2.texNormalForm() << "$\\\\ \\hline \n" ;
	const FiniteFuncOrdinal gamma0(1,0,0);
	out << "{\\tt const FiniteFuncOrdinal gamma0(1,0,0);} & $" <<
		gamma0.texNormalForm() << "$ \\\\ \\hline\n" ;
	const FiniteFuncOrdinal gammaOmega(omega,0,0);
	out << "{\\tt const FiniteFuncOrdinal gammaOmega(omega,0,0);} & $" <<
		gammaOmega.texNormalForm() << "$ \\\\ \\hline\n" ;
	const FiniteFuncOrdinal gammax(gammaOmega,gamma0,omega);
	out <<
	"{\\tt const FiniteFuncOrdinal gammax(gammaOmega,gamma0,omega);} & $" <<
		gammax.texNormalForm() << "$ \\\\ \\hline\n" ;
	const FiniteFuncOrdinal big(1,0,0,0);
	out << "{\\tt const FiniteFuncOrdinal big(1,0.0,0);} & $" <<
		big.texNormalForm() << "$ \\\\ \\hline\n" ;



	out << "\\hline\\end{tabular}\n" ;
	out << "\\caption{{\\tt FiniteFuncOrdinal} \\Cpp{} code examples}\n";
    out << "\\index{{\\tt FiniteFuncOrdinal} C{\\tt ++} examples}\n" ;
    out << "\\index{examples {\\tt  FiniteFuncOrdinal} C{\\tt ++} code}\n" ;
	out << "\\label{TabVebFunc}\n" ;
	out << "\\end{table}\n\n" ;
}

static bool fixedPointRetSub(const char * lab, bool ret, bool dbg)
{
    if (!dbg) return ret ;
     outStream() << "FiniteFuncOrdinal::fixedPoint returning at " << lab
        << " val "<<ret<<"\n";
     return ret ;
}

#define fixedPointRet(lab,ret) return fixedPointRetSub(lab,ret,dbg)

bool FiniteFuncOrdinal::fixedPoint(int ix, const Ordinal* const * params)
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::mult,0);
	if (dbg) {
        outStream() << "fixedPoint(" << ix ;
        for (const Ordinal* const * p= params; *p; p++) 
            outStream() << ", " << (*p)->normalForm() ;
            outStream() << ")\n" ;
    }
	if (ix < 0 || !params) fixedPointRet("A",false) ;
	int paramsPcl = params[ix]->getImpl().psuedoCodeLevel() ;
	if (paramsPcl <= CantorNormalElement::cantorCodeLevel)
        fixedPointRet("B", false) ;
	if (paramsPcl > FiniteFuncNormalElement::finiteFuncCodeLevel)
            fixedPointRet("C",true) ;
    
	int size = 0 ;
	for (;params[size];size++);
    assert(size>0);
    if (ix == 0) size++;
	const Ordinal** nParams = new const Ordinal *[size+1] ;
	nParams[size]=0;
	assert(ix<size);
	for (int i = 0 ; i < ix;i++) nParams[i] = params[i] ;
	for (int i = ix ; i < size ; i++) {
        if ((i>ix) && params[i]) assert(params[i]->isZero());
        nParams[i] = &zero ;
    }
    if (ix ==0) nParams[ix] = &one ; 
	FiniteFuncOrdinal base(nParams) ;
	bool ret =  base.compare(*(params[ix])) < 0;
	if (dbg && ret) {
		outStream() << "FixedPoint - base = " << base.normalForm() <<
            ", params[" << ix << "] = " << params[ix]->normalForm() << "\n" ;
	}
	fixedPointRet("E",ret) ;

}

static void finFuncExamp()
{
	string tname = "tabfiniteFuncCppExamp" ;
	string fname = tname;
	fname += ".tex" ;
	ofstream outStream(fname.c_str());
	OutStream::streamManager.push(outStream);
#define CPP_EXAMP(str) outStream << "{\\tt " << #str << "}&$" << \
	str.texNormalForm()  << "$\\\\  \n"
	
	outStream << "\\begin{table}\\centering\n" ;
	outStream << "\\begin{tabular}{|l|l|}\\hline\n" ;
	
	outStream << "{\\bf \\Cpp{} code}&{\\bf Ordinal}\\\\ \\hline\n" ;
	CPP_EXAMP(psi(zero,omega));
	CPP_EXAMP(psi(one,zero));
	CPP_EXAMP(psi(one,one));
	CPP_EXAMP(psi(eps0,one));
	CPP_EXAMP(psi(one,Ordinal::two));
	CPP_EXAMP(finiteFunctional(one,zero,zero));
	CPP_EXAMP(finiteFunctional(one,zero,one));
	CPP_EXAMP(finiteFunctional(one,zero,Ordinal::two));
	CPP_EXAMP(finiteFunctional(one,Ordinal::two,zero));
	CPP_EXAMP(finiteFunctional(one,zero,omega));
	CPP_EXAMP(finiteFunctional(one,eps0,omega));
	CPP_EXAMP(finiteFunctional(one,zero,zero,zero));
	outStream << "{\\tt finiteFunctional(createParameters(}&\\\\ \n";
	outStream << "{\\tt \\verb`&one,&zero,&zero,&zero,&zero))`}&$" <<
		finiteFunctional(createParameters(&one,&zero,&zero,&zero,&zero)).
		texNormalForm() << "$\\\\ \n" ;

	outStream << "\\hline\n" ;
	outStream << "\\end{tabular}\n" ;
	outStream<<"\\caption{\\Indextt{finiteFunctional} \\Cpp{} code examples}\n";
    outStream << "\\mindex{{\\tt finiteFunctional} C{\\tt ++} examples}\n" ;
    outStream << "\\mindex{examples {\\tt finiteFunctional} C{\\tt ++} code}\n" ;
	outStream << "\\label{TabFiniteFuncOrdinalCppExamp}\n" ;
	outStream << "\\end{table}\n\n" ;

	OutStream::streamManager.pop();
}


void FiniteFuncOrdinal::texDocument()
{
	finFuncExamp();

	outTabVebFunc();

	const Int indicies[] = {1,2,4,-1};


	FiniteFuncOrdinal gamma0(1,0,0);
	const Ordinal ordAry[] = {
		psi(1,0),
		psi(2,0),
		psi(omega,omega),
		
		FiniteFuncOrdinal(1,0,0),
		FiniteFuncOrdinal(1,1,0),
		FiniteFuncOrdinal(1,1,1),
		
		FiniteFuncOrdinal(2,0,0),
		
		FiniteFuncOrdinal(3,0,0),
		FiniteFuncOrdinal(omega,0),
		FiniteFuncOrdinal(omega,1),
		FiniteFuncOrdinal(omega,0,0),
		FiniteFuncOrdinal(omega,0,1),
		FiniteFuncOrdinal(omega,1,0),
		FiniteFuncOrdinal(omega,1,1),
		FiniteFuncOrdinal(1,0,0,0),
		FiniteFuncOrdinal(2,0,0,0),
		FiniteFuncOrdinal(2,0,2,1),
		FiniteFuncOrdinal(omega,0,0,0),
		
		FiniteFuncOrdinal(2,psi(2,0),psi(1,0)),
		
		FiniteFuncOrdinal(3,psi(2,0),psi(1,0)),
		FiniteFuncOrdinal(3,finiteFunctional(2,0,0,0),omega),
		FiniteFuncOrdinal(3,finiteFunctional(2,0,0,0),psi(1,0)),
		FiniteFuncOrdinal(3,finiteFunctional(2,0,0,0),psi(1,1)),
		
		
		
		
		
		
		FiniteFuncOrdinal(psi(2,0),gamma0,eps0),
		zero
	};
	limitElementTable(ordAry,indicies,"FiniteFuncOrdinal");

	


	

	
    

	const Ordinal en4 = psi(omega^omega,omega+3);
	const FiniteFuncOrdinal enn(3,eps0,en4);

	const Ordinal& ea1 = eps0+2;
	const Ordinal& ea2 = psi(1,1)+eps0+2 ;
	const Ordinal& ea3 = (eps0^eps0) ;

	
	const Ordinal * const am[] = {&ea1,&ea2,&ea3,
		
		&en4,
		&enn,
		NULL};

	arithExamp(am,"FiniteFuncOrdinal",multType);
	
	const Ordinal& e1 = eps0+Ordinal::two ;
	const Ordinal& e2 = psi(Ordinal::one,Ordinal::one)+eps0 ;
	const Ordinal& e3 = (eps0^eps0)+3 ;


	const Ordinal * const  bm[] = {&e1, &e2, &e3,
		&en4,
		
		&enn,
		NULL};

	arithExamp(bm,"FiniteFuncOrdinal",powerType);

	


}




