(* 	$Id: Identity.Mod,v 1.1 2003/04/16 10:32:35 mva Exp $	 *)
MODULE OOC:Scanner:Identity;
(*  Passes string representation of scanned symbols to output channel.
    Copyright (C) 2000  Michael van Acken

    This file is part of OOC.

    OOC is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.  

    OOC is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details. 

    You should have received a copy of the GNU General Public License
    along with OOC. If not, write to the Free Software Foundation, 59
    Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

(** This is the most simple builder for a scanner: it takes the string
representation of the symbols, and writes it unchanged to the
designated output channel.  The output produced this way matches the
input data character to character, even if the scanner reports illegal
or malformed symbols.  Note that the scanner also passes whitespace to
the builder.  *)

IMPORT
  Channel, OOC:Scanner:Symbol, OOC:Scanner:InputBuffer, 
  B := OOC:Scanner:Builder;

TYPE
  Builder* = POINTER TO BuilderDesc;
  BuilderDesc = RECORD
    (B.BuilderDesc)
    writer: Channel.Writer;
  END;
  

PROCEDURE Init* (b: Builder; buffer: InputBuffer.Buffer; ch: Channel.Channel);
  BEGIN
    B.Init (b, buffer);
    b. writer := ch. NewWriter ()
  END Init;

PROCEDURE New* (buffer: InputBuffer.Buffer; ch: Channel.Channel): Builder;
  VAR
    b: Builder;
  BEGIN
    NEW (b);
    Init (b, buffer, ch);
    RETURN b
  END New;

PROCEDURE (b: Builder) AddSymbol* (id: Symbol.Id;
                                   cstart, cend: B.Pos;
                                   line, column: LONGINT);
  BEGIN
    b. writer. WriteBytes (b. inputBuffer. chars^, cstart, cend-cstart)
  END AddSymbol;

END OOC:Scanner:Identity.
